import{s as zl,n as Hl,o as Ll}from"../chunks/scheduler.39a43cde.js";import{S as Dl,i as Kl,g as w,s as n,r as J,A as Pl,h as d,f as t,c as a,j as xl,u as M,x as b,k as vl,y as Ol,a as e,v as T,d as i,t as p,w as m}from"../chunks/index.23ec2204.js";import{D as ls,C as U}from"../chunks/DocNotebookDropdown.7c3158f8.js";import{H as j,E as ss}from"../chunks/getInferenceSnippets.30223549.js";function ts(Vl){let y,K,L,P,c,O,I,ll,u,El='<em>작성자: <a href="https://github.com/MartinEls" rel="nofollow">Martin Elstner</a> , 번역: <a href="https://github.com/whybe-choi" rel="nofollow">최용빈</a></em>',sl,o,gl='허깅페이스의 데이터셋은 파켓(parquet) 파일에 의존합니다. 우리는 빠른 인메모리 데이터베이스 시스템인 <a href="https://huggingface.co/docs/hub/en/datasets-duckdb" rel="nofollow">DuckDB를 사용하여 이 파일들과 상호작용</a>할 수 있습니다. DuckDB의 기능 중 하나는 <a href="https://duckdb.org/docs/extensions/vss.html" rel="nofollow">벡터 유사도 검색</a>으로, 인덱스 유무에 관계없이 사용할 수 있습니다.',tl,r,el,h,nl,f,al,C,Rl="먼저, 검색할 데이터셋에 대한 임베딩을 생성해야 합니다. 우리는 <code>sentence-transformers</code> 라이브러리를 사용하여 데이터셋에 대한 임베딩을 생성할 것입니다.",Jl,Z,Ml,B,$l='이제 허브에서 <a href="https://huggingface.co/datasets/ai-blueprint/fineweb-bbc-news" rel="nofollow">ai-blueprint/fineweb-bbc-news</a> 데이터셋을 로드해 보겠습니다.',Tl,W,il,_,Al="이제 데이터셋에 대한 임베딩을 생성할 수 있습니다. 일반적으로 정밀도(precision)를 잃지 않기 위해 데이터를 더 작은 배치로 나누고 싶을 수 있지만, 이 예제에서는 데이터셋의 전체 텍스트에 대한 임베딩만 생성하겠습니다.",pl,k,ml,V,Gl="이제 임베딩이 포함된 데이터셋을 허브에 다시 업로드할 수 있습니다.",wl,E,dl,g,bl,R,Yl="이제 <code>duckdb</code>를 사용하여 데이터셋에서 벡터 검색을 수행할 수 있습니다. 이때 인덱스를 사용하거나 사용하지 않을 수 있습니다. 인덱스를 <strong>활용하지 않고</strong> 검색하는 것은 더 느리지만 더 정확하고, 인덱스를 <strong>활용하여</strong> 검색하는 것은 더 빠르지만 덜 정확합니다.",yl,$,Ul,A,Nl="인덱스를 활용하지 않고 검색하려면 <code>duckdb</code> 라이브러리를 사용하여 데이터셋에 연결하고 벡터 검색을 수행할 수 있습니다. 이는 느린 작업지만 일반적으로 약 10만 행까지의 작은 데이터셋에서는 충분히 빠르게 동작합니다. 즉, 우리가 사용하는 데이터셋에 대해서 쿼리를 날리는 것은 다소 느릴 것입니다.",jl,G,cl,Y,Il,N,Xl="이 접근법은 데이터셋의 로컬 복사본을 생성하고 이를 사용하여 인덱스를 생성합니다. 약간의 경미한 오버헤드가 있지만 한번 생성한 후에는 검색 속도가 상당히 향상될 것입니다.",ul,X,ol,q,ql="이제 인덱스를 사용하여 벡터 검색을 수행할 수 있으며, 결과는 즉시 반환됩니다.",rl,F,hl,Q,Fl="이 쿼리는 응답시간을 30초에서 1초 미만으로 줄이며, 무거운 벡터 검색 엔진을 배포할 필요가 없고 저장소는 허브에서 처리됩니다.",fl,S,Cl,x,Ql="우리는 <code>duckbd</code>를 사용하여 허브에서 벡터 검색을 수행하는 방법을 보았습니다. 10만 행 미만의 작은 데이터셋의 경우, 허브를 벡터 검색 벡엔드로 사용하여 인덱스 없이 벡터 검색을 수행할 수 있지만, 더 큰 데이터셋의 경우 <code>vss</code> 확장 프로그램으로 인덱스를 생성하면서 로컬 검색을 수행하고 허브를 스토리지 백엔드로 사용해야 합니다.",Zl,v,Bl,z,Sl='<li><a href="https://huggingface.co/docs/hub/en/datasets-duckdb" rel="nofollow">허깅페이스에서의 벡터 검색</a></li> <li><a href="https://duckdb.org/docs/extensions/vss.html" rel="nofollow">DuckDB를 사용한 벡터 검색 인덱싱</a></li>',Wl,H,_l,D,kl;return c=new ls({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/ko/vector_search_with_hub_as_backend.ipynb"}]}}),I=new j({props:{title:"허깅페이스 허브를 백엔드로 사용한 벡터 검색",local:"허깅페이스-허브를-백엔드로-사용한-벡터-검색",headingTag:"h1"}}),r=new j({props:{title:"의존성 설치",local:"의존성-설치",headingTag:"h2"}}),h=new U({props:{code:"IXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyUyMGR1Y2tkYiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMG1vZGVsMnZlYyUyMC1x",highlighted:"!pip install datasets duckdb sentence-transformers model2vec -q",wrap:!1}}),f=new j({props:{title:"데이터셋에 대한 임베딩 생성",local:"데이터셋에-대한-임베딩-생성",headingTag:"h2"}}),Z=new U({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzLm1vZGVscyUyMGltcG9ydCUyMFN0YXRpY0VtYmVkZGluZyUwQSUwQXN0YXRpY19lbWJlZGRpbmclMjAlM0QlMjBTdGF0aWNFbWJlZGRpbmcuZnJvbV9tb2RlbDJ2ZWMoJTIybWluaXNobGFiJTJGcG90aW9uLWJhc2UtOE0lMjIpJTBBbW9kZWwlMjAlM0QlMjBTZW50ZW5jZVRyYW5zZm9ybWVyKG1vZHVsZXMlM0QlNUJzdGF0aWNfZW1iZWRkaW5nJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">from</span> sentence_transformers.models <span class="hljs-keyword">import</span> StaticEmbedding

static_embedding = StaticEmbedding.from_model2vec(<span class="hljs-string">&quot;minishlab/potion-base-8M&quot;</span>)
model = SentenceTransformer(modules=[static_embedding])`,wrap:!1}}),W=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyYWktYmx1ZXByaW50JTJGZmluZXdlYi1iYmMtbmV3cyUyMik=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news&quot;</span>)`,wrap:!1}}),k=new U({props:{code:"ZGVmJTIwY3JlYXRlX2VtYmVkZGluZ3MoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5ncyUyMCUzRCUyMG1vZGVsLmVuY29kZShiYXRjaCU1QiUyMnRleHQlMjIlNUQlMkMlMjBjb252ZXJ0X3RvX251bXB5JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMmVtYmVkZGluZ3MlMjIlNUQlMjAlM0QlMjBlbWJlZGRpbmdzLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2glMEElMEElMEFkcyUyMCUzRCUyMGRzLm1hcChjcmVhdGVfZW1iZWRkaW5ncyUyQyUyMGJhdGNoZWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_embeddings</span>(<span class="hljs-params">batch</span>):
    embeddings = model.encode(batch[<span class="hljs-string">&quot;text&quot;</span>], convert_to_numpy=<span class="hljs-literal">True</span>)
    batch[<span class="hljs-string">&quot;embeddings&quot;</span>] = embeddings.tolist()
    <span class="hljs-keyword">return</span> batch


ds = ds.<span class="hljs-built_in">map</span>(create_embeddings, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),E=new U({props:{code:"ZHMucHVzaF90b19odWIoJTIyYWktYmx1ZXByaW50JTJGZmluZXdlYi1iYmMtbmV3cy1lbWJlZGRpbmdzJTIyKQ==",highlighted:'ds.push_to_hub(<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>)',wrap:!1}}),g=new j({props:{title:"허깅페이스 허브에서 벡터 검색",local:"허깅페이스-허브에서-벡터-검색",headingTag:"h2"}}),$=new j({props:{title:"인덱스를 활용하지 않고 검색하기",local:"인덱스를-활용하지-않고-검색하기",headingTag:"h3"}}),G=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> duckdb
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">similarity_search_without_duckdb_index</span>(<span class="hljs-params">
    query: <span class="hljs-built_in">str</span>,
    k: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
    dataset_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>,
    embedding_column: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;embeddings&quot;</span>,
</span>):
    <span class="hljs-comment"># 인덱스를 위해 사용한 모델과 동일한 모델을 사용</span>
    query_vector = model.encode(query)
    embedding_dim = model.get_sentence_embedding_dimension()

    sql = <span class="hljs-string">f&quot;&quot;&quot;
        SELECT
            *,
            array_cosine_distance(
                <span class="hljs-subst">{embedding_column}</span>::float[<span class="hljs-subst">{embedding_dim}</span>],
                <span class="hljs-subst">{query_vector.tolist()}</span>::float[<span class="hljs-subst">{embedding_dim}</span>]
            ) as distance
        FROM &#x27;hf://datasets/<span class="hljs-subst">{dataset_name}</span>/**/*.parquet&#x27;
        ORDER BY distance
        LIMIT <span class="hljs-subst">{k}</span>
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> duckdb.sql(sql).to_df()


similarity_search_without_duckdb_index(<span class="hljs-string">&quot;What is the future of AI?&quot;</span>)`,wrap:!1}}),Y=new j({props:{title:"인덱스를 활용하여 검색하기",local:"인덱스를-활용하여-검색하기",headingTag:"h3"}}),X=new U({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> duckdb


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_setup_vss</span>():
    duckdb.sql(
        query=<span class="hljs-string">&quot;&quot;&quot;
        INSTALL vss;
        LOAD vss;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_drop_table</span>(<span class="hljs-params">table_name</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        DROP TABLE IF EXISTS <span class="hljs-subst">{table_name}</span>;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_create_table</span>(<span class="hljs-params">dataset_name, table_name, embedding_column</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        CREATE TABLE <span class="hljs-subst">{table_name}</span> AS
        SELECT *, <span class="hljs-subst">{embedding_column}</span>::float[<span class="hljs-subst">{model.get_sentence_embedding_dimension()}</span>] as <span class="hljs-subst">{embedding_column}</span>_float
        FROM &#x27;hf://datasets/<span class="hljs-subst">{dataset_name}</span>/**/*.parquet&#x27;;
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_create_index</span>(<span class="hljs-params">table_name, embedding_column</span>):
    duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        CREATE INDEX my_hnsw_index ON <span class="hljs-subst">{table_name}</span> USING HNSW (<span class="hljs-subst">{embedding_column}</span>_float) WITH (metric = &#x27;cosine&#x27;);
        &quot;&quot;&quot;</span>
    )


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_index</span>(<span class="hljs-params">dataset_name, table_name, embedding_column</span>):
    _setup_vss()
    _drop_table(table_name)
    _create_table(dataset_name, table_name, embedding_column)
    _create_index(table_name, embedding_column)


create_index(
    dataset_name=<span class="hljs-string">&quot;ai-blueprint/fineweb-bbc-news-embeddings&quot;</span>,
    table_name=<span class="hljs-string">&quot;fineweb_bbc_news_embeddings&quot;</span>,
    embedding_column=<span class="hljs-string">&quot;embeddings&quot;</span>,
)`,wrap:!1}}),F=new U({props:{code:"ZGVmJTIwc2ltaWxhcml0eV9zZWFyY2hfd2l0aF9kdWNrZGJfaW5kZXgoJTBBJTIwJTIwJTIwJTIwcXVlcnklM0ElMjBzdHIlMkMlMjBrJTNBJTIwaW50JTIwJTNEJTIwNSUyQyUyMHRhYmxlX25hbWUlM0ElMjBzdHIlMjAlM0QlMjAlMjJmaW5ld2ViX2JiY19uZXdzX2VtYmVkZGluZ3MlMjIlMkMlMjBlbWJlZGRpbmdfY29sdW1uJTNBJTIwc3RyJTIwJTNEJTIwJTIyZW1iZWRkaW5ncyUyMiUwQSklM0ElMEElMjAlMjAlMjAlMjBlbWJlZGRpbmclMjAlM0QlMjBtb2RlbC5lbmNvZGUocXVlcnkpLnRvbGlzdCgpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZHVja2RiLnNxbCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRGYlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTRUxFQ1QlMjAqJTJDJTIwYXJyYXlfY29zaW5lX2Rpc3RhbmNlKCU3QmVtYmVkZGluZ19jb2x1bW4lN0RfZmxvYXQlMkMlMjAlN0JlbWJlZGRpbmclN0QlM0ElM0FGTE9BVCU1QiU3Qm1vZGVsLmdldF9zZW50ZW5jZV9lbWJlZGRpbmdfZGltZW5zaW9uKCklN0QlNUQpJTIwYXMlMjBkaXN0YW5jZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZST00lMjAlN0J0YWJsZV9uYW1lJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwT1JERVIlMjBCWSUyMGRpc3RhbmNlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTElNSVQlMjAlN0JrJTdEJTNCJTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwKS50b19kZigpJTBBJTBBJTBBc2ltaWxhcml0eV9zZWFyY2hfd2l0aF9kdWNrZGJfaW5kZXgoJTIyV2hhdCUyMGlzJTIwdGhlJTIwZnV0dXJlJTIwb2YlMjBBSSUzRiUyMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">similarity_search_with_duckdb_index</span>(<span class="hljs-params">
    query: <span class="hljs-built_in">str</span>, k: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>, table_name: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;fineweb_bbc_news_embeddings&quot;</span>, embedding_column: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;embeddings&quot;</span>
</span>):
    embedding = model.encode(query).tolist()
    <span class="hljs-keyword">return</span> duckdb.sql(
        query=<span class="hljs-string">f&quot;&quot;&quot;
        SELECT *, array_cosine_distance(<span class="hljs-subst">{embedding_column}</span>_float, <span class="hljs-subst">{embedding}</span>::FLOAT[<span class="hljs-subst">{model.get_sentence_embedding_dimension()}</span>]) as distance
        FROM <span class="hljs-subst">{table_name}</span>
        ORDER BY distance
        LIMIT <span class="hljs-subst">{k}</span>;
    &quot;&quot;&quot;</span>
    ).to_df()


similarity_search_with_duckdb_index(<span class="hljs-string">&quot;What is the future of AI?&quot;</span>)`,wrap:!1}}),S=new j({props:{title:"결론",local:"결론",headingTag:"h2"}}),v=new j({props:{title:"더 알아보기",local:"더-알아보기",headingTag:"h2"}}),H=new ss({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/ko/vector_search_with_hub_as_backend.md"}}),{c(){y=w("meta"),K=n(),L=w("p"),P=n(),J(c.$$.fragment),O=n(),J(I.$$.fragment),ll=n(),u=w("p"),u.innerHTML=El,sl=n(),o=w("p"),o.innerHTML=gl,tl=n(),J(r.$$.fragment),el=n(),J(h.$$.fragment),nl=n(),J(f.$$.fragment),al=n(),C=w("p"),C.innerHTML=Rl,Jl=n(),J(Z.$$.fragment),Ml=n(),B=w("p"),B.innerHTML=$l,Tl=n(),J(W.$$.fragment),il=n(),_=w("p"),_.textContent=Al,pl=n(),J(k.$$.fragment),ml=n(),V=w("p"),V.textContent=Gl,wl=n(),J(E.$$.fragment),dl=n(),J(g.$$.fragment),bl=n(),R=w("p"),R.innerHTML=Yl,yl=n(),J($.$$.fragment),Ul=n(),A=w("p"),A.innerHTML=Nl,jl=n(),J(G.$$.fragment),cl=n(),J(Y.$$.fragment),Il=n(),N=w("p"),N.textContent=Xl,ul=n(),J(X.$$.fragment),ol=n(),q=w("p"),q.textContent=ql,rl=n(),J(F.$$.fragment),hl=n(),Q=w("p"),Q.textContent=Fl,fl=n(),J(S.$$.fragment),Cl=n(),x=w("p"),x.innerHTML=Ql,Zl=n(),J(v.$$.fragment),Bl=n(),z=w("ul"),z.innerHTML=Sl,Wl=n(),J(H.$$.fragment),_l=n(),D=w("p"),this.h()},l(l){const s=Pl("svelte-u9bgzb",document.head);y=d(s,"META",{name:!0,content:!0}),s.forEach(t),K=a(l),L=d(l,"P",{}),xl(L).forEach(t),P=a(l),M(c.$$.fragment,l),O=a(l),M(I.$$.fragment,l),ll=a(l),u=d(l,"P",{"data-svelte-h":!0}),b(u)!=="svelte-732dc3"&&(u.innerHTML=El),sl=a(l),o=d(l,"P",{"data-svelte-h":!0}),b(o)!=="svelte-z8wvfb"&&(o.innerHTML=gl),tl=a(l),M(r.$$.fragment,l),el=a(l),M(h.$$.fragment,l),nl=a(l),M(f.$$.fragment,l),al=a(l),C=d(l,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1s2w2c"&&(C.innerHTML=Rl),Jl=a(l),M(Z.$$.fragment,l),Ml=a(l),B=d(l,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1ci2cq3"&&(B.innerHTML=$l),Tl=a(l),M(W.$$.fragment,l),il=a(l),_=d(l,"P",{"data-svelte-h":!0}),b(_)!=="svelte-1qo93gw"&&(_.textContent=Al),pl=a(l),M(k.$$.fragment,l),ml=a(l),V=d(l,"P",{"data-svelte-h":!0}),b(V)!=="svelte-1g329lk"&&(V.textContent=Gl),wl=a(l),M(E.$$.fragment,l),dl=a(l),M(g.$$.fragment,l),bl=a(l),R=d(l,"P",{"data-svelte-h":!0}),b(R)!=="svelte-80cs59"&&(R.innerHTML=Yl),yl=a(l),M($.$$.fragment,l),Ul=a(l),A=d(l,"P",{"data-svelte-h":!0}),b(A)!=="svelte-96zzjt"&&(A.innerHTML=Nl),jl=a(l),M(G.$$.fragment,l),cl=a(l),M(Y.$$.fragment,l),Il=a(l),N=d(l,"P",{"data-svelte-h":!0}),b(N)!=="svelte-kxctf7"&&(N.textContent=Xl),ul=a(l),M(X.$$.fragment,l),ol=a(l),q=d(l,"P",{"data-svelte-h":!0}),b(q)!=="svelte-80uvij"&&(q.textContent=ql),rl=a(l),M(F.$$.fragment,l),hl=a(l),Q=d(l,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-53ypoa"&&(Q.textContent=Fl),fl=a(l),M(S.$$.fragment,l),Cl=a(l),x=d(l,"P",{"data-svelte-h":!0}),b(x)!=="svelte-12niir1"&&(x.innerHTML=Ql),Zl=a(l),M(v.$$.fragment,l),Bl=a(l),z=d(l,"UL",{"data-svelte-h":!0}),b(z)!=="svelte-vdnjht"&&(z.innerHTML=Sl),Wl=a(l),M(H.$$.fragment,l),_l=a(l),D=d(l,"P",{}),xl(D).forEach(t),this.h()},h(){vl(y,"name","hf:doc:metadata"),vl(y,"content",es)},m(l,s){Ol(document.head,y),e(l,K,s),e(l,L,s),e(l,P,s),T(c,l,s),e(l,O,s),T(I,l,s),e(l,ll,s),e(l,u,s),e(l,sl,s),e(l,o,s),e(l,tl,s),T(r,l,s),e(l,el,s),T(h,l,s),e(l,nl,s),T(f,l,s),e(l,al,s),e(l,C,s),e(l,Jl,s),T(Z,l,s),e(l,Ml,s),e(l,B,s),e(l,Tl,s),T(W,l,s),e(l,il,s),e(l,_,s),e(l,pl,s),T(k,l,s),e(l,ml,s),e(l,V,s),e(l,wl,s),T(E,l,s),e(l,dl,s),T(g,l,s),e(l,bl,s),e(l,R,s),e(l,yl,s),T($,l,s),e(l,Ul,s),e(l,A,s),e(l,jl,s),T(G,l,s),e(l,cl,s),T(Y,l,s),e(l,Il,s),e(l,N,s),e(l,ul,s),T(X,l,s),e(l,ol,s),e(l,q,s),e(l,rl,s),T(F,l,s),e(l,hl,s),e(l,Q,s),e(l,fl,s),T(S,l,s),e(l,Cl,s),e(l,x,s),e(l,Zl,s),T(v,l,s),e(l,Bl,s),e(l,z,s),e(l,Wl,s),T(H,l,s),e(l,_l,s),e(l,D,s),kl=!0},p:Hl,i(l){kl||(i(c.$$.fragment,l),i(I.$$.fragment,l),i(r.$$.fragment,l),i(h.$$.fragment,l),i(f.$$.fragment,l),i(Z.$$.fragment,l),i(W.$$.fragment,l),i(k.$$.fragment,l),i(E.$$.fragment,l),i(g.$$.fragment,l),i($.$$.fragment,l),i(G.$$.fragment,l),i(Y.$$.fragment,l),i(X.$$.fragment,l),i(F.$$.fragment,l),i(S.$$.fragment,l),i(v.$$.fragment,l),i(H.$$.fragment,l),kl=!0)},o(l){p(c.$$.fragment,l),p(I.$$.fragment,l),p(r.$$.fragment,l),p(h.$$.fragment,l),p(f.$$.fragment,l),p(Z.$$.fragment,l),p(W.$$.fragment,l),p(k.$$.fragment,l),p(E.$$.fragment,l),p(g.$$.fragment,l),p($.$$.fragment,l),p(G.$$.fragment,l),p(Y.$$.fragment,l),p(X.$$.fragment,l),p(F.$$.fragment,l),p(S.$$.fragment,l),p(v.$$.fragment,l),p(H.$$.fragment,l),kl=!1},d(l){l&&(t(K),t(L),t(P),t(O),t(ll),t(u),t(sl),t(o),t(tl),t(el),t(nl),t(al),t(C),t(Jl),t(Ml),t(B),t(Tl),t(il),t(_),t(pl),t(ml),t(V),t(wl),t(dl),t(bl),t(R),t(yl),t(Ul),t(A),t(jl),t(cl),t(Il),t(N),t(ul),t(ol),t(q),t(rl),t(hl),t(Q),t(fl),t(Cl),t(x),t(Zl),t(Bl),t(z),t(Wl),t(_l),t(D)),t(y),m(c,l),m(I,l),m(r,l),m(h,l),m(f,l),m(Z,l),m(W,l),m(k,l),m(E,l),m(g,l),m($,l),m(G,l),m(Y,l),m(X,l),m(F,l),m(S,l),m(v,l),m(H,l)}}}const es='{"title":"허깅페이스 허브를 백엔드로 사용한 벡터 검색","local":"허깅페이스-허브를-백엔드로-사용한-벡터-검색","sections":[{"title":"의존성 설치","local":"의존성-설치","sections":[],"depth":2},{"title":"데이터셋에 대한 임베딩 생성","local":"데이터셋에-대한-임베딩-생성","sections":[],"depth":2},{"title":"허깅페이스 허브에서 벡터 검색","local":"허깅페이스-허브에서-벡터-검색","sections":[{"title":"인덱스를 활용하지 않고 검색하기","local":"인덱스를-활용하지-않고-검색하기","sections":[],"depth":3},{"title":"인덱스를 활용하여 검색하기","local":"인덱스를-활용하여-검색하기","sections":[],"depth":3}],"depth":2},{"title":"결론","local":"결론","sections":[],"depth":2},{"title":"더 알아보기","local":"더-알아보기","sections":[],"depth":2}],"depth":1}';function ns(Vl){return Ll(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class is extends Dl{constructor(y){super(),Kl(this,y,ns,ts,zl,{})}}export{is as component};
