import{s as ft,n as Zt,o as xt}from"../chunks/scheduler.65852ee5.js";import{S as gt,i as Vt,g as M,s as n,r as y,A as Xt,h as p,f as t,c as a,j as Bt,u as J,x as i,k as Gt,y as vt,a as e,v as U,d as j,t as T,w as o}from"../chunks/index.aa74147d.js";import{D as Wt,C as u}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as Bl,E as Nt}from"../chunks/getInferenceSnippets.d34c235c.js";function _t(qs){let w,Zl,Gl,xl,r,gl,m,Vl,c,Qs='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Xl,h,Es="评估大型语言模型（LLMs）通常是一项困难的任务：由于他们能力广泛，给它们分配的任务时通常应该根据非常泛且松散的要求来判断。例如，AI 对问题的回答可能是：",vl,b,ks="<li>不基于上下文</li> <li>重复、重复、重复</li> <li>语法错误</li> <li>过于冗长，用词过多，导致话语或书面内容过于详细和拖沓</li> <li>不连贯</li> <li>…</li>",Wl,d,Ys="这些标准的列表还有很多。即使我们有一个有限的列表，每一个标准的衡量都是困难的：“制定一个基于规则的程序来评估输出是非常具有挑战性的。传统的评估指标，基于输出和参考答案之间的相似性（例如，ROUGE、BLEU），对于这些问题也无效。”",Nl,I,Hs=`✅ 一种强大的解决方案，可以在不需要昂贵人力的前提下，以人类的方式评估输出，就是使用 LLM 作为评判者。
这种方法在 <a href="https://huggingface.co/papers/2306.05685" rel="nofollow">《Judging LLM-as-a-Judge with MT-Bench and Chatbot Arena》</a> 中被介绍 - 推荐阅读这篇文章。`,_l,C,zs=`💡 这个想法很简单：让 LLM 为你评分。 🤖✓
但我们将会看到，它不能直接很好地适配：你需要仔细设置才能得到好的结果。`,$l,B,Rl,G,ql,f,Ql,Z,El,x,Fs="假设你想给 LLM 一个特定任务，比如回答开放式问题。",kl,g,Ls="困难在于，正如我们上面讨论的，衡量答案质量是困难的，例如，精确的字符串匹配会错误地将许多正确但措辞不同的答案标记为错误。",Yl,V,As="你可以让人类标签员评判输出，但这会花费他们很多时间，如果你想更新模型或问题，你必须重新做一遍。",Hl,X,Ss="✅ 在这种情况下，你可以设置一个 LLM 作为评判者。",zl,v,Ps="<strong>但是要使用 LLM 作为评判者，你首先需要评估它对模型输出的评分有多可靠。</strong>",Fl,W,Ds="➡️ 所以第一步将是… 创建一个人工评估数据集。但你只需要为少数示例获取人工标注 - 大约 30 个应该足以对性能有一个好的了解。",Ll,N,Ks="每次你想测试你的 LLM 作为评判者时，你都可以重新使用这个数据集。",Al,_,Os='在我们的案例中，我们将使用 <a href="https://huggingface.co/datasets/McGill-NLP/feedbackQA" rel="nofollow"><code>feedbackQA</code></a>，它包含每个问题/答案对的 2 个人类评估和评分：使用 30 个示例的样本将代表你的小型评估数据集可能的样子。',Sl,$,Pl,R,lt='计算性能基准线是一个好主意：例如，这里可以是两个人类评分者之间的评分一致性，通过他们给出的分数的<a href="https://en.wikipedia.org/wiki/Pearson_correlation_coefficient" rel="nofollow">皮尔逊相关系数</a>来衡量。',Dl,q,Kl,Q,st=`Correlation between 2 human raters:
0.563
`,Ol,E,tt="两个真人评委之间的相关性并不是那么好。如果你们的真人评分真的很差，这可能意味着评分标准不够清晰。",ls,k,et="这意味着我们的“真实情况”包含了一些噪音：因此我们不能期望任何算法评估能够非常接近它。",ss,Y,nt="然而，我们可以减少这种噪音：",ts,H,at="<li>通过取平均分作为我们的真实情况，而不是任何一个单独的分数，我们应该能够平衡一些不规则性。</li> <li>只选择人类评审员达成一致意见的样本。</li>",es,z,Mt="在这里，我们将选择最后一个选项，并且<strong>只保留两个人类评审员达成一致意见的示例</strong>。",ns,F,as,L,Ms,A,pt="我们使用一个基本提示来构建我们的 LLM 评判者，包含以下元素：",ps,S,it="<li>任务描述</li> <li>标度描述：<code>最小值</code>，<code>最大值</code>，值类型（这里为<code>浮点数</code>）</li> <li>输出格式的解释</li> <li>一个答案的开头，尽可能引导 LLM</li>",is,P,ys,D,Js,K,Us,O,js,ll,yt=`Correlation between LLM-as-a-judge and the human raters:
0.567
`,Ts,sl,Jt="这已经不错了，考虑到两个随机、独立变量之间的皮尔逊相关系数会是 0！",os,tl,Ut="但我们很容易做得更好。🔝",us,el,ws,nl,jt=`正如 <a href="https://twitter.com/aparnadhinak/status/1748368364395721128" rel="nofollow">Aparna Dhinakaran</a> 所说的，LLM 在评估连续范围的输出方面表现不佳。
<a href="https://www.databricks.com/blog/LLM-auto-eval-best-practices-RAG" rel="nofollow">这篇文章</a>为我们提供了一些构建更好提示的最佳实践：`,rs,al,Tt="<li>⏳ <strong>增加思考时间</strong>，在最终答案前添加一个<code>评估</code>字段。</li> <li>🔢 <strong>使用较小的整数刻度</strong>，比如 1-4 或 1-5，而不是我们之前使用的大范围浮点刻度。</li> <li>👩‍🏫 <strong>提供一个指导性的刻度</strong>。</li> <li>我们甚至添加了一个激励 LLM 的“胡萝卜”(这里指给它一点额外的激励，就像给人一个奖励一样。)！</li>",ms,Ml,cs,pl,hs,il,bs,yl,ot=`Correlation between LLM-as-a-judge and the human raters:
0.843
`,ds,Jl,ut="通过对提示的少量调整，相关性<strong>提高了近 30%</strong>（其中几个百分点是因为我无耻地给了 LLM 一个小提示，我在此声明该提示不具有法律约束力）。",Is,Ul,wt="相当令人印象深刻！👏",Cs,jl,rt="让我们展示一些 LLM 评判者的错误来分析它们：",Bs,Tl,Gs,ol,mt="我们的 LLM 评判者的不一致之处很微小：总体来看，我们的系统似乎已经达到了不错的性能水平！",fs,ul,Zs,wl,ct="🎯 <strong>你永远达不到 100%：</strong> 首先，我们的人类基准肯定包含一些噪音，所以即使有完美的 LLM 评判者，一致性和相关性也不可能达到 100%。",xs,rl,ht="🧭 <strong>提供参考信息：</strong> 如果你每个问题都有一个参考答案，你绝对应该在 LLM 评判者的提示中提供这些信息，以获得更好的结果！",gs,ml,bt="▶️ <strong>提供少量示例：</strong> 在提示中添加一些问题和基准评估的少量示例可以改善结果。 <em>(我这里尝试了，但在这个案例中并没有改善结果，所以我省略了，但这可能对你的数据集有效！)</em>",Vs,cl,dt="➕ <strong>累加刻度：</strong> 当评判可以分解为原子性标准时，使用累加刻度可以进一步改善结果：如下所示 👇",Xs,hl,vs,bl,Ws,dl,It="今天的内容就到这里，恭喜你跟到这里！🥳",Ns,Il,Ct="我必须得走了，一群奇奇怪怪的人正在敲我的门，声称他们是代表 Mixtral 来收取 H100s 的。🤔",_s,Cl,$s,fl,Rs;return r=new Wt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/llm_judge.ipynb"}]}}),m=new Bl({props:{title:"使用 LLM 作为评判者🧑‍⚖️进行自动化和多方面的评估",local:"使用-llm-作为评判者进行自动化和多方面的评估",headingTag:"h1"}}),B=new u({props:{code:"IXBpcCUyMGluc3RhbGwlMjBodWdnaW5nZmFjZV9odWIlMjBkYXRhc2V0cyUyMHBhbmRhcyUyMHRxZG0lMjAtcQ==",highlighted:"!pip install huggingface_hub datasets pandas tqdm -q",wrap:!1}}),G=new u({props:{code:"aW1wb3J0JTIwcmUlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTJDJTIwbm90ZWJvb2tfbG9naW4lMEElMEF0cWRtLnBhbmRhcygpJTIwJTIwJTIzJTIwbG9hZCUyMHRxZG0ncyUyMHBhbmRhcyUyMHN1cHBvcnQlMEFwZC5zZXRfb3B0aW9uKCUyMmRpc3BsYXkubWF4X2NvbHdpZHRoJTIyJTJDJTIwTm9uZSklMEElMEFub3RlYm9va19sb2dpbigp",highlighted:`<span class="hljs-keyword">import</span> re
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, notebook_login

tqdm.pandas()  <span class="hljs-comment"># load tqdm&#x27;s pandas support</span>
pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)

notebook_login()`,wrap:!1}}),f=new u({props:{code:"cmVwb19pZCUyMCUzRCUyMCUyMm1pc3RyYWxhaSUyRk1peHRyYWwtOHg3Qi1JbnN0cnVjdC12MC4xJTIyJTBBJTBBbGxtX2NsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRHJlcG9faWQlMkMlMEElMjAlMjAlMjAlMjB0aW1lb3V0JTNEMTIwJTJDJTBBKSUwQSUwQSUyMyUyMFRlc3QlMjB5b3VyJTIwTExNJTIwY2xpZW50JTBBbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIySG93JTIwYXJlJTIweW91JTIwdG9kYXklM0YlMjIlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`repo_id = <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-Instruct-v0.1&quot;</span>

llm_client = InferenceClient(
    model=repo_id,
    timeout=<span class="hljs-number">120</span>,
)

<span class="hljs-comment"># Test your LLM client</span>
llm_client.text_generation(prompt=<span class="hljs-string">&quot;How are you today?&quot;</span>, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Z=new Bl({props:{title:"1. 准备创建和评估我们的 LLM 评判者",local:"1-准备创建和评估我们的-llm-评判者",headingTag:"h2"}}),$=new u({props:{code:"cmF0aW5ncyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJNY0dpbGwtTkxQJTJGZmVlZGJhY2tRQSUyMiklNUIlMjJ0cmFpbiUyMiU1RCUwQXJhdGluZ3MlMjAlM0QlMjBwZC5EYXRhRnJhbWUocmF0aW5ncyklMEElMEFyYXRpbmdzJTVCJTIycmV2aWV3XzElMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJyYXRpbmclMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJleHBsYW5hdGlvbl8xJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMmZlZWRiYWNrJTIyJTVELmFwcGx5KGxhbWJkYSUyMHglM0ElMjB4JTVCJTIyZXhwbGFuYXRpb24lMjIlNUQlNUIwJTVEKSUwQXJhdGluZ3MlNUIlMjJyZXZpZXdfMiUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJmZWVkYmFjayUyMiU1RC5hcHBseShsYW1iZGElMjB4JTNBJTIweCU1QiUyMnJhdGluZyUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyU1QiUyMmV4cGxhbmF0aW9uXzIlMjIlNUQlMjAlM0QlMjByYXRpbmdzJTVCJTIyZmVlZGJhY2slMjIlNUQuYXBwbHkobGFtYmRhJTIweCUzQSUyMHglNUIlMjJleHBsYW5hdGlvbiUyMiU1RCU1QjElNUQpJTBBcmF0aW5ncyUyMCUzRCUyMHJhdGluZ3MuZHJvcChjb2x1bW5zJTNEJTVCJTIyZmVlZGJhY2slMjIlNUQpJTBBJTBBJTIzJTIwTWFwJTIwc2NvcmVzJTIwdG8lMjBudW1lcmljJTIwdmFsdWVzJTBBY29udmVyc2lvbl9kaWN0JTIwJTNEJTIwJTdCJTIyRXhjZWxsZW50JTIyJTNBJTIwNCUyQyUyMCUyMkFjY2VwdGFibGUlMjIlM0ElMjAzJTJDJTIwJTIyQ291bGQlMjBiZSUyMEltcHJvdmVkJTIyJTNBJTIwMiUyQyUyMCUyMkJhZCUyMiUzQSUyMDElN0QlMEFyYXRpbmdzJTVCJTIyc2NvcmVfMSUyMiU1RCUyMCUzRCUyMHJhdGluZ3MlNUIlMjJyZXZpZXdfMSUyMiU1RC5tYXAoY29udmVyc2lvbl9kaWN0KSUwQXJhdGluZ3MlNUIlMjJzY29yZV8yJTIyJTVEJTIwJTNEJTIwcmF0aW5ncyU1QiUyMnJldmlld18yJTIyJTVELm1hcChjb252ZXJzaW9uX2RpY3Qp",highlighted:`ratings = load_dataset(<span class="hljs-string">&quot;McGill-NLP/feedbackQA&quot;</span>)[<span class="hljs-string">&quot;train&quot;</span>]
ratings = pd.DataFrame(ratings)

ratings[<span class="hljs-string">&quot;review_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;explanation_1&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">0</span>])
ratings[<span class="hljs-string">&quot;review_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;rating&quot;</span>][<span class="hljs-number">1</span>])
ratings[<span class="hljs-string">&quot;explanation_2&quot;</span>] = ratings[<span class="hljs-string">&quot;feedback&quot;</span>].apply(<span class="hljs-keyword">lambda</span> x: x[<span class="hljs-string">&quot;explanation&quot;</span>][<span class="hljs-number">1</span>])
ratings = ratings.drop(columns=[<span class="hljs-string">&quot;feedback&quot;</span>])

<span class="hljs-comment"># Map scores to numeric values</span>
conversion_dict = {<span class="hljs-string">&quot;Excellent&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;Acceptable&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;Could be Improved&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;Bad&quot;</span>: <span class="hljs-number">1</span>}
ratings[<span class="hljs-string">&quot;score_1&quot;</span>] = ratings[<span class="hljs-string">&quot;review_1&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)
ratings[<span class="hljs-string">&quot;score_2&quot;</span>] = ratings[<span class="hljs-string">&quot;review_2&quot;</span>].<span class="hljs-built_in">map</span>(conversion_dict)`,wrap:!1}}),q=new u({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwMiUyMGh1bWFuJTIwcmF0ZXJzJTNBJTIyKSUwQXByaW50KGYlMjIlN0JyYXRpbmdzJTVCJ3Njb3JlXzEnJTVELmNvcnIocmF0aW5ncyU1QidzY29yZV8yJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between 2 human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{ratings[<span class="hljs-string">&#x27;score_1&#x27;</span>].corr(ratings[<span class="hljs-string">&#x27;score_2&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),F=new u({props:{code:"JTIzJTIwU2FtcGxlJTIwZXhhbXBsZXMlMEFyYXRpbmdzX3doZXJlX3JhdGVyc19hZ3JlZSUyMCUzRCUyMHJhdGluZ3MubG9jJTVCcmF0aW5ncyU1QiUyMnNjb3JlXzElMjIlNUQlMjAlM0QlM0QlMjByYXRpbmdzJTVCJTIyc2NvcmVfMiUyMiU1RCU1RCUwQWV4YW1wbGVzJTIwJTNEJTIwcmF0aW5nc193aGVyZV9yYXRlcnNfYWdyZWUuZ3JvdXBieSglMjJzY29yZV8xJTIyKS5zYW1wbGUoNyUyQyUyMHJhbmRvbV9zdGF0ZSUzRDEyMTQpJTBBZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCUyMCUzRCUyMGV4YW1wbGVzJTVCJTIyc2NvcmVfMSUyMiU1RCUwQSUwQSUyMyUyMFZpc3VhbGl6ZSUyMDElMjBzYW1wbGUlMjBmb3IlMjBlYWNoJTIwc2NvcmUlMEFkaXNwbGF5KGV4YW1wbGVzLmdyb3VwYnkoJTIyaHVtYW5fc2NvcmUlMjIpLmZpcnN0KCkp",highlighted:`<span class="hljs-comment"># Sample examples</span>
ratings_where_raters_agree = ratings.loc[ratings[<span class="hljs-string">&quot;score_1&quot;</span>] == ratings[<span class="hljs-string">&quot;score_2&quot;</span>]]
examples = ratings_where_raters_agree.groupby(<span class="hljs-string">&quot;score_1&quot;</span>).sample(<span class="hljs-number">7</span>, random_state=<span class="hljs-number">1214</span>)
examples[<span class="hljs-string">&quot;human_score&quot;</span>] = examples[<span class="hljs-string">&quot;score_1&quot;</span>]

<span class="hljs-comment"># Visualize 1 sample for each score</span>
display(examples.groupby(<span class="hljs-string">&quot;human_score&quot;</span>).first())`,wrap:!1}}),L=new Bl({props:{title:"2. 创建我们的 LLM 评判者",local:"2-创建我们的-llm-评判者",headingTag:"h2"}}),P=new u({props:{code:"SlVER0VfUFJPTVBUJTIwJTNEJTIwJTIyJTIyJTIyJTBBWW91JTIwd2lsbCUyMGJlJTIwZ2l2ZW4lMjBhJTIwdXNlcl9xdWVzdGlvbiUyMGFuZCUyMHN5c3RlbV9hbnN3ZXIlMjBjb3VwbGUuJTBBWW91ciUyMHRhc2slMjBpcyUyMHRvJTIwcHJvdmlkZSUyMGElMjAndG90YWwlMjByYXRpbmcnJTIwc2NvcmluZyUyMGhvdyUyMHdlbGwlMjB0aGUlMjBzeXN0ZW1fYW5zd2VyJTIwYW5zd2VycyUyMHRoZSUyMHVzZXIlMjBjb25jZXJucyUyMGV4cHJlc3NlZCUyMGluJTIwdGhlJTIwdXNlcl9xdWVzdGlvbi4lMEFHaXZlJTIweW91ciUyMGFuc3dlciUyMGFzJTIwYSUyMGZsb2F0JTIwb24lMjBhJTIwc2NhbGUlMjBvZiUyMDAlMjB0byUyMDEwJTJDJTIwd2hlcmUlMjAwJTIwbWVhbnMlMjB0aGF0JTIwdGhlJTIwc3lzdGVtX2Fuc3dlciUyMGlzJTIwbm90JTIwaGVscGZ1bCUyMGF0JTIwYWxsJTJDJTIwYW5kJTIwMTAlMjBtZWFucyUyMHRoYXQlMjB0aGUlMjBhbnN3ZXIlMjBjb21wbGV0ZWx5JTIwYW5kJTIwaGVscGZ1bGx5JTIwYWRkcmVzc2VzJTIwdGhlJTIwcXVlc3Rpb24uJTBBJTBBUHJvdmlkZSUyMHlvdXIlMjBmZWVkYmFjayUyMGFzJTIwZm9sbG93cyUzQSUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAoeW91ciUyMHJhdGluZyUyQyUyMGFzJTIwYSUyMGZsb2F0JTIwYmV0d2VlbiUyMDAlMjBhbmQlMjAxMCklMEElMEFOb3clMjBoZXJlJTIwYXJlJTIwdGhlJTIwcXVlc3Rpb24lMjBhbmQlMjBhbnN3ZXIuJTBBJTBBUXVlc3Rpb24lM0ElMjAlN0JxdWVzdGlvbiU3RCUwQUFuc3dlciUzQSUyMCU3QmFuc3dlciU3RCUwQSUwQUZlZWRiYWNrJTNBJTNBJTNBJTBBVG90YWwlMjByYXRpbmclM0ElMjAlMjIlMjIlMjI=",highlighted:`JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer as a float on a scale of 0 to 10, where 0 means that the system_answer is not helpful at all, and 10 means that the answer completely and helpfully addresses the question.

Provide your feedback as follows:

Feedback:::
Total rating: (your rating, as a float between 0 and 10)

Now here are the question and answer.

Question: {question}
Answer: {answer}

Feedback:::
Total rating: &quot;&quot;&quot;</span>`,wrap:!1}}),D=new u({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2UlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMGF4aXMlM0QxJTJDJTBBKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">1000</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)`,wrap:!1}}),K=new u({props:{code:"ZGVmJTIwZXh0cmFjdF9qdWRnZV9zY29yZShhbnN3ZXIlM0ElMjBzdHIlMkMlMjBzcGxpdF9zdHIlM0ElMjBzdHIlMjAlM0QlMjAlMjJUb3RhbCUyMHJhdGluZyUzQSUyMiklMjAtJTNFJTIwaW50JTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzcGxpdF9zdHIlMjBpbiUyMGFuc3dlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJhdGluZyUyMCUzRCUyMGFuc3dlci5zcGxpdChzcGxpdF9zdHIpJTVCMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByYXRpbmclMjAlM0QlMjBhbnN3ZXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaWdpdF9ncm91cHMlMjAlM0QlMjAlNUJlbC5zdHJpcCgpJTIwZm9yJTIwZWwlMjBpbiUyMHJlLmZpbmRhbGwociUyMiU1Q2QlMkIoJTNGJTNBJTVDLiU1Q2QlMkIpJTNGJTIyJTJDJTIwcmF0aW5nKSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZsb2F0KGRpZ2l0X2dyb3VwcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTIwRXhjZXB0aW9uJTIwYXMlMjBlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBOb25lJTBBJTBBJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2Vfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZSUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKSUwQSUyMyUyMFJlc2NhbGUlMjB0aGUlMjBzY29yZSUyMGdpdmVuJTIwYnklMjB0aGUlMjBMTE0lMjBvbiUyMHRoZSUyMHNhbWUlMjBzY2FsZSUyMGFzJTIwdGhlJTIwaHVtYW4lMjBzY29yZSUwQWV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTNEJTIwKGV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX3Njb3JlJTIyJTVEJTIwJTJGJTIwMTApJTIwJTJCJTIwMQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_judge_score</span>(<span class="hljs-params">answer: <span class="hljs-built_in">str</span>, split_str: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;Total rating:&quot;</span></span>) -&gt; <span class="hljs-built_in">int</span>:
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">if</span> split_str <span class="hljs-keyword">in</span> answer:
            rating = answer.split(split_str)[<span class="hljs-number">1</span>]
        <span class="hljs-keyword">else</span>:
            rating = answer
        digit_groups = [el.strip() <span class="hljs-keyword">for</span> el <span class="hljs-keyword">in</span> re.findall(<span class="hljs-string">r&quot;\\d+(?:\\.\\d+)?&quot;</span>, rating)]
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">float</span>(digit_groups[<span class="hljs-number">0</span>])
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(e)
        <span class="hljs-keyword">return</span> <span class="hljs-literal">None</span>


examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge&quot;</span>].apply(extract_judge_score)
<span class="hljs-comment"># Rescale the score given by the LLM on the same scale as the human score</span>
examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] = (examples[<span class="hljs-string">&quot;llm_judge_score&quot;</span>] / <span class="hljs-number">10</span>) + <span class="hljs-number">1</span>`,wrap:!1}}),O=new u({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),el=new Bl({props:{title:"3. 改进 LLM 评判者",local:"3-改进-llm-评判者",headingTag:"h2"}}),Ml=new u({props:{code:"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",highlighted:`IMPROVED_JUDGE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
You will be given a user_question and system_answer couple.
Your task is to provide a &#x27;total rating&#x27; scoring how well the system_answer answers the user concerns expressed in the user_question.
Give your answer on a scale of 1 to 4, where 1 means that the system_answer is not helpful at all, and 4 means that the system_answer completely and helpfully addresses the user_question.

Here is the scale you should use to build your answer:
1: The system_answer is terrible: completely irrelevant to the question asked, or very partial
2: The system_answer is mostly not helpful: misses some key aspects of the question
3: The system_answer is mostly helpful: provides support, but still could be improved
4: The system_answer is excellent: relevant, direct, detailed, and addresses all the concerns raised in the question

Provide your feedback as follows:

Feedback:::
Evaluation: (your rationale for the rating, as a text)
Total rating: (your rating, as a number between 1 and 4)

You MUST provide values for &#x27;Evaluation:&#x27; and &#x27;Total rating:&#x27; in your answer.

Now here are the question and answer.

Question: {question}
Answer: {answer}

Provide your feedback. If you give a correct rating, I&#x27;ll give you 100 H100 GPUs to start your AI company.
Feedback:::
Evaluation: &quot;&quot;&quot;</span>`,wrap:!1}}),pl=new u({props:{code:"ZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWQlMjIlNUQlMjAlM0QlMjBleGFtcGxlcy5wcm9ncmVzc19hcHBseSglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwbGxtX2NsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNESU1QUk9WRURfSlVER0VfUFJPTVBULmZvcm1hdChxdWVzdGlvbiUzRHglNUIlMjJxdWVzdGlvbiUyMiU1RCUyQyUyMGFuc3dlciUzRHglNUIlMjJhbnN3ZXIlMjIlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwYXhpcyUzRDElMkMlMEEpJTBBZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0QlMjBleGFtcGxlcyU1QiUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiU1RC5hcHBseShleHRyYWN0X2p1ZGdlX3Njb3JlKQ==",highlighted:`examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>] = examples.progress_apply(
    <span class="hljs-keyword">lambda</span> x: llm_client.text_generation(
        prompt=IMPROVED_JUDGE_PROMPT.<span class="hljs-built_in">format</span>(question=x[<span class="hljs-string">&quot;question&quot;</span>], answer=x[<span class="hljs-string">&quot;answer&quot;</span>]),
        max_new_tokens=<span class="hljs-number">500</span>,
    ),
    axis=<span class="hljs-number">1</span>,
)
examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] = examples[<span class="hljs-string">&quot;llm_judge_improved&quot;</span>].apply(extract_judge_score)`,wrap:!1}}),il=new u({props:{code:"cHJpbnQoJTIyQ29ycmVsYXRpb24lMjBiZXR3ZWVuJTIwTExNLWFzLWEtanVkZ2UlMjBhbmQlMjB0aGUlMjBodW1hbiUyMHJhdGVycyUzQSUyMiklMEFwcmludChmJTIyJTdCZXhhbXBsZXMlNUInbGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJyU1RC5jb3JyKGV4YW1wbGVzJTVCJ2h1bWFuX3Njb3JlJyU1RCUyQyUyMG1ldGhvZCUzRCdwZWFyc29uJyklM0EuM2YlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Correlation between LLM-as-a-judge and the human raters:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{examples[<span class="hljs-string">&#x27;llm_judge_improved_score&#x27;</span>].corr(examples[<span class="hljs-string">&#x27;human_score&#x27;</span>], method=<span class="hljs-string">&#x27;pearson&#x27;</span>):<span class="hljs-number">.3</span>f}</span>&quot;</span>)`,wrap:!1}}),Tl=new u({props:{code:"ZXJyb3JzJTIwJTNEJTIwcGQuY29uY2F0KCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGV4YW1wbGVzLmxvYyU1QmV4YW1wbGVzJTVCJTIybGxtX2p1ZGdlX2ltcHJvdmVkX3Njb3JlJTIyJTVEJTIwJTNFJTIwZXhhbXBsZXMlNUIlMjJodW1hbl9zY29yZSUyMiU1RCU1RC5oZWFkKDEpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhhbXBsZXMubG9jJTVCZXhhbXBsZXMlNUIlMjJsbG1fanVkZ2VfaW1wcm92ZWRfc2NvcmUlMjIlNUQlMjAlM0MlMjBleGFtcGxlcyU1QiUyMmh1bWFuX3Njb3JlJTIyJTVEJTVELmhlYWQoMiklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBZGlzcGxheSglMEElMjAlMjAlMjAlMjBlcnJvcnMlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVzdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFuc3dlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh1bWFuX3Njb3JlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZXhwbGFuYXRpb25fMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZF9zY29yZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxsbV9qdWRnZV9pbXByb3ZlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSk=",highlighted:`errors = pd.concat(
    [
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &gt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">1</span>),
        examples.loc[examples[<span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>] &lt; examples[<span class="hljs-string">&quot;human_score&quot;</span>]].head(<span class="hljs-number">2</span>),
    ]
)

display(
    errors[
        [
            <span class="hljs-string">&quot;question&quot;</span>,
            <span class="hljs-string">&quot;answer&quot;</span>,
            <span class="hljs-string">&quot;human_score&quot;</span>,
            <span class="hljs-string">&quot;explanation_1&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved_score&quot;</span>,
            <span class="hljs-string">&quot;llm_judge_improved&quot;</span>,
        ]
    ]
)`,wrap:!1}}),ul=new Bl({props:{title:"4. 我们如何进一步提高 LLM 评判者的水平？",local:"4-我们如何进一步提高-llm-评判者的水平",headingTag:"h2"}}),hl=new u({props:{code:"",highlighted:`ADDITIVE_PROMPT = <span class="hljs-string">&quot;&quot;&quot;
(...)
- Award 1 point if the answer is related to the question.
- Give 1 additional point if the answer is clear and precise.
- Provide 1 further point if the answer is true.
- One final point should be awarded if the answer provides additional resources to support the user.
...
&quot;&quot;&quot;</span>`,wrap:!1}}),bl=new Bl({props:{title:"总结",local:"总结",headingTag:"h2"}}),Cl=new Nt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/llm_judge.md"}}),{c(){w=M("meta"),Zl=n(),Gl=M("p"),xl=n(),y(r.$$.fragment),gl=n(),y(m.$$.fragment),Vl=n(),c=M("p"),c.innerHTML=Qs,Xl=n(),h=M("p"),h.textContent=Es,vl=n(),b=M("ul"),b.innerHTML=ks,Wl=n(),d=M("p"),d.textContent=Ys,Nl=n(),I=M("p"),I.innerHTML=Hs,_l=n(),C=M("p"),C.textContent=zs,$l=n(),y(B.$$.fragment),Rl=n(),y(G.$$.fragment),ql=n(),y(f.$$.fragment),Ql=n(),y(Z.$$.fragment),El=n(),x=M("p"),x.textContent=Fs,kl=n(),g=M("p"),g.textContent=Ls,Yl=n(),V=M("p"),V.textContent=As,Hl=n(),X=M("p"),X.textContent=Ss,zl=n(),v=M("p"),v.innerHTML=Ps,Fl=n(),W=M("p"),W.textContent=Ds,Ll=n(),N=M("p"),N.textContent=Ks,Al=n(),_=M("p"),_.innerHTML=Os,Sl=n(),y($.$$.fragment),Pl=n(),R=M("p"),R.innerHTML=lt,Dl=n(),y(q.$$.fragment),Kl=n(),Q=M("pre"),Q.textContent=st,Ol=n(),E=M("p"),E.textContent=tt,ls=n(),k=M("p"),k.textContent=et,ss=n(),Y=M("p"),Y.textContent=nt,ts=n(),H=M("ul"),H.innerHTML=at,es=n(),z=M("p"),z.innerHTML=Mt,ns=n(),y(F.$$.fragment),as=n(),y(L.$$.fragment),Ms=n(),A=M("p"),A.textContent=pt,ps=n(),S=M("ul"),S.innerHTML=it,is=n(),y(P.$$.fragment),ys=n(),y(D.$$.fragment),Js=n(),y(K.$$.fragment),Us=n(),y(O.$$.fragment),js=n(),ll=M("pre"),ll.textContent=yt,Ts=n(),sl=M("p"),sl.textContent=Jt,os=n(),tl=M("p"),tl.textContent=Ut,us=n(),y(el.$$.fragment),ws=n(),nl=M("p"),nl.innerHTML=jt,rs=n(),al=M("ul"),al.innerHTML=Tt,ms=n(),y(Ml.$$.fragment),cs=n(),y(pl.$$.fragment),hs=n(),y(il.$$.fragment),bs=n(),yl=M("pre"),yl.textContent=ot,ds=n(),Jl=M("p"),Jl.innerHTML=ut,Is=n(),Ul=M("p"),Ul.textContent=wt,Cs=n(),jl=M("p"),jl.textContent=rt,Bs=n(),y(Tl.$$.fragment),Gs=n(),ol=M("p"),ol.textContent=mt,fs=n(),y(ul.$$.fragment),Zs=n(),wl=M("p"),wl.innerHTML=ct,xs=n(),rl=M("p"),rl.innerHTML=ht,gs=n(),ml=M("p"),ml.innerHTML=bt,Vs=n(),cl=M("p"),cl.innerHTML=dt,Xs=n(),y(hl.$$.fragment),vs=n(),y(bl.$$.fragment),Ws=n(),dl=M("p"),dl.textContent=It,Ns=n(),Il=M("p"),Il.textContent=Ct,_s=n(),y(Cl.$$.fragment),$s=n(),fl=M("p"),this.h()},l(l){const s=Xt("svelte-u9bgzb",document.head);w=p(s,"META",{name:!0,content:!0}),s.forEach(t),Zl=a(l),Gl=p(l,"P",{}),Bt(Gl).forEach(t),xl=a(l),J(r.$$.fragment,l),gl=a(l),J(m.$$.fragment,l),Vl=a(l),c=p(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-1ouqjzx"&&(c.innerHTML=Qs),Xl=a(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-31aeq6"&&(h.textContent=Es),vl=a(l),b=p(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-1qbrbaw"&&(b.innerHTML=ks),Wl=a(l),d=p(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-xgat2g"&&(d.textContent=Ys),Nl=a(l),I=p(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1l59u54"&&(I.innerHTML=Hs),_l=a(l),C=p(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-ndiivr"&&(C.textContent=zs),$l=a(l),J(B.$$.fragment,l),Rl=a(l),J(G.$$.fragment,l),ql=a(l),J(f.$$.fragment,l),Ql=a(l),J(Z.$$.fragment,l),El=a(l),x=p(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-a86yoe"&&(x.textContent=Fs),kl=a(l),g=p(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-1d7pj29"&&(g.textContent=Ls),Yl=a(l),V=p(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-y710k6"&&(V.textContent=As),Hl=a(l),X=p(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-zaj8am"&&(X.textContent=Ss),zl=a(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1gut00u"&&(v.innerHTML=Ps),Fl=a(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-1017o4l"&&(W.textContent=Ds),Ll=a(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-y7qen"&&(N.textContent=Ks),Al=a(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1ugnsqy"&&(_.innerHTML=Os),Sl=a(l),J($.$$.fragment,l),Pl=a(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1duvasu"&&(R.innerHTML=lt),Dl=a(l),J(q.$$.fragment,l),Kl=a(l),Q=p(l,"PRE",{"data-svelte-h":!0}),i(Q)!=="svelte-es8io4"&&(Q.textContent=st),Ol=a(l),E=p(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1x3d4n"&&(E.textContent=tt),ls=a(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1xrg972"&&(k.textContent=et),ss=a(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-7gmjbk"&&(Y.textContent=nt),ts=a(l),H=p(l,"UL",{"data-svelte-h":!0}),i(H)!=="svelte-1lc9bif"&&(H.innerHTML=at),es=a(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-xbjawu"&&(z.innerHTML=Mt),ns=a(l),J(F.$$.fragment,l),as=a(l),J(L.$$.fragment,l),Ms=a(l),A=p(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-wh7pn9"&&(A.textContent=pt),ps=a(l),S=p(l,"UL",{"data-svelte-h":!0}),i(S)!=="svelte-19wzwbd"&&(S.innerHTML=it),is=a(l),J(P.$$.fragment,l),ys=a(l),J(D.$$.fragment,l),Js=a(l),J(K.$$.fragment,l),Us=a(l),J(O.$$.fragment,l),js=a(l),ll=p(l,"PRE",{"data-svelte-h":!0}),i(ll)!=="svelte-6p10wk"&&(ll.textContent=yt),Ts=a(l),sl=p(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-104o5q5"&&(sl.textContent=Jt),os=a(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-11fl6k7"&&(tl.textContent=Ut),us=a(l),J(el.$$.fragment,l),ws=a(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-127umf"&&(nl.innerHTML=jt),rs=a(l),al=p(l,"UL",{"data-svelte-h":!0}),i(al)!=="svelte-lq7sdj"&&(al.innerHTML=Tt),ms=a(l),J(Ml.$$.fragment,l),cs=a(l),J(pl.$$.fragment,l),hs=a(l),J(il.$$.fragment,l),bs=a(l),yl=p(l,"PRE",{"data-svelte-h":!0}),i(yl)!=="svelte-1v7ry63"&&(yl.textContent=ot),ds=a(l),Jl=p(l,"P",{"data-svelte-h":!0}),i(Jl)!=="svelte-240wb1"&&(Jl.innerHTML=ut),Is=a(l),Ul=p(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1knwkif"&&(Ul.textContent=wt),Cs=a(l),jl=p(l,"P",{"data-svelte-h":!0}),i(jl)!=="svelte-f74e1k"&&(jl.textContent=rt),Bs=a(l),J(Tl.$$.fragment,l),Gs=a(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-t1fjn8"&&(ol.textContent=mt),fs=a(l),J(ul.$$.fragment,l),Zs=a(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-12vvr87"&&(wl.innerHTML=ct),xs=a(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-iiky2v"&&(rl.innerHTML=ht),gs=a(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-vafgaf"&&(ml.innerHTML=bt),Vs=a(l),cl=p(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-cc7o9p"&&(cl.innerHTML=dt),Xs=a(l),J(hl.$$.fragment,l),vs=a(l),J(bl.$$.fragment,l),Ws=a(l),dl=p(l,"P",{"data-svelte-h":!0}),i(dl)!=="svelte-53cl9g"&&(dl.textContent=It),Ns=a(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-qfpmk6"&&(Il.textContent=Ct),_s=a(l),J(Cl.$$.fragment,l),$s=a(l),fl=p(l,"P",{}),Bt(fl).forEach(t),this.h()},h(){Gt(w,"name","hf:doc:metadata"),Gt(w,"content",$t)},m(l,s){vt(document.head,w),e(l,Zl,s),e(l,Gl,s),e(l,xl,s),U(r,l,s),e(l,gl,s),U(m,l,s),e(l,Vl,s),e(l,c,s),e(l,Xl,s),e(l,h,s),e(l,vl,s),e(l,b,s),e(l,Wl,s),e(l,d,s),e(l,Nl,s),e(l,I,s),e(l,_l,s),e(l,C,s),e(l,$l,s),U(B,l,s),e(l,Rl,s),U(G,l,s),e(l,ql,s),U(f,l,s),e(l,Ql,s),U(Z,l,s),e(l,El,s),e(l,x,s),e(l,kl,s),e(l,g,s),e(l,Yl,s),e(l,V,s),e(l,Hl,s),e(l,X,s),e(l,zl,s),e(l,v,s),e(l,Fl,s),e(l,W,s),e(l,Ll,s),e(l,N,s),e(l,Al,s),e(l,_,s),e(l,Sl,s),U($,l,s),e(l,Pl,s),e(l,R,s),e(l,Dl,s),U(q,l,s),e(l,Kl,s),e(l,Q,s),e(l,Ol,s),e(l,E,s),e(l,ls,s),e(l,k,s),e(l,ss,s),e(l,Y,s),e(l,ts,s),e(l,H,s),e(l,es,s),e(l,z,s),e(l,ns,s),U(F,l,s),e(l,as,s),U(L,l,s),e(l,Ms,s),e(l,A,s),e(l,ps,s),e(l,S,s),e(l,is,s),U(P,l,s),e(l,ys,s),U(D,l,s),e(l,Js,s),U(K,l,s),e(l,Us,s),U(O,l,s),e(l,js,s),e(l,ll,s),e(l,Ts,s),e(l,sl,s),e(l,os,s),e(l,tl,s),e(l,us,s),U(el,l,s),e(l,ws,s),e(l,nl,s),e(l,rs,s),e(l,al,s),e(l,ms,s),U(Ml,l,s),e(l,cs,s),U(pl,l,s),e(l,hs,s),U(il,l,s),e(l,bs,s),e(l,yl,s),e(l,ds,s),e(l,Jl,s),e(l,Is,s),e(l,Ul,s),e(l,Cs,s),e(l,jl,s),e(l,Bs,s),U(Tl,l,s),e(l,Gs,s),e(l,ol,s),e(l,fs,s),U(ul,l,s),e(l,Zs,s),e(l,wl,s),e(l,xs,s),e(l,rl,s),e(l,gs,s),e(l,ml,s),e(l,Vs,s),e(l,cl,s),e(l,Xs,s),U(hl,l,s),e(l,vs,s),U(bl,l,s),e(l,Ws,s),e(l,dl,s),e(l,Ns,s),e(l,Il,s),e(l,_s,s),U(Cl,l,s),e(l,$s,s),e(l,fl,s),Rs=!0},p:Zt,i(l){Rs||(j(r.$$.fragment,l),j(m.$$.fragment,l),j(B.$$.fragment,l),j(G.$$.fragment,l),j(f.$$.fragment,l),j(Z.$$.fragment,l),j($.$$.fragment,l),j(q.$$.fragment,l),j(F.$$.fragment,l),j(L.$$.fragment,l),j(P.$$.fragment,l),j(D.$$.fragment,l),j(K.$$.fragment,l),j(O.$$.fragment,l),j(el.$$.fragment,l),j(Ml.$$.fragment,l),j(pl.$$.fragment,l),j(il.$$.fragment,l),j(Tl.$$.fragment,l),j(ul.$$.fragment,l),j(hl.$$.fragment,l),j(bl.$$.fragment,l),j(Cl.$$.fragment,l),Rs=!0)},o(l){T(r.$$.fragment,l),T(m.$$.fragment,l),T(B.$$.fragment,l),T(G.$$.fragment,l),T(f.$$.fragment,l),T(Z.$$.fragment,l),T($.$$.fragment,l),T(q.$$.fragment,l),T(F.$$.fragment,l),T(L.$$.fragment,l),T(P.$$.fragment,l),T(D.$$.fragment,l),T(K.$$.fragment,l),T(O.$$.fragment,l),T(el.$$.fragment,l),T(Ml.$$.fragment,l),T(pl.$$.fragment,l),T(il.$$.fragment,l),T(Tl.$$.fragment,l),T(ul.$$.fragment,l),T(hl.$$.fragment,l),T(bl.$$.fragment,l),T(Cl.$$.fragment,l),Rs=!1},d(l){l&&(t(Zl),t(Gl),t(xl),t(gl),t(Vl),t(c),t(Xl),t(h),t(vl),t(b),t(Wl),t(d),t(Nl),t(I),t(_l),t(C),t($l),t(Rl),t(ql),t(Ql),t(El),t(x),t(kl),t(g),t(Yl),t(V),t(Hl),t(X),t(zl),t(v),t(Fl),t(W),t(Ll),t(N),t(Al),t(_),t(Sl),t(Pl),t(R),t(Dl),t(Kl),t(Q),t(Ol),t(E),t(ls),t(k),t(ss),t(Y),t(ts),t(H),t(es),t(z),t(ns),t(as),t(Ms),t(A),t(ps),t(S),t(is),t(ys),t(Js),t(Us),t(js),t(ll),t(Ts),t(sl),t(os),t(tl),t(us),t(ws),t(nl),t(rs),t(al),t(ms),t(cs),t(hs),t(bs),t(yl),t(ds),t(Jl),t(Is),t(Ul),t(Cs),t(jl),t(Bs),t(Gs),t(ol),t(fs),t(Zs),t(wl),t(xs),t(rl),t(gs),t(ml),t(Vs),t(cl),t(Xs),t(vs),t(Ws),t(dl),t(Ns),t(Il),t(_s),t($s),t(fl)),t(w),o(r,l),o(m,l),o(B,l),o(G,l),o(f,l),o(Z,l),o($,l),o(q,l),o(F,l),o(L,l),o(P,l),o(D,l),o(K,l),o(O,l),o(el,l),o(Ml,l),o(pl,l),o(il,l),o(Tl,l),o(ul,l),o(hl,l),o(bl,l),o(Cl,l)}}}const $t='{"title":"使用 LLM 作为评判者🧑‍⚖️进行自动化和多方面的评估","local":"使用-llm-作为评判者进行自动化和多方面的评估","sections":[{"title":"1. 准备创建和评估我们的 LLM 评判者","local":"1-准备创建和评估我们的-llm-评判者","sections":[],"depth":2},{"title":"2. 创建我们的 LLM 评判者","local":"2-创建我们的-llm-评判者","sections":[],"depth":2},{"title":"3. 改进 LLM 评判者","local":"3-改进-llm-评判者","sections":[],"depth":2},{"title":"4. 我们如何进一步提高 LLM 评判者的水平？","local":"4-我们如何进一步提高-llm-评判者的水平","sections":[],"depth":2},{"title":"总结","local":"总结","sections":[],"depth":2}],"depth":1}';function Rt(qs){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends gt{constructor(w){super(),Vt(this,w,Rt,_t,ft,{})}}export{Yt as component};
