import{s as wt,n as jt,o as mt}from"../chunks/scheduler.f6319a2a.js";import{S as bt,i as ht,g as M,s as n,r as p,A as dt,h as o,f as s,c as a,j as ct,u as y,x as i,k as Tt,y as Ct,a as e,v as U,d as u,t as r,w as J}from"../chunks/index.85aa684c.js";import{C as c}from"../chunks/CodeBlock.3400fc53.js";import{D as It}from"../chunks/DocNotebookDropdown.3fc3604b.js";import{H as $l,E as gt}from"../chunks/getInferenceSnippets.054af502.js";function ft(Hl){let T,el,tl,nl,w,al,j,Ml,m,Yl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>smolagents</code>.",ol,b,Fl="<p>Let’s start with the golden question: why not keep it simple and use a standard text-to-SQL pipeline?</p>",il,h,zl="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",pl,d,Ll="👉 Instead, an agent system is able to critically inspect outputs and decide if the query needs to be changed or not, thus giving it a huge performance boost.",yl,C,Dl="Let’s build this agent! 💪",Ul,I,Pl="Run the line below to install required dependencies:",ul,g,rl,f,Kl=`To call Inference Providers, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,Jl,B,cl,Q,Ol="Then, we setup the SQL environment:",Tl,q,wl,v,jl,Z,lt="Now let’s make our SQL table retrievable by a tool.",ml,W,tt="The tool’s description attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. This is where we want to describe the SQL table.",bl,S,hl,G,dl,_,st='Now let’s build our tool. It needs the following: (read <a href="../tutorials/tools">the tool doc</a> for more detail)',Cl,k,et="<li>A docstring with an <code>Args:</code> part listing arguments.</li> <li>Type hints on both inputs and output.</li>",Il,N,gl,R,nt="Now let us create an agent that leverages this tool.",fl,A,at="We use the <code>CodeAgent</code>, which is smolagents’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",Bl,E,Mt="The model is the LLM that powers the agent system. <code>InferenceClientModel</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API.",Ql,V,ql,x,vl,X,ot="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",Zl,$,it="So let’s make a second table recording the names of waiters for each receipt_id!",Wl,H,Sl,Y,pt="Since we changed the table, we update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",Gl,F,_l,z,yt='Since this request is a bit harder than the previous one, we’ll switch the LLM engine to use the more powerful <a href="https://huggingface.co/Qwen/Qwen2.5-Coder-32B-Instruct" rel="nofollow">Qwen/Qwen2.5-Coder-32B-Instruct</a>!',kl,L,Nl,D,Ut="It directly works! The setup was surprisingly simple, wasn’t it?",Rl,P,ut="This example is done! We’ve touched upon these concepts:",Al,K,rt="<li>Building new tools.</li> <li>Updating a tool’s description.</li> <li>Switching to a stronger LLM helps agent reasoning.</li>",El,O,Jt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Vl,ll,xl,sl,Xl;return w=new $l({props:{title:"Text-to-SQL",local:"text-to-sql",headingTag:"h1"}}),j=new It({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/text_to_sql.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/text_to_sql.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/text_to_sql.ipynb"}]}}),g=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcHl0aG9uLWRvdGVudiUyMHNxbGFsY2hlbXklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents python-dotenv sqlalchemy --upgrade -q",wrap:!1}}),B=new c({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),q=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-keyword">def</span> <span class="hljs-title function_">insert_rows_into_table</span>(<span class="hljs-params">rows, table, engine=engine</span>):
    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
        stmt = insert(table).values(**row)
        <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
            connection.execute(stmt)

table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
insert_rows_into_table(rows, receipts)`,wrap:!1}}),v=new $l({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h3"}}),S=new c({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`inspector = inspect(engine)
columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),G=new c({props:{code:"Q29sdW1ucyUzQSUwQSUyMCUyMC0lMjByZWNlaXB0X2lkJTNBJTIwSU5URUdFUiUwQSUyMCUyMC0lMjBjdXN0b21lcl9uYW1lJTNBJTIwVkFSQ0hBUigxNiklMEElMjAlMjAtJTIwcHJpY2UlM0ElMjBGTE9BVCUwQSUyMCUyMC0lMjB0aXAlM0ElMjBGTE9BVA==",highlighted:`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT`,wrap:!1}}),N=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjB0b29sJTBBJTBBJTQwdG9vbCUwQWRlZiUyMHNxbF9lbmdpbmUocXVlcnklM0ElMjBzdHIpJTIwLSUzRSUyMHN0ciUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMEFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEElMjAlMjAlMjAlMjBUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb2x1bW5zJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHJlY2VpcHRfaWQlM0ElMjBJTlRFR0VSJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMGN1c3RvbWVyX25hbWUlM0ElMjBWQVJDSEFSKDE2KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC0lMjBwcmljZSUzQSUyMEZMT0FUJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLSUyMHRpcCUzQSUyMEZMT0FUJTBBJTBBJTIwJTIwJTIwJTIwQXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNBJTIwVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBvdXRwdXQlMjAlM0QlMjAlMjIlMjIlMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmNvbm5lY3QoKSUyMGFzJTIwY29uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcm93cyUyMCUzRCUyMGNvbi5leGVjdXRlKHRleHQocXVlcnkpKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dCUyMCUyQiUzRCUyMCUyMiU1Q24lMjIlMjAlMkIlMjBzdHIocm93KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dA==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> tool

<span class="hljs-meta">@tool</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">sql_engine</span>(<span class="hljs-params">query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Allows you to perform SQL queries on the table. Returns a string representation of the result.
    The table is named &#x27;receipts&#x27;. Its description is as follows:
        Columns:
        - receipt_id: INTEGER
        - customer_name: VARCHAR(16)
        - price: FLOAT
        - tip: FLOAT

    Args:
        query: The query to perform. This should be correct SQL.
    &quot;&quot;&quot;</span>
    output = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
        rows = con.execute(text(query))
        <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
            output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
    <span class="hljs-keyword">return</span> output`,wrap:!1}}),V=new c({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCc3FsX2VuZ2luZSU1RCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwobW9kZWxfaWQlM0QlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyKSUyQyUwQSklMEFhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwY2xpZW50JTIwd2hvJTIwZ290JTIwdGhlJTIwbW9zdCUyMGV4cGVuc2l2ZSUyMHJlY2VpcHQlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>),
)
agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)`,wrap:!1}}),x=new $l({props:{title:"Level 2: Table joins",local:"level-2-table-joins",headingTag:"h3"}}),H=new c({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEF3YWl0ZXJzJTIwJTNEJTIwVGFibGUoJTBBJTIwJTIwJTIwJTIwdGFibGVfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhX29iaiUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJyZWNlaXB0X2lkJTIyJTJDJTIwSW50ZWdlciUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIyd2FpdGVyX25hbWUlMjIlMkMlMjBTdHJpbmcoMTYpJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSklMEFtZXRhZGF0YV9vYmouY3JlYXRlX2FsbChlbmdpbmUpJTBBJTBBcm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJDb3JleSUyMEpvaG5zb24lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMiUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWljaGFlbCUyMFdhdHRzJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDMlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjA0JTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTdEJTJDJTBBJTVEJTBBaW5zZXJ0X3Jvd3NfaW50b190YWJsZShyb3dzJTJDJTIwd2FpdGVycyk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
waiters = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
insert_rows_into_table(rows, waiters)`,wrap:!1}}),F=new c({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
It can use the following tables:&quot;&quot;&quot;</span>

inspector = inspect(engine)
<span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),L=new c({props:{code:"c3FsX2VuZ2luZS5kZXNjcmlwdGlvbiUyMCUzRCUyMHVwZGF0ZWRfZGVzY3JpcHRpb24lMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QnNxbF9lbmdpbmUlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzREluZmVyZW5jZUNsaWVudE1vZGVsKG1vZGVsX2lkJTNEJTIyUXdlbiUyRlF3ZW4yLjUtQ29kZXItMzJCLUluc3RydWN0JTIyKSUyQyUwQSklMEElMEFhZ2VudC5ydW4oJTIyV2hpY2glMjB3YWl0ZXIlMjBnb3QlMjBtb3JlJTIwdG90YWwlMjBtb25leSUyMGZyb20lMjB0aXBzJTNGJTIyKQ==",highlighted:`sql_engine.description = updated_description

agent = CodeAgent(
    tools=[sql_engine],
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen2.5-Coder-32B-Instruct&quot;</span>),
)

agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),ll=new gt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/text_to_sql.md"}}),{c(){T=M("meta"),el=n(),tl=M("p"),nl=n(),p(w.$$.fragment),al=n(),p(j.$$.fragment),Ml=n(),m=M("p"),m.innerHTML=Yl,ol=n(),b=M("blockquote"),b.innerHTML=Fl,il=n(),h=M("p"),h.textContent=zl,pl=n(),d=M("p"),d.textContent=Ll,yl=n(),C=M("p"),C.textContent=Dl,Ul=n(),I=M("p"),I.textContent=Pl,ul=n(),p(g.$$.fragment),rl=n(),f=M("p"),f.innerHTML=Kl,Jl=n(),p(B.$$.fragment),cl=n(),Q=M("p"),Q.textContent=Ol,Tl=n(),p(q.$$.fragment),wl=n(),p(v.$$.fragment),jl=n(),Z=M("p"),Z.textContent=lt,ml=n(),W=M("p"),W.textContent=tt,bl=n(),p(S.$$.fragment),hl=n(),p(G.$$.fragment),dl=n(),_=M("p"),_.innerHTML=st,Cl=n(),k=M("ul"),k.innerHTML=et,Il=n(),p(N.$$.fragment),gl=n(),R=M("p"),R.textContent=nt,fl=n(),A=M("p"),A.innerHTML=at,Bl=n(),E=M("p"),E.innerHTML=Mt,Ql=n(),p(V.$$.fragment),ql=n(),p(x.$$.fragment),vl=n(),X=M("p"),X.textContent=ot,Zl=n(),$=M("p"),$.textContent=it,Wl=n(),p(H.$$.fragment),Sl=n(),Y=M("p"),Y.innerHTML=pt,Gl=n(),p(F.$$.fragment),_l=n(),z=M("p"),z.innerHTML=yt,kl=n(),p(L.$$.fragment),Nl=n(),D=M("p"),D.textContent=Ut,Rl=n(),P=M("p"),P.textContent=ut,Al=n(),K=M("ul"),K.innerHTML=rt,El=n(),O=M("p"),O.textContent=Jt,Vl=n(),p(ll.$$.fragment),xl=n(),sl=M("p"),this.h()},l(l){const t=dt("svelte-u9bgzb",document.head);T=o(t,"META",{name:!0,content:!0}),t.forEach(s),el=a(l),tl=o(l,"P",{}),ct(tl).forEach(s),nl=a(l),y(w.$$.fragment,l),al=a(l),y(j.$$.fragment,l),Ml=a(l),m=o(l,"P",{"data-svelte-h":!0}),i(m)!=="svelte-1rrh2b0"&&(m.innerHTML=Yl),ol=a(l),b=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(b)!=="svelte-1yhwgse"&&(b.innerHTML=Fl),il=a(l),h=o(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1hw7g6s"&&(h.textContent=zl),pl=a(l),d=o(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-i6rawm"&&(d.textContent=Ll),yl=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1tzrwc8"&&(C.textContent=Dl),Ul=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-16cuoal"&&(I.textContent=Pl),ul=a(l),y(g.$$.fragment,l),rl=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-14ije4u"&&(f.innerHTML=Kl),Jl=a(l),y(B.$$.fragment,l),cl=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-64yurm"&&(Q.textContent=Ol),Tl=a(l),y(q.$$.fragment,l),wl=a(l),y(v.$$.fragment,l),jl=a(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-fdu5cw"&&(Z.textContent=lt),ml=a(l),W=o(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-groxlc"&&(W.textContent=tt),bl=a(l),y(S.$$.fragment,l),hl=a(l),y(G.$$.fragment,l),dl=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-1snt6vj"&&(_.innerHTML=st),Cl=a(l),k=o(l,"UL",{"data-svelte-h":!0}),i(k)!=="svelte-idbd3h"&&(k.innerHTML=et),Il=a(l),y(N.$$.fragment,l),gl=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1t4r7cu"&&(R.textContent=nt),fl=a(l),A=o(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-sv1k2f"&&(A.innerHTML=at),Bl=a(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1kyyn07"&&(E.innerHTML=Mt),Ql=a(l),y(V.$$.fragment,l),ql=a(l),y(x.$$.fragment,l),vl=a(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-nr3fl7"&&(X.textContent=ot),Zl=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1ru0803"&&($.textContent=it),Wl=a(l),y(H.$$.fragment,l),Sl=a(l),Y=o(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-l5upel"&&(Y.innerHTML=pt),Gl=a(l),y(F.$$.fragment,l),_l=a(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1uns4lf"&&(z.innerHTML=yt),kl=a(l),y(L.$$.fragment,l),Nl=a(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1umn140"&&(D.textContent=Ut),Rl=a(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13g6phr"&&(P.textContent=ut),Al=a(l),K=o(l,"UL",{"data-svelte-h":!0}),i(K)!=="svelte-1pz5sot"&&(K.innerHTML=rt),El=a(l),O=o(l,"P",{"data-svelte-h":!0}),i(O)!=="svelte-bt1f1w"&&(O.textContent=Jt),Vl=a(l),y(ll.$$.fragment,l),xl=a(l),sl=o(l,"P",{}),ct(sl).forEach(s),this.h()},h(){Tt(T,"name","hf:doc:metadata"),Tt(T,"content",Bt)},m(l,t){Ct(document.head,T),e(l,el,t),e(l,tl,t),e(l,nl,t),U(w,l,t),e(l,al,t),U(j,l,t),e(l,Ml,t),e(l,m,t),e(l,ol,t),e(l,b,t),e(l,il,t),e(l,h,t),e(l,pl,t),e(l,d,t),e(l,yl,t),e(l,C,t),e(l,Ul,t),e(l,I,t),e(l,ul,t),U(g,l,t),e(l,rl,t),e(l,f,t),e(l,Jl,t),U(B,l,t),e(l,cl,t),e(l,Q,t),e(l,Tl,t),U(q,l,t),e(l,wl,t),U(v,l,t),e(l,jl,t),e(l,Z,t),e(l,ml,t),e(l,W,t),e(l,bl,t),U(S,l,t),e(l,hl,t),U(G,l,t),e(l,dl,t),e(l,_,t),e(l,Cl,t),e(l,k,t),e(l,Il,t),U(N,l,t),e(l,gl,t),e(l,R,t),e(l,fl,t),e(l,A,t),e(l,Bl,t),e(l,E,t),e(l,Ql,t),U(V,l,t),e(l,ql,t),U(x,l,t),e(l,vl,t),e(l,X,t),e(l,Zl,t),e(l,$,t),e(l,Wl,t),U(H,l,t),e(l,Sl,t),e(l,Y,t),e(l,Gl,t),U(F,l,t),e(l,_l,t),e(l,z,t),e(l,kl,t),U(L,l,t),e(l,Nl,t),e(l,D,t),e(l,Rl,t),e(l,P,t),e(l,Al,t),e(l,K,t),e(l,El,t),e(l,O,t),e(l,Vl,t),U(ll,l,t),e(l,xl,t),e(l,sl,t),Xl=!0},p:jt,i(l){Xl||(u(w.$$.fragment,l),u(j.$$.fragment,l),u(g.$$.fragment,l),u(B.$$.fragment,l),u(q.$$.fragment,l),u(v.$$.fragment,l),u(S.$$.fragment,l),u(G.$$.fragment,l),u(N.$$.fragment,l),u(V.$$.fragment,l),u(x.$$.fragment,l),u(H.$$.fragment,l),u(F.$$.fragment,l),u(L.$$.fragment,l),u(ll.$$.fragment,l),Xl=!0)},o(l){r(w.$$.fragment,l),r(j.$$.fragment,l),r(g.$$.fragment,l),r(B.$$.fragment,l),r(q.$$.fragment,l),r(v.$$.fragment,l),r(S.$$.fragment,l),r(G.$$.fragment,l),r(N.$$.fragment,l),r(V.$$.fragment,l),r(x.$$.fragment,l),r(H.$$.fragment,l),r(F.$$.fragment,l),r(L.$$.fragment,l),r(ll.$$.fragment,l),Xl=!1},d(l){l&&(s(el),s(tl),s(nl),s(al),s(Ml),s(m),s(ol),s(b),s(il),s(h),s(pl),s(d),s(yl),s(C),s(Ul),s(I),s(ul),s(rl),s(f),s(Jl),s(cl),s(Q),s(Tl),s(wl),s(jl),s(Z),s(ml),s(W),s(bl),s(hl),s(dl),s(_),s(Cl),s(k),s(Il),s(gl),s(R),s(fl),s(A),s(Bl),s(E),s(Ql),s(ql),s(vl),s(X),s(Zl),s($),s(Wl),s(Sl),s(Y),s(Gl),s(_l),s(z),s(kl),s(Nl),s(D),s(Rl),s(P),s(Al),s(K),s(El),s(O),s(Vl),s(xl),s(sl)),s(T),J(w,l),J(j,l),J(g,l),J(B,l),J(q,l),J(v,l),J(S,l),J(G,l),J(N,l),J(V,l),J(x,l),J(H,l),J(F,l),J(L,l),J(ll,l)}}}const Bt='{"title":"Text-to-SQL","local":"text-to-sql","sections":[{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":3},{"title":"Level 2: Table joins","local":"level-2-table-joins","sections":[],"depth":3}],"depth":1}';function Qt(Hl){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends bt{constructor(T){super(),ht(this,T,Qt,ft,wt,{})}}export{Gt as component};
