import{s as Ht,n as Ft,o as zt}from"../chunks/scheduler.9bc65507.js";import{S as Pt,i as Kt,g as n,s,u as d,A as Lt,h as r,f as t,c as o,j as p,v as M,y as h,k as i,o as c,a as l,w,d as y,t as m,x as u}from"../chunks/index.78c82d43.js";import{I as se}from"../chunks/IconCopyLink.bedaa44d.js";import{C as Z}from"../chunks/CodeBlock.48618ec2.js";function qt(dt){let f,Te,we,ge,J,C,ye,W,rt,oe,Mt="Distributed training with 🤗 Accelerate",Ue,G,wt='As models get bigger, parallelism has emerged as a strategy for training larger models on limited hardware and accelerating training speed by several orders of magnitude. At Hugging Face, we created the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a> library to help users easily train a 🤗 Transformers model on any type of distributed setup, whether it is multiple GPU’s on one machine or multiple GPU’s across several machines. In this tutorial, learn how to customize your native PyTorch training loop to enable training in a distributed environment.',Ce,v,$,me,X,st,ie,yt="Setup",$e,x,mt="Get started by installing 🤗 Accelerate:",Ie,Y,Ae,N,ut='Then import and create an <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> object. The <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/package_reference/accelerator#accelerate.Accelerator" rel="nofollow">Accelerator</a> will automatically detect your type of distributed setup and initialize all the necessary components for training. You don’t need to explicitly place your model on a device.',ke,E,Be,b,I,ue,S,ot,ce,ft="Prepare to accelerate",_e,V,Jt='The next step is to pass all the relevant training objects to the <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow">prepare</a> method. This includes your training and evaluation DataLoaders, a model and an optimizer:',Ze,R,We,j,A,fe,Q,it,pe,vt="Backward",Ge,H,bt='The last addition is to replace the typical <code>loss.backward()</code> in your training loop with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow">backward</a>method:',Xe,F,xe,z,jt="As you can see in the following code, you only need to add four additional lines of code to your training loop to enable distributed training!",Ye,P,Ne,T,k,Je,K,ct,he,Tt="Train",Ee,L,gt="Once you’ve added the relevant lines of code, launch your training in a script or a notebook like Colaboratory.",Se,g,B,ve,q,pt,de,Ut="Train with a script",Ve,D,Ct="If you are running your training from a script, run the following command to create and save a configuration file:",Re,O,Qe,ee,$t="Then launch your training with:",He,te,Fe,U,_,be,ae,ht,Me,It="Train with a notebook",ze,le,At='🤗 Accelerate can also run in a notebook if you’re planning on using Colaboratory’s TPUs. Wrap all the code responsible for training in a function, and pass it to <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a>:',Pe,ne,Ke,re,kt='For more information about 🤗 Accelerate and its rich features, refer to the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">documentation</a>.',Le,je,qe;return W=new se({}),X=new se({}),Y=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate"}}),E=new Z({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`}}),S=new se({}),R=new Z({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`}}),Q=new se({}),F=new Z({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`}}),P=new Z({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`}}),K=new se({}),q=new se({}),O=new Z({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),te=new Z({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py"}}),ae=new se({}),ne=new Z({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`}}),{c(){f=n("meta"),Te=s(),we=n("p"),ge=s(),J=n("h1"),C=n("a"),ye=n("span"),d(W.$$.fragment),rt=s(),oe=n("span"),oe.textContent=Mt,Ue=s(),G=n("p"),G.innerHTML=wt,Ce=s(),v=n("h2"),$=n("a"),me=n("span"),d(X.$$.fragment),st=s(),ie=n("span"),ie.textContent=yt,$e=s(),x=n("p"),x.textContent=mt,Ie=s(),d(Y.$$.fragment),Ae=s(),N=n("p"),N.innerHTML=ut,ke=s(),d(E.$$.fragment),Be=s(),b=n("h2"),I=n("a"),ue=n("span"),d(S.$$.fragment),ot=s(),ce=n("span"),ce.textContent=ft,_e=s(),V=n("p"),V.innerHTML=Jt,Ze=s(),d(R.$$.fragment),We=s(),j=n("h2"),A=n("a"),fe=n("span"),d(Q.$$.fragment),it=s(),pe=n("span"),pe.textContent=vt,Ge=s(),H=n("p"),H.innerHTML=bt,Xe=s(),d(F.$$.fragment),xe=s(),z=n("p"),z.textContent=jt,Ye=s(),d(P.$$.fragment),Ne=s(),T=n("h2"),k=n("a"),Je=n("span"),d(K.$$.fragment),ct=s(),he=n("span"),he.textContent=Tt,Ee=s(),L=n("p"),L.textContent=gt,Se=s(),g=n("h3"),B=n("a"),ve=n("span"),d(q.$$.fragment),pt=s(),de=n("span"),de.textContent=Ut,Ve=s(),D=n("p"),D.textContent=Ct,Re=s(),d(O.$$.fragment),Qe=s(),ee=n("p"),ee.textContent=$t,He=s(),d(te.$$.fragment),Fe=s(),U=n("h3"),_=n("a"),be=n("span"),d(ae.$$.fragment),ht=s(),Me=n("span"),Me.textContent=It,ze=s(),le=n("p"),le.innerHTML=At,Pe=s(),d(ne.$$.fragment),Ke=s(),re=n("p"),re.innerHTML=kt,Le=s(),je=n("p"),this.h()},l(e){const a=Lt("svelte-1phssyn",document.head);f=r(a,"META",{name:!0,content:!0}),a.forEach(t),Te=o(e),we=r(e,"P",{}),p(we).forEach(t),ge=o(e),J=r(e,"H1",{class:!0});var De=p(J);C=r(De,"A",{id:!0,class:!0,href:!0});var Bt=p(C);ye=r(Bt,"SPAN",{});var _t=p(ye);M(W.$$.fragment,_t),_t.forEach(t),Bt.forEach(t),rt=o(De),oe=r(De,"SPAN",{"data-svelte-h":!0}),h(oe)!=="svelte-qly37s"&&(oe.textContent=Mt),De.forEach(t),Ue=o(e),G=r(e,"P",{"data-svelte-h":!0}),h(G)!=="svelte-11mv690"&&(G.innerHTML=wt),Ce=o(e),v=r(e,"H2",{class:!0});var Oe=p(v);$=r(Oe,"A",{id:!0,class:!0,href:!0});var Zt=p($);me=r(Zt,"SPAN",{});var Wt=p(me);M(X.$$.fragment,Wt),Wt.forEach(t),Zt.forEach(t),st=o(Oe),ie=r(Oe,"SPAN",{"data-svelte-h":!0}),h(ie)!=="svelte-1bbncge"&&(ie.textContent=yt),Oe.forEach(t),$e=o(e),x=r(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1wyzwc5"&&(x.textContent=mt),Ie=o(e),M(Y.$$.fragment,e),Ae=o(e),N=r(e,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1bd4bcz"&&(N.innerHTML=ut),ke=o(e),M(E.$$.fragment,e),Be=o(e),b=r(e,"H2",{class:!0});var et=p(b);I=r(et,"A",{id:!0,class:!0,href:!0});var Gt=p(I);ue=r(Gt,"SPAN",{});var Xt=p(ue);M(S.$$.fragment,Xt),Xt.forEach(t),Gt.forEach(t),ot=o(et),ce=r(et,"SPAN",{"data-svelte-h":!0}),h(ce)!=="svelte-16z0qai"&&(ce.textContent=ft),et.forEach(t),_e=o(e),V=r(e,"P",{"data-svelte-h":!0}),h(V)!=="svelte-fn2ams"&&(V.innerHTML=Jt),Ze=o(e),M(R.$$.fragment,e),We=o(e),j=r(e,"H2",{class:!0});var tt=p(j);A=r(tt,"A",{id:!0,class:!0,href:!0});var xt=p(A);fe=r(xt,"SPAN",{});var Yt=p(fe);M(Q.$$.fragment,Yt),Yt.forEach(t),xt.forEach(t),it=o(tt),pe=r(tt,"SPAN",{"data-svelte-h":!0}),h(pe)!=="svelte-1hbv3ea"&&(pe.textContent=vt),tt.forEach(t),Ge=o(e),H=r(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1gf8t2e"&&(H.innerHTML=bt),Xe=o(e),M(F.$$.fragment,e),xe=o(e),z=r(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-tbmaal"&&(z.textContent=jt),Ye=o(e),M(P.$$.fragment,e),Ne=o(e),T=r(e,"H2",{class:!0});var at=p(T);k=r(at,"A",{id:!0,class:!0,href:!0});var Nt=p(k);Je=r(Nt,"SPAN",{});var Et=p(Je);M(K.$$.fragment,Et),Et.forEach(t),Nt.forEach(t),ct=o(at),he=r(at,"SPAN",{"data-svelte-h":!0}),h(he)!=="svelte-5arm0l"&&(he.textContent=Tt),at.forEach(t),Ee=o(e),L=r(e,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1bmx0kl"&&(L.textContent=gt),Se=o(e),g=r(e,"H3",{class:!0});var lt=p(g);B=r(lt,"A",{id:!0,class:!0,href:!0});var St=p(B);ve=r(St,"SPAN",{});var Vt=p(ve);M(q.$$.fragment,Vt),Vt.forEach(t),St.forEach(t),pt=o(lt),de=r(lt,"SPAN",{"data-svelte-h":!0}),h(de)!=="svelte-ozvdun"&&(de.textContent=Ut),lt.forEach(t),Ve=o(e),D=r(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-d65x2y"&&(D.textContent=Ct),Re=o(e),M(O.$$.fragment,e),Qe=o(e),ee=r(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-xc3fgn"&&(ee.textContent=$t),He=o(e),M(te.$$.fragment,e),Fe=o(e),U=r(e,"H3",{class:!0});var nt=p(U);_=r(nt,"A",{id:!0,class:!0,href:!0});var Rt=p(_);be=r(Rt,"SPAN",{});var Qt=p(be);M(ae.$$.fragment,Qt),Qt.forEach(t),Rt.forEach(t),ht=o(nt),Me=r(nt,"SPAN",{"data-svelte-h":!0}),h(Me)!=="svelte-1qgdybt"&&(Me.textContent=It),nt.forEach(t),ze=o(e),le=r(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-1aq1lpd"&&(le.innerHTML=At),Pe=o(e),M(ne.$$.fragment,e),Ke=o(e),re=r(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-5m2lvn"&&(re.innerHTML=kt),Le=o(e),je=r(e,"P",{}),p(je).forEach(t),this.h()},h(){i(f,"name","hf:doc:metadata"),i(f,"content",JSON.stringify(Dt)),i(C,"id","distributed-training-with-accelerate"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#distributed-training-with-accelerate"),i(J,"class","relative group"),i($,"id","setup"),i($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i($,"href","#setup"),i(v,"class","relative group"),i(I,"id","prepare-to-accelerate"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#prepare-to-accelerate"),i(b,"class","relative group"),i(A,"id","backward"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#backward"),i(j,"class","relative group"),i(k,"id","train"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#train"),i(T,"class","relative group"),i(B,"id","train-with-a-script"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#train-with-a-script"),i(g,"class","relative group"),i(_,"id","train-with-a-notebook"),i(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(_,"href","#train-with-a-notebook"),i(U,"class","relative group")},m(e,a){c(document.head,f),l(e,Te,a),l(e,we,a),l(e,ge,a),l(e,J,a),c(J,C),c(C,ye),w(W,ye,null),c(J,rt),c(J,oe),l(e,Ue,a),l(e,G,a),l(e,Ce,a),l(e,v,a),c(v,$),c($,me),w(X,me,null),c(v,st),c(v,ie),l(e,$e,a),l(e,x,a),l(e,Ie,a),w(Y,e,a),l(e,Ae,a),l(e,N,a),l(e,ke,a),w(E,e,a),l(e,Be,a),l(e,b,a),c(b,I),c(I,ue),w(S,ue,null),c(b,ot),c(b,ce),l(e,_e,a),l(e,V,a),l(e,Ze,a),w(R,e,a),l(e,We,a),l(e,j,a),c(j,A),c(A,fe),w(Q,fe,null),c(j,it),c(j,pe),l(e,Ge,a),l(e,H,a),l(e,Xe,a),w(F,e,a),l(e,xe,a),l(e,z,a),l(e,Ye,a),w(P,e,a),l(e,Ne,a),l(e,T,a),c(T,k),c(k,Je),w(K,Je,null),c(T,ct),c(T,he),l(e,Ee,a),l(e,L,a),l(e,Se,a),l(e,g,a),c(g,B),c(B,ve),w(q,ve,null),c(g,pt),c(g,de),l(e,Ve,a),l(e,D,a),l(e,Re,a),w(O,e,a),l(e,Qe,a),l(e,ee,a),l(e,He,a),w(te,e,a),l(e,Fe,a),l(e,U,a),c(U,_),c(_,be),w(ae,be,null),c(U,ht),c(U,Me),l(e,ze,a),l(e,le,a),l(e,Pe,a),w(ne,e,a),l(e,Ke,a),l(e,re,a),l(e,Le,a),l(e,je,a),qe=!0},p:Ft,i(e){qe||(y(W.$$.fragment,e),y(X.$$.fragment,e),y(Y.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(R.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(q.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),qe=!0)},o(e){m(W.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(S.$$.fragment,e),m(R.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),qe=!1},d(e){e&&(t(Te),t(we),t(ge),t(J),t(Ue),t(G),t(Ce),t(v),t($e),t(x),t(Ie),t(Ae),t(N),t(ke),t(Be),t(b),t(_e),t(V),t(Ze),t(We),t(j),t(Ge),t(H),t(Xe),t(xe),t(z),t(Ye),t(Ne),t(T),t(Ee),t(L),t(Se),t(g),t(Ve),t(D),t(Re),t(Qe),t(ee),t(He),t(Fe),t(U),t(ze),t(le),t(Pe),t(Ke),t(re),t(Le),t(je)),t(f),u(W),u(X),u(Y,e),u(E,e),u(S),u(R,e),u(Q),u(F,e),u(P,e),u(K),u(q),u(O,e),u(te,e),u(ae),u(ne,e)}}}const Dt={local:"distributed-training-with-accelerate",sections:[{local:"setup",title:"Setup"},{local:"prepare-to-accelerate",title:"Prepare to accelerate"},{local:"backward",title:"Backward"},{local:"train",sections:[{local:"train-with-a-script",title:"Train with a script"},{local:"train-with-a-notebook",title:"Train with a notebook"}],title:"Train"}],title:"Distributed training with 🤗 Accelerate"};function Ot(dt){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class na extends Pt{constructor(f){super(),Kt(this,f,Ot,qt,Ht,{})}}export{na as component};
