import{s as Ns,o as Zs,n as Qn}from"../chunks/scheduler.182ea377.js";import{S as Es,i as Cs,g as a,s as n,r as c,A as Ss,h as i,f as o,c as s,j as M,u as m,x as _,k as v,y as t,a as I,v as g,d as f,t as u,w as h}from"../chunks/index.abf12888.js";import{T as Ds}from"../chunks/Tip.230e2334.js";import{D as y}from"../chunks/Docstring.93f6f462.js";import{C as Ls}from"../chunks/CodeBlock.57fe6e13.js";import{E as Us}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Xt}from"../chunks/Heading.16916d63.js";function $s(C){let b,U='Make sure to check out the Stable Diffusion <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/overview#tips" rel="nofollow">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality and how to reuse pipeline components efficiently!',x,T,J='If you want to use one of the official checkpoints for a task, explore the <a href="https://huggingface.co/gligen" rel="nofollow">gligen</a> Hub organizations!';return{c(){b=a("p"),b.innerHTML=U,x=n(),T=a("p"),T.innerHTML=J},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-v9h8gm"&&(b.innerHTML=U),x=s(l),T=i(l,"P",{"data-svelte-h":!0}),_(T)!=="svelte-9ek9ww"&&(T.innerHTML=J)},m(l,j){I(l,b,j),I(l,x,j),I(l,T,j)},p:Qn,d(l){l&&(o(b),o(x),o(T))}}}function ks(C){let b,U="Examples:",x,T,J;return T=new Ls({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-inpainting-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a birthday cake&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.6088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a birthday cake&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-inpainting-text-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;masterful/gligen-1-4-generation-text-box&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a waterfall and a modern high speed train running through the tunnel in a beautiful forest with fall foliage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.1387</span>, <span class="hljs-number">0.2051</span>, <span class="hljs-number">0.4277</span>, <span class="hljs-number">0.7090</span>], [<span class="hljs-number">0.4980</span>, <span class="hljs-number">0.4355</span>, <span class="hljs-number">0.8516</span>, <span class="hljs-number">0.7266</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;a waterfall&quot;</span>, <span class="hljs-string">&quot;a modern high speed train running through the tunnel&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-1-4-generation-text-box.jpg&quot;</span>)`,wrap:!1}}),{c(){b=a("p"),b.textContent=U,x=n(),c(T.$$.fragment)},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-kvfsh7"&&(b.textContent=U),x=s(l),m(T.$$.fragment,l)},m(l,j){I(l,b,j),I(l,x,j),g(T,l,j),J=!0},p:Qn,i(l){J||(f(T.$$.fragment,l),J=!0)},o(l){u(T.$$.fragment,l),J=!1},d(l){l&&(o(b),o(x)),h(T,l)}}}function Ps(C){let b,U="Examples:",x,T,J;return T=new Ls({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionGLIGENTextImagePipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Insert objects described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Inpainting_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>input_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/livingroom_modern.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a backpack&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.2676</span>, <span class="hljs-number">0.4088</span>, <span class="hljs-number">0.4773</span>, <span class="hljs-number">0.7183</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = <span class="hljs-literal">None</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/backpack.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_inpaint_image=input_image,
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-inpainting-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># insert objects described by text and image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a flower sitting on the beach&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.0</span>, <span class="hljs-number">0.09</span>, <span class="hljs-number">0.53</span>, <span class="hljs-number">0.76</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>phrases = [<span class="hljs-string">&quot;flower&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gligen/pexels-pixabay-60597.jpg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=phrases,
<span class="hljs-meta">... </span>    gligen_images=[gligen_image],
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box.jpg&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate an image described by the prompt and</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># transfer style described by image at the region defined by bounding boxes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionGLIGENTextImagePipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;anhnct/Gligen_Text_Image&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a dragon flying on the sky&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[<span class="hljs-number">0.4</span>, <span class="hljs-number">0.2</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>], [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]]  <span class="hljs-comment"># Set \`[0.0, 1.0, 0.0, 1.0]\` for the style</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gligen_placeholder = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    gligen_phrases=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;dragon&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;placeholder&quot;</span>,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any text instead of \`placeholder\` token, because we will use mask here</span>
<span class="hljs-meta">... </span>    gligen_images=[
<span class="hljs-meta">... </span>        gligen_placeholder,
<span class="hljs-meta">... </span>        gligen_image,
<span class="hljs-meta">... </span>    ],  <span class="hljs-comment"># Can use any image in gligen_placeholder, because we will use mask here</span>
<span class="hljs-meta">... </span>    input_phrases_mask=[<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],  <span class="hljs-comment"># Set 0 for the placeholder token</span>
<span class="hljs-meta">... </span>    input_images_mask=[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>],  <span class="hljs-comment"># Set 0 for the placeholder image</span>
<span class="hljs-meta">... </span>    gligen_boxes=boxes,
<span class="hljs-meta">... </span>    gligen_scheduled_sampling_beta=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;./gligen-generation-text-image-box-style-transfer.jpg&quot;</span>)`,wrap:!1}}),{c(){b=a("p"),b.textContent=U,x=n(),c(T.$$.fragment)},l(l){b=i(l,"P",{"data-svelte-h":!0}),_(b)!=="svelte-kvfsh7"&&(b.textContent=U),x=s(l),m(T.$$.fragment,l)},m(l,j){I(l,b,j),I(l,x,j),g(T,l,j),J=!0},p:Qn,i(l){J||(f(T.$$.fragment,l),J=!0)},o(l){u(T.$$.fragment,l),J=!1},d(l){l&&(o(b),o(x)),h(T,l)}}}function Ws(C){let b,U,x,T,J,l,j,Hn='The GLIGEN model was created by researchers and engineers from <a href="https://github.com/gligen/GLIGEN" rel="nofollow">University of Wisconsin-Madison, Columbia University, and Microsoft</a>. The <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> and <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can generate photorealistic images conditioned on grounding inputs. Along with text and bounding boxes with <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a>, if input images are given, <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> can insert objects described by text at the region defined by bounding boxes. Otherwise, it’ll generate an image described by the caption/prompt and insert objects described by text at the region defined by bounding boxes. It’s trained on COCO2014D and COCO2014CD datasets, and the model uses a frozen CLIP ViT-L/14 text encoder to condition itself on grounding inputs.',ht,se,Fn='The abstract from the <a href="https://huggingface.co/papers/2301.07093" rel="nofollow">paper</a> is:',_t,ae,qn="<em>Large-scale text-to-image diffusion models have made amazing advances. However, the status quo is to use text input alone, which can impede controllability. In this work, we propose GLIGEN, Grounded-Language-to-Image Generation, a novel approach that builds upon and extends the functionality of existing pre-trained text-to-image diffusion models by enabling them to also be conditioned on grounding inputs. To preserve the vast concept knowledge of the pre-trained model, we freeze all of its weights and inject the grounding information into new trainable layers via a gated mechanism. Our model achieves open-world grounded text2img generation with caption and bounding box condition inputs, and the grounding ability generalizes well to novel spatial configurations and concepts. GLIGEN’s zeroshot performance on COCO and LVIS outperforms existing supervised layout-to-image baselines by a large margin.</em>",bt,S,Mt,ie,On='<a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENPipeline">StableDiffusionGLIGENPipeline</a> was contributed by <a href="https://github.com/nikhil-masterful" rel="nofollow">Nikhil Gajendrakumar</a> and <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline">StableDiffusionGLIGENTextImagePipeline</a> was contributed by <a href="https://github.com/tuanh123789" rel="nofollow">Nguyễn Công Tú Anh</a>.',vt,oe,It,w,le,Qt,ke,Kn="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",Ht,Pe,es=`This model inherits from <a href="/docs/diffusers/v0.27.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,Ft,L,re,qt,We,ts="The call function to the pipeline for generation.",Ot,D,Kt,$,pe,en,Be,ns=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,tn,k,de,nn,Ve,ss=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,sn,P,ce,an,Ae,as=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,on,W,me,ln,Re,is=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,rn,B,ge,pn,ze,os=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,dn,Ye,fe,cn,Xe,ue,mn,V,he,gn,Qe,ls="Encodes the prompt into text encoder hidden states.",wt,_e,Tt,r,be,fn,He,rs="Pipeline for text-to-image generation using Stable Diffusion with Grounded-Language-to-Image Generation (GLIGEN).",un,Fe,ps=`This model inherits from <a href="/docs/diffusers/v0.27.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.).`,hn,N,Me,_n,qe,ds="The call function to the pipeline for generation.",bn,A,Mn,R,ve,vn,Oe,cs=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,In,z,Ie,wn,Ke,ms=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Tn,Y,we,yn,et,gs=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,Gn,X,Te,xn,tt,fs=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Jn,Q,ye,jn,nt,us=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Un,st,Ge,Ln,at,xe,Nn,H,Je,Zn,it,hs=`Based on the input mask corresponding value <code>0 or 1</code> for each phrases and image, mask the features
corresponding to phrases and images.`,En,F,je,Cn,ot,_s="Crop the input image to the specified dimensions.",Sn,q,Ue,Dn,lt,bs=`Create an inpainting mask based on given boxes. This function generates an inpainting mask using the provided
boxes to mark regions that need to be inpainted.`,$n,O,Le,kn,rt,Ms="Encodes the prompt into text encoder hidden states.",Pn,K,Ne,Wn,pt,vs=`Get image and phrases embedding by using CLIP pretrain model. The image embedding is transformed into the
phrases embedding space through a projection.`,Bn,ee,Ze,Vn,dt,Is=`Prepare the cross-attention kwargs containing information about the grounded input (boxes, mask, image
embedding, phrases embedding).`,An,te,Ee,Rn,ct,ws=`Prepare the cross-attention kwargs without information about the grounded input (boxes, mask, image embedding,
phrases embedding) (All are zero tensor).`,zn,ne,Ce,Yn,mt,Ts="Crop and resize the image to the target size while keeping the center.",yt,Se,Gt,Z,De,Xn,gt,ys="Output class for Stable Diffusion pipelines.",xt,ut,Jt;return J=new Xt({props:{title:"GLIGEN (Grounded Language-to-Image Generation)",local:"gligen-grounded-language-to-image-generation",headingTag:"h1"}}),S=new Ds({props:{$$slots:{default:[$s]},$$scope:{ctx:C}}}),oe=new Xt({props:{title:"StableDiffusionGLIGENPipeline",local:"diffusers.StableDiffusionGLIGENPipeline",headingTag:"h2"}}),le=new y({props:{name:"class diffusers.StableDiffusionGLIGENPipeline",anchor:"diffusers.StableDiffusionGLIGENPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L102"}}),re=new y({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L522",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),D=new Us({props:{anchor:"diffusers.StableDiffusionGLIGENPipeline.__call__.example",$$slots:{default:[ks]},$$scope:{ctx:C}}}),pe=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),de=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),ce=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1673"}}),me=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1681"}}),ge=new y({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L942"}}),fe=new y({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENPipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L478"}}),ue=new y({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENPipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L495"}}),he=new y({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen.py#L209"}}),_e=new Xt({props:{title:"StableDiffusionGLIGENTextImagePipeline",local:"diffusers.StableDiffusionGLIGENTextImagePipeline",headingTag:"h2"}}),be=new y({props:{name:"class diffusers.StableDiffusionGLIGENTextImagePipeline",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"processor",val:": CLIPProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"image_project",val:": CLIPImageProjection"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPFeatureExtractor"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.27.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.processor",description:`<strong>processor</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPProcessor" rel="nofollow">CLIPProcessor</a>) &#x2014;
A <code>CLIPProcessor</code> to procces reference image.`,name:"processor"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_encoder",description:`<strong>image_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>) &#x2014;
Frozen image-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"image_encoder"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.image_project",description:`<strong>image_project</strong> (<code>CLIPImageProjection</code>) &#x2014;
A <code>CLIPImageProjection</code> to project image embedding into phrases embedding space.`,name:"image_project"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.27.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.27.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/v0.27.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.27.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.27.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L148"}}),Me=new y({props:{name:"__call__",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 7.5"},{name:"gligen_scheduled_sampling_beta",val:": float = 0.3"},{name:"gligen_phrases",val:": List = None"},{name:"gligen_images",val:": List = None"},{name:"input_phrases_mask",val:": Union = None"},{name:"input_images_mask",val:": Union = None"},{name:"gligen_boxes",val:": List = None"},{name:"gligen_inpaint_image",val:": Optional = None"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"gligen_normalize_constant",val:": float = 28.7"},{name:"clip_skip",val:": int = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_phrases",description:`<strong>gligen_phrases</strong> (<code>List[str]</code>) &#x2014;
The phrases to guide what to include in each of the regions defined by the corresponding
<code>gligen_boxes</code>. There should only be one phrase per bounding box.`,name:"gligen_phrases"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_images",description:`<strong>gligen_images</strong> (<code>List[PIL.Image.Image]</code>) &#x2014;
The images to guide what to include in each of the regions defined by the corresponding <code>gligen_boxes</code>.
There should only be one image per bounding box`,name:"gligen_images"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_phrases_mask",description:`<strong>input_phrases_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre phrases mask input defined by the correspongding <code>input_phrases_mask</code>`,name:"input_phrases_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.input_images_mask",description:`<strong>input_images_mask</strong> (<code>int</code> or <code>List[int]</code>) &#x2014;
pre images mask input defined by the correspongding <code>input_images_mask</code>`,name:"input_images_mask"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_boxes",description:`<strong>gligen_boxes</strong> (<code>List[List[float]]</code>) &#x2014;
The bounding boxes that identify rectangular regions of the image that are going to be filled with the
content described by the corresponding <code>gligen_phrases</code>. Each rectangular box is defined as a
<code>List[float]</code> of 4 elements <code>[xmin, ymin, xmax, ymax]</code> where each value is between [0,1].`,name:"gligen_boxes"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_inpaint_image",description:`<strong>gligen_inpaint_image</strong> (<code>PIL.Image.Image</code>, <em>optional</em>) &#x2014;
The input image, if provided, is inpainted with objects described by the <code>gligen_boxes</code> and
<code>gligen_phrases</code>. Otherwise, it is treated as a generation task on a blank input image.`,name:"gligen_inpaint_image"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_scheduled_sampling_beta",description:`<strong>gligen_scheduled_sampling_beta</strong> (<code>float</code>, defaults to 0.3) &#x2014;
Scheduled Sampling factor from <a href="https://arxiv.org/pdf/2301.07093.pdf" rel="nofollow">GLIGEN: Open-Set Grounded Text-to-Image
Generation</a>. Scheduled Sampling factor is only varied for
scheduled sampling during inference for improved quality and controllability.`,name:"gligen_scheduled_sampling_beta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.27.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.gligen_normalize_constant",description:`<strong>gligen_normalize_constant</strong> (<code>float</code>, <em>optional</em>, defaults to 28.7) &#x2014;
The normalize value of the image embedding.`,name:"gligen_normalize_constant"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L683",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.27.0/en/api/pipelines/stable_diffusion/inpaint#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),A=new Us({props:{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.__call__.example",$$slots:{default:[Ps]},$$scope:{ctx:C}}}),ve=new y({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1659"}}),Ie=new y({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1666"}}),we=new y({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1673"}}),Te=new y({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L1681"}}),ye=new y({props:{name:"enable_model_cpu_offload",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/pipeline_utils.py#L942"}}),Ge=new y({props:{name:"prepare_latents",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.prepare_latents",parameters:[{name:"batch_size",val:""},{name:"num_channels_latents",val:""},{name:"height",val:""},{name:"width",val:""},{name:"dtype",val:""},{name:"device",val:""},{name:"generator",val:""},{name:"latents",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L502"}}),xe=new y({props:{name:"enable_fuser",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.enable_fuser",parameters:[{name:"enabled",val:" = True"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L519"}}),Je=new y({props:{name:"complete_mask",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.complete_mask",parameters:[{name:"has_mask",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L556"}}),je=new y({props:{name:"crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.crop",parameters:[{name:"im",val:""},{name:"new_width",val:""},{name:"new_height",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L536"}}),Ue=new y({props:{name:"draw_inpaint_mask_from_boxes",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.draw_inpaint_mask_from_boxes",parameters:[{name:"boxes",val:""},{name:"size",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L524"}}),Le=new y({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L234"}}),Ne=new y({props:{name:"get_clip_feature",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_clip_feature",parameters:[{name:"input",val:""},{name:"normalize_constant",val:""},{name:"device",val:""},{name:"is_image",val:" = False"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L572"}}),Ze=new y({props:{name:"get_cross_attention_kwargs_with_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_with_grounded",parameters:[{name:"hidden_size",val:""},{name:"gligen_phrases",val:""},{name:"gligen_images",val:""},{name:"gligen_boxes",val:""},{name:"input_phrases_mask",val:""},{name:"input_images_mask",val:""},{name:"repeat_batch",val:""},{name:"normalize_constant",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L596"}}),Ee=new y({props:{name:"get_cross_attention_kwargs_without_grounded",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.get_cross_attention_kwargs_without_grounded",parameters:[{name:"hidden_size",val:""},{name:"repeat_batch",val:""},{name:"max_objs",val:""},{name:"device",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L660"}}),Ce=new y({props:{name:"target_size_center_crop",anchor:"diffusers.StableDiffusionGLIGENTextImagePipeline.target_size_center_crop",parameters:[{name:"im",val:""},{name:"new_hw",val:""}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion_gligen/pipeline_stable_diffusion_gligen_text_image.py#L547"}}),Se=new Xt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),De=new y({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/v0.27.0/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){b=a("meta"),U=n(),x=a("p"),T=n(),c(J.$$.fragment),l=n(),j=a("p"),j.innerHTML=Hn,ht=n(),se=a("p"),se.innerHTML=Fn,_t=n(),ae=a("p"),ae.innerHTML=qn,bt=n(),c(S.$$.fragment),Mt=n(),ie=a("p"),ie.innerHTML=On,vt=n(),c(oe.$$.fragment),It=n(),w=a("div"),c(le.$$.fragment),Qt=n(),ke=a("p"),ke.textContent=Kn,Ht=n(),Pe=a("p"),Pe.innerHTML=es,Ft=n(),L=a("div"),c(re.$$.fragment),qt=n(),We=a("p"),We.textContent=ts,Ot=n(),c(D.$$.fragment),Kt=n(),$=a("div"),c(pe.$$.fragment),en=n(),Be=a("p"),Be.textContent=ns,tn=n(),k=a("div"),c(de.$$.fragment),nn=n(),Ve=a("p"),Ve.innerHTML=ss,sn=n(),P=a("div"),c(ce.$$.fragment),an=n(),Ae=a("p"),Ae.textContent=as,on=n(),W=a("div"),c(me.$$.fragment),ln=n(),Re=a("p"),Re.innerHTML=is,rn=n(),B=a("div"),c(ge.$$.fragment),pn=n(),ze=a("p"),ze.innerHTML=os,dn=n(),Ye=a("div"),c(fe.$$.fragment),cn=n(),Xe=a("div"),c(ue.$$.fragment),mn=n(),V=a("div"),c(he.$$.fragment),gn=n(),Qe=a("p"),Qe.textContent=ls,wt=n(),c(_e.$$.fragment),Tt=n(),r=a("div"),c(be.$$.fragment),fn=n(),He=a("p"),He.textContent=rs,un=n(),Fe=a("p"),Fe.innerHTML=ps,hn=n(),N=a("div"),c(Me.$$.fragment),_n=n(),qe=a("p"),qe.textContent=ds,bn=n(),c(A.$$.fragment),Mn=n(),R=a("div"),c(ve.$$.fragment),vn=n(),Oe=a("p"),Oe.textContent=cs,In=n(),z=a("div"),c(Ie.$$.fragment),wn=n(),Ke=a("p"),Ke.innerHTML=ms,Tn=n(),Y=a("div"),c(we.$$.fragment),yn=n(),et=a("p"),et.textContent=gs,Gn=n(),X=a("div"),c(Te.$$.fragment),xn=n(),tt=a("p"),tt.innerHTML=fs,Jn=n(),Q=a("div"),c(ye.$$.fragment),jn=n(),nt=a("p"),nt.innerHTML=us,Un=n(),st=a("div"),c(Ge.$$.fragment),Ln=n(),at=a("div"),c(xe.$$.fragment),Nn=n(),H=a("div"),c(Je.$$.fragment),Zn=n(),it=a("p"),it.innerHTML=hs,En=n(),F=a("div"),c(je.$$.fragment),Cn=n(),ot=a("p"),ot.textContent=_s,Sn=n(),q=a("div"),c(Ue.$$.fragment),Dn=n(),lt=a("p"),lt.textContent=bs,$n=n(),O=a("div"),c(Le.$$.fragment),kn=n(),rt=a("p"),rt.textContent=Ms,Pn=n(),K=a("div"),c(Ne.$$.fragment),Wn=n(),pt=a("p"),pt.textContent=vs,Bn=n(),ee=a("div"),c(Ze.$$.fragment),Vn=n(),dt=a("p"),dt.textContent=Is,An=n(),te=a("div"),c(Ee.$$.fragment),Rn=n(),ct=a("p"),ct.textContent=ws,zn=n(),ne=a("div"),c(Ce.$$.fragment),Yn=n(),mt=a("p"),mt.textContent=Ts,yt=n(),c(Se.$$.fragment),Gt=n(),Z=a("div"),c(De.$$.fragment),Xn=n(),gt=a("p"),gt.textContent=ys,xt=n(),ut=a("p"),this.h()},l(e){const p=Ss("svelte-u9bgzb",document.head);b=i(p,"META",{name:!0,content:!0}),p.forEach(o),U=s(e),x=i(e,"P",{}),M(x).forEach(o),T=s(e),m(J.$$.fragment,e),l=s(e),j=i(e,"P",{"data-svelte-h":!0}),_(j)!=="svelte-mwjju8"&&(j.innerHTML=Hn),ht=s(e),se=i(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-uh0q2i"&&(se.innerHTML=Fn),_t=s(e),ae=i(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-5czwpf"&&(ae.innerHTML=qn),bt=s(e),m(S.$$.fragment,e),Mt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-uku6mc"&&(ie.innerHTML=On),vt=s(e),m(oe.$$.fragment,e),It=s(e),w=i(e,"DIV",{class:!0});var G=M(w);m(le.$$.fragment,G),Qt=s(G),ke=i(G,"P",{"data-svelte-h":!0}),_(ke)!=="svelte-gowtb8"&&(ke.textContent=Kn),Ht=s(G),Pe=i(G,"P",{"data-svelte-h":!0}),_(Pe)!=="svelte-19bda6r"&&(Pe.innerHTML=es),Ft=s(G),L=i(G,"DIV",{class:!0});var E=M(L);m(re.$$.fragment,E),qt=s(E),We=i(E,"P",{"data-svelte-h":!0}),_(We)!=="svelte-50j04k"&&(We.textContent=ts),Ot=s(E),m(D.$$.fragment,E),E.forEach(o),Kt=s(G),$=i(G,"DIV",{class:!0});var $e=M($);m(pe.$$.fragment,$e),en=s($e),Be=i($e,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-14bnrb6"&&(Be.textContent=ns),$e.forEach(o),tn=s(G),k=i(G,"DIV",{class:!0});var jt=M(k);m(de.$$.fragment,jt),nn=s(jt),Ve=i(jt,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-1s3c06i"&&(Ve.innerHTML=ss),jt.forEach(o),sn=s(G),P=i(G,"DIV",{class:!0});var Ut=M(P);m(ce.$$.fragment,Ut),an=s(Ut),Ae=i(Ut,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-1xwrf7t"&&(Ae.textContent=as),Ut.forEach(o),on=s(G),W=i(G,"DIV",{class:!0});var Lt=M(W);m(me.$$.fragment,Lt),ln=s(Lt),Re=i(Lt,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-pkn4ui"&&(Re.innerHTML=is),Lt.forEach(o),rn=s(G),B=i(G,"DIV",{class:!0});var Nt=M(B);m(ge.$$.fragment,Nt),pn=s(Nt),ze=i(Nt,"P",{"data-svelte-h":!0}),_(ze)!=="svelte-d7vywi"&&(ze.innerHTML=os),Nt.forEach(o),dn=s(G),Ye=i(G,"DIV",{class:!0});var Gs=M(Ye);m(fe.$$.fragment,Gs),Gs.forEach(o),cn=s(G),Xe=i(G,"DIV",{class:!0});var xs=M(Xe);m(ue.$$.fragment,xs),xs.forEach(o),mn=s(G),V=i(G,"DIV",{class:!0});var Zt=M(V);m(he.$$.fragment,Zt),gn=s(Zt),Qe=i(Zt,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-16q0ax1"&&(Qe.textContent=ls),Zt.forEach(o),G.forEach(o),wt=s(e),m(_e.$$.fragment,e),Tt=s(e),r=i(e,"DIV",{class:!0});var d=M(r);m(be.$$.fragment,d),fn=s(d),He=i(d,"P",{"data-svelte-h":!0}),_(He)!=="svelte-gowtb8"&&(He.textContent=rs),un=s(d),Fe=i(d,"P",{"data-svelte-h":!0}),_(Fe)!=="svelte-19bda6r"&&(Fe.innerHTML=ps),hn=s(d),N=i(d,"DIV",{class:!0});var ft=M(N);m(Me.$$.fragment,ft),_n=s(ft),qe=i(ft,"P",{"data-svelte-h":!0}),_(qe)!=="svelte-50j04k"&&(qe.textContent=ds),bn=s(ft),m(A.$$.fragment,ft),ft.forEach(o),Mn=s(d),R=i(d,"DIV",{class:!0});var Et=M(R);m(ve.$$.fragment,Et),vn=s(Et),Oe=i(Et,"P",{"data-svelte-h":!0}),_(Oe)!=="svelte-14bnrb6"&&(Oe.textContent=cs),Et.forEach(o),In=s(d),z=i(d,"DIV",{class:!0});var Ct=M(z);m(Ie.$$.fragment,Ct),wn=s(Ct),Ke=i(Ct,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-1s3c06i"&&(Ke.innerHTML=ms),Ct.forEach(o),Tn=s(d),Y=i(d,"DIV",{class:!0});var St=M(Y);m(we.$$.fragment,St),yn=s(St),et=i(St,"P",{"data-svelte-h":!0}),_(et)!=="svelte-1xwrf7t"&&(et.textContent=gs),St.forEach(o),Gn=s(d),X=i(d,"DIV",{class:!0});var Dt=M(X);m(Te.$$.fragment,Dt),xn=s(Dt),tt=i(Dt,"P",{"data-svelte-h":!0}),_(tt)!=="svelte-pkn4ui"&&(tt.innerHTML=fs),Dt.forEach(o),Jn=s(d),Q=i(d,"DIV",{class:!0});var $t=M(Q);m(ye.$$.fragment,$t),jn=s($t),nt=i($t,"P",{"data-svelte-h":!0}),_(nt)!=="svelte-d7vywi"&&(nt.innerHTML=us),$t.forEach(o),Un=s(d),st=i(d,"DIV",{class:!0});var Js=M(st);m(Ge.$$.fragment,Js),Js.forEach(o),Ln=s(d),at=i(d,"DIV",{class:!0});var js=M(at);m(xe.$$.fragment,js),js.forEach(o),Nn=s(d),H=i(d,"DIV",{class:!0});var kt=M(H);m(Je.$$.fragment,kt),Zn=s(kt),it=i(kt,"P",{"data-svelte-h":!0}),_(it)!=="svelte-z0y3an"&&(it.innerHTML=hs),kt.forEach(o),En=s(d),F=i(d,"DIV",{class:!0});var Pt=M(F);m(je.$$.fragment,Pt),Cn=s(Pt),ot=i(Pt,"P",{"data-svelte-h":!0}),_(ot)!=="svelte-11j7r65"&&(ot.textContent=_s),Pt.forEach(o),Sn=s(d),q=i(d,"DIV",{class:!0});var Wt=M(q);m(Ue.$$.fragment,Wt),Dn=s(Wt),lt=i(Wt,"P",{"data-svelte-h":!0}),_(lt)!=="svelte-9eocln"&&(lt.textContent=bs),Wt.forEach(o),$n=s(d),O=i(d,"DIV",{class:!0});var Bt=M(O);m(Le.$$.fragment,Bt),kn=s(Bt),rt=i(Bt,"P",{"data-svelte-h":!0}),_(rt)!=="svelte-16q0ax1"&&(rt.textContent=Ms),Bt.forEach(o),Pn=s(d),K=i(d,"DIV",{class:!0});var Vt=M(K);m(Ne.$$.fragment,Vt),Wn=s(Vt),pt=i(Vt,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-1hybt25"&&(pt.textContent=vs),Vt.forEach(o),Bn=s(d),ee=i(d,"DIV",{class:!0});var At=M(ee);m(Ze.$$.fragment,At),Vn=s(At),dt=i(At,"P",{"data-svelte-h":!0}),_(dt)!=="svelte-1f1gk5j"&&(dt.textContent=Is),At.forEach(o),An=s(d),te=i(d,"DIV",{class:!0});var Rt=M(te);m(Ee.$$.fragment,Rt),Rn=s(Rt),ct=i(Rt,"P",{"data-svelte-h":!0}),_(ct)!=="svelte-1tqrrzw"&&(ct.textContent=ws),Rt.forEach(o),zn=s(d),ne=i(d,"DIV",{class:!0});var zt=M(ne);m(Ce.$$.fragment,zt),Yn=s(zt),mt=i(zt,"P",{"data-svelte-h":!0}),_(mt)!=="svelte-gczl07"&&(mt.textContent=Ts),zt.forEach(o),d.forEach(o),yt=s(e),m(Se.$$.fragment,e),Gt=s(e),Z=i(e,"DIV",{class:!0});var Yt=M(Z);m(De.$$.fragment,Yt),Xn=s(Yt),gt=i(Yt,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-1qpjiuf"&&(gt.textContent=ys),Yt.forEach(o),xt=s(e),ut=i(e,"P",{}),M(ut).forEach(o),this.h()},h(){v(b,"name","hf:doc:metadata"),v(b,"content",Bs),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(r,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,b),I(e,U,p),I(e,x,p),I(e,T,p),g(J,e,p),I(e,l,p),I(e,j,p),I(e,ht,p),I(e,se,p),I(e,_t,p),I(e,ae,p),I(e,bt,p),g(S,e,p),I(e,Mt,p),I(e,ie,p),I(e,vt,p),g(oe,e,p),I(e,It,p),I(e,w,p),g(le,w,null),t(w,Qt),t(w,ke),t(w,Ht),t(w,Pe),t(w,Ft),t(w,L),g(re,L,null),t(L,qt),t(L,We),t(L,Ot),g(D,L,null),t(w,Kt),t(w,$),g(pe,$,null),t($,en),t($,Be),t(w,tn),t(w,k),g(de,k,null),t(k,nn),t(k,Ve),t(w,sn),t(w,P),g(ce,P,null),t(P,an),t(P,Ae),t(w,on),t(w,W),g(me,W,null),t(W,ln),t(W,Re),t(w,rn),t(w,B),g(ge,B,null),t(B,pn),t(B,ze),t(w,dn),t(w,Ye),g(fe,Ye,null),t(w,cn),t(w,Xe),g(ue,Xe,null),t(w,mn),t(w,V),g(he,V,null),t(V,gn),t(V,Qe),I(e,wt,p),g(_e,e,p),I(e,Tt,p),I(e,r,p),g(be,r,null),t(r,fn),t(r,He),t(r,un),t(r,Fe),t(r,hn),t(r,N),g(Me,N,null),t(N,_n),t(N,qe),t(N,bn),g(A,N,null),t(r,Mn),t(r,R),g(ve,R,null),t(R,vn),t(R,Oe),t(r,In),t(r,z),g(Ie,z,null),t(z,wn),t(z,Ke),t(r,Tn),t(r,Y),g(we,Y,null),t(Y,yn),t(Y,et),t(r,Gn),t(r,X),g(Te,X,null),t(X,xn),t(X,tt),t(r,Jn),t(r,Q),g(ye,Q,null),t(Q,jn),t(Q,nt),t(r,Un),t(r,st),g(Ge,st,null),t(r,Ln),t(r,at),g(xe,at,null),t(r,Nn),t(r,H),g(Je,H,null),t(H,Zn),t(H,it),t(r,En),t(r,F),g(je,F,null),t(F,Cn),t(F,ot),t(r,Sn),t(r,q),g(Ue,q,null),t(q,Dn),t(q,lt),t(r,$n),t(r,O),g(Le,O,null),t(O,kn),t(O,rt),t(r,Pn),t(r,K),g(Ne,K,null),t(K,Wn),t(K,pt),t(r,Bn),t(r,ee),g(Ze,ee,null),t(ee,Vn),t(ee,dt),t(r,An),t(r,te),g(Ee,te,null),t(te,Rn),t(te,ct),t(r,zn),t(r,ne),g(Ce,ne,null),t(ne,Yn),t(ne,mt),I(e,yt,p),g(Se,e,p),I(e,Gt,p),I(e,Z,p),g(De,Z,null),t(Z,Xn),t(Z,gt),I(e,xt,p),I(e,ut,p),Jt=!0},p(e,[p]){const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),S.$set(G);const E={};p&2&&(E.$$scope={dirty:p,ctx:e}),D.$set(E);const $e={};p&2&&($e.$$scope={dirty:p,ctx:e}),A.$set($e)},i(e){Jt||(f(J.$$.fragment,e),f(S.$$.fragment,e),f(oe.$$.fragment,e),f(le.$$.fragment,e),f(re.$$.fragment,e),f(D.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(ce.$$.fragment,e),f(me.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(A.$$.fragment,e),f(ve.$$.fragment,e),f(Ie.$$.fragment,e),f(we.$$.fragment,e),f(Te.$$.fragment,e),f(ye.$$.fragment,e),f(Ge.$$.fragment,e),f(xe.$$.fragment,e),f(Je.$$.fragment,e),f(je.$$.fragment,e),f(Ue.$$.fragment,e),f(Le.$$.fragment,e),f(Ne.$$.fragment,e),f(Ze.$$.fragment,e),f(Ee.$$.fragment,e),f(Ce.$$.fragment,e),f(Se.$$.fragment,e),f(De.$$.fragment,e),Jt=!0)},o(e){u(J.$$.fragment,e),u(S.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(D.$$.fragment,e),u(pe.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(Me.$$.fragment,e),u(A.$$.fragment,e),u(ve.$$.fragment,e),u(Ie.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(ye.$$.fragment,e),u(Ge.$$.fragment,e),u(xe.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(Le.$$.fragment,e),u(Ne.$$.fragment,e),u(Ze.$$.fragment,e),u(Ee.$$.fragment,e),u(Ce.$$.fragment,e),u(Se.$$.fragment,e),u(De.$$.fragment,e),Jt=!1},d(e){e&&(o(U),o(x),o(T),o(l),o(j),o(ht),o(se),o(_t),o(ae),o(bt),o(Mt),o(ie),o(vt),o(It),o(w),o(wt),o(Tt),o(r),o(yt),o(Gt),o(Z),o(xt),o(ut)),o(b),h(J,e),h(S,e),h(oe,e),h(le),h(re),h(D),h(pe),h(de),h(ce),h(me),h(ge),h(fe),h(ue),h(he),h(_e,e),h(be),h(Me),h(A),h(ve),h(Ie),h(we),h(Te),h(ye),h(Ge),h(xe),h(Je),h(je),h(Ue),h(Le),h(Ne),h(Ze),h(Ee),h(Ce),h(Se,e),h(De)}}}const Bs='{"title":"GLIGEN (Grounded Language-to-Image Generation)","local":"gligen-grounded-language-to-image-generation","sections":[{"title":"StableDiffusionGLIGENPipeline","local":"diffusers.StableDiffusionGLIGENPipeline","sections":[],"depth":2},{"title":"StableDiffusionGLIGENTextImagePipeline","local":"diffusers.StableDiffusionGLIGENTextImagePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Vs(C){return Zs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Es{constructor(b){super(),Cs(this,b,Vs,Ws,Ns,{})}}export{Fs as component};
