import{s as ms,o as fs,n as q}from"../chunks/scheduler.9bc65507.js";import{S as gs,i as _s,g as a,s as l,u as b,A as bs,h as r,f as n,c as i,j as g,v as y,y as m,k as u,o as t,a as h,w as v,d as T,t as w,x as k}from"../chunks/index.78c82d43.js";import{T as Ut}from"../chunks/Tip.87d55b76.js";import{D as L}from"../chunks/Docstring.f3d04bd2.js";import{C as Wt}from"../chunks/CodeBlock.48618ec2.js";import{I as K}from"../chunks/IconCopyLink.bedaa44d.js";import{E as It}from"../chunks/ExampleCodeBlock.872b014d.js";function ys(F){let o,f=`Falcon models were initially added to the Hugging Face Hub as custom code checkpoints. However, Falcon is now fully
supported in the Transformers library. If you fine-tuned a model from a custom code checkpoint, we recommend converting
your checkpoint to the new in-library format, as this should give significant improvements to stability and
performance, especially for generation, as well as removing the need to use <code>trust_remote_code=True</code>!`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-9k32i0"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function vs(F){let o,f="Example:",d,p,_;return p=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZhbGNvbk1vZGVsJTJDJTIwRmFsY29uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMHNtYWxsJTIwKDItbGF5ZXIpJTIwRmFsY29uJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBGYWxjb25Db25maWcobnVtX2hpZGRlbl9sYXllcnMlM0QyKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBzbWFsbCUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEZhbGNvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FalconModel, FalconConfig</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Initializing a small (2-layer) Falcon configuration</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">configuration = FalconConfig(num_hidden_layers=<span class="hljs-number">2</span>)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Initializing a model from the small configuration</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">model = FalconModel(configuration)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># Accessing the model configuration</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">configuration = model.config</span>`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function Ts(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function ws(F){let o,f="Example:",d,p,_;return p=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGYWxjb25Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEFtb2RlbCUyMCUzRCUyMEZhbGNvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconModel.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function ks(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function Ms(F){let o,f="Example:",d,p,_;return p=new Wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEFtb2RlbCUyMCUzRCUyMEZhbGNvbkZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForCausalLM.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function Fs(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function $s(F){let o,f="Example of single-label classification:",d,p,_;return p=new Wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KCkuaXRlbSgpJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-ykxpe4"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function Cs(F){let o,f="Example of multi-label classification:",d,p,_;return p=new Wt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEZhbGNvbkZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMHByb2JsZW1fdHlwZSUzRCUyMm11bHRpX2xhYmVsX2NsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmFuZ2UoMCUyQyUyMGxvZ2l0cy5zaGFwZSU1Qi0xJTVEKSU1QnRvcmNoLnNpZ21vaWQobG9naXRzKS5zcXVlZXplKGRpbSUzRDApJTIwJTNFJTIwMC41JTVEJTBBJTBBJTIzJTIwVG8lMjB0cmFpbiUyMGElMjBtb2RlbCUyMG9uJTIwJTYwbnVtX2xhYmVscyU2MCUyMGNsYXNzZXMlMkMlMjB5b3UlMjBjYW4lMjBwYXNzJTIwJTYwbnVtX2xhYmVscyUzRG51bV9sYWJlbHMlNjAlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQoLi4uKSU2MCUwQW51bV9sYWJlbHMlMjAlM0QlMjBsZW4obW9kZWwuY29uZmlnLmlkMmxhYmVsKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1l8e32d"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function xs(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function Js(F){let o,f="Example:",d,p,_;return p=new Wt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBGYWxjb25Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJSb2NrZXRrbmlnaHQxJTJGZmFsY29uLXJ3LTFiJTIyKSUwQW1vZGVsJTIwJTNEJTIwRmFsY29uRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyUm9ja2V0a25pZ2h0MSUyRmZhbGNvbi1ydy0xYiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUwQSUyMyUyME5vdGUlMjB0aGF0JTIwdG9rZW5zJTIwYXJlJTIwY2xhc3NpZmllZCUyMHJhdGhlciUyMHRoZW4lMjBpbnB1dCUyMHdvcmRzJTIwd2hpY2glMjBtZWFucyUyMHRoYXQlMEElMjMlMjB0aGVyZSUyMG1pZ2h0JTIwYmUlMjBtb3JlJTIwcHJlZGljdGVkJTIwdG9rZW4lMjBjbGFzc2VzJTIwdGhhbiUyMHdvcmRzLiUwQSUyMyUyME11bHRpcGxlJTIwdG9rZW4lMjBjbGFzc2VzJTIwbWlnaHQlMjBhY2NvdW50JTIwZm9yJTIwdGhlJTIwc2FtZSUyMHdvcmQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMjAlM0QlMjAlNUJtb2RlbC5jb25maWcuaWQybGFiZWwlNUJ0Lml0ZW0oKSU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVEJTVEJTBBJTBBbGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, FalconForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FalconForTokenClassification.from_pretrained(<span class="hljs-string">&quot;Rocketknight1/falcon-rw-1b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`}}),{c(){o=a("p"),o.textContent=f,d=l(),b(p.$$.fragment)},l(s){o=r(s,"P",{"data-svelte-h":!0}),m(o)!=="svelte-11lpom8"&&(o.textContent=f),d=i(s),y(p.$$.fragment,s)},m(s,M){h(s,o,M),h(s,d,M),v(p,s,M),_=!0},p:q,i(s){_||(T(p.$$.fragment,s),_=!0)},o(s){w(p.$$.fragment,s),_=!1},d(s){s&&(n(o),n(d)),k(p,s)}}}function js(F){let o,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){o=a("p"),o.innerHTML=f},l(d){o=r(d,"P",{"data-svelte-h":!0}),m(o)!=="svelte-fincs2"&&(o.innerHTML=f)},m(d,p){h(d,o,p)},p:q,d(d){d&&n(o)}}}function zs(F){let o,f,d,p,_,s,M,Me,Fo,De,Tn="Falcon",Dt,V,ee,Zt,Fe,$o,Ke,wn="Overview",Kt,$e,kn=`Falcon is a class of causal decoder-only models built by <a href="https://www.tii.ae/" rel="nofollow">TII</a>. The largest Falcon checkpoints
have been trained on &gt;=1T tokens of text, with a particular emphasis on the <a href="https://arxiv.org/abs/2306.01116" rel="nofollow">RefinedWeb</a>
corpus. They are made available under the Apache 2.0 license.`,eo,Ce,Mn=`Falcon’s architecture is modern and optimized for inference, with multi-query attention and support for efficient
attention variants like <code>FlashAttention</code>. Both ‘base’ models trained only as causal language models as well as
‘instruct’ models that have received further fine-tuning are available.`,to,xe,Fn=`Falcon models are (as of 2023) some of the largest and most powerful open-source language models,
and consistently rank highly in the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">OpenLLM leaderboard</a>.`,oo,P,te,Nt,Je,Co,et,$n="Converting custom checkpoints",no,oe,so,je,Cn=`You can convert custom code checkpoints to full Transformers checkpoints using the <code>convert_custom_code_checkpoint.py</code>
script located in the
<a href="https://github.com/huggingface/transformers/tree/main/src/transformers/models/falcon" rel="nofollow">Falcon model directory</a>
of the Transformers library. To use this script, simply call it with
<code>python convert_custom_code_checkpoint.py --checkpoint_dir my_model</code>. This will convert your checkpoint in-place, and
you can immediately load it from the directory afterwards with e.g. <code>from_pretrained()</code>. If your model hasn’t been
uploaded to the Hub, we recommend making a backup before attempting the conversion, just in case!`,ao,X,ne,qt,ze,xo,tt,xn="FalconConfig",ro,I,Ue,Jo,ot,Jn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconModel">FalconModel</a>. It is used to instantiate a Falcon
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/tiiuae/falcon-7b" rel="nofollow">tiiuae/falcon-7b</a> architecture.`,jo,nt,jn=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,zo,se,lo,Q,ae,Lt,Ie,Uo,st,zn="FalconModel",io,C,We,Io,at,Un="The bare Falcon Model transformer outputting raw hidden-states without any specific head on top.",Wo,rt,In=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Zo,lt,Wn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,No,W,Ze,qo,it,Zn='The <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconModel">FalconModel</a> forward method, overrides the <code>__call__</code> special method.',Lo,re,Ho,le,co,A,ie,Ht,Ne,Ro,ct,Nn="FalconForCausalLM",po,x,qe,Go,dt,qn="The Falcon Model transformer with a language modeling head on top (linear layer with weights tied to the input embeddings).",So,pt,Ln=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Bo,ht,Hn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Eo,Z,Le,Vo,ut,Rn='The <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconForCausalLM">FalconForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Po,ce,Xo,de,ho,Y,pe,Rt,He,Qo,mt,Gn="FalconForSequenceClassification",uo,$,Re,Ao,ft,Sn="The Falcon Model transformer with a sequence classification head on top (linear layer).",Yo,gt,Bn=`<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-1) do.`,Oo,_t,En=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Do,bt,Vn=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,Ko,yt,Pn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,en,z,Ge,tn,vt,Xn='The <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconForSequenceClassification">FalconForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',on,he,nn,ue,sn,me,mo,O,fe,Gt,Se,an,Tt,Qn="FalconForTokenClassification",fo,J,Be,rn,wt,An=`Falcon Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,ln,kt,Yn=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,cn,Mt,On=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,dn,N,Ee,pn,Ft,Dn='The <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconForTokenClassification">FalconForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',hn,ge,un,_e,go,D,be,St,Ve,mn,$t,Kn="FalconForQuestionAnswering",_o,j,Pe,fn,Ct,es=`The Falcon Model transformer with a span classification head on top for extractive question-answering tasks like
SQuAD (a linear layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,gn,xt,ts=`This model inherits from <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings etc.)`,_n,Jt,os=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bn,H,Xe,yn,jt,ns='The <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconForQuestionAnswering">FalconForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',vn,ye,bo,Bt,yo;return Me=new K({}),Fe=new K({}),Je=new K({}),oe=new Ut({props:{$$slots:{default:[ys]},$$scope:{ctx:F}}}),ze=new K({}),Ue=new L({props:{name:"class transformers.FalconConfig",anchor:"transformers.FalconConfig",parameters:[{name:"vocab_size",val:" = 65024"},{name:"hidden_size",val:" = 4544"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 71"},{name:"layer_norm_epsilon",val:" = 1e-05"},{name:"initializer_range",val:" = 0.02"},{name:"use_cache",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"num_kv_heads",val:" = None"},{name:"alibi",val:" = False"},{name:"new_decoder_architecture",val:" = False"},{name:"multi_query",val:" = True"},{name:"parallel_attn",val:" = True"},{name:"bias",val:" = False"},{name:"max_position_embeddings",val:" = 2048"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"bos_token_id",val:" = 11"},{name:"eos_token_id",val:" = 11"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FalconConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65024) &#x2014;
Vocabulary size of the Falcon model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconModel">FalconModel</a>`,name:"vocab_size"},{anchor:"transformers.FalconConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4544) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.FalconConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.FalconConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 71) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.FalconConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FalconConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models). Only relevant if
<code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.FalconConfig.layer_norm_epsilon",description:`<strong>layer_norm_epsilon</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_epsilon"},{anchor:"transformers.FalconConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for MLP layers.`,name:"hidden_dropout"},{anchor:"transformers.FalconConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for attention layers.`,name:"attention_dropout"},{anchor:"transformers.FalconConfig.num_kv_heads",description:`<strong>num_kv_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of key-value heads to use per attention layer. If unset, defaults to the same value as
<code>num_attention_heads</code>.`,name:"num_kv_heads"},{anchor:"transformers.FalconConfig.alibi",description:`<strong>alibi</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use ALiBi positional biases during self-attention.`,name:"alibi"},{anchor:"transformers.FalconConfig.new_decoder_architecture",description:`<strong>new_decoder_architecture</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the new (Falcon-40B) decoder architecture. If <code>True</code>, the <code>multi_query</code> and <code>parallel_attn</code>
arguments are ignored, as the new decoder always uses parallel attention.`,name:"new_decoder_architecture"},{anchor:"transformers.FalconConfig.multi_query",description:`<strong>multi_query</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use multi-query attention in the decoder. Ignored when <code>new_decoder_architecture</code> is <code>True</code>.`,name:"multi_query"},{anchor:"transformers.FalconConfig.parallel_attn",description:`<strong>parallel_attn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to compute attention in parallel with the feedforward layer. If False, they are consecutive
instead, as in the original Transformer architecture. Ignored when <code>new_decoder_architecture</code> is <code>True</code>.`,name:"parallel_attn"},{anchor:"transformers.FalconConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use bias on Linear layers.`,name:"bias"},{anchor:"transformers.FalconConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with, when <code>alibi</code> is <code>False</code>. Pretrained
Falcon models with RoPE support up to 2048 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.FalconConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.FalconConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be an float greater than 1. The expected format
is <code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalLLaMA/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.FalconConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 11) &#x2014;
The id of the &#x201C;beginning-of-sequence&#x201D; token.`,name:"bos_token_id"},{anchor:"transformers.FalconConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 11) &#x2014;
The id of the &#x201C;end-of-sequence&#x201D; token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/configuration_falcon.py#L32"}}),se=new It({props:{anchor:"transformers.FalconConfig.example",$$slots:{default:[vs]},$$scope:{ctx:F}}}),Ie=new K({}),We=new L({props:{name:"class transformers.FalconModel",anchor:"transformers.FalconModel",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L769"}}),Ze=new L({props:{name:"forward",anchor:"transformers.FalconModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FalconModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L828",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new Ut({props:{$$slots:{default:[Ts]},$$scope:{ctx:F}}}),le=new It({props:{anchor:"transformers.FalconModel.forward.example",$$slots:{default:[ws]},$$scope:{ctx:F}}}),Ne=new K({}),qe=new L({props:{name:"class transformers.FalconForCausalLM",anchor:"transformers.FalconForCausalLM",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L969"}}),Le=new L({props:{name:"forward",anchor:"transformers.FalconForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FalconForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1003",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Cross attentions weights after the attention softmax, used to compute the weighted average in the
cross-attention heads.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>torch.FloatTensor</code> tuples of length <code>config.n_layers</code>, with each tuple containing the cached key,
value states of the self-attention and the cross-attention layers if model is used in encoder-decoder
setting. Only relevant if <code>config.is_decoder = True</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithCrossAttentions"
>transformers.modeling_outputs.CausalLMOutputWithCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new Ut({props:{$$slots:{default:[ks]},$$scope:{ctx:F}}}),de=new It({props:{anchor:"transformers.FalconForCausalLM.forward.example",$$slots:{default:[Ms]},$$scope:{ctx:F}}}),He=new K({}),Re=new L({props:{name:"class transformers.FalconForSequenceClassification",anchor:"transformers.FalconForSequenceClassification",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1110"}}),Ge=new L({props:{name:"forward",anchor:"transformers.FalconForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FalconForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1120",returnDescription:`
<p>A <code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><code>transformers.modeling_outputs.SequenceClassifierOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Ut({props:{$$slots:{default:[Fs]},$$scope:{ctx:F}}}),ue=new It({props:{anchor:"transformers.FalconForSequenceClassification.forward.example",$$slots:{default:[$s]},$$scope:{ctx:F}}}),me=new It({props:{anchor:"transformers.FalconForSequenceClassification.forward.example-2",$$slots:{default:[Cs]},$$scope:{ctx:F}}}),Se=new K({}),Be=new L({props:{name:"class transformers.FalconForTokenClassification",anchor:"transformers.FalconForTokenClassification",parameters:[{name:"config",val:": FalconConfig"}],parametersDescription:[{anchor:"transformers.FalconForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1226"}}),Ee=new L({props:{name:"forward",anchor:"transformers.FalconForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FalconForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1244",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig"
>FalconConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Ut({props:{$$slots:{default:[xs]},$$scope:{ctx:F}}}),_e=new It({props:{anchor:"transformers.FalconForTokenClassification.forward.example",$$slots:{default:[Js]},$$scope:{ctx:F}}}),Ve=new K({}),Pe=new L({props:{name:"class transformers.FalconForQuestionAnswering",anchor:"transformers.FalconForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.FalconForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/falcon#transformers.FalconConfig">FalconConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1315"}}),Xe=new L({props:{name:"forward",anchor:"transformers.FalconForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.FalconForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, input_ids_length)</code>) &#x2014;
<code>input_ids_length</code> = <code>sequence_length</code> if <code>past_key_values</code> is <code>None</code> else <code>past_key_values[0][0].shape[2]</code>
(<code>sequence_length</code> of input past key value states). Indices of input sequence tokens in the vocabulary.</p>
<p>If <code>past_key_values</code> is used, only <code>input_ids</code> that do not have their past calculated should be passed as
<code>input_ids</code>.</p>
<p>Indices can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/v4.33.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FalconForQuestionAnswering.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Tuple[Tuple[torch.Tensor]]</code> of length <code>config.num_hidden_layers</code>) &#x2014;
Contains precomputed hidden-states (key and values in the attention blocks) as computed by the model (see
<code>past_key_values</code> output below). Can be used to speed up sequential decoding. The <code>input_ids</code> which have
their past given to this model should not be passed as <code>input_ids</code> as they have already been computed.</p>
<p>Each element of <code>past_key_values</code> is a tuple (past_key, past_value):</p>
<ul>
<li>past_key: [batch_size * num_heads, head_dim, kv_length]</li>
<li>past_value: [batch_size * num_heads, kv_length, head_dim]</li>
</ul>`,name:"past_key_values"},{anchor:"transformers.FalconForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.FalconForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.FalconForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>inputs_embeds</code> have to be input (see
<code>past_key_values</code>).`,name:"inputs_embeds"},{anchor:"transformers.FalconForQuestionAnswering.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FalconForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FalconForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FalconForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.33.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FalconForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.FalconForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/falcon/modeling_falcon.py#L1324"}}),ye=new Ut({props:{$$slots:{default:[js]},$$scope:{ctx:F}}}),{c(){o=a("meta"),f=l(),d=a("p"),p=l(),_=a("h1"),s=a("a"),M=a("span"),b(Me.$$.fragment),Fo=l(),De=a("span"),De.textContent=Tn,Dt=l(),V=a("h2"),ee=a("a"),Zt=a("span"),b(Fe.$$.fragment),$o=l(),Ke=a("span"),Ke.textContent=wn,Kt=l(),$e=a("p"),$e.innerHTML=kn,eo=l(),Ce=a("p"),Ce.innerHTML=Mn,to=l(),xe=a("p"),xe.innerHTML=Fn,oo=l(),P=a("h2"),te=a("a"),Nt=a("span"),b(Je.$$.fragment),Co=l(),et=a("span"),et.textContent=$n,no=l(),b(oe.$$.fragment),so=l(),je=a("p"),je.innerHTML=Cn,ao=l(),X=a("h2"),ne=a("a"),qt=a("span"),b(ze.$$.fragment),xo=l(),tt=a("span"),tt.textContent=xn,ro=l(),I=a("div"),b(Ue.$$.fragment),Jo=l(),ot=a("p"),ot.innerHTML=Jn,jo=l(),nt=a("p"),nt.innerHTML=jn,zo=l(),b(se.$$.fragment),lo=l(),Q=a("h2"),ae=a("a"),Lt=a("span"),b(Ie.$$.fragment),Uo=l(),st=a("span"),st.textContent=zn,io=l(),C=a("div"),b(We.$$.fragment),Io=l(),at=a("p"),at.textContent=Un,Wo=l(),rt=a("p"),rt.innerHTML=In,Zo=l(),lt=a("p"),lt.innerHTML=Wn,No=l(),W=a("div"),b(Ze.$$.fragment),qo=l(),it=a("p"),it.innerHTML=Zn,Lo=l(),b(re.$$.fragment),Ho=l(),b(le.$$.fragment),co=l(),A=a("h2"),ie=a("a"),Ht=a("span"),b(Ne.$$.fragment),Ro=l(),ct=a("span"),ct.textContent=Nn,po=l(),x=a("div"),b(qe.$$.fragment),Go=l(),dt=a("p"),dt.textContent=qn,So=l(),pt=a("p"),pt.innerHTML=Ln,Bo=l(),ht=a("p"),ht.innerHTML=Hn,Eo=l(),Z=a("div"),b(Le.$$.fragment),Vo=l(),ut=a("p"),ut.innerHTML=Rn,Po=l(),b(ce.$$.fragment),Xo=l(),b(de.$$.fragment),ho=l(),Y=a("h2"),pe=a("a"),Rt=a("span"),b(He.$$.fragment),Qo=l(),mt=a("span"),mt.textContent=Gn,uo=l(),$=a("div"),b(Re.$$.fragment),Ao=l(),ft=a("p"),ft.textContent=Sn,Yo=l(),gt=a("p"),gt.innerHTML=Bn,Oo=l(),_t=a("p"),_t.innerHTML=En,Do=l(),bt=a("p"),bt.innerHTML=Vn,Ko=l(),yt=a("p"),yt.innerHTML=Pn,en=l(),z=a("div"),b(Ge.$$.fragment),tn=l(),vt=a("p"),vt.innerHTML=Xn,on=l(),b(he.$$.fragment),nn=l(),b(ue.$$.fragment),sn=l(),b(me.$$.fragment),mo=l(),O=a("h2"),fe=a("a"),Gt=a("span"),b(Se.$$.fragment),an=l(),Tt=a("span"),Tt.textContent=Qn,fo=l(),J=a("div"),b(Be.$$.fragment),rn=l(),wt=a("p"),wt.textContent=An,ln=l(),kt=a("p"),kt.innerHTML=Yn,cn=l(),Mt=a("p"),Mt.innerHTML=On,dn=l(),N=a("div"),b(Ee.$$.fragment),pn=l(),Ft=a("p"),Ft.innerHTML=Dn,hn=l(),b(ge.$$.fragment),un=l(),b(_e.$$.fragment),go=l(),D=a("h2"),be=a("a"),St=a("span"),b(Ve.$$.fragment),mn=l(),$t=a("span"),$t.textContent=Kn,_o=l(),j=a("div"),b(Pe.$$.fragment),fn=l(),Ct=a("p"),Ct.innerHTML=es,gn=l(),xt=a("p"),xt.innerHTML=ts,_n=l(),Jt=a("p"),Jt.innerHTML=os,bn=l(),H=a("div"),b(Xe.$$.fragment),yn=l(),jt=a("p"),jt.innerHTML=ns,vn=l(),b(ye.$$.fragment),bo=l(),Bt=a("p"),this.h()},l(e){const c=bs("svelte-1phssyn",document.head);o=r(c,"META",{name:!0,content:!0}),c.forEach(n),f=i(e),d=r(e,"P",{}),g(d).forEach(n),p=i(e),_=r(e,"H1",{class:!0});var Qe=g(_);s=r(Qe,"A",{id:!0,class:!0,href:!0});var Et=g(s);M=r(Et,"SPAN",{});var Vt=g(M);y(Me.$$.fragment,Vt),Vt.forEach(n),Et.forEach(n),Fo=i(Qe),De=r(Qe,"SPAN",{"data-svelte-h":!0}),m(De)!=="svelte-1pc1vvm"&&(De.textContent=Tn),Qe.forEach(n),Dt=i(e),V=r(e,"H2",{class:!0});var Ae=g(V);ee=r(Ae,"A",{id:!0,class:!0,href:!0});var Pt=g(ee);Zt=r(Pt,"SPAN",{});var Xt=g(Zt);y(Fe.$$.fragment,Xt),Xt.forEach(n),Pt.forEach(n),$o=i(Ae),Ke=r(Ae,"SPAN",{"data-svelte-h":!0}),m(Ke)!=="svelte-1jsw1pg"&&(Ke.textContent=wn),Ae.forEach(n),Kt=i(e),$e=r(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-10avqgm"&&($e.innerHTML=kn),eo=i(e),Ce=r(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-yb5860"&&(Ce.innerHTML=Mn),to=i(e),xe=r(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-nzqfj1"&&(xe.innerHTML=Fn),oo=i(e),P=r(e,"H2",{class:!0});var Ye=g(P);te=r(Ye,"A",{id:!0,class:!0,href:!0});var Qt=g(te);Nt=r(Qt,"SPAN",{});var At=g(Nt);y(Je.$$.fragment,At),At.forEach(n),Qt.forEach(n),Co=i(Ye),et=r(Ye,"SPAN",{"data-svelte-h":!0}),m(et)!=="svelte-10f5w2"&&(et.textContent=$n),Ye.forEach(n),no=i(e),y(oe.$$.fragment,e),so=i(e),je=r(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1ct6uvq"&&(je.innerHTML=Cn),ao=i(e),X=r(e,"H2",{class:!0});var Oe=g(X);ne=r(Oe,"A",{id:!0,class:!0,href:!0});var Yt=g(ne);qt=r(Yt,"SPAN",{});var Ot=g(qt);y(ze.$$.fragment,Ot),Ot.forEach(n),Yt.forEach(n),xo=i(Oe),tt=r(Oe,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-y3ul0g"&&(tt.textContent=xn),Oe.forEach(n),ro=i(e),I=r(e,"DIV",{class:!0});var ve=g(I);y(Ue.$$.fragment,ve),Jo=i(ve),ot=r(ve,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-1i6sdhf"&&(ot.innerHTML=Jn),jo=i(ve),nt=r(ve,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-cfh5wl"&&(nt.innerHTML=jn),zo=i(ve),y(se.$$.fragment,ve),ve.forEach(n),lo=i(e),Q=r(e,"H2",{class:!0});var vo=g(Q);ae=r(vo,"A",{id:!0,class:!0,href:!0});var ss=g(ae);Lt=r(ss,"SPAN",{});var as=g(Lt);y(Ie.$$.fragment,as),as.forEach(n),ss.forEach(n),Uo=i(vo),st=r(vo,"SPAN",{"data-svelte-h":!0}),m(st)!=="svelte-127f73x"&&(st.textContent=zn),vo.forEach(n),io=i(e),C=r(e,"DIV",{class:!0});var R=g(C);y(We.$$.fragment,R),Io=i(R),at=r(R,"P",{"data-svelte-h":!0}),m(at)!=="svelte-13ll91i"&&(at.textContent=Un),Wo=i(R),rt=r(R,"P",{"data-svelte-h":!0}),m(rt)!=="svelte-1403dog"&&(rt.innerHTML=In),Zo=i(R),lt=r(R,"P",{"data-svelte-h":!0}),m(lt)!=="svelte-hswkmf"&&(lt.innerHTML=Wn),No=i(R),W=r(R,"DIV",{class:!0});var Te=g(W);y(Ze.$$.fragment,Te),qo=i(Te),it=r(Te,"P",{"data-svelte-h":!0}),m(it)!=="svelte-1rgfugo"&&(it.innerHTML=Zn),Lo=i(Te),y(re.$$.fragment,Te),Ho=i(Te),y(le.$$.fragment,Te),Te.forEach(n),R.forEach(n),co=i(e),A=r(e,"H2",{class:!0});var To=g(A);ie=r(To,"A",{id:!0,class:!0,href:!0});var rs=g(ie);Ht=r(rs,"SPAN",{});var ls=g(Ht);y(Ne.$$.fragment,ls),ls.forEach(n),rs.forEach(n),Ro=i(To),ct=r(To,"SPAN",{"data-svelte-h":!0}),m(ct)!=="svelte-oyd5al"&&(ct.textContent=Nn),To.forEach(n),po=i(e),x=r(e,"DIV",{class:!0});var G=g(x);y(qe.$$.fragment,G),Go=i(G),dt=r(G,"P",{"data-svelte-h":!0}),m(dt)!=="svelte-88v1u6"&&(dt.textContent=qn),So=i(G),pt=r(G,"P",{"data-svelte-h":!0}),m(pt)!=="svelte-1403dog"&&(pt.innerHTML=Ln),Bo=i(G),ht=r(G,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-hswkmf"&&(ht.innerHTML=Hn),Eo=i(G),Z=r(G,"DIV",{class:!0});var we=g(Z);y(Le.$$.fragment,we),Vo=i(we),ut=r(we,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1nk8yao"&&(ut.innerHTML=Rn),Po=i(we),y(ce.$$.fragment,we),Xo=i(we),y(de.$$.fragment,we),we.forEach(n),G.forEach(n),ho=i(e),Y=r(e,"H2",{class:!0});var wo=g(Y);pe=r(wo,"A",{id:!0,class:!0,href:!0});var is=g(pe);Rt=r(is,"SPAN",{});var cs=g(Rt);y(He.$$.fragment,cs),cs.forEach(n),is.forEach(n),Qo=i(wo),mt=r(wo,"SPAN",{"data-svelte-h":!0}),m(mt)!=="svelte-1m9o3ju"&&(mt.textContent=Gn),wo.forEach(n),uo=i(e),$=r(e,"DIV",{class:!0});var U=g($);y(Re.$$.fragment,U),Ao=i(U),ft=r(U,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-n3dntd"&&(ft.textContent=Sn),Yo=i(U),gt=r(U,"P",{"data-svelte-h":!0}),m(gt)!=="svelte-hunkw2"&&(gt.innerHTML=Bn),Oo=i(U),_t=r(U,"P",{"data-svelte-h":!0}),m(_t)!=="svelte-10ugs3m"&&(_t.innerHTML=En),Do=i(U),bt=r(U,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-1403dog"&&(bt.innerHTML=Vn),Ko=i(U),yt=r(U,"P",{"data-svelte-h":!0}),m(yt)!=="svelte-hswkmf"&&(yt.innerHTML=Pn),en=i(U),z=r(U,"DIV",{class:!0});var S=g(z);y(Ge.$$.fragment,S),tn=i(S),vt=r(S,"P",{"data-svelte-h":!0}),m(vt)!=="svelte-bmwfmg"&&(vt.innerHTML=Xn),on=i(S),y(he.$$.fragment,S),nn=i(S),y(ue.$$.fragment,S),sn=i(S),y(me.$$.fragment,S),S.forEach(n),U.forEach(n),mo=i(e),O=r(e,"H2",{class:!0});var ko=g(O);fe=r(ko,"A",{id:!0,class:!0,href:!0});var ds=g(fe);Gt=r(ds,"SPAN",{});var ps=g(Gt);y(Se.$$.fragment,ps),ps.forEach(n),ds.forEach(n),an=i(ko),Tt=r(ko,"SPAN",{"data-svelte-h":!0}),m(Tt)!=="svelte-p9rtca"&&(Tt.textContent=Qn),ko.forEach(n),fo=i(e),J=r(e,"DIV",{class:!0});var B=g(J);y(Be.$$.fragment,B),rn=i(B),wt=r(B,"P",{"data-svelte-h":!0}),m(wt)!=="svelte-1g0l4i2"&&(wt.textContent=An),ln=i(B),kt=r(B,"P",{"data-svelte-h":!0}),m(kt)!=="svelte-1403dog"&&(kt.innerHTML=Yn),cn=i(B),Mt=r(B,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-hswkmf"&&(Mt.innerHTML=On),dn=i(B),N=r(B,"DIV",{class:!0});var ke=g(N);y(Ee.$$.fragment,ke),pn=i(ke),Ft=r(ke,"P",{"data-svelte-h":!0}),m(Ft)!=="svelte-wo3csa"&&(Ft.innerHTML=Dn),hn=i(ke),y(ge.$$.fragment,ke),un=i(ke),y(_e.$$.fragment,ke),ke.forEach(n),B.forEach(n),go=i(e),D=r(e,"H2",{class:!0});var Mo=g(D);be=r(Mo,"A",{id:!0,class:!0,href:!0});var hs=g(be);St=r(hs,"SPAN",{});var us=g(St);y(Ve.$$.fragment,us),us.forEach(n),hs.forEach(n),mn=i(Mo),$t=r(Mo,"SPAN",{"data-svelte-h":!0}),m($t)!=="svelte-7mcsyz"&&($t.textContent=Kn),Mo.forEach(n),_o=i(e),j=r(e,"DIV",{class:!0});var E=g(j);y(Pe.$$.fragment,E),fn=i(E),Ct=r(E,"P",{"data-svelte-h":!0}),m(Ct)!=="svelte-1uae4ge"&&(Ct.innerHTML=es),gn=i(E),xt=r(E,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-1403dog"&&(xt.innerHTML=ts),_n=i(E),Jt=r(E,"P",{"data-svelte-h":!0}),m(Jt)!=="svelte-hswkmf"&&(Jt.innerHTML=os),bn=i(E),H=r(E,"DIV",{class:!0});var zt=g(H);y(Xe.$$.fragment,zt),yn=i(zt),jt=r(zt,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-1wtdoys"&&(jt.innerHTML=ns),vn=i(zt),y(ye.$$.fragment,zt),zt.forEach(n),E.forEach(n),bo=i(e),Bt=r(e,"P",{}),g(Bt).forEach(n),this.h()},h(){u(o,"name","hf:doc:metadata"),u(o,"content",JSON.stringify(Us)),u(s,"id","falcon"),u(s,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(s,"href","#falcon"),u(_,"class","relative group"),u(ee,"id","overview"),u(ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ee,"href","#overview"),u(V,"class","relative group"),u(te,"id","converting-custom-checkpoints"),u(te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(te,"href","#converting-custom-checkpoints"),u(P,"class","relative group"),u(ne,"id","transformers.FalconConfig"),u(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ne,"href","#transformers.FalconConfig"),u(X,"class","relative group"),u(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ae,"id","transformers.FalconModel"),u(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ae,"href","#transformers.FalconModel"),u(Q,"class","relative group"),u(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(ie,"id","transformers.FalconForCausalLM"),u(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(ie,"href","#transformers.FalconForCausalLM"),u(A,"class","relative group"),u(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(pe,"id","transformers.FalconForSequenceClassification"),u(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(pe,"href","#transformers.FalconForSequenceClassification"),u(Y,"class","relative group"),u(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(fe,"id","transformers.FalconForTokenClassification"),u(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(fe,"href","#transformers.FalconForTokenClassification"),u(O,"class","relative group"),u(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(be,"id","transformers.FalconForQuestionAnswering"),u(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(be,"href","#transformers.FalconForQuestionAnswering"),u(D,"class","relative group"),u(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),u(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,o),h(e,f,c),h(e,d,c),h(e,p,c),h(e,_,c),t(_,s),t(s,M),v(Me,M,null),t(_,Fo),t(_,De),h(e,Dt,c),h(e,V,c),t(V,ee),t(ee,Zt),v(Fe,Zt,null),t(V,$o),t(V,Ke),h(e,Kt,c),h(e,$e,c),h(e,eo,c),h(e,Ce,c),h(e,to,c),h(e,xe,c),h(e,oo,c),h(e,P,c),t(P,te),t(te,Nt),v(Je,Nt,null),t(P,Co),t(P,et),h(e,no,c),v(oe,e,c),h(e,so,c),h(e,je,c),h(e,ao,c),h(e,X,c),t(X,ne),t(ne,qt),v(ze,qt,null),t(X,xo),t(X,tt),h(e,ro,c),h(e,I,c),v(Ue,I,null),t(I,Jo),t(I,ot),t(I,jo),t(I,nt),t(I,zo),v(se,I,null),h(e,lo,c),h(e,Q,c),t(Q,ae),t(ae,Lt),v(Ie,Lt,null),t(Q,Uo),t(Q,st),h(e,io,c),h(e,C,c),v(We,C,null),t(C,Io),t(C,at),t(C,Wo),t(C,rt),t(C,Zo),t(C,lt),t(C,No),t(C,W),v(Ze,W,null),t(W,qo),t(W,it),t(W,Lo),v(re,W,null),t(W,Ho),v(le,W,null),h(e,co,c),h(e,A,c),t(A,ie),t(ie,Ht),v(Ne,Ht,null),t(A,Ro),t(A,ct),h(e,po,c),h(e,x,c),v(qe,x,null),t(x,Go),t(x,dt),t(x,So),t(x,pt),t(x,Bo),t(x,ht),t(x,Eo),t(x,Z),v(Le,Z,null),t(Z,Vo),t(Z,ut),t(Z,Po),v(ce,Z,null),t(Z,Xo),v(de,Z,null),h(e,ho,c),h(e,Y,c),t(Y,pe),t(pe,Rt),v(He,Rt,null),t(Y,Qo),t(Y,mt),h(e,uo,c),h(e,$,c),v(Re,$,null),t($,Ao),t($,ft),t($,Yo),t($,gt),t($,Oo),t($,_t),t($,Do),t($,bt),t($,Ko),t($,yt),t($,en),t($,z),v(Ge,z,null),t(z,tn),t(z,vt),t(z,on),v(he,z,null),t(z,nn),v(ue,z,null),t(z,sn),v(me,z,null),h(e,mo,c),h(e,O,c),t(O,fe),t(fe,Gt),v(Se,Gt,null),t(O,an),t(O,Tt),h(e,fo,c),h(e,J,c),v(Be,J,null),t(J,rn),t(J,wt),t(J,ln),t(J,kt),t(J,cn),t(J,Mt),t(J,dn),t(J,N),v(Ee,N,null),t(N,pn),t(N,Ft),t(N,hn),v(ge,N,null),t(N,un),v(_e,N,null),h(e,go,c),h(e,D,c),t(D,be),t(be,St),v(Ve,St,null),t(D,mn),t(D,$t),h(e,_o,c),h(e,j,c),v(Pe,j,null),t(j,fn),t(j,Ct),t(j,gn),t(j,xt),t(j,_n),t(j,Jt),t(j,bn),t(j,H),v(Xe,H,null),t(H,yn),t(H,jt),t(H,vn),v(ye,H,null),h(e,bo,c),h(e,Bt,c),yo=!0},p(e,[c]){const Qe={};c&2&&(Qe.$$scope={dirty:c,ctx:e}),oe.$set(Qe);const Et={};c&2&&(Et.$$scope={dirty:c,ctx:e}),se.$set(Et);const Vt={};c&2&&(Vt.$$scope={dirty:c,ctx:e}),re.$set(Vt);const Ae={};c&2&&(Ae.$$scope={dirty:c,ctx:e}),le.$set(Ae);const Pt={};c&2&&(Pt.$$scope={dirty:c,ctx:e}),ce.$set(Pt);const Xt={};c&2&&(Xt.$$scope={dirty:c,ctx:e}),de.$set(Xt);const Ye={};c&2&&(Ye.$$scope={dirty:c,ctx:e}),he.$set(Ye);const Qt={};c&2&&(Qt.$$scope={dirty:c,ctx:e}),ue.$set(Qt);const At={};c&2&&(At.$$scope={dirty:c,ctx:e}),me.$set(At);const Oe={};c&2&&(Oe.$$scope={dirty:c,ctx:e}),ge.$set(Oe);const Yt={};c&2&&(Yt.$$scope={dirty:c,ctx:e}),_e.$set(Yt);const Ot={};c&2&&(Ot.$$scope={dirty:c,ctx:e}),ye.$set(Ot)},i(e){yo||(T(Me.$$.fragment,e),T(Fe.$$.fragment,e),T(Je.$$.fragment,e),T(oe.$$.fragment,e),T(ze.$$.fragment,e),T(Ue.$$.fragment,e),T(se.$$.fragment,e),T(Ie.$$.fragment,e),T(We.$$.fragment,e),T(Ze.$$.fragment,e),T(re.$$.fragment,e),T(le.$$.fragment,e),T(Ne.$$.fragment,e),T(qe.$$.fragment,e),T(Le.$$.fragment,e),T(ce.$$.fragment,e),T(de.$$.fragment,e),T(He.$$.fragment,e),T(Re.$$.fragment,e),T(Ge.$$.fragment,e),T(he.$$.fragment,e),T(ue.$$.fragment,e),T(me.$$.fragment,e),T(Se.$$.fragment,e),T(Be.$$.fragment,e),T(Ee.$$.fragment,e),T(ge.$$.fragment,e),T(_e.$$.fragment,e),T(Ve.$$.fragment,e),T(Pe.$$.fragment,e),T(Xe.$$.fragment,e),T(ye.$$.fragment,e),yo=!0)},o(e){w(Me.$$.fragment,e),w(Fe.$$.fragment,e),w(Je.$$.fragment,e),w(oe.$$.fragment,e),w(ze.$$.fragment,e),w(Ue.$$.fragment,e),w(se.$$.fragment,e),w(Ie.$$.fragment,e),w(We.$$.fragment,e),w(Ze.$$.fragment,e),w(re.$$.fragment,e),w(le.$$.fragment,e),w(Ne.$$.fragment,e),w(qe.$$.fragment,e),w(Le.$$.fragment,e),w(ce.$$.fragment,e),w(de.$$.fragment,e),w(He.$$.fragment,e),w(Re.$$.fragment,e),w(Ge.$$.fragment,e),w(he.$$.fragment,e),w(ue.$$.fragment,e),w(me.$$.fragment,e),w(Se.$$.fragment,e),w(Be.$$.fragment,e),w(Ee.$$.fragment,e),w(ge.$$.fragment,e),w(_e.$$.fragment,e),w(Ve.$$.fragment,e),w(Pe.$$.fragment,e),w(Xe.$$.fragment,e),w(ye.$$.fragment,e),yo=!1},d(e){e&&(n(f),n(d),n(p),n(_),n(Dt),n(V),n(Kt),n($e),n(eo),n(Ce),n(to),n(xe),n(oo),n(P),n(no),n(so),n(je),n(ao),n(X),n(ro),n(I),n(lo),n(Q),n(io),n(C),n(co),n(A),n(po),n(x),n(ho),n(Y),n(uo),n($),n(mo),n(O),n(fo),n(J),n(go),n(D),n(_o),n(j),n(bo),n(Bt)),n(o),k(Me),k(Fe),k(Je),k(oe,e),k(ze),k(Ue),k(se),k(Ie),k(We),k(Ze),k(re),k(le),k(Ne),k(qe),k(Le),k(ce),k(de),k(He),k(Re),k(Ge),k(he),k(ue),k(me),k(Se),k(Be),k(Ee),k(ge),k(_e),k(Ve),k(Pe),k(Xe),k(ye)}}}const Us={local:"falcon",sections:[{local:"overview",title:"Overview"},{local:"converting-custom-checkpoints",title:"Converting custom checkpoints "},{local:"transformers.FalconConfig",title:"FalconConfig"},{local:"transformers.FalconModel",title:"FalconModel"},{local:"transformers.FalconForCausalLM",title:"FalconForCausalLM"},{local:"transformers.FalconForSequenceClassification",title:"FalconForSequenceClassification"},{local:"transformers.FalconForTokenClassification",title:"FalconForTokenClassification"},{local:"transformers.FalconForQuestionAnswering",title:"FalconForQuestionAnswering"}],title:"Falcon"};function Is(F){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gs extends gs{constructor(o){super(),_s(this,o,Is,zs,ms,{})}}export{Gs as component};
