import{s as dp,o as Mp,n as yp}from"../chunks/scheduler.9bc65507.js";import{S as jp,i as gp,g as p,s as l,u as r,A as fp,h as i,f as s,c as n,j as g,v as h,y as o,k as M,o as y,a,w as c,d as m,t as u,x as d}from"../chunks/index.78c82d43.js";import{T as wp}from"../chunks/Tip.87d55b76.js";import{I as U}from"../chunks/IconCopyLink.bedaa44d.js";import{C as j}from"../chunks/CodeBlock.48618ec2.js";import{D as Jp}from"../chunks/DocNotebookDropdown.40f7599b.js";function bp(ms){let w,q="To follow this guide you will need a GPU. If you’re working in a notebook, run the following line to check if a GPU is available:",T,b,J;return b=new j({props:{code:"IW52aWRpYS1zbWk=",highlighted:"!nvidia-smi"}}),{c(){w=p("p"),w.textContent=q,T=l(),r(b.$$.fragment)},l(f){w=i(f,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1qyctb1"&&(w.textContent=q),T=n(f),h(b.$$.fragment,f)},m(f,C){a(f,w,C),a(f,T,C),c(b,f,C),J=!0},p:yp,i(f){J||(m(b.$$.fragment,f),J=!0)},o(f){u(b.$$.fragment,f),J=!1},d(f){f&&(s(w),s(T)),d(b,f)}}}function Tp(ms){let w,q,T,b,J,f,C,P,Tl,St,Vl="Text to speech",us,D,ds,L,Gl=`Text-to-speech (TTS) is the task of creating natural-sounding speech from text, where the speech can be generated in multiple
languages and for multiple speakers. The only text-to-speech model currently available in 🤗 Transformers
is <a href="model_doc/speecht5">SpeechT5</a>, though more will be added in the future. SpeechT5 is pre-trained on a combination of
speech-to-text and text-to-speech data, allowing it to learn a unified space of hidden representations shared by both text
and speech. This means that the same pre-trained model can be fine-tuned for different tasks. Furthermore, SpeechT5
supports multiple speakers through x-vector speaker embeddings.`,Ms,K,Bl="This guide illustrates how to:",ys,O,Wl='<li>Fine-tune <a href="model_doc/speecht5">SpeechT5</a> that was originally trained on English speech on the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',js,ee,Rl="Before you begin, make sure you have all the necessary libraries installed:",gs,te,fs,se,Xl="Install 🤗Transformers from source as not all the SpeechT5 features have been merged into an official release yet:",ws,ae,Js,B,bs,le,Yl="We encourage you to log in to your Hugging Face account to upload and share your model with the community. When prompted, enter your token to log in:",Ts,ne,Us,v,W,ss,pe,Ul,Ht,Nl="Load the dataset",Cs,ie,zl=`<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. In this guide, we are using the Dutch language subset, feel free to pick another subset.`,vs,oe,Al=`Note that VoxPopuli or any other automated speech recognition (ASR) dataset may not be the most suitable
option for training TTS models. The features that make it beneficial for ASR, such as excessive background noise, are
typically undesirable in TTS. However, finding top-quality, multilingual, and multi-speaker TTS datasets can be quite
challenging.`,ks,re,El="Let’s load the data:",xs,he,Is,ce,Ql=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,$s,me,Zs,k,R,as,ue,Cl,qt,Fl="Preprocess the data",_s,de,Sl="Let’s begin by defining the model checkpoint to use and loading the appropriate processor:",Vs,Me,Gs,x,X,ls,ye,vl,Pt,Hl="Text cleanup for SpeechT5 tokenization",Bs,je,ql="Start by cleaning up the text data. You’ll need the tokenizer part of the processor to process the text:",Ws,ge,Rs,fe,Pl=`The dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which feature to use as the text input,
consider that the SpeechT5 tokenizer doesn’t have any tokens for numbers. In <code>normalized_text</code> the numbers are written
out as text. Thus, it is a better fit, and we recommend using    <code>normalized_text</code> as input text.`,Xs,we,Dl=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,Ys,Je,Ll=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,Ns,be,zs,Te,Kl=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,As,Ue,Es,Ce,Ol=`To handle the unsupported characters identified in the previous step, define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,Qs,ve,Fs,ke,en="Now that you have dealt with special characters in the text, it’s time to shift focus to the audio data.",Ss,I,Y,ns,xe,kl,Dt,tn="Speakers",Hs,Ie,sn=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,qs,$e,Ps,Ze,an="By plotting a histogram you can get a sense of how much data there is for each speaker.",Ds,_e,Ls,N,ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Ks,Ve,nn=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,Os,Ge,ea,Be,pn="Let’s check how many speakers remain:",ta,We,sa,Re,on="Let’s see how many examples are left:",aa,Xe,la,Ye,rn="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",na,Ne,hn=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,pa,$,z,ps,ze,xl,Lt,cn="Speaker embeddings",ia,Ae,mn=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,oa,Ee,un=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,ra,Qe,ha,Fe,dn=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,ca,Se,Mn=`For optimal results, we recommend training an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language.`,ma,Z,A,is,He,Il,Kt,yn="Processing the dataset",ua,qe,jn=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,da,Pe,Ma,De,gn="Verify the processing is correct by looking at a single example:",ya,Le,ja,Ke,fn="Speaker embeddings should be a 512-element vector:",ga,Oe,fa,et,wn="The labels should be a log-mel spectrogram with 80 mel bins.",wa,tt,Ja,E,Jn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',ba,st,bn=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,Ta,at,Tn="Now apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",Ua,lt,Ca,nt,Un=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,va,pt,ka,it,Cn="Next, create a basic train/test split:",xa,ot,Ia,_,Q,os,rt,$l,Ot,vn="Data collator",$a,ht,kn=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with the special value <code>-100</code>. This special value
instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,Za,ct,_a,mt,xn=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,Va,ut,Ga,V,F,rs,dt,Zl,es,In="Train the model",Ba,Mt,$n="Load the pre-trained model from the same checkpoint as you used for loading the processor:",Wa,yt,Ra,jt,Zn="The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training.",Xa,gt,Ya,ft,_n=`Define the training arguments. Here we are not computing any evaluation metrics during the training process. Instead, we’ll
only look at the loss:`,Na,wt,za,Jt,Vn="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Aa,bt,Ea,Tt,Gn=`And with that, you’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,Qa,Ut,Fa,Ct,Bn="Push the final model to the 🤗 Hub:",Sa,vt,Ha,G,S,hs,kt,_l,ts,Wn="Inference",qa,xt,Rn=`Great, now that you’ve fine-tuned a model, you can use it for inference!
Load the model from the 🤗 Hub (make sure to use your account name in the following code snippet):`,Pa,It,Da,$t,Xn="Pick an example, here we’ll take one from the test dataset. Obtain a speaker embedding.",La,Zt,Ka,_t,Yn="Define some input text and tokenize it.",Oa,Vt,el,Gt,Nn="Preprocess the input text:",tl,Bt,sl,Wt,zn="Create a spectrogram with your model:",al,Rt,ll,Xt,An="Visualize the spectrogram, if you’d like to:",nl,Yt,pl,H,En='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_2.png" alt="Generated log-mel spectrogram"/>',il,Nt,Qn="Finally, use the vocoder to turn the spectrogram into sound.",ol,zt,rl,At,Fn=`In our experience, obtaining satisfactory results from this model can be challenging. The quality of the speaker
embeddings appears to be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,hl,Et,Sn=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,cl,Qt,Hn=`Finally, it is essential to consider ethical considerations. Although TTS technology has numerous useful applications, it
may also be used for malicious purposes, such as impersonating someone’s voice without their knowledge or consent. Please
use TTS judiciously and responsibly.`,ml,cs,ul;return P=new U({}),D=new Jp({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"}]}}),te=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install datasets soundfile speechbrain accelerate"}}),ae=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdA==",highlighted:"pip install git+https://github.com/huggingface/transformers.git"}}),B=new wp({props:{$$slots:{default:[bp]},$$scope:{ctx:ms}}}),ne=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),pe=new U({}),he=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">20968</span>`}}),me=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))'}}),ue=new U({}),Me=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = SpeechT5Processor.from_pretrained(checkpoint)`}}),ye=new U({}),ge=new j({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer'}}),be=new j({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
<span class="hljs-meta">... </span>    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


<span class="hljs-meta">&gt;&gt;&gt; </span>vocabs = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    extract_all_chars,
<span class="hljs-meta">... </span>    batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    keep_in_memory=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    remove_columns=dataset.column_names,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`}}),Ue=new j({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab - tokenizer_vocab
{<span class="hljs-string">&#x27; &#x27;</span>, <span class="hljs-string">&#x27;à&#x27;</span>, <span class="hljs-string">&#x27;ç&#x27;</span>, <span class="hljs-string">&#x27;è&#x27;</span>, <span class="hljs-string">&#x27;ë&#x27;</span>, <span class="hljs-string">&#x27;í&#x27;</span>, <span class="hljs-string">&#x27;ï&#x27;</span>, <span class="hljs-string">&#x27;ö&#x27;</span>, <span class="hljs-string">&#x27;ü&#x27;</span>}`}}),ve=new j({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>replacements = [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
<span class="hljs-meta">... </span>        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`}}),xe=new U({}),$e=new j({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
<span class="hljs-meta">... </span>    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`}}),_e=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`}}),Ge=new j({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`}}),We=new j({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))
<span class="hljs-number">42</span>`}}),Xe=new j({props:{code:"bGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">9973</span>`}}),ze=new U({}),Qe=new j({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

<span class="hljs-meta">&gt;&gt;&gt; </span>spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_model = EncoderClassifier.from_hparams(
<span class="hljs-meta">... </span>    source=spk_model_name,
<span class="hljs-meta">... </span>    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
<span class="hljs-meta">... </span>    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
<span class="hljs-meta">... </span>        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> speaker_embeddings`}}),He=new U({}),Pe=new j({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">... </span>    example = processor(
<span class="hljs-meta">... </span>        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
<span class="hljs-meta">... </span>        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>        return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-comment"># strip off the batch dimension</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`}}),Le=new j({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(processed_example.keys())
[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;stop_labels&#x27;</span>, <span class="hljs-string">&#x27;speaker_embeddings&#x27;</span>]`}}),Oe=new j({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape
(<span class="hljs-number">512</span>,)`}}),tt=new j({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`}}),lt=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)'}}),pt=new j({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
<span class="hljs-meta">... </span>    input_length = <span class="hljs-built_in">len</span>(input_ids)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">8259</span>`}}),ot=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)'}}),rt=new U({}),ct=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
<span class="hljs-meta">... </span>    processor: <span class="hljs-type">Any</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
<span class="hljs-meta">... </span>        batch = processor.pad(input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># not used during fine-tuning</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>            target_lengths = torch.tensor([<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features])
<span class="hljs-meta">... </span>            target_lengths = target_lengths.new(
<span class="hljs-meta">... </span>                [length - length % model.config.reduction_factor <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths]
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            max_length = <span class="hljs-built_in">max</span>(target_lengths)
<span class="hljs-meta">... </span>            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># also add in the speaker embeddings</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`}}),ut=new j({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = TTSDataCollatorWithPadding(processor=processor)'}}),dt=new U({}),yt=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`}}),gt=new j({props:{code:"bW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNl",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.use_cache = <span class="hljs-literal">False</span>'}}),wt=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = Seq2SeqTrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">4000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`}}),bt=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Seq2SeqTrainer(
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`}}),Ut=new j({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()'}}),vt=new j({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()'}}),kt=new U({}),It=new j({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>)'}}),Zt=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`}}),Vt=new j({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>'}}),Bt=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0R0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)'}}),Rt=new j({props:{code:"c3BlY3Ryb2dyYW0lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZV9zcGVlY2goaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings)'}}),Yt=new j({props:{code:"cGx0LmZpZ3VyZSgpJTBBcGx0Lmltc2hvdyhzcGVjdHJvZ3JhbS5UKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(spectrogram.T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`}}),zt=new j({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyMCUzRCUyMHZvY29kZXIoc3BlY3Ryb2dyYW0pJTBBJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    speech = vocoder(spectrogram)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`}}),{c(){w=p("meta"),q=l(),T=p("p"),b=l(),J=p("h1"),f=p("a"),C=p("span"),r(P.$$.fragment),Tl=l(),St=p("span"),St.textContent=Vl,us=l(),r(D.$$.fragment),ds=l(),L=p("p"),L.innerHTML=Gl,Ms=l(),K=p("p"),K.textContent=Bl,ys=l(),O=p("ol"),O.innerHTML=Wl,js=l(),ee=p("p"),ee.textContent=Rl,gs=l(),r(te.$$.fragment),fs=l(),se=p("p"),se.textContent=Xl,ws=l(),r(ae.$$.fragment),Js=l(),r(B.$$.fragment),bs=l(),le=p("p"),le.textContent=Yl,Ts=l(),r(ne.$$.fragment),Us=l(),v=p("h2"),W=p("a"),ss=p("span"),r(pe.$$.fragment),Ul=l(),Ht=p("span"),Ht.textContent=Nl,Cs=l(),ie=p("p"),ie.innerHTML=zl,vs=l(),oe=p("p"),oe.textContent=Al,ks=l(),re=p("p"),re.textContent=El,xs=l(),r(he.$$.fragment),Is=l(),ce=p("p"),ce.textContent=Ql,$s=l(),r(me.$$.fragment),Zs=l(),k=p("h2"),R=p("a"),as=p("span"),r(ue.$$.fragment),Cl=l(),qt=p("span"),qt.textContent=Fl,_s=l(),de=p("p"),de.textContent=Sl,Vs=l(),r(Me.$$.fragment),Gs=l(),x=p("h3"),X=p("a"),ls=p("span"),r(ye.$$.fragment),vl=l(),Pt=p("span"),Pt.textContent=Hl,Bs=l(),je=p("p"),je.textContent=ql,Ws=l(),r(ge.$$.fragment),Rs=l(),fe=p("p"),fe.innerHTML=Pl,Xs=l(),we=p("p"),we.innerHTML=Dl,Ys=l(),Je=p("p"),Je.innerHTML=Ll,Ns=l(),r(be.$$.fragment),zs=l(),Te=p("p"),Te.textContent=Kl,As=l(),r(Ue.$$.fragment),Es=l(),Ce=p("p"),Ce.innerHTML=Ol,Qs=l(),r(ve.$$.fragment),Fs=l(),ke=p("p"),ke.textContent=en,Ss=l(),I=p("h3"),Y=p("a"),ns=p("span"),r(xe.$$.fragment),kl=l(),Dt=p("span"),Dt.textContent=tn,Hs=l(),Ie=p("p"),Ie.textContent=sn,qs=l(),r($e.$$.fragment),Ps=l(),Ze=p("p"),Ze.textContent=an,Ds=l(),r(_e.$$.fragment),Ls=l(),N=p("div"),N.innerHTML=ln,Ks=l(),Ve=p("p"),Ve.textContent=nn,Os=l(),r(Ge.$$.fragment),ea=l(),Be=p("p"),Be.textContent=pn,ta=l(),r(We.$$.fragment),sa=l(),Re=p("p"),Re.textContent=on,aa=l(),r(Xe.$$.fragment),la=l(),Ye=p("p"),Ye.textContent=rn,na=l(),Ne=p("p"),Ne.textContent=hn,pa=l(),$=p("h3"),z=p("a"),ps=p("span"),r(ze.$$.fragment),xl=l(),Lt=p("span"),Lt.textContent=cn,ia=l(),Ae=p("p"),Ae.innerHTML=mn,oa=l(),Ee=p("p"),Ee.innerHTML=un,ra=l(),r(Qe.$$.fragment),ha=l(),Fe=p("p"),Fe.innerHTML=dn,ca=l(),Se=p("p"),Se.textContent=Mn,ma=l(),Z=p("h3"),A=p("a"),is=p("span"),r(He.$$.fragment),Il=l(),Kt=p("span"),Kt.textContent=yn,ua=l(),qe=p("p"),qe.innerHTML=jn,da=l(),r(Pe.$$.fragment),Ma=l(),De=p("p"),De.textContent=gn,ya=l(),r(Le.$$.fragment),ja=l(),Ke=p("p"),Ke.textContent=fn,ga=l(),r(Oe.$$.fragment),fa=l(),et=p("p"),et.textContent=wn,wa=l(),r(tt.$$.fragment),Ja=l(),E=p("div"),E.innerHTML=Jn,ba=l(),st=p("p"),st.textContent=bn,Ta=l(),at=p("p"),at.textContent=Tn,Ua=l(),r(lt.$$.fragment),Ca=l(),nt=p("p"),nt.textContent=Un,va=l(),r(pt.$$.fragment),ka=l(),it=p("p"),it.textContent=Cn,xa=l(),r(ot.$$.fragment),Ia=l(),_=p("h3"),Q=p("a"),os=p("span"),r(rt.$$.fragment),$l=l(),Ot=p("span"),Ot.textContent=vn,$a=l(),ht=p("p"),ht.innerHTML=kn,Za=l(),r(ct.$$.fragment),_a=l(),mt=p("p"),mt.textContent=xn,Va=l(),r(ut.$$.fragment),Ga=l(),V=p("h2"),F=p("a"),rs=p("span"),r(dt.$$.fragment),Zl=l(),es=p("span"),es.textContent=In,Ba=l(),Mt=p("p"),Mt.textContent=$n,Wa=l(),r(yt.$$.fragment),Ra=l(),jt=p("p"),jt.innerHTML=Zn,Xa=l(),r(gt.$$.fragment),Ya=l(),ft=p("p"),ft.textContent=_n,Na=l(),r(wt.$$.fragment),za=l(),Jt=p("p"),Jt.innerHTML=Vn,Aa=l(),r(bt.$$.fragment),Ea=l(),Tt=p("p"),Tt.innerHTML=Gn,Qa=l(),r(Ut.$$.fragment),Fa=l(),Ct=p("p"),Ct.textContent=Bn,Sa=l(),r(vt.$$.fragment),Ha=l(),G=p("h2"),S=p("a"),hs=p("span"),r(kt.$$.fragment),_l=l(),ts=p("span"),ts.textContent=Wn,qa=l(),xt=p("p"),xt.textContent=Rn,Pa=l(),r(It.$$.fragment),Da=l(),$t=p("p"),$t.textContent=Xn,La=l(),r(Zt.$$.fragment),Ka=l(),_t=p("p"),_t.textContent=Yn,Oa=l(),r(Vt.$$.fragment),el=l(),Gt=p("p"),Gt.textContent=Nn,tl=l(),r(Bt.$$.fragment),sl=l(),Wt=p("p"),Wt.textContent=zn,al=l(),r(Rt.$$.fragment),ll=l(),Xt=p("p"),Xt.textContent=An,nl=l(),r(Yt.$$.fragment),pl=l(),H=p("div"),H.innerHTML=En,il=l(),Nt=p("p"),Nt.textContent=Qn,ol=l(),r(zt.$$.fragment),rl=l(),At=p("p"),At.textContent=Fn,hl=l(),Et=p("p"),Et.innerHTML=Sn,cl=l(),Qt=p("p"),Qt.textContent=Hn,ml=l(),cs=p("p"),this.h()},l(e){const t=fp("svelte-1phssyn",document.head);w=i(t,"META",{name:!0,content:!0}),t.forEach(s),q=n(e),T=i(e,"P",{}),g(T).forEach(s),b=n(e),J=i(e,"H1",{class:!0});var Ft=g(J);f=i(Ft,"A",{id:!0,class:!0,href:!0});var qn=g(f);C=i(qn,"SPAN",{});var Pn=g(C);h(P.$$.fragment,Pn),Pn.forEach(s),qn.forEach(s),Tl=n(Ft),St=i(Ft,"SPAN",{"data-svelte-h":!0}),o(St)!=="svelte-19xbyp3"&&(St.textContent=Vl),Ft.forEach(s),us=n(e),h(D.$$.fragment,e),ds=n(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-15m1kam"&&(L.innerHTML=Gl),Ms=n(e),K=i(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ku8orh"&&(K.textContent=Bl),ys=n(e),O=i(e,"OL",{"data-svelte-h":!0}),o(O)!=="svelte-nzkxk7"&&(O.innerHTML=Wl),js=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1c9nexd"&&(ee.textContent=Rl),gs=n(e),h(te.$$.fragment,e),fs=n(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1pk9b4n"&&(se.textContent=Xl),ws=n(e),h(ae.$$.fragment,e),Js=n(e),h(B.$$.fragment,e),bs=n(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-yib87s"&&(le.textContent=Yl),Ts=n(e),h(ne.$$.fragment,e),Us=n(e),v=i(e,"H2",{class:!0});var dl=g(v);W=i(dl,"A",{id:!0,class:!0,href:!0});var Dn=g(W);ss=i(Dn,"SPAN",{});var Ln=g(ss);h(pe.$$.fragment,Ln),Ln.forEach(s),Dn.forEach(s),Ul=n(dl),Ht=i(dl,"SPAN",{"data-svelte-h":!0}),o(Ht)!=="svelte-6t1nik"&&(Ht.textContent=Nl),dl.forEach(s),Cs=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1lfskuv"&&(ie.innerHTML=zl),vs=n(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-1smm6mj"&&(oe.textContent=Al),ks=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-1soaqfm"&&(re.textContent=El),xs=n(e),h(he.$$.fragment,e),Is=n(e),ce=i(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-1xdebij"&&(ce.textContent=Ql),$s=n(e),h(me.$$.fragment,e),Zs=n(e),k=i(e,"H2",{class:!0});var Ml=g(k);R=i(Ml,"A",{id:!0,class:!0,href:!0});var Kn=g(R);as=i(Kn,"SPAN",{});var On=g(as);h(ue.$$.fragment,On),On.forEach(s),Kn.forEach(s),Cl=n(Ml),qt=i(Ml,"SPAN",{"data-svelte-h":!0}),o(qt)!=="svelte-171xy48"&&(qt.textContent=Fl),Ml.forEach(s),_s=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1cfkf3a"&&(de.textContent=Sl),Vs=n(e),h(Me.$$.fragment,e),Gs=n(e),x=i(e,"H3",{class:!0});var yl=g(x);X=i(yl,"A",{id:!0,class:!0,href:!0});var ep=g(X);ls=i(ep,"SPAN",{});var tp=g(ls);h(ye.$$.fragment,tp),tp.forEach(s),ep.forEach(s),vl=n(yl),Pt=i(yl,"SPAN",{"data-svelte-h":!0}),o(Pt)!=="svelte-zd2o8z"&&(Pt.textContent=Hl),yl.forEach(s),Bs=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1bseo5y"&&(je.textContent=ql),Ws=n(e),h(ge.$$.fragment,e),Rs=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-alux34"&&(fe.innerHTML=Pl),Xs=n(e),we=i(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1qiuc1m"&&(we.innerHTML=Dl),Ys=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-l4aof2"&&(Je.innerHTML=Ll),Ns=n(e),h(be.$$.fragment,e),zs=n(e),Te=i(e,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-fefaym"&&(Te.textContent=Kl),As=n(e),h(Ue.$$.fragment,e),Es=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1m7sgt2"&&(Ce.innerHTML=Ol),Qs=n(e),h(ve.$$.fragment,e),Fs=n(e),ke=i(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-k1jzc5"&&(ke.textContent=en),Ss=n(e),I=i(e,"H3",{class:!0});var jl=g(I);Y=i(jl,"A",{id:!0,class:!0,href:!0});var sp=g(Y);ns=i(sp,"SPAN",{});var ap=g(ns);h(xe.$$.fragment,ap),ap.forEach(s),sp.forEach(s),kl=n(jl),Dt=i(jl,"SPAN",{"data-svelte-h":!0}),o(Dt)!=="svelte-1djgoy3"&&(Dt.textContent=tn),jl.forEach(s),Hs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1edo483"&&(Ie.textContent=sn),qs=n(e),h($e.$$.fragment,e),Ps=n(e),Ze=i(e,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-1hah56a"&&(Ze.textContent=an),Ds=n(e),h(_e.$$.fragment,e),Ls=n(e),N=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(N)!=="svelte-1uufiik"&&(N.innerHTML=ln),Ks=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1ujf40"&&(Ve.textContent=nn),Os=n(e),h(Ge.$$.fragment,e),ea=n(e),Be=i(e,"P",{"data-svelte-h":!0}),o(Be)!=="svelte-g2dd32"&&(Be.textContent=pn),ta=n(e),h(We.$$.fragment,e),sa=n(e),Re=i(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-hbes5t"&&(Re.textContent=on),aa=n(e),h(Xe.$$.fragment,e),la=n(e),Ye=i(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-oizlk1"&&(Ye.textContent=rn),na=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1n0u7fp"&&(Ne.textContent=hn),pa=n(e),$=i(e,"H3",{class:!0});var gl=g($);z=i(gl,"A",{id:!0,class:!0,href:!0});var lp=g(z);ps=i(lp,"SPAN",{});var np=g(ps);h(ze.$$.fragment,np),np.forEach(s),lp.forEach(s),xl=n(gl),Lt=i(gl,"SPAN",{"data-svelte-h":!0}),o(Lt)!=="svelte-11a8qqy"&&(Lt.textContent=cn),gl.forEach(s),ia=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-1xdfpy2"&&(Ae.innerHTML=mn),oa=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-7nncma"&&(Ee.innerHTML=un),ra=n(e),h(Qe.$$.fragment,e),ha=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1mtxkxr"&&(Fe.innerHTML=dn),ca=n(e),Se=i(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-1az2ed"&&(Se.textContent=Mn),ma=n(e),Z=i(e,"H3",{class:!0});var fl=g(Z);A=i(fl,"A",{id:!0,class:!0,href:!0});var pp=g(A);is=i(pp,"SPAN",{});var ip=g(is);h(He.$$.fragment,ip),ip.forEach(s),pp.forEach(s),Il=n(fl),Kt=i(fl,"SPAN",{"data-svelte-h":!0}),o(Kt)!=="svelte-yn1vvh"&&(Kt.textContent=yn),fl.forEach(s),ua=n(e),qe=i(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1tlidee"&&(qe.innerHTML=jn),da=n(e),h(Pe.$$.fragment,e),Ma=n(e),De=i(e,"P",{"data-svelte-h":!0}),o(De)!=="svelte-17mzfft"&&(De.textContent=gn),ya=n(e),h(Le.$$.fragment,e),ja=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-1mqg4ck"&&(Ke.textContent=fn),ga=n(e),h(Oe.$$.fragment,e),fa=n(e),et=i(e,"P",{"data-svelte-h":!0}),o(et)!=="svelte-f7g58h"&&(et.textContent=wn),wa=n(e),h(tt.$$.fragment,e),Ja=n(e),E=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(E)!=="svelte-j4o1b8"&&(E.innerHTML=Jn),ba=n(e),st=i(e,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1t9vz0y"&&(st.textContent=bn),Ta=n(e),at=i(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1r5jy40"&&(at.textContent=Tn),Ua=n(e),h(lt.$$.fragment,e),Ca=n(e),nt=i(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-wvyh3r"&&(nt.textContent=Un),va=n(e),h(pt.$$.fragment,e),ka=n(e),it=i(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-12gx63x"&&(it.textContent=Cn),xa=n(e),h(ot.$$.fragment,e),Ia=n(e),_=i(e,"H3",{class:!0});var wl=g(_);Q=i(wl,"A",{id:!0,class:!0,href:!0});var op=g(Q);os=i(op,"SPAN",{});var rp=g(os);h(rt.$$.fragment,rp),rp.forEach(s),op.forEach(s),$l=n(wl),Ot=i(wl,"SPAN",{"data-svelte-h":!0}),o(Ot)!=="svelte-a1w05"&&(Ot.textContent=vn),wl.forEach(s),$a=n(e),ht=i(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-1qadcxm"&&(ht.innerHTML=kn),Za=n(e),h(ct.$$.fragment,e),_a=n(e),mt=i(e,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-u623yc"&&(mt.textContent=xn),Va=n(e),h(ut.$$.fragment,e),Ga=n(e),V=i(e,"H2",{class:!0});var Jl=g(V);F=i(Jl,"A",{id:!0,class:!0,href:!0});var hp=g(F);rs=i(hp,"SPAN",{});var cp=g(rs);h(dt.$$.fragment,cp),cp.forEach(s),hp.forEach(s),Zl=n(Jl),es=i(Jl,"SPAN",{"data-svelte-h":!0}),o(es)!=="svelte-n13n3f"&&(es.textContent=In),Jl.forEach(s),Ba=n(e),Mt=i(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1kkriue"&&(Mt.textContent=$n),Wa=n(e),h(yt.$$.fragment,e),Ra=n(e),jt=i(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-15xsopr"&&(jt.innerHTML=Zn),Xa=n(e),h(gt.$$.fragment,e),Ya=n(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-11l73nm"&&(ft.textContent=_n),Na=n(e),h(wt.$$.fragment,e),za=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1yq1u47"&&(Jt.innerHTML=Vn),Aa=n(e),h(bt.$$.fragment,e),Ea=n(e),Tt=i(e,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-1qh8b8v"&&(Tt.innerHTML=Gn),Qa=n(e),h(Ut.$$.fragment,e),Fa=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-hefgo2"&&(Ct.textContent=Bn),Sa=n(e),h(vt.$$.fragment,e),Ha=n(e),G=i(e,"H2",{class:!0});var bl=g(G);S=i(bl,"A",{id:!0,class:!0,href:!0});var mp=g(S);hs=i(mp,"SPAN",{});var up=g(hs);h(kt.$$.fragment,up),up.forEach(s),mp.forEach(s),_l=n(bl),ts=i(bl,"SPAN",{"data-svelte-h":!0}),o(ts)!=="svelte-199uz7g"&&(ts.textContent=Wn),bl.forEach(s),qa=n(e),xt=i(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-6uvp9l"&&(xt.textContent=Rn),Pa=n(e),h(It.$$.fragment,e),Da=n(e),$t=i(e,"P",{"data-svelte-h":!0}),o($t)!=="svelte-kiuzrb"&&($t.textContent=Xn),La=n(e),h(Zt.$$.fragment,e),Ka=n(e),_t=i(e,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-1sn5mu7"&&(_t.textContent=Yn),Oa=n(e),h(Vt.$$.fragment,e),el=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1sf6bxe"&&(Gt.textContent=Nn),tl=n(e),h(Bt.$$.fragment,e),sl=n(e),Wt=i(e,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-eurn6"&&(Wt.textContent=zn),al=n(e),h(Rt.$$.fragment,e),ll=n(e),Xt=i(e,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-iofzmb"&&(Xt.textContent=An),nl=n(e),h(Yt.$$.fragment,e),pl=n(e),H=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(H)!=="svelte-16b2dt6"&&(H.innerHTML=En),il=n(e),Nt=i(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-chmo02"&&(Nt.textContent=Qn),ol=n(e),h(zt.$$.fragment,e),rl=n(e),At=i(e,"P",{"data-svelte-h":!0}),o(At)!=="svelte-1fdujzv"&&(At.textContent=Fn),hl=n(e),Et=i(e,"P",{"data-svelte-h":!0}),o(Et)!=="svelte-6lmfh0"&&(Et.innerHTML=Sn),cl=n(e),Qt=i(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1mo0fd"&&(Qt.textContent=Hn),ml=n(e),cs=i(e,"P",{}),g(cs).forEach(s),this.h()},h(){M(w,"name","hf:doc:metadata"),M(w,"content",JSON.stringify(Up)),M(f,"id","text-to-speech"),M(f,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(f,"href","#text-to-speech"),M(J,"class","relative group"),M(W,"id","load-the-dataset"),M(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(W,"href","#load-the-dataset"),M(v,"class","relative group"),M(R,"id","preprocess-the-data"),M(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(R,"href","#preprocess-the-data"),M(k,"class","relative group"),M(X,"id","text-cleanup-for-speecht5-tokenization"),M(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(X,"href","#text-cleanup-for-speecht5-tokenization"),M(x,"class","relative group"),M(Y,"id","speakers"),M(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Y,"href","#speakers"),M(I,"class","relative group"),M(N,"class","flex justify-center"),M(z,"id","speaker-embeddings"),M(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(z,"href","#speaker-embeddings"),M($,"class","relative group"),M(A,"id","processing-the-dataset"),M(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(A,"href","#processing-the-dataset"),M(Z,"class","relative group"),M(E,"class","flex justify-center"),M(Q,"id","data-collator"),M(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(Q,"href","#data-collator"),M(_,"class","relative group"),M(F,"id","train-the-model"),M(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(F,"href","#train-the-model"),M(V,"class","relative group"),M(S,"id","inference"),M(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),M(S,"href","#inference"),M(G,"class","relative group"),M(H,"class","flex justify-center")},m(e,t){y(document.head,w),a(e,q,t),a(e,T,t),a(e,b,t),a(e,J,t),y(J,f),y(f,C),c(P,C,null),y(J,Tl),y(J,St),a(e,us,t),c(D,e,t),a(e,ds,t),a(e,L,t),a(e,Ms,t),a(e,K,t),a(e,ys,t),a(e,O,t),a(e,js,t),a(e,ee,t),a(e,gs,t),c(te,e,t),a(e,fs,t),a(e,se,t),a(e,ws,t),c(ae,e,t),a(e,Js,t),c(B,e,t),a(e,bs,t),a(e,le,t),a(e,Ts,t),c(ne,e,t),a(e,Us,t),a(e,v,t),y(v,W),y(W,ss),c(pe,ss,null),y(v,Ul),y(v,Ht),a(e,Cs,t),a(e,ie,t),a(e,vs,t),a(e,oe,t),a(e,ks,t),a(e,re,t),a(e,xs,t),c(he,e,t),a(e,Is,t),a(e,ce,t),a(e,$s,t),c(me,e,t),a(e,Zs,t),a(e,k,t),y(k,R),y(R,as),c(ue,as,null),y(k,Cl),y(k,qt),a(e,_s,t),a(e,de,t),a(e,Vs,t),c(Me,e,t),a(e,Gs,t),a(e,x,t),y(x,X),y(X,ls),c(ye,ls,null),y(x,vl),y(x,Pt),a(e,Bs,t),a(e,je,t),a(e,Ws,t),c(ge,e,t),a(e,Rs,t),a(e,fe,t),a(e,Xs,t),a(e,we,t),a(e,Ys,t),a(e,Je,t),a(e,Ns,t),c(be,e,t),a(e,zs,t),a(e,Te,t),a(e,As,t),c(Ue,e,t),a(e,Es,t),a(e,Ce,t),a(e,Qs,t),c(ve,e,t),a(e,Fs,t),a(e,ke,t),a(e,Ss,t),a(e,I,t),y(I,Y),y(Y,ns),c(xe,ns,null),y(I,kl),y(I,Dt),a(e,Hs,t),a(e,Ie,t),a(e,qs,t),c($e,e,t),a(e,Ps,t),a(e,Ze,t),a(e,Ds,t),c(_e,e,t),a(e,Ls,t),a(e,N,t),a(e,Ks,t),a(e,Ve,t),a(e,Os,t),c(Ge,e,t),a(e,ea,t),a(e,Be,t),a(e,ta,t),c(We,e,t),a(e,sa,t),a(e,Re,t),a(e,aa,t),c(Xe,e,t),a(e,la,t),a(e,Ye,t),a(e,na,t),a(e,Ne,t),a(e,pa,t),a(e,$,t),y($,z),y(z,ps),c(ze,ps,null),y($,xl),y($,Lt),a(e,ia,t),a(e,Ae,t),a(e,oa,t),a(e,Ee,t),a(e,ra,t),c(Qe,e,t),a(e,ha,t),a(e,Fe,t),a(e,ca,t),a(e,Se,t),a(e,ma,t),a(e,Z,t),y(Z,A),y(A,is),c(He,is,null),y(Z,Il),y(Z,Kt),a(e,ua,t),a(e,qe,t),a(e,da,t),c(Pe,e,t),a(e,Ma,t),a(e,De,t),a(e,ya,t),c(Le,e,t),a(e,ja,t),a(e,Ke,t),a(e,ga,t),c(Oe,e,t),a(e,fa,t),a(e,et,t),a(e,wa,t),c(tt,e,t),a(e,Ja,t),a(e,E,t),a(e,ba,t),a(e,st,t),a(e,Ta,t),a(e,at,t),a(e,Ua,t),c(lt,e,t),a(e,Ca,t),a(e,nt,t),a(e,va,t),c(pt,e,t),a(e,ka,t),a(e,it,t),a(e,xa,t),c(ot,e,t),a(e,Ia,t),a(e,_,t),y(_,Q),y(Q,os),c(rt,os,null),y(_,$l),y(_,Ot),a(e,$a,t),a(e,ht,t),a(e,Za,t),c(ct,e,t),a(e,_a,t),a(e,mt,t),a(e,Va,t),c(ut,e,t),a(e,Ga,t),a(e,V,t),y(V,F),y(F,rs),c(dt,rs,null),y(V,Zl),y(V,es),a(e,Ba,t),a(e,Mt,t),a(e,Wa,t),c(yt,e,t),a(e,Ra,t),a(e,jt,t),a(e,Xa,t),c(gt,e,t),a(e,Ya,t),a(e,ft,t),a(e,Na,t),c(wt,e,t),a(e,za,t),a(e,Jt,t),a(e,Aa,t),c(bt,e,t),a(e,Ea,t),a(e,Tt,t),a(e,Qa,t),c(Ut,e,t),a(e,Fa,t),a(e,Ct,t),a(e,Sa,t),c(vt,e,t),a(e,Ha,t),a(e,G,t),y(G,S),y(S,hs),c(kt,hs,null),y(G,_l),y(G,ts),a(e,qa,t),a(e,xt,t),a(e,Pa,t),c(It,e,t),a(e,Da,t),a(e,$t,t),a(e,La,t),c(Zt,e,t),a(e,Ka,t),a(e,_t,t),a(e,Oa,t),c(Vt,e,t),a(e,el,t),a(e,Gt,t),a(e,tl,t),c(Bt,e,t),a(e,sl,t),a(e,Wt,t),a(e,al,t),c(Rt,e,t),a(e,ll,t),a(e,Xt,t),a(e,nl,t),c(Yt,e,t),a(e,pl,t),a(e,H,t),a(e,il,t),a(e,Nt,t),a(e,ol,t),c(zt,e,t),a(e,rl,t),a(e,At,t),a(e,hl,t),a(e,Et,t),a(e,cl,t),a(e,Qt,t),a(e,ml,t),a(e,cs,t),ul=!0},p(e,[t]){const Ft={};t&2&&(Ft.$$scope={dirty:t,ctx:e}),B.$set(Ft)},i(e){ul||(m(P.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(B.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(he.$$.fragment,e),m(me.$$.fragment,e),m(ue.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(ge.$$.fragment,e),m(be.$$.fragment,e),m(Ue.$$.fragment,e),m(ve.$$.fragment,e),m(xe.$$.fragment,e),m($e.$$.fragment,e),m(_e.$$.fragment,e),m(Ge.$$.fragment,e),m(We.$$.fragment,e),m(Xe.$$.fragment,e),m(ze.$$.fragment,e),m(Qe.$$.fragment,e),m(He.$$.fragment,e),m(Pe.$$.fragment,e),m(Le.$$.fragment,e),m(Oe.$$.fragment,e),m(tt.$$.fragment,e),m(lt.$$.fragment,e),m(pt.$$.fragment,e),m(ot.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(ut.$$.fragment,e),m(dt.$$.fragment,e),m(yt.$$.fragment,e),m(gt.$$.fragment,e),m(wt.$$.fragment,e),m(bt.$$.fragment,e),m(Ut.$$.fragment,e),m(vt.$$.fragment,e),m(kt.$$.fragment,e),m(It.$$.fragment,e),m(Zt.$$.fragment,e),m(Vt.$$.fragment,e),m(Bt.$$.fragment,e),m(Rt.$$.fragment,e),m(Yt.$$.fragment,e),m(zt.$$.fragment,e),ul=!0)},o(e){u(P.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(B.$$.fragment,e),u(ne.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(me.$$.fragment,e),u(ue.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(be.$$.fragment,e),u(Ue.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(_e.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(ze.$$.fragment,e),u(Qe.$$.fragment,e),u(He.$$.fragment,e),u(Pe.$$.fragment,e),u(Le.$$.fragment,e),u(Oe.$$.fragment,e),u(tt.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(ot.$$.fragment,e),u(rt.$$.fragment,e),u(ct.$$.fragment,e),u(ut.$$.fragment,e),u(dt.$$.fragment,e),u(yt.$$.fragment,e),u(gt.$$.fragment,e),u(wt.$$.fragment,e),u(bt.$$.fragment,e),u(Ut.$$.fragment,e),u(vt.$$.fragment,e),u(kt.$$.fragment,e),u(It.$$.fragment,e),u(Zt.$$.fragment,e),u(Vt.$$.fragment,e),u(Bt.$$.fragment,e),u(Rt.$$.fragment,e),u(Yt.$$.fragment,e),u(zt.$$.fragment,e),ul=!1},d(e){e&&(s(q),s(T),s(b),s(J),s(us),s(ds),s(L),s(Ms),s(K),s(ys),s(O),s(js),s(ee),s(gs),s(fs),s(se),s(ws),s(Js),s(bs),s(le),s(Ts),s(Us),s(v),s(Cs),s(ie),s(vs),s(oe),s(ks),s(re),s(xs),s(Is),s(ce),s($s),s(Zs),s(k),s(_s),s(de),s(Vs),s(Gs),s(x),s(Bs),s(je),s(Ws),s(Rs),s(fe),s(Xs),s(we),s(Ys),s(Je),s(Ns),s(zs),s(Te),s(As),s(Es),s(Ce),s(Qs),s(Fs),s(ke),s(Ss),s(I),s(Hs),s(Ie),s(qs),s(Ps),s(Ze),s(Ds),s(Ls),s(N),s(Ks),s(Ve),s(Os),s(ea),s(Be),s(ta),s(sa),s(Re),s(aa),s(la),s(Ye),s(na),s(Ne),s(pa),s($),s(ia),s(Ae),s(oa),s(Ee),s(ra),s(ha),s(Fe),s(ca),s(Se),s(ma),s(Z),s(ua),s(qe),s(da),s(Ma),s(De),s(ya),s(ja),s(Ke),s(ga),s(fa),s(et),s(wa),s(Ja),s(E),s(ba),s(st),s(Ta),s(at),s(Ua),s(Ca),s(nt),s(va),s(ka),s(it),s(xa),s(Ia),s(_),s($a),s(ht),s(Za),s(_a),s(mt),s(Va),s(Ga),s(V),s(Ba),s(Mt),s(Wa),s(Ra),s(jt),s(Xa),s(Ya),s(ft),s(Na),s(za),s(Jt),s(Aa),s(Ea),s(Tt),s(Qa),s(Fa),s(Ct),s(Sa),s(Ha),s(G),s(qa),s(xt),s(Pa),s(Da),s($t),s(La),s(Ka),s(_t),s(Oa),s(el),s(Gt),s(tl),s(sl),s(Wt),s(al),s(ll),s(Xt),s(nl),s(pl),s(H),s(il),s(Nt),s(ol),s(rl),s(At),s(hl),s(Et),s(cl),s(Qt),s(ml),s(cs)),s(w),d(P),d(D,e),d(te,e),d(ae,e),d(B,e),d(ne,e),d(pe),d(he,e),d(me,e),d(ue),d(Me,e),d(ye),d(ge,e),d(be,e),d(Ue,e),d(ve,e),d(xe),d($e,e),d(_e,e),d(Ge,e),d(We,e),d(Xe,e),d(ze),d(Qe,e),d(He),d(Pe,e),d(Le,e),d(Oe,e),d(tt,e),d(lt,e),d(pt,e),d(ot,e),d(rt),d(ct,e),d(ut,e),d(dt),d(yt,e),d(gt,e),d(wt,e),d(bt,e),d(Ut,e),d(vt,e),d(kt),d(It,e),d(Zt,e),d(Vt,e),d(Bt,e),d(Rt,e),d(Yt,e),d(zt,e)}}}const Up={local:"text-to-speech",sections:[{local:"load-the-dataset",title:"Load the dataset"},{local:"preprocess-the-data",sections:[{local:"text-cleanup-for-speecht5-tokenization",title:"Text cleanup for SpeechT5 tokenization "},{local:"speakers",title:"Speakers"},{local:"speaker-embeddings",title:"Speaker embeddings"},{local:"processing-the-dataset",title:"Processing the dataset"},{local:"data-collator",title:"Data collator"}],title:"Preprocess the data"},{local:"train-the-model",title:"Train the model"},{local:"inference",title:"Inference"}],title:"Text to speech"};function Cp(ms){return Mp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _p extends jp{constructor(w){super(),gp(this,w,Cp,Tp,dp,{})}}export{_p as component};
