import{s as bn,n as qn,o as vn}from"../chunks/scheduler.9bc65507.js";import{S as wn,i as Mn,g as n,s as l,u as h,m as Ve,H as Ze,A as jn,h as o,f as s,c as i,j as c,v as m,y as r,n as Ge,B as Qe,k as p,o as u,a,w as d,d as g,t as y,x as f}from"../chunks/index.78c82d43.js";import{Y as Xe}from"../chunks/Youtube.b19762b6.js";import{I as H}from"../chunks/IconCopyLink.bedaa44d.js";import{C as q}from"../chunks/CodeBlock.48618ec2.js";import{D as Tn}from"../chunks/DocNotebookDropdown.40f7599b.js";function kn(na){let v,ds,ns,gs,w,z,os,S,Re,Zt,oa="Summary of the tokenizers",ys,N,fs,B,la="On this page, we will have a closer look at tokenization.",bs,W,qs,D,ia=`As we saw in <a href="preprocessing">the preprocessing tutorial</a>, tokenizing a text is splitting it into words or
subwords, which then are converted to ids through a look-up table. Converting words or subwords to ids is
straightforward, so in this summary, we will focus on splitting a text into words or subwords (i.e. tokenizing a text).
More specifically, we will look at the three main types of tokenizers used in 🤗 Transformers: <a href="#byte-pair-encoding">Byte-Pair Encoding
(BPE)</a>, <a href="#wordpiece">WordPiece</a>, and <a href="#sentencepiece">SentencePiece</a>, and show examples
of which tokenizer type is used by which model.`,vs,V,ra=`Note that on each model page, you can look at the documentation of the associated tokenizer to know which tokenizer
type was used by the pretrained model. For instance, if we look at <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>, we can see
that the model uses <a href="#wordpiece">WordPiece</a>.`,ws,M,I,ls,Z,Ke,Gt,pa="Introduction",Ms,G,ua=`Splitting a text into smaller chunks is a task that is harder than it looks, and there are multiple ways of doing so.
For instance, let’s look at the sentence <code>&quot;Don&#39;t you love 🤗 Transformers? We sure do.&quot;</code>`,js,Q,Ts,X,ca="A simple way of tokenizing this text is to split it by spaces, which would give:",ks,R,Js,K,ha=`This is a sensible first step, but if we look at the tokens <code>&quot;Transformers?&quot;</code> and <code>&quot;do.&quot;</code>, we notice that the
punctuation is attached to the words <code>&quot;Transformer&quot;</code> and <code>&quot;do&quot;</code>, which is suboptimal. We should take the
punctuation into account so that a model does not have to learn a different representation of a word and every possible
punctuation symbol that could follow it, which would explode the number of representations the model has to learn.
Taking punctuation into account, tokenizing our exemplary text would give:`,xs,F,$s,Y,ma=`Better. However, it is disadvantageous, how the tokenization dealt with the word <code>&quot;Don&#39;t&quot;</code>. <code>&quot;Don&#39;t&quot;</code> stands for
<code>&quot;do not&quot;</code>, so it would be better tokenized as <code>[&quot;Do&quot;, &quot;n&#39;t&quot;]</code>. This is where things start getting complicated, and
part of the reason each model has its own tokenizer type. Depending on the rules we apply for tokenizing a text, a
different tokenized output is generated for the same text. A pretrained model only performs properly if you feed it an
input that was tokenized with the same rules that were used to tokenize its training data.`,zs,O,da=`<a href="https://spacy.io/" rel="nofollow">spaCy</a> and <a href="http://www.statmt.org/moses/?n=Development.GetStarted" rel="nofollow">Moses</a> are two popular
rule-based tokenizers. Applying them on our example, <em>spaCy</em> and <em>Moses</em> would output something like:`,Is,tt,_s,st,ga=`As can be seen space and punctuation tokenization, as well as rule-based tokenization, is used here. Space and
punctuation tokenization and rule-based tokenization are both examples of word tokenization, which is loosely defined
as splitting sentences into words. While it’s the most intuitive way to split texts into smaller chunks, this
tokenization method can lead to problems for massive text corpora. In this case, space and punctuation tokenization
usually generates a very big vocabulary (the set of all unique words and tokens used). <em>E.g.</em>, <a href="model_doc/transformerxl">Transformer XL</a> uses space and punctuation tokenization, resulting in a vocabulary size of 267,735!`,Us,et,ya=`Such a big vocabulary size forces the model to have an enormous embedding matrix as the input and output layer, which
causes both an increased memory and time complexity. In general, transformers models rarely have a vocabulary size
greater than 50,000, especially if they are pretrained only on a single language.`,Cs,at,fa="So if simple space and punctuation tokenization is unsatisfactory, why not simply tokenize on characters?",Ps,nt,As,ot,ba=`While character tokenization is very simple and would greatly reduce memory and time complexity it makes it much harder
for the model to learn meaningful input representations. <em>E.g.</em> learning a meaningful context-independent
representation for the letter <code>&quot;t&quot;</code> is much harder than learning a context-independent representation for the word
<code>&quot;today&quot;</code>. Therefore, character tokenization is often accompanied by a loss of performance. So to get the best of
both worlds, transformers models use a hybrid between word-level and character-level tokenization called <strong>subword</strong>
tokenization.`,Ls,j,_,is,lt,Fe,Qt,qa="Subword tokenization",Es,it,Hs,rt,va=`Subword tokenization algorithms rely on the principle that frequently used words should not be split into smaller
subwords, but rare words should be decomposed into meaningful subwords. For instance <code>&quot;annoyingly&quot;</code> might be
considered a rare word and could be decomposed into <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code>. Both <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code> as
stand-alone subwords would appear more frequently while at the same time the meaning of <code>&quot;annoyingly&quot;</code> is kept by the
composite meaning of <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code>. This is especially useful in agglutinative languages such as Turkish,
where you can form (almost) arbitrarily long complex words by stringing together subwords.`,Ss,pt,wa=`Subword tokenization allows the model to have a reasonable vocabulary size while being able to learn meaningful
context-independent representations. In addition, subword tokenization enables the model to process words it has never
seen before, by decomposing them into known subwords. For instance, the <a href="/docs/transformers/v4.33.3/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> tokenizes
<code>&quot;I have a new GPU!&quot;</code> as follows:`,Ns,ut,Bs,ct,Ma=`Because we are considering the uncased model, the sentence was lowercased first. We can see that the words <code>[&quot;i&quot;, &quot;have&quot;, &quot;a&quot;, &quot;new&quot;]</code> are present in the tokenizer’s vocabulary, but the word <code>&quot;gpu&quot;</code> is not. Consequently, the
tokenizer splits <code>&quot;gpu&quot;</code> into known subwords: <code>[&quot;gp&quot; and &quot;##u&quot;]</code>. <code>&quot;##&quot;</code> means that the rest of the token should
be attached to the previous one, without space (for decoding or reversal of the tokenization).`,Ws,ht,ja='As another example, <a href="/docs/transformers/v4.33.3/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> tokenizes our previously exemplary text as follows:',Ds,mt,Vs,dt,Ta=`We’ll get back to the meaning of those <code>&quot;▁&quot;</code> when we look at <a href="#sentencepiece">SentencePiece</a>. As one can see,
the rare word <code>&quot;Transformers&quot;</code> has been split into the more frequent subwords <code>&quot;Transform&quot;</code> and <code>&quot;ers&quot;</code>.`,Zs,gt,ka=`Let’s now look at how the different subword tokenization algorithms work. Note that all of those tokenization
algorithms rely on some form of training which is usually done on the corpus the corresponding model will be trained
on.`,Gs,Xt,Qs,T,U,rs,yt,Ye,Rt,Ja="Byte-Pair Encoding (BPE)",Xs,ft,xa=`Byte-Pair Encoding (BPE) was introduced in <a href="https://arxiv.org/abs/1508.07909" rel="nofollow">Neural Machine Translation of Rare Words with Subword Units (Sennrich et
al., 2015)</a>. BPE relies on a pre-tokenizer that splits the training data into
words. Pretokenization can be as simple as space tokenization, e.g. <a href="model_doc/gpt2">GPT-2</a>, <a href="model_doc/roberta">RoBERTa</a>. More advanced pre-tokenization include rule-based tokenization, e.g. <a href="model_doc/xlm">XLM</a>,
<a href="model_doc/flaubert">FlauBERT</a> which uses Moses for most languages, or <a href="model_doc/gpt">GPT</a> which uses
Spacy and ftfy, to count the frequency of each word in the training corpus.`,Rs,bt,$a=`After pre-tokenization, a set of unique words has been created and the frequency with which each word occurred in the
training data has been determined. Next, BPE creates a base vocabulary consisting of all symbols that occur in the set
of unique words and learns merge rules to form a new symbol from two symbols of the base vocabulary. It does so until
the vocabulary has attained the desired vocabulary size. Note that the desired vocabulary size is a hyperparameter to
define before training the tokenizer.`,Ks,qt,za=`As an example, let’s assume that after pre-tokenization, the following set of words including their frequency has been
determined:`,Fs,vt,Ys,wt,Ia=`Consequently, the base vocabulary is <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Splitting all words into symbols of the
base vocabulary, we obtain:`,Os,Mt,te,jt,_a=`BPE then counts the frequency of each possible symbol pair and picks the symbol pair that occurs most frequently. In
the example above <code>&quot;h&quot;</code> followed by <code>&quot;u&quot;</code> is present <em>10 + 5 = 15</em> times (10 times in the 10 occurrences of
<code>&quot;hug&quot;</code>, 5 times in the 5 occurrences of <code>&quot;hugs&quot;</code>). However, the most frequent symbol pair is <code>&quot;u&quot;</code> followed by
<code>&quot;g&quot;</code>, occurring <em>10 + 5 + 5 = 20</em> times in total. Thus, the first merge rule the tokenizer learns is to group all
<code>&quot;u&quot;</code> symbols followed by a <code>&quot;g&quot;</code> symbol together. Next, <code>&quot;ug&quot;</code> is added to the vocabulary. The set of words then
becomes`,se,Tt,ee,kt,Ua=`BPE then identifies the next most common symbol pair. It’s <code>&quot;u&quot;</code> followed by <code>&quot;n&quot;</code>, which occurs 16 times. <code>&quot;u&quot;</code>,
<code>&quot;n&quot;</code> is merged to <code>&quot;un&quot;</code> and added to the vocabulary. The next most frequent symbol pair is <code>&quot;h&quot;</code> followed by
<code>&quot;ug&quot;</code>, occurring 15 times. Again the pair is merged and <code>&quot;hug&quot;</code> can be added to the vocabulary.`,ae,Jt,Ca=`At this stage, the vocabulary is <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;, &quot;ug&quot;, &quot;un&quot;, &quot;hug&quot;]</code> and our set of unique words
is represented as`,ne,xt,oe,$t,Pa=`Assuming, that the Byte-Pair Encoding training would stop at this point, the learned merge rules would then be applied
to new words (as long as those new words do not include symbols that were not in the base vocabulary). For instance,
the word <code>&quot;bug&quot;</code> would be tokenized to <code>[&quot;b&quot;, &quot;ug&quot;]</code> but <code>&quot;mug&quot;</code> would be tokenized as <code>[&quot;&lt;unk&gt;&quot;, &quot;ug&quot;]</code> since
the symbol <code>&quot;m&quot;</code> is not in the base vocabulary. In general, single letters such as <code>&quot;m&quot;</code> are not replaced by the
<code>&quot;&lt;unk&gt;&quot;</code> symbol because the training data usually includes at least one occurrence of each letter, but it is likely
to happen for very special characters like emojis.`,le,zt,Aa=`As mentioned earlier, the vocabulary size, <em>i.e.</em> the base vocabulary size + the number of merges, is a hyperparameter
to choose. For instance <a href="model_doc/gpt">GPT</a> has a vocabulary size of 40,478 since they have 478 base characters
and chose to stop training after 40,000 merges.`,ie,k,C,ps,It,Oe,Kt,La="Byte-level BPE",re,_t,Ea=`A base vocabulary that includes all possible base characters can be quite large if <em>e.g.</em> all unicode characters are
considered as base characters. To have a better base vocabulary, <a href="https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf" rel="nofollow">GPT-2</a> uses bytes
as the base vocabulary, which is a clever trick to force the base vocabulary to be of size 256 while ensuring that
every base character is included in the vocabulary. With some additional rules to deal with punctuation, the GPT2’s
tokenizer can tokenize every text without the need for the &lt;unk&gt; symbol. <a href="model_doc/gpt">GPT-2</a> has a vocabulary
size of 50,257, which corresponds to the 256 bytes base tokens, a special end-of-text token and the symbols learned
with 50,000 merges.`,pe,Ft,ue,J,P,us,Ut,ta,Yt,Ha="WordPiece",ce,Ct,Sa=`WordPiece is the subword tokenization algorithm used for <a href="model_doc/bert">BERT</a>, <a href="model_doc/distilbert">DistilBERT</a>, and <a href="model_doc/electra">Electra</a>. The algorithm was outlined in <a href="https://static.googleusercontent.com/media/research.google.com/ja//pubs/archive/37842.pdf" rel="nofollow">Japanese and Korean
Voice Search (Schuster et al., 2012)</a> and is very similar to
BPE. WordPiece first initializes the vocabulary to include every character present in the training data and
progressively learns a given number of merge rules. In contrast to BPE, WordPiece does not choose the most frequent
symbol pair, but the one that maximizes the likelihood of the training data once added to the vocabulary.`,he,Pt,Na=`So what does this mean exactly? Referring to the previous example, maximizing the likelihood of the training data is
equivalent to finding the symbol pair, whose probability divided by the probabilities of its first symbol followed by
its second symbol is the greatest among all symbol pairs. <em>E.g.</em> <code>&quot;u&quot;</code>, followed by <code>&quot;g&quot;</code> would have only been
merged if the probability of <code>&quot;ug&quot;</code> divided by <code>&quot;u&quot;</code>, <code>&quot;g&quot;</code> would have been greater than for any other symbol
pair. Intuitively, WordPiece is slightly different to BPE in that it evaluates what it <em>loses</em> by merging two symbols
to ensure it’s <em>worth it</em>.`,me,Ot,de,x,A,cs,At,sa,ts,Ba="Unigram",ge,Lt,Wa=`Unigram is a subword tokenization algorithm introduced in <a href="https://arxiv.org/pdf/1804.10959.pdf" rel="nofollow">Subword Regularization: Improving Neural Network Translation
Models with Multiple Subword Candidates (Kudo, 2018)</a>. In contrast to BPE or
WordPiece, Unigram initializes its base vocabulary to a large number of symbols and progressively trims down each
symbol to obtain a smaller vocabulary. The base vocabulary could for instance correspond to all pre-tokenized words and
the most common substrings. Unigram is not used directly for any of the models in the transformers, but it’s used in
conjunction with <a href="#sentencepiece">SentencePiece</a>.`,ye,Et,Da=`At each training step, the Unigram algorithm defines a loss (often defined as the log-likelihood) over the training
data given the current vocabulary and a unigram language model. Then, for each symbol in the vocabulary, the algorithm
computes how much the overall loss would increase if the symbol was to be removed from the vocabulary. Unigram then
removes p (with p usually being 10% or 20%) percent of the symbols whose loss increase is the lowest, <em>i.e.</em> those
symbols that least affect the overall loss over the training data. This process is repeated until the vocabulary has
reached the desired size. The Unigram algorithm always keeps the base characters so that any word can be tokenized.`,fe,Ht,Va=`Because Unigram is not based on merge rules (in contrast to BPE and WordPiece), the algorithm has several ways of
tokenizing new text after training. As an example, if a trained Unigram tokenizer exhibits the vocabulary:`,be,St,qe,Nt,Za=`<code>&quot;hugs&quot;</code> could be tokenized both as <code>[&quot;hug&quot;, &quot;s&quot;]</code>, <code>[&quot;h&quot;, &quot;ug&quot;, &quot;s&quot;]</code> or <code>[&quot;h&quot;, &quot;u&quot;, &quot;g&quot;, &quot;s&quot;]</code>. So which one
to choose? Unigram saves the probability of each token in the training corpus on top of saving the vocabulary so that
the probability of each possible tokenization can be computed after training. The algorithm simply picks the most
likely tokenization in practice, but also offers the possibility to sample a possible tokenization according to their
probabilities.`,ve,b,ea,we,dn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex">x_{1}, \\dots, x_{N}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Me,je,gn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex">x_{i}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Te,ke,yn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">S(x_{i})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Je,xe,ss,$e,fn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi mathvariant="script">L</mi><mo>=</mo><mo>−</mo><munderover><mo>∑</mo><mrow><mi>i</mi><mo>=</mo><mn>1</mn></mrow><mi>N</mi></munderover><mi>log</mi><mo>⁡</mo><mrow><mo fence="true">(</mo><munder><mo>∑</mo><mrow><mi>x</mi><mo>∈</mo><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow></munder><mi>p</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">\\mathcal{L} = -\\sum_{i=1}^{N} \\log \\left ( \\sum_{x \\in S(x_{i})} p(x) \\right )</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathcal">L</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.6em;vertical-align:-1.55em;"></span><span class="mord">−</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mrel mtight">=</span><span class="mord mtight">1</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1
c-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,
-36,557 l0,84c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,
949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9
c0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,
-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189
l0,-92c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,
-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.05em;"><span style="top:-1.809em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∈</span><span class="mord mathnormal mtight" style="margin-right:0.05764em;">S</span><span class="mopen mtight">(</span><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3281em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.516em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">p</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)</span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,
63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5
c11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0,9
c-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664
c-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11
c0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17
c242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558
l0,-144c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,
-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,ze,es,Ie,$,L,hs,Bt,aa,as,Ga="SentencePiece",_e,Wt,Qa=`All tokenization algorithms described so far have the same problem: It is assumed that the input text uses spaces to
separate words. However, not all languages use spaces to separate words. One possible solution is to use language
specific pre-tokenizers, <em>e.g.</em> <a href="model_doc/xlm">XLM</a> uses a specific Chinese, Japanese, and Thai pre-tokenizer).
To solve this problem more generally, <a href="https://arxiv.org/pdf/1808.06226.pdf" rel="nofollow">SentencePiece: A simple and language independent subword tokenizer and
detokenizer for Neural Text Processing (Kudo et al., 2018)</a> treats the input
as a raw input stream, thus including the space in the set of characters to use. It then uses the BPE or unigram
algorithm to construct the appropriate vocabulary.`,Ue,Dt,Xa=`The <a href="/docs/transformers/v4.33.3/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> uses SentencePiece for example, which is also why in the example earlier the
<code>&quot;▁&quot;</code> character was included in the vocabulary. Decoding with SentencePiece is very easy since all tokens can just be
concatenated and <code>&quot;▁&quot;</code> is replaced by a space.`,Ce,Vt,Ra=`All transformers models in the library that use SentencePiece use it in combination with unigram. Examples of models
using SentencePiece are <a href="model_doc/albert">ALBERT</a>, <a href="model_doc/xlnet">XLNet</a>, <a href="model_doc/marian">Marian</a>, and <a href="model_doc/t5">T5</a>.`,Pe,ms,Ae;return S=new H({}),N=new Tn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tokenizer_summary.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tokenizer_summary.ipynb"}]}}),W=new Xe({props:{id:"VFp38yj8h3A"}}),Z=new H({}),Q=new Xe({props:{id:"nhJxYji1aho"}}),R=new q({props:{code:"JTVCJTIyRG9uJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8uJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do.&quot;</span>]</span>'}}),F=new q({props:{code:"JTVCJTIyRG9uJTIyJTJDJTIwJTIyJyUyMiUyQyUyMCUyMnQlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>'}}),tt=new q({props:{code:"JTVCJTIyRG8lMjIlMkMlMjAlMjJuJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Do&quot;</span>, <span class="hljs-string">&quot;n&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>'}}),nt=new Xe({props:{id:"ssLq_EK2jLE"}}),lt=new H({}),it=new Xe({props:{id:"zHvTiHr506c"}}),ut=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiklMEF0b2tlbml6ZXIudG9rZW5pemUoJTIySSUyMGhhdmUlMjBhJTIwbmV3JTIwR1BVISUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;I have a new GPU!&quot;</span>)
[<span class="hljs-string">&quot;i&quot;</span>, <span class="hljs-string">&quot;have&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;new&quot;</span>, <span class="hljs-string">&quot;gp&quot;</span>, <span class="hljs-string">&quot;##u&quot;</span>, <span class="hljs-string">&quot;!&quot;</span>]`}}),mt=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnhsbmV0LWJhc2UtY2FzZWQlMjIpJTBBdG9rZW5pemVyLnRva2VuaXplKCUyMkRvbid0JTIweW91JTIwbG92ZSUyMCVGMCU5RiVBNCU5NyUyMFRyYW5zZm9ybWVycyUzRiUyMFdlJTIwc3VyZSUyMGRvLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLNetTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;Don&#x27;t you love 🤗 Transformers? We sure do.&quot;</span>)
[<span class="hljs-string">&quot;▁Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;▁you&quot;</span>, <span class="hljs-string">&quot;▁love&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;Transform&quot;</span>, <span class="hljs-string">&quot;ers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;▁We&quot;</span>, <span class="hljs-string">&quot;▁sure&quot;</span>, <span class="hljs-string">&quot;▁do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]`}}),yt=new H({}),vt=new q({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)'}}),Mt=new q({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)'}}),Tt=new q({props:{code:"KCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)'}}),xt=new q({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)'}}),It=new H({}),Ut=new H({}),At=new H({}),St=new q({props:{code:"JTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlMkMlMjAlMjJodWclMjIlNUQlMkM=",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]</span>,'}}),Bt=new H({}),{c(){v=n("meta"),ds=l(),ns=n("p"),gs=l(),w=n("h1"),z=n("a"),os=n("span"),h(S.$$.fragment),Re=l(),Zt=n("span"),Zt.textContent=oa,ys=l(),h(N.$$.fragment),fs=l(),B=n("p"),B.textContent=la,bs=l(),h(W.$$.fragment),qs=l(),D=n("p"),D.innerHTML=ia,vs=l(),V=n("p"),V.innerHTML=ra,ws=l(),M=n("h2"),I=n("a"),ls=n("span"),h(Z.$$.fragment),Ke=l(),Gt=n("span"),Gt.textContent=pa,Ms=l(),G=n("p"),G.innerHTML=ua,js=l(),h(Q.$$.fragment),Ts=l(),X=n("p"),X.textContent=ca,ks=l(),h(R.$$.fragment),Js=l(),K=n("p"),K.innerHTML=ha,xs=l(),h(F.$$.fragment),$s=l(),Y=n("p"),Y.innerHTML=ma,zs=l(),O=n("p"),O.innerHTML=da,Is=l(),h(tt.$$.fragment),_s=l(),st=n("p"),st.innerHTML=ga,Us=l(),et=n("p"),et.textContent=ya,Cs=l(),at=n("p"),at.textContent=fa,Ps=l(),h(nt.$$.fragment),As=l(),ot=n("p"),ot.innerHTML=ba,Ls=l(),j=n("h2"),_=n("a"),is=n("span"),h(lt.$$.fragment),Fe=l(),Qt=n("span"),Qt.textContent=qa,Es=l(),h(it.$$.fragment),Hs=l(),rt=n("p"),rt.innerHTML=va,Ss=l(),pt=n("p"),pt.innerHTML=wa,Ns=l(),h(ut.$$.fragment),Bs=l(),ct=n("p"),ct.innerHTML=Ma,Ws=l(),ht=n("p"),ht.innerHTML=ja,Ds=l(),h(mt.$$.fragment),Vs=l(),dt=n("p"),dt.innerHTML=Ta,Zs=l(),gt=n("p"),gt.textContent=ka,Gs=l(),Xt=n("a"),Qs=l(),T=n("h3"),U=n("a"),rs=n("span"),h(yt.$$.fragment),Ye=l(),Rt=n("span"),Rt.textContent=Ja,Xs=l(),ft=n("p"),ft.innerHTML=xa,Rs=l(),bt=n("p"),bt.textContent=$a,Ks=l(),qt=n("p"),qt.textContent=za,Fs=l(),h(vt.$$.fragment),Ys=l(),wt=n("p"),wt.innerHTML=Ia,Os=l(),h(Mt.$$.fragment),te=l(),jt=n("p"),jt.innerHTML=_a,se=l(),h(Tt.$$.fragment),ee=l(),kt=n("p"),kt.innerHTML=Ua,ae=l(),Jt=n("p"),Jt.innerHTML=Ca,ne=l(),h(xt.$$.fragment),oe=l(),$t=n("p"),$t.innerHTML=Pa,le=l(),zt=n("p"),zt.innerHTML=Aa,ie=l(),k=n("h4"),C=n("a"),ps=n("span"),h(It.$$.fragment),Oe=l(),Kt=n("span"),Kt.textContent=La,re=l(),_t=n("p"),_t.innerHTML=Ea,pe=l(),Ft=n("a"),ue=l(),J=n("h3"),P=n("a"),us=n("span"),h(Ut.$$.fragment),ta=l(),Yt=n("span"),Yt.textContent=Ha,ce=l(),Ct=n("p"),Ct.innerHTML=Sa,he=l(),Pt=n("p"),Pt.innerHTML=Na,me=l(),Ot=n("a"),de=l(),x=n("h3"),A=n("a"),cs=n("span"),h(At.$$.fragment),sa=l(),ts=n("span"),ts.textContent=Ba,ge=l(),Lt=n("p"),Lt.innerHTML=Wa,ye=l(),Et=n("p"),Et.innerHTML=Da,fe=l(),Ht=n("p"),Ht.textContent=Va,be=l(),h(St.$$.fragment),qe=l(),Nt=n("p"),Nt.innerHTML=Za,ve=l(),b=n("p"),ea=Ve(`Those probabilities are defined by the loss the tokenizer is trained on. Assuming that the training data consists of
the words `),we=new Ze(!1),Me=Ve(" and that the set of all possible tokenizations for a word "),je=new Ze(!1),Te=Ve(` is
defined as `),ke=new Ze(!1),Je=Ve(", then the overall loss is defined as"),xe=l(),ss=n("p"),$e=new Ze(!1),ze=l(),es=n("a"),Ie=l(),$=n("h3"),L=n("a"),hs=n("span"),h(Bt.$$.fragment),aa=l(),as=n("span"),as.textContent=Ga,_e=l(),Wt=n("p"),Wt.innerHTML=Qa,Ue=l(),Dt=n("p"),Dt.innerHTML=Xa,Ce=l(),Vt=n("p"),Vt.innerHTML=Ra,Pe=l(),ms=n("p"),this.h()},l(t){const e=jn("svelte-1phssyn",document.head);v=o(e,"META",{name:!0,content:!0}),e.forEach(s),ds=i(t),ns=o(t,"P",{}),c(ns).forEach(s),gs=i(t),w=o(t,"H1",{class:!0});var Le=c(w);z=o(Le,"A",{id:!0,class:!0,href:!0});var Ka=c(z);os=o(Ka,"SPAN",{});var Fa=c(os);m(S.$$.fragment,Fa),Fa.forEach(s),Ka.forEach(s),Re=i(Le),Zt=o(Le,"SPAN",{"data-svelte-h":!0}),r(Zt)!=="svelte-h4ysun"&&(Zt.textContent=oa),Le.forEach(s),ys=i(t),m(N.$$.fragment,t),fs=i(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1h07nug"&&(B.textContent=la),bs=i(t),m(W.$$.fragment,t),qs=i(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-ej4gda"&&(D.innerHTML=ia),vs=i(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1fczw90"&&(V.innerHTML=ra),ws=i(t),M=o(t,"H2",{class:!0});var Ee=c(M);I=o(Ee,"A",{id:!0,class:!0,href:!0});var Ya=c(I);ls=o(Ya,"SPAN",{});var Oa=c(ls);m(Z.$$.fragment,Oa),Oa.forEach(s),Ya.forEach(s),Ke=i(Ee),Gt=o(Ee,"SPAN",{"data-svelte-h":!0}),r(Gt)!=="svelte-hzp88l"&&(Gt.textContent=pa),Ee.forEach(s),Ms=i(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-67zbo9"&&(G.innerHTML=ua),js=i(t),m(Q.$$.fragment,t),Ts=i(t),X=o(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-s5zdmn"&&(X.textContent=ca),ks=i(t),m(R.$$.fragment,t),Js=i(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-14s15gf"&&(K.innerHTML=ha),xs=i(t),m(F.$$.fragment,t),$s=i(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-j1dyaf"&&(Y.innerHTML=ma),zs=i(t),O=o(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-11fbadg"&&(O.innerHTML=da),Is=i(t),m(tt.$$.fragment,t),_s=i(t),st=o(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1j9l5vm"&&(st.innerHTML=ga),Us=i(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1fz5yn1"&&(et.textContent=ya),Cs=i(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-16itca4"&&(at.textContent=fa),Ps=i(t),m(nt.$$.fragment,t),As=i(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-jqh0qv"&&(ot.innerHTML=ba),Ls=i(t),j=o(t,"H2",{class:!0});var He=c(j);_=o(He,"A",{id:!0,class:!0,href:!0});var tn=c(_);is=o(tn,"SPAN",{});var sn=c(is);m(lt.$$.fragment,sn),sn.forEach(s),tn.forEach(s),Fe=i(He),Qt=o(He,"SPAN",{"data-svelte-h":!0}),r(Qt)!=="svelte-89trsm"&&(Qt.textContent=qa),He.forEach(s),Es=i(t),m(it.$$.fragment,t),Hs=i(t),rt=o(t,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-1e53ypn"&&(rt.innerHTML=va),Ss=i(t),pt=o(t,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-1g4w645"&&(pt.innerHTML=wa),Ns=i(t),m(ut.$$.fragment,t),Bs=i(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1mzno7"&&(ct.innerHTML=Ma),Ws=i(t),ht=o(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-n5824r"&&(ht.innerHTML=ja),Ds=i(t),m(mt.$$.fragment,t),Vs=i(t),dt=o(t,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-uhdxhc"&&(dt.innerHTML=Ta),Zs=i(t),gt=o(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-129rtng"&&(gt.textContent=ka),Gs=i(t),Xt=o(t,"A",{id:!0}),c(Xt).forEach(s),Qs=i(t),T=o(t,"H3",{class:!0});var Se=c(T);U=o(Se,"A",{id:!0,class:!0,href:!0});var en=c(U);rs=o(en,"SPAN",{});var an=c(rs);m(yt.$$.fragment,an),an.forEach(s),en.forEach(s),Ye=i(Se),Rt=o(Se,"SPAN",{"data-svelte-h":!0}),r(Rt)!=="svelte-13sugzb"&&(Rt.textContent=Ja),Se.forEach(s),Xs=i(t),ft=o(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1ba546p"&&(ft.innerHTML=xa),Rs=i(t),bt=o(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-jfl55u"&&(bt.textContent=$a),Ks=i(t),qt=o(t,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-14qop42"&&(qt.textContent=za),Fs=i(t),m(vt.$$.fragment,t),Ys=i(t),wt=o(t,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-dnl63x"&&(wt.innerHTML=Ia),Os=i(t),m(Mt.$$.fragment,t),te=i(t),jt=o(t,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1ldwndq"&&(jt.innerHTML=_a),se=i(t),m(Tt.$$.fragment,t),ee=i(t),kt=o(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1tbuzqr"&&(kt.innerHTML=Ua),ae=i(t),Jt=o(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-ldb2oy"&&(Jt.innerHTML=Ca),ne=i(t),m(xt.$$.fragment,t),oe=i(t),$t=o(t,"P",{"data-svelte-h":!0}),r($t)!=="svelte-1y8lhzz"&&($t.innerHTML=Pa),le=i(t),zt=o(t,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-195xy43"&&(zt.innerHTML=Aa),ie=i(t),k=o(t,"H4",{class:!0});var Ne=c(k);C=o(Ne,"A",{id:!0,class:!0,href:!0});var nn=c(C);ps=o(nn,"SPAN",{});var on=c(ps);m(It.$$.fragment,on),on.forEach(s),nn.forEach(s),Oe=i(Ne),Kt=o(Ne,"SPAN",{"data-svelte-h":!0}),r(Kt)!=="svelte-7zzm5t"&&(Kt.textContent=La),Ne.forEach(s),re=i(t),_t=o(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-1nngf6"&&(_t.innerHTML=Ea),pe=i(t),Ft=o(t,"A",{id:!0}),c(Ft).forEach(s),ue=i(t),J=o(t,"H3",{class:!0});var Be=c(J);P=o(Be,"A",{id:!0,class:!0,href:!0});var ln=c(P);us=o(ln,"SPAN",{});var rn=c(us);m(Ut.$$.fragment,rn),rn.forEach(s),ln.forEach(s),ta=i(Be),Yt=o(Be,"SPAN",{"data-svelte-h":!0}),r(Yt)!=="svelte-19riald"&&(Yt.textContent=Ha),Be.forEach(s),ce=i(t),Ct=o(t,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-bqacvb"&&(Ct.innerHTML=Sa),he=i(t),Pt=o(t,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-q7cyms"&&(Pt.innerHTML=Na),me=i(t),Ot=o(t,"A",{id:!0}),c(Ot).forEach(s),de=i(t),x=o(t,"H3",{class:!0});var We=c(x);A=o(We,"A",{id:!0,class:!0,href:!0});var pn=c(A);cs=o(pn,"SPAN",{});var un=c(cs);m(At.$$.fragment,un),un.forEach(s),pn.forEach(s),sa=i(We),ts=o(We,"SPAN",{"data-svelte-h":!0}),r(ts)!=="svelte-kj2zr6"&&(ts.textContent=Ba),We.forEach(s),ge=i(t),Lt=o(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-uuczu6"&&(Lt.innerHTML=Wa),ye=i(t),Et=o(t,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-29pdu2"&&(Et.innerHTML=Da),fe=i(t),Ht=o(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-8otjbx"&&(Ht.textContent=Va),be=i(t),m(St.$$.fragment,t),qe=i(t),Nt=o(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1rs0qcq"&&(Nt.innerHTML=Za),ve=i(t),b=o(t,"P",{});var E=c(b);ea=Ge(E,`Those probabilities are defined by the loss the tokenizer is trained on. Assuming that the training data consists of
the words `),we=Qe(E,!1),Me=Ge(E," and that the set of all possible tokenizations for a word "),je=Qe(E,!1),Te=Ge(E,` is
defined as `),ke=Qe(E,!1),Je=Ge(E,", then the overall loss is defined as"),E.forEach(s),xe=i(t),ss=o(t,"P",{});var cn=c(ss);$e=Qe(cn,!1),cn.forEach(s),ze=i(t),es=o(t,"A",{id:!0}),c(es).forEach(s),Ie=i(t),$=o(t,"H3",{class:!0});var De=c($);L=o(De,"A",{id:!0,class:!0,href:!0});var hn=c(L);hs=o(hn,"SPAN",{});var mn=c(hs);m(Bt.$$.fragment,mn),mn.forEach(s),hn.forEach(s),aa=i(De),as=o(De,"SPAN",{"data-svelte-h":!0}),r(as)!=="svelte-17z98py"&&(as.textContent=Ga),De.forEach(s),_e=i(t),Wt=o(t,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-438wq2"&&(Wt.innerHTML=Qa),Ue=i(t),Dt=o(t,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-11mheso"&&(Dt.innerHTML=Xa),Ce=i(t),Vt=o(t,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-tl8004"&&(Vt.innerHTML=Ra),Pe=i(t),ms=o(t,"P",{}),c(ms).forEach(s),this.h()},h(){p(v,"name","hf:doc:metadata"),p(v,"content",JSON.stringify(Jn)),p(z,"id","summary-of-the-tokenizers"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#summary-of-the-tokenizers"),p(w,"class","relative group"),p(I,"id","introduction"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#introduction"),p(M,"class","relative group"),p(_,"id","subword-tokenization"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#subword-tokenization"),p(j,"class","relative group"),p(Xt,"id","byte-pair-encoding"),p(U,"id","bytepair-encoding-bpe"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#bytepair-encoding-bpe"),p(T,"class","relative group"),p(C,"id","bytelevel-bpe"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#bytelevel-bpe"),p(k,"class","relative group"),p(Ft,"id","wordpiece"),p(P,"id","wordpiece"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#wordpiece"),p(J,"class","relative group"),p(Ot,"id","unigram"),p(A,"id","unigram"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#unigram"),p(x,"class","relative group"),we.a=Me,je.a=Te,ke.a=Je,$e.a=null,p(es,"id","sentencepiece"),p(L,"id","sentencepiece"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#sentencepiece"),p($,"class","relative group")},m(t,e){u(document.head,v),a(t,ds,e),a(t,ns,e),a(t,gs,e),a(t,w,e),u(w,z),u(z,os),d(S,os,null),u(w,Re),u(w,Zt),a(t,ys,e),d(N,t,e),a(t,fs,e),a(t,B,e),a(t,bs,e),d(W,t,e),a(t,qs,e),a(t,D,e),a(t,vs,e),a(t,V,e),a(t,ws,e),a(t,M,e),u(M,I),u(I,ls),d(Z,ls,null),u(M,Ke),u(M,Gt),a(t,Ms,e),a(t,G,e),a(t,js,e),d(Q,t,e),a(t,Ts,e),a(t,X,e),a(t,ks,e),d(R,t,e),a(t,Js,e),a(t,K,e),a(t,xs,e),d(F,t,e),a(t,$s,e),a(t,Y,e),a(t,zs,e),a(t,O,e),a(t,Is,e),d(tt,t,e),a(t,_s,e),a(t,st,e),a(t,Us,e),a(t,et,e),a(t,Cs,e),a(t,at,e),a(t,Ps,e),d(nt,t,e),a(t,As,e),a(t,ot,e),a(t,Ls,e),a(t,j,e),u(j,_),u(_,is),d(lt,is,null),u(j,Fe),u(j,Qt),a(t,Es,e),d(it,t,e),a(t,Hs,e),a(t,rt,e),a(t,Ss,e),a(t,pt,e),a(t,Ns,e),d(ut,t,e),a(t,Bs,e),a(t,ct,e),a(t,Ws,e),a(t,ht,e),a(t,Ds,e),d(mt,t,e),a(t,Vs,e),a(t,dt,e),a(t,Zs,e),a(t,gt,e),a(t,Gs,e),a(t,Xt,e),a(t,Qs,e),a(t,T,e),u(T,U),u(U,rs),d(yt,rs,null),u(T,Ye),u(T,Rt),a(t,Xs,e),a(t,ft,e),a(t,Rs,e),a(t,bt,e),a(t,Ks,e),a(t,qt,e),a(t,Fs,e),d(vt,t,e),a(t,Ys,e),a(t,wt,e),a(t,Os,e),d(Mt,t,e),a(t,te,e),a(t,jt,e),a(t,se,e),d(Tt,t,e),a(t,ee,e),a(t,kt,e),a(t,ae,e),a(t,Jt,e),a(t,ne,e),d(xt,t,e),a(t,oe,e),a(t,$t,e),a(t,le,e),a(t,zt,e),a(t,ie,e),a(t,k,e),u(k,C),u(C,ps),d(It,ps,null),u(k,Oe),u(k,Kt),a(t,re,e),a(t,_t,e),a(t,pe,e),a(t,Ft,e),a(t,ue,e),a(t,J,e),u(J,P),u(P,us),d(Ut,us,null),u(J,ta),u(J,Yt),a(t,ce,e),a(t,Ct,e),a(t,he,e),a(t,Pt,e),a(t,me,e),a(t,Ot,e),a(t,de,e),a(t,x,e),u(x,A),u(A,cs),d(At,cs,null),u(x,sa),u(x,ts),a(t,ge,e),a(t,Lt,e),a(t,ye,e),a(t,Et,e),a(t,fe,e),a(t,Ht,e),a(t,be,e),d(St,t,e),a(t,qe,e),a(t,Nt,e),a(t,ve,e),a(t,b,e),u(b,ea),we.m(dn,b),u(b,Me),je.m(gn,b),u(b,Te),ke.m(yn,b),u(b,Je),a(t,xe,e),a(t,ss,e),$e.m(fn,ss),a(t,ze,e),a(t,es,e),a(t,Ie,e),a(t,$,e),u($,L),u(L,hs),d(Bt,hs,null),u($,aa),u($,as),a(t,_e,e),a(t,Wt,e),a(t,Ue,e),a(t,Dt,e),a(t,Ce,e),a(t,Vt,e),a(t,Pe,e),a(t,ms,e),Ae=!0},p:qn,i(t){Ae||(g(S.$$.fragment,t),g(N.$$.fragment,t),g(W.$$.fragment,t),g(Z.$$.fragment,t),g(Q.$$.fragment,t),g(R.$$.fragment,t),g(F.$$.fragment,t),g(tt.$$.fragment,t),g(nt.$$.fragment,t),g(lt.$$.fragment,t),g(it.$$.fragment,t),g(ut.$$.fragment,t),g(mt.$$.fragment,t),g(yt.$$.fragment,t),g(vt.$$.fragment,t),g(Mt.$$.fragment,t),g(Tt.$$.fragment,t),g(xt.$$.fragment,t),g(It.$$.fragment,t),g(Ut.$$.fragment,t),g(At.$$.fragment,t),g(St.$$.fragment,t),g(Bt.$$.fragment,t),Ae=!0)},o(t){y(S.$$.fragment,t),y(N.$$.fragment,t),y(W.$$.fragment,t),y(Z.$$.fragment,t),y(Q.$$.fragment,t),y(R.$$.fragment,t),y(F.$$.fragment,t),y(tt.$$.fragment,t),y(nt.$$.fragment,t),y(lt.$$.fragment,t),y(it.$$.fragment,t),y(ut.$$.fragment,t),y(mt.$$.fragment,t),y(yt.$$.fragment,t),y(vt.$$.fragment,t),y(Mt.$$.fragment,t),y(Tt.$$.fragment,t),y(xt.$$.fragment,t),y(It.$$.fragment,t),y(Ut.$$.fragment,t),y(At.$$.fragment,t),y(St.$$.fragment,t),y(Bt.$$.fragment,t),Ae=!1},d(t){t&&(s(ds),s(ns),s(gs),s(w),s(ys),s(fs),s(B),s(bs),s(qs),s(D),s(vs),s(V),s(ws),s(M),s(Ms),s(G),s(js),s(Ts),s(X),s(ks),s(Js),s(K),s(xs),s($s),s(Y),s(zs),s(O),s(Is),s(_s),s(st),s(Us),s(et),s(Cs),s(at),s(Ps),s(As),s(ot),s(Ls),s(j),s(Es),s(Hs),s(rt),s(Ss),s(pt),s(Ns),s(Bs),s(ct),s(Ws),s(ht),s(Ds),s(Vs),s(dt),s(Zs),s(gt),s(Gs),s(Xt),s(Qs),s(T),s(Xs),s(ft),s(Rs),s(bt),s(Ks),s(qt),s(Fs),s(Ys),s(wt),s(Os),s(te),s(jt),s(se),s(ee),s(kt),s(ae),s(Jt),s(ne),s(oe),s($t),s(le),s(zt),s(ie),s(k),s(re),s(_t),s(pe),s(Ft),s(ue),s(J),s(ce),s(Ct),s(he),s(Pt),s(me),s(Ot),s(de),s(x),s(ge),s(Lt),s(ye),s(Et),s(fe),s(Ht),s(be),s(qe),s(Nt),s(ve),s(b),s(xe),s(ss),s(ze),s(es),s(Ie),s($),s(_e),s(Wt),s(Ue),s(Dt),s(Ce),s(Vt),s(Pe),s(ms)),s(v),f(S),f(N,t),f(W,t),f(Z),f(Q,t),f(R,t),f(F,t),f(tt,t),f(nt,t),f(lt),f(it,t),f(ut,t),f(mt,t),f(yt),f(vt,t),f(Mt,t),f(Tt,t),f(xt,t),f(It),f(Ut),f(At),f(St,t),f(Bt)}}}const Jn={local:"summary-of-the-tokenizers",sections:[{local:"introduction",title:"Introduction"},{local:"subword-tokenization",sections:[{local:"bytepair-encoding-bpe",sections:[{local:"bytelevel-bpe",title:"Byte-level BPE"}],title:"Byte-Pair Encoding (BPE)"},{local:"wordpiece",title:"WordPiece"},{local:"unigram",title:"Unigram"},{local:"sentencepiece",title:"SentencePiece"}],title:"Subword tokenization"}],title:"Summary of the tokenizers"};function xn(na){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pn extends wn{constructor(v){super(),Mn(this,v,xn,kn,bn,{})}}export{Pn as component};
