import{s as Tn,f as jn,o as Jn,n as I}from"../chunks/scheduler.9bc65507.js";import{S as Un,i as xn,g as p,s as a,r as h,A as $n,h as m,f as o,c as r,j as J,u as g,x as M,k as j,y as i,a as d,v as u,d as f,t as b,w as _}from"../chunks/index.707bf1b6.js";import{T as Oe}from"../chunks/Tip.c2ecdbf4.js";import{D as U}from"../chunks/Docstring.17db21ae.js";import{C as A}from"../chunks/CodeBlock.54a9f38d.js";import{E as te}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as N}from"../chunks/Heading.342b1fa6.js";function In(T){let t,w=`The architecture of OWLv2 is identical to <a href="owlvit">OWL-ViT</a>, however the object detection head now also includes an objectness classifier, which predicts the (query-agnostic) likelihood that a predicted box contains an object (as opposed to background). The objectness score can be used to rank or filter predictions independently of text queries.
Usage of OWLv2 is identical to <a href="owlvit">OWL-ViT</a> with a new, updated image processor (<a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>).`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-2n5g77"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function zn(T){let t,w="Example:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVGV4dENvbmZpZyUyQyUyME93bHYyVGV4dE1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVGV4dE1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlRleHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlRleHRDb25maWclMjBmcm9tJTIwdGhlJTIwZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPd2x2MlRleHRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2TextConfig, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2TextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2TextConfig from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Cn(T){let t,w="Example:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME93bHYyVmlzaW9uQ29uZmlnJTJDJTIwT3dsdjJWaXNpb25Nb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBPd2x2MlZpc2lvbk1vZGVsJTIwd2l0aCUyMGdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBPd2x2MlZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME93bHYyVmlzaW9uTW9kZWwlMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2VisionConfig, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel with google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Owlv2VisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Owlv2VisionModel model from the google/owlv2-base-patch16 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-11lpom8"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function On(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Wn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTVEJTJDJTIwaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHNfcGVyX2ltYWdlJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHNfcGVyX2ltYWdlJTIwJTIwJTIzJTIwdGhpcyUyMGlzJTIwdGhlJTIwaW1hZ2UtdGV4dCUyMHNpbWlsYXJpdHklMjBzY29yZSUwQXByb2JzJTIwJTNEJTIwbG9naXRzX3Blcl9pbWFnZS5zb2Z0bWF4KGRpbSUzRDEpJTIwJTIwJTIzJTIwd2UlMjBjYW4lMjB0YWtlJTIwdGhlJTIwc29mdG1heCUyMHRvJTIwZ2V0JTIwdGhlJTIwbGFiZWwlMjBwcm9iYWJpbGl0aWVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]], images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_per_image = outputs.logits_per_image  <span class="hljs-comment"># this is the image-text similarity score</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits_per_image.softmax(dim=<span class="hljs-number">1</span>)  <span class="hljs-comment"># we can take the softmax to get the label probabilities</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function kn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Zn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2Mk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBPd2x2Mk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGb3dsdjItYmFzZS1wYXRjaDE2LWVuc2VtYmxlJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTVCJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwY2F0JTIyJTJDJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhJTIwZG9nJTIyJTVEJTJDJTIwJTVCJTIycGhvdG8lMjBvZiUyMGElMjBhc3RyYW5hdXQlMjIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKSUwQXRleHRfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfdGV4dF9mZWF0dXJlcygqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text_features = model.get_text_features(**inputs)`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Vn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Nn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNi1lbnNlbWJsZSUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYtZW5zZW1ibGUlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW1hZ2VfZmVhdHVyZXMlMjAlM0QlMjBtb2RlbC5nZXRfaW1hZ2VfZmVhdHVyZXMoKippbnB1dHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2Model

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2Model.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_features = model.get_image_features(**inputs)`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Bn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Fn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBPd2x2MlRleHRNb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwT3dsdjJUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlNUIlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBjYXQlMjIlMkMlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGElMjBkb2clMjIlNUQlMkMlMjAlNUIlMjJwaG90byUyMG9mJTIwYSUyMGFzdHJhbmF1dCUyMiU1RCU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjAoRU9TJTIwdG9rZW4pJTIwc3RhdGVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2TextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2TextModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>], [<span class="hljs-string">&quot;photo of a astranaut&quot;</span>]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled (EOS token) states</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Hn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Rn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME93bHYyVmlzaW9uTW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyME93bHYyVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRm93bHYyLWJhc2UtcGF0Y2gxNiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZvd2x2Mi1iYXNlLXBhdGNoMTYlMjIpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlZF9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQlMjAlMjAlMjMlMjBwb29sZWQlMjBDTFMlMjBzdGF0ZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2VisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2VisionModel.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooled_output = outputs.pooler_output  <span class="hljs-comment"># pooled CLS states</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Gn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function En(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.utils.constants <span class="hljs-keyword">import</span> OPENAI_CLIP_MEAN, OPENAI_CLIP_STD

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note: boxes need to be visualized on the padded, unnormalized image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># hence we&#x27;ll set the target image sizes (height, width) based on that</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_preprocessed_image</span>(<span class="hljs-params">pixel_values</span>):
<span class="hljs-meta">... </span>    pixel_values = pixel_values.squeeze().numpy()
<span class="hljs-meta">... </span>    unnormalized_image = (pixel_values * np.array(OPENAI_CLIP_STD)[:, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]) + np.array(OPENAI_CLIP_MEAN)[:, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    unnormalized_image = (unnormalized_image * <span class="hljs-number">255</span>).astype(np.uint8)
<span class="hljs-meta">... </span>    unnormalized_image = np.moveaxis(unnormalized_image, <span class="hljs-number">0</span>, -<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    unnormalized_image = Image.fromarray(unnormalized_image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> unnormalized_image

<span class="hljs-meta">&gt;&gt;&gt; </span>unnormalized_image = get_preprocessed_image(inputs.pixel_values)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([unnormalized_image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to final bounding boxes and scores</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_object_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.2</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = texts[i]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">512.5</span>, <span class="hljs-number">35.08</span>, <span class="hljs-number">963.48</span>, <span class="hljs-number">557.02</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">10.13</span>, <span class="hljs-number">77.94</span>, <span class="hljs-number">489.93</span>, <span class="hljs-number">709.69</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Xn(T){let t,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=w},l(l){t=m(l,"P",{"data-svelte-h":!0}),M(t)!=="svelte-fincs2"&&(t.innerHTML=w)},m(l,c){d(l,t,c)},p:I,d(l){l&&o(t)}}}function Pn(T){let t,w="Examples:",l,c,v;return c=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Owlv2ForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.utils.constants <span class="hljs-keyword">import</span> OPENAI_CLIP_MEAN, OPENAI_CLIP_STD

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>query_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000001675.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>query_image = Image.<span class="hljs-built_in">open</span>(requests.get(query_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, query_images=query_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model.image_guided_detection(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note: boxes need to be visualized on the padded, unnormalized image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># hence we&#x27;ll set the target image sizes (height, width) based on that</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_preprocessed_image</span>(<span class="hljs-params">pixel_values</span>):
<span class="hljs-meta">... </span>    pixel_values = pixel_values.squeeze().numpy()
<span class="hljs-meta">... </span>    unnormalized_image = (pixel_values * np.array(OPENAI_CLIP_STD)[:, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]) + np.array(OPENAI_CLIP_MEAN)[:, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
<span class="hljs-meta">... </span>    unnormalized_image = (unnormalized_image * <span class="hljs-number">255</span>).astype(np.uint8)
<span class="hljs-meta">... </span>    unnormalized_image = np.moveaxis(unnormalized_image, <span class="hljs-number">0</span>, -<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    unnormalized_image = Image.fromarray(unnormalized_image)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> unnormalized_image

<span class="hljs-meta">&gt;&gt;&gt; </span>unnormalized_image = get_preprocessed_image(inputs.pixel_values)

<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([unnormalized_image.size[::-<span class="hljs-number">1</span>]])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_image_guided_detection(
<span class="hljs-meta">... </span>    outputs=outputs, threshold=<span class="hljs-number">0.9</span>, nms_threshold=<span class="hljs-number">0.3</span>, target_sizes=target_sizes
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected similar object with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.938</span> at location [<span class="hljs-number">490.96</span>, <span class="hljs-number">109.89</span>, <span class="hljs-number">821.09</span>, <span class="hljs-number">536.11</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.959</span> at location [<span class="hljs-number">8.67</span>, <span class="hljs-number">721.29</span>, <span class="hljs-number">928.68</span>, <span class="hljs-number">732.78</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.902</span> at location [<span class="hljs-number">4.27</span>, <span class="hljs-number">720.02</span>, <span class="hljs-number">941.45</span>, <span class="hljs-number">761.59</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">265.46</span>, -<span class="hljs-number">58.9</span>, <span class="hljs-number">1009.04</span>, <span class="hljs-number">365.66</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">1.0</span> at location [<span class="hljs-number">9.79</span>, <span class="hljs-number">28.69</span>, <span class="hljs-number">937.31</span>, <span class="hljs-number">941.64</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">869.97</span>, <span class="hljs-number">58.28</span>, <span class="hljs-number">923.23</span>, <span class="hljs-number">978.1</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.985</span> at location [<span class="hljs-number">309.23</span>, <span class="hljs-number">21.07</span>, <span class="hljs-number">371.61</span>, <span class="hljs-number">932.02</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.947</span> at location [<span class="hljs-number">27.93</span>, <span class="hljs-number">859.45</span>, <span class="hljs-number">969.75</span>, <span class="hljs-number">915.44</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.996</span> at location [<span class="hljs-number">785.82</span>, <span class="hljs-number">41.38</span>, <span class="hljs-number">880.26</span>, <span class="hljs-number">966.37</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.998</span> at location [<span class="hljs-number">5.08</span>, <span class="hljs-number">721.17</span>, <span class="hljs-number">925.93</span>, <span class="hljs-number">998.41</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.969</span> at location [<span class="hljs-number">6.7</span>, <span class="hljs-number">898.1</span>, <span class="hljs-number">921.75</span>, <span class="hljs-number">949.51</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.966</span> at location [<span class="hljs-number">47.16</span>, <span class="hljs-number">927.29</span>, <span class="hljs-number">981.99</span>, <span class="hljs-number">942.14</span>]
Detected similar <span class="hljs-built_in">object</span> <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.924</span> at location [<span class="hljs-number">46.4</span>, <span class="hljs-number">936.13</span>, <span class="hljs-number">953.02</span>, <span class="hljs-number">950.78</span>]`,wrap:!1}}),{c(){t=p("p"),t.textContent=w,l=a(),h(c.$$.fragment)},l(s){t=m(s,"P",{"data-svelte-h":!0}),M(t)!=="svelte-kvfsh7"&&(t.textContent=w),l=r(s),g(c.$$.fragment,s)},m(s,y){d(s,t,y),d(s,l,y),u(c,s,y),v=!0},p:I,i(s){v||(f(c.$$.fragment,s),v=!0)},o(s){b(c.$$.fragment,s),v=!1},d(s){s&&(o(t),o(l)),_(c,s)}}}function Ln(T){let t,w,l,c,v,s,y,ns,We,Go='OWLv2 was proposed in <a href="https://arxiv.org/abs/2306.09683" rel="nofollow">Scaling Open-Vocabulary Object Detection</a> by Matthias Minderer, Alexey Gritsenko, Neil Houlsby. OWLv2 scales up <a href="owlvit">OWL-ViT</a> using self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. This results in large gains over the previous state-of-the-art for zero-shot object detection.',as,ke,Eo="The abstract from the paper is the following:",rs,Ze,Xo="<em>Open-vocabulary object detection has benefited greatly from pretrained vision-language models, but is still limited by the amount of available detection training data. While detection training data can be expanded by using Web image-text pairs as weak supervision, this has not been done at scales comparable to image-level pretraining. Here, we scale up detection data with self-training, which uses an existing detector to generate pseudo-box annotations on image-text pairs. Major challenges in scaling self-training are the choice of label space, pseudo-annotation filtering, and training efficiency. We present the OWLv2 model and OWL-ST self-training recipe, which address these challenges. OWLv2 surpasses the performance of previous state-of-the-art open-vocabulary detectors already at comparable training scales (~10M examples). However, with OWL-ST, we can scale to over 1B examples, yielding further large improvement: With an L/14 architecture, OWL-ST improves AP on LVIS rare classes, for which the model has seen no human box annotations, from 31.2% to 44.6% (43% relative improvement). OWL-ST unlocks Web-scale training for open-world localization, similar to what has been seen for image classification and language modelling.</em>",ls,se,Po,is,Ve,Lo='OWLv2 high-level overview. Taken from the <a href="https://arxiv.org/abs/2306.09683">original paper</a>.',cs,Ne,qo=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/google-research/scenic/tree/main/scenic/projects/owl_vit" rel="nofollow">here</a>.`,ds,Be,ps,Fe,Qo='OWLv2 is, just like its predecessor <a href="owlvit">OWL-ViT</a>, a zero-shot text-conditioned object detection model. OWL-ViT uses <a href="clip">CLIP</a> as its multi-modal backbone, with a ViT-like Transformer to get visual features and a causal language model to get the text features. To use CLIP for detection, OWL-ViT removes the final token pooling layer of the vision model and attaches a lightweight classification and box head to each transformer output token. Open-vocabulary classification is enabled by replacing the fixed classification layer weights with the class-name embeddings obtained from the text model. The authors first train CLIP from scratch and fine-tune it end-to-end with the classification and box heads on standard detection datasets using a bipartite matching loss. One or multiple text queries per image can be used to perform zero-shot text-conditioned object detection.',ms,He,Yo='<a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> can be used to resize (or rescale) and normalize images for the model and <a href="/docs/transformers/v4.36.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> is used to encode the text. <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> wraps <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both encode the text and prepare the images. The following example shows how to perform object detection using <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Processor">Owlv2Processor</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a>.',hs,Re,gs,Ge,us,Ee,Do='<li>A demo notebook on using OWLv2 for zero- and one-shot (image-guided) object detection can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OWLv2" rel="nofollow">here</a>.</li> <li><a href="../tasks/zero_shot_object_detection">Zero-shot object detection task guide</a></li>',fs,oe,bs,Xe,_s,W,Pe,Fs,Ct,So=`<a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> is the configuration class to store the configuration of an <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a>. It is used to
instantiate an OWLv2 model according to the specified arguments, defining the text model and vision model
configs. Instantiating a configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Hs,Ot,Ao=`Configuration objects inherit from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Rs,ne,Le,Gs,Wt,Ko=`Instantiate a <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Config">Owlv2Config</a> (or a derived class) from owlv2 text model configuration and owlv2 vision
model configuration.`,ws,qe,vs,k,Qe,Es,kt,en=`This is the configuration class to store the configuration of an <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>. It is used to instantiate an
Owlv2 text encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Owlv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,Xs,Zt,tn=`Configuration objects inherit from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ps,ae,Ms,Ye,ys,Z,De,Ls,Vt,sn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a>. It is used to instantiate
an OWLv2 image encoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OWLv2
<a href="https://huggingface.co/google/owlv2-base-patch16" rel="nofollow">google/owlv2-base-patch16</a> architecture.`,qs,Nt,on=`Configuration objects inherit from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.36.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qs,re,Ts,Se,js,z,Ae,Ys,Bt,nn="Constructs an OWLv2 image processor.",Ds,le,Ke,Ss,Ft,an="Preprocess an image or batch of images.",As,ie,et,Ks,Ht,rn=`Converts the raw output of <a href="/docs/transformers/v4.36.0/en/model_doc/owlvit#transformers.OwlViTForObjectDetection">OwlViTForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,eo,ce,tt,to,Rt,ln=`Converts the output of <a href="/docs/transformers/v4.36.0/en/model_doc/owlvit#transformers.OwlViTForObjectDetection.image_guided_detection">OwlViTForObjectDetection.image_guided_detection()</a> into the format expected by the COCO
api.`,Js,st,Us,x,ot,so,Gt,cn=`Constructs an Owlv2 processor which wraps <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/v4.36.0/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into
a single processor that interits both the image processor and tokenizer functionalities. See the
<code>__call__()</code> and <a href="/docs/transformers/v4.36.0/en/model_doc/owlvit#transformers.OwlViTProcessor.decode">decode()</a> for more information.`,oo,de,nt,no,Et,dn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/v4.36.0/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,ao,pe,at,ro,Xt,pn=`This method forwards all its arguments to CLIPTokenizerFast’s <a href="/docs/transformers/v4.36.0/en/model_doc/speecht5#transformers.SpeechT5Tokenizer.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,lo,me,rt,io,Pt,mn=`This method forwards all its arguments to <code>OwlViTImageProcessor.post_process_one_shot_object_detection</code>.
Please refer to the docstring of this method for more information.`,co,he,lt,po,Lt,hn=`This method forwards all its arguments to <a href="/docs/transformers/v4.36.0/en/model_doc/owlvit#transformers.OwlViTImageProcessor.post_process_object_detection">OwlViTImageProcessor.post_process_object_detection()</a>. Please refer
to the docstring of this method for more information.`,xs,it,$s,$,ct,mo,qt,gn=`This model inherits from <a href="/docs/transformers/v4.36.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ho,Qt,un=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,go,B,dt,uo,Yt,fn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',fo,ge,bo,ue,_o,F,pt,wo,Dt,bn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',vo,fe,Mo,be,yo,H,mt,To,St,_n='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Model">Owlv2Model</a> forward method, overrides the <code>__call__</code> special method.',jo,_e,Jo,we,Is,ht,zs,K,gt,Uo,R,ut,xo,At,wn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a> forward method, overrides the <code>__call__</code> special method.',$o,ve,Io,Me,Cs,ft,Os,ee,bt,zo,G,_t,Co,Kt,vn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel">Owlv2VisionModel</a> forward method, overrides the <code>__call__</code> special method.',Oo,ye,Wo,Te,Ws,wt,ks,P,vt,ko,E,Mt,Zo,es,Mn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Vo,je,No,Je,Bo,X,yt,Fo,ts,yn='The <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ForObjectDetection">Owlv2ForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Ho,Ue,Ro,xe,Zs,os,Vs;return v=new N({props:{title:"OWLv2",local:"owlv2",headingTag:"h1"}}),y=new N({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Be=new N({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Re=new A({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Owlv2Processor, Owlv2ForObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = Owlv2Processor.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Owlv2ForObjectDetection.from_pretrained(<span class="hljs-string">&quot;google/owlv2-base-patch16-ensemble&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>texts = [[<span class="hljs-string">&quot;a photo of a cat&quot;</span>, <span class="hljs-string">&quot;a photo of a dog&quot;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=texts, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Target image sizes (height, width) to rescale box predictions [batch_size, 2]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.Tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_object_detection(outputs=outputs, target_sizes=target_sizes, threshold=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>i = <span class="hljs-number">0</span>  <span class="hljs-comment"># Retrieve predictions for the first image for the corresponding text queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = texts[i]
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes, scores, labels = results[i][<span class="hljs-string">&quot;boxes&quot;</span>], results[i][<span class="hljs-string">&quot;scores&quot;</span>], results[i][<span class="hljs-string">&quot;labels&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(boxes, scores, labels):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text[label]}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.614</span> at location [<span class="hljs-number">341.67</span>, <span class="hljs-number">17.54</span>, <span class="hljs-number">642.32</span>, <span class="hljs-number">278.51</span>]
Detected a photo of a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.665</span> at location [<span class="hljs-number">6.75</span>, <span class="hljs-number">38.97</span>, <span class="hljs-number">326.62</span>, <span class="hljs-number">354.85</span>]`,wrap:!1}}),Ge=new N({props:{title:"Resources",local:"resources",headingTag:"h2"}}),oe=new Oe({props:{$$slots:{default:[In]},$$scope:{ctx:T}}}),Xe=new N({props:{title:"Owlv2Config",local:"transformers.Owlv2Config",headingTag:"h2"}}),Pe=new U({props:{name:"class transformers.Owlv2Config",anchor:"transformers.Owlv2Config",parameters:[{name:"text_config",val:" = None"},{name:"vision_config",val:" = None"},{name:"projection_dim",val:" = 512"},{name:"logit_scale_init_value",val:" = 2.6592"},{name:"return_dict",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Config.text_config",description:`<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextConfig">Owlv2TextConfig</a>.`,name:"text_config"},{anchor:"transformers.Owlv2Config.vision_config",description:`<strong>vision_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Dictionary of configuration options used to initialize <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionConfig">Owlv2VisionConfig</a>.`,name:"vision_config"},{anchor:"transformers.Owlv2Config.projection_dim",description:`<strong>projection_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of text and vision projection layers.`,name:"projection_dim"},{anchor:"transformers.Owlv2Config.logit_scale_init_value",description:`<strong>logit_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 2.6592) &#x2014;
The inital value of the <em>logit_scale</em> parameter. Default is used as per the original OWLv2
implementation.`,name:"logit_scale_init_value"},{anchor:"transformers.Owlv2Config.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return a dictionary. If <code>False</code>, returns a tuple.`,name:"return_dict"},{anchor:"transformers.Owlv2Config.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/configuration_owlv2.py#L256"}}),Le=new U({props:{name:"from_text_vision_configs",anchor:"transformers.Owlv2Config.from_text_vision_configs",parameters:[{name:"text_config",val:": typing.Dict"},{name:"vision_config",val:": typing.Dict"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/configuration_owlv2.py#L325",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2Config"
>Owlv2Config</a></p>
`}}),qe=new N({props:{title:"Owlv2TextConfig",local:"transformers.Owlv2TextConfig",headingTag:"h2"}}),Qe=new U({props:{name:"class transformers.Owlv2TextConfig",anchor:"transformers.Owlv2TextConfig",parameters:[{name:"vocab_size",val:" = 49408"},{name:"hidden_size",val:" = 512"},{name:"intermediate_size",val:" = 2048"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 8"},{name:"max_position_embeddings",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 49406"},{name:"eos_token_id",val:" = 49407"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size of the OWLv2 text model. Defines the number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel">Owlv2TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Owlv2TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.Owlv2TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> \`<code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2TextConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2TextConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2TextConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"},{anchor:"transformers.Owlv2TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The id of the padding token in the input sequences.`,name:"pad_token_id"},{anchor:"transformers.Owlv2TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49406) &#x2014;
The id of the beginning-of-sequence token in the input sequences.`,name:"bos_token_id"},{anchor:"transformers.Owlv2TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 49407) &#x2014;
The id of the end-of-sequence token in the input sequences.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/configuration_owlv2.py#L36"}}),ae=new te({props:{anchor:"transformers.Owlv2TextConfig.example",$$slots:{default:[zn]},$$scope:{ctx:T}}}),Ye=new N({props:{title:"Owlv2VisionConfig",local:"transformers.Owlv2VisionConfig",headingTag:"h2"}}),De=new U({props:{name:"class transformers.Owlv2VisionConfig",anchor:"transformers.Owlv2VisionConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"intermediate_size",val:" = 3072"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"num_channels",val:" = 3"},{name:"image_size",val:" = 768"},{name:"patch_size",val:" = 16"},{name:"hidden_act",val:" = 'quick_gelu'"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"attention_dropout",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"initializer_factor",val:" = 1.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Owlv2VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Owlv2VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Owlv2VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Owlv2VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input images.`,name:"num_channels"},{anchor:"transformers.Owlv2VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.Owlv2VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Owlv2VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;quick_gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> \`<code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Owlv2VisionConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.Owlv2VisionConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.Owlv2VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Owlv2VisionConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A factor for initializing all weight matrices (should be kept to 1, used internally for initialization
testing).`,name:"initializer_factor"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/configuration_owlv2.py#L150"}}),re=new te({props:{anchor:"transformers.Owlv2VisionConfig.example",$$slots:{default:[Cn]},$$scope:{ctx:T}}}),Se=new N({props:{title:"Owlv2ImageProcessor",local:"transformers.Owlv2ImageProcessor",headingTag:"h2"}}),Ae=new U({props:{name:"class transformers.Owlv2ImageProcessor",anchor:"transformers.Owlv2ImageProcessor",parameters:[{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_pad",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right. Can be overriden by
<code>do_pad</code> in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 960, &quot;width&quot;: 960}</code>):
Size to resize the image to. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling method to use if resizing the image. Can be overriden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.Owlv2ImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>OPENAI_CLIP_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/image_processing_owlv2.py#L176"}}),Ke=new U({props:{name:"preprocess",anchor:"transformers.Owlv2ImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_pad",val:": bool = None"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square with gray pixels on the bottom and the right.`,name:"do_pad"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size to resize the image to.`,name:"size"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.Owlv2ImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/image_processing_owlv2.py#L333"}}),et=new U({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/image_processing_owlv2.py#L464",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),tt=new U({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:" = 0.0"},{name:"nms_threshold",val:" = 0.3"},{name:"target_sizes",val:" = None"}],parametersDescription:[{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.outputs",description:`<strong>outputs</strong> (<code>OwlViTImageGuidedObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Minimum confidence threshold to use to filter out predicted boxes.`,name:"threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.nms_threshold",description:`<strong>nms_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
IoU threshold for non-maximum suppression of overlapping boxes.`,name:"nms_threshold"},{anchor:"transformers.Owlv2ImageProcessor.post_process_image_guided_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Tensor of shape (batch_size, 2) where each entry is the (height, width) of the corresponding image in
the batch. If set, predicted normalized bounding boxes are rescaled to the target sizes. If left to
None, predictions will not be unnormalized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/image_processing_owlv2.py#L520",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model. All labels are set to None as
<code>OwlViTForObjectDetection.image_guided_detection</code> perform one-shot object detection.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),st=new N({props:{title:"Owlv2Processor",local:"transformers.Owlv2Processor",headingTag:"h2"}}),ot=new U({props:{name:"class transformers.Owlv2Processor",anchor:"transformers.Owlv2Processor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Owlv2Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor">Owlv2ImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Owlv2Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/processing_owlv2.py#L28"}}),nt=new U({props:{name:"batch_decode",anchor:"transformers.Owlv2Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/processing_owlv2.py#L178"}}),at=new U({props:{name:"decode",anchor:"transformers.Owlv2Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/processing_owlv2.py#L186"}}),rt=new U({props:{name:"post_process_image_guided_detection",anchor:"transformers.Owlv2Processor.post_process_image_guided_detection",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/processing_owlv2.py#L170"}}),lt=new U({props:{name:"post_process_object_detection",anchor:"transformers.Owlv2Processor.post_process_object_detection",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/processing_owlv2.py#L162"}}),it=new N({props:{title:"Owlv2Model",local:"transformers.Owlv2Model",headingTag:"h2"}}),ct=new U({props:{name:"class transformers.Owlv2Model",anchor:"transformers.Owlv2Model",parameters:[{name:"config",val:": Owlv2Config"}],parametersDescription:[{anchor:"transformers.Owlv2Model.config",description:`<strong>config</strong> (<code>Owvl2Config</code>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.36.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1016"}}),dt=new U({props:{name:"forward",anchor:"transformers.Owlv2Model.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"return_loss",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_base_image_embeds",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.36.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.forward.return_loss",description:`<strong>return_loss</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the contrastive loss.`,name:"return_loss"},{anchor:"transformers.Owlv2Model.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.forward.return_base_image_embeds",description:`<strong>return_base_image_embeds</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the base image embeddings.`,name:"return_base_image_embeds"},{anchor:"transformers.Owlv2Model.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1131",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>return_loss</code> is <code>True</code>) — Contrastive loss for image-text similarity.</li>
<li><strong>logits_per_image</strong> (<code>torch.FloatTensor</code> of shape <code>(image_batch_size, text_batch_size)</code>) — The scaled dot product scores between <code>image_embeds</code> and <code>text_embeds</code>. This represents the image-text
similarity scores.</li>
<li><strong>logits_per_text</strong> (<code>torch.FloatTensor</code> of shape <code>(text_batch_size, image_batch_size)</code>) — The scaled dot product scores between <code>text_embeds</code> and <code>image_embeds</code>. This represents the text-image
similarity scores.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>) — The image embeddings obtained by applying the projection layer to the pooled output of
<a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2Output</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Oe({props:{$$slots:{default:[On]},$$scope:{ctx:T}}}),ue=new te({props:{anchor:"transformers.Owlv2Model.forward.example",$$slots:{default:[Wn]},$$scope:{ctx:T}}}),pt=new U({props:{name:"get_text_features",anchor:"transformers.Owlv2Model.get_text_features",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_text_features.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.36.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2Model.get_text_features.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2Model.get_text_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_text_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_text_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1051",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The text embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>text_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),fe=new Oe({props:{$$slots:{default:[kn]},$$scope:{ctx:T}}}),be=new te({props:{anchor:"transformers.Owlv2Model.get_text_features.example",$$slots:{default:[Zn]},$$scope:{ctx:T}}}),mt=new U({props:{name:"get_image_features",anchor:"transformers.Owlv2Model.get_image_features",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2Model.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2Model.get_image_features.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2Model.get_image_features.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2Model.get_image_features.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1086",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The image embeddings obtained by
applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.FloatTensor</code> of shape <code>(batch_size, output_dim</code>)</p>
`}}),_e=new Oe({props:{$$slots:{default:[Vn]},$$scope:{ctx:T}}}),we=new te({props:{anchor:"transformers.Owlv2Model.get_image_features.example",$$slots:{default:[Nn]},$$scope:{ctx:T}}}),ht=new N({props:{title:"Owlv2TextModel",local:"transformers.Owlv2TextModel",headingTag:"h2"}}),gt=new U({props:{name:"class transformers.Owlv2TextModel",anchor:"transformers.Owlv2TextModel",parameters:[{name:"config",val:": Owlv2TextConfig"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L852"}}),ut=new U({props:{name:"forward",anchor:"transformers.Owlv2TextModel.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.36.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>`,name:"input_ids"},{anchor:"transformers.Owlv2TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L867",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2TextConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new Oe({props:{$$slots:{default:[Bn]},$$scope:{ctx:T}}}),Me=new te({props:{anchor:"transformers.Owlv2TextModel.forward.example",$$slots:{default:[Fn]},$$scope:{ctx:T}}}),ft=new N({props:{title:"Owlv2VisionModel",local:"transformers.Owlv2VisionModel",headingTag:"h2"}}),bt=new U({props:{name:"class transformers.Owlv2VisionModel",anchor:"transformers.Owlv2VisionModel",parameters:[{name:"config",val:": Owlv2VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L964"}}),_t=new U({props:{name:"forward",anchor:"transformers.Owlv2VisionModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2VisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2VisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2VisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2VisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L977",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2VisionConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new Oe({props:{$$slots:{default:[Hn]},$$scope:{ctx:T}}}),Te=new te({props:{anchor:"transformers.Owlv2VisionModel.forward.example",$$slots:{default:[Rn]},$$scope:{ctx:T}}}),wt=new N({props:{title:"Owlv2ForObjectDetection",local:"transformers.Owlv2ForObjectDetection",headingTag:"h2"}}),vt=new U({props:{name:"class transformers.Owlv2ForObjectDetection",anchor:"transformers.Owlv2ForObjectDetection",parameters:[{name:"config",val:": Owlv2Config"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1300"}}),Mt=new U({props:{name:"forward",anchor:"transformers.Owlv2ForObjectDetection.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"pixel_values",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Indices can be obtained using <a href="/docs/transformers/v4.36.0/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See
<a href="/docs/transformers/v4.36.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/v4.36.0/en/model_doc/perceiver#transformers.PerceiverTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details. <a href="../glossary#input-ids">What are input
IDs?</a>.`,name:"input_ids"},{anchor:"transformers.Owlv2ForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_max_text_queries, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="../glossary#attention-mask">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"transformers.Owlv2ForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the last hidden state. See <code>text_model_last_hidden_state</code> and
<code>vision_model_last_hidden_state</code> under returned tensors for more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1654",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>objectness_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 1)</code>) — The objectness logits of all image patches. OWL-ViT represents images as a set of image patches where the
total number of patches is (image_size / patch_size)**2.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>text_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_max_text_queries, output_dim</code>) — The text embeddings obtained by applying the projection layer to the pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes image
embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),je=new Oe({props:{$$slots:{default:[Gn]},$$scope:{ctx:T}}}),Je=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.forward.example",$$slots:{default:[En]},$$scope:{ctx:T}}}),yt=new U({props:{name:"image_guided_detection",anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"query_pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values.`,name:"pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.query_pixel_values",description:`<strong>query_pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values of query image(s) to be detected. Pass in one query image per target image.`,name:"query_pixel_values"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.36.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.36.0/src/transformers/models/owlv2/modeling_owlv2.py#L1529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.owlv2.configuration_owlv2.Owlv2Config'&gt;</code>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, num_queries)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>target_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual target image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>query_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual query image in the batch
(disregarding possible padding). You can use <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2ImageProcessor.post_process_object_detection"
>post_process_object_detection()</a> to
retrieve the unnormalized bounding boxes.</li>
<li><strong>image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>query_image_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size, patch_size, output_dim</code>) — Pooled output of <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>. OWLv2 represents images as a set of image patches and computes
image embeddings for each patch.</li>
<li><strong>class_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) — Class embeddings of all image patches. OWLv2 represents images as a set of image patches where the total
number of patches is (image_size / patch_size)**2.</li>
<li><strong>text_model_output</strong> (Tuple<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2TextModel"
>Owlv2TextModel</a>.</li>
<li><strong>vision_model_output</strong> (<code>BaseModelOutputWithPooling</code>) — The output of the <a
  href="/docs/transformers/v4.36.0/en/model_doc/owlv2#transformers.Owlv2VisionModel"
>Owlv2VisionModel</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.owlv2.modeling_owlv2.Owlv2ImageGuidedObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ue=new Oe({props:{$$slots:{default:[Xn]},$$scope:{ctx:T}}}),xe=new te({props:{anchor:"transformers.Owlv2ForObjectDetection.image_guided_detection.example",$$slots:{default:[Pn]},$$scope:{ctx:T}}}),{c(){t=p("meta"),w=a(),l=p("p"),c=a(),h(v.$$.fragment),s=a(),h(y.$$.fragment),ns=a(),We=p("p"),We.innerHTML=Go,as=a(),ke=p("p"),ke.textContent=Eo,rs=a(),Ze=p("p"),Ze.innerHTML=Xo,ls=a(),se=p("img"),is=a(),Ve=p("small"),Ve.innerHTML=Lo,cs=a(),Ne=p("p"),Ne.innerHTML=qo,ds=a(),h(Be.$$.fragment),ps=a(),Fe=p("p"),Fe.innerHTML=Qo,ms=a(),He=p("p"),He.innerHTML=Yo,hs=a(),h(Re.$$.fragment),gs=a(),h(Ge.$$.fragment),us=a(),Ee=p("ul"),Ee.innerHTML=Do,fs=a(),h(oe.$$.fragment),bs=a(),h(Xe.$$.fragment),_s=a(),W=p("div"),h(Pe.$$.fragment),Fs=a(),Ct=p("p"),Ct.innerHTML=So,Hs=a(),Ot=p("p"),Ot.innerHTML=Ao,Rs=a(),ne=p("div"),h(Le.$$.fragment),Gs=a(),Wt=p("p"),Wt.innerHTML=Ko,ws=a(),h(qe.$$.fragment),vs=a(),k=p("div"),h(Qe.$$.fragment),Es=a(),kt=p("p"),kt.innerHTML=en,Xs=a(),Zt=p("p"),Zt.innerHTML=tn,Ps=a(),h(ae.$$.fragment),Ms=a(),h(Ye.$$.fragment),ys=a(),Z=p("div"),h(De.$$.fragment),Ls=a(),Vt=p("p"),Vt.innerHTML=sn,qs=a(),Nt=p("p"),Nt.innerHTML=on,Qs=a(),h(re.$$.fragment),Ts=a(),h(Se.$$.fragment),js=a(),z=p("div"),h(Ae.$$.fragment),Ys=a(),Bt=p("p"),Bt.textContent=nn,Ds=a(),le=p("div"),h(Ke.$$.fragment),Ss=a(),Ft=p("p"),Ft.textContent=an,As=a(),ie=p("div"),h(et.$$.fragment),Ks=a(),Ht=p("p"),Ht.innerHTML=rn,eo=a(),ce=p("div"),h(tt.$$.fragment),to=a(),Rt=p("p"),Rt.innerHTML=ln,Js=a(),h(st.$$.fragment),Us=a(),x=p("div"),h(ot.$$.fragment),so=a(),Gt=p("p"),Gt.innerHTML=cn,oo=a(),de=p("div"),h(nt.$$.fragment),no=a(),Et=p("p"),Et.innerHTML=dn,ao=a(),pe=p("div"),h(at.$$.fragment),ro=a(),Xt=p("p"),Xt.innerHTML=pn,lo=a(),me=p("div"),h(rt.$$.fragment),io=a(),Pt=p("p"),Pt.innerHTML=mn,co=a(),he=p("div"),h(lt.$$.fragment),po=a(),Lt=p("p"),Lt.innerHTML=hn,xs=a(),h(it.$$.fragment),$s=a(),$=p("div"),h(ct.$$.fragment),mo=a(),qt=p("p"),qt.innerHTML=gn,ho=a(),Qt=p("p"),Qt.innerHTML=un,go=a(),B=p("div"),h(dt.$$.fragment),uo=a(),Yt=p("p"),Yt.innerHTML=fn,fo=a(),h(ge.$$.fragment),bo=a(),h(ue.$$.fragment),_o=a(),F=p("div"),h(pt.$$.fragment),wo=a(),Dt=p("p"),Dt.innerHTML=bn,vo=a(),h(fe.$$.fragment),Mo=a(),h(be.$$.fragment),yo=a(),H=p("div"),h(mt.$$.fragment),To=a(),St=p("p"),St.innerHTML=_n,jo=a(),h(_e.$$.fragment),Jo=a(),h(we.$$.fragment),Is=a(),h(ht.$$.fragment),zs=a(),K=p("div"),h(gt.$$.fragment),Uo=a(),R=p("div"),h(ut.$$.fragment),xo=a(),At=p("p"),At.innerHTML=wn,$o=a(),h(ve.$$.fragment),Io=a(),h(Me.$$.fragment),Cs=a(),h(ft.$$.fragment),Os=a(),ee=p("div"),h(bt.$$.fragment),zo=a(),G=p("div"),h(_t.$$.fragment),Co=a(),Kt=p("p"),Kt.innerHTML=vn,Oo=a(),h(ye.$$.fragment),Wo=a(),h(Te.$$.fragment),Ws=a(),h(wt.$$.fragment),ks=a(),P=p("div"),h(vt.$$.fragment),ko=a(),E=p("div"),h(Mt.$$.fragment),Zo=a(),es=p("p"),es.innerHTML=Mn,Vo=a(),h(je.$$.fragment),No=a(),h(Je.$$.fragment),Bo=a(),X=p("div"),h(yt.$$.fragment),Fo=a(),ts=p("p"),ts.innerHTML=yn,Ho=a(),h(Ue.$$.fragment),Ro=a(),h(xe.$$.fragment),Zs=a(),os=p("p"),this.h()},l(e){const n=$n("svelte-u9bgzb",document.head);t=m(n,"META",{name:!0,content:!0}),n.forEach(o),w=r(e),l=m(e,"P",{}),J(l).forEach(o),c=r(e),g(v.$$.fragment,e),s=r(e),g(y.$$.fragment,e),ns=r(e),We=m(e,"P",{"data-svelte-h":!0}),M(We)!=="svelte-1jjmdbl"&&(We.innerHTML=Go),as=r(e),ke=m(e,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-vfdo9a"&&(ke.textContent=Eo),rs=r(e),Ze=m(e,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-17v2uvw"&&(Ze.innerHTML=Xo),ls=r(e),se=m(e,"IMG",{src:!0,alt:!0,width:!0}),is=r(e),Ve=m(e,"SMALL",{"data-svelte-h":!0}),M(Ve)!=="svelte-a4adom"&&(Ve.innerHTML=Lo),cs=r(e),Ne=m(e,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-h0sl6k"&&(Ne.innerHTML=qo),ds=r(e),g(Be.$$.fragment,e),ps=r(e),Fe=m(e,"P",{"data-svelte-h":!0}),M(Fe)!=="svelte-44ncwu"&&(Fe.innerHTML=Qo),ms=r(e),He=m(e,"P",{"data-svelte-h":!0}),M(He)!=="svelte-itweff"&&(He.innerHTML=Yo),hs=r(e),g(Re.$$.fragment,e),gs=r(e),g(Ge.$$.fragment,e),us=r(e),Ee=m(e,"UL",{"data-svelte-h":!0}),M(Ee)!=="svelte-yomnb6"&&(Ee.innerHTML=Do),fs=r(e),g(oe.$$.fragment,e),bs=r(e),g(Xe.$$.fragment,e),_s=r(e),W=m(e,"DIV",{class:!0});var L=J(W);g(Pe.$$.fragment,L),Fs=r(L),Ct=m(L,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-1sox2s5"&&(Ct.innerHTML=So),Hs=r(L),Ot=m(L,"P",{"data-svelte-h":!0}),M(Ot)!=="svelte-1qljms5"&&(Ot.innerHTML=Ao),Rs=r(L),ne=m(L,"DIV",{class:!0});var Tt=J(ne);g(Le.$$.fragment,Tt),Gs=r(Tt),Wt=m(Tt,"P",{"data-svelte-h":!0}),M(Wt)!=="svelte-iu1cj4"&&(Wt.innerHTML=Ko),Tt.forEach(o),L.forEach(o),ws=r(e),g(qe.$$.fragment,e),vs=r(e),k=m(e,"DIV",{class:!0});var q=J(k);g(Qe.$$.fragment,q),Es=r(q),kt=m(q,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-1l7p47z"&&(kt.innerHTML=en),Xs=r(q),Zt=m(q,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-1qljms5"&&(Zt.innerHTML=tn),Ps=r(q),g(ae.$$.fragment,q),q.forEach(o),Ms=r(e),g(Ye.$$.fragment,e),ys=r(e),Z=m(e,"DIV",{class:!0});var Q=J(Z);g(De.$$.fragment,Q),Ls=r(Q),Vt=m(Q,"P",{"data-svelte-h":!0}),M(Vt)!=="svelte-19jmnhj"&&(Vt.innerHTML=sn),qs=r(Q),Nt=m(Q,"P",{"data-svelte-h":!0}),M(Nt)!=="svelte-1qljms5"&&(Nt.innerHTML=on),Qs=r(Q),g(re.$$.fragment,Q),Q.forEach(o),Ts=r(e),g(Se.$$.fragment,e),js=r(e),z=m(e,"DIV",{class:!0});var V=J(z);g(Ae.$$.fragment,V),Ys=r(V),Bt=m(V,"P",{"data-svelte-h":!0}),M(Bt)!=="svelte-dzqrng"&&(Bt.textContent=nn),Ds=r(V),le=m(V,"DIV",{class:!0});var jt=J(le);g(Ke.$$.fragment,jt),Ss=r(jt),Ft=m(jt,"P",{"data-svelte-h":!0}),M(Ft)!=="svelte-1x3yxsa"&&(Ft.textContent=an),jt.forEach(o),As=r(V),ie=m(V,"DIV",{class:!0});var Jt=J(ie);g(et.$$.fragment,Jt),Ks=r(Jt),Ht=m(Jt,"P",{"data-svelte-h":!0}),M(Ht)!=="svelte-11qym8d"&&(Ht.innerHTML=rn),Jt.forEach(o),eo=r(V),ce=m(V,"DIV",{class:!0});var Ut=J(ce);g(tt.$$.fragment,Ut),to=r(Ut),Rt=m(Ut,"P",{"data-svelte-h":!0}),M(Rt)!=="svelte-1czfp0y"&&(Rt.innerHTML=ln),Ut.forEach(o),V.forEach(o),Js=r(e),g(st.$$.fragment,e),Us=r(e),x=m(e,"DIV",{class:!0});var C=J(x);g(ot.$$.fragment,C),so=r(C),Gt=m(C,"P",{"data-svelte-h":!0}),M(Gt)!=="svelte-ijpnyb"&&(Gt.innerHTML=cn),oo=r(C),de=m(C,"DIV",{class:!0});var xt=J(de);g(nt.$$.fragment,xt),no=r(xt),Et=m(xt,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-rhkuvm"&&(Et.innerHTML=dn),xt.forEach(o),ao=r(C),pe=m(C,"DIV",{class:!0});var $t=J(pe);g(at.$$.fragment,$t),ro=r($t),Xt=m($t,"P",{"data-svelte-h":!0}),M(Xt)!=="svelte-t7uovo"&&(Xt.innerHTML=pn),$t.forEach(o),lo=r(C),me=m(C,"DIV",{class:!0});var It=J(me);g(rt.$$.fragment,It),io=r(It),Pt=m(It,"P",{"data-svelte-h":!0}),M(Pt)!=="svelte-13us65f"&&(Pt.innerHTML=mn),It.forEach(o),co=r(C),he=m(C,"DIV",{class:!0});var zt=J(he);g(lt.$$.fragment,zt),po=r(zt),Lt=m(zt,"P",{"data-svelte-h":!0}),M(Lt)!=="svelte-evwadh"&&(Lt.innerHTML=hn),zt.forEach(o),C.forEach(o),xs=r(e),g(it.$$.fragment,e),$s=r(e),$=m(e,"DIV",{class:!0});var O=J($);g(ct.$$.fragment,O),mo=r(O),qt=m(O,"P",{"data-svelte-h":!0}),M(qt)!=="svelte-11ko49a"&&(qt.innerHTML=gn),ho=r(O),Qt=m(O,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-hswkmf"&&(Qt.innerHTML=un),go=r(O),B=m(O,"DIV",{class:!0});var Y=J(B);g(dt.$$.fragment,Y),uo=r(Y),Yt=m(Y,"P",{"data-svelte-h":!0}),M(Yt)!=="svelte-1f3fyjr"&&(Yt.innerHTML=fn),fo=r(Y),g(ge.$$.fragment,Y),bo=r(Y),g(ue.$$.fragment,Y),Y.forEach(o),_o=r(O),F=m(O,"DIV",{class:!0});var D=J(F);g(pt.$$.fragment,D),wo=r(D),Dt=m(D,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-1f3fyjr"&&(Dt.innerHTML=bn),vo=r(D),g(fe.$$.fragment,D),Mo=r(D),g(be.$$.fragment,D),D.forEach(o),yo=r(O),H=m(O,"DIV",{class:!0});var S=J(H);g(mt.$$.fragment,S),To=r(S),St=m(S,"P",{"data-svelte-h":!0}),M(St)!=="svelte-1f3fyjr"&&(St.innerHTML=_n),jo=r(S),g(_e.$$.fragment,S),Jo=r(S),g(we.$$.fragment,S),S.forEach(o),O.forEach(o),Is=r(e),g(ht.$$.fragment,e),zs=r(e),K=m(e,"DIV",{class:!0});var Ns=J(K);g(gt.$$.fragment,Ns),Uo=r(Ns),R=m(Ns,"DIV",{class:!0});var $e=J(R);g(ut.$$.fragment,$e),xo=r($e),At=m($e,"P",{"data-svelte-h":!0}),M(At)!=="svelte-bgbs1p"&&(At.innerHTML=wn),$o=r($e),g(ve.$$.fragment,$e),Io=r($e),g(Me.$$.fragment,$e),$e.forEach(o),Ns.forEach(o),Cs=r(e),g(ft.$$.fragment,e),Os=r(e),ee=m(e,"DIV",{class:!0});var Bs=J(ee);g(bt.$$.fragment,Bs),zo=r(Bs),G=m(Bs,"DIV",{class:!0});var Ie=J(G);g(_t.$$.fragment,Ie),Co=r(Ie),Kt=m(Ie,"P",{"data-svelte-h":!0}),M(Kt)!=="svelte-x771hn"&&(Kt.innerHTML=vn),Oo=r(Ie),g(ye.$$.fragment,Ie),Wo=r(Ie),g(Te.$$.fragment,Ie),Ie.forEach(o),Bs.forEach(o),Ws=r(e),g(wt.$$.fragment,e),ks=r(e),P=m(e,"DIV",{class:!0});var ss=J(P);g(vt.$$.fragment,ss),ko=r(ss),E=m(ss,"DIV",{class:!0});var ze=J(E);g(Mt.$$.fragment,ze),Zo=r(ze),es=m(ze,"P",{"data-svelte-h":!0}),M(es)!=="svelte-lteqx5"&&(es.innerHTML=Mn),Vo=r(ze),g(je.$$.fragment,ze),No=r(ze),g(Je.$$.fragment,ze),ze.forEach(o),Bo=r(ss),X=m(ss,"DIV",{class:!0});var Ce=J(X);g(yt.$$.fragment,Ce),Fo=r(Ce),ts=m(Ce,"P",{"data-svelte-h":!0}),M(ts)!=="svelte-lteqx5"&&(ts.innerHTML=yn),Ho=r(Ce),g(Ue.$$.fragment,Ce),Ro=r(Ce),g(xe.$$.fragment,Ce),Ce.forEach(o),ss.forEach(o),Zs=r(e),os=m(e,"P",{}),J(os).forEach(o),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",qn),jn(se.src,Po="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/owlv2_overview.png")||j(se,"src",Po),j(se,"alt","drawing"),j(se,"width","600"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,t),d(e,w,n),d(e,l,n),d(e,c,n),u(v,e,n),d(e,s,n),u(y,e,n),d(e,ns,n),d(e,We,n),d(e,as,n),d(e,ke,n),d(e,rs,n),d(e,Ze,n),d(e,ls,n),d(e,se,n),d(e,is,n),d(e,Ve,n),d(e,cs,n),d(e,Ne,n),d(e,ds,n),u(Be,e,n),d(e,ps,n),d(e,Fe,n),d(e,ms,n),d(e,He,n),d(e,hs,n),u(Re,e,n),d(e,gs,n),u(Ge,e,n),d(e,us,n),d(e,Ee,n),d(e,fs,n),u(oe,e,n),d(e,bs,n),u(Xe,e,n),d(e,_s,n),d(e,W,n),u(Pe,W,null),i(W,Fs),i(W,Ct),i(W,Hs),i(W,Ot),i(W,Rs),i(W,ne),u(Le,ne,null),i(ne,Gs),i(ne,Wt),d(e,ws,n),u(qe,e,n),d(e,vs,n),d(e,k,n),u(Qe,k,null),i(k,Es),i(k,kt),i(k,Xs),i(k,Zt),i(k,Ps),u(ae,k,null),d(e,Ms,n),u(Ye,e,n),d(e,ys,n),d(e,Z,n),u(De,Z,null),i(Z,Ls),i(Z,Vt),i(Z,qs),i(Z,Nt),i(Z,Qs),u(re,Z,null),d(e,Ts,n),u(Se,e,n),d(e,js,n),d(e,z,n),u(Ae,z,null),i(z,Ys),i(z,Bt),i(z,Ds),i(z,le),u(Ke,le,null),i(le,Ss),i(le,Ft),i(z,As),i(z,ie),u(et,ie,null),i(ie,Ks),i(ie,Ht),i(z,eo),i(z,ce),u(tt,ce,null),i(ce,to),i(ce,Rt),d(e,Js,n),u(st,e,n),d(e,Us,n),d(e,x,n),u(ot,x,null),i(x,so),i(x,Gt),i(x,oo),i(x,de),u(nt,de,null),i(de,no),i(de,Et),i(x,ao),i(x,pe),u(at,pe,null),i(pe,ro),i(pe,Xt),i(x,lo),i(x,me),u(rt,me,null),i(me,io),i(me,Pt),i(x,co),i(x,he),u(lt,he,null),i(he,po),i(he,Lt),d(e,xs,n),u(it,e,n),d(e,$s,n),d(e,$,n),u(ct,$,null),i($,mo),i($,qt),i($,ho),i($,Qt),i($,go),i($,B),u(dt,B,null),i(B,uo),i(B,Yt),i(B,fo),u(ge,B,null),i(B,bo),u(ue,B,null),i($,_o),i($,F),u(pt,F,null),i(F,wo),i(F,Dt),i(F,vo),u(fe,F,null),i(F,Mo),u(be,F,null),i($,yo),i($,H),u(mt,H,null),i(H,To),i(H,St),i(H,jo),u(_e,H,null),i(H,Jo),u(we,H,null),d(e,Is,n),u(ht,e,n),d(e,zs,n),d(e,K,n),u(gt,K,null),i(K,Uo),i(K,R),u(ut,R,null),i(R,xo),i(R,At),i(R,$o),u(ve,R,null),i(R,Io),u(Me,R,null),d(e,Cs,n),u(ft,e,n),d(e,Os,n),d(e,ee,n),u(bt,ee,null),i(ee,zo),i(ee,G),u(_t,G,null),i(G,Co),i(G,Kt),i(G,Oo),u(ye,G,null),i(G,Wo),u(Te,G,null),d(e,Ws,n),u(wt,e,n),d(e,ks,n),d(e,P,n),u(vt,P,null),i(P,ko),i(P,E),u(Mt,E,null),i(E,Zo),i(E,es),i(E,Vo),u(je,E,null),i(E,No),u(Je,E,null),i(P,Bo),i(P,X),u(yt,X,null),i(X,Fo),i(X,ts),i(X,Ho),u(Ue,X,null),i(X,Ro),u(xe,X,null),d(e,Zs,n),d(e,os,n),Vs=!0},p(e,[n]){const L={};n&2&&(L.$$scope={dirty:n,ctx:e}),oe.$set(L);const Tt={};n&2&&(Tt.$$scope={dirty:n,ctx:e}),ae.$set(Tt);const q={};n&2&&(q.$$scope={dirty:n,ctx:e}),re.$set(q);const Q={};n&2&&(Q.$$scope={dirty:n,ctx:e}),ge.$set(Q);const V={};n&2&&(V.$$scope={dirty:n,ctx:e}),ue.$set(V);const jt={};n&2&&(jt.$$scope={dirty:n,ctx:e}),fe.$set(jt);const Jt={};n&2&&(Jt.$$scope={dirty:n,ctx:e}),be.$set(Jt);const Ut={};n&2&&(Ut.$$scope={dirty:n,ctx:e}),_e.$set(Ut);const C={};n&2&&(C.$$scope={dirty:n,ctx:e}),we.$set(C);const xt={};n&2&&(xt.$$scope={dirty:n,ctx:e}),ve.$set(xt);const $t={};n&2&&($t.$$scope={dirty:n,ctx:e}),Me.$set($t);const It={};n&2&&(It.$$scope={dirty:n,ctx:e}),ye.$set(It);const zt={};n&2&&(zt.$$scope={dirty:n,ctx:e}),Te.$set(zt);const O={};n&2&&(O.$$scope={dirty:n,ctx:e}),je.$set(O);const Y={};n&2&&(Y.$$scope={dirty:n,ctx:e}),Je.$set(Y);const D={};n&2&&(D.$$scope={dirty:n,ctx:e}),Ue.$set(D);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),xe.$set(S)},i(e){Vs||(f(v.$$.fragment,e),f(y.$$.fragment,e),f(Be.$$.fragment,e),f(Re.$$.fragment,e),f(Ge.$$.fragment,e),f(oe.$$.fragment,e),f(Xe.$$.fragment,e),f(Pe.$$.fragment,e),f(Le.$$.fragment,e),f(qe.$$.fragment,e),f(Qe.$$.fragment,e),f(ae.$$.fragment,e),f(Ye.$$.fragment,e),f(De.$$.fragment,e),f(re.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(at.$$.fragment,e),f(rt.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(pt.$$.fragment,e),f(fe.$$.fragment,e),f(be.$$.fragment,e),f(mt.$$.fragment,e),f(_e.$$.fragment,e),f(we.$$.fragment,e),f(ht.$$.fragment,e),f(gt.$$.fragment,e),f(ut.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(ft.$$.fragment,e),f(bt.$$.fragment,e),f(_t.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(Mt.$$.fragment,e),f(je.$$.fragment,e),f(Je.$$.fragment,e),f(yt.$$.fragment,e),f(Ue.$$.fragment,e),f(xe.$$.fragment,e),Vs=!0)},o(e){b(v.$$.fragment,e),b(y.$$.fragment,e),b(Be.$$.fragment,e),b(Re.$$.fragment,e),b(Ge.$$.fragment,e),b(oe.$$.fragment,e),b(Xe.$$.fragment,e),b(Pe.$$.fragment,e),b(Le.$$.fragment,e),b(qe.$$.fragment,e),b(Qe.$$.fragment,e),b(ae.$$.fragment,e),b(Ye.$$.fragment,e),b(De.$$.fragment,e),b(re.$$.fragment,e),b(Se.$$.fragment,e),b(Ae.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(st.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),b(it.$$.fragment,e),b(ct.$$.fragment,e),b(dt.$$.fragment,e),b(ge.$$.fragment,e),b(ue.$$.fragment,e),b(pt.$$.fragment,e),b(fe.$$.fragment,e),b(be.$$.fragment,e),b(mt.$$.fragment,e),b(_e.$$.fragment,e),b(we.$$.fragment,e),b(ht.$$.fragment,e),b(gt.$$.fragment,e),b(ut.$$.fragment,e),b(ve.$$.fragment,e),b(Me.$$.fragment,e),b(ft.$$.fragment,e),b(bt.$$.fragment,e),b(_t.$$.fragment,e),b(ye.$$.fragment,e),b(Te.$$.fragment,e),b(wt.$$.fragment,e),b(vt.$$.fragment,e),b(Mt.$$.fragment,e),b(je.$$.fragment,e),b(Je.$$.fragment,e),b(yt.$$.fragment,e),b(Ue.$$.fragment,e),b(xe.$$.fragment,e),Vs=!1},d(e){e&&(o(w),o(l),o(c),o(s),o(ns),o(We),o(as),o(ke),o(rs),o(Ze),o(ls),o(se),o(is),o(Ve),o(cs),o(Ne),o(ds),o(ps),o(Fe),o(ms),o(He),o(hs),o(gs),o(us),o(Ee),o(fs),o(bs),o(_s),o(W),o(ws),o(vs),o(k),o(Ms),o(ys),o(Z),o(Ts),o(js),o(z),o(Js),o(Us),o(x),o(xs),o($s),o($),o(Is),o(zs),o(K),o(Cs),o(Os),o(ee),o(Ws),o(ks),o(P),o(Zs),o(os)),o(t),_(v,e),_(y,e),_(Be,e),_(Re,e),_(Ge,e),_(oe,e),_(Xe,e),_(Pe),_(Le),_(qe,e),_(Qe),_(ae),_(Ye,e),_(De),_(re),_(Se,e),_(Ae),_(Ke),_(et),_(tt),_(st,e),_(ot),_(nt),_(at),_(rt),_(lt),_(it,e),_(ct),_(dt),_(ge),_(ue),_(pt),_(fe),_(be),_(mt),_(_e),_(we),_(ht,e),_(gt),_(ut),_(ve),_(Me),_(ft,e),_(bt),_(_t),_(ye),_(Te),_(wt,e),_(vt),_(Mt),_(je),_(Je),_(yt),_(Ue),_(xe)}}}const qn='{"title":"OWLv2","local":"owlv2","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Owlv2Config","local":"transformers.Owlv2Config","sections":[],"depth":2},{"title":"Owlv2TextConfig","local":"transformers.Owlv2TextConfig","sections":[],"depth":2},{"title":"Owlv2VisionConfig","local":"transformers.Owlv2VisionConfig","sections":[],"depth":2},{"title":"Owlv2ImageProcessor","local":"transformers.Owlv2ImageProcessor","sections":[],"depth":2},{"title":"Owlv2Processor","local":"transformers.Owlv2Processor","sections":[],"depth":2},{"title":"Owlv2Model","local":"transformers.Owlv2Model","sections":[],"depth":2},{"title":"Owlv2TextModel","local":"transformers.Owlv2TextModel","sections":[],"depth":2},{"title":"Owlv2VisionModel","local":"transformers.Owlv2VisionModel","sections":[],"depth":2},{"title":"Owlv2ForObjectDetection","local":"transformers.Owlv2ForObjectDetection","sections":[],"depth":2}],"depth":1}';function Qn(T){return Jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class sa extends Un{constructor(t){super(),xn(this,t,Qn,Ln,Tn,{})}}export{sa as component};
