import{s as Tt,f as wt,o as xt,n as Ve}from"../chunks/scheduler.9bc65507.js";import{S as $t,i as Mt,g as c,s,r as h,A as jt,h as d,f as t,c as a,j as M,u as g,x as y,k as x,y as i,a as r,v as f,d as u,t as _,w as b}from"../chunks/index.707bf1b6.js";import{T as Bo}from"../chunks/Tip.c2ecdbf4.js";import{D as z}from"../chunks/Docstring.17db21ae.js";import{C as Ao}from"../chunks/CodeBlock.54a9f38d.js";import{E as Qo}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{P as Ct}from"../chunks/PipelineTag.44585822.js";import{H as K}from"../chunks/Heading.342b1fa6.js";function Yt(j){let n,v='Use <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> for preparing images (and optional targets) for the model. Contrary to <a href="detr">DETR</a>, YOLOS doesn’t require a <code>pixel_mask</code> to be created.';return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-19j5avc"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ve,d(m){m&&t(n)}}}function Ut(j){let n,v="Example:",m,p,T;return p=new Ao({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFlvbG9zQ29uZmlnJTJDJTIwWW9sb3NNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBZT0xPUyUyMGh1c3R2bCUyRnlvbG9zLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwWW9sb3NDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaHVzdHZsJTJGeW9sb3MtYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> YolosConfig, YolosModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a YOLOS hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = YolosConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ve,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function It(j){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ve,d(m){m&&t(n)}}}function zt(j){let n,v="Example:",m,p,T;return p=new Ao({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFlvbG9zTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHVzdHZsJTJGeW9sb3Mtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, YolosModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3401</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-11lpom8"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ve,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function kt(j){let n,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=c("p"),n.innerHTML=v},l(m){n=d(m,"P",{"data-svelte-h":!0}),y(n)!=="svelte-fincs2"&&(n.innerHTML=v)},m(m,p){r(m,n,p)},p:Ve,d(m){m&&t(n)}}}function Jt(j){let n,v="Examples:",m,p,T;return p=new Ao({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMENPQ08lMjBBUEklMEF0YXJnZXRfc2l6ZXMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEKSUwQXJlc3VsdHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX29iamVjdF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMHRocmVzaG9sZCUzRDAuOSUyQyUyMHRhcmdldF9zaXplcyUzRHRhcmdldF9zaXplcyklNUIlMEElMjAlMjAlMjAlMjAwJTBBJTVEJTBBJTBBZm9yJTIwc2NvcmUlMkMlMjBsYWJlbCUyQyUyMGJveCUyMGluJTIwemlwKHJlc3VsdHMlNUIlMjJzY29yZXMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIybGFiZWxzJTIyJTVEJTJDJTIwcmVzdWx0cyU1QiUyMmJveGVzJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGJveCUyMCUzRCUyMCU1QnJvdW5kKGklMkMlMjAyKSUyMGZvciUyMGklMjBpbiUyMGJveC50b2xpc3QoKSU1RCUwQSUyMCUyMCUyMCUyMHByaW50KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJEZXRlY3RlZCUyMCU3Qm1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmxhYmVsLml0ZW0oKSU1RCU3RCUyMHdpdGglMjBjb25maWRlbmNlJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMiU3QnJvdW5kKHNjb3JlLml0ZW0oKSUyQyUyMDMpJTdEJTIwYXQlMjBsb2NhdGlvbiUyMCU3QmJveCU3RCUyMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to COCO API</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.994</span> at location [<span class="hljs-number">46.96</span>, <span class="hljs-number">72.61</span>, <span class="hljs-number">181.02</span>, <span class="hljs-number">119.73</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.975</span> at location [<span class="hljs-number">340.66</span>, <span class="hljs-number">79.19</span>, <span class="hljs-number">372.59</span>, <span class="hljs-number">192.65</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.984</span> at location [<span class="hljs-number">12.27</span>, <span class="hljs-number">54.25</span>, <span class="hljs-number">319.42</span>, <span class="hljs-number">470.99</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.922</span> at location [<span class="hljs-number">41.66</span>, <span class="hljs-number">71.96</span>, <span class="hljs-number">178.7</span>, <span class="hljs-number">120.33</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.914</span> at location [<span class="hljs-number">342.34</span>, <span class="hljs-number">21.48</span>, <span class="hljs-number">638.64</span>, <span class="hljs-number">372.46</span>]`,wrap:!1}}),{c(){n=c("p"),n.textContent=v,m=s(),h(p.$$.fragment)},l(l){n=d(l,"P",{"data-svelte-h":!0}),y(n)!=="svelte-kvfsh7"&&(n.textContent=v),m=a(l),g(p.$$.fragment,l)},m(l,w){r(l,n,w),r(l,m,w),f(p,l,w),T=!0},p:Ve,i(l){T||(u(p.$$.fragment,l),T=!0)},o(l){_(p.$$.fragment,l),T=!1},d(l){l&&(t(n),t(m)),b(p,l)}}}function Ft(j){let n,v,m,p,T,l,w,He,ee,Xo=`The YOLOS model was proposed in <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
YOLOS proposes to just leverage the plain <a href="vit">Vision Transformer (ViT)</a> for object detection, inspired by DETR. It turns out that a base-sized encoder-only Transformer can also achieve 42 AP on COCO, similar to DETR and much more complex frameworks such as Faster R-CNN.`,Be,oe,Ko="The abstract from the paper is the following:",Qe,te,et="<em>Can Transformer perform 2D object- and region-level recognition from a pure sequence-to-sequence perspective with minimal knowledge about the 2D spatial structure? To answer this question, we present You Only Look at One Sequence (YOLOS), a series of object detection models based on the vanilla Vision Transformer with the fewest possible modifications, region priors, as well as inductive biases of the target task. We find that YOLOS pre-trained on the mid-sized ImageNet-1k dataset only can already achieve quite competitive performance on the challenging COCO object detection benchmark, e.g., YOLOS-Base directly adopted from BERT-Base architecture can obtain 42.0 box AP on COCO val. We also discuss the impacts as well as limitations of current pre-train schemes and model scaling strategies for Transformer in vision through YOLOS.</em>",Ae,D,ot,Xe,ne,tt='YOLOS architecture. Taken from the <a href="https://arxiv.org/abs/2106.00666">original paper</a>.',Ke,se,nt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/hustvl/YOLOS" rel="nofollow">here</a>.',eo,ae,oo,re,st="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with YOLOS.",to,ie,no,le,at='<li>All example notebooks illustrating inference + fine-tuning <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/YOLOS" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',so,ce,rt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",ao,N,ro,de,io,C,me,wo,ze,it=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a>. It is used to instantiate a YOLOS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the YOLOS
<a href="https://huggingface.co/hustvl/yolos-base" rel="nofollow">hustvl/yolos-base</a> architecture.`,xo,ke,lt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$o,O,lo,pe,co,$,he,Mo,Je,ct="Constructs a Detr image processor.",jo,R,ge,Co,Fe,dt="Preprocess an image or a batch of images so that it can be used by the model.",Yo,W,fe,Uo,Pe,mt=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Io,E,ue,zo,Le,pt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,mo,_e,po,Y,be,ko,Z,ye,Jo,De,ht="Preprocess an image or a batch of images.",Fo,S,ve,Po,Ne,gt=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,Lo,q,Te,Do,Oe,ft=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,ho,we,go,F,xe,No,Re,ut=`The bare YOLOS Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oo,k,$e,Ro,We,_t='The <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> forward method, overrides the <code>__call__</code> special method.',Wo,V,Eo,G,fo,Me,uo,U,je,Zo,Ee,bt="YOLOS Model (consisting of a ViT encoder) with object detection heads on top, for tasks such as COCO detection.",So,Ze,yt=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,qo,J,Ce,Vo,Se,vt='The <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',Go,H,Ho,B,_o,Ge,bo;return T=new K({props:{title:"YOLOS",local:"yolos",headingTag:"h1"}}),w=new K({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new K({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ie=new Ct({props:{pipeline:"object-detection"}}),N=new Bo({props:{$$slots:{default:[Yt]},$$scope:{ctx:j}}}),de=new K({props:{title:"YolosConfig",local:"transformers.YolosConfig",headingTag:"h2"}}),me=new z({props:{name:"class transformers.YolosConfig",anchor:"transformers.YolosConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = [512, 864]"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"num_detection_tokens",val:" = 100"},{name:"use_mid_position_embeddings",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.YolosConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.YolosConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.YolosConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.YolosConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.YolosConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.YolosConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.YolosConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.YolosConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.YolosConfig.image_size",description:`<strong>image_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[512, 864]</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.YolosConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.YolosConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.YolosConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.YolosConfig.num_detection_tokens",description:`<strong>num_detection_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of detection tokens.`,name:"num_detection_tokens"},{anchor:"transformers.YolosConfig.use_mid_position_embeddings",description:`<strong>use_mid_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the mid-layer position encodings.`,name:"use_mid_position_embeddings"},{anchor:"transformers.YolosConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.YolosConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.YolosConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.YolosConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.YolosConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.YolosConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.YolosConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/configuration_yolos.py#L35"}}),O=new Qo({props:{anchor:"transformers.YolosConfig.example",$$slots:{default:[Ut]},$$scope:{ctx:j}}}),pe=new K({props:{title:"YolosImageProcessor",local:"transformers.YolosImageProcessor",headingTag:"h2"}}),he=new z({props:{name:"class transformers.YolosImageProcessor",anchor:"transformers.YolosImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.yolos.image_processing_yolos.AnnotionFormat] = <AnnotionFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"do_pad",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s (height, width) dimensions after resizing. Can be overridden by the <code>size</code> parameter in
the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.YolosImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.
do_normalize &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image to the largest image in a batch and create a pixel mask. Can be
overridden by the <code>do_pad</code> parameter in the <code>preprocess</code> method.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L673"}}),ge=new z({props:{name:"preprocess",anchor:"transformers.YolosImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": bool = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.yolos.image_processing_yolos.AnnotionFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotionation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotionation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.YolosImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.YolosImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotionFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.YolosImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>, defaults to self.data_format) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1011"}}),fe=new z({props:{name:"pad",anchor:"transformers.YolosImageProcessor.pad",parameters:[{name:"images",val:": typing.List[numpy.ndarray]"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosImageProcessor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosImageProcessor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L956"}}),ue=new z({props:{name:"post_process_object_detection",anchor:"transformers.YolosImageProcessor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosImageProcessor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),_e=new K({props:{title:"YolosFeatureExtractor",local:"transformers.YolosFeatureExtractor",headingTag:"h2"}}),be=new z({props:{name:"class transformers.YolosFeatureExtractor",anchor:"transformers.YolosFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/feature_extraction_yolos.py#L36"}}),ye=new z({props:{name:"__call__",anchor:"transformers.YolosFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L547"}}),ve=new z({props:{name:"pad",anchor:"transformers.YolosFeatureExtractor.pad",parameters:[{name:"images",val:": typing.List[numpy.ndarray]"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": typing.Union[transformers.utils.generic.TensorType, str, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosFeatureExtractor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosFeatureExtractor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosFeatureExtractor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosFeatureExtractor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L956"}}),Te=new z({props:{name:"post_process_object_detection",anchor:"transformers.YolosFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),we=new K({props:{title:"YolosModel",local:"transformers.YolosModel",headingTag:"h2"}}),xe=new z({props:{name:"class transformers.YolosModel",anchor:"transformers.YolosModel",parameters:[{name:"config",val:": YolosConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L587"}}),$e=new z({props:{name:"forward",anchor:"transformers.YolosModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L615",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new Bo({props:{$$slots:{default:[It]},$$scope:{ctx:j}}}),G=new Qo({props:{anchor:"transformers.YolosModel.forward.example",$$slots:{default:[zt]},$$scope:{ctx:j}}}),Me=new K({props:{title:"YolosForObjectDetection",local:"transformers.YolosForObjectDetection",headingTag:"h2"}}),je=new z({props:{name:"class transformers.YolosForObjectDetection",anchor:"transformers.YolosForObjectDetection",parameters:[{name:"config",val:": YolosConfig"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L695"}}),Ce=new z({props:{name:"forward",anchor:"transformers.YolosForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/dpt#transformers.DPTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosForObjectDetection.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.YolosForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: <code>&apos;class_labels&apos;</code> and <code>&apos;boxes&apos;</code> (the class labels and bounding boxes of an image in the
batch respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L722",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>post_process()</code> to retrieve the unnormalized bounding
boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxilary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new Bo({props:{$$slots:{default:[kt]},$$scope:{ctx:j}}}),B=new Qo({props:{anchor:"transformers.YolosForObjectDetection.forward.example",$$slots:{default:[Jt]},$$scope:{ctx:j}}}),{c(){n=c("meta"),v=s(),m=c("p"),p=s(),h(T.$$.fragment),l=s(),h(w.$$.fragment),He=s(),ee=c("p"),ee.innerHTML=Xo,Be=s(),oe=c("p"),oe.textContent=Ko,Qe=s(),te=c("p"),te.innerHTML=et,Ae=s(),D=c("img"),Xe=s(),ne=c("small"),ne.innerHTML=tt,Ke=s(),se=c("p"),se.innerHTML=nt,eo=s(),h(ae.$$.fragment),oo=s(),re=c("p"),re.textContent=st,to=s(),h(ie.$$.fragment),no=s(),le=c("ul"),le.innerHTML=at,so=s(),ce=c("p"),ce.textContent=rt,ao=s(),h(N.$$.fragment),ro=s(),h(de.$$.fragment),io=s(),C=c("div"),h(me.$$.fragment),wo=s(),ze=c("p"),ze.innerHTML=it,xo=s(),ke=c("p"),ke.innerHTML=lt,$o=s(),h(O.$$.fragment),lo=s(),h(pe.$$.fragment),co=s(),$=c("div"),h(he.$$.fragment),Mo=s(),Je=c("p"),Je.textContent=ct,jo=s(),R=c("div"),h(ge.$$.fragment),Co=s(),Fe=c("p"),Fe.textContent=dt,Yo=s(),W=c("div"),h(fe.$$.fragment),Uo=s(),Pe=c("p"),Pe.textContent=mt,Io=s(),E=c("div"),h(ue.$$.fragment),zo=s(),Le=c("p"),Le.innerHTML=pt,mo=s(),h(_e.$$.fragment),po=s(),Y=c("div"),h(be.$$.fragment),ko=s(),Z=c("div"),h(ye.$$.fragment),Jo=s(),De=c("p"),De.textContent=ht,Fo=s(),S=c("div"),h(ve.$$.fragment),Po=s(),Ne=c("p"),Ne.textContent=gt,Lo=s(),q=c("div"),h(Te.$$.fragment),Do=s(),Oe=c("p"),Oe.innerHTML=ft,ho=s(),h(we.$$.fragment),go=s(),F=c("div"),h(xe.$$.fragment),No=s(),Re=c("p"),Re.innerHTML=ut,Oo=s(),k=c("div"),h($e.$$.fragment),Ro=s(),We=c("p"),We.innerHTML=_t,Wo=s(),h(V.$$.fragment),Eo=s(),h(G.$$.fragment),fo=s(),h(Me.$$.fragment),uo=s(),U=c("div"),h(je.$$.fragment),Zo=s(),Ee=c("p"),Ee.textContent=bt,So=s(),Ze=c("p"),Ze.innerHTML=yt,qo=s(),J=c("div"),h(Ce.$$.fragment),Vo=s(),Se=c("p"),Se.innerHTML=vt,Go=s(),h(H.$$.fragment),Ho=s(),h(B.$$.fragment),_o=s(),Ge=c("p"),this.h()},l(e){const o=jt("svelte-u9bgzb",document.head);n=d(o,"META",{name:!0,content:!0}),o.forEach(t),v=a(e),m=d(e,"P",{}),M(m).forEach(t),p=a(e),g(T.$$.fragment,e),l=a(e),g(w.$$.fragment,e),He=a(e),ee=d(e,"P",{"data-svelte-h":!0}),y(ee)!=="svelte-98a8ak"&&(ee.innerHTML=Xo),Be=a(e),oe=d(e,"P",{"data-svelte-h":!0}),y(oe)!=="svelte-vfdo9a"&&(oe.textContent=Ko),Qe=a(e),te=d(e,"P",{"data-svelte-h":!0}),y(te)!=="svelte-ng2z0l"&&(te.innerHTML=et),Ae=a(e),D=d(e,"IMG",{src:!0,alt:!0,width:!0}),Xe=a(e),ne=d(e,"SMALL",{"data-svelte-h":!0}),y(ne)!=="svelte-vits75"&&(ne.innerHTML=tt),Ke=a(e),se=d(e,"P",{"data-svelte-h":!0}),y(se)!=="svelte-zgo631"&&(se.innerHTML=nt),eo=a(e),g(ae.$$.fragment,e),oo=a(e),re=d(e,"P",{"data-svelte-h":!0}),y(re)!=="svelte-93t6s9"&&(re.textContent=st),to=a(e),g(ie.$$.fragment,e),no=a(e),le=d(e,"UL",{"data-svelte-h":!0}),y(le)!=="svelte-1bs161h"&&(le.innerHTML=at),so=a(e),ce=d(e,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-1xesile"&&(ce.textContent=rt),ao=a(e),g(N.$$.fragment,e),ro=a(e),g(de.$$.fragment,e),io=a(e),C=d(e,"DIV",{class:!0});var P=M(C);g(me.$$.fragment,P),wo=a(P),ze=d(P,"P",{"data-svelte-h":!0}),y(ze)!=="svelte-1kalbwl"&&(ze.innerHTML=it),xo=a(P),ke=d(P,"P",{"data-svelte-h":!0}),y(ke)!=="svelte-o55m63"&&(ke.innerHTML=lt),$o=a(P),g(O.$$.fragment,P),P.forEach(t),lo=a(e),g(pe.$$.fragment,e),co=a(e),$=d(e,"DIV",{class:!0});var I=M($);g(he.$$.fragment,I),Mo=a(I),Je=d(I,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-19j0nu1"&&(Je.textContent=ct),jo=a(I),R=d(I,"DIV",{class:!0});var Ye=M(R);g(ge.$$.fragment,Ye),Co=a(Ye),Fe=d(Ye,"P",{"data-svelte-h":!0}),y(Fe)!=="svelte-jgz2ra"&&(Fe.textContent=dt),Ye.forEach(t),Yo=a(I),W=d(I,"DIV",{class:!0});var Ue=M(W);g(fe.$$.fragment,Ue),Uo=a(Ue),Pe=d(Ue,"P",{"data-svelte-h":!0}),y(Pe)!=="svelte-1f2f3d6"&&(Pe.textContent=mt),Ue.forEach(t),Io=a(I),E=d(I,"DIV",{class:!0});var Ie=M(E);g(ue.$$.fragment,Ie),zo=a(Ie),Le=d(Ie,"P",{"data-svelte-h":!0}),y(Le)!=="svelte-1hjr84f"&&(Le.innerHTML=pt),Ie.forEach(t),I.forEach(t),mo=a(e),g(_e.$$.fragment,e),po=a(e),Y=d(e,"DIV",{class:!0});var L=M(Y);g(be.$$.fragment,L),ko=a(L),Z=d(L,"DIV",{class:!0});var yo=M(Z);g(ye.$$.fragment,yo),Jo=a(yo),De=d(yo,"P",{"data-svelte-h":!0}),y(De)!=="svelte-khengj"&&(De.textContent=ht),yo.forEach(t),Fo=a(L),S=d(L,"DIV",{class:!0});var vo=M(S);g(ve.$$.fragment,vo),Po=a(vo),Ne=d(vo,"P",{"data-svelte-h":!0}),y(Ne)!=="svelte-1f2f3d6"&&(Ne.textContent=gt),vo.forEach(t),Lo=a(L),q=d(L,"DIV",{class:!0});var To=M(q);g(Te.$$.fragment,To),Do=a(To),Oe=d(To,"P",{"data-svelte-h":!0}),y(Oe)!=="svelte-1hjr84f"&&(Oe.innerHTML=ft),To.forEach(t),L.forEach(t),ho=a(e),g(we.$$.fragment,e),go=a(e),F=d(e,"DIV",{class:!0});var qe=M(F);g(xe.$$.fragment,qe),No=a(qe),Re=d(qe,"P",{"data-svelte-h":!0}),y(Re)!=="svelte-19k5mgv"&&(Re.innerHTML=ut),Oo=a(qe),k=d(qe,"DIV",{class:!0});var Q=M(k);g($e.$$.fragment,Q),Ro=a(Q),We=d(Q,"P",{"data-svelte-h":!0}),y(We)!=="svelte-k5bn63"&&(We.innerHTML=_t),Wo=a(Q),g(V.$$.fragment,Q),Eo=a(Q),g(G.$$.fragment,Q),Q.forEach(t),qe.forEach(t),fo=a(e),g(Me.$$.fragment,e),uo=a(e),U=d(e,"DIV",{class:!0});var A=M(U);g(je.$$.fragment,A),Zo=a(A),Ee=d(A,"P",{"data-svelte-h":!0}),y(Ee)!=="svelte-1yg9bo0"&&(Ee.textContent=bt),So=a(A),Ze=d(A,"P",{"data-svelte-h":!0}),y(Ze)!=="svelte-1gjh92c"&&(Ze.innerHTML=yt),qo=a(A),J=d(A,"DIV",{class:!0});var X=M(J);g(Ce.$$.fragment,X),Vo=a(X),Se=d(X,"P",{"data-svelte-h":!0}),y(Se)!=="svelte-1mbhkvx"&&(Se.innerHTML=vt),Go=a(X),g(H.$$.fragment,X),Ho=a(X),g(B.$$.fragment,X),X.forEach(t),A.forEach(t),_o=a(e),Ge=d(e,"P",{}),M(Ge).forEach(t),this.h()},h(){x(n,"name","hf:doc:metadata"),x(n,"content",Pt),wt(D.src,ot="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/yolos_architecture.png")||x(D,"src",ot),x(D,"alt","drawing"),x(D,"width","600"),x(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,n),r(e,v,o),r(e,m,o),r(e,p,o),f(T,e,o),r(e,l,o),f(w,e,o),r(e,He,o),r(e,ee,o),r(e,Be,o),r(e,oe,o),r(e,Qe,o),r(e,te,o),r(e,Ae,o),r(e,D,o),r(e,Xe,o),r(e,ne,o),r(e,Ke,o),r(e,se,o),r(e,eo,o),f(ae,e,o),r(e,oo,o),r(e,re,o),r(e,to,o),f(ie,e,o),r(e,no,o),r(e,le,o),r(e,so,o),r(e,ce,o),r(e,ao,o),f(N,e,o),r(e,ro,o),f(de,e,o),r(e,io,o),r(e,C,o),f(me,C,null),i(C,wo),i(C,ze),i(C,xo),i(C,ke),i(C,$o),f(O,C,null),r(e,lo,o),f(pe,e,o),r(e,co,o),r(e,$,o),f(he,$,null),i($,Mo),i($,Je),i($,jo),i($,R),f(ge,R,null),i(R,Co),i(R,Fe),i($,Yo),i($,W),f(fe,W,null),i(W,Uo),i(W,Pe),i($,Io),i($,E),f(ue,E,null),i(E,zo),i(E,Le),r(e,mo,o),f(_e,e,o),r(e,po,o),r(e,Y,o),f(be,Y,null),i(Y,ko),i(Y,Z),f(ye,Z,null),i(Z,Jo),i(Z,De),i(Y,Fo),i(Y,S),f(ve,S,null),i(S,Po),i(S,Ne),i(Y,Lo),i(Y,q),f(Te,q,null),i(q,Do),i(q,Oe),r(e,ho,o),f(we,e,o),r(e,go,o),r(e,F,o),f(xe,F,null),i(F,No),i(F,Re),i(F,Oo),i(F,k),f($e,k,null),i(k,Ro),i(k,We),i(k,Wo),f(V,k,null),i(k,Eo),f(G,k,null),r(e,fo,o),f(Me,e,o),r(e,uo,o),r(e,U,o),f(je,U,null),i(U,Zo),i(U,Ee),i(U,So),i(U,Ze),i(U,qo),i(U,J),f(Ce,J,null),i(J,Vo),i(J,Se),i(J,Go),f(H,J,null),i(J,Ho),f(B,J,null),r(e,_o,o),r(e,Ge,o),bo=!0},p(e,[o]){const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),N.$set(P);const I={};o&2&&(I.$$scope={dirty:o,ctx:e}),O.$set(I);const Ye={};o&2&&(Ye.$$scope={dirty:o,ctx:e}),V.$set(Ye);const Ue={};o&2&&(Ue.$$scope={dirty:o,ctx:e}),G.$set(Ue);const Ie={};o&2&&(Ie.$$scope={dirty:o,ctx:e}),H.$set(Ie);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),B.$set(L)},i(e){bo||(u(T.$$.fragment,e),u(w.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(N.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(O.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(fe.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),bo=!0)},o(e){_(T.$$.fragment,e),_(w.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(N.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(O.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(be.$$.fragment,e),_(ye.$$.fragment,e),_(ve.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(V.$$.fragment,e),_(G.$$.fragment,e),_(Me.$$.fragment,e),_(je.$$.fragment,e),_(Ce.$$.fragment,e),_(H.$$.fragment,e),_(B.$$.fragment,e),bo=!1},d(e){e&&(t(v),t(m),t(p),t(l),t(He),t(ee),t(Be),t(oe),t(Qe),t(te),t(Ae),t(D),t(Xe),t(ne),t(Ke),t(se),t(eo),t(oo),t(re),t(to),t(no),t(le),t(so),t(ce),t(ao),t(ro),t(io),t(C),t(lo),t(co),t($),t(mo),t(po),t(Y),t(ho),t(go),t(F),t(fo),t(uo),t(U),t(_o),t(Ge)),t(n),b(T,e),b(w,e),b(ae,e),b(ie,e),b(N,e),b(de,e),b(me),b(O),b(pe,e),b(he),b(ge),b(fe),b(ue),b(_e,e),b(be),b(ye),b(ve),b(Te),b(we,e),b(xe),b($e),b(V),b(G),b(Me,e),b(je),b(Ce),b(H),b(B)}}}const Pt='{"title":"YOLOS","local":"yolos","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"YolosConfig","local":"transformers.YolosConfig","sections":[],"depth":2},{"title":"YolosImageProcessor","local":"transformers.YolosImageProcessor","sections":[],"depth":2},{"title":"YolosFeatureExtractor","local":"transformers.YolosFeatureExtractor","sections":[],"depth":2},{"title":"YolosModel","local":"transformers.YolosModel","sections":[],"depth":2},{"title":"YolosForObjectDetection","local":"transformers.YolosForObjectDetection","sections":[],"depth":2}],"depth":1}';function Lt(j){return xt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends $t{constructor(n){super(),Mt(this,n,Lt,Ft,Tt,{})}}export{qt as component};
