import{s as Gr,o as $r,n as Hr}from"../chunks/scheduler.9bc65507.js";import{S as kr,i as Ir,g as n,s as i,r as h,A as Nr,h as o,f as l,c as a,j as Dr,u as m,x as r,k as w,y as Sr,a as s,v as u,d as f,t as d,w as c}from"../chunks/index.707bf1b6.js";import{T as Jr}from"../chunks/Tip.c2ecdbf4.js";import{C as _l}from"../chunks/CodeBlock.54a9f38d.js";import{H as g}from"../chunks/Heading.342b1fa6.js";function zr(Ul){let p,P=`While the main concepts discussed in this guide are likely applicable across frameworks, here we focus on
PyTorch-based implementations.`;return{c(){p=n("p"),p.textContent=P},l(v){p=o(v,"P",{"data-svelte-h":!0}),r(p)!=="svelte-11nx342"&&(p.textContent=P)},m(v,M){s(v,p,M)},p:Hr,d(v){v&&l(p)}}}function Ar(Ul){let p,P=`This mechanism is similar to an efficient group backpacking strategy: person A carries the tent, person B carries the stove,
and person C carries the axe. Each night they all share what they have with others and get from others what they don’t have,
and in the morning they pack up their allocated type of gear and continue on their way. This is what ZeRO DP/Sharded DDP is.
Compare this strategy to the simple one where each person has to carry their own tent, stove and axe (similar to
DataParallel (DP and DDP) in PyTorch), which would be far more inefficient.`;return{c(){p=n("p"),p.textContent=P},l(v){p=o(v,"P",{"data-svelte-h":!0}),r(p)!=="svelte-15youi0"&&(p.textContent=P)},m(v,M){s(v,p,M)},p:Hr,d(v){v&&l(p)}}}function Er(Ul){let p,P,v,M,G,Jl,$,za=`If training a model on a single GPU is too slow or if the model’s weights do not fit in a single GPU’s memory, transitioning
to a multi-GPU setup may be a viable option. Prior to making this transition, thoroughly explore all the strategies covered
in the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> as they are universally applicable
to model training on any number of GPUs. Once you have employed those strategies and found them insufficient for your
case on a single GPU, consider moving to multiple GPUs.`,Hl,k,Aa=`Transitioning from a single GPU to multiple GPUs requires the introduction of some form of parallelism, as the workload
must be distributed across the resources. Multiple techniques can be employed to achieve parallelism, such as data
parallelism, tensor parallelism, and pipeline parallelism. It’s important to note that there isn’t a one-size-fits-all
solution, and the optimal settings depend on the specific hardware configuration you are using.`,Gl,I,Ea=`This guide offers an in-depth overview of individual types of parallelism, as well as guidance on ways to combine<br/>
techniques and choosing an appropriate approach. For step-by-step tutorials on distributed training, please refer to
the <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">🤗 Accelerate documentation</a>.`,$l,y,kl,N,Qa=`Before diving deeper into the specifics of each technique, let’s go over the rough decision process when training
large models on a large infrastructure.`,Il,S,Nl,z,Ba=`Begin by estimating how much vRAM is required to train your model. For models hosted on the 🤗 Hub, use our
<a href="https://huggingface.co/spaces/hf-accelerate/model-memory-usage" rel="nofollow">Model Memory Calculator</a>, which gives you
accurate calculations within a few percent margin.`,Sl,A,Va="<strong>Parallelization strategy for a single Node / multi-GPU setup</strong>",zl,E,Ra=`When training a model on a single node with multiple GPUs, your choice of parallelization strategy can significantly
impact performance. Here’s a breakdown of your options:`,Al,Q,Za="<strong>Case 1: Your model fits onto a single GPU</strong>",El,B,Fa="If your model can comfortably fit onto a single GPU, you have two primary options:",Ql,V,Wa="<li>DDP - Distributed DataParallel</li> <li>ZeRO - depending on the situation and configuration used, this method may or may not be faster, however, it’s worth experimenting with it.</li>",Bl,R,Xa="<strong>Case 2: Your model doesn’t fit onto a single GPU:</strong>",Vl,Z,qa="If your model is too large for a single GPU, you have several alternatives to consider:",Rl,F,Oa="<li>PipelineParallel (PP)</li> <li>ZeRO</li> <li>TensorParallel (TP)</li>",Zl,W,Ya=`With very fast inter-node connectivity (e.g., NVLINK or NVSwitch) all three strategies (PP, ZeRO, TP) should result in
similar performance. However, without these, PP will be faster than TP or ZeRO. The degree of TP may also
make a difference. It’s best to experiment with your specific setup to determine the most suitable strategy.`,Fl,X,Ka="TP is almost always used within a single node. That is TP size <= GPUs per node.",Wl,q,en="<strong>Case 3: Largest layer of your model does not fit onto a single GPU</strong>",Xl,O,tn='<li>If you are not using ZeRO, you have to use TensorParallel (TP), because PipelineParallel (PP) alone won’t be sufficient to accommodate the large layer.</li> <li>If you are using ZeRO, additionally adopt techniques from the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a>.</li>',ql,Y,ln="<strong>Parallelization strategy for a multi-Node / multi-GPU setup</strong>",Ol,K,sn="<li><p>When you have fast inter-node connectivity (e.g., NVLINK or NVSwitch) consider using one of these options:</p> <ol><li>ZeRO - as it requires close to no modifications to the model</li> <li>A combination of PipelineParallel(PP) with TensorParallel(TP) and DataParallel(DP) - this approach will result in fewer communications, but requires significant changes to the model</li></ol></li> <li><p>When you have slow inter-node connectivity and still low on GPU memory:</p> <ol><li>Employ a combination of DataParallel(DP) with PipelineParallel(PP), TensorParallel(TP), and ZeRO.</li></ol></li>",Yl,ee,an="In the following sections of this guide we dig deeper into how these different parallelism methods work.",Kl,te,es,le,nn=`Even with only 2 GPUs, you can readily leverage the accelerated training capabilities offered by PyTorch’s built-in features,
such as <code>DataParallel</code> (DP) and <code>DistributedDataParallel</code> (DDP). Note that
<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">PyTorch documentation</a> recommends to prefer
<code>DistributedDataParallel</code> (DDP) over <code>DataParallel</code> (DP) for multi-GPU training as it works for all models.
Let’s take a look at how these two methods work and what makes them different.`,ts,se,ls,ie,on="To understand the key differences in inter-GPU communication overhead between the two methods, let’s review the processes per batch:",ss,ae,rn='<a href="https://pytorch.org/docs/master/notes/ddp.html" rel="nofollow">DDP</a>:',is,ne,pn="<li>At the start time the main process replicates the model once from GPU 0 to the rest of GPUs</li> <li>Then for each batch:<ol><li>Each GPU directly consumes its mini-batch of data.</li> <li>During <code>backward</code>, once the local gradients are ready, they are averaged across all processes.</li></ol></li>",as,oe,hn='<a href="https://pytorch.org/docs/master/generated/torch.nn.DataParallel.html" rel="nofollow">DP</a>:',ns,re,mn="For each batch:",os,pe,un="<li>GPU 0 reads the batch of data and then sends a mini-batch to each GPU.</li> <li>The up-to-date model is replicated from GPU 0 to each GPU.</li> <li><code>forward</code> is executed, and output from each GPU is sent to GPU 0 to compute the loss.</li> <li>The loss is distributed from GPU 0 to all GPUs, and <code>backward</code> is run.</li> <li>Gradients from each GPU are sent to GPU 0 and averaged.</li>",rs,he,fn="Key differences include:",ps,me,dn=`<li>DDP performs only a single communication per batch - sending gradients, while DP performs five different data exchanges per batch.
DDP copies data using <a href="https://pytorch.org/docs/master/distributed.html" rel="nofollow">torch.distributed</a>, while DP copies data within
the process via Python threads (which introduces limitations associated with GIL). As a result, <strong><code>DistributedDataParallel</code> (DDP) is generally faster than <code>DataParallel</code> (DP)</strong> unless you have slow GPU card inter-connectivity.</li> <li>Under DP, GPU 0 performs significantly more work than other GPUs, resulting in GPU under-utilization.</li> <li>DDP supports distributed training across multiple machines, whereas DP does not.</li>`,hs,ue,cn=`This is not an exhaustive list of differences between DP and DDP, however, other nuances are out of scope of this guide.
You can get a deeper understanding of these methods by reading this <a href="https://www.telesens.co/2019/04/04/distributed-data-parallel-training-using-pytorch-on-aws/" rel="nofollow">article</a>.`,ms,fe,vn=`Let’s illustrate the differences between DP and DDP with an experiment. We’ll benchmark the differences between DP and
DDP with an added context of NVLink presence:`,us,de,wn="<li>Hardware: 2x TITAN RTX 24GB each + NVlink with 2 NVLinks (<code>NV2</code> in <code>nvidia-smi topo -m</code>).</li> <li>Software: <code>pytorch-1.8-to-be</code> + <code>cuda-11.0</code> / <code>transformers==4.3.0.dev0</code>.</li>",fs,ce,gn="To disable the NVLink feature on one of the benchmarks, we use <code>NCCL_P2P_DISABLE=1</code>.",ds,ve,Pn="Here is the benchmarking code and outputs:",cs,we,Mn="<strong>DP</strong>",vs,ge,ws,Pe,yn="<strong>DDP w/ NVlink</strong>",gs,Me,Ps,ye,xn="<strong>DDP w/o NVlink</strong>",Ms,xe,ys,Te,Tn="Here are the same benchmarking results gathered in a table for convenience:",xs,be,bn='<thead><tr><th align="left">Type</th> <th>NVlink</th> <th align="right">Time</th></tr></thead> <tbody><tr><td align="left">2:DP</td> <td>Y</td> <td align="right">110s</td></tr> <tr><td align="left">2:DDP</td> <td>Y</td> <td align="right">101s</td></tr> <tr><td align="left">2:DDP</td> <td>N</td> <td align="right">131s</td></tr></tbody>',Ts,Ce,Cn=`As you can see, in this case DP is ~10% slower than DDP with NVlink, but ~15% faster than DDP without NVlink.
The real difference will depend on how much data each GPU needs to sync with the others - the more there is to sync,
the more a slow link will impede the overall runtime.`,bs,je,Cs,Le,jn='ZeRO-powered data parallelism (ZeRO-DP) is illustrated in the following diagram from this <a href="https://www.microsoft.com/en-us/research/blog/zero-deepspeed-new-system-optimizations-enable-training-models-with-over-100-billion-parameters/" rel="nofollow">blog post</a>.',js,x,Ln='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero.png" alt="DeepSpeed-Image-1"/>',Ls,_e,_n=`While it may appear complex, it is a very similar concept to <code>DataParallel</code> (DP). The difference is that instead of
replicating the full model parameters, gradients and optimizer states, each GPU stores only a slice of it. Then, at
run-time when the full layer parameters are needed just for the given layer, all GPUs synchronize to give each other
parts that they miss.`,_s,Ue,Un=`To illustrate this idea, consider a simple model with 3 layers (La, Lb, and Lc), where each layer has 3 parameters.
Layer La, for example, has weights a0, a1 and a2:`,Us,De,Ds,Je,Dn="If we have 3 GPUs, ZeRO-DP splits the model onto 3 GPUs like so:",Js,He,Hs,Ge,Jn=`In a way, this is the same horizontal slicing as tensor parallelism, as opposed to Vertical
slicing, where one puts whole layer-groups on different GPUs. Now let’s see how this works:`,Gs,$e,Hn="Each of these GPUs will get the usual mini-batch as it works in DP:",$s,ke,ks,Ie,Gn="The inputs are passed without modifications as if they would be processed by the original model.",Is,Ne,$n="First, the inputs get to the layer <code>La</code>. What happens at this point?",Ns,Se,kn=`On GPU0: the x0 mini-batch requires the a0, a1, a2 parameters to do its forward path through the layer, but the GPU0 has only a0.
It will get a1 from GPU1 and a2 from GPU2, bringing all the pieces of the model together.`,Ss,ze,In=`In parallel, GPU1 gets another mini-batch - x1. GPU1 has the a1 parameter, but needs a0 and a2, so it gets those from GPU0 and GPU2.
Same happens to GPU2 that gets the mini-batch x2. It gets a0 and a1 from GPU0 and GPU1.`,zs,Ae,Nn=`This way each of the 3 GPUs gets the full tensors reconstructed and makes a forward pass with its own mini-batch.
As soon as the calculation is done, the data that is no longer needed gets dropped - it’s only used during the calculation.
The reconstruction is done efficiently via a pre-fetch.`,As,Ee,Sn="Then the whole process is repeated for layer Lb, then Lc forward-wise, and then backward Lc -> Lb -> La.",Es,T,Qs,Qe,zn=`While reading the literature on this topic you may encounter the following synonyms: Sharded, Partitioned.
If you pay close attention the way ZeRO partitions the model’s weights - it looks very similar to tensor parallelism
which will be discussed later. This is because it partitions/shards each layer’s weights, unlike vertical model parallelism
which is discussed next.`,Bs,Be,An="Implementations:",Vs,Ve,En='<li><a href="https://www.deepspeed.ai/tutorials/zero/" rel="nofollow">DeepSpeed</a> ZeRO-DP stages 1+2+3</li> <li><a href="https://huggingface.co/docs/accelerate/en/usage_guides/deepspeed" rel="nofollow"><code>Accelerate</code> integration</a></li> <li><a href="main_classes/trainer#trainer-integrations"><code>transformers</code> integration</a></li>',Rs,Re,Zs,Ze,Qn=`To explain Pipeline parallelism, we’ll first look into Naive Model Parallelism (MP), also known as Vertical MP. This approach
involves distributing groups of model layers across multiple GPUs by assigning specific layers to specific GPUs with <code>.to()</code>.
As data flows through these layers, it is moved to the same GPU as the layer, while the other layers remain untouched.`,Fs,Fe,Bn=`We refer to this Model parallelism as “Vertical” because of how models are typically visualized. For example, the
following diagram shows an 8-layer model split vertically into two slices, placing layers 0-3 onto
GPU0 and 4-7 to GPU1:`,Ws,We,Xs,Xe,Vn=`In this example, when data moves from layer 0 to 3, it’s no different from regular forward pass. However, passing data
from layer 3 to 4 requires moving it from GPU0 to GPU1, introducing a communication overhead. If the participating
GPUs are on the same compute node (e.g. same physical machine) this copying is fast, but if the GPUs are distributed
across different compute nodes (e.g. multiple machines), the communication overhead could be substantially greater.`,qs,qe,Rn=`Following that, layers 4 to 7 work as they would in the original model. Upon completion of the 7th layer, there is often
a need to send the data back to layer 0 where the labels are (or alternatively send the labels to the last layer). Now the loss can be
computed and the optimizer can do its work.`,Os,Oe,Zn="Naive Model Parallelism comes several shortcomings:",Ys,Ye,Fn="<li><strong>All but one GPU are idle at any given moment</strong>: if 4 GPUs are used, it’s nearly identical to quadrupling the amount of memory of a single GPU, and ignoring the rest of the hardware.</li> <li><strong>Overhead in data transfer between devices</strong>:  E.g. 4x 6GB cards will be able to accommodate the same size as 1x 24GB card using naive MP, but a single 24GB card will complete the training faster, because it doesn’t have the data copying overhead. But, say, if you have 40GB cards and need to fit a 45GB model you can with 4x 40GB cards (but barely because of the gradient and optimizer states)</li> <li><strong>Copying shared embeddings</strong>: Shared embeddings may need to get copied back and forth between GPUs.</li>",Ks,Ke,Wn=`Now that you are familiar with how the naive approach to model parallelism works and its shortcomings, let’s look at Pipeline Parallelism (PP).
PP is almost identical to a naive MP, but it solves the GPU idling problem by chunking the incoming batch into micro-batches
and artificially creating a pipeline, which allows different GPUs to concurrently participate in the computation process.`,ei,et,Xn=`The following illustration from the <a href="https://ai.googleblog.com/2019/03/introducing-gpipe-open-source-library.html" rel="nofollow">GPipe paper</a>
shows the naive MP on the top, and PP on the bottom:`,ti,b,qn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-gpipe-bubble.png" alt="MP vs PP"/>',li,tt,On=`At the bottom of the diagram, you can observe that the Pipeline Parallelism (PP) approach minimizes the number of idle
GPU zones, referred to as ‘bubbles’. Both parts of the diagram show a parallelism level of degree 4, meaning that 4 GPUs
are involved in the pipeline. You can see that there’s a forward path of 4 pipe stages (F0, F1, F2 and F3) followed by
a backward path in reverse order (B3, B2, B1, and B0).`,si,lt,Yn=`PP introduces a new hyperparameter to tune - <code>chunks</code>, which determines how many data chunks are sent in a sequence
through the same pipe stage. For example, in the bottom diagram you can see <code>chunks=4</code>. GPU0 performs the same
forward path on chunk 0, 1, 2 and 3 (F0,0, F0,1, F0,2, F0,3) and then it waits for other GPUs to do complete their work.
Only when the other GPUs begin to complete their work, GPU0 starts to work again doing the backward path for chunks
3, 2, 1 and 0 (B0,3, B0,2, B0,1, B0,0).`,ii,st,Kn=`Note that this is the same concept as gradient accumulation steps. PyTorch uses <code>chunks</code>, while DeepSpeed refers
to the same hyperparameter as gradient accumulation steps.`,ai,it,eo=`Because of the chunks, PP introduces the notion of micro-batches (MBS). DP splits the global data batch size into
mini-batches, so if you have a DP degree of 4, a global batch size of 1024 gets split up into 4 mini-batches of
256 each (1024/4). And if the number of <code>chunks</code> (or GAS) is 32 we end up with a micro-batch size of 8 (256/32). Each
Pipeline stage works with a single micro-batch at a time. To calculate the global batch size of the DP + PP setup,
use the formula: <code>mbs * chunks * dp_degree</code> (<code>8 * 32 * 4 = 1024</code>).
With <code>chunks=1</code> you end up with the naive MP, which is inefficient. With a large <code>chunks</code> value you end up with
tiny micro-batch sizes which is also inefficient. For this reason, we encourage to experiment with the <code>chunks</code> value to
find the one that leads to the most efficient GPUs utilization.`,ni,at,to=`You may notice a bubble of “dead” time on the diagram that can’t be parallelized because the last <code>forward</code> stage
has to wait for <code>backward</code> to complete the pipeline. The purpose of finding the best value for <code>chunks</code> is to enable a high
concurrent GPU utilization across all participating GPUs which translates to minimizing the size of the bubble.`,oi,nt,lo="Pipeline API solutions have been implemented in:",ri,ot,so="<li>PyTorch</li> <li>DeepSpeed</li> <li>Megatron-LM</li>",pi,rt,io="These come with some shortcomings:",hi,pt,ao='<li>They have to modify the model quite heavily, because Pipeline requires one to rewrite the normal flow of modules into a <code>nn.Sequential</code> sequence of the same, which may require changes to the design of the model.</li> <li>Currently the Pipeline API is very restricted. If you had a bunch of Python variables being passed in the very first stage of the Pipeline, you will have to find a way around it. Currently, the pipeline interface requires either a single Tensor or a tuple of Tensors as the only input and output. These tensors must have a batch size as the very first dimension, since pipeline is going to chunk the mini batch into micro-batches. Possible improvements are being discussed here <a href="https://github.com/pytorch/pytorch/pull/50693" rel="nofollow">https://github.com/pytorch/pytorch/pull/50693</a></li> <li>Conditional control flow at the level of pipe stages is not possible - e.g., Encoder-Decoder models like T5 require special workarounds to handle a conditional encoder stage.</li> <li>They have to arrange each layer so that the output of one layer becomes an input to the other layer.</li>',mi,ht,no="More recent solutions include:",ui,mt,oo="<li>Varuna</li> <li>Sagemaker</li>",fi,ut,ro=`We have not experimented with Varuna and SageMaker but their papers report that they have overcome the list of problems
mentioned above and that they require smaller changes to the user’s model.`,di,ft,po="Implementations:",ci,dt,ho='<li><a href="https://pytorch.org/docs/stable/pipeline.html" rel="nofollow">PyTorch</a> (initial support in pytorch-1.8, and progressively getting improved in 1.9 and more so in 1.10). Some <a href="https://github.com/pytorch/pytorch/blob/master/benchmarks/distributed/pipeline/pipe.py" rel="nofollow">examples</a></li> <li><a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation - no API.</li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> - this is implemented based on the Hugging Face Transformers.</li>',vi,ct,mo=`🤗 Transformers status: as of this writing none of the models supports full-PP. GPT2 and T5 models have naive MP support.
The main obstacle is being unable to convert the models to <code>nn.Sequential</code> and have all the inputs to be Tensors. This
is because currently the models include many features that make the conversion very complicated, and will need to be removed to accomplish that.`,wi,vt,uo='DeepSpeed and Megatron-LM integrations are available in <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/deepspeed" rel="nofollow">🤗 Accelerate</a>',gi,wt,fo="Other approaches:",Pi,gt,co='DeepSpeed, Varuna and SageMaker use the concept of an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/model-parallel-core-features.html" rel="nofollow">Interleaved Pipeline</a>',Mi,C,vo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-sagemaker-interleaved-pipeline.png" alt="Interleaved pipeline execution"/>',yi,Pt,wo=`Here the bubble (idle time) is further minimized by prioritizing backward passes. Varuna further attempts to improve the
schedule by using simulations to discover the most efficient scheduling.`,xi,Mt,go="OSLO has pipeline parallelism implementation based on the Transformers without <code>nn.Sequential</code> conversion.",Ti,yt,bi,xt,Po=`In Tensor Parallelism, each GPU processes a slice of a tensor and only aggregates the full tensor for operations requiring it.
To describe this method, this section of the guide relies on the concepts and diagrams from the <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a>
paper: <a href="https://arxiv.org/abs/2104.04473" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters</a>.`,Ci,Tt,Mo=`The main building block of any transformer is a fully connected <code>nn.Linear</code> followed by a nonlinear activation <code>GeLU</code>.
The dot dot-product part of it, following the Megatron’s paper notation, can be written as <code>Y = GeLU(XA)</code>, where <code>X</code> is
an input vector, <code>Y</code> is the output vector, and <code>A</code> is the weight matrix.`,ji,bt,yo="If we look at the computation in matrix form, you can see how the matrix multiplication can be split between multiple GPUs:",Li,j,xo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_gemm.png" alt="Parallel GEMM"/>',_i,Ct,To=`If we split the weight matrix <code>A</code> column-wise across <code>N</code> GPUs and perform matrix multiplications <code>XA_1</code> through <code>XA_n</code> in parallel,
then we will end up with <code>N</code> output vectors <code>Y_1, Y_2, ..., Y_n</code> which can be fed into <code>GeLU</code> independently:`,Ui,L,bo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-independent-gelu.png" alt="Independent GeLU"/>',Di,jt,Co=`Using this principle, we can update a multi-layer perceptron of arbitrary depth, without the need for any synchronization
between GPUs until the very end, where we need to reconstruct the output vector from shards. The Megatron-LM paper authors
provide a helpful illustration for that:`,Ji,_,jo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_shard_processing.png" alt="Parallel shard processing"/>',Hi,Lt,Lo=`Parallelizing the multi-headed attention layers is even simpler, since they are already inherently parallel, due to having
multiple independent heads!`,Gi,U,_o='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-tp-parallel_self_attention.png" alt="Parallel self-attention"/>',$i,_t,Uo=`Special considerations: TP requires very fast network, and therefore it’s not advisable to do TP across more than one node.
Practically, if a node has 4 GPUs, the highest TP degree is therefore 4. If you need a TP degree of 8, you need to use
nodes that have at least 8 GPUs.`,ki,Ut,Do=`This section is based on the original much more <a href="https://github.com/huggingface/transformers/issues/10321#issuecomment-783543530" rel="nofollow">detailed TP overview</a>.
by <a href="https://github.com/anton-l" rel="nofollow">@anton-l</a>.`,Ii,Dt,Jo="Alternative names:",Ni,Jt,Ho='<li>DeepSpeed calls it <a href="https://www.deepspeed.ai/training/#model-parallelism" rel="nofollow">tensor slicing</a></li>',Si,Ht,Go="Implementations:",zi,Gt,$o='<li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> has an internal implementation, as it’s very model-specific</li> <li><a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> (only inference at the moment)</li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a> - this is a proprietary solution that can only be used on AWS.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a> has the tensor parallelism implementation based on the Transformers.</li>',Ai,$t,ko="SageMaker combines TP with DP for a more efficient processing.",Ei,kt,Io="🤗 Transformers status:",Qi,It,No='<li>core: not yet implemented in the core</li> <li>but if you want inference <a href="https://github.com/tunib-ai/parallelformers" rel="nofollow">parallelformers</a> provides this support for most of our models. So until this is implemented in the core you can use theirs. And hopefully training mode will be supported too.</li> <li>Deepspeed-Inference also supports our BERT, GPT-2, and GPT-Neo models in their super-fast CUDA-kernel-based inference mode, see more <a href="https://www.deepspeed.ai/tutorials/inference-tutorial/" rel="nofollow">here</a></li>',Bi,Nt,So='🤗 Accelerate integrates with <a href="https://huggingface.co/docs/accelerate/v0.23.0/en/usage_guides/megatron_lm" rel="nofollow">TP from Megatron-LM</a>.',Vi,St,Ri,zt,zo=`The following diagram from the DeepSpeed <a href="https://www.deepspeed.ai/tutorials/pipeline/" rel="nofollow">pipeline tutorial</a> demonstrates
how one can combine DP with PP.`,Zi,D,Ao='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-zero-dp-pp.png" alt="DP + PP-2d"/>',Fi,At,Eo=`Here it’s important to see how DP rank 0 doesn’t see GPU2 and DP rank 1 doesn’t see GPU3. To DP there is just GPUs 0
and 1 where it feeds data as if there were just 2 GPUs. GPU0 “secretly” offloads some of its load to GPU2 using PP.
And GPU1 does the same by enlisting GPU3 to its aid.`,Wi,Et,Qo="Since each dimension requires at least 2 GPUs, here you’d need at least 4 GPUs.",Xi,Qt,Bo="Implementations:",qi,Bt,Vo='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a></li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',Oi,Vt,Ro="🤗 Transformers status: not yet implemented",Yi,Rt,Ki,Zt,Zo="To get an even more efficient training a 3D parallelism is used where PP is combined with TP and DP. This can be seen in the following diagram.",ea,J,Fo='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-deepspeed-3d.png" alt="dp-pp-tp-3d"/>',ta,Ft,Wo='This diagram is from a blog post <a href="https://www.microsoft.com/en-us/research/blog/deepspeed-extreme-scale-model-training-for-everyone/" rel="nofollow">3D parallelism: Scaling to trillion-parameter models</a>, which is a good read as well.',la,Wt,Xo="Since each dimension requires at least 2 GPUs, here you’d need at least 8 GPUs.",sa,Xt,qo="Implementations:",ia,qt,Oo='<li><a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> - DeepSpeed also includes an even more efficient DP, which they call ZeRO-DP.</li> <li><a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a></li> <li><a href="https://github.com/microsoft/varuna" rel="nofollow">Varuna</a></li> <li><a href="https://arxiv.org/abs/2111.05972" rel="nofollow">SageMaker</a></li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',aa,Ot,Yo="🤗 Transformers status: not yet implemented, since we have no PP and TP.",na,Yt,oa,Kt,Ko=`One of the main features of DeepSpeed is ZeRO, which is a super-scalable extension of DP. It has already been
discussed in <a href="#zero-data-parallelism">ZeRO Data Parallelism</a>. Normally it’s a standalone feature that doesn’t require PP or TP.
But it can be combined with PP and TP.`,ra,el,er="When ZeRO-DP is combined with PP (and optionally TP) it typically enables only ZeRO stage 1 (optimizer sharding).",pa,tl,tr=`While it’s theoretically possible to use ZeRO stage 2 (gradient sharding) with Pipeline Parallelism, it will have negative
performance impacts. There would need to be an additional reduce-scatter collective for every micro-batch to aggregate
the gradients before sharding, which adds a potentially significant communication overhead. By nature of Pipeline Parallelism,
small micro-batches are used and instead the focus is on trying to balance arithmetic intensity (micro-batch size) with
minimizing the Pipeline bubble (number of micro-batches). Therefore those communication costs are going to impact the performance.`,ha,ll,lr=`In addition, there are already fewer layers than normal due to PP and so the memory savings won’t be huge. PP already
reduces gradient size by <code>1/PP</code>, and so gradient sharding savings on top of that are less significant than pure DP.`,ma,sl,sr="ZeRO stage 3 is not a good choice either for the same reason - more inter-node communications required.",ua,il,ir="And since we have ZeRO, the other benefit is ZeRO-Offload. Since this is stage 1 optimizer states can be offloaded to CPU.",fa,al,ar="Implementations:",da,nl,nr='<li><a href="https://github.com/microsoft/Megatron-DeepSpeed" rel="nofollow">Megatron-DeepSpeed</a> and <a href="https://github.com/bigscience-workshop/Megatron-DeepSpeed" rel="nofollow">Megatron-Deepspeed from BigScience</a>, which is the fork of the former repo.</li> <li><a href="https://github.com/tunib-ai/oslo" rel="nofollow">OSLO</a></li>',ca,ol,or="Important papers:",va,rl,rr='<li><a href="https://arxiv.org/abs/2201.11990" rel="nofollow">Using DeepSpeed and Megatron to Train Megatron-Turing NLG 530B, A Large-Scale Generative Language Model</a></li>',wa,pl,pr="🤗 Transformers status: not yet implemented, since we have no PP and TP.",ga,hl,Pa,ml,hr='<a href="https://github.com/flexflow/FlexFlow" rel="nofollow">FlexFlow</a> also solves the parallelization problem in a slightly different approach.',Ma,ul,mr='Paper: <a href="https://arxiv.org/abs/1807.05358" rel="nofollow">“Beyond Data and Model Parallelism for Deep Neural Networks” by Zhihao Jia, Matei Zaharia, Alex Aiken</a>',ya,fl,ur="It performs a sort of 4D Parallelism over Sample-Operator-Attribute-Parameter.",xa,dl,fr="<li>Sample = Data Parallelism (sample-wise parallel)</li> <li>Operator = Parallelize a single operation into several sub-operations</li> <li>Attribute = Data Parallelism (length-wise parallel)</li> <li>Parameter = Model Parallelism (regardless of dimension - horizontal or vertical)</li>",Ta,cl,dr="Examples:",ba,vl,cr="<li>Sample</li>",Ca,wl,vr="Let’s take 10 batches of sequence length 512. If we parallelize them by sample dimension into 2 devices, we get 10 x 512 which becomes be 5 x 2 x 512.",ja,gl,wr="<li>Operator</li>",La,Pl,gr=`If we perform layer normalization, we compute std first and mean second, and then we can normalize data.
Operator parallelism allows computing std and mean in parallel. So if we parallelize them by operator dimension into 2
devices (cuda:0, cuda:1), first we copy input data into both devices, and cuda:0 computes std, cuda:1 computes mean at the same time.`,_a,Ml,Pr="<li>Attribute</li>",Ua,yl,Mr="We have 10 batches of 512 length. If we parallelize them by attribute dimension into 2 devices, 10 x 512 will be 10 x 2 x 256.",Da,xl,yr="<li>Parameter</li>",Ja,Tl,xr="It is similar with tensor model parallelism or naive layer-wise model parallelism.",Ha,H,Tr='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/parallelism-flexflow.jpeg" alt="flex-flow-soap"/>',Ga,bl,br=`The significance of this framework is that it takes resources like (1) GPU/TPU/CPU vs. (2) RAM/DRAM vs. (3)
fast-intra-connect/slow-inter-connect and it automatically optimizes all these algorithmically deciding which
parallelisation to use where.`,$a,Cl,Cr=`One very important aspect is that FlexFlow is designed for optimizing DNN parallelizations for models with static and
fixed workloads, since models with dynamic behavior may prefer different parallelization strategies across iterations.`,ka,jl,jr=`So the promise is very attractive - it runs a 30min simulation on the cluster of choice and it comes up with the best
strategy to utilise this specific environment. If you add/remove/replace any parts it’ll run and re-optimize the plan
for that. And then you can train. A different setup will have its own custom optimization.`,Ia,Ll,Lr=`🤗 Transformers status: Transformers models are FX-trace-able via <a href="https://github.com/huggingface/transformers/blob/master/src/transformers/utils/fx.py" rel="nofollow">transformers.utils.fx</a>,
which is a prerequisite for FlexFlow, however, changes are required on the FlexFlow side to make it work with Transformers models.`,Na,Dl,Sa;return G=new g({props:{title:"Efficient Training on Multiple GPUs",local:"efficient-training-on-multiple-gpus",headingTag:"h1"}}),y=new Jr({props:{$$slots:{default:[zr]},$$scope:{ctx:Ul}}}),S=new g({props:{title:"Scalability strategy",local:"scalability-strategy",headingTag:"h2"}}),te=new g({props:{title:"Data Parallelism",local:"data-parallelism",headingTag:"h2"}}),se=new g({props:{title:"DataParallel vs DistributedDataParallel",local:"dataparallel-vs-distributeddataparallel",headingTag:"h3"}}),ge=new _l({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTEwLjU5NDglMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuODA4JTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">110</span>.<span class="hljs-string">5948</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">808</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),Me=new _l({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMSUyMCU1QyUwQXB5dGhvbiUyMC1tJTIwdG9yY2guZGlzdHJpYnV0ZWQubGF1bmNoJTIwLS1ucHJvY19wZXJfbm9kZSUyMDIlMjBleGFtcGxlcyUyRnB5dG9yY2glMkZsYW5ndWFnZS1tb2RlbGluZyUyRnJ1bl9jbG0ucHklMjAlNUMlMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMGdwdDIlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEEtLWRvX3RyYWluJTIwLS1vdXRwdXRfZGlyJTIwJTJGdG1wJTJGdGVzdC1jbG0lMjAtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDQlMjAtLW1heF9zdGVwcyUyMDIwMCUwQSUwQSU3Qid0cmFpbl9ydW50aW1lJyUzQSUyMDEwMS45MDAzJTJDJTIwJ3RyYWluX3NhbXBsZXNfcGVyX3NlY29uZCclM0ElMjAxLjk2MyUyQyUyMCdlcG9jaCclM0ElMjAwLjY5JTdE",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">101</span>.<span class="hljs-string">9003</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">963</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),xe=new _l({props:{code:"cm0lMjAtciUyMCUyRnRtcCUyRnRlc3QtY2xtJTNCJTIwTkNDTF9QMlBfRElTQUJMRSUzRDElMjBDVURBX1ZJU0lCTEVfREVWSUNFUyUzRDAlMkMxJTIwJTVDJTBBcHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5sYXVuY2glMjAtLW5wcm9jX3Blcl9ub2RlJTIwMiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRmxhbmd1YWdlLW1vZGVsaW5nJTJGcnVuX2NsbS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwZ3B0MiUyMC0tZGF0YXNldF9uYW1lJTIwd2lraXRleHQlMjAtLWRhdGFzZXRfY29uZmlnX25hbWUlMjB3aWtpdGV4dC0yLXJhdy12MSUyMCU1QyUwQS0tZG9fdHJhaW4lMjAtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkZ0ZXN0LWNsbSUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwNCUyMC0tbWF4X3N0ZXBzJTIwMjAwJTBBJTBBJTdCJ3RyYWluX3J1bnRpbWUnJTNBJTIwMTMxLjQzNjclMkMlMjAndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDEuNTIyJTJDJTIwJ2Vwb2NoJyUzQSUyMDAuNjklN0Q=",highlighted:`<span class="hljs-string">rm</span> -<span class="hljs-string">r</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span>; <span class="hljs-string">NCCL_P2P_DISABLE</span>=<span class="hljs-string">1</span> <span class="hljs-string">CUDA_VISIBLE_DEVICES</span>=<span class="hljs-string">0</span>,<span class="hljs-string">1</span> \\
<span class="hljs-string">python</span> -<span class="hljs-string">m</span> <span class="hljs-string">torch</span>.<span class="hljs-string">distributed</span>.<span class="hljs-string">launch</span> <span class="hljs-built_in">--nproc_per_node</span> <span class="hljs-string">2</span> <span class="hljs-string">examples</span>/<span class="hljs-string">pytorch</span>/<span class="hljs-string">language-modeling</span>/<span class="hljs-string">run_clm</span>.<span class="hljs-string">py</span> \\
<span class="hljs-built_in">--model_name_or_path</span> <span class="hljs-string">gpt2</span> <span class="hljs-built_in">--dataset_name</span> <span class="hljs-string">wikitext</span> <span class="hljs-built_in">--dataset_config_name</span> <span class="hljs-string">wikitext-2-raw-v1</span> \\
<span class="hljs-built_in">--do_train</span> <span class="hljs-built_in">--output_dir</span> /<span class="hljs-string">tmp</span>/<span class="hljs-string">test-clm</span> <span class="hljs-built_in">--per_device_train_batch_size</span> <span class="hljs-string">4</span> <span class="hljs-built_in">--max_steps</span> <span class="hljs-string">200</span>

{<span class="hljs-string">&#x27;train_runtime&#x27;</span>: <span class="hljs-string">131</span>.<span class="hljs-string">4367</span>, <span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>: <span class="hljs-string">1</span>.<span class="hljs-string">522</span>, <span class="hljs-string">&#x27;epoch&#x27;</span>: <span class="hljs-string">0</span>.<span class="hljs-string">69</span>}`,wrap:!1}}),je=new g({props:{title:"ZeRO Data Parallelism",local:"zero-data-parallelism",headingTag:"h2"}}),De=new _l({props:{code:"TGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWEwJTIwJTdDJTIwYjAlMjAlN0MlMjBjMCUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQWEyJTIwJTdDJTIwYjIlMjAlN0MlMjBjMg==",highlighted:`La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),He=new _l({props:{code:"R1BVMCUzQSUwQUxhJTIwJTdDJTIwTGIlMjAlN0MlMjBMYyUwQS0tLSU3Qy0tLS0lN0MtLS0lMEFhMCUyMCU3QyUyMGIwJTIwJTdDJTIwYzAlMEElMEFHUFUxJTNBJTBBTGElMjAlN0MlMjBMYiUyMCU3QyUyMExjJTBBLS0tJTdDLS0tLSU3Qy0tLSUwQWExJTIwJTdDJTIwYjElMjAlN0MlMjBjMSUwQSUwQUdQVTIlM0ElMEFMYSUyMCU3QyUyMExiJTIwJTdDJTIwTGMlMEEtLS0lN0MtLS0tJTdDLS0tJTBBYTIlMjAlN0MlMjBiMiUyMCU3QyUyMGMy",highlighted:`GPU0:
La |<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a0 </span>|<span class="hljs-string"> b0 </span>|<span class="hljs-string"> c0

GPU1:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a1 </span>|<span class="hljs-string"> b1 </span>|<span class="hljs-string"> c1

GPU2:
La </span>|<span class="hljs-string"> Lb </span>|<span class="hljs-string"> Lc
---</span>|<span class="hljs-string">----</span>|<span class="hljs-string">---
a2 </span>|<span class="hljs-string"> b2 </span>|<span class="hljs-string"> c2</span>`,wrap:!1}}),ke=new _l({props:{code:"eDAlMjAlM0QlM0UlMjBHUFUwJTBBeDElMjAlM0QlM0UlMjBHUFUxJTBBeDIlMjAlM0QlM0UlMjBHUFUy",highlighted:`<span class="hljs-attribute">x0</span> <span class="hljs-operator">=</span>&gt; GPU0
<span class="hljs-attribute">x1</span> <span class="hljs-operator">=</span>&gt; GPU1
<span class="hljs-attribute">x2</span> <span class="hljs-operator">=</span>&gt; GPU2`,wrap:!1}}),T=new Jr({props:{$$slots:{default:[Ar]},$$scope:{ctx:Ul}}}),Re=new g({props:{title:"From Naive Model Parallelism to Pipeline Parallelism",local:"from-naive-model-parallelism-to-pipeline-parallelism",headingTag:"h2"}}),We=new _l({props:{code:"JTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIwJTIwJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTBBJTdDJTIwJTIwMCUyMCU3QyUyMDElMjAlN0MlMjAyJTIwJTdDJTIwMyUyMCUyMCU3QyUyMCUyMCU3QyUyMCUyMDQlMjAlN0MlMjA1JTIwJTdDJTIwNiUyMCU3QyUyMDclMjAlMjAlN0MlMEElM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMjAlMjAlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBHUFUwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwR1BVMQ==",highlighted:`===================  ===================
|<span class="hljs-string">  0 </span>|<span class="hljs-string"> 1 </span>|<span class="hljs-string"> 2 </span>|<span class="hljs-string"> 3  </span>|<span class="hljs-string">  </span>|<span class="hljs-string">  4 </span>|<span class="hljs-string"> 5 </span>|<span class="hljs-string"> 6 </span>|<span class="hljs-string"> 7  </span>|
===================  ===================
        GPU0                 GPU1`,wrap:!1}}),yt=new g({props:{title:"Tensor Parallelism",local:"tensor-parallelism",headingTag:"h2"}}),St=new g({props:{title:"Data Parallelism + Pipeline Parallelism",local:"data-parallelism--pipeline-parallelism",headingTag:"h2"}}),Rt=new g({props:{title:"Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),Yt=new g({props:{title:"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism",local:"zero-data-parallelism--pipeline-parallelism--tensor-parallelism",headingTag:"h2"}}),hl=new g({props:{title:"FlexFlow",local:"flexflow",headingTag:"h2"}}),{c(){p=n("meta"),P=i(),v=n("p"),M=i(),h(G.$$.fragment),Jl=i(),$=n("p"),$.innerHTML=za,Hl=i(),k=n("p"),k.textContent=Aa,Gl=i(),I=n("p"),I.innerHTML=Ea,$l=i(),h(y.$$.fragment),kl=i(),N=n("p"),N.textContent=Qa,Il=i(),h(S.$$.fragment),Nl=i(),z=n("p"),z.innerHTML=Ba,Sl=i(),A=n("p"),A.innerHTML=Va,zl=i(),E=n("p"),E.textContent=Ra,Al=i(),Q=n("p"),Q.innerHTML=Za,El=i(),B=n("p"),B.textContent=Fa,Ql=i(),V=n("ol"),V.innerHTML=Wa,Bl=i(),R=n("p"),R.innerHTML=Xa,Vl=i(),Z=n("p"),Z.textContent=qa,Rl=i(),F=n("ol"),F.innerHTML=Oa,Zl=i(),W=n("p"),W.textContent=Ya,Fl=i(),X=n("p"),X.textContent=Ka,Wl=i(),q=n("p"),q.innerHTML=en,Xl=i(),O=n("ol"),O.innerHTML=tn,ql=i(),Y=n("p"),Y.innerHTML=ln,Ol=i(),K=n("ul"),K.innerHTML=sn,Yl=i(),ee=n("p"),ee.textContent=an,Kl=i(),h(te.$$.fragment),es=i(),le=n("p"),le.innerHTML=nn,ts=i(),h(se.$$.fragment),ls=i(),ie=n("p"),ie.textContent=on,ss=i(),ae=n("p"),ae.innerHTML=rn,is=i(),ne=n("ul"),ne.innerHTML=pn,as=i(),oe=n("p"),oe.innerHTML=hn,ns=i(),re=n("p"),re.textContent=mn,os=i(),pe=n("ol"),pe.innerHTML=un,rs=i(),he=n("p"),he.textContent=fn,ps=i(),me=n("ol"),me.innerHTML=dn,hs=i(),ue=n("p"),ue.innerHTML=cn,ms=i(),fe=n("p"),fe.textContent=vn,us=i(),de=n("ul"),de.innerHTML=wn,fs=i(),ce=n("p"),ce.innerHTML=gn,ds=i(),ve=n("p"),ve.textContent=Pn,cs=i(),we=n("p"),we.innerHTML=Mn,vs=i(),h(ge.$$.fragment),ws=i(),Pe=n("p"),Pe.innerHTML=yn,gs=i(),h(Me.$$.fragment),Ps=i(),ye=n("p"),ye.innerHTML=xn,Ms=i(),h(xe.$$.fragment),ys=i(),Te=n("p"),Te.textContent=Tn,xs=i(),be=n("table"),be.innerHTML=bn,Ts=i(),Ce=n("p"),Ce.textContent=Cn,bs=i(),h(je.$$.fragment),Cs=i(),Le=n("p"),Le.innerHTML=jn,js=i(),x=n("div"),x.innerHTML=Ln,Ls=i(),_e=n("p"),_e.innerHTML=_n,_s=i(),Ue=n("p"),Ue.textContent=Un,Us=i(),h(De.$$.fragment),Ds=i(),Je=n("p"),Je.textContent=Dn,Js=i(),h(He.$$.fragment),Hs=i(),Ge=n("p"),Ge.textContent=Jn,Gs=i(),$e=n("p"),$e.textContent=Hn,$s=i(),h(ke.$$.fragment),ks=i(),Ie=n("p"),Ie.textContent=Gn,Is=i(),Ne=n("p"),Ne.innerHTML=$n,Ns=i(),Se=n("p"),Se.textContent=kn,Ss=i(),ze=n("p"),ze.textContent=In,zs=i(),Ae=n("p"),Ae.textContent=Nn,As=i(),Ee=n("p"),Ee.textContent=Sn,Es=i(),h(T.$$.fragment),Qs=i(),Qe=n("p"),Qe.textContent=zn,Bs=i(),Be=n("p"),Be.textContent=An,Vs=i(),Ve=n("ul"),Ve.innerHTML=En,Rs=i(),h(Re.$$.fragment),Zs=i(),Ze=n("p"),Ze.innerHTML=Qn,Fs=i(),Fe=n("p"),Fe.textContent=Bn,Ws=i(),h(We.$$.fragment),Xs=i(),Xe=n("p"),Xe.textContent=Vn,qs=i(),qe=n("p"),qe.textContent=Rn,Os=i(),Oe=n("p"),Oe.textContent=Zn,Ys=i(),Ye=n("ul"),Ye.innerHTML=Fn,Ks=i(),Ke=n("p"),Ke.textContent=Wn,ei=i(),et=n("p"),et.innerHTML=Xn,ti=i(),b=n("div"),b.innerHTML=qn,li=i(),tt=n("p"),tt.textContent=On,si=i(),lt=n("p"),lt.innerHTML=Yn,ii=i(),st=n("p"),st.innerHTML=Kn,ai=i(),it=n("p"),it.innerHTML=eo,ni=i(),at=n("p"),at.innerHTML=to,oi=i(),nt=n("p"),nt.textContent=lo,ri=i(),ot=n("ul"),ot.innerHTML=so,pi=i(),rt=n("p"),rt.textContent=io,hi=i(),pt=n("ul"),pt.innerHTML=ao,mi=i(),ht=n("p"),ht.textContent=no,ui=i(),mt=n("ul"),mt.innerHTML=oo,fi=i(),ut=n("p"),ut.textContent=ro,di=i(),ft=n("p"),ft.textContent=po,ci=i(),dt=n("ul"),dt.innerHTML=ho,vi=i(),ct=n("p"),ct.innerHTML=mo,wi=i(),vt=n("p"),vt.innerHTML=uo,gi=i(),wt=n("p"),wt.textContent=fo,Pi=i(),gt=n("p"),gt.innerHTML=co,Mi=i(),C=n("div"),C.innerHTML=vo,yi=i(),Pt=n("p"),Pt.textContent=wo,xi=i(),Mt=n("p"),Mt.innerHTML=go,Ti=i(),h(yt.$$.fragment),bi=i(),xt=n("p"),xt.innerHTML=Po,Ci=i(),Tt=n("p"),Tt.innerHTML=Mo,ji=i(),bt=n("p"),bt.textContent=yo,Li=i(),j=n("div"),j.innerHTML=xo,_i=i(),Ct=n("p"),Ct.innerHTML=To,Ui=i(),L=n("div"),L.innerHTML=bo,Di=i(),jt=n("p"),jt.textContent=Co,Ji=i(),_=n("div"),_.innerHTML=jo,Hi=i(),Lt=n("p"),Lt.textContent=Lo,Gi=i(),U=n("div"),U.innerHTML=_o,$i=i(),_t=n("p"),_t.textContent=Uo,ki=i(),Ut=n("p"),Ut.innerHTML=Do,Ii=i(),Dt=n("p"),Dt.textContent=Jo,Ni=i(),Jt=n("ul"),Jt.innerHTML=Ho,Si=i(),Ht=n("p"),Ht.textContent=Go,zi=i(),Gt=n("ul"),Gt.innerHTML=$o,Ai=i(),$t=n("p"),$t.textContent=ko,Ei=i(),kt=n("p"),kt.textContent=Io,Qi=i(),It=n("ul"),It.innerHTML=No,Bi=i(),Nt=n("p"),Nt.innerHTML=So,Vi=i(),h(St.$$.fragment),Ri=i(),zt=n("p"),zt.innerHTML=zo,Zi=i(),D=n("div"),D.innerHTML=Ao,Fi=i(),At=n("p"),At.textContent=Eo,Wi=i(),Et=n("p"),Et.textContent=Qo,Xi=i(),Qt=n("p"),Qt.textContent=Bo,qi=i(),Bt=n("ul"),Bt.innerHTML=Vo,Oi=i(),Vt=n("p"),Vt.textContent=Ro,Yi=i(),h(Rt.$$.fragment),Ki=i(),Zt=n("p"),Zt.textContent=Zo,ea=i(),J=n("div"),J.innerHTML=Fo,ta=i(),Ft=n("p"),Ft.innerHTML=Wo,la=i(),Wt=n("p"),Wt.textContent=Xo,sa=i(),Xt=n("p"),Xt.textContent=qo,ia=i(),qt=n("ul"),qt.innerHTML=Oo,aa=i(),Ot=n("p"),Ot.textContent=Yo,na=i(),h(Yt.$$.fragment),oa=i(),Kt=n("p"),Kt.innerHTML=Ko,ra=i(),el=n("p"),el.textContent=er,pa=i(),tl=n("p"),tl.textContent=tr,ha=i(),ll=n("p"),ll.innerHTML=lr,ma=i(),sl=n("p"),sl.textContent=sr,ua=i(),il=n("p"),il.textContent=ir,fa=i(),al=n("p"),al.textContent=ar,da=i(),nl=n("ul"),nl.innerHTML=nr,ca=i(),ol=n("p"),ol.textContent=or,va=i(),rl=n("ul"),rl.innerHTML=rr,wa=i(),pl=n("p"),pl.textContent=pr,ga=i(),h(hl.$$.fragment),Pa=i(),ml=n("p"),ml.innerHTML=hr,Ma=i(),ul=n("p"),ul.innerHTML=mr,ya=i(),fl=n("p"),fl.textContent=ur,xa=i(),dl=n("ol"),dl.innerHTML=fr,Ta=i(),cl=n("p"),cl.textContent=dr,ba=i(),vl=n("ul"),vl.innerHTML=cr,Ca=i(),wl=n("p"),wl.textContent=vr,ja=i(),gl=n("ul"),gl.innerHTML=wr,La=i(),Pl=n("p"),Pl.textContent=gr,_a=i(),Ml=n("ul"),Ml.innerHTML=Pr,Ua=i(),yl=n("p"),yl.textContent=Mr,Da=i(),xl=n("ul"),xl.innerHTML=yr,Ja=i(),Tl=n("p"),Tl.textContent=xr,Ha=i(),H=n("div"),H.innerHTML=Tr,Ga=i(),bl=n("p"),bl.textContent=br,$a=i(),Cl=n("p"),Cl.textContent=Cr,ka=i(),jl=n("p"),jl.textContent=jr,Ia=i(),Ll=n("p"),Ll.innerHTML=Lr,Na=i(),Dl=n("p"),this.h()},l(e){const t=Nr("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(l),P=a(e),v=o(e,"P",{}),Dr(v).forEach(l),M=a(e),m(G.$$.fragment,e),Jl=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-pmpw5m"&&($.innerHTML=za),Hl=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-6u57b2"&&(k.textContent=Aa),Gl=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1fmi0j5"&&(I.innerHTML=Ea),$l=a(e),m(y.$$.fragment,e),kl=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-k4erla"&&(N.textContent=Qa),Il=a(e),m(S.$$.fragment,e),Nl=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-vl1lph"&&(z.innerHTML=Ba),Sl=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-exgbxp"&&(A.innerHTML=Va),zl=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ld98nk"&&(E.textContent=Ra),Al=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-owu077"&&(Q.innerHTML=Za),El=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-108eswe"&&(B.textContent=Fa),Ql=a(e),V=o(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-17djrzw"&&(V.innerHTML=Wa),Bl=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1pjlj4x"&&(R.innerHTML=Xa),Vl=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vvmjdr"&&(Z.textContent=qa),Rl=a(e),F=o(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-1s0wp36"&&(F.innerHTML=Oa),Zl=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-g99shh"&&(W.textContent=Ya),Fl=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-bg5rkn"&&(X.textContent=Ka),Wl=a(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1vlifqo"&&(q.innerHTML=en),Xl=a(e),O=o(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-12kjlqq"&&(O.innerHTML=tn),ql=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-ym8ubp"&&(Y.innerHTML=ln),Ol=a(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-1dtz42n"&&(K.innerHTML=sn),Yl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-4bia72"&&(ee.textContent=an),Kl=a(e),m(te.$$.fragment,e),es=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1017dvy"&&(le.innerHTML=nn),ts=a(e),m(se.$$.fragment,e),ls=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1j6eoys"&&(ie.textContent=on),ss=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1v8b0bi"&&(ae.innerHTML=rn),is=a(e),ne=o(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-ibjm0a"&&(ne.innerHTML=pn),as=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-2za96j"&&(oe.innerHTML=hn),ns=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1e3g0sm"&&(re.textContent=mn),os=a(e),pe=o(e,"OL",{"data-svelte-h":!0}),r(pe)!=="svelte-n1bojj"&&(pe.innerHTML=un),rs=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1yk5hqh"&&(he.textContent=fn),ps=a(e),me=o(e,"OL",{"data-svelte-h":!0}),r(me)!=="svelte-1glndlp"&&(me.innerHTML=dn),hs=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-tn8imq"&&(ue.innerHTML=cn),ms=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-196u8fm"&&(fe.textContent=vn),us=a(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1p9lena"&&(de.innerHTML=wn),fs=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-lyxecx"&&(ce.innerHTML=gn),ds=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1ccu14e"&&(ve.textContent=Pn),cs=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1cuy4x"&&(we.innerHTML=Mn),vs=a(e),m(ge.$$.fragment,e),ws=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-ady25n"&&(Pe.innerHTML=yn),gs=a(e),m(Me.$$.fragment,e),Ps=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1bcmt3e"&&(ye.innerHTML=xn),Ms=a(e),m(xe.$$.fragment,e),ys=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-ammqnu"&&(Te.textContent=Tn),xs=a(e),be=o(e,"TABLE",{"data-svelte-h":!0}),r(be)!=="svelte-1glyygb"&&(be.innerHTML=bn),Ts=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-3h79hx"&&(Ce.textContent=Cn),bs=a(e),m(je.$$.fragment,e),Cs=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-rus1tj"&&(Le.innerHTML=jn),js=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-l6ikqh"&&(x.innerHTML=Ln),Ls=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1n0hd1i"&&(_e.innerHTML=_n),_s=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-yml45c"&&(Ue.textContent=Un),Us=a(e),m(De.$$.fragment,e),Ds=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ycp41i"&&(Je.textContent=Dn),Js=a(e),m(He.$$.fragment,e),Hs=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-vhaef9"&&(Ge.textContent=Jn),Gs=a(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-v79p4j"&&($e.textContent=Hn),$s=a(e),m(ke.$$.fragment,e),ks=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1x8bz4m"&&(Ie.textContent=Gn),Is=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-9s70m2"&&(Ne.innerHTML=$n),Ns=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-18avb09"&&(Se.textContent=kn),Ss=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-ptnnl0"&&(ze.textContent=In),zs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1e42x7e"&&(Ae.textContent=Nn),As=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1qw37a5"&&(Ee.textContent=Sn),Es=a(e),m(T.$$.fragment,e),Qs=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-3x8lv3"&&(Qe.textContent=zn),Bs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1b2mzqh"&&(Be.textContent=An),Vs=a(e),Ve=o(e,"UL",{"data-svelte-h":!0}),r(Ve)!=="svelte-a0zshu"&&(Ve.innerHTML=En),Rs=a(e),m(Re.$$.fragment,e),Zs=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-byke96"&&(Ze.innerHTML=Qn),Fs=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-kfubqe"&&(Fe.textContent=Bn),Ws=a(e),m(We.$$.fragment,e),Xs=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-vd21sy"&&(Xe.textContent=Vn),qs=a(e),qe=o(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-vjztmh"&&(qe.textContent=Rn),Os=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-1l6dgyv"&&(Oe.textContent=Zn),Ys=a(e),Ye=o(e,"UL",{"data-svelte-h":!0}),r(Ye)!=="svelte-19omdeq"&&(Ye.innerHTML=Fn),Ks=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1yzyde0"&&(Ke.textContent=Wn),ei=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1lu2bt6"&&(et.innerHTML=Xn),ti=a(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1zwet4"&&(b.innerHTML=qn),li=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-10mywh3"&&(tt.textContent=On),si=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-qcenct"&&(lt.innerHTML=Yn),ii=a(e),st=o(e,"P",{"data-svelte-h":!0}),r(st)!=="svelte-q4rot4"&&(st.innerHTML=Kn),ai=a(e),it=o(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1qpt7zo"&&(it.innerHTML=eo),ni=a(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1g0sf3v"&&(at.innerHTML=to),oi=a(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-18mmroz"&&(nt.textContent=lo),ri=a(e),ot=o(e,"UL",{"data-svelte-h":!0}),r(ot)!=="svelte-1m54oo0"&&(ot.innerHTML=so),pi=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-3pifdn"&&(rt.textContent=io),hi=a(e),pt=o(e,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-p13wwf"&&(pt.innerHTML=ao),mi=a(e),ht=o(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-5h607a"&&(ht.textContent=no),ui=a(e),mt=o(e,"UL",{"data-svelte-h":!0}),r(mt)!=="svelte-n2xihd"&&(mt.innerHTML=oo),fi=a(e),ut=o(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1xvp26s"&&(ut.textContent=ro),di=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1b2mzqh"&&(ft.textContent=po),ci=a(e),dt=o(e,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-1kewxhh"&&(dt.innerHTML=ho),vi=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-zuoye1"&&(ct.innerHTML=mo),wi=a(e),vt=o(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1nopw2u"&&(vt.innerHTML=uo),gi=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-1djad0c"&&(wt.textContent=fo),Pi=a(e),gt=o(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-vnarcr"&&(gt.innerHTML=co),Mi=a(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-xyuwxq"&&(C.innerHTML=vo),yi=a(e),Pt=o(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-19x9s0e"&&(Pt.textContent=wo),xi=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1q9n35q"&&(Mt.innerHTML=go),Ti=a(e),m(yt.$$.fragment,e),bi=a(e),xt=o(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1fj06i7"&&(xt.innerHTML=Po),Ci=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1ktbklq"&&(Tt.innerHTML=Mo),ji=a(e),bt=o(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-250ai3"&&(bt.textContent=yo),Li=a(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1ugxk60"&&(j.innerHTML=xo),_i=a(e),Ct=o(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-s73n1q"&&(Ct.innerHTML=To),Ui=a(e),L=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(L)!=="svelte-gpv8h8"&&(L.innerHTML=bo),Di=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1lnmjiw"&&(jt.textContent=Co),Ji=a(e),_=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-yslb0f"&&(_.innerHTML=jo),Hi=a(e),Lt=o(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-8jgntx"&&(Lt.textContent=Lo),Gi=a(e),U=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-b5xtwy"&&(U.innerHTML=_o),$i=a(e),_t=o(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-kplhah"&&(_t.textContent=Uo),ki=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-hmoxa9"&&(Ut.innerHTML=Do),Ii=a(e),Dt=o(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1ma7lah"&&(Dt.textContent=Jo),Ni=a(e),Jt=o(e,"UL",{"data-svelte-h":!0}),r(Jt)!=="svelte-p60tn3"&&(Jt.innerHTML=Ho),Si=a(e),Ht=o(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1b2mzqh"&&(Ht.textContent=Go),zi=a(e),Gt=o(e,"UL",{"data-svelte-h":!0}),r(Gt)!=="svelte-sudg8s"&&(Gt.innerHTML=$o),Ai=a(e),$t=o(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-xqarbt"&&($t.textContent=ko),Ei=a(e),kt=o(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1g6ovc1"&&(kt.textContent=Io),Qi=a(e),It=o(e,"UL",{"data-svelte-h":!0}),r(It)!=="svelte-13k8bts"&&(It.innerHTML=No),Bi=a(e),Nt=o(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-f1rs41"&&(Nt.innerHTML=So),Vi=a(e),m(St.$$.fragment,e),Ri=a(e),zt=o(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1oq9xy9"&&(zt.innerHTML=zo),Zi=a(e),D=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(D)!=="svelte-jbayi"&&(D.innerHTML=Ao),Fi=a(e),At=o(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-1xg3nfy"&&(At.textContent=Eo),Wi=a(e),Et=o(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-4rkar7"&&(Et.textContent=Qo),Xi=a(e),Qt=o(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1b2mzqh"&&(Qt.textContent=Bo),qi=a(e),Bt=o(e,"UL",{"data-svelte-h":!0}),r(Bt)!=="svelte-1ry6c7"&&(Bt.innerHTML=Vo),Oi=a(e),Vt=o(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-9dc2gy"&&(Vt.textContent=Ro),Yi=a(e),m(Rt.$$.fragment,e),Ki=a(e),Zt=o(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-fz9fyw"&&(Zt.textContent=Zo),ea=a(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-4i6t8z"&&(J.innerHTML=Fo),ta=a(e),Ft=o(e,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-18bvwlv"&&(Ft.innerHTML=Wo),la=a(e),Wt=o(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-1hp29wn"&&(Wt.textContent=Xo),sa=a(e),Xt=o(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1b2mzqh"&&(Xt.textContent=qo),ia=a(e),qt=o(e,"UL",{"data-svelte-h":!0}),r(qt)!=="svelte-3ic0jq"&&(qt.innerHTML=Oo),aa=a(e),Ot=o(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-r6xwz8"&&(Ot.textContent=Yo),na=a(e),m(Yt.$$.fragment,e),oa=a(e),Kt=o(e,"P",{"data-svelte-h":!0}),r(Kt)!=="svelte-7uwyc9"&&(Kt.innerHTML=Ko),ra=a(e),el=o(e,"P",{"data-svelte-h":!0}),r(el)!=="svelte-172u2n6"&&(el.textContent=er),pa=a(e),tl=o(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-mgnvai"&&(tl.textContent=tr),ha=a(e),ll=o(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-bdt2fr"&&(ll.innerHTML=lr),ma=a(e),sl=o(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-q3kikv"&&(sl.textContent=sr),ua=a(e),il=o(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-s2rtor"&&(il.textContent=ir),fa=a(e),al=o(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-1b2mzqh"&&(al.textContent=ar),da=a(e),nl=o(e,"UL",{"data-svelte-h":!0}),r(nl)!=="svelte-o5zp0z"&&(nl.innerHTML=nr),ca=a(e),ol=o(e,"P",{"data-svelte-h":!0}),r(ol)!=="svelte-1grbiex"&&(ol.textContent=or),va=a(e),rl=o(e,"UL",{"data-svelte-h":!0}),r(rl)!=="svelte-1oyel1u"&&(rl.innerHTML=rr),wa=a(e),pl=o(e,"P",{"data-svelte-h":!0}),r(pl)!=="svelte-r6xwz8"&&(pl.textContent=pr),ga=a(e),m(hl.$$.fragment,e),Pa=a(e),ml=o(e,"P",{"data-svelte-h":!0}),r(ml)!=="svelte-121cfuq"&&(ml.innerHTML=hr),Ma=a(e),ul=o(e,"P",{"data-svelte-h":!0}),r(ul)!=="svelte-dou7hg"&&(ul.innerHTML=mr),ya=a(e),fl=o(e,"P",{"data-svelte-h":!0}),r(fl)!=="svelte-oa098n"&&(fl.textContent=ur),xa=a(e),dl=o(e,"OL",{"data-svelte-h":!0}),r(dl)!=="svelte-6cxs64"&&(dl.innerHTML=fr),Ta=a(e),cl=o(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-kvfsh7"&&(cl.textContent=dr),ba=a(e),vl=o(e,"UL",{"data-svelte-h":!0}),r(vl)!=="svelte-1734ihx"&&(vl.innerHTML=cr),Ca=a(e),wl=o(e,"P",{"data-svelte-h":!0}),r(wl)!=="svelte-jsce61"&&(wl.textContent=vr),ja=a(e),gl=o(e,"UL",{"data-svelte-h":!0}),r(gl)!=="svelte-ilmkvr"&&(gl.innerHTML=wr),La=a(e),Pl=o(e,"P",{"data-svelte-h":!0}),r(Pl)!=="svelte-w2gbdo"&&(Pl.textContent=gr),_a=a(e),Ml=o(e,"UL",{"data-svelte-h":!0}),r(Ml)!=="svelte-dyjda9"&&(Ml.innerHTML=Pr),Ua=a(e),yl=o(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-1qwl5bi"&&(yl.textContent=Mr),Da=a(e),xl=o(e,"UL",{"data-svelte-h":!0}),r(xl)!=="svelte-bzftse"&&(xl.innerHTML=yr),Ja=a(e),Tl=o(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-pn1yl1"&&(Tl.textContent=xr),Ha=a(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(H)!=="svelte-1jywqo8"&&(H.innerHTML=Tr),Ga=a(e),bl=o(e,"P",{"data-svelte-h":!0}),r(bl)!=="svelte-11n85y7"&&(bl.textContent=br),$a=a(e),Cl=o(e,"P",{"data-svelte-h":!0}),r(Cl)!=="svelte-13bz10s"&&(Cl.textContent=Cr),ka=a(e),jl=o(e,"P",{"data-svelte-h":!0}),r(jl)!=="svelte-iohzxv"&&(jl.textContent=jr),Ia=a(e),Ll=o(e,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-so3ryv"&&(Ll.innerHTML=Lr),Na=a(e),Dl=o(e,"P",{}),Dr(Dl).forEach(l),this.h()},h(){w(p,"name","hf:doc:metadata"),w(p,"content",Qr),w(x,"class","flex justify-center"),w(b,"class","flex justify-center"),w(C,"class","flex justify-center"),w(j,"class","flex justify-center"),w(L,"class","flex justify-center"),w(_,"class","flex justify-center"),w(U,"class","flex justify-center"),w(D,"class","flex justify-center"),w(J,"class","flex justify-center"),w(H,"class","flex justify-center")},m(e,t){Sr(document.head,p),s(e,P,t),s(e,v,t),s(e,M,t),u(G,e,t),s(e,Jl,t),s(e,$,t),s(e,Hl,t),s(e,k,t),s(e,Gl,t),s(e,I,t),s(e,$l,t),u(y,e,t),s(e,kl,t),s(e,N,t),s(e,Il,t),u(S,e,t),s(e,Nl,t),s(e,z,t),s(e,Sl,t),s(e,A,t),s(e,zl,t),s(e,E,t),s(e,Al,t),s(e,Q,t),s(e,El,t),s(e,B,t),s(e,Ql,t),s(e,V,t),s(e,Bl,t),s(e,R,t),s(e,Vl,t),s(e,Z,t),s(e,Rl,t),s(e,F,t),s(e,Zl,t),s(e,W,t),s(e,Fl,t),s(e,X,t),s(e,Wl,t),s(e,q,t),s(e,Xl,t),s(e,O,t),s(e,ql,t),s(e,Y,t),s(e,Ol,t),s(e,K,t),s(e,Yl,t),s(e,ee,t),s(e,Kl,t),u(te,e,t),s(e,es,t),s(e,le,t),s(e,ts,t),u(se,e,t),s(e,ls,t),s(e,ie,t),s(e,ss,t),s(e,ae,t),s(e,is,t),s(e,ne,t),s(e,as,t),s(e,oe,t),s(e,ns,t),s(e,re,t),s(e,os,t),s(e,pe,t),s(e,rs,t),s(e,he,t),s(e,ps,t),s(e,me,t),s(e,hs,t),s(e,ue,t),s(e,ms,t),s(e,fe,t),s(e,us,t),s(e,de,t),s(e,fs,t),s(e,ce,t),s(e,ds,t),s(e,ve,t),s(e,cs,t),s(e,we,t),s(e,vs,t),u(ge,e,t),s(e,ws,t),s(e,Pe,t),s(e,gs,t),u(Me,e,t),s(e,Ps,t),s(e,ye,t),s(e,Ms,t),u(xe,e,t),s(e,ys,t),s(e,Te,t),s(e,xs,t),s(e,be,t),s(e,Ts,t),s(e,Ce,t),s(e,bs,t),u(je,e,t),s(e,Cs,t),s(e,Le,t),s(e,js,t),s(e,x,t),s(e,Ls,t),s(e,_e,t),s(e,_s,t),s(e,Ue,t),s(e,Us,t),u(De,e,t),s(e,Ds,t),s(e,Je,t),s(e,Js,t),u(He,e,t),s(e,Hs,t),s(e,Ge,t),s(e,Gs,t),s(e,$e,t),s(e,$s,t),u(ke,e,t),s(e,ks,t),s(e,Ie,t),s(e,Is,t),s(e,Ne,t),s(e,Ns,t),s(e,Se,t),s(e,Ss,t),s(e,ze,t),s(e,zs,t),s(e,Ae,t),s(e,As,t),s(e,Ee,t),s(e,Es,t),u(T,e,t),s(e,Qs,t),s(e,Qe,t),s(e,Bs,t),s(e,Be,t),s(e,Vs,t),s(e,Ve,t),s(e,Rs,t),u(Re,e,t),s(e,Zs,t),s(e,Ze,t),s(e,Fs,t),s(e,Fe,t),s(e,Ws,t),u(We,e,t),s(e,Xs,t),s(e,Xe,t),s(e,qs,t),s(e,qe,t),s(e,Os,t),s(e,Oe,t),s(e,Ys,t),s(e,Ye,t),s(e,Ks,t),s(e,Ke,t),s(e,ei,t),s(e,et,t),s(e,ti,t),s(e,b,t),s(e,li,t),s(e,tt,t),s(e,si,t),s(e,lt,t),s(e,ii,t),s(e,st,t),s(e,ai,t),s(e,it,t),s(e,ni,t),s(e,at,t),s(e,oi,t),s(e,nt,t),s(e,ri,t),s(e,ot,t),s(e,pi,t),s(e,rt,t),s(e,hi,t),s(e,pt,t),s(e,mi,t),s(e,ht,t),s(e,ui,t),s(e,mt,t),s(e,fi,t),s(e,ut,t),s(e,di,t),s(e,ft,t),s(e,ci,t),s(e,dt,t),s(e,vi,t),s(e,ct,t),s(e,wi,t),s(e,vt,t),s(e,gi,t),s(e,wt,t),s(e,Pi,t),s(e,gt,t),s(e,Mi,t),s(e,C,t),s(e,yi,t),s(e,Pt,t),s(e,xi,t),s(e,Mt,t),s(e,Ti,t),u(yt,e,t),s(e,bi,t),s(e,xt,t),s(e,Ci,t),s(e,Tt,t),s(e,ji,t),s(e,bt,t),s(e,Li,t),s(e,j,t),s(e,_i,t),s(e,Ct,t),s(e,Ui,t),s(e,L,t),s(e,Di,t),s(e,jt,t),s(e,Ji,t),s(e,_,t),s(e,Hi,t),s(e,Lt,t),s(e,Gi,t),s(e,U,t),s(e,$i,t),s(e,_t,t),s(e,ki,t),s(e,Ut,t),s(e,Ii,t),s(e,Dt,t),s(e,Ni,t),s(e,Jt,t),s(e,Si,t),s(e,Ht,t),s(e,zi,t),s(e,Gt,t),s(e,Ai,t),s(e,$t,t),s(e,Ei,t),s(e,kt,t),s(e,Qi,t),s(e,It,t),s(e,Bi,t),s(e,Nt,t),s(e,Vi,t),u(St,e,t),s(e,Ri,t),s(e,zt,t),s(e,Zi,t),s(e,D,t),s(e,Fi,t),s(e,At,t),s(e,Wi,t),s(e,Et,t),s(e,Xi,t),s(e,Qt,t),s(e,qi,t),s(e,Bt,t),s(e,Oi,t),s(e,Vt,t),s(e,Yi,t),u(Rt,e,t),s(e,Ki,t),s(e,Zt,t),s(e,ea,t),s(e,J,t),s(e,ta,t),s(e,Ft,t),s(e,la,t),s(e,Wt,t),s(e,sa,t),s(e,Xt,t),s(e,ia,t),s(e,qt,t),s(e,aa,t),s(e,Ot,t),s(e,na,t),u(Yt,e,t),s(e,oa,t),s(e,Kt,t),s(e,ra,t),s(e,el,t),s(e,pa,t),s(e,tl,t),s(e,ha,t),s(e,ll,t),s(e,ma,t),s(e,sl,t),s(e,ua,t),s(e,il,t),s(e,fa,t),s(e,al,t),s(e,da,t),s(e,nl,t),s(e,ca,t),s(e,ol,t),s(e,va,t),s(e,rl,t),s(e,wa,t),s(e,pl,t),s(e,ga,t),u(hl,e,t),s(e,Pa,t),s(e,ml,t),s(e,Ma,t),s(e,ul,t),s(e,ya,t),s(e,fl,t),s(e,xa,t),s(e,dl,t),s(e,Ta,t),s(e,cl,t),s(e,ba,t),s(e,vl,t),s(e,Ca,t),s(e,wl,t),s(e,ja,t),s(e,gl,t),s(e,La,t),s(e,Pl,t),s(e,_a,t),s(e,Ml,t),s(e,Ua,t),s(e,yl,t),s(e,Da,t),s(e,xl,t),s(e,Ja,t),s(e,Tl,t),s(e,Ha,t),s(e,H,t),s(e,Ga,t),s(e,bl,t),s(e,$a,t),s(e,Cl,t),s(e,ka,t),s(e,jl,t),s(e,Ia,t),s(e,Ll,t),s(e,Na,t),s(e,Dl,t),Sa=!0},p(e,[t]){const _r={};t&2&&(_r.$$scope={dirty:t,ctx:e}),y.$set(_r);const Ur={};t&2&&(Ur.$$scope={dirty:t,ctx:e}),T.$set(Ur)},i(e){Sa||(f(G.$$.fragment,e),f(y.$$.fragment,e),f(S.$$.fragment,e),f(te.$$.fragment,e),f(se.$$.fragment,e),f(ge.$$.fragment,e),f(Me.$$.fragment,e),f(xe.$$.fragment,e),f(je.$$.fragment,e),f(De.$$.fragment,e),f(He.$$.fragment,e),f(ke.$$.fragment,e),f(T.$$.fragment,e),f(Re.$$.fragment,e),f(We.$$.fragment,e),f(yt.$$.fragment,e),f(St.$$.fragment,e),f(Rt.$$.fragment,e),f(Yt.$$.fragment,e),f(hl.$$.fragment,e),Sa=!0)},o(e){d(G.$$.fragment,e),d(y.$$.fragment,e),d(S.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(xe.$$.fragment,e),d(je.$$.fragment,e),d(De.$$.fragment,e),d(He.$$.fragment,e),d(ke.$$.fragment,e),d(T.$$.fragment,e),d(Re.$$.fragment,e),d(We.$$.fragment,e),d(yt.$$.fragment,e),d(St.$$.fragment,e),d(Rt.$$.fragment,e),d(Yt.$$.fragment,e),d(hl.$$.fragment,e),Sa=!1},d(e){e&&(l(P),l(v),l(M),l(Jl),l($),l(Hl),l(k),l(Gl),l(I),l($l),l(kl),l(N),l(Il),l(Nl),l(z),l(Sl),l(A),l(zl),l(E),l(Al),l(Q),l(El),l(B),l(Ql),l(V),l(Bl),l(R),l(Vl),l(Z),l(Rl),l(F),l(Zl),l(W),l(Fl),l(X),l(Wl),l(q),l(Xl),l(O),l(ql),l(Y),l(Ol),l(K),l(Yl),l(ee),l(Kl),l(es),l(le),l(ts),l(ls),l(ie),l(ss),l(ae),l(is),l(ne),l(as),l(oe),l(ns),l(re),l(os),l(pe),l(rs),l(he),l(ps),l(me),l(hs),l(ue),l(ms),l(fe),l(us),l(de),l(fs),l(ce),l(ds),l(ve),l(cs),l(we),l(vs),l(ws),l(Pe),l(gs),l(Ps),l(ye),l(Ms),l(ys),l(Te),l(xs),l(be),l(Ts),l(Ce),l(bs),l(Cs),l(Le),l(js),l(x),l(Ls),l(_e),l(_s),l(Ue),l(Us),l(Ds),l(Je),l(Js),l(Hs),l(Ge),l(Gs),l($e),l($s),l(ks),l(Ie),l(Is),l(Ne),l(Ns),l(Se),l(Ss),l(ze),l(zs),l(Ae),l(As),l(Ee),l(Es),l(Qs),l(Qe),l(Bs),l(Be),l(Vs),l(Ve),l(Rs),l(Zs),l(Ze),l(Fs),l(Fe),l(Ws),l(Xs),l(Xe),l(qs),l(qe),l(Os),l(Oe),l(Ys),l(Ye),l(Ks),l(Ke),l(ei),l(et),l(ti),l(b),l(li),l(tt),l(si),l(lt),l(ii),l(st),l(ai),l(it),l(ni),l(at),l(oi),l(nt),l(ri),l(ot),l(pi),l(rt),l(hi),l(pt),l(mi),l(ht),l(ui),l(mt),l(fi),l(ut),l(di),l(ft),l(ci),l(dt),l(vi),l(ct),l(wi),l(vt),l(gi),l(wt),l(Pi),l(gt),l(Mi),l(C),l(yi),l(Pt),l(xi),l(Mt),l(Ti),l(bi),l(xt),l(Ci),l(Tt),l(ji),l(bt),l(Li),l(j),l(_i),l(Ct),l(Ui),l(L),l(Di),l(jt),l(Ji),l(_),l(Hi),l(Lt),l(Gi),l(U),l($i),l(_t),l(ki),l(Ut),l(Ii),l(Dt),l(Ni),l(Jt),l(Si),l(Ht),l(zi),l(Gt),l(Ai),l($t),l(Ei),l(kt),l(Qi),l(It),l(Bi),l(Nt),l(Vi),l(Ri),l(zt),l(Zi),l(D),l(Fi),l(At),l(Wi),l(Et),l(Xi),l(Qt),l(qi),l(Bt),l(Oi),l(Vt),l(Yi),l(Ki),l(Zt),l(ea),l(J),l(ta),l(Ft),l(la),l(Wt),l(sa),l(Xt),l(ia),l(qt),l(aa),l(Ot),l(na),l(oa),l(Kt),l(ra),l(el),l(pa),l(tl),l(ha),l(ll),l(ma),l(sl),l(ua),l(il),l(fa),l(al),l(da),l(nl),l(ca),l(ol),l(va),l(rl),l(wa),l(pl),l(ga),l(Pa),l(ml),l(Ma),l(ul),l(ya),l(fl),l(xa),l(dl),l(Ta),l(cl),l(ba),l(vl),l(Ca),l(wl),l(ja),l(gl),l(La),l(Pl),l(_a),l(Ml),l(Ua),l(yl),l(Da),l(xl),l(Ja),l(Tl),l(Ha),l(H),l(Ga),l(bl),l($a),l(Cl),l(ka),l(jl),l(Ia),l(Ll),l(Na),l(Dl)),l(p),c(G,e),c(y,e),c(S,e),c(te,e),c(se,e),c(ge,e),c(Me,e),c(xe,e),c(je,e),c(De,e),c(He,e),c(ke,e),c(T,e),c(Re,e),c(We,e),c(yt,e),c(St,e),c(Rt,e),c(Yt,e),c(hl,e)}}}const Qr='{"title":"Efficient Training on Multiple GPUs","local":"efficient-training-on-multiple-gpus","sections":[{"title":"Scalability strategy","local":"scalability-strategy","sections":[],"depth":2},{"title":"Data Parallelism","local":"data-parallelism","sections":[{"title":"DataParallel vs DistributedDataParallel","local":"dataparallel-vs-distributeddataparallel","sections":[],"depth":3}],"depth":2},{"title":"ZeRO Data Parallelism","local":"zero-data-parallelism","sections":[],"depth":2},{"title":"From Naive Model Parallelism to Pipeline Parallelism","local":"from-naive-model-parallelism-to-pipeline-parallelism","sections":[],"depth":2},{"title":"Tensor Parallelism","local":"tensor-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism","local":"data-parallelism--pipeline-parallelism","sections":[],"depth":2},{"title":"Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"ZeRO Data Parallelism + Pipeline Parallelism + Tensor Parallelism","local":"zero-data-parallelism--pipeline-parallelism--tensor-parallelism","sections":[],"depth":2},{"title":"FlexFlow","local":"flexflow","sections":[],"depth":2}],"depth":1}';function Br(Ul){return $r(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xr extends kr{constructor(p){super(),Ir(this,p,Br,Er,Gr,{})}}export{Xr as component};
