import{s as At,n as Kt,o as Ot}from"../chunks/scheduler.3e4cb221.js";import{S as el,i as tl,g as i,s as n,r as o,A as ll,h as m,f as l,c as a,j as St,u as r,x as p,k as Dt,y as sl,a as s,v as J,d as c,t as M,w as u}from"../chunks/index.88dc8d40.js";import{C as d}from"../chunks/CodeBlock.d2283cff.js";import{D as nl}from"../chunks/DocNotebookDropdown.c80dcb90.js";import{H as T}from"../chunks/Heading.44b48e03.js";function al(Tt){let g,Te,de,fe,f,Ue,U,be,b,ft='🤗 Transformers 中有多种多语言模型，它们的推理用法与单语言模型不同。但是，并非<em>所有</em>的多语言模型用法都不同。一些模型，例如 <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a> 就可以像单语言模型一样使用。本指南将向您展示如何使用不同用途的多语言模型进行推理。',ye,y,he,h,Ut="XLM 有十个不同的检查点，其中只有一个是单语言的。剩下的九个检查点可以归为两类：使用语言嵌入的检查点和不使用语言嵌入的检查点。",$e,$,we,w,bt="以下 XLM 模型使用语言嵌入来指定推理中使用的语言：",xe,x,yt="<li><code>xlm-mlm-ende-1024</code> （掩码语言建模，英语-德语）</li> <li><code>xlm-mlm-enfr-1024</code> （掩码语言建模，英语-法语）</li> <li><code>xlm-mlm-enro-1024</code> （掩码语言建模，英语-罗马尼亚语）</li> <li><code>xlm-mlm-xnli15-1024</code> （掩码语言建模，XNLI 数据集语言）</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> （掩码语言建模+翻译，XNLI 数据集语言）</li> <li><code>xlm-clm-enfr-1024</code> （因果语言建模，英语-法语）</li> <li><code>xlm-clm-ende-1024</code> （因果语言建模，英语-德语）</li>",je,j,ht="语言嵌入被表示一个张量，其形状与传递给模型的 <code>input_ids</code> 相同。这些张量中的值取决于所使用的语言，并由分词器的 <code>lang2id</code> 和 <code>id2lang</code>  属性识别。",Ce,C,$t="在此示例中，加载 <code>xlm-clm-enfr-1024</code> 检查点（因果语言建模，英语-法语）：",ke,k,ve,v,wt="分词器的 <code>lang2id</code> 属性显示了该模型的语言及其对应的id：",_e,_,Ze,Z,xt="接下来，创建一个示例输入：",Ie,I,Xe,X,jt="将语言 id 设置为 <code>&quot;en&quot;</code> 并用其定义语言嵌入。语言嵌入是一个用 <code>0</code> 填充的张量，这个张量应该与 <code>input_ids</code> 大小相同。",Re,R,Ve,V,Ct="现在，你可以将 <code>input_ids</code> 和语言嵌入传递给模型：",Ge,G,We,W,kt='<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> 脚本可以使用 <code>xlm-clm</code> 检查点生成带有语言嵌入的文本。',Le,L,ze,z,vt="以下 XLM 模型在推理时不需要语言嵌入：",Be,B,_t="<li><code>xlm-mlm-17-1280</code> （掩码语言建模，支持 17 种语言）</li> <li><code>xlm-mlm-100-1280</code> （掩码语言建模，支持 100 种语言）</li>",Ee,E,Zt="与之前的 XLM 检查点不同，这些模型用于通用句子表示。",Fe,F,Qe,Q,It="以下 BERT 模型可用于多语言任务：",He,H,Xt="<li><code>bert-base-multilingual-uncased</code> （掩码语言建模 + 下一句预测，支持 102 种语言）</li> <li><code>bert-base-multilingual-cased</code> （掩码语言建模 + 下一句预测，支持 104 种语言）</li>",qe,q,Rt="这些模型在推理时不需要语言嵌入。它们应该能够从上下文中识别语言并进行相应的推理。",Ne,N,Ye,Y,Vt="以下 XLM-RoBERTa 模型可用于多语言任务：",Pe,P,Gt="<li><code>xlm-roberta-base</code> （掩码语言建模，支持 100 种语言）</li> <li><code>xlm-roberta-large</code> （掩码语言建模，支持 100 种语言）</li>",Se,S,Wt="XLM-RoBERTa 使用 100 种语言的 2.5TB 新创建和清理的 CommonCrawl 数据进行了训练。与之前发布的 mBERT 或 XLM 等多语言模型相比，它在分类、序列标记和问答等下游任务上提供了更强大的优势。",De,D,Ae,A,Lt="以下 M2M100 模型可用于多语言翻译：",Ke,K,zt="<li><code>facebook/m2m100_418M</code> （翻译）</li> <li><code>facebook/m2m100_1.2B</code> （翻译）</li>",Oe,O,Bt="在此示例中，加载 <code>facebook/m2m100_418M</code> 检查点以将中文翻译为英文。你可以在分词器中设置源语言：",et,ee,tt,te,Et="对文本进行分词：",lt,le,st,se,Ft="M2M100 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",nt,ne,at,ae,it,ie,Qt="以下 MBart 模型可用于多语言翻译：",mt,me,Ht="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> （一对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> （多对多多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> （多对一多语言机器翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-50</code> （多语言翻译，支持 50 种语言）</li> <li><code>facebook/mbart-large-cc25</code></li>",pt,pe,qt="在此示例中，加载  <code>facebook/mbart-large-50-many-to-many-mmt</code> 检查点以将芬兰语翻译为英语。 你可以在分词器中设置源语言：",ot,oe,rt,re,Nt="对文本进行分词：",Jt,Je,ct,ce,Yt="MBart 强制将目标语言 id 作为第一个生成的标记，以进行到目标语言的翻译。在 <code>generate</code> 方法中将 <code>forced_bos_token_id</code> 设置为 <code>en</code> 以翻译成英语：",Mt,Me,ut,ue,Pt="如果你使用的是 <code>facebook/mbart-large-50-many-to-one-mmt</code> 检查点，则无需强制目标语言 id 作为第一个生成的令牌，否则用法是相同的。",dt,ge,gt;return f=new T({props:{title:"用于推理的多语言模型",local:"用于推理的多语言模型",headingTag:"h1"}}),U=new nl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/multilingual.ipynb"}]}}),y=new T({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new T({props:{title:"带有语言嵌入的 XLM",local:"带有语言嵌入的-xlm",headingTag:"h3"}}),k=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),_=new d({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),I=new d({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAx",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size 为 1</span>',wrap:!1}}),R=new d({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwJUU2JTg4JTkxJUU0JUJCJUFDJUU1JUIwJTg2JUU1JTg1JUI2JTIwcmVzaGFwZSUyMCVFNCVCOCVCQSUyMChiYXRjaF9zaXplJTJDJTIwc2VxdWVuY2VfbGVuZ3RoKSUyMCVFNSVBNCVBNyVFNSVCMCU4RiUwQWxhbmdzJTIwJTNEJTIwbGFuZ3MudmlldygxJTJDJTIwLTEpJTIwJTIwJTIzJTIwJUU3JThFJUIwJUU1JTlDJUE4JUU3JTlBJTg0JUU1JUJEJUEyJUU3JThBJUI2JUU2JTk4JUFGJTIwJTVCMSUyQyUyMHNlcXVlbmNlX2xlbmd0aCU1RCUyMCglRTYlODglOTElRTQlQkIlQUMlRTclOUElODQlMjBiYXRjaCUyMHNpemUlMjAlRTQlQjglQkElMjAxKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># 我们将其 reshape 为 (batch_size, sequence_length) 大小</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># 现在的形状是 [1, sequence_length] (我们的 batch size 为 1)</span>`,wrap:!1}}),G=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),L=new T({props:{title:"不带语言嵌入的 XLM",local:"不带语言嵌入的-xlm",headingTag:"h3"}}),F=new T({props:{title:"BERT",local:"bert",headingTag:"h2"}}),N=new T({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),D=new T({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new d({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ne=new d({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ae=new T({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),oe=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),Je=new d({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Me=new d({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkJTVCJTIyZW5fWFglMjIlNUQpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id[<span class="hljs-string">&quot;en_XX&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){g=i("meta"),Te=n(),de=i("p"),fe=n(),o(f.$$.fragment),Ue=n(),o(U.$$.fragment),be=n(),b=i("p"),b.innerHTML=ft,ye=n(),o(y.$$.fragment),he=n(),h=i("p"),h.textContent=Ut,$e=n(),o($.$$.fragment),we=n(),w=i("p"),w.textContent=bt,xe=n(),x=i("ul"),x.innerHTML=yt,je=n(),j=i("p"),j.innerHTML=ht,Ce=n(),C=i("p"),C.innerHTML=$t,ke=n(),o(k.$$.fragment),ve=n(),v=i("p"),v.innerHTML=wt,_e=n(),o(_.$$.fragment),Ze=n(),Z=i("p"),Z.textContent=xt,Ie=n(),o(I.$$.fragment),Xe=n(),X=i("p"),X.innerHTML=jt,Re=n(),o(R.$$.fragment),Ve=n(),V=i("p"),V.innerHTML=Ct,Ge=n(),o(G.$$.fragment),We=n(),W=i("p"),W.innerHTML=kt,Le=n(),o(L.$$.fragment),ze=n(),z=i("p"),z.textContent=vt,Be=n(),B=i("ul"),B.innerHTML=_t,Ee=n(),E=i("p"),E.textContent=Zt,Fe=n(),o(F.$$.fragment),Qe=n(),Q=i("p"),Q.textContent=It,He=n(),H=i("ul"),H.innerHTML=Xt,qe=n(),q=i("p"),q.textContent=Rt,Ne=n(),o(N.$$.fragment),Ye=n(),Y=i("p"),Y.textContent=Vt,Pe=n(),P=i("ul"),P.innerHTML=Gt,Se=n(),S=i("p"),S.textContent=Wt,De=n(),o(D.$$.fragment),Ae=n(),A=i("p"),A.textContent=Lt,Ke=n(),K=i("ul"),K.innerHTML=zt,Oe=n(),O=i("p"),O.innerHTML=Bt,et=n(),o(ee.$$.fragment),tt=n(),te=i("p"),te.textContent=Et,lt=n(),o(le.$$.fragment),st=n(),se=i("p"),se.innerHTML=Ft,nt=n(),o(ne.$$.fragment),at=n(),o(ae.$$.fragment),it=n(),ie=i("p"),ie.textContent=Qt,mt=n(),me=i("ul"),me.innerHTML=Ht,pt=n(),pe=i("p"),pe.innerHTML=qt,ot=n(),o(oe.$$.fragment),rt=n(),re=i("p"),re.textContent=Nt,Jt=n(),o(Je.$$.fragment),ct=n(),ce=i("p"),ce.innerHTML=Yt,Mt=n(),o(Me.$$.fragment),ut=n(),ue=i("p"),ue.innerHTML=Pt,dt=n(),ge=i("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);g=m(t,"META",{name:!0,content:!0}),t.forEach(l),Te=a(e),de=m(e,"P",{}),St(de).forEach(l),fe=a(e),r(f.$$.fragment,e),Ue=a(e),r(U.$$.fragment,e),be=a(e),b=m(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-tk208n"&&(b.innerHTML=ft),ye=a(e),r(y.$$.fragment,e),he=a(e),h=m(e,"P",{"data-svelte-h":!0}),p(h)!=="svelte-1do04ou"&&(h.textContent=Ut),$e=a(e),r($.$$.fragment,e),we=a(e),w=m(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-ae6845"&&(w.textContent=bt),xe=a(e),x=m(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-o2sepu"&&(x.innerHTML=yt),je=a(e),j=m(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1xxan1y"&&(j.innerHTML=ht),Ce=a(e),C=m(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-y2cvsq"&&(C.innerHTML=$t),ke=a(e),r(k.$$.fragment,e),ve=a(e),v=m(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1bg3kzi"&&(v.innerHTML=wt),_e=a(e),r(_.$$.fragment,e),Ze=a(e),Z=m(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-mgsk1x"&&(Z.textContent=xt),Ie=a(e),r(I.$$.fragment,e),Xe=a(e),X=m(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1wd8oyh"&&(X.innerHTML=jt),Re=a(e),r(R.$$.fragment,e),Ve=a(e),V=m(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-wr7smr"&&(V.innerHTML=Ct),Ge=a(e),r(G.$$.fragment,e),We=a(e),W=m(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1y11as"&&(W.innerHTML=kt),Le=a(e),r(L.$$.fragment,e),ze=a(e),z=m(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-ug2kdl"&&(z.textContent=vt),Be=a(e),B=m(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-f6s7ji"&&(B.innerHTML=_t),Ee=a(e),E=m(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-s35cwf"&&(E.textContent=Zt),Fe=a(e),r(F.$$.fragment,e),Qe=a(e),Q=m(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-10z54vn"&&(Q.textContent=It),He=a(e),H=m(e,"UL",{"data-svelte-h":!0}),p(H)!=="svelte-uos87p"&&(H.innerHTML=Xt),qe=a(e),q=m(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-mlr4c8"&&(q.textContent=Rt),Ne=a(e),r(N.$$.fragment,e),Ye=a(e),Y=m(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1e23zdv"&&(Y.textContent=Vt),Pe=a(e),P=m(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-qd9drw"&&(P.innerHTML=Gt),Se=a(e),S=m(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-gdaw37"&&(S.textContent=Wt),De=a(e),r(D.$$.fragment,e),Ae=a(e),A=m(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1eurwqt"&&(A.textContent=Lt),Ke=a(e),K=m(e,"UL",{"data-svelte-h":!0}),p(K)!=="svelte-11pgdv5"&&(K.innerHTML=zt),Oe=a(e),O=m(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-7kr2c3"&&(O.innerHTML=Bt),et=a(e),r(ee.$$.fragment,e),tt=a(e),te=m(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1azdq78"&&(te.textContent=Et),lt=a(e),r(le.$$.fragment,e),st=a(e),se=m(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-7k4v2z"&&(se.innerHTML=Ft),nt=a(e),r(ne.$$.fragment,e),at=a(e),r(ae.$$.fragment,e),it=a(e),ie=m(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1n3gxv8"&&(ie.textContent=Qt),mt=a(e),me=m(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-xrptst"&&(me.innerHTML=Ht),pt=a(e),pe=m(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-df2xsd"&&(pe.innerHTML=qt),ot=a(e),r(oe.$$.fragment,e),rt=a(e),re=m(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1azdq78"&&(re.textContent=Nt),Jt=a(e),r(Je.$$.fragment,e),ct=a(e),ce=m(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-z2e3e4"&&(ce.innerHTML=Yt),Mt=a(e),r(Me.$$.fragment,e),ut=a(e),ue=m(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-573keg"&&(ue.innerHTML=Pt),dt=a(e),ge=m(e,"P",{}),St(ge).forEach(l),this.h()},h(){Dt(g,"name","hf:doc:metadata"),Dt(g,"content",il)},m(e,t){sl(document.head,g),s(e,Te,t),s(e,de,t),s(e,fe,t),J(f,e,t),s(e,Ue,t),J(U,e,t),s(e,be,t),s(e,b,t),s(e,ye,t),J(y,e,t),s(e,he,t),s(e,h,t),s(e,$e,t),J($,e,t),s(e,we,t),s(e,w,t),s(e,xe,t),s(e,x,t),s(e,je,t),s(e,j,t),s(e,Ce,t),s(e,C,t),s(e,ke,t),J(k,e,t),s(e,ve,t),s(e,v,t),s(e,_e,t),J(_,e,t),s(e,Ze,t),s(e,Z,t),s(e,Ie,t),J(I,e,t),s(e,Xe,t),s(e,X,t),s(e,Re,t),J(R,e,t),s(e,Ve,t),s(e,V,t),s(e,Ge,t),J(G,e,t),s(e,We,t),s(e,W,t),s(e,Le,t),J(L,e,t),s(e,ze,t),s(e,z,t),s(e,Be,t),s(e,B,t),s(e,Ee,t),s(e,E,t),s(e,Fe,t),J(F,e,t),s(e,Qe,t),s(e,Q,t),s(e,He,t),s(e,H,t),s(e,qe,t),s(e,q,t),s(e,Ne,t),J(N,e,t),s(e,Ye,t),s(e,Y,t),s(e,Pe,t),s(e,P,t),s(e,Se,t),s(e,S,t),s(e,De,t),J(D,e,t),s(e,Ae,t),s(e,A,t),s(e,Ke,t),s(e,K,t),s(e,Oe,t),s(e,O,t),s(e,et,t),J(ee,e,t),s(e,tt,t),s(e,te,t),s(e,lt,t),J(le,e,t),s(e,st,t),s(e,se,t),s(e,nt,t),J(ne,e,t),s(e,at,t),J(ae,e,t),s(e,it,t),s(e,ie,t),s(e,mt,t),s(e,me,t),s(e,pt,t),s(e,pe,t),s(e,ot,t),J(oe,e,t),s(e,rt,t),s(e,re,t),s(e,Jt,t),J(Je,e,t),s(e,ct,t),s(e,ce,t),s(e,Mt,t),J(Me,e,t),s(e,ut,t),s(e,ue,t),s(e,dt,t),s(e,ge,t),gt=!0},p:Kt,i(e){gt||(c(f.$$.fragment,e),c(U.$$.fragment,e),c(y.$$.fragment,e),c($.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(I.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(Je.$$.fragment,e),c(Me.$$.fragment,e),gt=!0)},o(e){M(f.$$.fragment,e),M(U.$$.fragment,e),M(y.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(_.$$.fragment,e),M(I.$$.fragment,e),M(R.$$.fragment,e),M(G.$$.fragment,e),M(L.$$.fragment,e),M(F.$$.fragment,e),M(N.$$.fragment,e),M(D.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(oe.$$.fragment,e),M(Je.$$.fragment,e),M(Me.$$.fragment,e),gt=!1},d(e){e&&(l(Te),l(de),l(fe),l(Ue),l(be),l(b),l(ye),l(he),l(h),l($e),l(we),l(w),l(xe),l(x),l(je),l(j),l(Ce),l(C),l(ke),l(ve),l(v),l(_e),l(Ze),l(Z),l(Ie),l(Xe),l(X),l(Re),l(Ve),l(V),l(Ge),l(We),l(W),l(Le),l(ze),l(z),l(Be),l(B),l(Ee),l(E),l(Fe),l(Qe),l(Q),l(He),l(H),l(qe),l(q),l(Ne),l(Ye),l(Y),l(Pe),l(P),l(Se),l(S),l(De),l(Ae),l(A),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(st),l(se),l(nt),l(at),l(it),l(ie),l(mt),l(me),l(pt),l(pe),l(ot),l(rt),l(re),l(Jt),l(ct),l(ce),l(Mt),l(ut),l(ue),l(dt),l(ge)),l(g),u(f,e),u(U,e),u(y,e),u($,e),u(k,e),u(_,e),u(I,e),u(R,e),u(G,e),u(L,e),u(F,e),u(N,e),u(D,e),u(ee,e),u(le,e),u(ne,e),u(ae,e),u(oe,e),u(Je,e),u(Me,e)}}}const il='{"title":"用于推理的多语言模型","local":"用于推理的多语言模型","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"带有语言嵌入的 XLM","local":"带有语言嵌入的-xlm","sections":[],"depth":3},{"title":"不带语言嵌入的 XLM","local":"不带语言嵌入的-xlm","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ml(Tt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends el{constructor(g){super(),tl(this,g,ml,al,At,{})}}export{Ml as component};
