import{s as pl,o as il,n as ol}from"../chunks/scheduler.3e4cb221.js";import{S as Ml,i as ml,g as p,s as a,r as M,A as rl,h as i,f as l,c as n,j as nl,u as m,x as o,k as ks,y as cl,a as e,v as r,d as c,t as u,w as d}from"../chunks/index.88dc8d40.js";import{T as ul}from"../chunks/Tip.00072250.js";import{C as T}from"../chunks/CodeBlock.d2283cff.js";import{D as dl}from"../chunks/DocNotebookDropdown.c80dcb90.js";import{H as y}from"../chunks/Heading.44b48e03.js";function gl(ft){let g,U='如果您对基本的LLM使用感兴趣，我们高级的<a href="pipeline_tutorial"><code>Pipeline</code></a>接口是一个很好的起点。然而，LLMs通常需要像<code>quantization</code>和<code>token选择步骤的精细控制</code>等高级功能，这最好通过<code>generate()</code>来完成。使用LLM进行自回归生成也是资源密集型的操作，应该在GPU上执行以获得足够的吞吐量。';return{c(){g=p("p"),g.innerHTML=U},l(h){g=i(h,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1fzrcun"&&(g.innerHTML=U)},m(h,bt){e(h,g,bt)},p:ol,d(h){h&&l(g)}}}function yl(ft){let g,U,h,bt,f,wt,w,Zt,Z,Is="LLMs，即大语言模型，是文本生成背后的关键组成部分。简单来说，它们包含经过大规模预训练的transformer模型，用于根据给定的输入文本预测下一个词（或更准确地说，下一个<code>token</code>）。由于它们一次只预测一个<code>token</code>，因此除了调用模型之外，您需要执行更复杂的操作来生成新的句子——您需要进行自回归生成。",kt,k,Gs="自回归生成是在给定一些初始输入，通过迭代调用模型及其自身的生成输出来生成文本的推理过程，。在🤗 Transformers中，这由<code>generate()</code>方法处理，所有具有生成能力的模型都可以使用该方法。",It,I,_s="本教程将向您展示如何：",Gt,G,Bs="<li>使用LLM生成文本</li> <li>避免常见的陷阱</li> <li>帮助您充分利用LLM下一步指导</li>",_t,_,$s="在开始之前，请确保已安装所有必要的库：",Bt,B,$t,$,Xt,X,Xs='一个用于<a href="tasks/language_modeling">因果语言建模</a>训练的语言模型，将文本<code>tokens</code>序列作为输入，并返回下一个<code>token</code>的概率分布。',Vt,j,Vs='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;LLM的前向传递&quot;</figcaption>',Wt,V,Ws="使用LLM进行自回归生成的一个关键方面是如何从这个概率分布中选择下一个<code>token</code>。这个步骤可以随意进行，只要最终得到下一个迭代的<code>token</code>。这意味着可以简单的从概率分布中选择最可能的<code>token</code>，也可以复杂的在对结果分布进行采样之前应用多种变换，这取决于你的需求。",Rt,J,Rs='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;自回归生成迭代地从概率分布中选择下一个token以生成文本&quot;</figcaption>',vt,W,vs="上述过程是迭代重复的，直到达到某个停止条件。理想情况下，停止条件由模型决定，该模型应学会在何时输出一个结束序列（<code>EOS</code>）标记。如果不是这种情况，生成将在达到某个预定义的最大长度时停止。",Ct,R,Cs="正确设置<code>token</code>选择步骤和停止条件对于让你的模型按照预期的方式执行任务至关重要。这就是为什么我们为每个模型都有一个[~generation.GenerationConfig]文件，它包含一个效果不错的默认生成参数配置，并与您模型一起加载。",zt,v,zs="让我们谈谈代码！",Ht,b,Lt,C,Hs="首先，您需要加载模型。",xt,z,Ft,H,Ls="您将会注意到在<code>from_pretrained</code>调用中的两个标志：",qt,L,xs='<li><code>device_map</code>确保模型被移动到您的GPU(s)上</li> <li><code>load_in_4bit</code>应用<a href="main_classes/quantization">4位动态量化</a>来极大地减少资源需求</li>',Qt,x,Fs="还有其他方式来初始化一个模型，但这是一个开始使用LLM很好的起点。",Nt,F,qs='接下来，你需要使用一个<a href="tokenizer_summary">tokenizer</a>来预处理你的文本输入。',Et,q,St,Q,Qs="<code>model_inputs</code>变量保存着分词后的文本输入以及注意力掩码。尽管<code>generate()</code>在未传递注意力掩码时会尽其所能推断出注意力掩码，但建议尽可能传递它以获得最佳结果。",Yt,N,Ns="在对输入进行分词后，可以调用<code>generate()</code>方法来返回生成的<code>tokens</code>。生成的<code>tokens</code>应该在打印之前转换为文本。",At,E,Kt,S,Es="最后，您不需要一次处理一个序列！您可以批量输入，这将在小延迟和低内存成本下显著提高吞吐量。您只需要确保正确地填充您的输入（详见下文）。",Dt,Y,Pt,A,Ss="就是这样！在几行代码中，您就可以利用LLM的强大功能。",Ot,K,ts,D,Ys='有许多<a href="generation_strategies">生成策略</a>，有时默认值可能不适合您的用例。如果您的输出与您期望的结果不匹配，我们已经创建了一个最常见的陷阱列表以及如何避免它们。',ss,P,ls,O,es,tt,As='如果在<code>GenerationConfig</code>文件中没有指定，<code>generate</code>默认返回20个tokens。我们强烈建议在您的<code>generate</code>调用中手动设置<code>max_new_tokens</code>以控制它可以返回的最大新tokens数量。请注意，LLMs（更准确地说，仅<a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">解码器模型</a>）也将输入提示作为输出的一部分返回。',as,st,ns,lt,ps,et,Ks='默认情况下，除非在<code>GenerationConfig</code>文件中指定，否则<code>generate</code>会在每个迭代中选择最可能的token（贪婪解码）。对于您的任务，这可能是不理想的；像聊天机器人或写作文章这样的创造性任务受益于采样。另一方面，像音频转录或翻译这样的基于输入的任务受益于贪婪解码。通过将<code>do_sample=True</code>启用采样，您可以在这篇<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">博客文章</a>中了解更多关于这个话题的信息。',is,at,os,nt,Ms,pt,Ds='LLMs是<a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">仅解码器</a>架构，意味着它们会持续迭代您的输入提示。如果您的输入长度不相同，则需要对它们进行填充。由于LLMs没有接受过从<code>pad tokens</code>继续训练，因此您的输入需要左填充。确保在生成时不要忘记传递注意力掩码！',ms,it,rs,ot,cs,Mt,Ps='一些模型和任务期望某种输入提示格式才能正常工作。当未应用此格式时，您将获得悄然的性能下降：模型能工作，但不如预期提示那样好。有关提示的更多信息，包括哪些模型和任务需要小心，可在<a href="tasks/prompting">指南</a>中找到。让我们看一个使用<a href="chat_templating">聊天模板</a>的聊天LLM示例：',us,mt,ds,rt,gs,ct,Os="虽然自回归生成过程相对简单，但要充分利用LLM可能是一个具有挑战性的任务，因为很多组件复杂且密切关联。以下是帮助您深入了解LLM使用和理解的下一步：",ys,ut,hs,dt,tl='<li><a href="generation_strategies">指南</a>，介绍如何控制不同的生成方法、如何设置生成配置文件以及如何进行输出流式传输；</li> <li><a href="chat_templating">指南</a>，介绍聊天LLMs的提示模板；</li> <li><a href="tasks/prompting">指南</a>，介绍如何充分利用提示设计；</li> <li>API参考文档，包括<code>GenerationConfig</code>、<code>generate()</code>和<a href="internal/generation_utils">与生成相关的类</a>。</li>',Ts,gt,js,yt,sl='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, 侧重于开源模型的质量;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, 侧重于LLM的吞吐量.</li>',Js,ht,bs,Tt,ll='<li><a href="llm_tutorial_optimization">指南</a>,如何优化LLMs以提高速度和内存利用；</li> <li><a href="main_classes/quantization">指南</a>, 关于<code>quantization</code>，如bitsandbytes和autogptq的指南，教您如何大幅降低内存需求。</li>',Us,jt,fs,Jt,el='<li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, 一个面向生产的LLM服务器；</li> <li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, 一个🤗 Transformers的扩展，优化特定硬件设备的性能</li>',ws,Ut,Zs;return f=new y({props:{title:"使用LLMs进行生成",local:"使用llms进行生成",headingTag:"h2"}}),w=new dl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/zh/tensorflow/llm_tutorial.ipynb"}]}}),B=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),$=new y({props:{title:"生成文本",local:"生成文本",headingTag:"h2"}}),b=new ul({props:{$$slots:{default:[gl]},$$scope:{ctx:ft}}}),z=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new T({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),Y=new T({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),K=new y({props:{title:"常见陷阱",local:"常见陷阱",headingTag:"h2"}}),P=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),O=new y({props:{title:"生成的输出太短/太长",local:"生成的输出太短太长",headingTag:"h3"}}),st=new T({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBvdXRwdXQlMjB3aWxsJTIwY29udGFpbiUyMHVwJTIwdG8lMjAyMCUyMHRva2VucyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwU2V0dGluZyUyMCU2MG1heF9uZXdfdG9rZW5zJTYwJTIwYWxsb3dzJTIweW91JTIwdG8lMjBjb250cm9sJTIwdGhlJTIwbWF4aW11bSUyMGxlbmd0aCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),lt=new y({props:{title:"错误的生成模式",local:"错误的生成模式",headingTag:"h3"}}),at=new T({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMG9yJTIwcmVwcm9kdWNpYmlsaXR5JTIwLS0lMjB5b3UlMjBkb24ndCUyMG5lZWQlMjB0aGlzJTIwdW5sZXNzJTIweW91JTIwd2FudCUyMGZ1bGwlMjByZXByb2R1Y2liaWxpdHklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwc2V0X3NlZWQlMEFzZXRfc2VlZCg0MiklMEElMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySSUyMGFtJTIwYSUyMGNhdC4lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMExMTSUyMCUyQiUyMGdyZWVkeSUyMGRlY29kaW5nJTIwJTNEJTIwcmVwZXRpdGl2ZSUyQyUyMGJvcmluZyUyMG91dHB1dCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwYmVjb21lcyUyMG1vcmUlMjBjcmVhdGl2ZSElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed or reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),nt=new y({props:{title:"错误的填充位置",local:"错误的填充位置",headingTag:"h3"}}),it=new T({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMFdpdGglMjBsZWZ0LXBhZGRpbmclMkMlMjBpdCUyMHdvcmtzJTIwYXMlMjBleHBlY3RlZCElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyKSUwQXRva2VuaXplci5wYWRfdG9rZW4lMjAlM0QlMjB0b2tlbml6ZXIuZW9zX3Rva2VuJTIwJTIwJTIzJTIwTW9zdCUyMExMTXMlMjBkb24ndCUyMGhhdmUlMjBhJTIwcGFkJTIwdG9rZW4lMjBieSUyMGRlZmF1bHQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwJTIyQSUyQyUyMEIlMkMlMjBDJTJDJTIwRCUyQyUyMEUlMjIlNUQlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),ot=new y({props:{title:"错误的提示",local:"错误的提示",headingTag:"h3"}}),mt=new T({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),rt=new y({props:{title:"更多资源",local:"更多资源",headingTag:"h2"}}),ut=new y({props:{title:"高级生成用法",local:"高级生成用法",headingTag:"h3"}}),gt=new y({props:{title:"LLM排行榜",local:"llm排行榜",headingTag:"h3"}}),ht=new y({props:{title:"延迟、吞吐量和内存利用率",local:"延迟吞吐量和内存利用率",headingTag:"h3"}}),jt=new y({props:{title:"相关库",local:"相关库",headingTag:"h3"}}),{c(){g=p("meta"),U=a(),h=p("p"),bt=a(),M(f.$$.fragment),wt=a(),M(w.$$.fragment),Zt=a(),Z=p("p"),Z.innerHTML=Is,kt=a(),k=p("p"),k.innerHTML=Gs,It=a(),I=p("p"),I.textContent=_s,Gt=a(),G=p("ul"),G.innerHTML=Bs,_t=a(),_=p("p"),_.textContent=$s,Bt=a(),M(B.$$.fragment),$t=a(),M($.$$.fragment),Xt=a(),X=p("p"),X.innerHTML=Xs,Vt=a(),j=p("figure"),j.innerHTML=Vs,Wt=a(),V=p("p"),V.innerHTML=Ws,Rt=a(),J=p("figure"),J.innerHTML=Rs,vt=a(),W=p("p"),W.innerHTML=vs,Ct=a(),R=p("p"),R.innerHTML=Cs,zt=a(),v=p("p"),v.textContent=zs,Ht=a(),M(b.$$.fragment),Lt=a(),C=p("p"),C.textContent=Hs,xt=a(),M(z.$$.fragment),Ft=a(),H=p("p"),H.innerHTML=Ls,qt=a(),L=p("ul"),L.innerHTML=xs,Qt=a(),x=p("p"),x.textContent=Fs,Nt=a(),F=p("p"),F.innerHTML=qs,Et=a(),M(q.$$.fragment),St=a(),Q=p("p"),Q.innerHTML=Qs,Yt=a(),N=p("p"),N.innerHTML=Ns,At=a(),M(E.$$.fragment),Kt=a(),S=p("p"),S.textContent=Es,Dt=a(),M(Y.$$.fragment),Pt=a(),A=p("p"),A.textContent=Ss,Ot=a(),M(K.$$.fragment),ts=a(),D=p("p"),D.innerHTML=Ys,ss=a(),M(P.$$.fragment),ls=a(),M(O.$$.fragment),es=a(),tt=p("p"),tt.innerHTML=As,as=a(),M(st.$$.fragment),ns=a(),M(lt.$$.fragment),ps=a(),et=p("p"),et.innerHTML=Ks,is=a(),M(at.$$.fragment),os=a(),M(nt.$$.fragment),Ms=a(),pt=p("p"),pt.innerHTML=Ds,ms=a(),M(it.$$.fragment),rs=a(),M(ot.$$.fragment),cs=a(),Mt=p("p"),Mt.innerHTML=Ps,us=a(),M(mt.$$.fragment),ds=a(),M(rt.$$.fragment),gs=a(),ct=p("p"),ct.textContent=Os,ys=a(),M(ut.$$.fragment),hs=a(),dt=p("ol"),dt.innerHTML=tl,Ts=a(),M(gt.$$.fragment),js=a(),yt=p("ol"),yt.innerHTML=sl,Js=a(),M(ht.$$.fragment),bs=a(),Tt=p("ol"),Tt.innerHTML=ll,Us=a(),M(jt.$$.fragment),fs=a(),Jt=p("ol"),Jt.innerHTML=el,ws=a(),Ut=p("p"),this.h()},l(t){const s=rl("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(l),U=n(t),h=i(t,"P",{}),nl(h).forEach(l),bt=n(t),m(f.$$.fragment,t),wt=n(t),m(w.$$.fragment,t),Zt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-8lgfa7"&&(Z.innerHTML=Is),kt=n(t),k=i(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-193bll4"&&(k.innerHTML=Gs),It=n(t),I=i(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-lx14wd"&&(I.textContent=_s),Gt=n(t),G=i(t,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-13m7zir"&&(G.innerHTML=Bs),_t=n(t),_=i(t,"P",{"data-svelte-h":!0}),o(_)!=="svelte-noc1o7"&&(_.textContent=$s),Bt=n(t),m(B.$$.fragment,t),$t=n(t),m($.$$.fragment,t),Xt=n(t),X=i(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1wbwdf2"&&(X.innerHTML=Xs),Vt=n(t),j=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-4ssllr"&&(j.innerHTML=Vs),Wt=n(t),V=i(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1ikd8ml"&&(V.innerHTML=Ws),Rt=n(t),J=i(t,"FIGURE",{class:!0,"data-svelte-h":!0}),o(J)!=="svelte-bzy8d0"&&(J.innerHTML=Rs),vt=n(t),W=i(t,"P",{"data-svelte-h":!0}),o(W)!=="svelte-yw7aac"&&(W.innerHTML=vs),Ct=n(t),R=i(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-scvmxm"&&(R.innerHTML=Cs),zt=n(t),v=i(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-23apfz"&&(v.textContent=zs),Ht=n(t),m(b.$$.fragment,t),Lt=n(t),C=i(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-11xv34o"&&(C.textContent=Hs),xt=n(t),m(z.$$.fragment,t),Ft=n(t),H=i(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-6j494d"&&(H.innerHTML=Ls),qt=n(t),L=i(t,"UL",{"data-svelte-h":!0}),o(L)!=="svelte-4d7bnv"&&(L.innerHTML=xs),Qt=n(t),x=i(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-seh5kq"&&(x.textContent=Fs),Nt=n(t),F=i(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-57ytyl"&&(F.innerHTML=qs),Et=n(t),m(q.$$.fragment,t),St=n(t),Q=i(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1kmshty"&&(Q.innerHTML=Qs),Yt=n(t),N=i(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1svt1hl"&&(N.innerHTML=Ns),At=n(t),m(E.$$.fragment,t),Kt=n(t),S=i(t,"P",{"data-svelte-h":!0}),o(S)!=="svelte-dnai18"&&(S.textContent=Es),Dt=n(t),m(Y.$$.fragment,t),Pt=n(t),A=i(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1eqj8jy"&&(A.textContent=Ss),Ot=n(t),m(K.$$.fragment,t),ts=n(t),D=i(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1awc9fu"&&(D.innerHTML=Ys),ss=n(t),m(P.$$.fragment,t),ls=n(t),m(O.$$.fragment,t),es=n(t),tt=i(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1vu8cjd"&&(tt.innerHTML=As),as=n(t),m(st.$$.fragment,t),ns=n(t),m(lt.$$.fragment,t),ps=n(t),et=i(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-1ablpct"&&(et.innerHTML=Ks),is=n(t),m(at.$$.fragment,t),os=n(t),m(nt.$$.fragment,t),Ms=n(t),pt=i(t,"P",{"data-svelte-h":!0}),o(pt)!=="svelte-pao9hp"&&(pt.innerHTML=Ds),ms=n(t),m(it.$$.fragment,t),rs=n(t),m(ot.$$.fragment,t),cs=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-15btsci"&&(Mt.innerHTML=Ps),us=n(t),m(mt.$$.fragment,t),ds=n(t),m(rt.$$.fragment,t),gs=n(t),ct=i(t,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-d2e6yq"&&(ct.textContent=Os),ys=n(t),m(ut.$$.fragment,t),hs=n(t),dt=i(t,"OL",{"data-svelte-h":!0}),o(dt)!=="svelte-1vt6h05"&&(dt.innerHTML=tl),Ts=n(t),m(gt.$$.fragment,t),js=n(t),yt=i(t,"OL",{"data-svelte-h":!0}),o(yt)!=="svelte-e1h2fe"&&(yt.innerHTML=sl),Js=n(t),m(ht.$$.fragment,t),bs=n(t),Tt=i(t,"OL",{"data-svelte-h":!0}),o(Tt)!=="svelte-1aq8t2a"&&(Tt.innerHTML=ll),Us=n(t),m(jt.$$.fragment,t),fs=n(t),Jt=i(t,"OL",{"data-svelte-h":!0}),o(Jt)!=="svelte-1ubnemc"&&(Jt.innerHTML=el),ws=n(t),Ut=i(t,"P",{}),nl(Ut).forEach(l),this.h()},h(){ks(g,"name","hf:doc:metadata"),ks(g,"content",hl),ks(j,"class","image table text-center m-0 w-full"),ks(J,"class","image table text-center m-0 w-full")},m(t,s){cl(document.head,g),e(t,U,s),e(t,h,s),e(t,bt,s),r(f,t,s),e(t,wt,s),r(w,t,s),e(t,Zt,s),e(t,Z,s),e(t,kt,s),e(t,k,s),e(t,It,s),e(t,I,s),e(t,Gt,s),e(t,G,s),e(t,_t,s),e(t,_,s),e(t,Bt,s),r(B,t,s),e(t,$t,s),r($,t,s),e(t,Xt,s),e(t,X,s),e(t,Vt,s),e(t,j,s),e(t,Wt,s),e(t,V,s),e(t,Rt,s),e(t,J,s),e(t,vt,s),e(t,W,s),e(t,Ct,s),e(t,R,s),e(t,zt,s),e(t,v,s),e(t,Ht,s),r(b,t,s),e(t,Lt,s),e(t,C,s),e(t,xt,s),r(z,t,s),e(t,Ft,s),e(t,H,s),e(t,qt,s),e(t,L,s),e(t,Qt,s),e(t,x,s),e(t,Nt,s),e(t,F,s),e(t,Et,s),r(q,t,s),e(t,St,s),e(t,Q,s),e(t,Yt,s),e(t,N,s),e(t,At,s),r(E,t,s),e(t,Kt,s),e(t,S,s),e(t,Dt,s),r(Y,t,s),e(t,Pt,s),e(t,A,s),e(t,Ot,s),r(K,t,s),e(t,ts,s),e(t,D,s),e(t,ss,s),r(P,t,s),e(t,ls,s),r(O,t,s),e(t,es,s),e(t,tt,s),e(t,as,s),r(st,t,s),e(t,ns,s),r(lt,t,s),e(t,ps,s),e(t,et,s),e(t,is,s),r(at,t,s),e(t,os,s),r(nt,t,s),e(t,Ms,s),e(t,pt,s),e(t,ms,s),r(it,t,s),e(t,rs,s),r(ot,t,s),e(t,cs,s),e(t,Mt,s),e(t,us,s),r(mt,t,s),e(t,ds,s),r(rt,t,s),e(t,gs,s),e(t,ct,s),e(t,ys,s),r(ut,t,s),e(t,hs,s),e(t,dt,s),e(t,Ts,s),r(gt,t,s),e(t,js,s),e(t,yt,s),e(t,Js,s),r(ht,t,s),e(t,bs,s),e(t,Tt,s),e(t,Us,s),r(jt,t,s),e(t,fs,s),e(t,Jt,s),e(t,ws,s),e(t,Ut,s),Zs=!0},p(t,[s]){const al={};s&2&&(al.$$scope={dirty:s,ctx:t}),b.$set(al)},i(t){Zs||(c(f.$$.fragment,t),c(w.$$.fragment,t),c(B.$$.fragment,t),c($.$$.fragment,t),c(b.$$.fragment,t),c(z.$$.fragment,t),c(q.$$.fragment,t),c(E.$$.fragment,t),c(Y.$$.fragment,t),c(K.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(st.$$.fragment,t),c(lt.$$.fragment,t),c(at.$$.fragment,t),c(nt.$$.fragment,t),c(it.$$.fragment,t),c(ot.$$.fragment,t),c(mt.$$.fragment,t),c(rt.$$.fragment,t),c(ut.$$.fragment,t),c(gt.$$.fragment,t),c(ht.$$.fragment,t),c(jt.$$.fragment,t),Zs=!0)},o(t){u(f.$$.fragment,t),u(w.$$.fragment,t),u(B.$$.fragment,t),u($.$$.fragment,t),u(b.$$.fragment,t),u(z.$$.fragment,t),u(q.$$.fragment,t),u(E.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(st.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(nt.$$.fragment,t),u(it.$$.fragment,t),u(ot.$$.fragment,t),u(mt.$$.fragment,t),u(rt.$$.fragment,t),u(ut.$$.fragment,t),u(gt.$$.fragment,t),u(ht.$$.fragment,t),u(jt.$$.fragment,t),Zs=!1},d(t){t&&(l(U),l(h),l(bt),l(wt),l(Zt),l(Z),l(kt),l(k),l(It),l(I),l(Gt),l(G),l(_t),l(_),l(Bt),l($t),l(Xt),l(X),l(Vt),l(j),l(Wt),l(V),l(Rt),l(J),l(vt),l(W),l(Ct),l(R),l(zt),l(v),l(Ht),l(Lt),l(C),l(xt),l(Ft),l(H),l(qt),l(L),l(Qt),l(x),l(Nt),l(F),l(Et),l(St),l(Q),l(Yt),l(N),l(At),l(Kt),l(S),l(Dt),l(Pt),l(A),l(Ot),l(ts),l(D),l(ss),l(ls),l(es),l(tt),l(as),l(ns),l(ps),l(et),l(is),l(os),l(Ms),l(pt),l(ms),l(rs),l(cs),l(Mt),l(us),l(ds),l(gs),l(ct),l(ys),l(hs),l(dt),l(Ts),l(js),l(yt),l(Js),l(bs),l(Tt),l(Us),l(fs),l(Jt),l(ws),l(Ut)),l(g),d(f,t),d(w,t),d(B,t),d($,t),d(b,t),d(z,t),d(q,t),d(E,t),d(Y,t),d(K,t),d(P,t),d(O,t),d(st,t),d(lt,t),d(at,t),d(nt,t),d(it,t),d(ot,t),d(mt,t),d(rt,t),d(ut,t),d(gt,t),d(ht,t),d(jt,t)}}}const hl='{"title":"使用LLMs进行生成","local":"使用llms进行生成","sections":[],"depth":2}';function Tl(ft){return il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends Ml{constructor(g){super(),ml(this,g,Tl,yl,pl,{})}}export{Zl as component};
