import{s as Wr,o as Hr,n as C}from"../chunks/scheduler.bdbef820.js";import{S as Pr,i as Ar,g as c,s as o,r as f,A as qr,h as p,f as d,c as r,j as M,u as h,x as v,k,y as s,a as u,v as _,d as b,t as $,w as x}from"../chunks/index.c0aea24a.js";import{D as T}from"../chunks/Docstring.34291e8a.js";import{C as U}from"../chunks/CodeBlock.6ccca92e.js";import{E as J}from"../chunks/ExampleCodeBlock.241e4203.js";import{H as un,E as Or}from"../chunks/EditOnGithub.725ee0c1.js";function Kr(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSgpJTBBZHMlMjAlM0QlMjBidWlsZGVyLmFzX2RhdGFzZXQoc3BsaXQlM0QndHJhaW4nKSUwQWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = builder.as_dataset(split=<span class="hljs-string">&#x27;train&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">8530</span>
})`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function el(y){let a,w="Download and prepare the dataset as Arrow files that can be loaded as a Dataset using <code>builder.as_dataset()</code>:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare()`,wrap:!1}}),{c(){a=c("p"),a.innerHTML=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-i6fpq7"&&(a.innerHTML=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function tl(y){let a,w="Download and prepare the dataset as sharded Parquet files locally:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFidWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQWJ1aWxkZXIuZG93bmxvYWRfYW5kX3ByZXBhcmUoJTIyLiUyRm91dHB1dF9kaXIlMjIlMkMlMjBmaWxlX2Zvcm1hdCUzRCUyMnBhcnF1ZXQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;./output_dir&quot;</span>, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1035kd7"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function al(y){let a,w="Download and prepare the dataset as sharded Parquet files in a cloud storage:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFzdG9yYWdlX29wdGlvbnMlMjAlM0QlMjAlN0IlMjJrZXklMjIlM0ElMjBhd3NfYWNjZXNzX2tleV9pZCUyQyUyMCUyMnNlY3JldCUyMiUzQSUyMGF3c19zZWNyZXRfYWNjZXNzX2tleSU3RCUwQWJ1aWxkZXIlMjAlM0QlMjBsb2FkX2RhdGFzZXRfYnVpbGRlciglMjJyb3R0ZW5fdG9tYXRvZXMlMjIpJTBBYnVpbGRlci5kb3dubG9hZF9hbmRfcHJlcGFyZSglMjJzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRm15X3JvdHRlbl90b21hdG9lcyUyMiUyQyUyMHN0b3JhZ2Vfb3B0aW9ucyUzRHN0b3JhZ2Vfb3B0aW9ucyUyQyUyMGZpbGVfZm9ybWF0JTNEJTIycGFycXVldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>storage_options = {<span class="hljs-string">&quot;key&quot;</span>: aws_access_key_id, <span class="hljs-string">&quot;secret&quot;</span>: aws_secret_access_key}
<span class="hljs-meta">&gt;&gt;&gt; </span>builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>builder.download_and_prepare(<span class="hljs-string">&quot;s3://my-bucket/my_rotten_tomatoes&quot;</span>, storage_options=storage_options, file_format=<span class="hljs-string">&quot;parquet&quot;</span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-y7m7rz"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function nl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfYWxsX2V4cG9ydGVkX2RhdGFzZXRfaW5mb3MoKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_all_exported_dataset_infos()
{<span class="hljs-string">&#x27;default&#x27;</span>: DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)}</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function sl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJ3JvdHRlbl90b21hdG9lcycpJTBBZHNfYnVpbGRlci5nZXRfZXhwb3J0ZWRfZGF0YXNldF9pbmZvKCklMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&#x27;rotten_tomatoes&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.get_exported_dataset_info()
DatasetInfo(description=<span class="hljs-string">&quot;Movie Review Dataset.
a dataset of containing 5,331 positive and 5,331 negative processed
s from Rotten Tomatoes movie reviews. This data was first used in Bo
 Lillian Lee, \`\`Seeing stars: Exploiting class relationships for
t categorization with respect to rating scales.&#x27;&#x27;, Proceedings of the
5.
ion=&#x27;@InProceedings{Pang+Lee:05a,
 =       {Bo Pang and Lillian Lee},
=        {Seeing stars: Exploiting class relationships for sentiment
          categorization with respect to rating scales},
tle =    {Proceedings of the ACL},
         2005

age=&#x27;http://www.cs.cornell.edu/people/pabo/movie-review-data/&#x27;, license=&#x27;&#x27;, features={&#x27;text&#x27;: Value(dtype=&#x27;string&#x27;, id=None), &#x27;label&#x27;: ClassLabel(num_classes=2, names=[&#x27;neg&#x27;, &#x27;pos&#x27;], id=None)}, post_processed=None, supervised_keys=SupervisedKeysData(input=&#x27;&#x27;, output=&#x27;&#x27;), task_templates=[TextClassification(task=&#x27;text-classification&#x27;, text_column=&#x27;text&#x27;, label_column=&#x27;label&#x27;)], builder_name=&#x27;rotten_tomatoes_movie_review&#x27;, config_name=&#x27;default&#x27;, version=1.0.0, splits={&#x27;train&#x27;: SplitInfo(name=&#x27;train&#x27;, num_bytes=1074810, num_examples=8530, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;validation&#x27;: SplitInfo(name=&#x27;validation&#x27;, num_bytes=134679, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;), &#x27;test&#x27;: SplitInfo(name=&#x27;test&#x27;, num_bytes=135972, num_examples=1066, dataset_name=&#x27;rotten_tomatoes_movie_review&#x27;)}, download_checksums={&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;: {&#x27;num_bytes&#x27;: 487770, &#x27;checksum&#x27;: &#x27;a05befe52aafda71d458d188a1c54506a998b1308613ba76bbda2e5029409ce9&#x27;}}, download_size=487770, post_processing_size=None, dataset_size=1345461, size_in_bytes=1833231)</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function ol(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function rl(y){let a,w="Is roughly equivalent to:",i,n,l;return n=new U({props:{code:"ZXh0cmFjdGVkX3BhdGhzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRsX21hbmFnZXIuZG93bmxvYWQodXJsX29yX3VybHMpKQ==",highlighted:'<span class="hljs-attr">extracted_paths</span> = dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-yva38v"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function ll(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWRfY3VzdG9tKCdzMyUzQSUyRiUyRm15LWJ1Y2tldCUyRmRhdGEuemlwJyUyQyUyMGN1c3RvbV9kb3dubG9hZF9mb3JfbXlfcHJpdmF0ZV9idWNrZXQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download_custom(<span class="hljs-string">&#x27;s3://my-bucket/data.zip&#x27;</span>, custom_download_for_my_private_bucket)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function dl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function il(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function cl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function pl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function ml(y){let a,w="Is equivalent to:",i,n,l;return n=new U({props:{code:"dXJscyUyMCUzRCUyMGRsX21hbmFnZXIuZXh0cmFjdChkbF9tYW5hZ2VyLmRvd25sb2FkKHVybF9vcl91cmxzKSk=",highlighted:'<span class="hljs-attribute">urls</span> <span class="hljs-operator">=</span> dl_manager.extract(dl_manager.download(url_or_urls))',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-b0lbw9"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function gl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZG93bmxvYWRlZF9maWxlcyUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZXh0cmFjdGVkX2ZpbGVzJTIwJTNEJTIwZGxfbWFuYWdlci5leHRyYWN0KGRvd25sb2FkZWRfZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>downloaded_files = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>extracted_files = dl_manager.extract(downloaded_files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function ul(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"YXJjaGl2ZSUyMCUzRCUyMGRsX21hbmFnZXIuZG93bmxvYWQoJ2h0dHBzJTNBJTJGJTJGc3RvcmFnZS5nb29nbGVhcGlzLmNvbSUyRnNlbGRvbi1kYXRhc2V0cyUyRnNlbnRlbmNlX3BvbGFyaXR5X3YxJTJGcnQtcG9sYXJpdHlkYXRhLnRhci5neicpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfYXJjaGl2ZShhcmNoaXZlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>archive = dl_manager.download(<span class="hljs-string">&#x27;https://storage.googleapis.com/seldon-datasets/sentence_polarity_v1/rt-polaritydata.tar.gz&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_archive(archive)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function fl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZiZWFucyUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRnRyYWluLnppcCcpJTBBZmlsZXMlMjAlM0QlMjBkbF9tYW5hZ2VyLml0ZXJfZmlsZXMoZmlsZXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.download_and_extract(<span class="hljs-string">&#x27;https://huggingface.co/datasets/beans/resolve/main/data/train.zip&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>files = dl_manager.iter_files(files)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function hl(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZF9leHRyYWN0KHVybCklN0QlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and_extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function _l(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"ZGF0YXNldHMuU3BsaXRHZW5lcmF0b3IoJTBBJTIwJTIwJTIwJTIwbmFtZSUzRGRhdGFzZXRzLlNwbGl0LlRSQUlOJTJDJTBBJTIwJTIwJTIwJTIwZ2VuX2t3YXJncyUzRCU3QiUyMnNwbGl0X2tleSUyMiUzQSUyMCUyMnRyYWluJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVkFMSURBVElPTiUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ2YWxpZGF0aW9uJTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSklMkMlMEFkYXRhc2V0cy5TcGxpdEdlbmVyYXRvciglMEElMjAlMjAlMjAlMjBuYW1lJTNEZGF0YXNldHMuU3BsaXQuVEVTVCUyQyUwQSUyMCUyMCUyMCUyMGdlbl9rd2FyZ3MlM0QlN0IlMjJzcGxpdF9rZXklMjIlM0ElMjAlMjJ0ZXN0JTIyJTJDJTIwJTIyZmlsZXMlMjIlM0ElMjBkbF9tYW5hZ2VyLmRvd25sb2FkX2FuZCUyMGV4dHJhY3QodXJsKSU3RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TRAIN,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.VALIDATION,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;validation&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>),
<span class="hljs-meta">... </span>datasets.SplitGenerator(
<span class="hljs-meta">... </span>    name=datasets.Split.TEST,
<span class="hljs-meta">... </span>    gen_kwargs={<span class="hljs-string">&quot;split_key&quot;</span>: <span class="hljs-string">&quot;test&quot;</span>, <span class="hljs-string">&quot;files&quot;</span>: dl_manager.download_and extract(url)},
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function bl(y){let a,w="Each descriptor can be composed with other using addition or slice:",i,n,l;return n=new U({props:{code:"c3BsaXQlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCMCUzQTI1JTVEKSUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1Q=",highlighted:'split = datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">0</span>:<span class="hljs-number">25</span>]) + datasets.Split.TEST',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-in376m"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function $l(y){let a,w="A split cannot be added twice, so the following will fail:",i,n,l;return n=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRSQUlOLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUI3NSUzQSU1RCklMEEpJTIwJTIwJTIzJTIwRXJyb3IlMEFzcGxpdCUyMCUzRCUyMGRhdGFzZXRzLlNwbGl0LlRFU1QlMjAlMkIlMjBkYXRhc2V0cy5TcGxpdC5BTEwlMjAlMjAlMjMlMjBFcnJvcg==",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TRAIN.subsplit(datasets.percent[<span class="hljs-number">75</span>:])
)  <span class="hljs-comment"># Error</span>
split = datasets.Split.TEST + datasets.Split.ALL  <span class="hljs-comment"># Error</span>`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1dn84z5"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function xl(y){let a,w="The slices can be applied only one time. So the following are valid:",i,n,l;return n=new U({props:{code:"c3BsaXQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGF0YXNldHMuU3BsaXQuVFJBSU4uc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTI1JTVEKSUyMCUyQiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXRzLlNwbGl0LlRFU1Quc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKSUwQSklMEFzcGxpdCUyMCUzRCUyMChkYXRhc2V0cy5TcGxpdC5UUkFJTiUyMCUyQiUyMGRhdGFzZXRzLlNwbGl0LlRFU1QpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0E1MCU1RCk=",highlighted:`split = (
        datasets.Split.TRAIN.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) +
        datasets.Split.TEST.subsplit(datasets.percent[:<span class="hljs-number">50</span>])
)
split = (datasets.Split.TRAIN + datasets.Split.TEST).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-f377rx"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function vl(y){let a,w="But this is not valid:",i,n,l;return n=new U({props:{code:"dHJhaW4lMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5UUkFJTiUwQXRlc3QlMjAlM0QlMjBkYXRhc2V0cy5TcGxpdC5URVNUJTBBc3BsaXQlMjAlM0QlMjB0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpLnN1YnNwbGl0KGRhdGFzZXRzLnBlcmNlbnQlNUIlM0EyNSU1RCklMEFzcGxpdCUyMCUzRCUyMCh0cmFpbi5zdWJzcGxpdChkYXRhc2V0cy5wZXJjZW50JTVCJTNBMjUlNUQpJTIwJTJCJTIwdGVzdCkuc3Vic3BsaXQoZGF0YXNldHMucGVyY2VudCU1QiUzQTUwJTVEKQ==",highlighted:`train = datasets.Split.TRAIN
test = datasets.Split.TEST
split = train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]).subsplit(datasets.percent[:<span class="hljs-number">25</span>])
split = (train.subsplit(datasets.percent[:<span class="hljs-number">25</span>]) + test).subsplit(datasets.percent[:<span class="hljs-number">50</span>])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-1jf0xuu"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function wl(y){let a,w="Examples:",i,n,l;return n=new U({props:{code:"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",highlighted:`<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(<span class="hljs-string">&#x27;test[:33%]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%]+train[1:-1]&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=(
datasets.ReadInstruction(<span class="hljs-string">&#x27;test&#x27;</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>) +
datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=<span class="hljs-number">1</span>, to=-<span class="hljs-number">1</span>, unit=<span class="hljs-string">&#x27;abs&#x27;</span>)))

<span class="hljs-comment"># The following lines are equivalent:</span>
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>)
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction.from_spec(
<span class="hljs-string">&#x27;test[:33%](pct1_dropremainder)&#x27;</span>))
ds = datasets.load_dataset(<span class="hljs-string">&#x27;mnist&#x27;</span>, split=datasets.ReadInstruction(
<span class="hljs-string">&#x27;test&#x27;</span>, from_=<span class="hljs-number">0</span>, to=<span class="hljs-number">33</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>, rounding=<span class="hljs-string">&quot;pct1_dropremainder&quot;</span>))

<span class="hljs-comment"># 10-fold validation:</span>
tests = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k, to=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])
trains = datasets.load_dataset(
<span class="hljs-string">&#x27;mnist&#x27;</span>,
[datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, to=k, unit=<span class="hljs-string">&#x27;%&#x27;</span>) + datasets.ReadInstruction(<span class="hljs-string">&#x27;train&#x27;</span>, from_=k+<span class="hljs-number">10</span>, unit=<span class="hljs-string">&#x27;%&#x27;</span>)
<span class="hljs-keyword">for</span> k <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-number">100</span>, <span class="hljs-number">10</span>)])`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function yl(y){let a,w="Examples:",i,n,l;return n=new U({props:{code:"dGVzdCUzQSUyMHRlc3QlMjBzcGxpdC4lMEF0ZXN0JTIwJTJCJTIwdmFsaWRhdGlvbiUzQSUyMHRlc3QlMjBzcGxpdCUyMCUyQiUyMHZhbGlkYXRpb24lMjBzcGxpdC4lMEF0ZXN0JTVCMTAlM0ElNUQlM0ElMjB0ZXN0JTIwc3BsaXQlMkMlMjBtaW51cyUyMGl0cyUyMGZpcnN0JTIwMTAlMjByZWNvcmRzLiUwQXRlc3QlNUIlM0ExMCUyNSU1RCUzQSUyMGZpcnN0JTIwMTAlMjUlMjByZWNvcmRzJTIwb2YlMjB0ZXN0JTIwc3BsaXQuJTBBdGVzdCU1QiUzQTIwJTI1JTVEKHBjdDFfZHJvcHJlbWFpbmRlciklM0ElMjBmaXJzdCUyMDEwJTI1JTIwcmVjb3JkcyUyQyUyMHJvdW5kZWQlMjB3aXRoJTIwdGhlJTIwcGN0MV9kcm9wcmVtYWluZGVyJTIwcm91bmRpbmcuJTBBdGVzdCU1QiUzQS01JTI1JTVEJTJCdHJhaW4lNUI0MCUyNSUzQTYwJTI1JTVEJTNBJTIwZmlyc3QlMjA5NSUyNSUyMG9mJTIwdGVzdCUyMCUyQiUyMG1pZGRsZSUyMDIwJTI1JTIwb2YlMjB0cmFpbi4=",highlighted:`<span class="hljs-keyword">test: test</span> split.
<span class="hljs-keyword">test </span>+ validation: test split + validation split.
test[10:]: test split, minus its first 10 records.
test[:10%]: first 10% records of test split.
test[:20%](pct1_dropremainder): first 10% records, rounded with the pct1_dropremainder rounding.
test[:<span class="hljs-string">-5</span>%]+train[40%:60%]: first 95% of test + middle 20% of train.`,wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-kvfsh7"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function Ml(y){let a,w="Example:",i,n,l;return n=new U({props:{code:"VkVSU0lPTiUyMCUzRCUyMGRhdGFzZXRzLlZlcnNpb24oJTIyMS4wLjAlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>VERSION = datasets.Version(<span class="hljs-string">&quot;1.0.0&quot;</span>)',wrap:!1}}),{c(){a=c("p"),a.textContent=w,i=o(),f(n.$$.fragment)},l(e){a=p(e,"P",{"data-svelte-h":!0}),v(a)!=="svelte-11lpom8"&&(a.textContent=w),i=r(e),h(n.$$.fragment,e)},m(e,m){u(e,a,m),u(e,i,m),_(n,e,m),l=!0},p:C,i(e){l||(b(n.$$.fragment,e),l=!0)},o(e){$(n.$$.fragment,e),l=!1},d(e){e&&(d(a),d(i)),x(n,e)}}}function kl(y){let a,w,i,n,l,e,m,hn,pt,zo='🤗 Datasets relies on two main classes during the dataset building process: <a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.DatasetBuilder">DatasetBuilder</a> and <a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a>.',_n,R,mt,Vn,sa,Vo="Abstract base class for all datasets.",Sn,oa,So="<code>DatasetBuilder</code> has 3 key methods:",En,ra,Eo=`<li><code>DatasetBuilder.info</code>: Documents the dataset, including feature
names, types, shapes, version, splits, citation, etc.</li> <li><a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.DatasetBuilder.download_and_prepare">DatasetBuilder.download_and_prepare()</a>: Downloads the source data
and writes it to disk.</li> <li><a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.DatasetBuilder.as_dataset">DatasetBuilder.as_dataset()</a>: Generates a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>.</li>`,Ln,la,Lo=`Some <code>DatasetBuilder</code>s expose multiple variants of the
dataset by defining a <a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> subclass and accepting a
config object (or name) on construction. Configurable datasets expose a
pre-defined set of configurations in <code>DatasetBuilder.builder_configs()</code>.`,Qn,se,gt,Yn,da,Qo="Return a Dataset for the specified split.",Wn,Xe,Hn,D,ut,Pn,ia,Yo="Downloads and prepares dataset for reading.",An,ca,Wo="Example:",qn,Ze,On,De,Kn,Fe,es,oe,ft,ts,pa,Ho="Empty dict if doesn’t exist",as,ze,ns,re,ht,ss,ma,Po="Empty <code>DatasetInfo</code> if doesn’t exist",os,Ve,rs,Se,_t,ls,ga,Ao="Return the path of the module of this class or subclass.",bn,q,bt,ds,ua,qo="Base class for datasets with data generation based on dict generators.",is,fa,Oo=`<code>GeneratorBasedBuilder</code> is a convenience class that abstracts away much
of the data writing and reading of <code>DatasetBuilder</code>. It expects subclasses to
implement generators of feature dictionaries across the dataset splits
(<code>_split_generators</code>). See the method docstrings for details.`,$n,xe,$t,cs,ha,Ko="Beam-based Builder.",xn,ve,xt,ps,_a,er="Base class for datasets with data generation based on Arrow loading functions (CSV/JSON/Parquet).",vn,Q,vt,ms,ba,tr="Base class for <code>DatasetBuilder</code> data configuration.",gs,$a,ar=`<code>DatasetBuilder</code> subclasses with data configuration options should subclass
<code>BuilderConfig</code> and add their own properties.`,us,W,wt,fs,xa,nr=`The config id is used to build the cache directory.
By default it is equal to the config name.
However the name of a config is not sufficient to have a unique identifier for the dataset being generated
since it doesn’t take into account:`,hs,va,sr="<li>the config kwargs that can be used to overwrite attributes</li> <li>the custom features used to write the dataset</li> <li>the data_files for json/text/csv/pandas datasets</li>",_s,wa,or="Therefore the config id is just the config name with an optional suffix based on these.",wn,yt,yn,G,Mt,bs,H,kt,$s,ya,rr="Download given URL(s).",xs,Ma,lr="By default, only one process is used for download. Pass customized <code>download_config.num_proc</code> to change this behavior.",vs,Ee,ws,le,Tt,ys,ka,dr="Download and extract given <code>url_or_urls</code>.",Ms,Le,ks,de,Jt,Ts,Ta,ir="Download given urls(s) by calling <code>custom_download</code>.",Js,Qe,Cs,ie,Ct,Us,Ja,cr="Extract given path(s).",Rs,Ye,js,ce,Ut,Gs,Ca,pr="Iterate over files within an archive.",Ns,We,Is,pe,Rt,Bs,Ua,mr="Iterate over file paths.",Xs,He,Zs,Pe,jt,Ds,Ra,gr="Ship the files using Beam FileSystems to the pipeline temp dir.",Mn,I,Gt,Fs,ja,ur=`Download manager that uses the ”::” separator to navigate through (possibly remote) compressed archives.
Contrary to the regular <code>DownloadManager</code>, the <code>download</code> and <code>extract</code> methods don’t actually download nor extract
data, but they rather return the path or url that could be opened using the <code>xopen</code> function which extends the
built-in <code>open</code> function to stream data from remote files.`,zs,me,Nt,Vs,Ga,fr=`Normalize URL(s) of files to stream data from.
This is the lazy version of <code>DownloadManager.download</code> for streaming.`,Ss,Ae,Es,P,It,Ls,Na,hr="Prepare given <code>url_or_urls</code> for streaming (add extraction protocol).",Qs,Ia,_r="This is the lazy version of <code>DownloadManager.download_and_extract</code> for streaming.",Ys,qe,Ws,A,Bt,Hs,Ba,br="Add extraction protocol for given url(s) for streaming.",Ps,Xa,$r="This is the lazy version of <code>DownloadManager.extract</code> for streaming.",As,Oe,qs,ge,Xt,Os,Za,xr="Iterate over files within an archive.",Ks,Ke,eo,ue,Zt,to,Da,vr="Iterate over files.",ao,et,kn,we,Dt,no,Fa,wr="Configuration for our cached path manager.",Tn,z,Ft,so,za,yr="<code>Enum</code> for how to treat pre-existing downloads and data.",oo,Va,Mr=`The default mode is <code>REUSE_DATASET_IF_EXISTS</code>, which will reuse both
raw downloads and the prepared dataset if they exist.`,ro,Sa,kr="The generations modes:",lo,Ea,Tr="<thead><tr><th></th> <th>Downloads</th> <th>Dataset</th></tr></thead> <tbody><tr><td><code>REUSE_DATASET_IF_EXISTS</code> (default)</td> <td>Reuse</td> <td>Reuse</td></tr> <tr><td><code>REUSE_CACHE_IF_EXISTS</code></td> <td>Reuse</td> <td>Fresh</td></tr> <tr><td><code>FORCE_REDOWNLOAD</code></td> <td>Fresh</td> <td>Fresh</td></tr></tbody>",Jn,zt,Cn,V,Vt,io,La,Jr="<code>Enum</code> that specifies which verification checks to run.",co,Qa,Cr=`The default mode is <code>BASIC_CHECKS</code>, which will perform only rudimentary checks to avoid slowdowns
when generating/downloading a dataset for the first time.`,po,Ya,Ur="The verification modes:",mo,Wa,Rr="<thead><tr><th></th> <th>Verification checks</th></tr></thead> <tbody><tr><td><code>ALL_CHECKS</code></td> <td>Split checks, uniqueness of the keys yielded in case of the GeneratorBuilder</td></tr> <tr><td></td> <td>and the validity (number of files, checksums, etc.) of downloaded files</td></tr> <tr><td><code>BASIC_CHECKS</code> (default)</td> <td>Same as <code>ALL_CHECKS</code> but without checking downloaded files</td></tr> <tr><td><code>NO_CHECKS</code></td> <td>None</td></tr></tbody>",Un,St,Rn,Y,Et,go,Ha,jr="Defines the split information for the generator.",uo,Pa,Gr=`This should be used as returned value of
<code>GeneratorBasedBuilder._split_generators</code>.
See <code>GeneratorBasedBuilder._split_generators</code> for more info and example
of usage.`,fo,tt,jn,B,Lt,ho,Aa,Nr="<code>Enum</code> for dataset splits.",_o,qa,Ir=`Datasets are typically split into different subsets to be used at various
stages of training and evaluation.`,bo,Oa,Br=`<li><code>TRAIN</code>: the training data.</li> <li><code>VALIDATION</code>: the validation data. If present, this is typically used as
evaluation data while iterating on a model (e.g. changing hyperparameters,
model architecture, etc.).</li> <li><code>TEST</code>: the testing data. This is the data to report metrics on. Typically
you do not want to use this during model iteration as you may overfit to it.</li> <li><code>ALL</code>: the union of all defined dataset splits.</li>`,$o,Ka,Xr="All splits, including compositions inherit from <code>datasets.SplitBase</code>.",xo,en,Zr='See the <a href="../load_hub#splits">guide</a> on splits for more information.',vo,at,Gn,N,Qt,wo,tn,Dr="Descriptor corresponding to a named split (train, test, …).",yo,an,Fr="Example:",Mo,nt,ko,nn,zr=`The resulting split will correspond to 25% of the train split merged with
100% of the test split.`,To,st,Jo,ot,Co,rt,Nn,ye,Yt,Uo,sn,Vr="Split corresponding to the union of all defined dataset splits.",In,S,Wt,Ro,on,Sr="Reading instruction for a dataset.",jo,lt,Go,fe,Ht,No,rn,Er="Creates a <code>ReadInstruction</code> instance out of a string spec.",Io,dt,Bo,he,Pt,Xo,ln,Lr="Translate instruction into a list of absolute instructions.",Zo,dn,Qr="Those absolute instructions are then to be added together.",Bn,At,Xn,O,qt,Do,cn,Yr="Dataset version <code>MAJOR.MINOR.PATCH</code>.",Fo,it,Zn,Ot,Dn,fn,Fn;return l=new un({props:{title:"Builder classes",local:"builder-classes",headingTag:"h1"}}),m=new un({props:{title:"Builders",local:"datasets.DatasetBuilder",headingTag:"h2"}}),mt=new T({props:{name:"class datasets.DatasetBuilder",anchor:"datasets.DatasetBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Directory to cache data. Defaults to <code>&quot;~/.cache/huggingface/datasets&quot;</code>.`,name:"cache_dir"},{anchor:"datasets.DatasetBuilder.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset, if different from the builder name. Useful for packaged builders
like csv, imagefolder, audiofolder, etc. to reflect the difference between datasets
that use the same packaged builder.`,name:"dataset_name"},{anchor:"datasets.DatasetBuilder.config_name",description:`<strong>config_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the dataset configuration.
It affects the data generated on disk. Different configurations will have their own subdirectories and
versions.
If not provided, the default configuration is used (if it exists).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.3.0</p>
						
<p>Parameter <code>name</code> was renamed to <code>config_name</code>.</p>

					</div>`,name:"config_name"},{anchor:"datasets.DatasetBuilder.hash",description:`<strong>hash</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Hash specific to the dataset code. Used to update the caching directory when the
dataset loading script code is updated (to avoid reusing old data).
The typical caching directory (defined in <code>self._relative_data_dir</code>) is <code>name/version/hash/</code>.`,name:"hash"},{anchor:"datasets.DatasetBuilder.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files.
This can be a remote URL.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.features",description:`<strong>features</strong> (<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Features">Features</a>, <em>optional</em>) &#x2014;
Features types to use with this dataset.
It can be used to change the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Features">Features</a> types of a dataset, for example.`,name:"features"},{anchor:"datasets.DatasetBuilder.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
String or boolean to use as Bearer token for remote files on the
Datasets Hub. If <code>True</code>, will get token from <code>&quot;~/.huggingface&quot;</code>.`,name:"token"},{anchor:"datasets.DatasetBuilder.repo_id",description:`<strong>repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
ID of the dataset repository.
Used to distinguish builders with the same name but not coming from the same namespace, for example &#x201C;squad&#x201D;
and &#x201C;lhoestq/squad&#x201D; repo IDs. In the latter, the builder name would be &#x201C;lhoestq___squad&#x201D;.`,name:"repo_id"},{anchor:"datasets.DatasetBuilder.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).
For builders like &#x201C;csv&#x201D; or &#x201C;json&#x201D; that need the user to specify data files. They can be either
local or remote files. For convenience, you can use a <code>DataFilesDict</code>.`,name:"data_files"},{anchor:"datasets.DatasetBuilder.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to directory containing source data file(s).
Use only if <code>data_files</code> is not passed, in which case it is equivalent to passing
<code>os.path.join(data_dir, &quot;**&quot;)</code> as <code>data_files</code>.
For builders that require manual download, it must be the path to the local directory containing the
manually downloaded data.`,name:"data_dir"},{anchor:"datasets.DatasetBuilder.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.writer_batch_size",description:`<strong>writer_batch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Batch size used by the ArrowWriter.
It defines the number of samples that are kept in memory before writing them
and also the length of the arrow chunks.
None means that the ArrowWriter will use its default value.`,name:"writer_batch_size"},{anchor:"datasets.DatasetBuilder.name",description:`<strong>name</strong> (<code>str</code>) &#x2014; Configuration name for the dataset.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.3.0</p>
						
<p>Use <code>config_name</code> instead.</p>

					</div>`,name:"name"},{anchor:"datasets.DatasetBuilder.*config_kwargs",description:`*<strong>*config_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments to be passed to the corresponding builder
configuration class, set on the class attribute <a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.BuilderConfig">DatasetBuilder.BUILDER_CONFIG_CLASS</a>. The builder
configuration class is <a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.BuilderConfig">BuilderConfig</a> or a subclass of it.`,name:"*config_kwargs"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L216"}}),gt=new T({props:{name:"as_dataset",anchor:"datasets.DatasetBuilder.as_dataset",parameters:[{name:"split",val:": Optional = None"},{name:"run_post_process",val:" = True"},{name:"verification_mode",val:": Union = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"in_memory",val:" = False"}],parametersDescription:[{anchor:"datasets.DatasetBuilder.as_dataset.split",description:`<strong>split</strong> (<code>datasets.Split</code>) &#x2014;
Which subset of the data to return.`,name:"split"},{anchor:"datasets.DatasetBuilder.as_dataset.run_post_process",description:`<strong>run_post_process</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to run post-processing dataset transforms and/or add
indexes.`,name:"run_post_process"},{anchor:"datasets.DatasetBuilder.as_dataset.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.as_dataset.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to ignore the verifications of the
downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.as_dataset.in_memory",description:`<strong>in_memory</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to copy the data in-memory.`,name:"in_memory"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>datasets.Dataset</p>
`}}),Xe=new J({props:{anchor:"datasets.DatasetBuilder.as_dataset.example",$$slots:{default:[Kr]},$$scope:{ctx:y}}}),ut=new T({props:{name:"download_and_prepare",anchor:"datasets.DatasetBuilder.download_and_prepare",parameters:[{name:"output_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"download_mode",val:": Union = None"},{name:"verification_mode",val:": Union = None"},{name:"ignore_verifications",val:" = 'deprecated'"},{name:"try_from_hf_gcs",val:" = 'deprecated'"},{name:"dl_manager",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"file_format",val:": str = 'arrow'"},{name:"max_shard_size",val:": Union = None"},{name:"num_proc",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"**download_and_prepare_kwargs",val:""}],parametersDescription:[{anchor:"datasets.DatasetBuilder.download_and_prepare.output_dir",description:`<strong>output_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Output directory for the dataset.
Default to this builder&#x2019;s <code>cache_dir</code>, which is inside <code>~/.cache/huggingface/datasets</code> by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"output_dir"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_config",description:`<strong>download_config</strong> (<code>DownloadConfig</code>, <em>optional</em>) &#x2014;
Specific download configuration parameters.`,name:"download_config"},{anchor:"datasets.DatasetBuilder.download_and_prepare.download_mode",description:`<strong>download_mode</strong> (<a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.DownloadMode">DownloadMode</a> or <code>str</code>, <em>optional</em>) &#x2014;
Select the download/generate mode, default to <code>REUSE_DATASET_IF_EXISTS</code>.`,name:"download_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.verification_mode",description:`<strong>verification_mode</strong> (<a href="/docs/datasets/main/en/package_reference/builder_classes#datasets.VerificationMode">VerificationMode</a> or <code>str</code>, defaults to <code>BASIC_CHECKS</code>) &#x2014;
Verification mode determining the checks to run on the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.9.1</p>
						
					</div>`,name:"verification_mode"},{anchor:"datasets.DatasetBuilder.download_and_prepare.ignore_verifications",description:`<strong>ignore_verifications</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Ignore the verifications of the downloaded/processed dataset information (checksums/size/splits/&#x2026;).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.9.1</p>
						
<p><code>ignore_verifications</code> was deprecated in version 2.9.1 and will be removed in 3.0.0.
Please use <code>verification_mode</code> instead.</p>

					</div>`,name:"ignore_verifications"},{anchor:"datasets.DatasetBuilder.download_and_prepare.try_from_hf_gcs",description:`<strong>try_from_hf_gcs</strong> (<code>bool</code>) &#x2014;
If <code>True</code>, it will try to download the already prepared dataset from the HF Google cloud storage.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.16.0</p>
						
<p><code>try_from_hf_gcs</code> was deprecated in version 2.16.0 and will be removed in 3.0.0.
Host the processed files on the Hugging Face Hub instead.</p>

					</div>`,name:"try_from_hf_gcs"},{anchor:"datasets.DatasetBuilder.download_and_prepare.dl_manager",description:`<strong>dl_manager</strong> (<code>DownloadManager</code>, <em>optional</em>) &#x2014;
Specific <code>DownloadManger</code> to use.`,name:"dl_manager"},{anchor:"datasets.DatasetBuilder.download_and_prepare.base_path",description:`<strong>base_path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Base path for relative paths that are used to download files. This can be a remote url.
If not specified, the value of the <code>base_path</code> attribute (<code>self.base_path</code>) will be used instead.`,name:"base_path"},{anchor:"datasets.DatasetBuilder.download_and_prepare.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token for remote files on the Datasets Hub.
If True, or not specified, will get token from ~/.huggingface.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.7.1</p>
						
<p>Pass <code>use_auth_token</code> to <code>load_dataset_builder</code> instead.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DatasetBuilder.download_and_prepare.file_format",description:`<strong>file_format</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Format of the data files in which the dataset will be written.
Supported formats: &#x201C;arrow&#x201D;, &#x201C;parquet&#x201D;. Default to &#x201C;arrow&#x201D; format.
If the format is &#x201C;parquet&#x201D;, then image and audio data are embedded into the Parquet files instead of pointing to local files.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"file_format"},{anchor:"datasets.DatasetBuilder.download_and_prepare.max_shard_size",description:`<strong>max_shard_size</strong> (<code>Union[str, int]</code>, <em>optional</em>) &#x2014;
Maximum number of bytes written per shard, default is &#x201C;500MB&#x201D;.
The size is based on uncompressed data size, so in practice your shard files may be smaller than
<code>max_shard_size</code> thanks to Parquet compression for example.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"max_shard_size"},{anchor:"datasets.DatasetBuilder.download_and_prepare.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes when downloading and generating the dataset locally.
Multiprocessing is disabled by default.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.7.0</p>
						
					</div>`,name:"num_proc"},{anchor:"datasets.DatasetBuilder.download_and_prepare.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the caching file-system backend, if any.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						<p class="font-medium">Added in 2.5.0</p>
						
					</div>`,name:"storage_options"},{anchor:"datasets.DatasetBuilder.download_and_prepare.*download_and_prepare_kwargs",description:"*<strong>*download_and_prepare_kwargs</strong> (additional keyword arguments) &#x2014; Keyword arguments.",name:"*download_and_prepare_kwargs"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L753"}}),Ze=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example",$$slots:{default:[el]},$$scope:{ctx:y}}}),De=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-2",$$slots:{default:[tl]},$$scope:{ctx:y}}}),Fe=new J({props:{anchor:"datasets.DatasetBuilder.download_and_prepare.example-3",$$slots:{default:[al]},$$scope:{ctx:y}}}),ft=new T({props:{name:"get_all_exported_dataset_infos",anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos",parameters:[],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L537"}}),ze=new J({props:{anchor:"datasets.DatasetBuilder.get_all_exported_dataset_infos.example",$$slots:{default:[nl]},$$scope:{ctx:y}}}),ht=new T({props:{name:"get_exported_dataset_info",anchor:"datasets.DatasetBuilder.get_exported_dataset_info",parameters:[],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L552"}}),Ve=new J({props:{anchor:"datasets.DatasetBuilder.get_exported_dataset_info.example",$$slots:{default:[sl]},$$scope:{ctx:y}}}),_t=new T({props:{name:"get_imported_module_dir",anchor:"datasets.DatasetBuilder.get_imported_module_dir",parameters:[],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L745"}}),bt=new T({props:{name:"class datasets.GeneratorBasedBuilder",anchor:"datasets.GeneratorBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L1538"}}),$t=new T({props:{name:"class datasets.BeamBasedBuilder",anchor:"datasets.BeamBasedBuilder",parameters:[{name:"*args",val:""},{name:"beam_runner",val:" = None"},{name:"beam_options",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L2052"}}),xt=new T({props:{name:"class datasets.ArrowBasedBuilder",anchor:"datasets.ArrowBasedBuilder",parameters:[{name:"cache_dir",val:": Optional = None"},{name:"dataset_name",val:": Optional = None"},{name:"config_name",val:": Optional = None"},{name:"hash",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"info",val:": Optional = None"},{name:"features",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:" = 'deprecated'"},{name:"repo_id",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"data_dir",val:": Optional = None"},{name:"storage_options",val:": Optional = None"},{name:"writer_batch_size",val:": Optional = None"},{name:"name",val:" = 'deprecated'"},{name:"**config_kwargs",val:""}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L1803"}}),vt=new T({props:{name:"class datasets.BuilderConfig",anchor:"datasets.BuilderConfig",parameters:[{name:"name",val:": str = 'default'"},{name:"version",val:": Union = 0.0.0"},{name:"data_dir",val:": Optional = None"},{name:"data_files",val:": Union = None"},{name:"description",val:": Optional = None"}],parametersDescription:[{anchor:"datasets.BuilderConfig.name",description:`<strong>name</strong> (<code>str</code>, defaults to <code>default</code>) &#x2014;
The name of the configuration.`,name:"name"},{anchor:"datasets.BuilderConfig.version",description:`<strong>version</strong> (<code>Version</code> or <code>str</code>, defaults to <code>0.0.0</code>) &#x2014;
The version of the configuration.`,name:"version"},{anchor:"datasets.BuilderConfig.data_dir",description:`<strong>data_dir</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the directory containing the source data.`,name:"data_dir"},{anchor:"datasets.BuilderConfig.data_files",description:`<strong>data_files</strong> (<code>str</code> or <code>Sequence</code> or <code>Mapping</code>, <em>optional</em>) &#x2014;
Path(s) to source data file(s).`,name:"data_files"},{anchor:"datasets.BuilderConfig.description",description:`<strong>description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A human description of the configuration.`,name:"description"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L102"}}),wt=new T({props:{name:"create_config_id",anchor:"datasets.BuilderConfig.create_config_id",parameters:[{name:"config_kwargs",val:": dict"},{name:"custom_features",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/builder.py#L146"}}),yt=new un({props:{title:"Download",local:"datasets.DownloadManager",headingTag:"h2"}}),Mt=new T({props:{name:"class datasets.DownloadManager",anchor:"datasets.DownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"},{name:"record_checksums",val:" = True"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L86"}}),kt=new T({props:{name:"download",anchor:"datasets.DownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L229",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The downloaded paths matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list</code> or <code>dict</code></p>
`}}),Ee=new J({props:{anchor:"datasets.DownloadManager.download.example",$$slots:{default:[ol]},$$scope:{ctx:y}}}),Tt=new T({props:{name:"download_and_extract",anchor:"datasets.DownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L418",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, extracted paths of given URL(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Le=new J({props:{anchor:"datasets.DownloadManager.download_and_extract.example",$$slots:{default:[rl]},$$scope:{ctx:y}}}),Jt=new T({props:{name:"download_custom",anchor:"datasets.DownloadManager.download_custom",parameters:[{name:"url_or_urls",val:""},{name:"custom_download",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.download_custom.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL or <code>list</code> or <code>dict</code> of URLs to download and extract. Each URL is a <code>str</code>.`,name:"url_or_urls"},{anchor:"datasets.DownloadManager.download_custom.custom_download",description:`<strong>custom_download</strong> (<code>Callable[src_url, dst_path]</code>) &#x2014;
The source URL and destination path. For example
<code>tf.io.gfile.copy</code>, that lets you download from  Google storage.`,name:"custom_download"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L182",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The downloaded paths matching the given input
<code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>downloaded_path(s)</p>
`}}),Qe=new J({props:{anchor:"datasets.DownloadManager.download_custom.example",$$slots:{default:[ll]},$$scope:{ctx:y}}}),Ct=new T({props:{name:"extract",anchor:"datasets.DownloadManager.extract",parameters:[{name:"path_or_paths",val:""},{name:"num_proc",val:" = 'deprecated'"}],parametersDescription:[{anchor:"datasets.DownloadManager.extract.path_or_paths",description:`<strong>path_or_paths</strong> (path or <code>list</code> or <code>dict</code>) &#x2014;
Path of file to extract. Each path is a <code>str</code>.`,name:"path_or_paths"},{anchor:"datasets.DownloadManager.extract.num_proc",description:`<strong>num_proc</strong> (<code>int</code>) &#x2014;
Use multi-processing if <code>num_proc</code> &gt; 1 and the length of
<code>path_or_paths</code> is larger than <code>num_proc</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.6.2</p>
						
<p>Pass <code>DownloadConfig(num_proc=&lt;num_proc&gt;)</code> to the initializer instead.</p>

					</div>`,name:"num_proc"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L372",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code>, The extracted paths matching the given input
path_or_paths.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>extracted_path(s)</p>
`}}),Ye=new J({props:{anchor:"datasets.DownloadManager.extract.example",$$slots:{default:[dl]},$$scope:{ctx:y}}}),Ut=new T({props:{name:"iter_archive",anchor:"datasets.DownloadManager.iter_archive",parameters:[{name:"path_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_archive.path_or_buf",description:`<strong>path_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"path_or_buf"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L328",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),We=new J({props:{anchor:"datasets.DownloadManager.iter_archive.example",$$slots:{default:[il]},$$scope:{ctx:y}}}),Rt=new T({props:{name:"iter_files",anchor:"datasets.DownloadManager.iter_files",parameters:[{name:"paths",val:": Union"}],parametersDescription:[{anchor:"datasets.DownloadManager.iter_files.paths",description:`<strong>paths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"paths"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L353",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`,isYield:!0}}),He=new J({props:{anchor:"datasets.DownloadManager.iter_files.example",$$slots:{default:[cl]},$$scope:{ctx:y}}}),jt=new T({props:{name:"ship_files_with_pipeline",anchor:"datasets.DownloadManager.ship_files_with_pipeline",parameters:[{name:"downloaded_path_or_paths",val:""},{name:"pipeline",val:""}],parametersDescription:[{anchor:"datasets.DownloadManager.ship_files_with_pipeline.downloaded_path_or_paths",description:`<strong>downloaded_path_or_paths</strong> (<code>str</code> or <code>list[str]</code> or <code>dict[str, str]</code>) &#x2014;
Nested structure containing the
downloaded path(s).`,name:"downloaded_path_or_paths"},{anchor:"datasets.DownloadManager.ship_files_with_pipeline.pipeline",description:`<strong>pipeline</strong> (<code>utils.beam_utils.BeamPipeline</code>) &#x2014;
Apache Beam Pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code> or <code>list[str]</code> or <code>dict[str, str]</code></p>
`}}),Gt=new T({props:{name:"class datasets.StreamingDownloadManager",anchor:"datasets.StreamingDownloadManager",parameters:[{name:"dataset_name",val:": Optional = None"},{name:"data_dir",val:": Optional = None"},{name:"download_config",val:": Optional = None"},{name:"base_path",val:": Optional = None"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L46"}}),Nt=new T({props:{name:"download",anchor:"datasets.StreamingDownloadManager.download",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L72",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input url_or_urls.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Ae=new J({props:{anchor:"datasets.StreamingDownloadManager.download.example",$$slots:{default:[pl]},$$scope:{ctx:y}}}),It=new T({props:{name:"download_and_extract",anchor:"datasets.StreamingDownloadManager.download_and_extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.download_and_extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) to stream from data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L148",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),qe=new J({props:{anchor:"datasets.StreamingDownloadManager.download_and_extract.example",$$slots:{default:[ml]},$$scope:{ctx:y}}}),Bt=new T({props:{name:"extract",anchor:"datasets.StreamingDownloadManager.extract",parameters:[{name:"url_or_urls",val:""}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.extract.url_or_urls",description:`<strong>url_or_urls</strong> (<code>str</code> or <code>list</code> or <code>dict</code>) &#x2014;
URL(s) of files to stream data from. Each url is a <code>str</code>.`,name:"url_or_urls"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L99",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(<code>str</code> or <code>list</code> or <code>dict</code>), URL(s) to stream data from matching the given input <code>url_or_urls</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>url(s)</p>
`}}),Oe=new J({props:{anchor:"datasets.StreamingDownloadManager.extract.example",$$slots:{default:[gl]},$$scope:{ctx:y}}}),Xt=new T({props:{name:"iter_archive",anchor:"datasets.StreamingDownloadManager.iter_archive",parameters:[{name:"urlpath_or_buf",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_archive.urlpath_or_buf",description:`<strong>urlpath_or_buf</strong> (<code>str</code> or <code>io.BufferedReader</code>) &#x2014;
Archive path or archive binary file object.`,name:"urlpath_or_buf"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L168",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tuple[str, io.BufferedReader]</code></p>
`,isYield:!0}}),Ke=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_archive.example",$$slots:{default:[ul]},$$scope:{ctx:y}}}),Zt=new T({props:{name:"iter_files",anchor:"datasets.StreamingDownloadManager.iter_files",parameters:[{name:"urlpaths",val:": Union"}],parametersDescription:[{anchor:"datasets.StreamingDownloadManager.iter_files.urlpaths",description:`<strong>urlpaths</strong> (<code>str</code> or <code>list</code> of <code>str</code>) &#x2014;
Root paths.`,name:"urlpaths"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/streaming_download_manager.py#L193",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>str</p>
`,isYield:!0}}),et=new J({props:{anchor:"datasets.StreamingDownloadManager.iter_files.example",$$slots:{default:[fl]},$$scope:{ctx:y}}}),Dt=new T({props:{name:"class datasets.DownloadConfig",anchor:"datasets.DownloadConfig",parameters:[{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"resume_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"proxies",val:": Optional = None"},{name:"user_agent",val:": Optional = None"},{name:"extract_compressed_file",val:": bool = False"},{name:"force_extract",val:": bool = False"},{name:"delete_extracted",val:": bool = False"},{name:"extract_on_the_fly",val:": bool = False"},{name:"use_etag",val:": bool = True"},{name:"num_proc",val:": Optional = None"},{name:"max_retries",val:": int = 1"},{name:"token",val:": Union = None"},{name:"use_auth_token",val:": dataclasses.InitVar[typing.Union[str, bool, NoneType]] = 'deprecated'"},{name:"ignore_url_params",val:": bool = False"},{name:"storage_options",val:": Dict = <factory>"},{name:"download_desc",val:": Optional = None"},{name:"disable_tqdm",val:": bool = False"}],parametersDescription:[{anchor:"datasets.DownloadConfig.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>Path</code>, <em>optional</em>) &#x2014;
Specify a cache directory to save the file to (overwrite the
default cache dir).`,name:"cache_dir"},{anchor:"datasets.DownloadConfig.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, re-dowload the file even if it&#x2019;s already cached in
the cache dir.`,name:"force_download"},{anchor:"datasets.DownloadConfig.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, resume the download if an incompletely received file is
found.`,name:"resume_download"},{anchor:"datasets.DownloadConfig.proxies",description:"<strong>proxies</strong> (<code>dict</code>, <em>optional</em>) &#x2014;",name:"proxies"},{anchor:"datasets.DownloadConfig.user_agent",description:`<strong>user_agent</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Optional string or dict that will be appended to the user-agent on remote
requests.`,name:"user_agent"},{anchor:"datasets.DownloadConfig.extract_compressed_file",description:`<strong>extract_compressed_file</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> and the path point to a zip or tar file,
extract the compressed file in a folder along the archive.`,name:"extract_compressed_file"},{anchor:"datasets.DownloadConfig.force_extract",description:`<strong>force_extract</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code> when <code>extract_compressed_file</code> is <code>True</code> and the archive
was already extracted, re-extract the archive and override the folder where it was extracted.`,name:"force_extract"},{anchor:"datasets.DownloadConfig.delete_extracted",description:`<strong>delete_extracted</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to delete (or keep) the extracted files.`,name:"delete_extracted"},{anchor:"datasets.DownloadConfig.extract_on_the_fly",description:`<strong>extract_on_the_fly</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, extract compressed files while they are being read.`,name:"extract_on_the_fly"},{anchor:"datasets.DownloadConfig.use_etag",description:`<strong>use_etag</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use the ETag HTTP response header to validate the cached files.`,name:"use_etag"},{anchor:"datasets.DownloadConfig.num_proc",description:`<strong>num_proc</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of processes to launch to download the files in parallel.`,name:"num_proc"},{anchor:"datasets.DownloadConfig.max_retries",description:`<strong>max_retries</strong> (<code>int</code>, default to <code>1</code>) &#x2014;
The number of times to retry an HTTP request if it fails.`,name:"max_retries"},{anchor:"datasets.DownloadConfig.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.`,name:"token"},{anchor:"datasets.DownloadConfig.use_auth_token",description:`<strong>use_auth_token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Optional string or boolean to use as Bearer token
for remote files on the Datasets Hub. If <code>True</code>, or not specified, will get token from <code>~/.huggingface</code>.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						<p class="font-medium">Deprecated in 2.14.0</p>
						
<p><code>use_auth_token</code> was deprecated in favor of <code>token</code> in version 2.14.0 and will be removed in 3.0.0.</p>

					</div>`,name:"use_auth_token"},{anchor:"datasets.DownloadConfig.ignore_url_params",description:`<strong>ignore_url_params</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to strip all query parameters and fragments from
the download URL before using it for caching the file.`,name:"ignore_url_params"},{anchor:"datasets.DownloadConfig.storage_options",description:`<strong>storage_options</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Key/value pairs to be passed on to the dataset file-system backend, if any.`,name:"storage_options"},{anchor:"datasets.DownloadConfig.download_desc",description:`<strong>download_desc</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A description to be displayed alongside with the progress bar while downloading the files.`,name:"download_desc"},{anchor:"datasets.DownloadConfig.disable_tqdm",description:`<strong>disable_tqdm</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to disable the individual files download progress bar`,name:"disable_tqdm"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_config.py#L10"}}),Ft=new T({props:{name:"class datasets.DownloadMode",anchor:"datasets.DownloadMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/download/download_manager.py#L55"}}),zt=new un({props:{title:"Verification",local:"datasets.VerificationMode",headingTag:"h2"}}),Vt=new T({props:{name:"class datasets.VerificationMode",anchor:"datasets.VerificationMode",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/utils/info_utils.py#L14"}}),St=new un({props:{title:"Splits",local:"datasets.SplitGenerator",headingTag:"h2"}}),Et=new T({props:{name:"class datasets.SplitGenerator",anchor:"datasets.SplitGenerator",parameters:[{name:"name",val:": str"},{name:"gen_kwargs",val:": Dict = <factory>"}],parametersDescription:[{anchor:"datasets.SplitGenerator.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
Name of the <code>Split</code> for which the generator will
create the examples.`,name:"name"},{anchor:"datasets.SplitGenerator.*gen_kwargs",description:`*<strong>*gen_kwargs</strong> (additional keyword arguments) &#x2014;
Keyword arguments to forward to the <code>DatasetBuilder._generate_examples</code> method
of the builder.`,name:"*gen_kwargs"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/splits.py#L601"}}),tt=new J({props:{anchor:"datasets.SplitGenerator.example",$$slots:{default:[hl]},$$scope:{ctx:y}}}),Lt=new T({props:{name:"class datasets.Split",anchor:"datasets.Split",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/splits.py#L406"}}),at=new J({props:{anchor:"datasets.Split.example",$$slots:{default:[_l]},$$scope:{ctx:y}}}),Qt=new T({props:{name:"class datasets.NamedSplit",anchor:"datasets.NamedSplit",parameters:[{name:"name",val:""}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/splits.py#L314"}}),nt=new J({props:{anchor:"datasets.NamedSplit.example",$$slots:{default:[bl]},$$scope:{ctx:y}}}),st=new J({props:{anchor:"datasets.NamedSplit.example-2",$$slots:{default:[$l]},$$scope:{ctx:y}}}),ot=new J({props:{anchor:"datasets.NamedSplit.example-3",$$slots:{default:[xl]},$$scope:{ctx:y}}}),rt=new J({props:{anchor:"datasets.NamedSplit.example-4",$$slots:{default:[vl]},$$scope:{ctx:y}}}),Yt=new T({props:{name:"class datasets.NamedSplitAll",anchor:"datasets.NamedSplitAll",parameters:[],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/splits.py#L391"}}),Wt=new T({props:{name:"class datasets.ReadInstruction",anchor:"datasets.ReadInstruction",parameters:[{name:"split_name",val:""},{name:"rounding",val:" = None"},{name:"from_",val:" = None"},{name:"to",val:" = None"},{name:"unit",val:" = None"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/arrow_reader.py#L499"}}),lt=new J({props:{anchor:"datasets.ReadInstruction.example",$$slots:{default:[wl]},$$scope:{ctx:y}}}),Ht=new T({props:{name:"from_spec",anchor:"datasets.ReadInstruction.from_spec",parameters:[{name:"spec",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.from_spec.spec",description:`<strong>spec</strong> (<code>str</code>) &#x2014;
Split(s) + optional slice(s) to read + optional rounding
if percents are used as the slicing unit. A slice can be specified,
using absolute numbers (<code>int</code>) or percentages (<code>int</code>).`,name:"spec"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/arrow_reader.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>ReadInstruction instance.</p>
`}}),dt=new J({props:{anchor:"datasets.ReadInstruction.from_spec.example",$$slots:{default:[yl]},$$scope:{ctx:y}}}),Pt=new T({props:{name:"to_absolute",anchor:"datasets.ReadInstruction.to_absolute",parameters:[{name:"name2len",val:""}],parametersDescription:[{anchor:"datasets.ReadInstruction.to_absolute.name2len",description:`<strong>name2len</strong> (<code>dict</code>) &#x2014;
Associating split names to number of examples.`,name:"name2len"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/arrow_reader.py#L651",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of _AbsoluteInstruction instances (corresponds to the + in spec).</p>
`}}),At=new un({props:{title:"Version",local:"datasets.Version",headingTag:"h2"}}),qt=new T({props:{name:"class datasets.Version",anchor:"datasets.Version",parameters:[{name:"version_str",val:": str"},{name:"description",val:": Optional = None"},{name:"major",val:": Union = None"},{name:"minor",val:": Union = None"},{name:"patch",val:": Union = None"}],parametersDescription:[{anchor:"datasets.Version.version_str",description:`<strong>version_str</strong> (<code>str</code>) &#x2014;
The dataset version.`,name:"version_str"},{anchor:"datasets.Version.description",description:`<strong>description</strong> (<code>str</code>) &#x2014;
A description of what is new in this version.`,name:"description"},{anchor:"datasets.Version.major",description:"<strong>major</strong> (<code>str</code>) &#x2014;",name:"major"},{anchor:"datasets.Version.minor",description:"<strong>minor</strong> (<code>str</code>) &#x2014;",name:"minor"},{anchor:"datasets.Version.patch",description:"<strong>patch</strong> (<code>str</code>) &#x2014;",name:"patch"}],source:"https://github.com/huggingface/datasets/blob/main/src/datasets/utils/version.py#L28"}}),it=new J({props:{anchor:"datasets.Version.example",$$slots:{default:[Ml]},$$scope:{ctx:y}}}),Ot=new Or({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/package_reference/builder_classes.mdx"}}),{c(){a=c("meta"),w=o(),i=c("p"),n=o(),f(l.$$.fragment),e=o(),f(m.$$.fragment),hn=o(),pt=c("p"),pt.innerHTML=zo,_n=o(),R=c("div"),f(mt.$$.fragment),Vn=o(),sa=c("p"),sa.textContent=Vo,Sn=o(),oa=c("p"),oa.innerHTML=So,En=o(),ra=c("ul"),ra.innerHTML=Eo,Ln=o(),la=c("p"),la.innerHTML=Lo,Qn=o(),se=c("div"),f(gt.$$.fragment),Yn=o(),da=c("p"),da.textContent=Qo,Wn=o(),f(Xe.$$.fragment),Hn=o(),D=c("div"),f(ut.$$.fragment),Pn=o(),ia=c("p"),ia.textContent=Yo,An=o(),ca=c("p"),ca.textContent=Wo,qn=o(),f(Ze.$$.fragment),On=o(),f(De.$$.fragment),Kn=o(),f(Fe.$$.fragment),es=o(),oe=c("div"),f(ft.$$.fragment),ts=o(),pa=c("p"),pa.textContent=Ho,as=o(),f(ze.$$.fragment),ns=o(),re=c("div"),f(ht.$$.fragment),ss=o(),ma=c("p"),ma.innerHTML=Po,os=o(),f(Ve.$$.fragment),rs=o(),Se=c("div"),f(_t.$$.fragment),ls=o(),ga=c("p"),ga.textContent=Ao,bn=o(),q=c("div"),f(bt.$$.fragment),ds=o(),ua=c("p"),ua.textContent=qo,is=o(),fa=c("p"),fa.innerHTML=Oo,$n=o(),xe=c("div"),f($t.$$.fragment),cs=o(),ha=c("p"),ha.textContent=Ko,xn=o(),ve=c("div"),f(xt.$$.fragment),ps=o(),_a=c("p"),_a.textContent=er,vn=o(),Q=c("div"),f(vt.$$.fragment),ms=o(),ba=c("p"),ba.innerHTML=tr,gs=o(),$a=c("p"),$a.innerHTML=ar,us=o(),W=c("div"),f(wt.$$.fragment),fs=o(),xa=c("p"),xa.textContent=nr,hs=o(),va=c("ul"),va.innerHTML=sr,_s=o(),wa=c("p"),wa.textContent=or,wn=o(),f(yt.$$.fragment),yn=o(),G=c("div"),f(Mt.$$.fragment),bs=o(),H=c("div"),f(kt.$$.fragment),$s=o(),ya=c("p"),ya.textContent=rr,xs=o(),Ma=c("p"),Ma.innerHTML=lr,vs=o(),f(Ee.$$.fragment),ws=o(),le=c("div"),f(Tt.$$.fragment),ys=o(),ka=c("p"),ka.innerHTML=dr,Ms=o(),f(Le.$$.fragment),ks=o(),de=c("div"),f(Jt.$$.fragment),Ts=o(),Ta=c("p"),Ta.innerHTML=ir,Js=o(),f(Qe.$$.fragment),Cs=o(),ie=c("div"),f(Ct.$$.fragment),Us=o(),Ja=c("p"),Ja.textContent=cr,Rs=o(),f(Ye.$$.fragment),js=o(),ce=c("div"),f(Ut.$$.fragment),Gs=o(),Ca=c("p"),Ca.textContent=pr,Ns=o(),f(We.$$.fragment),Is=o(),pe=c("div"),f(Rt.$$.fragment),Bs=o(),Ua=c("p"),Ua.textContent=mr,Xs=o(),f(He.$$.fragment),Zs=o(),Pe=c("div"),f(jt.$$.fragment),Ds=o(),Ra=c("p"),Ra.textContent=gr,Mn=o(),I=c("div"),f(Gt.$$.fragment),Fs=o(),ja=c("p"),ja.innerHTML=ur,zs=o(),me=c("div"),f(Nt.$$.fragment),Vs=o(),Ga=c("p"),Ga.innerHTML=fr,Ss=o(),f(Ae.$$.fragment),Es=o(),P=c("div"),f(It.$$.fragment),Ls=o(),Na=c("p"),Na.innerHTML=hr,Qs=o(),Ia=c("p"),Ia.innerHTML=_r,Ys=o(),f(qe.$$.fragment),Ws=o(),A=c("div"),f(Bt.$$.fragment),Hs=o(),Ba=c("p"),Ba.textContent=br,Ps=o(),Xa=c("p"),Xa.innerHTML=$r,As=o(),f(Oe.$$.fragment),qs=o(),ge=c("div"),f(Xt.$$.fragment),Os=o(),Za=c("p"),Za.textContent=xr,Ks=o(),f(Ke.$$.fragment),eo=o(),ue=c("div"),f(Zt.$$.fragment),to=o(),Da=c("p"),Da.textContent=vr,ao=o(),f(et.$$.fragment),kn=o(),we=c("div"),f(Dt.$$.fragment),no=o(),Fa=c("p"),Fa.textContent=wr,Tn=o(),z=c("div"),f(Ft.$$.fragment),so=o(),za=c("p"),za.innerHTML=yr,oo=o(),Va=c("p"),Va.innerHTML=Mr,ro=o(),Sa=c("p"),Sa.textContent=kr,lo=o(),Ea=c("table"),Ea.innerHTML=Tr,Jn=o(),f(zt.$$.fragment),Cn=o(),V=c("div"),f(Vt.$$.fragment),io=o(),La=c("p"),La.innerHTML=Jr,co=o(),Qa=c("p"),Qa.innerHTML=Cr,po=o(),Ya=c("p"),Ya.textContent=Ur,mo=o(),Wa=c("table"),Wa.innerHTML=Rr,Un=o(),f(St.$$.fragment),Rn=o(),Y=c("div"),f(Et.$$.fragment),go=o(),Ha=c("p"),Ha.textContent=jr,uo=o(),Pa=c("p"),Pa.innerHTML=Gr,fo=o(),f(tt.$$.fragment),jn=o(),B=c("div"),f(Lt.$$.fragment),ho=o(),Aa=c("p"),Aa.innerHTML=Nr,_o=o(),qa=c("p"),qa.textContent=Ir,bo=o(),Oa=c("ul"),Oa.innerHTML=Br,$o=o(),Ka=c("p"),Ka.innerHTML=Xr,xo=o(),en=c("p"),en.innerHTML=Zr,vo=o(),f(at.$$.fragment),Gn=o(),N=c("div"),f(Qt.$$.fragment),wo=o(),tn=c("p"),tn.textContent=Dr,yo=o(),an=c("p"),an.textContent=Fr,Mo=o(),f(nt.$$.fragment),ko=o(),nn=c("p"),nn.textContent=zr,To=o(),f(st.$$.fragment),Jo=o(),f(ot.$$.fragment),Co=o(),f(rt.$$.fragment),Nn=o(),ye=c("div"),f(Yt.$$.fragment),Uo=o(),sn=c("p"),sn.textContent=Vr,In=o(),S=c("div"),f(Wt.$$.fragment),Ro=o(),on=c("p"),on.textContent=Sr,jo=o(),f(lt.$$.fragment),Go=o(),fe=c("div"),f(Ht.$$.fragment),No=o(),rn=c("p"),rn.innerHTML=Er,Io=o(),f(dt.$$.fragment),Bo=o(),he=c("div"),f(Pt.$$.fragment),Xo=o(),ln=c("p"),ln.textContent=Lr,Zo=o(),dn=c("p"),dn.textContent=Qr,Bn=o(),f(At.$$.fragment),Xn=o(),O=c("div"),f(qt.$$.fragment),Do=o(),cn=c("p"),cn.innerHTML=Yr,Fo=o(),f(it.$$.fragment),Zn=o(),f(Ot.$$.fragment),Dn=o(),fn=c("p"),this.h()},l(t){const g=qr("svelte-u9bgzb",document.head);a=p(g,"META",{name:!0,content:!0}),g.forEach(d),w=r(t),i=p(t,"P",{}),M(i).forEach(d),n=r(t),h(l.$$.fragment,t),e=r(t),h(m.$$.fragment,t),hn=r(t),pt=p(t,"P",{"data-svelte-h":!0}),v(pt)!=="svelte-igswdo"&&(pt.innerHTML=zo),_n=r(t),R=p(t,"DIV",{class:!0});var j=M(R);h(mt.$$.fragment,j),Vn=r(j),sa=p(j,"P",{"data-svelte-h":!0}),v(sa)!=="svelte-krqj9a"&&(sa.textContent=Vo),Sn=r(j),oa=p(j,"P",{"data-svelte-h":!0}),v(oa)!=="svelte-apl31e"&&(oa.innerHTML=So),En=r(j),ra=p(j,"UL",{"data-svelte-h":!0}),v(ra)!=="svelte-ycxawl"&&(ra.innerHTML=Eo),Ln=r(j),la=p(j,"P",{"data-svelte-h":!0}),v(la)!=="svelte-1606omh"&&(la.innerHTML=Lo),Qn=r(j),se=p(j,"DIV",{class:!0});var Me=M(se);h(gt.$$.fragment,Me),Yn=r(Me),da=p(Me,"P",{"data-svelte-h":!0}),v(da)!=="svelte-1q1652n"&&(da.textContent=Qo),Wn=r(Me),h(Xe.$$.fragment,Me),Me.forEach(d),Hn=r(j),D=p(j,"DIV",{class:!0});var E=M(D);h(ut.$$.fragment,E),Pn=r(E),ia=p(E,"P",{"data-svelte-h":!0}),v(ia)!=="svelte-9mag6f"&&(ia.textContent=Yo),An=r(E),ca=p(E,"P",{"data-svelte-h":!0}),v(ca)!=="svelte-11lpom8"&&(ca.textContent=Wo),qn=r(E),h(Ze.$$.fragment,E),On=r(E),h(De.$$.fragment,E),Kn=r(E),h(Fe.$$.fragment,E),E.forEach(d),es=r(j),oe=p(j,"DIV",{class:!0});var ke=M(oe);h(ft.$$.fragment,ke),ts=r(ke),pa=p(ke,"P",{"data-svelte-h":!0}),v(pa)!=="svelte-1o5q38l"&&(pa.textContent=Ho),as=r(ke),h(ze.$$.fragment,ke),ke.forEach(d),ns=r(j),re=p(j,"DIV",{class:!0});var Te=M(re);h(ht.$$.fragment,Te),ss=r(Te),ma=p(Te,"P",{"data-svelte-h":!0}),v(ma)!=="svelte-168h2s0"&&(ma.innerHTML=Po),os=r(Te),h(Ve.$$.fragment,Te),Te.forEach(d),rs=r(j),Se=p(j,"DIV",{class:!0});var Kt=M(Se);h(_t.$$.fragment,Kt),ls=r(Kt),ga=p(Kt,"P",{"data-svelte-h":!0}),v(ga)!=="svelte-1jq5ljq"&&(ga.textContent=Ao),Kt.forEach(d),j.forEach(d),bn=r(t),q=p(t,"DIV",{class:!0});var Je=M(q);h(bt.$$.fragment,Je),ds=r(Je),ua=p(Je,"P",{"data-svelte-h":!0}),v(ua)!=="svelte-5e48ll"&&(ua.textContent=qo),is=r(Je),fa=p(Je,"P",{"data-svelte-h":!0}),v(fa)!=="svelte-1b18j1y"&&(fa.innerHTML=Oo),Je.forEach(d),$n=r(t),xe=p(t,"DIV",{class:!0});var ea=M(xe);h($t.$$.fragment,ea),cs=r(ea),ha=p(ea,"P",{"data-svelte-h":!0}),v(ha)!=="svelte-1wgsupk"&&(ha.textContent=Ko),ea.forEach(d),xn=r(t),ve=p(t,"DIV",{class:!0});var ta=M(ve);h(xt.$$.fragment,ta),ps=r(ta),_a=p(ta,"P",{"data-svelte-h":!0}),v(_a)!=="svelte-17aolem"&&(_a.textContent=er),ta.forEach(d),vn=r(t),Q=p(t,"DIV",{class:!0});var K=M(Q);h(vt.$$.fragment,K),ms=r(K),ba=p(K,"P",{"data-svelte-h":!0}),v(ba)!=="svelte-15gz2dy"&&(ba.innerHTML=tr),gs=r(K),$a=p(K,"P",{"data-svelte-h":!0}),v($a)!=="svelte-1m2o9um"&&($a.innerHTML=ar),us=r(K),W=p(K,"DIV",{class:!0});var ee=M(W);h(wt.$$.fragment,ee),fs=r(ee),xa=p(ee,"P",{"data-svelte-h":!0}),v(xa)!=="svelte-1h03lp6"&&(xa.textContent=nr),hs=r(ee),va=p(ee,"UL",{"data-svelte-h":!0}),v(va)!=="svelte-y69nf2"&&(va.innerHTML=sr),_s=r(ee),wa=p(ee,"P",{"data-svelte-h":!0}),v(wa)!=="svelte-d2y9u1"&&(wa.textContent=or),ee.forEach(d),K.forEach(d),wn=r(t),h(yt.$$.fragment,t),yn=r(t),G=p(t,"DIV",{class:!0});var X=M(G);h(Mt.$$.fragment,X),bs=r(X),H=p(X,"DIV",{class:!0});var te=M(H);h(kt.$$.fragment,te),$s=r(te),ya=p(te,"P",{"data-svelte-h":!0}),v(ya)!=="svelte-19i8z0e"&&(ya.textContent=rr),xs=r(te),Ma=p(te,"P",{"data-svelte-h":!0}),v(Ma)!=="svelte-a30fyv"&&(Ma.innerHTML=lr),vs=r(te),h(Ee.$$.fragment,te),te.forEach(d),ws=r(X),le=p(X,"DIV",{class:!0});var Ce=M(le);h(Tt.$$.fragment,Ce),ys=r(Ce),ka=p(Ce,"P",{"data-svelte-h":!0}),v(ka)!=="svelte-xkawo0"&&(ka.innerHTML=dr),Ms=r(Ce),h(Le.$$.fragment,Ce),Ce.forEach(d),ks=r(X),de=p(X,"DIV",{class:!0});var Ue=M(de);h(Jt.$$.fragment,Ue),Ts=r(Ue),Ta=p(Ue,"P",{"data-svelte-h":!0}),v(Ta)!=="svelte-1tww4ej"&&(Ta.innerHTML=ir),Js=r(Ue),h(Qe.$$.fragment,Ue),Ue.forEach(d),Cs=r(X),ie=p(X,"DIV",{class:!0});var Re=M(ie);h(Ct.$$.fragment,Re),Us=r(Re),Ja=p(Re,"P",{"data-svelte-h":!0}),v(Ja)!=="svelte-1vlembv"&&(Ja.textContent=cr),Rs=r(Re),h(Ye.$$.fragment,Re),Re.forEach(d),js=r(X),ce=p(X,"DIV",{class:!0});var je=M(ce);h(Ut.$$.fragment,je),Gs=r(je),Ca=p(je,"P",{"data-svelte-h":!0}),v(Ca)!=="svelte-1ephcm7"&&(Ca.textContent=pr),Ns=r(je),h(We.$$.fragment,je),je.forEach(d),Is=r(X),pe=p(X,"DIV",{class:!0});var Ge=M(pe);h(Rt.$$.fragment,Ge),Bs=r(Ge),Ua=p(Ge,"P",{"data-svelte-h":!0}),v(Ua)!=="svelte-1sadrg0"&&(Ua.textContent=mr),Xs=r(Ge),h(He.$$.fragment,Ge),Ge.forEach(d),Zs=r(X),Pe=p(X,"DIV",{class:!0});var aa=M(Pe);h(jt.$$.fragment,aa),Ds=r(aa),Ra=p(aa,"P",{"data-svelte-h":!0}),v(Ra)!=="svelte-1ue62pg"&&(Ra.textContent=gr),aa.forEach(d),X.forEach(d),Mn=r(t),I=p(t,"DIV",{class:!0});var Z=M(I);h(Gt.$$.fragment,Z),Fs=r(Z),ja=p(Z,"P",{"data-svelte-h":!0}),v(ja)!=="svelte-2x5qds"&&(ja.innerHTML=ur),zs=r(Z),me=p(Z,"DIV",{class:!0});var Ne=M(me);h(Nt.$$.fragment,Ne),Vs=r(Ne),Ga=p(Ne,"P",{"data-svelte-h":!0}),v(Ga)!=="svelte-z89fig"&&(Ga.innerHTML=fr),Ss=r(Ne),h(Ae.$$.fragment,Ne),Ne.forEach(d),Es=r(Z),P=p(Z,"DIV",{class:!0});var ae=M(P);h(It.$$.fragment,ae),Ls=r(ae),Na=p(ae,"P",{"data-svelte-h":!0}),v(Na)!=="svelte-vb22br"&&(Na.innerHTML=hr),Qs=r(ae),Ia=p(ae,"P",{"data-svelte-h":!0}),v(Ia)!=="svelte-1hkl2pt"&&(Ia.innerHTML=_r),Ys=r(ae),h(qe.$$.fragment,ae),ae.forEach(d),Ws=r(Z),A=p(Z,"DIV",{class:!0});var ne=M(A);h(Bt.$$.fragment,ne),Hs=r(ne),Ba=p(ne,"P",{"data-svelte-h":!0}),v(Ba)!=="svelte-sgtbuc"&&(Ba.textContent=br),Ps=r(ne),Xa=p(ne,"P",{"data-svelte-h":!0}),v(Xa)!=="svelte-5qr3om"&&(Xa.innerHTML=$r),As=r(ne),h(Oe.$$.fragment,ne),ne.forEach(d),qs=r(Z),ge=p(Z,"DIV",{class:!0});var Ie=M(ge);h(Xt.$$.fragment,Ie),Os=r(Ie),Za=p(Ie,"P",{"data-svelte-h":!0}),v(Za)!=="svelte-1ephcm7"&&(Za.textContent=xr),Ks=r(Ie),h(Ke.$$.fragment,Ie),Ie.forEach(d),eo=r(Z),ue=p(Z,"DIV",{class:!0});var Be=M(ue);h(Zt.$$.fragment,Be),to=r(Be),Da=p(Be,"P",{"data-svelte-h":!0}),v(Da)!=="svelte-1kdi5en"&&(Da.textContent=vr),ao=r(Be),h(et.$$.fragment,Be),Be.forEach(d),Z.forEach(d),kn=r(t),we=p(t,"DIV",{class:!0});var na=M(we);h(Dt.$$.fragment,na),no=r(na),Fa=p(na,"P",{"data-svelte-h":!0}),v(Fa)!=="svelte-1equdtb"&&(Fa.textContent=wr),na.forEach(d),Tn=r(t),z=p(t,"DIV",{class:!0});var _e=M(z);h(Ft.$$.fragment,_e),so=r(_e),za=p(_e,"P",{"data-svelte-h":!0}),v(za)!=="svelte-nmj2uv"&&(za.innerHTML=yr),oo=r(_e),Va=p(_e,"P",{"data-svelte-h":!0}),v(Va)!=="svelte-xtdw9q"&&(Va.innerHTML=Mr),ro=r(_e),Sa=p(_e,"P",{"data-svelte-h":!0}),v(Sa)!=="svelte-a4zsdi"&&(Sa.textContent=kr),lo=r(_e),Ea=p(_e,"TABLE",{"data-svelte-h":!0}),v(Ea)!=="svelte-pv0x4r"&&(Ea.innerHTML=Tr),_e.forEach(d),Jn=r(t),h(zt.$$.fragment,t),Cn=r(t),V=p(t,"DIV",{class:!0});var be=M(V);h(Vt.$$.fragment,be),io=r(be),La=p(be,"P",{"data-svelte-h":!0}),v(La)!=="svelte-1eqexd"&&(La.innerHTML=Jr),co=r(be),Qa=p(be,"P",{"data-svelte-h":!0}),v(Qa)!=="svelte-13iynk4"&&(Qa.innerHTML=Cr),po=r(be),Ya=p(be,"P",{"data-svelte-h":!0}),v(Ya)!=="svelte-1luabaw"&&(Ya.textContent=Ur),mo=r(be),Wa=p(be,"TABLE",{"data-svelte-h":!0}),v(Wa)!=="svelte-6p84mg"&&(Wa.innerHTML=Rr),be.forEach(d),Un=r(t),h(St.$$.fragment,t),Rn=r(t),Y=p(t,"DIV",{class:!0});var ct=M(Y);h(Et.$$.fragment,ct),go=r(ct),Ha=p(ct,"P",{"data-svelte-h":!0}),v(Ha)!=="svelte-18qkgha"&&(Ha.textContent=jr),uo=r(ct),Pa=p(ct,"P",{"data-svelte-h":!0}),v(Pa)!=="svelte-fn7w0y"&&(Pa.innerHTML=Gr),fo=r(ct),h(tt.$$.fragment,ct),ct.forEach(d),jn=r(t),B=p(t,"DIV",{class:!0});var L=M(B);h(Lt.$$.fragment,L),ho=r(L),Aa=p(L,"P",{"data-svelte-h":!0}),v(Aa)!=="svelte-ewaslg"&&(Aa.innerHTML=Nr),_o=r(L),qa=p(L,"P",{"data-svelte-h":!0}),v(qa)!=="svelte-l59ai2"&&(qa.textContent=Ir),bo=r(L),Oa=p(L,"UL",{"data-svelte-h":!0}),v(Oa)!=="svelte-sbyekb"&&(Oa.innerHTML=Br),$o=r(L),Ka=p(L,"P",{"data-svelte-h":!0}),v(Ka)!=="svelte-20xdby"&&(Ka.innerHTML=Xr),xo=r(L),en=p(L,"P",{"data-svelte-h":!0}),v(en)!=="svelte-1cn2wk0"&&(en.innerHTML=Zr),vo=r(L),h(at.$$.fragment,L),L.forEach(d),Gn=r(t),N=p(t,"DIV",{class:!0});var F=M(N);h(Qt.$$.fragment,F),wo=r(F),tn=p(F,"P",{"data-svelte-h":!0}),v(tn)!=="svelte-124iux6"&&(tn.textContent=Dr),yo=r(F),an=p(F,"P",{"data-svelte-h":!0}),v(an)!=="svelte-11lpom8"&&(an.textContent=Fr),Mo=r(F),h(nt.$$.fragment,F),ko=r(F),nn=p(F,"P",{"data-svelte-h":!0}),v(nn)!=="svelte-5jjbkq"&&(nn.textContent=zr),To=r(F),h(st.$$.fragment,F),Jo=r(F),h(ot.$$.fragment,F),Co=r(F),h(rt.$$.fragment,F),F.forEach(d),Nn=r(t),ye=p(t,"DIV",{class:!0});var zn=M(ye);h(Yt.$$.fragment,zn),Uo=r(zn),sn=p(zn,"P",{"data-svelte-h":!0}),v(sn)!=="svelte-11ie63y"&&(sn.textContent=Vr),zn.forEach(d),In=r(t),S=p(t,"DIV",{class:!0});var $e=M(S);h(Wt.$$.fragment,$e),Ro=r($e),on=p($e,"P",{"data-svelte-h":!0}),v(on)!=="svelte-3dhs2m"&&(on.textContent=Sr),jo=r($e),h(lt.$$.fragment,$e),Go=r($e),fe=p($e,"DIV",{class:!0});var pn=M(fe);h(Ht.$$.fragment,pn),No=r(pn),rn=p(pn,"P",{"data-svelte-h":!0}),v(rn)!=="svelte-1g1y80g"&&(rn.innerHTML=Er),Io=r(pn),h(dt.$$.fragment,pn),pn.forEach(d),Bo=r($e),he=p($e,"DIV",{class:!0});var mn=M(he);h(Pt.$$.fragment,mn),Xo=r(mn),ln=p(mn,"P",{"data-svelte-h":!0}),v(ln)!=="svelte-14tg07e"&&(ln.textContent=Lr),Zo=r(mn),dn=p(mn,"P",{"data-svelte-h":!0}),v(dn)!=="svelte-l773xk"&&(dn.textContent=Qr),mn.forEach(d),$e.forEach(d),Bn=r(t),h(At.$$.fragment,t),Xn=r(t),O=p(t,"DIV",{class:!0});var gn=M(O);h(qt.$$.fragment,gn),Do=r(gn),cn=p(gn,"P",{"data-svelte-h":!0}),v(cn)!=="svelte-14lq7j5"&&(cn.innerHTML=Yr),Fo=r(gn),h(it.$$.fragment,gn),gn.forEach(d),Zn=r(t),h(Ot.$$.fragment,t),Dn=r(t),fn=p(t,"P",{}),M(fn).forEach(d),this.h()},h(){k(a,"name","hf:doc:metadata"),k(a,"content",Tl),k(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,g){s(document.head,a),u(t,w,g),u(t,i,g),u(t,n,g),_(l,t,g),u(t,e,g),_(m,t,g),u(t,hn,g),u(t,pt,g),u(t,_n,g),u(t,R,g),_(mt,R,null),s(R,Vn),s(R,sa),s(R,Sn),s(R,oa),s(R,En),s(R,ra),s(R,Ln),s(R,la),s(R,Qn),s(R,se),_(gt,se,null),s(se,Yn),s(se,da),s(se,Wn),_(Xe,se,null),s(R,Hn),s(R,D),_(ut,D,null),s(D,Pn),s(D,ia),s(D,An),s(D,ca),s(D,qn),_(Ze,D,null),s(D,On),_(De,D,null),s(D,Kn),_(Fe,D,null),s(R,es),s(R,oe),_(ft,oe,null),s(oe,ts),s(oe,pa),s(oe,as),_(ze,oe,null),s(R,ns),s(R,re),_(ht,re,null),s(re,ss),s(re,ma),s(re,os),_(Ve,re,null),s(R,rs),s(R,Se),_(_t,Se,null),s(Se,ls),s(Se,ga),u(t,bn,g),u(t,q,g),_(bt,q,null),s(q,ds),s(q,ua),s(q,is),s(q,fa),u(t,$n,g),u(t,xe,g),_($t,xe,null),s(xe,cs),s(xe,ha),u(t,xn,g),u(t,ve,g),_(xt,ve,null),s(ve,ps),s(ve,_a),u(t,vn,g),u(t,Q,g),_(vt,Q,null),s(Q,ms),s(Q,ba),s(Q,gs),s(Q,$a),s(Q,us),s(Q,W),_(wt,W,null),s(W,fs),s(W,xa),s(W,hs),s(W,va),s(W,_s),s(W,wa),u(t,wn,g),_(yt,t,g),u(t,yn,g),u(t,G,g),_(Mt,G,null),s(G,bs),s(G,H),_(kt,H,null),s(H,$s),s(H,ya),s(H,xs),s(H,Ma),s(H,vs),_(Ee,H,null),s(G,ws),s(G,le),_(Tt,le,null),s(le,ys),s(le,ka),s(le,Ms),_(Le,le,null),s(G,ks),s(G,de),_(Jt,de,null),s(de,Ts),s(de,Ta),s(de,Js),_(Qe,de,null),s(G,Cs),s(G,ie),_(Ct,ie,null),s(ie,Us),s(ie,Ja),s(ie,Rs),_(Ye,ie,null),s(G,js),s(G,ce),_(Ut,ce,null),s(ce,Gs),s(ce,Ca),s(ce,Ns),_(We,ce,null),s(G,Is),s(G,pe),_(Rt,pe,null),s(pe,Bs),s(pe,Ua),s(pe,Xs),_(He,pe,null),s(G,Zs),s(G,Pe),_(jt,Pe,null),s(Pe,Ds),s(Pe,Ra),u(t,Mn,g),u(t,I,g),_(Gt,I,null),s(I,Fs),s(I,ja),s(I,zs),s(I,me),_(Nt,me,null),s(me,Vs),s(me,Ga),s(me,Ss),_(Ae,me,null),s(I,Es),s(I,P),_(It,P,null),s(P,Ls),s(P,Na),s(P,Qs),s(P,Ia),s(P,Ys),_(qe,P,null),s(I,Ws),s(I,A),_(Bt,A,null),s(A,Hs),s(A,Ba),s(A,Ps),s(A,Xa),s(A,As),_(Oe,A,null),s(I,qs),s(I,ge),_(Xt,ge,null),s(ge,Os),s(ge,Za),s(ge,Ks),_(Ke,ge,null),s(I,eo),s(I,ue),_(Zt,ue,null),s(ue,to),s(ue,Da),s(ue,ao),_(et,ue,null),u(t,kn,g),u(t,we,g),_(Dt,we,null),s(we,no),s(we,Fa),u(t,Tn,g),u(t,z,g),_(Ft,z,null),s(z,so),s(z,za),s(z,oo),s(z,Va),s(z,ro),s(z,Sa),s(z,lo),s(z,Ea),u(t,Jn,g),_(zt,t,g),u(t,Cn,g),u(t,V,g),_(Vt,V,null),s(V,io),s(V,La),s(V,co),s(V,Qa),s(V,po),s(V,Ya),s(V,mo),s(V,Wa),u(t,Un,g),_(St,t,g),u(t,Rn,g),u(t,Y,g),_(Et,Y,null),s(Y,go),s(Y,Ha),s(Y,uo),s(Y,Pa),s(Y,fo),_(tt,Y,null),u(t,jn,g),u(t,B,g),_(Lt,B,null),s(B,ho),s(B,Aa),s(B,_o),s(B,qa),s(B,bo),s(B,Oa),s(B,$o),s(B,Ka),s(B,xo),s(B,en),s(B,vo),_(at,B,null),u(t,Gn,g),u(t,N,g),_(Qt,N,null),s(N,wo),s(N,tn),s(N,yo),s(N,an),s(N,Mo),_(nt,N,null),s(N,ko),s(N,nn),s(N,To),_(st,N,null),s(N,Jo),_(ot,N,null),s(N,Co),_(rt,N,null),u(t,Nn,g),u(t,ye,g),_(Yt,ye,null),s(ye,Uo),s(ye,sn),u(t,In,g),u(t,S,g),_(Wt,S,null),s(S,Ro),s(S,on),s(S,jo),_(lt,S,null),s(S,Go),s(S,fe),_(Ht,fe,null),s(fe,No),s(fe,rn),s(fe,Io),_(dt,fe,null),s(S,Bo),s(S,he),_(Pt,he,null),s(he,Xo),s(he,ln),s(he,Zo),s(he,dn),u(t,Bn,g),_(At,t,g),u(t,Xn,g),u(t,O,g),_(qt,O,null),s(O,Do),s(O,cn),s(O,Fo),_(it,O,null),u(t,Zn,g),_(Ot,t,g),u(t,Dn,g),u(t,fn,g),Fn=!0},p(t,[g]){const j={};g&2&&(j.$$scope={dirty:g,ctx:t}),Xe.$set(j);const Me={};g&2&&(Me.$$scope={dirty:g,ctx:t}),Ze.$set(Me);const E={};g&2&&(E.$$scope={dirty:g,ctx:t}),De.$set(E);const ke={};g&2&&(ke.$$scope={dirty:g,ctx:t}),Fe.$set(ke);const Te={};g&2&&(Te.$$scope={dirty:g,ctx:t}),ze.$set(Te);const Kt={};g&2&&(Kt.$$scope={dirty:g,ctx:t}),Ve.$set(Kt);const Je={};g&2&&(Je.$$scope={dirty:g,ctx:t}),Ee.$set(Je);const ea={};g&2&&(ea.$$scope={dirty:g,ctx:t}),Le.$set(ea);const ta={};g&2&&(ta.$$scope={dirty:g,ctx:t}),Qe.$set(ta);const K={};g&2&&(K.$$scope={dirty:g,ctx:t}),Ye.$set(K);const ee={};g&2&&(ee.$$scope={dirty:g,ctx:t}),We.$set(ee);const X={};g&2&&(X.$$scope={dirty:g,ctx:t}),He.$set(X);const te={};g&2&&(te.$$scope={dirty:g,ctx:t}),Ae.$set(te);const Ce={};g&2&&(Ce.$$scope={dirty:g,ctx:t}),qe.$set(Ce);const Ue={};g&2&&(Ue.$$scope={dirty:g,ctx:t}),Oe.$set(Ue);const Re={};g&2&&(Re.$$scope={dirty:g,ctx:t}),Ke.$set(Re);const je={};g&2&&(je.$$scope={dirty:g,ctx:t}),et.$set(je);const Ge={};g&2&&(Ge.$$scope={dirty:g,ctx:t}),tt.$set(Ge);const aa={};g&2&&(aa.$$scope={dirty:g,ctx:t}),at.$set(aa);const Z={};g&2&&(Z.$$scope={dirty:g,ctx:t}),nt.$set(Z);const Ne={};g&2&&(Ne.$$scope={dirty:g,ctx:t}),st.$set(Ne);const ae={};g&2&&(ae.$$scope={dirty:g,ctx:t}),ot.$set(ae);const ne={};g&2&&(ne.$$scope={dirty:g,ctx:t}),rt.$set(ne);const Ie={};g&2&&(Ie.$$scope={dirty:g,ctx:t}),lt.$set(Ie);const Be={};g&2&&(Be.$$scope={dirty:g,ctx:t}),dt.$set(Be);const na={};g&2&&(na.$$scope={dirty:g,ctx:t}),it.$set(na)},i(t){Fn||(b(l.$$.fragment,t),b(m.$$.fragment,t),b(mt.$$.fragment,t),b(gt.$$.fragment,t),b(Xe.$$.fragment,t),b(ut.$$.fragment,t),b(Ze.$$.fragment,t),b(De.$$.fragment,t),b(Fe.$$.fragment,t),b(ft.$$.fragment,t),b(ze.$$.fragment,t),b(ht.$$.fragment,t),b(Ve.$$.fragment,t),b(_t.$$.fragment,t),b(bt.$$.fragment,t),b($t.$$.fragment,t),b(xt.$$.fragment,t),b(vt.$$.fragment,t),b(wt.$$.fragment,t),b(yt.$$.fragment,t),b(Mt.$$.fragment,t),b(kt.$$.fragment,t),b(Ee.$$.fragment,t),b(Tt.$$.fragment,t),b(Le.$$.fragment,t),b(Jt.$$.fragment,t),b(Qe.$$.fragment,t),b(Ct.$$.fragment,t),b(Ye.$$.fragment,t),b(Ut.$$.fragment,t),b(We.$$.fragment,t),b(Rt.$$.fragment,t),b(He.$$.fragment,t),b(jt.$$.fragment,t),b(Gt.$$.fragment,t),b(Nt.$$.fragment,t),b(Ae.$$.fragment,t),b(It.$$.fragment,t),b(qe.$$.fragment,t),b(Bt.$$.fragment,t),b(Oe.$$.fragment,t),b(Xt.$$.fragment,t),b(Ke.$$.fragment,t),b(Zt.$$.fragment,t),b(et.$$.fragment,t),b(Dt.$$.fragment,t),b(Ft.$$.fragment,t),b(zt.$$.fragment,t),b(Vt.$$.fragment,t),b(St.$$.fragment,t),b(Et.$$.fragment,t),b(tt.$$.fragment,t),b(Lt.$$.fragment,t),b(at.$$.fragment,t),b(Qt.$$.fragment,t),b(nt.$$.fragment,t),b(st.$$.fragment,t),b(ot.$$.fragment,t),b(rt.$$.fragment,t),b(Yt.$$.fragment,t),b(Wt.$$.fragment,t),b(lt.$$.fragment,t),b(Ht.$$.fragment,t),b(dt.$$.fragment,t),b(Pt.$$.fragment,t),b(At.$$.fragment,t),b(qt.$$.fragment,t),b(it.$$.fragment,t),b(Ot.$$.fragment,t),Fn=!0)},o(t){$(l.$$.fragment,t),$(m.$$.fragment,t),$(mt.$$.fragment,t),$(gt.$$.fragment,t),$(Xe.$$.fragment,t),$(ut.$$.fragment,t),$(Ze.$$.fragment,t),$(De.$$.fragment,t),$(Fe.$$.fragment,t),$(ft.$$.fragment,t),$(ze.$$.fragment,t),$(ht.$$.fragment,t),$(Ve.$$.fragment,t),$(_t.$$.fragment,t),$(bt.$$.fragment,t),$($t.$$.fragment,t),$(xt.$$.fragment,t),$(vt.$$.fragment,t),$(wt.$$.fragment,t),$(yt.$$.fragment,t),$(Mt.$$.fragment,t),$(kt.$$.fragment,t),$(Ee.$$.fragment,t),$(Tt.$$.fragment,t),$(Le.$$.fragment,t),$(Jt.$$.fragment,t),$(Qe.$$.fragment,t),$(Ct.$$.fragment,t),$(Ye.$$.fragment,t),$(Ut.$$.fragment,t),$(We.$$.fragment,t),$(Rt.$$.fragment,t),$(He.$$.fragment,t),$(jt.$$.fragment,t),$(Gt.$$.fragment,t),$(Nt.$$.fragment,t),$(Ae.$$.fragment,t),$(It.$$.fragment,t),$(qe.$$.fragment,t),$(Bt.$$.fragment,t),$(Oe.$$.fragment,t),$(Xt.$$.fragment,t),$(Ke.$$.fragment,t),$(Zt.$$.fragment,t),$(et.$$.fragment,t),$(Dt.$$.fragment,t),$(Ft.$$.fragment,t),$(zt.$$.fragment,t),$(Vt.$$.fragment,t),$(St.$$.fragment,t),$(Et.$$.fragment,t),$(tt.$$.fragment,t),$(Lt.$$.fragment,t),$(at.$$.fragment,t),$(Qt.$$.fragment,t),$(nt.$$.fragment,t),$(st.$$.fragment,t),$(ot.$$.fragment,t),$(rt.$$.fragment,t),$(Yt.$$.fragment,t),$(Wt.$$.fragment,t),$(lt.$$.fragment,t),$(Ht.$$.fragment,t),$(dt.$$.fragment,t),$(Pt.$$.fragment,t),$(At.$$.fragment,t),$(qt.$$.fragment,t),$(it.$$.fragment,t),$(Ot.$$.fragment,t),Fn=!1},d(t){t&&(d(w),d(i),d(n),d(e),d(hn),d(pt),d(_n),d(R),d(bn),d(q),d($n),d(xe),d(xn),d(ve),d(vn),d(Q),d(wn),d(yn),d(G),d(Mn),d(I),d(kn),d(we),d(Tn),d(z),d(Jn),d(Cn),d(V),d(Un),d(Rn),d(Y),d(jn),d(B),d(Gn),d(N),d(Nn),d(ye),d(In),d(S),d(Bn),d(Xn),d(O),d(Zn),d(Dn),d(fn)),d(a),x(l,t),x(m,t),x(mt),x(gt),x(Xe),x(ut),x(Ze),x(De),x(Fe),x(ft),x(ze),x(ht),x(Ve),x(_t),x(bt),x($t),x(xt),x(vt),x(wt),x(yt,t),x(Mt),x(kt),x(Ee),x(Tt),x(Le),x(Jt),x(Qe),x(Ct),x(Ye),x(Ut),x(We),x(Rt),x(He),x(jt),x(Gt),x(Nt),x(Ae),x(It),x(qe),x(Bt),x(Oe),x(Xt),x(Ke),x(Zt),x(et),x(Dt),x(Ft),x(zt,t),x(Vt),x(St,t),x(Et),x(tt),x(Lt),x(at),x(Qt),x(nt),x(st),x(ot),x(rt),x(Yt),x(Wt),x(lt),x(Ht),x(dt),x(Pt),x(At,t),x(qt),x(it),x(Ot,t)}}}const Tl='{"title":"Builder classes","local":"builder-classes","sections":[{"title":"Builders","local":"datasets.DatasetBuilder","sections":[],"depth":2},{"title":"Download","local":"datasets.DownloadManager","sections":[],"depth":2},{"title":"Verification","local":"datasets.VerificationMode","sections":[],"depth":2},{"title":"Splits","local":"datasets.SplitGenerator","sections":[],"depth":2},{"title":"Version","local":"datasets.Version","sections":[],"depth":2}],"depth":1}';function Jl(y){return Hr(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Il extends Pr{constructor(a){super(),Ar(this,a,Jl,kl,Wr,{})}}export{Il as component};
