import{s as ut,o as gt,n as Ks}from"../chunks/scheduler.bdbef820.js";import{S as jt,i as Mt,g as r,s as l,r as d,A as bt,h as c,f as e,c as n,j as _e,u as m,x as g,k as $e,y as yt,a as t,v as h,d as o,t as f,w as u}from"../chunks/index.c0aea24a.js";import{T as Os}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{F as wt,M as Tt}from"../chunks/Markdown.1f17db59.js";import{H as x,E as xt}from"../chunks/EditOnGithub.725ee0c1.js";function Jt(w){let p,j=`An <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is useful for iterative jobs like training a model.
You shouldn’t use a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> for jobs that require random access to examples because you have to iterate all over it using a for loop. Getting the last example in an iterable dataset would require you to iterate over all the previous examples.
You can find more details in the <a href="./about_mapstyle_vs_iterable">Dataset vs. IterableDataset guide</a>.`;return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-b07mzo"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Ks,d(i){i&&e(p)}}}function $t(w){let p,j='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will also shuffle the order of the shards if the dataset is sharded into multiple files.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-msn2o0"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Ks,d(i){i&&e(p)}}}function _t(w){let p,j="<code>take</code> and <code>skip</code> prevent future calls to <code>shuffle</code> because they lock in the order of the shards. You should <code>shuffle</code> your dataset before splitting it.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-kg825l"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Ks,d(i){i&&e(p)}}}function kt(w){let p,j="Casting only works if the original feature type and new feature type are compatible. For example, you can cast a column with the feature type <code>Value(&#39;int32&#39;)</code> to <code>Value(&#39;bool&#39;)</code> if the original column only contains ones and zeros.";return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-19jja92"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Ks,d(i){i&&e(p)}}}function Zt(w){let p,j='See other examples of batch processing in the <a href="./process#batch-processing">batched map processing</a> documentation. They work the same for iterable datasets.';return{c(){p=r("p"),p.innerHTML=j},l(i){p=c(i,"P",{"data-svelte-h":!0}),g(p)!=="svelte-csithm"&&(p.innerHTML=j)},m(i,b){t(i,p,b)},p:Ks,d(i){i&&e(p)}}}function Ut(w){let p,j,i,b="Lastly, create a simple training loop and start training:",T,J,$;return p=new y({props:{code:"c2VlZCUyQyUyMGJ1ZmZlcl9zaXplJTIwJTNEJTIwNDIlMkMlMjAxMF8wMDAlMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zaHVmZmxlKHNlZWQlMkMlMjBidWZmZXJfc2l6ZSUzRGJ1ZmZlcl9zaXplKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>seed, buffer_size = <span class="hljs-number">42</span>, <span class="hljs-number">10_000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.shuffle(seed, buffer_size=buffer_size)`,wrap:!1}}),J=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yTWFza2VkTE0lMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZGF0YXNldCUyQyUyMGNvbGxhdGVfZm4lM0REYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nKHRva2VuaXplcikpJTBBZGV2aWNlJTIwJTNEJTIwJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnJTIwJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBbW9kZWwudHJhaW4oKS50byhkZXZpY2UpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcocGFyYW1zJTNEbW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QxZS01KSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgzKSUzQSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGklMkMlMjBiYXRjaCUyMGluJTIwZW51bWVyYXRlKHRxZG0oZGF0YWxvYWRlciUyQyUyMHRvdGFsJTNENSkpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTNEJTNEJTIwNSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cyU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpJTIwJTI1JTIwMTAlMjAlM0QlM0QlMjAwJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMmxvc3MlM0ElMjAlN0Jsb3NzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMaskedLM, DataCollatorForLanguageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(dataset, collate_fn=DataCollatorForLanguageModeling(tokenizer))
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span> 
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;distilbert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.train().to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(params=model.parameters(), lr=<span class="hljs-number">1e-5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
<span class="hljs-meta">... </span>    dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(dataloader, total=<span class="hljs-number">5</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i == <span class="hljs-number">5</span>:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i % <span class="hljs-number">10</span> == <span class="hljs-number">0</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;loss: <span class="hljs-subst">{loss}</span>&quot;</span>)`,wrap:!1}}),{c(){d(p.$$.fragment),j=l(),i=r("p"),i.textContent=b,T=l(),d(J.$$.fragment)},l(M){m(p.$$.fragment,M),j=n(M),i=c(M,"P",{"data-svelte-h":!0}),g(i)!=="svelte-uyzjf"&&(i.textContent=b),T=n(M),m(J.$$.fragment,M)},m(M,_){h(p,M,_),t(M,j,_),t(M,i,_),t(M,T,_),h(J,M,_),$=!0},p:Ks,i(M){$||(o(p.$$.fragment,M),o(J.$$.fragment,M),$=!0)},o(M){f(p.$$.fragment,M),f(J.$$.fragment,M),$=!1},d(M){M&&(e(j),e(i),e(T)),u(p,M),u(J,M)}}}function Gt(w){let p,j;return p=new Tt({props:{$$slots:{default:[Ut]},$$scope:{ctx:w}}}),{c(){d(p.$$.fragment)},l(i){m(p.$$.fragment,i)},m(i,b){h(p,i,b),j=!0},p(i,b){const T={};b&2&&(T.$$scope={dirty:b,ctx:i}),p.$set(T)},i(i){j||(o(p.$$.fragment,i),j=!0)},o(i){f(p.$$.fragment,i),j=!1},d(i){u(p,i)}}}function It(w){let p,j,i,b,T,J,$,M=`Dataset streaming lets you work with a dataset without downloading it.
The data is streamed as you iterate over the dataset.
This is especially helpful when:`,_,v,ke="<li>You don’t want to wait for an extremely large dataset to download.</li> <li>The dataset size exceeds the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",sa,k,Ze='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming.gif"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/streaming-dark.gif"/>',aa,C,Ue='For example, the English split of the <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> dataset is 1.2 terabytes, but you can use it instantly with streaming. Stream a dataset by setting <code>streaming=True</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> as shown below:',ea,F,ta,W,Ge=`Dataset streaming also lets you work with a dataset made of local files without doing any conversion.
In this case, the data is streamed from the local files as you iterate over the dataset.
This is especially helpful when:`,la,V,Ie="<li>You don’t want to wait for an extremely large local dataset to be converted to Arrow.</li> <li>The converted files size would exceed the amount of available disk space on your computer.</li> <li>You want to quickly explore just a few samples of a dataset.</li>",na,Y,Re='For example, you can stream a local dataset of hundreds of compressed JSONL files like <a href="https://huggingface.co/datasets/oscar-corpus/OSCAR-2201" rel="nofollow">oscar-corpus/OSCAR-2201</a> to use it instantly:',pa,z,ia,B,Xe=`Loading a dataset in streaming mode creates a new dataset type instance (instead of the classic <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object), known as an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
This special type of dataset has its own set of processing methods shown below.`,ra,Z,ca,N,da,Q,ve='If you have an existing <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can convert it to an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function. This is actually faster than setting the <code>streaming=True</code> argument in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a> because the data is streamed from local files.',ma,H,ha,D,Ce='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.to_iterable_dataset">to_iterable_dataset()</a> function supports sharding when the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is instantiated. This is useful when working with big datasets, and you’d like to shuffle the dataset or to enable fast parallel loading with a PyTorch DataLoader.',oa,L,fa,S,ua,A,Fe='Like a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, you can also shuffle a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.',ga,E,We='The <code>buffer_size</code> argument controls the size of the buffer to randomly sample examples from. Let’s say your dataset has one million examples, and you set the <code>buffer_size</code> to ten thousand. <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> will randomly select examples from the first ten thousand examples in the buffer. Selected examples in the buffer are replaced with new examples. By default, the buffer size is 1,000.',ja,q,Ma,U,ba,K,ya,P,Ve="Sometimes you may want to reshuffle the dataset after each epoch. This will require you to set a different seed for each epoch. Use <code>IterableDataset.set_epoch()</code> in between epochs to tell the dataset what epoch you’re on.",wa,O,Ye="Your seed effectively becomes: <code>initial seed + current epoch</code>.",Ta,ss,xa,as,Ja,es,ze="You can split your dataset one of two ways:",$a,ts,Be='<li><a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> returns the first <code>n</code> examples in a dataset:</li>',_a,ls,ka,ns,Ne='<li><a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.skip">IterableDataset.skip()</a> omits the first <code>n</code> examples in a dataset and returns the remaining examples:</li>',Za,ps,Ua,G,Ga,qs,Ia,is,Ra,rs,Qe='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.interleave_datasets">interleave_datasets()</a> can combine an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> with other datasets. The combined dataset returns alternating examples from each of the original datasets.',Xa,cs,va,ds,He="Define sampling probabilities from each of the original datasets for more control over how each of them are sampled and combined. Set the <code>probabilities</code> argument with your desired sampling probabilities:",Ca,ms,Fa,hs,De="Around 80% of the final dataset is made of the <code>en_dataset</code>, and 20% of the <code>fr_dataset</code>.",Wa,os,Le=`You can also specify the <code>stopping_strategy</code>. The default strategy, <code>first_exhausted</code>, is a subsampling strategy, i.e the dataset construction is stopped as soon one of the dataset runs out of samples.
You can specify <code>stopping_strategy=all_exhausted</code> to execute an oversampling strategy. In this case, the dataset construction is stopped as soon as every samples in every dataset has been added at least once. In practice, it means that if a dataset is exhausted, it will return to the beginning of this dataset until the stop criterion has been reached.
Note that if no sampling probabilities are specified, the new dataset will have <code>max_length_datasets*nb_dataset samples</code>.`,Va,fs,Ya,us,Se="The following methods allow you to modify the columns of a dataset. These methods are useful for renaming or removing columns and changing columns to a new set of features.",za,gs,Ba,js,Ae='Use <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> when you need to rename a column in your dataset. Features associated with the original column are actually moved under the new column name, instead of just replacing the original column in-place.',Na,Ms,Ee='Provide <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.rename_column">IterableDataset.rename_column()</a> with the name of the original column, and the new column name:',Qa,bs,Ha,ys,Da,ws,qe='When you need to remove one or more columns, give <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.remove_columns">IterableDataset.remove_columns()</a> the name of the column to remove. Remove more than one column by providing a list of column names:',La,Ts,Sa,xs,Aa,Js,Ke='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.cast">IterableDataset.cast()</a> changes the feature type of one or more columns. This method takes your new <code>Features</code> as its argument. The following sample code shows how to change the feature types of <code>ClassLabel</code> and <code>Value</code>:',Ea,$s,qa,I,Ka,_s,Pe='Use <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.cast_column">IterableDataset.cast_column()</a> to change the feature type of just one column. Pass the column name and its new feature type as arguments:',Pa,ks,Oa,Zs,se,Us,Oe=`Similar to the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a> function for a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, 🤗  Datasets features <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> for processing an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> applies processing on-the-fly when examples are streamed.`,ae,Gs,st="It allows you to apply a processing function to each example in a dataset, independently or in batches. This function can even create new rows and columns.",ee,Is,at='The following example demonstrates how to tokenize a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. The function needs to accept and output a <code>dict</code>:',te,Rs,le,Xs,et='Next, apply this function to the dataset with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',ne,vs,pe,Cs,tt='Let’s take a look at another example, except this time, you will remove a column with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>. When you remove a column, it is only removed after the example has been provided to the mapped function. This allows the mapped function to use the content of the columns before they are removed.',ie,Fs,lt='Specify the column to remove with the <code>remove_columns</code> argument in <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a>:',re,Ws,ce,Vs,de,Ys,nt='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> also supports working with batches of examples. Operate on batches by setting <code>batched=True</code>. The default batch size is 1000, but you can adjust it with the <code>batch_size</code> argument. This opens the door to many interesting applications such as tokenization, splitting long sentences into shorter chunks, and data augmentation.',me,zs,he,Bs,oe,R,fe,Ns,ue,Qs,pt='You can filter rows in the dataset based on a predicate function using <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a>. It returns rows that match a specified condition:',ge,Hs,je,Ds,it='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.filter">Dataset.filter()</a> can also filter by indices if you set <code>with_indices=True</code>:',Me,Ls,be,Ss,ye,As,rt='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> can be integrated into a training loop. First, shuffle the dataset:',we,X,Te,Es,xe,Ps,Je;return T=new x({props:{title:"Stream",local:"stream",headingTag:"h1"}}),F=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXItY29ycHVzJTJGT1NDQVItMjIwMSclMkMlMjAnZW4nJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar-corpus/OSCAR-2201&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),z=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YV9maWxlcyUyMCUzRCUyMCU3Qid0cmFpbiclM0ElMjAncGF0aCUyRnRvJTJGT1NDQVItMjIwMSUyRmNvbXByZXNzZWQlMkZlbl9tZXRhJTJGKi5qc29ubC5neiclN0QlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdqc29uJyUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFwcmludChuZXh0KGl0ZXIoZGF0YXNldCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data_files = {<span class="hljs-string">&#x27;train&#x27;</span>: <span class="hljs-string">&#x27;path/to/OSCAR-2201/compressed/en_meta/*.jsonl.gz&#x27;</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;json&#x27;</span>, data_files=data_files, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset)))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Founded in 2015, Golden Bees is a leading programmatic recruitment platform dedicated to employers, HR agencies and job boards. The company has developed unique HR-custom technologies and predictive algorithms to identify and attract the best candidates for a job opportunity.&#x27;</span>, ...`,wrap:!1}}),Z=new Os({props:{$$slots:{default:[Jt]},$$scope:{ctx:w}}}),N=new x({props:{title:"Convert from a Dataset",local:"convert-from-a-dataset",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKSUwQSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZm9vZDEwMSUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># faster 🐇</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()

<span class="hljs-comment"># slower 🐢</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, streaming=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZvb2QxMDElMjIpJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNENjQpJTIwJTIzJTIwc2hhcmQlMjB0aGUlMjBkYXRhc2V0JTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGl0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShidWZmZXJfc2l6ZSUzRDEwXzAwMCklMjAlMjAlMjMlMjBzaHVmZmxlcyUyMHRoZSUyMHNoYXJkcyUyMG9yZGVyJTIwYW5kJTIwdXNlJTIwYSUyMHNodWZmbGUlMjBidWZmZXIlMjB3aGVuJTIweW91JTIwc3RhcnQlMjBpdGVyYXRpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset(num_shards=<span class="hljs-number">64</span>) <span class="hljs-comment"># shard the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = iterable_dataset.shuffle(buffer_size=<span class="hljs-number">10_000</span>)  <span class="hljs-comment"># shuffles the shards order and use a shuffle buffer when you start iterating</span>
dataloader = torch.utils.data.DataLoader(iterable_dataset, num_workers=<span class="hljs-number">4</span>)  <span class="hljs-comment"># assigns 64 / 4 = 16 shards from the shuffled list of shards to each worker when you start iterating</span>`,wrap:!1}}),S=new x({props:{title:"Shuffle",local:"shuffle",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQXNodWZmbGVkX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNodWZmbGUoc2VlZCUzRDQyJTJDJTIwYnVmZmVyX3NpemUlM0QxMF8wMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>shuffled_dataset = dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">10_000</span>)`,wrap:!1}}),U=new Os({props:{$$slots:{default:[$t]},$$scope:{ctx:w}}}),K=new x({props:{title:"Reshuffle",local:"reshuffle",headingTag:"h2"}}),ss=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBzaHVmZmxlZF9kYXRhc2V0LnNldF9lcG9jaChlcG9jaCklMEElMjAlMjAlMjAlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBzaHVmZmxlZF9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    shuffled_dataset.set_epoch(epoch)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> shuffled_dataset:
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),as=new x({props:{title:"Split dataset",local:"split-dataset",headingTag:"h2"}}),ls=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJTIydW5zaHVmZmxlZF9kZWR1cGxpY2F0ZWRfZW4lMjIlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXRfaGVhZCUyMCUzRCUyMGRhdGFzZXQudGFrZSgyKSUwQWxpc3QoZGF0YXNldF9oZWFkKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_head = dataset.take(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(dataset_head)
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was...&#x27;</span>}, {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),ps=new y({props:{code:"dHJhaW5fZGF0YXNldCUyMCUzRCUyMHNodWZmbGVkX2RhdGFzZXQuc2tpcCgxMDAwKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = shuffled_dataset.skip(<span class="hljs-number">1000</span>)',wrap:!1}}),G=new Os({props:{warning:!0,$$slots:{default:[_t]},$$scope:{ctx:w}}}),is=new x({props:{title:"Interleave",local:"interleave",headingTag:"h2"}}),cs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwaW50ZXJsZWF2ZV9kYXRhc2V0cyUwQWVuX2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJ29zY2FyJyUyQyUyMCUyMnVuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJTIyJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFmcl9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCdvc2NhciclMkMlMjAlMjJ1bnNodWZmbGVkX2RlZHVwbGljYXRlZF9mciUyMiUyQyUyMHNwbGl0JTNEJ3RyYWluJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBJTBBbXVsdGlsaW5ndWFsX2RhdGFzZXQlMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEKSUwQWxpc3QobXVsdGlsaW5ndWFsX2RhdGFzZXQudGFrZSgyKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> interleave_datasets
<span class="hljs-meta">&gt;&gt;&gt; </span>en_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_en&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fr_dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&quot;unshuffled_deduplicated_fr&quot;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>, trust_remote_code=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset = interleave_datasets([en_dataset, fr_dataset])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot;Média de débat d&#x27;idées, de culture et de littérature...&quot;</span>}]`,wrap:!1}}),ms=new y({props:{code:"bXVsdGlsaW5ndWFsX2RhdGFzZXRfd2l0aF9vdmVyc2FtcGxpbmclMjAlM0QlMjBpbnRlcmxlYXZlX2RhdGFzZXRzKCU1QmVuX2RhdGFzZXQlMkMlMjBmcl9kYXRhc2V0JTVEJTJDJTIwcHJvYmFiaWxpdGllcyUzRCU1QjAuOCUyQyUyMDAuMiU1RCUyQyUyMHNlZWQlM0Q0MiklMEFsaXN0KG11bHRpbGluZ3VhbF9kYXRhc2V0X3dpdGhfb3ZlcnNhbXBsaW5nLnRha2UoMikp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>multilingual_dataset_with_oversampling = interleave_datasets([en_dataset, fr_dataset], probabilities=[<span class="hljs-number">0.8</span>, <span class="hljs-number">0.2</span>], seed=<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(multilingual_dataset_with_oversampling.take(<span class="hljs-number">2</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision...&#x27;</span>}, {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Lily James cannot fight the music...&#x27;</span>}]`,wrap:!1}}),fs=new x({props:{title:"Rename, remove, and cast",local:"rename-remove-and-cast",headingTag:"h2"}}),gs=new x({props:{title:"Rename",local:"rename",headingTag:"h3"}}),bs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIydGV4dCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.rename_column(<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>)`,wrap:!1}}),ys=new x({props:{title:"Remove",local:"remove",headingTag:"h3"}}),Ts=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnbWM0JyUyQyUyMCdlbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QndHJhaW4nJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnJlbW92ZV9jb2x1bW5zKCd0aW1lc3RhbXAnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;mc4&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns(<span class="hljs-string">&#x27;timestamp&#x27;</span>)`,wrap:!1}}),xs=new x({props:{title:"Cast",local:"cast",headingTag:"h3"}}),$s=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnZ2x1ZSclMkMlMjAnbXJwYyclMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjBzdHJlYW1pbmclM0RUcnVlKSUwQWRhdGFzZXQuZmVhdHVyZXMlMEElMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBDbGFzc0xhYmVsJTJDJTIwVmFsdWUlMEFuZXdfZmVhdHVyZXMlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzLmNvcHkoKSUwQW5ld19mZWF0dXJlcyU1QiUyMmxhYmVsJTIyJTVEJTIwJTNEJTIwQ2xhc3NMYWJlbChuYW1lcyUzRCU1QiduZWdhdGl2ZSclMkMlMjAncG9zaXRpdmUnJTVEKSUwQW5ld19mZWF0dXJlcyU1QiUyMmlkeCUyMiU1RCUyMCUzRCUyMFZhbHVlKCdpbnQ2NCcpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdChuZXdfZmVhdHVyZXMpJTBBZGF0YXNldC5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;glue&#x27;</span>, <span class="hljs-string">&#x27;mrpc&#x27;</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;not_equivalent&#x27;</span>, <span class="hljs-string">&#x27;equivalent&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int32&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> ClassLabel, Value
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features = dataset.features.copy()
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;label&quot;</span>] = ClassLabel(names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>new_features[<span class="hljs-string">&quot;idx&quot;</span>] = Value(<span class="hljs-string">&#x27;int64&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast(new_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;sentence1&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;sentence2&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;negative&#x27;</span>, <span class="hljs-string">&#x27;positive&#x27;</span>], names_file=<span class="hljs-literal">None</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
<span class="hljs-string">&#x27;idx&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),I=new Os({props:{$$slots:{default:[kt]},$$scope:{ctx:w}}}),ks=new y({props:{code:"ZGF0YXNldC5mZWF0dXJlcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmNhc3RfY29sdW1uKCUyMmF1ZGlvJTIyJTJDJTIwQXVkaW8oc2FtcGxpbmdfcmF0ZSUzRDE2MDAwKSklMEFkYXRhc2V0LmZlYXR1cmVz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">44100</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.features
{<span class="hljs-string">&#x27;audio&#x27;</span>: Audio(sampling_rate=<span class="hljs-number">16000</span>, mono=<span class="hljs-literal">True</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),Zs=new x({props:{title:"Map",local:"map",headingTag:"h2"}}),Rs=new y({props:{code:"ZGVmJTIwYWRkX3ByZWZpeChleGFtcGxlKSUzQSUwQSUyMCUyMCUyMCUyMGV4YW1wbGUlNUIndGV4dCclNUQlMjAlM0QlMjAnTXklMjB0ZXh0JTNBJTIwJyUyMCUyQiUyMGV4YW1wbGUlNUIndGV4dCclNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBleGFtcGxl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">add_prefix</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&#x27;text&#x27;</span>] = <span class="hljs-string">&#x27;My text: &#x27;</span> + example[<span class="hljs-string">&#x27;text&#x27;</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),vs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCklMEFsaXN0KHVwZGF0ZWRfZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Ws=new y({props:{code:"dXBkYXRlZF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoYWRkX3ByZWZpeCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIyaWQlMjIlNUQpJTBBbGlzdCh1cGRhdGVkX2RhdGFzZXQudGFrZSgzKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_dataset = dataset.<span class="hljs-built_in">map</span>(add_prefix, remove_columns=[<span class="hljs-string">&quot;id&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(updated_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Mtendere Village was inspired by...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: Lily James cannot fight the music...&#x27;</span>},
 {<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My text: &quot;I\\&#x27;d love to help kickstart...&#x27;</span>}]`,wrap:!1}}),Vs=new x({props:{title:"Batch processing",local:"batch-processing",headingTag:"h3"}}),zs=new x({props:{title:"Tokenization",local:"tokenization",headingTag:"h4"}}),Bs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMm1jNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJ2Rpc3RpbGJlcnQtYmFzZS11bmNhc2VkJyklMEFkZWYlMjBlbmNvZGUoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJ3RleHQnJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEJ21heF9sZW5ndGgnKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0Lm1hcChlbmNvZGUlMkMlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEJTVCJTIydGV4dCUyMiUyQyUyMCUyMnRpbWVzdGFtcCUyMiUyQyUyMCUyMnVybCUyMiU1RCklMEFuZXh0KGl0ZXIoZGF0YXNldCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;mc4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;distilbert-base-uncased&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">encode</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&#x27;text&#x27;</span>], truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-string">&#x27;max_length&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(encode, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;timestamp&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))
{<span class="hljs-string">&#x27;input_ids&#x27;</span>: [<span class="hljs-number">101</span>, <span class="hljs-number">8466</span>, <span class="hljs-number">1018</span>, <span class="hljs-number">1010</span>, <span class="hljs-number">4029</span>, <span class="hljs-number">2475</span>, <span class="hljs-number">2062</span>, <span class="hljs-number">18558</span>, <span class="hljs-number">3100</span>, <span class="hljs-number">2061</span>, ...,<span class="hljs-number">1106</span>, <span class="hljs-number">3739</span>, <span class="hljs-number">102</span>],
<span class="hljs-string">&#x27;attention_mask&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, ..., <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]}`,wrap:!1}}),R=new Os({props:{$$slots:{default:[Zt]},$$scope:{ctx:w}}}),Ns=new x({props:{title:"Filter",local:"filter",headingTag:"h3"}}),Hs=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCgnb3NjYXInJTJDJTIwJ3Vuc2h1ZmZsZWRfZGVkdXBsaWNhdGVkX2VuJyUyQyUyMHN0cmVhbWluZyUzRFRydWUlMkMlMjBzcGxpdCUzRCd0cmFpbiclMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBc3RhcnRfd2l0aF9hciUyMCUzRCUyMGRhdGFzZXQuZmlsdGVyKGxhbWJkYSUyMGV4YW1wbGUlM0ElMjBleGFtcGxlJTVCJ3RleHQnJTVELnN0YXJ0c3dpdGgoJ0FyJykpJTBBbmV4dChpdGVyKHN0YXJ0X3dpdGhfYXIpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&#x27;oscar&#x27;</span>, <span class="hljs-string">&#x27;unshuffled_deduplicated_en&#x27;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&#x27;train&#x27;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_with_ar = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example: example[<span class="hljs-string">&#x27;text&#x27;</span>].startswith(<span class="hljs-string">&#x27;Ar&#x27;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(start_with_ar))
{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)?...&#x27;</span>}`,wrap:!1}}),Ls=new y({props:{code:"ZXZlbl9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIobGFtYmRhJTIwZXhhbXBsZSUyQyUyMGlkeCUzQSUyMGlkeCUyMCUyNSUyMDIlMjAlM0QlM0QlMjAwJTJDJTIwd2l0aF9pbmRpY2VzJTNEVHJ1ZSklMEFsaXN0KGV2ZW5fZGF0YXNldC50YWtlKDMpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>even_dataset = dataset.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> example, idx: idx % <span class="hljs-number">2</span> == <span class="hljs-number">0</span>, with_indices=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(even_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Mtendere Village was inspired by the vision of Chief Napoleon Dzombe, ...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;&quot;I\\&#x27;d love to help kickstart continued development! And 0 EUR/month...&#x27;</span>},
 {<span class="hljs-string">&#x27;id&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;Are you looking for Number the Stars (Essential Modern Classics)? Normally, ...&#x27;</span>}]`,wrap:!1}}),Ss=new x({props:{title:"Stream in a training loop",local:"stream-in-a-training-loop",headingTag:"h2"}}),X=new wt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[Gt]},$$scope:{ctx:w}}}),Es=new xt({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/stream.mdx"}}),{c(){p=r("meta"),j=l(),i=r("p"),b=l(),d(T.$$.fragment),J=l(),$=r("p"),$.textContent=M,_=l(),v=r("ul"),v.innerHTML=ke,sa=l(),k=r("div"),k.innerHTML=Ze,aa=l(),C=r("p"),C.innerHTML=Ue,ea=l(),d(F.$$.fragment),ta=l(),W=r("p"),W.textContent=Ge,la=l(),V=r("ul"),V.innerHTML=Ie,na=l(),Y=r("p"),Y.innerHTML=Re,pa=l(),d(z.$$.fragment),ia=l(),B=r("p"),B.innerHTML=Xe,ra=l(),d(Z.$$.fragment),ca=l(),d(N.$$.fragment),da=l(),Q=r("p"),Q.innerHTML=ve,ma=l(),d(H.$$.fragment),ha=l(),D=r("p"),D.innerHTML=Ce,oa=l(),d(L.$$.fragment),fa=l(),d(S.$$.fragment),ua=l(),A=r("p"),A.innerHTML=Fe,ga=l(),E=r("p"),E.innerHTML=We,ja=l(),d(q.$$.fragment),Ma=l(),d(U.$$.fragment),ba=l(),d(K.$$.fragment),ya=l(),P=r("p"),P.innerHTML=Ve,wa=l(),O=r("p"),O.innerHTML=Ye,Ta=l(),d(ss.$$.fragment),xa=l(),d(as.$$.fragment),Ja=l(),es=r("p"),es.textContent=ze,$a=l(),ts=r("ul"),ts.innerHTML=Be,_a=l(),d(ls.$$.fragment),ka=l(),ns=r("ul"),ns.innerHTML=Ne,Za=l(),d(ps.$$.fragment),Ua=l(),d(G.$$.fragment),Ga=l(),qs=r("a"),Ia=l(),d(is.$$.fragment),Ra=l(),rs=r("p"),rs.innerHTML=Qe,Xa=l(),d(cs.$$.fragment),va=l(),ds=r("p"),ds.innerHTML=He,Ca=l(),d(ms.$$.fragment),Fa=l(),hs=r("p"),hs.innerHTML=De,Wa=l(),os=r("p"),os.innerHTML=Le,Va=l(),d(fs.$$.fragment),Ya=l(),us=r("p"),us.textContent=Se,za=l(),d(gs.$$.fragment),Ba=l(),js=r("p"),js.innerHTML=Ae,Na=l(),Ms=r("p"),Ms.innerHTML=Ee,Qa=l(),d(bs.$$.fragment),Ha=l(),d(ys.$$.fragment),Da=l(),ws=r("p"),ws.innerHTML=qe,La=l(),d(Ts.$$.fragment),Sa=l(),d(xs.$$.fragment),Aa=l(),Js=r("p"),Js.innerHTML=Ke,Ea=l(),d($s.$$.fragment),qa=l(),d(I.$$.fragment),Ka=l(),_s=r("p"),_s.innerHTML=Pe,Pa=l(),d(ks.$$.fragment),Oa=l(),d(Zs.$$.fragment),se=l(),Us=r("p"),Us.innerHTML=Oe,ae=l(),Gs=r("p"),Gs.textContent=st,ee=l(),Is=r("p"),Is.innerHTML=at,te=l(),d(Rs.$$.fragment),le=l(),Xs=r("p"),Xs.innerHTML=et,ne=l(),d(vs.$$.fragment),pe=l(),Cs=r("p"),Cs.innerHTML=tt,ie=l(),Fs=r("p"),Fs.innerHTML=lt,re=l(),d(Ws.$$.fragment),ce=l(),d(Vs.$$.fragment),de=l(),Ys=r("p"),Ys.innerHTML=nt,me=l(),d(zs.$$.fragment),he=l(),d(Bs.$$.fragment),oe=l(),d(R.$$.fragment),fe=l(),d(Ns.$$.fragment),ue=l(),Qs=r("p"),Qs.innerHTML=pt,ge=l(),d(Hs.$$.fragment),je=l(),Ds=r("p"),Ds.innerHTML=it,Me=l(),d(Ls.$$.fragment),be=l(),d(Ss.$$.fragment),ye=l(),As=r("p"),As.innerHTML=rt,we=l(),d(X.$$.fragment),Te=l(),d(Es.$$.fragment),xe=l(),Ps=r("p"),this.h()},l(s){const a=bt("svelte-u9bgzb",document.head);p=c(a,"META",{name:!0,content:!0}),a.forEach(e),j=n(s),i=c(s,"P",{}),_e(i).forEach(e),b=n(s),m(T.$$.fragment,s),J=n(s),$=c(s,"P",{"data-svelte-h":!0}),g($)!=="svelte-1sf84jt"&&($.textContent=M),_=n(s),v=c(s,"UL",{"data-svelte-h":!0}),g(v)!=="svelte-1y6qvic"&&(v.innerHTML=ke),sa=n(s),k=c(s,"DIV",{class:!0,"data-svelte-h":!0}),g(k)!=="svelte-p91s8d"&&(k.innerHTML=Ze),aa=n(s),C=c(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1gdgj03"&&(C.innerHTML=Ue),ea=n(s),m(F.$$.fragment,s),ta=n(s),W=c(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-xdwdpa"&&(W.textContent=Ge),la=n(s),V=c(s,"UL",{"data-svelte-h":!0}),g(V)!=="svelte-lffs3"&&(V.innerHTML=Ie),na=n(s),Y=c(s,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-1newt0m"&&(Y.innerHTML=Re),pa=n(s),m(z.$$.fragment,s),ia=n(s),B=c(s,"P",{"data-svelte-h":!0}),g(B)!=="svelte-1v9hbju"&&(B.innerHTML=Xe),ra=n(s),m(Z.$$.fragment,s),ca=n(s),m(N.$$.fragment,s),da=n(s),Q=c(s,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-9d16wo"&&(Q.innerHTML=ve),ma=n(s),m(H.$$.fragment,s),ha=n(s),D=c(s,"P",{"data-svelte-h":!0}),g(D)!=="svelte-1oppubr"&&(D.innerHTML=Ce),oa=n(s),m(L.$$.fragment,s),fa=n(s),m(S.$$.fragment,s),ua=n(s),A=c(s,"P",{"data-svelte-h":!0}),g(A)!=="svelte-1pw5r1t"&&(A.innerHTML=Fe),ga=n(s),E=c(s,"P",{"data-svelte-h":!0}),g(E)!=="svelte-pt67rh"&&(E.innerHTML=We),ja=n(s),m(q.$$.fragment,s),Ma=n(s),m(U.$$.fragment,s),ba=n(s),m(K.$$.fragment,s),ya=n(s),P=c(s,"P",{"data-svelte-h":!0}),g(P)!=="svelte-l7znh1"&&(P.innerHTML=Ve),wa=n(s),O=c(s,"P",{"data-svelte-h":!0}),g(O)!=="svelte-flznjz"&&(O.innerHTML=Ye),Ta=n(s),m(ss.$$.fragment,s),xa=n(s),m(as.$$.fragment,s),Ja=n(s),es=c(s,"P",{"data-svelte-h":!0}),g(es)!=="svelte-1y9p9l9"&&(es.textContent=ze),$a=n(s),ts=c(s,"UL",{"data-svelte-h":!0}),g(ts)!=="svelte-1jm6l4z"&&(ts.innerHTML=Be),_a=n(s),m(ls.$$.fragment,s),ka=n(s),ns=c(s,"UL",{"data-svelte-h":!0}),g(ns)!=="svelte-1tg1950"&&(ns.innerHTML=Ne),Za=n(s),m(ps.$$.fragment,s),Ua=n(s),m(G.$$.fragment,s),Ga=n(s),qs=c(s,"A",{id:!0}),_e(qs).forEach(e),Ia=n(s),m(is.$$.fragment,s),Ra=n(s),rs=c(s,"P",{"data-svelte-h":!0}),g(rs)!=="svelte-upyohm"&&(rs.innerHTML=Qe),Xa=n(s),m(cs.$$.fragment,s),va=n(s),ds=c(s,"P",{"data-svelte-h":!0}),g(ds)!=="svelte-1t5oa18"&&(ds.innerHTML=He),Ca=n(s),m(ms.$$.fragment,s),Fa=n(s),hs=c(s,"P",{"data-svelte-h":!0}),g(hs)!=="svelte-1oi4bk"&&(hs.innerHTML=De),Wa=n(s),os=c(s,"P",{"data-svelte-h":!0}),g(os)!=="svelte-13euv56"&&(os.innerHTML=Le),Va=n(s),m(fs.$$.fragment,s),Ya=n(s),us=c(s,"P",{"data-svelte-h":!0}),g(us)!=="svelte-mlzv10"&&(us.textContent=Se),za=n(s),m(gs.$$.fragment,s),Ba=n(s),js=c(s,"P",{"data-svelte-h":!0}),g(js)!=="svelte-1981esk"&&(js.innerHTML=Ae),Na=n(s),Ms=c(s,"P",{"data-svelte-h":!0}),g(Ms)!=="svelte-chfhij"&&(Ms.innerHTML=Ee),Qa=n(s),m(bs.$$.fragment,s),Ha=n(s),m(ys.$$.fragment,s),Da=n(s),ws=c(s,"P",{"data-svelte-h":!0}),g(ws)!=="svelte-1r5asza"&&(ws.innerHTML=qe),La=n(s),m(Ts.$$.fragment,s),Sa=n(s),m(xs.$$.fragment,s),Aa=n(s),Js=c(s,"P",{"data-svelte-h":!0}),g(Js)!=="svelte-1xittgo"&&(Js.innerHTML=Ke),Ea=n(s),m($s.$$.fragment,s),qa=n(s),m(I.$$.fragment,s),Ka=n(s),_s=c(s,"P",{"data-svelte-h":!0}),g(_s)!=="svelte-w6xmqw"&&(_s.innerHTML=Pe),Pa=n(s),m(ks.$$.fragment,s),Oa=n(s),m(Zs.$$.fragment,s),se=n(s),Us=c(s,"P",{"data-svelte-h":!0}),g(Us)!=="svelte-1h1g2or"&&(Us.innerHTML=Oe),ae=n(s),Gs=c(s,"P",{"data-svelte-h":!0}),g(Gs)!=="svelte-1rfoeeh"&&(Gs.textContent=st),ee=n(s),Is=c(s,"P",{"data-svelte-h":!0}),g(Is)!=="svelte-zszb9u"&&(Is.innerHTML=at),te=n(s),m(Rs.$$.fragment,s),le=n(s),Xs=c(s,"P",{"data-svelte-h":!0}),g(Xs)!=="svelte-1v8p29n"&&(Xs.innerHTML=et),ne=n(s),m(vs.$$.fragment,s),pe=n(s),Cs=c(s,"P",{"data-svelte-h":!0}),g(Cs)!=="svelte-1f12xbe"&&(Cs.innerHTML=tt),ie=n(s),Fs=c(s,"P",{"data-svelte-h":!0}),g(Fs)!=="svelte-zr1qst"&&(Fs.innerHTML=lt),re=n(s),m(Ws.$$.fragment,s),ce=n(s),m(Vs.$$.fragment,s),de=n(s),Ys=c(s,"P",{"data-svelte-h":!0}),g(Ys)!=="svelte-cewjpj"&&(Ys.innerHTML=nt),me=n(s),m(zs.$$.fragment,s),he=n(s),m(Bs.$$.fragment,s),oe=n(s),m(R.$$.fragment,s),fe=n(s),m(Ns.$$.fragment,s),ue=n(s),Qs=c(s,"P",{"data-svelte-h":!0}),g(Qs)!=="svelte-86ngw3"&&(Qs.innerHTML=pt),ge=n(s),m(Hs.$$.fragment,s),je=n(s),Ds=c(s,"P",{"data-svelte-h":!0}),g(Ds)!=="svelte-19qhh0v"&&(Ds.innerHTML=it),Me=n(s),m(Ls.$$.fragment,s),be=n(s),m(Ss.$$.fragment,s),ye=n(s),As=c(s,"P",{"data-svelte-h":!0}),g(As)!=="svelte-3lon84"&&(As.innerHTML=rt),we=n(s),m(X.$$.fragment,s),Te=n(s),m(Es.$$.fragment,s),xe=n(s),Ps=c(s,"P",{}),_e(Ps).forEach(e),this.h()},h(){$e(p,"name","hf:doc:metadata"),$e(p,"content",Rt),$e(k,"class","flex justify-center"),$e(qs,"id","interleave_datasets")},m(s,a){yt(document.head,p),t(s,j,a),t(s,i,a),t(s,b,a),h(T,s,a),t(s,J,a),t(s,$,a),t(s,_,a),t(s,v,a),t(s,sa,a),t(s,k,a),t(s,aa,a),t(s,C,a),t(s,ea,a),h(F,s,a),t(s,ta,a),t(s,W,a),t(s,la,a),t(s,V,a),t(s,na,a),t(s,Y,a),t(s,pa,a),h(z,s,a),t(s,ia,a),t(s,B,a),t(s,ra,a),h(Z,s,a),t(s,ca,a),h(N,s,a),t(s,da,a),t(s,Q,a),t(s,ma,a),h(H,s,a),t(s,ha,a),t(s,D,a),t(s,oa,a),h(L,s,a),t(s,fa,a),h(S,s,a),t(s,ua,a),t(s,A,a),t(s,ga,a),t(s,E,a),t(s,ja,a),h(q,s,a),t(s,Ma,a),h(U,s,a),t(s,ba,a),h(K,s,a),t(s,ya,a),t(s,P,a),t(s,wa,a),t(s,O,a),t(s,Ta,a),h(ss,s,a),t(s,xa,a),h(as,s,a),t(s,Ja,a),t(s,es,a),t(s,$a,a),t(s,ts,a),t(s,_a,a),h(ls,s,a),t(s,ka,a),t(s,ns,a),t(s,Za,a),h(ps,s,a),t(s,Ua,a),h(G,s,a),t(s,Ga,a),t(s,qs,a),t(s,Ia,a),h(is,s,a),t(s,Ra,a),t(s,rs,a),t(s,Xa,a),h(cs,s,a),t(s,va,a),t(s,ds,a),t(s,Ca,a),h(ms,s,a),t(s,Fa,a),t(s,hs,a),t(s,Wa,a),t(s,os,a),t(s,Va,a),h(fs,s,a),t(s,Ya,a),t(s,us,a),t(s,za,a),h(gs,s,a),t(s,Ba,a),t(s,js,a),t(s,Na,a),t(s,Ms,a),t(s,Qa,a),h(bs,s,a),t(s,Ha,a),h(ys,s,a),t(s,Da,a),t(s,ws,a),t(s,La,a),h(Ts,s,a),t(s,Sa,a),h(xs,s,a),t(s,Aa,a),t(s,Js,a),t(s,Ea,a),h($s,s,a),t(s,qa,a),h(I,s,a),t(s,Ka,a),t(s,_s,a),t(s,Pa,a),h(ks,s,a),t(s,Oa,a),h(Zs,s,a),t(s,se,a),t(s,Us,a),t(s,ae,a),t(s,Gs,a),t(s,ee,a),t(s,Is,a),t(s,te,a),h(Rs,s,a),t(s,le,a),t(s,Xs,a),t(s,ne,a),h(vs,s,a),t(s,pe,a),t(s,Cs,a),t(s,ie,a),t(s,Fs,a),t(s,re,a),h(Ws,s,a),t(s,ce,a),h(Vs,s,a),t(s,de,a),t(s,Ys,a),t(s,me,a),h(zs,s,a),t(s,he,a),h(Bs,s,a),t(s,oe,a),h(R,s,a),t(s,fe,a),h(Ns,s,a),t(s,ue,a),t(s,Qs,a),t(s,ge,a),h(Hs,s,a),t(s,je,a),t(s,Ds,a),t(s,Me,a),h(Ls,s,a),t(s,be,a),h(Ss,s,a),t(s,ye,a),t(s,As,a),t(s,we,a),h(X,s,a),t(s,Te,a),h(Es,s,a),t(s,xe,a),t(s,Ps,a),Je=!0},p(s,[a]){const ct={};a&2&&(ct.$$scope={dirty:a,ctx:s}),Z.$set(ct);const dt={};a&2&&(dt.$$scope={dirty:a,ctx:s}),U.$set(dt);const mt={};a&2&&(mt.$$scope={dirty:a,ctx:s}),G.$set(mt);const ht={};a&2&&(ht.$$scope={dirty:a,ctx:s}),I.$set(ht);const ot={};a&2&&(ot.$$scope={dirty:a,ctx:s}),R.$set(ot);const ft={};a&2&&(ft.$$scope={dirty:a,ctx:s}),X.$set(ft)},i(s){Je||(o(T.$$.fragment,s),o(F.$$.fragment,s),o(z.$$.fragment,s),o(Z.$$.fragment,s),o(N.$$.fragment,s),o(H.$$.fragment,s),o(L.$$.fragment,s),o(S.$$.fragment,s),o(q.$$.fragment,s),o(U.$$.fragment,s),o(K.$$.fragment,s),o(ss.$$.fragment,s),o(as.$$.fragment,s),o(ls.$$.fragment,s),o(ps.$$.fragment,s),o(G.$$.fragment,s),o(is.$$.fragment,s),o(cs.$$.fragment,s),o(ms.$$.fragment,s),o(fs.$$.fragment,s),o(gs.$$.fragment,s),o(bs.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(xs.$$.fragment,s),o($s.$$.fragment,s),o(I.$$.fragment,s),o(ks.$$.fragment,s),o(Zs.$$.fragment,s),o(Rs.$$.fragment,s),o(vs.$$.fragment,s),o(Ws.$$.fragment,s),o(Vs.$$.fragment,s),o(zs.$$.fragment,s),o(Bs.$$.fragment,s),o(R.$$.fragment,s),o(Ns.$$.fragment,s),o(Hs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ss.$$.fragment,s),o(X.$$.fragment,s),o(Es.$$.fragment,s),Je=!0)},o(s){f(T.$$.fragment,s),f(F.$$.fragment,s),f(z.$$.fragment,s),f(Z.$$.fragment,s),f(N.$$.fragment,s),f(H.$$.fragment,s),f(L.$$.fragment,s),f(S.$$.fragment,s),f(q.$$.fragment,s),f(U.$$.fragment,s),f(K.$$.fragment,s),f(ss.$$.fragment,s),f(as.$$.fragment,s),f(ls.$$.fragment,s),f(ps.$$.fragment,s),f(G.$$.fragment,s),f(is.$$.fragment,s),f(cs.$$.fragment,s),f(ms.$$.fragment,s),f(fs.$$.fragment,s),f(gs.$$.fragment,s),f(bs.$$.fragment,s),f(ys.$$.fragment,s),f(Ts.$$.fragment,s),f(xs.$$.fragment,s),f($s.$$.fragment,s),f(I.$$.fragment,s),f(ks.$$.fragment,s),f(Zs.$$.fragment,s),f(Rs.$$.fragment,s),f(vs.$$.fragment,s),f(Ws.$$.fragment,s),f(Vs.$$.fragment,s),f(zs.$$.fragment,s),f(Bs.$$.fragment,s),f(R.$$.fragment,s),f(Ns.$$.fragment,s),f(Hs.$$.fragment,s),f(Ls.$$.fragment,s),f(Ss.$$.fragment,s),f(X.$$.fragment,s),f(Es.$$.fragment,s),Je=!1},d(s){s&&(e(j),e(i),e(b),e(J),e($),e(_),e(v),e(sa),e(k),e(aa),e(C),e(ea),e(ta),e(W),e(la),e(V),e(na),e(Y),e(pa),e(ia),e(B),e(ra),e(ca),e(da),e(Q),e(ma),e(ha),e(D),e(oa),e(fa),e(ua),e(A),e(ga),e(E),e(ja),e(Ma),e(ba),e(ya),e(P),e(wa),e(O),e(Ta),e(xa),e(Ja),e(es),e($a),e(ts),e(_a),e(ka),e(ns),e(Za),e(Ua),e(Ga),e(qs),e(Ia),e(Ra),e(rs),e(Xa),e(va),e(ds),e(Ca),e(Fa),e(hs),e(Wa),e(os),e(Va),e(Ya),e(us),e(za),e(Ba),e(js),e(Na),e(Ms),e(Qa),e(Ha),e(Da),e(ws),e(La),e(Sa),e(Aa),e(Js),e(Ea),e(qa),e(Ka),e(_s),e(Pa),e(Oa),e(se),e(Us),e(ae),e(Gs),e(ee),e(Is),e(te),e(le),e(Xs),e(ne),e(pe),e(Cs),e(ie),e(Fs),e(re),e(ce),e(de),e(Ys),e(me),e(he),e(oe),e(fe),e(ue),e(Qs),e(ge),e(je),e(Ds),e(Me),e(be),e(ye),e(As),e(we),e(Te),e(xe),e(Ps)),e(p),u(T,s),u(F,s),u(z,s),u(Z,s),u(N,s),u(H,s),u(L,s),u(S,s),u(q,s),u(U,s),u(K,s),u(ss,s),u(as,s),u(ls,s),u(ps,s),u(G,s),u(is,s),u(cs,s),u(ms,s),u(fs,s),u(gs,s),u(bs,s),u(ys,s),u(Ts,s),u(xs,s),u($s,s),u(I,s),u(ks,s),u(Zs,s),u(Rs,s),u(vs,s),u(Ws,s),u(Vs,s),u(zs,s),u(Bs,s),u(R,s),u(Ns,s),u(Hs,s),u(Ls,s),u(Ss,s),u(X,s),u(Es,s)}}}const Rt='{"title":"Stream","local":"stream","sections":[{"title":"Convert from a Dataset","local":"convert-from-a-dataset","sections":[],"depth":2},{"title":"Shuffle","local":"shuffle","sections":[],"depth":2},{"title":"Reshuffle","local":"reshuffle","sections":[],"depth":2},{"title":"Split dataset","local":"split-dataset","sections":[],"depth":2},{"title":"Interleave","local":"interleave","sections":[],"depth":2},{"title":"Rename, remove, and cast","local":"rename-remove-and-cast","sections":[{"title":"Rename","local":"rename","sections":[],"depth":3},{"title":"Remove","local":"remove","sections":[],"depth":3},{"title":"Cast","local":"cast","sections":[],"depth":3}],"depth":2},{"title":"Map","local":"map","sections":[{"title":"Batch processing","local":"batch-processing","sections":[{"title":"Tokenization","local":"tokenization","sections":[],"depth":4}],"depth":3},{"title":"Filter","local":"filter","sections":[],"depth":3}],"depth":2},{"title":"Stream in a training loop","local":"stream-in-a-training-loop","sections":[],"depth":2}],"depth":1}';function Xt(w){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zt extends jt{constructor(p){super(),Mt(this,p,Xt,It,ut,{})}}export{zt as component};
