import{s as ca,o as ma,n as Vs}from"../chunks/scheduler.bdbef820.js";import{S as oa,i as ha,g as i,s as n,r as m,A as da,h as c,f as t,c as p,j as ra,u as o,x as g,k as ia,y as ua,a as e,v as h,d,t as u,w as j}from"../chunks/index.c0aea24a.js";import{T as Es}from"../chunks/Tip.31005f7d.js";import{C as J}from"../chunks/CodeBlock.6ccca92e.js";import{H as ts,E as ja}from"../chunks/EditOnGithub.725ee0c1.js";function ga(f){let l,M=`<code>jax</code> and <code>jaxlib</code> are required to reproduce to code above, so please make sure you
install them as <code>pip install datasets[jax]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1i2qrbm"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Vs,d(r){r&&t(l)}}}function Ma(f){let l,M='A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to JAX arrays.';return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-15s0oa4"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Vs,d(r){r&&t(l)}}}function ya(f){let l,M=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-1go8nao"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Vs,d(r){r&&t(l)}}}function fa(f){let l,M=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){l=i("p"),l.innerHTML=M},l(r){l=c(r,"P",{"data-svelte-h":!0}),g(l)!=="svelte-118qika"&&(l.innerHTML=M)},m(r,y){e(r,l,y)},p:Vs,d(r){r&&t(l)}}}function Ja(f){let l,M,r,y,$,ls,C,Bs=`This document is a quick introduction to using <code>datasets</code> with JAX, with a particular focus on how to get
<code>jax.Array</code> objects out of our datasets, and how to use them to train JAX models.`,ns,b,ps,I,rs,R,Ys=`By default, datasets return regular Python objects: integers, floats, strings, lists, etc., and
string and binary objects are unchanged, since JAX only supports numbers.`,is,Z,Fs="To get JAX arrays (numpy-like) instead, you can set the format of the dataset to <code>jax</code>:",cs,k,ms,T,os,X,zs=`Note that the exact same procedure applies to <code>DatasetDict</code> objects, so that
when setting the format of a <code>DatasetDict</code> to <code>jax</code>, all the <code>Dataset</code>s there
will be formatted as <code>jax</code>:`,hs,v,ds,x,Hs=`Another thing you’ll need to take into consideration is that the formatting is not applied
until you actually access the data. So if you want to get a JAX array out of a dataset,
you’ll need to access the data first, otherwise the format will remain the same.`,us,_,Ds=`Finally, to load the data in the device of your choice, you can specify the <code>device</code> argument,
but note that <code>jaxlib.xla_extension.Device</code> is not supported as it’s not serializable with neither
<code>pickle</code> not <code>dill</code>, so you’ll need to use its string identifier instead:`,js,A,gs,N,Ws=`Note that if the <code>device</code> argument is not provided to <code>with_format</code> then it will use the default
device which is <code>jax.devices()[0]</code>.`,Ms,q,ys,Q,Ls=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a JAX formatted dataset outputs a <code>DeviceArray</code> object, which is a numpy-like array, so it does not
need the <code>Array</code> feature type to be specified as opposed to PyTorch or TensorFlow formatters.`,fs,G,Js,E,bs,V,Ss='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data is properly converted to arrays:',Ts,B,ws,Y,Ps="String and binary objects are unchanged, since JAX only supports numbers.",Us,F,Ks='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',$s,w,Cs,z,Is,U,Rs,H,Zs,D,ks,W,Os=`JAX doesn’t have any built-in data loading capabilities, so you’ll need to use a library such
as <a href="https://pytorch.org/" rel="nofollow">PyTorch</a> to load your data using a <code>DataLoader</code> or <a href="https://www.tensorflow.org/" rel="nofollow">TensorFlow</a>
using a <code>tf.data.Dataset</code>. Citing the <a href="https://jax.readthedocs.io/en/latest/notebooks/Neural_Network_and_Data_Loading.html#data-loading-with-pytorch" rel="nofollow">JAX documentation</a> on this topic:
“JAX is laser-focused on program transformations and accelerator-backed NumPy, so we don’t
include data loading or munging in the JAX library. There are already a lot of great data loaders
out there, so let’s just use them instead of reinventing anything. We’ll grab PyTorch’s data loader,
and make a tiny shim to make it work with NumPy arrays.”.`,Xs,L,sa=`So that’s the reason why JAX-formatting in <code>datasets</code> is so useful, because it lets you use
any model from the HuggingFace Hub with JAX, without having to worry about the data loading
part.`,vs,S,xs,P,aa=`The easiest way to get JAX arrays out of a dataset is to use the <code>with_format(&#39;jax&#39;)</code> method. Lets assume
that we want to train a neural network on the <a href="http://yann.lecun.com/exdb/mnist/" rel="nofollow">MNIST dataset</a> available
at the HuggingFace Hub at <a href="https://huggingface.co/datasets/mnist" rel="nofollow">https://huggingface.co/datasets/mnist</a>.`,_s,K,As,O,ta=`Once the format is set we can feed the dataset to the JAX model in batches using the <code>Dataset.iter()</code>
method:`,Ns,ss,qs,as,Qs,es,Gs;return $=new ts({props:{title:"Use with JAX",local:"use-with-jax",headingTag:"h1"}}),b=new Es({props:{$$slots:{default:[ga]},$$scope:{ctx:f}}}),I=new ts({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),k=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMmpheCUyMiklMEFkcyU1QjAlNUQlMEFkcyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], dtype=int32)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([
    [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),T=new Es({props:{$$slots:{default:[Ma]},$$scope:{ctx:f}}}),v=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldERpY3QlMEFkYXRhJTIwJTNEJTIwJTdCJTIydHJhaW4lMjIlM0ElMjAlN0IlMjJkYXRhJTIyJTNBJTIwJTVCJTVCMSUyQyUyMDIlNUQlMkMlMjAlNUIzJTJDJTIwNCU1RCU1RCU3RCUyQyUyMCUyMnRlc3QlMjIlM0ElMjAlN0IlMjJkYXRhJTIyJTNBJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU3RCU3RCUwQWRkcyUyMCUzRCUyMERhdGFzZXREaWN0LmZyb21fZGljdChkYXRhKSUwQWRkcyUyMCUzRCUyMGRkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZGRzJTVCJTIydHJhaW4lMjIlNUQlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> DatasetDict
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;train&quot;</span>: {<span class="hljs-string">&quot;data&quot;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]}, <span class="hljs-string">&quot;test&quot;</span>: {<span class="hljs-string">&quot;data&quot;</span>: [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>], [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]}}
<span class="hljs-meta">&gt;&gt;&gt; </span>dds = DatasetDict.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>dds = dds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dds[<span class="hljs-string">&quot;train&quot;</span>][:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([
    [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
    [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),A=new J({props:{code:"aW1wb3J0JTIwamF4JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkZXZpY2UlMjAlM0QlMjBzdHIoamF4LmRldmljZXMoKSU1QjAlNUQpJTIwJTIwJTIzJTIwTm90JTIwY2FzdGluZyUyMHRvJTIwJTYwc3RyJTYwJTIwYmVmb3JlJTIwcGFzc2luZyUyMGl0JTIwdG8lMjAlNjB3aXRoX2Zvcm1hdCU2MCUyMHdpbGwlMjByYWlzZSUyMGElMjAlNjBWYWx1ZUVycm9yJTYwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTBBZHMlNUIwJTVEJTBBZHMlNUIwJTVEJTVCJTIyZGF0YSUyMiU1RC5kZXZpY2UoKSUwQWFzc2VydCUyMGRzJTVCMCU1RCU1QiUyMmRhdGElMjIlNUQuZGV2aWNlKCklMjAlM0QlM0QlMjBqYXguZGV2aWNlcygpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-built_in">str</span>(jax.devices()[<span class="hljs-number">0</span>])  <span class="hljs-comment"># Not casting to \`str\` before passing it to \`with_format\` will raise a \`ValueError\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>, device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], dtype=int32)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;data&quot;</span>].device()
TFRT_CPU_0
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">assert</span> ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;data&quot;</span>].device() == jax.devices()[<span class="hljs-number">0</span>]
<span class="hljs-literal">True</span>`,wrap:!1}}),q=new ts({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),G=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: DeviceArray([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
             [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], dtype=int32)}`,wrap:!1}}),E=new ts({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),B=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIlM0EzJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: DeviceArray([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>], dtype=int32)}`,wrap:!1}}),w=new Es({props:{$$slots:{default:[ya]},$$scope:{ctx:f}}}),z=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwSW1hZ2UlMEFpbWFnZXMlMjAlM0QlMjAlNUIlMjJwYXRoJTJGdG8lMkZpbWFnZS5wbmclMjIlNUQlMjAqJTIwMTAlMEFmZWF0dXJlcyUyMCUzRCUyMEZlYXR1cmVzKCU3QiUyMmltYWdlJTIyJTNBJTIwSW1hZ2UoKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmltYWdlJTIyJTNBJTIwaW1hZ2VzJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMmpheCUyMiklMEFkcyU1QjAlNUQlNUIlMjJpbWFnZSUyMiU1RC5zaGFwZSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RCU1QiUyMmltYWdlJTIyJTVELnNoYXBlJTBBZHMlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[[ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              ...,
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=uint8)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
(<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[[[ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              ...,
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
              [ <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=uint8)}`,wrap:!1}}),U=new Es({props:{$$slots:{default:[fa]},$$scope:{ctx:f}}}),H=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMEFhdWRpbyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmF1ZGlvLndhdiUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyYXVkaW8lMjIlM0ElMjBBdWRpbygpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyYXVkaW8lMjIlM0ElMjBhdWRpbyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
DeviceArray([-<span class="hljs-number">0.059021</span>  , -<span class="hljs-number">0.03894043</span>, -<span class="hljs-number">0.00735474</span>, ...,  <span class="hljs-number">0.0133667</span> ,
              <span class="hljs-number">0.01809692</span>,  <span class="hljs-number">0.00268555</span>], dtype=float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
DeviceArray(<span class="hljs-number">44100</span>, dtype=int32, weak_type=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new ts({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),S=new ts({props:{title:"Using with_format('jax')",local:"using-withformatjax",headingTag:"h3"}}),K=new J({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybW5pc3QlMjIpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJqYXglMjIpJTBBZHMlNUIlMjJ0cmFpbiUyMiU1RCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;mnist&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;jax&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: DeviceArray([[  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       ...,
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...],
                       [  <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>,   <span class="hljs-number">0</span>, ...]], dtype=uint8),
 <span class="hljs-string">&#x27;label&#x27;</span>: DeviceArray(<span class="hljs-number">5</span>, dtype=int32)}`,wrap:!1}}),ss=new J({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKGVwb2NocyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RC5pdGVyKGJhdGNoX3NpemUlM0QzMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB4JTJDJTIweSUyMCUzRCUyMGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMkMlMjBiYXRjaCU1QiUyMmxhYmVsJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> ds[<span class="hljs-string">&quot;train&quot;</span>].<span class="hljs-built_in">iter</span>(batch_size=<span class="hljs-number">32</span>):
<span class="hljs-meta">... </span>        x, y = batch[<span class="hljs-string">&quot;image&quot;</span>], batch[<span class="hljs-string">&quot;label&quot;</span>]
<span class="hljs-meta">... </span>        ...`,wrap:!1}}),as=new ja({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/use_with_jax.mdx"}}),{c(){l=i("meta"),M=n(),r=i("p"),y=n(),m($.$$.fragment),ls=n(),C=i("p"),C.innerHTML=Bs,ns=n(),m(b.$$.fragment),ps=n(),m(I.$$.fragment),rs=n(),R=i("p"),R.textContent=Ys,is=n(),Z=i("p"),Z.innerHTML=Fs,cs=n(),m(k.$$.fragment),ms=n(),m(T.$$.fragment),os=n(),X=i("p"),X.innerHTML=zs,hs=n(),m(v.$$.fragment),ds=n(),x=i("p"),x.textContent=Hs,us=n(),_=i("p"),_.innerHTML=Ds,js=n(),m(A.$$.fragment),gs=n(),N=i("p"),N.innerHTML=Ws,Ms=n(),m(q.$$.fragment),ys=n(),Q=i("p"),Q.innerHTML=Ls,fs=n(),m(G.$$.fragment),Js=n(),m(E.$$.fragment),bs=n(),V=i("p"),V.innerHTML=Ss,Ts=n(),m(B.$$.fragment),ws=n(),Y=i("p"),Y.textContent=Ps,Us=n(),F=i("p"),F.innerHTML=Ks,$s=n(),m(w.$$.fragment),Cs=n(),m(z.$$.fragment),Is=n(),m(U.$$.fragment),Rs=n(),m(H.$$.fragment),Zs=n(),m(D.$$.fragment),ks=n(),W=i("p"),W.innerHTML=Os,Xs=n(),L=i("p"),L.innerHTML=sa,vs=n(),m(S.$$.fragment),xs=n(),P=i("p"),P.innerHTML=aa,_s=n(),m(K.$$.fragment),As=n(),O=i("p"),O.innerHTML=ta,Ns=n(),m(ss.$$.fragment),qs=n(),m(as.$$.fragment),Qs=n(),es=i("p"),this.h()},l(s){const a=da("svelte-u9bgzb",document.head);l=c(a,"META",{name:!0,content:!0}),a.forEach(t),M=p(s),r=c(s,"P",{}),ra(r).forEach(t),y=p(s),o($.$$.fragment,s),ls=p(s),C=c(s,"P",{"data-svelte-h":!0}),g(C)!=="svelte-1a2kcgx"&&(C.innerHTML=Bs),ns=p(s),o(b.$$.fragment,s),ps=p(s),o(I.$$.fragment,s),rs=p(s),R=c(s,"P",{"data-svelte-h":!0}),g(R)!=="svelte-1ix49d8"&&(R.textContent=Ys),is=p(s),Z=c(s,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1upv66g"&&(Z.innerHTML=Fs),cs=p(s),o(k.$$.fragment,s),ms=p(s),o(T.$$.fragment,s),os=p(s),X=c(s,"P",{"data-svelte-h":!0}),g(X)!=="svelte-1b7i338"&&(X.innerHTML=zs),hs=p(s),o(v.$$.fragment,s),ds=p(s),x=c(s,"P",{"data-svelte-h":!0}),g(x)!=="svelte-1c29vp0"&&(x.textContent=Hs),us=p(s),_=c(s,"P",{"data-svelte-h":!0}),g(_)!=="svelte-1ooxy7c"&&(_.innerHTML=Ds),js=p(s),o(A.$$.fragment,s),gs=p(s),N=c(s,"P",{"data-svelte-h":!0}),g(N)!=="svelte-hj2cy7"&&(N.innerHTML=Ws),Ms=p(s),o(q.$$.fragment,s),ys=p(s),Q=c(s,"P",{"data-svelte-h":!0}),g(Q)!=="svelte-ubc06l"&&(Q.innerHTML=Ls),fs=p(s),o(G.$$.fragment,s),Js=p(s),o(E.$$.fragment,s),bs=p(s),V=c(s,"P",{"data-svelte-h":!0}),g(V)!=="svelte-8w6z6n"&&(V.innerHTML=Ss),Ts=p(s),o(B.$$.fragment,s),ws=p(s),Y=c(s,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-gkri0z"&&(Y.textContent=Ps),Us=p(s),F=c(s,"P",{"data-svelte-h":!0}),g(F)!=="svelte-1g2r59q"&&(F.innerHTML=Ks),$s=p(s),o(w.$$.fragment,s),Cs=p(s),o(z.$$.fragment,s),Is=p(s),o(U.$$.fragment,s),Rs=p(s),o(H.$$.fragment,s),Zs=p(s),o(D.$$.fragment,s),ks=p(s),W=c(s,"P",{"data-svelte-h":!0}),g(W)!=="svelte-1msw6w0"&&(W.innerHTML=Os),Xs=p(s),L=c(s,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1xmbhz7"&&(L.innerHTML=sa),vs=p(s),o(S.$$.fragment,s),xs=p(s),P=c(s,"P",{"data-svelte-h":!0}),g(P)!=="svelte-1pw5xoa"&&(P.innerHTML=aa),_s=p(s),o(K.$$.fragment,s),As=p(s),O=c(s,"P",{"data-svelte-h":!0}),g(O)!=="svelte-lnmbh3"&&(O.innerHTML=ta),Ns=p(s),o(ss.$$.fragment,s),qs=p(s),o(as.$$.fragment,s),Qs=p(s),es=c(s,"P",{}),ra(es).forEach(t),this.h()},h(){ia(l,"name","hf:doc:metadata"),ia(l,"content",ba)},m(s,a){ua(document.head,l),e(s,M,a),e(s,r,a),e(s,y,a),h($,s,a),e(s,ls,a),e(s,C,a),e(s,ns,a),h(b,s,a),e(s,ps,a),h(I,s,a),e(s,rs,a),e(s,R,a),e(s,is,a),e(s,Z,a),e(s,cs,a),h(k,s,a),e(s,ms,a),h(T,s,a),e(s,os,a),e(s,X,a),e(s,hs,a),h(v,s,a),e(s,ds,a),e(s,x,a),e(s,us,a),e(s,_,a),e(s,js,a),h(A,s,a),e(s,gs,a),e(s,N,a),e(s,Ms,a),h(q,s,a),e(s,ys,a),e(s,Q,a),e(s,fs,a),h(G,s,a),e(s,Js,a),h(E,s,a),e(s,bs,a),e(s,V,a),e(s,Ts,a),h(B,s,a),e(s,ws,a),e(s,Y,a),e(s,Us,a),e(s,F,a),e(s,$s,a),h(w,s,a),e(s,Cs,a),h(z,s,a),e(s,Is,a),h(U,s,a),e(s,Rs,a),h(H,s,a),e(s,Zs,a),h(D,s,a),e(s,ks,a),e(s,W,a),e(s,Xs,a),e(s,L,a),e(s,vs,a),h(S,s,a),e(s,xs,a),e(s,P,a),e(s,_s,a),h(K,s,a),e(s,As,a),e(s,O,a),e(s,Ns,a),h(ss,s,a),e(s,qs,a),h(as,s,a),e(s,Qs,a),e(s,es,a),Gs=!0},p(s,[a]){const ea={};a&2&&(ea.$$scope={dirty:a,ctx:s}),b.$set(ea);const la={};a&2&&(la.$$scope={dirty:a,ctx:s}),T.$set(la);const na={};a&2&&(na.$$scope={dirty:a,ctx:s}),w.$set(na);const pa={};a&2&&(pa.$$scope={dirty:a,ctx:s}),U.$set(pa)},i(s){Gs||(d($.$$.fragment,s),d(b.$$.fragment,s),d(I.$$.fragment,s),d(k.$$.fragment,s),d(T.$$.fragment,s),d(v.$$.fragment,s),d(A.$$.fragment,s),d(q.$$.fragment,s),d(G.$$.fragment,s),d(E.$$.fragment,s),d(B.$$.fragment,s),d(w.$$.fragment,s),d(z.$$.fragment,s),d(U.$$.fragment,s),d(H.$$.fragment,s),d(D.$$.fragment,s),d(S.$$.fragment,s),d(K.$$.fragment,s),d(ss.$$.fragment,s),d(as.$$.fragment,s),Gs=!0)},o(s){u($.$$.fragment,s),u(b.$$.fragment,s),u(I.$$.fragment,s),u(k.$$.fragment,s),u(T.$$.fragment,s),u(v.$$.fragment,s),u(A.$$.fragment,s),u(q.$$.fragment,s),u(G.$$.fragment,s),u(E.$$.fragment,s),u(B.$$.fragment,s),u(w.$$.fragment,s),u(z.$$.fragment,s),u(U.$$.fragment,s),u(H.$$.fragment,s),u(D.$$.fragment,s),u(S.$$.fragment,s),u(K.$$.fragment,s),u(ss.$$.fragment,s),u(as.$$.fragment,s),Gs=!1},d(s){s&&(t(M),t(r),t(y),t(ls),t(C),t(ns),t(ps),t(rs),t(R),t(is),t(Z),t(cs),t(ms),t(os),t(X),t(hs),t(ds),t(x),t(us),t(_),t(js),t(gs),t(N),t(Ms),t(ys),t(Q),t(fs),t(Js),t(bs),t(V),t(Ts),t(ws),t(Y),t(Us),t(F),t($s),t(Cs),t(Is),t(Rs),t(Zs),t(ks),t(W),t(Xs),t(L),t(vs),t(xs),t(P),t(_s),t(As),t(O),t(Ns),t(qs),t(Qs),t(es)),t(l),j($,s),j(b,s),j(I,s),j(k,s),j(T,s),j(v,s),j(A,s),j(q,s),j(G,s),j(E,s),j(B,s),j(w,s),j(z,s),j(U,s),j(H,s),j(D,s),j(S,s),j(K,s),j(ss,s),j(as,s)}}}const ba=`{"title":"Use with JAX","local":"use-with-jax","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Using with_format('jax')","local":"using-withformatjax","sections":[],"depth":3}],"depth":2}],"depth":1}`;function Ta(f){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ra extends oa{constructor(l){super(),ha(this,l,Ta,Ja,ca,{})}}export{Ra as component};
