import{s as Ba,o as Da,n as ja}from"../chunks/scheduler.bdbef820.js";import{S as Ha,i as La,g as r,s as l,r as c,A as Sa,h as i,f as t,c as n,j as qa,u as h,x as m,k as Ea,y as Aa,a as e,v as o,d,t as u,w as j}from"../chunks/index.c0aea24a.js";import{T as ua}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as M,E as Pa}from"../chunks/EditOnGithub.725ee0c1.js";function Ka(T){let p,J='A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast zero-copy reads from arrays in the dataset to PyTorch tensors.';return{c(){p=r("p"),p.innerHTML=J},l(g){p=i(g,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1bbq9ig"&&(p.innerHTML=J)},m(g,b){e(g,p,b)},p:ja,d(g){g&&t(p)}}}function Oa(T){let p,J=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=r("p"),p.innerHTML=J},l(g){p=i(g,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1go8nao"&&(p.innerHTML=J)},m(g,b){e(g,p,b)},p:ja,d(g){g&&t(p)}}}function st(T){let p,J=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=r("p"),p.innerHTML=J},l(g){p=i(g,"P",{"data-svelte-h":!0}),m(p)!=="svelte-118qika"&&(p.innerHTML=J)},m(g,b){e(g,p,b)},p:ja,d(g){g&&t(p)}}}function at(T){let p,J,g,b,I,ys,$,ga=`This document is a quick introduction to using <code>datasets</code> with PyTorch, with a particular focus on how to get
<code>torch.Tensor</code> objects out of our datasets, and how to use a PyTorch <code>DataLoader</code> and a Hugging Face <code>Dataset</code>
with the best performance.`,bs,R,Ms,C,Ja="By default, datasets return regular python objects: integers, floats, strings, lists, etc.",Ts,k,ya='To get PyTorch tensors instead, you can set the format of the dataset to <code>pytorch</code> using <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.with_format">Dataset.with_format()</a>:',ws,G,fs,w,Us,_,ba="To load the data as tensors on a GPU, specify the <code>device</code> argument:",Is,Z,$s,v,Rs,Q,Ma=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a PyTorch formatted dataset outputs nested lists instead of a single tensor:`,Cs,X,ks,F,Ta="To get a single tensor, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:",Gs,Y,_s,x,Zs,z,wa='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',vs,N,Qs,W,fa="String and binary objects are unchanged, since PyTorch only supports numbers.",Xs,V,Ua='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Fs,f,Ys,q,xs,U,zs,E,Ns,B,Ws,D,Ia='Like <code>torch.utils.data.Dataset</code> objects, a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> can be passed directly to a PyTorch <code>DataLoader</code>:',Vs,H,qs,L,Es,S,$a=`There are several ways you can increase the speed your data is loaded which can save you time, especially if you are working with large datasets.
PyTorch offers parallelized data loading, retrieving batches of indices instead of individually, and streaming to iterate over the dataset without downloading it on disk.`,Bs,A,Ds,P,Ra="You can parallelize data loading with the <code>num_workers</code> argument of a PyTorch <code>DataLoader</code> and get a higher throughput.",Hs,K,Ca=`Under the hood, the <code>DataLoader</code> starts <code>num_workers</code> processes.
Each process reloads the dataset passed to the <code>DataLoader</code> and is used to query examples.
Reloading the dataset inside a worker doesn’t fill up your RAM, since it simply memory-maps the dataset again from your disk.`,Ls,O,Ss,ss,As,as,ka=`Stream a dataset by loading it as an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. This allows you to progressively iterate over a remote dataset without downloading it on disk and or over local data files.
Learn more about which type of dataset is best for your use case in the <a href="./about_mapstyle_vs_iterable">choosing between a regular dataset or an iterable dataset</a> guide.`,Ps,ts,Ga="An iterable dataset from <code>datasets</code> inherits from <code>torch.utils.data.IterableDataset</code> so you can pass it to a <code>torch.utils.data.DataLoader</code>:",Ks,es,Os,ls,_a="If the dataset is split in several shards (i.e. if the dataset consists of multiple data files), then you can stream in parallel using <code>num_workers</code>:",sa,ns,aa,ps,Za="In this case each worker is given a subset of the list of shards to stream from.",ta,rs,ea,is,va='To split your dataset across your training nodes, you can use <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.distributed.split_dataset_by_node">datasets.distributed.split_dataset_by_node()</a>:',la,ms,na,cs,Qa=`This works for both map-style datasets and iterable datasets.
The dataset is split for the node at rank <code>rank</code> in a pool of nodes of size <code>world_size</code>.`,pa,hs,Xa="For map-style datasets:",ra,os,Fa="Each node is assigned a chunk of data, e.g. rank 0 is given the first chunk of the dataset.",ia,ds,Ya="For iterable datasets:",ma,us,xa=`If the dataset has a number of shards that is a factor of <code>world_size</code> (i.e. if <code>dataset.n_shards % world_size == 0</code>),
then the shards are evenly assigned across the nodes, which is the most optimized.
Otherwise, each node keeps 1 example out of <code>world_size</code>, skipping the other examples.`,ca,js,za="This can also be combined with a <code>torch.utils.data.DataLoader</code> if you want each node to use multiple workers to load the data.",ha,gs,oa,Js,da;return I=new M({props:{title:"Use with PyTorch",local:"use-with-pytorch",headingTag:"h1"}}),R=new M({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),G=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}`,wrap:!1}}),w=new ua({props:{$$slots:{default:[Ka]},$$scope:{ctx:T}}}),Z=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>, device=device)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], device=<span class="hljs-string">&#x27;cuda:0&#x27;</span>)}`,wrap:!1}}),v=new M({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: [tensor([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]), tensor([<span class="hljs-number">3</span>, <span class="hljs-number">4</span>])]}`,wrap:!1}}),Y=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
          [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
         [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
          [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])}`,wrap:!1}}),x=new M({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),N=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),f=new ua({props:{$$slots:{default:[Oa]},$$scope:{ctx:T}}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydG9yY2glMjIpJTBBZHMlNUIwJTVEJTVCJTIyaW1hZ2UlMjIlNUQuc2hhcGUlMEFkcyU1QjAlNUQlMEFkcyU1QiUzQTIlNUQlNUIlMjJpbWFnZSUyMiU1RC5zaGFwZSUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=torch.uint8)}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;image&quot;</span>].shape
torch.Size([<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: tensor([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=torch.uint8)}`,wrap:!1}}),U=new ua({props:{$$slots:{default:[st]},$$scope:{ctx:T}}}),E=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRvcmNoJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;torch&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
tensor([ <span class="hljs-number">6.1035e-05</span>,  <span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.6785e-04</span>,  ..., -<span class="hljs-number">1.5259e-05</span>,
        -<span class="hljs-number">1.5259e-05</span>,  <span class="hljs-number">1.5259e-05</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
tensor(<span class="hljs-number">44100</span>)`,wrap:!1}}),B=new M({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),H=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyMCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxNiklMEFsYWJlbCUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kaW50KDAlMkMlMjAyJTJDJTIwc2l6ZSUzRDE2KSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElMkMlMjAlMjJsYWJlbCUyMiUzQSUyMGxhYmVsJTdEKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0Q0KSUwQWZvciUyMGJhdGNoJTIwaW4lMjBkYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoYmF0Y2gpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>label = np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, size=<span class="hljs-number">16</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data, <span class="hljs-string">&quot;label&quot;</span>: label}).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(batch)                                                                                            
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.0047</span>, <span class="hljs-number">0.4979</span>, <span class="hljs-number">0.6726</span>, <span class="hljs-number">0.8105</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.4832</span>, <span class="hljs-number">0.2723</span>, <span class="hljs-number">0.4259</span>, <span class="hljs-number">0.2224</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.5837</span>, <span class="hljs-number">0.3444</span>, <span class="hljs-number">0.4658</span>, <span class="hljs-number">0.6417</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>])}
{<span class="hljs-string">&#x27;data&#x27;</span>: tensor([<span class="hljs-number">0.7022</span>, <span class="hljs-number">0.1225</span>, <span class="hljs-number">0.7228</span>, <span class="hljs-number">0.8259</span>]), <span class="hljs-string">&#x27;label&#x27;</span>: tensor([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>])}`,wrap:!1}}),L=new M({props:{title:"Optimize data loading",local:"optimize-data-loading",headingTag:"h3"}}),A=new M({props:{title:"Use multiple Workers",local:"use-multiple-workers",headingTag:"h4"}}),O=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZnJvbV9kaXNrJTBBZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZGF0YSUyMCUzRCUyMG5wLnJhbmRvbS5yYW5kKDEwXzAwMCklMEFEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCkuc2F2ZV90b19kaXNrKCUyMm15X2RhdGFzZXQlMjIpJTBBZHMlMjAlM0QlMjBsb2FkX2Zyb21fZGlzayglMjJteV9kYXRhc2V0JTIyKS53aXRoX2Zvcm1hdCglMjJ0b3JjaCUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihkcyUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMG51bV93b3JrZXJzJTNENCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_from_disk
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).save_to_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_from_disk(<span class="hljs-string">&quot;my_dataset&quot;</span>).with_format(<span class="hljs-string">&quot;torch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(ds, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),ss=new M({props:{title:"Stream data",local:"stream-data",headingTag:"h3"}}),es=new y({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWRhdGElMjAlM0QlMjBucC5yYW5kb20ucmFuZCgxMF8wMDApJTBBRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpLnB1c2hfdG9faHViKCUyMiUzQ3VzZXJuYW1lJTNFJTJGbXlfZGF0YXNldCUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB0byUyMHRoZSUyMEh1Z2dpbmclMjBGYWNlJTIwSHViJTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjIlM0N1c2VybmFtZSUzRSUyRm15X2RhdGFzZXQlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFkYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihteV9pdGVyYWJsZV9kYXRhc2V0JTJDJTIwYmF0Y2hfc2l6ZSUzRDMyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span>data = np.random.rand(<span class="hljs-number">10_000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}).push_to_hub(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>)  <span class="hljs-comment"># Upload to the Hugging Face Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;&lt;username&gt;/my_dataset&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>)`,wrap:!1}}),ns=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzdHJlYW1pbmclM0RUcnVlJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTBBZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIobXlfaXRlcmFibGVfZGF0YXNldCUyQyUyMGJhdGNoX3NpemUlM0QzMiUyQyUyMG51bV93b3JrZXJzJTNENCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, streaming=<span class="hljs-literal">True</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>my_iterable_dataset.n_shards
<span class="hljs-number">39</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = DataLoader(my_iterable_dataset, batch_size=<span class="hljs-number">32</span>, num_workers=<span class="hljs-number">4</span>)`,wrap:!1}}),rs=new M({props:{title:"Distributed",local:"distributed",headingTag:"h3"}}),ms=new y({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwZGF0YXNldHMuZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBzcGxpdF9kYXRhc2V0X2J5X25vZGUlMEElMEFkcyUyMCUzRCUyMHNwbGl0X2RhdGFzZXRfYnlfbm9kZShkcyUyQyUyMHJhbmslM0RpbnQob3MuZW52aXJvbiU1QiUyMlJBTkslMjIlNUQpJTJDJTIwd29ybGRfc2l6ZSUzRGludChvcy5lbnZpcm9uJTVCJTIyV09STERfU0laRSUyMiU1RCkp",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> datasets.distributed <span class="hljs-keyword">import</span> split_dataset_by_node

ds = split_dataset_by_node(ds, rank=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;RANK&quot;</span>]), world_size=<span class="hljs-built_in">int</span>(os.environ[<span class="hljs-string">&quot;WORLD_SIZE&quot;</span>]))`,wrap:!1}}),gs=new Pa({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/use_with_pytorch.mdx"}}),{c(){p=r("meta"),J=l(),g=r("p"),b=l(),c(I.$$.fragment),ys=l(),$=r("p"),$.innerHTML=ga,bs=l(),c(R.$$.fragment),Ms=l(),C=r("p"),C.textContent=Ja,Ts=l(),k=r("p"),k.innerHTML=ya,ws=l(),c(G.$$.fragment),fs=l(),c(w.$$.fragment),Us=l(),_=r("p"),_.innerHTML=ba,Is=l(),c(Z.$$.fragment),$s=l(),c(v.$$.fragment),Rs=l(),Q=r("p"),Q.textContent=Ma,Cs=l(),c(X.$$.fragment),ks=l(),F=r("p"),F.innerHTML=Ta,Gs=l(),c(Y.$$.fragment),_s=l(),c(x.$$.fragment),Zs=l(),z=r("p"),z.innerHTML=wa,vs=l(),c(N.$$.fragment),Qs=l(),W=r("p"),W.textContent=fa,Xs=l(),V=r("p"),V.innerHTML=Ua,Fs=l(),c(f.$$.fragment),Ys=l(),c(q.$$.fragment),xs=l(),c(U.$$.fragment),zs=l(),c(E.$$.fragment),Ns=l(),c(B.$$.fragment),Ws=l(),D=r("p"),D.innerHTML=Ia,Vs=l(),c(H.$$.fragment),qs=l(),c(L.$$.fragment),Es=l(),S=r("p"),S.textContent=$a,Bs=l(),c(A.$$.fragment),Ds=l(),P=r("p"),P.innerHTML=Ra,Hs=l(),K=r("p"),K.innerHTML=Ca,Ls=l(),c(O.$$.fragment),Ss=l(),c(ss.$$.fragment),As=l(),as=r("p"),as.innerHTML=ka,Ps=l(),ts=r("p"),ts.innerHTML=Ga,Ks=l(),c(es.$$.fragment),Os=l(),ls=r("p"),ls.innerHTML=_a,sa=l(),c(ns.$$.fragment),aa=l(),ps=r("p"),ps.textContent=Za,ta=l(),c(rs.$$.fragment),ea=l(),is=r("p"),is.innerHTML=va,la=l(),c(ms.$$.fragment),na=l(),cs=r("p"),cs.innerHTML=Qa,pa=l(),hs=r("p"),hs.textContent=Xa,ra=l(),os=r("p"),os.textContent=Fa,ia=l(),ds=r("p"),ds.textContent=Ya,ma=l(),us=r("p"),us.innerHTML=xa,ca=l(),js=r("p"),js.innerHTML=za,ha=l(),c(gs.$$.fragment),oa=l(),Js=r("p"),this.h()},l(s){const a=Sa("svelte-u9bgzb",document.head);p=i(a,"META",{name:!0,content:!0}),a.forEach(t),J=n(s),g=i(s,"P",{}),qa(g).forEach(t),b=n(s),h(I.$$.fragment,s),ys=n(s),$=i(s,"P",{"data-svelte-h":!0}),m($)!=="svelte-1116k3w"&&($.innerHTML=ga),bs=n(s),h(R.$$.fragment,s),Ms=n(s),C=i(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-j9f3ms"&&(C.textContent=Ja),Ts=n(s),k=i(s,"P",{"data-svelte-h":!0}),m(k)!=="svelte-wuauow"&&(k.innerHTML=ya),ws=n(s),h(G.$$.fragment,s),fs=n(s),h(w.$$.fragment,s),Us=n(s),_=i(s,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1ezbzoy"&&(_.innerHTML=ba),Is=n(s),h(Z.$$.fragment,s),$s=n(s),h(v.$$.fragment,s),Rs=n(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-hbe3u7"&&(Q.textContent=Ma),Cs=n(s),h(X.$$.fragment,s),ks=n(s),F=i(s,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1nq7c44"&&(F.innerHTML=Ta),Gs=n(s),h(Y.$$.fragment,s),_s=n(s),h(x.$$.fragment,s),Zs=n(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-9al131"&&(z.innerHTML=wa),vs=n(s),h(N.$$.fragment,s),Qs=n(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1hobffv"&&(W.textContent=fa),Xs=n(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1g2r59q"&&(V.innerHTML=Ua),Fs=n(s),h(f.$$.fragment,s),Ys=n(s),h(q.$$.fragment,s),xs=n(s),h(U.$$.fragment,s),zs=n(s),h(E.$$.fragment,s),Ns=n(s),h(B.$$.fragment,s),Ws=n(s),D=i(s,"P",{"data-svelte-h":!0}),m(D)!=="svelte-12en5kh"&&(D.innerHTML=Ia),Vs=n(s),h(H.$$.fragment,s),qs=n(s),h(L.$$.fragment,s),Es=n(s),S=i(s,"P",{"data-svelte-h":!0}),m(S)!=="svelte-nw1d6c"&&(S.textContent=$a),Bs=n(s),h(A.$$.fragment,s),Ds=n(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1wyypch"&&(P.innerHTML=Ra),Hs=n(s),K=i(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1u9vub"&&(K.innerHTML=Ca),Ls=n(s),h(O.$$.fragment,s),Ss=n(s),h(ss.$$.fragment,s),As=n(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-a5l4ib"&&(as.innerHTML=ka),Ps=n(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-1t3p6zv"&&(ts.innerHTML=Ga),Ks=n(s),h(es.$$.fragment,s),Os=n(s),ls=i(s,"P",{"data-svelte-h":!0}),m(ls)!=="svelte-gqi02o"&&(ls.innerHTML=_a),sa=n(s),h(ns.$$.fragment,s),aa=n(s),ps=i(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-i7csup"&&(ps.textContent=Za),ta=n(s),h(rs.$$.fragment,s),ea=n(s),is=i(s,"P",{"data-svelte-h":!0}),m(is)!=="svelte-1xpq9l0"&&(is.innerHTML=va),la=n(s),h(ms.$$.fragment,s),na=n(s),cs=i(s,"P",{"data-svelte-h":!0}),m(cs)!=="svelte-utgciv"&&(cs.innerHTML=Qa),pa=n(s),hs=i(s,"P",{"data-svelte-h":!0}),m(hs)!=="svelte-1a3gkys"&&(hs.textContent=Xa),ra=n(s),os=i(s,"P",{"data-svelte-h":!0}),m(os)!=="svelte-41cx6v"&&(os.textContent=Fa),ia=n(s),ds=i(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-1kujsme"&&(ds.textContent=Ya),ma=n(s),us=i(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-nsc411"&&(us.innerHTML=xa),ca=n(s),js=i(s,"P",{"data-svelte-h":!0}),m(js)!=="svelte-19jtkan"&&(js.innerHTML=za),ha=n(s),h(gs.$$.fragment,s),oa=n(s),Js=i(s,"P",{}),qa(Js).forEach(t),this.h()},h(){Ea(p,"name","hf:doc:metadata"),Ea(p,"content",tt)},m(s,a){Aa(document.head,p),e(s,J,a),e(s,g,a),e(s,b,a),o(I,s,a),e(s,ys,a),e(s,$,a),e(s,bs,a),o(R,s,a),e(s,Ms,a),e(s,C,a),e(s,Ts,a),e(s,k,a),e(s,ws,a),o(G,s,a),e(s,fs,a),o(w,s,a),e(s,Us,a),e(s,_,a),e(s,Is,a),o(Z,s,a),e(s,$s,a),o(v,s,a),e(s,Rs,a),e(s,Q,a),e(s,Cs,a),o(X,s,a),e(s,ks,a),e(s,F,a),e(s,Gs,a),o(Y,s,a),e(s,_s,a),o(x,s,a),e(s,Zs,a),e(s,z,a),e(s,vs,a),o(N,s,a),e(s,Qs,a),e(s,W,a),e(s,Xs,a),e(s,V,a),e(s,Fs,a),o(f,s,a),e(s,Ys,a),o(q,s,a),e(s,xs,a),o(U,s,a),e(s,zs,a),o(E,s,a),e(s,Ns,a),o(B,s,a),e(s,Ws,a),e(s,D,a),e(s,Vs,a),o(H,s,a),e(s,qs,a),o(L,s,a),e(s,Es,a),e(s,S,a),e(s,Bs,a),o(A,s,a),e(s,Ds,a),e(s,P,a),e(s,Hs,a),e(s,K,a),e(s,Ls,a),o(O,s,a),e(s,Ss,a),o(ss,s,a),e(s,As,a),e(s,as,a),e(s,Ps,a),e(s,ts,a),e(s,Ks,a),o(es,s,a),e(s,Os,a),e(s,ls,a),e(s,sa,a),o(ns,s,a),e(s,aa,a),e(s,ps,a),e(s,ta,a),o(rs,s,a),e(s,ea,a),e(s,is,a),e(s,la,a),o(ms,s,a),e(s,na,a),e(s,cs,a),e(s,pa,a),e(s,hs,a),e(s,ra,a),e(s,os,a),e(s,ia,a),e(s,ds,a),e(s,ma,a),e(s,us,a),e(s,ca,a),e(s,js,a),e(s,ha,a),o(gs,s,a),e(s,oa,a),e(s,Js,a),da=!0},p(s,[a]){const Na={};a&2&&(Na.$$scope={dirty:a,ctx:s}),w.$set(Na);const Wa={};a&2&&(Wa.$$scope={dirty:a,ctx:s}),f.$set(Wa);const Va={};a&2&&(Va.$$scope={dirty:a,ctx:s}),U.$set(Va)},i(s){da||(d(I.$$.fragment,s),d(R.$$.fragment,s),d(G.$$.fragment,s),d(w.$$.fragment,s),d(Z.$$.fragment,s),d(v.$$.fragment,s),d(X.$$.fragment,s),d(Y.$$.fragment,s),d(x.$$.fragment,s),d(N.$$.fragment,s),d(f.$$.fragment,s),d(q.$$.fragment,s),d(U.$$.fragment,s),d(E.$$.fragment,s),d(B.$$.fragment,s),d(H.$$.fragment,s),d(L.$$.fragment,s),d(A.$$.fragment,s),d(O.$$.fragment,s),d(ss.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(rs.$$.fragment,s),d(ms.$$.fragment,s),d(gs.$$.fragment,s),da=!0)},o(s){u(I.$$.fragment,s),u(R.$$.fragment,s),u(G.$$.fragment,s),u(w.$$.fragment,s),u(Z.$$.fragment,s),u(v.$$.fragment,s),u(X.$$.fragment,s),u(Y.$$.fragment,s),u(x.$$.fragment,s),u(N.$$.fragment,s),u(f.$$.fragment,s),u(q.$$.fragment,s),u(U.$$.fragment,s),u(E.$$.fragment,s),u(B.$$.fragment,s),u(H.$$.fragment,s),u(L.$$.fragment,s),u(A.$$.fragment,s),u(O.$$.fragment,s),u(ss.$$.fragment,s),u(es.$$.fragment,s),u(ns.$$.fragment,s),u(rs.$$.fragment,s),u(ms.$$.fragment,s),u(gs.$$.fragment,s),da=!1},d(s){s&&(t(J),t(g),t(b),t(ys),t($),t(bs),t(Ms),t(C),t(Ts),t(k),t(ws),t(fs),t(Us),t(_),t(Is),t($s),t(Rs),t(Q),t(Cs),t(ks),t(F),t(Gs),t(_s),t(Zs),t(z),t(vs),t(Qs),t(W),t(Xs),t(V),t(Fs),t(Ys),t(xs),t(zs),t(Ns),t(Ws),t(D),t(Vs),t(qs),t(Es),t(S),t(Bs),t(Ds),t(P),t(Hs),t(K),t(Ls),t(Ss),t(As),t(as),t(Ps),t(ts),t(Ks),t(Os),t(ls),t(sa),t(aa),t(ps),t(ta),t(ea),t(is),t(la),t(na),t(cs),t(pa),t(hs),t(ra),t(os),t(ia),t(ds),t(ma),t(us),t(ca),t(js),t(ha),t(oa),t(Js)),t(p),j(I,s),j(R,s),j(G,s),j(w,s),j(Z,s),j(v,s),j(X,s),j(Y,s),j(x,s),j(N,s),j(f,s),j(q,s),j(U,s),j(E,s),j(B,s),j(H,s),j(L,s),j(A,s),j(O,s),j(ss,s),j(es,s),j(ns,s),j(rs,s),j(ms,s),j(gs,s)}}}const tt='{"title":"Use with PyTorch","local":"use-with-pytorch","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Optimize data loading","local":"optimize-data-loading","sections":[{"title":"Use multiple Workers","local":"use-multiple-workers","sections":[],"depth":4}],"depth":3},{"title":"Stream data","local":"stream-data","sections":[],"depth":3},{"title":"Distributed","local":"distributed","sections":[],"depth":3}],"depth":2}],"depth":1}';function et(T){return Da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mt extends Ha{constructor(p){super(),La(this,p,et,at,Ba,{})}}export{mt as component};
