import{s as qa,o as Fa,n as oa}from"../chunks/scheduler.bdbef820.js";import{S as Na,i as Ga,g as o,s as n,r as c,A as za,h as r,f as t,c as l,j as Qa,u as h,x as i,k as Za,y as Ha,a as e,v as d,d as u,t as f,w as g}from"../chunks/index.c0aea24a.js";import{T as pa}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as U,E as Ea}from"../chunks/EditOnGithub.725ee0c1.js";function Xa(M){let p,j='A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object is a wrapper of an Arrow table, which allows fast reads from arrays in the dataset to TensorFlow tensors.';return{c(){p=o("p"),p.innerHTML=j},l(m){p=r(m,"P",{"data-svelte-h":!0}),i(p)!=="svelte-wyg4b4"&&(p.innerHTML=j)},m(m,b){e(m,p,b)},p:oa,d(m){m&&t(p)}}}function Va(M){let p,j=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> feature type, you’ll need to install the <code>vision</code> extra as
<code>pip install datasets[vision]</code>.`;return{c(){p=o("p"),p.innerHTML=j},l(m){p=r(m,"P",{"data-svelte-h":!0}),i(p)!=="svelte-1go8nao"&&(p.innerHTML=j)},m(m,b){e(m,p,b)},p:oa,d(m){m&&t(p)}}}function Wa(M){let p,j=`To use the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature type, you’ll need to install the <code>audio</code> extra as
<code>pip install datasets[audio]</code>.`;return{c(){p=o("p"),p.innerHTML=j},l(m){p=r(m,"P",{"data-svelte-h":!0}),i(p)!=="svelte-118qika"&&(p.innerHTML=j)},m(m,b){e(m,p,b)},p:oa,d(m){m&&t(p)}}}function Da(M){let p,j,m,b,$,us,C,ra=`This document is a quick introduction to using <code>datasets</code> with TensorFlow, with a particular focus on how to get
<code>tf.Tensor</code> objects out of our datasets, and how to stream data from Hugging Face <code>Dataset</code> objects to Keras methods
like <code>model.fit()</code>.`,fs,R,gs,_,ia="By default, datasets return regular Python objects: integers, floats, strings, lists, etc.",js,I,ma="To get TensorFlow tensors instead, you can set the format of the dataset to <code>tf</code>:",ys,v,bs,T,Ms,k,ca=`This can be useful for converting your dataset to a dict of <code>Tensor</code> objects, or for writing a generator to load TF
samples from it. If you wish to convert the entire dataset to <code>Tensor</code>, simply query the full dataset:`,Ts,x,ws,Q,Js,Z,ha=`If your dataset consists of N-dimensional arrays, you will see that by default they are considered as nested lists.
In particular, a TensorFlow formatted dataset outputs a <code>RaggedTensor</code> instead of a single tensor:`,Us,q,$s,F,da="To get a single tensor, you must explicitly use the <code>Array</code> feature type and specify the shape of your tensors:",Cs,N,Rs,G,_s,z,ua='<a href="/docs/datasets/main/en/package_reference/main_classes#datasets.ClassLabel">ClassLabel</a> data are properly converted to tensors:',Is,H,vs,E,fa="Strings and binary objects are also supported:",ks,X,xs,V,ga="You can also explicitly format certain columns and leave the other columns unformatted:",Qs,W,Zs,D,ja="String and binary objects are unchanged, since PyTorch only supports numbers.",qs,Y,ya='The <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Image">Image</a> and <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Audio">Audio</a> feature types are also supported.',Fs,w,Ns,L,Gs,J,zs,A,Hs,B,Es,S,ba=`Although you can load individual samples and batches just by indexing into your dataset, this won’t work if you want
to use Keras methods like <code>fit()</code> and <code>predict()</code>. You could write a generator function that shuffles and loads batches
from your dataset and <code>fit()</code> on that, but that sounds like a lot of unnecessary work. Instead, if you want to stream
data from your dataset on-the-fly, we recommend converting your dataset to a <code>tf.data.Dataset</code> using the
<code>to_tf_dataset()</code> method.`,Xs,P,Ma=`The <code>tf.data.Dataset</code> class covers a wide range of use-cases - it is often created from Tensors in memory, or using a load function to read files on disc
or external storage. The dataset can be transformed arbitrarily with the <code>map()</code> method, or methods like <code>batch()</code>
and <code>shuffle()</code> can be used to create a dataset that’s ready for training. These methods do not modify the stored data
in any way - instead, the methods build a data pipeline graph that will be executed when the dataset is iterated over,
usually during model training or inference. This is different from the <code>map()</code> method of Hugging Face <code>Dataset</code> objects,
which runs the map function immediately and saves the new or changed columns.`,Vs,K,Ta=`Since the entire data preprocessing pipeline can be compiled in a <code>tf.data.Dataset</code>, this approach allows for massively
parallel, asynchronous data loading and training. However, the requirement for graph compilation can be a limitation,
particularly for Hugging Face tokenizers, which are usually not (yet!) compilable as part of a TF graph. As a result,
we usually advise pre-processing the dataset as a Hugging Face dataset, where arbitrary Python functions can be
used, and then converting to <code>tf.data.Dataset</code> afterwards using <code>to_tf_dataset()</code> to get a batched dataset ready for
training. To see examples of this approach, please see the <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> or <a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a> for <code>transformers</code>.`,Ws,O,Ds,ss,wa="Using <code>to_tf_dataset()</code> is straightforward. Once your dataset is preprocessed and ready, simply call it like so:",Ys,as,Ls,ts,Ja=`The returned <code>tf_ds</code> object here is now fully ready to train on, and can be passed directly to <code>model.fit()</code>. Note
that you set the batch size when creating the dataset, and so you don’t need to specify it when calling <code>fit()</code>:`,As,es,Bs,ns,Ua=`For a full description of the arguments, please see the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.to_tf_dataset">to_tf_dataset()</a> documentation. In many cases,
you will also need to add a <code>collate_fn</code> to your call. This is a function that takes multiple elements of the dataset
and combines them into a single batch. When all elements have the same length, the built-in default collator will
suffice, but for more complex tasks a custom collator may be necessary. In particular, many tasks have samples
with varying sequence lengths which will require a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/data_collator" rel="nofollow">data collator</a> that can pad batches correctly. You can see examples
of this in the <code>transformers</code> NLP <a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">examples</a> and
<a href="https://huggingface.co/docs/transformers/notebooks" rel="nofollow">notebooks</a>, where variable sequence lengths are very common.`,Ss,ls,$a=`If you find that loading with <code>to_tf_dataset</code> is slow, you can also use the <code>num_workers</code> argument. This spins
up multiple subprocesses to load data in parallel. This feature is recent and still somewhat experimental - please file
an issue if you encounter any bugs while using it!`,Ps,ps,Ks,os,Ca=`The astute reader may have noticed at this point that we have offered two approaches to achieve the same goal - if you
want to pass your dataset to a TensorFlow model, you can either convert the dataset to a <code>Tensor</code> or <code>dict</code> of <code>Tensors</code>
using <code>.with_format(&#39;tf&#39;)</code>, or you can convert the dataset to a <code>tf.data.Dataset</code> with <code>to_tf_dataset()</code>. Either of these
can be passed to <code>model.fit()</code>, so which should you choose?`,Os,rs,Ra=`The key thing to recognize is that when you convert the whole dataset to <code>Tensor</code>s, it is static and fully loaded into
RAM. This is simple and convenient, but if any of the following apply, you should probably use <code>to_tf_dataset()</code>
instead:`,sa,is,_a=`<li>Your dataset is too large to fit in RAM. <code>to_tf_dataset()</code> streams only one batch at a time, so even very large
datasets can be handled with this method.</li> <li>You want to apply random transformations using <code>dataset.with_transform()</code> or the <code>collate_fn</code>. This is
common in several modalities, such as image augmentations when training vision models, or random masking when training
masked language models. Using <code>to_tf_dataset()</code> will apply those transformations
at the moment when a batch is loaded, which means the same samples will get different augmentations each time
they are loaded. This is usually what you want.</li> <li>Your data has a variable dimension, such as input texts in NLP that consist of varying
numbers of tokens. When you create a batch with samples with a variable dimension, the standard solution is to
pad the shorter samples to the length of the longest one. When you stream samples from a dataset with <code>to_tf_dataset</code>,
you can apply this padding to each batch via your <code>collate_fn</code>. However, if you want to convert
such a dataset to dense <code>Tensor</code>s, then you will have to pad samples to the length of the longest sample in <em>the
entire dataset!</em> This can result in huge amounts of padding, which wastes memory and reduces your model’s speed.</li>`,aa,ms,ta,cs,Ia="Right now, <code>to_tf_dataset()</code> always returns a batched dataset - we will add support for unbatched datasets soon!",ea,hs,na,ds,la;return $=new U({props:{title:"Using Datasets with TensorFlow",local:"using-datasets-with-tensorflow",headingTag:"h1"}}),R=new U({props:{title:"Dataset format",local:"dataset-format",headingTag:"h2"}}),v=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),T=new pa({props:{$$slots:{default:[Xa]},$$scope:{ctx:M}}}),x=new y({props:{code:"ZHMlNUIlM0ElNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
       [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}`,wrap:!1}}),Q=new U({props:{title:"N-dimensional arrays",local:"n-dimensional-arrays",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyZGF0YSUyMiUzQSUyMGRhdGElN0QpJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiklMEFkcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.RaggedTensor [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>], [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]]&gt;}`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXJyYXkyRCUwQWRhdGElMjAlM0QlMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTVCJTVCNSUyQyUyMDYlNUQlMkMlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyZGF0YSUyMiUzQSUyMEFycmF5MkQoc2hhcGUlM0QoMiUyQyUyMDIpJTJDJTIwZHR5cGUlM0QnaW50MzInKSU3RCklMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmRhdGElMjIlM0ElMjBkYXRhJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUwQWRzJTVCMCU1RCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Array2D
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],[[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],[<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;data&quot;</span>: Array2D(shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=<span class="hljs-string">&#x27;int32&#x27;</span>)})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;data&quot;</span>: data}, features=features)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
        [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]])&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>), dtype=int64, numpy=
 array([[[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],
         [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]],
 
        [[<span class="hljs-number">5</span>, <span class="hljs-number">6</span>],
         [<span class="hljs-number">7</span>, <span class="hljs-number">8</span>]]])&gt;}`,wrap:!1}}),G=new U({props:{title:"Other feature types",local:"other-feature-types",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQ2xhc3NMYWJlbCUwQWxhYmVscyUyMCUzRCUyMCU1QjAlMkMlMjAwJTJDJTIwMSU1RCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIybGFiZWwlMjIlM0ElMjBDbGFzc0xhYmVsKG5hbWVzJTNEJTVCJTIybmVnYXRpdmUlMjIlMkMlMjAlMjJwb3NpdGl2ZSUyMiU1RCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJsYWJlbCUyMiUzQSUyMGxhYmVscyU3RCUyQyUyMGZlYXR1cmVzJTNEZmVhdHVyZXMpJTIwJTBBZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiklMjAlMjAlMEFkcyU1QiUzQTMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, ClassLabel
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;label&quot;</span>: ClassLabel(names=[<span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;positive&quot;</span>])})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;label&quot;</span>: labels}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">3</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTIwJTBBdGV4dCUyMCUzRCUyMCU1QiUyMmZvbyUyMiUyQyUyMCUyMmJhciUyMiU1RCUwQWRhdGElMjAlM0QlMjAlNUIwJTJDJTIwMSU1RCUyMCUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIydGV4dCUyMiUzQSUyMHRleHQlMkMlMjAlMjJkYXRhJTIyJTNBJTIwZGF0YSU3RCklMjAlMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUwQWRzJTVCJTNBMiU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features 
<span class="hljs-meta">&gt;&gt;&gt; </span>text = [<span class="hljs-string">&quot;foo&quot;</span>, <span class="hljs-string">&quot;bar&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>data = [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>] 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;text&quot;</span>: text, <span class="hljs-string">&quot;data&quot;</span>: data})  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;text&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=string, numpy=array([<span class="hljs-string">b&#x27;foo&#x27;</span>, <span class="hljs-string">b&#x27;bar&#x27;</span>], dtype=<span class="hljs-built_in">object</span>)&gt;,
 <span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;}`,wrap:!1}}),W=new y({props:{code:"ZHMlMjAlM0QlMjBkcy53aXRoX2Zvcm1hdCglMjJ0ZiUyMiUyQyUyMGNvbHVtbnMlM0QlNUIlMjJkYXRhJTIyJTVEJTJDJTIwb3V0cHV0X2FsbF9jb2x1bW5zJTNEVHJ1ZSklMEFkcyU1QiUzQTIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>, columns=[<span class="hljs-string">&quot;data&quot;</span>], output_all_columns=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;data&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>,), dtype=int64, numpy=array([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])&gt;,
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;foo&#x27;</span>, <span class="hljs-string">&#x27;bar&#x27;</span>]}`,wrap:!1}}),w=new pa({props:{$$slots:{default:[Va]},$$scope:{ctx:M}}}),L=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWltYWdlcyUyMCUzRCUyMCU1QiUyMnBhdGglMkZ0byUyRmltYWdlLnBuZyUyMiU1RCUyMColMjAxMCUwQWZlYXR1cmVzJTIwJTNEJTIwRmVhdHVyZXMoJTdCJTIyaW1hZ2UlMjIlM0ElMjBJbWFnZSgpJTdEKSUwQWRzJTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZXMlN0QlMkMlMjBmZWF0dXJlcyUzRGZlYXR1cmVzKSUyMCUwQWRzJTIwJTNEJTIwZHMud2l0aF9mb3JtYXQoJTIydGYlMjIpJTIwJTIwJTBBZHMlNUIwJTVEJTBBZHMlNUIlM0EyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>images = [<span class="hljs-string">&quot;path/to/image.png&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;image&quot;</span>: Image()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;image&quot;</span>: images}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
         ...,
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
         [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]], dtype=uint8)&gt;}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[:<span class="hljs-number">2</span>]
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;tf.Tensor: shape=(<span class="hljs-number">2</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>, <span class="hljs-number">4</span>), dtype=uint8, numpy=
 array([[[[<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">215</span>, <span class="hljs-number">106</span>, <span class="hljs-number">255</span>],
          ...,
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
          [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>]]]], dtype=uint8)&gt;}`,wrap:!1}}),J=new pa({props:{$$slots:{default:[Wa]},$$scope:{ctx:M}}}),A=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUyQyUyMEZlYXR1cmVzJTJDJTIwQXVkaW8lMkMlMjBJbWFnZSUwQWF1ZGlvJTIwJTNEJTIwJTVCJTIycGF0aCUyRnRvJTJGYXVkaW8ud2F2JTIyJTVEJTIwKiUyMDEwJTBBZmVhdHVyZXMlMjAlM0QlMjBGZWF0dXJlcyglN0IlMjJhdWRpbyUyMiUzQSUyMEF1ZGlvKCklN0QpJTBBZHMlMjAlM0QlMjBEYXRhc2V0LmZyb21fZGljdCglN0IlMjJhdWRpbyUyMiUzQSUyMGF1ZGlvJTdEJTJDJTIwZmVhdHVyZXMlM0RmZWF0dXJlcyklMjAlMEFkcyUyMCUzRCUyMGRzLndpdGhfZm9ybWF0KCUyMnRmJTIyKSUyMCUyMCUwQWRzJTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMEFkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset, Features, Audio, Image
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = [<span class="hljs-string">&quot;path/to/audio.wav&quot;</span>] * <span class="hljs-number">10</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>features = Features({<span class="hljs-string">&quot;audio&quot;</span>: Audio()})
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict({<span class="hljs-string">&quot;audio&quot;</span>: audio}, features=features) 
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = ds.with_format(<span class="hljs-string">&quot;tf&quot;</span>)  
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>]
&lt;tf.Tensor: shape=(<span class="hljs-number">202311</span>,), dtype=float32, numpy=
array([ <span class="hljs-number">6.1035156e-05</span>,  <span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.6784668e-04</span>, ...,
       -<span class="hljs-number">1.5258789e-05</span>, -<span class="hljs-number">1.5258789e-05</span>,  <span class="hljs-number">1.5258789e-05</span>], dtype=float32)&gt;
<span class="hljs-meta">&gt;&gt;&gt; </span>ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;sampling_rate&quot;</span>]
&lt;tf.Tensor: shape=(), dtype=int32, numpy=<span class="hljs-number">44100</span>&gt;`,wrap:!1}}),B=new U({props:{title:"Data loading",local:"data-loading",headingTag:"h2"}}),O=new U({props:{title:"Using to_tf_dataset()",local:"using-totfdataset",headingTag:"h3"}}),as=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQWRhdGElMjAlM0QlMjAlN0IlMjJpbnB1dHMlMjIlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTIybGFiZWxzJTIyJTNBJTIwJTVCMCUyQyUyMDElNUQlN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGRhdGEpJTBBdGZfZHMlMjAlM0QlMjBkcy50b190Zl9kYXRhc2V0KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-meta">&gt;&gt;&gt; </span>data = {<span class="hljs-string">&quot;inputs&quot;</span>: [[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>],[<span class="hljs-number">3</span>, <span class="hljs-number">4</span>]], <span class="hljs-string">&quot;labels&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(data)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_ds = ds.to_tf_dataset(
            columns=[<span class="hljs-string">&quot;inputs&quot;</span>],
            label_cols=[<span class="hljs-string">&quot;labels&quot;</span>],
            batch_size=<span class="hljs-number">2</span>,
            shuffle=<span class="hljs-literal">True</span>
            )`,wrap:!1}}),es=new y({props:{code:"bW9kZWwuZml0KHRmX2RzJTJDJTIwZXBvY2hzJTNEMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_ds, epochs=<span class="hljs-number">2</span>)',wrap:!1}}),ps=new U({props:{title:"When to use to_tf_dataset",local:"when-to-use-totfdataset",headingTag:"h3"}}),ms=new U({props:{title:"Caveats and limitations",local:"caveats-and-limitations",headingTag:"h3"}}),hs=new Ea({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/use_with_tensorflow.mdx"}}),{c(){p=o("meta"),j=n(),m=o("p"),b=n(),c($.$$.fragment),us=n(),C=o("p"),C.innerHTML=ra,fs=n(),c(R.$$.fragment),gs=n(),_=o("p"),_.textContent=ia,js=n(),I=o("p"),I.innerHTML=ma,ys=n(),c(v.$$.fragment),bs=n(),c(T.$$.fragment),Ms=n(),k=o("p"),k.innerHTML=ca,Ts=n(),c(x.$$.fragment),ws=n(),c(Q.$$.fragment),Js=n(),Z=o("p"),Z.innerHTML=ha,Us=n(),c(q.$$.fragment),$s=n(),F=o("p"),F.innerHTML=da,Cs=n(),c(N.$$.fragment),Rs=n(),c(G.$$.fragment),_s=n(),z=o("p"),z.innerHTML=ua,Is=n(),c(H.$$.fragment),vs=n(),E=o("p"),E.textContent=fa,ks=n(),c(X.$$.fragment),xs=n(),V=o("p"),V.textContent=ga,Qs=n(),c(W.$$.fragment),Zs=n(),D=o("p"),D.textContent=ja,qs=n(),Y=o("p"),Y.innerHTML=ya,Fs=n(),c(w.$$.fragment),Ns=n(),c(L.$$.fragment),Gs=n(),c(J.$$.fragment),zs=n(),c(A.$$.fragment),Hs=n(),c(B.$$.fragment),Es=n(),S=o("p"),S.innerHTML=ba,Xs=n(),P=o("p"),P.innerHTML=Ma,Vs=n(),K=o("p"),K.innerHTML=Ta,Ws=n(),c(O.$$.fragment),Ds=n(),ss=o("p"),ss.innerHTML=wa,Ys=n(),c(as.$$.fragment),Ls=n(),ts=o("p"),ts.innerHTML=Ja,As=n(),c(es.$$.fragment),Bs=n(),ns=o("p"),ns.innerHTML=Ua,Ss=n(),ls=o("p"),ls.innerHTML=$a,Ps=n(),c(ps.$$.fragment),Ks=n(),os=o("p"),os.innerHTML=Ca,Os=n(),rs=o("p"),rs.innerHTML=Ra,sa=n(),is=o("ul"),is.innerHTML=_a,aa=n(),c(ms.$$.fragment),ta=n(),cs=o("p"),cs.innerHTML=Ia,ea=n(),c(hs.$$.fragment),na=n(),ds=o("p"),this.h()},l(s){const a=za("svelte-u9bgzb",document.head);p=r(a,"META",{name:!0,content:!0}),a.forEach(t),j=l(s),m=r(s,"P",{}),Qa(m).forEach(t),b=l(s),h($.$$.fragment,s),us=l(s),C=r(s,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1131e0q"&&(C.innerHTML=ra),fs=l(s),h(R.$$.fragment,s),gs=l(s),_=r(s,"P",{"data-svelte-h":!0}),i(_)!=="svelte-ej8pz8"&&(_.textContent=ia),js=l(s),I=r(s,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1jvz2h"&&(I.innerHTML=ma),ys=l(s),h(v.$$.fragment,s),bs=l(s),h(T.$$.fragment,s),Ms=l(s),k=r(s,"P",{"data-svelte-h":!0}),i(k)!=="svelte-1sidsxe"&&(k.innerHTML=ca),Ts=l(s),h(x.$$.fragment,s),ws=l(s),h(Q.$$.fragment,s),Js=l(s),Z=r(s,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-zqzaaa"&&(Z.innerHTML=ha),Us=l(s),h(q.$$.fragment,s),$s=l(s),F=r(s,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1nq7c44"&&(F.innerHTML=da),Cs=l(s),h(N.$$.fragment,s),Rs=l(s),h(G.$$.fragment,s),_s=l(s),z=r(s,"P",{"data-svelte-h":!0}),i(z)!=="svelte-9al131"&&(z.innerHTML=ua),Is=l(s),h(H.$$.fragment,s),vs=l(s),E=r(s,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1tbbgzx"&&(E.textContent=fa),ks=l(s),h(X.$$.fragment,s),xs=l(s),V=r(s,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1p3x5ww"&&(V.textContent=ga),Qs=l(s),h(W.$$.fragment,s),Zs=l(s),D=r(s,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1hobffv"&&(D.textContent=ja),qs=l(s),Y=r(s,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1g2r59q"&&(Y.innerHTML=ya),Fs=l(s),h(w.$$.fragment,s),Ns=l(s),h(L.$$.fragment,s),Gs=l(s),h(J.$$.fragment,s),zs=l(s),h(A.$$.fragment,s),Hs=l(s),h(B.$$.fragment,s),Es=l(s),S=r(s,"P",{"data-svelte-h":!0}),i(S)!=="svelte-sac77h"&&(S.innerHTML=ba),Xs=l(s),P=r(s,"P",{"data-svelte-h":!0}),i(P)!=="svelte-p0plz9"&&(P.innerHTML=Ma),Vs=l(s),K=r(s,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1nyo297"&&(K.innerHTML=Ta),Ws=l(s),h(O.$$.fragment,s),Ds=l(s),ss=r(s,"P",{"data-svelte-h":!0}),i(ss)!=="svelte-lj7mpl"&&(ss.innerHTML=wa),Ys=l(s),h(as.$$.fragment,s),Ls=l(s),ts=r(s,"P",{"data-svelte-h":!0}),i(ts)!=="svelte-j57oqq"&&(ts.innerHTML=Ja),As=l(s),h(es.$$.fragment,s),Bs=l(s),ns=r(s,"P",{"data-svelte-h":!0}),i(ns)!=="svelte-1b9y1mi"&&(ns.innerHTML=Ua),Ss=l(s),ls=r(s,"P",{"data-svelte-h":!0}),i(ls)!=="svelte-iqwe7b"&&(ls.innerHTML=$a),Ps=l(s),h(ps.$$.fragment,s),Ks=l(s),os=r(s,"P",{"data-svelte-h":!0}),i(os)!=="svelte-s09fia"&&(os.innerHTML=Ca),Os=l(s),rs=r(s,"P",{"data-svelte-h":!0}),i(rs)!=="svelte-1l92k1p"&&(rs.innerHTML=Ra),sa=l(s),is=r(s,"UL",{"data-svelte-h":!0}),i(is)!=="svelte-1no32rr"&&(is.innerHTML=_a),aa=l(s),h(ms.$$.fragment,s),ta=l(s),cs=r(s,"P",{"data-svelte-h":!0}),i(cs)!=="svelte-15wdpsm"&&(cs.innerHTML=Ia),ea=l(s),h(hs.$$.fragment,s),na=l(s),ds=r(s,"P",{}),Qa(ds).forEach(t),this.h()},h(){Za(p,"name","hf:doc:metadata"),Za(p,"content",Ya)},m(s,a){Ha(document.head,p),e(s,j,a),e(s,m,a),e(s,b,a),d($,s,a),e(s,us,a),e(s,C,a),e(s,fs,a),d(R,s,a),e(s,gs,a),e(s,_,a),e(s,js,a),e(s,I,a),e(s,ys,a),d(v,s,a),e(s,bs,a),d(T,s,a),e(s,Ms,a),e(s,k,a),e(s,Ts,a),d(x,s,a),e(s,ws,a),d(Q,s,a),e(s,Js,a),e(s,Z,a),e(s,Us,a),d(q,s,a),e(s,$s,a),e(s,F,a),e(s,Cs,a),d(N,s,a),e(s,Rs,a),d(G,s,a),e(s,_s,a),e(s,z,a),e(s,Is,a),d(H,s,a),e(s,vs,a),e(s,E,a),e(s,ks,a),d(X,s,a),e(s,xs,a),e(s,V,a),e(s,Qs,a),d(W,s,a),e(s,Zs,a),e(s,D,a),e(s,qs,a),e(s,Y,a),e(s,Fs,a),d(w,s,a),e(s,Ns,a),d(L,s,a),e(s,Gs,a),d(J,s,a),e(s,zs,a),d(A,s,a),e(s,Hs,a),d(B,s,a),e(s,Es,a),e(s,S,a),e(s,Xs,a),e(s,P,a),e(s,Vs,a),e(s,K,a),e(s,Ws,a),d(O,s,a),e(s,Ds,a),e(s,ss,a),e(s,Ys,a),d(as,s,a),e(s,Ls,a),e(s,ts,a),e(s,As,a),d(es,s,a),e(s,Bs,a),e(s,ns,a),e(s,Ss,a),e(s,ls,a),e(s,Ps,a),d(ps,s,a),e(s,Ks,a),e(s,os,a),e(s,Os,a),e(s,rs,a),e(s,sa,a),e(s,is,a),e(s,aa,a),d(ms,s,a),e(s,ta,a),e(s,cs,a),e(s,ea,a),d(hs,s,a),e(s,na,a),e(s,ds,a),la=!0},p(s,[a]){const va={};a&2&&(va.$$scope={dirty:a,ctx:s}),T.$set(va);const ka={};a&2&&(ka.$$scope={dirty:a,ctx:s}),w.$set(ka);const xa={};a&2&&(xa.$$scope={dirty:a,ctx:s}),J.$set(xa)},i(s){la||(u($.$$.fragment,s),u(R.$$.fragment,s),u(v.$$.fragment,s),u(T.$$.fragment,s),u(x.$$.fragment,s),u(Q.$$.fragment,s),u(q.$$.fragment,s),u(N.$$.fragment,s),u(G.$$.fragment,s),u(H.$$.fragment,s),u(X.$$.fragment,s),u(W.$$.fragment,s),u(w.$$.fragment,s),u(L.$$.fragment,s),u(J.$$.fragment,s),u(A.$$.fragment,s),u(B.$$.fragment,s),u(O.$$.fragment,s),u(as.$$.fragment,s),u(es.$$.fragment,s),u(ps.$$.fragment,s),u(ms.$$.fragment,s),u(hs.$$.fragment,s),la=!0)},o(s){f($.$$.fragment,s),f(R.$$.fragment,s),f(v.$$.fragment,s),f(T.$$.fragment,s),f(x.$$.fragment,s),f(Q.$$.fragment,s),f(q.$$.fragment,s),f(N.$$.fragment,s),f(G.$$.fragment,s),f(H.$$.fragment,s),f(X.$$.fragment,s),f(W.$$.fragment,s),f(w.$$.fragment,s),f(L.$$.fragment,s),f(J.$$.fragment,s),f(A.$$.fragment,s),f(B.$$.fragment,s),f(O.$$.fragment,s),f(as.$$.fragment,s),f(es.$$.fragment,s),f(ps.$$.fragment,s),f(ms.$$.fragment,s),f(hs.$$.fragment,s),la=!1},d(s){s&&(t(j),t(m),t(b),t(us),t(C),t(fs),t(gs),t(_),t(js),t(I),t(ys),t(bs),t(Ms),t(k),t(Ts),t(ws),t(Js),t(Z),t(Us),t($s),t(F),t(Cs),t(Rs),t(_s),t(z),t(Is),t(vs),t(E),t(ks),t(xs),t(V),t(Qs),t(Zs),t(D),t(qs),t(Y),t(Fs),t(Ns),t(Gs),t(zs),t(Hs),t(Es),t(S),t(Xs),t(P),t(Vs),t(K),t(Ws),t(Ds),t(ss),t(Ys),t(Ls),t(ts),t(As),t(Bs),t(ns),t(Ss),t(ls),t(Ps),t(Ks),t(os),t(Os),t(rs),t(sa),t(is),t(aa),t(ta),t(cs),t(ea),t(na),t(ds)),t(p),g($,s),g(R,s),g(v,s),g(T,s),g(x,s),g(Q,s),g(q,s),g(N,s),g(G,s),g(H,s),g(X,s),g(W,s),g(w,s),g(L,s),g(J,s),g(A,s),g(B,s),g(O,s),g(as,s),g(es,s),g(ps,s),g(ms,s),g(hs,s)}}}const Ya='{"title":"Using Datasets with TensorFlow","local":"using-datasets-with-tensorflow","sections":[{"title":"Dataset format","local":"dataset-format","sections":[],"depth":2},{"title":"N-dimensional arrays","local":"n-dimensional-arrays","sections":[],"depth":2},{"title":"Other feature types","local":"other-feature-types","sections":[],"depth":2},{"title":"Data loading","local":"data-loading","sections":[{"title":"Using to_tf_dataset()","local":"using-totfdataset","sections":[],"depth":3},{"title":"When to use to_tf_dataset","local":"when-to-use-totfdataset","sections":[],"depth":3},{"title":"Caveats and limitations","local":"caveats-and-limitations","sections":[],"depth":3}],"depth":2}],"depth":1}';function La(M){return Fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Oa extends Na{constructor(p){super(),Ga(this,p,La,Da,qa,{})}}export{Oa as component};
