import{s as xa,n as Qa,o as Wa}from"../chunks/scheduler.bdbef820.js";import{S as Na,i as Da,g as i,s as l,r as p,A as Sa,h as r,f as s,c as n,j as va,u as d,x as f,k as za,y as Ha,a as t,v as c,d as m,t as o,w as h}from"../chunks/index.c0aea24a.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as u,E as Ea}from"../chunks/EditOnGithub.725ee0c1.js";function Aa(ha){let M,ye,he,Me,w,ue,b,fa=`There are two types of dataset objects, a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
Whichever type of dataset you choose to use or create depends on the size of the dataset.
In general, an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is ideal for big datasets (think hundreds of GBs!) due to its lazy behavior and speed advantages, while a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> is great for everything else.
This page will compare the differences between a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> to help you pick the right dataset object for you.`,we,j,be,J,ya=`When you have a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, you can access it using <code>my_dataset[0]</code>. This provides random access to the rows.
Such datasets are also called “map-style” datasets.
For example you can download ImageNet-1k like this and access any row:`,je,T,Je,_,Ma=`But one caveat is that you must have the entire dataset stored on your disk or in memory, which blocks you from accessing datasets bigger than the disk.
Because it can become inconvenient for big datasets, there exists another type of dataset, the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.
When you have an <code>IterableDataset</code>, you can access it using a <code>for</code> loop to load the data progressively as you iterate over the dataset.
This way, only a small fraction of examples is loaded in memory, and you don’t write anything on disk.`,Te,U,ua="For example, you can stream the ImageNet-1k dataset without downloading it on disk:",_e,g,Ue,Z,wa=`Streaming can read online data without writing any file to disk.
For example, you can stream datasets made out of multiple shards, each of which is hundreds of gigabytes like <a href="https://huggingface.co/datasets/c4" rel="nofollow">C4</a>, <a href="https://huggingface.co/datasets/oscar" rel="nofollow">OSCAR</a> or <a href="https://huggingface.co/datasets/laion/laion2B-en" rel="nofollow">LAION-2B</a>.
Learn more about how to stream a dataset in the <a href="./stream">Dataset Streaming Guide</a>.`,ge,X,ba="This is not the only difference though, because the “lazy” behavior of an <code>IterableDataset</code> is also present when it comes to dataset creation and processing.",Ze,I,Xe,k,ja='You can create a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using lists or dictionaries, and the data is entirely converted to Arrow so you can easily access any row:',Ie,G,ke,C,Ja=`To create an <code>IterableDataset</code> on the other hand, you must provide a “lazy” way to load the data.
In Python, we generally use generator functions. These functions <code>yield</code> one example at a time, which means you can’t access a row by slicing it like a regular <code>Dataset</code>:`,Ge,$,Ce,V,$e,R,Ta='It is possible to convert local or remote data files to an Arrow <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Ve,B,Re,F,_a="However, this requires a conversion step from CSV to Arrow format, which takes time and disk space if your dataset is big.",Be,Y,Ua=`To save disk space and skip the conversion step, you can define an <code>IterableDataset</code> by streaming from the local files directly.
This way, the data is read progressively from the local files as you iterate over the dataset:`,Fe,v,Ye,z,ga=`Many file formats are supported, like CSV, JSONL, and Parquet, as well as image and audio files.
You can find more information in the corresponding guides for loading <a href="./tabular_load">tabular</a>, <a href="./nlp_load">text</a>, <a href="./image_load">vision</a>, and <a href="./audio_load%5D">audio</a> datasets.`,ve,x,ze,Q,Za=`When you process a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object using <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map">Dataset.map()</a>, the entire dataset is processed immediately and returned.
This is similar to how <code>pandas</code> works for example.`,xe,W,Qe,N,Xa=`On the other hand, due to the “lazy” nature of an <code>IterableDataset</code>, calling <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.map">IterableDataset.map()</a> does not apply your <code>map</code> function over the full dataset.
Instead, your <code>map</code> function is applied on-the-fly.`,We,D,Ia="Because of that, you can chain multiple processing steps and they will all run at once when you start iterating over the dataset:",Ne,S,De,H,Se,E,ka=`When you shuffle a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> using <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a>, you apply an exact shuffling of the dataset.
It works by taking a list of indices <code>[0, 1, 2, ... len(my_dataset) - 1]</code> and shuffling this list.
Then, accessing <code>my_dataset[0]</code> returns the row and index defined by the first element of the indices mapping that has been shuffled:`,He,A,Ee,q,Ga=`Since we don’t have random access to the rows in the case of an <code>IterableDataset</code>, we can’t use a shuffled list of indices and access a row at an arbitrary position.
This prevents the use of exact shuffling.
Instead, a fast approximate shuffling is used in <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It uses a shuffle buffer to sample random examples iteratively from the dataset.
Since the dataset is still read iteratively, it provides excellent speed performance:`,Ae,L,qe,P,Ca='But using a shuffle buffer is not enough to provide a satisfactory shuffling for machine learning model training. So <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a> also shuffles the dataset shards if your dataset is made of multiple files or sources:',Le,K,Pe,O,Ke,ee,$a=`Regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> objects are based on Arrow which provides fast random access to the rows.
Thanks to memory mapping and the fact that Arrow is an in-memory format, reading data from disk doesn’t do expensive system calls and deserialization.
It provides even faster data loading when iterating using a <code>for</code> loop by iterating on contiguous Arrow record batches.`,Oe,ae,Va=`However as soon as your <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> has an indices mapping (via <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.shuffle">Dataset.shuffle()</a> for example), the speed can become 10x slower.
This is because there is an extra step to get the row index to read using the indices mapping, and most importantly, you aren’t reading contiguous chunks of data anymore.
To restore the speed, you’d need to rewrite the entire dataset on your disk again using <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.flatten_indices">Dataset.flatten_indices()</a>, which removes the indices mapping.
This may take a lot of time depending of the size of your dataset though:`,ea,se,aa,te,Ra=`In this case, we recommend switching to an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> and leveraging its fast approximate shuffling method <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.shuffle">IterableDataset.shuffle()</a>.
It only shuffles the shards order and adds a shuffle buffer to your dataset, which keeps the speed of your dataset optimal.
You can also reshuffle the dataset easily:`,sa,le,ta,ne,Ba=`If you’re using your dataset on multiple epochs, the effective seed to shuffle the shards order in the shuffle buffer is <code>seed + epoch</code>.
It makes it easy to reshuffle a dataset between epochs:`,la,ie,na,re,ia,pe,Fa='If you want to benefit from the “lazy” behavior of an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> or their speed advantages, you can switch your map-style <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> to an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',ra,de,pa,ce,Ya='If you want to shuffle your dataset or <a href="./use_with_pytorch#stream-data">use it with a PyTorch DataLoader</a>, we recommend generating a sharded <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',da,me,ca,oe,ma,fe,oa;return w=new u({props:{title:"Differences between Dataset and IterableDataset",local:"differences-between-dataset-and-iterabledataset",headingTag:"h1"}}),j=new u({props:{title:"Downloading and streaming",local:"downloading-and-streaming",headingTag:"h2"}}),T=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUyMCUyMCUyMyUyMGRvd25sb2FkcyUyMHRoZSUyMGZ1bGwlMjBkYXRhc2V0JTBBcHJpbnQoaW1hZ2VuZXQlNUIwJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)  <span class="hljs-comment"># downloads the full dataset</span>
<span class="hljs-built_in">print</span>(imagenet[<span class="hljs-number">0</span>])`,wrap:!1}}),g=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaW1hZ2VuZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1hZ2VuZXQtMWslMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMjAlMjAlMjMlMjB3aWxsJTIwc3RhcnQlMjBsb2FkaW5nJTIwdGhlJTIwZGF0YSUyMHdoZW4lMjBpdGVyYXRlZCUyMG92ZXIlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBpbWFnZW5ldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

imagenet = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)  <span class="hljs-comment"># will start loading the data when iterated over</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> imagenet:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),I=new u({props:{title:"Creating map-style datasets and iterable datasets",local:"creating-map-style-datasets-and-iterable-datasets",headingTag:"h2"}}),G=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KCU3QiUyMmNvbF8xJTIyJTNBJTIwJTVCMCUyQyUyMDElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMkMlMjA1JTJDJTIwNiUyQyUyMDclMkMlMjA4JTJDJTIwOSU1RCU3RCklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = Dataset.from_dict({<span class="hljs-string">&quot;col_1&quot;</span>: [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>]})
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),$=new y({props:{code:"ZGVmJTIwbXlfZ2VuZXJhdG9yKG4pJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMCU3QiUyMmNvbF8xJTIyJTNBJTIwaSU3RCUwQSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRCU3QiUyMm4lMjIlM0ElMjAxMCU3RCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n</span>):
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
        <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;col_1&quot;</span>: i}

my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs={<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>})
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),V=new u({props:{title:"Loading local files entirely and progressively",local:"loading-local-files-entirely-and-progressively",headingTag:"h2"}}),B=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),v=new y({props:{code:"ZGF0YV9maWxlcyUyMCUzRCUyMCU3QiUyMnRyYWluJTIyJTNBJTIwJTVCJTIycGF0aCUyRnRvJTJGZGF0YS5jc3YlMjIlNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwbXlfaXRlcmFibGVfZGF0YXNldCUzQSUyMCUyMCUyMyUyMHRoaXMlMjByZWFkcyUyMHRoZSUyMENTViUyMGZpbGUlMjBwcm9ncmVzc2l2ZWx5JTIwYXMlMjB5b3UlMjBpdGVyYXRlJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">&quot;path/to/data.csv&quot;</span>]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># this reads the CSV file progressively as you iterate over the dataset</span>
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),x=new u({props:{title:"Eager data processing and lazy data processing",local:"eager-data-processing-and-lazy-data-processing",headingTag:"h2"}}),W=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQubWFwKHByb2Nlc3NfZm4pJTIwJTIwJTIzJTIwcHJvY2Vzc19mbiUyMGlzJTIwYXBwbGllZCUyMG9uJTIwYWxsJTIwdGhlJTIwZXhhbXBsZXMlMjBvZiUyMHRoZSUyMGRhdGFzZXQlMEFwcmludChteV9kYXRhc2V0JTVCMCU1RCk=",highlighted:`my_dataset = my_dataset.<span class="hljs-built_in">map</span>(process_fn)  <span class="hljs-comment"># process_fn is applied on all the examples of the dataset</span>
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),S=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQubWFwKHByb2Nlc3NfZm5fMSklMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5maWx0ZXIoZmlsdGVyX2ZuKSUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0Lm1hcChwcm9jZXNzX2ZuXzIpJTBBJTBBJTIzJTIwcHJvY2Vzc19mbl8xJTJDJTIwZmlsdGVyX2ZuJTIwYW5kJTIwcHJvY2Vzc19mbl8yJTIwYXJlJTIwYXBwbGllZCUyMG9uLXRoZS1mbHklMjB3aGVuJTIwaXRlcmF0aW5nJTIwb3ZlciUyMHRoZSUyMGRhdGFzZXQlMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTIwJTIwJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_1)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">filter</span>(filter_fn)
my_iterable_dataset = my_iterable_dataset.<span class="hljs-built_in">map</span>(process_fn_2)

<span class="hljs-comment"># process_fn_1, filter_fn and process_fn_2 are applied on-the-fly when iterating over the dataset</span>
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),H=new u({props:{title:"Exact and fast approximate shuffling",local:"exact-and-fast-approximate-shuffling",headingTag:"h2"}}),A=new y({props:{code:"bXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBcHJpbnQobXlfZGF0YXNldCU1QjAlNUQp",highlighted:`my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
<span class="hljs-built_in">print</span>(my_dataset[<span class="hljs-number">0</span>])`,wrap:!1}}),L=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIlMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBteV9pdGVyYWJsZV9kYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZXhhbXBsZSklMEElMjAlMjAlMjAlMjBicmVhaw==",highlighted:`my_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)
<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:
    <span class="hljs-built_in">print</span>(example)
    <span class="hljs-keyword">break</span>`,wrap:!1}}),K=new y({props:{code:"JTIzJTIwU3RyZWFtJTIwZnJvbSUyMHRoZSUyMGludGVybmV0JTBBbXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJkZWVwbWluZCUyRmNvZGVfY29udGVzdHMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMzklMEElMEElMjMlMjBTdHJlYW0lMjBmcm9tJTIwbG9jYWwlMjBmaWxlcyUwQWRhdGFfZmlsZXMlMjAlM0QlMjAlN0IlMjJ0cmFpbiUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QuY3N2JTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAyNCklNUQlN0QlMEFteV9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmNzdiUyMiUyQyUyMGRhdGFfZmlsZXMlM0RkYXRhX2ZpbGVzJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQlMEElMEElMjMlMjBGcm9tJTIwYSUyMGdlbmVyYXRvciUyMGZ1bmN0aW9uJTBBZGVmJTIwbXlfZ2VuZXJhdG9yKG4lMkMlMjBzb3VyY2VzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMHNvdXJjZSUyMGluJTIwc291cmNlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGVfaWRfZm9yX2N1cnJlbnRfc291cmNlJTIwaW4lMjByYW5nZShuKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHlpZWxkJTIwJTdCJTIyZXhhbXBsZV9pZCUyMiUzQSUyMGYlMjIlN0Jzb3VyY2UlN0RfJTdCZXhhbXBsZV9pZF9mb3JfY3VycmVudF9zb3VyY2UlN0QlMjIlN0QlMEElMEFnZW5fa3dhcmdzJTIwJTNEJTIwJTdCJTIybiUyMiUzQSUyMDEwJTJDJTIwJTIyc291cmNlcyUyMiUzQSUyMCU1QmYlMjJwYXRoJTJGdG8lMkZkYXRhXyU3QmklN0QlMjIlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDI0KSU1RCU3RCUwQW15X2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBJdGVyYWJsZURhdGFzZXQuZnJvbV9nZW5lcmF0b3IobXlfZ2VuZXJhdG9yJTJDJTIwZ2VuX2t3YXJncyUzRGdlbl9rd2FyZ3MpJTBBbXlfaXRlcmFibGVfZGF0YXNldC5uX3NoYXJkcyUyMCUyMCUyMyUyMDEwMjQ=",highlighted:`<span class="hljs-comment"># Stream from the internet</span>
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;deepmind/code_contests&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 39</span>

<span class="hljs-comment"># Stream from local files</span>
data_files = {<span class="hljs-string">&quot;train&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>.csv&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = load_dataset(<span class="hljs-string">&quot;csv&quot;</span>, data_files=data_files, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>

<span class="hljs-comment"># From a generator function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">my_generator</span>(<span class="hljs-params">n, sources</span>):
    <span class="hljs-keyword">for</span> source <span class="hljs-keyword">in</span> sources:
        <span class="hljs-keyword">for</span> example_id_for_current_source <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n):
            <span class="hljs-keyword">yield</span> {<span class="hljs-string">&quot;example_id&quot;</span>: <span class="hljs-string">f&quot;<span class="hljs-subst">{source}</span>_<span class="hljs-subst">{example_id_for_current_source}</span>&quot;</span>}

gen_kwargs = {<span class="hljs-string">&quot;n&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;sources&quot;</span>: [<span class="hljs-string">f&quot;path/to/data_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1024</span>)]}
my_iterable_dataset = IterableDataset.from_generator(my_generator, gen_kwargs=gen_kwargs)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),O=new u({props:{title:"Speed differences",local:"speed-differences",headingTag:"h2"}}),se=new y({props:{code:"bXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuc2h1ZmZsZShzZWVkJTNENDIpJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjB1cCUyMHRvJTIwMTB4JTIwc2xvd2VyJTBBbXlfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQuZmxhdHRlbl9pbmRpY2VzKCklMjAlMjAlMjMlMjByZXdyaXRlJTIwdGhlJTIwc2h1ZmZsZWQlMjBkYXRhc2V0JTIwb24lMjBkaXNrJTIwYXMlMjBjb250aWd1b3VzJTIwY2h1bmtzJTIwb2YlMjBkYXRhJTBBbXlfZGF0YXNldCU1QjAlNUQlMjAlMjAlMjMlMjBmYXN0JTIwYWdhaW4=",highlighted:`my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast</span>
my_dataset = my_dataset.shuffle(seed=<span class="hljs-number">42</span>)
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># up to 10x slower</span>
my_dataset = my_dataset.flatten_indices()  <span class="hljs-comment"># rewrite the shuffled dataset on disk as contiguous chunks of data</span>
my_dataset[<span class="hljs-number">0</span>]  <span class="hljs-comment"># fast again</span>`,wrap:!1}}),le=new y({props:{code:"Zm9yJTIwZXhhbXBsZSUyMGluJTIwZW51bWVyYXRlKG15X2l0ZXJhYmxlX2RhdGFzZXQpJTNBJTIwJTIwJTIzJTIwZmFzdCUwQSUyMCUyMCUyMCUyMHBhc3MlMEElMEFzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0JTIwJTNEJTIwbXlfaXRlcmFibGVfZGF0YXNldC5zaHVmZmxlKHNlZWQlM0Q0MiUyQyUyMGJ1ZmZlcl9zaXplJTNEMTAwKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGVudW1lcmF0ZShzaHVmZmxlZF9pdGVyYWJsZV9kYXRhc2V0KSUzQSUyMCUyMCUyMyUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQXNodWZmbGVkX2l0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBteV9pdGVyYWJsZV9kYXRhc2V0LnNodWZmbGUoc2VlZCUzRDEzMzclMkMlMjBidWZmZXJfc2l6ZSUzRDEwMCklMjAlMjAlMjMlMjByZXNodWZmbGluZyUyMHVzaW5nJTIwYW5vdGhlciUyMHNlZWQlMjBpcyUyMGluc3RhbnRhbmVvdXMlMEElMEFmb3IlMjBleGFtcGxlJTIwaW4lMjBlbnVtZXJhdGUoc2h1ZmZsZWRfaXRlcmFibGVfZGF0YXNldCklM0ElMjAlMjAlMjMlMjBzdGlsbCUyMGFzJTIwZmFzdCUyMGFzJTIwYmVmb3JlJTBBJTIwJTIwJTIwJTIwcGFzcw==",highlighted:`<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(my_iterable_dataset):  <span class="hljs-comment"># fast</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">42</span>, buffer_size=<span class="hljs-number">100</span>)

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># as fast as before</span>
    <span class="hljs-keyword">pass</span>

shuffled_iterable_dataset = my_iterable_dataset.shuffle(seed=<span class="hljs-number">1337</span>, buffer_size=<span class="hljs-number">100</span>)  <span class="hljs-comment"># reshuffling using another seed is instantaneous</span>

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(shuffled_iterable_dataset):  <span class="hljs-comment"># still as fast as before</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),ie=new y({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG5fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMG15X2l0ZXJhYmxlX2RhdGFzZXQuc2V0X2Vwb2NoKGVwb2NoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMG15X2l0ZXJhYmxlX2RhdGFzZXQlM0ElMjAlMjAlMjMlMjBmYXN0JTIwJTJCJTIwcmVzaHVmZmxlZCUyMGF0JTIwZWFjaCUyMGVwb2NoJTIwdXNpbmclMjAlNjBlZmZlY3RpdmVfc2VlZCUyMCUzRCUyMHNlZWQlMjAlMkIlMjBlcG9jaCU2MCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):
    my_iterable_dataset.set_epoch(epoch)
    <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> my_iterable_dataset:  <span class="hljs-comment"># fast + reshuffled at each epoch using \`effective_seed = seed + epoch\`</span>
        <span class="hljs-keyword">pass</span>`,wrap:!1}}),re=new u({props:{title:"Switch from map-style to iterable",local:"switch-from-map-style-to-iterable",headingTag:"h2"}}),de=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldCgp",highlighted:"my_iterable_dataset = my_dataset.to_iterable_dataset()",wrap:!1}}),me=new y({props:{code:"bXlfaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMG15X2RhdGFzZXQudG9faXRlcmFibGVfZGF0YXNldChudW1fc2hhcmRzJTNEMTAyNCklMEFteV9pdGVyYWJsZV9kYXRhc2V0Lm5fc2hhcmRzJTIwJTIwJTIzJTIwMTAyNA==",highlighted:`my_iterable_dataset = my_dataset.to_iterable_dataset(num_shards=<span class="hljs-number">1024</span>)
my_iterable_dataset.n_shards  <span class="hljs-comment"># 1024</span>`,wrap:!1}}),oe=new Ea({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/about_mapstyle_vs_iterable.mdx"}}),{c(){M=i("meta"),ye=l(),he=i("p"),Me=l(),p(w.$$.fragment),ue=l(),b=i("p"),b.innerHTML=fa,we=l(),p(j.$$.fragment),be=l(),J=i("p"),J.innerHTML=ya,je=l(),p(T.$$.fragment),Je=l(),_=i("p"),_.innerHTML=Ma,Te=l(),U=i("p"),U.textContent=ua,_e=l(),p(g.$$.fragment),Ue=l(),Z=i("p"),Z.innerHTML=wa,ge=l(),X=i("p"),X.innerHTML=ba,Ze=l(),p(I.$$.fragment),Xe=l(),k=i("p"),k.innerHTML=ja,Ie=l(),p(G.$$.fragment),ke=l(),C=i("p"),C.innerHTML=Ja,Ge=l(),p($.$$.fragment),Ce=l(),p(V.$$.fragment),$e=l(),R=i("p"),R.innerHTML=Ta,Ve=l(),p(B.$$.fragment),Re=l(),F=i("p"),F.textContent=_a,Be=l(),Y=i("p"),Y.innerHTML=Ua,Fe=l(),p(v.$$.fragment),Ye=l(),z=i("p"),z.innerHTML=ga,ve=l(),p(x.$$.fragment),ze=l(),Q=i("p"),Q.innerHTML=Za,xe=l(),p(W.$$.fragment),Qe=l(),N=i("p"),N.innerHTML=Xa,We=l(),D=i("p"),D.textContent=Ia,Ne=l(),p(S.$$.fragment),De=l(),p(H.$$.fragment),Se=l(),E=i("p"),E.innerHTML=ka,He=l(),p(A.$$.fragment),Ee=l(),q=i("p"),q.innerHTML=Ga,Ae=l(),p(L.$$.fragment),qe=l(),P=i("p"),P.innerHTML=Ca,Le=l(),p(K.$$.fragment),Pe=l(),p(O.$$.fragment),Ke=l(),ee=i("p"),ee.innerHTML=$a,Oe=l(),ae=i("p"),ae.innerHTML=Va,ea=l(),p(se.$$.fragment),aa=l(),te=i("p"),te.innerHTML=Ra,sa=l(),p(le.$$.fragment),ta=l(),ne=i("p"),ne.innerHTML=Ba,la=l(),p(ie.$$.fragment),na=l(),p(re.$$.fragment),ia=l(),pe=i("p"),pe.innerHTML=Fa,ra=l(),p(de.$$.fragment),pa=l(),ce=i("p"),ce.innerHTML=Ya,da=l(),p(me.$$.fragment),ca=l(),p(oe.$$.fragment),ma=l(),fe=i("p"),this.h()},l(e){const a=Sa("svelte-u9bgzb",document.head);M=r(a,"META",{name:!0,content:!0}),a.forEach(s),ye=n(e),he=r(e,"P",{}),va(he).forEach(s),Me=n(e),d(w.$$.fragment,e),ue=n(e),b=r(e,"P",{"data-svelte-h":!0}),f(b)!=="svelte-1nndet4"&&(b.innerHTML=fa),we=n(e),d(j.$$.fragment,e),be=n(e),J=r(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1hxjfay"&&(J.innerHTML=ya),je=n(e),d(T.$$.fragment,e),Je=n(e),_=r(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-mjmkw0"&&(_.innerHTML=Ma),Te=n(e),U=r(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-p27tn9"&&(U.textContent=ua),_e=n(e),d(g.$$.fragment,e),Ue=n(e),Z=r(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-qlt0xf"&&(Z.innerHTML=wa),ge=n(e),X=r(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1ik5e8b"&&(X.innerHTML=ba),Ze=n(e),d(I.$$.fragment,e),Xe=n(e),k=r(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-xsnnlf"&&(k.innerHTML=ja),Ie=n(e),d(G.$$.fragment,e),ke=n(e),C=r(e,"P",{"data-svelte-h":!0}),f(C)!=="svelte-z2r7k0"&&(C.innerHTML=Ja),Ge=n(e),d($.$$.fragment,e),Ce=n(e),d(V.$$.fragment,e),$e=n(e),R=r(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-1ewb8lm"&&(R.innerHTML=Ta),Ve=n(e),d(B.$$.fragment,e),Re=n(e),F=r(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-gryvti"&&(F.textContent=_a),Be=n(e),Y=r(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-gn3sd"&&(Y.innerHTML=Ua),Fe=n(e),d(v.$$.fragment,e),Ye=n(e),z=r(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-u916f6"&&(z.innerHTML=ga),ve=n(e),d(x.$$.fragment,e),ze=n(e),Q=r(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-15ijpck"&&(Q.innerHTML=Za),xe=n(e),d(W.$$.fragment,e),Qe=n(e),N=r(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-ro2n64"&&(N.innerHTML=Xa),We=n(e),D=r(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-vsuw18"&&(D.textContent=Ia),Ne=n(e),d(S.$$.fragment,e),De=n(e),d(H.$$.fragment,e),Se=n(e),E=r(e,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1ecbtre"&&(E.innerHTML=ka),He=n(e),d(A.$$.fragment,e),Ee=n(e),q=r(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-q1ca4g"&&(q.innerHTML=Ga),Ae=n(e),d(L.$$.fragment,e),qe=n(e),P=r(e,"P",{"data-svelte-h":!0}),f(P)!=="svelte-yru43"&&(P.innerHTML=Ca),Le=n(e),d(K.$$.fragment,e),Pe=n(e),d(O.$$.fragment,e),Ke=n(e),ee=r(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1mv00j9"&&(ee.innerHTML=$a),Oe=n(e),ae=r(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-1fwq0m9"&&(ae.innerHTML=Va),ea=n(e),d(se.$$.fragment,e),aa=n(e),te=r(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-qyjr4f"&&(te.innerHTML=Ra),sa=n(e),d(le.$$.fragment,e),ta=n(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1yhobsx"&&(ne.innerHTML=Ba),la=n(e),d(ie.$$.fragment,e),na=n(e),d(re.$$.fragment,e),ia=n(e),pe=r(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-1auhyc3"&&(pe.innerHTML=Fa),ra=n(e),d(de.$$.fragment,e),pa=n(e),ce=r(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-604gzo"&&(ce.innerHTML=Ya),da=n(e),d(me.$$.fragment,e),ca=n(e),d(oe.$$.fragment,e),ma=n(e),fe=r(e,"P",{}),va(fe).forEach(s),this.h()},h(){za(M,"name","hf:doc:metadata"),za(M,"content",qa)},m(e,a){Ha(document.head,M),t(e,ye,a),t(e,he,a),t(e,Me,a),c(w,e,a),t(e,ue,a),t(e,b,a),t(e,we,a),c(j,e,a),t(e,be,a),t(e,J,a),t(e,je,a),c(T,e,a),t(e,Je,a),t(e,_,a),t(e,Te,a),t(e,U,a),t(e,_e,a),c(g,e,a),t(e,Ue,a),t(e,Z,a),t(e,ge,a),t(e,X,a),t(e,Ze,a),c(I,e,a),t(e,Xe,a),t(e,k,a),t(e,Ie,a),c(G,e,a),t(e,ke,a),t(e,C,a),t(e,Ge,a),c($,e,a),t(e,Ce,a),c(V,e,a),t(e,$e,a),t(e,R,a),t(e,Ve,a),c(B,e,a),t(e,Re,a),t(e,F,a),t(e,Be,a),t(e,Y,a),t(e,Fe,a),c(v,e,a),t(e,Ye,a),t(e,z,a),t(e,ve,a),c(x,e,a),t(e,ze,a),t(e,Q,a),t(e,xe,a),c(W,e,a),t(e,Qe,a),t(e,N,a),t(e,We,a),t(e,D,a),t(e,Ne,a),c(S,e,a),t(e,De,a),c(H,e,a),t(e,Se,a),t(e,E,a),t(e,He,a),c(A,e,a),t(e,Ee,a),t(e,q,a),t(e,Ae,a),c(L,e,a),t(e,qe,a),t(e,P,a),t(e,Le,a),c(K,e,a),t(e,Pe,a),c(O,e,a),t(e,Ke,a),t(e,ee,a),t(e,Oe,a),t(e,ae,a),t(e,ea,a),c(se,e,a),t(e,aa,a),t(e,te,a),t(e,sa,a),c(le,e,a),t(e,ta,a),t(e,ne,a),t(e,la,a),c(ie,e,a),t(e,na,a),c(re,e,a),t(e,ia,a),t(e,pe,a),t(e,ra,a),c(de,e,a),t(e,pa,a),t(e,ce,a),t(e,da,a),c(me,e,a),t(e,ca,a),c(oe,e,a),t(e,ma,a),t(e,fe,a),oa=!0},p:Qa,i(e){oa||(m(w.$$.fragment,e),m(j.$$.fragment,e),m(T.$$.fragment,e),m(g.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(v.$$.fragment,e),m(x.$$.fragment,e),m(W.$$.fragment,e),m(S.$$.fragment,e),m(H.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(me.$$.fragment,e),m(oe.$$.fragment,e),oa=!0)},o(e){o(w.$$.fragment,e),o(j.$$.fragment,e),o(T.$$.fragment,e),o(g.$$.fragment,e),o(I.$$.fragment,e),o(G.$$.fragment,e),o($.$$.fragment,e),o(V.$$.fragment,e),o(B.$$.fragment,e),o(v.$$.fragment,e),o(x.$$.fragment,e),o(W.$$.fragment,e),o(S.$$.fragment,e),o(H.$$.fragment,e),o(A.$$.fragment,e),o(L.$$.fragment,e),o(K.$$.fragment,e),o(O.$$.fragment,e),o(se.$$.fragment,e),o(le.$$.fragment,e),o(ie.$$.fragment,e),o(re.$$.fragment,e),o(de.$$.fragment,e),o(me.$$.fragment,e),o(oe.$$.fragment,e),oa=!1},d(e){e&&(s(ye),s(he),s(Me),s(ue),s(b),s(we),s(be),s(J),s(je),s(Je),s(_),s(Te),s(U),s(_e),s(Ue),s(Z),s(ge),s(X),s(Ze),s(Xe),s(k),s(Ie),s(ke),s(C),s(Ge),s(Ce),s($e),s(R),s(Ve),s(Re),s(F),s(Be),s(Y),s(Fe),s(Ye),s(z),s(ve),s(ze),s(Q),s(xe),s(Qe),s(N),s(We),s(D),s(Ne),s(De),s(Se),s(E),s(He),s(Ee),s(q),s(Ae),s(qe),s(P),s(Le),s(Pe),s(Ke),s(ee),s(Oe),s(ae),s(ea),s(aa),s(te),s(sa),s(ta),s(ne),s(la),s(na),s(ia),s(pe),s(ra),s(pa),s(ce),s(da),s(ca),s(ma),s(fe)),s(M),h(w,e),h(j,e),h(T,e),h(g,e),h(I,e),h(G,e),h($,e),h(V,e),h(B,e),h(v,e),h(x,e),h(W,e),h(S,e),h(H,e),h(A,e),h(L,e),h(K,e),h(O,e),h(se,e),h(le,e),h(ie,e),h(re,e),h(de,e),h(me,e),h(oe,e)}}}const qa='{"title":"Differences between Dataset and IterableDataset","local":"differences-between-dataset-and-iterabledataset","sections":[{"title":"Downloading and streaming","local":"downloading-and-streaming","sections":[],"depth":2},{"title":"Creating map-style datasets and iterable datasets","local":"creating-map-style-datasets-and-iterable-datasets","sections":[],"depth":2},{"title":"Loading local files entirely and progressively","local":"loading-local-files-entirely-and-progressively","sections":[],"depth":2},{"title":"Eager data processing and lazy data processing","local":"eager-data-processing-and-lazy-data-processing","sections":[],"depth":2},{"title":"Exact and fast approximate shuffling","local":"exact-and-fast-approximate-shuffling","sections":[],"depth":2},{"title":"Speed differences","local":"speed-differences","sections":[],"depth":2},{"title":"Switch from map-style to iterable","local":"switch-from-map-style-to-iterable","sections":[],"depth":2}],"depth":1}';function La(ha){return Wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends Na{constructor(M){super(),Da(this,M,La,Aa,xa,{})}}export{as as component};
