import{s as ra,n as oa,o as ma}from"../chunks/scheduler.bdbef820.js";import{S as ca,i as da,g as i,s as n,r,A as ha,h as p,f as t,c as l,j as ia,u as o,x as m,k as pa,y as ga,a as s,v as c,d,t as h,w as g}from"../chunks/index.c0aea24a.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as O,E as fa}from"../chunks/EditOnGithub.725ee0c1.js";function ua(He){let u,te,ee,se,b,ne,j,Ye='There are two types of dataset objects, a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',le,x,Qe='This tutorial will show you how to load and access a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',ie,w,pe,$,Le='When you load a dataset split, you’ll get a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',re,y,Pe='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',oe,M,me,_,ce,k,We='A <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',de,T,he,v,Ne="Use the <code>-</code> operator to start from the end of the dataset:",ge,U,fe,I,Ee="Indexing by the column name returns a list of all the values in the column:",ue,J,be,C,Se="You can combine row and column name indexing to return a specific value at a position:",je,G,xe,R,Ve="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",we,Z,$e,D,ye,X,Ae="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",Me,B,_e,F,ke,q,Ke='An <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',Te,z,ve,H,Oe='You can also create an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',Ue,Y,Ie,Q,ea='An <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Je,L,aa='However, this means an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Ce,P,Ge,W,ta='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Re,N,Ze,E,sa='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',De,S,Xe,V,na='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Be,A,la='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/main/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Fe,K,qe,ae,ze;return b=new O({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new O({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),M=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),_=new O({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),T=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),U=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),J=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXRleHQlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMEFlbmRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBcHJpbnQoZiUyMkVsYXBzZWQlMjB0aW1lJTNBJTIwJTdCZW5kX3RpbWUlMjAtJTIwc3RhcnRfdGltZSUzQS40ZiU3RCUyMHNlY29uZHMlMjIpJTBBJTBBc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBdGV4dCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCMCU1RCUwQWVuZF90aW1lJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyRWxhcHNlZCUyMHRpbWUlM0ElMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjRmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),D=new O({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),B=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),F=new O({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),z=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),P=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),N=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),S=new O({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),K=new fa({props:{source:"https://github.com/huggingface/datasets/blob/main/docs/source/access.mdx"}}),{c(){u=i("meta"),te=n(),ee=i("p"),se=n(),r(b.$$.fragment),ne=n(),j=i("p"),j.innerHTML=Ye,le=n(),x=i("p"),x.innerHTML=Qe,ie=n(),r(w.$$.fragment),pe=n(),$=i("p"),$.innerHTML=Le,re=n(),y=i("p"),y.innerHTML=Pe,oe=n(),r(M.$$.fragment),me=n(),r(_.$$.fragment),ce=n(),k=i("p"),k.innerHTML=We,de=n(),r(T.$$.fragment),he=n(),v=i("p"),v.innerHTML=Ne,ge=n(),r(U.$$.fragment),fe=n(),I=i("p"),I.textContent=Ee,ue=n(),r(J.$$.fragment),be=n(),C=i("p"),C.textContent=Se,je=n(),r(G.$$.fragment),xe=n(),R=i("p"),R.textContent=Ve,we=n(),r(Z.$$.fragment),$e=n(),r(D.$$.fragment),ye=n(),X=i("p"),X.innerHTML=Ae,Me=n(),r(B.$$.fragment),_e=n(),r(F.$$.fragment),ke=n(),q=i("p"),q.innerHTML=Ke,Te=n(),r(z.$$.fragment),ve=n(),H=i("p"),H.innerHTML=Oe,Ue=n(),r(Y.$$.fragment),Ie=n(),Q=i("p"),Q.innerHTML=ea,Je=n(),L=i("p"),L.innerHTML=aa,Ce=n(),r(P.$$.fragment),Ge=n(),W=i("p"),W.innerHTML=ta,Re=n(),r(N.$$.fragment),Ze=n(),E=i("p"),E.innerHTML=sa,De=n(),r(S.$$.fragment),Xe=n(),V=i("p"),V.innerHTML=na,Be=n(),A=i("p"),A.innerHTML=la,Fe=n(),r(K.$$.fragment),qe=n(),ae=i("p"),this.h()},l(e){const a=ha("svelte-u9bgzb",document.head);u=p(a,"META",{name:!0,content:!0}),a.forEach(t),te=l(e),ee=p(e,"P",{}),ia(ee).forEach(t),se=l(e),o(b.$$.fragment,e),ne=l(e),j=p(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1tk0foc"&&(j.innerHTML=Ye),le=l(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1rz4ptz"&&(x.innerHTML=Qe),ie=l(e),o(w.$$.fragment,e),pe=l(e),$=p(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1ye32n5"&&($.innerHTML=Le),re=l(e),y=p(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-jz751l"&&(y.innerHTML=Pe),oe=l(e),o(M.$$.fragment,e),me=l(e),o(_.$$.fragment,e),ce=l(e),k=p(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-cwlj39"&&(k.innerHTML=We),de=l(e),o(T.$$.fragment,e),he=l(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-18jqw8v"&&(v.innerHTML=Ne),ge=l(e),o(U.$$.fragment,e),fe=l(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18othzs"&&(I.textContent=Ee),ue=l(e),o(J.$$.fragment,e),be=l(e),C=p(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1gzsqvo"&&(C.textContent=Se),je=l(e),o(G.$$.fragment,e),xe=l(e),R=p(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-158alym"&&(R.textContent=Ve),we=l(e),o(Z.$$.fragment,e),$e=l(e),o(D.$$.fragment,e),ye=l(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1gt5d64"&&(X.innerHTML=Ae),Me=l(e),o(B.$$.fragment,e),_e=l(e),o(F.$$.fragment,e),ke=l(e),q=p(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-10fogjp"&&(q.innerHTML=Ke),Te=l(e),o(z.$$.fragment,e),ve=l(e),H=p(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-gfcs15"&&(H.innerHTML=Oe),Ue=l(e),o(Y.$$.fragment,e),Ie=l(e),Q=p(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-bs8hma"&&(Q.innerHTML=ea),Je=l(e),L=p(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1dgqf8f"&&(L.innerHTML=aa),Ce=l(e),o(P.$$.fragment,e),Ge=l(e),W=p(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-qblcng"&&(W.innerHTML=ta),Re=l(e),o(N.$$.fragment,e),Ze=l(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-w7qh4t"&&(E.innerHTML=sa),De=l(e),o(S.$$.fragment,e),Xe=l(e),V=p(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-51y7bk"&&(V.innerHTML=na),Be=l(e),A=p(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1r0xrkk"&&(A.innerHTML=la),Fe=l(e),o(K.$$.fragment,e),qe=l(e),ae=p(e,"P",{}),ia(ae).forEach(t),this.h()},h(){pa(u,"name","hf:doc:metadata"),pa(u,"content",ba)},m(e,a){ga(document.head,u),s(e,te,a),s(e,ee,a),s(e,se,a),c(b,e,a),s(e,ne,a),s(e,j,a),s(e,le,a),s(e,x,a),s(e,ie,a),c(w,e,a),s(e,pe,a),s(e,$,a),s(e,re,a),s(e,y,a),s(e,oe,a),c(M,e,a),s(e,me,a),c(_,e,a),s(e,ce,a),s(e,k,a),s(e,de,a),c(T,e,a),s(e,he,a),s(e,v,a),s(e,ge,a),c(U,e,a),s(e,fe,a),s(e,I,a),s(e,ue,a),c(J,e,a),s(e,be,a),s(e,C,a),s(e,je,a),c(G,e,a),s(e,xe,a),s(e,R,a),s(e,we,a),c(Z,e,a),s(e,$e,a),c(D,e,a),s(e,ye,a),s(e,X,a),s(e,Me,a),c(B,e,a),s(e,_e,a),c(F,e,a),s(e,ke,a),s(e,q,a),s(e,Te,a),c(z,e,a),s(e,ve,a),s(e,H,a),s(e,Ue,a),c(Y,e,a),s(e,Ie,a),s(e,Q,a),s(e,Je,a),s(e,L,a),s(e,Ce,a),c(P,e,a),s(e,Ge,a),s(e,W,a),s(e,Re,a),c(N,e,a),s(e,Ze,a),s(e,E,a),s(e,De,a),c(S,e,a),s(e,Xe,a),s(e,V,a),s(e,Be,a),s(e,A,a),s(e,Fe,a),c(K,e,a),s(e,qe,a),s(e,ae,a),ze=!0},p:oa,i(e){ze||(d(b.$$.fragment,e),d(w.$$.fragment,e),d(M.$$.fragment,e),d(_.$$.fragment,e),d(T.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(N.$$.fragment,e),d(S.$$.fragment,e),d(K.$$.fragment,e),ze=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(M.$$.fragment,e),h(_.$$.fragment,e),h(T.$$.fragment,e),h(U.$$.fragment,e),h(J.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(N.$$.fragment,e),h(S.$$.fragment,e),h(K.$$.fragment,e),ze=!1},d(e){e&&(t(te),t(ee),t(se),t(ne),t(j),t(le),t(x),t(ie),t(pe),t($),t(re),t(y),t(oe),t(me),t(ce),t(k),t(de),t(he),t(v),t(ge),t(fe),t(I),t(ue),t(be),t(C),t(je),t(xe),t(R),t(we),t($e),t(ye),t(X),t(Me),t(_e),t(ke),t(q),t(Te),t(ve),t(H),t(Ue),t(Ie),t(Q),t(Je),t(L),t(Ce),t(Ge),t(W),t(Re),t(Ze),t(E),t(De),t(Xe),t(V),t(Be),t(A),t(Fe),t(qe),t(ae)),t(u),g(b,e),g(w,e),g(M,e),g(_,e),g(T,e),g(U,e),g(J,e),g(G,e),g(Z,e),g(D,e),g(B,e),g(F,e),g(z,e),g(Y,e),g(P,e),g(N,e),g(S,e),g(K,e)}}}const ba='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ja(He){return ma(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ma extends ca{constructor(u){super(),da(this,u,ja,ua,ra,{})}}export{Ma as component};
