import{s as Xs,n as Fs,o as Hs}from"../chunks/scheduler.85c25b89.js";import{S as Ys,i as As,g as h,s as l,r as p,A as Ks,h as u,f as t,c as n,j as Ws,u as i,x as M,k as Gs,y as Ls,a,v as r,d as m,t as o,w as c}from"../chunks/index.c9837788.js";import{C as y}from"../chunks/CodeBlock.52fa569e.js";import{H as f,E as Ps}from"../chunks/EditOnGithub.b65eee75.js";function Os(ds){let g,je,fe,de,j,Ue,d,Us="All of the models in <code>timm</code> have consistent mechanisms for obtaining various types of features from the model for tasks besides classification.",Je,U,we,J,Js="The features from the penultimate model layer can be obtained in several ways without requiring model surgery (although feel free to do surgery). One must first decide if they want pooled or un-pooled features.",be,w,$e,b,ws="There are three ways to obtain unpooled features.",Te,$,bs="Without modifying the network, one can call <code>model.forward_features(input)</code> on any model instead of the usual <code>model(input)</code>. This will bypass the head classifier and global pooling for networks.",Ce,T,$s="If one wants to explicitly modify the network to return unpooled features, they can either create the model without a classifier and pooling, or remove it later. Both paths remove the parameters associated with the classifier from the network.",ke,C,xe,k,Qe,x,Ts="Output:",ve,Q,Be,v,Ne,B,Ie,N,Cs="Output:",Ze,I,Se,Z,_e,S,Re,_,ks="Output:",ze,R,Ve,z,De,V,xs="To modify the network to return pooled features, one can use <code>forward_features()</code> and pool/flatten the result themselves, or modify the network like above but keep pooling intact.",Ee,D,We,E,Ge,W,Qs="Output:",Xe,G,Fe,X,He,F,Ye,H,vs="Output:",Ae,Y,Ke,A,Le,K,Bs="Object detection, segmentation, keypoint, and a variety of dense pixel tasks require access to feature maps from the backbone network at multiple scales. This is often done by modifying the original classification network. Since each network varies quite a bit in structure, it’s not uncommon to see only a few backbones supported in any given obj detection or segmentation library.",Pe,L,Ns="<code>timm</code> allows a consistent interface for creating any of the included models as feature backbones that output feature maps for selected levels.",Oe,P,Is="A feature backbone can be created by adding the argument <code>features_only=True</code> to any <code>create_model</code> call. By default 5 strides will be output from most models (not all have that many), with the first starting at 2 (some start at 1 or 4).",qe,O,es,q,ss,ee,Zs="Output:",ts,se,as,te,ls,ae,Ss="After a feature backbone has been created, it can be queried to provide channel or resolution reduction information to the downstream heads without requiring static config or hardcoded constants. The <code>.feature_info</code> attribute is a class encapsulating the information about the feature extraction points.",ns,le,ps,ne,_s="Output:",is,pe,rs,ie,ms,re,Rs="There are two additional creation arguments impacting the output features.",os,me,zs="<li><code>out_indices</code> selects which indices to output</li> <li><code>output_stride</code> limits the feature output stride of the network (also works in classification mode BTW)</li>",cs,oe,Vs="<code>out_indices</code> is supported by all models, but not all models have the same index to feature stride mapping. Look at the code or check feature_info to compare. The out indices generally correspond to the <code>C(i+1)th</code> feature level (a <code>2^(i+1)</code> reduction). For most models, index 0 is the stride 2 features, and index 4 is stride 32.",hs,ce,Ds="<code>output_stride</code> is achieved by converting layers to use dilated convolutions. Doing so is not always straightforward, some networks only support <code>output_stride=32</code>.",us,he,Ms,ue,Es="Output:",ys,Me,fs,ye,gs,ge,js;return j=new f({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h1"}}),U=new f({props:{title:"Penultimate Layer Features (Pre-Classifier Features)",local:"penultimate-layer-features-pre-classifier-features",headingTag:"h2"}}),w=new f({props:{title:"Unpooled",local:"unpooled",headingTag:"h3"}}),C=new f({props:{title:"forward_features()",local:"forwardfeatures",headingTag:"h4"}}),k=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCd4Y2VwdGlvbjQxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFvJTIwJTNEJTIwbS5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ1VucG9vbGVkJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;xception41&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m.forward_features(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Q=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjAxMCUyQyUyMDEwJTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 2048, 10, 10])`,wrap:!1}}),v=new f({props:{title:"Create with no classifier and pooling",local:"create-with-no-classifier-and-pooling",headingTag:"h4"}}),B=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCUyQyUyMGdsb2JhbF9wb29sJTNEJycpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQXByaW50KGYnVW5wb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>, global_pool=<span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),I=new y({props:{code:"VW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:"Unpooled shape: torch.Size([2, 2048, 7, 7])",wrap:!1}}),Z=new f({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),S=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdkZW5zZW5ldDEyMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidPcmlnaW5hbCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcpJTBBbS5yZXNldF9jbGFzc2lmaWVyKDAlMkMlMjAnJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidVbnBvb2xlZCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>, <span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),R=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 1024, 7, 7])`,wrap:!1}}),z=new f({props:{title:"Pooled",local:"pooled",headingTag:"h3"}}),D=new f({props:{title:"Create with no classifier",local:"create-with-no-classifier",headingTag:"h4"}}),E=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),G=new y({props:{code:"UG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAyMDQ4JTVEKQ==",highlighted:"Pooled shape: torch.Size([2, 2048])",wrap:!1}}),X=new f({props:{title:"Remove it later",local:"remove-it-later",headingTag:"h4"}}),F=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlc2Vfdm92bmV0MTliX2R3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFtLnJlc2V0X2NsYXNzaWZpZXIoMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`,wrap:!1}}),Y=new y({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBUG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAxMDI0JTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Pooled shape: torch.Size([2, 1024])`,wrap:!1}}),A=new f({props:{title:"Multi-scale Feature Maps (Feature Pyramid)",local:"multi-scale-feature-maps-feature-pyramid",headingTag:"h2"}}),O=new f({props:{title:"Create a feature map extraction model",local:"create-a-feature-map-extraction-model",headingTag:"h3"}}),q=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXN0MjZkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnest26d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),se=new y({props:{code:"dG9yY2guU2l6ZSglNUIyJTJDJTIwNjQlMkMlMjAxMTIlMkMlMjAxMTIlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjU2JTJDJTIwNTYlMkMlMjA1NiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAyOCUyQyUyMDI4JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`torch.Size([2, 64, 112, 112])
torch.Size([2, 256, 56, 56])
torch.Size([2, 512, 28, 28])
torch.Size([2, 1024, 14, 14])
torch.Size([2, 2048, 7, 7])`,wrap:!1}}),te=new f({props:{title:"Query the feature information",local:"query-the-feature-information",headingTag:"h3"}}),le=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZWduZXR5XzAzMiclMkMlMjBmZWF0dXJlc19vbmx5JTNEVHJ1ZSUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXByaW50KGYnRmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTdCbS5mZWF0dXJlX2luZm8uY2hhbm5lbHMoKSU3RCcpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;regnety_032&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),pe=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCMzIlMkMlMjA3MiUyQyUyMDIxNiUyQyUyMDU3NiUyQyUyMDE1MTIlNUQlMEF0b3JjaC5TaXplKCU1QjIlMkMlMjAzMiUyQyUyMDExMiUyQyUyMDExMiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA3MiUyQyUyMDU2JTJDJTIwNTYlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjE2JTJDJTIwMjglMkMlMjAyOCU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1NzYlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDE1MTIlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Feature channels: [32, 72, 216, 576, 1512]
torch.Size([2, 32, 112, 112])
torch.Size([2, 72, 56, 56])
torch.Size([2, 216, 28, 28])
torch.Size([2, 576, 14, 14])
torch.Size([2, 1512, 7, 7])`,wrap:!1}}),ie=new f({props:{title:"Select specific feature levels or limit the stride",local:"select-specific-feature-levels-or-limit-the-stride",headingTag:"h3"}}),he=new y({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlY2FyZXNuZXQxMDFkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwb3V0cHV0X3N0cmlkZSUzRDglMkMlMjBvdXRfaW5kaWNlcyUzRCgyJTJDJTIwNCklMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludChmJ0ZlYXR1cmUlMjBjaGFubmVscyUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLmNoYW5uZWxzKCklN0QnKSUwQXByaW50KGYnRmVhdHVyZSUyMHJlZHVjdGlvbiUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLnJlZHVjdGlvbigpJTdEJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDMyMCUyQyUyMDMyMCkpJTBBZm9yJTIweCUyMGluJTIwbyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHguc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, output_stride=<span class="hljs-number">8</span>, out_indices=(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>), pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature reduction: <span class="hljs-subst">{m.feature_info.reduction()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">320</span>, <span class="hljs-number">320</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`,wrap:!1}}),Me=new y({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCNTEyJTJDJTIwMjA0OCU1RCUwQUZlYXR1cmUlMjByZWR1Y3Rpb24lM0ElMjAlNUI4JTJDJTIwOCU1RCUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDQwJTJDJTIwNDAlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjA0OCUyQyUyMDQwJTJDJTIwNDAlNUQp",highlighted:`Feature channels: [512, 2048]
Feature reduction: [8, 8]
torch.Size([2, 512, 40, 40])
torch.Size([2, 2048, 40, 40])`,wrap:!1}}),ye=new Ps({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/feature_extraction.mdx"}}),{c(){g=h("meta"),je=l(),fe=h("p"),de=l(),p(j.$$.fragment),Ue=l(),d=h("p"),d.innerHTML=Us,Je=l(),p(U.$$.fragment),we=l(),J=h("p"),J.textContent=Js,be=l(),p(w.$$.fragment),$e=l(),b=h("p"),b.textContent=ws,Te=l(),$=h("p"),$.innerHTML=bs,Ce=l(),T=h("p"),T.textContent=$s,ke=l(),p(C.$$.fragment),xe=l(),p(k.$$.fragment),Qe=l(),x=h("p"),x.textContent=Ts,ve=l(),p(Q.$$.fragment),Be=l(),p(v.$$.fragment),Ne=l(),p(B.$$.fragment),Ie=l(),N=h("p"),N.textContent=Cs,Ze=l(),p(I.$$.fragment),Se=l(),p(Z.$$.fragment),_e=l(),p(S.$$.fragment),Re=l(),_=h("p"),_.textContent=ks,ze=l(),p(R.$$.fragment),Ve=l(),p(z.$$.fragment),De=l(),V=h("p"),V.innerHTML=xs,Ee=l(),p(D.$$.fragment),We=l(),p(E.$$.fragment),Ge=l(),W=h("p"),W.textContent=Qs,Xe=l(),p(G.$$.fragment),Fe=l(),p(X.$$.fragment),He=l(),p(F.$$.fragment),Ye=l(),H=h("p"),H.textContent=vs,Ae=l(),p(Y.$$.fragment),Ke=l(),p(A.$$.fragment),Le=l(),K=h("p"),K.textContent=Bs,Pe=l(),L=h("p"),L.innerHTML=Ns,Oe=l(),P=h("p"),P.innerHTML=Is,qe=l(),p(O.$$.fragment),es=l(),p(q.$$.fragment),ss=l(),ee=h("p"),ee.textContent=Zs,ts=l(),p(se.$$.fragment),as=l(),p(te.$$.fragment),ls=l(),ae=h("p"),ae.innerHTML=Ss,ns=l(),p(le.$$.fragment),ps=l(),ne=h("p"),ne.textContent=_s,is=l(),p(pe.$$.fragment),rs=l(),p(ie.$$.fragment),ms=l(),re=h("p"),re.textContent=Rs,os=l(),me=h("ul"),me.innerHTML=zs,cs=l(),oe=h("p"),oe.innerHTML=Vs,hs=l(),ce=h("p"),ce.innerHTML=Ds,us=l(),p(he.$$.fragment),Ms=l(),ue=h("p"),ue.textContent=Es,ys=l(),p(Me.$$.fragment),fs=l(),p(ye.$$.fragment),gs=l(),ge=h("p"),this.h()},l(e){const s=Ks("svelte-u9bgzb",document.head);g=u(s,"META",{name:!0,content:!0}),s.forEach(t),je=n(e),fe=u(e,"P",{}),Ws(fe).forEach(t),de=n(e),i(j.$$.fragment,e),Ue=n(e),d=u(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1w5xc9e"&&(d.innerHTML=Us),Je=n(e),i(U.$$.fragment,e),we=n(e),J=u(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1i0y2af"&&(J.textContent=Js),be=n(e),i(w.$$.fragment,e),$e=n(e),b=u(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-gzowzl"&&(b.textContent=ws),Te=n(e),$=u(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-1c1de84"&&($.innerHTML=bs),Ce=n(e),T=u(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1c79pr0"&&(T.textContent=$s),ke=n(e),i(C.$$.fragment,e),xe=n(e),i(k.$$.fragment,e),Qe=n(e),x=u(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1wuxk0l"&&(x.textContent=Ts),ve=n(e),i(Q.$$.fragment,e),Be=n(e),i(v.$$.fragment,e),Ne=n(e),i(B.$$.fragment,e),Ie=n(e),N=u(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1wuxk0l"&&(N.textContent=Cs),Ze=n(e),i(I.$$.fragment,e),Se=n(e),i(Z.$$.fragment,e),_e=n(e),i(S.$$.fragment,e),Re=n(e),_=u(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1wuxk0l"&&(_.textContent=ks),ze=n(e),i(R.$$.fragment,e),Ve=n(e),i(z.$$.fragment,e),De=n(e),V=u(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-jci7dg"&&(V.innerHTML=xs),Ee=n(e),i(D.$$.fragment,e),We=n(e),i(E.$$.fragment,e),Ge=n(e),W=u(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1wuxk0l"&&(W.textContent=Qs),Xe=n(e),i(G.$$.fragment,e),Fe=n(e),i(X.$$.fragment,e),He=n(e),i(F.$$.fragment,e),Ye=n(e),H=u(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1wuxk0l"&&(H.textContent=vs),Ae=n(e),i(Y.$$.fragment,e),Ke=n(e),i(A.$$.fragment,e),Le=n(e),K=u(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-56ounp"&&(K.textContent=Bs),Pe=n(e),L=u(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-1j7o0l4"&&(L.innerHTML=Ns),Oe=n(e),P=u(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-qgbd6k"&&(P.innerHTML=Is),qe=n(e),i(O.$$.fragment,e),es=n(e),i(q.$$.fragment,e),ss=n(e),ee=u(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1wuxk0l"&&(ee.textContent=Zs),ts=n(e),i(se.$$.fragment,e),as=n(e),i(te.$$.fragment,e),ls=n(e),ae=u(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-2ryznm"&&(ae.innerHTML=Ss),ns=n(e),i(le.$$.fragment,e),ps=n(e),ne=u(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-1wuxk0l"&&(ne.textContent=_s),is=n(e),i(pe.$$.fragment,e),rs=n(e),i(ie.$$.fragment,e),ms=n(e),re=u(e,"P",{"data-svelte-h":!0}),M(re)!=="svelte-18fc4zz"&&(re.textContent=Rs),os=n(e),me=u(e,"UL",{"data-svelte-h":!0}),M(me)!=="svelte-1c2ig9e"&&(me.innerHTML=zs),cs=n(e),oe=u(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-1sy35a7"&&(oe.innerHTML=Vs),hs=n(e),ce=u(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-nvrnid"&&(ce.innerHTML=Ds),us=n(e),i(he.$$.fragment,e),Ms=n(e),ue=u(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1wuxk0l"&&(ue.textContent=Es),ys=n(e),i(Me.$$.fragment,e),fs=n(e),i(ye.$$.fragment,e),gs=n(e),ge=u(e,"P",{}),Ws(ge).forEach(t),this.h()},h(){Gs(g,"name","hf:doc:metadata"),Gs(g,"content",qs)},m(e,s){Ls(document.head,g),a(e,je,s),a(e,fe,s),a(e,de,s),r(j,e,s),a(e,Ue,s),a(e,d,s),a(e,Je,s),r(U,e,s),a(e,we,s),a(e,J,s),a(e,be,s),r(w,e,s),a(e,$e,s),a(e,b,s),a(e,Te,s),a(e,$,s),a(e,Ce,s),a(e,T,s),a(e,ke,s),r(C,e,s),a(e,xe,s),r(k,e,s),a(e,Qe,s),a(e,x,s),a(e,ve,s),r(Q,e,s),a(e,Be,s),r(v,e,s),a(e,Ne,s),r(B,e,s),a(e,Ie,s),a(e,N,s),a(e,Ze,s),r(I,e,s),a(e,Se,s),r(Z,e,s),a(e,_e,s),r(S,e,s),a(e,Re,s),a(e,_,s),a(e,ze,s),r(R,e,s),a(e,Ve,s),r(z,e,s),a(e,De,s),a(e,V,s),a(e,Ee,s),r(D,e,s),a(e,We,s),r(E,e,s),a(e,Ge,s),a(e,W,s),a(e,Xe,s),r(G,e,s),a(e,Fe,s),r(X,e,s),a(e,He,s),r(F,e,s),a(e,Ye,s),a(e,H,s),a(e,Ae,s),r(Y,e,s),a(e,Ke,s),r(A,e,s),a(e,Le,s),a(e,K,s),a(e,Pe,s),a(e,L,s),a(e,Oe,s),a(e,P,s),a(e,qe,s),r(O,e,s),a(e,es,s),r(q,e,s),a(e,ss,s),a(e,ee,s),a(e,ts,s),r(se,e,s),a(e,as,s),r(te,e,s),a(e,ls,s),a(e,ae,s),a(e,ns,s),r(le,e,s),a(e,ps,s),a(e,ne,s),a(e,is,s),r(pe,e,s),a(e,rs,s),r(ie,e,s),a(e,ms,s),a(e,re,s),a(e,os,s),a(e,me,s),a(e,cs,s),a(e,oe,s),a(e,hs,s),a(e,ce,s),a(e,us,s),r(he,e,s),a(e,Ms,s),a(e,ue,s),a(e,ys,s),r(Me,e,s),a(e,fs,s),r(ye,e,s),a(e,gs,s),a(e,ge,s),js=!0},p:Fs,i(e){js||(m(j.$$.fragment,e),m(U.$$.fragment,e),m(w.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(Q.$$.fragment,e),m(v.$$.fragment,e),m(B.$$.fragment,e),m(I.$$.fragment,e),m(Z.$$.fragment,e),m(S.$$.fragment,e),m(R.$$.fragment,e),m(z.$$.fragment,e),m(D.$$.fragment,e),m(E.$$.fragment,e),m(G.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),m(q.$$.fragment,e),m(se.$$.fragment,e),m(te.$$.fragment,e),m(le.$$.fragment,e),m(pe.$$.fragment,e),m(ie.$$.fragment,e),m(he.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),js=!0)},o(e){o(j.$$.fragment,e),o(U.$$.fragment,e),o(w.$$.fragment,e),o(C.$$.fragment,e),o(k.$$.fragment,e),o(Q.$$.fragment,e),o(v.$$.fragment,e),o(B.$$.fragment,e),o(I.$$.fragment,e),o(Z.$$.fragment,e),o(S.$$.fragment,e),o(R.$$.fragment,e),o(z.$$.fragment,e),o(D.$$.fragment,e),o(E.$$.fragment,e),o(G.$$.fragment,e),o(X.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(O.$$.fragment,e),o(q.$$.fragment,e),o(se.$$.fragment,e),o(te.$$.fragment,e),o(le.$$.fragment,e),o(pe.$$.fragment,e),o(ie.$$.fragment,e),o(he.$$.fragment,e),o(Me.$$.fragment,e),o(ye.$$.fragment,e),js=!1},d(e){e&&(t(je),t(fe),t(de),t(Ue),t(d),t(Je),t(we),t(J),t(be),t($e),t(b),t(Te),t($),t(Ce),t(T),t(ke),t(xe),t(Qe),t(x),t(ve),t(Be),t(Ne),t(Ie),t(N),t(Ze),t(Se),t(_e),t(Re),t(_),t(ze),t(Ve),t(De),t(V),t(Ee),t(We),t(Ge),t(W),t(Xe),t(Fe),t(He),t(Ye),t(H),t(Ae),t(Ke),t(Le),t(K),t(Pe),t(L),t(Oe),t(P),t(qe),t(es),t(ss),t(ee),t(ts),t(as),t(ls),t(ae),t(ns),t(ps),t(ne),t(is),t(rs),t(ms),t(re),t(os),t(me),t(cs),t(oe),t(hs),t(ce),t(us),t(Ms),t(ue),t(ys),t(fs),t(gs),t(ge)),t(g),c(j,e),c(U,e),c(w,e),c(C,e),c(k,e),c(Q,e),c(v,e),c(B,e),c(I,e),c(Z,e),c(S,e),c(R,e),c(z,e),c(D,e),c(E,e),c(G,e),c(X,e),c(F,e),c(Y,e),c(A,e),c(O,e),c(q,e),c(se,e),c(te,e),c(le,e),c(pe,e),c(ie,e),c(he,e),c(Me,e),c(ye,e)}}}const qs='{"title":"Feature Extraction","local":"feature-extraction","sections":[{"title":"Penultimate Layer Features (Pre-Classifier Features)","local":"penultimate-layer-features-pre-classifier-features","sections":[{"title":"Unpooled","local":"unpooled","sections":[{"title":"forward_features()","local":"forwardfeatures","sections":[],"depth":4},{"title":"Create with no classifier and pooling","local":"create-with-no-classifier-and-pooling","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3},{"title":"Pooled","local":"pooled","sections":[{"title":"Create with no classifier","local":"create-with-no-classifier","sections":[],"depth":4},{"title":"Remove it later","local":"remove-it-later","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Multi-scale Feature Maps (Feature Pyramid)","local":"multi-scale-feature-maps-feature-pyramid","sections":[{"title":"Create a feature map extraction model","local":"create-a-feature-map-extraction-model","sections":[],"depth":3},{"title":"Query the feature information","local":"query-the-feature-information","sections":[],"depth":3},{"title":"Select specific feature levels or limit the stride","local":"select-specific-feature-levels-or-limit-the-stride","sections":[],"depth":3}],"depth":2}],"depth":1}';function et(ds){return Hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nt extends Ys{constructor(g){super(),As(this,g,et,Os,Xs,{})}}export{nt as component};
