import{s as Vt,n as Ht,o as St}from"../chunks/scheduler.85c25b89.js";import{S as zt,i as Ft,g as p,s as e,r,m as V,H as Dt,A as Lt,h as m,f as l,c as n,j as xt,u as c,n as H,x as o,B as qt,k as S,y as h,a,v as J,d as j,t as g,w as T}from"../chunks/index.c9837788.js";import{C as z}from"../chunks/CodeBlock.52fa569e.js";import{H as L}from"../chunks/Heading.3097d2ed.js";function Pt(At){let w,q,F,P,u,K,i,bt,Y,Zt="ResNeXt",ft,d,Bt="building block",Ut,y,Nt="ResNet",It,_,$t="cardinality",Ct,O,_t='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>C</mi></mrow><annotation encoding="application/x-tex"> C </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">C</span></span></span></span>',tt,st,b,lt,f,Wt="To load a pretrained model:",at,U,et,I,Et="To load and preprocess the image:",nt,C,pt,x,Gt="To get the model predictions:",mt,A,it,Z,vt="To get the top-5 predictions class names:",ot,B,Mt,N,kt="Replace the model name with the variant you want to use, e.g. <code>resnext101_32x8d</code>. You can find the IDs in the model summaries at the top of this page.",rt,$,Rt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ct,W,ht,E,Qt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Jt,G,jt,v,Xt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,gt,k,Tt,R,Yt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',wt,Q,dt,X,yt,D,ut;return u=new L({props:{title:"ResNeXt",local:"resnext",headingTag:"h1"}}),b=new L({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),U=new z({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3Jlc25leHQxMDFfMzJ4OGQnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnext101_32x8d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),C=new z({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),A=new z({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),B=new z({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new L({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),G=new z({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgncmVzbmV4dDEwMV8zMng4ZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;resnext101_32x8d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),k=new L({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new L({props:{title:"Citation",local:"citation",headingTag:"h2"}}),X=new z({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYlMkMlMEElMjAlMjBhdXRob3IlMjAlMjAlMjAlMjAlM0QlMjAlN0JTYWluaW5nJTIwWGllJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUm9zcyUyMEIuJTIwR2lyc2hpY2slMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQaW90ciUyMERvbGwlN0IlNUMnJTdCYSU3RCU3RHIlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBaaHVvd2VuJTIwVHUlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBLYWltaW5nJTIwSGUlN0QlMkMlMEElMjAlMjB0aXRsZSUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QkFnZ3JlZ2F0ZWQlMjBSZXNpZHVhbCUyMFRyYW5zZm9ybWF0aW9ucyUyMGZvciUyMERlZXAlMjBOZXVyYWwlMjBOZXR3b3JrcyU3RCUyQyUwQSUyMCUyMGpvdXJuYWwlMjAlMjAlMjAlM0QlMjAlN0JDb1JSJTdEJTJDJTBBJTIwJTIwdm9sdW1lJTIwJTIwJTIwJTIwJTNEJTIwJTdCYWJzJTJGMTYxMS4wNTQzMSU3RCUyQyUwQSUyMCUyMHllYXIlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0IyMDE2JTdEJTJDJTBBJTIwJTIwdXJsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cCUzQSUyRiUyRmFyeGl2Lm9yZyUyRmFicyUyRjE2MTEuMDU0MzElN0QlMkMlMEElMjAlMjBhcmNoaXZlUHJlZml4JTIwJTNEJTIwJTdCYXJYaXYlN0QlMkMlMEElMjAlMjBlcHJpbnQlMjAlMjAlMjAlMjAlM0QlMjAlN0IxNjExLjA1NDMxJTdEJTJDJTBBJTIwJTIwdGltZXN0YW1wJTIwJTNEJTIwJTdCTW9uJTJDJTIwMTMlMjBBdWclMjAyMDE4JTIwMTYlM0E0NSUzQTU4JTIwJTJCMDIwMCU3RCUyQyUwQSUyMCUyMGJpYnVybCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHBzJTNBJTJGJTJGZGJscC5vcmclMkZyZWMlMkZqb3VybmFscyUyRmNvcnIlMkZYaWVHRFRIMTYuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/XieGDTH16,
  author    = {Saining Xie and
               Ross B. Girshick and
               Piotr Doll{\\&#x27;{a}</span><span class="language-xml">}r and
               Zhuowen Tu and
               Kaiming He},
  title     = </span><span class="hljs-template-variable">{Aggregated Residual Transformations for Deep Neural Networks}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1611.05431}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2016}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1611.05431}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1611.05431}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 13 Aug 2018 16:45:58 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/XieGDTH16.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){w=p("meta"),q=e(),F=p("p"),P=e(),r(u.$$.fragment),K=e(),i=p("p"),bt=V("A "),Y=p("strong"),Y.textContent=Zt,ft=V(" repeats a "),d=p("a"),d.textContent=Bt,Ut=V(" that aggregates a set of transformations with the same topology. Compared to a "),y=p("a"),y.textContent=Nt,It=V(", it exposes a new dimension,  "),_=p("em"),_.textContent=$t,Ct=V(" (the size of the set of transformations)"),O=new Dt(!1),tt=V(", as an essential factor in addition to the dimensions of depth and width."),st=e(),r(b.$$.fragment),lt=e(),f=p("p"),f.textContent=Wt,at=e(),r(U.$$.fragment),et=e(),I=p("p"),I.textContent=Et,nt=e(),r(C.$$.fragment),pt=e(),x=p("p"),x.textContent=Gt,mt=e(),r(A.$$.fragment),it=e(),Z=p("p"),Z.textContent=vt,ot=e(),r(B.$$.fragment),Mt=e(),N=p("p"),N.innerHTML=kt,rt=e(),$=p("p"),$.innerHTML=Rt,ct=e(),r(W.$$.fragment),ht=e(),E=p("p"),E.textContent=Qt,Jt=e(),r(G.$$.fragment),jt=e(),v=p("p"),v.innerHTML=Xt,gt=e(),r(k.$$.fragment),Tt=e(),R=p("p"),R.innerHTML=Yt,wt=e(),r(Q.$$.fragment),dt=e(),r(X.$$.fragment),yt=e(),D=p("p"),this.h()},l(t){const s=Lt("svelte-u9bgzb",document.head);w=m(s,"META",{name:!0,content:!0}),s.forEach(l),q=n(t),F=m(t,"P",{}),xt(F).forEach(l),P=n(t),c(u.$$.fragment,t),K=n(t),i=m(t,"P",{});var M=xt(i);bt=H(M,"A "),Y=m(M,"STRONG",{"data-svelte-h":!0}),o(Y)!=="svelte-ixiuf7"&&(Y.textContent=Zt),ft=H(M," repeats a "),d=m(M,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(d)!=="svelte-60xv13"&&(d.textContent=Bt),Ut=H(M," that aggregates a set of transformations with the same topology. Compared to a "),y=m(M,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(y)!=="svelte-1fowv03"&&(y.textContent=Nt),It=H(M,", it exposes a new dimension,  "),_=m(M,"EM",{"data-svelte-h":!0}),o(_)!=="svelte-47b3di"&&(_.textContent=$t),Ct=H(M," (the size of the set of transformations)"),O=qt(M,!1),tt=H(M,", as an essential factor in addition to the dimensions of depth and width."),M.forEach(l),st=n(t),c(b.$$.fragment,t),lt=n(t),f=m(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-18ywhxh"&&(f.textContent=Wt),at=n(t),c(U.$$.fragment,t),et=n(t),I=m(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1c2ipa8"&&(I.textContent=Et),nt=n(t),c(C.$$.fragment,t),pt=n(t),x=m(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1n9qsq1"&&(x.textContent=Gt),mt=n(t),c(A.$$.fragment,t),it=n(t),Z=m(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-19cnvx1"&&(Z.textContent=vt),ot=n(t),c(B.$$.fragment,t),Mt=n(t),N=m(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-j0haf3"&&(N.innerHTML=kt),rt=n(t),$=m(t,"P",{"data-svelte-h":!0}),o($)!=="svelte-1wmi3ea"&&($.innerHTML=Rt),ct=n(t),c(W.$$.fragment,t),ht=n(t),E=m(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-9sr7nh"&&(E.textContent=Qt),Jt=n(t),c(G.$$.fragment,t),jt=n(t),v=m(t,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1kguc51"&&(v.innerHTML=Xt),gt=n(t),c(k.$$.fragment,t),Tt=n(t),R=m(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1n0coha"&&(R.innerHTML=Yt),wt=n(t),c(Q.$$.fragment,t),dt=n(t),c(X.$$.fragment,t),yt=n(t),D=m(t,"P",{}),xt(D).forEach(l),this.h()},h(){S(w,"name","hf:doc:metadata"),S(w,"content",Kt),S(d,"href","https://paperswithcode.com/method/resnext-block"),S(d,"rel","nofollow"),S(y,"href","https://paperswithcode.com/method/resnet"),S(y,"rel","nofollow"),O.a=tt},m(t,s){h(document.head,w),a(t,q,s),a(t,F,s),a(t,P,s),J(u,t,s),a(t,K,s),a(t,i,s),h(i,bt),h(i,Y),h(i,ft),h(i,d),h(i,Ut),h(i,y),h(i,It),h(i,_),h(i,Ct),O.m(_t,i),h(i,tt),a(t,st,s),J(b,t,s),a(t,lt,s),a(t,f,s),a(t,at,s),J(U,t,s),a(t,et,s),a(t,I,s),a(t,nt,s),J(C,t,s),a(t,pt,s),a(t,x,s),a(t,mt,s),J(A,t,s),a(t,it,s),a(t,Z,s),a(t,ot,s),J(B,t,s),a(t,Mt,s),a(t,N,s),a(t,rt,s),a(t,$,s),a(t,ct,s),J(W,t,s),a(t,ht,s),a(t,E,s),a(t,Jt,s),J(G,t,s),a(t,jt,s),a(t,v,s),a(t,gt,s),J(k,t,s),a(t,Tt,s),a(t,R,s),a(t,wt,s),J(Q,t,s),a(t,dt,s),J(X,t,s),a(t,yt,s),a(t,D,s),ut=!0},p:Ht,i(t){ut||(j(u.$$.fragment,t),j(b.$$.fragment,t),j(U.$$.fragment,t),j(C.$$.fragment,t),j(A.$$.fragment,t),j(B.$$.fragment,t),j(W.$$.fragment,t),j(G.$$.fragment,t),j(k.$$.fragment,t),j(Q.$$.fragment,t),j(X.$$.fragment,t),ut=!0)},o(t){g(u.$$.fragment,t),g(b.$$.fragment,t),g(U.$$.fragment,t),g(C.$$.fragment,t),g(A.$$.fragment,t),g(B.$$.fragment,t),g(W.$$.fragment,t),g(G.$$.fragment,t),g(k.$$.fragment,t),g(Q.$$.fragment,t),g(X.$$.fragment,t),ut=!1},d(t){t&&(l(q),l(F),l(P),l(K),l(i),l(st),l(lt),l(f),l(at),l(et),l(I),l(nt),l(pt),l(x),l(mt),l(it),l(Z),l(ot),l(Mt),l(N),l(rt),l($),l(ct),l(ht),l(E),l(Jt),l(jt),l(v),l(gt),l(Tt),l(R),l(wt),l(dt),l(yt),l(D)),l(w),T(u,t),T(b,t),T(U,t),T(C,t),T(A,t),T(B,t),T(W,t),T(G,t),T(k,t),T(Q,t),T(X,t)}}}const Kt='{"title":"ResNeXt","local":"resnext","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ot(At){return St(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends zt{constructor(w){super(),Ft(this,w,Ot,Pt,Vt,{})}}export{es as component};
