import{s as Us,n as Cs,o as Is}from"../chunks/scheduler.85c25b89.js";import{S as $s,i as ks,g as p,s as a,r as i,A as Zs,h as m,f as e,c as n,j as fs,u as o,x as d,k as bs,y as Ws,a as l,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as V}from"../chunks/CodeBlock.52fa569e.js";import{H as v}from"../chunks/Heading.3097d2ed.js";function Ns(cs){let y,_,R,S,g,Y,w,hs='<strong>SE ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',z,J,F,j,Ms="To load a pretrained model:",H,u,A,T,ds="To load and preprocess the image:",L,f,q,b,ys="To get the model predictions:",D,U,P,C,gs="To get the top-5 predictions class names:",K,I,O,$,ws="Replace the model name with the variant you want to use, e.g. <code>seresnet152d</code>. You can find the IDs in the model summaries at the top of this page.",ss,k,Js='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ts,Z,es,W,js="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",ls,N,as,B,us=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ns,x,ps,G,Ts='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ms,E,is,Q,os,X,rs;return g=new v({props:{title:"SE-ResNet",local:"se-resnet",headingTag:"h1"}}),J=new v({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NlcmVzbmV0MTUyZCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnet152d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new v({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2VyZXNuZXQxNTJkJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;seresnet152d&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new v({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new v({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new V({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){y=p("meta"),_=a(),R=p("p"),S=a(),i(g.$$.fragment),Y=a(),w=p("p"),w.innerHTML=hs,z=a(),i(J.$$.fragment),F=a(),j=p("p"),j.textContent=Ms,H=a(),i(u.$$.fragment),A=a(),T=p("p"),T.textContent=ds,L=a(),i(f.$$.fragment),q=a(),b=p("p"),b.textContent=ys,D=a(),i(U.$$.fragment),P=a(),C=p("p"),C.textContent=gs,K=a(),i(I.$$.fragment),O=a(),$=p("p"),$.innerHTML=ws,ss=a(),k=p("p"),k.innerHTML=Js,ts=a(),i(Z.$$.fragment),es=a(),W=p("p"),W.textContent=js,ls=a(),i(N.$$.fragment),as=a(),B=p("p"),B.innerHTML=us,ns=a(),i(x.$$.fragment),ps=a(),G=p("p"),G.innerHTML=Ts,ms=a(),i(E.$$.fragment),is=a(),i(Q.$$.fragment),os=a(),X=p("p"),this.h()},l(s){const t=Zs("svelte-u9bgzb",document.head);y=m(t,"META",{name:!0,content:!0}),t.forEach(e),_=n(s),R=m(s,"P",{}),fs(R).forEach(e),S=n(s),o(g.$$.fragment,s),Y=n(s),w=m(s,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1b8qp0g"&&(w.innerHTML=hs),z=n(s),o(J.$$.fragment,s),F=n(s),j=m(s,"P",{"data-svelte-h":!0}),d(j)!=="svelte-18ywhxh"&&(j.textContent=Ms),H=n(s),o(u.$$.fragment,s),A=n(s),T=m(s,"P",{"data-svelte-h":!0}),d(T)!=="svelte-1c2ipa8"&&(T.textContent=ds),L=n(s),o(f.$$.fragment,s),q=n(s),b=m(s,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1n9qsq1"&&(b.textContent=ys),D=n(s),o(U.$$.fragment,s),P=n(s),C=m(s,"P",{"data-svelte-h":!0}),d(C)!=="svelte-19cnvx1"&&(C.textContent=gs),K=n(s),o(I.$$.fragment,s),O=n(s),$=m(s,"P",{"data-svelte-h":!0}),d($)!=="svelte-1m8ksnz"&&($.innerHTML=ws),ss=n(s),k=m(s,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Js),ts=n(s),o(Z.$$.fragment,s),es=n(s),W=m(s,"P",{"data-svelte-h":!0}),d(W)!=="svelte-9sr7nh"&&(W.textContent=js),ls=n(s),o(N.$$.fragment,s),as=n(s),B=m(s,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1kguc51"&&(B.innerHTML=us),ns=n(s),o(x.$$.fragment,s),ps=n(s),G=m(s,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1n0coha"&&(G.innerHTML=Ts),ms=n(s),o(E.$$.fragment,s),is=n(s),o(Q.$$.fragment,s),os=n(s),X=m(s,"P",{}),fs(X).forEach(e),this.h()},h(){bs(y,"name","hf:doc:metadata"),bs(y,"content",Bs)},m(s,t){Ws(document.head,y),l(s,_,t),l(s,R,t),l(s,S,t),r(g,s,t),l(s,Y,t),l(s,w,t),l(s,z,t),r(J,s,t),l(s,F,t),l(s,j,t),l(s,H,t),r(u,s,t),l(s,A,t),l(s,T,t),l(s,L,t),r(f,s,t),l(s,q,t),l(s,b,t),l(s,D,t),r(U,s,t),l(s,P,t),l(s,C,t),l(s,K,t),r(I,s,t),l(s,O,t),l(s,$,t),l(s,ss,t),l(s,k,t),l(s,ts,t),r(Z,s,t),l(s,es,t),l(s,W,t),l(s,ls,t),r(N,s,t),l(s,as,t),l(s,B,t),l(s,ns,t),r(x,s,t),l(s,ps,t),l(s,G,t),l(s,ms,t),r(E,s,t),l(s,is,t),r(Q,s,t),l(s,os,t),l(s,X,t),rs=!0},p:Cs,i(s){rs||(c(g.$$.fragment,s),c(J.$$.fragment,s),c(u.$$.fragment,s),c(f.$$.fragment,s),c(U.$$.fragment,s),c(I.$$.fragment,s),c(Z.$$.fragment,s),c(N.$$.fragment,s),c(x.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),rs=!0)},o(s){h(g.$$.fragment,s),h(J.$$.fragment,s),h(u.$$.fragment,s),h(f.$$.fragment,s),h(U.$$.fragment,s),h(I.$$.fragment,s),h(Z.$$.fragment,s),h(N.$$.fragment,s),h(x.$$.fragment,s),h(E.$$.fragment,s),h(Q.$$.fragment,s),rs=!1},d(s){s&&(e(_),e(R),e(S),e(Y),e(w),e(z),e(F),e(j),e(H),e(A),e(T),e(L),e(q),e(b),e(D),e(P),e(C),e(K),e(O),e($),e(ss),e(k),e(ts),e(es),e(W),e(ls),e(as),e(B),e(ns),e(ps),e(G),e(ms),e(is),e(os),e(X)),e(y),M(g,s),M(J,s),M(u,s),M(f,s),M(U,s),M(I,s),M(Z,s),M(N,s),M(x,s),M(E,s),M(Q,s)}}}const Bs='{"title":"SE-ResNet","local":"se-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xs(cs){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rs extends $s{constructor(y){super(),ks(this,y,xs,Ns,Us,{})}}export{Rs as component};
