import{s as dn,f as pn,o as hn,n as Ye}from"../chunks/scheduler.9bc65507.js";import{S as gn,i as fn,g as s,s as r,u as _,A as un,h as n,f as t,c as i,j as f,v as b,y as h,k as d,o,a as m,w as y,d as M,t as k,x as v}from"../chunks/index.78c82d43.js";import{T as cn}from"../chunks/Tip.87d55b76.js";import{D as $}from"../chunks/Docstring.f3d04bd2.js";import{C as Bt}from"../chunks/CodeBlock.48618ec2.js";import{I as pe}from"../chunks/IconCopyLink.bedaa44d.js";import{E as Vt}from"../chunks/ExampleCodeBlock.872b014d.js";function _n(j){let c,w="Examples:",g,p,u;return p=new Bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2syRm9ybWVyQ29uZmlnJTJDJTIwTWFzazJGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXNrMkZvcm1lciUyMGZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrMkZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mask2FormerConfig, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mask2Former facebook/mask2former-swin-small-coco-instance configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mask2FormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/mask2former-swin-small-coco-instance style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){c=s("p"),c.textContent=w,g=r(),_(p.$$.fragment)},l(a){c=n(a,"P",{"data-svelte-h":!0}),h(c)!=="svelte-kvfsh7"&&(c.textContent=w),g=i(a),b(p.$$.fragment,a)},m(a,F){m(a,c,F),m(a,g,F),y(p,a,F),u=!0},p:Ye,i(a){u||(M(p.$$.fragment,a),u=!0)},o(a){k(p.$$.fragment,a),u=!1},d(a){a&&(t(c),t(g)),v(p,a)}}}function bn(j){let c,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=s("p"),c.innerHTML=w},l(g){c=n(g,"P",{"data-svelte-h":!0}),h(c)!=="svelte-fincs2"&&(c.innerHTML=w)},m(g,p){m(g,c,p)},p:Ye,d(g){g&&t(c)}}}function yn(j){let c,w="Examples:",g,p,u;return p=new Bt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBNYXNrMkZvcm1lck1vZGVsJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMHByZXByb2Nlc3NvciUyMGFuZCUyME1hc2syRm9ybWVyTW9kZWwlMjB0cmFpbmVkJTIwb24lMjBDT0NPJTIwaW5zdGFuY2UlMjBzZWdtZW50YXRpb24lMjBkYXRhc2V0JTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMG1vZGVsJTIwb3V0cHV0cyUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQXByaW50KG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image preprocessor and Mask2FormerModel trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model outputs last hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.transformer_decoder_last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>])`}}),{c(){c=s("p"),c.textContent=w,g=r(),_(p.$$.fragment)},l(a){c=n(a,"P",{"data-svelte-h":!0}),h(c)!=="svelte-kvfsh7"&&(c.textContent=w),g=i(a),b(p.$$.fragment,a)},m(a,F){m(a,c,F),m(a,g,F),y(p,a,F),u=!0},p:Ye,i(a){u||(M(p.$$.fragment,a),u=!0)},o(a){k(p.$$.fragment,a),u=!1},d(a){a&&(t(c),t(g)),v(p,a)}}}function Mn(j){let c,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=s("p"),c.innerHTML=w},l(g){c=n(g,"P",{"data-svelte-h":!0}),h(c)!=="svelte-fincs2"&&(c.innerHTML=w)},m(g,p){m(g,c,p)},p:Ye,d(g){g&&t(c)}}}function kn(j){let c,w="Instance segmentation example:",g,p,u;return p=new Bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENPQ08lMjBpbnN0YW5jZSUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMGluc3RhbmNlJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9pbnN0YW5jZV9tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX2luc3RhbmNlX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get instance segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_instance_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_instance_map.shape)
torch.Size([<span class="hljs-number">480</span>, <span class="hljs-number">640</span>])`}}),{c(){c=s("p"),c.textContent=w,g=r(),_(p.$$.fragment)},l(a){c=n(a,"P",{"data-svelte-h":!0}),h(c)!=="svelte-1xhxiwz"&&(c.textContent=w),g=i(a),b(p.$$.fragment,a)},m(a,F){m(a,c,F),m(a,g,F),y(p,a,F),u=!0},p:Ye,i(a){u||(M(p.$$.fragment,a),u=!0)},o(a){k(p.$$.fragment,a),u=!1},d(a){a&&(t(c),t(g)),v(p,a)}}}function vn(j){let c,w="Semantic segmentation example:",g,p,u;return p=new Bt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMEFERTIwayUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwZGF0YXNldCUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLXNtYWxsLWFkZS1zZW1hbnRpYyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtYWRlLXNlbWFudGljJTIyKSUwQSUwQXVybCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfYWRlMjBrJTJGcmVzb2x2ZSUyRm1haW4lMkZBREVfdmFsXzAwMDAwMDAxLmpwZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9zZW1hbnRpY19tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX3NlbWFudGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on ADE20k semantic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get semantic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_semantic_map.shape)
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">683</span>])`}}),{c(){c=s("p"),c.textContent=w,g=r(),_(p.$$.fragment)},l(a){c=n(a,"P",{"data-svelte-h":!0}),h(c)!=="svelte-ec2k7m"&&(c.textContent=w),g=i(a),b(p.$$.fragment,a)},m(a,F){m(a,c,F),m(a,g,F),y(p,a,F),u=!0},p:Ye,i(a){u||(M(p.$$.fragment,a),u=!0)},o(a){k(p.$$.fragment,a),u=!1},d(a){a&&(t(c),t(g)),v(p,a)}}}function wn(j){let c,w="Panoptic segmentation example:",g,p,u;return p=new Bt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on CityScapes panoptic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://cdn-media.huggingface.co/Inference-API/Sample-results-on-the-Cityscapes-dataset-The-above-images-show-how-our-method-can-handle.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get panoptic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_panoptic_map = image_processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_panoptic_map.shape)
torch.Size([<span class="hljs-number">338</span>, <span class="hljs-number">676</span>])`}}),{c(){c=s("p"),c.textContent=w,g=r(),_(p.$$.fragment)},l(a){c=n(a,"P",{"data-svelte-h":!0}),h(c)!=="svelte-1hqqxa2"&&(c.textContent=w),g=i(a),b(p.$$.fragment,a)},m(a,F){m(a,c,F),m(a,g,F),y(p,a,F),u=!0},p:Ye,i(a){u||(M(p.$$.fragment,a),u=!0)},o(a){k(p.$$.fragment,a),u=!1},d(a){a&&(t(c),t(g)),v(p,a)}}}function Fn(j){let c,w,g,p,u,a,F,he,Fo,Ae,ps="Mask2Former",Lt,X,E,Ut,ge,To,Qe,hs="Overview",Rt,fe,gs='The Mask2Former model was proposed in <a href="https://arxiv.org/abs/2112.01527" rel="nofollow">Masked-attention Mask Transformer for Universal Image Segmentation</a> by Bowen Cheng, Ishan Misra, Alexander G. Schwing, Alexander Kirillov, Rohit Girdhar. Mask2Former is a unified framework for panoptic, instance and semantic segmentation and features significant performance and efficiency improvements over <a href="maskformer">MaskFormer</a>.',Pt,ue,fs="The abstract from the paper is the following:",Gt,_e,us=`<em>Image segmentation groups pixels with different semantics, e.g., category or instance membership. Each choice
of semantics defines a task. While only the semantics of each task differ, current research focuses on designing specialized architectures for each task. We present Masked-attention Mask Transformer (Mask2Former), a new architecture capable of addressing any image segmentation task (panoptic, instance or semantic). Its key components include masked attention, which extracts localized features by constraining cross-attention within predicted mask regions. In addition to reducing the research effort by at least three times, it outperforms the best specialized architectures by a significant margin on four popular datasets. Most notably, Mask2Former sets a new state-of-the-art for panoptic segmentation (57.8 PQ on COCO), instance segmentation (50.1 AP on COCO) and semantic segmentation (57.7 mIoU on ADE20K).</em>`,Ht,be,_s="Tips:",Et,ye,bs='<li>Mask2Former uses the same preprocessing and postprocessing steps as <a href="maskformer">MaskFormer</a>. Use <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>',qt,q,ys,Yt,Me,Ms='Mask2Former architecture. Taken from the <a href="https://arxiv.org/abs/2112.01527">original paper.</a>',At,ke,ks='This model was contributed by <a href="https://huggingface.co/shivi" rel="nofollow">Shivalika Singh</a> and <a href="https://huggingface.co/adirik" rel="nofollow">Alara Dirik</a>. The original code can be found <a href="https://github.com/facebookresearch/Mask2Former" rel="nofollow">here</a>.',Qt,V,Y,jt,ve,xo,Oe,vs="Resources",Ot,we,ws="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mask2Former.",Dt,Fe,Fs='<li>Demo notebooks regarding inference + fine-tuning Mask2Former on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Mask2Former" rel="nofollow">here</a>.</li>',Kt,Te,Ts=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,eo,B,A,Jt,xe,Uo,De,xs="MaskFormer specific outputs",to,L,Ue,jo,Ke,Us='Class for outputs of <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. This class returns all the needed hidden states to compute the logits.',oo,N,je,Jo,et,js="Class for outputs of <code>Mask2FormerForUniversalSegmentationOutput</code>.",zo,tt,Js=`This output can be directly passed to <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to compute final segmentation maps. Please, see
[\`~Mask2FormerImageProcessor] for details regarding usage.`,so,R,Q,zt,Je,$o,ot,zs="Mask2FormerConfig",no,U,ze,Io,st,$s=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. It is used to instantiate a
Mask2Former model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Mask2Former
<a href="https://huggingface.co/facebook/mask2former-swin-small-coco-instance" rel="nofollow">facebook/mask2former-swin-small-coco-instance</a>
architecture.`,Co,nt,Is=`Configuration objects inherit from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,No,at,Cs='Currently, Mask2Former only supports the <a href="swin">Swin Transformer</a> as backbone.',Wo,O,Zo,D,$e,So,rt,Ns='Instantiate a <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (or a derived class) from a pre-trained backbone model configuration.',ao,P,K,$t,Ie,Xo,it,Ws="Mask2FormerModel",ro,W,Ce,Vo,lt,Zs=`The bare Mask2Former Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Bo,I,Ne,Lo,mt,Ss='The <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ro,ee,Po,te,io,G,oe,It,We,Go,ct,Xs="Mask2FormerForUniversalSegmentation",lo,Z,Ze,Ho,dt,Vs=`The Mask2Former Model with heads on top for instance/semantic/panoptic segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Eo,x,Se,qo,pt,Bs='The <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Yo,se,Ao,ht,Ls="Examples:",Qo,ne,Oo,ae,Do,re,mo,H,ie,Ct,Xe,Ko,gt,Rs="Mask2FormerImageProcessor",co,T,Ve,es,ft,Ps=`Constructs a Mask2Former image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,ts,ut,Gs=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,os,_t,Be,ss,S,Le,ns,bt,Hs="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",as,yt,Es=`Mask2Former addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,rs,le,Re,is,Mt,qs=`Converts the output of <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,ls,me,Pe,ms,kt,Ys=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into instance segmentation predictions.
Only supports PyTorch.`,cs,ce,Ge,ds,vt,As=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,po,Nt,ho;return he=new pe({}),ge=new pe({}),ve=new pe({}),xe=new pe({}),Ue=new $({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_intermediate_states",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_intermediate_states",description:`<strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"transformer_decoder_intermediate_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from each layer in the transformer decoder.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L146"}}),je=new $({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": typing.Union[typing.List[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.auxiliary_logits",description:`<strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L192"}}),Je=new pe({}),ze=new $({props:{name:"class transformers.Mask2FormerConfig",anchor:"transformers.Mask2FormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"activation_function",val:": str = 'relu'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.0"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_projection",val:": bool = False"},{name:"common_stride",val:": int = 4"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 100"},{name:"no_object_weight",val:": float = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"feature_strides",val:": typing.List[int] = [4, 8, 16, 32]"},{name:"output_auxiliary_logits",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>SwinConfig()</code>) &#x2014;
The configuration of the backbone model. If unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.Mask2FormerConfig.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The features (channels) of the resulting feature maps.`,name:"feature_size"},{anchor:"transformers.Mask2FormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.Mask2FormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of feedforward network for deformable detr encoder used as part of pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in the deformable detr encoder used as part of pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.Mask2FormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.Mask2FormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Mask2FormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder.`,name:"dropout"},{anchor:"transformers.Mask2FormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Feature dimension in feedforward network for transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.Mask2FormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pre-LayerNorm or not for transformer decoder.`,name:"pre_norm"},{anchor:"transformers.Mask2FormerConfig.enforce_input_projection",description:`<strong>enforce_input_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an input projection 1x1 convolution even if the input channels and hidden dim are identical
in the Transformer decoder.`,name:"enforce_input_projection"},{anchor:"transformers.Mask2FormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Parameter used for determining number of FPN levels used as part of pixel decoder.`,name:"common_stride"},{anchor:"transformers.Mask2FormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Category id to be ignored during training.`,name:"ignore_value"},{anchor:"transformers.Mask2FormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of queries for the decoder.`,name:"num_queries"},{anchor:"transformers.Mask2FormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.Mask2FormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The weight for the cross entropy loss.`,name:"class_weight"},{anchor:"transformers.Mask2FormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.Mask2FormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.Mask2FormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points used for sampling during loss calculation.`,name:"train_num_points"},{anchor:"transformers.Mask2FormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Oversampling parameter used for calculating no. of sampled points`,name:"oversample_ratio"},{anchor:"transformers.Mask2FormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.Mask2FormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.Mask2FormerConfig.init_xavier_std",description:"<strong>init_xavier_std</strong> (`float&#x201C;, <em>optional</em>, defaults to 1.0) &#x2014;\nThe scaling factor used for the Xavier initialization gain in the HM Attention map module.",name:"init_xavier_std"},{anchor:"transformers.Mask2FormerConfig.use_auxiliary_loss",description:"<strong>use_auxiliary_loss</strong> (<code>boolean``, *optional*, defaults to </code>True<code>) -- If </code>True<code> </code>Mask2FormerForUniversalSegmentationOutput` will contain the auxiliary losses computed using\nthe logits from each decoder&#x2019;s stage.",name:"use_auxiliary_loss"},{anchor:"transformers.Mask2FormerConfig.feature_strides",description:`<strong>feature_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
Feature strides corresponding to features generated from backbone network.`,name:"feature_strides"},{anchor:"transformers.Mask2FormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/configuration_mask2former.py#L33"}}),O=new Vt({props:{anchor:"transformers.Mask2FormerConfig.example",$$slots:{default:[_n]},$$scope:{ctx:j}}}),$e=new $({props:{name:"from_backbone_config",anchor:"transformers.Mask2FormerConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.33.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/configuration_mask2former.py#L217",returnDescription:`
<p>An instance of a configuration object</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a></p>
`}}),Ie=new pe({}),Ce=new $({props:{name:"class transformers.Mask2FormerModel",anchor:"transformers.Mask2FormerModel",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L2211"}}),Ne=new $({props:{name:"forward",anchor:"transformers.Mask2FormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L2221",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from each layer in the transformer decoder.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerModelOutput</code></p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ee=new cn({props:{$$slots:{default:[bn]},$$scope:{ctx:j}}}),te=new Vt({props:{anchor:"transformers.Mask2FormerModel.forward.example",$$slots:{default:[yn]},$$scope:{ctx:j}}}),We=new pe({}),Ze=new $({props:{name:"class transformers.Mask2FormerForUniversalSegmentation",anchor:"transformers.Mask2FormerForUniversalSegmentation",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.33.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L2315"}}),Se=new $({props:{name:"forward",anchor:"transformers.Mask2FormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.33.3/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/modeling_mask2former.py#L2368",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerUniversalSegmentationOutput</code></p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),se=new cn({props:{$$slots:{default:[Mn]},$$scope:{ctx:j}}}),ne=new Vt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example",$$slots:{default:[kn]},$$scope:{ctx:j}}}),ae=new Vt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-2",$$slots:{default:[vn]},$$scope:{ctx:j}}}),re=new Vt({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-3",$$slots:{default:[wn]},$$scope:{ctx:j}}}),Xe=new pe({}),Ve=new $({props:{name:"class transformers.Mask2FormerImageProcessor",anchor:"transformers.Mask2FormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.Mask2FormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.Mask2FormerImageProcessor.max_size",description:`<strong>max_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1333) &#x2014;
The largest size an image dimension can have (otherwise it&#x2019;s capped). Only has an effect if <code>do_resize</code> is
set to <code>True</code>.`,name:"max_size"},{anchor:"transformers.Mask2FormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>PIL.Image.Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.Mask2FormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.Mask2FormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.Mask2FormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1/ 255) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Mask2FormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.Mask2FormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.Mask2FormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.Mask2FormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.Mask2FormerImageProcessor.reduce_labels",description:`<strong>reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L343"}}),Be=new $({props:{name:"preprocess",anchor:"transformers.Mask2FormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L671"}}),Le=new $({props:{name:"encode_inputs",anchor:"transformers.Mask2FormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.33.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L859",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.33.3/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.33.3/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Re=new $({props:{name:"post_process_semantic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L962",returnDescription:`
<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`
<p><code>List[torch.Tensor]</code></p>
`}}),Pe=new $({props:{name:"post_process_instance_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L1017",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),Ge=new $({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>Mask2FormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.33.3/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.33.3/src/transformers/models/mask2former/image_processing_mask2former.py#L1136",returnDescription:`
<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`
<p><code>List[Dict]</code></p>
`}}),{c(){c=s("meta"),w=r(),g=s("p"),p=r(),u=s("h1"),a=s("a"),F=s("span"),_(he.$$.fragment),Fo=r(),Ae=s("span"),Ae.textContent=ps,Lt=r(),X=s("h2"),E=s("a"),Ut=s("span"),_(ge.$$.fragment),To=r(),Qe=s("span"),Qe.textContent=hs,Rt=r(),fe=s("p"),fe.innerHTML=gs,Pt=r(),ue=s("p"),ue.textContent=fs,Gt=r(),_e=s("p"),_e.innerHTML=us,Ht=r(),be=s("p"),be.textContent=_s,Et=r(),ye=s("ul"),ye.innerHTML=bs,qt=r(),q=s("img"),Yt=r(),Me=s("small"),Me.innerHTML=Ms,At=r(),ke=s("p"),ke.innerHTML=ks,Qt=r(),V=s("h2"),Y=s("a"),jt=s("span"),_(ve.$$.fragment),xo=r(),Oe=s("span"),Oe.textContent=vs,Ot=r(),we=s("p"),we.textContent=ws,Dt=r(),Fe=s("ul"),Fe.innerHTML=Fs,Kt=r(),Te=s("p"),Te.textContent=Ts,eo=r(),B=s("h2"),A=s("a"),Jt=s("span"),_(xe.$$.fragment),Uo=r(),De=s("span"),De.textContent=xs,to=r(),L=s("div"),_(Ue.$$.fragment),jo=r(),Ke=s("p"),Ke.innerHTML=Us,oo=r(),N=s("div"),_(je.$$.fragment),Jo=r(),et=s("p"),et.innerHTML=js,zo=r(),tt=s("p"),tt.innerHTML=Js,so=r(),R=s("h2"),Q=s("a"),zt=s("span"),_(Je.$$.fragment),$o=r(),ot=s("span"),ot.textContent=zs,no=r(),U=s("div"),_(ze.$$.fragment),Io=r(),st=s("p"),st.innerHTML=$s,Co=r(),nt=s("p"),nt.innerHTML=Is,No=r(),at=s("p"),at.innerHTML=Cs,Wo=r(),_(O.$$.fragment),Zo=r(),D=s("div"),_($e.$$.fragment),So=r(),rt=s("p"),rt.innerHTML=Ns,ao=r(),P=s("h2"),K=s("a"),$t=s("span"),_(Ie.$$.fragment),Xo=r(),it=s("span"),it.textContent=Ws,ro=r(),W=s("div"),_(Ce.$$.fragment),Vo=r(),lt=s("p"),lt.innerHTML=Zs,Bo=r(),I=s("div"),_(Ne.$$.fragment),Lo=r(),mt=s("p"),mt.innerHTML=Ss,Ro=r(),_(ee.$$.fragment),Po=r(),_(te.$$.fragment),io=r(),G=s("h2"),oe=s("a"),It=s("span"),_(We.$$.fragment),Go=r(),ct=s("span"),ct.textContent=Xs,lo=r(),Z=s("div"),_(Ze.$$.fragment),Ho=r(),dt=s("p"),dt.innerHTML=Vs,Eo=r(),x=s("div"),_(Se.$$.fragment),qo=r(),pt=s("p"),pt.innerHTML=Bs,Yo=r(),_(se.$$.fragment),Ao=r(),ht=s("p"),ht.textContent=Ls,Qo=r(),_(ne.$$.fragment),Oo=r(),_(ae.$$.fragment),Do=r(),_(re.$$.fragment),mo=r(),H=s("h2"),ie=s("a"),Ct=s("span"),_(Xe.$$.fragment),Ko=r(),gt=s("span"),gt.textContent=Rs,co=r(),T=s("div"),_(Ve.$$.fragment),es=r(),ft=s("p"),ft.textContent=Ps,ts=r(),ut=s("p"),ut.innerHTML=Gs,os=r(),_t=s("div"),_(Be.$$.fragment),ss=r(),S=s("div"),_(Le.$$.fragment),ns=r(),bt=s("p"),bt.innerHTML=Hs,as=r(),yt=s("p"),yt.innerHTML=Es,rs=r(),le=s("div"),_(Re.$$.fragment),is=r(),Mt=s("p"),Mt.innerHTML=qs,ls=r(),me=s("div"),_(Pe.$$.fragment),ms=r(),kt=s("p"),kt.innerHTML=Ys,cs=r(),ce=s("div"),_(Ge.$$.fragment),ds=r(),vt=s("p"),vt.innerHTML=As,po=r(),Nt=s("p"),this.h()},l(e){const l=un("svelte-1phssyn",document.head);c=n(l,"META",{name:!0,content:!0}),l.forEach(t),w=i(e),g=n(e,"P",{}),f(g).forEach(t),p=i(e),u=n(e,"H1",{class:!0});var He=f(u);a=n(He,"A",{id:!0,class:!0,href:!0});var Wt=f(a);F=n(Wt,"SPAN",{});var Zt=f(F);b(he.$$.fragment,Zt),Zt.forEach(t),Wt.forEach(t),Fo=i(He),Ae=n(He,"SPAN",{"data-svelte-h":!0}),h(Ae)!=="svelte-19gnb4c"&&(Ae.textContent=ps),He.forEach(t),Lt=i(e),X=n(e,"H2",{class:!0});var Ee=f(X);E=n(Ee,"A",{id:!0,class:!0,href:!0});var St=f(E);Ut=n(St,"SPAN",{});var Xt=f(Ut);b(ge.$$.fragment,Xt),Xt.forEach(t),St.forEach(t),To=i(Ee),Qe=n(Ee,"SPAN",{"data-svelte-h":!0}),h(Qe)!=="svelte-1jsw1pg"&&(Qe.textContent=hs),Ee.forEach(t),Rt=i(e),fe=n(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-vv3e67"&&(fe.innerHTML=gs),Pt=i(e),ue=n(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-vfdo9a"&&(ue.textContent=fs),Gt=i(e),_e=n(e,"P",{"data-svelte-h":!0}),h(_e)!=="svelte-12dpxkq"&&(_e.innerHTML=us),Ht=i(e),be=n(e,"P",{"data-svelte-h":!0}),h(be)!=="svelte-axv494"&&(be.textContent=_s),Et=i(e),ye=n(e,"UL",{"data-svelte-h":!0}),h(ye)!=="svelte-aue2co"&&(ye.innerHTML=bs),qt=i(e),q=n(e,"IMG",{src:!0,alt:!0,width:!0}),Yt=i(e),Me=n(e,"SMALL",{"data-svelte-h":!0}),h(Me)!=="svelte-1qlm9ke"&&(Me.innerHTML=Ms),At=i(e),ke=n(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-12ct8xd"&&(ke.innerHTML=ks),Qt=i(e),V=n(e,"H2",{class:!0});var qe=f(V);Y=n(qe,"A",{id:!0,class:!0,href:!0});var Qs=f(Y);jt=n(Qs,"SPAN",{});var Os=f(jt);b(ve.$$.fragment,Os),Os.forEach(t),Qs.forEach(t),xo=i(qe),Oe=n(qe,"SPAN",{"data-svelte-h":!0}),h(Oe)!=="svelte-w4zzv6"&&(Oe.textContent=vs),qe.forEach(t),Ot=i(e),we=n(e,"P",{"data-svelte-h":!0}),h(we)!=="svelte-m0sdby"&&(we.textContent=ws),Dt=i(e),Fe=n(e,"UL",{"data-svelte-h":!0}),h(Fe)!=="svelte-783z7i"&&(Fe.innerHTML=Fs),Kt=i(e),Te=n(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-1rggs50"&&(Te.textContent=Ts),eo=i(e),B=n(e,"H2",{class:!0});var go=f(B);A=n(go,"A",{id:!0,class:!0,href:!0});var Ds=f(A);Jt=n(Ds,"SPAN",{});var Ks=f(Jt);b(xe.$$.fragment,Ks),Ks.forEach(t),Ds.forEach(t),Uo=i(go),De=n(go,"SPAN",{"data-svelte-h":!0}),h(De)!=="svelte-7euy36"&&(De.textContent=xs),go.forEach(t),to=i(e),L=n(e,"DIV",{class:!0});var fo=f(L);b(Ue.$$.fragment,fo),jo=i(fo),Ke=n(fo,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-uhlsuh"&&(Ke.innerHTML=Us),fo.forEach(t),oo=i(e),N=n(e,"DIV",{class:!0});var wt=f(N);b(je.$$.fragment,wt),Jo=i(wt),et=n(wt,"P",{"data-svelte-h":!0}),h(et)!=="svelte-1cgna0v"&&(et.innerHTML=js),zo=i(wt),tt=n(wt,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-127kxvf"&&(tt.innerHTML=Js),wt.forEach(t),so=i(e),R=n(e,"H2",{class:!0});var uo=f(R);Q=n(uo,"A",{id:!0,class:!0,href:!0});var en=f(Q);zt=n(en,"SPAN",{});var tn=f(zt);b(Je.$$.fragment,tn),tn.forEach(t),en.forEach(t),$o=i(uo),ot=n(uo,"SPAN",{"data-svelte-h":!0}),h(ot)!=="svelte-1scze76"&&(ot.textContent=zs),uo.forEach(t),no=i(e),U=n(e,"DIV",{class:!0});var C=f(U);b(ze.$$.fragment,C),Io=i(C),st=n(C,"P",{"data-svelte-h":!0}),h(st)!=="svelte-12qhkc8"&&(st.innerHTML=$s),Co=i(C),nt=n(C,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-cfh5wl"&&(nt.innerHTML=Is),No=i(C),at=n(C,"P",{"data-svelte-h":!0}),h(at)!=="svelte-938vl7"&&(at.innerHTML=Cs),Wo=i(C),b(O.$$.fragment,C),Zo=i(C),D=n(C,"DIV",{class:!0});var _o=f(D);b($e.$$.fragment,_o),So=i(_o),rt=n(_o,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-s1lsol"&&(rt.innerHTML=Ns),_o.forEach(t),C.forEach(t),ao=i(e),P=n(e,"H2",{class:!0});var bo=f(P);K=n(bo,"A",{id:!0,class:!0,href:!0});var on=f(K);$t=n(on,"SPAN",{});var sn=f($t);b(Ie.$$.fragment,sn),sn.forEach(t),on.forEach(t),Xo=i(bo),it=n(bo,"SPAN",{"data-svelte-h":!0}),h(it)!=="svelte-lpfvy9"&&(it.textContent=Ws),bo.forEach(t),ro=i(e),W=n(e,"DIV",{class:!0});var Ft=f(W);b(Ce.$$.fragment,Ft),Vo=i(Ft),lt=n(Ft,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-14icbh2"&&(lt.innerHTML=Zs),Bo=i(Ft),I=n(Ft,"DIV",{class:!0});var de=f(I);b(Ne.$$.fragment,de),Lo=i(de),mt=n(de,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-mi8l6s"&&(mt.innerHTML=Ss),Ro=i(de),b(ee.$$.fragment,de),Po=i(de),b(te.$$.fragment,de),de.forEach(t),Ft.forEach(t),io=i(e),G=n(e,"H2",{class:!0});var yo=f(G);oe=n(yo,"A",{id:!0,class:!0,href:!0});var nn=f(oe);It=n(nn,"SPAN",{});var an=f(It);b(We.$$.fragment,an),an.forEach(t),nn.forEach(t),Go=i(yo),ct=n(yo,"SPAN",{"data-svelte-h":!0}),h(ct)!=="svelte-hd0z5y"&&(ct.textContent=Xs),yo.forEach(t),lo=i(e),Z=n(e,"DIV",{class:!0});var Tt=f(Z);b(Ze.$$.fragment,Tt),Ho=i(Tt),dt=n(Tt,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-dh9ww1"&&(dt.innerHTML=Vs),Eo=i(Tt),x=n(Tt,"DIV",{class:!0});var z=f(x);b(Se.$$.fragment,z),qo=i(z),pt=n(z,"P",{"data-svelte-h":!0}),h(pt)!=="svelte-52i1go"&&(pt.innerHTML=Bs),Yo=i(z),b(se.$$.fragment,z),Ao=i(z),ht=n(z,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-kvfsh7"&&(ht.textContent=Ls),Qo=i(z),b(ne.$$.fragment,z),Oo=i(z),b(ae.$$.fragment,z),Do=i(z),b(re.$$.fragment,z),z.forEach(t),Tt.forEach(t),mo=i(e),H=n(e,"H2",{class:!0});var Mo=f(H);ie=n(Mo,"A",{id:!0,class:!0,href:!0});var rn=f(ie);Ct=n(rn,"SPAN",{});var ln=f(Ct);b(Xe.$$.fragment,ln),ln.forEach(t),rn.forEach(t),Ko=i(Mo),gt=n(Mo,"SPAN",{"data-svelte-h":!0}),h(gt)!=="svelte-pmr81n"&&(gt.textContent=Rs),Mo.forEach(t),co=i(e),T=n(e,"DIV",{class:!0});var J=f(T);b(Ve.$$.fragment,J),es=i(J),ft=n(J,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-1te0494"&&(ft.textContent=Ps),ts=i(J),ut=n(J,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-1wh3jgn"&&(ut.innerHTML=Gs),os=i(J),_t=n(J,"DIV",{class:!0});var mn=f(_t);b(Be.$$.fragment,mn),mn.forEach(t),ss=i(J),S=n(J,"DIV",{class:!0});var xt=f(S);b(Le.$$.fragment,xt),ns=i(xt),bt=n(xt,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-1tetyua"&&(bt.innerHTML=Hs),as=i(xt),yt=n(xt,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-1gqhxe4"&&(yt.innerHTML=Es),xt.forEach(t),rs=i(J),le=n(J,"DIV",{class:!0});var ko=f(le);b(Re.$$.fragment,ko),is=i(ko),Mt=n(ko,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-1hkti6t"&&(Mt.innerHTML=qs),ko.forEach(t),ls=i(J),me=n(J,"DIV",{class:!0});var vo=f(me);b(Pe.$$.fragment,vo),ms=i(vo),kt=n(vo,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-31bvgi"&&(kt.innerHTML=Ys),vo.forEach(t),cs=i(J),ce=n(J,"DIV",{class:!0});var wo=f(ce);b(Ge.$$.fragment,wo),ds=i(wo),vt=n(wo,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-ay0y3u"&&(vt.innerHTML=As),wo.forEach(t),J.forEach(t),po=i(e),Nt=n(e,"P",{}),f(Nt).forEach(t),this.h()},h(){d(c,"name","hf:doc:metadata"),d(c,"content",JSON.stringify(Tn)),d(a,"id","mask2former"),d(a,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(a,"href","#mask2former"),d(u,"class","relative group"),d(E,"id","overview"),d(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(E,"href","#overview"),d(X,"class","relative group"),pn(q.src,ys="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/mask2former_architecture.jpg")||d(q,"src",ys),d(q,"alt","drawing"),d(q,"width","600"),d(Y,"id","resources"),d(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Y,"href","#resources"),d(V,"class","relative group"),d(A,"id","transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"),d(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(A,"href","#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"),d(B,"class","relative group"),d(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Q,"id","transformers.Mask2FormerConfig"),d(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Q,"href","#transformers.Mask2FormerConfig"),d(R,"class","relative group"),d(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(K,"id","transformers.Mask2FormerModel"),d(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(K,"href","#transformers.Mask2FormerModel"),d(P,"class","relative group"),d(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(oe,"id","transformers.Mask2FormerForUniversalSegmentation"),d(oe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(oe,"href","#transformers.Mask2FormerForUniversalSegmentation"),d(G,"class","relative group"),d(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ie,"id","transformers.Mask2FormerImageProcessor"),d(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ie,"href","#transformers.Mask2FormerImageProcessor"),d(H,"class","relative group"),d(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){o(document.head,c),m(e,w,l),m(e,g,l),m(e,p,l),m(e,u,l),o(u,a),o(a,F),y(he,F,null),o(u,Fo),o(u,Ae),m(e,Lt,l),m(e,X,l),o(X,E),o(E,Ut),y(ge,Ut,null),o(X,To),o(X,Qe),m(e,Rt,l),m(e,fe,l),m(e,Pt,l),m(e,ue,l),m(e,Gt,l),m(e,_e,l),m(e,Ht,l),m(e,be,l),m(e,Et,l),m(e,ye,l),m(e,qt,l),m(e,q,l),m(e,Yt,l),m(e,Me,l),m(e,At,l),m(e,ke,l),m(e,Qt,l),m(e,V,l),o(V,Y),o(Y,jt),y(ve,jt,null),o(V,xo),o(V,Oe),m(e,Ot,l),m(e,we,l),m(e,Dt,l),m(e,Fe,l),m(e,Kt,l),m(e,Te,l),m(e,eo,l),m(e,B,l),o(B,A),o(A,Jt),y(xe,Jt,null),o(B,Uo),o(B,De),m(e,to,l),m(e,L,l),y(Ue,L,null),o(L,jo),o(L,Ke),m(e,oo,l),m(e,N,l),y(je,N,null),o(N,Jo),o(N,et),o(N,zo),o(N,tt),m(e,so,l),m(e,R,l),o(R,Q),o(Q,zt),y(Je,zt,null),o(R,$o),o(R,ot),m(e,no,l),m(e,U,l),y(ze,U,null),o(U,Io),o(U,st),o(U,Co),o(U,nt),o(U,No),o(U,at),o(U,Wo),y(O,U,null),o(U,Zo),o(U,D),y($e,D,null),o(D,So),o(D,rt),m(e,ao,l),m(e,P,l),o(P,K),o(K,$t),y(Ie,$t,null),o(P,Xo),o(P,it),m(e,ro,l),m(e,W,l),y(Ce,W,null),o(W,Vo),o(W,lt),o(W,Bo),o(W,I),y(Ne,I,null),o(I,Lo),o(I,mt),o(I,Ro),y(ee,I,null),o(I,Po),y(te,I,null),m(e,io,l),m(e,G,l),o(G,oe),o(oe,It),y(We,It,null),o(G,Go),o(G,ct),m(e,lo,l),m(e,Z,l),y(Ze,Z,null),o(Z,Ho),o(Z,dt),o(Z,Eo),o(Z,x),y(Se,x,null),o(x,qo),o(x,pt),o(x,Yo),y(se,x,null),o(x,Ao),o(x,ht),o(x,Qo),y(ne,x,null),o(x,Oo),y(ae,x,null),o(x,Do),y(re,x,null),m(e,mo,l),m(e,H,l),o(H,ie),o(ie,Ct),y(Xe,Ct,null),o(H,Ko),o(H,gt),m(e,co,l),m(e,T,l),y(Ve,T,null),o(T,es),o(T,ft),o(T,ts),o(T,ut),o(T,os),o(T,_t),y(Be,_t,null),o(T,ss),o(T,S),y(Le,S,null),o(S,ns),o(S,bt),o(S,as),o(S,yt),o(T,rs),o(T,le),y(Re,le,null),o(le,is),o(le,Mt),o(T,ls),o(T,me),y(Pe,me,null),o(me,ms),o(me,kt),o(T,cs),o(T,ce),y(Ge,ce,null),o(ce,ds),o(ce,vt),m(e,po,l),m(e,Nt,l),ho=!0},p(e,[l]){const He={};l&2&&(He.$$scope={dirty:l,ctx:e}),O.$set(He);const Wt={};l&2&&(Wt.$$scope={dirty:l,ctx:e}),ee.$set(Wt);const Zt={};l&2&&(Zt.$$scope={dirty:l,ctx:e}),te.$set(Zt);const Ee={};l&2&&(Ee.$$scope={dirty:l,ctx:e}),se.$set(Ee);const St={};l&2&&(St.$$scope={dirty:l,ctx:e}),ne.$set(St);const Xt={};l&2&&(Xt.$$scope={dirty:l,ctx:e}),ae.$set(Xt);const qe={};l&2&&(qe.$$scope={dirty:l,ctx:e}),re.$set(qe)},i(e){ho||(M(he.$$.fragment,e),M(ge.$$.fragment,e),M(ve.$$.fragment,e),M(xe.$$.fragment,e),M(Ue.$$.fragment,e),M(je.$$.fragment,e),M(Je.$$.fragment,e),M(ze.$$.fragment,e),M(O.$$.fragment,e),M($e.$$.fragment,e),M(Ie.$$.fragment,e),M(Ce.$$.fragment,e),M(Ne.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(Se.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(ae.$$.fragment,e),M(re.$$.fragment,e),M(Xe.$$.fragment,e),M(Ve.$$.fragment,e),M(Be.$$.fragment,e),M(Le.$$.fragment,e),M(Re.$$.fragment,e),M(Pe.$$.fragment,e),M(Ge.$$.fragment,e),ho=!0)},o(e){k(he.$$.fragment,e),k(ge.$$.fragment,e),k(ve.$$.fragment,e),k(xe.$$.fragment,e),k(Ue.$$.fragment,e),k(je.$$.fragment,e),k(Je.$$.fragment,e),k(ze.$$.fragment,e),k(O.$$.fragment,e),k($e.$$.fragment,e),k(Ie.$$.fragment,e),k(Ce.$$.fragment,e),k(Ne.$$.fragment,e),k(ee.$$.fragment,e),k(te.$$.fragment,e),k(We.$$.fragment,e),k(Ze.$$.fragment,e),k(Se.$$.fragment,e),k(se.$$.fragment,e),k(ne.$$.fragment,e),k(ae.$$.fragment,e),k(re.$$.fragment,e),k(Xe.$$.fragment,e),k(Ve.$$.fragment,e),k(Be.$$.fragment,e),k(Le.$$.fragment,e),k(Re.$$.fragment,e),k(Pe.$$.fragment,e),k(Ge.$$.fragment,e),ho=!1},d(e){e&&(t(w),t(g),t(p),t(u),t(Lt),t(X),t(Rt),t(fe),t(Pt),t(ue),t(Gt),t(_e),t(Ht),t(be),t(Et),t(ye),t(qt),t(q),t(Yt),t(Me),t(At),t(ke),t(Qt),t(V),t(Ot),t(we),t(Dt),t(Fe),t(Kt),t(Te),t(eo),t(B),t(to),t(L),t(oo),t(N),t(so),t(R),t(no),t(U),t(ao),t(P),t(ro),t(W),t(io),t(G),t(lo),t(Z),t(mo),t(H),t(co),t(T),t(po),t(Nt)),t(c),v(he),v(ge),v(ve),v(xe),v(Ue),v(je),v(Je),v(ze),v(O),v($e),v(Ie),v(Ce),v(Ne),v(ee),v(te),v(We),v(Ze),v(Se),v(se),v(ne),v(ae),v(re),v(Xe),v(Ve),v(Be),v(Le),v(Re),v(Pe),v(Ge)}}}const Tn={local:"mask2former",sections:[{local:"overview",title:"Overview"},{local:"resources",title:"Resources"},{local:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",title:"MaskFormer specific outputs"},{local:"transformers.Mask2FormerConfig",title:"Mask2FormerConfig"},{local:"transformers.Mask2FormerModel",title:"Mask2FormerModel"},{local:"transformers.Mask2FormerForUniversalSegmentation",title:"Mask2FormerForUniversalSegmentation"},{local:"transformers.Mask2FormerImageProcessor",title:"Mask2FormerImageProcessor"}],title:"Mask2Former"};function xn(j){return hn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nn extends gn{constructor(c){super(),fn(this,c,xn,Fn,dn,{})}}export{Nn as component};
