import{s as ns,n as as,o as os}from"../chunks/scheduler.7bc62968.js";import{S as is,i as ps,g as o,s as n,r as ae,A as rs,h as i,f as s,c as a,j as ts,u as oe,x as p,k as ss,y as _s,a as l,v as ie,d as pe,t as re,w as _e}from"../chunks/index.2f8492b0.js";import{C as ls}from"../chunks/CodeBlock.4e96d6f7.js";import{H as fe}from"../chunks/Heading.14fb2476.js";function hs(Mt){let r,ce,he,ue,_,we,h,ge,M,ft=`Convolution is an operation used to extract features from data. The data can be 1D, 2D or 3D. We’ll explain the operation with a solid example. All you need to know now is that the operation simply takes a matrix made of numbers, moves it through the data, and takes the sum of products between the data and that matrix. This matrix is called kernel or filter. You might say, “What does it have to do with the feature extraction, and how am I supposed to apply it?
Don’t panic! We’re getting to it.`,me,f,ct="To illustrate the intuition, let’s take a look at this example. We have this 1D data, and we visualize it. Visualization will help understand the effects of convolution operation.",ye,c,ut='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/kernel_image.png" alt="Kernel Image"/>',Ce,u,wt="We have this kernel [-1, 1]. We’ll start from the left-most element, put the kernel, multiply the overlapping numbers, and sum them up. Kernels have centers; it’s one of the elements. Here, we pick the center as 1 (the element on the right). We picked the center here as 1, assuming an imaginary zero on the left, it is called a pad, you will see later on. Now, the kernel’s center has to touch every single element, so we put a zero to the left of the element for convenience. If we don’t pad it, I’ll have to start multiplying -1 with the left-most element, and 1 will not touch the left-most element, so we apply padding. Let’s see what it looks like.",ve,w,gt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv.jpg" alt="1D Conv"/>',de,g,mt="I’m multiplying the left-most element (that is currently a pad) with -1, and the first element (zero) with 1 and sum them up, get a 0, and note it down. Now, we’ll move the kernel by one position and do the same. Note it down again, this movement is called striding, this is usually done by moving the kernel by one pixel. You can also move it with more pixels. The result (convolved data) is currently an array [0, 0].",je,m,yt=`<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv_multiplication.png" alt="1D Conv Multiplication"/>
We will repeat it until the right element of the kernel touches every element, which yields the below result.`,Te,y,Ct='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/1d_conv_result.png" alt="1D Conv Result"/>',Ue,C,vt="Notice anything? The filter gives the rate of change in the data (the derivatives!). This is one characteristic we could extract from our data. Let’s visualize it.",Xe,v,dt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/convolved_illustrated.png" alt="Convolved Illustrated"/>',Je,d,jt="The convolved data (the result of the convolution) is called a feature map. And it makes sense, as it shows the features we can extract, the characteristics related to the data, and the rate of change.",xe,j,Tt=`This is exactly what edge detection filters do! Let’s see it in 2-dimensional data. This time, our kernel will be different. It will be a 3x3 kernel (just so you know it could’ve been a 2x2 too).
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv.png" alt="2D Conv "/>`,Qe,T,Ut="This filter is actually quite famous, but we won’t spoil it for you now :). The previous filter was [-1 1]. Meanwhile, this one is [-1 0 1]. It’s just of shape 3x3 and nothing different, and it shows increments and decrements on the horizontal axis. Let’s see an example and apply convolution. Below is our 2D data.",Ie,U,Xt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv_matrix.png" alt="2D Conv Matrix"/>',be,X,Jt="Think of this as an image, and we want to extract the horizontal changes. Now, the center of the filter has to touch every single pixel, so we pad the image.",ke,J,xt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/padding.png" alt="Padding"/>',Ne,x,Qt="The feature map will be the same size as the original data. The result of the convolution will be written to the same position that the center of the kernel touched in the original matrix, meaning, for this one, it will touch the leftmost and the top positions.",Ae,Q,It='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_conv_illustrated.png" alt="2d_conv_illustrated"/>',Pe,I,bt="If we keep applying the convolution, we get the following feature map.",$e,b,kt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/2d_feature_map.png" alt="2D Feature Map"/>',De,k,Nt="Which shows us the horizontal changes (the edges). This filter is actually called the Prewitt Filter.",ze,N,At='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/prewitt_sobel.png" alt="Prewitt Sobel"/>',Le,A,Pt='You can flip <a href="https://en.wikipedia.org/wiki/Prewitt_operator" rel="nofollow">the Prewitt filter</a> to get the changes in vertical direction. <a href="https://en.wikipedia.org/wiki/Sobel_operator" rel="nofollow">The Sobel filter</a> is another famous filter for edge detection.',Be,P,$t="## Convolutional Neural Networks",He,$,Dt="Fine, but what does it have to do with deep learning? Well, brute forcing filters to extract features does not work well with every image. Imagine if we could somehow find the optimal filters to extract important information or even detect objects in the images. That’s where convolutional neural networks come into play. We convolve images with various filters, and these pixels in the feature maps will eventually become the parameters that we will optimize, and in the end, we will find the best filters for our problem.",We,D,zt="The idea is, that we will use filters to extract information. We will randomly initialize multiple filters, create our feature maps, feed them to a classifier, and do backpropagation. Before diving into it, I’d like to introduce you to something we call “pooling”.",Ee,z,Lt=`As you can see above, there are many pixels that show the change in the feature map. To know that there’s an edge, we only need to see that there’s a change (an edge, a corner, anything), and that’s it.
<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/max_pooling.png" alt="Max Pooling"/>`,Fe,L,Bt="In the above example, we could have got only one of the two, and that would be enough. This way, we would store fewer parameters and still have the features. This operation of getting the most important element in the feature map is called pooling. With pooling, we lose the exact pixel location of where there’s an edge but we store fewer parameters. Also, this way, our feature extraction mechanism will be more robust to small changes, e.g., we only need to know that there are two eyes, a nose, and a mouth to know that there’s a face in an image, the distance between those elements and the size of those elements tend to change from face to face, and pooling enables the model to be more robust against these changes. Another good thing about pooling is that it helps us handle varying input sizes. We’d like you to watch this video to gain a better intuition. Below is the max pooling operation, where every four pixels, we get the maximum pixel. There are various types of pooling, e.g., average pooling, weighted pooling, or L2 pooling.",Se,B,Ht="Let’s build a simple CNN architecture. We will use a Keras example (for the sake of illustration) and we will walk you through what’s happening. Below is our model (again, don’t panic, we will walk you through what’s happening).",Ge,H,Wt="If you don’t know what Keras Sequential API is doing, it stacks layers like lego bricks and connects them. Each layer has different hyperparameters, the Conv2D layer takes a number of convolution filters, kernel size, and activation function, while MaxPooling2D takes pooling size, and the dense layer takes a number of output units (again, don’t panic).",Ke,W,Et="Most of the convnet implementations don’t do padding for the sake of letting the kernel touch every pixel in an image processing fashion. Padding with zeroes comes with an assumption that we might have features in borders, and it adds complexity for calculation on top. That’s why you see that the first input size is (26,26), we lose information along the borders.",Ye,E,Ze,F,qe,S,Ft="Convolutional neural networks start with an input layer and a convolutional layer. Keras Conv2D layers take a number of kernels and the size of the kernel as parameters. What’s happening is illustrated below. Here, we convolve the image with 32 kernels and end up with 32 feature maps, each having the size of the image.",Ve,G,St='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration.png" alt="Network Illustration"/>',Re,K,Gt="After convolutional layers, we put a max pooling layer to reduce the number of parameters stored and make the model robust to the changes, as discussed above. This will reduce the number of parameters calculated.",Oe,Y,Kt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration_2.png" alt="Network Illustration 2"/>',et,Z,Yt="Then, these feature maps are concatenated together and flattened.",tt,q,Zt='<img src="https://huggingface.co/datasets/hf-vision/course-assets/resolve/main/CNNs/network_illustration_3.png" alt="Network Illustration 3"/>',st,V,qt="Later on, we use something called dropout to drop a portion of parameters to avoid overfitting. Finally, the final form of weights will go through a dense layer to get classified and backpropagation will take place.",lt,R,nt,O,Vt="How does the backpropagation work here? We want to optimize for the best kernel values here, so they’re our weights. In the end, we expect the classifier to figure out the relationship between pixel values, kernels, and classes. Thus, we have a very long flattened array consisting of elements that are pooled and activated versions of pixels convolved with initial weights (the kernel elements). We update those weights such that we answer the question “which kernels should I apply to make a distinction between cat and a dog photo?”. The point of training CNNs is to come up with the optimal kernels, and these are found using backpropagation. Prior to CNNs, people would try to try a lot of filters on an image to extract features themselves, meanwhile most generic filters (as we’ve seen above, e.g., Prewitt or Sobel) do not necessarily work for all images given images can be very different, even in the same dataset. This is why CNNs outperform traditional image processing techniques.",at,ee,Rt="There are a couple of advantages by means of storage when we use convolutional neural networks.",ot,te,it,se,Ot="In convolutional neural networks, we convolve with the same filter across all pixels, all channels, and all images which provides an advantage over storing parameters, this is much more efficient than going through an image with a dense neural network. This is called “weight tying” and those weights are called “tied weights”. This is also seen in autoencoders.",pt,le,rt,ne,es="In densely connected neural networks, we input the whole piece of data at once -which is very overwhelming due to how images have hundreds or thousands of pixels-, meanwhile in convnets, we have smaller kernels that we use to extract features. This is called sparse interaction, and it helps us use less memory.",_t,Me,ht;return _=new fe({props:{title:"Introduction to Convolutional Neural Networks",local:"introduction-to-convolutional-neural-networks",headingTag:"h1"}}),h=new fe({props:{title:"Convolution: Basic Ideas",local:"convolution-basic-ideas",headingTag:"h2"}}),E=new ls({props:{code:"bW9kZWwlMjAlM0QlMjBrZXJhcy5TZXF1ZW50aWFsKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtlcmFzLklucHV0KHNoYXBlJTNEaW5wdXRfc2hhcGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLkNvbnYyRCgzMiUyQyUyMGtlcm5lbF9zaXplJTNEKDMlMkMlMjAzKSUyQyUyMGFjdGl2YXRpb24lM0QlMjJyZWx1JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVycy5NYXhQb29saW5nMkQocG9vbF9zaXplJTNEKDIlMkMlMjAyKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcnMuQ29udjJEKDY0JTJDJTIwa2VybmVsX3NpemUlM0QoMyUyQyUyMDMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLk1heFBvb2xpbmcyRChwb29sX3NpemUlM0QoMiUyQyUyMDIpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxheWVycy5GbGF0dGVuKCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsYXllcnMuRHJvcG91dCgwLjUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGF5ZXJzLkRlbnNlKG51bV9jbGFzc2VzJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnNvZnRtYXglMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQW1vZGVsLnN1bW1hcnkoKQ==",highlighted:`model = keras.Sequential(
    [
        keras.Input(shape=input_shape),
        layers.Conv2D(<span class="hljs-number">32</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Conv2D(<span class="hljs-number">64</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Flatten(),
        layers.Dropout(<span class="hljs-number">0.5</span>),
        layers.Dense(num_classes, activation=<span class="hljs-string">&quot;softmax&quot;</span>),
    ]
)
model.summary()`,wrap:!1}}),F=new ls({props:{code:"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",highlighted:`Model: &quot;sequential&quot;
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
<span class="hljs-section">Layer (type)                 Output Shape              Param #   
=================================================================</span>
conv2d (Conv2D)              (None, 26, 26, 32)        320       
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
max<span class="hljs-emphasis">_pooling2d (MaxPooling2D) (None, 13, 13, 32)        0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_</span>
conv2d<span class="hljs-emphasis">_1 (Conv2D)            (None, 11, 11, 64)        18496     
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_</span>
max<span class="hljs-emphasis">_pooling2d_</span>1 (MaxPooling2 (None, 5, 5, 64)          0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
flatten (Flatten)            (None, 1600)              0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
dropout (Dropout)            (None, 1600)              0         
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span>_
<span class="hljs-section">dense (Dense)                (None, 10)                16010     
=================================================================</span>
Total params: 34,826
Trainable params: 34,826
Non-trainable params: 0
<span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-strong">____</span><span class="hljs-emphasis">_</span>`,wrap:!1}}),R=new fe({props:{title:"Backpropagation in Convolutional Neural Networks in Theory",local:"backpropagation-in-convolutional-neural-networks-in-theory",headingTag:"h3"}}),te=new fe({props:{title:"Parameter sharing",local:"parameter-sharing",headingTag:"h3"}}),le=new fe({props:{title:"Sparse Interactions",local:"sparse-interactions",headingTag:"h3"}}),{c(){r=o("meta"),ce=n(),he=o("p"),ue=n(),ae(_.$$.fragment),we=n(),ae(h.$$.fragment),ge=n(),M=o("p"),M.textContent=ft,me=n(),f=o("p"),f.textContent=ct,ye=n(),c=o("p"),c.innerHTML=ut,Ce=n(),u=o("p"),u.textContent=wt,ve=n(),w=o("p"),w.innerHTML=gt,de=n(),g=o("p"),g.textContent=mt,je=n(),m=o("p"),m.innerHTML=yt,Te=n(),y=o("p"),y.innerHTML=Ct,Ue=n(),C=o("p"),C.textContent=vt,Xe=n(),v=o("p"),v.innerHTML=dt,Je=n(),d=o("p"),d.textContent=jt,xe=n(),j=o("p"),j.innerHTML=Tt,Qe=n(),T=o("p"),T.textContent=Ut,Ie=n(),U=o("p"),U.innerHTML=Xt,be=n(),X=o("p"),X.textContent=Jt,ke=n(),J=o("p"),J.innerHTML=xt,Ne=n(),x=o("p"),x.textContent=Qt,Ae=n(),Q=o("p"),Q.innerHTML=It,Pe=n(),I=o("p"),I.textContent=bt,$e=n(),b=o("p"),b.innerHTML=kt,De=n(),k=o("p"),k.textContent=Nt,ze=n(),N=o("p"),N.innerHTML=At,Le=n(),A=o("p"),A.innerHTML=Pt,Be=n(),P=o("p"),P.textContent=$t,He=n(),$=o("p"),$.textContent=Dt,We=n(),D=o("p"),D.textContent=zt,Ee=n(),z=o("p"),z.innerHTML=Lt,Fe=n(),L=o("p"),L.textContent=Bt,Se=n(),B=o("p"),B.textContent=Ht,Ge=n(),H=o("p"),H.textContent=Wt,Ke=n(),W=o("p"),W.textContent=Et,Ye=n(),ae(E.$$.fragment),Ze=n(),ae(F.$$.fragment),qe=n(),S=o("p"),S.textContent=Ft,Ve=n(),G=o("p"),G.innerHTML=St,Re=n(),K=o("p"),K.textContent=Gt,Oe=n(),Y=o("p"),Y.innerHTML=Kt,et=n(),Z=o("p"),Z.textContent=Yt,tt=n(),q=o("p"),q.innerHTML=Zt,st=n(),V=o("p"),V.textContent=qt,lt=n(),ae(R.$$.fragment),nt=n(),O=o("p"),O.textContent=Vt,at=n(),ee=o("p"),ee.textContent=Rt,ot=n(),ae(te.$$.fragment),it=n(),se=o("p"),se.textContent=Ot,pt=n(),ae(le.$$.fragment),rt=n(),ne=o("p"),ne.textContent=es,_t=n(),Me=o("p"),this.h()},l(e){const t=rs("svelte-u9bgzb",document.head);r=i(t,"META",{name:!0,content:!0}),t.forEach(s),ce=a(e),he=i(e,"P",{}),ts(he).forEach(s),ue=a(e),oe(_.$$.fragment,e),we=a(e),oe(h.$$.fragment,e),ge=a(e),M=i(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-js1wle"&&(M.textContent=ft),me=a(e),f=i(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1ux31d8"&&(f.textContent=ct),ye=a(e),c=i(e,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1an6y10"&&(c.innerHTML=ut),Ce=a(e),u=i(e,"P",{"data-svelte-h":!0}),p(u)!=="svelte-bgkhoi"&&(u.textContent=wt),ve=a(e),w=i(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-wa2ski"&&(w.innerHTML=gt),de=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-qr4ipf"&&(g.textContent=mt),je=a(e),m=i(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-pbdbvn"&&(m.innerHTML=yt),Te=a(e),y=i(e,"P",{"data-svelte-h":!0}),p(y)!=="svelte-1bd1lxb"&&(y.innerHTML=Ct),Ue=a(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1c6lnzy"&&(C.textContent=vt),Xe=a(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-4ck1yg"&&(v.innerHTML=dt),Je=a(e),d=i(e,"P",{"data-svelte-h":!0}),p(d)!=="svelte-1je5z3e"&&(d.textContent=jt),xe=a(e),j=i(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1v3rui9"&&(j.innerHTML=Tt),Qe=a(e),T=i(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-7tiixt"&&(T.textContent=Ut),Ie=a(e),U=i(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1hmwpk9"&&(U.innerHTML=Xt),be=a(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-h89lro"&&(X.textContent=Jt),ke=a(e),J=i(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-ijbbdv"&&(J.innerHTML=xt),Ne=a(e),x=i(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-t7bv9p"&&(x.textContent=Qt),Ae=a(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1h0g6a3"&&(Q.innerHTML=It),Pe=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-10c7o21"&&(I.textContent=bt),$e=a(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-o7n03h"&&(b.innerHTML=kt),De=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1i0lgcz"&&(k.textContent=Nt),ze=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-9tvsfg"&&(N.innerHTML=At),Le=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1hzskr6"&&(A.innerHTML=Pt),Be=a(e),P=i(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-vndxjl"&&(P.textContent=$t),He=a(e),$=i(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-4b3wij"&&($.textContent=Dt),We=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1bwr5lk"&&(D.textContent=zt),Ee=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-13he0fh"&&(z.innerHTML=Lt),Fe=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1bbyip8"&&(L.textContent=Bt),Se=a(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-125rfo9"&&(B.textContent=Ht),Ge=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-mkpmog"&&(H.textContent=Wt),Ke=a(e),W=i(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-7oa27"&&(W.textContent=Et),Ye=a(e),oe(E.$$.fragment,e),Ze=a(e),oe(F.$$.fragment,e),qe=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-epav3e"&&(S.textContent=Ft),Ve=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-j4t7lq"&&(G.innerHTML=St),Re=a(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-itm15h"&&(K.textContent=Gt),Oe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-11wdyez"&&(Y.innerHTML=Kt),et=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1pbiqiu"&&(Z.textContent=Yt),tt=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-gxoajt"&&(q.innerHTML=Zt),st=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-llfp4"&&(V.textContent=qt),lt=a(e),oe(R.$$.fragment,e),nt=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-19vtkdl"&&(O.textContent=Vt),at=a(e),ee=i(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-y803lj"&&(ee.textContent=Rt),ot=a(e),oe(te.$$.fragment,e),it=a(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-p7dm8c"&&(se.textContent=Ot),pt=a(e),oe(le.$$.fragment,e),rt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1wtxxcv"&&(ne.textContent=es),_t=a(e),Me=i(e,"P",{}),ts(Me).forEach(s),this.h()},h(){ss(r,"name","hf:doc:metadata"),ss(r,"content",Ms)},m(e,t){_s(document.head,r),l(e,ce,t),l(e,he,t),l(e,ue,t),ie(_,e,t),l(e,we,t),ie(h,e,t),l(e,ge,t),l(e,M,t),l(e,me,t),l(e,f,t),l(e,ye,t),l(e,c,t),l(e,Ce,t),l(e,u,t),l(e,ve,t),l(e,w,t),l(e,de,t),l(e,g,t),l(e,je,t),l(e,m,t),l(e,Te,t),l(e,y,t),l(e,Ue,t),l(e,C,t),l(e,Xe,t),l(e,v,t),l(e,Je,t),l(e,d,t),l(e,xe,t),l(e,j,t),l(e,Qe,t),l(e,T,t),l(e,Ie,t),l(e,U,t),l(e,be,t),l(e,X,t),l(e,ke,t),l(e,J,t),l(e,Ne,t),l(e,x,t),l(e,Ae,t),l(e,Q,t),l(e,Pe,t),l(e,I,t),l(e,$e,t),l(e,b,t),l(e,De,t),l(e,k,t),l(e,ze,t),l(e,N,t),l(e,Le,t),l(e,A,t),l(e,Be,t),l(e,P,t),l(e,He,t),l(e,$,t),l(e,We,t),l(e,D,t),l(e,Ee,t),l(e,z,t),l(e,Fe,t),l(e,L,t),l(e,Se,t),l(e,B,t),l(e,Ge,t),l(e,H,t),l(e,Ke,t),l(e,W,t),l(e,Ye,t),ie(E,e,t),l(e,Ze,t),ie(F,e,t),l(e,qe,t),l(e,S,t),l(e,Ve,t),l(e,G,t),l(e,Re,t),l(e,K,t),l(e,Oe,t),l(e,Y,t),l(e,et,t),l(e,Z,t),l(e,tt,t),l(e,q,t),l(e,st,t),l(e,V,t),l(e,lt,t),ie(R,e,t),l(e,nt,t),l(e,O,t),l(e,at,t),l(e,ee,t),l(e,ot,t),ie(te,e,t),l(e,it,t),l(e,se,t),l(e,pt,t),ie(le,e,t),l(e,rt,t),l(e,ne,t),l(e,_t,t),l(e,Me,t),ht=!0},p:as,i(e){ht||(pe(_.$$.fragment,e),pe(h.$$.fragment,e),pe(E.$$.fragment,e),pe(F.$$.fragment,e),pe(R.$$.fragment,e),pe(te.$$.fragment,e),pe(le.$$.fragment,e),ht=!0)},o(e){re(_.$$.fragment,e),re(h.$$.fragment,e),re(E.$$.fragment,e),re(F.$$.fragment,e),re(R.$$.fragment,e),re(te.$$.fragment,e),re(le.$$.fragment,e),ht=!1},d(e){e&&(s(ce),s(he),s(ue),s(we),s(ge),s(M),s(me),s(f),s(ye),s(c),s(Ce),s(u),s(ve),s(w),s(de),s(g),s(je),s(m),s(Te),s(y),s(Ue),s(C),s(Xe),s(v),s(Je),s(d),s(xe),s(j),s(Qe),s(T),s(Ie),s(U),s(be),s(X),s(ke),s(J),s(Ne),s(x),s(Ae),s(Q),s(Pe),s(I),s($e),s(b),s(De),s(k),s(ze),s(N),s(Le),s(A),s(Be),s(P),s(He),s($),s(We),s(D),s(Ee),s(z),s(Fe),s(L),s(Se),s(B),s(Ge),s(H),s(Ke),s(W),s(Ye),s(Ze),s(qe),s(S),s(Ve),s(G),s(Re),s(K),s(Oe),s(Y),s(et),s(Z),s(tt),s(q),s(st),s(V),s(lt),s(nt),s(O),s(at),s(ee),s(ot),s(it),s(se),s(pt),s(rt),s(ne),s(_t),s(Me)),s(r),_e(_,e),_e(h,e),_e(E,e),_e(F,e),_e(R,e),_e(te,e),_e(le,e)}}}const Ms='{"title":"Introduction to Convolutional Neural Networks","local":"introduction-to-convolutional-neural-networks","sections":[{"title":"Convolution: Basic Ideas","local":"convolution-basic-ideas","sections":[{"title":"Backpropagation in Convolutional Neural Networks in Theory","local":"backpropagation-in-convolutional-neural-networks-in-theory","sections":[],"depth":3},{"title":"Parameter sharing","local":"parameter-sharing","sections":[],"depth":3},{"title":"Sparse Interactions","local":"sparse-interactions","sections":[],"depth":3}],"depth":2}],"depth":1}';function fs(Mt){return os(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends is{constructor(r){super(),ps(this,r,fs,hs,ns,{})}}export{ms as component};
