import{s as We,o as Xe,n as Le}from"../chunks/scheduler.d6170356.js";import{S as Fe,i as ze,g as o,s as a,r,A as Ee,h as m,f as l,c as n,j as Re,u as p,x as g,k as Be,y as Qe,a as s,v as c,d,t as M,w as h}from"../chunks/index.fcd4cc08.js";import{T as Ye}from"../chunks/Tip.b09c67cf.js";import{C as Je}from"../chunks/CodeBlock.7b16bdef.js";import{H as w}from"../chunks/Heading.8660bd0e.js";function Ne(A){let i,y="As of today (2024-03-15) mlx does not support <code>group</code> param for nn.Conv2d. Therefore, architectures such as <code>resnext</code>, <code>regnet</code> or <code>efficientnet</code> are not yet supported in <code>mlx-image</code>.";return{c(){i=o("p"),i.innerHTML=y},l(f){i=m(f,"P",{"data-svelte-h":!0}),g(i)!=="svelte-1ayt94f"&&(i.innerHTML=y)},m(f,N){s(f,i,N)},p:Le,d(f){f&&l(i)}}}function Ve(A){let i,y,f,N,T,S,J,be='<a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow"><code>mlx-image</code></a> is an image models library developed by <a href="https://github.com/riccardomusmeci" rel="nofollow">Riccardo Musmeci</a> built on Apple <a href="https://github.com/ml-explore/mlx" rel="nofollow">MLX</a>. It tries to replicate the great <a href="https://github.com/huggingface/pytorch-image-models" rel="nofollow">timm</a>, but for MLX models.',q,b,P,$,$e=`You can find <code>mlx-image</code> models by filtering using the <code>mlx-image</code> library name, like in <a href="https://huggingface.co/models?library=mlx-image&amp;sort=trending" rel="nofollow">this query</a>.
There’s also an open <a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision</a> community for contributors converting and publishing weights for MLX format.`,D,j,K,U,O,I,ee,x,je='Model weights are available on the <a href="https://huggingface.co/mlx-vision" rel="nofollow"><code>mlx-vision</code></a> community on HuggingFace.',te,C,Ue="To load a model with pre-trained weights:",le,v,se,Z,Ie="To list all available models:",ae,G,ne,u,ie,k,oe,_,xe='Go to <a href="https://github.com/riccardomusmeci/mlx-image/blob/main/results/results-imagenet-1k.csv" rel="nofollow">results-imagenet-1k.csv</a> to check every model converted to <code>mlx-image</code> and its performance on ImageNet-1K with different settings.',me,H,Ce="<p><strong>TL;DR</strong> performance is comparable to the original models from PyTorch implementations.</p>",re,R,pe,B,ve="<code>mlx-image</code> tries to be as close as possible to PyTorch:",ce,W,Ze="<li><p><code>DataLoader</code> -&gt; you can define your own <code>collate_fn</code> and also use <code>num_workers</code> to speed up data loading</p></li> <li><p><code>Dataset</code> -&gt; <code>mlx-image</code> already supports <code>LabelFolderDataset</code> (the good and old PyTorch <code>ImageFolder</code>) and <code>FolderDataset</code> (a generic folder with images in it)</p></li> <li><p><code>ModelCheckpoint</code> -&gt; keeps track of the best model and saves it to disk (similar to PyTorchLightning). It also suggests early stopping</p></li>",de,X,Me,L,Ge="Training is similar to PyTorch. Here’s an example of how to train a model:",he,F,ge,z,fe,E,ke='<li><a href="https://github.com/riccardomusmeci/mlx-image" rel="nofollow">mlx-image repository</a></li> <li><a href="https://huggingface.co/mlx-vision" rel="nofollow">mlx-vision community</a></li>',we,Q,ue,Y,_e="If you have any questions, please email <code>riccardomusmeci92@gmail.com</code>.",ye,V,Te;return T=new w({props:{title:"Using mlx-image at Hugging Face",local:"using-mlx-image-at-hugging-face",headingTag:"h1"}}),b=new w({props:{title:"Exploring mlx-image on the Hub",local:"exploring-mlx-image-on-the-hub",headingTag:"h2"}}),j=new w({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new Je({props:{code:"cGlwJTIwaW5zdGFsbCUyMG1seC1pbWFnZQ==",highlighted:"pip install mlx-image",wrap:!1}}),I=new w({props:{title:"Models",local:"models",headingTag:"h2"}}),v=new Je({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwY3JlYXRlX21vZGVsJTBBJTBBJTIzJTIwbG9hZGluZyUyMHdlaWdodHMlMjBmcm9tJTIwSHVnZ2luZ0ZhY2UlMjAoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRm1seC12aXNpb24lMkZyZXNuZXQxOC1tbHhpbSklMEFtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQxOCUyMiklMjAlMjMlMjBwcmV0cmFpbmVkJTIwd2VpZ2h0cyUyMGxvYWRlZCUyMGZyb20lMjBIRiUwQSUwQSUyMyUyMGxvYWRpbmclMjB3ZWlnaHRzJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyJTJDJTIwd2VpZ2h0cyUzRCUyMnBhdGglMkZ0byUyRnJlc25ldDE4JTJGbW9kZWwuc2FmZXRlbnNvcnMlMjIp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model

<span class="hljs-comment"># loading weights from HuggingFace (https://huggingface.co/mlx-vision/resnet18-mlxim)</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>

<span class="hljs-comment"># loading weights from local file</span>
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>, weights=<span class="hljs-string">&quot;path/to/resnet18/model.safetensors&quot;</span>)`,wrap:!1}}),G=new Je({props:{code:"ZnJvbSUyMG1seGltLm1vZGVsJTIwaW1wb3J0JTIwbGlzdF9tb2RlbHMlMEFsaXN0X21vZGVscygp",highlighted:`<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> list_models
list_models()`,wrap:!1}}),u=new Ye({props:{warning:!0,$$slots:{default:[Ne]},$$scope:{ctx:A}}}),k=new w({props:{title:"ImageNet-1K Results",local:"imagenet-1k-results",headingTag:"h2"}}),R=new w({props:{title:"Similarity to PyTorch and other familiar tools",local:"similarity-to-pytorch-and-other-familiar-tools",headingTag:"h2"}}),X=new w({props:{title:"Training",local:"training",headingTag:"h2"}}),F=new Je({props:{code:"aW1wb3J0JTIwbWx4Lm5uJTIwYXMlMjBubiUwQWltcG9ydCUyMG1seC5vcHRpbWl6ZXJzJTIwYXMlMjBvcHRpbSUwQWZyb20lMjBtbHhpbS5tb2RlbCUyMGltcG9ydCUyMGNyZWF0ZV9tb2RlbCUwQWZyb20lMjBtbHhpbS5kYXRhJTIwaW1wb3J0JTIwTGFiZWxGb2xkZXJEYXRhc2V0JTJDJTIwRGF0YUxvYWRlciUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBMYWJlbEZvbGRlckRhdGFzZXQoJTBBJTIwJTIwJTIwJTIwcm9vdF9kaXIlM0QlMjJwYXRoJTJGdG8lMkZ0cmFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsYXNzX21hcCUzRCU3QjAlM0ElMjAlMjJjbGFzc18wJTIyJTJDJTIwMSUzQSUyMCUyMmNsYXNzXzElMjIlMkMlMjAyJTNBJTIwJTVCJTIyY2xhc3NfMiUyMiUyQyUyMCUyMmNsYXNzXzMlMjIlNUQlN0QlMEEpJTBBdHJhaW5fbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjBkYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGJhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dvcmtlcnMlM0Q0JTBBKSUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDE4JTIyKSUyMCUyMyUyMHByZXRyYWluZWQlMjB3ZWlnaHRzJTIwbG9hZGVkJTIwZnJvbSUyMEhGJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbShsZWFybmluZ19yYXRlJTNEMWUtMyklMEElMEFkZWYlMjB0cmFpbl9zdGVwKG1vZGVsJTJDJTIwaW5wdXRzJTJDJTIwdGFyZ2V0cyklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG14Lm1lYW4obm4ubG9zc2VzLmNyb3NzX2VudHJvcHkobG9naXRzJTJDJTIwdGFyZ2V0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb3NzJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZSgxMCklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBiYXRjaCUyMGluJTIwdHJhaW5fbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyQyUyMHRhcmdldCUyMCUzRCUyMGJhdGNoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fc3RlcF9mbiUyMCUzRCUyMG5uLnZhbHVlX2FuZF9ncmFkKG1vZGVsJTJDJTIwdHJhaW5fc3RlcCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTJDJTIwZ3JhZHMlMjAlM0QlMjB0cmFpbl9zdGVwX2ZuKHglMkMlMjB0YXJnZXQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnVwZGF0ZShtb2RlbCUyQyUyMGdyYWRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG14LmV2YWwobW9kZWwuc3RhdGUlMkMlMjBvcHRpbWl6ZXIuc3RhdGUp",highlighted:`<span class="hljs-keyword">import</span> mlx.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-keyword">import</span> mlx.optimizers <span class="hljs-keyword">as</span> optim
<span class="hljs-keyword">from</span> mlxim.model <span class="hljs-keyword">import</span> create_model
<span class="hljs-keyword">from</span> mlxim.data <span class="hljs-keyword">import</span> LabelFolderDataset, DataLoader

train_dataset = LabelFolderDataset(
    root_dir=<span class="hljs-string">&quot;path/to/train&quot;</span>,
    class_map={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;class_0&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;class_1&quot;</span>, <span class="hljs-number">2</span>: [<span class="hljs-string">&quot;class_2&quot;</span>, <span class="hljs-string">&quot;class_3&quot;</span>]}
)
train_loader = DataLoader(
    dataset=train_dataset,
    batch_size=<span class="hljs-number">32</span>,
    shuffle=<span class="hljs-literal">True</span>,
    num_workers=<span class="hljs-number">4</span>
)
model = create_model(<span class="hljs-string">&quot;resnet18&quot;</span>) <span class="hljs-comment"># pretrained weights loaded from HF</span>
optimizer = optim.Adam(learning_rate=<span class="hljs-number">1e-3</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">train_step</span>(<span class="hljs-params">model, inputs, targets</span>):
    logits = model(inputs)
    loss = mx.mean(nn.losses.cross_entropy(logits, target))
    <span class="hljs-keyword">return</span> loss

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_loader:
        x, target = batch
        train_step_fn = nn.value_and_grad(model, train_step)
        loss, grads = train_step_fn(x, target)
        optimizer.update(model, grads)
        mx.<span class="hljs-built_in">eval</span>(model.state, optimizer.state)`,wrap:!1}}),z=new w({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),Q=new w({props:{title:"Contact",local:"contact",headingTag:"h2"}}),{c(){i=o("meta"),y=a(),f=o("p"),N=a(),r(T.$$.fragment),S=a(),J=o("p"),J.innerHTML=be,q=a(),r(b.$$.fragment),P=a(),$=o("p"),$.innerHTML=$e,D=a(),r(j.$$.fragment),K=a(),r(U.$$.fragment),O=a(),r(I.$$.fragment),ee=a(),x=o("p"),x.innerHTML=je,te=a(),C=o("p"),C.textContent=Ue,le=a(),r(v.$$.fragment),se=a(),Z=o("p"),Z.textContent=Ie,ae=a(),r(G.$$.fragment),ne=a(),r(u.$$.fragment),ie=a(),r(k.$$.fragment),oe=a(),_=o("p"),_.innerHTML=xe,me=a(),H=o("blockquote"),H.innerHTML=Ce,re=a(),r(R.$$.fragment),pe=a(),B=o("p"),B.innerHTML=ve,ce=a(),W=o("ul"),W.innerHTML=Ze,de=a(),r(X.$$.fragment),Me=a(),L=o("p"),L.textContent=Ge,he=a(),r(F.$$.fragment),ge=a(),r(z.$$.fragment),fe=a(),E=o("ul"),E.innerHTML=ke,we=a(),r(Q.$$.fragment),ue=a(),Y=o("p"),Y.innerHTML=_e,ye=a(),V=o("p"),this.h()},l(e){const t=Ee("svelte-u9bgzb",document.head);i=m(t,"META",{name:!0,content:!0}),t.forEach(l),y=n(e),f=m(e,"P",{}),Re(f).forEach(l),N=n(e),p(T.$$.fragment,e),S=n(e),J=m(e,"P",{"data-svelte-h":!0}),g(J)!=="svelte-1c0kah6"&&(J.innerHTML=be),q=n(e),p(b.$$.fragment,e),P=n(e),$=m(e,"P",{"data-svelte-h":!0}),g($)!=="svelte-15ir2pb"&&($.innerHTML=$e),D=n(e),p(j.$$.fragment,e),K=n(e),p(U.$$.fragment,e),O=n(e),p(I.$$.fragment,e),ee=n(e),x=m(e,"P",{"data-svelte-h":!0}),g(x)!=="svelte-13m84xx"&&(x.innerHTML=je),te=n(e),C=m(e,"P",{"data-svelte-h":!0}),g(C)!=="svelte-rlp6qh"&&(C.textContent=Ue),le=n(e),p(v.$$.fragment,e),se=n(e),Z=m(e,"P",{"data-svelte-h":!0}),g(Z)!=="svelte-1xjx8g7"&&(Z.textContent=Ie),ae=n(e),p(G.$$.fragment,e),ne=n(e),p(u.$$.fragment,e),ie=n(e),p(k.$$.fragment,e),oe=n(e),_=m(e,"P",{"data-svelte-h":!0}),g(_)!=="svelte-kcleo1"&&(_.innerHTML=xe),me=n(e),H=m(e,"BLOCKQUOTE",{"data-svelte-h":!0}),g(H)!=="svelte-1xz4blu"&&(H.innerHTML=Ce),re=n(e),p(R.$$.fragment,e),pe=n(e),B=m(e,"P",{"data-svelte-h":!0}),g(B)!=="svelte-11sjtis"&&(B.innerHTML=ve),ce=n(e),W=m(e,"UL",{"data-svelte-h":!0}),g(W)!=="svelte-jcjia8"&&(W.innerHTML=Ze),de=n(e),p(X.$$.fragment,e),Me=n(e),L=m(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1cvxtzq"&&(L.textContent=Ge),he=n(e),p(F.$$.fragment,e),ge=n(e),p(z.$$.fragment,e),fe=n(e),E=m(e,"UL",{"data-svelte-h":!0}),g(E)!=="svelte-k2vhlo"&&(E.innerHTML=ke),we=n(e),p(Q.$$.fragment,e),ue=n(e),Y=m(e,"P",{"data-svelte-h":!0}),g(Y)!=="svelte-12c9hfs"&&(Y.innerHTML=_e),ye=n(e),V=m(e,"P",{}),Re(V).forEach(l),this.h()},h(){Be(i,"name","hf:doc:metadata"),Be(i,"content",Ae)},m(e,t){Qe(document.head,i),s(e,y,t),s(e,f,t),s(e,N,t),c(T,e,t),s(e,S,t),s(e,J,t),s(e,q,t),c(b,e,t),s(e,P,t),s(e,$,t),s(e,D,t),c(j,e,t),s(e,K,t),c(U,e,t),s(e,O,t),c(I,e,t),s(e,ee,t),s(e,x,t),s(e,te,t),s(e,C,t),s(e,le,t),c(v,e,t),s(e,se,t),s(e,Z,t),s(e,ae,t),c(G,e,t),s(e,ne,t),c(u,e,t),s(e,ie,t),c(k,e,t),s(e,oe,t),s(e,_,t),s(e,me,t),s(e,H,t),s(e,re,t),c(R,e,t),s(e,pe,t),s(e,B,t),s(e,ce,t),s(e,W,t),s(e,de,t),c(X,e,t),s(e,Me,t),s(e,L,t),s(e,he,t),c(F,e,t),s(e,ge,t),c(z,e,t),s(e,fe,t),s(e,E,t),s(e,we,t),c(Q,e,t),s(e,ue,t),s(e,Y,t),s(e,ye,t),s(e,V,t),Te=!0},p(e,[t]){const He={};t&2&&(He.$$scope={dirty:t,ctx:e}),u.$set(He)},i(e){Te||(d(T.$$.fragment,e),d(b.$$.fragment,e),d(j.$$.fragment,e),d(U.$$.fragment,e),d(I.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(u.$$.fragment,e),d(k.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),Te=!0)},o(e){M(T.$$.fragment,e),M(b.$$.fragment,e),M(j.$$.fragment,e),M(U.$$.fragment,e),M(I.$$.fragment,e),M(v.$$.fragment,e),M(G.$$.fragment,e),M(u.$$.fragment,e),M(k.$$.fragment,e),M(R.$$.fragment,e),M(X.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(Q.$$.fragment,e),Te=!1},d(e){e&&(l(y),l(f),l(N),l(S),l(J),l(q),l(P),l($),l(D),l(K),l(O),l(ee),l(x),l(te),l(C),l(le),l(se),l(Z),l(ae),l(ne),l(ie),l(oe),l(_),l(me),l(H),l(re),l(pe),l(B),l(ce),l(W),l(de),l(Me),l(L),l(he),l(ge),l(fe),l(E),l(we),l(ue),l(Y),l(ye),l(V)),l(i),h(T,e),h(b,e),h(j,e),h(U,e),h(I,e),h(v,e),h(G,e),h(u,e),h(k,e),h(R,e),h(X,e),h(F,e),h(z,e),h(Q,e)}}}const Ae='{"title":"Using mlx-image at Hugging Face","local":"using-mlx-image-at-hugging-face","sections":[{"title":"Exploring mlx-image on the Hub","local":"exploring-mlx-image-on-the-hub","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"ImageNet-1K Results","local":"imagenet-1k-results","sections":[],"depth":2},{"title":"Similarity to PyTorch and other familiar tools","local":"similarity-to-pytorch-and-other-familiar-tools","sections":[],"depth":2},{"title":"Training","local":"training","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2},{"title":"Contact","local":"contact","sections":[],"depth":2}],"depth":1}';function Se(A){return Xe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Fe{constructor(i){super(),ze(this,i,Se,Ve,We,{})}}export{et as component};
