import{s as Aa,n as Na,o as Ka}from"../chunks/scheduler.9039eef2.js";import{S as Fa,i as Ea,g as r,s as n,r as p,A as La,h as i,f as a,c as o,j as v,u as g,x as m,k as b,y as t,a as s,v as h,d as _,t as u,w as f}from"../chunks/index.ded8f90d.js";import{D as T}from"../chunks/Docstring.a2ba2b54.js";import{C as ea}from"../chunks/CodeBlock.8580f3e8.js";import{H as ze}from"../chunks/Heading.f027f30d.js";function Da(ta){let U,Pe,qe,Be,F,We,E,aa=`TRL supports the Kahneman-Tversky Optimization (KTO) Trainer for aligning language models with binary feedback data (e.g., upvote/downvote), as described in the <a href="https://arxiv.org/abs/2402.01306" rel="nofollow">paper</a> by Kawin Ethayarajh, Winnie Xu, Niklas Muennighoff, Dan Jurafsky, and Douwe Kiela.
For a full example have a look at  <code>examples/scripts/kto.py</code>.`,Qe,L,na=`Depending on how good your base model is, you may or may not need to do SFT before KTO.
This is different from standard RLHF and DPO, which always require SFT.`,Se,D,Re,z,oa="The KTO trainer expects a very specific format for the dataset as it does not require pairwise preferences. Since the model will be trained to directly optimize examples that consist of a prompt, model completion, and a label to indicate whether the completion is “good” or “bad”, we expect a dataset with the following columns:",Ze,q,la="<li><code>prompt</code></li> <li><code>completion</code></li> <li><code>label</code></li>",Xe,H,ra="for example:",Ve,P,Ge,B,ia=`where the <code>prompt</code> contains the context inputs, <code>completion</code> contains the corresponding responses and <code>label</code> contains the corresponding flag that indicates if the generated completion is desired (<code>True</code>) or undesired (<code>False</code>).
A prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.`,Ye,W,et,Q,sa="The KTO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",tt,S,at,R,da="For a detailed example have a look at the <code>examples/scripts/kto.py</code> script. At a high level we need to initialize the <code>KTOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",nt,Z,ma="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",ot,X,ca=`The <code>desirable_weight</code> and <code>undesirable_weight</code> refer to the weights placed on the losses for desirable/positive and undesirable/negative examples.
By default, they are both 1. However, if you have more of one or the other, then you should upweight the less common type such that the ratio of (<code>desirable_weight</code> <em>number of positives) to (<code>undesirable_weight</code></em> number of negatives) is in the range 1:1 to 4:3.`,lt,V,rt,G,pa="After this one can then call:",it,Y,st,ee,dt,d,te,yt,ue,ga="Initialize KTOTrainer.",wt,x,ae,Ct,fe,ha=`Llama tokenizer does not satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,$t,J,ne,Ut,ve,_a="Computes log probabilities of the reference model for a single padded batch of a KTO specific dataset.",xt,w,oe,Jt,be,ua=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ot,Te,fa="Works both with or without labels.",jt,O,le,It,Me,va="Creates mismatched pairs of prompts and completions for the KL dataset.",kt,j,re,At,ye,ba="Compute the log probabilities of the given labels under the given logits.",Nt,I,ie,Kt,we,Ta="Compute the KTO loss and other metrics for the given batch of inputs for train or test.",Ft,k,se,Et,Ce,Ma="Generate samples from the model and reference model for the given batch of inputs.",Lt,C,de,Dt,$e,ya="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",zt,Ue,wa="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",qt,$,me,Ht,xe,Ca="Returns the training <code>~torch.utils.data.DataLoader</code>.",Pt,Je,$a="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",Bt,A,ce,Wt,Oe,Ua="Compute the KTO loss for a batch of policy and reference model log probabilities.",Qt,N,pe,St,je,xa="Log <code>logs</code> on the various objects watching training, including stored metrics.",Rt,M,ge,Zt,Ie,Ja="Tokenize a single row from a KTO specific dataset.",Xt,ke,Oa=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + completion responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the completion.`,Vt,Ae,ja=`We also create the labels for the completion responses, which are of length equal to
the sum of the length of the prompt and the completion response, with
label_pad_token_id  for the prompt tokens.`,mt,he,ct,y,_e,Gt,Ne,Ia='KTOConfig collects all training arguments related to the <a href="/docs/trl/main/en/kto_trainer#trl.KTOTrainer">KTOTrainer</a> class.',Yt,Ke,ka=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,pt,He,gt;return F=new ze({props:{title:"KTO Trainer",local:"kto-trainer",headingTag:"h1"}}),D=new ze({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),P=new ea({props:{code:"a3RvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhleSUyQyUyMGhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJoaSUyMG5pY2UlMjB0byUyMG1lZXQlMjB5b3UlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJDJTJCJTJCJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySmF2YSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxhYmVsJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRmFsc2UlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`kto_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;Hey, hello&quot;</span>,
        <span class="hljs-string">&quot;How are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;completion&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I don&#x27;t have a name&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;label&quot;</span>: [
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">True</span>,
        <span class="hljs-literal">False</span>,
        <span class="hljs-literal">False</span>,
    ],
}`,wrap:!1}}),W=new ze({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),S=new ze({props:{title:"Using the KTOTrainer",local:"using-the-ktotrainer",headingTag:"h2"}}),V=new ea({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEtUT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSUyMCUyMCUyMCUyMHVuZGVzaXJhYmxlX3dlaWdodCUzRDEuMCUyQyUwQSklMEElMEFrdG9fdHJhaW5lciUyMCUzRCUyMEtUT1RyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBtb2RlbF9yZWYlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = KTOConfig(
    beta=<span class="hljs-number">0.1</span>,
    desirable_weight=<span class="hljs-number">1.0</span>,
    undesirable_weight=<span class="hljs-number">1.0</span>,
)

kto_trainer = KTOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),Y=new ea({props:{code:"a3RvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"kto_trainer.train()",wrap:!1}}),ee=new ze({props:{title:"KTOTrainer",local:"trl.KTOTrainer",headingTag:"h2"}}),te=new T({props:{name:"class trl.KTOTrainer",anchor:"trl.KTOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"ref_model",val:": Union = None"},{name:"args",val:": KTOConfig = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.KTOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.KTOTrainer.args",description:`<strong>args</strong> (<code>KTOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.KTOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.KTOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.KTOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.KTOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.KTOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.KTOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.KTOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.KTOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.KTOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.KTOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.KTOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L66"}}),ae=new T({props:{name:"build_tokenized_answer",anchor:"trl.KTOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L642"}}),ne=new T({props:{name:"compute_reference_log_probs",anchor:"trl.KTOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L568"}}),oe=new T({props:{name:"evaluation_loop",anchor:"trl.KTOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1134"}}),le=new T({props:{name:"get_KL_dataset",anchor:"trl.KTOTrainer.get_KL_dataset",parameters:[{name:"batch",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L692"}}),re=new T({props:{name:"get_batch_logps",anchor:"trl.KTOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L785",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ie=new T({props:{name:"get_batch_loss_metrics",anchor:"trl.KTOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L941"}}),se=new T({props:{name:"get_batch_samples",anchor:"trl.KTOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1048"}}),de=new T({props:{name:"get_eval_dataloader",anchor:"trl.KTOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L515"}}),me=new T({props:{name:"get_train_dataloader",anchor:"trl.KTOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L474"}}),ce=new T({props:{name:"kto_loss",anchor:"trl.KTOTrainer.kto_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"policy_KL_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"reference_KL_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, KL).
The losses tensor contains the KTO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The KL tensor contains the detached KL divergence estimate between the policy and reference models.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),pe=new T({props:{name:"log",anchor:"trl.KTOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.KTOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L1190"}}),ge=new T({props:{name:"tokenize_row",anchor:"trl.KTOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"},{name:"prefix",val:" = ''"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_trainer.py#L697"}}),he=new ze({props:{title:"KTOConfig",local:"trl.KTOConfig",headingTag:"h2"}}),_e=new T({props:{name:"class trl.KTOConfig",anchor:"trl.KTOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"evaluation_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Optional = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Optional = None"},{name:"deepspeed",val:": Optional = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Optional = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Optional = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"desirable_weight",val:": Optional = 1.0"},{name:"undesirable_weight",val:": Optional = 1.0"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": Optional = None"},{name:"ref_model_init_kwargs",val:": Optional = None"}],parametersDescription:[{anchor:"trl.KTOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.KTOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.KTOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.KTOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in KTO loss. Higher beta means less divergence from the initial policy.`,name:"beta"},{anchor:"trl.KTOConfig.desirable_weight",description:`<strong>desirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The desirable losses are weighed by this factor to counter unequal number of desirable and undesirable paris.`,name:"desirable_weight"},{anchor:"trl.KTOConfig.undesirable_weight",description:`<strong>undesirable_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The undesirable losses are weighed by this factor to counter unequal number of desirable and undesirable pairs.`,name:"undesirable_weight"},{anchor:"trl.KTOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.KTOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>0</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.KTOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.KTOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.KTOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.KTOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Flag to precompute reference model log probabilities for training and evaluation datasets. This is useful if you want to train
without the reference model and reduce the total GPU memory needed.
model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the model from a string.
ref_model_init_kwargs &#x2014; (<code>Optional[Dict]</code>, <em>optional</em>):
Dict of Optional kwargs to pass when instantiating the ref model from a string.`,name:"precompute_ref_log_probs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/kto_config.py#L20"}}),{c(){U=r("meta"),Pe=n(),qe=r("p"),Be=n(),p(F.$$.fragment),We=n(),E=r("p"),E.innerHTML=aa,Qe=n(),L=r("p"),L.textContent=na,Se=n(),p(D.$$.fragment),Re=n(),z=r("p"),z.textContent=oa,Ze=n(),q=r("ul"),q.innerHTML=la,Xe=n(),H=r("p"),H.textContent=ra,Ve=n(),p(P.$$.fragment),Ge=n(),B=r("p"),B.innerHTML=ia,Ye=n(),p(W.$$.fragment),et=n(),Q=r("p"),Q.innerHTML=sa,tt=n(),p(S.$$.fragment),at=n(),R=r("p"),R.innerHTML=da,nt=n(),Z=r("p"),Z.innerHTML=ma,ot=n(),X=r("p"),X.innerHTML=ca,lt=n(),p(V.$$.fragment),rt=n(),G=r("p"),G.textContent=pa,it=n(),p(Y.$$.fragment),st=n(),p(ee.$$.fragment),dt=n(),d=r("div"),p(te.$$.fragment),yt=n(),ue=r("p"),ue.textContent=ga,wt=n(),x=r("div"),p(ae.$$.fragment),Ct=n(),fe=r("p"),fe.innerHTML=ha,$t=n(),J=r("div"),p(ne.$$.fragment),Ut=n(),ve=r("p"),ve.textContent=_a,xt=n(),w=r("div"),p(oe.$$.fragment),Jt=n(),be=r("p"),be.innerHTML=ua,Ot=n(),Te=r("p"),Te.textContent=fa,jt=n(),O=r("div"),p(le.$$.fragment),It=n(),Me=r("p"),Me.textContent=va,kt=n(),j=r("div"),p(re.$$.fragment),At=n(),ye=r("p"),ye.textContent=ba,Nt=n(),I=r("div"),p(ie.$$.fragment),Kt=n(),we=r("p"),we.textContent=Ta,Ft=n(),k=r("div"),p(se.$$.fragment),Et=n(),Ce=r("p"),Ce.textContent=Ma,Lt=n(),C=r("div"),p(de.$$.fragment),Dt=n(),$e=r("p"),$e.innerHTML=ya,zt=n(),Ue=r("p"),Ue.innerHTML=wa,qt=n(),$=r("div"),p(me.$$.fragment),Ht=n(),xe=r("p"),xe.innerHTML=Ca,Pt=n(),Je=r("p"),Je.innerHTML=$a,Bt=n(),A=r("div"),p(ce.$$.fragment),Wt=n(),Oe=r("p"),Oe.textContent=Ua,Qt=n(),N=r("div"),p(pe.$$.fragment),St=n(),je=r("p"),je.innerHTML=xa,Rt=n(),M=r("div"),p(ge.$$.fragment),Zt=n(),Ie=r("p"),Ie.textContent=Ja,Xt=n(),ke=r("p"),ke.textContent=Oa,Vt=n(),Ae=r("p"),Ae.textContent=ja,mt=n(),p(he.$$.fragment),ct=n(),y=r("div"),p(_e.$$.fragment),Gt=n(),Ne=r("p"),Ne.innerHTML=Ia,Yt=n(),Ke=r("p"),Ke.innerHTML=ka,pt=n(),He=r("p"),this.h()},l(e){const l=La("svelte-u9bgzb",document.head);U=i(l,"META",{name:!0,content:!0}),l.forEach(a),Pe=o(e),qe=i(e,"P",{}),v(qe).forEach(a),Be=o(e),g(F.$$.fragment,e),We=o(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-171dbf3"&&(E.innerHTML=aa),Qe=o(e),L=i(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-z1e9ri"&&(L.textContent=na),Se=o(e),g(D.$$.fragment,e),Re=o(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1792bye"&&(z.textContent=oa),Ze=o(e),q=i(e,"UL",{"data-svelte-h":!0}),m(q)!=="svelte-1bk1n3o"&&(q.innerHTML=la),Xe=o(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1gl9mvz"&&(H.textContent=ra),Ve=o(e),g(P.$$.fragment,e),Ge=o(e),B=i(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-109yt43"&&(B.innerHTML=ia),Ye=o(e),g(W.$$.fragment,e),et=o(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-znx0uh"&&(Q.innerHTML=sa),tt=o(e),g(S.$$.fragment,e),at=o(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-6k9bp8"&&(R.innerHTML=da),nt=o(e),Z=i(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1eil2tw"&&(Z.innerHTML=ma),ot=o(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-ad0vsu"&&(X.innerHTML=ca),lt=o(e),g(V.$$.fragment,e),rt=o(e),G=i(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1lg6q1l"&&(G.textContent=pa),it=o(e),g(Y.$$.fragment,e),st=o(e),g(ee.$$.fragment,e),dt=o(e),d=i(e,"DIV",{class:!0});var c=v(d);g(te.$$.fragment,c),yt=o(c),ue=i(c,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-hyhzxp"&&(ue.textContent=ga),wt=o(c),x=i(c,"DIV",{class:!0});var ht=v(x);g(ae.$$.fragment,ht),Ct=o(ht),fe=i(ht,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-y1fzbp"&&(fe.innerHTML=ha),ht.forEach(a),$t=o(c),J=i(c,"DIV",{class:!0});var _t=v(J);g(ne.$$.fragment,_t),Ut=o(_t),ve=i(_t,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-pt6g01"&&(ve.textContent=_a),_t.forEach(a),xt=o(c),w=i(c,"DIV",{class:!0});var Fe=v(w);g(oe.$$.fragment,Fe),Jt=o(Fe),be=i(Fe,"P",{"data-svelte-h":!0}),m(be)!=="svelte-8qlty5"&&(be.innerHTML=ua),Ot=o(Fe),Te=i(Fe,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1tyo99t"&&(Te.textContent=fa),Fe.forEach(a),jt=o(c),O=i(c,"DIV",{class:!0});var ut=v(O);g(le.$$.fragment,ut),It=o(ut),Me=i(ut,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1y1n7oy"&&(Me.textContent=va),ut.forEach(a),kt=o(c),j=i(c,"DIV",{class:!0});var ft=v(j);g(re.$$.fragment,ft),At=o(ft),ye=i(ft,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-4nmimv"&&(ye.textContent=ba),ft.forEach(a),Nt=o(c),I=i(c,"DIV",{class:!0});var vt=v(I);g(ie.$$.fragment,vt),Kt=o(vt),we=i(vt,"P",{"data-svelte-h":!0}),m(we)!=="svelte-db7iek"&&(we.textContent=Ta),vt.forEach(a),Ft=o(c),k=i(c,"DIV",{class:!0});var bt=v(k);g(se.$$.fragment,bt),Et=o(bt),Ce=i(bt,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-18uwvbi"&&(Ce.textContent=Ma),bt.forEach(a),Lt=o(c),C=i(c,"DIV",{class:!0});var Ee=v(C);g(de.$$.fragment,Ee),Dt=o(Ee),$e=i(Ee,"P",{"data-svelte-h":!0}),m($e)!=="svelte-xesobz"&&($e.innerHTML=ya),zt=o(Ee),Ue=i(Ee,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-qg43tm"&&(Ue.innerHTML=wa),Ee.forEach(a),qt=o(c),$=i(c,"DIV",{class:!0});var Le=v($);g(me.$$.fragment,Le),Ht=o(Le),xe=i(Le,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-dkae9b"&&(xe.innerHTML=Ca),Pt=o(Le),Je=i(Le,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-hmd5cw"&&(Je.innerHTML=$a),Le.forEach(a),Bt=o(c),A=i(c,"DIV",{class:!0});var Tt=v(A);g(ce.$$.fragment,Tt),Wt=o(Tt),Oe=i(Tt,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-svckwe"&&(Oe.textContent=Ua),Tt.forEach(a),Qt=o(c),N=i(c,"DIV",{class:!0});var Mt=v(N);g(pe.$$.fragment,Mt),St=o(Mt),je=i(Mt,"P",{"data-svelte-h":!0}),m(je)!=="svelte-nqksfz"&&(je.innerHTML=xa),Mt.forEach(a),Rt=o(c),M=i(c,"DIV",{class:!0});var K=v(M);g(ge.$$.fragment,K),Zt=o(K),Ie=i(K,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-118ojw5"&&(Ie.textContent=Ja),Xt=o(K),ke=i(K,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-1ku9h1p"&&(ke.textContent=Oa),Vt=o(K),Ae=i(K,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-qa9jmj"&&(Ae.textContent=ja),K.forEach(a),c.forEach(a),mt=o(e),g(he.$$.fragment,e),ct=o(e),y=i(e,"DIV",{class:!0});var De=v(y);g(_e.$$.fragment,De),Gt=o(De),Ne=i(De,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1i1r5fd"&&(Ne.innerHTML=Ia),Yt=o(De),Ke=i(De,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-1xl7jqc"&&(Ke.innerHTML=ka),De.forEach(a),pt=o(e),He=i(e,"P",{}),v(He).forEach(a),this.h()},h(){b(U,"name","hf:doc:metadata"),b(U,"content",za),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,l){t(document.head,U),s(e,Pe,l),s(e,qe,l),s(e,Be,l),h(F,e,l),s(e,We,l),s(e,E,l),s(e,Qe,l),s(e,L,l),s(e,Se,l),h(D,e,l),s(e,Re,l),s(e,z,l),s(e,Ze,l),s(e,q,l),s(e,Xe,l),s(e,H,l),s(e,Ve,l),h(P,e,l),s(e,Ge,l),s(e,B,l),s(e,Ye,l),h(W,e,l),s(e,et,l),s(e,Q,l),s(e,tt,l),h(S,e,l),s(e,at,l),s(e,R,l),s(e,nt,l),s(e,Z,l),s(e,ot,l),s(e,X,l),s(e,lt,l),h(V,e,l),s(e,rt,l),s(e,G,l),s(e,it,l),h(Y,e,l),s(e,st,l),h(ee,e,l),s(e,dt,l),s(e,d,l),h(te,d,null),t(d,yt),t(d,ue),t(d,wt),t(d,x),h(ae,x,null),t(x,Ct),t(x,fe),t(d,$t),t(d,J),h(ne,J,null),t(J,Ut),t(J,ve),t(d,xt),t(d,w),h(oe,w,null),t(w,Jt),t(w,be),t(w,Ot),t(w,Te),t(d,jt),t(d,O),h(le,O,null),t(O,It),t(O,Me),t(d,kt),t(d,j),h(re,j,null),t(j,At),t(j,ye),t(d,Nt),t(d,I),h(ie,I,null),t(I,Kt),t(I,we),t(d,Ft),t(d,k),h(se,k,null),t(k,Et),t(k,Ce),t(d,Lt),t(d,C),h(de,C,null),t(C,Dt),t(C,$e),t(C,zt),t(C,Ue),t(d,qt),t(d,$),h(me,$,null),t($,Ht),t($,xe),t($,Pt),t($,Je),t(d,Bt),t(d,A),h(ce,A,null),t(A,Wt),t(A,Oe),t(d,Qt),t(d,N),h(pe,N,null),t(N,St),t(N,je),t(d,Rt),t(d,M),h(ge,M,null),t(M,Zt),t(M,Ie),t(M,Xt),t(M,ke),t(M,Vt),t(M,Ae),s(e,mt,l),h(he,e,l),s(e,ct,l),s(e,y,l),h(_e,y,null),t(y,Gt),t(y,Ne),t(y,Yt),t(y,Ke),s(e,pt,l),s(e,He,l),gt=!0},p:Na,i(e){gt||(_(F.$$.fragment,e),_(D.$$.fragment,e),_(P.$$.fragment,e),_(W.$$.fragment,e),_(S.$$.fragment,e),_(V.$$.fragment,e),_(Y.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ae.$$.fragment,e),_(ne.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(me.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(_e.$$.fragment,e),gt=!0)},o(e){u(F.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(W.$$.fragment,e),u(S.$$.fragment,e),u(V.$$.fragment,e),u(Y.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),gt=!1},d(e){e&&(a(Pe),a(qe),a(Be),a(We),a(E),a(Qe),a(L),a(Se),a(Re),a(z),a(Ze),a(q),a(Xe),a(H),a(Ve),a(Ge),a(B),a(Ye),a(et),a(Q),a(tt),a(at),a(R),a(nt),a(Z),a(ot),a(X),a(lt),a(rt),a(G),a(it),a(st),a(dt),a(d),a(mt),a(ct),a(y),a(pt),a(He)),a(U),f(F,e),f(D,e),f(P,e),f(W,e),f(S,e),f(V,e),f(Y,e),f(ee,e),f(te),f(ae),f(ne),f(oe),f(le),f(re),f(ie),f(se),f(de),f(me),f(ce),f(pe),f(ge),f(he,e),f(_e)}}}const za='{"title":"KTO Trainer","local":"kto-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the KTOTrainer","local":"using-the-ktotrainer","sections":[],"depth":2},{"title":"KTOTrainer","local":"trl.KTOTrainer","sections":[],"depth":2},{"title":"KTOConfig","local":"trl.KTOConfig","sections":[],"depth":2}],"depth":1}';function qa(ta){return Ka(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends Fa{constructor(U){super(),Ea(this,U,qa,Da,Aa,{})}}export{Sa as component};
