import{s as bt,n as $t,o as vt}from"../chunks/scheduler.d627b047.js";import{S as _t,i as Jt,g as i,s as a,r as d,A as Ut,h as o,f as l,c as s,j as wt,u as m,x as r,k as Tt,y as Zt,a as n,v as p,d as f,t as u,w as h}from"../chunks/index.d48c4817.js";import{C as g}from"../chunks/CodeBlock.5da89496.js";import{H as y}from"../chunks/Heading.47e562a9.js";function kt(Ae){let c,ie,ae,oe,M,re,w,qe="If you encounter any issue when using PEFT, please check the following list of common issues and their solutions.",de,T,me,b,De="Examples often rely on the most recent package versions, so please ensure they’re up-to-date. In particular, check the version of the following packages:",pe,$,Ke="<li><code>peft</code></li> <li><code>transformers</code></li> <li><code>accelerate</code></li> <li><code>torch</code></li>",fe,v,Oe="In general, you can update the package version by running this command inside your Python environment:",ue,_,he,J,et="Installing PEFT from source is useful for keeping up with the latest developments:",ce,U,ye,Z,ge,k,Me,j,tt="This error probably occurred because the model was loaded with <code>torch_dtype=torch.float16</code> and then used in an automatic mixed precision (AMP) context, e.g. by setting <code>fp16=True</code> in the <code>Trainer</code> class from 🤗 Transformers. The reason is that when using AMP, trainable weights should never use fp16. To make this work without having to load the whole model in FP32, add the following snippet to your code:",we,C,Te,x,lt="Alternatively, you can use the utility function <code>cast_mixed_precision_params</code> from peft as shown below:",be,B,$e,W,ve,H,nt='There can be several reasons for getting a poor result from a loaded PEFT model, which are listed below. If you’re still unable to troubleshoot the problem, see if anyone else had a similar <a href="https://github.com/huggingface/peft/issues" rel="nofollow">issue</a> on GitHub, and if you can’t find any, open a new issue.',_e,I,at="When opening an issue, it helps a lot if you provide a minimal code example that reproduces the issue. Also, please report if the loaded model performs at the same level as the model did before fine-tuning, if it performs at a random level, or if it is only slightly worse than expected. This information helps us identify the problem more quickly.",Je,R,Ue,G,st="If your model outputs are not exactly the same as previous runs, there could be an issue with random elements. For example:",Ze,L,it='<li>please ensure it is in <code>.eval()</code> mode, which is important, for instance, if the model uses dropout</li> <li>if you use <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> on a language model, there could be random sampling, so obtaining the same result requires setting a random seed</li> <li>if you used quantization and merged the weights, small deviations are expected due to rounding errors</li>',ke,F,je,P,ot="Please ensure that you load the model correctly. A common error is trying to load a <em>trained</em> model with <code>get_peft_model</code>, which is incorrect. Instead, the loading code should look like this:",Ce,V,xe,E,Be,X,rt="For some tasks, it is important to correctly configure <code>modules_to_save</code> in the config to account for randomly initialized layers.",We,Y,dt="As an example, this is necessary if you use LoRA to fine-tune a language model for sequence classification because 🤗 Transformers adds a randomly initialized classification head on top of the model. If you do not add this layer to <code>modules_to_save</code>, the classification head won’t be saved. The next time you load the model, you’ll get a <em>different</em> randomly initialized classification head, resulting in completely different results.",He,z,mt="In PEFT, we try to correctly guess the <code>modules_to_save</code> if you provide the <code>task_type</code> argument in the config. This should work for transformers models that follow the standard naming scheme. It is always a good idea to double check though because we can’t guarantee all models follow the naming scheme.",Ie,Q,pt="When you load a transformers model that has randomly initialized layers, you should see a warning along the lines of:",Re,N,Ge,S,ft="The mentioned layers should be added to <code>modules_to_save</code> in the config to avoid the described problem.",Le,A,Fe,q,ut="For many language fine-tuning tasks, extending the model’s vocabulary is necessary since new tokens are being introduced. This requires extending the embedding layer to account for the new tokens and also storing the embedding layer in addition to the adapter weights when saving the adapter.",Pe,D,ht="Save the embedding layer by adding it to the <code>target_modules</code> of the config. The embedding layer name must follow the standard naming scheme from Transformers. For example, the Mistral config could look like this:",Ve,K,Ee,O,ct='Once added to <code>target_modules</code>, PEFT automatically stores the embedding layer when saving the adapter if the model has the <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.get_input_embeddings" rel="nofollow">get_input_embeddings</a> and <a href="https://huggingface.co/docs/transformers/v4.37.2/en/main_classes/model#transformers.PreTrainedModel.get_output_embeddings" rel="nofollow">get_output_embeddings</a>. This is generally the case for Transformers models.',Xe,ee,yt="If the model’s embedding layer doesn’t follow the Transformer’s naming scheme, you can still save it by manually passing <code>save_embedding_layers=True</code> when saving the adapter:",Ye,te,ze,le,gt="For inference, load the base model first and resize it the same way you did before you trained the model. After you’ve resized the base model, you can load the PEFT checkpoint.",Qe,ne,Mt='For a complete example, please check out <a href="https://github.com/huggingface/peft/blob/main/examples/causal_language_modeling/peft_lora_clm_with_additional_tokens.ipynb" rel="nofollow">this notebook</a>.',Ne,se,Se;return M=new y({props:{title:"Troubleshooting",local:"troubleshooting",headingTag:"h1"}}),T=new y({props:{title:"Examples don’t work",local:"examples-dont-work",headingTag:"h2"}}),_=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjAlM0NwYWNrYWdlX25hbWUlM0U=",highlighted:"python -m pip install -U &lt;package_name&gt;",wrap:!1}}),U=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZwZWZ0",highlighted:"python -m pip install git+https://github.com/huggingface/peft",wrap:!1}}),Z=new y({props:{title:"Training errors",local:"training-errors",headingTag:"h2"}}),k=new y({props:{title:"Getting: ValueError: Attempting to unscale FP16 gradients",local:"getting-valueerror-attempting-to-unscale-fp16-gradients",headingTag:"h3"}}),C=new g({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKC4uLiklMEElMEElMjMlMjBhZGQlMjB0aGlzJTNBJTBBZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLmRhdGElMjAlM0QlMjBwYXJhbS5kYXRhLmZsb2F0KCklMEElMEElMjMlMjBwcm9jZWVkJTIwYXMlMjB1c3VhbCUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTNEcGVmdF9tb2RlbCUyQyUyMGZwMTYlM0RUcnVlJTJDJTIwLi4uKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`peft_model = get_peft_model(...)

<span class="hljs-comment"># add this:</span>
<span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
    <span class="hljs-keyword">if</span> param.requires_grad:
        param.data = param.data.<span class="hljs-built_in">float</span>()

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),B=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjYXN0X21peGVkX3ByZWNpc2lvbl9wYXJhbXMlMEElMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoLi4uKSUwQWNhc3RfbWl4ZWRfcHJlY2lzaW9uX3BhcmFtcyhwZWZ0X21vZGVsJTJDJTIwZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMHByb2NlZWQlMjBhcyUyMHVzdWFsJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0RwZWZ0X21vZGVsJTJDJTIwZnAxNiUzRFRydWUlMkMlMjAuLi4pJTBBdHJhaW5lci50cmFpbigp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> cast_mixed_precision_params

peft_model = get_peft_model(...)
cast_mixed_precision_params(peft_model, dtype=torch.float16)

<span class="hljs-comment"># proceed as usual</span>
trainer = Trainer(model=peft_model, fp16=<span class="hljs-literal">True</span>, ...)
trainer.train()`,wrap:!1}}),W=new y({props:{title:"Bad results from a loaded PEFT model",local:"bad-results-from-a-loaded-peft-model",headingTag:"h2"}}),R=new y({props:{title:"Random deviations",local:"random-deviations",headingTag:"h3"}}),F=new y({props:{title:"Incorrectly loaded model",local:"incorrectly-loaded-model",headingTag:"h3"}}),V=new g({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMkMlMjBQZWZ0Q29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMC4uLiUyMCUyMCUyMyUyMHRvJTIwbG9hZCUyMHRoZSUyMGJhc2UlMjBtb2RlbCUyQyUyMHVzZSUyMHRoZSUyMHNhbWUlMjBjb2RlJTIwYXMlMjB3aGVuJTIweW91JTIwdHJhaW5lZCUyMGl0JTBBY29uZmlnJTIwJTNEJTIwUGVmdENvbmZpZy5mcm9tX3ByZXRyYWluZWQocGVmdF9tb2RlbF9pZCklMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel, PeftConfig

base_model = ...  <span class="hljs-comment"># to load the base model, use the same code as when you trained it</span>
config = PeftConfig.from_pretrained(peft_model_id)
peft_model = PeftModel.from_pretrained(base_model, peft_model_id)`,wrap:!1}}),E=new y({props:{title:"Randomly initialized layers",local:"randomly-initialized-layers",headingTag:"h3"}}),N=new g({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMCUzQ01PREVMJTNFJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwJTNDSUQlM0UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJTNDTEFZRVJfTkFNRVMlM0UlNUQuJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`<span class="hljs-keyword">Some</span> weights <span class="hljs-keyword">of</span> &lt;MODEL&gt; were <span class="hljs-keyword">not</span> initialized <span class="hljs-keyword">from</span> the model <span class="hljs-keyword">checkpoint</span> at &lt;ID&gt; <span class="hljs-keyword">and</span> are newly initialized: [&lt;LAYER_NAMES&gt;].
You should probably TRAIN this model <span class="hljs-keyword">on</span> a down-stream task <span class="hljs-keyword">to</span> be able <span class="hljs-keyword">to</span> use it <span class="hljs-keyword">for</span> predictions <span class="hljs-keyword">and</span> inference.`,wrap:!1}}),A=new y({props:{title:"Extending the vocabulary",local:"extending-the-vocabulary",headingTag:"h3"}}),K=new g({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmVtYmVkX3Rva2VucyUyMiUyQyUyMCUyMmxtX2hlYWQlMjIlMkMlMjAlMjJxX3Byb2olMjIlMkMlMjAlMjJ2X3Byb2olMjIlNUQp",highlighted:'config = LoraConfig(..., target_modules=[<span class="hljs-string">&quot;embed_tokens&quot;</span>, <span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;q_proj&quot;</span>, <span class="hljs-string">&quot;v_proj&quot;</span>])',wrap:!1}}),te=new g({props:{code:"bW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbCguLi4pJTBBJTIzJTIwdHJhaW4lMjB0aGUlMjBtb2RlbCUwQW1vZGVsLnNhdmVfYWRhcHRlciglMjJteV9hZGFwdGVyJTIyJTJDJTIwc2F2ZV9lbWJlZGRpbmdfbGF5ZXJzJTNEVHJ1ZSk=",highlighted:`model = get_peft_model(...)
<span class="hljs-comment"># train the model</span>
model.save_adapter(<span class="hljs-string">&quot;my_adapter&quot;</span>, save_embedding_layers=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=i("meta"),ie=a(),ae=i("p"),oe=a(),d(M.$$.fragment),re=a(),w=i("p"),w.textContent=qe,de=a(),d(T.$$.fragment),me=a(),b=i("p"),b.textContent=De,pe=a(),$=i("ul"),$.innerHTML=Ke,fe=a(),v=i("p"),v.textContent=Oe,ue=a(),d(_.$$.fragment),he=a(),J=i("p"),J.textContent=et,ce=a(),d(U.$$.fragment),ye=a(),d(Z.$$.fragment),ge=a(),d(k.$$.fragment),Me=a(),j=i("p"),j.innerHTML=tt,we=a(),d(C.$$.fragment),Te=a(),x=i("p"),x.innerHTML=lt,be=a(),d(B.$$.fragment),$e=a(),d(W.$$.fragment),ve=a(),H=i("p"),H.innerHTML=nt,_e=a(),I=i("p"),I.textContent=at,Je=a(),d(R.$$.fragment),Ue=a(),G=i("p"),G.textContent=st,Ze=a(),L=i("ol"),L.innerHTML=it,ke=a(),d(F.$$.fragment),je=a(),P=i("p"),P.innerHTML=ot,Ce=a(),d(V.$$.fragment),xe=a(),d(E.$$.fragment),Be=a(),X=i("p"),X.innerHTML=rt,We=a(),Y=i("p"),Y.innerHTML=dt,He=a(),z=i("p"),z.innerHTML=mt,Ie=a(),Q=i("p"),Q.textContent=pt,Re=a(),d(N.$$.fragment),Ge=a(),S=i("p"),S.innerHTML=ft,Le=a(),d(A.$$.fragment),Fe=a(),q=i("p"),q.textContent=ut,Pe=a(),D=i("p"),D.innerHTML=ht,Ve=a(),d(K.$$.fragment),Ee=a(),O=i("p"),O.innerHTML=ct,Xe=a(),ee=i("p"),ee.innerHTML=yt,Ye=a(),d(te.$$.fragment),ze=a(),le=i("p"),le.textContent=gt,Qe=a(),ne=i("p"),ne.innerHTML=Mt,Ne=a(),se=i("p"),this.h()},l(e){const t=Ut("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(l),ie=s(e),ae=o(e,"P",{}),wt(ae).forEach(l),oe=s(e),m(M.$$.fragment,e),re=s(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-wwms7a"&&(w.textContent=qe),de=s(e),m(T.$$.fragment,e),me=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-jke3kd"&&(b.textContent=De),pe=s(e),$=o(e,"UL",{"data-svelte-h":!0}),r($)!=="svelte-ccv654"&&($.innerHTML=Ke),fe=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1cuqjyb"&&(v.textContent=Oe),ue=s(e),m(_.$$.fragment,e),he=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-h5ykrw"&&(J.textContent=et),ce=s(e),m(U.$$.fragment,e),ye=s(e),m(Z.$$.fragment,e),ge=s(e),m(k.$$.fragment,e),Me=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-19tje0q"&&(j.innerHTML=tt),we=s(e),m(C.$$.fragment,e),Te=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1d12k4"&&(x.innerHTML=lt),be=s(e),m(B.$$.fragment,e),$e=s(e),m(W.$$.fragment,e),ve=s(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-10lsbv8"&&(H.innerHTML=nt),_e=s(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-lfc2ft"&&(I.textContent=at),Je=s(e),m(R.$$.fragment,e),Ue=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-16feh"&&(G.textContent=st),Ze=s(e),L=o(e,"OL",{"data-svelte-h":!0}),r(L)!=="svelte-m1xqgb"&&(L.innerHTML=it),ke=s(e),m(F.$$.fragment,e),je=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-5incon"&&(P.innerHTML=ot),Ce=s(e),m(V.$$.fragment,e),xe=s(e),m(E.$$.fragment,e),Be=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-5heszj"&&(X.innerHTML=rt),We=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-c4824l"&&(Y.innerHTML=dt),He=s(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1nym86"&&(z.innerHTML=mt),Ie=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g4txs2"&&(Q.textContent=pt),Re=s(e),m(N.$$.fragment,e),Ge=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1fbeum6"&&(S.innerHTML=ft),Le=s(e),m(A.$$.fragment,e),Fe=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-15igmai"&&(q.textContent=ut),Pe=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1cgzlph"&&(D.innerHTML=ht),Ve=s(e),m(K.$$.fragment,e),Ee=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ocs1md"&&(O.innerHTML=ct),Xe=s(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-ucua6z"&&(ee.innerHTML=yt),Ye=s(e),m(te.$$.fragment,e),ze=s(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-nkv7o7"&&(le.textContent=gt),Qe=s(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-a0ibfa"&&(ne.innerHTML=Mt),Ne=s(e),se=o(e,"P",{}),wt(se).forEach(l),this.h()},h(){Tt(c,"name","hf:doc:metadata"),Tt(c,"content",jt)},m(e,t){Zt(document.head,c),n(e,ie,t),n(e,ae,t),n(e,oe,t),p(M,e,t),n(e,re,t),n(e,w,t),n(e,de,t),p(T,e,t),n(e,me,t),n(e,b,t),n(e,pe,t),n(e,$,t),n(e,fe,t),n(e,v,t),n(e,ue,t),p(_,e,t),n(e,he,t),n(e,J,t),n(e,ce,t),p(U,e,t),n(e,ye,t),p(Z,e,t),n(e,ge,t),p(k,e,t),n(e,Me,t),n(e,j,t),n(e,we,t),p(C,e,t),n(e,Te,t),n(e,x,t),n(e,be,t),p(B,e,t),n(e,$e,t),p(W,e,t),n(e,ve,t),n(e,H,t),n(e,_e,t),n(e,I,t),n(e,Je,t),p(R,e,t),n(e,Ue,t),n(e,G,t),n(e,Ze,t),n(e,L,t),n(e,ke,t),p(F,e,t),n(e,je,t),n(e,P,t),n(e,Ce,t),p(V,e,t),n(e,xe,t),p(E,e,t),n(e,Be,t),n(e,X,t),n(e,We,t),n(e,Y,t),n(e,He,t),n(e,z,t),n(e,Ie,t),n(e,Q,t),n(e,Re,t),p(N,e,t),n(e,Ge,t),n(e,S,t),n(e,Le,t),p(A,e,t),n(e,Fe,t),n(e,q,t),n(e,Pe,t),n(e,D,t),n(e,Ve,t),p(K,e,t),n(e,Ee,t),n(e,O,t),n(e,Xe,t),n(e,ee,t),n(e,Ye,t),p(te,e,t),n(e,ze,t),n(e,le,t),n(e,Qe,t),n(e,ne,t),n(e,Ne,t),n(e,se,t),Se=!0},p:$t,i(e){Se||(f(M.$$.fragment,e),f(T.$$.fragment,e),f(_.$$.fragment,e),f(U.$$.fragment,e),f(Z.$$.fragment,e),f(k.$$.fragment,e),f(C.$$.fragment,e),f(B.$$.fragment,e),f(W.$$.fragment,e),f(R.$$.fragment,e),f(F.$$.fragment,e),f(V.$$.fragment,e),f(E.$$.fragment,e),f(N.$$.fragment,e),f(A.$$.fragment,e),f(K.$$.fragment,e),f(te.$$.fragment,e),Se=!0)},o(e){u(M.$$.fragment,e),u(T.$$.fragment,e),u(_.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(k.$$.fragment,e),u(C.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(F.$$.fragment,e),u(V.$$.fragment,e),u(E.$$.fragment,e),u(N.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(te.$$.fragment,e),Se=!1},d(e){e&&(l(ie),l(ae),l(oe),l(re),l(w),l(de),l(me),l(b),l(pe),l($),l(fe),l(v),l(ue),l(he),l(J),l(ce),l(ye),l(ge),l(Me),l(j),l(we),l(Te),l(x),l(be),l($e),l(ve),l(H),l(_e),l(I),l(Je),l(Ue),l(G),l(Ze),l(L),l(ke),l(je),l(P),l(Ce),l(xe),l(Be),l(X),l(We),l(Y),l(He),l(z),l(Ie),l(Q),l(Re),l(Ge),l(S),l(Le),l(Fe),l(q),l(Pe),l(D),l(Ve),l(Ee),l(O),l(Xe),l(ee),l(Ye),l(ze),l(le),l(Qe),l(ne),l(Ne),l(se)),l(c),h(M,e),h(T,e),h(_,e),h(U,e),h(Z,e),h(k,e),h(C,e),h(B,e),h(W,e),h(R,e),h(F,e),h(V,e),h(E,e),h(N,e),h(A,e),h(K,e),h(te,e)}}}const jt='{"title":"Troubleshooting","local":"troubleshooting","sections":[{"title":"Examples don’t work","local":"examples-dont-work","sections":[],"depth":2},{"title":"Training errors","local":"training-errors","sections":[{"title":"Getting: ValueError: Attempting to unscale FP16 gradients","local":"getting-valueerror-attempting-to-unscale-fp16-gradients","sections":[],"depth":3}],"depth":2},{"title":"Bad results from a loaded PEFT model","local":"bad-results-from-a-loaded-peft-model","sections":[{"title":"Random deviations","local":"random-deviations","sections":[],"depth":3},{"title":"Incorrectly loaded model","local":"incorrectly-loaded-model","sections":[],"depth":3},{"title":"Randomly initialized layers","local":"randomly-initialized-layers","sections":[],"depth":3},{"title":"Extending the vocabulary","local":"extending-the-vocabulary","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ct(Ae){return vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends _t{constructor(c){super(),Jt(this,c,Ct,kt,bt,{})}}export{It as component};
