import{s as Af,o as Zf,n as J}from"../chunks/scheduler.6062bdaf.js";import{S as Ef,i as Wf,g as M,s as i,r as g,m as Ir,A as Nf,h as b,f as y,c as r,j as k,u,x as I,n as Jr,k as v,y as l,a as T,v as m,d as h,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as G}from"../chunks/Tip.b9ac1f03.js";import{D as A}from"../chunks/Docstring.81ba5e3c.js";import{C as w}from"../chunks/CodeBlock.fa01571c.js";import{E as U}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as to,E as Gf}from"../chunks/EditOnGithub.74ab2baa.js";function Bf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Qf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBYXVkaW9fb3V0cHV0JTIwJTNEJTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBZm9yJTIwaSUyQyUyMGl0ZW0lMjBpbiUyMGVudW1lcmF0ZShhdWRpb19vdXRwdXQpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oZiUyMm91dHB1dF8lN0JpJTdELmZsYWMlMjIlMkMlMjAlMjJ3YiUyMiklMjBhcyUyMGYlM0E=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Vf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Sf(_){let n,c=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function Yf(_){let n;return{c(){n=Ir("Some parameters might not be supported by some providers.")},l(c){n=Jr(c,"Some parameters might not be supported by some providers.")},m(c,s){T(c,n,s)},d(c){c&&y(n)}}}function Rf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function zf(_){let n,c="Example using streaming:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Xf(_){let n,c="Example using OpenAI’s syntax:",s,t,o;return t=new w({props:{code:"JTIzJTIwaW5zdGVhZCUyMG9mJTIwJTYwZnJvbSUyMG9wZW5haSUyMGltcG9ydCUyME9wZW5BSSU2MCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBiYXNlX3VybCUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QuLi4lMkMlMEEpJTBBJTBBb3V0cHV0JTIwJTNEJTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDb3VudCUyMHRvJTIwMTAlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzRDEwMjQlMkMlMEEpJTBBJTBBZm9yJTIwY2h1bmslMjBpbiUyMG91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQp",highlighted:`<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = InferenceClient(
    base_url=...,
    api_key=...,
)

output = client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ff(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Hf(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Df(_){let n,c="Example using Image + Text as input:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Of(_){let n,c="Example using tools:",s,t,o;return t=new w({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJEb24ndCUyMG1ha2UlMjBhc3N1bXB0aW9ucyUyMGFib3V0JTIwd2hhdCUyMHZhbHVlcyUyMHRvJTIwcGx1ZyUyMGludG8lMjBmdW5jdGlvbnMuJTIwQXNrJTIwZm9yJTIwY2xhcmlmaWNhdGlvbiUyMGlmJTIwYSUyMHVzZXIlMjByZXF1ZXN0JTIwaXMlMjBhbWJpZ3VvdXMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCdzJTIwdGhlJTIwd2VhdGhlciUyMGxpa2UlMjB0aGUlMjBuZXh0JTIwMyUyMGRheXMlMjBpbiUyMFNhbiUyMEZyYW5jaXNjbyUyQyUyMENBJTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBdG9vbHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJHZXQlMjB0aGUlMjBjdXJyZW50JTIwd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmxvY2F0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwY2l0eSUyMGFuZCUyMHN0YXRlJTJDJTIwZS5nLiUyMFNhbiUyMEZyYW5jaXNjbyUyQyUyMENBJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZm9ybWF0JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmVudW0lMjIlM0ElMjAlNUIlMjJjZWxzaXVzJTIyJTJDJTIwJTIyZmFocmVuaGVpdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwdGVtcGVyYXR1cmUlMjB1bml0JTIwdG8lMjB1c2UuJTIwSW5mZXIlMjB0aGlzJTIwZnJvbSUyMHRoZSUyMHVzZXJzJTIwbG9jYXRpb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmZvcm1hdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmZ1bmN0aW9uJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9uX2RheV93ZWF0aGVyX2ZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJHZXQlMjBhbiUyME4tZGF5JTIwd2VhdGhlciUyMGZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGFyYW1ldGVycyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJvYmplY3QlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwcm9wZXJ0aWVzJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybG9jYXRpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBjaXR5JTIwYW5kJTIwc3RhdGUlMkMlMjBlLmcuJTIwU2FuJTIwRnJhbmNpc2NvJTJDJTIwQ0ElMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJmb3JtYXQlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW51bSUyMiUzQSUyMCU1QiUyMmNlbHNpdXMlMjIlMkMlMjAlMjJmYWhyZW5oZWl0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjB0ZW1wZXJhdHVyZSUyMHVuaXQlMjB0byUyMHVzZS4lMjBJbmZlciUyMHRoaXMlMjBmcm9tJTIwdGhlJTIwdXNlcnMlMjBsb2NhdGlvbi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJudW1fZGF5cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJpbnRlZ2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBudW1iZXIlMjBvZiUyMGRheXMlMjB0byUyMGZvcmVjYXN0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVxdWlyZWQlMjIlM0ElMjAlNUIlMjJsb2NhdGlvbiUyMiUyQyUyMCUyMmZvcm1hdCUyMiUyQyUyMCUyMm51bV9kYXlzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTVEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjBjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRG1lc3NhZ2VzJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0R0b29scyUyQyUwQSUyMCUyMCUyMCUyMHRvb2xfY2hvaWNlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0Q1MDAlMkMlMEEpJTBBcmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS50b29sX2NhbGxzJTVCMCU1RC5mdW5jdGlvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Lf(_){let n,c="Example using response_format:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Pf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Kf(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ey(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ny(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEFjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ty(_){let n,c=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-33gpw6"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function sy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ay(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwcyUzQSUyRiUyRmp6Z3UwYnVlaTUudXMtZWFzdC0xLmF3cy5lbmRwb2ludHMuaHVnZ2luZ2ZhY2UuY2xvdWQlMjIpJTBBY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ly(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function oy(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function iy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ry(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function cy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function py(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFjbGllbnQuaW1hZ2VfdG9fdGV4dCglMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function gy(_){let n,c=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-79tj90"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function uy(_){let n,c=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1vz9qc7"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function my(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBbW9kZWxzJTIwJTNEJTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFjbGllbnQubGlzdF9kZXBsb3llZF9tb2RlbHMoJTIydGV4dC1nZW5lcmF0aW9uLWluZmVyZW5jZSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function hy(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function dy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function fy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function yy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function My(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function by(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBcXVlcnklMjAlM0QlMjAlMjJIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YlMjIlMEF0YWJsZSUyMCUzRCUyMCU3QiUyMlJlcG9zaXRvcnklMjIlM0ElMjAlNUIlMjJUcmFuc2Zvcm1lcnMlMjIlMkMlMjAlMjJEYXRhc2V0cyUyMiUyQyUyMCUyMlRva2VuaXplcnMlMjIlNUQlMkMlMjAlMjJTdGFycyUyMiUzQSUyMCU1QiUyMjM2NTQyJTIyJTJDJTIwJTIyNDUxMiUyMiUyQyUyMCUyMjM5MzQlMjIlNUQlN0QlMEFjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function jy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMkMlMEElN0QlMEFjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function _y(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGFibGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJIZWlnaHQlMjIlM0ElMjAlNUIlMjIxMS41MiUyMiUyQyUyMCUyMjEyLjQ4JTIyJTJDJTIwJTIyMTIuMzc3OCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDElMjIlM0ElMjAlNUIlMjIyMy4yJTIyJTJDJTIwJTIyMjQlMjIlMkMlMjAlMjIyMy45JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMiUyMiUzQSUyMCU1QiUyMjI1LjQlMjIlMkMlMjAlMjIyNi4zJTIyJTJDJTIwJTIyMjYuNSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDMlMjIlM0ElMjAlNUIlMjIzMCUyMiUyQyUyMCUyMjMxLjIlMjIlMkMlMjAlMjIzMS4xJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyU3BlY2llcyUyMiUzQSUyMCU1QiUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMldpZHRoJTIyJTNBJTIwJTVCJTIyNC4wMiUyMiUyQyUyMCUyMjQuMzA1NiUyMiUyQyUyMCUyMjQuNjk2MSUyMiU1RCUyQyUwQSU3RCUwQWNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ty(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Iy(_){let n,c=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1jtiv7y"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function Jy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function wy(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function Uy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyQW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMHRoZSUyMG1vb24uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93JTIwcmVzb2x1dGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmJldHRlcl9hc3Ryb25hdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function xy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Cy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function $y(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBYXVkaW8lMjAlM0QlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function ky(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function vy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function qy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Ay(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Zy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ey(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWNsaWVudC50cmFuc2xhdGlvbiglMjJNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiUyMiUyQyUyMG1vZGVsJTNEJTIySGVsc2lua2ktTkxQJTJGb3B1cy1tdC1lbi1mciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Wy(_){let n,c="Specifying languages:",s,t,o;return t=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ny(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Gy(_){let n,c="Example with <code>multi_label=False</code>:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBdGV4dCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJBJTIwbmV3JTIwbW9kZWwlMjBvZmZlcnMlMjBhbiUyMGV4cGxhbmF0aW9uJTIwZm9yJTIwaG93JTIwdGhlJTIwR2FsaWxlYW4lMjBzYXRlbGxpdGVzJTIwZm9ybWVkJTIwYXJvdW5kJTIwdGhlJTIwc29sYXIlMjBzeXN0ZW0ncyUyMiUwQSUyMCUyMCUyMCUyMCUyMmxhcmdlc3QlMjB3b3JsZC4lMjBLb25zdGFudGluJTIwQmF0eWdpbiUyMGRpZCUyMG5vdCUyMHNldCUyMG91dCUyMHRvJTIwc29sdmUlMjBvbmUlMjBvZiUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjBtb3N0JTIwcHV6emxpbmclMjIlMEElMjAlMjAlMjAlMjAlMjIlMjBteXN0ZXJpZXMlMjB3aGVuJTIwaGUlMjB3ZW50JTIwZm9yJTIwYSUyMHJ1biUyMHVwJTIwYSUyMGhpbGwlMjBpbiUyME5pY2UlMkMlMjBGcmFuY2UuJTIyJTBBKSUwQWxhYmVscyUyMCUzRCUyMCU1QiUyMnNwYWNlJTIwJTI2JTIwY29zbW9zJTIyJTJDJTIwJTIyc2NpZW50aWZpYyUyMGRpc2NvdmVyeSUyMiUyQyUyMCUyMm1pY3JvYmlvbG9neSUyMiUyQyUyMCUyMnJvYm90cyUyMiUyQyUyMCUyMmFyY2hlb2xvZ3klMjIlNUQlMEFjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbih0ZXh0JTJDJTIwbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.innerHTML=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function By(_){let n,c="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=M("p"),n.innerHTML=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Qy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBJTBBY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Vy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1ZGlvX2NsYXNzaWZpY2F0aW9uKCUyMmF1ZGlvLmZsYWMlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.audio_classification(<span class="hljs-string">&quot;audio.flac&quot;</span>)
[
    AudioClassificationOutputElement(score=<span class="hljs-number">0.4976358711719513</span>, label=<span class="hljs-string">&#x27;hap&#x27;</span>),
    AudioClassificationOutputElement(score=<span class="hljs-number">0.3677836060523987</span>, label=<span class="hljs-string">&#x27;neu&#x27;</span>),
    ...
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Sy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF1ZGlvX291dHB1dCUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmF1ZGlvX3RvX2F1ZGlvKCUyMmF1ZGlvLmZsYWMlMjIpJTBBYXN5bmMlMjBmb3IlMjBpJTJDJTIwaXRlbSUyMGluJTIwZW51bWVyYXRlKGF1ZGlvX291dHB1dCklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbihmJTIyb3V0cHV0XyU3QmklN0QuZmxhYyUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_output = <span class="hljs-keyword">await</span> client.audio_to_audio(<span class="hljs-string">&quot;audio.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> i, item <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(audio_output):
<span class="hljs-meta">&gt;&gt;&gt; </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">f&quot;output_<span class="hljs-subst">{i}</span>.flac&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
            f.write(item.blob)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Yy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmF1dG9tYXRpY19zcGVlY2hfcmVjb2duaXRpb24oJTIyaGVsbG9fd29ybGQuZmxhYyUyMikudGV4dA==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.automatic_speech_recognition(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).text
<span class="hljs-string">&quot;hello world&quot;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ry(_){let n,c=`The <code>client.chat_completion</code> method is aliased as <code>client.chat.completions.create</code> for compatibility with OpenAI’s client.
Inputs and outputs are strictly the same and using either syntax will yield the same results.
Check out the <a href="https://huggingface.co/docs/huggingface_hub/guides/inference#openai-compatibility" rel="nofollow">Inference guide</a>
for more details about OpenAI’s compatibility.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-9iksi9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function zy(_){let n;return{c(){n=Ir("Some parameters might not be supported by some providers.")},l(c){n=Jr(c,"Some parameters might not be supported by some providers.")},m(c,s){T(c,n,s)},d(c){c&&y(n)}}}function Xy(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMDAp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&#x27;eos_token&#x27;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&#x27;assistant&#x27;</span>,
                content=<span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>,
                name=<span class="hljs-literal">None</span>,
                tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&#x27;&#x27;</span>,
    model=<span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-8B-Instruct&#x27;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&#x27;text_completion&#x27;</span>,
    system_fingerprint=<span class="hljs-string">&#x27;2.0.4-sha-f426a33&#x27;</span>,
    usage=ChatCompletionOutputUsage(
        completion_tokens=<span class="hljs-number">8</span>,
        prompt_tokens=<span class="hljs-number">17</span>,
        total_tokens=<span class="hljs-number">25</span>
    )
)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Fy(_){let n,c="Example using streaming:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlNUQlMEFjbGllbnQlMjAlM0QlMjBBc3luY0luZmVyZW5jZUNsaWVudCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCLUluc3RydWN0JTIyKSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LmNoYXRfY29tcGxldGlvbihtZXNzYWdlcyUyQyUyMG1heF90b2tlbnMlM0QxMCUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.chat_completion(messages, max_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27;The&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; capital&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)
(...)
ChatCompletionStreamOutput(choices=[ChatCompletionStreamOutputChoice(delta=ChatCompletionStreamOutputDelta(content=<span class="hljs-string">&#x27; may&#x27;</span>, role=<span class="hljs-string">&#x27;assistant&#x27;</span>), index=<span class="hljs-number">0</span>, finish_reason=<span class="hljs-literal">None</span>)], created=<span class="hljs-number">1710498504</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1mc18uw"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Hy(_){let n,c="Example using OpenAI’s syntax:",s,t,o;return t=new w({props:{code:"JTIzJTIwTXVzdCUyMGJlJTIwcnVuJTIwaW4lMjBhbiUyMGFzeW5jJTIwY29udGV4dCUwQSUyMyUyMGluc3RlYWQlMjBvZiUyMCU2MGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklNjAlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEElMjMlMjBpbnN0ZWFkJTIwb2YlMjAlNjBjbGllbnQlMjAlM0QlMjBPcGVuQUkoLi4uKSU2MCUwQWNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCUwQSUyMCUyMCUyMCUyMGJhc2VfdXJsJTNELi4uJTJDJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRC4uLiUyQyUwQSklMEElMEFvdXRwdXQlMjAlM0QlMjBhd2FpdCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-comment"># instead of \`from openai import OpenAI\`</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># instead of \`client = OpenAI(...)\`</span>
client = AsyncInferenceClient(
    base_url=...,
    api_key=...,
)

output = <span class="hljs-keyword">await</span> client.chat.completions.create(
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    messages=[
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful assistant.&quot;</span>},
        {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Count to 10&quot;</span>},
    ],
    stream=<span class="hljs-literal">True</span>,
    max_tokens=<span class="hljs-number">1024</span>,
)

<span class="hljs-keyword">for</span> chunk <span class="hljs-keyword">in</span> output:
    <span class="hljs-built_in">print</span>(chunk.choices[<span class="hljs-number">0</span>].delta.content)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-i0a0yp"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Dy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnRvZ2V0aGVyJTIyJTJDJTIwJTIwJTIzJTIwVXNlJTIwVG9nZXRoZXIlMjBBSSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMiUzQ3RvZ2V0aGVyX2FwaV9rZXklM0UlMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMFRvZ2V0aGVyJTIwQVBJJTIwa2V5JTIwZGlyZWN0bHklMEEpJTBBY2xpZW50LmNoYXRfY29tcGxldGlvbiglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUzRiUyMiU3RCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;together&quot;</span>,  <span class="hljs-comment"># Use Together AI provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;&lt;together_api_key&gt;&quot;</span>,  <span class="hljs-comment"># Pass your Together API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Oy(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnNhbWJhbm92YSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMFNhbWJhbm92YSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFjbGllbnQuY2hhdF9jb21wbGV0aW9uKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwY2FwaXRhbCUyMG9mJTIwRnJhbmNlJTNGJTIyJTdEJTVEJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;sambanova&quot;</span>,  <span class="hljs-comment"># Use Sambanova provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=[{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>}],
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function Ly(_){let n,c="Example using Image + Text as input:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient

<span class="hljs-comment"># provide a remote URL</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url =<span class="hljs-string">&quot;https://cdn.britannica.com/61/93061-050-99147DCE/Statue-of-Liberty-Island-New-York-Bay.jpg&quot;</span>
<span class="hljs-comment"># or a base64-encoded image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_path = <span class="hljs-string">&quot;/path/to/image.jpeg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    base64_image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">f&quot;data:image/jpeg;base64,<span class="hljs-subst">{base64_image}</span>&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output = <span class="hljs-keyword">await</span> client.chat.completions.create(
<span class="hljs-meta">... </span>    messages=[
<span class="hljs-meta">... </span>        {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image_url&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;image_url&quot;</span>: {<span class="hljs-string">&quot;url&quot;</span>: image_url},
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in one sentence.&quot;</span>,
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>            ],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
The image depicts the iconic Statue of Liberty situated <span class="hljs-keyword">in</span> New York Harbor, New York, on a clear day.`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1e6ij9p"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Py(_){let n,c="Example using tools:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>tools = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;function&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;parameters&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;location&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;format&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                    <span class="hljs-string">&quot;num_days&quot;</span>: {
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
<span class="hljs-meta">... </span>                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
<span class="hljs-meta">... </span>                    },
<span class="hljs-meta">... </span>                },
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>,
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    tools=tools,
<span class="hljs-meta">... </span>    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.tool_calls[<span class="hljs-number">0</span>].function
ChatCompletionOutputFunctionDefinition(
    arguments={
        <span class="hljs-string">&#x27;location&#x27;</span>: <span class="hljs-string">&#x27;San Francisco, CA&#x27;</span>,
        <span class="hljs-string">&#x27;format&#x27;</span>: <span class="hljs-string">&#x27;fahrenheit&#x27;</span>,
        <span class="hljs-string">&#x27;num_days&#x27;</span>: <span class="hljs-number">3</span>
    },
    name=<span class="hljs-string">&#x27;get_n_day_weather_forecast&#x27;</span>,
    description=<span class="hljs-literal">None</span>
)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1ksikbz"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function Ky(_){let n,c="Example using response_format:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park. What did I saw and when?&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>response_format = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.chat_completion(
<span class="hljs-meta">... </span>    messages=messages,
<span class="hljs-meta">... </span>    response_format=response_format,
<span class="hljs-meta">... </span>    max_tokens=<span class="hljs-number">500</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.choices[<span class="hljs-number">0</span>].message.content
<span class="hljs-string">&#x27;{

y&quot;: &quot;bike ride&quot;,
&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;],
_seen&quot;: 3,
n&quot;: &quot;park&quot;}&#x27;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1klcxsv"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function eM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmRvY3VtZW50X3F1ZXN0aW9uX2Fuc3dlcmluZyhpbWFnZSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZpbXBpcmElMkZkb2NxdWVyeSUyRnJlc29sdmUlMkYyMzU5MjIzYzE4MzdhNzU4NzQwMmJkYTBmMjY0MzM4MmE2ZWVmZWFiJTJGaW52b2ljZS5wbmclMjIlMkMlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGludm9pY2UlMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.document_question_answering(image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>, question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>)
[DocumentQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;us-001&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9999666213989258</span>, start=<span class="hljs-number">16</span>)]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function nM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZlYXR1cmVfZXh0cmFjdGlvbiglMjJIaSUyQyUyMHdobyUyMGFyZSUyMHlvdSUzRiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.feature_extraction(<span class="hljs-string">&quot;Hi, who are you?&quot;</span>)
array([[ <span class="hljs-number">2.424802</span>  ,  <span class="hljs-number">2.93384</span>   ,  <span class="hljs-number">1.1750331</span> , ...,  <span class="hljs-number">1.240499</span>, -<span class="hljs-number">0.13776633</span>, -<span class="hljs-number">0.7889173</span> ],
[-<span class="hljs-number">0.42943227</span>, -<span class="hljs-number">0.6364878</span> , -<span class="hljs-number">1.693462</span>  , ...,  <span class="hljs-number">0.41978157</span>, -<span class="hljs-number">2.4336355</span> ,  <span class="hljs-number">0.6162071</span> ],
...,
[ <span class="hljs-number">0.28552425</span>, -<span class="hljs-number">0.928395</span>  , -<span class="hljs-number">1.2077185</span> , ...,  <span class="hljs-number">0.76810825</span>, -<span class="hljs-number">2.1069427</span> ,  <span class="hljs-number">0.6236161</span> ]], dtype=float32)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function tM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmZpbGxfbWFzayglMjJUaGUlMjBnb2FsJTIwb2YlMjBsaWZlJTIwaXMlMjAlM0NtYXNrJTNFLiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.fill_mask(<span class="hljs-string">&quot;The goal of life is &lt;mask&gt;.&quot;</span>)
[
    FillMaskOutputElement(score=<span class="hljs-number">0.06897063553333282</span>, token=<span class="hljs-number">11098</span>, token_str=<span class="hljs-string">&#x27; happiness&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is happiness.&#x27;</span>),
    FillMaskOutputElement(score=<span class="hljs-number">0.06554922461509705</span>, token=<span class="hljs-number">45075</span>, token_str=<span class="hljs-string">&#x27; immortality&#x27;</span>, sequence=<span class="hljs-string">&#x27;The goal of life is immortality.&#x27;</span>)
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function sM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy03MEItSW5zdHJ1Y3QlMjIpJTBBYXdhaXQlMjBjbGllbnQuZ2V0X2VuZHBvaW50X2luZm8oKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_endpoint_info()
{
    <span class="hljs-string">&#x27;model_id&#x27;</span>: <span class="hljs-string">&#x27;meta-llama/Meta-Llama-3-70B-Instruct&#x27;</span>,
    <span class="hljs-string">&#x27;model_sha&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;model_dtype&#x27;</span>: <span class="hljs-string">&#x27;torch.float16&#x27;</span>,
    <span class="hljs-string">&#x27;model_device_type&#x27;</span>: <span class="hljs-string">&#x27;cuda&#x27;</span>,
    <span class="hljs-string">&#x27;model_pipeline_tag&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;max_concurrent_requests&#x27;</span>: <span class="hljs-number">128</span>,
    <span class="hljs-string">&#x27;max_best_of&#x27;</span>: <span class="hljs-number">2</span>,
    <span class="hljs-string">&#x27;max_stop_sequences&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;max_input_length&#x27;</span>: <span class="hljs-number">8191</span>,
    <span class="hljs-string">&#x27;max_total_tokens&#x27;</span>: <span class="hljs-number">8192</span>,
    <span class="hljs-string">&#x27;waiting_served_ratio&#x27;</span>: <span class="hljs-number">0.3</span>,
    <span class="hljs-string">&#x27;max_batch_total_tokens&#x27;</span>: <span class="hljs-number">1259392</span>,
    <span class="hljs-string">&#x27;max_waiting_tokens&#x27;</span>: <span class="hljs-number">20</span>,
    <span class="hljs-string">&#x27;max_batch_size&#x27;</span>: <span class="hljs-literal">None</span>,
    <span class="hljs-string">&#x27;validation_workers&#x27;</span>: <span class="hljs-number">32</span>,
    <span class="hljs-string">&#x27;max_client_batch_size&#x27;</span>: <span class="hljs-number">4</span>,
    <span class="hljs-string">&#x27;version&#x27;</span>: <span class="hljs-string">&#x27;2.0.2&#x27;</span>,
    <span class="hljs-string">&#x27;sha&#x27;</span>: <span class="hljs-string">&#x27;dccab72549635c7eb5ddb17f43f0b7cdff07c214&#x27;</span>,
    <span class="hljs-string">&#x27;docker_label&#x27;</span>: <span class="hljs-string">&#x27;sha-dccab72&#x27;</span>
}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function aM(_){let n,c=`This endpoint is mostly useful when you already know which model you want to use and want to check its
availability. If you want to discover already deployed models, you should rather use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.list_deployed_models">list_deployed_models()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-33gpw6"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function lM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmdldF9tb2RlbF9zdGF0dXMoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.get_model_status(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)
ModelStatus(loaded=<span class="hljs-literal">True</span>, state=<span class="hljs-string">&#x27;Loaded&#x27;</span>, compute_type=<span class="hljs-string">&#x27;gpu&#x27;</span>, framework=<span class="hljs-string">&#x27;text-generation-inference&#x27;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function oM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoJTIyaHR0cHMlM0ElMkYlMkZqemd1MGJ1ZWk1LnVzLWVhc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTIyKSUwQWF3YWl0JTIwY2xpZW50LmhlYWx0aF9jaGVjaygp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient(<span class="hljs-string">&quot;https://jzgu0buei5.us-east-1.aws.endpoints.huggingface.cloud&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.health_check()
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function iM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[ImageClassificationOutputElement(label=<span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>, score=<span class="hljs-number">0.9779096841812134</span>), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function rM(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function cM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3NlZ21lbnRhdGlvbiglMjJjYXQuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_segmentation(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
[ImageSegmentationOutputElement(score=<span class="hljs-number">0.989008</span>, label=<span class="hljs-string">&#x27;LABEL_184&#x27;</span>, mask=&lt;PIL.PngImagePlugin.PngImageFile image mode=L size=400x300 at <span class="hljs-number">0x7FDD2B129CC0</span>&gt;), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function pM(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function gM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuaW1hZ2VfdG9faW1hZ2UoJTIyY2F0LmpwZyUyMiUyQyUyMHByb21wdCUzRCUyMnR1cm4lMjB0aGUlMjBjYXQlMjBpbnRvJTIwYSUyMHRpZ2VyJTIyKSUwQWltYWdlLnNhdmUoJTIydGlnZXIuanBnJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.image_to_image(<span class="hljs-string">&quot;cat.jpg&quot;</span>, prompt=<span class="hljs-string">&quot;turn the cat into a tiger&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;tiger.jpg&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function uM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LmltYWdlX3RvX3RleHQoJTIyY2F0LmpwZyUyMiklMEFhd2FpdCUyMGNsaWVudC5pbWFnZV90b190ZXh0KCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;cat.jpg&quot;</span>)
<span class="hljs-string">&#x27;a cat standing in a grassy field &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.image_to_text(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
<span class="hljs-string">&#x27;a dog laying on the grass next to a flower pot &#x27;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function mM(_){let n,c=`This endpoint method does not return a live list of all models available for the Serverless Inference API service.
It searches over a cached list of models that were recently available and the list may not be up to date.
If you want to know the live status of a specific model, use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-79tj90"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function hM(_){let n,c=`This endpoint method is mostly useful for discoverability. If you already know which model you want to use and want to
check its availability, you can directly use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">get_model_status()</a>.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1vz9qc7"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function dM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQW1vZGVscyUyMCUzRCUyMGF3YWl0JTIwY2xpZW50Lmxpc3RfZGVwbG95ZWRfbW9kZWxzKCklMEFtb2RlbHMlNUIlMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlNUQlMEElMEFhd2FpdCUyMGNsaWVudC5saXN0X2RlcGxveWVkX21vZGVscyglMjJ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async contextthon</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Discover zero-shot-classification models currently deployed</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>models = <span class="hljs-keyword">await</span> client.list_deployed_models()
<span class="hljs-meta">&gt;&gt;&gt; </span>models[<span class="hljs-string">&quot;zero-shot-classification&quot;</span>]
[<span class="hljs-string">&#x27;Narsil/deberta-large-mnli-zero-cls&#x27;</span>, <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>, ...]

<span class="hljs-comment"># List from only 1 framework</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.list_deployed_models(<span class="hljs-string">&quot;text-generation-inference&quot;</span>)
{<span class="hljs-string">&#x27;text-generation&#x27;</span>: [<span class="hljs-string">&#x27;bigcode/starcoder&#x27;</span>, <span class="hljs-string">&#x27;meta-llama/Llama-2-70b-chat-hf&#x27;</span>, ...], ...}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function fM(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function yM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lm9iamVjdF9kZXRlY3Rpb24oJTIycGVvcGxlLmpwZyUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.object_detection(<span class="hljs-string">&quot;people.jpg&quot;</span>)
[ObjectDetectionOutputElement(score=<span class="hljs-number">0.9486683011054993</span>, label=<span class="hljs-string">&#x27;person&#x27;</span>, box=ObjectDetectionBoundingBox(xmin=<span class="hljs-number">59</span>, ymin=<span class="hljs-number">39</span>, xmax=<span class="hljs-number">420</span>, ymax=<span class="hljs-number">510</span>)), ...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function MM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnF1ZXN0aW9uX2Fuc3dlcmluZyhxdWVzdGlvbiUzRCUyMldoYXQncyUyMG15JTIwbmFtZSUzRiUyMiUyQyUyMGNvbnRleHQlM0QlMjJNeSUyMG5hbWUlMjBpcyUyMENsYXJhJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmtlbGV5LiUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.question_answering(question=<span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>, context=<span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>)
QuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;Clara&#x27;</span>, end=<span class="hljs-number">16</span>, score=<span class="hljs-number">0.9326565265655518</span>, start=<span class="hljs-number">11</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function bM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnNlbnRlbmNlX3NpbWlsYXJpdHkoJTBBJTIwJTIwJTIwJTIwJTIyTWFjaGluZSUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMGVhc3kuJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3RoZXJfc2VudGVuY2VzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRGVlcCUyMGxlYXJuaW5nJTIwaXMlMjBzbyUyMHN0cmFpZ2h0Zm9yd2FyZC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJUaGlzJTIwaXMlMjBzbyUyMGRpZmZpY3VsdCUyQyUyMGxpa2UlMjByb2NrZXQlMjBzY2llbmNlLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBjYW4ndCUyMGJlbGlldmUlMjBob3clMjBtdWNoJTIwSSUyMHN0cnVnZ2xlZCUyMHdpdGglMjB0aGlzLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.sentence_similarity(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Machine learning is so easy.&quot;</span>,
<span class="hljs-meta">... </span>    other_sentences=[
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Deep learning is so straightforward.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;This is so difficult, like rocket science.&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;I can&#x27;t believe how much I struggled with this.&quot;</span>,
<span class="hljs-meta">... </span>    ],
<span class="hljs-meta">... </span>)
[<span class="hljs-number">0.7785726189613342</span>, <span class="hljs-number">0.45876261591911316</span>, <span class="hljs-number">0.2906220555305481</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function jM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnN1bW1hcml6YXRpb24oJTIyVGhlJTIwRWlmZmVsJTIwdG93ZXIuLi4lMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.summarization(<span class="hljs-string">&quot;The Eiffel tower...&quot;</span>)
SummarizationOutput(generated_text=<span class="hljs-string">&quot;The Eiffel tower is one of the most famous landmarks in the world....&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function _M(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXF1ZXJ5JTIwJTNEJTIwJTIySG93JTIwbWFueSUyMHN0YXJzJTIwZG9lcyUyMHRoZSUyMHRyYW5zZm9ybWVycyUyMHJlcG9zaXRvcnklMjBoYXZlJTNGJTIyJTBBdGFibGUlMjAlM0QlMjAlN0IlMjJSZXBvc2l0b3J5JTIyJTNBJTIwJTVCJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyRGF0YXNldHMlMjIlMkMlMjAlMjJUb2tlbml6ZXJzJTIyJTVEJTJDJTIwJTIyU3RhcnMlMjIlM0ElMjAlNUIlMjIzNjU0MiUyMiUyQyUyMCUyMjQ1MTIlMjIlMkMlMjAlMjIzOTM0JTIyJTVEJTdEJTBBYXdhaXQlMjBjbGllbnQudGFibGVfcXVlc3Rpb25fYW5zd2VyaW5nKHRhYmxlJTJDJTIwcXVlcnklMkMlMjBtb2RlbCUzRCUyMmdvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>query = <span class="hljs-string">&quot;How many stars does the transformers repository have?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {<span class="hljs-string">&quot;Repository&quot;</span>: [<span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;Datasets&quot;</span>, <span class="hljs-string">&quot;Tokenizers&quot;</span>], <span class="hljs-string">&quot;Stars&quot;</span>: [<span class="hljs-string">&quot;36542&quot;</span>, <span class="hljs-string">&quot;4512&quot;</span>, <span class="hljs-string">&quot;3934&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.table_question_answering(table, query, model=<span class="hljs-string">&quot;google/tapas-base-finetuned-wtq&quot;</span>)
TableQuestionAnsweringOutputElement(answer=<span class="hljs-string">&#x27;36542&#x27;</span>, coordinates=[[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>]], cells=[<span class="hljs-string">&#x27;36542&#x27;</span>], aggregator=<span class="hljs-string">&#x27;AVERAGE&#x27;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function TM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyZml4ZWRfYWNpZGl0eSUyMiUzQSUyMCU1QiUyMjcuNCUyMiUyQyUyMCUyMjcuOCUyMiUyQyUyMCUyMjEwLjMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJ2b2xhdGlsZV9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyMC43JTIyJTJDJTIwJTIyMC44OCUyMiUyQyUyMCUyMjAuMzIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJjaXRyaWNfYWNpZCUyMiUzQSUyMCU1QiUyMjAlMjIlMkMlMjAlMjIwJTIyJTJDJTIwJTIyMC40NSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnJlc2lkdWFsX3N1Z2FyJTIyJTNBJTIwJTVCJTIyMS45JTIyJTJDJTIwJTIyMi42JTIyJTJDJTIwJTIyNi40JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyY2hsb3JpZGVzJTIyJTNBJTIwJTVCJTIyMC4wNzYlMjIlMkMlMjAlMjIwLjA5OCUyMiUyQyUyMCUyMjAuMDczJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIyZnJlZV9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjExJTIyJTJDJTIwJTIyMjUlMjIlMkMlMjAlMjI1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIydG90YWxfc3VsZnVyX2Rpb3hpZGUlMjIlM0ElMjAlNUIlMjIzNCUyMiUyQyUyMCUyMjY3JTIyJTJDJTIwJTIyMTMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJkZW5zaXR5JTIyJTNBJTIwJTVCJTIyMC45OTc4JTIyJTJDJTIwJTIyMC45OTY4JTIyJTJDJTIwJTIyMC45OTc2JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycEglMjIlM0ElMjAlNUIlMjIzLjUxJTIyJTJDJTIwJTIyMy4yJTIyJTJDJTIwJTIyMy4yMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMnN1bHBoYXRlcyUyMiUzQSUyMCU1QiUyMjAuNTYlMjIlMkMlMjAlMjIwLjY4JTIyJTJDJTIwJTIyMC44MiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmFsY29ob2wlMjIlM0ElMjAlNUIlMjI5LjQlMjIlMkMlMjAlMjI5LjglMjIlMkMlMjAlMjIxMi42JTIyJTVEJTJDJTBBJTdEJTBBYXdhaXQlMjBjbGllbnQudGFidWxhcl9jbGFzc2lmaWNhdGlvbih0YWJsZSUzRHRhYmxlJTJDJTIwbW9kZWwlM0QlMjJqdWxpZW4tYyUyRndpbmUtcXVhbGl0eSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_classification(table=table, model=<span class="hljs-string">&quot;julien-c/wine-quality&quot;</span>)
[<span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function IM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRhYmxlJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIySGVpZ2h0JTIyJTNBJTIwJTVCJTIyMTEuNTIlMjIlMkMlMjAlMjIxMi40OCUyMiUyQyUyMCUyMjEyLjM3NzglMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgxJTIyJTNBJTIwJTVCJTIyMjMuMiUyMiUyQyUyMCUyMjI0JTIyJTJDJTIwJTIyMjMuOSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMkxlbmd0aDIlMjIlM0ElMjAlNUIlMjIyNS40JTIyJTJDJTIwJTIyMjYuMyUyMiUyQyUyMCUyMjI2LjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJMZW5ndGgzJTIyJTNBJTIwJTVCJTIyMzAlMjIlMkMlMjAlMjIzMS4yJTIyJTJDJTIwJTIyMzEuMSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMlNwZWNpZXMlMjIlM0ElMjAlNUIlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTJDJTIwJTIyQnJlYW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjJXaWR0aCUyMiUzQSUyMCU1QiUyMjQuMDIlMjIlMkMlMjAlMjI0LjMwNTYlMjIlMkMlMjAlMjI0LjY5NjElMjIlNUQlMkMlMEElN0QlMEFhd2FpdCUyMGNsaWVudC50YWJ1bGFyX3JlZ3Jlc3Npb24odGFibGUlMkMlMjBtb2RlbCUzRCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>table = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>],
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.tabular_regression(table, model=<span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>)
[<span class="hljs-number">110</span>, <span class="hljs-number">120</span>, <span class="hljs-number">130</span>]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function JM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRleHRfY2xhc3NpZmljYXRpb24oJTIySSUyMGxpa2UlMjB5b3UlMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_classification(<span class="hljs-string">&quot;I like you&quot;</span>)
[
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;POSITIVE&#x27;</span>, score=<span class="hljs-number">0.9998695850372314</span>),
    TextClassificationOutputElement(label=<span class="hljs-string">&#x27;NEGATIVE&#x27;</span>, score=<span class="hljs-number">0.0001304351753788069</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function wM(_){let n,c=`If you want to generate a response from chat messages, you should use the <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">InferenceClient.chat_completion()</a> method.
It accepts a list of messages instead of a single text prompt and handles the chat templating for you.`;return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1jtiv7y"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function UM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-comment"># Case 1: generate text</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>)
<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>

<span class="hljs-comment"># Case 2: iterate over the generated tokens. Useful for large generation.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token)
<span class="hljs-number">100</span>
%
<span class="hljs-built_in">open</span>
source
<span class="hljs-keyword">and</span>
built
to
be
easy
to
use
.

<span class="hljs-comment"># Case 3: get more details about the generation process.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>)
TextGenerationOutput(
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationDetails(
        finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>,
        generated_tokens=<span class="hljs-number">12</span>,
        seed=<span class="hljs-literal">None</span>,
        prefill=[
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">487</span>, text=<span class="hljs-string">&#x27;The&#x27;</span>, logprob=<span class="hljs-literal">None</span>),
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">53789</span>, text=<span class="hljs-string">&#x27; hugging&#x27;</span>, logprob=-<span class="hljs-number">13.171875</span>),
            (...)
            TextGenerationPrefillOutputToken(<span class="hljs-built_in">id</span>=<span class="hljs-number">204</span>, text=<span class="hljs-string">&#x27; &#x27;</span>, logprob=-<span class="hljs-number">7.0390625</span>)
        ],
        tokens=[
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>),
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>),
            (...)
            TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>, text=<span class="hljs-string">&#x27;.&#x27;</span>, logprob=-<span class="hljs-number">0.5703125</span>, special=<span class="hljs-literal">False</span>)
        ],
        best_of_sequences=<span class="hljs-literal">None</span>
    )
)

<span class="hljs-comment"># Case 4: iterate over the generated tokens with more details.</span>
<span class="hljs-comment"># Last object is more complete, containing the full generated text and the finish reason.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> details <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The huggingface_hub library is &quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, details=<span class="hljs-literal">True</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(details)
...
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1425</span>, text=<span class="hljs-string">&#x27;100&#x27;</span>, logprob=-<span class="hljs-number">1.0175781</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">16</span>, text=<span class="hljs-string">&#x27;%&#x27;</span>, logprob=-<span class="hljs-number">0.0463562</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1314</span>, text=<span class="hljs-string">&#x27; open&#x27;</span>, logprob=-<span class="hljs-number">1.3359375</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3178</span>, text=<span class="hljs-string">&#x27; source&#x27;</span>, logprob=-<span class="hljs-number">0.28100586</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">273</span>, text=<span class="hljs-string">&#x27; and&#x27;</span>, logprob=-<span class="hljs-number">0.5961914</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">3426</span>, text=<span class="hljs-string">&#x27; built&#x27;</span>, logprob=-<span class="hljs-number">1.9423828</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">1.4121094</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">314</span>, text=<span class="hljs-string">&#x27; be&#x27;</span>, logprob=-<span class="hljs-number">1.5224609</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">1833</span>, text=<span class="hljs-string">&#x27; easy&#x27;</span>, logprob=-<span class="hljs-number">2.1132812</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">271</span>, text=<span class="hljs-string">&#x27; to&#x27;</span>, logprob=-<span class="hljs-number">0.08520508</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(<span class="hljs-built_in">id</span>=<span class="hljs-number">745</span>, text=<span class="hljs-string">&#x27; use&#x27;</span>, logprob=-<span class="hljs-number">0.39453125</span>, special=<span class="hljs-literal">False</span>), generated_text=<span class="hljs-literal">None</span>, details=<span class="hljs-literal">None</span>)
TextGenerationStreamOutput(token=TokenElement(
    <span class="hljs-built_in">id</span>=<span class="hljs-number">25</span>,
    text=<span class="hljs-string">&#x27;.&#x27;</span>,
    logprob=-<span class="hljs-number">0.5703125</span>,
    special=<span class="hljs-literal">False</span>),
    generated_text=<span class="hljs-string">&#x27;100% open source and built to be easy to use.&#x27;</span>,
    details=TextGenerationStreamOutputStreamDetails(finish_reason=<span class="hljs-string">&#x27;length&#x27;</span>, generated_tokens=<span class="hljs-number">12</span>, seed=<span class="hljs-literal">None</span>)
)

<span class="hljs-comment"># Case 5: generate constrained output using grammar</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = <span class="hljs-keyword">await</span> client.text_generation(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;HuggingFaceH4/zephyr-orpo-141b-A35b-v0.1&quot;</span>,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    repetition_penalty=<span class="hljs-number">1.3</span>,
<span class="hljs-meta">... </span>    grammar={
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;value&quot;</span>: {
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;properties&quot;</span>: {
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals_seen&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>, <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>},
<span class="hljs-meta">... </span>                <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>, <span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}},
<span class="hljs-meta">... </span>            },
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
<span class="hljs-meta">... </span>        },
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>json.loads(response)
{
    <span class="hljs-string">&quot;activity&quot;</span>: <span class="hljs-string">&quot;bike riding&quot;</span>,
    <span class="hljs-string">&quot;animals&quot;</span>: [<span class="hljs-string">&quot;puppy&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;raccoon&quot;</span>],
    <span class="hljs-string">&quot;animals_seen&quot;</span>: <span class="hljs-number">3</span>,
    <span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;park&quot;</span>
}`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function xM(_){let n,c="You must have <code>PIL</code> installed if you want to work with images (<code>pip install Pillow</code>).";return{c(){n=M("p"),n.innerHTML=c},l(s){n=b(s,"P",{"data-svelte-h":!0}),I(n)!=="svelte-s2e3n9"&&(n.innerHTML=c)},m(s,t){T(s,n,t)},p:J,d(s){s&&y(n)}}}function CM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJsb3clMjByZXNvbHV0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMi0xJTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYmV0dGVyX2FzdHJvbmF1dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;low resolution, blurry&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;better_astronaut.png&quot;</span>)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function $M(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMGZhbC5haSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmZhbC1haS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBmYWwuYWklMjBBUEklMjBrZXklMEEpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Use fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function kM(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzZSUyMHJlcGxpY2F0ZSUyMHByb3ZpZGVyJTBBJTIwJTIwJTIwJTIwYXBpX2tleSUzRCUyMmhmXy4uLiUyMiUyQyUyMCUyMCUyMyUyMFBhc3MlMjB5b3VyJTIwSEYlMjB0b2tlbiUwQSklMEFpbWFnZSUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMkFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjB0aGUlMjBtb29uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBKSUwQWltYWdlLnNhdmUoJTIyYXN0cm9uYXV0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Use replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function vM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMHBhdGhsaWIlMjBpbXBvcnQlMjBQYXRoJTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF1ZGlvJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19zcGVlY2goJTIySGVsbG8lMjB3b3JsZCUyMiklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>audio = <span class="hljs-keyword">await</span> client.text_to_speech(<span class="hljs-string">&quot;Hello world&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function qM(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJ5b3VyLXJlcGxpY2F0ZS1hcGkta2V5JTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBSZXBsaWNhdGUlMjBBUEklMjBrZXklMjBkaXJlY3RseSUwQSklMEFhdWRpbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3NwZWVjaCglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTIySGVsbG8lMjB3b3JsZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyT3V0ZUFJJTJGT3V0ZVRUUy0wLjMtNTAwTSUyMiUyQyUwQSklMEFQYXRoKCUyMmhlbGxvX3dvcmxkLmZsYWMlMjIpLndyaXRlX2J5dGVzKGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;your-replicate-api-key&quot;</span>,  <span class="hljs-comment"># Pass your Replicate API key directly</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function AM(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFwaV9rZXklM0QlMjJoZl8uLi4lMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMEhGJTIwdG9rZW4lMEEpJTBBYXVkaW8lMjAlM0RjbGllbnQudGV4dF90b19zcGVlY2goJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCUyMkhlbGxvJTIwd29ybGQlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMk91dGVBSSUyRk91dGVUVFMtMC4zLTUwME0lMjIlMkMlMEEpJTBBUGF0aCglMjJoZWxsb193b3JsZC5mbGFjJTIyKS53cml0ZV9ieXRlcyhhdWRpbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio =client.text_to_speech(
<span class="hljs-meta">... </span>    text=<span class="hljs-string">&quot;Hello world&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;OuteAI/OuteTTS-0.3-500M&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>Path(<span class="hljs-string">&quot;hello_world.flac&quot;</span>).write_bytes(audio)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function ZM(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwZmFsLmFpJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyZmFsLWFpLWFwaS1rZXklMjIlMkMlMjAlMjAlMjMlMjBQYXNzJTIweW91ciUyMGZhbC5haSUyMEFQSSUyMGtleSUwQSklMEF2aWRlbyUyMCUzRCUyMGNsaWVudC50ZXh0X3RvX3ZpZGVvKCUwQSUyMCUyMCUyMCUyMCUyMkElMjBtYWplc3RpYyUyMGxpb24lMjBydW5uaW5nJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIydGVuY2VudCUyRkh1bnl1YW5WaWRlbyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJsaW9uLm1wNCUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZmlsZSUzQSUwQSUyMCUyMCUyMCUyMGZpbGUud3JpdGUodmlkZW8p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;fal-ai&quot;</span>,  <span class="hljs-comment"># Using fal.ai provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;fal-ai-api-key&quot;</span>,  <span class="hljs-comment"># Pass your fal.ai API key</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion running in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;tencent/HunyuanVideo&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;lion.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function EM(_){let n,c;return n=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMEElMjAlMjAlMjAlMjBwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMCUyMCUyMyUyMFVzaW5nJTIwcmVwbGljYXRlJTIwcHJvdmlkZXIlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNEJTIyaGZfLi4uJTIyJTJDJTIwJTIwJTIzJTIwUGFzcyUyMHlvdXIlMjBIRiUyMHRva2VuJTBBKSUwQXZpZGVvJTIwJTNEJTIwY2xpZW50LnRleHRfdG9fdmlkZW8oJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGNhdCUyMHJ1bm5pbmclMjBpbiUyMGElMjBwYXJrJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJnZW5tbyUyRm1vY2hpLTEtcHJldmlldyUyMiUyQyUwQSklMEF3aXRoJTIwb3BlbiglMjJjYXQubXA0JTIyJTJDJTIwJTIyd2IlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwZmlsZS53cml0ZSh2aWRlbyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
<span class="hljs-meta">... </span>    provider=<span class="hljs-string">&quot;replicate&quot;</span>,  <span class="hljs-comment"># Using replicate provider</span>
<span class="hljs-meta">... </span>    api_key=<span class="hljs-string">&quot;hf_...&quot;</span>,  <span class="hljs-comment"># Pass your HF token</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = client.text_to_video(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A cat running in a park&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;genmo/mochi-1-preview&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;cat.mp4&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> file:
<span class="hljs-meta">... </span>    file.write(video)`,wrap:!1}}),{c(){g(n.$$.fragment)},l(s){u(n.$$.fragment,s)},m(s,t){m(n,s,t),c=!0},p:J,i(s){c||(h(n.$$.fragment,s),c=!0)},o(s){d(n.$$.fragment,s),c=!1},d(s){f(n,s)}}}function WM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRva2VuX2NsYXNzaWZpY2F0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMik=",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.token_classification(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>)
[
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9971321225166321</span>,
        word=<span class="hljs-string">&#x27;Sarah Jessica Parker&#x27;</span>,
        start=<span class="hljs-number">11</span>,
        end=<span class="hljs-number">31</span>,
    ),
    TokenClassificationOutputElement(
        entity_group=<span class="hljs-string">&#x27;PER&#x27;</span>,
        score=<span class="hljs-number">0.9773476123809814</span>,
        word=<span class="hljs-string">&#x27;Jessica&#x27;</span>,
        start=<span class="hljs-number">52</span>,
        end=<span class="hljs-number">59</span>,
    )
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function NM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyKSUwQWF3YWl0JTIwY2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQmVybGluJTIyJTJDJTIwbW9kZWwlM0QlMjJIZWxzaW5raS1OTFAlMkZvcHVzLW10LWVuLWZyJTIyKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>)
<span class="hljs-string">&#x27;Mein Name ist Wolfgang und ich lebe in Berlin.&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.translation(<span class="hljs-string">&quot;My name is Wolfgang and I live in Berlin&quot;</span>, model=<span class="hljs-string">&quot;Helsinki-NLP/opus-mt-en-fr&quot;</span>)
TranslationOutput(translation_text=<span class="hljs-string">&#x27;Je m&#x27;</span>appelle Wolfgang et je vis à Berlin.<span class="hljs-string">&#x27;)</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function GM(_){let n,c="Specifying languages:",s,t,o;return t=new w({props:{code:"Y2xpZW50LnRyYW5zbGF0aW9uKCUyMk15JTIwbmFtZSUyMGlzJTIwU2FyYWglMjBKZXNzaWNhJTIwUGFya2VyJTIwYnV0JTIweW91JTIwY2FuJTIwY2FsbCUyMG1lJTIwSmVzc2ljYSUyMiUyQyUyMG1vZGVsJTNEJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJlbl9YWCUyMiUyQyUyMHRndF9sYW5nJTNEJTIyZnJfWFglMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client.translation(<span class="hljs-string">&quot;My name is Sarah Jessica Parker but you can call me Jessica&quot;</span>, model=<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;en_XX&quot;</span>, tgt_lang=<span class="hljs-string">&quot;fr_XX&quot;</span>)
<span class="hljs-string">&quot;Mon nom est Sarah Jessica Parker mais vous pouvez m&#x27;appeler Jessica&quot;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-mhcj6c"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function BM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50LnZpc3VhbF9xdWVzdGlvbl9hbnN3ZXJpbmcoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtaXNoaWclMkZzYW1wbGVfaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0aWdlci5qcGclMjIlMkMlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzRCUyMldoYXQlMjBpcyUyMHRoZSUyMGFuaW1hbCUyMGRvaW5nJTNGJTIyJTBBKQ==",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.visual_question_answering(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/datasets/mishig/sample_images/resolve/main/tiger.jpg&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the animal doing?&quot;</span>
<span class="hljs-meta">... </span>)
[
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.778609573841095</span>, answer=<span class="hljs-string">&#x27;laying down&#x27;</span>),
    VisualQuestionAnsweringOutputElement(score=<span class="hljs-number">0.6957435607910156</span>, answer=<span class="hljs-string">&#x27;sitting&#x27;</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function QM(_){let n,c="Example with <code>multi_label=False</code>:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyQSUyMG5ldyUyMG1vZGVsJTIwb2ZmZXJzJTIwYW4lMjBleHBsYW5hdGlvbiUyMGZvciUyMGhvdyUyMHRoZSUyMEdhbGlsZWFuJTIwc2F0ZWxsaXRlcyUyMGZvcm1lZCUyMGFyb3VuZCUyMHRoZSUyMHNvbGFyJTIwc3lzdGVtJ3MlMjIlMEElMjAlMjAlMjAlMjAlMjJsYXJnZXN0JTIwd29ybGQuJTIwS29uc3RhbnRpbiUyMEJhdHlnaW4lMjBkaWQlMjBub3QlMjBzZXQlMjBvdXQlMjB0byUyMHNvbHZlJTIwb25lJTIwb2YlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSdzJTIwbW9zdCUyMHB1enpsaW5nJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTIwbXlzdGVyaWVzJTIwd2hlbiUyMGhlJTIwd2VudCUyMGZvciUyMGElMjBydW4lMjB1cCUyMGElMjBoaWxsJTIwaW4lMjBOaWNlJTJDJTIwRnJhbmNlLiUyMiUwQSklMEFsYWJlbHMlMjAlM0QlMjAlNUIlMjJzcGFjZSUyMCUyNiUyMGNvc21vcyUyMiUyQyUyMCUyMnNjaWVudGlmaWMlMjBkaXNjb3ZlcnklMjIlMkMlMjAlMjJtaWNyb2Jpb2xvZ3klMjIlMkMlMjAlMjJyb2JvdHMlMjIlMkMlMjAlMjJhcmNoZW9sb2d5JTIyJTVEJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMpJTBBYXdhaXQlMjBjbGllbnQuemVyb19zaG90X2NsYXNzaWZpY2F0aW9uKHRleHQlMkMlMjBsYWJlbHMlMkMlMjBtdWx0aV9sYWJlbCUzRFRydWUp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A new model offers an explanation for how the Galilean satellites formed around the solar system&#x27;s&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;largest world. Konstantin Batygin did not set out to solve one of the solar system&#x27;s most puzzling&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot; mysteries when he went for a run up a hill in Nice, France.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [<span class="hljs-string">&quot;space &amp; cosmos&quot;</span>, <span class="hljs-string">&quot;scientific discovery&quot;</span>, <span class="hljs-string">&quot;microbiology&quot;</span>, <span class="hljs-string">&quot;robots&quot;</span>, <span class="hljs-string">&quot;archeology&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.7961668968200684</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.18570658564567566</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.00730885099619627</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.006258360575884581</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.004559356719255447</span>),
]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(text, labels, multi_label=<span class="hljs-literal">True</span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;scientific discovery&#x27;</span>, score=<span class="hljs-number">0.9829297661781311</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;space &amp; cosmos&#x27;</span>, score=<span class="hljs-number">0.755190908908844</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;microbiology&#x27;</span>, score=<span class="hljs-number">0.0005462635890580714</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;archeology&#x27;</span>, score=<span class="hljs-number">0.00047131875180639327</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;robots&#x27;</span>, score=<span class="hljs-number">0.00030448526376858354</span>),
]`,wrap:!1}}),{c(){n=M("p"),n.innerHTML=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-90ztrp"&&(n.innerHTML=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function VM(_){let n,c="Example with <code>multi_label=True</code> and a custom <code>hypothesis_template</code>:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjB0ZXh0JTNEJTIySSUyMHJlYWxseSUyMGxpa2UlMjBvdXIlMjBkaW5uZXIlMjBhbmQlMjBJJ20lMjB2ZXJ5JTIwaGFwcHkuJTIwSSUyMGRvbid0JTIwbGlrZSUyMHRoZSUyMHdlYXRoZXIlMjB0aG91Z2guJTIyJTJDJTBBJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIycG9zaXRpdmUlMjIlMkMlMjAlMjJuZWdhdGl2ZSUyMiUyQyUyMCUyMnBlc3NpbWlzdGljJTIyJTJDJTIwJTIyb3B0aW1pc3RpYyUyMiU1RCUyQyUwQSUyMCUyMCUyMG11bHRpX2xhYmVsJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMGh5cG90aGVzaXNfdGVtcGxhdGUlM0QlMjJUaGlzJTIwdGV4dCUyMGlzJTIwJTdCJTdEJTIwdG93YXJkcyUyMHRoZSUyMHdlYXRoZXIlMjIlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_classification(
<span class="hljs-meta">... </span>   text=<span class="hljs-string">&quot;I really like our dinner and I&#x27;m very happy. I don&#x27;t like the weather though.&quot;</span>,
<span class="hljs-meta">... </span>   labels=[<span class="hljs-string">&quot;positive&quot;</span>, <span class="hljs-string">&quot;negative&quot;</span>, <span class="hljs-string">&quot;pessimistic&quot;</span>, <span class="hljs-string">&quot;optimistic&quot;</span>],
<span class="hljs-meta">... </span>   multi_label=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>   hypothesis_template=<span class="hljs-string">&quot;This text is {} towards the weather&quot;</span>
<span class="hljs-meta">... </span>)
[
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;negative&#x27;</span>, score=<span class="hljs-number">0.9231801629066467</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;pessimistic&#x27;</span>, score=<span class="hljs-number">0.8760990500450134</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;optimistic&#x27;</span>, score=<span class="hljs-number">0.0008674879791215062</span>),
    ZeroShotClassificationOutputElement(label=<span class="hljs-string">&#x27;positive&#x27;</span>, score=<span class="hljs-number">0.0005250611575320363</span>)
]`,wrap:!1}}),{c(){n=M("p"),n.innerHTML=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-1qklg9x"&&(n.innerHTML=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function SM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWF3YWl0JTIwY2xpZW50Lnplcm9fc2hvdF9pbWFnZV9jbGFzc2lmaWNhdGlvbiglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRnVwbG9hZC53aWtpbWVkaWEub3JnJTJGd2lraXBlZGlhJTJGY29tbW9ucyUyRnRodW1iJTJGNCUyRjQzJTJGQ3V0ZV9kb2cuanBnJTJGMzIwcHgtQ3V0ZV9kb2cuanBnJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTNEJTVCJTIyZG9nJTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIyaG9yc2UlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-comment"># Must be run in an async context</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> client.zero_shot_image_classification(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>,
<span class="hljs-meta">... </span>    labels=[<span class="hljs-string">&quot;dog&quot;</span>, <span class="hljs-string">&quot;cat&quot;</span>, <span class="hljs-string">&quot;horse&quot;</span>],
<span class="hljs-meta">... </span>)
[ZeroShotImageClassificationOutputElement(label=<span class="hljs-string">&#x27;dog&#x27;</span>, score=<span class="hljs-number">0.956</span>),...]`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function YM(_){let n,c="Example:",s,t,o;return t=new w({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub.inference_api <span class="hljs-keyword">import</span> InferenceApi

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Mask-fill example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs=<span class="hljs-string">&quot;The goal of life is [MASK].&quot;</span>)
[{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;the goal of life is life.&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.10933292657136917</span>, <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">2166</span>, <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27;life&#x27;</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Question Answering example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;deepset/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;question&quot;</span>: <span class="hljs-string">&quot;What&#x27;s my name?&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;context&quot;</span>: <span class="hljs-string">&quot;My name is Clara and I live in Berkeley.&quot;</span>,
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9326569437980652</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;Clara&#x27;</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Zero-shot example</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;typeform/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-string">&quot;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = {<span class="hljs-string">&quot;candidate_labels&quot;</span>: [<span class="hljs-string">&quot;refund&quot;</span>, <span class="hljs-string">&quot;legal&quot;</span>, <span class="hljs-string">&quot;faq&quot;</span>]}
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(inputs, params)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.9378499388694763</span>, <span class="hljs-number">0.04914155602455139</span>, <span class="hljs-number">0.013008488342165947</span>]}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Overriding configured task</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Text-to-image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inference(<span class="hljs-string">&quot;cat&quot;</span>)
&lt;PIL.PngImagePlugin.PngImageFile image (...)&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Return as raw response to parse the output yourself</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inference = InferenceApi(<span class="hljs-string">&quot;mio/amadeus&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = inference(<span class="hljs-string">&quot;hello world&quot;</span>, raw_response=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response.headers
{<span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;audio/flac&quot;</span>, ...}
<span class="hljs-meta">&gt;&gt;&gt; </span>response.content <span class="hljs-comment"># raw bytes from server</span>
<span class="hljs-string">b&#x27;(...)&#x27;</span>`,wrap:!1}}),{c(){n=M("p"),n.textContent=c,s=i(),g(t.$$.fragment)},l(e){n=b(e,"P",{"data-svelte-h":!0}),I(n)!=="svelte-11lpom8"&&(n.textContent=c),s=r(e),u(t.$$.fragment,e)},m(e,p){T(e,n,p),T(e,s,p),m(t,e,p),o=!0},p:J,i(e){o||(h(t.$$.fragment,e),o=!0)},o(e){d(t.$$.fragment,e),o=!1},d(e){e&&(y(n),y(s)),f(t,e)}}}function RM(_){let n,c,s,t,o,e,p,Ym="추론은 학습된 모델을 사용하여 새로운 데이터를 예측하는 과정입니다. 이 과정은 계산량이 많을 수 있기 때문에, 전용 서버에서 실행하는 것이 흥미로운 옵션이 될 수 있습니다. <code>huggingface_hub</code> 라이브러리는 호스팅된 모델에 대한 추론을 실행하는 간단한 방법을 제공합니다. 연결할 수 있는 서비스는 여러가지가 있습니다:",sr,ba,Rm='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">추론 API</a>: Hugging Face의 인프라에서 가속화된 추론을 무료로 실행할 수 있는 서비스입니다. 이 서비스는 시작하기 위한 빠른 방법이며, 다양한 모델을 테스트하고 AI 제품을 프로토타입화하는 데에도 유용합니다.</li> <li><a href="https://huggingface.co/inference-endpoints" rel="nofollow">추론 엔드포인트</a>: 모델을 쉽게 운영 환경으로 배포할 수 있는 제품입니다. 추론은 여러분이 선택한 클라우드 제공업체의 전용 및 완전히 관리되는 인프라에서 Hugging Face에 의해 실행됩니다.</li>',ar,ja,zm='이러한 서비스는 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> 객체를 사용하여 호출할 수 있습니다. 자세한 사용 방법에 대해서는 <a href="../guides/inference">이 가이드</a>를 참조해주세요.',lr,_a,or,C,Ta,wr,so,Xm="Initialize a new Inference Client.",Ur,ao,Fm=`<a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,xr,ze,Ia,Cr,lo,Hm="Perform audio classification on the provided audio content.",$r,ut,kr,Xe,Ja,vr,oo,Dm="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",qr,mt,Ar,Fe,wa,Zr,io,Om="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",Er,ht,Wr,Z,Ua,Nr,ro,Lm="A method for completing conversations using a specified language model.",Gr,dt,Br,ft,Qr,yt,Vr,Mt,Sr,bt,Yr,co,Pm="Example using a third-party provider directly. Usage will be billed on your Together AI account.",Rr,jt,zr,po,Km="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Xr,_t,Fr,Tt,Hr,It,Dr,Jt,Or,He,xa,Lr,go,eh="Answer questions on document images.",Pr,wt,Kr,De,Ca,ec,uo,nh="Generate embeddings for a given text.",nc,Ut,tc,Oe,$a,sc,mo,th="Fill in a hole with a missing word (token to be precise).",ac,xt,lc,ie,ka,oc,ho,sh="Get information about the deployed endpoint.",ic,fo,ah=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,rc,Ct,cc,re,va,pc,yo,lh="Get the status of a model hosted on the Inference API.",gc,$t,uc,kt,mc,ce,qa,hc,Mo,oh="Check the health of the deployed endpoint.",dc,bo,ih=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,fc,vt,yc,Le,Aa,Mc,jo,rh="Perform image classification on the given image using the specified model.",bc,qt,jc,pe,Za,_c,_o,ch="Perform image segmentation on the given image using the specified model.",Tc,At,Ic,Zt,Jc,ge,Ea,wc,To,ph="Perform image-to-image translation using a specified model.",Uc,Et,xc,Wt,Cc,ue,Wa,$c,Io,gh="Takes an input image and return text.",kc,Jo,uh=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,vc,Nt,qc,L,Na,Ac,wo,mh="List models deployed on the Serverless Inference API service.",Zc,Uo,hh=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,Ec,Gt,Wc,Bt,Nc,Qt,Gc,me,Ga,Bc,xo,dh="Perform object detection on the given image using the specified model.",Qc,Vt,Vc,St,Sc,Pe,Ba,Yc,Co,fh="Make a POST request to the inference server.",Rc,$o,yh=`This method is deprecated and will be removed in the future.
Please use task methods instead (e.g. <code>InferenceClient.chat_completion</code>).`,zc,Ke,Qa,Xc,ko,Mh="Retrieve the answer to a question from a given text.",Fc,Yt,Hc,en,Va,Dc,vo,bh="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",Oc,Rt,Lc,nn,Sa,Pc,qo,jh="Generate a summary of a given text using a specified model.",Kc,zt,ep,tn,Ya,np,Ao,_h="Retrieve the answer to a question from information given in a table.",tp,Xt,sp,sn,Ra,ap,Zo,Th="Classifying a target category (a group) based on a set of attributes.",lp,Ft,op,an,za,ip,Eo,Ih="Predicting a numerical target value given a set of attributes/features in a table.",rp,Ht,cp,ln,Xa,pp,Wo,Jh="Perform text classification (e.g. sentiment-analysis) on the given text.",gp,Dt,up,he,Fa,mp,No,wh="Given a prompt, generate the following text.",hp,Ot,dp,Lt,fp,B,Ha,yp,Go,Uh="Generate an image based on a given text using a specified model.",Mp,Pt,bp,Kt,jp,es,_p,Bo,xh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Tp,ns,Ip,Q,Da,Jp,Qo,Ch="Synthesize an audio of a voice pronouncing a given text.",wp,ts,Up,Vo,$h="Example using a third-party provider directly. Usage will be billed on your Replicate account.",xp,ss,Cp,So,kh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",$p,as,kp,V,Oa,vp,Yo,vh="Generate a video based on a given text.",qp,Ro,qh="Example:",Ap,zo,Ah="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",Zp,ls,Ep,Xo,Zh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Wp,os,Np,on,La,Gp,Fo,Eh=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,Bp,is,Qp,te,Pa,Vp,Ho,Wh="Convert text from one language to another.",Sp,Do,Nh=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Yp,rs,Rp,cs,zp,rn,Ka,Xp,Oo,Gh="Answering open-ended questions based on an image.",Fp,ps,Hp,de,el,Dp,Lo,Bh="Provide as input a text and a set of candidate labels to classify the input text.",Op,gs,Lp,us,Pp,cn,nl,Kp,Po,Qh="Provide input image and text labels to predict text labels for the image.",eg,ms,ir,tl,rr,sl,Vh=`비동기 버전의 클라이언트도 제공되며, 이는 <code>asyncio</code>와 <code>aiohttp</code>를 기반으로 작동합니다.
이를 사용하려면 <code>aiohttp</code>를 직접 설치하거나 <code>[inference]</code> 추가 기능을 사용할 수 있습니다:`,cr,al,pr,x,ll,ng,Ko,Sh="Initialize a new Inference Client.",tg,ei,Yh=`<a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> aims to provide a unified experience to perform inference. The client can be used
seamlessly with either the (free) Inference API, self-hosted Inference Endpoints, or third-party Inference Providers.`,sg,pn,ol,ag,ni,Rh="Perform audio classification on the provided audio content.",lg,hs,og,gn,il,ig,ti,zh="Performs multiple tasks related to audio-to-audio depending on the model (eg: speech enhancement, source separation).",rg,ds,cg,un,rl,pg,si,Xh="Perform automatic speech recognition (ASR or audio-to-text) on the given audio content.",gg,fs,ug,E,cl,mg,ai,Fh="A method for completing conversations using a specified language model.",hg,ys,dg,Ms,fg,bs,yg,js,Mg,_s,bg,li,Hh="Example using a third-party provider directly. Usage will be billed on your Together AI account.",jg,Ts,_g,oi,Dh="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",Tg,Is,Ig,Js,Jg,ws,wg,Us,Ug,fe,pl,xg,ii,Oh="Close all open sessions.",Cg,ri,Lh=`By default, ‘aiohttp.ClientSession’ objects are closed automatically when a call is completed. However, if you
are streaming data from the server and you stop before the stream is complete, you must call this method to
close the session properly.`,$g,ci,Ph="Another possibility is to use an async context (e.g. <code>async with AsyncInferenceClient(): ...</code>).",kg,mn,gl,vg,pi,Kh="Answer questions on document images.",qg,xs,Ag,hn,ul,Zg,gi,ed="Generate embeddings for a given text.",Eg,Cs,Wg,dn,ml,Ng,ui,nd="Fill in a hole with a missing word (token to be precise).",Gg,$s,Bg,ye,hl,Qg,mi,td="Get information about the deployed endpoint.",Vg,hi,sd=`This endpoint is only available on endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
Endpoints powered by <code>transformers</code> return an empty payload.`,Sg,ks,Yg,Me,dl,Rg,di,ad="Get the status of a model hosted on the Inference API.",zg,vs,Xg,qs,Fg,be,fl,Hg,fi,ld="Check the health of the deployed endpoint.",Dg,yi,od=`Health check is only available with Inference Endpoints powered by Text-Generation-Inference (TGI) or Text-Embedding-Inference (TEI).
For Inference API, please use <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient.get_model_status">InferenceClient.get_model_status()</a> instead.`,Og,As,Lg,fn,yl,Pg,Mi,id="Perform image classification on the given image using the specified model.",Kg,Zs,eu,je,Ml,nu,bi,rd="Perform image segmentation on the given image using the specified model.",tu,Es,su,Ws,au,_e,bl,lu,ji,cd="Perform image-to-image translation using a specified model.",ou,Ns,iu,Gs,ru,Te,jl,cu,_i,pd="Takes an input image and return text.",pu,Ti,gd=`Models can have very different outputs depending on your use case (image captioning, optical character recognition
(OCR), Pix2Struct, etc). Please have a look to the model card to learn more about a model’s specificities.`,gu,Bs,uu,P,_l,mu,Ii,ud="List models deployed on the Serverless Inference API service.",hu,Ji,md=`This helper checks deployed models framework by framework. By default, it will check the 4 main frameworks that
are supported and account for 95% of the hosted models. However, if you want a complete list of models you can
specify <code>frameworks=&quot;all&quot;</code> as input. Alternatively, if you know before-hand which framework you are interested
in, you can also restrict to search to this one (e.g. <code>frameworks=&quot;text-generation-inference&quot;</code>). The more
frameworks are checked, the more time it will take.`,du,Qs,fu,Vs,yu,Ss,Mu,Ie,Tl,bu,wi,hd="Perform object detection on the given image using the specified model.",ju,Ys,_u,Rs,Tu,yn,Il,Iu,Ui,dd="Make a POST request to the inference server.",Ju,xi,fd=`This method is deprecated and will be removed in the future.
Please use task methods instead (e.g. <code>InferenceClient.chat_completion</code>).`,wu,Mn,Jl,Uu,Ci,yd="Retrieve the answer to a question from a given text.",xu,zs,Cu,bn,wl,$u,$i,Md="Compute the semantic similarity between a sentence and a list of other sentences by comparing their embeddings.",ku,Xs,vu,jn,Ul,qu,ki,bd="Generate a summary of a given text using a specified model.",Au,Fs,Zu,_n,xl,Eu,vi,jd="Retrieve the answer to a question from information given in a table.",Wu,Hs,Nu,Tn,Cl,Gu,qi,_d="Classifying a target category (a group) based on a set of attributes.",Bu,Ds,Qu,In,$l,Vu,Ai,Td="Predicting a numerical target value given a set of attributes/features in a table.",Su,Os,Yu,Jn,kl,Ru,Zi,Id="Perform text classification (e.g. sentiment-analysis) on the given text.",zu,Ls,Xu,Je,vl,Fu,Ei,Jd="Given a prompt, generate the following text.",Hu,Ps,Du,Ks,Ou,S,ql,Lu,Wi,wd="Generate an image based on a given text using a specified model.",Pu,ea,Ku,na,em,ta,nm,Ni,Ud="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",tm,sa,sm,Y,Al,am,Gi,xd="Synthesize an audio of a voice pronouncing a given text.",lm,aa,om,Bi,Cd="Example using a third-party provider directly. Usage will be billed on your Replicate account.",im,la,rm,Qi,$d="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",cm,oa,pm,R,Zl,gm,Vi,kd="Generate a video based on a given text.",um,Si,vd="Example:",mm,Yi,qd="Example using a third-party provider directly. Usage will be billed on your fal.ai account.",hm,ia,dm,Ri,Ad="Example using a third-party provider through Hugging Face Routing. Usage will be billed on your Hugging Face account.",fm,ra,ym,wn,El,Mm,zi,Zd=`Perform token classification on the given text.
Usually used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.`,bm,ca,jm,se,Wl,_m,Xi,Ed="Convert text from one language to another.",Tm,Fi,Wd=`Check out <a href="https://huggingface.co/tasks/translation" rel="nofollow">https://huggingface.co/tasks/translation</a> for more information on how to choose the best model for
your specific use case. Source and target languages usually depend on the model.
However, it is possible to specify source and target languages for certain models. If you are working with one of these models,
you can use <code>src_lang</code> and <code>tgt_lang</code> arguments to pass the relevant information.`,Im,pa,Jm,ga,wm,Un,Nl,Um,Hi,Nd="Answering open-ended questions based on an image.",xm,ua,Cm,we,Gl,$m,Di,Gd="Provide as input a text and a set of candidate labels to classify the input text.",km,ma,vm,ha,qm,xn,Bl,Am,Oi,Bd="Provide input image and text labels to predict text labels for the image.",Zm,da,gr,Ql,ur,Cn,Vl,Em,Li,Qd="Error raised when a model is unavailable or the request times out.",mr,Sl,hr,Yl,Vd="대부분의 작업에 대해, 반환 값은 내장된 유형(string, list, image…)을 갖습니다. 보다 복잡한 유형을 위한 목록은 다음과 같습니다.",dr,Rl,fr,$n,zl,Wm,Pi,Sd="This Dataclass represents the model status in the Hugging Face Inference API.",yr,Xl,Mr,Fl,Yd='<code>InferenceAPI</code>는 추론 API를 호출하는 레거시 방식입니다. 이 인터페이스는 더 간단하며 각 작업의 입력 매개변수와 출력 형식을 알아야 합니다. 또한 추론 엔드포인트나 AWS SageMaker와 같은 다른 서비스에 연결할 수 있는 기능이 없습니다. <code>InferenceAPI</code>는 곧 폐지될 예정이므로 가능한 경우 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>를 사용하는 것을 권장합니다. 스크립트에서 <code>InferenceAPI</code>를 <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>로 전환하는 방법에 대해 알아보려면 <a href="../guides/inference#legacy-inferenceapi-client">이 가이드</a>를 참조하세요.',br,K,Hl,Nm,Ki,Rd="Client to configure requests and make calls to the HuggingFace Inference API.",Gm,fa,Bm,ya,Dl,Qm,er,zd="Inits headers and API call information.",Vm,Ma,Ol,Sm,nr,Xd="Make a call to the Inference API.",jr,Ll,_r,tr,Tr;return o=new to({props:{title:"추론",local:"inference",headingTag:"h1"}}),_a=new to({props:{title:"추론 클라이언트",local:"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient",headingTag:"h2"}}),Ta=new A({props:{name:"class huggingface_hub.InferenceClient",anchor:"huggingface_hub.InferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Optional[typing.Literal['fal-ai', 'hf-inference', 'replicate', 'sambanova', 'together']] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. Can be <code>&quot;replicate&quot;</code>, <code>&quot;together&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;sambanova&quot;</code> or <code>&quot;hf-inference&quot;</code>.
defaults to hf-inference (Hugging Face Serverless Inference API).
If model is a URL or <code>base_url</code> is passed, then <code>provider</code> is not used.`,name:"provider"},{anchor:"huggingface_hub.InferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.InferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.InferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.InferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.InferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.InferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.InferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L120"}}),Ia=new A({props:{name:"audio_classification",anchor:"huggingface_hub.InferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L355",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ut=new U({props:{anchor:"huggingface_hub.InferenceClient.audio_classification.example",$$slots:{default:[Bf]},$$scope:{ctx:_}}}),Ja=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.InferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L411",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),mt=new U({props:{anchor:"huggingface_hub.InferenceClient.audio_to_audio.example",$$slots:{default:[Qf]},$$scope:{ctx:_}}}),wa=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.parameters",description:`<strong>parameters</strong> (Dict[str, Any], <em>optional</em>) &#x2014;
Additional parameters to pass to the model.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ht=new U({props:{anchor:"huggingface_hub.InferenceClient.automatic_speech_recognition.example",$$slots:{default:[Vf]},$$scope:{ctx:_}}}),Ua=new A({props:{name:"chat_completion",anchor:"huggingface_hub.InferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Dict]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputGrammarType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.InferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.InferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.InferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.InferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.InferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.InferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.InferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.InferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.InferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),dt=new G({props:{$$slots:{default:[Sf]},$$scope:{ctx:_}}}),ft=new G({props:{$$slots:{default:[Yf]},$$scope:{ctx:_}}}),yt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example",$$slots:{default:[Rf]},$$scope:{ctx:_}}}),Mt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-2",$$slots:{default:[zf]},$$scope:{ctx:_}}}),bt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-3",$$slots:{default:[Xf]},$$scope:{ctx:_}}}),jt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-4",$$slots:{default:[Ff]},$$scope:{ctx:_}}}),_t=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-5",$$slots:{default:[Hf]},$$scope:{ctx:_}}}),Tt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-6",$$slots:{default:[Df]},$$scope:{ctx:_}}}),It=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-7",$$slots:{default:[Of]},$$scope:{ctx:_}}}),Jt=new U({props:{anchor:"huggingface_hub.InferenceClient.chat_completion.example-8",$$slots:{default:[Lf]},$$scope:{ctx:_}}}),xa=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.InferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L977",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),wt=new U({props:{anchor:"huggingface_hub.InferenceClient.document_question_answering.example",$$slots:{default:[Pf]},$$scope:{ctx:_}}}),Ca=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.InferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.InferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1063",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>HTTPError</code></p>
`}}),Ut=new U({props:{anchor:"huggingface_hub.InferenceClient.feature_extraction.example",$$slots:{default:[Kf]},$$scope:{ctx:_}}}),$a=new A({props:{name:"fill_mask",anchor:"huggingface_hub.InferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.InferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.InferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1135",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),xt=new U({props:{anchor:"huggingface_hub.InferenceClient.fill_mask.example",$$slots:{default:[ey]},$$scope:{ctx:_}}}),ka=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.InferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3262",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Ct=new U({props:{anchor:"huggingface_hub.InferenceClient.get_endpoint_info.example",$$slots:{default:[ny]},$$scope:{ctx:_}}}),va=new A({props:{name:"get_model_status",anchor:"huggingface_hub.InferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3357",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),$t=new G({props:{$$slots:{default:[ty]},$$scope:{ctx:_}}}),kt=new U({props:{anchor:"huggingface_hub.InferenceClient.get_model_status.example",$$slots:{default:[sy]},$$scope:{ctx:_}}}),qa=new A({props:{name:"health_check",anchor:"huggingface_hub.InferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3320",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),vt=new U({props:{anchor:"huggingface_hub.InferenceClient.health_check.example",$$slots:{default:[ay]},$$scope:{ctx:_}}}),Aa=new A({props:{name:"image_classification",anchor:"huggingface_hub.InferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.InferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1190",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),qt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_classification.example",$$slots:{default:[ly]},$$scope:{ctx:_}}}),Za=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.InferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.InferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),At=new G({props:{warning:!0,$$slots:{default:[oy]},$$scope:{ctx:_}}}),Zt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_segmentation.example",$$slots:{default:[iy]},$$scope:{ctx:_}}}),Ea=new A({props:{name:"image_to_image",anchor:"huggingface_hub.InferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1308",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Et=new G({props:{warning:!0,$$slots:{default:[ry]},$$scope:{ctx:_}}}),Wt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_to_image.example",$$slots:{default:[cy]},$$scope:{ctx:_}}}),Wa=new A({props:{name:"image_to_text",anchor:"huggingface_hub.InferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.InferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Nt=new U({props:{anchor:"huggingface_hub.InferenceClient.image_to_text.example",$$slots:{default:[py]},$$scope:{ctx:_}}}),Na=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.InferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3174",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Gt=new G({props:{warning:!0,$$slots:{default:[gy]},$$scope:{ctx:_}}}),Bt=new G({props:{$$slots:{default:[uy]},$$scope:{ctx:_}}}),Qt=new U({props:{anchor:"huggingface_hub.InferenceClient.list_deployed_models.example",$$slots:{default:[my]},$$scope:{ctx:_}}}),Ga=new A({props:{name:"object_detection",anchor:"huggingface_hub.InferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1428",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),Vt=new G({props:{warning:!0,$$slots:{default:[hy]},$$scope:{ctx:_}}}),St=new U({props:{anchor:"huggingface_hub.InferenceClient.object_detection.example",$$slots:{default:[dy]},$$scope:{ctx:_}}}),Ba=new A({props:{name:"post",anchor:"huggingface_hub.InferenceClient.post",parameters:[{name:"json",val:": typing.Union[str, typing.Dict, typing.List, NoneType] = None"},{name:"data",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, NoneType] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L241"}}),Qa=new A({props:{name:"question_answering",anchor:"huggingface_hub.InferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.InferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.InferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.InferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.InferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1478",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Yt=new U({props:{anchor:"huggingface_hub.InferenceClient.question_answering.example",$$slots:{default:[fy]},$$scope:{ctx:_}}}),Va=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.InferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.InferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Rt=new U({props:{anchor:"huggingface_hub.InferenceClient.sentence_similarity.example",$$slots:{default:[yy]},$$scope:{ctx:_}}}),Sa=new A({props:{name:"summarization",anchor:"huggingface_hub.InferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.InferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1614",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),zt=new U({props:{anchor:"huggingface_hub.InferenceClient.summarization.example",$$slots:{default:[My]},$$scope:{ctx:_}}}),Ya=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.InferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.InferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1671",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Xt=new U({props:{anchor:"huggingface_hub.InferenceClient.table_question_answering.example",$$slots:{default:[by]},$$scope:{ctx:_}}}),Ra=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.InferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ft=new U({props:{anchor:"huggingface_hub.InferenceClient.tabular_classification.example",$$slots:{default:[jy]},$$scope:{ctx:_}}}),za=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.InferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.InferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1787",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ht=new U({props:{anchor:"huggingface_hub.InferenceClient.tabular_regression.example",$$slots:{default:[_y]},$$scope:{ctx:_}}}),Xa=new A({props:{name:"text_classification",anchor:"huggingface_hub.InferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L1836",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Dt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_classification.example",$$slots:{default:[Ty]},$$scope:{ctx:_}}}),Fa=new A({props:{name:"text_generation",anchor:"huggingface_hub.InferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.InferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.InferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.InferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.InferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.InferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.InferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.InferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.InferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.InferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.InferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.InferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2043",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Ot=new G({props:{$$slots:{default:[Iy]},$$scope:{ctx:_}}}),Lt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_generation.example",$$slots:{default:[Jy]},$$scope:{ctx:_}}}),Ha=new A({props:{name:"text_to_image",anchor:"huggingface_hub.InferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[float] = None"},{name:"width",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.text_to_image.TextToImageTargetSize] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.InferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.InferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.InferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.InferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2384",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),Pt=new G({props:{warning:!0,$$slots:{default:[wy]},$$scope:{ctx:_}}}),Kt=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example",$$slots:{default:[Uy]},$$scope:{ctx:_}}}),es=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-2",$$slots:{default:[xy]},$$scope:{ctx:_}}}),ns=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_image.example-3",$$slots:{default:[Cy]},$$scope:{ctx:_}}}),Da=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.InferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.InferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2595",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ts=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example",$$slots:{default:[$y]},$$scope:{ctx:_}}}),ss=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-2",$$slots:{default:[ky]},$$scope:{ctx:_}}}),as=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_speech.example-3",$$slots:{default:[vy]},$$scope:{ctx:_}}}),Oa=new A({props:{name:"text_to_video",anchor:"huggingface_hub.InferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.InferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.InferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.InferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),ls=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example",$$slots:{default:[qy]},$$scope:{ctx:_}}}),os=new U({props:{anchor:"huggingface_hub.InferenceClient.text_to_video.example-2",$$slots:{default:[Ay]},$$scope:{ctx:_}}}),La=new A({props:{name:"token_classification",anchor:"huggingface_hub.InferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.InferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.InferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2750",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),is=new U({props:{anchor:"huggingface_hub.InferenceClient.token_classification.example",$$slots:{default:[Zy]},$$scope:{ctx:_}}}),Pa=new A({props:{name:"translation",anchor:"huggingface_hub.InferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.InferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.InferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.InferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.InferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2824",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code> or <code>ValueError</code></p>
`}}),rs=new U({props:{anchor:"huggingface_hub.InferenceClient.translation.example",$$slots:{default:[Ey]},$$scope:{ctx:_}}}),cs=new U({props:{anchor:"huggingface_hub.InferenceClient.translation.example-2",$$slots:{default:[Wy]},$$scope:{ctx:_}}}),Ka=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.InferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2912",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>HTTPError</code></p>
`}}),ps=new U({props:{anchor:"huggingface_hub.InferenceClient.visual_question_answering.example",$$slots:{default:[Ny]},$$scope:{ctx:_}}}),el=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L2970",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),gs=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example",$$slots:{default:[Gy]},$$scope:{ctx:_}}}),us=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_classification.example-2",$$slots:{default:[By]},$$scope:{ctx:_}}}),nl=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py#L3093",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>HTTPError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>HTTPError</code></p>
`}}),ms=new U({props:{anchor:"huggingface_hub.InferenceClient.zero_shot_image_classification.example",$$slots:{default:[Qy]},$$scope:{ctx:_}}}),tl=new to({props:{title:"비동기 추론 클라이언트",local:"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient",headingTag:"h2"}}),al=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMCVFQiU5OCU5MCVFQiU4QSU5NCUwQSUyMyUyMHBpcCUyMGluc3RhbGwlMjBhaW9odHRw",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># 또는</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),ll=new A({props:{name:"class huggingface_hub.AsyncInferenceClient",anchor:"huggingface_hub.AsyncInferenceClient",parameters:[{name:"model",val:": typing.Optional[str] = None"},{name:"provider",val:": typing.Optional[typing.Literal['fal-ai', 'hf-inference', 'replicate', 'sambanova', 'together']] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"timeout",val:": typing.Optional[float] = None"},{name:"headers",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"cookies",val:": typing.Optional[typing.Dict[str, str]] = None"},{name:"trust_env",val:": bool = False"},{name:"proxies",val:": typing.Optional[typing.Any] = None"},{name:"base_url",val:": typing.Optional[str] = None"},{name:"api_key",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.model",description:`<strong>model</strong> (<code>str</code>, <code>optional</code>) &#x2014;
The model to run inference with. Can be a model id hosted on the Hugging Face Hub, e.g. <code>meta-llama/Meta-Llama-3-8B-Instruct</code>
or a URL to a deployed Inference Endpoint. Defaults to None, in which case a recommended model is
automatically selected for the task.
Note: for better compatibility with OpenAI&#x2019;s client, <code>model</code> has been aliased as <code>base_url</code>. Those 2
arguments are mutually exclusive. If using <code>base_url</code> for chat completion, the <code>/chat/completions</code> suffix
path will be appended to the base URL (see the <a href="https://huggingface.co/docs/text-generation-inference/en/messages_api" rel="nofollow">TGI Messages API</a>
documentation for details). When passing a URL as <code>model</code>, the client will not append any suffix path to it.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.provider",description:`<strong>provider</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of the provider to use for inference. Can be <code>&quot;replicate&quot;</code>, <code>&quot;together&quot;</code>, <code>&quot;fal-ai&quot;</code>, <code>&quot;sambanova&quot;</code> or <code>&quot;hf-inference&quot;</code>.
defaults to hf-inference (Hugging Face Serverless Inference API).
If model is a URL or <code>base_url</code> is passed, then <code>provider</code> is not used.`,name:"provider"},{anchor:"huggingface_hub.AsyncInferenceClient.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Hugging Face token. Will default to the locally saved token if not provided.
Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.
Note: for better compatibility with OpenAI&#x2019;s client, <code>token</code> has been aliased as <code>api_key</code>. Those 2
arguments are mutually exclusive and have the exact same behavior.`,name:"token"},{anchor:"huggingface_hub.AsyncInferenceClient.timeout",description:`<strong>timeout</strong> (<code>float</code>, <code>optional</code>) &#x2014;
The maximum number of seconds to wait for a response from the server. Loading a new model in Inference
API can take up to several minutes. Defaults to None, meaning it will loop until the server is available.`,name:"timeout"},{anchor:"huggingface_hub.AsyncInferenceClient.headers",description:`<strong>headers</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional headers to send to the server. By default only the authorization and user-agent headers are sent.
Values in this dictionary will override the default values.`,name:"headers"},{anchor:"huggingface_hub.AsyncInferenceClient.cookies",description:`<strong>cookies</strong> (<code>Dict[str, str]</code>, <code>optional</code>) &#x2014;
Additional cookies to send to the server.`,name:"cookies"},{anchor:"huggingface_hub.AsyncInferenceClient.trust_env",description:`<strong>trust_env</strong> (&#x2018;bool&#x2019;, &#x2018;optional&#x2019;) &#x2014;
Trust environment settings for proxy configuration if the parameter is <code>True</code> (<code>False</code> by default).`,name:"trust_env"},{anchor:"huggingface_hub.AsyncInferenceClient.proxies",description:`<strong>proxies</strong> (<code>Any</code>, <code>optional</code>) &#x2014;
Proxies to use for the request.`,name:"proxies"},{anchor:"huggingface_hub.AsyncInferenceClient.base_url",description:`<strong>base_url</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Base URL to run inference. This is a duplicated argument from <code>model</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>model</code> is set. Defaults to None.`,name:"base_url"},{anchor:"huggingface_hub.AsyncInferenceClient.api_key",description:`<strong>api_key</strong> (<code>str</code>, <code>optional</code>) &#x2014;
Token to use for authentication. This is a duplicated argument from <code>token</code> to make <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
follow the same pattern as <code>openai.OpenAI</code> client. Cannot be used if <code>token</code> is set. Defaults to None.`,name:"api_key"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L108"}}),ol=new A({props:{name:"audio_classification",anchor:"huggingface_hub.AsyncInferenceClient.audio_classification",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('AudioClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content to classify. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for audio classification. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;AudioClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L389",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioClassificationOutputElement"
>AudioClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),hs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_classification.example",$$slots:{default:[Vy]},$$scope:{ctx:_}}}),il=new A({props:{name:"audio_to_audio",anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The audio content for the model. It can be raw audio bytes, a local audio file, or a URL pointing to an
audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model can be any model which takes an audio file and returns another audio file. Can be a model ID hosted on the Hugging Face Hub
or a URL to a deployed Inference Endpoint. If not provided, the default recommended model for
audio_to_audio will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AudioToAudioOutputElement"
>AudioToAudioOutputElement</a> items containing audios label, content-type, and audio content in blob.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[AudioToAudioOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ds=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.audio_to_audio.example",$$slots:{default:[Sy]},$$scope:{ctx:_}}}),rl=new A({props:{name:"automatic_speech_recognition",anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition",parameters:[{name:"audio",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.audio",description:`<strong>audio</strong> (Union[str, Path, bytes, BinaryIO]) &#x2014;
The content to transcribe. It can be raw audio bytes, local audio file, or a URL to an audio file.`,name:"audio"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for ASR. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for ASR will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.parameters",description:`<strong>parameters</strong> (Dict[str, Any], <em>optional</em>) &#x2014;
Additional parameters to pass to the model.`,name:"parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L498",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An item containing the transcribed text and optionally the timestamp chunks.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.AutomaticSpeechRecognitionOutput"
>AutomaticSpeechRecognitionOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),fs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.automatic_speech_recognition.example",$$slots:{default:[Yy]},$$scope:{ctx:_}}}),cl=new A({props:{name:"chat_completion",anchor:"huggingface_hub.AsyncInferenceClient.chat_completion",parameters:[{name:"messages",val:": typing.List[typing.Dict]"},{name:"model",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"logit_bias",val:": typing.Optional[typing.List[float]] = None"},{name:"logprobs",val:": typing.Optional[bool] = None"},{name:"max_tokens",val:": typing.Optional[int] = None"},{name:"n",val:": typing.Optional[int] = None"},{name:"presence_penalty",val:": typing.Optional[float] = None"},{name:"response_format",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputGrammarType] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stream_options",val:": typing.Optional[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputStreamOptions] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"tool_choice",val:": typing.Union[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputToolChoiceClass, ForwardRef('ChatCompletionInputToolChoiceEnum'), NoneType] = None"},{name:"tool_prompt",val:": typing.Optional[str] = None"},{name:"tools",val:": typing.Optional[typing.List[huggingface_hub.inference._generated.types.chat_completion.ChatCompletionInputTool]] = None"},{name:"top_logprobs",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.messages",description:`<strong>messages</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputMessage">ChatCompletionInputMessage</a>) &#x2014;
Conversation history consisting of roles and content pairs.`,name:"messages"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for chat-completion. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for chat-based text-generation will be used.
See <a href="https://huggingface.co/tasks/text-generation" rel="nofollow">https://huggingface.co/tasks/text-generation</a> for more details.
If <code>model</code> is a model ID, it is passed to the server as the <code>model</code> parameter. If you want to define a
custom URL while setting <code>model</code> in the request payload, you must set <code>base_url</code> when initializing <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Penalizes new tokens based on their existing frequency
in the text so far. Range: [-2.0, 2.0]. Defaults to 0.0.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logit_bias",description:`<strong>logit_bias</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Adjusts the likelihood of specific tokens appearing in the generated output.`,name:"logit_bias"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.logprobs",description:`<strong>logprobs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return log probabilities of the output tokens or not. If true, returns the log
probabilities of each output token returned in the content of message.`,name:"logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.max_tokens",description:`<strong>max_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of tokens allowed in the response. Defaults to 100.`,name:"max_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.n",description:`<strong>n</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of completions to generate for each prompt.`,name:"n"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.presence_penalty",description:`<strong>presence_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the
text so far, increasing the model&#x2019;s likelihood to talk about new topics.`,name:"presence_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.response_format",description:`<strong>response_format</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputGrammarType">ChatCompletionInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"response_format"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.seed",description:`<strong>seed</strong> (Optional<code>int</code>, <em>optional</em>) &#x2014;
Seed for reproducible control flow. Defaults to None.`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Up to four strings which trigger the end of the response.
Defaults to None.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Enable realtime streaming of responses. Defaults to False.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.stream_options",description:`<strong>stream_options</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputStreamOptions">ChatCompletionInputStreamOptions</a>, <em>optional</em>) &#x2014;
Options for streaming completions.`,name:"stream_options"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Controls randomness of the generations. Lower values ensure
less random completions. Range: [0, 2]. Defaults to 1.0.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_logprobs",description:`<strong>top_logprobs</strong> (<code>int</code>, <em>optional</em>) &#x2014;
An integer between 0 and 5 specifying the number of most likely tokens to return at each token
position, each with an associated log probability. logprobs must be set to true if this parameter is
used.`,name:"top_logprobs"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Fraction of the most likely next words to sample from.
Must be between 0 and 1. Defaults to 1.0.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_choice",description:`<strong>tool_choice</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputToolChoiceClass">ChatCompletionInputToolChoiceClass</a> or <code>ChatCompletionInputToolChoiceEnum()</code>, <em>optional</em>) &#x2014;
The tool to use for the completion. Defaults to &#x201C;auto&#x201D;.`,name:"tool_choice"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tool_prompt",description:`<strong>tool_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
A prompt to be appended before the tools.`,name:"tool_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.tools",description:`<strong>tools</strong> (List of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionInputTool">ChatCompletionInputTool</a>, <em>optional</em>) &#x2014;
A list of tools the model may call. Currently, only functions are supported as a tool. Use this to
provide a list of functions the model may generate JSON inputs for.`,name:"tools"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L619",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code>, the generated text is returned as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> (default).</li>
<li>if <code>stream=True</code>, the generated text is returned token by token as a sequence of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionOutput"
>ChatCompletionOutput</a> or Iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ChatCompletionStreamOutput"
>ChatCompletionStreamOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ys=new G({props:{$$slots:{default:[Ry]},$$scope:{ctx:_}}}),Ms=new G({props:{$$slots:{default:[zy]},$$scope:{ctx:_}}}),bs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example",$$slots:{default:[Xy]},$$scope:{ctx:_}}}),js=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-2",$$slots:{default:[Fy]},$$scope:{ctx:_}}}),_s=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-3",$$slots:{default:[Hy]},$$scope:{ctx:_}}}),Ts=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-4",$$slots:{default:[Dy]},$$scope:{ctx:_}}}),Is=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-5",$$slots:{default:[Oy]},$$scope:{ctx:_}}}),Js=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-6",$$slots:{default:[Ly]},$$scope:{ctx:_}}}),ws=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-7",$$slots:{default:[Py]},$$scope:{ctx:_}}}),Us=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.chat_completion.example-8",$$slots:{default:[Ky]},$$scope:{ctx:_}}}),pl=new A({props:{name:"close",anchor:"huggingface_hub.AsyncInferenceClient.close",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L378"}}),gl=new A({props:{name:"document_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"lang",val:": typing.Optional[str] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"word_boxes",val:": typing.Optional[typing.List[typing.Union[typing.List[float], str]]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the document question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended document question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the words in the document are too long to fit with the question for the model, it will be split in
several chunks with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.lang",description:`<strong>lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Language to use while running OCR. Defaults to english.`,name:"lang"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using doc_stride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Can return less than top_k
answers if there are not enough options available within the context.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.word_boxes",description:`<strong>word_boxes</strong> (<code>List[Union[List[float], str</code>, <em>optional</em>) &#x2014;
A list of words and bounding boxes (normalized 0-&gt;1000). If provided, the inference will skip the OCR
step and use the provided bounding boxes instead.`,name:"word_boxes"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1020",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.DocumentQuestionAnsweringOutputElement"
>DocumentQuestionAnsweringOutputElement</a> items containing the predicted label, associated probability, word ids, and page number.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[DocumentQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),xs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.document_question_answering.example",$$slots:{default:[eM]},$$scope:{ctx:_}}}),ul=new A({props:{name:"feature_extraction",anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction",parameters:[{name:"text",val:": str"},{name:"normalize",val:": typing.Optional[bool] = None"},{name:"prompt_name",val:": typing.Optional[str] = None"},{name:"truncate",val:": typing.Optional[bool] = None"},{name:"truncation_direction",val:": typing.Optional[typing.Literal['Left', 'Right']] = None"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.text",description:`<strong>text</strong> (<em>str</em>) &#x2014;
The text to embed.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.model",description:`<strong>model</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.normalize",description:`<strong>normalize</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to normalize the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"normalize"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.prompt_name",description:`<strong>prompt_name</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The name of the prompt that should be used by for encoding. If not set, no prompt will be applied.
Must be a key in the <em>Sentence Transformers</em> configuration <em>prompts</em> dictionary.
For example if <code>prompt_name</code> is &#x201C;query&#x201D; and the <code>prompts</code> is {&#x201C;query&#x201D;: &#x201C;query: &#x201D;,&#x2026;},
then the sentence &#x201C;What is the capital of France?&#x201D; will be encoded as &#x201C;query: What is the capital of France?&#x201D;
because the prompt text will be prepended before any text to encode.`,name:"prompt_name"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncate",description:`<strong>truncate</strong> (<em>bool</em>, <em>optional</em>) &#x2014;
Whether to truncate the embeddings or not.
Only available on server powered by Text-Embedding-Inference.`,name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.truncation_direction",description:`<strong>truncation_direction</strong> (<em>Literal[&#x201C;Left&#x201D;, &#x201C;Right&#x201D;]</em>, <em>optional</em>) &#x2014;
Which side of the input should be truncated when <em>truncate=True</em> is passed.`,name:"truncation_direction"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1107",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text as a float32 numpy array.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><em>np.ndarray</em></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li>[<em>InferenceTimeoutError</em>] —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>[<em>InferenceTimeoutError</em>] or <code>aiohttp.ClientResponseError</code></p>
`}}),Cs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.feature_extraction.example",$$slots:{default:[nM]},$$scope:{ctx:_}}}),ml=new A({props:{name:"fill_mask",anchor:"huggingface_hub.AsyncInferenceClient.fill_mask",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"targets",val:": typing.Optional[typing.List[str]] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
a string to be filled from, must contain the [MASK] token (check model card for exact name of the mask).`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the fill mask task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended fill mask model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.targets",description:`<strong>targets</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
When passed, the model will limit the scores to the passed targets instead of looking up in the whole
vocabulary. If the provided targets are not in the model vocab, they will be tokenized and the first
resulting token will be used (with a warning, and that might be slower).`,name:"targets"},{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When passed, overrides the number of predictions to return.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1180",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.FillMaskOutputElement"
>FillMaskOutputElement</a> items containing the predicted label, associated
probability, token reference, and completed text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[FillMaskOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),$s=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.fill_mask.example",$$slots:{default:[tM]},$$scope:{ctx:_}}}),hl=new A({props:{name:"get_endpoint_info",anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3371",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Information about the endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),ks=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_endpoint_info.example",$$slots:{default:[sM]},$$scope:{ctx:_}}}),dl=new A({props:{name:"get_model_status",anchor:"huggingface_hub.AsyncInferenceClient.get_model_status",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Identifier of the model for witch the status gonna be checked. If model is not provided,
the model associated with this instance of <a href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will be used. Only InferenceAPI service can be checked so the
identifier cannot be a URL.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3470",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of ModelStatus dataclass, containing information,
about the state of the model: load, state, compute type and framework.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ModelStatus</code></p>
`}}),vs=new G({props:{$$slots:{default:[aM]},$$scope:{ctx:_}}}),qs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.get_model_status.example",$$slots:{default:[lM]},$$scope:{ctx:_}}}),fl=new A({props:{name:"health_check",anchor:"huggingface_hub.AsyncInferenceClient.health_check",parameters:[{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.health_check.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
URL of the Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3431",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if everything is working fine.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),As=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.health_check.example",$$slots:{default:[oM]},$$scope:{ctx:_}}}),yl=new A({props:{name:"image_classification",anchor:"huggingface_hub.AsyncInferenceClient.image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('ImageClassificationOutputTransform')] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to classify. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image classification. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image classification will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;ImageClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"},{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1236",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageClassificationOutputElement"
>ImageClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Zs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_classification.example",$$slots:{default:[iM]},$$scope:{ctx:_}}}),Ml=new A({props:{name:"image_segmentation",anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"mask_threshold",val:": typing.Optional[float] = None"},{name:"overlap_mask_area_threshold",val:": typing.Optional[float] = None"},{name:"subtask",val:": typing.Optional[ForwardRef('ImageSegmentationSubtask')] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to segment. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for image segmentation. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for image segmentation will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Mask overlap threshold to eliminate small, disconnected segments.`,name:"overlap_mask_area_threshold"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.subtask",description:`<strong>subtask</strong> (<code>&quot;ImageSegmentationSubtask&quot;</code>, <em>optional</em>) &#x2014;
Segmentation task to be performed, depending on model capabilities.`,name:"subtask"},{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Probability threshold to filter out predicted masks.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1286",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageSegmentationOutputElement"
>ImageSegmentationOutputElement</a> items containing the segmented masks and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ImageSegmentationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Es=new G({props:{warning:!0,$$slots:{default:[rM]},$$scope:{ctx:_}}}),Ws=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_segmentation.example",$$slots:{default:[cM]},$$scope:{ctx:_}}}),bl=new A({props:{name:"image_to_image",anchor:"huggingface_hub.AsyncInferenceClient.image_to_image",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.image_to_image.ImageToImageTargetSize] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for translation. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The text prompt to guide the image generation.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
For diffusion models. The number of denoising steps. More denoising steps usually lead to a higher
quality image at the expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
For diffusion models. A higher guidance scale value encourages the model to generate images closely
linked to the text prompt at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.target_size",description:`<strong>target_size</strong> (<code>ImageToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image.`,name:"target_size"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1356",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The translated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ns=new G({props:{warning:!0,$$slots:{default:[pM]},$$scope:{ctx:_}}}),Gs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_image.example",$$slots:{default:[gM]},$$scope:{ctx:_}}}),jl=new A({props:{name:"image_to_text",anchor:"huggingface_hub.AsyncInferenceClient.image_to_text",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image..`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1432",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ImageToTextOutput"
>ImageToTextOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Bs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.image_to_text.example",$$slots:{default:[uM]},$$scope:{ctx:_}}}),_l=new A({props:{name:"list_deployed_models",anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models",parameters:[{name:"frameworks",val:": typing.Union[NoneType, str, typing.Literal['all'], typing.List[str]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.frameworks",description:`<strong>frameworks</strong> (<code>Literal[&quot;all&quot;]</code> or <code>List[str]</code> or <code>str</code>, <em>optional</em>) &#x2014;
The frameworks to filter on. By default only a subset of the available frameworks are tested. If set to
&#x201C;all&#x201D;, all available frameworks will be tested. It is also possible to provide a single framework or a
custom set of frameworks to check.`,name:"frameworks"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3241",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary mapping task names to a sorted list of model IDs.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, List[str]]</code></p>
`}}),Qs=new G({props:{warning:!0,$$slots:{default:[mM]},$$scope:{ctx:_}}}),Vs=new G({props:{$$slots:{default:[hM]},$$scope:{ctx:_}}}),Ss=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.list_deployed_models.example",$$slots:{default:[dM]},$$scope:{ctx:_}}}),Tl=new A({props:{name:"object_detection",anchor:"huggingface_hub.AsyncInferenceClient.object_detection",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"model",val:": typing.Optional[str] = None"},{name:"threshold",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The image to detect objects on. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for object detection. Can be a model ID hosted on the Hugging Face Hub or a URL to a
deployed Inference Endpoint. If not provided, the default recommended model for object detection (DETR) will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The probability necessary to make a prediction.`,name:"threshold"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1478",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ObjectDetectionOutputElement"
>ObjectDetectionOutputElement</a> items containing the bounding boxes and associated attributes.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ObjectDetectionOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If the request output is not a List.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),Ys=new G({props:{warning:!0,$$slots:{default:[fM]},$$scope:{ctx:_}}}),Rs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.object_detection.example",$$slots:{default:[yM]},$$scope:{ctx:_}}}),Il=new A({props:{name:"post",anchor:"huggingface_hub.AsyncInferenceClient.post",parameters:[{name:"json",val:": typing.Union[str, typing.Dict, typing.List, NoneType] = None"},{name:"data",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path, NoneType] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"task",val:": typing.Optional[str] = None"},{name:"stream",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L236"}}),Jl=new A({props:{name:"question_answering",anchor:"huggingface_hub.AsyncInferenceClient.question_answering",parameters:[{name:"question",val:": str"},{name:"context",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"align_to_words",val:": typing.Optional[bool] = None"},{name:"doc_stride",val:": typing.Optional[int] = None"},{name:"handle_impossible_answer",val:": typing.Optional[bool] = None"},{name:"max_answer_len",val:": typing.Optional[int] = None"},{name:"max_question_len",val:": typing.Optional[int] = None"},{name:"max_seq_len",val:": typing.Optional[int] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.context",description:`<strong>context</strong> (<code>str</code>) &#x2014;
The context of the question.`,name:"context"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.align_to_words",description:`<strong>align_to_words</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Attempts to align the answer to real words. Improves quality on space separated languages. Might hurt
on non-space-separated languages (like Japanese or Chinese)`,name:"align_to_words"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.doc_stride",description:`<strong>doc_stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If the context is too long to fit with the question for the model, it will be split in several chunks
with some overlap. This argument controls the size of that overlap.`,name:"doc_stride"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.handle_impossible_answer",description:`<strong>handle_impossible_answer</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to accept impossible as an answer.`,name:"handle_impossible_answer"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_answer_len",description:`<strong>max_answer_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of predicted answers (e.g., only answers with a shorter length are considered).`,name:"max_answer_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_question_len",description:`<strong>max_question_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the question after tokenization. It will be truncated if needed.`,name:"max_question_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the total sentence (context + question) in tokens of each chunk passed to the
model. The context will be split in several chunks (using docStride as overlap) if needed.`,name:"max_seq_len"},{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1529",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>When top_k is 1 or not provided, it returns a single <code>QuestionAnsweringOutputElement</code>.
When top_k is greater than 1, it returns a list of <code>QuestionAnsweringOutputElement</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Union[<code>QuestionAnsweringOutputElement</code>, List<a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.QuestionAnsweringOutputElement"
>QuestionAnsweringOutputElement</a>]</p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),zs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.question_answering.example",$$slots:{default:[MM]},$$scope:{ctx:_}}}),wl=new A({props:{name:"sentence_similarity",anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity",parameters:[{name:"sentence",val:": str"},{name:"other_sentences",val:": typing.List[str]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.sentence",description:`<strong>sentence</strong> (<code>str</code>) &#x2014;
The main sentence to compare to others.`,name:"sentence"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.other_sentences",description:`<strong>other_sentences</strong> (<code>List[str]</code>) &#x2014;
The list of sentences to compare to.`,name:"other_sentences"},{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the conversational task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended conversational model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1614",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The embedding representing the input text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[float]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Xs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.sentence_similarity.example",$$slots:{default:[bM]},$$scope:{ctx:_}}}),Ul=new A({props:{name:"summarization",anchor:"huggingface_hub.AsyncInferenceClient.summarization",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('SummarizationTruncationStrategy')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.summarization.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to summarize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended model for summarization will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"},{anchor:"huggingface_hub.AsyncInferenceClient.summarization.truncation",description:`<strong>truncation</strong> (<code>&quot;SummarizationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1667",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated summary text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.SummarizationOutput"
>SummarizationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Fs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.summarization.example",$$slots:{default:[jM]},$$scope:{ctx:_}}}),xl=new A({props:{name:"table_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"query",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"padding",val:": typing.Optional[ForwardRef('Padding')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.table",description:`<strong>table</strong> (<code>str</code>) &#x2014;
A table of data represented as a dict of lists where entries are headers and the lists are all the
values, all lists must have the same size.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.query",description:`<strong>query</strong> (<code>str</code>) &#x2014;
The query in plain text that you want to ask the table.`,name:"query"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.model",description:`<strong>model</strong> (<code>str</code>) &#x2014;
The model to use for the table-question-answering task. Can be a model ID hosted on the Hugging Face
Hub or a URL to a deployed Inference Endpoint.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.padding",description:`<strong>padding</strong> (<code>&quot;Padding&quot;</code>, <em>optional</em>) &#x2014;
Activates and controls padding.`,name:"padding"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to do inference sequentially or as a batch. Batching is faster, but models like SQA require the
inference to be done sequentially to extract relations within sequences, given their conversational
nature.`,name:"sequential"},{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activates and controls truncation.`,name:"truncation"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1725",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a table question answering output containing the answer, coordinates, cells and the aggregator used.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TableQuestionAnsweringOutputElement"
>TableQuestionAnsweringOutputElement</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Hs=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.table_question_answering.example",$$slots:{default:[_M]},$$scope:{ctx:_}}}),Cl=new A({props:{name:"tabular_classification",anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes to classify.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular classification model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of labels, one per row in the initial table.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ds=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_classification.example",$$slots:{default:[TM]},$$scope:{ctx:_}}}),$l=new A({props:{name:"tabular_regression",anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression",parameters:[{name:"table",val:": typing.Dict[str, typing.Any]"},{name:"model",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.table",description:`<strong>table</strong> (<code>Dict[str, Any]</code>) &#x2014;
Set of attributes stored in a table. The attributes used to predict the target can be both numerical and categorical.`,name:"table"},{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the tabular regression task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended tabular regression model will be used.
Defaults to None.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of predicted numerical target values.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Os=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.tabular_regression.example",$$slots:{default:[IM]},$$scope:{ctx:_}}}),kl=new A({props:{name:"text_classification",anchor:"huggingface_hub.AsyncInferenceClient.text_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"function_to_apply",val:": typing.Optional[ForwardRef('TextClassificationOutputTransform')] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the text classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended text classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
When specified, limits the output to the top K most probable classes.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.function_to_apply",description:`<strong>function_to_apply</strong> (<code>&quot;TextClassificationOutputTransform&quot;</code>, <em>optional</em>) &#x2014;
The function to apply to the model outputs in order to retrieve the scores.`,name:"function_to_apply"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L1893",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextClassificationOutputElement"
>TextClassificationOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TextClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ls=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_classification.example",$$slots:{default:[JM]},$$scope:{ctx:_}}}),vl=new A({props:{name:"text_generation",anchor:"huggingface_hub.AsyncInferenceClient.text_generation",parameters:[{name:"prompt",val:": str"},{name:"details",val:": bool = False"},{name:"stream",val:": bool = False"},{name:"model",val:": typing.Optional[str] = None"},{name:"adapter_id",val:": typing.Optional[str] = None"},{name:"best_of",val:": typing.Optional[int] = None"},{name:"decoder_input_details",val:": typing.Optional[bool] = None"},{name:"do_sample",val:": typing.Optional[bool] = False"},{name:"frequency_penalty",val:": typing.Optional[float] = None"},{name:"grammar",val:": typing.Optional[huggingface_hub.inference._generated.types.text_generation.TextGenerationInputGrammarType] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"repetition_penalty",val:": typing.Optional[float] = None"},{name:"return_full_text",val:": typing.Optional[bool] = False"},{name:"seed",val:": typing.Optional[int] = None"},{name:"stop",val:": typing.Optional[typing.List[str]] = None"},{name:"stop_sequences",val:": typing.Optional[typing.List[str]] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_n_tokens",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"truncate",val:": typing.Optional[int] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"watermark",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
Input text.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.details",description:`<strong>details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns a string. Pass <code>details=True</code> if you want a detailed output (tokens,
probabilities, seed, finish reason, etc.). Only available for models running on with the
<code>text-generation-inference</code> backend.`,name:"details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stream",description:`<strong>stream</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
By default, text_generation returns the full generated text. Pass <code>stream=True</code> if you want a stream of
tokens to be returned. Only available for models running on with the <code>text-generation-inference</code>
backend.`,name:"stream"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.adapter_id",description:`<strong>adapter_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Lora adapter id.`,name:"adapter_id"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.best_of",description:`<strong>best_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Generate best_of sequences and return the one if the highest token logprobs.`,name:"best_of"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.decoder_input_details",description:`<strong>decoder_input_details</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Return the decoder input token logprobs and ids. You must set <code>details=True</code> as well for it to be taken
into account. Defaults to <code>False</code>.`,name:"decoder_input_details"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Activate logits sampling`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.frequency_penalty",description:`<strong>frequency_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in
the text so far, decreasing the model&#x2019;s likelihood to repeat the same line verbatim.`,name:"frequency_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.grammar",description:`<strong>grammar</strong> (<a href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationInputGrammarType">TextGenerationInputGrammarType</a>, <em>optional</em>) &#x2014;
Grammar constraints. Can be either a JSONSchema or a regex.`,name:"grammar"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of generated tokens. Defaults to 100.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.return_full_text",description:`<strong>return_full_text</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to prepend the prompt to the generated text`,name:"return_full_text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Random sampling seed`,name:"seed"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop",description:`<strong>stop</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Stop generating tokens if a member of <code>stop</code> is generated.`,name:"stop"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.stop_sequences",description:`<strong>stop_sequences</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
Deprecated argument. Use <code>stop</code> instead.`,name:"stop_sequences"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_n_tokens",description:`<strong>top_n_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Return information about the <code>top_n_tokens</code> most likely tokens at each generation step, instead of
just the sampled token.`,name:"top_n_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_k",description:"<strong>top_k</strong> (<code>int</code>, *optional`) &#x2014;\nThe number of highest probability vocabulary tokens to keep for top-k-filtering.",name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.top_p",description:"<strong>top_p</strong> (<code>float</code>, *optional<code>) -- If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to </code>top_p` or\nhigher are kept for generation.",name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.truncate",description:"<strong>truncate</strong> (<code>int</code>, *optional`) &#x2014;\nTruncate inputs tokens to the given size.",name:"truncate"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, *optional\`) &#x2014;
Typical Decoding mass
See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.watermark",description:'<strong>watermark</strong> (<code>bool</code>, *optional`) &#x2014;\nWatermarking with <a href="https://arxiv.org/abs/2301.10226" rel="nofollow">A Watermark for Large Language Models</a>',name:"watermark"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2101",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Generated text returned from the server:</p>
<ul>
<li>if <code>stream=False</code> and <code>details=False</code>, the generated text is returned as a <code>str</code> (default)</li>
<li>if <code>stream=True</code> and <code>details=False</code>, the generated text is returned token by token as a <code>Iterable[str]</code></li>
<li>if <code>stream=False</code> and <code>details=True</code>, the generated text is returned with more details as a <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationOutput"
>TextGenerationOutput</a></li>
<li>if <code>details=True</code> and <code>stream=True</code>, the generated text is returned token by token as a iterable of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TextGenerationStreamOutput"
>TextGenerationStreamOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[str, TextGenerationOutput, Iterable[str], Iterable[TextGenerationStreamOutput]]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValidationError</code> —
If input values are not valid. No HTTP call is made to the server.</li>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValidationError</code> or <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),Ps=new G({props:{$$slots:{default:[wM]},$$scope:{ctx:_}}}),Ks=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_generation.example",$$slots:{default:[UM]},$$scope:{ctx:_}}}),ql=new A({props:{name:"text_to_image",anchor:"huggingface_hub.AsyncInferenceClient.text_to_image",parameters:[{name:"prompt",val:": str"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"height",val:": typing.Optional[float] = None"},{name:"width",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"scheduler",val:": typing.Optional[str] = None"},{name:"target_size",val:": typing.Optional[huggingface_hub.inference._generated.types.text_to_image.TextToImageTargetSize] = None"},{name:"seed",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate an image from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
One prompt to guide what NOT to include in image generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.height",description:`<strong>height</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The height in pixels of the image to generate.`,name:"height"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.width",description:`<strong>width</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The width in pixels of the image to generate.`,name:"width"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-image model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.scheduler",description:`<strong>scheduler</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Override the scheduler with a compatible one.`,name:"scheduler"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.target_size",description:`<strong>target_size</strong> (<code>TextToImageTargetSize</code>, <em>optional</em>) &#x2014;
The size in pixel of the output image`,name:"target_size"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2443",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Image</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ea=new G({props:{warning:!0,$$slots:{default:[xM]},$$scope:{ctx:_}}}),na=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example",$$slots:{default:[CM]},$$scope:{ctx:_}}}),ta=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-2",$$slots:{default:[$M]},$$scope:{ctx:_}}}),sa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_image.example-3",$$slots:{default:[kM]},$$scope:{ctx:_}}}),Al=new A({props:{name:"text_to_speech",anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"do_sample",val:": typing.Optional[bool] = None"},{name:"early_stopping",val:": typing.Union[bool, ForwardRef('TextToSpeechEarlyStoppingEnum'), NoneType] = None"},{name:"epsilon_cutoff",val:": typing.Optional[float] = None"},{name:"eta_cutoff",val:": typing.Optional[float] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_new_tokens",val:": typing.Optional[int] = None"},{name:"min_length",val:": typing.Optional[int] = None"},{name:"min_new_tokens",val:": typing.Optional[int] = None"},{name:"num_beam_groups",val:": typing.Optional[int] = None"},{name:"num_beams",val:": typing.Optional[int] = None"},{name:"penalty_alpha",val:": typing.Optional[float] = None"},{name:"temperature",val:": typing.Optional[float] = None"},{name:"top_k",val:": typing.Optional[int] = None"},{name:"top_p",val:": typing.Optional[float] = None"},{name:"typical_p",val:": typing.Optional[float] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The text to synthesize.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-speech model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use sampling instead of greedy decoding when generating new tokens.`,name:"do_sample"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.early_stopping",description:`<strong>early_stopping</strong> (<code>Union[bool, &quot;TextToSpeechEarlyStoppingEnum&quot;]</code>, <em>optional</em>) &#x2014;
Controls the stopping condition for beam-based methods.`,name:"early_stopping"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
epsilon_cutoff will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on
the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly
between 0 and 1, a token is only considered if it is greater than either eta_cutoff or sqrt(eta_cutoff)<ul>
<li>exp(-entropy(softmax(next_token_logits))). The latter term is intuitively the expected next token
probability, scaled by sqrt(eta_cutoff). In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://hf.co/papers/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.</li>
</ul>`,name:"eta_cutoff"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length (in tokens) of the generated text, including the input.`,name:"max_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of tokens to generate. Takes precedence over max_length.`,name:"max_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum length (in tokens) of the generated text, including the input.`,name:"min_length"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of tokens to generate. Takes precedence over min_length.`,name:"min_new_tokens"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of groups to divide num_beams into in order to ensure diversity among different groups of beams.
See <a href="https://hf.co/papers/1610.02424" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of beams to use for beam search.`,name:"num_beams"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value balances the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
top_p or higher are kept for generation.`,name:"top_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is
to the expected conditional probability of predicting a random token next, given the partial text
already generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with
probabilities that add up to typical_p or higher are kept for generation. See <a href="https://hf.co/papers/2202.00666" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether the model should use the past last key/values attentions to speed up decoding`,name:"use_cache"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2655",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),aa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example",$$slots:{default:[vM]},$$scope:{ctx:_}}}),la=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-2",$$slots:{default:[qM]},$$scope:{ctx:_}}}),oa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_speech.example-3",$$slots:{default:[AM]},$$scope:{ctx:_}}}),Zl=new A({props:{name:"text_to_video",anchor:"huggingface_hub.AsyncInferenceClient.text_to_video",parameters:[{name:"prompt",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"guidance_scale",val:": typing.Optional[float] = None"},{name:"negative_prompt",val:": typing.Optional[typing.List[str]] = None"},{name:"num_frames",val:": typing.Optional[float] = None"},{name:"num_inference_steps",val:": typing.Optional[int] = None"},{name:"seed",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.prompt",description:`<strong>prompt</strong> (<code>str</code>) &#x2014;
The prompt to generate a video from.`,name:"prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. If not provided, the default recommended text-to-video model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A higher guidance scale value encourages the model to generate videos closely linked to the text
prompt, but values too high may cause saturation and other artifacts.`,name:"guidance_scale"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.negative_prompt",description:`<strong>negative_prompt</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
One or several prompt to guide what NOT to include in video generation.`,name:"negative_prompt"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_frames",description:`<strong>num_frames</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The num_frames parameter determines how many video frames are generated.`,name:"num_frames"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality video at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.seed",description:`<strong>seed</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Seed for the random number generator.`,name:"seed"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2568",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated video.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bytes</code></p>
`}}),ia=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example",$$slots:{default:[ZM]},$$scope:{ctx:_}}}),ra=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.text_to_video.example-2",$$slots:{default:[EM]},$$scope:{ctx:_}}}),El=new A({props:{name:"token_classification",anchor:"huggingface_hub.AsyncInferenceClient.token_classification",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"aggregation_strategy",val:": typing.Optional[ForwardRef('TokenClassificationAggregationStrategy')] = None"},{name:"ignore_labels",val:": typing.Optional[typing.List[str]] = None"},{name:"stride",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be classified.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the token classification task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended token classification model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.aggregation_strategy",description:`<strong>aggregation_strategy</strong> (<code>&quot;TokenClassificationAggregationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The strategy used to fuse tokens based on model predictions`,name:"aggregation_strategy"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.ignore_labels",description:`<strong>ignore_labels</strong> (<code>List[str</code>, <em>optional</em>) &#x2014;
A list of labels to ignore`,name:"ignore_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of overlapping tokens between chunks when splitting the input text.`,name:"stride"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2811",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TokenClassificationOutputElement"
>TokenClassificationOutputElement</a> items containing the entity group, confidence score, word, start and end index.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[TokenClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ca=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.token_classification.example",$$slots:{default:[WM]},$$scope:{ctx:_}}}),Wl=new A({props:{name:"translation",anchor:"huggingface_hub.AsyncInferenceClient.translation",parameters:[{name:"text",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"src_lang",val:": typing.Optional[str] = None"},{name:"tgt_lang",val:": typing.Optional[str] = None"},{name:"clean_up_tokenization_spaces",val:": typing.Optional[bool] = None"},{name:"truncation",val:": typing.Optional[ForwardRef('TranslationTruncationStrategy')] = None"},{name:"generate_parameters",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.translation.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
A string to be translated.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the translation task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended translation model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.src_lang",description:`<strong>src_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The source language of the text. Required for models that can translate from multiple languages.`,name:"src_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.tgt_lang",description:`<strong>tgt_lang</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Target language to translate to. Required for models that can translate to multiple languages.`,name:"tgt_lang"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to clean up the potential extra spaces in the text output.`,name:"clean_up_tokenization_spaces"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.truncation",description:`<strong>truncation</strong> (<code>&quot;TranslationTruncationStrategy&quot;</code>, <em>optional</em>) &#x2014;
The truncation strategy to use.`,name:"truncation"},{anchor:"huggingface_hub.AsyncInferenceClient.translation.generate_parameters",description:`<strong>generate_parameters</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parametrization of the text generation algorithm.`,name:"generate_parameters"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2886",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated translated text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.TranslationOutput"
>TranslationOutput</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
<li><code>ValueError</code> —
If only one of the <code>src_lang</code> and <code>tgt_lang</code> arguments are provided.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code> or <code>ValueError</code></p>
`}}),pa=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example",$$slots:{default:[NM]},$$scope:{ctx:_}}}),ga=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.translation.example-2",$$slots:{default:[GM]},$$scope:{ctx:_}}}),Nl=new A({props:{name:"visual_question_answering",anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"question",val:": str"},{name:"model",val:": typing.Optional[str] = None"},{name:"top_k",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image for the context. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.question",description:`<strong>question</strong> (<code>str</code>) &#x2014;
Question to be answered.`,name:"question"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for the visual question answering task. Can be a model ID hosted on the Hugging Face Hub or a URL to
a deployed Inference Endpoint. If not provided, the default recommended visual question answering model will be used.
Defaults to None.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of answers to return (will be chosen by order of likelihood). Note that we return less than
topk answers if there are not enough options available within the context.`,name:"top_k"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L2975",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a list of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.VisualQuestionAnsweringOutputElement"
>VisualQuestionAnsweringOutputElement</a> items containing the predicted label and associated probability.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[VisualQuestionAnsweringOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>InferenceTimeoutError</code> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>InferenceTimeoutError</code> or <code>aiohttp.ClientResponseError</code></p>
`}}),ua=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.visual_question_answering.example",$$slots:{default:[BM]},$$scope:{ctx:_}}}),Gl=new A({props:{name:"zero_shot_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification",parameters:[{name:"text",val:": str"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"multi_label",val:": typing.Optional[bool] = False"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.text",description:`<strong>text</strong> (<code>str</code>) &#x2014;
The input text to classify.`,name:"text"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The set of possible class labels to classify the text into.`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of strings. Each string is the verbalization of a possible label for the input text.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.multi_label",description:`<strong>multi_label</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether multiple candidate labels can be true. If false, the scores are normalized such that the sum of
the label likelihoods for each sequence is 1. If true, the labels are considered independent and
probabilities are normalized for each candidate.`,name:"multi_label"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the text classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot classification model will be used.`,name:"model"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3034",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotClassificationOutputElement"
>ZeroShotClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),ma=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example",$$slots:{default:[QM]},$$scope:{ctx:_}}}),ha=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_classification.example-2",$$slots:{default:[VM]},$$scope:{ctx:_}}}),Bl=new A({props:{name:"zero_shot_image_classification",anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification",parameters:[{name:"image",val:": typing.Union[bytes, typing.BinaryIO, str, pathlib.Path]"},{name:"candidate_labels",val:": typing.List[str] = None"},{name:"model",val:": typing.Optional[str] = None"},{name:"hypothesis_template",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.List[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.image",description:`<strong>image</strong> (<code>Union[str, Path, bytes, BinaryIO]</code>) &#x2014;
The input image to caption. It can be raw bytes, an image file, or a URL to an online image.`,name:"image"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.candidate_labels",description:`<strong>candidate_labels</strong> (<code>List[str]</code>) &#x2014;
The candidate labels for this image`,name:"candidate_labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.labels",description:`<strong>labels</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
(deprecated) List of string possible labels. There must be at least 2 labels.`,name:"labels"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The model to use for inference. Can be a model ID hosted on the Hugging Face Hub or a URL to a deployed
Inference Endpoint. This parameter overrides the model defined at the instance level. If not provided, the default recommended zero-shot image classification model will be used.`,name:"model"},{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.hypothesis_template",description:`<strong>hypothesis_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The sentence used in conjunction with <code>candidate_labels</code> to attempt the image classification by
replacing the placeholder with the candidate labels.`,name:"hypothesis_template"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_generated/_async_client.py#L3159",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_types#huggingface_hub.ZeroShotImageClassificationOutputElement"
>ZeroShotImageClassificationOutputElement</a> items containing the predicted labels and their confidence.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[ZeroShotImageClassificationOutputElement]</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> —
If the model is unavailable or the request times out.</li>
<li><code>aiohttp.ClientResponseError</code> —
If the request fails with an HTTP error status code other than HTTP 503.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/main/ko/package_reference/inference_client#huggingface_hub.InferenceTimeoutError"
>InferenceTimeoutError</a> or <code>aiohttp.ClientResponseError</code></p>
`}}),da=new U({props:{anchor:"huggingface_hub.AsyncInferenceClient.zero_shot_image_classification.example",$$slots:{default:[SM]},$$scope:{ctx:_}}}),Ql=new to({props:{title:"추론 시간 초과 오류",local:"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError",headingTag:"h2"}}),Vl=new A({props:{name:"class huggingface_hub.InferenceTimeoutError",anchor:"huggingface_hub.InferenceTimeoutError",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/errors.py#L92"}}),Sl=new to({props:{title:"반환 유형",local:"return-types",headingTag:"h2"}}),Rl=new to({props:{title:"모델 상태",local:"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus",headingTag:"h3"}}),zl=new A({props:{name:"class huggingface_hub.inference._common.ModelStatus",anchor:"huggingface_hub.inference._common.ModelStatus",parameters:[{name:"loaded",val:": bool"},{name:"state",val:": str"},{name:"compute_type",val:": typing.Dict"},{name:"framework",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.inference._common.ModelStatus.loaded",description:`<strong>loaded</strong> (<code>bool</code>) &#x2014;
If the model is currently loaded into Hugging Face&#x2019;s InferenceAPI. Models
are loaded on-demand, leading to the user&#x2019;s first request taking longer.
If a model is loaded, you can be assured that it is in a healthy state.`,name:"loaded"},{anchor:"huggingface_hub.inference._common.ModelStatus.state",description:`<strong>state</strong> (<code>str</code>) &#x2014;
The current state of the model. This can be &#x2018;Loaded&#x2019;, &#x2018;Loadable&#x2019;, &#x2018;TooBig&#x2019;.
If a model&#x2019;s state is &#x2018;Loadable&#x2019;, it&#x2019;s not too big and has a supported
backend. Loadable models are automatically loaded when the user first
requests inference on the endpoint. This means it is transparent for the
user to load a model, except that the first call takes longer to complete.`,name:"state"},{anchor:"huggingface_hub.inference._common.ModelStatus.compute_type",description:`<strong>compute_type</strong> (<code>Dict</code>) &#x2014;
Information about the compute resource the model is using or will use, such as &#x2018;gpu&#x2019; type and number of
replicas.`,name:"compute_type"},{anchor:"huggingface_hub.inference._common.ModelStatus.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The name of the framework that the model was built with, such as &#x2018;transformers&#x2019;
or &#x2018;text-generation-inference&#x2019;.`,name:"framework"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_common.py#L107"}}),Xl=new to({props:{title:"추론 API",local:"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi",headingTag:"h2"}}),Hl=new A({props:{name:"class huggingface_hub.InferenceApi",anchor:"huggingface_hub.InferenceApi",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L46"}}),fa=new U({props:{anchor:"huggingface_hub.InferenceApi.example",$$slots:{default:[YM]},$$scope:{ctx:_}}}),Dl=new A({props:{name:"__init__",anchor:"huggingface_hub.InferenceApi.__init__",parameters:[{name:"repo_id",val:": str"},{name:"task",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"gpu",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__init__.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
Id of repository (e.g. <em>user/bert-base-uncased</em>).`,name:"repo_id"},{anchor:"huggingface_hub.InferenceApi.__init__.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>, defaults <code>None</code>) &#x2014;
Whether to force a task instead of using task specified in the
repository.`,name:"task"},{anchor:"huggingface_hub.InferenceApi.__init__.token",description:`<strong>token</strong> (<em>str</em>, <em>optional</em>) &#x2014;
The API token to use as HTTP bearer authorization. This is not
the authentication token. You can find the token in
<a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>. Alternatively, you can
find both your organizations and personal API tokens using
<em>HfApi().whoami(token)</em>.`,name:"token"},{anchor:"huggingface_hub.InferenceApi.__init__.gpu",description:`<strong>gpu</strong> (<em>bool</em>, <em>optional</em>, defaults <em>False</em>) &#x2014;
Whether to use GPU instead of CPU for inference(requires Startup
plan at least).`,name:"gpu"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L93"}}),Ol=new A({props:{name:"__call__",anchor:"huggingface_hub.InferenceApi.__call__",parameters:[{name:"inputs",val:": typing.Union[str, typing.Dict, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"params",val:": typing.Optional[typing.Dict] = None"},{name:"data",val:": typing.Optional[bytes] = None"},{name:"raw_response",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.InferenceApi.__call__.inputs",description:`<strong>inputs</strong> (<code>str</code> or <code>Dict</code> or <code>List[str]</code> or <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
Inputs for the prediction.`,name:"inputs"},{anchor:"huggingface_hub.InferenceApi.__call__.params",description:`<strong>params</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Additional parameters for the models. Will be sent as <code>parameters</code> in the
payload.`,name:"params"},{anchor:"huggingface_hub.InferenceApi.__call__.data",description:`<strong>data</strong> (<code>bytes</code>, <em>optional</em>) &#x2014;
Bytes content of the request. In this case, leave <code>inputs</code> and <code>params</code> empty.`,name:"data"},{anchor:"huggingface_hub.InferenceApi.__call__.raw_response",description:`<strong>raw_response</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, the raw <code>Response</code> object is returned. You can parse its content
as preferred. By default, the content is parsed into a more practical format
(json dictionary or PIL Image for example).`,name:"raw_response"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference_api.py#L158"}}),Ll=new Gf({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/ko/package_reference/inference_client.md"}}),{c(){n=M("meta"),c=i(),s=M("p"),t=i(),g(o.$$.fragment),e=i(),p=M("p"),p.innerHTML=Ym,sr=i(),ba=M("ul"),ba.innerHTML=Rm,ar=i(),ja=M("p"),ja.innerHTML=zm,lr=i(),g(_a.$$.fragment),or=i(),C=M("div"),g(Ta.$$.fragment),wr=i(),so=M("p"),so.textContent=Xm,Ur=i(),ao=M("p"),ao.innerHTML=Fm,xr=i(),ze=M("div"),g(Ia.$$.fragment),Cr=i(),lo=M("p"),lo.textContent=Hm,$r=i(),g(ut.$$.fragment),kr=i(),Xe=M("div"),g(Ja.$$.fragment),vr=i(),oo=M("p"),oo.textContent=Dm,qr=i(),g(mt.$$.fragment),Ar=i(),Fe=M("div"),g(wa.$$.fragment),Zr=i(),io=M("p"),io.textContent=Om,Er=i(),g(ht.$$.fragment),Wr=i(),Z=M("div"),g(Ua.$$.fragment),Nr=i(),ro=M("p"),ro.textContent=Lm,Gr=i(),g(dt.$$.fragment),Br=i(),g(ft.$$.fragment),Qr=i(),g(yt.$$.fragment),Vr=i(),g(Mt.$$.fragment),Sr=i(),g(bt.$$.fragment),Yr=i(),co=M("p"),co.textContent=Pm,Rr=i(),g(jt.$$.fragment),zr=i(),po=M("p"),po.textContent=Km,Xr=i(),g(_t.$$.fragment),Fr=i(),g(Tt.$$.fragment),Hr=i(),g(It.$$.fragment),Dr=i(),g(Jt.$$.fragment),Or=i(),He=M("div"),g(xa.$$.fragment),Lr=i(),go=M("p"),go.textContent=eh,Pr=i(),g(wt.$$.fragment),Kr=i(),De=M("div"),g(Ca.$$.fragment),ec=i(),uo=M("p"),uo.textContent=nh,nc=i(),g(Ut.$$.fragment),tc=i(),Oe=M("div"),g($a.$$.fragment),sc=i(),mo=M("p"),mo.textContent=th,ac=i(),g(xt.$$.fragment),lc=i(),ie=M("div"),g(ka.$$.fragment),oc=i(),ho=M("p"),ho.textContent=sh,ic=i(),fo=M("p"),fo.innerHTML=ah,rc=i(),g(Ct.$$.fragment),cc=i(),re=M("div"),g(va.$$.fragment),pc=i(),yo=M("p"),yo.textContent=lh,gc=i(),g($t.$$.fragment),uc=i(),g(kt.$$.fragment),mc=i(),ce=M("div"),g(qa.$$.fragment),hc=i(),Mo=M("p"),Mo.textContent=oh,dc=i(),bo=M("p"),bo.innerHTML=ih,fc=i(),g(vt.$$.fragment),yc=i(),Le=M("div"),g(Aa.$$.fragment),Mc=i(),jo=M("p"),jo.textContent=rh,bc=i(),g(qt.$$.fragment),jc=i(),pe=M("div"),g(Za.$$.fragment),_c=i(),_o=M("p"),_o.textContent=ch,Tc=i(),g(At.$$.fragment),Ic=i(),g(Zt.$$.fragment),Jc=i(),ge=M("div"),g(Ea.$$.fragment),wc=i(),To=M("p"),To.textContent=ph,Uc=i(),g(Et.$$.fragment),xc=i(),g(Wt.$$.fragment),Cc=i(),ue=M("div"),g(Wa.$$.fragment),$c=i(),Io=M("p"),Io.textContent=gh,kc=i(),Jo=M("p"),Jo.textContent=uh,vc=i(),g(Nt.$$.fragment),qc=i(),L=M("div"),g(Na.$$.fragment),Ac=i(),wo=M("p"),wo.textContent=mh,Zc=i(),Uo=M("p"),Uo.innerHTML=hh,Ec=i(),g(Gt.$$.fragment),Wc=i(),g(Bt.$$.fragment),Nc=i(),g(Qt.$$.fragment),Gc=i(),me=M("div"),g(Ga.$$.fragment),Bc=i(),xo=M("p"),xo.textContent=dh,Qc=i(),g(Vt.$$.fragment),Vc=i(),g(St.$$.fragment),Sc=i(),Pe=M("div"),g(Ba.$$.fragment),Yc=i(),Co=M("p"),Co.textContent=fh,Rc=i(),$o=M("p"),$o.innerHTML=yh,zc=i(),Ke=M("div"),g(Qa.$$.fragment),Xc=i(),ko=M("p"),ko.textContent=Mh,Fc=i(),g(Yt.$$.fragment),Hc=i(),en=M("div"),g(Va.$$.fragment),Dc=i(),vo=M("p"),vo.textContent=bh,Oc=i(),g(Rt.$$.fragment),Lc=i(),nn=M("div"),g(Sa.$$.fragment),Pc=i(),qo=M("p"),qo.textContent=jh,Kc=i(),g(zt.$$.fragment),ep=i(),tn=M("div"),g(Ya.$$.fragment),np=i(),Ao=M("p"),Ao.textContent=_h,tp=i(),g(Xt.$$.fragment),sp=i(),sn=M("div"),g(Ra.$$.fragment),ap=i(),Zo=M("p"),Zo.textContent=Th,lp=i(),g(Ft.$$.fragment),op=i(),an=M("div"),g(za.$$.fragment),ip=i(),Eo=M("p"),Eo.textContent=Ih,rp=i(),g(Ht.$$.fragment),cp=i(),ln=M("div"),g(Xa.$$.fragment),pp=i(),Wo=M("p"),Wo.textContent=Jh,gp=i(),g(Dt.$$.fragment),up=i(),he=M("div"),g(Fa.$$.fragment),mp=i(),No=M("p"),No.textContent=wh,hp=i(),g(Ot.$$.fragment),dp=i(),g(Lt.$$.fragment),fp=i(),B=M("div"),g(Ha.$$.fragment),yp=i(),Go=M("p"),Go.textContent=Uh,Mp=i(),g(Pt.$$.fragment),bp=i(),g(Kt.$$.fragment),jp=Ir(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(es.$$.fragment),_p=i(),Bo=M("p"),Bo.textContent=xh,Tp=i(),g(ns.$$.fragment),Ip=i(),Q=M("div"),g(Da.$$.fragment),Jp=i(),Qo=M("p"),Qo.textContent=Ch,wp=i(),g(ts.$$.fragment),Up=i(),Vo=M("p"),Vo.textContent=$h,xp=i(),g(ss.$$.fragment),Cp=i(),So=M("p"),So.textContent=kh,$p=i(),g(as.$$.fragment),kp=i(),V=M("div"),g(Oa.$$.fragment),vp=i(),Yo=M("p"),Yo.textContent=vh,qp=i(),Ro=M("p"),Ro.textContent=qh,Ap=i(),zo=M("p"),zo.textContent=Ah,Zp=i(),g(ls.$$.fragment),Ep=i(),Xo=M("p"),Xo.textContent=Zh,Wp=i(),g(os.$$.fragment),Np=i(),on=M("div"),g(La.$$.fragment),Gp=i(),Fo=M("p"),Fo.textContent=Eh,Bp=i(),g(is.$$.fragment),Qp=i(),te=M("div"),g(Pa.$$.fragment),Vp=i(),Ho=M("p"),Ho.textContent=Wh,Sp=i(),Do=M("p"),Do.innerHTML=Nh,Yp=i(),g(rs.$$.fragment),Rp=i(),g(cs.$$.fragment),zp=i(),rn=M("div"),g(Ka.$$.fragment),Xp=i(),Oo=M("p"),Oo.textContent=Gh,Fp=i(),g(ps.$$.fragment),Hp=i(),de=M("div"),g(el.$$.fragment),Dp=i(),Lo=M("p"),Lo.textContent=Bh,Op=i(),g(gs.$$.fragment),Lp=i(),g(us.$$.fragment),Pp=i(),cn=M("div"),g(nl.$$.fragment),Kp=i(),Po=M("p"),Po.textContent=Qh,eg=i(),g(ms.$$.fragment),ir=i(),g(tl.$$.fragment),rr=i(),sl=M("p"),sl.innerHTML=Vh,cr=i(),g(al.$$.fragment),pr=i(),x=M("div"),g(ll.$$.fragment),ng=i(),Ko=M("p"),Ko.textContent=Sh,tg=i(),ei=M("p"),ei.innerHTML=Yh,sg=i(),pn=M("div"),g(ol.$$.fragment),ag=i(),ni=M("p"),ni.textContent=Rh,lg=i(),g(hs.$$.fragment),og=i(),gn=M("div"),g(il.$$.fragment),ig=i(),ti=M("p"),ti.textContent=zh,rg=i(),g(ds.$$.fragment),cg=i(),un=M("div"),g(rl.$$.fragment),pg=i(),si=M("p"),si.textContent=Xh,gg=i(),g(fs.$$.fragment),ug=i(),E=M("div"),g(cl.$$.fragment),mg=i(),ai=M("p"),ai.textContent=Fh,hg=i(),g(ys.$$.fragment),dg=i(),g(Ms.$$.fragment),fg=i(),g(bs.$$.fragment),yg=i(),g(js.$$.fragment),Mg=i(),g(_s.$$.fragment),bg=i(),li=M("p"),li.textContent=Hh,jg=i(),g(Ts.$$.fragment),_g=i(),oi=M("p"),oi.textContent=Dh,Tg=i(),g(Is.$$.fragment),Ig=i(),g(Js.$$.fragment),Jg=i(),g(ws.$$.fragment),wg=i(),g(Us.$$.fragment),Ug=i(),fe=M("div"),g(pl.$$.fragment),xg=i(),ii=M("p"),ii.textContent=Oh,Cg=i(),ri=M("p"),ri.textContent=Lh,$g=i(),ci=M("p"),ci.innerHTML=Ph,kg=i(),mn=M("div"),g(gl.$$.fragment),vg=i(),pi=M("p"),pi.textContent=Kh,qg=i(),g(xs.$$.fragment),Ag=i(),hn=M("div"),g(ul.$$.fragment),Zg=i(),gi=M("p"),gi.textContent=ed,Eg=i(),g(Cs.$$.fragment),Wg=i(),dn=M("div"),g(ml.$$.fragment),Ng=i(),ui=M("p"),ui.textContent=nd,Gg=i(),g($s.$$.fragment),Bg=i(),ye=M("div"),g(hl.$$.fragment),Qg=i(),mi=M("p"),mi.textContent=td,Vg=i(),hi=M("p"),hi.innerHTML=sd,Sg=i(),g(ks.$$.fragment),Yg=i(),Me=M("div"),g(dl.$$.fragment),Rg=i(),di=M("p"),di.textContent=ad,zg=i(),g(vs.$$.fragment),Xg=i(),g(qs.$$.fragment),Fg=i(),be=M("div"),g(fl.$$.fragment),Hg=i(),fi=M("p"),fi.textContent=ld,Dg=i(),yi=M("p"),yi.innerHTML=od,Og=i(),g(As.$$.fragment),Lg=i(),fn=M("div"),g(yl.$$.fragment),Pg=i(),Mi=M("p"),Mi.textContent=id,Kg=i(),g(Zs.$$.fragment),eu=i(),je=M("div"),g(Ml.$$.fragment),nu=i(),bi=M("p"),bi.textContent=rd,tu=i(),g(Es.$$.fragment),su=i(),g(Ws.$$.fragment),au=i(),_e=M("div"),g(bl.$$.fragment),lu=i(),ji=M("p"),ji.textContent=cd,ou=i(),g(Ns.$$.fragment),iu=i(),g(Gs.$$.fragment),ru=i(),Te=M("div"),g(jl.$$.fragment),cu=i(),_i=M("p"),_i.textContent=pd,pu=i(),Ti=M("p"),Ti.textContent=gd,gu=i(),g(Bs.$$.fragment),uu=i(),P=M("div"),g(_l.$$.fragment),mu=i(),Ii=M("p"),Ii.textContent=ud,hu=i(),Ji=M("p"),Ji.innerHTML=md,du=i(),g(Qs.$$.fragment),fu=i(),g(Vs.$$.fragment),yu=i(),g(Ss.$$.fragment),Mu=i(),Ie=M("div"),g(Tl.$$.fragment),bu=i(),wi=M("p"),wi.textContent=hd,ju=i(),g(Ys.$$.fragment),_u=i(),g(Rs.$$.fragment),Tu=i(),yn=M("div"),g(Il.$$.fragment),Iu=i(),Ui=M("p"),Ui.textContent=dd,Ju=i(),xi=M("p"),xi.innerHTML=fd,wu=i(),Mn=M("div"),g(Jl.$$.fragment),Uu=i(),Ci=M("p"),Ci.textContent=yd,xu=i(),g(zs.$$.fragment),Cu=i(),bn=M("div"),g(wl.$$.fragment),$u=i(),$i=M("p"),$i.textContent=Md,ku=i(),g(Xs.$$.fragment),vu=i(),jn=M("div"),g(Ul.$$.fragment),qu=i(),ki=M("p"),ki.textContent=bd,Au=i(),g(Fs.$$.fragment),Zu=i(),_n=M("div"),g(xl.$$.fragment),Eu=i(),vi=M("p"),vi.textContent=jd,Wu=i(),g(Hs.$$.fragment),Nu=i(),Tn=M("div"),g(Cl.$$.fragment),Gu=i(),qi=M("p"),qi.textContent=_d,Bu=i(),g(Ds.$$.fragment),Qu=i(),In=M("div"),g($l.$$.fragment),Vu=i(),Ai=M("p"),Ai.textContent=Td,Su=i(),g(Os.$$.fragment),Yu=i(),Jn=M("div"),g(kl.$$.fragment),Ru=i(),Zi=M("p"),Zi.textContent=Id,zu=i(),g(Ls.$$.fragment),Xu=i(),Je=M("div"),g(vl.$$.fragment),Fu=i(),Ei=M("p"),Ei.textContent=Jd,Hu=i(),g(Ps.$$.fragment),Du=i(),g(Ks.$$.fragment),Ou=i(),S=M("div"),g(ql.$$.fragment),Lu=i(),Wi=M("p"),Wi.textContent=wd,Pu=i(),g(ea.$$.fragment),Ku=i(),g(na.$$.fragment),em=Ir(`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),g(ta.$$.fragment),nm=i(),Ni=M("p"),Ni.textContent=Ud,tm=i(),g(sa.$$.fragment),sm=i(),Y=M("div"),g(Al.$$.fragment),am=i(),Gi=M("p"),Gi.textContent=xd,lm=i(),g(aa.$$.fragment),om=i(),Bi=M("p"),Bi.textContent=Cd,im=i(),g(la.$$.fragment),rm=i(),Qi=M("p"),Qi.textContent=$d,cm=i(),g(oa.$$.fragment),pm=i(),R=M("div"),g(Zl.$$.fragment),gm=i(),Vi=M("p"),Vi.textContent=kd,um=i(),Si=M("p"),Si.textContent=vd,mm=i(),Yi=M("p"),Yi.textContent=qd,hm=i(),g(ia.$$.fragment),dm=i(),Ri=M("p"),Ri.textContent=Ad,fm=i(),g(ra.$$.fragment),ym=i(),wn=M("div"),g(El.$$.fragment),Mm=i(),zi=M("p"),zi.textContent=Zd,bm=i(),g(ca.$$.fragment),jm=i(),se=M("div"),g(Wl.$$.fragment),_m=i(),Xi=M("p"),Xi.textContent=Ed,Tm=i(),Fi=M("p"),Fi.innerHTML=Wd,Im=i(),g(pa.$$.fragment),Jm=i(),g(ga.$$.fragment),wm=i(),Un=M("div"),g(Nl.$$.fragment),Um=i(),Hi=M("p"),Hi.textContent=Nd,xm=i(),g(ua.$$.fragment),Cm=i(),we=M("div"),g(Gl.$$.fragment),$m=i(),Di=M("p"),Di.textContent=Gd,km=i(),g(ma.$$.fragment),vm=i(),g(ha.$$.fragment),qm=i(),xn=M("div"),g(Bl.$$.fragment),Am=i(),Oi=M("p"),Oi.textContent=Bd,Zm=i(),g(da.$$.fragment),gr=i(),g(Ql.$$.fragment),ur=i(),Cn=M("div"),g(Vl.$$.fragment),Em=i(),Li=M("p"),Li.textContent=Qd,mr=i(),g(Sl.$$.fragment),hr=i(),Yl=M("p"),Yl.textContent=Vd,dr=i(),g(Rl.$$.fragment),fr=i(),$n=M("div"),g(zl.$$.fragment),Wm=i(),Pi=M("p"),Pi.textContent=Sd,yr=i(),g(Xl.$$.fragment),Mr=i(),Fl=M("p"),Fl.innerHTML=Yd,br=i(),K=M("div"),g(Hl.$$.fragment),Nm=i(),Ki=M("p"),Ki.textContent=Rd,Gm=i(),g(fa.$$.fragment),Bm=i(),ya=M("div"),g(Dl.$$.fragment),Qm=i(),er=M("p"),er.textContent=zd,Vm=i(),Ma=M("div"),g(Ol.$$.fragment),Sm=i(),nr=M("p"),nr.textContent=Xd,jr=i(),g(Ll.$$.fragment),_r=i(),tr=M("p"),this.h()},l(a){const j=Nf("svelte-u9bgzb",document.head);n=b(j,"META",{name:!0,content:!0}),j.forEach(y),c=r(a),s=b(a,"P",{}),k(s).forEach(y),t=r(a),u(o.$$.fragment,a),e=r(a),p=b(a,"P",{"data-svelte-h":!0}),I(p)!=="svelte-10zkjtm"&&(p.innerHTML=Ym),sr=r(a),ba=b(a,"UL",{"data-svelte-h":!0}),I(ba)!=="svelte-5iysbw"&&(ba.innerHTML=Rm),ar=r(a),ja=b(a,"P",{"data-svelte-h":!0}),I(ja)!=="svelte-1bl7dx4"&&(ja.innerHTML=zm),lr=r(a),u(_a.$$.fragment,a),or=r(a),C=b(a,"DIV",{class:!0});var q=k(C);u(Ta.$$.fragment,q),wr=r(q),so=b(q,"P",{"data-svelte-h":!0}),I(so)!=="svelte-1p4u01l"&&(so.textContent=Xm),Ur=r(q),ao=b(q,"P",{"data-svelte-h":!0}),I(ao)!=="svelte-kbf9lm"&&(ao.innerHTML=Fm),xr=r(q),ze=b(q,"DIV",{class:!0});var kn=k(ze);u(Ia.$$.fragment,kn),Cr=r(kn),lo=b(kn,"P",{"data-svelte-h":!0}),I(lo)!=="svelte-1hs5qib"&&(lo.textContent=Hm),$r=r(kn),u(ut.$$.fragment,kn),kn.forEach(y),kr=r(q),Xe=b(q,"DIV",{class:!0});var vn=k(Xe);u(Ja.$$.fragment,vn),vr=r(vn),oo=b(vn,"P",{"data-svelte-h":!0}),I(oo)!=="svelte-z9e742"&&(oo.textContent=Dm),qr=r(vn),u(mt.$$.fragment,vn),vn.forEach(y),Ar=r(q),Fe=b(q,"DIV",{class:!0});var qn=k(Fe);u(wa.$$.fragment,qn),Zr=r(qn),io=b(qn,"P",{"data-svelte-h":!0}),I(io)!=="svelte-lahnll"&&(io.textContent=Om),Er=r(qn),u(ht.$$.fragment,qn),qn.forEach(y),Wr=r(q),Z=b(q,"DIV",{class:!0});var W=k(Z);u(Ua.$$.fragment,W),Nr=r(W),ro=b(W,"P",{"data-svelte-h":!0}),I(ro)!=="svelte-5o70yf"&&(ro.textContent=Lm),Gr=r(W),u(dt.$$.fragment,W),Br=r(W),u(ft.$$.fragment,W),Qr=r(W),u(yt.$$.fragment,W),Vr=r(W),u(Mt.$$.fragment,W),Sr=r(W),u(bt.$$.fragment,W),Yr=r(W),co=b(W,"P",{"data-svelte-h":!0}),I(co)!=="svelte-6a37ax"&&(co.textContent=Pm),Rr=r(W),u(jt.$$.fragment,W),zr=r(W),po=b(W,"P",{"data-svelte-h":!0}),I(po)!=="svelte-gzqu78"&&(po.textContent=Km),Xr=r(W),u(_t.$$.fragment,W),Fr=r(W),u(Tt.$$.fragment,W),Hr=r(W),u(It.$$.fragment,W),Dr=r(W),u(Jt.$$.fragment,W),W.forEach(y),Or=r(q),He=b(q,"DIV",{class:!0});var An=k(He);u(xa.$$.fragment,An),Lr=r(An),go=b(An,"P",{"data-svelte-h":!0}),I(go)!=="svelte-qs8cmr"&&(go.textContent=eh),Pr=r(An),u(wt.$$.fragment,An),An.forEach(y),Kr=r(q),De=b(q,"DIV",{class:!0});var Zn=k(De);u(Ca.$$.fragment,Zn),ec=r(Zn),uo=b(Zn,"P",{"data-svelte-h":!0}),I(uo)!=="svelte-1axtrg9"&&(uo.textContent=nh),nc=r(Zn),u(Ut.$$.fragment,Zn),Zn.forEach(y),tc=r(q),Oe=b(q,"DIV",{class:!0});var En=k(Oe);u($a.$$.fragment,En),sc=r(En),mo=b(En,"P",{"data-svelte-h":!0}),I(mo)!=="svelte-1lnjtsz"&&(mo.textContent=th),ac=r(En),u(xt.$$.fragment,En),En.forEach(y),lc=r(q),ie=b(q,"DIV",{class:!0});var Ue=k(ie);u(ka.$$.fragment,Ue),oc=r(Ue),ho=b(Ue,"P",{"data-svelte-h":!0}),I(ho)!=="svelte-s2la9t"&&(ho.textContent=sh),ic=r(Ue),fo=b(Ue,"P",{"data-svelte-h":!0}),I(fo)!=="svelte-1xhka28"&&(fo.innerHTML=ah),rc=r(Ue),u(Ct.$$.fragment,Ue),Ue.forEach(y),cc=r(q),re=b(q,"DIV",{class:!0});var xe=k(re);u(va.$$.fragment,xe),pc=r(xe),yo=b(xe,"P",{"data-svelte-h":!0}),I(yo)!=="svelte-1htupoc"&&(yo.textContent=lh),gc=r(xe),u($t.$$.fragment,xe),uc=r(xe),u(kt.$$.fragment,xe),xe.forEach(y),mc=r(q),ce=b(q,"DIV",{class:!0});var Ce=k(ce);u(qa.$$.fragment,Ce),hc=r(Ce),Mo=b(Ce,"P",{"data-svelte-h":!0}),I(Mo)!=="svelte-1m9sgvu"&&(Mo.textContent=oh),dc=r(Ce),bo=b(Ce,"P",{"data-svelte-h":!0}),I(bo)!=="svelte-1xj24a2"&&(bo.innerHTML=ih),fc=r(Ce),u(vt.$$.fragment,Ce),Ce.forEach(y),yc=r(q),Le=b(q,"DIV",{class:!0});var Wn=k(Le);u(Aa.$$.fragment,Wn),Mc=r(Wn),jo=b(Wn,"P",{"data-svelte-h":!0}),I(jo)!=="svelte-u63854"&&(jo.textContent=rh),bc=r(Wn),u(qt.$$.fragment,Wn),Wn.forEach(y),jc=r(q),pe=b(q,"DIV",{class:!0});var $e=k(pe);u(Za.$$.fragment,$e),_c=r($e),_o=b($e,"P",{"data-svelte-h":!0}),I(_o)!=="svelte-k6f11e"&&(_o.textContent=ch),Tc=r($e),u(At.$$.fragment,$e),Ic=r($e),u(Zt.$$.fragment,$e),$e.forEach(y),Jc=r(q),ge=b(q,"DIV",{class:!0});var ke=k(ge);u(Ea.$$.fragment,ke),wc=r(ke),To=b(ke,"P",{"data-svelte-h":!0}),I(To)!=="svelte-7cx5l1"&&(To.textContent=ph),Uc=r(ke),u(Et.$$.fragment,ke),xc=r(ke),u(Wt.$$.fragment,ke),ke.forEach(y),Cc=r(q),ue=b(q,"DIV",{class:!0});var ve=k(ue);u(Wa.$$.fragment,ve),$c=r(ve),Io=b(ve,"P",{"data-svelte-h":!0}),I(Io)!=="svelte-1tnfouk"&&(Io.textContent=gh),kc=r(ve),Jo=b(ve,"P",{"data-svelte-h":!0}),I(Jo)!=="svelte-qrqo93"&&(Jo.textContent=uh),vc=r(ve),u(Nt.$$.fragment,ve),ve.forEach(y),qc=r(q),L=b(q,"DIV",{class:!0});var ee=k(L);u(Na.$$.fragment,ee),Ac=r(ee),wo=b(ee,"P",{"data-svelte-h":!0}),I(wo)!=="svelte-71vo6e"&&(wo.textContent=mh),Zc=r(ee),Uo=b(ee,"P",{"data-svelte-h":!0}),I(Uo)!=="svelte-1k36r1q"&&(Uo.innerHTML=hh),Ec=r(ee),u(Gt.$$.fragment,ee),Wc=r(ee),u(Bt.$$.fragment,ee),Nc=r(ee),u(Qt.$$.fragment,ee),ee.forEach(y),Gc=r(q),me=b(q,"DIV",{class:!0});var qe=k(me);u(Ga.$$.fragment,qe),Bc=r(qe),xo=b(qe,"P",{"data-svelte-h":!0}),I(xo)!=="svelte-fzfwfh"&&(xo.textContent=dh),Qc=r(qe),u(Vt.$$.fragment,qe),Vc=r(qe),u(St.$$.fragment,qe),qe.forEach(y),Sc=r(q),Pe=b(q,"DIV",{class:!0});var Nn=k(Pe);u(Ba.$$.fragment,Nn),Yc=r(Nn),Co=b(Nn,"P",{"data-svelte-h":!0}),I(Co)!=="svelte-14tnsya"&&(Co.textContent=fh),Rc=r(Nn),$o=b(Nn,"P",{"data-svelte-h":!0}),I($o)!=="svelte-9lex0q"&&($o.innerHTML=yh),Nn.forEach(y),zc=r(q),Ke=b(q,"DIV",{class:!0});var Gn=k(Ke);u(Qa.$$.fragment,Gn),Xc=r(Gn),ko=b(Gn,"P",{"data-svelte-h":!0}),I(ko)!=="svelte-1mibg86"&&(ko.textContent=Mh),Fc=r(Gn),u(Yt.$$.fragment,Gn),Gn.forEach(y),Hc=r(q),en=b(q,"DIV",{class:!0});var Bn=k(en);u(Va.$$.fragment,Bn),Dc=r(Bn),vo=b(Bn,"P",{"data-svelte-h":!0}),I(vo)!=="svelte-1nuhgbh"&&(vo.textContent=bh),Oc=r(Bn),u(Rt.$$.fragment,Bn),Bn.forEach(y),Lc=r(q),nn=b(q,"DIV",{class:!0});var Qn=k(nn);u(Sa.$$.fragment,Qn),Pc=r(Qn),qo=b(Qn,"P",{"data-svelte-h":!0}),I(qo)!=="svelte-1uepm2o"&&(qo.textContent=jh),Kc=r(Qn),u(zt.$$.fragment,Qn),Qn.forEach(y),ep=r(q),tn=b(q,"DIV",{class:!0});var Vn=k(tn);u(Ya.$$.fragment,Vn),np=r(Vn),Ao=b(Vn,"P",{"data-svelte-h":!0}),I(Ao)!=="svelte-77a94i"&&(Ao.textContent=_h),tp=r(Vn),u(Xt.$$.fragment,Vn),Vn.forEach(y),sp=r(q),sn=b(q,"DIV",{class:!0});var Sn=k(sn);u(Ra.$$.fragment,Sn),ap=r(Sn),Zo=b(Sn,"P",{"data-svelte-h":!0}),I(Zo)!=="svelte-61sxmo"&&(Zo.textContent=Th),lp=r(Sn),u(Ft.$$.fragment,Sn),Sn.forEach(y),op=r(q),an=b(q,"DIV",{class:!0});var Yn=k(an);u(za.$$.fragment,Yn),ip=r(Yn),Eo=b(Yn,"P",{"data-svelte-h":!0}),I(Eo)!=="svelte-hzldyu"&&(Eo.textContent=Ih),rp=r(Yn),u(Ht.$$.fragment,Yn),Yn.forEach(y),cp=r(q),ln=b(q,"DIV",{class:!0});var Rn=k(ln);u(Xa.$$.fragment,Rn),pp=r(Rn),Wo=b(Rn,"P",{"data-svelte-h":!0}),I(Wo)!=="svelte-b4yzyj"&&(Wo.textContent=Jh),gp=r(Rn),u(Dt.$$.fragment,Rn),Rn.forEach(y),up=r(q),he=b(q,"DIV",{class:!0});var Ae=k(he);u(Fa.$$.fragment,Ae),mp=r(Ae),No=b(Ae,"P",{"data-svelte-h":!0}),I(No)!=="svelte-qakvx8"&&(No.textContent=wh),hp=r(Ae),u(Ot.$$.fragment,Ae),dp=r(Ae),u(Lt.$$.fragment,Ae),Ae.forEach(y),fp=r(q),B=b(q,"DIV",{class:!0});var z=k(B);u(Ha.$$.fragment,z),yp=r(z),Go=b(z,"P",{"data-svelte-h":!0}),I(Go)!=="svelte-9lmcnw"&&(Go.textContent=Uh),Mp=r(z),u(Pt.$$.fragment,z),bp=r(z),u(Kt.$$.fragment,z),jp=Jr(z,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(es.$$.fragment,z),_p=r(z),Bo=b(z,"P",{"data-svelte-h":!0}),I(Bo)!=="svelte-gzqu78"&&(Bo.textContent=xh),Tp=r(z),u(ns.$$.fragment,z),z.forEach(y),Ip=r(q),Q=b(q,"DIV",{class:!0});var X=k(Q);u(Da.$$.fragment,X),Jp=r(X),Qo=b(X,"P",{"data-svelte-h":!0}),I(Qo)!=="svelte-12mjzdy"&&(Qo.textContent=Ch),wp=r(X),u(ts.$$.fragment,X),Up=r(X),Vo=b(X,"P",{"data-svelte-h":!0}),I(Vo)!=="svelte-6wr902"&&(Vo.textContent=$h),xp=r(X),u(ss.$$.fragment,X),Cp=r(X),So=b(X,"P",{"data-svelte-h":!0}),I(So)!=="svelte-gzqu78"&&(So.textContent=kh),$p=r(X),u(as.$$.fragment,X),X.forEach(y),kp=r(q),V=b(q,"DIV",{class:!0});var F=k(V);u(Oa.$$.fragment,F),vp=r(F),Yo=b(F,"P",{"data-svelte-h":!0}),I(Yo)!=="svelte-17lryks"&&(Yo.textContent=vh),qp=r(F),Ro=b(F,"P",{"data-svelte-h":!0}),I(Ro)!=="svelte-11lpom8"&&(Ro.textContent=qh),Ap=r(F),zo=b(F,"P",{"data-svelte-h":!0}),I(zo)!=="svelte-vt1ppo"&&(zo.textContent=Ah),Zp=r(F),u(ls.$$.fragment,F),Ep=r(F),Xo=b(F,"P",{"data-svelte-h":!0}),I(Xo)!=="svelte-gzqu78"&&(Xo.textContent=Zh),Wp=r(F),u(os.$$.fragment,F),F.forEach(y),Np=r(q),on=b(q,"DIV",{class:!0});var zn=k(on);u(La.$$.fragment,zn),Gp=r(zn),Fo=b(zn,"P",{"data-svelte-h":!0}),I(Fo)!=="svelte-1araal"&&(Fo.textContent=Eh),Bp=r(zn),u(is.$$.fragment,zn),zn.forEach(y),Qp=r(q),te=b(q,"DIV",{class:!0});var ae=k(te);u(Pa.$$.fragment,ae),Vp=r(ae),Ho=b(ae,"P",{"data-svelte-h":!0}),I(Ho)!=="svelte-1v3lqck"&&(Ho.textContent=Wh),Sp=r(ae),Do=b(ae,"P",{"data-svelte-h":!0}),I(Do)!=="svelte-jwmjgr"&&(Do.innerHTML=Nh),Yp=r(ae),u(rs.$$.fragment,ae),Rp=r(ae),u(cs.$$.fragment,ae),ae.forEach(y),zp=r(q),rn=b(q,"DIV",{class:!0});var Xn=k(rn);u(Ka.$$.fragment,Xn),Xp=r(Xn),Oo=b(Xn,"P",{"data-svelte-h":!0}),I(Oo)!=="svelte-1jbp6ey"&&(Oo.textContent=Gh),Fp=r(Xn),u(ps.$$.fragment,Xn),Xn.forEach(y),Hp=r(q),de=b(q,"DIV",{class:!0});var Ze=k(de);u(el.$$.fragment,Ze),Dp=r(Ze),Lo=b(Ze,"P",{"data-svelte-h":!0}),I(Lo)!=="svelte-1c9xuqj"&&(Lo.textContent=Bh),Op=r(Ze),u(gs.$$.fragment,Ze),Lp=r(Ze),u(us.$$.fragment,Ze),Ze.forEach(y),Pp=r(q),cn=b(q,"DIV",{class:!0});var Fn=k(cn);u(nl.$$.fragment,Fn),Kp=r(Fn),Po=b(Fn,"P",{"data-svelte-h":!0}),I(Po)!=="svelte-108ipf8"&&(Po.textContent=Qh),eg=r(Fn),u(ms.$$.fragment,Fn),Fn.forEach(y),q.forEach(y),ir=r(a),u(tl.$$.fragment,a),rr=r(a),sl=b(a,"P",{"data-svelte-h":!0}),I(sl)!=="svelte-1vkrv9k"&&(sl.innerHTML=Vh),cr=r(a),u(al.$$.fragment,a),pr=r(a),x=b(a,"DIV",{class:!0});var $=k(x);u(ll.$$.fragment,$),ng=r($),Ko=b($,"P",{"data-svelte-h":!0}),I(Ko)!=="svelte-1p4u01l"&&(Ko.textContent=Sh),tg=r($),ei=b($,"P",{"data-svelte-h":!0}),I(ei)!=="svelte-kbf9lm"&&(ei.innerHTML=Yh),sg=r($),pn=b($,"DIV",{class:!0});var Hn=k(pn);u(ol.$$.fragment,Hn),ag=r(Hn),ni=b(Hn,"P",{"data-svelte-h":!0}),I(ni)!=="svelte-1hs5qib"&&(ni.textContent=Rh),lg=r(Hn),u(hs.$$.fragment,Hn),Hn.forEach(y),og=r($),gn=b($,"DIV",{class:!0});var Dn=k(gn);u(il.$$.fragment,Dn),ig=r(Dn),ti=b(Dn,"P",{"data-svelte-h":!0}),I(ti)!=="svelte-z9e742"&&(ti.textContent=zh),rg=r(Dn),u(ds.$$.fragment,Dn),Dn.forEach(y),cg=r($),un=b($,"DIV",{class:!0});var On=k(un);u(rl.$$.fragment,On),pg=r(On),si=b(On,"P",{"data-svelte-h":!0}),I(si)!=="svelte-lahnll"&&(si.textContent=Xh),gg=r(On),u(fs.$$.fragment,On),On.forEach(y),ug=r($),E=b($,"DIV",{class:!0});var N=k(E);u(cl.$$.fragment,N),mg=r(N),ai=b(N,"P",{"data-svelte-h":!0}),I(ai)!=="svelte-5o70yf"&&(ai.textContent=Fh),hg=r(N),u(ys.$$.fragment,N),dg=r(N),u(Ms.$$.fragment,N),fg=r(N),u(bs.$$.fragment,N),yg=r(N),u(js.$$.fragment,N),Mg=r(N),u(_s.$$.fragment,N),bg=r(N),li=b(N,"P",{"data-svelte-h":!0}),I(li)!=="svelte-6a37ax"&&(li.textContent=Hh),jg=r(N),u(Ts.$$.fragment,N),_g=r(N),oi=b(N,"P",{"data-svelte-h":!0}),I(oi)!=="svelte-gzqu78"&&(oi.textContent=Dh),Tg=r(N),u(Is.$$.fragment,N),Ig=r(N),u(Js.$$.fragment,N),Jg=r(N),u(ws.$$.fragment,N),wg=r(N),u(Us.$$.fragment,N),N.forEach(y),Ug=r($),fe=b($,"DIV",{class:!0});var Ee=k(fe);u(pl.$$.fragment,Ee),xg=r(Ee),ii=b(Ee,"P",{"data-svelte-h":!0}),I(ii)!=="svelte-vcr7iw"&&(ii.textContent=Oh),Cg=r(Ee),ri=b(Ee,"P",{"data-svelte-h":!0}),I(ri)!=="svelte-1jtca0b"&&(ri.textContent=Lh),$g=r(Ee),ci=b(Ee,"P",{"data-svelte-h":!0}),I(ci)!=="svelte-1sz3ulv"&&(ci.innerHTML=Ph),Ee.forEach(y),kg=r($),mn=b($,"DIV",{class:!0});var Ln=k(mn);u(gl.$$.fragment,Ln),vg=r(Ln),pi=b(Ln,"P",{"data-svelte-h":!0}),I(pi)!=="svelte-qs8cmr"&&(pi.textContent=Kh),qg=r(Ln),u(xs.$$.fragment,Ln),Ln.forEach(y),Ag=r($),hn=b($,"DIV",{class:!0});var Pn=k(hn);u(ul.$$.fragment,Pn),Zg=r(Pn),gi=b(Pn,"P",{"data-svelte-h":!0}),I(gi)!=="svelte-1axtrg9"&&(gi.textContent=ed),Eg=r(Pn),u(Cs.$$.fragment,Pn),Pn.forEach(y),Wg=r($),dn=b($,"DIV",{class:!0});var Kn=k(dn);u(ml.$$.fragment,Kn),Ng=r(Kn),ui=b(Kn,"P",{"data-svelte-h":!0}),I(ui)!=="svelte-1lnjtsz"&&(ui.textContent=nd),Gg=r(Kn),u($s.$$.fragment,Kn),Kn.forEach(y),Bg=r($),ye=b($,"DIV",{class:!0});var We=k(ye);u(hl.$$.fragment,We),Qg=r(We),mi=b(We,"P",{"data-svelte-h":!0}),I(mi)!=="svelte-s2la9t"&&(mi.textContent=td),Vg=r(We),hi=b(We,"P",{"data-svelte-h":!0}),I(hi)!=="svelte-1xhka28"&&(hi.innerHTML=sd),Sg=r(We),u(ks.$$.fragment,We),We.forEach(y),Yg=r($),Me=b($,"DIV",{class:!0});var Ne=k(Me);u(dl.$$.fragment,Ne),Rg=r(Ne),di=b(Ne,"P",{"data-svelte-h":!0}),I(di)!=="svelte-1htupoc"&&(di.textContent=ad),zg=r(Ne),u(vs.$$.fragment,Ne),Xg=r(Ne),u(qs.$$.fragment,Ne),Ne.forEach(y),Fg=r($),be=b($,"DIV",{class:!0});var Ge=k(be);u(fl.$$.fragment,Ge),Hg=r(Ge),fi=b(Ge,"P",{"data-svelte-h":!0}),I(fi)!=="svelte-1m9sgvu"&&(fi.textContent=ld),Dg=r(Ge),yi=b(Ge,"P",{"data-svelte-h":!0}),I(yi)!=="svelte-1xj24a2"&&(yi.innerHTML=od),Og=r(Ge),u(As.$$.fragment,Ge),Ge.forEach(y),Lg=r($),fn=b($,"DIV",{class:!0});var et=k(fn);u(yl.$$.fragment,et),Pg=r(et),Mi=b(et,"P",{"data-svelte-h":!0}),I(Mi)!=="svelte-u63854"&&(Mi.textContent=id),Kg=r(et),u(Zs.$$.fragment,et),et.forEach(y),eu=r($),je=b($,"DIV",{class:!0});var Be=k(je);u(Ml.$$.fragment,Be),nu=r(Be),bi=b(Be,"P",{"data-svelte-h":!0}),I(bi)!=="svelte-k6f11e"&&(bi.textContent=rd),tu=r(Be),u(Es.$$.fragment,Be),su=r(Be),u(Ws.$$.fragment,Be),Be.forEach(y),au=r($),_e=b($,"DIV",{class:!0});var Qe=k(_e);u(bl.$$.fragment,Qe),lu=r(Qe),ji=b(Qe,"P",{"data-svelte-h":!0}),I(ji)!=="svelte-7cx5l1"&&(ji.textContent=cd),ou=r(Qe),u(Ns.$$.fragment,Qe),iu=r(Qe),u(Gs.$$.fragment,Qe),Qe.forEach(y),ru=r($),Te=b($,"DIV",{class:!0});var Ve=k(Te);u(jl.$$.fragment,Ve),cu=r(Ve),_i=b(Ve,"P",{"data-svelte-h":!0}),I(_i)!=="svelte-1tnfouk"&&(_i.textContent=pd),pu=r(Ve),Ti=b(Ve,"P",{"data-svelte-h":!0}),I(Ti)!=="svelte-qrqo93"&&(Ti.textContent=gd),gu=r(Ve),u(Bs.$$.fragment,Ve),Ve.forEach(y),uu=r($),P=b($,"DIV",{class:!0});var ne=k(P);u(_l.$$.fragment,ne),mu=r(ne),Ii=b(ne,"P",{"data-svelte-h":!0}),I(Ii)!=="svelte-71vo6e"&&(Ii.textContent=ud),hu=r(ne),Ji=b(ne,"P",{"data-svelte-h":!0}),I(Ji)!=="svelte-1k36r1q"&&(Ji.innerHTML=md),du=r(ne),u(Qs.$$.fragment,ne),fu=r(ne),u(Vs.$$.fragment,ne),yu=r(ne),u(Ss.$$.fragment,ne),ne.forEach(y),Mu=r($),Ie=b($,"DIV",{class:!0});var Se=k(Ie);u(Tl.$$.fragment,Se),bu=r(Se),wi=b(Se,"P",{"data-svelte-h":!0}),I(wi)!=="svelte-fzfwfh"&&(wi.textContent=hd),ju=r(Se),u(Ys.$$.fragment,Se),_u=r(Se),u(Rs.$$.fragment,Se),Se.forEach(y),Tu=r($),yn=b($,"DIV",{class:!0});var nt=k(yn);u(Il.$$.fragment,nt),Iu=r(nt),Ui=b(nt,"P",{"data-svelte-h":!0}),I(Ui)!=="svelte-14tnsya"&&(Ui.textContent=dd),Ju=r(nt),xi=b(nt,"P",{"data-svelte-h":!0}),I(xi)!=="svelte-9lex0q"&&(xi.innerHTML=fd),nt.forEach(y),wu=r($),Mn=b($,"DIV",{class:!0});var tt=k(Mn);u(Jl.$$.fragment,tt),Uu=r(tt),Ci=b(tt,"P",{"data-svelte-h":!0}),I(Ci)!=="svelte-1mibg86"&&(Ci.textContent=yd),xu=r(tt),u(zs.$$.fragment,tt),tt.forEach(y),Cu=r($),bn=b($,"DIV",{class:!0});var st=k(bn);u(wl.$$.fragment,st),$u=r(st),$i=b(st,"P",{"data-svelte-h":!0}),I($i)!=="svelte-1nuhgbh"&&($i.textContent=Md),ku=r(st),u(Xs.$$.fragment,st),st.forEach(y),vu=r($),jn=b($,"DIV",{class:!0});var at=k(jn);u(Ul.$$.fragment,at),qu=r(at),ki=b(at,"P",{"data-svelte-h":!0}),I(ki)!=="svelte-1uepm2o"&&(ki.textContent=bd),Au=r(at),u(Fs.$$.fragment,at),at.forEach(y),Zu=r($),_n=b($,"DIV",{class:!0});var lt=k(_n);u(xl.$$.fragment,lt),Eu=r(lt),vi=b(lt,"P",{"data-svelte-h":!0}),I(vi)!=="svelte-77a94i"&&(vi.textContent=jd),Wu=r(lt),u(Hs.$$.fragment,lt),lt.forEach(y),Nu=r($),Tn=b($,"DIV",{class:!0});var ot=k(Tn);u(Cl.$$.fragment,ot),Gu=r(ot),qi=b(ot,"P",{"data-svelte-h":!0}),I(qi)!=="svelte-61sxmo"&&(qi.textContent=_d),Bu=r(ot),u(Ds.$$.fragment,ot),ot.forEach(y),Qu=r($),In=b($,"DIV",{class:!0});var it=k(In);u($l.$$.fragment,it),Vu=r(it),Ai=b(it,"P",{"data-svelte-h":!0}),I(Ai)!=="svelte-hzldyu"&&(Ai.textContent=Td),Su=r(it),u(Os.$$.fragment,it),it.forEach(y),Yu=r($),Jn=b($,"DIV",{class:!0});var rt=k(Jn);u(kl.$$.fragment,rt),Ru=r(rt),Zi=b(rt,"P",{"data-svelte-h":!0}),I(Zi)!=="svelte-b4yzyj"&&(Zi.textContent=Id),zu=r(rt),u(Ls.$$.fragment,rt),rt.forEach(y),Xu=r($),Je=b($,"DIV",{class:!0});var Ye=k(Je);u(vl.$$.fragment,Ye),Fu=r(Ye),Ei=b(Ye,"P",{"data-svelte-h":!0}),I(Ei)!=="svelte-qakvx8"&&(Ei.textContent=Jd),Hu=r(Ye),u(Ps.$$.fragment,Ye),Du=r(Ye),u(Ks.$$.fragment,Ye),Ye.forEach(y),Ou=r($),S=b($,"DIV",{class:!0});var H=k(S);u(ql.$$.fragment,H),Lu=r(H),Wi=b(H,"P",{"data-svelte-h":!0}),I(Wi)!=="svelte-9lmcnw"&&(Wi.textContent=wd),Pu=r(H),u(ea.$$.fragment,H),Ku=r(H),u(na.$$.fragment,H),em=Jr(H,`
Example using a third-party provider directly. Usage will be billed on your fal.ai account.
`),u(ta.$$.fragment,H),nm=r(H),Ni=b(H,"P",{"data-svelte-h":!0}),I(Ni)!=="svelte-gzqu78"&&(Ni.textContent=Ud),tm=r(H),u(sa.$$.fragment,H),H.forEach(y),sm=r($),Y=b($,"DIV",{class:!0});var D=k(Y);u(Al.$$.fragment,D),am=r(D),Gi=b(D,"P",{"data-svelte-h":!0}),I(Gi)!=="svelte-12mjzdy"&&(Gi.textContent=xd),lm=r(D),u(aa.$$.fragment,D),om=r(D),Bi=b(D,"P",{"data-svelte-h":!0}),I(Bi)!=="svelte-6wr902"&&(Bi.textContent=Cd),im=r(D),u(la.$$.fragment,D),rm=r(D),Qi=b(D,"P",{"data-svelte-h":!0}),I(Qi)!=="svelte-gzqu78"&&(Qi.textContent=$d),cm=r(D),u(oa.$$.fragment,D),D.forEach(y),pm=r($),R=b($,"DIV",{class:!0});var O=k(R);u(Zl.$$.fragment,O),gm=r(O),Vi=b(O,"P",{"data-svelte-h":!0}),I(Vi)!=="svelte-17lryks"&&(Vi.textContent=kd),um=r(O),Si=b(O,"P",{"data-svelte-h":!0}),I(Si)!=="svelte-11lpom8"&&(Si.textContent=vd),mm=r(O),Yi=b(O,"P",{"data-svelte-h":!0}),I(Yi)!=="svelte-vt1ppo"&&(Yi.textContent=qd),hm=r(O),u(ia.$$.fragment,O),dm=r(O),Ri=b(O,"P",{"data-svelte-h":!0}),I(Ri)!=="svelte-gzqu78"&&(Ri.textContent=Ad),fm=r(O),u(ra.$$.fragment,O),O.forEach(y),ym=r($),wn=b($,"DIV",{class:!0});var ct=k(wn);u(El.$$.fragment,ct),Mm=r(ct),zi=b(ct,"P",{"data-svelte-h":!0}),I(zi)!=="svelte-1araal"&&(zi.textContent=Zd),bm=r(ct),u(ca.$$.fragment,ct),ct.forEach(y),jm=r($),se=b($,"DIV",{class:!0});var le=k(se);u(Wl.$$.fragment,le),_m=r(le),Xi=b(le,"P",{"data-svelte-h":!0}),I(Xi)!=="svelte-1v3lqck"&&(Xi.textContent=Ed),Tm=r(le),Fi=b(le,"P",{"data-svelte-h":!0}),I(Fi)!=="svelte-jwmjgr"&&(Fi.innerHTML=Wd),Im=r(le),u(pa.$$.fragment,le),Jm=r(le),u(ga.$$.fragment,le),le.forEach(y),wm=r($),Un=b($,"DIV",{class:!0});var pt=k(Un);u(Nl.$$.fragment,pt),Um=r(pt),Hi=b(pt,"P",{"data-svelte-h":!0}),I(Hi)!=="svelte-1jbp6ey"&&(Hi.textContent=Nd),xm=r(pt),u(ua.$$.fragment,pt),pt.forEach(y),Cm=r($),we=b($,"DIV",{class:!0});var Re=k(we);u(Gl.$$.fragment,Re),$m=r(Re),Di=b(Re,"P",{"data-svelte-h":!0}),I(Di)!=="svelte-1c9xuqj"&&(Di.textContent=Gd),km=r(Re),u(ma.$$.fragment,Re),vm=r(Re),u(ha.$$.fragment,Re),Re.forEach(y),qm=r($),xn=b($,"DIV",{class:!0});var gt=k(xn);u(Bl.$$.fragment,gt),Am=r(gt),Oi=b(gt,"P",{"data-svelte-h":!0}),I(Oi)!=="svelte-108ipf8"&&(Oi.textContent=Bd),Zm=r(gt),u(da.$$.fragment,gt),gt.forEach(y),$.forEach(y),gr=r(a),u(Ql.$$.fragment,a),ur=r(a),Cn=b(a,"DIV",{class:!0});var Pl=k(Cn);u(Vl.$$.fragment,Pl),Em=r(Pl),Li=b(Pl,"P",{"data-svelte-h":!0}),I(Li)!=="svelte-2793d9"&&(Li.textContent=Qd),Pl.forEach(y),mr=r(a),u(Sl.$$.fragment,a),hr=r(a),Yl=b(a,"P",{"data-svelte-h":!0}),I(Yl)!=="svelte-1lzrumh"&&(Yl.textContent=Vd),dr=r(a),u(Rl.$$.fragment,a),fr=r(a),$n=b(a,"DIV",{class:!0});var Kl=k($n);u(zl.$$.fragment,Kl),Wm=r(Kl),Pi=b(Kl,"P",{"data-svelte-h":!0}),I(Pi)!=="svelte-1hj6bfi"&&(Pi.textContent=Sd),Kl.forEach(y),yr=r(a),u(Xl.$$.fragment,a),Mr=r(a),Fl=b(a,"P",{"data-svelte-h":!0}),I(Fl)!=="svelte-12jme9g"&&(Fl.innerHTML=Yd),br=r(a),K=b(a,"DIV",{class:!0});var oe=k(K);u(Hl.$$.fragment,oe),Nm=r(oe),Ki=b(oe,"P",{"data-svelte-h":!0}),I(Ki)!=="svelte-xkrgz1"&&(Ki.textContent=Rd),Gm=r(oe),u(fa.$$.fragment,oe),Bm=r(oe),ya=b(oe,"DIV",{class:!0});var eo=k(ya);u(Dl.$$.fragment,eo),Qm=r(eo),er=b(eo,"P",{"data-svelte-h":!0}),I(er)!=="svelte-1ruvvxs"&&(er.textContent=zd),eo.forEach(y),Vm=r(oe),Ma=b(oe,"DIV",{class:!0});var no=k(Ma);u(Ol.$$.fragment,no),Sm=r(no),nr=b(no,"P",{"data-svelte-h":!0}),I(nr)!=="svelte-ss15d2"&&(nr.textContent=Xd),no.forEach(y),oe.forEach(y),jr=r(a),u(Ll.$$.fragment,a),_r=r(a),tr=b(a,"P",{}),k(tr).forEach(y),this.h()},h(){v(n,"name","hf:doc:metadata"),v(n,"content",zM),v(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(en,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(nn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(gn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(dn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(fn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(yn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(bn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(_n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Tn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(In,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Jn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(wn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Un,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(xn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Cn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(ya,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Ma,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(a,j){l(document.head,n),T(a,c,j),T(a,s,j),T(a,t,j),m(o,a,j),T(a,e,j),T(a,p,j),T(a,sr,j),T(a,ba,j),T(a,ar,j),T(a,ja,j),T(a,lr,j),m(_a,a,j),T(a,or,j),T(a,C,j),m(Ta,C,null),l(C,wr),l(C,so),l(C,Ur),l(C,ao),l(C,xr),l(C,ze),m(Ia,ze,null),l(ze,Cr),l(ze,lo),l(ze,$r),m(ut,ze,null),l(C,kr),l(C,Xe),m(Ja,Xe,null),l(Xe,vr),l(Xe,oo),l(Xe,qr),m(mt,Xe,null),l(C,Ar),l(C,Fe),m(wa,Fe,null),l(Fe,Zr),l(Fe,io),l(Fe,Er),m(ht,Fe,null),l(C,Wr),l(C,Z),m(Ua,Z,null),l(Z,Nr),l(Z,ro),l(Z,Gr),m(dt,Z,null),l(Z,Br),m(ft,Z,null),l(Z,Qr),m(yt,Z,null),l(Z,Vr),m(Mt,Z,null),l(Z,Sr),m(bt,Z,null),l(Z,Yr),l(Z,co),l(Z,Rr),m(jt,Z,null),l(Z,zr),l(Z,po),l(Z,Xr),m(_t,Z,null),l(Z,Fr),m(Tt,Z,null),l(Z,Hr),m(It,Z,null),l(Z,Dr),m(Jt,Z,null),l(C,Or),l(C,He),m(xa,He,null),l(He,Lr),l(He,go),l(He,Pr),m(wt,He,null),l(C,Kr),l(C,De),m(Ca,De,null),l(De,ec),l(De,uo),l(De,nc),m(Ut,De,null),l(C,tc),l(C,Oe),m($a,Oe,null),l(Oe,sc),l(Oe,mo),l(Oe,ac),m(xt,Oe,null),l(C,lc),l(C,ie),m(ka,ie,null),l(ie,oc),l(ie,ho),l(ie,ic),l(ie,fo),l(ie,rc),m(Ct,ie,null),l(C,cc),l(C,re),m(va,re,null),l(re,pc),l(re,yo),l(re,gc),m($t,re,null),l(re,uc),m(kt,re,null),l(C,mc),l(C,ce),m(qa,ce,null),l(ce,hc),l(ce,Mo),l(ce,dc),l(ce,bo),l(ce,fc),m(vt,ce,null),l(C,yc),l(C,Le),m(Aa,Le,null),l(Le,Mc),l(Le,jo),l(Le,bc),m(qt,Le,null),l(C,jc),l(C,pe),m(Za,pe,null),l(pe,_c),l(pe,_o),l(pe,Tc),m(At,pe,null),l(pe,Ic),m(Zt,pe,null),l(C,Jc),l(C,ge),m(Ea,ge,null),l(ge,wc),l(ge,To),l(ge,Uc),m(Et,ge,null),l(ge,xc),m(Wt,ge,null),l(C,Cc),l(C,ue),m(Wa,ue,null),l(ue,$c),l(ue,Io),l(ue,kc),l(ue,Jo),l(ue,vc),m(Nt,ue,null),l(C,qc),l(C,L),m(Na,L,null),l(L,Ac),l(L,wo),l(L,Zc),l(L,Uo),l(L,Ec),m(Gt,L,null),l(L,Wc),m(Bt,L,null),l(L,Nc),m(Qt,L,null),l(C,Gc),l(C,me),m(Ga,me,null),l(me,Bc),l(me,xo),l(me,Qc),m(Vt,me,null),l(me,Vc),m(St,me,null),l(C,Sc),l(C,Pe),m(Ba,Pe,null),l(Pe,Yc),l(Pe,Co),l(Pe,Rc),l(Pe,$o),l(C,zc),l(C,Ke),m(Qa,Ke,null),l(Ke,Xc),l(Ke,ko),l(Ke,Fc),m(Yt,Ke,null),l(C,Hc),l(C,en),m(Va,en,null),l(en,Dc),l(en,vo),l(en,Oc),m(Rt,en,null),l(C,Lc),l(C,nn),m(Sa,nn,null),l(nn,Pc),l(nn,qo),l(nn,Kc),m(zt,nn,null),l(C,ep),l(C,tn),m(Ya,tn,null),l(tn,np),l(tn,Ao),l(tn,tp),m(Xt,tn,null),l(C,sp),l(C,sn),m(Ra,sn,null),l(sn,ap),l(sn,Zo),l(sn,lp),m(Ft,sn,null),l(C,op),l(C,an),m(za,an,null),l(an,ip),l(an,Eo),l(an,rp),m(Ht,an,null),l(C,cp),l(C,ln),m(Xa,ln,null),l(ln,pp),l(ln,Wo),l(ln,gp),m(Dt,ln,null),l(C,up),l(C,he),m(Fa,he,null),l(he,mp),l(he,No),l(he,hp),m(Ot,he,null),l(he,dp),m(Lt,he,null),l(C,fp),l(C,B),m(Ha,B,null),l(B,yp),l(B,Go),l(B,Mp),m(Pt,B,null),l(B,bp),m(Kt,B,null),l(B,jp),m(es,B,null),l(B,_p),l(B,Bo),l(B,Tp),m(ns,B,null),l(C,Ip),l(C,Q),m(Da,Q,null),l(Q,Jp),l(Q,Qo),l(Q,wp),m(ts,Q,null),l(Q,Up),l(Q,Vo),l(Q,xp),m(ss,Q,null),l(Q,Cp),l(Q,So),l(Q,$p),m(as,Q,null),l(C,kp),l(C,V),m(Oa,V,null),l(V,vp),l(V,Yo),l(V,qp),l(V,Ro),l(V,Ap),l(V,zo),l(V,Zp),m(ls,V,null),l(V,Ep),l(V,Xo),l(V,Wp),m(os,V,null),l(C,Np),l(C,on),m(La,on,null),l(on,Gp),l(on,Fo),l(on,Bp),m(is,on,null),l(C,Qp),l(C,te),m(Pa,te,null),l(te,Vp),l(te,Ho),l(te,Sp),l(te,Do),l(te,Yp),m(rs,te,null),l(te,Rp),m(cs,te,null),l(C,zp),l(C,rn),m(Ka,rn,null),l(rn,Xp),l(rn,Oo),l(rn,Fp),m(ps,rn,null),l(C,Hp),l(C,de),m(el,de,null),l(de,Dp),l(de,Lo),l(de,Op),m(gs,de,null),l(de,Lp),m(us,de,null),l(C,Pp),l(C,cn),m(nl,cn,null),l(cn,Kp),l(cn,Po),l(cn,eg),m(ms,cn,null),T(a,ir,j),m(tl,a,j),T(a,rr,j),T(a,sl,j),T(a,cr,j),m(al,a,j),T(a,pr,j),T(a,x,j),m(ll,x,null),l(x,ng),l(x,Ko),l(x,tg),l(x,ei),l(x,sg),l(x,pn),m(ol,pn,null),l(pn,ag),l(pn,ni),l(pn,lg),m(hs,pn,null),l(x,og),l(x,gn),m(il,gn,null),l(gn,ig),l(gn,ti),l(gn,rg),m(ds,gn,null),l(x,cg),l(x,un),m(rl,un,null),l(un,pg),l(un,si),l(un,gg),m(fs,un,null),l(x,ug),l(x,E),m(cl,E,null),l(E,mg),l(E,ai),l(E,hg),m(ys,E,null),l(E,dg),m(Ms,E,null),l(E,fg),m(bs,E,null),l(E,yg),m(js,E,null),l(E,Mg),m(_s,E,null),l(E,bg),l(E,li),l(E,jg),m(Ts,E,null),l(E,_g),l(E,oi),l(E,Tg),m(Is,E,null),l(E,Ig),m(Js,E,null),l(E,Jg),m(ws,E,null),l(E,wg),m(Us,E,null),l(x,Ug),l(x,fe),m(pl,fe,null),l(fe,xg),l(fe,ii),l(fe,Cg),l(fe,ri),l(fe,$g),l(fe,ci),l(x,kg),l(x,mn),m(gl,mn,null),l(mn,vg),l(mn,pi),l(mn,qg),m(xs,mn,null),l(x,Ag),l(x,hn),m(ul,hn,null),l(hn,Zg),l(hn,gi),l(hn,Eg),m(Cs,hn,null),l(x,Wg),l(x,dn),m(ml,dn,null),l(dn,Ng),l(dn,ui),l(dn,Gg),m($s,dn,null),l(x,Bg),l(x,ye),m(hl,ye,null),l(ye,Qg),l(ye,mi),l(ye,Vg),l(ye,hi),l(ye,Sg),m(ks,ye,null),l(x,Yg),l(x,Me),m(dl,Me,null),l(Me,Rg),l(Me,di),l(Me,zg),m(vs,Me,null),l(Me,Xg),m(qs,Me,null),l(x,Fg),l(x,be),m(fl,be,null),l(be,Hg),l(be,fi),l(be,Dg),l(be,yi),l(be,Og),m(As,be,null),l(x,Lg),l(x,fn),m(yl,fn,null),l(fn,Pg),l(fn,Mi),l(fn,Kg),m(Zs,fn,null),l(x,eu),l(x,je),m(Ml,je,null),l(je,nu),l(je,bi),l(je,tu),m(Es,je,null),l(je,su),m(Ws,je,null),l(x,au),l(x,_e),m(bl,_e,null),l(_e,lu),l(_e,ji),l(_e,ou),m(Ns,_e,null),l(_e,iu),m(Gs,_e,null),l(x,ru),l(x,Te),m(jl,Te,null),l(Te,cu),l(Te,_i),l(Te,pu),l(Te,Ti),l(Te,gu),m(Bs,Te,null),l(x,uu),l(x,P),m(_l,P,null),l(P,mu),l(P,Ii),l(P,hu),l(P,Ji),l(P,du),m(Qs,P,null),l(P,fu),m(Vs,P,null),l(P,yu),m(Ss,P,null),l(x,Mu),l(x,Ie),m(Tl,Ie,null),l(Ie,bu),l(Ie,wi),l(Ie,ju),m(Ys,Ie,null),l(Ie,_u),m(Rs,Ie,null),l(x,Tu),l(x,yn),m(Il,yn,null),l(yn,Iu),l(yn,Ui),l(yn,Ju),l(yn,xi),l(x,wu),l(x,Mn),m(Jl,Mn,null),l(Mn,Uu),l(Mn,Ci),l(Mn,xu),m(zs,Mn,null),l(x,Cu),l(x,bn),m(wl,bn,null),l(bn,$u),l(bn,$i),l(bn,ku),m(Xs,bn,null),l(x,vu),l(x,jn),m(Ul,jn,null),l(jn,qu),l(jn,ki),l(jn,Au),m(Fs,jn,null),l(x,Zu),l(x,_n),m(xl,_n,null),l(_n,Eu),l(_n,vi),l(_n,Wu),m(Hs,_n,null),l(x,Nu),l(x,Tn),m(Cl,Tn,null),l(Tn,Gu),l(Tn,qi),l(Tn,Bu),m(Ds,Tn,null),l(x,Qu),l(x,In),m($l,In,null),l(In,Vu),l(In,Ai),l(In,Su),m(Os,In,null),l(x,Yu),l(x,Jn),m(kl,Jn,null),l(Jn,Ru),l(Jn,Zi),l(Jn,zu),m(Ls,Jn,null),l(x,Xu),l(x,Je),m(vl,Je,null),l(Je,Fu),l(Je,Ei),l(Je,Hu),m(Ps,Je,null),l(Je,Du),m(Ks,Je,null),l(x,Ou),l(x,S),m(ql,S,null),l(S,Lu),l(S,Wi),l(S,Pu),m(ea,S,null),l(S,Ku),m(na,S,null),l(S,em),m(ta,S,null),l(S,nm),l(S,Ni),l(S,tm),m(sa,S,null),l(x,sm),l(x,Y),m(Al,Y,null),l(Y,am),l(Y,Gi),l(Y,lm),m(aa,Y,null),l(Y,om),l(Y,Bi),l(Y,im),m(la,Y,null),l(Y,rm),l(Y,Qi),l(Y,cm),m(oa,Y,null),l(x,pm),l(x,R),m(Zl,R,null),l(R,gm),l(R,Vi),l(R,um),l(R,Si),l(R,mm),l(R,Yi),l(R,hm),m(ia,R,null),l(R,dm),l(R,Ri),l(R,fm),m(ra,R,null),l(x,ym),l(x,wn),m(El,wn,null),l(wn,Mm),l(wn,zi),l(wn,bm),m(ca,wn,null),l(x,jm),l(x,se),m(Wl,se,null),l(se,_m),l(se,Xi),l(se,Tm),l(se,Fi),l(se,Im),m(pa,se,null),l(se,Jm),m(ga,se,null),l(x,wm),l(x,Un),m(Nl,Un,null),l(Un,Um),l(Un,Hi),l(Un,xm),m(ua,Un,null),l(x,Cm),l(x,we),m(Gl,we,null),l(we,$m),l(we,Di),l(we,km),m(ma,we,null),l(we,vm),m(ha,we,null),l(x,qm),l(x,xn),m(Bl,xn,null),l(xn,Am),l(xn,Oi),l(xn,Zm),m(da,xn,null),T(a,gr,j),m(Ql,a,j),T(a,ur,j),T(a,Cn,j),m(Vl,Cn,null),l(Cn,Em),l(Cn,Li),T(a,mr,j),m(Sl,a,j),T(a,hr,j),T(a,Yl,j),T(a,dr,j),m(Rl,a,j),T(a,fr,j),T(a,$n,j),m(zl,$n,null),l($n,Wm),l($n,Pi),T(a,yr,j),m(Xl,a,j),T(a,Mr,j),T(a,Fl,j),T(a,br,j),T(a,K,j),m(Hl,K,null),l(K,Nm),l(K,Ki),l(K,Gm),m(fa,K,null),l(K,Bm),l(K,ya),m(Dl,ya,null),l(ya,Qm),l(ya,er),l(K,Vm),l(K,Ma),m(Ol,Ma,null),l(Ma,Sm),l(Ma,nr),T(a,jr,j),m(Ll,a,j),T(a,_r,j),T(a,tr,j),Tr=!0},p(a,[j]){const q={};j&2&&(q.$$scope={dirty:j,ctx:a}),ut.$set(q);const kn={};j&2&&(kn.$$scope={dirty:j,ctx:a}),mt.$set(kn);const vn={};j&2&&(vn.$$scope={dirty:j,ctx:a}),ht.$set(vn);const qn={};j&2&&(qn.$$scope={dirty:j,ctx:a}),dt.$set(qn);const W={};j&2&&(W.$$scope={dirty:j,ctx:a}),ft.$set(W);const An={};j&2&&(An.$$scope={dirty:j,ctx:a}),yt.$set(An);const Zn={};j&2&&(Zn.$$scope={dirty:j,ctx:a}),Mt.$set(Zn);const En={};j&2&&(En.$$scope={dirty:j,ctx:a}),bt.$set(En);const Ue={};j&2&&(Ue.$$scope={dirty:j,ctx:a}),jt.$set(Ue);const xe={};j&2&&(xe.$$scope={dirty:j,ctx:a}),_t.$set(xe);const Ce={};j&2&&(Ce.$$scope={dirty:j,ctx:a}),Tt.$set(Ce);const Wn={};j&2&&(Wn.$$scope={dirty:j,ctx:a}),It.$set(Wn);const $e={};j&2&&($e.$$scope={dirty:j,ctx:a}),Jt.$set($e);const ke={};j&2&&(ke.$$scope={dirty:j,ctx:a}),wt.$set(ke);const ve={};j&2&&(ve.$$scope={dirty:j,ctx:a}),Ut.$set(ve);const ee={};j&2&&(ee.$$scope={dirty:j,ctx:a}),xt.$set(ee);const qe={};j&2&&(qe.$$scope={dirty:j,ctx:a}),Ct.$set(qe);const Nn={};j&2&&(Nn.$$scope={dirty:j,ctx:a}),$t.$set(Nn);const Gn={};j&2&&(Gn.$$scope={dirty:j,ctx:a}),kt.$set(Gn);const Bn={};j&2&&(Bn.$$scope={dirty:j,ctx:a}),vt.$set(Bn);const Qn={};j&2&&(Qn.$$scope={dirty:j,ctx:a}),qt.$set(Qn);const Vn={};j&2&&(Vn.$$scope={dirty:j,ctx:a}),At.$set(Vn);const Sn={};j&2&&(Sn.$$scope={dirty:j,ctx:a}),Zt.$set(Sn);const Yn={};j&2&&(Yn.$$scope={dirty:j,ctx:a}),Et.$set(Yn);const Rn={};j&2&&(Rn.$$scope={dirty:j,ctx:a}),Wt.$set(Rn);const Ae={};j&2&&(Ae.$$scope={dirty:j,ctx:a}),Nt.$set(Ae);const z={};j&2&&(z.$$scope={dirty:j,ctx:a}),Gt.$set(z);const X={};j&2&&(X.$$scope={dirty:j,ctx:a}),Bt.$set(X);const F={};j&2&&(F.$$scope={dirty:j,ctx:a}),Qt.$set(F);const zn={};j&2&&(zn.$$scope={dirty:j,ctx:a}),Vt.$set(zn);const ae={};j&2&&(ae.$$scope={dirty:j,ctx:a}),St.$set(ae);const Xn={};j&2&&(Xn.$$scope={dirty:j,ctx:a}),Yt.$set(Xn);const Ze={};j&2&&(Ze.$$scope={dirty:j,ctx:a}),Rt.$set(Ze);const Fn={};j&2&&(Fn.$$scope={dirty:j,ctx:a}),zt.$set(Fn);const $={};j&2&&($.$$scope={dirty:j,ctx:a}),Xt.$set($);const Hn={};j&2&&(Hn.$$scope={dirty:j,ctx:a}),Ft.$set(Hn);const Dn={};j&2&&(Dn.$$scope={dirty:j,ctx:a}),Ht.$set(Dn);const On={};j&2&&(On.$$scope={dirty:j,ctx:a}),Dt.$set(On);const N={};j&2&&(N.$$scope={dirty:j,ctx:a}),Ot.$set(N);const Ee={};j&2&&(Ee.$$scope={dirty:j,ctx:a}),Lt.$set(Ee);const Ln={};j&2&&(Ln.$$scope={dirty:j,ctx:a}),Pt.$set(Ln);const Pn={};j&2&&(Pn.$$scope={dirty:j,ctx:a}),Kt.$set(Pn);const Kn={};j&2&&(Kn.$$scope={dirty:j,ctx:a}),es.$set(Kn);const We={};j&2&&(We.$$scope={dirty:j,ctx:a}),ns.$set(We);const Ne={};j&2&&(Ne.$$scope={dirty:j,ctx:a}),ts.$set(Ne);const Ge={};j&2&&(Ge.$$scope={dirty:j,ctx:a}),ss.$set(Ge);const et={};j&2&&(et.$$scope={dirty:j,ctx:a}),as.$set(et);const Be={};j&2&&(Be.$$scope={dirty:j,ctx:a}),ls.$set(Be);const Qe={};j&2&&(Qe.$$scope={dirty:j,ctx:a}),os.$set(Qe);const Ve={};j&2&&(Ve.$$scope={dirty:j,ctx:a}),is.$set(Ve);const ne={};j&2&&(ne.$$scope={dirty:j,ctx:a}),rs.$set(ne);const Se={};j&2&&(Se.$$scope={dirty:j,ctx:a}),cs.$set(Se);const nt={};j&2&&(nt.$$scope={dirty:j,ctx:a}),ps.$set(nt);const tt={};j&2&&(tt.$$scope={dirty:j,ctx:a}),gs.$set(tt);const st={};j&2&&(st.$$scope={dirty:j,ctx:a}),us.$set(st);const at={};j&2&&(at.$$scope={dirty:j,ctx:a}),ms.$set(at);const lt={};j&2&&(lt.$$scope={dirty:j,ctx:a}),hs.$set(lt);const ot={};j&2&&(ot.$$scope={dirty:j,ctx:a}),ds.$set(ot);const it={};j&2&&(it.$$scope={dirty:j,ctx:a}),fs.$set(it);const rt={};j&2&&(rt.$$scope={dirty:j,ctx:a}),ys.$set(rt);const Ye={};j&2&&(Ye.$$scope={dirty:j,ctx:a}),Ms.$set(Ye);const H={};j&2&&(H.$$scope={dirty:j,ctx:a}),bs.$set(H);const D={};j&2&&(D.$$scope={dirty:j,ctx:a}),js.$set(D);const O={};j&2&&(O.$$scope={dirty:j,ctx:a}),_s.$set(O);const ct={};j&2&&(ct.$$scope={dirty:j,ctx:a}),Ts.$set(ct);const le={};j&2&&(le.$$scope={dirty:j,ctx:a}),Is.$set(le);const pt={};j&2&&(pt.$$scope={dirty:j,ctx:a}),Js.$set(pt);const Re={};j&2&&(Re.$$scope={dirty:j,ctx:a}),ws.$set(Re);const gt={};j&2&&(gt.$$scope={dirty:j,ctx:a}),Us.$set(gt);const Pl={};j&2&&(Pl.$$scope={dirty:j,ctx:a}),xs.$set(Pl);const Kl={};j&2&&(Kl.$$scope={dirty:j,ctx:a}),Cs.$set(Kl);const oe={};j&2&&(oe.$$scope={dirty:j,ctx:a}),$s.$set(oe);const eo={};j&2&&(eo.$$scope={dirty:j,ctx:a}),ks.$set(eo);const no={};j&2&&(no.$$scope={dirty:j,ctx:a}),vs.$set(no);const Fd={};j&2&&(Fd.$$scope={dirty:j,ctx:a}),qs.$set(Fd);const Hd={};j&2&&(Hd.$$scope={dirty:j,ctx:a}),As.$set(Hd);const Dd={};j&2&&(Dd.$$scope={dirty:j,ctx:a}),Zs.$set(Dd);const Od={};j&2&&(Od.$$scope={dirty:j,ctx:a}),Es.$set(Od);const Ld={};j&2&&(Ld.$$scope={dirty:j,ctx:a}),Ws.$set(Ld);const Pd={};j&2&&(Pd.$$scope={dirty:j,ctx:a}),Ns.$set(Pd);const Kd={};j&2&&(Kd.$$scope={dirty:j,ctx:a}),Gs.$set(Kd);const ef={};j&2&&(ef.$$scope={dirty:j,ctx:a}),Bs.$set(ef);const nf={};j&2&&(nf.$$scope={dirty:j,ctx:a}),Qs.$set(nf);const tf={};j&2&&(tf.$$scope={dirty:j,ctx:a}),Vs.$set(tf);const sf={};j&2&&(sf.$$scope={dirty:j,ctx:a}),Ss.$set(sf);const af={};j&2&&(af.$$scope={dirty:j,ctx:a}),Ys.$set(af);const lf={};j&2&&(lf.$$scope={dirty:j,ctx:a}),Rs.$set(lf);const of={};j&2&&(of.$$scope={dirty:j,ctx:a}),zs.$set(of);const rf={};j&2&&(rf.$$scope={dirty:j,ctx:a}),Xs.$set(rf);const cf={};j&2&&(cf.$$scope={dirty:j,ctx:a}),Fs.$set(cf);const pf={};j&2&&(pf.$$scope={dirty:j,ctx:a}),Hs.$set(pf);const gf={};j&2&&(gf.$$scope={dirty:j,ctx:a}),Ds.$set(gf);const uf={};j&2&&(uf.$$scope={dirty:j,ctx:a}),Os.$set(uf);const mf={};j&2&&(mf.$$scope={dirty:j,ctx:a}),Ls.$set(mf);const hf={};j&2&&(hf.$$scope={dirty:j,ctx:a}),Ps.$set(hf);const df={};j&2&&(df.$$scope={dirty:j,ctx:a}),Ks.$set(df);const ff={};j&2&&(ff.$$scope={dirty:j,ctx:a}),ea.$set(ff);const yf={};j&2&&(yf.$$scope={dirty:j,ctx:a}),na.$set(yf);const Mf={};j&2&&(Mf.$$scope={dirty:j,ctx:a}),ta.$set(Mf);const bf={};j&2&&(bf.$$scope={dirty:j,ctx:a}),sa.$set(bf);const jf={};j&2&&(jf.$$scope={dirty:j,ctx:a}),aa.$set(jf);const _f={};j&2&&(_f.$$scope={dirty:j,ctx:a}),la.$set(_f);const Tf={};j&2&&(Tf.$$scope={dirty:j,ctx:a}),oa.$set(Tf);const If={};j&2&&(If.$$scope={dirty:j,ctx:a}),ia.$set(If);const Jf={};j&2&&(Jf.$$scope={dirty:j,ctx:a}),ra.$set(Jf);const wf={};j&2&&(wf.$$scope={dirty:j,ctx:a}),ca.$set(wf);const Uf={};j&2&&(Uf.$$scope={dirty:j,ctx:a}),pa.$set(Uf);const xf={};j&2&&(xf.$$scope={dirty:j,ctx:a}),ga.$set(xf);const Cf={};j&2&&(Cf.$$scope={dirty:j,ctx:a}),ua.$set(Cf);const $f={};j&2&&($f.$$scope={dirty:j,ctx:a}),ma.$set($f);const kf={};j&2&&(kf.$$scope={dirty:j,ctx:a}),ha.$set(kf);const vf={};j&2&&(vf.$$scope={dirty:j,ctx:a}),da.$set(vf);const qf={};j&2&&(qf.$$scope={dirty:j,ctx:a}),fa.$set(qf)},i(a){Tr||(h(o.$$.fragment,a),h(_a.$$.fragment,a),h(Ta.$$.fragment,a),h(Ia.$$.fragment,a),h(ut.$$.fragment,a),h(Ja.$$.fragment,a),h(mt.$$.fragment,a),h(wa.$$.fragment,a),h(ht.$$.fragment,a),h(Ua.$$.fragment,a),h(dt.$$.fragment,a),h(ft.$$.fragment,a),h(yt.$$.fragment,a),h(Mt.$$.fragment,a),h(bt.$$.fragment,a),h(jt.$$.fragment,a),h(_t.$$.fragment,a),h(Tt.$$.fragment,a),h(It.$$.fragment,a),h(Jt.$$.fragment,a),h(xa.$$.fragment,a),h(wt.$$.fragment,a),h(Ca.$$.fragment,a),h(Ut.$$.fragment,a),h($a.$$.fragment,a),h(xt.$$.fragment,a),h(ka.$$.fragment,a),h(Ct.$$.fragment,a),h(va.$$.fragment,a),h($t.$$.fragment,a),h(kt.$$.fragment,a),h(qa.$$.fragment,a),h(vt.$$.fragment,a),h(Aa.$$.fragment,a),h(qt.$$.fragment,a),h(Za.$$.fragment,a),h(At.$$.fragment,a),h(Zt.$$.fragment,a),h(Ea.$$.fragment,a),h(Et.$$.fragment,a),h(Wt.$$.fragment,a),h(Wa.$$.fragment,a),h(Nt.$$.fragment,a),h(Na.$$.fragment,a),h(Gt.$$.fragment,a),h(Bt.$$.fragment,a),h(Qt.$$.fragment,a),h(Ga.$$.fragment,a),h(Vt.$$.fragment,a),h(St.$$.fragment,a),h(Ba.$$.fragment,a),h(Qa.$$.fragment,a),h(Yt.$$.fragment,a),h(Va.$$.fragment,a),h(Rt.$$.fragment,a),h(Sa.$$.fragment,a),h(zt.$$.fragment,a),h(Ya.$$.fragment,a),h(Xt.$$.fragment,a),h(Ra.$$.fragment,a),h(Ft.$$.fragment,a),h(za.$$.fragment,a),h(Ht.$$.fragment,a),h(Xa.$$.fragment,a),h(Dt.$$.fragment,a),h(Fa.$$.fragment,a),h(Ot.$$.fragment,a),h(Lt.$$.fragment,a),h(Ha.$$.fragment,a),h(Pt.$$.fragment,a),h(Kt.$$.fragment,a),h(es.$$.fragment,a),h(ns.$$.fragment,a),h(Da.$$.fragment,a),h(ts.$$.fragment,a),h(ss.$$.fragment,a),h(as.$$.fragment,a),h(Oa.$$.fragment,a),h(ls.$$.fragment,a),h(os.$$.fragment,a),h(La.$$.fragment,a),h(is.$$.fragment,a),h(Pa.$$.fragment,a),h(rs.$$.fragment,a),h(cs.$$.fragment,a),h(Ka.$$.fragment,a),h(ps.$$.fragment,a),h(el.$$.fragment,a),h(gs.$$.fragment,a),h(us.$$.fragment,a),h(nl.$$.fragment,a),h(ms.$$.fragment,a),h(tl.$$.fragment,a),h(al.$$.fragment,a),h(ll.$$.fragment,a),h(ol.$$.fragment,a),h(hs.$$.fragment,a),h(il.$$.fragment,a),h(ds.$$.fragment,a),h(rl.$$.fragment,a),h(fs.$$.fragment,a),h(cl.$$.fragment,a),h(ys.$$.fragment,a),h(Ms.$$.fragment,a),h(bs.$$.fragment,a),h(js.$$.fragment,a),h(_s.$$.fragment,a),h(Ts.$$.fragment,a),h(Is.$$.fragment,a),h(Js.$$.fragment,a),h(ws.$$.fragment,a),h(Us.$$.fragment,a),h(pl.$$.fragment,a),h(gl.$$.fragment,a),h(xs.$$.fragment,a),h(ul.$$.fragment,a),h(Cs.$$.fragment,a),h(ml.$$.fragment,a),h($s.$$.fragment,a),h(hl.$$.fragment,a),h(ks.$$.fragment,a),h(dl.$$.fragment,a),h(vs.$$.fragment,a),h(qs.$$.fragment,a),h(fl.$$.fragment,a),h(As.$$.fragment,a),h(yl.$$.fragment,a),h(Zs.$$.fragment,a),h(Ml.$$.fragment,a),h(Es.$$.fragment,a),h(Ws.$$.fragment,a),h(bl.$$.fragment,a),h(Ns.$$.fragment,a),h(Gs.$$.fragment,a),h(jl.$$.fragment,a),h(Bs.$$.fragment,a),h(_l.$$.fragment,a),h(Qs.$$.fragment,a),h(Vs.$$.fragment,a),h(Ss.$$.fragment,a),h(Tl.$$.fragment,a),h(Ys.$$.fragment,a),h(Rs.$$.fragment,a),h(Il.$$.fragment,a),h(Jl.$$.fragment,a),h(zs.$$.fragment,a),h(wl.$$.fragment,a),h(Xs.$$.fragment,a),h(Ul.$$.fragment,a),h(Fs.$$.fragment,a),h(xl.$$.fragment,a),h(Hs.$$.fragment,a),h(Cl.$$.fragment,a),h(Ds.$$.fragment,a),h($l.$$.fragment,a),h(Os.$$.fragment,a),h(kl.$$.fragment,a),h(Ls.$$.fragment,a),h(vl.$$.fragment,a),h(Ps.$$.fragment,a),h(Ks.$$.fragment,a),h(ql.$$.fragment,a),h(ea.$$.fragment,a),h(na.$$.fragment,a),h(ta.$$.fragment,a),h(sa.$$.fragment,a),h(Al.$$.fragment,a),h(aa.$$.fragment,a),h(la.$$.fragment,a),h(oa.$$.fragment,a),h(Zl.$$.fragment,a),h(ia.$$.fragment,a),h(ra.$$.fragment,a),h(El.$$.fragment,a),h(ca.$$.fragment,a),h(Wl.$$.fragment,a),h(pa.$$.fragment,a),h(ga.$$.fragment,a),h(Nl.$$.fragment,a),h(ua.$$.fragment,a),h(Gl.$$.fragment,a),h(ma.$$.fragment,a),h(ha.$$.fragment,a),h(Bl.$$.fragment,a),h(da.$$.fragment,a),h(Ql.$$.fragment,a),h(Vl.$$.fragment,a),h(Sl.$$.fragment,a),h(Rl.$$.fragment,a),h(zl.$$.fragment,a),h(Xl.$$.fragment,a),h(Hl.$$.fragment,a),h(fa.$$.fragment,a),h(Dl.$$.fragment,a),h(Ol.$$.fragment,a),h(Ll.$$.fragment,a),Tr=!0)},o(a){d(o.$$.fragment,a),d(_a.$$.fragment,a),d(Ta.$$.fragment,a),d(Ia.$$.fragment,a),d(ut.$$.fragment,a),d(Ja.$$.fragment,a),d(mt.$$.fragment,a),d(wa.$$.fragment,a),d(ht.$$.fragment,a),d(Ua.$$.fragment,a),d(dt.$$.fragment,a),d(ft.$$.fragment,a),d(yt.$$.fragment,a),d(Mt.$$.fragment,a),d(bt.$$.fragment,a),d(jt.$$.fragment,a),d(_t.$$.fragment,a),d(Tt.$$.fragment,a),d(It.$$.fragment,a),d(Jt.$$.fragment,a),d(xa.$$.fragment,a),d(wt.$$.fragment,a),d(Ca.$$.fragment,a),d(Ut.$$.fragment,a),d($a.$$.fragment,a),d(xt.$$.fragment,a),d(ka.$$.fragment,a),d(Ct.$$.fragment,a),d(va.$$.fragment,a),d($t.$$.fragment,a),d(kt.$$.fragment,a),d(qa.$$.fragment,a),d(vt.$$.fragment,a),d(Aa.$$.fragment,a),d(qt.$$.fragment,a),d(Za.$$.fragment,a),d(At.$$.fragment,a),d(Zt.$$.fragment,a),d(Ea.$$.fragment,a),d(Et.$$.fragment,a),d(Wt.$$.fragment,a),d(Wa.$$.fragment,a),d(Nt.$$.fragment,a),d(Na.$$.fragment,a),d(Gt.$$.fragment,a),d(Bt.$$.fragment,a),d(Qt.$$.fragment,a),d(Ga.$$.fragment,a),d(Vt.$$.fragment,a),d(St.$$.fragment,a),d(Ba.$$.fragment,a),d(Qa.$$.fragment,a),d(Yt.$$.fragment,a),d(Va.$$.fragment,a),d(Rt.$$.fragment,a),d(Sa.$$.fragment,a),d(zt.$$.fragment,a),d(Ya.$$.fragment,a),d(Xt.$$.fragment,a),d(Ra.$$.fragment,a),d(Ft.$$.fragment,a),d(za.$$.fragment,a),d(Ht.$$.fragment,a),d(Xa.$$.fragment,a),d(Dt.$$.fragment,a),d(Fa.$$.fragment,a),d(Ot.$$.fragment,a),d(Lt.$$.fragment,a),d(Ha.$$.fragment,a),d(Pt.$$.fragment,a),d(Kt.$$.fragment,a),d(es.$$.fragment,a),d(ns.$$.fragment,a),d(Da.$$.fragment,a),d(ts.$$.fragment,a),d(ss.$$.fragment,a),d(as.$$.fragment,a),d(Oa.$$.fragment,a),d(ls.$$.fragment,a),d(os.$$.fragment,a),d(La.$$.fragment,a),d(is.$$.fragment,a),d(Pa.$$.fragment,a),d(rs.$$.fragment,a),d(cs.$$.fragment,a),d(Ka.$$.fragment,a),d(ps.$$.fragment,a),d(el.$$.fragment,a),d(gs.$$.fragment,a),d(us.$$.fragment,a),d(nl.$$.fragment,a),d(ms.$$.fragment,a),d(tl.$$.fragment,a),d(al.$$.fragment,a),d(ll.$$.fragment,a),d(ol.$$.fragment,a),d(hs.$$.fragment,a),d(il.$$.fragment,a),d(ds.$$.fragment,a),d(rl.$$.fragment,a),d(fs.$$.fragment,a),d(cl.$$.fragment,a),d(ys.$$.fragment,a),d(Ms.$$.fragment,a),d(bs.$$.fragment,a),d(js.$$.fragment,a),d(_s.$$.fragment,a),d(Ts.$$.fragment,a),d(Is.$$.fragment,a),d(Js.$$.fragment,a),d(ws.$$.fragment,a),d(Us.$$.fragment,a),d(pl.$$.fragment,a),d(gl.$$.fragment,a),d(xs.$$.fragment,a),d(ul.$$.fragment,a),d(Cs.$$.fragment,a),d(ml.$$.fragment,a),d($s.$$.fragment,a),d(hl.$$.fragment,a),d(ks.$$.fragment,a),d(dl.$$.fragment,a),d(vs.$$.fragment,a),d(qs.$$.fragment,a),d(fl.$$.fragment,a),d(As.$$.fragment,a),d(yl.$$.fragment,a),d(Zs.$$.fragment,a),d(Ml.$$.fragment,a),d(Es.$$.fragment,a),d(Ws.$$.fragment,a),d(bl.$$.fragment,a),d(Ns.$$.fragment,a),d(Gs.$$.fragment,a),d(jl.$$.fragment,a),d(Bs.$$.fragment,a),d(_l.$$.fragment,a),d(Qs.$$.fragment,a),d(Vs.$$.fragment,a),d(Ss.$$.fragment,a),d(Tl.$$.fragment,a),d(Ys.$$.fragment,a),d(Rs.$$.fragment,a),d(Il.$$.fragment,a),d(Jl.$$.fragment,a),d(zs.$$.fragment,a),d(wl.$$.fragment,a),d(Xs.$$.fragment,a),d(Ul.$$.fragment,a),d(Fs.$$.fragment,a),d(xl.$$.fragment,a),d(Hs.$$.fragment,a),d(Cl.$$.fragment,a),d(Ds.$$.fragment,a),d($l.$$.fragment,a),d(Os.$$.fragment,a),d(kl.$$.fragment,a),d(Ls.$$.fragment,a),d(vl.$$.fragment,a),d(Ps.$$.fragment,a),d(Ks.$$.fragment,a),d(ql.$$.fragment,a),d(ea.$$.fragment,a),d(na.$$.fragment,a),d(ta.$$.fragment,a),d(sa.$$.fragment,a),d(Al.$$.fragment,a),d(aa.$$.fragment,a),d(la.$$.fragment,a),d(oa.$$.fragment,a),d(Zl.$$.fragment,a),d(ia.$$.fragment,a),d(ra.$$.fragment,a),d(El.$$.fragment,a),d(ca.$$.fragment,a),d(Wl.$$.fragment,a),d(pa.$$.fragment,a),d(ga.$$.fragment,a),d(Nl.$$.fragment,a),d(ua.$$.fragment,a),d(Gl.$$.fragment,a),d(ma.$$.fragment,a),d(ha.$$.fragment,a),d(Bl.$$.fragment,a),d(da.$$.fragment,a),d(Ql.$$.fragment,a),d(Vl.$$.fragment,a),d(Sl.$$.fragment,a),d(Rl.$$.fragment,a),d(zl.$$.fragment,a),d(Xl.$$.fragment,a),d(Hl.$$.fragment,a),d(fa.$$.fragment,a),d(Dl.$$.fragment,a),d(Ol.$$.fragment,a),d(Ll.$$.fragment,a),Tr=!1},d(a){a&&(y(c),y(s),y(t),y(e),y(p),y(sr),y(ba),y(ar),y(ja),y(lr),y(or),y(C),y(ir),y(rr),y(sl),y(cr),y(pr),y(x),y(gr),y(ur),y(Cn),y(mr),y(hr),y(Yl),y(dr),y(fr),y($n),y(yr),y(Mr),y(Fl),y(br),y(K),y(jr),y(_r),y(tr)),y(n),f(o,a),f(_a,a),f(Ta),f(Ia),f(ut),f(Ja),f(mt),f(wa),f(ht),f(Ua),f(dt),f(ft),f(yt),f(Mt),f(bt),f(jt),f(_t),f(Tt),f(It),f(Jt),f(xa),f(wt),f(Ca),f(Ut),f($a),f(xt),f(ka),f(Ct),f(va),f($t),f(kt),f(qa),f(vt),f(Aa),f(qt),f(Za),f(At),f(Zt),f(Ea),f(Et),f(Wt),f(Wa),f(Nt),f(Na),f(Gt),f(Bt),f(Qt),f(Ga),f(Vt),f(St),f(Ba),f(Qa),f(Yt),f(Va),f(Rt),f(Sa),f(zt),f(Ya),f(Xt),f(Ra),f(Ft),f(za),f(Ht),f(Xa),f(Dt),f(Fa),f(Ot),f(Lt),f(Ha),f(Pt),f(Kt),f(es),f(ns),f(Da),f(ts),f(ss),f(as),f(Oa),f(ls),f(os),f(La),f(is),f(Pa),f(rs),f(cs),f(Ka),f(ps),f(el),f(gs),f(us),f(nl),f(ms),f(tl,a),f(al,a),f(ll),f(ol),f(hs),f(il),f(ds),f(rl),f(fs),f(cl),f(ys),f(Ms),f(bs),f(js),f(_s),f(Ts),f(Is),f(Js),f(ws),f(Us),f(pl),f(gl),f(xs),f(ul),f(Cs),f(ml),f($s),f(hl),f(ks),f(dl),f(vs),f(qs),f(fl),f(As),f(yl),f(Zs),f(Ml),f(Es),f(Ws),f(bl),f(Ns),f(Gs),f(jl),f(Bs),f(_l),f(Qs),f(Vs),f(Ss),f(Tl),f(Ys),f(Rs),f(Il),f(Jl),f(zs),f(wl),f(Xs),f(Ul),f(Fs),f(xl),f(Hs),f(Cl),f(Ds),f($l),f(Os),f(kl),f(Ls),f(vl),f(Ps),f(Ks),f(ql),f(ea),f(na),f(ta),f(sa),f(Al),f(aa),f(la),f(oa),f(Zl),f(ia),f(ra),f(El),f(ca),f(Wl),f(pa),f(ga),f(Nl),f(ua),f(Gl),f(ma),f(ha),f(Bl),f(da),f(Ql,a),f(Vl),f(Sl,a),f(Rl,a),f(zl),f(Xl,a),f(Hl),f(fa),f(Dl),f(Ol),f(Ll,a)}}}const zM='{"title":"추론","local":"inference","sections":[{"title":"추론 클라이언트","local":"huggingface_hub.InferenceClient ][ huggingface_hub.InferenceClient","sections":[],"depth":2},{"title":"비동기 추론 클라이언트","local":"huggingface_hub.AsyncInferenceClient ][ huggingface_hub.AsyncInferenceClient","sections":[],"depth":2},{"title":"추론 시간 초과 오류","local":"huggingface_hub.InferenceTimeoutError ][ huggingface_hub.InferenceTimeoutError","sections":[],"depth":2},{"title":"반환 유형","local":"return-types","sections":[{"title":"모델 상태","local":"huggingface_hub.inference._common.ModelStatus ][ huggingface_hub.inference._common.ModelStatus","sections":[],"depth":3}],"depth":2},{"title":"추론 API","local":"huggingface_hub.InferenceApi ][ huggingface_hub.InferenceApi","sections":[],"depth":2}],"depth":1}';function XM(_){return Zf(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class eb extends Ef{constructor(n){super(),Wf(this,n,XM,RM,Af,{})}}export{eb as component};
