import{s as bc,n as Mc,o as xc}from"../chunks/scheduler.b108d059.js";import{S as Cc,i as Hc,g as i,s as n,r as u,A as Lc,h as r,f as l,c as o,j as h,u as m,x as d,k as a,y as wc,a as s,v as p,d as c,t as f,w as T}from"../chunks/index.008de539.js";import{C as Nu}from"../chunks/CodeBlock.3968c746.js";import{H as _}from"../chunks/Heading.88bfeb84.js";function Ac(Bu){let $,ln,en,sn,y,nn,v,on,b,Vu="Helper module for <code>Tensor</code> processing.",rn,M,Qu=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,dn,x,Su='<li><a href="#module_utils/tensor">utils/tensor</a><ul><li><em>static</em><ul><li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li> <li><a href="#module_utils/tensor.transpose"><code>.transpose(tensor, axes)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.interpolate"><code>.interpolate(input, size, mode, align_corners)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.mean_pooling"><code>.mean_pooling(last_hidden_state, attention_mask)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.layer_norm"><code>.layer_norm(input, normalized_shape, options)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.cat"><code>.cat(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.stack"><code>.stack(tensors, dim)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.std_mean"><code>.std_mean(input, dim, correction, keepdim)</code></a> ⇒ <code>Array.&lt;Tensor&gt;</code></li> <li><a href="#module_utils/tensor.mean"><code>.mean(input, dim, keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.dynamicTimeWarping"><code>.dynamicTimeWarping(matrix)</code></a> ⇒ <code>Array.&lt;Array&lt;number&gt;&gt;</code></li> <li><a href="#module_utils/tensor.ones"><code>.ones(size)</code></a></li> <li><a href="#module_utils/tensor.ones_like"><code>.ones_like(tensor)</code></a> ⇒</li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/tensor..args%5B0%5D"><code>~args[0]</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor..args%5B1%5D"><code>~args[1]</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..reshape"><code>~reshape(data, dimensions)</code></a> ⇒ <code>*</code><ul><li><a href="#module_utils/tensor..reshape..reshapedArray"><code>~reshapedArray</code></a> : <code>any</code></li></ul></li> <li><a href="#module_utils/tensor..DataArray"><code>~DataArray</code></a> : <code>*</code></li> <li><a href="#module_utils/tensor..NestArray"><code>~NestArray</code></a> : <code>*</code></li></ul></li></ul></li>',an,un,mn,C,pn,H,cn,L,Wu='<strong>Kind</strong>: static class of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',fn,w,Yu='<li><a href="#module_utils/tensor.Tensor">.Tensor</a><ul><li><a href="#new_module_utils/tensor.Tensor_new"><code>new Tensor(...args)</code></a></li> <li><a href="#module_utils/tensor.Tensor+dims"><code>.dims</code></a> : <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+type"><code>.type</code></a> : <code>DataType</code></li> <li><a href="#module_utils/tensor.Tensor+data"><code>.data</code></a> : <code>DataArray</code></li> <li><a href="#module_utils/tensor.Tensor+size"><code>.size</code></a> : <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+Symbol.iterator"><code>.Symbol.iterator()</code></a> ⇒ <code>Iterator</code></li> <li><a href="#module_utils/tensor.Tensor+_getitem"><code>._getitem(index)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+indexOf"><code>.indexOf(item)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/tensor.Tensor+_subarray"><code>._subarray(index, iterSize, iterDims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+item"><code>.item()</code></a> ⇒ <code>number</code> | <code>bigint</code></li> <li><a href="#module_utils/tensor.Tensor+tolist"><code>.tolist()</code></a> ⇒ <code>Array</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid"><code>.sigmoid()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sigmoid_"><code>.sigmoid_()</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul"><code>.mul(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+mul_"><code>.mul_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add"><code>.add(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+add_"><code>.add_(val)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+transpose"><code>.transpose(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+sum"><code>.sum([dim], keepdim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+norm"><code>.norm([p], [dim], [keepdim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize_"><code>.normalize_([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+normalize"><code>.normalize([p], [dim])</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+stride"><code>.stride()</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/tensor.Tensor+squeeze"><code>.squeeze([dim])</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+squeeze_"><code>.squeeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+unsqueeze"><code>.unsqueeze(dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+unsqueeze_"><code>.unsqueeze_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten_"><code>.flatten_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+flatten"><code>.flatten(start_dim, end_dim)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+view"><code>.view(...dims)</code></a> ⇒ <code>Tensor</code></li> <li><a href="#module_utils/tensor.Tensor+clamp_"><code>.clamp_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+clamp"><code>.clamp(min, max)</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+round_"><code>.round_()</code></a></li> <li><a href="#module_utils/tensor.Tensor+round"><code>.round()</code></a> ⇒</li> <li><a href="#module_utils/tensor.Tensor+to"><code>.to(type)</code></a> ⇒ <code>Tensor</code></li></ul></li>',Tn,hn,_n,A,$n,g,yn,z,Fu="Create a new Tensor or copy an existing Tensor.",vn,P,Ou="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>*</code></td></tr></tbody>",bn,Mn,xn,U,Cn,R,Hn,j,Gu="Dimensions of the tensor.",Ln,E,Zu='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',wn,An,gn,J,zn,k,Pn,D,Xu="Type of the tensor.",Un,I,em='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Rn,jn,En,q,Jn,K,kn,N,tm="The data stored in the tensor.",Dn,B,lm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',In,qn,Kn,V,Nn,Q,Bn,S,sm="The number of elements in the tensor.",Vn,W,nm='<strong>Kind</strong>: instance property of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Qn,Sn,Wn,Y,Yn,F,Fn,O,om=`Returns an iterator object for iterating over the tensor data in row-major order.
If the tensor has more than one dimension, the iterator will yield subarrays.`,On,G,im='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Iterator</code> - An iterator object for iterating over the tensor data in row-major order.',Gn,Zn,Xn,Z,eo,X,to,ee,rm="Index into a Tensor object.",lo,te,dm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The data at the specified index.',so,le,am="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td><td><p>The index to access.</p></td></tr></tbody>",no,oo,io,se,ro,ne,ao,oe,um='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> - The index of the first occurrence of item in the tensor data.',uo,ie,mm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>item</td><td><code>number</code> | <code>bigint</code></td><td><p>The item to search for in the tensor</p></td></tr></tbody>",mo,po,co,re,fo,de,To,ae,pm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',ho,ue,cm="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>index</td><td><code>number</code></td> </tr><tr><td>iterSize</td><td><code>number</code></td> </tr><tr><td>iterDims</td><td><code>any</code></td></tr></tbody>",_o,$o,yo,me,vo,pe,bo,ce,fm=`Returns the value of this tensor as a standard JavaScript Number. This only works
for tensors with one element. For other cases, see <code>Tensor.tolist()</code>.`,Mo,fe,Tm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>number</code> | <code>bigint</code> - The value of this tensor as a standard JavaScript Number.<br/> <strong>Throws</strong>:',xo,Te,hm="<li><code>Error</code> If the tensor has more than one element.</li>",Co,Ho,Lo,he,wo,_e,Ao,$e,_m="Convert tensor data to a n-dimensional JS list",go,ye,$m='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',zo,Po,Uo,ve,Ro,be,jo,Me,ym="Return a new Tensor with the sigmoid function applied to each element.",Eo,xe,vm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the sigmoid function applied.',Jo,ko,Do,Ce,Io,He,qo,Le,bm="Applies the sigmoid function to the tensor in place.",Ko,we,Mm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',No,Bo,Vo,Ae,Qo,ge,So,ze,xm="Return a new Tensor with every element multiplied by a constant.",Wo,Pe,Cm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',Yo,Ue,Hm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",Fo,Oo,Go,Re,Zo,je,Xo,Ee,Lm="Multiply the tensor by a constant in place.",ei,Je,wm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',ti,ke,Am="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to multiply by.</p></td></tr></tbody>",li,si,ni,De,oi,Ie,ii,qe,gm="Return a new Tensor with every element added by a constant.",ri,Ke,zm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The new tensor.',di,Ne,Pm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",ai,ui,mi,Be,pi,Ve,ci,Qe,Um="Add the tensor by a constant in place.",fi,Se,Rm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns <code>this</code>.',Ti,We,jm="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>val</td><td><code>number</code></td><td><p>The value to add by.</p></td></tr></tbody>",hi,_i,$i,Ye,yi,Fe,vi,Oe,Em="Return a transposed version of this Tensor, according to the provided dimensions.",bi,Ge,Jm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Mi,Ze,km="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>Dimensions to transpose.</p></td></tr></tbody>",xi,Ci,Hi,Xe,Li,et,wi,tt,Dm="Returns the sum of each row of the input tensor in the given dimension dim.",Ai,lt,Im='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The summed tensor',gi,st,qm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>The dimension or dimensions to reduce. If <code>null</code>, all dimensions are reduced.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensor has <code>dim</code> retained or not.</p></td></tr></tbody>",zi,Pi,Ui,nt,Ri,ot,ji,it,Km="Returns the matrix norm or vector norm of a given tensor.",Ei,rt,Nm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The norm of the tensor.',Ji,dt,Bm=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code> | <code>string</code></td><td><code>&#39;fro&#39;</code></td><td><p>The order of norm</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>Specifies which dimension of the tensor to calculate the norm across.
If dim is None, the norm will be calculated across all dimensions of input.</p></td> </tr><tr><td>[keepdim]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether the output tensors have dim retained or not.</p></td></tr></tbody>`,ki,Di,Ii,at,qi,ut,Ki,mt,Vm="Performs <code>L_p</code> normalization of inputs over specified dimension. Operates in place.",Ni,pt,Qm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - <code>this</code> for operation chaining.',Bi,ct,Sm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Vi,Qi,Si,ft,Wi,Tt,Yi,ht,Wm="Performs <code>L_p</code> normalization of inputs over specified dimension.",Fi,_t,Ym='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',Oi,$t,Fm="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[p]</td><td><code>number</code></td><td><code>2</code></td><td><p>The exponent value in the norm formulation</p></td> </tr><tr><td>[dim]</td><td><code>number</code></td><td><code>1</code></td><td><p>The dimension to reduce</p></td></tr></tbody>",Gi,Zi,Xi,yt,er,vt,tr,bt,Om=`Compute and return the stride of this tensor.
Stride is the jump necessary to go from one element to the next one in the specified dimension dim.`,lr,Mt,Gm='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The stride of this tensor.',sr,nr,or,xt,ir,Ct,rr,Ht,Zm="Returns a tensor with all specified dimensions of input of size 1 removed.",dr,Lt,Xm=`NOTE: The returned tensor shares the storage with the input tensor, so changing the contents of one will change the contents of the other.
If you would like a copy, use <code>tensor.clone()</code> before squeezing.`,ar,wt,ep='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The squeezed tensor',ur,At,tp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>[dim]</td><td><code>number</code></td><td><code></code></td><td><p>If given, the input will be squeezed only in the specified dimensions.</p></td></tr></tbody>",mr,pr,cr,gt,fr,zt,Tr,Pt,lp='In-place version of @see <a href="Tensor.squeeze">Tensor.squeeze</a>',hr,Ut,sp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',_r,$r,yr,Rt,vr,jt,br,Et,np="Returns a new tensor with a dimension of size one inserted at the specified position.",Mr,Jt,op="NOTE: The returned tensor shares the same underlying data with this tensor.",xr,kt,ip='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The unsqueezed tensor',Cr,Dt,rp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>dim</td><td><code>number</code></td><td><code></code></td><td><p>The index at which to insert the singleton dimension</p></td></tr></tbody>",Hr,Lr,wr,It,Ar,qt,gr,Kt,dp='In-place version of @see <a href="Tensor.unsqueeze">Tensor.unsqueeze</a>',zr,Nt,ap='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',Pr,Ur,Rr,Bt,jr,Vt,Er,Qt,up='In-place version of @see <a href="Tensor.flatten">Tensor.flatten</a>',Jr,St,mp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',kr,Dr,Ir,Wt,qr,Yt,Kr,Ft,pp=`Flattens input by reshaping it into a one-dimensional tensor.
If <code>start_dim</code> or <code>end_dim</code> are passed, only dimensions starting with <code>start_dim</code>
and ending with <code>end_dim</code> are flattened. The order of elements in input is unchanged.`,Nr,Ot,cp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: The flattened tensor.',Br,Gt,fp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>start_dim</td><td><code>number</code></td><td><code>0</code></td><td><p>the first dim to flatten</p></td> </tr><tr><td>end_dim</td><td><code>number</code></td><td></td><td><p>the last dim to flatten</p></td></tr></tbody>",Vr,Qr,Sr,Zt,Wr,Xt,Yr,el,Tp="Returns a new tensor with the same data as the <code>self</code> tensor but of a different <code>shape</code>.",Fr,tl,hp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The tensor with the same data but different shape',Or,ll,_p="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>...dims</td><td><code>number</code></td><td><p>the desired size</p></td></tr></tbody>",Gr,Zr,Xr,sl,ed,nl,td,ol,$p='In-place version of @see <a href="Tensor.clamp">Tensor.clamp</a>',ld,il,yp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',sd,nd,od,rl,id,dl,rd,al,vp="Clamps all elements in input into the range [ min, max ]",dd,ul,bp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',ad,ml,Mp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>min</td><td><code>number</code></td><td><p>lower-bound of the range to be clamped to</p></td> </tr><tr><td>max</td><td><code>number</code></td><td><p>upper-bound of the range to be clamped to</p></td></tr></tbody>",ud,md,pd,pl,cd,cl,fd,fl,xp='In-place version of @see <a href="Tensor.round">Tensor.round</a>',Td,Tl,Cp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a>',hd,_d,$d,hl,yd,_l,vd,$l,Hp="Rounds elements of input to the nearest integer.",bd,yl,Lp='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: the output tensor.',Md,xd,Cd,vl,Hd,bl,Ld,Ml,wp="Performs Tensor dtype conversion.",wd,xl,Ap='<strong>Kind</strong>: instance method of <a href="#module_utils/tensor.Tensor"><code>Tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The converted tensor.',Ad,Cl,gp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>type</td><td><code>DataType</code></td><td><p>The desired data type.</p></td></tr></tbody>",gd,zd,Pd,Hl,Ud,Ll,Rd,wl,zp="Transposes a tensor according to the provided axes.",jd,Al,Pp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The transposed tensor.',Ed,gl,Up="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>any</code></td><td><p>The input tensor to transpose.</p></td> </tr><tr><td>axes</td><td><code>Array</code></td><td><p>The axes to transpose the tensor along.</p></td></tr></tbody>",Jd,kd,Dd,zl,Id,Pl,qd,Ul,Rp="Interpolates an Tensor to the given size.",Kd,Rl,jp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The interpolated tensor.',Nd,jl,Ep="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>The input tensor to interpolate. Data must be channel-first (i.e., [c, h, w])</p></td> </tr><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>The output size of the image</p></td> </tr><tr><td>mode</td><td><code>string</code></td><td><p>The interpolation mode</p></td> </tr><tr><td>align_corners</td><td><code>boolean</code></td><td><p>Whether to align corners.</p></td></tr></tbody>",Bd,Vd,Qd,El,Sd,Jl,Wd,kl,Jp="Perform mean pooling of the last hidden state followed by a normalization step.",Yd,Dl,kp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - Returns a new Tensor of shape [batchSize, embedDim].',Fd,Il,Dp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>last_hidden_state</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength, embedDim]</p></td> </tr><tr><td>attention_mask</td><td><code>Tensor</code></td><td><p>Tensor of shape [batchSize, seqLength]</p></td></tr></tbody>",Od,Gd,Zd,ql,Xd,Kl,ea,Nl,Ip="Apply Layer Normalization for last certain number of dimensions.",ta,Bl,qp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The normalized tensor.',la,Vl,Kp="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td></td><td><p>The input tensor</p></td> </tr><tr><td>normalized_shape</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>input shape from an expected input of size</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for the layer normalization</p></td> </tr><tr><td>[options.eps]</td><td><code>number</code></td><td><code>1e-5</code></td><td><p>A value added to the denominator for numerical stability.</p></td></tr></tbody>",sa,na,oa,Ql,ia,Sl,ra,Wl,Np="Concatenates an array of tensors along a specified dimension.",da,Yl,Bp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The concatenated tensor.',aa,Fl,Vp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to concatenate.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to concatenate along.</p></td></tr></tbody>",ua,ma,pa,Ol,ca,Gl,fa,Zl,Qp="Stack an array of tensors along a specified dimension.",Ta,Xl,Sp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Tensor</code> - The stacked tensor.',ha,es,Wp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensors</td><td><code>Array.&lt;Tensor&gt;</code></td><td><p>The array of tensors to stack.</p></td> </tr><tr><td>dim</td><td><code>number</code></td><td><p>The dimension to stack along.</p></td></tr></tbody>",_a,$a,ya,ts,va,ls,ba,ss,Yp="Calculates the standard deviation and mean over the dimensions specified by dim. dim can be a single dimension or <code>null</code> to reduce over all dimensions.",Ma,ns,Fp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;Tensor&gt;</code> - A tuple of (std, mean) tensors.',xa,os,Op="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tenso</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce. If None, all dimensions are reduced.</p></td> </tr><tr><td>correction</td><td><code>number</code></td><td><p>difference between the sample size and sample degrees of freedom. Defaults to Bessel&#39;s correction, correction=1.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Ca,Ha,La,is,wa,rs,Aa,ds,Gp="Returns the mean value of each row of the input tensor in the given dimension dim.",ga,as,Zp='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: A new tensor with means taken along the specified dimension.',za,us,Xp="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Tensor</code></td><td><p>the input tensor.</p></td> </tr><tr><td>dim</td><td><code>number</code> | <code>null</code></td><td><p>the dimension to reduce.</p></td> </tr><tr><td>keepdim</td><td><code>boolean</code></td><td><p>whether the output tensor has dim retained or not.</p></td></tr></tbody>",Pa,Ua,Ra,ms,ja,ps,Ea,cs,ec=`Measures similarity between two temporal sequences (e.g., input audio and output tokens
to generate token-level timestamps).`,Ja,fs,tc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',ka,Ts,lc="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>matrix</td><td><code>Tensor</code></td></tr></tbody>",Da,Ia,qa,hs,Ka,_s,Na,$s,sc="Returns a tensor filled with the scalar value 1, with the shape defined by the variable argument size.",Ba,ys,nc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',Va,vs,oc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>Array.&lt;number&gt;</code></td><td><p>A sequence of integers defining the shape of the output tensor.</p></td></tr></tbody>",Qa,Sa,Wa,bs,Ya,Ms,Fa,xs,ic="Returns a tensor filled with the scalar value 1, with the same size as input.",Oa,Cs,rc='<strong>Kind</strong>: static method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: The ones tensor.',Ga,Hs,dc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>tensor</td><td><code>Tensor</code></td><td><p>The size of input will determine size of the output tensor.</p></td></tr></tbody>",Za,Xa,eu,Ls,tu,ws,lu,As,ac='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',su,nu,ou,gs,iu,zs,ru,Ps,uc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',du,au,uu,Us,mu,Rs,pu,js,mc="Reshapes a 1-dimensional array into an n-dimensional array, according to the provided dimensions.",cu,Es,pc='<strong>Kind</strong>: inner method of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The reshaped array.',fu,Js,cc="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Array&lt;T&gt;</code> | <code>DataArray</code></td><td><p>The input array to reshape.</p></td> </tr><tr><td>dimensions</td><td><code>DIM</code></td><td><p>The target shape/dimensions.</p></td></tr></tbody>",Tu,ks,fc="<strong>Example</strong>",hu,Ds,_u,$u,yu,Is,vu,qs,bu,Ks,Tc='<strong>Kind</strong>: inner property of <a href="#module_utils/tensor..reshape"><code>reshape</code></a>',Mu,xu,Cu,Ns,Hu,Bs,Lu,Vs,hc='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a>',wu,Au,gu,Qs,zu,Ss,Pu,Ws,_c="This creates a nested array of a given type and depth (see examples).",Uu,Ys,$c='<strong>Kind</strong>: inner typedef of <a href="#module_utils/tensor"><code>utils/tensor</code></a><br/> <strong>Example</strong>',Ru,Fs,ju,Os,yc="<strong>Example</strong>",Eu,Gs,Ju,Zs,vc="<strong>Example</strong>",ku,Xs,Du,Iu,qu,tn,Ku;return v=new _({props:{title:"utils/tensor",local:"utilstensor",headingTag:"h1"}}),H=new _({props:{title:"utils/tensor.Tensor",local:"utilstensortensor",headingTag:"h2"}}),g=new _({props:{title:"new Tensor(...args)",local:"new-tensorargs",headingTag:"h3"}}),R=new _({props:{title:"tensor.dims : <code> Array. < number > </code>",local:"tensordims--code-array--number--code",headingTag:"h3"}}),k=new _({props:{title:"tensor.type : <code> DataType </code>",local:"tensortype--code-datatype-code",headingTag:"h3"}}),K=new _({props:{title:"tensor.data : <code> DataArray </code>",local:"tensordata--code-dataarray-code",headingTag:"h3"}}),Q=new _({props:{title:"tensor.size : <code> number </code>",local:"tensorsize--code-number-code",headingTag:"h3"}}),F=new _({props:{title:"tensor.Symbol.iterator() ⇒ <code> Iterator </code>",local:"tensorsymboliterator--code-iterator-code",headingTag:"h3"}}),X=new _({props:{title:"tensor._getitem(index) ⇒ <code> Tensor </code>",local:"tensorgetitemindex--code-tensor-code",headingTag:"h3"}}),ne=new _({props:{title:"tensor.indexOf(item) ⇒ <code> number </code>",local:"tensorindexofitem--code-number-code",headingTag:"h3"}}),de=new _({props:{title:"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>",local:"tensorsubarrayindex-itersize-iterdims--code-tensor-code",headingTag:"h3"}}),pe=new _({props:{title:"tensor.item() ⇒ <code> number </code> | <code> bigint </code>",local:"tensoritem--code-number-code--code-bigint-code",headingTag:"h3"}}),_e=new _({props:{title:"tensor.tolist() ⇒ <code> Array </code>",local:"tensortolist--code-array-code",headingTag:"h3"}}),be=new _({props:{title:"tensor.sigmoid() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),He=new _({props:{title:"tensor.sigmoid_() ⇒ <code> Tensor </code>",local:"tensorsigmoid--code-tensor-code",headingTag:"h3"}}),ge=new _({props:{title:"tensor.mul(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),je=new _({props:{title:"tensor.mul_(val) ⇒ <code> Tensor </code>",local:"tensormulval--code-tensor-code",headingTag:"h3"}}),Ie=new _({props:{title:"tensor.add(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Ve=new _({props:{title:"tensor.add_(val) ⇒ <code> Tensor </code>",local:"tensoraddval--code-tensor-code",headingTag:"h3"}}),Fe=new _({props:{title:"tensor.transpose(...dims) ⇒ <code> Tensor </code>",local:"tensortransposedims--code-tensor-code",headingTag:"h3"}}),et=new _({props:{title:"tensor.sum([dim], keepdim) ⇒",local:"tensorsumdim-keepdim-",headingTag:"h3"}}),ot=new _({props:{title:"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>",local:"tensornormp-dim-keepdim--code-tensor-code",headingTag:"h3"}}),ut=new _({props:{title:"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),Tt=new _({props:{title:"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>",local:"tensornormalizep-dim--code-tensor-code",headingTag:"h3"}}),vt=new _({props:{title:"tensor.stride() ⇒ <code> Array. < number > </code>",local:"tensorstride--code-array--number--code",headingTag:"h3"}}),Ct=new _({props:{title:"tensor.squeeze([dim]) ⇒",local:"tensorsqueezedim-",headingTag:"h3"}}),zt=new _({props:{title:"tensor.squeeze_()",local:"tensorsqueeze",headingTag:"h3"}}),jt=new _({props:{title:"tensor.unsqueeze(dim) ⇒",local:"tensorunsqueezedim-",headingTag:"h3"}}),qt=new _({props:{title:"tensor.unsqueeze_()",local:"tensorunsqueeze",headingTag:"h3"}}),Vt=new _({props:{title:"tensor.flatten_()",local:"tensorflatten",headingTag:"h3"}}),Yt=new _({props:{title:"tensor.flatten(start_dim, end_dim) ⇒",local:"tensorflattenstartdim-enddim-",headingTag:"h3"}}),Xt=new _({props:{title:"tensor.view(...dims) ⇒ <code> Tensor </code>",local:"tensorviewdims--code-tensor-code",headingTag:"h3"}}),nl=new _({props:{title:"tensor.clamp_()",local:"tensorclamp",headingTag:"h3"}}),dl=new _({props:{title:"tensor.clamp(min, max) ⇒",local:"tensorclampmin-max-",headingTag:"h3"}}),cl=new _({props:{title:"tensor.round_()",local:"tensorround",headingTag:"h3"}}),_l=new _({props:{title:"tensor.round() ⇒",local:"tensorround-",headingTag:"h3"}}),bl=new _({props:{title:"tensor.to(type) ⇒ <code> Tensor </code>",local:"tensortotype--code-tensor-code",headingTag:"h3"}}),Ll=new _({props:{title:"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>",local:"utilstensortransposetensor-axes--code-tensor-code",headingTag:"h2"}}),Pl=new _({props:{title:"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>",local:"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code",headingTag:"h2"}}),Jl=new _({props:{title:"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>",local:"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code",headingTag:"h2"}}),Kl=new _({props:{title:"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>",local:"utilstensorlayernorminput-normalizedshape-options--code-tensor-code",headingTag:"h2"}}),Sl=new _({props:{title:"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorcattensors-dim--code-tensor-code",headingTag:"h2"}}),Gl=new _({props:{title:"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>",local:"utilstensorstacktensors-dim--code-tensor-code",headingTag:"h2"}}),ls=new _({props:{title:"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>",local:"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code",headingTag:"h2"}}),rs=new _({props:{title:"utils/tensor.mean(input, dim, keepdim) ⇒",local:"utilstensormeaninput-dim-keepdim-",headingTag:"h2"}}),ps=new _({props:{title:"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>",local:"utilstensordynamictimewarpingmatrix--code-array--array--number---code",headingTag:"h2"}}),_s=new _({props:{title:"utils/tensor.ones(size)",local:"utilstensoronessize",headingTag:"h2"}}),Ms=new _({props:{title:"utils/tensor.ones_like(tensor) ⇒",local:"utilstensoronesliketensor-",headingTag:"h2"}}),ws=new _({props:{title:"utils/tensor~args[0] : <code> DataType </code>",local:"utilstensorargs0--code-datatype-code",headingTag:"h2"}}),zs=new _({props:{title:"utils/tensor~args[1] : <code> * </code>",local:"utilstensorargs1--code--code",headingTag:"h2"}}),Rs=new _({props:{title:"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>",local:"utilstensorreshapedata-dimensions--code--code",headingTag:"h2"}}),Ds=new Nu({props:{code:"cmVzaGFwZSglNUIxMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUyMCU1QjElMjAlMjAlMjAlMjAlMjAlMjAlNUQpJTNCJTIwJTJGJTJGJTIwVHlwZSUzQSUyMG51bWJlciU1QiU1RCUyMCUyMCUyMCUyMCUyMCUyMFZhbHVlJTNBJTIwJTVCMTAlNUQlMEElMjAlMjByZXNoYXBlKCU1QjElMkMlMjAyJTJDJTIwMyUyQyUyMDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMjAlNUIyJTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTBBJTIwJTIwcmVzaGFwZSglNUIxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTJDJTIwOCU1RCUyQyUyMCU1QjIlMkMlMjAyJTJDJTIwMiU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTVCJTVEJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTVEJTJDJTIwJTVCJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RCU1RCUwQSUyMCUyMHJlc2hhcGUoJTVCMSUyQyUyMDIlMkMlMjAzJTJDJTIwNCUyQyUyMDUlMkMlMjA2JTJDJTIwNyUyQyUyMDglNUQlMkMlMjAlNUI0JTJDJTIwMiUyMCUyMCUyMCU1RCklM0IlMjAlMkYlMkYlMjBUeXBlJTNBJTIwbnVtYmVyJTVCJTVEJTVCJTVEJTIwJTIwJTIwJTIwVmFsdWUlM0ElMjAlNUIlNUIxJTJDJTIwMiU1RCUyQyUyMCU1QjMlMkMlMjA0JTVEJTJDJTIwJTVCNSUyQyUyMDYlNUQlMkMlMjAlNUI3JTJDJTIwOCU1RCU1RA==",highlighted:`<span class="hljs-title function_">reshape</span>([<span class="hljs-number">10</span>                    ], [<span class="hljs-number">1</span>      ]); <span class="hljs-comment">// Type: number[]      Value: [10]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>            ], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>]); <span class="hljs-comment">// Type: number[][][]  Value: [[[1, 2], [3, 4]], [[5, 6], [7, 8]]]</span>
  <span class="hljs-title function_">reshape</span>([<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>], [<span class="hljs-number">4</span>, <span class="hljs-number">2</span>   ]); <span class="hljs-comment">// Type: number[][]    Value: [[1, 2], [3, 4], [5, 6], [7, 8]]</span>`,wrap:!1}}),qs=new _({props:{title:"reshape~reshapedArray : <code> any </code>",local:"reshapereshapedarray--code-any-code",headingTag:"h3"}}),Bs=new _({props:{title:"utils/tensor~DataArray : <code> * </code>",local:"utilstensordataarray--code--code",headingTag:"h2"}}),Ss=new _({props:{title:"utils/tensor~NestArray : <code> * </code>",local:"utilstensornestarray--code--code",headingTag:"h2"}}),Fs=new Nu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMSUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">1</span>&gt;; <span class="hljs-comment">// string[]</span>',wrap:!1}}),Gs=new Nu({props:{code:"TmVzdEFycmF5JTNDbnVtYmVyJTJDJTIwMiUzRSUzQiUyMCUyRiUyRiUyMG51bWJlciU1QiU1RCU1QiU1RA==",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;number, <span class="hljs-number">2</span>&gt;; <span class="hljs-comment">// number[][]</span>',wrap:!1}}),Xs=new Nu({props:{code:"TmVzdEFycmF5JTNDc3RyaW5nJTJDJTIwMyUzRSUzQiUyMCUyRiUyRiUyMHN0cmluZyU1QiU1RCU1QiU1RCU1QiU1RCUyMGV0Yy4=",highlighted:'<span class="hljs-title class_">NestArray</span>&lt;string, <span class="hljs-number">3</span>&gt;; <span class="hljs-comment">// string[][][] etc.</span>',wrap:!1}}),{c(){$=i("meta"),ln=n(),en=i("p"),sn=n(),y=i("a"),nn=n(),u(v.$$.fragment),on=n(),b=i("p"),b.innerHTML=Vu,rn=n(),M=i("p"),M.textContent=Qu,dn=n(),x=i("ul"),x.innerHTML=Su,an=n(),un=i("hr"),mn=n(),C=i("a"),pn=n(),u(H.$$.fragment),cn=n(),L=i("p"),L.innerHTML=Wu,fn=n(),w=i("ul"),w.innerHTML=Yu,Tn=n(),hn=i("hr"),_n=n(),A=i("a"),$n=n(),u(g.$$.fragment),yn=n(),z=i("p"),z.textContent=Fu,vn=n(),P=i("table"),P.innerHTML=Ou,bn=n(),Mn=i("hr"),xn=n(),U=i("a"),Cn=n(),u(R.$$.fragment),Hn=n(),j=i("p"),j.textContent=Gu,Ln=n(),E=i("p"),E.innerHTML=Zu,wn=n(),An=i("hr"),gn=n(),J=i("a"),zn=n(),u(k.$$.fragment),Pn=n(),D=i("p"),D.textContent=Xu,Un=n(),I=i("p"),I.innerHTML=em,Rn=n(),jn=i("hr"),En=n(),q=i("a"),Jn=n(),u(K.$$.fragment),kn=n(),N=i("p"),N.textContent=tm,Dn=n(),B=i("p"),B.innerHTML=lm,In=n(),qn=i("hr"),Kn=n(),V=i("a"),Nn=n(),u(Q.$$.fragment),Bn=n(),S=i("p"),S.textContent=sm,Vn=n(),W=i("p"),W.innerHTML=nm,Qn=n(),Sn=i("hr"),Wn=n(),Y=i("a"),Yn=n(),u(F.$$.fragment),Fn=n(),O=i("p"),O.textContent=om,On=n(),G=i("p"),G.innerHTML=im,Gn=n(),Zn=i("hr"),Xn=n(),Z=i("a"),eo=n(),u(X.$$.fragment),to=n(),ee=i("p"),ee.textContent=rm,lo=n(),te=i("p"),te.innerHTML=dm,so=n(),le=i("table"),le.innerHTML=am,no=n(),oo=i("hr"),io=n(),se=i("a"),ro=n(),u(ne.$$.fragment),ao=n(),oe=i("p"),oe.innerHTML=um,uo=n(),ie=i("table"),ie.innerHTML=mm,mo=n(),po=i("hr"),co=n(),re=i("a"),fo=n(),u(de.$$.fragment),To=n(),ae=i("p"),ae.innerHTML=pm,ho=n(),ue=i("table"),ue.innerHTML=cm,_o=n(),$o=i("hr"),yo=n(),me=i("a"),vo=n(),u(pe.$$.fragment),bo=n(),ce=i("p"),ce.innerHTML=fm,Mo=n(),fe=i("p"),fe.innerHTML=Tm,xo=n(),Te=i("ul"),Te.innerHTML=hm,Co=n(),Ho=i("hr"),Lo=n(),he=i("a"),wo=n(),u(_e.$$.fragment),Ao=n(),$e=i("p"),$e.textContent=_m,go=n(),ye=i("p"),ye.innerHTML=$m,zo=n(),Po=i("hr"),Uo=n(),ve=i("a"),Ro=n(),u(be.$$.fragment),jo=n(),Me=i("p"),Me.textContent=ym,Eo=n(),xe=i("p"),xe.innerHTML=vm,Jo=n(),ko=i("hr"),Do=n(),Ce=i("a"),Io=n(),u(He.$$.fragment),qo=n(),Le=i("p"),Le.textContent=bm,Ko=n(),we=i("p"),we.innerHTML=Mm,No=n(),Bo=i("hr"),Vo=n(),Ae=i("a"),Qo=n(),u(ge.$$.fragment),So=n(),ze=i("p"),ze.textContent=xm,Wo=n(),Pe=i("p"),Pe.innerHTML=Cm,Yo=n(),Ue=i("table"),Ue.innerHTML=Hm,Fo=n(),Oo=i("hr"),Go=n(),Re=i("a"),Zo=n(),u(je.$$.fragment),Xo=n(),Ee=i("p"),Ee.textContent=Lm,ei=n(),Je=i("p"),Je.innerHTML=wm,ti=n(),ke=i("table"),ke.innerHTML=Am,li=n(),si=i("hr"),ni=n(),De=i("a"),oi=n(),u(Ie.$$.fragment),ii=n(),qe=i("p"),qe.textContent=gm,ri=n(),Ke=i("p"),Ke.innerHTML=zm,di=n(),Ne=i("table"),Ne.innerHTML=Pm,ai=n(),ui=i("hr"),mi=n(),Be=i("a"),pi=n(),u(Ve.$$.fragment),ci=n(),Qe=i("p"),Qe.textContent=Um,fi=n(),Se=i("p"),Se.innerHTML=Rm,Ti=n(),We=i("table"),We.innerHTML=jm,hi=n(),_i=i("hr"),$i=n(),Ye=i("a"),yi=n(),u(Fe.$$.fragment),vi=n(),Oe=i("p"),Oe.textContent=Em,bi=n(),Ge=i("p"),Ge.innerHTML=Jm,Mi=n(),Ze=i("table"),Ze.innerHTML=km,xi=n(),Ci=i("hr"),Hi=n(),Xe=i("a"),Li=n(),u(et.$$.fragment),wi=n(),tt=i("p"),tt.textContent=Dm,Ai=n(),lt=i("p"),lt.innerHTML=Im,gi=n(),st=i("table"),st.innerHTML=qm,zi=n(),Pi=i("hr"),Ui=n(),nt=i("a"),Ri=n(),u(ot.$$.fragment),ji=n(),it=i("p"),it.textContent=Km,Ei=n(),rt=i("p"),rt.innerHTML=Nm,Ji=n(),dt=i("table"),dt.innerHTML=Bm,ki=n(),Di=i("hr"),Ii=n(),at=i("a"),qi=n(),u(ut.$$.fragment),Ki=n(),mt=i("p"),mt.innerHTML=Vm,Ni=n(),pt=i("p"),pt.innerHTML=Qm,Bi=n(),ct=i("table"),ct.innerHTML=Sm,Vi=n(),Qi=i("hr"),Si=n(),ft=i("a"),Wi=n(),u(Tt.$$.fragment),Yi=n(),ht=i("p"),ht.innerHTML=Wm,Fi=n(),_t=i("p"),_t.innerHTML=Ym,Oi=n(),$t=i("table"),$t.innerHTML=Fm,Gi=n(),Zi=i("hr"),Xi=n(),yt=i("a"),er=n(),u(vt.$$.fragment),tr=n(),bt=i("p"),bt.textContent=Om,lr=n(),Mt=i("p"),Mt.innerHTML=Gm,sr=n(),nr=i("hr"),or=n(),xt=i("a"),ir=n(),u(Ct.$$.fragment),rr=n(),Ht=i("p"),Ht.textContent=Zm,dr=n(),Lt=i("p"),Lt.innerHTML=Xm,ar=n(),wt=i("p"),wt.innerHTML=ep,ur=n(),At=i("table"),At.innerHTML=tp,mr=n(),pr=i("hr"),cr=n(),gt=i("a"),fr=n(),u(zt.$$.fragment),Tr=n(),Pt=i("p"),Pt.innerHTML=lp,hr=n(),Ut=i("p"),Ut.innerHTML=sp,_r=n(),$r=i("hr"),yr=n(),Rt=i("a"),vr=n(),u(jt.$$.fragment),br=n(),Et=i("p"),Et.textContent=np,Mr=n(),Jt=i("p"),Jt.textContent=op,xr=n(),kt=i("p"),kt.innerHTML=ip,Cr=n(),Dt=i("table"),Dt.innerHTML=rp,Hr=n(),Lr=i("hr"),wr=n(),It=i("a"),Ar=n(),u(qt.$$.fragment),gr=n(),Kt=i("p"),Kt.innerHTML=dp,zr=n(),Nt=i("p"),Nt.innerHTML=ap,Pr=n(),Ur=i("hr"),Rr=n(),Bt=i("a"),jr=n(),u(Vt.$$.fragment),Er=n(),Qt=i("p"),Qt.innerHTML=up,Jr=n(),St=i("p"),St.innerHTML=mp,kr=n(),Dr=i("hr"),Ir=n(),Wt=i("a"),qr=n(),u(Yt.$$.fragment),Kr=n(),Ft=i("p"),Ft.innerHTML=pp,Nr=n(),Ot=i("p"),Ot.innerHTML=cp,Br=n(),Gt=i("table"),Gt.innerHTML=fp,Vr=n(),Qr=i("hr"),Sr=n(),Zt=i("a"),Wr=n(),u(Xt.$$.fragment),Yr=n(),el=i("p"),el.innerHTML=Tp,Fr=n(),tl=i("p"),tl.innerHTML=hp,Or=n(),ll=i("table"),ll.innerHTML=_p,Gr=n(),Zr=i("hr"),Xr=n(),sl=i("a"),ed=n(),u(nl.$$.fragment),td=n(),ol=i("p"),ol.innerHTML=$p,ld=n(),il=i("p"),il.innerHTML=yp,sd=n(),nd=i("hr"),od=n(),rl=i("a"),id=n(),u(dl.$$.fragment),rd=n(),al=i("p"),al.textContent=vp,dd=n(),ul=i("p"),ul.innerHTML=bp,ad=n(),ml=i("table"),ml.innerHTML=Mp,ud=n(),md=i("hr"),pd=n(),pl=i("a"),cd=n(),u(cl.$$.fragment),fd=n(),fl=i("p"),fl.innerHTML=xp,Td=n(),Tl=i("p"),Tl.innerHTML=Cp,hd=n(),_d=i("hr"),$d=n(),hl=i("a"),yd=n(),u(_l.$$.fragment),vd=n(),$l=i("p"),$l.textContent=Hp,bd=n(),yl=i("p"),yl.innerHTML=Lp,Md=n(),xd=i("hr"),Cd=n(),vl=i("a"),Hd=n(),u(bl.$$.fragment),Ld=n(),Ml=i("p"),Ml.textContent=wp,wd=n(),xl=i("p"),xl.innerHTML=Ap,Ad=n(),Cl=i("table"),Cl.innerHTML=gp,gd=n(),zd=i("hr"),Pd=n(),Hl=i("a"),Ud=n(),u(Ll.$$.fragment),Rd=n(),wl=i("p"),wl.textContent=zp,jd=n(),Al=i("p"),Al.innerHTML=Pp,Ed=n(),gl=i("table"),gl.innerHTML=Up,Jd=n(),kd=i("hr"),Dd=n(),zl=i("a"),Id=n(),u(Pl.$$.fragment),qd=n(),Ul=i("p"),Ul.textContent=Rp,Kd=n(),Rl=i("p"),Rl.innerHTML=jp,Nd=n(),jl=i("table"),jl.innerHTML=Ep,Bd=n(),Vd=i("hr"),Qd=n(),El=i("a"),Sd=n(),u(Jl.$$.fragment),Wd=n(),kl=i("p"),kl.textContent=Jp,Yd=n(),Dl=i("p"),Dl.innerHTML=kp,Fd=n(),Il=i("table"),Il.innerHTML=Dp,Od=n(),Gd=i("hr"),Zd=n(),ql=i("a"),Xd=n(),u(Kl.$$.fragment),ea=n(),Nl=i("p"),Nl.textContent=Ip,ta=n(),Bl=i("p"),Bl.innerHTML=qp,la=n(),Vl=i("table"),Vl.innerHTML=Kp,sa=n(),na=i("hr"),oa=n(),Ql=i("a"),ia=n(),u(Sl.$$.fragment),ra=n(),Wl=i("p"),Wl.textContent=Np,da=n(),Yl=i("p"),Yl.innerHTML=Bp,aa=n(),Fl=i("table"),Fl.innerHTML=Vp,ua=n(),ma=i("hr"),pa=n(),Ol=i("a"),ca=n(),u(Gl.$$.fragment),fa=n(),Zl=i("p"),Zl.textContent=Qp,Ta=n(),Xl=i("p"),Xl.innerHTML=Sp,ha=n(),es=i("table"),es.innerHTML=Wp,_a=n(),$a=i("hr"),ya=n(),ts=i("a"),va=n(),u(ls.$$.fragment),ba=n(),ss=i("p"),ss.innerHTML=Yp,Ma=n(),ns=i("p"),ns.innerHTML=Fp,xa=n(),os=i("table"),os.innerHTML=Op,Ca=n(),Ha=i("hr"),La=n(),is=i("a"),wa=n(),u(rs.$$.fragment),Aa=n(),ds=i("p"),ds.textContent=Gp,ga=n(),as=i("p"),as.innerHTML=Zp,za=n(),us=i("table"),us.innerHTML=Xp,Pa=n(),Ua=i("hr"),Ra=n(),ms=i("a"),ja=n(),u(ps.$$.fragment),Ea=n(),cs=i("p"),cs.textContent=ec,Ja=n(),fs=i("p"),fs.innerHTML=tc,ka=n(),Ts=i("table"),Ts.innerHTML=lc,Da=n(),Ia=i("hr"),qa=n(),hs=i("a"),Ka=n(),u(_s.$$.fragment),Na=n(),$s=i("p"),$s.textContent=sc,Ba=n(),ys=i("p"),ys.innerHTML=nc,Va=n(),vs=i("table"),vs.innerHTML=oc,Qa=n(),Sa=i("hr"),Wa=n(),bs=i("a"),Ya=n(),u(Ms.$$.fragment),Fa=n(),xs=i("p"),xs.textContent=ic,Oa=n(),Cs=i("p"),Cs.innerHTML=rc,Ga=n(),Hs=i("table"),Hs.innerHTML=dc,Za=n(),Xa=i("hr"),eu=n(),Ls=i("a"),tu=n(),u(ws.$$.fragment),lu=n(),As=i("p"),As.innerHTML=ac,su=n(),nu=i("hr"),ou=n(),gs=i("a"),iu=n(),u(zs.$$.fragment),ru=n(),Ps=i("p"),Ps.innerHTML=uc,du=n(),au=i("hr"),uu=n(),Us=i("a"),mu=n(),u(Rs.$$.fragment),pu=n(),js=i("p"),js.textContent=mc,cu=n(),Es=i("p"),Es.innerHTML=pc,fu=n(),Js=i("table"),Js.innerHTML=cc,Tu=n(),ks=i("p"),ks.innerHTML=fc,hu=n(),u(Ds.$$.fragment),_u=n(),$u=i("hr"),yu=n(),Is=i("a"),vu=n(),u(qs.$$.fragment),bu=n(),Ks=i("p"),Ks.innerHTML=Tc,Mu=n(),xu=i("hr"),Cu=n(),Ns=i("a"),Hu=n(),u(Bs.$$.fragment),Lu=n(),Vs=i("p"),Vs.innerHTML=hc,wu=n(),Au=i("hr"),gu=n(),Qs=i("a"),zu=n(),u(Ss.$$.fragment),Pu=n(),Ws=i("p"),Ws.textContent=_c,Uu=n(),Ys=i("p"),Ys.innerHTML=$c,Ru=n(),u(Fs.$$.fragment),ju=n(),Os=i("p"),Os.innerHTML=yc,Eu=n(),u(Gs.$$.fragment),Ju=n(),Zs=i("p"),Zs.innerHTML=vc,ku=n(),u(Xs.$$.fragment),Du=n(),Iu=i("hr"),qu=n(),tn=i("p"),this.h()},l(e){const t=Lc("svelte-u9bgzb",document.head);$=r(t,"META",{name:!0,content:!0}),t.forEach(l),ln=o(e),en=r(e,"P",{}),h(en).forEach(l),sn=o(e),y=r(e,"A",{id:!0,class:!0}),h(y).forEach(l),nn=o(e),m(v.$$.fragment,e),on=o(e),b=r(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-uw4y1m"&&(b.innerHTML=Vu),rn=o(e),M=r(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-il3kl8"&&(M.textContent=Qu),dn=o(e),x=r(e,"UL",{"data-svelte-h":!0}),d(x)!=="svelte-1p2phu0"&&(x.innerHTML=Su),an=o(e),un=r(e,"HR",{}),mn=o(e),C=r(e,"A",{id:!0,class:!0}),h(C).forEach(l),pn=o(e),m(H.$$.fragment,e),cn=o(e),L=r(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1ugrfrw"&&(L.innerHTML=Wu),fn=o(e),w=r(e,"UL",{"data-svelte-h":!0}),d(w)!=="svelte-bidd2"&&(w.innerHTML=Yu),Tn=o(e),hn=r(e,"HR",{}),_n=o(e),A=r(e,"A",{id:!0,class:!0}),h(A).forEach(l),$n=o(e),m(g.$$.fragment,e),yn=o(e),z=r(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-55wecd"&&(z.textContent=Fu),vn=o(e),P=r(e,"TABLE",{"data-svelte-h":!0}),d(P)!=="svelte-ee7emz"&&(P.innerHTML=Ou),bn=o(e),Mn=r(e,"HR",{}),xn=o(e),U=r(e,"A",{id:!0,class:!0}),h(U).forEach(l),Cn=o(e),m(R.$$.fragment,e),Hn=o(e),j=r(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-1gc2rt4"&&(j.textContent=Gu),Ln=o(e),E=r(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-10qzguj"&&(E.innerHTML=Zu),wn=o(e),An=r(e,"HR",{}),gn=o(e),J=r(e,"A",{id:!0,class:!0}),h(J).forEach(l),zn=o(e),m(k.$$.fragment,e),Pn=o(e),D=r(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-81y0bb"&&(D.textContent=Xu),Un=o(e),I=r(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10qzguj"&&(I.innerHTML=em),Rn=o(e),jn=r(e,"HR",{}),En=o(e),q=r(e,"A",{id:!0,class:!0}),h(q).forEach(l),Jn=o(e),m(K.$$.fragment,e),kn=o(e),N=r(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1eqabt7"&&(N.textContent=tm),Dn=o(e),B=r(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-10qzguj"&&(B.innerHTML=lm),In=o(e),qn=r(e,"HR",{}),Kn=o(e),V=r(e,"A",{id:!0,class:!0}),h(V).forEach(l),Nn=o(e),m(Q.$$.fragment,e),Bn=o(e),S=r(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-krrt97"&&(S.textContent=sm),Vn=o(e),W=r(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-10qzguj"&&(W.innerHTML=nm),Qn=o(e),Sn=r(e,"HR",{}),Wn=o(e),Y=r(e,"A",{id:!0,class:!0}),h(Y).forEach(l),Yn=o(e),m(F.$$.fragment,e),Fn=o(e),O=r(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1adn56z"&&(O.textContent=om),On=o(e),G=r(e,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1gxgvk6"&&(G.innerHTML=im),Gn=o(e),Zn=r(e,"HR",{}),Xn=o(e),Z=r(e,"A",{id:!0,class:!0}),h(Z).forEach(l),eo=o(e),m(X.$$.fragment,e),to=o(e),ee=r(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1u97xg1"&&(ee.textContent=rm),lo=o(e),te=r(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1afa2dz"&&(te.innerHTML=dm),so=o(e),le=r(e,"TABLE",{"data-svelte-h":!0}),d(le)!=="svelte-1kq04ga"&&(le.innerHTML=am),no=o(e),oo=r(e,"HR",{}),io=o(e),se=r(e,"A",{id:!0,class:!0}),h(se).forEach(l),ro=o(e),m(ne.$$.fragment,e),ao=o(e),oe=r(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1cg22af"&&(oe.innerHTML=um),uo=o(e),ie=r(e,"TABLE",{"data-svelte-h":!0}),d(ie)!=="svelte-1hful42"&&(ie.innerHTML=mm),mo=o(e),po=r(e,"HR",{}),co=o(e),re=r(e,"A",{id:!0,class:!0}),h(re).forEach(l),fo=o(e),m(de.$$.fragment,e),To=o(e),ae=r(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1mr58c3"&&(ae.innerHTML=pm),ho=o(e),ue=r(e,"TABLE",{"data-svelte-h":!0}),d(ue)!=="svelte-153ftfy"&&(ue.innerHTML=cm),_o=o(e),$o=r(e,"HR",{}),yo=o(e),me=r(e,"A",{id:!0,class:!0}),h(me).forEach(l),vo=o(e),m(pe.$$.fragment,e),bo=o(e),ce=r(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13nzfs3"&&(ce.innerHTML=fm),Mo=o(e),fe=r(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-11rv1mu"&&(fe.innerHTML=Tm),xo=o(e),Te=r(e,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-5t2sg3"&&(Te.innerHTML=hm),Co=o(e),Ho=r(e,"HR",{}),Lo=o(e),he=r(e,"A",{id:!0,class:!0}),h(he).forEach(l),wo=o(e),m(_e.$$.fragment,e),Ao=o(e),$e=r(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-87xdyr"&&($e.textContent=_m),go=o(e),ye=r(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1mr58c3"&&(ye.innerHTML=$m),zo=o(e),Po=r(e,"HR",{}),Uo=o(e),ve=r(e,"A",{id:!0,class:!0}),h(ve).forEach(l),Ro=o(e),m(be.$$.fragment,e),jo=o(e),Me=r(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-2wti2w"&&(Me.textContent=ym),Eo=o(e),xe=r(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-kpq7mo"&&(xe.innerHTML=vm),Jo=o(e),ko=r(e,"HR",{}),Do=o(e),Ce=r(e,"A",{id:!0,class:!0}),h(Ce).forEach(l),Io=o(e),m(He.$$.fragment,e),qo=o(e),Le=r(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1edu6c8"&&(Le.textContent=bm),Ko=o(e),we=r(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1hc4oxa"&&(we.innerHTML=Mm),No=o(e),Bo=r(e,"HR",{}),Vo=o(e),Ae=r(e,"A",{id:!0,class:!0}),h(Ae).forEach(l),Qo=o(e),m(ge.$$.fragment,e),So=o(e),ze=r(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-xg80lg"&&(ze.textContent=xm),Wo=o(e),Pe=r(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-1aygav2"&&(Pe.innerHTML=Cm),Yo=o(e),Ue=r(e,"TABLE",{"data-svelte-h":!0}),d(Ue)!=="svelte-1tbtmqd"&&(Ue.innerHTML=Hm),Fo=o(e),Oo=r(e,"HR",{}),Go=o(e),Re=r(e,"A",{id:!0,class:!0}),h(Re).forEach(l),Zo=o(e),m(je.$$.fragment,e),Xo=o(e),Ee=r(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-1i12x1s"&&(Ee.textContent=Lm),ei=o(e),Je=r(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1hc4oxa"&&(Je.innerHTML=wm),ti=o(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),d(ke)!=="svelte-1tbtmqd"&&(ke.innerHTML=Am),li=o(e),si=r(e,"HR",{}),ni=o(e),De=r(e,"A",{id:!0,class:!0}),h(De).forEach(l),oi=o(e),m(Ie.$$.fragment,e),ii=o(e),qe=r(e,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-1hl64jn"&&(qe.textContent=gm),ri=o(e),Ke=r(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-1aygav2"&&(Ke.innerHTML=zm),di=o(e),Ne=r(e,"TABLE",{"data-svelte-h":!0}),d(Ne)!=="svelte-1p5444"&&(Ne.innerHTML=Pm),ai=o(e),ui=r(e,"HR",{}),mi=o(e),Be=r(e,"A",{id:!0,class:!0}),h(Be).forEach(l),pi=o(e),m(Ve.$$.fragment,e),ci=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-bbf4x3"&&(Qe.textContent=Um),fi=o(e),Se=r(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-1hc4oxa"&&(Se.innerHTML=Rm),Ti=o(e),We=r(e,"TABLE",{"data-svelte-h":!0}),d(We)!=="svelte-1p5444"&&(We.innerHTML=jm),hi=o(e),_i=r(e,"HR",{}),$i=o(e),Ye=r(e,"A",{id:!0,class:!0}),h(Ye).forEach(l),yi=o(e),m(Fe.$$.fragment,e),vi=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-lesh1u"&&(Oe.textContent=Em),bi=o(e),Ge=r(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-rvzl1t"&&(Ge.innerHTML=Jm),Mi=o(e),Ze=r(e,"TABLE",{"data-svelte-h":!0}),d(Ze)!=="svelte-onq75m"&&(Ze.innerHTML=km),xi=o(e),Ci=r(e,"HR",{}),Hi=o(e),Xe=r(e,"A",{id:!0,class:!0}),h(Xe).forEach(l),Li=o(e),m(et.$$.fragment,e),wi=o(e),tt=r(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-yjryb1"&&(tt.textContent=Dm),Ai=o(e),lt=r(e,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-xtr8tc"&&(lt.innerHTML=Im),gi=o(e),st=r(e,"TABLE",{"data-svelte-h":!0}),d(st)!=="svelte-6xvdso"&&(st.innerHTML=qm),zi=o(e),Pi=r(e,"HR",{}),Ui=o(e),nt=r(e,"A",{id:!0,class:!0}),h(nt).forEach(l),Ri=o(e),m(ot.$$.fragment,e),ji=o(e),it=r(e,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1okfsqx"&&(it.textContent=Km),Ei=o(e),rt=r(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1t556pk"&&(rt.innerHTML=Nm),Ji=o(e),dt=r(e,"TABLE",{"data-svelte-h":!0}),d(dt)!=="svelte-13m2wni"&&(dt.innerHTML=Bm),ki=o(e),Di=r(e,"HR",{}),Ii=o(e),at=r(e,"A",{id:!0,class:!0}),h(at).forEach(l),qi=o(e),m(ut.$$.fragment,e),Ki=o(e),mt=r(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1htpbrk"&&(mt.innerHTML=Vm),Ni=o(e),pt=r(e,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-1t0m8l6"&&(pt.innerHTML=Qm),Bi=o(e),ct=r(e,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1qi99pl"&&(ct.innerHTML=Sm),Vi=o(e),Qi=r(e,"HR",{}),Si=o(e),ft=r(e,"A",{id:!0,class:!0}),h(ft).forEach(l),Wi=o(e),m(Tt.$$.fragment,e),Yi=o(e),ht=r(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1ztgqp"&&(ht.innerHTML=Wm),Fi=o(e),_t=r(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-mvb39p"&&(_t.innerHTML=Ym),Oi=o(e),$t=r(e,"TABLE",{"data-svelte-h":!0}),d($t)!=="svelte-1qi99pl"&&($t.innerHTML=Fm),Gi=o(e),Zi=r(e,"HR",{}),Xi=o(e),yt=r(e,"A",{id:!0,class:!0}),h(yt).forEach(l),er=o(e),m(vt.$$.fragment,e),tr=o(e),bt=r(e,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-1a7u185"&&(bt.textContent=Om),lr=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1eu3doh"&&(Mt.innerHTML=Gm),sr=o(e),nr=r(e,"HR",{}),or=o(e),xt=r(e,"A",{id:!0,class:!0}),h(xt).forEach(l),ir=o(e),m(Ct.$$.fragment,e),rr=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-qls17b"&&(Ht.textContent=Zm),dr=o(e),Lt=r(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-5nabmy"&&(Lt.innerHTML=Xm),ar=o(e),wt=r(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1skbfxl"&&(wt.innerHTML=ep),ur=o(e),At=r(e,"TABLE",{"data-svelte-h":!0}),d(At)!=="svelte-52pnzr"&&(At.innerHTML=tp),mr=o(e),pr=r(e,"HR",{}),cr=o(e),gt=r(e,"A",{id:!0,class:!0}),h(gt).forEach(l),fr=o(e),m(zt.$$.fragment,e),Tr=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-19w0pic"&&(Pt.innerHTML=lp),hr=o(e),Ut=r(e,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1mr58c3"&&(Ut.innerHTML=sp),_r=o(e),$r=r(e,"HR",{}),yr=o(e),Rt=r(e,"A",{id:!0,class:!0}),h(Rt).forEach(l),vr=o(e),m(jt.$$.fragment,e),br=o(e),Et=r(e,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-18ws76n"&&(Et.textContent=np),Mr=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1tnr5gm"&&(Jt.textContent=op),xr=o(e),kt=r(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-1aoa5jo"&&(kt.innerHTML=ip),Cr=o(e),Dt=r(e,"TABLE",{"data-svelte-h":!0}),d(Dt)!=="svelte-1u9lyxp"&&(Dt.innerHTML=rp),Hr=o(e),Lr=r(e,"HR",{}),wr=o(e),It=r(e,"A",{id:!0,class:!0}),h(It).forEach(l),Ar=o(e),m(qt.$$.fragment,e),gr=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),d(Kt)!=="svelte-1b9ygao"&&(Kt.innerHTML=dp),zr=o(e),Nt=r(e,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-1mr58c3"&&(Nt.innerHTML=ap),Pr=o(e),Ur=r(e,"HR",{}),Rr=o(e),Bt=r(e,"A",{id:!0,class:!0}),h(Bt).forEach(l),jr=o(e),m(Vt.$$.fragment,e),Er=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),d(Qt)!=="svelte-1vkr5xo"&&(Qt.innerHTML=up),Jr=o(e),St=r(e,"P",{"data-svelte-h":!0}),d(St)!=="svelte-1mr58c3"&&(St.innerHTML=mp),kr=o(e),Dr=r(e,"HR",{}),Ir=o(e),Wt=r(e,"A",{id:!0,class:!0}),h(Wt).forEach(l),qr=o(e),m(Yt.$$.fragment,e),Kr=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-1gguudf"&&(Ft.innerHTML=pp),Nr=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-9ffe42"&&(Ot.innerHTML=cp),Br=o(e),Gt=r(e,"TABLE",{"data-svelte-h":!0}),d(Gt)!=="svelte-z6whez"&&(Gt.innerHTML=fp),Vr=o(e),Qr=r(e,"HR",{}),Sr=o(e),Zt=r(e,"A",{id:!0,class:!0}),h(Zt).forEach(l),Wr=o(e),m(Xt.$$.fragment,e),Yr=o(e),el=r(e,"P",{"data-svelte-h":!0}),d(el)!=="svelte-d6gvut"&&(el.innerHTML=Tp),Fr=o(e),tl=r(e,"P",{"data-svelte-h":!0}),d(tl)!=="svelte-18n9ux4"&&(tl.innerHTML=hp),Or=o(e),ll=r(e,"TABLE",{"data-svelte-h":!0}),d(ll)!=="svelte-jj58dd"&&(ll.innerHTML=_p),Gr=o(e),Zr=r(e,"HR",{}),Xr=o(e),sl=r(e,"A",{id:!0,class:!0}),h(sl).forEach(l),ed=o(e),m(nl.$$.fragment,e),td=o(e),ol=r(e,"P",{"data-svelte-h":!0}),d(ol)!=="svelte-1adolpg"&&(ol.innerHTML=$p),ld=o(e),il=r(e,"P",{"data-svelte-h":!0}),d(il)!=="svelte-1mr58c3"&&(il.innerHTML=yp),sd=o(e),nd=r(e,"HR",{}),od=o(e),rl=r(e,"A",{id:!0,class:!0}),h(rl).forEach(l),id=o(e),m(dl.$$.fragment,e),rd=o(e),al=r(e,"P",{"data-svelte-h":!0}),d(al)!=="svelte-1hm8vtj"&&(al.textContent=vp),dd=o(e),ul=r(e,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-106ei5g"&&(ul.innerHTML=bp),ad=o(e),ml=r(e,"TABLE",{"data-svelte-h":!0}),d(ml)!=="svelte-9ff0sy"&&(ml.innerHTML=Mp),ud=o(e),md=r(e,"HR",{}),pd=o(e),pl=r(e,"A",{id:!0,class:!0}),h(pl).forEach(l),cd=o(e),m(cl.$$.fragment,e),fd=o(e),fl=r(e,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-1e6kzks"&&(fl.innerHTML=xp),Td=o(e),Tl=r(e,"P",{"data-svelte-h":!0}),d(Tl)!=="svelte-1mr58c3"&&(Tl.innerHTML=Cp),hd=o(e),_d=r(e,"HR",{}),$d=o(e),hl=r(e,"A",{id:!0,class:!0}),h(hl).forEach(l),yd=o(e),m(_l.$$.fragment,e),vd=o(e),$l=r(e,"P",{"data-svelte-h":!0}),d($l)!=="svelte-t5k6jp"&&($l.textContent=Hp),bd=o(e),yl=r(e,"P",{"data-svelte-h":!0}),d(yl)!=="svelte-106ei5g"&&(yl.innerHTML=Lp),Md=o(e),xd=r(e,"HR",{}),Cd=o(e),vl=r(e,"A",{id:!0,class:!0}),h(vl).forEach(l),Hd=o(e),m(bl.$$.fragment,e),Ld=o(e),Ml=r(e,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-avw2a1"&&(Ml.textContent=wp),wd=o(e),xl=r(e,"P",{"data-svelte-h":!0}),d(xl)!=="svelte-16q99cu"&&(xl.innerHTML=Ap),Ad=o(e),Cl=r(e,"TABLE",{"data-svelte-h":!0}),d(Cl)!=="svelte-zy0eig"&&(Cl.innerHTML=gp),gd=o(e),zd=r(e,"HR",{}),Pd=o(e),Hl=r(e,"A",{id:!0,class:!0}),h(Hl).forEach(l),Ud=o(e),m(Ll.$$.fragment,e),Rd=o(e),wl=r(e,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-15z3tv8"&&(wl.textContent=zp),jd=o(e),Al=r(e,"P",{"data-svelte-h":!0}),d(Al)!=="svelte-sv4gxb"&&(Al.innerHTML=Pp),Ed=o(e),gl=r(e,"TABLE",{"data-svelte-h":!0}),d(gl)!=="svelte-q8pfpb"&&(gl.innerHTML=Up),Jd=o(e),kd=r(e,"HR",{}),Dd=o(e),zl=r(e,"A",{id:!0,class:!0}),h(zl).forEach(l),Id=o(e),m(Pl.$$.fragment,e),qd=o(e),Ul=r(e,"P",{"data-svelte-h":!0}),d(Ul)!=="svelte-fju8tm"&&(Ul.textContent=Rp),Kd=o(e),Rl=r(e,"P",{"data-svelte-h":!0}),d(Rl)!=="svelte-13s6o0v"&&(Rl.innerHTML=jp),Nd=o(e),jl=r(e,"TABLE",{"data-svelte-h":!0}),d(jl)!=="svelte-8i278m"&&(jl.innerHTML=Ep),Bd=o(e),Vd=r(e,"HR",{}),Qd=o(e),El=r(e,"A",{id:!0,class:!0}),h(El).forEach(l),Sd=o(e),m(Jl.$$.fragment,e),Wd=o(e),kl=r(e,"P",{"data-svelte-h":!0}),d(kl)!=="svelte-11ei68w"&&(kl.textContent=Jp),Yd=o(e),Dl=r(e,"P",{"data-svelte-h":!0}),d(Dl)!=="svelte-1p3llh"&&(Dl.innerHTML=kp),Fd=o(e),Il=r(e,"TABLE",{"data-svelte-h":!0}),d(Il)!=="svelte-1xe0vb8"&&(Il.innerHTML=Dp),Od=o(e),Gd=r(e,"HR",{}),Zd=o(e),ql=r(e,"A",{id:!0,class:!0}),h(ql).forEach(l),Xd=o(e),m(Kl.$$.fragment,e),ea=o(e),Nl=r(e,"P",{"data-svelte-h":!0}),d(Nl)!=="svelte-7ivim4"&&(Nl.textContent=Ip),ta=o(e),Bl=r(e,"P",{"data-svelte-h":!0}),d(Bl)!=="svelte-151n4qz"&&(Bl.innerHTML=qp),la=o(e),Vl=r(e,"TABLE",{"data-svelte-h":!0}),d(Vl)!=="svelte-iprxta"&&(Vl.innerHTML=Kp),sa=o(e),na=r(e,"HR",{}),oa=o(e),Ql=r(e,"A",{id:!0,class:!0}),h(Ql).forEach(l),ia=o(e),m(Sl.$$.fragment,e),ra=o(e),Wl=r(e,"P",{"data-svelte-h":!0}),d(Wl)!=="svelte-k6p1db"&&(Wl.textContent=Np),da=o(e),Yl=r(e,"P",{"data-svelte-h":!0}),d(Yl)!=="svelte-1o30xnd"&&(Yl.innerHTML=Bp),aa=o(e),Fl=r(e,"TABLE",{"data-svelte-h":!0}),d(Fl)!=="svelte-101obk2"&&(Fl.innerHTML=Vp),ua=o(e),ma=r(e,"HR",{}),pa=o(e),Ol=r(e,"A",{id:!0,class:!0}),h(Ol).forEach(l),ca=o(e),m(Gl.$$.fragment,e),fa=o(e),Zl=r(e,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-8afo9v"&&(Zl.textContent=Qp),Ta=o(e),Xl=r(e,"P",{"data-svelte-h":!0}),d(Xl)!=="svelte-1vvmhgz"&&(Xl.innerHTML=Sp),ha=o(e),es=r(e,"TABLE",{"data-svelte-h":!0}),d(es)!=="svelte-wz2jkw"&&(es.innerHTML=Wp),_a=o(e),$a=r(e,"HR",{}),ya=o(e),ts=r(e,"A",{id:!0,class:!0}),h(ts).forEach(l),va=o(e),m(ls.$$.fragment,e),ba=o(e),ss=r(e,"P",{"data-svelte-h":!0}),d(ss)!=="svelte-11plveb"&&(ss.innerHTML=Yp),Ma=o(e),ns=r(e,"P",{"data-svelte-h":!0}),d(ns)!=="svelte-1wu8g4g"&&(ns.innerHTML=Fp),xa=o(e),os=r(e,"TABLE",{"data-svelte-h":!0}),d(os)!=="svelte-1vsvca3"&&(os.innerHTML=Op),Ca=o(e),Ha=r(e,"HR",{}),La=o(e),is=r(e,"A",{id:!0,class:!0}),h(is).forEach(l),wa=o(e),m(rs.$$.fragment,e),Aa=o(e),ds=r(e,"P",{"data-svelte-h":!0}),d(ds)!=="svelte-17f4oxi"&&(ds.textContent=Gp),ga=o(e),as=r(e,"P",{"data-svelte-h":!0}),d(as)!=="svelte-1lh8r1a"&&(as.innerHTML=Zp),za=o(e),us=r(e,"TABLE",{"data-svelte-h":!0}),d(us)!=="svelte-m4z8c4"&&(us.innerHTML=Xp),Pa=o(e),Ua=r(e,"HR",{}),Ra=o(e),ms=r(e,"A",{id:!0,class:!0}),h(ms).forEach(l),ja=o(e),m(ps.$$.fragment,e),Ea=o(e),cs=r(e,"P",{"data-svelte-h":!0}),d(cs)!=="svelte-kcewlk"&&(cs.textContent=ec),Ja=o(e),fs=r(e,"P",{"data-svelte-h":!0}),d(fs)!=="svelte-17f480h"&&(fs.innerHTML=tc),ka=o(e),Ts=r(e,"TABLE",{"data-svelte-h":!0}),d(Ts)!=="svelte-1to7jw8"&&(Ts.innerHTML=lc),Da=o(e),Ia=r(e,"HR",{}),qa=o(e),hs=r(e,"A",{id:!0,class:!0}),h(hs).forEach(l),Ka=o(e),m(_s.$$.fragment,e),Na=o(e),$s=r(e,"P",{"data-svelte-h":!0}),d($s)!=="svelte-1ayje0f"&&($s.textContent=sc),Ba=o(e),ys=r(e,"P",{"data-svelte-h":!0}),d(ys)!=="svelte-17f480h"&&(ys.innerHTML=nc),Va=o(e),vs=r(e,"TABLE",{"data-svelte-h":!0}),d(vs)!=="svelte-gyxne1"&&(vs.innerHTML=oc),Qa=o(e),Sa=r(e,"HR",{}),Wa=o(e),bs=r(e,"A",{id:!0,class:!0}),h(bs).forEach(l),Ya=o(e),m(Ms.$$.fragment,e),Fa=o(e),xs=r(e,"P",{"data-svelte-h":!0}),d(xs)!=="svelte-1wvb8sq"&&(xs.textContent=ic),Oa=o(e),Cs=r(e,"P",{"data-svelte-h":!0}),d(Cs)!=="svelte-154yhp4"&&(Cs.innerHTML=rc),Ga=o(e),Hs=r(e,"TABLE",{"data-svelte-h":!0}),d(Hs)!=="svelte-1fk5fng"&&(Hs.innerHTML=dc),Za=o(e),Xa=r(e,"HR",{}),eu=o(e),Ls=r(e,"A",{id:!0,class:!0}),h(Ls).forEach(l),tu=o(e),m(ws.$$.fragment,e),lu=o(e),As=r(e,"P",{"data-svelte-h":!0}),d(As)!=="svelte-12loz97"&&(As.innerHTML=ac),su=o(e),nu=r(e,"HR",{}),ou=o(e),gs=r(e,"A",{id:!0,class:!0}),h(gs).forEach(l),iu=o(e),m(zs.$$.fragment,e),ru=o(e),Ps=r(e,"P",{"data-svelte-h":!0}),d(Ps)!=="svelte-12loz97"&&(Ps.innerHTML=uc),du=o(e),au=r(e,"HR",{}),uu=o(e),Us=r(e,"A",{id:!0,class:!0}),h(Us).forEach(l),mu=o(e),m(Rs.$$.fragment,e),pu=o(e),js=r(e,"P",{"data-svelte-h":!0}),d(js)!=="svelte-40isdg"&&(js.textContent=mc),cu=o(e),Es=r(e,"P",{"data-svelte-h":!0}),d(Es)!=="svelte-tlsa2h"&&(Es.innerHTML=pc),fu=o(e),Js=r(e,"TABLE",{"data-svelte-h":!0}),d(Js)!=="svelte-17343p6"&&(Js.innerHTML=cc),Tu=o(e),ks=r(e,"P",{"data-svelte-h":!0}),d(ks)!=="svelte-1aswmub"&&(ks.innerHTML=fc),hu=o(e),m(Ds.$$.fragment,e),_u=o(e),$u=r(e,"HR",{}),yu=o(e),Is=r(e,"A",{id:!0,class:!0}),h(Is).forEach(l),vu=o(e),m(qs.$$.fragment,e),bu=o(e),Ks=r(e,"P",{"data-svelte-h":!0}),d(Ks)!=="svelte-kp31r8"&&(Ks.innerHTML=Tc),Mu=o(e),xu=r(e,"HR",{}),Cu=o(e),Ns=r(e,"A",{id:!0,class:!0}),h(Ns).forEach(l),Hu=o(e),m(Bs.$$.fragment,e),Lu=o(e),Vs=r(e,"P",{"data-svelte-h":!0}),d(Vs)!=="svelte-1fs9no9"&&(Vs.innerHTML=hc),wu=o(e),Au=r(e,"HR",{}),gu=o(e),Qs=r(e,"A",{id:!0,class:!0}),h(Qs).forEach(l),zu=o(e),m(Ss.$$.fragment,e),Pu=o(e),Ws=r(e,"P",{"data-svelte-h":!0}),d(Ws)!=="svelte-2mif9c"&&(Ws.textContent=_c),Uu=o(e),Ys=r(e,"P",{"data-svelte-h":!0}),d(Ys)!=="svelte-1jas2kw"&&(Ys.innerHTML=$c),Ru=o(e),m(Fs.$$.fragment,e),ju=o(e),Os=r(e,"P",{"data-svelte-h":!0}),d(Os)!=="svelte-1aswmub"&&(Os.innerHTML=yc),Eu=o(e),m(Gs.$$.fragment,e),Ju=o(e),Zs=r(e,"P",{"data-svelte-h":!0}),d(Zs)!=="svelte-1aswmub"&&(Zs.innerHTML=vc),ku=o(e),m(Xs.$$.fragment,e),Du=o(e),Iu=r(e,"HR",{}),qu=o(e),tn=r(e,"P",{}),h(tn).forEach(l),this.h()},h(){a($,"name","hf:doc:metadata"),a($,"content",gc),a(y,"id","module_utils/tensor"),a(y,"class","group"),a(C,"id","module_utils/tensor.Tensor"),a(C,"class","group"),a(A,"id","new_module_utils/tensor.Tensor_new"),a(A,"class","group"),a(U,"id","module_utils/tensor.Tensor+dims"),a(U,"class","group"),a(J,"id","module_utils/tensor.Tensor+type"),a(J,"class","group"),a(q,"id","module_utils/tensor.Tensor+data"),a(q,"class","group"),a(V,"id","module_utils/tensor.Tensor+size"),a(V,"class","group"),a(Y,"id","module_utils/tensor.Tensor+Symbol.iterator"),a(Y,"class","group"),a(Z,"id","module_utils/tensor.Tensor+_getitem"),a(Z,"class","group"),a(se,"id","module_utils/tensor.Tensor+indexOf"),a(se,"class","group"),a(re,"id","module_utils/tensor.Tensor+_subarray"),a(re,"class","group"),a(me,"id","module_utils/tensor.Tensor+item"),a(me,"class","group"),a(he,"id","module_utils/tensor.Tensor+tolist"),a(he,"class","group"),a(ve,"id","module_utils/tensor.Tensor+sigmoid"),a(ve,"class","group"),a(Ce,"id","module_utils/tensor.Tensor+sigmoid_"),a(Ce,"class","group"),a(Ae,"id","module_utils/tensor.Tensor+mul"),a(Ae,"class","group"),a(Re,"id","module_utils/tensor.Tensor+mul_"),a(Re,"class","group"),a(De,"id","module_utils/tensor.Tensor+add"),a(De,"class","group"),a(Be,"id","module_utils/tensor.Tensor+add_"),a(Be,"class","group"),a(Ye,"id","module_utils/tensor.Tensor+transpose"),a(Ye,"class","group"),a(Xe,"id","module_utils/tensor.Tensor+sum"),a(Xe,"class","group"),a(nt,"id","module_utils/tensor.Tensor+norm"),a(nt,"class","group"),a(at,"id","module_utils/tensor.Tensor+normalize_"),a(at,"class","group"),a(ft,"id","module_utils/tensor.Tensor+normalize"),a(ft,"class","group"),a(yt,"id","module_utils/tensor.Tensor+stride"),a(yt,"class","group"),a(xt,"id","module_utils/tensor.Tensor+squeeze"),a(xt,"class","group"),a(gt,"id","module_utils/tensor.Tensor+squeeze_"),a(gt,"class","group"),a(Rt,"id","module_utils/tensor.Tensor+unsqueeze"),a(Rt,"class","group"),a(It,"id","module_utils/tensor.Tensor+unsqueeze_"),a(It,"class","group"),a(Bt,"id","module_utils/tensor.Tensor+flatten_"),a(Bt,"class","group"),a(Wt,"id","module_utils/tensor.Tensor+flatten"),a(Wt,"class","group"),a(Zt,"id","module_utils/tensor.Tensor+view"),a(Zt,"class","group"),a(sl,"id","module_utils/tensor.Tensor+clamp_"),a(sl,"class","group"),a(rl,"id","module_utils/tensor.Tensor+clamp"),a(rl,"class","group"),a(pl,"id","module_utils/tensor.Tensor+round_"),a(pl,"class","group"),a(hl,"id","module_utils/tensor.Tensor+round"),a(hl,"class","group"),a(vl,"id","module_utils/tensor.Tensor+to"),a(vl,"class","group"),a(Hl,"id","module_utils/tensor.transpose"),a(Hl,"class","group"),a(zl,"id","module_utils/tensor.interpolate"),a(zl,"class","group"),a(El,"id","module_utils/tensor.mean_pooling"),a(El,"class","group"),a(ql,"id","module_utils/tensor.layer_norm"),a(ql,"class","group"),a(Ql,"id","module_utils/tensor.cat"),a(Ql,"class","group"),a(Ol,"id","module_utils/tensor.stack"),a(Ol,"class","group"),a(ts,"id","module_utils/tensor.std_mean"),a(ts,"class","group"),a(is,"id","module_utils/tensor.mean"),a(is,"class","group"),a(ms,"id","module_utils/tensor.dynamicTimeWarping"),a(ms,"class","group"),a(hs,"id","module_utils/tensor.ones"),a(hs,"class","group"),a(bs,"id","module_utils/tensor.ones_like"),a(bs,"class","group"),a(Ls,"id","module_utils/tensor..args[0]"),a(Ls,"class","group"),a(gs,"id","module_utils/tensor..args[1]"),a(gs,"class","group"),a(Us,"id","module_utils/tensor..reshape"),a(Us,"class","group"),a(Is,"id","module_utils/tensor..reshape..reshapedArray"),a(Is,"class","group"),a(Ns,"id","module_utils/tensor..DataArray"),a(Ns,"class","group"),a(Qs,"id","module_utils/tensor..NestArray"),a(Qs,"class","group")},m(e,t){wc(document.head,$),s(e,ln,t),s(e,en,t),s(e,sn,t),s(e,y,t),s(e,nn,t),p(v,e,t),s(e,on,t),s(e,b,t),s(e,rn,t),s(e,M,t),s(e,dn,t),s(e,x,t),s(e,an,t),s(e,un,t),s(e,mn,t),s(e,C,t),s(e,pn,t),p(H,e,t),s(e,cn,t),s(e,L,t),s(e,fn,t),s(e,w,t),s(e,Tn,t),s(e,hn,t),s(e,_n,t),s(e,A,t),s(e,$n,t),p(g,e,t),s(e,yn,t),s(e,z,t),s(e,vn,t),s(e,P,t),s(e,bn,t),s(e,Mn,t),s(e,xn,t),s(e,U,t),s(e,Cn,t),p(R,e,t),s(e,Hn,t),s(e,j,t),s(e,Ln,t),s(e,E,t),s(e,wn,t),s(e,An,t),s(e,gn,t),s(e,J,t),s(e,zn,t),p(k,e,t),s(e,Pn,t),s(e,D,t),s(e,Un,t),s(e,I,t),s(e,Rn,t),s(e,jn,t),s(e,En,t),s(e,q,t),s(e,Jn,t),p(K,e,t),s(e,kn,t),s(e,N,t),s(e,Dn,t),s(e,B,t),s(e,In,t),s(e,qn,t),s(e,Kn,t),s(e,V,t),s(e,Nn,t),p(Q,e,t),s(e,Bn,t),s(e,S,t),s(e,Vn,t),s(e,W,t),s(e,Qn,t),s(e,Sn,t),s(e,Wn,t),s(e,Y,t),s(e,Yn,t),p(F,e,t),s(e,Fn,t),s(e,O,t),s(e,On,t),s(e,G,t),s(e,Gn,t),s(e,Zn,t),s(e,Xn,t),s(e,Z,t),s(e,eo,t),p(X,e,t),s(e,to,t),s(e,ee,t),s(e,lo,t),s(e,te,t),s(e,so,t),s(e,le,t),s(e,no,t),s(e,oo,t),s(e,io,t),s(e,se,t),s(e,ro,t),p(ne,e,t),s(e,ao,t),s(e,oe,t),s(e,uo,t),s(e,ie,t),s(e,mo,t),s(e,po,t),s(e,co,t),s(e,re,t),s(e,fo,t),p(de,e,t),s(e,To,t),s(e,ae,t),s(e,ho,t),s(e,ue,t),s(e,_o,t),s(e,$o,t),s(e,yo,t),s(e,me,t),s(e,vo,t),p(pe,e,t),s(e,bo,t),s(e,ce,t),s(e,Mo,t),s(e,fe,t),s(e,xo,t),s(e,Te,t),s(e,Co,t),s(e,Ho,t),s(e,Lo,t),s(e,he,t),s(e,wo,t),p(_e,e,t),s(e,Ao,t),s(e,$e,t),s(e,go,t),s(e,ye,t),s(e,zo,t),s(e,Po,t),s(e,Uo,t),s(e,ve,t),s(e,Ro,t),p(be,e,t),s(e,jo,t),s(e,Me,t),s(e,Eo,t),s(e,xe,t),s(e,Jo,t),s(e,ko,t),s(e,Do,t),s(e,Ce,t),s(e,Io,t),p(He,e,t),s(e,qo,t),s(e,Le,t),s(e,Ko,t),s(e,we,t),s(e,No,t),s(e,Bo,t),s(e,Vo,t),s(e,Ae,t),s(e,Qo,t),p(ge,e,t),s(e,So,t),s(e,ze,t),s(e,Wo,t),s(e,Pe,t),s(e,Yo,t),s(e,Ue,t),s(e,Fo,t),s(e,Oo,t),s(e,Go,t),s(e,Re,t),s(e,Zo,t),p(je,e,t),s(e,Xo,t),s(e,Ee,t),s(e,ei,t),s(e,Je,t),s(e,ti,t),s(e,ke,t),s(e,li,t),s(e,si,t),s(e,ni,t),s(e,De,t),s(e,oi,t),p(Ie,e,t),s(e,ii,t),s(e,qe,t),s(e,ri,t),s(e,Ke,t),s(e,di,t),s(e,Ne,t),s(e,ai,t),s(e,ui,t),s(e,mi,t),s(e,Be,t),s(e,pi,t),p(Ve,e,t),s(e,ci,t),s(e,Qe,t),s(e,fi,t),s(e,Se,t),s(e,Ti,t),s(e,We,t),s(e,hi,t),s(e,_i,t),s(e,$i,t),s(e,Ye,t),s(e,yi,t),p(Fe,e,t),s(e,vi,t),s(e,Oe,t),s(e,bi,t),s(e,Ge,t),s(e,Mi,t),s(e,Ze,t),s(e,xi,t),s(e,Ci,t),s(e,Hi,t),s(e,Xe,t),s(e,Li,t),p(et,e,t),s(e,wi,t),s(e,tt,t),s(e,Ai,t),s(e,lt,t),s(e,gi,t),s(e,st,t),s(e,zi,t),s(e,Pi,t),s(e,Ui,t),s(e,nt,t),s(e,Ri,t),p(ot,e,t),s(e,ji,t),s(e,it,t),s(e,Ei,t),s(e,rt,t),s(e,Ji,t),s(e,dt,t),s(e,ki,t),s(e,Di,t),s(e,Ii,t),s(e,at,t),s(e,qi,t),p(ut,e,t),s(e,Ki,t),s(e,mt,t),s(e,Ni,t),s(e,pt,t),s(e,Bi,t),s(e,ct,t),s(e,Vi,t),s(e,Qi,t),s(e,Si,t),s(e,ft,t),s(e,Wi,t),p(Tt,e,t),s(e,Yi,t),s(e,ht,t),s(e,Fi,t),s(e,_t,t),s(e,Oi,t),s(e,$t,t),s(e,Gi,t),s(e,Zi,t),s(e,Xi,t),s(e,yt,t),s(e,er,t),p(vt,e,t),s(e,tr,t),s(e,bt,t),s(e,lr,t),s(e,Mt,t),s(e,sr,t),s(e,nr,t),s(e,or,t),s(e,xt,t),s(e,ir,t),p(Ct,e,t),s(e,rr,t),s(e,Ht,t),s(e,dr,t),s(e,Lt,t),s(e,ar,t),s(e,wt,t),s(e,ur,t),s(e,At,t),s(e,mr,t),s(e,pr,t),s(e,cr,t),s(e,gt,t),s(e,fr,t),p(zt,e,t),s(e,Tr,t),s(e,Pt,t),s(e,hr,t),s(e,Ut,t),s(e,_r,t),s(e,$r,t),s(e,yr,t),s(e,Rt,t),s(e,vr,t),p(jt,e,t),s(e,br,t),s(e,Et,t),s(e,Mr,t),s(e,Jt,t),s(e,xr,t),s(e,kt,t),s(e,Cr,t),s(e,Dt,t),s(e,Hr,t),s(e,Lr,t),s(e,wr,t),s(e,It,t),s(e,Ar,t),p(qt,e,t),s(e,gr,t),s(e,Kt,t),s(e,zr,t),s(e,Nt,t),s(e,Pr,t),s(e,Ur,t),s(e,Rr,t),s(e,Bt,t),s(e,jr,t),p(Vt,e,t),s(e,Er,t),s(e,Qt,t),s(e,Jr,t),s(e,St,t),s(e,kr,t),s(e,Dr,t),s(e,Ir,t),s(e,Wt,t),s(e,qr,t),p(Yt,e,t),s(e,Kr,t),s(e,Ft,t),s(e,Nr,t),s(e,Ot,t),s(e,Br,t),s(e,Gt,t),s(e,Vr,t),s(e,Qr,t),s(e,Sr,t),s(e,Zt,t),s(e,Wr,t),p(Xt,e,t),s(e,Yr,t),s(e,el,t),s(e,Fr,t),s(e,tl,t),s(e,Or,t),s(e,ll,t),s(e,Gr,t),s(e,Zr,t),s(e,Xr,t),s(e,sl,t),s(e,ed,t),p(nl,e,t),s(e,td,t),s(e,ol,t),s(e,ld,t),s(e,il,t),s(e,sd,t),s(e,nd,t),s(e,od,t),s(e,rl,t),s(e,id,t),p(dl,e,t),s(e,rd,t),s(e,al,t),s(e,dd,t),s(e,ul,t),s(e,ad,t),s(e,ml,t),s(e,ud,t),s(e,md,t),s(e,pd,t),s(e,pl,t),s(e,cd,t),p(cl,e,t),s(e,fd,t),s(e,fl,t),s(e,Td,t),s(e,Tl,t),s(e,hd,t),s(e,_d,t),s(e,$d,t),s(e,hl,t),s(e,yd,t),p(_l,e,t),s(e,vd,t),s(e,$l,t),s(e,bd,t),s(e,yl,t),s(e,Md,t),s(e,xd,t),s(e,Cd,t),s(e,vl,t),s(e,Hd,t),p(bl,e,t),s(e,Ld,t),s(e,Ml,t),s(e,wd,t),s(e,xl,t),s(e,Ad,t),s(e,Cl,t),s(e,gd,t),s(e,zd,t),s(e,Pd,t),s(e,Hl,t),s(e,Ud,t),p(Ll,e,t),s(e,Rd,t),s(e,wl,t),s(e,jd,t),s(e,Al,t),s(e,Ed,t),s(e,gl,t),s(e,Jd,t),s(e,kd,t),s(e,Dd,t),s(e,zl,t),s(e,Id,t),p(Pl,e,t),s(e,qd,t),s(e,Ul,t),s(e,Kd,t),s(e,Rl,t),s(e,Nd,t),s(e,jl,t),s(e,Bd,t),s(e,Vd,t),s(e,Qd,t),s(e,El,t),s(e,Sd,t),p(Jl,e,t),s(e,Wd,t),s(e,kl,t),s(e,Yd,t),s(e,Dl,t),s(e,Fd,t),s(e,Il,t),s(e,Od,t),s(e,Gd,t),s(e,Zd,t),s(e,ql,t),s(e,Xd,t),p(Kl,e,t),s(e,ea,t),s(e,Nl,t),s(e,ta,t),s(e,Bl,t),s(e,la,t),s(e,Vl,t),s(e,sa,t),s(e,na,t),s(e,oa,t),s(e,Ql,t),s(e,ia,t),p(Sl,e,t),s(e,ra,t),s(e,Wl,t),s(e,da,t),s(e,Yl,t),s(e,aa,t),s(e,Fl,t),s(e,ua,t),s(e,ma,t),s(e,pa,t),s(e,Ol,t),s(e,ca,t),p(Gl,e,t),s(e,fa,t),s(e,Zl,t),s(e,Ta,t),s(e,Xl,t),s(e,ha,t),s(e,es,t),s(e,_a,t),s(e,$a,t),s(e,ya,t),s(e,ts,t),s(e,va,t),p(ls,e,t),s(e,ba,t),s(e,ss,t),s(e,Ma,t),s(e,ns,t),s(e,xa,t),s(e,os,t),s(e,Ca,t),s(e,Ha,t),s(e,La,t),s(e,is,t),s(e,wa,t),p(rs,e,t),s(e,Aa,t),s(e,ds,t),s(e,ga,t),s(e,as,t),s(e,za,t),s(e,us,t),s(e,Pa,t),s(e,Ua,t),s(e,Ra,t),s(e,ms,t),s(e,ja,t),p(ps,e,t),s(e,Ea,t),s(e,cs,t),s(e,Ja,t),s(e,fs,t),s(e,ka,t),s(e,Ts,t),s(e,Da,t),s(e,Ia,t),s(e,qa,t),s(e,hs,t),s(e,Ka,t),p(_s,e,t),s(e,Na,t),s(e,$s,t),s(e,Ba,t),s(e,ys,t),s(e,Va,t),s(e,vs,t),s(e,Qa,t),s(e,Sa,t),s(e,Wa,t),s(e,bs,t),s(e,Ya,t),p(Ms,e,t),s(e,Fa,t),s(e,xs,t),s(e,Oa,t),s(e,Cs,t),s(e,Ga,t),s(e,Hs,t),s(e,Za,t),s(e,Xa,t),s(e,eu,t),s(e,Ls,t),s(e,tu,t),p(ws,e,t),s(e,lu,t),s(e,As,t),s(e,su,t),s(e,nu,t),s(e,ou,t),s(e,gs,t),s(e,iu,t),p(zs,e,t),s(e,ru,t),s(e,Ps,t),s(e,du,t),s(e,au,t),s(e,uu,t),s(e,Us,t),s(e,mu,t),p(Rs,e,t),s(e,pu,t),s(e,js,t),s(e,cu,t),s(e,Es,t),s(e,fu,t),s(e,Js,t),s(e,Tu,t),s(e,ks,t),s(e,hu,t),p(Ds,e,t),s(e,_u,t),s(e,$u,t),s(e,yu,t),s(e,Is,t),s(e,vu,t),p(qs,e,t),s(e,bu,t),s(e,Ks,t),s(e,Mu,t),s(e,xu,t),s(e,Cu,t),s(e,Ns,t),s(e,Hu,t),p(Bs,e,t),s(e,Lu,t),s(e,Vs,t),s(e,wu,t),s(e,Au,t),s(e,gu,t),s(e,Qs,t),s(e,zu,t),p(Ss,e,t),s(e,Pu,t),s(e,Ws,t),s(e,Uu,t),s(e,Ys,t),s(e,Ru,t),p(Fs,e,t),s(e,ju,t),s(e,Os,t),s(e,Eu,t),p(Gs,e,t),s(e,Ju,t),s(e,Zs,t),s(e,ku,t),p(Xs,e,t),s(e,Du,t),s(e,Iu,t),s(e,qu,t),s(e,tn,t),Ku=!0},p:Mc,i(e){Ku||(c(v.$$.fragment,e),c(H.$$.fragment,e),c(g.$$.fragment,e),c(R.$$.fragment,e),c(k.$$.fragment,e),c(K.$$.fragment,e),c(Q.$$.fragment,e),c(F.$$.fragment,e),c(X.$$.fragment,e),c(ne.$$.fragment,e),c(de.$$.fragment,e),c(pe.$$.fragment,e),c(_e.$$.fragment,e),c(be.$$.fragment,e),c(He.$$.fragment,e),c(ge.$$.fragment,e),c(je.$$.fragment,e),c(Ie.$$.fragment,e),c(Ve.$$.fragment,e),c(Fe.$$.fragment,e),c(et.$$.fragment,e),c(ot.$$.fragment,e),c(ut.$$.fragment,e),c(Tt.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(zt.$$.fragment,e),c(jt.$$.fragment,e),c(qt.$$.fragment,e),c(Vt.$$.fragment,e),c(Yt.$$.fragment,e),c(Xt.$$.fragment,e),c(nl.$$.fragment,e),c(dl.$$.fragment,e),c(cl.$$.fragment,e),c(_l.$$.fragment,e),c(bl.$$.fragment,e),c(Ll.$$.fragment,e),c(Pl.$$.fragment,e),c(Jl.$$.fragment,e),c(Kl.$$.fragment,e),c(Sl.$$.fragment,e),c(Gl.$$.fragment,e),c(ls.$$.fragment,e),c(rs.$$.fragment,e),c(ps.$$.fragment,e),c(_s.$$.fragment,e),c(Ms.$$.fragment,e),c(ws.$$.fragment,e),c(zs.$$.fragment,e),c(Rs.$$.fragment,e),c(Ds.$$.fragment,e),c(qs.$$.fragment,e),c(Bs.$$.fragment,e),c(Ss.$$.fragment,e),c(Fs.$$.fragment,e),c(Gs.$$.fragment,e),c(Xs.$$.fragment,e),Ku=!0)},o(e){f(v.$$.fragment,e),f(H.$$.fragment,e),f(g.$$.fragment,e),f(R.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(Q.$$.fragment,e),f(F.$$.fragment,e),f(X.$$.fragment,e),f(ne.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(He.$$.fragment,e),f(ge.$$.fragment,e),f(je.$$.fragment,e),f(Ie.$$.fragment,e),f(Ve.$$.fragment,e),f(Fe.$$.fragment,e),f(et.$$.fragment,e),f(ot.$$.fragment,e),f(ut.$$.fragment,e),f(Tt.$$.fragment,e),f(vt.$$.fragment,e),f(Ct.$$.fragment,e),f(zt.$$.fragment,e),f(jt.$$.fragment,e),f(qt.$$.fragment,e),f(Vt.$$.fragment,e),f(Yt.$$.fragment,e),f(Xt.$$.fragment,e),f(nl.$$.fragment,e),f(dl.$$.fragment,e),f(cl.$$.fragment,e),f(_l.$$.fragment,e),f(bl.$$.fragment,e),f(Ll.$$.fragment,e),f(Pl.$$.fragment,e),f(Jl.$$.fragment,e),f(Kl.$$.fragment,e),f(Sl.$$.fragment,e),f(Gl.$$.fragment,e),f(ls.$$.fragment,e),f(rs.$$.fragment,e),f(ps.$$.fragment,e),f(_s.$$.fragment,e),f(Ms.$$.fragment,e),f(ws.$$.fragment,e),f(zs.$$.fragment,e),f(Rs.$$.fragment,e),f(Ds.$$.fragment,e),f(qs.$$.fragment,e),f(Bs.$$.fragment,e),f(Ss.$$.fragment,e),f(Fs.$$.fragment,e),f(Gs.$$.fragment,e),f(Xs.$$.fragment,e),Ku=!1},d(e){e&&(l(ln),l(en),l(sn),l(y),l(nn),l(on),l(b),l(rn),l(M),l(dn),l(x),l(an),l(un),l(mn),l(C),l(pn),l(cn),l(L),l(fn),l(w),l(Tn),l(hn),l(_n),l(A),l($n),l(yn),l(z),l(vn),l(P),l(bn),l(Mn),l(xn),l(U),l(Cn),l(Hn),l(j),l(Ln),l(E),l(wn),l(An),l(gn),l(J),l(zn),l(Pn),l(D),l(Un),l(I),l(Rn),l(jn),l(En),l(q),l(Jn),l(kn),l(N),l(Dn),l(B),l(In),l(qn),l(Kn),l(V),l(Nn),l(Bn),l(S),l(Vn),l(W),l(Qn),l(Sn),l(Wn),l(Y),l(Yn),l(Fn),l(O),l(On),l(G),l(Gn),l(Zn),l(Xn),l(Z),l(eo),l(to),l(ee),l(lo),l(te),l(so),l(le),l(no),l(oo),l(io),l(se),l(ro),l(ao),l(oe),l(uo),l(ie),l(mo),l(po),l(co),l(re),l(fo),l(To),l(ae),l(ho),l(ue),l(_o),l($o),l(yo),l(me),l(vo),l(bo),l(ce),l(Mo),l(fe),l(xo),l(Te),l(Co),l(Ho),l(Lo),l(he),l(wo),l(Ao),l($e),l(go),l(ye),l(zo),l(Po),l(Uo),l(ve),l(Ro),l(jo),l(Me),l(Eo),l(xe),l(Jo),l(ko),l(Do),l(Ce),l(Io),l(qo),l(Le),l(Ko),l(we),l(No),l(Bo),l(Vo),l(Ae),l(Qo),l(So),l(ze),l(Wo),l(Pe),l(Yo),l(Ue),l(Fo),l(Oo),l(Go),l(Re),l(Zo),l(Xo),l(Ee),l(ei),l(Je),l(ti),l(ke),l(li),l(si),l(ni),l(De),l(oi),l(ii),l(qe),l(ri),l(Ke),l(di),l(Ne),l(ai),l(ui),l(mi),l(Be),l(pi),l(ci),l(Qe),l(fi),l(Se),l(Ti),l(We),l(hi),l(_i),l($i),l(Ye),l(yi),l(vi),l(Oe),l(bi),l(Ge),l(Mi),l(Ze),l(xi),l(Ci),l(Hi),l(Xe),l(Li),l(wi),l(tt),l(Ai),l(lt),l(gi),l(st),l(zi),l(Pi),l(Ui),l(nt),l(Ri),l(ji),l(it),l(Ei),l(rt),l(Ji),l(dt),l(ki),l(Di),l(Ii),l(at),l(qi),l(Ki),l(mt),l(Ni),l(pt),l(Bi),l(ct),l(Vi),l(Qi),l(Si),l(ft),l(Wi),l(Yi),l(ht),l(Fi),l(_t),l(Oi),l($t),l(Gi),l(Zi),l(Xi),l(yt),l(er),l(tr),l(bt),l(lr),l(Mt),l(sr),l(nr),l(or),l(xt),l(ir),l(rr),l(Ht),l(dr),l(Lt),l(ar),l(wt),l(ur),l(At),l(mr),l(pr),l(cr),l(gt),l(fr),l(Tr),l(Pt),l(hr),l(Ut),l(_r),l($r),l(yr),l(Rt),l(vr),l(br),l(Et),l(Mr),l(Jt),l(xr),l(kt),l(Cr),l(Dt),l(Hr),l(Lr),l(wr),l(It),l(Ar),l(gr),l(Kt),l(zr),l(Nt),l(Pr),l(Ur),l(Rr),l(Bt),l(jr),l(Er),l(Qt),l(Jr),l(St),l(kr),l(Dr),l(Ir),l(Wt),l(qr),l(Kr),l(Ft),l(Nr),l(Ot),l(Br),l(Gt),l(Vr),l(Qr),l(Sr),l(Zt),l(Wr),l(Yr),l(el),l(Fr),l(tl),l(Or),l(ll),l(Gr),l(Zr),l(Xr),l(sl),l(ed),l(td),l(ol),l(ld),l(il),l(sd),l(nd),l(od),l(rl),l(id),l(rd),l(al),l(dd),l(ul),l(ad),l(ml),l(ud),l(md),l(pd),l(pl),l(cd),l(fd),l(fl),l(Td),l(Tl),l(hd),l(_d),l($d),l(hl),l(yd),l(vd),l($l),l(bd),l(yl),l(Md),l(xd),l(Cd),l(vl),l(Hd),l(Ld),l(Ml),l(wd),l(xl),l(Ad),l(Cl),l(gd),l(zd),l(Pd),l(Hl),l(Ud),l(Rd),l(wl),l(jd),l(Al),l(Ed),l(gl),l(Jd),l(kd),l(Dd),l(zl),l(Id),l(qd),l(Ul),l(Kd),l(Rl),l(Nd),l(jl),l(Bd),l(Vd),l(Qd),l(El),l(Sd),l(Wd),l(kl),l(Yd),l(Dl),l(Fd),l(Il),l(Od),l(Gd),l(Zd),l(ql),l(Xd),l(ea),l(Nl),l(ta),l(Bl),l(la),l(Vl),l(sa),l(na),l(oa),l(Ql),l(ia),l(ra),l(Wl),l(da),l(Yl),l(aa),l(Fl),l(ua),l(ma),l(pa),l(Ol),l(ca),l(fa),l(Zl),l(Ta),l(Xl),l(ha),l(es),l(_a),l($a),l(ya),l(ts),l(va),l(ba),l(ss),l(Ma),l(ns),l(xa),l(os),l(Ca),l(Ha),l(La),l(is),l(wa),l(Aa),l(ds),l(ga),l(as),l(za),l(us),l(Pa),l(Ua),l(Ra),l(ms),l(ja),l(Ea),l(cs),l(Ja),l(fs),l(ka),l(Ts),l(Da),l(Ia),l(qa),l(hs),l(Ka),l(Na),l($s),l(Ba),l(ys),l(Va),l(vs),l(Qa),l(Sa),l(Wa),l(bs),l(Ya),l(Fa),l(xs),l(Oa),l(Cs),l(Ga),l(Hs),l(Za),l(Xa),l(eu),l(Ls),l(tu),l(lu),l(As),l(su),l(nu),l(ou),l(gs),l(iu),l(ru),l(Ps),l(du),l(au),l(uu),l(Us),l(mu),l(pu),l(js),l(cu),l(Es),l(fu),l(Js),l(Tu),l(ks),l(hu),l(_u),l($u),l(yu),l(Is),l(vu),l(bu),l(Ks),l(Mu),l(xu),l(Cu),l(Ns),l(Hu),l(Lu),l(Vs),l(wu),l(Au),l(gu),l(Qs),l(zu),l(Pu),l(Ws),l(Uu),l(Ys),l(Ru),l(ju),l(Os),l(Eu),l(Ju),l(Zs),l(ku),l(Du),l(Iu),l(qu),l(tn)),l($),T(v,e),T(H,e),T(g,e),T(R,e),T(k,e),T(K,e),T(Q,e),T(F,e),T(X,e),T(ne,e),T(de,e),T(pe,e),T(_e,e),T(be,e),T(He,e),T(ge,e),T(je,e),T(Ie,e),T(Ve,e),T(Fe,e),T(et,e),T(ot,e),T(ut,e),T(Tt,e),T(vt,e),T(Ct,e),T(zt,e),T(jt,e),T(qt,e),T(Vt,e),T(Yt,e),T(Xt,e),T(nl,e),T(dl,e),T(cl,e),T(_l,e),T(bl,e),T(Ll,e),T(Pl,e),T(Jl,e),T(Kl,e),T(Sl,e),T(Gl,e),T(ls,e),T(rs,e),T(ps,e),T(_s,e),T(Ms,e),T(ws,e),T(zs,e),T(Rs,e),T(Ds,e),T(qs,e),T(Bs,e),T(Ss,e),T(Fs,e),T(Gs,e),T(Xs,e)}}}const gc='{"title":"utils/tensor","local":"utilstensor","sections":[{"title":"utils/tensor.Tensor","local":"utilstensortensor","sections":[{"title":"new Tensor(...args)","local":"new-tensorargs","sections":[],"depth":3},{"title":"tensor.dims : <code> Array. < number > </code>","local":"tensordims--code-array--number--code","sections":[],"depth":3},{"title":"tensor.type : <code> DataType </code>","local":"tensortype--code-datatype-code","sections":[],"depth":3},{"title":"tensor.data : <code> DataArray </code>","local":"tensordata--code-dataarray-code","sections":[],"depth":3},{"title":"tensor.size : <code> number </code>","local":"tensorsize--code-number-code","sections":[],"depth":3},{"title":"tensor.Symbol.iterator() ⇒ <code> Iterator </code>","local":"tensorsymboliterator--code-iterator-code","sections":[],"depth":3},{"title":"tensor._getitem(index) ⇒ <code> Tensor </code>","local":"tensorgetitemindex--code-tensor-code","sections":[],"depth":3},{"title":"tensor.indexOf(item) ⇒ <code> number </code>","local":"tensorindexofitem--code-number-code","sections":[],"depth":3},{"title":"tensor._subarray(index, iterSize, iterDims) ⇒ <code> Tensor </code>","local":"tensorsubarrayindex-itersize-iterdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.item() ⇒ <code> number </code> | <code> bigint </code>","local":"tensoritem--code-number-code--code-bigint-code","sections":[],"depth":3},{"title":"tensor.tolist() ⇒ <code> Array </code>","local":"tensortolist--code-array-code","sections":[],"depth":3},{"title":"tensor.sigmoid() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sigmoid_() ⇒ <code> Tensor </code>","local":"tensorsigmoid--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.mul_(val) ⇒ <code> Tensor </code>","local":"tensormulval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.add_(val) ⇒ <code> Tensor </code>","local":"tensoraddval--code-tensor-code","sections":[],"depth":3},{"title":"tensor.transpose(...dims) ⇒ <code> Tensor </code>","local":"tensortransposedims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.sum([dim], keepdim) ⇒","local":"tensorsumdim-keepdim-","sections":[],"depth":3},{"title":"tensor.norm([p], [dim], [keepdim]) ⇒ <code> Tensor </code>","local":"tensornormp-dim-keepdim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize_([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.normalize([p], [dim]) ⇒ <code> Tensor </code>","local":"tensornormalizep-dim--code-tensor-code","sections":[],"depth":3},{"title":"tensor.stride() ⇒ <code> Array. < number > </code>","local":"tensorstride--code-array--number--code","sections":[],"depth":3},{"title":"tensor.squeeze([dim]) ⇒","local":"tensorsqueezedim-","sections":[],"depth":3},{"title":"tensor.squeeze_()","local":"tensorsqueeze","sections":[],"depth":3},{"title":"tensor.unsqueeze(dim) ⇒","local":"tensorunsqueezedim-","sections":[],"depth":3},{"title":"tensor.unsqueeze_()","local":"tensorunsqueeze","sections":[],"depth":3},{"title":"tensor.flatten_()","local":"tensorflatten","sections":[],"depth":3},{"title":"tensor.flatten(start_dim, end_dim) ⇒","local":"tensorflattenstartdim-enddim-","sections":[],"depth":3},{"title":"tensor.view(...dims) ⇒ <code> Tensor </code>","local":"tensorviewdims--code-tensor-code","sections":[],"depth":3},{"title":"tensor.clamp_()","local":"tensorclamp","sections":[],"depth":3},{"title":"tensor.clamp(min, max) ⇒","local":"tensorclampmin-max-","sections":[],"depth":3},{"title":"tensor.round_()","local":"tensorround","sections":[],"depth":3},{"title":"tensor.round() ⇒","local":"tensorround-","sections":[],"depth":3},{"title":"tensor.to(type) ⇒ <code> Tensor </code>","local":"tensortotype--code-tensor-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor.transpose(tensor, axes) ⇒ <code> Tensor </code>","local":"utilstensortransposetensor-axes--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.interpolate(input, size, mode, align_corners) ⇒ <code> Tensor </code>","local":"utilstensorinterpolateinput-size-mode-aligncorners--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.mean_pooling(last_hidden_state, attention_mask) ⇒ <code> Tensor </code>","local":"utilstensormeanpoolinglasthiddenstate-attentionmask--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.layer_norm(input, normalized_shape, options) ⇒ <code> Tensor </code>","local":"utilstensorlayernorminput-normalizedshape-options--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.cat(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorcattensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.stack(tensors, dim) ⇒ <code> Tensor </code>","local":"utilstensorstacktensors-dim--code-tensor-code","sections":[],"depth":2},{"title":"utils/tensor.std_mean(input, dim, correction, keepdim) ⇒ <code> Array. < Tensor > </code>","local":"utilstensorstdmeaninput-dim-correction-keepdim--code-array--tensor--code","sections":[],"depth":2},{"title":"utils/tensor.mean(input, dim, keepdim) ⇒","local":"utilstensormeaninput-dim-keepdim-","sections":[],"depth":2},{"title":"utils/tensor.dynamicTimeWarping(matrix) ⇒ <code> Array. < Array < number > > </code>","local":"utilstensordynamictimewarpingmatrix--code-array--array--number---code","sections":[],"depth":2},{"title":"utils/tensor.ones(size)","local":"utilstensoronessize","sections":[],"depth":2},{"title":"utils/tensor.ones_like(tensor) ⇒","local":"utilstensoronesliketensor-","sections":[],"depth":2},{"title":"utils/tensor~args[0] : <code> DataType </code>","local":"utilstensorargs0--code-datatype-code","sections":[],"depth":2},{"title":"utils/tensor~args[1] : <code> * </code>","local":"utilstensorargs1--code--code","sections":[],"depth":2},{"title":"utils/tensor~reshape(data, dimensions) ⇒ <code> * </code>","local":"utilstensorreshapedata-dimensions--code--code","sections":[{"title":"reshape~reshapedArray : <code> any </code>","local":"reshapereshapedarray--code-any-code","sections":[],"depth":3}],"depth":2},{"title":"utils/tensor~DataArray : <code> * </code>","local":"utilstensordataarray--code--code","sections":[],"depth":2},{"title":"utils/tensor~NestArray : <code> * </code>","local":"utilstensornestarray--code--code","sections":[],"depth":2}],"depth":1}';function zc(Bu){return xc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ec extends Cc{constructor($){super(),Hc(this,$,zc,Ac,bc,{})}}export{Ec as component};
