import{s as Ci,n as Pi,o as Ji}from"../chunks/scheduler.b108d059.js";import{S as Hi,i as Ii,g as l,s as o,r as p,A as Fi,h as d,f as r,c as a,j as f,u as m,x as i,k as c,y as ki,a as s,v as n,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as Bl}from"../chunks/CodeBlock.3968c746.js";import{H as g}from"../chunks/Heading.88bfeb84.js";function ji(Wl){let x,vr,br,$r,T,wr,b,Mr,y,Nl="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Er,v,Gl="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",Cr,$,Pr,w,Zl='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Jr,Hr,Ir,M,Fr,E,kr,C,Ql="Base class for feature extractors.",jr,P,Xl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',Lr,zr,Ar,J,Rr,H,Ur,I,Vl="Constructs a new FeatureExtractor instance.",Dr,F,Yl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",Br,Wr,Nr,k,Gr,j,Zr,L,Sl="Feature extractor for image models.",Qr,z,ql='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',Xr,A,Kl='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Vr,Yr,Sr,R,qr,U,Kr,D,Ol="Constructs a new ImageFeatureExtractor instance.",Or,B,ed="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",es,ts,rs,W,ss,N,os,G,td=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,as,Z,rd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',ls,Q,sd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",ds,is,cs,X,ps,V,ms,Y,od="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",ns,S,ad='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',us,q,ld="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",hs,_s,fs,K,gs,O,xs,ee,dd="Pad the image by a certain amount.",Ts,te,id='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',bs,re,cd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image.</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",ys,vs,$s,se,ws,oe,Ms,ae,pd="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",Es,le,md='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',Cs,de,nd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Ps,Js,Hs,ie,Is,ce,Fs,pe,ud=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,ks,me,hd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',js,ne,_d="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",Ls,zs,As,ue,Rs,he,Us,_e,fd="Resizes the image.",Ds,fe,gd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Bs,ge,xd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",Ws,Ns,Gs,xe,Zs,Te,Qs,be,Td="Preprocesses the given image.",Xs,ye,bd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',Vs,ve,yd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",Ys,Ss,qs,$e,Ks,we,Os,Me,vd=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,eo,Ee,$d='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',to,Ce,wd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",ro,so,oo,Pe,ao,Je,lo,He,Md="Detr Feature Extractor.",io,Ie,Ed='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',co,Fe,Cd='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',po,mo,no,ke,uo,je,ho,Le,Pd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,_o,ze,Jd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',fo,Ae,Hd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",go,xo,To,Re,bo,Ue,yo,De,Id='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',vo,$o,wo,Be,Mo,We,Eo,Ne,Fd="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",Co,Ge,kd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Po,Ze,jd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Jo,Ho,Io,Qe,Fo,Xe,ko,Ve,Ld="Checks whether the segment is valid or not.",jo,Ye,zd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',Lo,Se,Ad="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",zo,Ao,Ro,qe,Uo,Ke,Do,Oe,Rd="Computes the segments.",Bo,et,Ud='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',Wo,tt,Dd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",No,Go,Zo,rt,Qo,st,Xo,ot,Bd="Post-process the model output to generate the final panoptic segmentation.",Vo,at,Wd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Yo,lt,Nd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",So,qo,Ko,dt,Oo,it,ea,ct,Gd="Represents a Processor that extracts features from an input.",ta,pt,Zd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',ra,mt,Qd='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',sa,oa,aa,nt,la,ut,da,ht,Xd="Creates a new Processor with the given feature extractor.",ia,_t,Vd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",ca,pa,ma,ft,na,gt,ua,xt,Yd="Calls the feature_extractor function with the given input.",ha,Tt,Sd='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',_a,bt,qd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",fa,ga,xa,yt,Ta,vt,ba,$t,Kd="Represents a WhisperProcessor that extracts features from an audio input.",ya,wt,Od='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',va,$a,wa,Mt,Ma,Et,Ea,Ct,ei="Calls the feature_extractor function with the given audio input.",Ca,Pt,ti='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Pa,Jt,ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Ja,Ha,Ia,Ht,Fa,It,ka,Ft,si=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,ja,kt,oi="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",La,jt,za,Lt,ai="<strong>Example:</strong> Run an image through a processor.",Aa,zt,Ra,At,li='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ua,Da,Ba,Rt,Wa,Ut,Na,Dt,di="Instantiate one of the processor classes of the library from a pretrained model.",Ga,Bt,ii=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Za,Wt,ci='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',Qa,Nt,pi=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,Xa,Va,Ya,Gt,Sa,Zt,qa,Qt,mi="Converts bounding boxes from center format to corners format.",Ka,Xt,ni='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',Oa,Vt,ui="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",el,tl,rl,Yt,sl,St,ol,qt,hi="Rounds the height and width down to the closest multiple of size_divisibility",al,Kt,_i='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',ll,Ot,fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",dl,il,cl,er,pl,tr,ml,rr,gi=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,nl,sr,xi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',ul,hl,_l,or,fl,ar,gl,lr,Ti='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',xl,dr,bi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",Tl,bl,yl,ir,vl,cr,$l,pr,yi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',wl,mr,vi="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",Ml,El,Cl,nr,Pl,ur,Jl,hr,$i='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Hl,_r,wi="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Il,Fl,kl,fr,jl,gr,Ll,xr,Mi='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',zl,Tr,Ei="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td></tr></tbody>",Al,Rl,Ul,yr,Dl;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),$=new Bl({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),H=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),j=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),U=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),oe=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),ce=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),he=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Te=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),we=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),Je=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),je=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Ue=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),We=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),Xe=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),Ke=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),st=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),it=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),ut=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),gt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),vt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),Et=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),It=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),jt=new Bl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),zt=new Bl({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ut=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),Zt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),St=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),tr=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),ar=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),cr=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),ur=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),gr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){x=l("meta"),vr=o(),br=l("p"),$r=o(),T=l("a"),wr=o(),p(b.$$.fragment),Mr=o(),y=l("p"),y.textContent=Nl,Er=o(),v=l("p"),v.innerHTML=Gl,Cr=o(),p($.$$.fragment),Pr=o(),w=l("ul"),w.innerHTML=Zl,Jr=o(),Hr=l("hr"),Ir=o(),M=l("a"),Fr=o(),p(E.$$.fragment),kr=o(),C=l("p"),C.textContent=Ql,jr=o(),P=l("p"),P.innerHTML=Xl,Lr=o(),zr=l("hr"),Ar=o(),J=l("a"),Rr=o(),p(H.$$.fragment),Ur=o(),I=l("p"),I.textContent=Vl,Dr=o(),F=l("table"),F.innerHTML=Yl,Br=o(),Wr=l("hr"),Nr=o(),k=l("a"),Gr=o(),p(j.$$.fragment),Zr=o(),L=l("p"),L.textContent=Sl,Qr=o(),z=l("p"),z.innerHTML=ql,Xr=o(),A=l("ul"),A.innerHTML=Kl,Vr=o(),Yr=l("hr"),Sr=o(),R=l("a"),qr=o(),p(U.$$.fragment),Kr=o(),D=l("p"),D.textContent=Ol,Or=o(),B=l("table"),B.innerHTML=ed,es=o(),ts=l("hr"),rs=o(),W=l("a"),ss=o(),p(N.$$.fragment),os=o(),G=l("p"),G.textContent=td,as=o(),Z=l("p"),Z.innerHTML=rd,ls=o(),Q=l("table"),Q.innerHTML=sd,ds=o(),is=l("hr"),cs=o(),X=l("a"),ps=o(),p(V.$$.fragment),ms=o(),Y=l("p"),Y.textContent=od,ns=o(),S=l("p"),S.innerHTML=ad,us=o(),q=l("table"),q.innerHTML=ld,hs=o(),_s=l("hr"),fs=o(),K=l("a"),gs=o(),p(O.$$.fragment),xs=o(),ee=l("p"),ee.textContent=dd,Ts=o(),te=l("p"),te.innerHTML=id,bs=o(),re=l("table"),re.innerHTML=cd,ys=o(),vs=l("hr"),$s=o(),se=l("a"),ws=o(),p(oe.$$.fragment),Ms=o(),ae=l("p"),ae.innerHTML=pd,Es=o(),le=l("p"),le.innerHTML=md,Cs=o(),de=l("table"),de.innerHTML=nd,Ps=o(),Js=l("hr"),Hs=o(),ie=l("a"),Is=o(),p(ce.$$.fragment),Fs=o(),pe=l("p"),pe.textContent=ud,ks=o(),me=l("p"),me.innerHTML=hd,js=o(),ne=l("table"),ne.innerHTML=_d,Ls=o(),zs=l("hr"),As=o(),ue=l("a"),Rs=o(),p(he.$$.fragment),Us=o(),_e=l("p"),_e.textContent=fd,Ds=o(),fe=l("p"),fe.innerHTML=gd,Bs=o(),ge=l("table"),ge.innerHTML=xd,Ws=o(),Ns=l("hr"),Gs=o(),xe=l("a"),Zs=o(),p(Te.$$.fragment),Qs=o(),be=l("p"),be.textContent=Td,Xs=o(),ye=l("p"),ye.innerHTML=bd,Vs=o(),ve=l("table"),ve.innerHTML=yd,Ys=o(),Ss=l("hr"),qs=o(),$e=l("a"),Ks=o(),p(we.$$.fragment),Os=o(),Me=l("p"),Me.textContent=vd,eo=o(),Ee=l("p"),Ee.innerHTML=$d,to=o(),Ce=l("table"),Ce.innerHTML=wd,ro=o(),so=l("hr"),oo=o(),Pe=l("a"),ao=o(),p(Je.$$.fragment),lo=o(),He=l("p"),He.textContent=Md,io=o(),Ie=l("p"),Ie.innerHTML=Ed,co=o(),Fe=l("ul"),Fe.innerHTML=Cd,po=o(),mo=l("hr"),no=o(),ke=l("a"),uo=o(),p(je.$$.fragment),ho=o(),Le=l("p"),Le.textContent=Pd,_o=o(),ze=l("p"),ze.innerHTML=Jd,fo=o(),Ae=l("table"),Ae.innerHTML=Hd,go=o(),xo=l("hr"),To=o(),Re=l("a"),bo=o(),p(Ue.$$.fragment),yo=o(),De=l("p"),De.innerHTML=Id,vo=o(),$o=l("hr"),wo=o(),Be=l("a"),Mo=o(),p(We.$$.fragment),Eo=o(),Ne=l("p"),Ne.innerHTML=Fd,Co=o(),Ge=l("p"),Ge.innerHTML=kd,Po=o(),Ze=l("table"),Ze.innerHTML=jd,Jo=o(),Ho=l("hr"),Io=o(),Qe=l("a"),Fo=o(),p(Xe.$$.fragment),ko=o(),Ve=l("p"),Ve.textContent=Ld,jo=o(),Ye=l("p"),Ye.innerHTML=zd,Lo=o(),Se=l("table"),Se.innerHTML=Ad,zo=o(),Ao=l("hr"),Ro=o(),qe=l("a"),Uo=o(),p(Ke.$$.fragment),Do=o(),Oe=l("p"),Oe.textContent=Rd,Bo=o(),et=l("p"),et.innerHTML=Ud,Wo=o(),tt=l("table"),tt.innerHTML=Dd,No=o(),Go=l("hr"),Zo=o(),rt=l("a"),Qo=o(),p(st.$$.fragment),Xo=o(),ot=l("p"),ot.textContent=Bd,Vo=o(),at=l("p"),at.innerHTML=Wd,Yo=o(),lt=l("table"),lt.innerHTML=Nd,So=o(),qo=l("hr"),Ko=o(),dt=l("a"),Oo=o(),p(it.$$.fragment),ea=o(),ct=l("p"),ct.textContent=Gd,ta=o(),pt=l("p"),pt.innerHTML=Zd,ra=o(),mt=l("ul"),mt.innerHTML=Qd,sa=o(),oa=l("hr"),aa=o(),nt=l("a"),la=o(),p(ut.$$.fragment),da=o(),ht=l("p"),ht.textContent=Xd,ia=o(),_t=l("table"),_t.innerHTML=Vd,ca=o(),pa=l("hr"),ma=o(),ft=l("a"),na=o(),p(gt.$$.fragment),ua=o(),xt=l("p"),xt.textContent=Yd,ha=o(),Tt=l("p"),Tt.innerHTML=Sd,_a=o(),bt=l("table"),bt.innerHTML=qd,fa=o(),ga=l("hr"),xa=o(),yt=l("a"),Ta=o(),p(vt.$$.fragment),ba=o(),$t=l("p"),$t.textContent=Kd,ya=o(),wt=l("p"),wt.innerHTML=Od,va=o(),$a=l("hr"),wa=o(),Mt=l("a"),Ma=o(),p(Et.$$.fragment),Ea=o(),Ct=l("p"),Ct.textContent=ei,Ca=o(),Pt=l("p"),Pt.innerHTML=ti,Pa=o(),Jt=l("table"),Jt.innerHTML=ri,Ja=o(),Ha=l("hr"),Ia=o(),Ht=l("a"),Fa=o(),p(It.$$.fragment),ka=o(),Ft=l("p"),Ft.innerHTML=si,ja=o(),kt=l("p"),kt.innerHTML=oi,La=o(),p(jt.$$.fragment),za=o(),Lt=l("p"),Lt.innerHTML=ai,Aa=o(),p(zt.$$.fragment),Ra=o(),At=l("p"),At.innerHTML=li,Ua=o(),Da=l("hr"),Ba=o(),Rt=l("a"),Wa=o(),p(Ut.$$.fragment),Na=o(),Dt=l("p"),Dt.textContent=di,Ga=o(),Bt=l("p"),Bt.innerHTML=ii,Za=o(),Wt=l("p"),Wt.innerHTML=ci,Qa=o(),Nt=l("table"),Nt.innerHTML=pi,Xa=o(),Va=l("hr"),Ya=o(),Gt=l("a"),Sa=o(),p(Zt.$$.fragment),qa=o(),Qt=l("p"),Qt.textContent=mi,Ka=o(),Xt=l("p"),Xt.innerHTML=ni,Oa=o(),Vt=l("table"),Vt.innerHTML=ui,el=o(),tl=l("hr"),rl=o(),Yt=l("a"),sl=o(),p(St.$$.fragment),ol=o(),qt=l("p"),qt.textContent=hi,al=o(),Kt=l("p"),Kt.innerHTML=_i,ll=o(),Ot=l("table"),Ot.innerHTML=fi,dl=o(),il=l("hr"),cl=o(),er=l("a"),pl=o(),p(tr.$$.fragment),ml=o(),rr=l("p"),rr.textContent=gi,nl=o(),sr=l("p"),sr.innerHTML=xi,ul=o(),hl=l("hr"),_l=o(),or=l("a"),fl=o(),p(ar.$$.fragment),gl=o(),lr=l("p"),lr.innerHTML=Ti,xl=o(),dr=l("table"),dr.innerHTML=bi,Tl=o(),bl=l("hr"),yl=o(),ir=l("a"),vl=o(),p(cr.$$.fragment),$l=o(),pr=l("p"),pr.innerHTML=yi,wl=o(),mr=l("table"),mr.innerHTML=vi,Ml=o(),El=l("hr"),Cl=o(),nr=l("a"),Pl=o(),p(ur.$$.fragment),Jl=o(),hr=l("p"),hr.innerHTML=$i,Hl=o(),_r=l("table"),_r.innerHTML=wi,Il=o(),Fl=l("hr"),kl=o(),fr=l("a"),jl=o(),p(gr.$$.fragment),Ll=o(),xr=l("p"),xr.innerHTML=Mi,zl=o(),Tr=l("table"),Tr.innerHTML=Ei,Al=o(),Rl=l("hr"),Ul=o(),yr=l("p"),this.h()},l(e){const t=Fi("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),vr=a(e),br=d(e,"P",{}),f(br).forEach(r),$r=a(e),T=d(e,"A",{id:!0,class:!0}),f(T).forEach(r),wr=a(e),m(b.$$.fragment,e),Mr=a(e),y=d(e,"P",{"data-svelte-h":!0}),i(y)!=="svelte-w0rx8m"&&(y.textContent=Nl),Er=a(e),v=d(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1olsie5"&&(v.innerHTML=Gl),Cr=a(e),m($.$$.fragment,e),Pr=a(e),w=d(e,"UL",{"data-svelte-h":!0}),i(w)!=="svelte-tl9vbq"&&(w.innerHTML=Zl),Jr=a(e),Hr=d(e,"HR",{}),Ir=a(e),M=d(e,"A",{id:!0,class:!0}),f(M).forEach(r),Fr=a(e),m(E.$$.fragment,e),kr=a(e),C=d(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-14r3pvv"&&(C.textContent=Ql),jr=a(e),P=d(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-fac4cj"&&(P.innerHTML=Xl),Lr=a(e),zr=d(e,"HR",{}),Ar=a(e),J=d(e,"A",{id:!0,class:!0}),f(J).forEach(r),Rr=a(e),m(H.$$.fragment,e),Ur=a(e),I=d(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-k3m2wg"&&(I.textContent=Vl),Dr=a(e),F=d(e,"TABLE",{"data-svelte-h":!0}),i(F)!=="svelte-rd7ds7"&&(F.innerHTML=Yl),Br=a(e),Wr=d(e,"HR",{}),Nr=a(e),k=d(e,"A",{id:!0,class:!0}),f(k).forEach(r),Gr=a(e),m(j.$$.fragment,e),Zr=a(e),L=d(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-8k8cys"&&(L.textContent=Sl),Qr=a(e),z=d(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-18p52n5"&&(z.innerHTML=ql),Xr=a(e),A=d(e,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-1ne2ywl"&&(A.innerHTML=Kl),Vr=a(e),Yr=d(e,"HR",{}),Sr=a(e),R=d(e,"A",{id:!0,class:!0}),f(R).forEach(r),qr=a(e),m(U.$$.fragment,e),Kr=a(e),D=d(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1mp2vol"&&(D.textContent=Ol),Or=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),i(B)!=="svelte-t798dn"&&(B.innerHTML=ed),es=a(e),ts=d(e,"HR",{}),rs=a(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),ss=a(e),m(N.$$.fragment,e),os=a(e),G=d(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1q6eyx4"&&(G.textContent=td),as=a(e),Z=d(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-ar7q77"&&(Z.innerHTML=rd),ls=a(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),i(Q)!=="svelte-klyf4z"&&(Q.innerHTML=sd),ds=a(e),is=d(e,"HR",{}),cs=a(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),ps=a(e),m(V.$$.fragment,e),ms=a(e),Y=d(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-7fx89a"&&(Y.textContent=od),ns=a(e),S=d(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-65os4c"&&(S.innerHTML=ad),us=a(e),q=d(e,"TABLE",{"data-svelte-h":!0}),i(q)!=="svelte-1dnvwno"&&(q.innerHTML=ld),hs=a(e),_s=d(e,"HR",{}),fs=a(e),K=d(e,"A",{id:!0,class:!0}),f(K).forEach(r),gs=a(e),m(O.$$.fragment,e),xs=a(e),ee=d(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1mmkb9p"&&(ee.textContent=dd),Ts=a(e),te=d(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-110o3sn"&&(te.innerHTML=id),bs=a(e),re=d(e,"TABLE",{"data-svelte-h":!0}),i(re)!=="svelte-iqjbgm"&&(re.innerHTML=cd),ys=a(e),vs=d(e,"HR",{}),$s=a(e),se=d(e,"A",{id:!0,class:!0}),f(se).forEach(r),ws=a(e),m(oe.$$.fragment,e),Ms=a(e),ae=d(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-pyd72v"&&(ae.innerHTML=pd),Es=a(e),le=d(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-1isxmg1"&&(le.innerHTML=md),Cs=a(e),de=d(e,"TABLE",{"data-svelte-h":!0}),i(de)!=="svelte-1e1ka8e"&&(de.innerHTML=nd),Ps=a(e),Js=d(e,"HR",{}),Hs=a(e),ie=d(e,"A",{id:!0,class:!0}),f(ie).forEach(r),Is=a(e),m(ce.$$.fragment,e),Fs=a(e),pe=d(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-8leww2"&&(pe.textContent=ud),ks=a(e),me=d(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-eqxqo6"&&(me.innerHTML=hd),js=a(e),ne=d(e,"TABLE",{"data-svelte-h":!0}),i(ne)!=="svelte-1n361ub"&&(ne.innerHTML=_d),Ls=a(e),zs=d(e,"HR",{}),As=a(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),Rs=a(e),m(he.$$.fragment,e),Us=a(e),_e=d(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-5iny39"&&(_e.textContent=fd),Ds=a(e),fe=d(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-ar7q77"&&(fe.innerHTML=gd),Bs=a(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),i(ge)!=="svelte-d8vk38"&&(ge.innerHTML=xd),Ws=a(e),Ns=d(e,"HR",{}),Gs=a(e),xe=d(e,"A",{id:!0,class:!0}),f(xe).forEach(r),Zs=a(e),m(Te.$$.fragment,e),Qs=a(e),be=d(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-10g8wi9"&&(be.textContent=Td),Xs=a(e),ye=d(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-cd20o3"&&(ye.innerHTML=bd),Vs=a(e),ve=d(e,"TABLE",{"data-svelte-h":!0}),i(ve)!=="svelte-1773mps"&&(ve.innerHTML=yd),Ys=a(e),Ss=d(e,"HR",{}),qs=a(e),$e=d(e,"A",{id:!0,class:!0}),f($e).forEach(r),Ks=a(e),m(we.$$.fragment,e),Os=a(e),Me=d(e,"P",{"data-svelte-h":!0}),i(Me)!=="svelte-1uytqp8"&&(Me.textContent=vd),eo=a(e),Ee=d(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-1pa0uk8"&&(Ee.innerHTML=$d),to=a(e),Ce=d(e,"TABLE",{"data-svelte-h":!0}),i(Ce)!=="svelte-hch5rz"&&(Ce.innerHTML=wd),ro=a(e),so=d(e,"HR",{}),oo=a(e),Pe=d(e,"A",{id:!0,class:!0}),f(Pe).forEach(r),ao=a(e),m(Je.$$.fragment,e),lo=a(e),He=d(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-y1gxwn"&&(He.textContent=Md),io=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1xz91ac"&&(Ie.innerHTML=Ed),co=a(e),Fe=d(e,"UL",{"data-svelte-h":!0}),i(Fe)!=="svelte-1obx36y"&&(Fe.innerHTML=Cd),po=a(e),mo=d(e,"HR",{}),no=a(e),ke=d(e,"A",{id:!0,class:!0}),f(ke).forEach(r),uo=a(e),m(je.$$.fragment,e),ho=a(e),Le=d(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-1ec3vsm"&&(Le.textContent=Pd),_o=a(e),ze=d(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-6tjpr7"&&(ze.innerHTML=Jd),fo=a(e),Ae=d(e,"TABLE",{"data-svelte-h":!0}),i(Ae)!=="svelte-1px7bnv"&&(Ae.innerHTML=Hd),go=a(e),xo=d(e,"HR",{}),To=a(e),Re=d(e,"A",{id:!0,class:!0}),f(Re).forEach(r),bo=a(e),m(Ue.$$.fragment,e),yo=a(e),De=d(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-j2v54d"&&(De.innerHTML=Id),vo=a(e),$o=d(e,"HR",{}),wo=a(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),Mo=a(e),m(We.$$.fragment,e),Eo=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-75c7d5"&&(Ne.innerHTML=Fd),Co=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),i(Ge)!=="svelte-o8p6wm"&&(Ge.innerHTML=kd),Po=a(e),Ze=d(e,"TABLE",{"data-svelte-h":!0}),i(Ze)!=="svelte-yqya7v"&&(Ze.innerHTML=jd),Jo=a(e),Ho=d(e,"HR",{}),Io=a(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),Fo=a(e),m(Xe.$$.fragment,e),ko=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),i(Ve)!=="svelte-gl8gb6"&&(Ve.textContent=Ld),jo=a(e),Ye=d(e,"P",{"data-svelte-h":!0}),i(Ye)!=="svelte-1qxvzd2"&&(Ye.innerHTML=zd),Lo=a(e),Se=d(e,"TABLE",{"data-svelte-h":!0}),i(Se)!=="svelte-1f7z42u"&&(Se.innerHTML=Ad),zo=a(e),Ao=d(e,"HR",{}),Ro=a(e),qe=d(e,"A",{id:!0,class:!0}),f(qe).forEach(r),Uo=a(e),m(Ke.$$.fragment,e),Do=a(e),Oe=d(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-7vs1p7"&&(Oe.textContent=Rd),Bo=a(e),et=d(e,"P",{"data-svelte-h":!0}),i(et)!=="svelte-15rcpil"&&(et.innerHTML=Ud),Wo=a(e),tt=d(e,"TABLE",{"data-svelte-h":!0}),i(tt)!=="svelte-3xdz32"&&(tt.innerHTML=Dd),No=a(e),Go=d(e,"HR",{}),Zo=a(e),rt=d(e,"A",{id:!0,class:!0}),f(rt).forEach(r),Qo=a(e),m(st.$$.fragment,e),Xo=a(e),ot=d(e,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-frdp8m"&&(ot.textContent=Bd),Vo=a(e),at=d(e,"P",{"data-svelte-h":!0}),i(at)!=="svelte-j2v54d"&&(at.innerHTML=Wd),Yo=a(e),lt=d(e,"TABLE",{"data-svelte-h":!0}),i(lt)!=="svelte-11rkhka"&&(lt.innerHTML=Nd),So=a(e),qo=d(e,"HR",{}),Ko=a(e),dt=d(e,"A",{id:!0,class:!0}),f(dt).forEach(r),Oo=a(e),m(it.$$.fragment,e),ea=a(e),ct=d(e,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-o9f953"&&(ct.textContent=Gd),ta=a(e),pt=d(e,"P",{"data-svelte-h":!0}),i(pt)!=="svelte-fac4cj"&&(pt.innerHTML=Zd),ra=a(e),mt=d(e,"UL",{"data-svelte-h":!0}),i(mt)!=="svelte-1v579im"&&(mt.innerHTML=Qd),sa=a(e),oa=d(e,"HR",{}),aa=a(e),nt=d(e,"A",{id:!0,class:!0}),f(nt).forEach(r),la=a(e),m(ut.$$.fragment,e),da=a(e),ht=d(e,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1naom0u"&&(ht.textContent=Xd),ia=a(e),_t=d(e,"TABLE",{"data-svelte-h":!0}),i(_t)!=="svelte-ilxs6c"&&(_t.innerHTML=Vd),ca=a(e),pa=d(e,"HR",{}),ma=a(e),ft=d(e,"A",{id:!0,class:!0}),f(ft).forEach(r),na=a(e),m(gt.$$.fragment,e),ua=a(e),xt=d(e,"P",{"data-svelte-h":!0}),i(xt)!=="svelte-zbbm3j"&&(xt.textContent=Yd),ha=a(e),Tt=d(e,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-kflsb2"&&(Tt.innerHTML=Sd),_a=a(e),bt=d(e,"TABLE",{"data-svelte-h":!0}),i(bt)!=="svelte-pm1u9z"&&(bt.innerHTML=qd),fa=a(e),ga=d(e,"HR",{}),xa=a(e),yt=d(e,"A",{id:!0,class:!0}),f(yt).forEach(r),Ta=a(e),m(vt.$$.fragment,e),ba=a(e),$t=d(e,"P",{"data-svelte-h":!0}),i($t)!=="svelte-17pib55"&&($t.textContent=Kd),ya=a(e),wt=d(e,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1ljhyyr"&&(wt.innerHTML=Od),va=a(e),$a=d(e,"HR",{}),wa=a(e),Mt=d(e,"A",{id:!0,class:!0}),f(Mt).forEach(r),Ma=a(e),m(Et.$$.fragment,e),Ea=a(e),Ct=d(e,"P",{"data-svelte-h":!0}),i(Ct)!=="svelte-r5x3fh"&&(Ct.textContent=ei),Ca=a(e),Pt=d(e,"P",{"data-svelte-h":!0}),i(Pt)!=="svelte-1vpvonk"&&(Pt.innerHTML=ti),Pa=a(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),i(Jt)!=="svelte-nv3lon"&&(Jt.innerHTML=ri),Ja=a(e),Ha=d(e,"HR",{}),Ia=a(e),Ht=d(e,"A",{id:!0,class:!0}),f(Ht).forEach(r),Fa=a(e),m(It.$$.fragment,e),ka=a(e),Ft=d(e,"P",{"data-svelte-h":!0}),i(Ft)!=="svelte-62dsf9"&&(Ft.innerHTML=si),ja=a(e),kt=d(e,"P",{"data-svelte-h":!0}),i(kt)!=="svelte-11vd43e"&&(kt.innerHTML=oi),La=a(e),m(jt.$$.fragment,e),za=a(e),Lt=d(e,"P",{"data-svelte-h":!0}),i(Lt)!=="svelte-c0cgha"&&(Lt.innerHTML=ai),Aa=a(e),m(zt.$$.fragment,e),Ra=a(e),At=d(e,"P",{"data-svelte-h":!0}),i(At)!=="svelte-wmyz1o"&&(At.innerHTML=li),Ua=a(e),Da=d(e,"HR",{}),Ba=a(e),Rt=d(e,"A",{id:!0,class:!0}),f(Rt).forEach(r),Wa=a(e),m(Ut.$$.fragment,e),Na=a(e),Dt=d(e,"P",{"data-svelte-h":!0}),i(Dt)!=="svelte-jwfdp9"&&(Dt.textContent=di),Ga=a(e),Bt=d(e,"P",{"data-svelte-h":!0}),i(Bt)!=="svelte-t85gxq"&&(Bt.innerHTML=ii),Za=a(e),Wt=d(e,"P",{"data-svelte-h":!0}),i(Wt)!=="svelte-y7m8db"&&(Wt.innerHTML=ci),Qa=a(e),Nt=d(e,"TABLE",{"data-svelte-h":!0}),i(Nt)!=="svelte-1oj79mt"&&(Nt.innerHTML=pi),Xa=a(e),Va=d(e,"HR",{}),Ya=a(e),Gt=d(e,"A",{id:!0,class:!0}),f(Gt).forEach(r),Sa=a(e),m(Zt.$$.fragment,e),qa=a(e),Qt=d(e,"P",{"data-svelte-h":!0}),i(Qt)!=="svelte-kjzox5"&&(Qt.textContent=mi),Ka=a(e),Xt=d(e,"P",{"data-svelte-h":!0}),i(Xt)!=="svelte-19qboln"&&(Xt.innerHTML=ni),Oa=a(e),Vt=d(e,"TABLE",{"data-svelte-h":!0}),i(Vt)!=="svelte-1bv5sxq"&&(Vt.innerHTML=ui),el=a(e),tl=d(e,"HR",{}),rl=a(e),Yt=d(e,"A",{id:!0,class:!0}),f(Yt).forEach(r),sl=a(e),m(St.$$.fragment,e),ol=a(e),qt=d(e,"P",{"data-svelte-h":!0}),i(qt)!=="svelte-vlkbp"&&(qt.textContent=hi),al=a(e),Kt=d(e,"P",{"data-svelte-h":!0}),i(Kt)!=="svelte-vmdbik"&&(Kt.innerHTML=_i),ll=a(e),Ot=d(e,"TABLE",{"data-svelte-h":!0}),i(Ot)!=="svelte-4ldb45"&&(Ot.innerHTML=fi),dl=a(e),il=d(e,"HR",{}),cl=a(e),er=d(e,"A",{id:!0,class:!0}),f(er).forEach(r),pl=a(e),m(tr.$$.fragment,e),ml=a(e),rr=d(e,"P",{"data-svelte-h":!0}),i(rr)!=="svelte-2u8xbp"&&(rr.textContent=gi),nl=a(e),sr=d(e,"P",{"data-svelte-h":!0}),i(sr)!=="svelte-3xndnt"&&(sr.innerHTML=xi),ul=a(e),hl=d(e,"HR",{}),_l=a(e),or=d(e,"A",{id:!0,class:!0}),f(or).forEach(r),fl=a(e),m(ar.$$.fragment,e),gl=a(e),lr=d(e,"P",{"data-svelte-h":!0}),i(lr)!=="svelte-cy5pwv"&&(lr.innerHTML=Ti),xl=a(e),dr=d(e,"TABLE",{"data-svelte-h":!0}),i(dr)!=="svelte-1dyar84"&&(dr.innerHTML=bi),Tl=a(e),bl=d(e,"HR",{}),yl=a(e),ir=d(e,"A",{id:!0,class:!0}),f(ir).forEach(r),vl=a(e),m(cr.$$.fragment,e),$l=a(e),pr=d(e,"P",{"data-svelte-h":!0}),i(pr)!=="svelte-cy5pwv"&&(pr.innerHTML=yi),wl=a(e),mr=d(e,"TABLE",{"data-svelte-h":!0}),i(mr)!=="svelte-1cnys15"&&(mr.innerHTML=vi),Ml=a(e),El=d(e,"HR",{}),Cl=a(e),nr=d(e,"A",{id:!0,class:!0}),f(nr).forEach(r),Pl=a(e),m(ur.$$.fragment,e),Jl=a(e),hr=d(e,"P",{"data-svelte-h":!0}),i(hr)!=="svelte-cy5pwv"&&(hr.innerHTML=$i),Hl=a(e),_r=d(e,"TABLE",{"data-svelte-h":!0}),i(_r)!=="svelte-179cln2"&&(_r.innerHTML=wi),Il=a(e),Fl=d(e,"HR",{}),kl=a(e),fr=d(e,"A",{id:!0,class:!0}),f(fr).forEach(r),jl=a(e),m(gr.$$.fragment,e),Ll=a(e),xr=d(e,"P",{"data-svelte-h":!0}),i(xr)!=="svelte-cy5pwv"&&(xr.innerHTML=Mi),zl=a(e),Tr=d(e,"TABLE",{"data-svelte-h":!0}),i(Tr)!=="svelte-vnvxdo"&&(Tr.innerHTML=Ei),Al=a(e),Rl=d(e,"HR",{}),Ul=a(e),yr=d(e,"P",{}),f(yr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",Li),c(T,"id","module_processors"),c(T,"class","group"),c(M,"id","module_processors.FeatureExtractor"),c(M,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(k,"id","module_processors.ImageFeatureExtractor"),c(k,"class","group"),c(R,"id","new_module_processors.ImageFeatureExtractor_new"),c(R,"class","group"),c(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(W,"class","group"),c(X,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(X,"class","group"),c(K,"id","module_processors.ImageFeatureExtractor+pad_image"),c(K,"class","group"),c(se,"id","module_processors.ImageFeatureExtractor+rescale"),c(se,"class","group"),c(ie,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(ie,"class","group"),c(ue,"id","module_processors.ImageFeatureExtractor+resize"),c(ue,"class","group"),c(xe,"id","module_processors.ImageFeatureExtractor+preprocess"),c(xe,"class","group"),c($e,"id","module_processors.ImageFeatureExtractor+_call"),c($e,"class","group"),c(Pe,"id","module_processors.DetrFeatureExtractor"),c(Pe,"class","group"),c(ke,"id","module_processors.DetrFeatureExtractor+_call"),c(ke,"class","group"),c(Re,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Re,"class","group"),c(Be,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),c(Be,"class","group"),c(Qe,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),c(Qe,"class","group"),c(qe,"id","module_processors.DetrFeatureExtractor+compute_segments"),c(qe,"class","group"),c(rt,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(rt,"class","group"),c(dt,"id","module_processors.Processor"),c(dt,"class","group"),c(nt,"id","new_module_processors.Processor_new"),c(nt,"class","group"),c(ft,"id","module_processors.Processor+_call"),c(ft,"class","group"),c(yt,"id","module_processors.WhisperProcessor"),c(yt,"class","group"),c(Mt,"id","module_processors.WhisperProcessor+_call"),c(Mt,"class","group"),c(Ht,"id","module_processors.AutoProcessor"),c(Ht,"class","group"),c(Rt,"id","module_processors.AutoProcessor.from_pretrained"),c(Rt,"class","group"),c(Gt,"id","module_processors..center_to_corners_format"),c(Gt,"class","group"),c(Yt,"id","module_processors..enforce_size_divisibility"),c(Yt,"class","group"),c(er,"id","module_processors..HeightWidth"),c(er,"class","group"),c(or,"id","module_processors..ImageFeatureExtractorResult"),c(or,"class","group"),c(ir,"id","module_processors..PreprocessedImage"),c(ir,"class","group"),c(nr,"id","module_processors..DetrFeatureExtractorResult"),c(nr,"class","group"),c(fr,"id","module_processors..SamImageProcessorResult"),c(fr,"class","group")},m(e,t){ki(document.head,x),s(e,vr,t),s(e,br,t),s(e,$r,t),s(e,T,t),s(e,wr,t),n(b,e,t),s(e,Mr,t),s(e,y,t),s(e,Er,t),s(e,v,t),s(e,Cr,t),n($,e,t),s(e,Pr,t),s(e,w,t),s(e,Jr,t),s(e,Hr,t),s(e,Ir,t),s(e,M,t),s(e,Fr,t),n(E,e,t),s(e,kr,t),s(e,C,t),s(e,jr,t),s(e,P,t),s(e,Lr,t),s(e,zr,t),s(e,Ar,t),s(e,J,t),s(e,Rr,t),n(H,e,t),s(e,Ur,t),s(e,I,t),s(e,Dr,t),s(e,F,t),s(e,Br,t),s(e,Wr,t),s(e,Nr,t),s(e,k,t),s(e,Gr,t),n(j,e,t),s(e,Zr,t),s(e,L,t),s(e,Qr,t),s(e,z,t),s(e,Xr,t),s(e,A,t),s(e,Vr,t),s(e,Yr,t),s(e,Sr,t),s(e,R,t),s(e,qr,t),n(U,e,t),s(e,Kr,t),s(e,D,t),s(e,Or,t),s(e,B,t),s(e,es,t),s(e,ts,t),s(e,rs,t),s(e,W,t),s(e,ss,t),n(N,e,t),s(e,os,t),s(e,G,t),s(e,as,t),s(e,Z,t),s(e,ls,t),s(e,Q,t),s(e,ds,t),s(e,is,t),s(e,cs,t),s(e,X,t),s(e,ps,t),n(V,e,t),s(e,ms,t),s(e,Y,t),s(e,ns,t),s(e,S,t),s(e,us,t),s(e,q,t),s(e,hs,t),s(e,_s,t),s(e,fs,t),s(e,K,t),s(e,gs,t),n(O,e,t),s(e,xs,t),s(e,ee,t),s(e,Ts,t),s(e,te,t),s(e,bs,t),s(e,re,t),s(e,ys,t),s(e,vs,t),s(e,$s,t),s(e,se,t),s(e,ws,t),n(oe,e,t),s(e,Ms,t),s(e,ae,t),s(e,Es,t),s(e,le,t),s(e,Cs,t),s(e,de,t),s(e,Ps,t),s(e,Js,t),s(e,Hs,t),s(e,ie,t),s(e,Is,t),n(ce,e,t),s(e,Fs,t),s(e,pe,t),s(e,ks,t),s(e,me,t),s(e,js,t),s(e,ne,t),s(e,Ls,t),s(e,zs,t),s(e,As,t),s(e,ue,t),s(e,Rs,t),n(he,e,t),s(e,Us,t),s(e,_e,t),s(e,Ds,t),s(e,fe,t),s(e,Bs,t),s(e,ge,t),s(e,Ws,t),s(e,Ns,t),s(e,Gs,t),s(e,xe,t),s(e,Zs,t),n(Te,e,t),s(e,Qs,t),s(e,be,t),s(e,Xs,t),s(e,ye,t),s(e,Vs,t),s(e,ve,t),s(e,Ys,t),s(e,Ss,t),s(e,qs,t),s(e,$e,t),s(e,Ks,t),n(we,e,t),s(e,Os,t),s(e,Me,t),s(e,eo,t),s(e,Ee,t),s(e,to,t),s(e,Ce,t),s(e,ro,t),s(e,so,t),s(e,oo,t),s(e,Pe,t),s(e,ao,t),n(Je,e,t),s(e,lo,t),s(e,He,t),s(e,io,t),s(e,Ie,t),s(e,co,t),s(e,Fe,t),s(e,po,t),s(e,mo,t),s(e,no,t),s(e,ke,t),s(e,uo,t),n(je,e,t),s(e,ho,t),s(e,Le,t),s(e,_o,t),s(e,ze,t),s(e,fo,t),s(e,Ae,t),s(e,go,t),s(e,xo,t),s(e,To,t),s(e,Re,t),s(e,bo,t),n(Ue,e,t),s(e,yo,t),s(e,De,t),s(e,vo,t),s(e,$o,t),s(e,wo,t),s(e,Be,t),s(e,Mo,t),n(We,e,t),s(e,Eo,t),s(e,Ne,t),s(e,Co,t),s(e,Ge,t),s(e,Po,t),s(e,Ze,t),s(e,Jo,t),s(e,Ho,t),s(e,Io,t),s(e,Qe,t),s(e,Fo,t),n(Xe,e,t),s(e,ko,t),s(e,Ve,t),s(e,jo,t),s(e,Ye,t),s(e,Lo,t),s(e,Se,t),s(e,zo,t),s(e,Ao,t),s(e,Ro,t),s(e,qe,t),s(e,Uo,t),n(Ke,e,t),s(e,Do,t),s(e,Oe,t),s(e,Bo,t),s(e,et,t),s(e,Wo,t),s(e,tt,t),s(e,No,t),s(e,Go,t),s(e,Zo,t),s(e,rt,t),s(e,Qo,t),n(st,e,t),s(e,Xo,t),s(e,ot,t),s(e,Vo,t),s(e,at,t),s(e,Yo,t),s(e,lt,t),s(e,So,t),s(e,qo,t),s(e,Ko,t),s(e,dt,t),s(e,Oo,t),n(it,e,t),s(e,ea,t),s(e,ct,t),s(e,ta,t),s(e,pt,t),s(e,ra,t),s(e,mt,t),s(e,sa,t),s(e,oa,t),s(e,aa,t),s(e,nt,t),s(e,la,t),n(ut,e,t),s(e,da,t),s(e,ht,t),s(e,ia,t),s(e,_t,t),s(e,ca,t),s(e,pa,t),s(e,ma,t),s(e,ft,t),s(e,na,t),n(gt,e,t),s(e,ua,t),s(e,xt,t),s(e,ha,t),s(e,Tt,t),s(e,_a,t),s(e,bt,t),s(e,fa,t),s(e,ga,t),s(e,xa,t),s(e,yt,t),s(e,Ta,t),n(vt,e,t),s(e,ba,t),s(e,$t,t),s(e,ya,t),s(e,wt,t),s(e,va,t),s(e,$a,t),s(e,wa,t),s(e,Mt,t),s(e,Ma,t),n(Et,e,t),s(e,Ea,t),s(e,Ct,t),s(e,Ca,t),s(e,Pt,t),s(e,Pa,t),s(e,Jt,t),s(e,Ja,t),s(e,Ha,t),s(e,Ia,t),s(e,Ht,t),s(e,Fa,t),n(It,e,t),s(e,ka,t),s(e,Ft,t),s(e,ja,t),s(e,kt,t),s(e,La,t),n(jt,e,t),s(e,za,t),s(e,Lt,t),s(e,Aa,t),n(zt,e,t),s(e,Ra,t),s(e,At,t),s(e,Ua,t),s(e,Da,t),s(e,Ba,t),s(e,Rt,t),s(e,Wa,t),n(Ut,e,t),s(e,Na,t),s(e,Dt,t),s(e,Ga,t),s(e,Bt,t),s(e,Za,t),s(e,Wt,t),s(e,Qa,t),s(e,Nt,t),s(e,Xa,t),s(e,Va,t),s(e,Ya,t),s(e,Gt,t),s(e,Sa,t),n(Zt,e,t),s(e,qa,t),s(e,Qt,t),s(e,Ka,t),s(e,Xt,t),s(e,Oa,t),s(e,Vt,t),s(e,el,t),s(e,tl,t),s(e,rl,t),s(e,Yt,t),s(e,sl,t),n(St,e,t),s(e,ol,t),s(e,qt,t),s(e,al,t),s(e,Kt,t),s(e,ll,t),s(e,Ot,t),s(e,dl,t),s(e,il,t),s(e,cl,t),s(e,er,t),s(e,pl,t),n(tr,e,t),s(e,ml,t),s(e,rr,t),s(e,nl,t),s(e,sr,t),s(e,ul,t),s(e,hl,t),s(e,_l,t),s(e,or,t),s(e,fl,t),n(ar,e,t),s(e,gl,t),s(e,lr,t),s(e,xl,t),s(e,dr,t),s(e,Tl,t),s(e,bl,t),s(e,yl,t),s(e,ir,t),s(e,vl,t),n(cr,e,t),s(e,$l,t),s(e,pr,t),s(e,wl,t),s(e,mr,t),s(e,Ml,t),s(e,El,t),s(e,Cl,t),s(e,nr,t),s(e,Pl,t),n(ur,e,t),s(e,Jl,t),s(e,hr,t),s(e,Hl,t),s(e,_r,t),s(e,Il,t),s(e,Fl,t),s(e,kl,t),s(e,fr,t),s(e,jl,t),n(gr,e,t),s(e,Ll,t),s(e,xr,t),s(e,zl,t),s(e,Tr,t),s(e,Al,t),s(e,Rl,t),s(e,Ul,t),s(e,yr,t),Dl=!0},p:Pi,i(e){Dl||(u(b.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(j.$$.fragment,e),u(U.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u(Ue.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(ut.$$.fragment,e),u(gt.$$.fragment,e),u(vt.$$.fragment,e),u(Et.$$.fragment,e),u(It.$$.fragment,e),u(jt.$$.fragment,e),u(zt.$$.fragment,e),u(Ut.$$.fragment,e),u(Zt.$$.fragment,e),u(St.$$.fragment,e),u(tr.$$.fragment,e),u(ar.$$.fragment,e),u(cr.$$.fragment,e),u(ur.$$.fragment,e),u(gr.$$.fragment,e),Dl=!0)},o(e){h(b.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(j.$$.fragment,e),h(U.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ke.$$.fragment,e),h(st.$$.fragment,e),h(it.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),h(Et.$$.fragment,e),h(It.$$.fragment,e),h(jt.$$.fragment,e),h(zt.$$.fragment,e),h(Ut.$$.fragment,e),h(Zt.$$.fragment,e),h(St.$$.fragment,e),h(tr.$$.fragment,e),h(ar.$$.fragment,e),h(cr.$$.fragment,e),h(ur.$$.fragment,e),h(gr.$$.fragment,e),Dl=!1},d(e){e&&(r(vr),r(br),r($r),r(T),r(wr),r(Mr),r(y),r(Er),r(v),r(Cr),r(Pr),r(w),r(Jr),r(Hr),r(Ir),r(M),r(Fr),r(kr),r(C),r(jr),r(P),r(Lr),r(zr),r(Ar),r(J),r(Rr),r(Ur),r(I),r(Dr),r(F),r(Br),r(Wr),r(Nr),r(k),r(Gr),r(Zr),r(L),r(Qr),r(z),r(Xr),r(A),r(Vr),r(Yr),r(Sr),r(R),r(qr),r(Kr),r(D),r(Or),r(B),r(es),r(ts),r(rs),r(W),r(ss),r(os),r(G),r(as),r(Z),r(ls),r(Q),r(ds),r(is),r(cs),r(X),r(ps),r(ms),r(Y),r(ns),r(S),r(us),r(q),r(hs),r(_s),r(fs),r(K),r(gs),r(xs),r(ee),r(Ts),r(te),r(bs),r(re),r(ys),r(vs),r($s),r(se),r(ws),r(Ms),r(ae),r(Es),r(le),r(Cs),r(de),r(Ps),r(Js),r(Hs),r(ie),r(Is),r(Fs),r(pe),r(ks),r(me),r(js),r(ne),r(Ls),r(zs),r(As),r(ue),r(Rs),r(Us),r(_e),r(Ds),r(fe),r(Bs),r(ge),r(Ws),r(Ns),r(Gs),r(xe),r(Zs),r(Qs),r(be),r(Xs),r(ye),r(Vs),r(ve),r(Ys),r(Ss),r(qs),r($e),r(Ks),r(Os),r(Me),r(eo),r(Ee),r(to),r(Ce),r(ro),r(so),r(oo),r(Pe),r(ao),r(lo),r(He),r(io),r(Ie),r(co),r(Fe),r(po),r(mo),r(no),r(ke),r(uo),r(ho),r(Le),r(_o),r(ze),r(fo),r(Ae),r(go),r(xo),r(To),r(Re),r(bo),r(yo),r(De),r(vo),r($o),r(wo),r(Be),r(Mo),r(Eo),r(Ne),r(Co),r(Ge),r(Po),r(Ze),r(Jo),r(Ho),r(Io),r(Qe),r(Fo),r(ko),r(Ve),r(jo),r(Ye),r(Lo),r(Se),r(zo),r(Ao),r(Ro),r(qe),r(Uo),r(Do),r(Oe),r(Bo),r(et),r(Wo),r(tt),r(No),r(Go),r(Zo),r(rt),r(Qo),r(Xo),r(ot),r(Vo),r(at),r(Yo),r(lt),r(So),r(qo),r(Ko),r(dt),r(Oo),r(ea),r(ct),r(ta),r(pt),r(ra),r(mt),r(sa),r(oa),r(aa),r(nt),r(la),r(da),r(ht),r(ia),r(_t),r(ca),r(pa),r(ma),r(ft),r(na),r(ua),r(xt),r(ha),r(Tt),r(_a),r(bt),r(fa),r(ga),r(xa),r(yt),r(Ta),r(ba),r($t),r(ya),r(wt),r(va),r($a),r(wa),r(Mt),r(Ma),r(Ea),r(Ct),r(Ca),r(Pt),r(Pa),r(Jt),r(Ja),r(Ha),r(Ia),r(Ht),r(Fa),r(ka),r(Ft),r(ja),r(kt),r(La),r(za),r(Lt),r(Aa),r(Ra),r(At),r(Ua),r(Da),r(Ba),r(Rt),r(Wa),r(Na),r(Dt),r(Ga),r(Bt),r(Za),r(Wt),r(Qa),r(Nt),r(Xa),r(Va),r(Ya),r(Gt),r(Sa),r(qa),r(Qt),r(Ka),r(Xt),r(Oa),r(Vt),r(el),r(tl),r(rl),r(Yt),r(sl),r(ol),r(qt),r(al),r(Kt),r(ll),r(Ot),r(dl),r(il),r(cl),r(er),r(pl),r(ml),r(rr),r(nl),r(sr),r(ul),r(hl),r(_l),r(or),r(fl),r(gl),r(lr),r(xl),r(dr),r(Tl),r(bl),r(yl),r(ir),r(vl),r($l),r(pr),r(wl),r(mr),r(Ml),r(El),r(Cl),r(nr),r(Pl),r(Jl),r(hr),r(Hl),r(_r),r(Il),r(Fl),r(kl),r(fr),r(jl),r(Ll),r(xr),r(zl),r(Tr),r(Al),r(Rl),r(Ul),r(yr)),r(x),_(b,e),_($,e),_(E,e),_(H,e),_(j,e),_(U,e),_(N,e),_(V,e),_(O,e),_(oe,e),_(ce,e),_(he,e),_(Te,e),_(we,e),_(Je,e),_(je,e),_(Ue,e),_(We,e),_(Xe,e),_(Ke,e),_(st,e),_(it,e),_(ut,e),_(gt,e),_(vt,e),_(Et,e),_(It,e),_(jt,e),_(zt,e),_(Ut,e),_(Zt,e),_(St,e),_(tr,e),_(ar,e),_(cr,e),_(ur,e),_(gr,e)}}}const Li='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function zi(Wl){return Ji(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bi extends Hi{constructor(x){super(),Ii(this,x,zi,ji,Ci,{})}}export{Bi as component};
