import{s as ql,o as Rl,n as Wl}from"../chunks/scheduler.d6170356.js";import{S as Fl,i as Yl,g as n,s as i,r as d,A as Ql,h as s,f as l,c as o,j as Il,u as h,x as r,k as Et,y as Bl,a,v as p,d as u,t as f,w as m}from"../chunks/index.fcd4cc08.js";import{T as El}from"../chunks/Tip.b09c67cf.js";import{C as v}from"../chunks/CodeBlock.7b16bdef.js";import{H as M,E as Sl}from"../chunks/EditOnGithub.da2b595c.js";function Xl(Ze){let g,H='In this guide, we will focus on Python libraries. If you’ve implemented your library in JavaScript, you can use <a href="https://www.npmjs.com/package/@huggingface/hub" rel="nofollow"><code>@huggingface/hub</code></a> instead. The rest of the logic (i.e. hosting files, code samples, etc.) does not depend on the code language.',$,y,b;return y=new v({props:{code:"bnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:'<span class="hljs-built_in">npm</span> add @huggingface/hub',wrap:!1}}),{c(){g=n("p"),g.innerHTML=H,$=i(),d(y.$$.fragment)},l(c){g=s(c,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1k8fo1s"&&(g.innerHTML=H),$=o(c),h(y.$$.fragment,c)},m(c,w){a(c,g,w),a(c,$,w),p(y,c,w),b=!0},p:Wl,i(c){b||(u(y.$$.fragment,c),b=!0)},o(c){f(y.$$.fragment,c),b=!1},d(c){c&&(l(g),l($)),m(y,c)}}}function Nl(Ze){let g,H,$,y,b,c,w,St='The Hugging Face Hub aims to facilitate sharing machine learning models, checkpoints, and artifacts. This endeavor includes integrating the Hub into many of the amazing third-party libraries in the community. Some of the ones already integrated include <a href="https://spacy.io/usage/projects#huggingface_hub" rel="nofollow">spaCy</a>, <a href="https://sbert.net/" rel="nofollow">Sentence Transformers</a>, <a href="https://github.com/mlfoundations/open_clip" rel="nofollow">OpenCLIP</a>, and <a href="https://huggingface.co/docs/timm/index" rel="nofollow">timm</a>, among many others. Integration means users can download and upload files to the Hub directly from your library. We hope you will integrate your library and join us in democratizing artificial intelligence for everyone.',Ge,x,Xt="Integrating the Hub with your library provides many benefits, including:",Pe,C,Nt='<li>Free model hosting for you and your users.</li> <li>Built-in file versioning - even for huge files - made possible by <a href="https://git-lfs.github.com/" rel="nofollow">Git-LFS</a>.</li> <li>Community features (discussions, pull requests, likes).</li> <li>Usage metrics for all models ran with your library.</li>',Ie,k,zt="This tutorial will help you integrate the Hub into your library so your users can benefit from all the features offered by the Hub.",qe,U,Vt='Before you begin, we recommend you create a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face account</a> from which you can manage your repositories and files.',Re,L,At='If you need help with the integration, feel free to open an <a href="https://github.com/huggingface/huggingface_hub/issues/new/choose" rel="nofollow">issue</a>, and we would be more than happy to help you.',We,j,Fe,J,Dt='Implementing an integration of a library with the Hub often means providing built-in methods to load models from the Hub and allow users to push new models to the Hub. This section will cover the basics of how to do that using the <code>huggingface_hub</code> library. For more in-depth guidance, check out <a href="https://huggingface.co/docs/huggingface_hub/guides/integrations" rel="nofollow">this guide</a>.',Ye,Z,Qe,G,Kt="To integrate your library with the Hub, you will need to add <code>huggingface_hub</code> library as a dependency:",Be,P,Ee,I,Ot='For more details about <code>huggingface_hub</code> installation, check out <a href="https://huggingface.co/docs/huggingface_hub/installation" rel="nofollow">this guide</a>.',Se,T,Xe,q,el="Users will need to authenticate once they have successfully installed the <code>huggingface_hub</code> library. The easiest way to authenticate is to save the token on the machine. Users can do that from the terminal using the <code>login()</code> command:",Ne,R,ze,W,tl="The command tells them if they are already logged in and prompts them for their token. The token is then validated and saved in their <code>HF_HOME</code> directory (defaults to <code>~/.cache/huggingface/token</code>). Any script or library interacting with the Hub will use this token when sending requests.",Ve,F,ll="Alternatively, users can programmatically login using <code>login()</code> in a notebook or a script:",Ae,Y,De,Q,al="Authentication is optional when downloading files from public repos on the Hub.",Ke,B,Oe,E,il="Integrations allow users to download a model from the Hub and instantiate it directly from your library. This is often made possible by providing a method (usually called <code>from_pretrained</code> or <code>load_from_hf</code>) that has to be specific to your library. To instantiate a model from the Hub, your library has to:",et,S,ol="<li>download files from the Hub. This is what we will discuss now.</li> <li>instantiate the Python model from these files.</li>",tt,X,nl='Use the <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.hf_hub_download" rel="nofollow"><code>hf_hub_download</code></a> method to download files from a repository on the Hub. Downloaded files are stored in the cache: <code>~/.cache/huggingface/hub</code>. Users won’t have to re-download the file the next time they use it, which saves a lot of time for large files. Furthermore, if the repository is updated with a new version of the file, <code>huggingface_hub</code> will automatically download the latest version and store it in the cache. Users don’t have to worry about updating their files manually.',lt,N,sl='For example, download the <code>config.json</code> file from the <a href="https://huggingface.co/lysandre/arxiv-nlp" rel="nofollow">lysandre/arxiv-nlp</a> repository:',at,z,it,V,rl="<code>config_path</code> now contains a path to the downloaded file. You are guaranteed that the file exists and is up-to-date.",ot,A,dl='If your library needs to download an entire repository, use <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/file_download#huggingface_hub.snapshot_download" rel="nofollow"><code>snapshot_download</code></a>. It will take care of downloading all the files in parallel. The return value is a path to the directory containing the downloaded files.',nt,D,st,K,hl='Many options exists to download files from a specific revision, to filter which files to download, to provide a custom cache directory, to download to a local directory, etc. Check out the <a href="https://huggingface.co/docs/huggingface_hub/en/guides/download" rel="nofollow">download guide</a> for more details.',rt,O,dt,ee,pl="You might also want to provide a method so that users can push their own models to the Hub. This allows the community to build an ecosystem of models compatible with your library. The <code>huggingface_hub</code> library offers methods to create repositories and upload files:",ht,te,ul="<li><code>create_repo</code> creates a repository on the Hub.</li> <li><code>upload_file</code> and <code>upload_folder</code> upload files to a repository on the Hub.</li>",pt,le,fl="The <code>create_repo</code> method creates a repository on the Hub. Use the <code>repo_id</code> parameter to provide a name for your repository:",ut,ae,ft,ie,ml="When you check your Hugging Face account, you should now see a <code>test-model</code> repository under your namespace.",mt,oe,cl='The <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/hf_api#huggingface_hub.HfApi.upload_file" rel="nofollow"><code>upload_file</code></a> method uploads a file to the Hub. This method requires the following:',ct,ne,gl="<li>A path to the file to upload.</li> <li>The final path in the repository.</li> <li>The repository you wish to push the files to.</li>",gt,se,yl="For example:",yt,re,bt,de,bl="If you check your Hugging Face account, you should see the file inside your repository.",wt,he,wl='Usually, a library will serialize the model to a local directory and then upload to the Hub the entire folder at once. This can be done using <a href="https://huggingface.co/docs/huggingface_hub/en/package_reference/hf_api#huggingface_hub.HfApi.upload_folder" rel="nofollow"><code>upload_folder</code></a>:',$t,pe,vt,ue,$l='For more details about how to upload files, check out the <a href="https://huggingface.co/docs/huggingface_hub/en/guides/upload" rel="nofollow">upload guide</a>.',Mt,fe,Tt,me,vl='Model cards are files that accompany the models and provide handy information. Under the hood, model cards are simple Markdown files with additional metadata. Model cards are essential for discoverability, reproducibility, and sharing! You can find a model card as the README.md file in any model repo. See the <a href="./model-cards">model cards guide</a> for more details about how to create a good model card.',_t,ce,Ml="If your library allows pushing a model to the Hub, it is recommended to generate a minimal model card with prefilled metadata (typically <code>library_name</code>, <code>pipeline_tag</code> or <code>tags</code>) and information on how the model has been trained. This will help having a standardized description for all models built with your library.",Ht,ge,xt,ye,Tl="Well done! You should now have a library able to load a model from the Hub and eventually push new models. The next step is to make sure that your models on the Hub are well-documented and integrated with the platform. To do so, libraries can be registered on the Hub, which comes with a few benefits for the users:",Ct,be,_l="<li>a pretty label can be shown on the model page (e.g. <code>KerasNLP</code> instead of <code>keras-nlp</code>)</li> <li>a link to your library repository and documentation is added to each model page</li> <li>a custom download count rule can be defined</li> <li>code snippets can be generated to show how to load the model using your library</li>",kt,we,Hl='To register a new library, please open a Pull Request <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">here</a> following the instructions below:',Ut,$e,xl=`<li>The library id should be lowercased and hyphen-separated (example: <code>&quot;adapter-transformers&quot;</code>). Make sure to preserve alphabetical order when opening the PR.</li> <li>set <code>repoName</code> and <code>prettyLabel</code> with user-friendly casing (example: <code>DeepForest</code>).</li> <li>set <code>repoUrl</code> with a link to the library source code (usually a GitHub repository).</li> <li>(optional) set <code>docsUrl</code> with a link to the docs of the library. If the documentation is in the GitHub repo referenced above, no need to set it twice.</li> <li>set <code>filter</code> to <code>false</code>.</li> <li>(optional) define how downloads must be counted by setting <code>countDownload</code>. Downloads can be tracked by file extensions or filenames. Make sure to not duplicate the counting. For instance, if loading a model requires 3 files, the download count rule must count downloads only on 1 of the 3 files. Otherwise, the download count will be overestimated.
<strong>Note:</strong> if the library uses one of the default config files (<code>config.json</code>, <code>config.yaml</code>, <code>hyperparams.yaml</code>, and <code>meta.yaml</code>, see <a href="https://huggingface.co/docs/hub/models-download-stats#which-are-the-query-files-for-different-libraries" rel="nofollow">here</a>), there is no need to manually define a download count rule.</li> <li>(optional) define <code>snippets</code> to let the user know how they can quickly instantiate a model. More details below.</li>`,Lt,ve,Cl='Before opening the PR, make sure that at least one model is referenced on <a href="https://huggingface.co/models?other=my-library-name" rel="nofollow">https://huggingface.co/models?other=my-library-name</a>. If not, the model card metadata of the relevant models must be updated with <code>library_name: my-library-name</code> (see <a href="https://huggingface.co/google/gemma-scope/blob/main/README.md?code=true#L3" rel="nofollow">example</a>). If you are not the owner of the models on the Hub, please open PRs (see <a href="https://huggingface.co/MCG-NJU/VFIMamba/discussions/1" rel="nofollow">example</a>).',jt,Me,kl='Here is a minimal <a href="https://github.com/huggingface/huggingface.js/pull/885/files" rel="nofollow">example</a> adding integration for VFIMamba.',Jt,Te,Zt,_e,Ul="We recommend adding a code snippet to explain how to use a model in your downstream library.",Gt,_,Ll='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet-dark.png"/>',Pt,He,jl='To add a code snippet, you should update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries-snippets.ts" rel="nofollow">model-libraries-snippets.ts</a> file with instructions for your model. For example, the <a href="https://huggingface.co/asteroid-team" rel="nofollow">Asteroid</a> integration includes a brief code snippet for how to load and use an Asteroid model:',It,xe,qt,Ce,Jl="Doing so will also add a tag to your model so users can quickly identify models from your library.",Rt,ke,Zl='Once your snippet has been added to <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries-snippets.ts" rel="nofollow">model-libraries-snippets.ts</a>, you can reference it in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">model-libraries.ts</a> as described above.',Wt,Ue,Ft,Le,Gl='Finally, you can add your library to the Hub’s documentation. Check for example the <a href="https://github.com/huggingface/hub-docs/pull/1150" rel="nofollow">Setfit PR</a> that added <a href="./setfit">SetFit</a> to the documentation.',Yt,je,Qt,Je,Bt;return b=new M({props:{title:"Integrate your library with the Hub",local:"integrate-your-library-with-the-hub",headingTag:"h1"}}),j=new M({props:{title:"Implementation",local:"implementation",headingTag:"h2"}}),Z=new M({props:{title:"Installation",local:"installation",headingTag:"h3"}}),P=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1Yg==",highlighted:"pip install huggingface_hub",wrap:!1}}),T=new El({props:{$$slots:{default:[Xl]},$$scope:{ctx:Ze}}}),R=new v({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:'huggingface-<span class="hljs-keyword">cli</span> login',wrap:!1}}),Y=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
login()`,wrap:!1}}),B=new M({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h3"}}),z=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWNvbmZpZ19wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRmFyeGl2LW5scCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIyY29uZmlnLmpzb24lMjIpJTBBY29uZmlnX3BhdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>config_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>config_path
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade/config.json&#x27;</span>`,wrap:!1}}),D=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNuYXBzaG90X2Rvd25sb2FkJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGYXJ4aXYtbmxwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download
<span class="hljs-meta">&gt;&gt;&gt; </span>snapshot_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>)
<span class="hljs-string">&#x27;/home/lysandre/.cache/huggingface/hub/models--lysandre--arxiv-nlp/snapshots/894a9adde21d9a3e3843e6d5aeaaf01875c7fade&#x27;</span>`,wrap:!1}}),O=new M({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h3"}}),ae=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8ocmVwb19pZCUzRCUyMnRlc3QtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(repo_id=<span class="hljs-string">&quot;test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),re=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGZHVtbXktdGVzdCUyRlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRnRlc3QtbW9kZWwlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>   path_or_fileobj=<span class="hljs-string">&quot;/home/lysandre/dummy-test/README.md&quot;</span>, 
<span class="hljs-meta">... </span>   path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, 
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model/blob/main/README.md&#x27;</span>`,wrap:!1}}),pe=new v({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9mb2xkZXIlMEF1cGxvYWRfZm9sZGVyKCUwQSUyMCUyMCUyMCUyMGZvbGRlcl9wYXRoJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGZHVtbXktdGVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRnRlc3QtbW9kZWwlMjIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_folder
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_folder(
<span class="hljs-meta">... </span>    folder_path=<span class="hljs-string">&quot;/home/lysandre/dummy-test&quot;</span>,
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),fe=new M({props:{title:"Model cards",local:"model-cards",headingTag:"h2"}}),ge=new M({props:{title:"Register your library",local:"register-your-library",headingTag:"h2"}}),Te=new M({props:{title:"Code snippets",local:"code-snippets",headingTag:"h3"}}),xe=new v({props:{code:"Y29uc3QlMjBhc3Rlcm9pZCUyMCUzRCUyMChtb2RlbCUzQSUyME1vZGVsRGF0YSklMjAlM0QlM0UlMEElNjBmcm9tJTIwYXN0ZXJvaWQubW9kZWxzJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTBBJTIwJTIwJTBBbW9kZWwlMjAlM0QlMjBCYXNlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyNCU3Qm1vZGVsLmlkJTdEJTIyKSU2MCUzQg==",highlighted:'<span class="hljs-keyword">const</span> <span class="hljs-title function_">asteroid</span> = (<span class="hljs-params">model: ModelData</span>) =&gt;\n<span class="hljs-string">`from asteroid.models import BaseModel\n  \nmodel = BaseModel.from_pretrained(&quot;<span class="hljs-subst">${model.id}</span>&quot;)`</span>;',wrap:!1}}),Ue=new M({props:{title:"Document your library",local:"document-your-library",headingTag:"h2"}}),je=new Sl({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/hub/models-adding-libraries.md"}}),{c(){g=n("meta"),H=i(),$=n("p"),y=i(),d(b.$$.fragment),c=i(),w=n("p"),w.innerHTML=St,Ge=i(),x=n("p"),x.textContent=Xt,Pe=i(),C=n("ul"),C.innerHTML=Nt,Ie=i(),k=n("p"),k.textContent=zt,qe=i(),U=n("p"),U.innerHTML=Vt,Re=i(),L=n("p"),L.innerHTML=At,We=i(),d(j.$$.fragment),Fe=i(),J=n("p"),J.innerHTML=Dt,Ye=i(),d(Z.$$.fragment),Qe=i(),G=n("p"),G.innerHTML=Kt,Be=i(),d(P.$$.fragment),Ee=i(),I=n("p"),I.innerHTML=Ot,Se=i(),d(T.$$.fragment),Xe=i(),q=n("p"),q.innerHTML=el,Ne=i(),d(R.$$.fragment),ze=i(),W=n("p"),W.innerHTML=tl,Ve=i(),F=n("p"),F.innerHTML=ll,Ae=i(),d(Y.$$.fragment),De=i(),Q=n("p"),Q.textContent=al,Ke=i(),d(B.$$.fragment),Oe=i(),E=n("p"),E.innerHTML=il,et=i(),S=n("ul"),S.innerHTML=ol,tt=i(),X=n("p"),X.innerHTML=nl,lt=i(),N=n("p"),N.innerHTML=sl,at=i(),d(z.$$.fragment),it=i(),V=n("p"),V.innerHTML=rl,ot=i(),A=n("p"),A.innerHTML=dl,nt=i(),d(D.$$.fragment),st=i(),K=n("p"),K.innerHTML=hl,rt=i(),d(O.$$.fragment),dt=i(),ee=n("p"),ee.innerHTML=pl,ht=i(),te=n("ul"),te.innerHTML=ul,pt=i(),le=n("p"),le.innerHTML=fl,ut=i(),d(ae.$$.fragment),ft=i(),ie=n("p"),ie.innerHTML=ml,mt=i(),oe=n("p"),oe.innerHTML=cl,ct=i(),ne=n("ul"),ne.innerHTML=gl,gt=i(),se=n("p"),se.textContent=yl,yt=i(),d(re.$$.fragment),bt=i(),de=n("p"),de.textContent=bl,wt=i(),he=n("p"),he.innerHTML=wl,$t=i(),d(pe.$$.fragment),vt=i(),ue=n("p"),ue.innerHTML=$l,Mt=i(),d(fe.$$.fragment),Tt=i(),me=n("p"),me.innerHTML=vl,_t=i(),ce=n("p"),ce.innerHTML=Ml,Ht=i(),d(ge.$$.fragment),xt=i(),ye=n("p"),ye.textContent=Tl,Ct=i(),be=n("ul"),be.innerHTML=_l,kt=i(),we=n("p"),we.innerHTML=Hl,Ut=i(),$e=n("ul"),$e.innerHTML=xl,Lt=i(),ve=n("p"),ve.innerHTML=Cl,jt=i(),Me=n("p"),Me.innerHTML=kl,Jt=i(),d(Te.$$.fragment),Zt=i(),_e=n("p"),_e.textContent=Ul,Gt=i(),_=n("div"),_.innerHTML=Ll,Pt=i(),He=n("p"),He.innerHTML=jl,It=i(),d(xe.$$.fragment),qt=i(),Ce=n("p"),Ce.textContent=Jl,Rt=i(),ke=n("p"),ke.innerHTML=Zl,Wt=i(),d(Ue.$$.fragment),Ft=i(),Le=n("p"),Le.innerHTML=Gl,Yt=i(),d(je.$$.fragment),Qt=i(),Je=n("p"),this.h()},l(e){const t=Ql("svelte-u9bgzb",document.head);g=s(t,"META",{name:!0,content:!0}),t.forEach(l),H=o(e),$=s(e,"P",{}),Il($).forEach(l),y=o(e),h(b.$$.fragment,e),c=o(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1ddhfut"&&(w.innerHTML=St),Ge=o(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1h76lqo"&&(x.textContent=Xt),Pe=o(e),C=s(e,"UL",{"data-svelte-h":!0}),r(C)!=="svelte-11qfmbk"&&(C.innerHTML=Nt),Ie=o(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-tideui"&&(k.textContent=zt),qe=o(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-bv6wqp"&&(U.innerHTML=Vt),Re=o(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-5v9xsl"&&(L.innerHTML=At),We=o(e),h(j.$$.fragment,e),Fe=o(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1fxxxnf"&&(J.innerHTML=Dt),Ye=o(e),h(Z.$$.fragment,e),Qe=o(e),G=s(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1vs871n"&&(G.innerHTML=Kt),Be=o(e),h(P.$$.fragment,e),Ee=o(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-e89z6c"&&(I.innerHTML=Ot),Se=o(e),h(T.$$.fragment,e),Xe=o(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-yoxod4"&&(q.innerHTML=el),Ne=o(e),h(R.$$.fragment,e),ze=o(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-d62rcs"&&(W.innerHTML=tl),Ve=o(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-pmlgxq"&&(F.innerHTML=ll),Ae=o(e),h(Y.$$.fragment,e),De=o(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-f4oyfe"&&(Q.textContent=al),Ke=o(e),h(B.$$.fragment,e),Oe=o(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-x5krz9"&&(E.innerHTML=il),et=o(e),S=s(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-hgx6x9"&&(S.innerHTML=ol),tt=o(e),X=s(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1d5am5g"&&(X.innerHTML=nl),lt=o(e),N=s(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-22k4ir"&&(N.innerHTML=sl),at=o(e),h(z.$$.fragment,e),it=o(e),V=s(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1lcofzz"&&(V.innerHTML=rl),ot=o(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1862qon"&&(A.innerHTML=dl),nt=o(e),h(D.$$.fragment,e),st=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18qqq2k"&&(K.innerHTML=hl),rt=o(e),h(O.$$.fragment,e),dt=o(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-6eyc4k"&&(ee.innerHTML=pl),ht=o(e),te=s(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-ve8rbn"&&(te.innerHTML=ul),pt=o(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-u3u4m5"&&(le.innerHTML=fl),ut=o(e),h(ae.$$.fragment,e),ft=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-aiu9oy"&&(ie.innerHTML=ml),mt=o(e),oe=s(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1n68zuv"&&(oe.innerHTML=cl),ct=o(e),ne=s(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-9phsay"&&(ne.innerHTML=gl),gt=o(e),se=s(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1gkqha7"&&(se.textContent=yl),yt=o(e),h(re.$$.fragment,e),bt=o(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-13oxzzb"&&(de.textContent=bl),wt=o(e),he=s(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-quod5e"&&(he.innerHTML=wl),$t=o(e),h(pe.$$.fragment,e),vt=o(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-16klp95"&&(ue.innerHTML=$l),Mt=o(e),h(fe.$$.fragment,e),Tt=o(e),me=s(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-zhx1dv"&&(me.innerHTML=vl),_t=o(e),ce=s(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1qegvbp"&&(ce.innerHTML=Ml),Ht=o(e),h(ge.$$.fragment,e),xt=o(e),ye=s(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-8v261g"&&(ye.textContent=Tl),Ct=o(e),be=s(e,"UL",{"data-svelte-h":!0}),r(be)!=="svelte-17mjo2y"&&(be.innerHTML=_l),kt=o(e),we=s(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-brcrhd"&&(we.innerHTML=Hl),Ut=o(e),$e=s(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-lucagn"&&($e.innerHTML=xl),Lt=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-7ffpy4"&&(ve.innerHTML=Cl),jt=o(e),Me=s(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1783vvo"&&(Me.innerHTML=kl),Jt=o(e),h(Te.$$.fragment,e),Zt=o(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-kjqwtb"&&(_e.textContent=Ul),Gt=o(e),_=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-k2vnd3"&&(_.innerHTML=Ll),Pt=o(e),He=s(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1r438fp"&&(He.innerHTML=jl),It=o(e),h(xe.$$.fragment,e),qt=o(e),Ce=s(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1s18u9b"&&(Ce.textContent=Jl),Rt=o(e),ke=s(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-18afhcq"&&(ke.innerHTML=Zl),Wt=o(e),h(Ue.$$.fragment,e),Ft=o(e),Le=s(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1bxz36b"&&(Le.innerHTML=Gl),Yt=o(e),h(je.$$.fragment,e),Qt=o(e),Je=s(e,"P",{}),Il(Je).forEach(l),this.h()},h(){Et(g,"name","hf:doc:metadata"),Et(g,"content",zl),Et(_,"class","flex justify-center")},m(e,t){Bl(document.head,g),a(e,H,t),a(e,$,t),a(e,y,t),p(b,e,t),a(e,c,t),a(e,w,t),a(e,Ge,t),a(e,x,t),a(e,Pe,t),a(e,C,t),a(e,Ie,t),a(e,k,t),a(e,qe,t),a(e,U,t),a(e,Re,t),a(e,L,t),a(e,We,t),p(j,e,t),a(e,Fe,t),a(e,J,t),a(e,Ye,t),p(Z,e,t),a(e,Qe,t),a(e,G,t),a(e,Be,t),p(P,e,t),a(e,Ee,t),a(e,I,t),a(e,Se,t),p(T,e,t),a(e,Xe,t),a(e,q,t),a(e,Ne,t),p(R,e,t),a(e,ze,t),a(e,W,t),a(e,Ve,t),a(e,F,t),a(e,Ae,t),p(Y,e,t),a(e,De,t),a(e,Q,t),a(e,Ke,t),p(B,e,t),a(e,Oe,t),a(e,E,t),a(e,et,t),a(e,S,t),a(e,tt,t),a(e,X,t),a(e,lt,t),a(e,N,t),a(e,at,t),p(z,e,t),a(e,it,t),a(e,V,t),a(e,ot,t),a(e,A,t),a(e,nt,t),p(D,e,t),a(e,st,t),a(e,K,t),a(e,rt,t),p(O,e,t),a(e,dt,t),a(e,ee,t),a(e,ht,t),a(e,te,t),a(e,pt,t),a(e,le,t),a(e,ut,t),p(ae,e,t),a(e,ft,t),a(e,ie,t),a(e,mt,t),a(e,oe,t),a(e,ct,t),a(e,ne,t),a(e,gt,t),a(e,se,t),a(e,yt,t),p(re,e,t),a(e,bt,t),a(e,de,t),a(e,wt,t),a(e,he,t),a(e,$t,t),p(pe,e,t),a(e,vt,t),a(e,ue,t),a(e,Mt,t),p(fe,e,t),a(e,Tt,t),a(e,me,t),a(e,_t,t),a(e,ce,t),a(e,Ht,t),p(ge,e,t),a(e,xt,t),a(e,ye,t),a(e,Ct,t),a(e,be,t),a(e,kt,t),a(e,we,t),a(e,Ut,t),a(e,$e,t),a(e,Lt,t),a(e,ve,t),a(e,jt,t),a(e,Me,t),a(e,Jt,t),p(Te,e,t),a(e,Zt,t),a(e,_e,t),a(e,Gt,t),a(e,_,t),a(e,Pt,t),a(e,He,t),a(e,It,t),p(xe,e,t),a(e,qt,t),a(e,Ce,t),a(e,Rt,t),a(e,ke,t),a(e,Wt,t),p(Ue,e,t),a(e,Ft,t),a(e,Le,t),a(e,Yt,t),p(je,e,t),a(e,Qt,t),a(e,Je,t),Bt=!0},p(e,[t]){const Pl={};t&2&&(Pl.$$scope={dirty:t,ctx:e}),T.$set(Pl)},i(e){Bt||(u(b.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(P.$$.fragment,e),u(T.$$.fragment,e),u(R.$$.fragment,e),u(Y.$$.fragment,e),u(B.$$.fragment,e),u(z.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(je.$$.fragment,e),Bt=!0)},o(e){f(b.$$.fragment,e),f(j.$$.fragment,e),f(Z.$$.fragment,e),f(P.$$.fragment,e),f(T.$$.fragment,e),f(R.$$.fragment,e),f(Y.$$.fragment,e),f(B.$$.fragment,e),f(z.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(pe.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),Bt=!1},d(e){e&&(l(H),l($),l(y),l(c),l(w),l(Ge),l(x),l(Pe),l(C),l(Ie),l(k),l(qe),l(U),l(Re),l(L),l(We),l(Fe),l(J),l(Ye),l(Qe),l(G),l(Be),l(Ee),l(I),l(Se),l(Xe),l(q),l(Ne),l(ze),l(W),l(Ve),l(F),l(Ae),l(De),l(Q),l(Ke),l(Oe),l(E),l(et),l(S),l(tt),l(X),l(lt),l(N),l(at),l(it),l(V),l(ot),l(A),l(nt),l(st),l(K),l(rt),l(dt),l(ee),l(ht),l(te),l(pt),l(le),l(ut),l(ft),l(ie),l(mt),l(oe),l(ct),l(ne),l(gt),l(se),l(yt),l(bt),l(de),l(wt),l(he),l($t),l(vt),l(ue),l(Mt),l(Tt),l(me),l(_t),l(ce),l(Ht),l(xt),l(ye),l(Ct),l(be),l(kt),l(we),l(Ut),l($e),l(Lt),l(ve),l(jt),l(Me),l(Jt),l(Zt),l(_e),l(Gt),l(_),l(Pt),l(He),l(It),l(qt),l(Ce),l(Rt),l(ke),l(Wt),l(Ft),l(Le),l(Yt),l(Qt),l(Je)),l(g),m(b,e),m(j,e),m(Z,e),m(P,e),m(T,e),m(R,e),m(Y,e),m(B,e),m(z,e),m(D,e),m(O,e),m(ae,e),m(re,e),m(pe,e),m(fe,e),m(ge,e),m(Te,e),m(xe,e),m(Ue,e),m(je,e)}}}const zl='{"title":"Integrate your library with the Hub","local":"integrate-your-library-with-the-hub","sections":[{"title":"Implementation","local":"implementation","sections":[{"title":"Installation","local":"installation","sections":[],"depth":3},{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[],"depth":3},{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[],"depth":3}],"depth":2},{"title":"Model cards","local":"model-cards","sections":[],"depth":2},{"title":"Register your library","local":"register-your-library","sections":[{"title":"Code snippets","local":"code-snippets","sections":[],"depth":3}],"depth":2},{"title":"Document your library","local":"document-your-library","sections":[],"depth":2}],"depth":1}';function Vl(Ze){return Rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ta extends Fl{constructor(g){super(),Yl(this,g,Vl,Nl,ql,{})}}export{ta as component};
