import{s as $t,n as Zt,o as Nt}from"../chunks/scheduler.85c25b89.js";import{S as It,i as Bt,g as p,s as a,r as m,A as Wt,h as i,f as l,c as n,j as Ct,u as o,x as r,k as kt,y as xt,a as e,v as h,d as c,t as M,w as j}from"../chunks/index.c9bcf812.js";import{C as R}from"../chunks/CodeBlock.94efc595.js";import{H as _}from"../chunks/Heading.3c6e5b17.js";function Gt(Mt){let y,Y,X,A,d,H,g,jt='A <strong>Dual Path Network (DPN)</strong> is a convolutional neural network which presents a new topology of connection paths internally. The intuition is that <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNets</a> enables feature re-usage while DenseNet enables new feature exploration, and both are important for learning good representations. To enjoy the benefits from both path topologies, Dual Path Networks share common features while maintaining the flexibility to explore new features through dual path architectures.',S,w,yt='The principal building block is an <a href="https://paperswithcode.com/method/dpn-block" rel="nofollow">DPN Block</a>.',F,u,z,J,dt="To load a pretrained model:",D,f,P,b,gt="To load and preprocess the image:",L,T,q,U,wt="To get the model predictions:",K,C,O,k,ut="To get the top-5 predictions class names:",tt,$,st,Z,Jt="Replace the model name with the variant you want to use, e.g. <code>dpn107</code>. You can find the IDs in the model summaries at the top of this page.",lt,N,ft='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,I,at,B,bt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",nt,W,pt,x,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,it,G,mt,E,Ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',ot,Q,rt,v,ht,V,ct;return d=new _({props:{title:"Dual Path Network (DPN)",local:"dual-path-network-dpn",headingTag:"h1"}}),u=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),f=new R({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2RwbjEwNyclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),T=new R({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),C=new R({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new R({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),I=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),W=new R({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnZHBuMTA3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;dpn107&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),Q=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),v=new R({props:{code:"JTQwbWlzYyU3QmNoZW4yMDE3ZHVhbCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCRHVhbCUyMFBhdGglMjBOZXR3b3JrcyU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3Qll1bnBlbmclMjBDaGVuJTIwYW5kJTIwSmlhbmFuJTIwTGklMjBhbmQlMjBIdWF4aW4lMjBYaWFvJTIwYW5kJTIwWGlhb2ppZSUyMEppbiUyMGFuZCUyMFNodWljaGVuZyUyMFlhbiUyMGFuZCUyMEppYXNoaSUyMEZlbmclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAxNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjE3MDcuMDE2MjklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSU3RA==",highlighted:`@misc{chen2017dual,
      title={Dual Path Networks}, 
      author={Yunpeng Chen <span class="hljs-keyword">and </span><span class="hljs-keyword">Jianan </span>Li <span class="hljs-keyword">and </span>Huaxin Xiao <span class="hljs-keyword">and </span>Xiaojie <span class="hljs-keyword">Jin </span><span class="hljs-keyword">and </span><span class="hljs-keyword">Shuicheng </span>Yan <span class="hljs-keyword">and </span><span class="hljs-keyword">Jiashi </span>Feng},
      year={<span class="hljs-number">2017</span>},
      eprint={<span class="hljs-number">1707</span>.<span class="hljs-number">01629</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){y=p("meta"),Y=a(),X=p("p"),A=a(),m(d.$$.fragment),H=a(),g=p("p"),g.innerHTML=jt,S=a(),w=p("p"),w.innerHTML=yt,F=a(),m(u.$$.fragment),z=a(),J=p("p"),J.textContent=dt,D=a(),m(f.$$.fragment),P=a(),b=p("p"),b.textContent=gt,L=a(),m(T.$$.fragment),q=a(),U=p("p"),U.textContent=wt,K=a(),m(C.$$.fragment),O=a(),k=p("p"),k.textContent=ut,tt=a(),m($.$$.fragment),st=a(),Z=p("p"),Z.innerHTML=Jt,lt=a(),N=p("p"),N.innerHTML=ft,et=a(),m(I.$$.fragment),at=a(),B=p("p"),B.textContent=bt,nt=a(),m(W.$$.fragment),pt=a(),x=p("p"),x.innerHTML=Tt,it=a(),m(G.$$.fragment),mt=a(),E=p("p"),E.innerHTML=Ut,ot=a(),m(Q.$$.fragment),rt=a(),m(v.$$.fragment),ht=a(),V=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);y=i(s,"META",{name:!0,content:!0}),s.forEach(l),Y=n(t),X=i(t,"P",{}),Ct(X).forEach(l),A=n(t),o(d.$$.fragment,t),H=n(t),g=i(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1vp7kec"&&(g.innerHTML=jt),S=n(t),w=i(t,"P",{"data-svelte-h":!0}),r(w)!=="svelte-34uoom"&&(w.innerHTML=yt),F=n(t),o(u.$$.fragment,t),z=n(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-18ywhxh"&&(J.textContent=dt),D=n(t),o(f.$$.fragment,t),P=n(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1c2ipa8"&&(b.textContent=gt),L=n(t),o(T.$$.fragment,t),q=n(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1n9qsq1"&&(U.textContent=wt),K=n(t),o(C.$$.fragment,t),O=n(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-19cnvx1"&&(k.textContent=ut),tt=n(t),o($.$$.fragment,t),st=n(t),Z=i(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1lx1824"&&(Z.innerHTML=Jt),lt=n(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1wmi3ea"&&(N.innerHTML=ft),et=n(t),o(I.$$.fragment,t),at=n(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9sr7nh"&&(B.textContent=bt),nt=n(t),o(W.$$.fragment,t),pt=n(t),x=i(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1kguc51"&&(x.innerHTML=Tt),it=n(t),o(G.$$.fragment,t),mt=n(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1n0coha"&&(E.innerHTML=Ut),ot=n(t),o(Q.$$.fragment,t),rt=n(t),o(v.$$.fragment,t),ht=n(t),V=i(t,"P",{}),Ct(V).forEach(l),this.h()},h(){kt(y,"name","hf:doc:metadata"),kt(y,"content",Et)},m(t,s){xt(document.head,y),e(t,Y,s),e(t,X,s),e(t,A,s),h(d,t,s),e(t,H,s),e(t,g,s),e(t,S,s),e(t,w,s),e(t,F,s),h(u,t,s),e(t,z,s),e(t,J,s),e(t,D,s),h(f,t,s),e(t,P,s),e(t,b,s),e(t,L,s),h(T,t,s),e(t,q,s),e(t,U,s),e(t,K,s),h(C,t,s),e(t,O,s),e(t,k,s),e(t,tt,s),h($,t,s),e(t,st,s),e(t,Z,s),e(t,lt,s),e(t,N,s),e(t,et,s),h(I,t,s),e(t,at,s),e(t,B,s),e(t,nt,s),h(W,t,s),e(t,pt,s),e(t,x,s),e(t,it,s),h(G,t,s),e(t,mt,s),e(t,E,s),e(t,ot,s),h(Q,t,s),e(t,rt,s),h(v,t,s),e(t,ht,s),e(t,V,s),ct=!0},p:Zt,i(t){ct||(c(d.$$.fragment,t),c(u.$$.fragment,t),c(f.$$.fragment,t),c(T.$$.fragment,t),c(C.$$.fragment,t),c($.$$.fragment,t),c(I.$$.fragment,t),c(W.$$.fragment,t),c(G.$$.fragment,t),c(Q.$$.fragment,t),c(v.$$.fragment,t),ct=!0)},o(t){M(d.$$.fragment,t),M(u.$$.fragment,t),M(f.$$.fragment,t),M(T.$$.fragment,t),M(C.$$.fragment,t),M($.$$.fragment,t),M(I.$$.fragment,t),M(W.$$.fragment,t),M(G.$$.fragment,t),M(Q.$$.fragment,t),M(v.$$.fragment,t),ct=!1},d(t){t&&(l(Y),l(X),l(A),l(H),l(g),l(S),l(w),l(F),l(z),l(J),l(D),l(P),l(b),l(L),l(q),l(U),l(K),l(O),l(k),l(tt),l(st),l(Z),l(lt),l(N),l(et),l(at),l(B),l(nt),l(pt),l(x),l(it),l(mt),l(E),l(ot),l(rt),l(ht),l(V)),l(y),j(d,t),j(u,t),j(f,t),j(T,t),j(C,t),j($,t),j(I,t),j(W,t),j(G,t),j(Q,t),j(v,t)}}}const Et='{"title":"Dual Path Network (DPN)","local":"dual-path-network-dpn","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qt(Mt){return Nt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends It{constructor(y){super(),Bt(this,y,Qt,Gt,$t,{})}}export{_t as component};
