import{s as hi,n as ci,o as pi}from"../chunks/scheduler.182ea377.js";import{S as ui,i as mi,g as s,s as l,p as L,A as gi,h as n,f as t,c as a,j as h,q as H,m as d,k as r,v as f,a as o,r as A,d as D,t as S,u as E}from"../chunks/index.008d68e4.js";import{I as N}from"../chunks/IconCopyLink.96bbb92b.js";function vi(yt){let c,$e,p,x,ye,I,ht,he,wt="Philosophy",Me,U,xt=`🧨 Diffusers provides <strong>state-of-the-art</strong> pretrained diffusion models across multiple modalities.
Its purpose is to serve as a <strong>modular toolbox</strong> for both inference and training.`,Le,q,_t="We aim at building a library that stands the test of time and therefore take API design very seriously.",He,z,kt='In a nutshell, Diffusers is built to be a natural extension of PyTorch. Therefore, most of our design choices are based on <a href="https://pytorch.org/docs/stable/community/design.html#pytorch-design-philosophy" rel="nofollow">PyTorch’s Design Principles</a>. Let’s go over the most important ones:',Ae,u,_,we,j,ct,ce,Pt="Usability over Performance",De,O,Tt='<li>While Diffusers has many built-in performance-enhancing features (see <a href="https://huggingface.co/docs/diffusers/optimization/fp16" rel="nofollow">Memory and Speed</a>), models are always loaded with the highest precision and lowest optimization. Therefore, by default diffusion pipelines are always instantiated on CPU with float32 precision if not otherwise defined by the user. This ensures usability across different platforms and accelerators and means that no complex installations are required to run the library.</li> <li>Diffusers aims to be a <strong>light-weight</strong> package and therefore has very few required dependencies, but many soft dependencies that can improve performance (such as <code>accelerate</code>, <code>safetensors</code>, <code>onnx</code>, etc…). We strive to keep the library as lightweight as possible so that it can be added without much concern as a dependency on other packages.</li> <li>Diffusers prefers simple, self-explainable code over condensed, magic code. This means that short-hand code syntaxes such as lambda functions, and advanced PyTorch operators are often not desired.</li>',Se,m,k,xe,F,pt,pe,Ct="Simple over easy",Ee,W,$t="As PyTorch states, <strong>explicit is better than implicit</strong> and <strong>simple is better than complex</strong>. This design philosophy is reflected in multiple parts of the library:",Ne,G,Mt=`<li>We follow PyTorch’s API with methods like <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.to" rel="nofollow"><code>DiffusionPipeline.to</code></a> to let the user handle device management.</li> <li>Raising concise error messages is preferred to silently correct erroneous input. Diffusers aims at teaching the user, rather than making the library as easy to use as possible.</li> <li>Complex model vs. scheduler logic is exposed instead of magically handled inside. Schedulers/Samplers are separated from diffusion models with minimal dependencies on each other. This forces the user to write the unrolled denoising loop. However, the separation allows for easier debugging and gives the user more control over adapting the denoising process or switching out diffusion models or schedulers.</li> <li>Separately trained components of the diffusion pipeline, <em>e.g.</em> the text encoder, the unet, and the variational autoencoder, each have their own model class. This forces the user to handle the interaction between the different model components, and the serialization format separates the model components into different files. However, this allows for easier debugging and customization. DreamBooth or Textual Inversion training
is very simple thanks to Diffusers’ ability to separate single components of the diffusion pipeline.</li>`,Ie,g,P,_e,R,ut,ue,Lt="Tweakable, contributor-friendly over abstraction",Ue,B,Ht=`For large parts of the library, Diffusers adopts an important design principle of the <a href="https://github.com/huggingface/transformers" rel="nofollow">Transformers library</a>, which is to prefer copy-pasted code over hasty abstractions. This design principle is very opinionated and stands in stark contrast to popular design principles such as <a href="https://en.wikipedia.org/wiki/Don%27t_repeat_yourself" rel="nofollow">Don’t repeat yourself (DRY)</a>.
In short, just like Transformers does for modeling files, Diffusers prefers to keep an extremely low level of abstraction and very self-contained code for pipelines and schedulers.
Functions, long code blocks, and even classes can be copied across multiple files which at first can look like a bad, sloppy design choice that makes the library unmaintainable.
<strong>However</strong>, this design has proven to be extremely successful for Transformers and makes a lot of sense for community-driven, open-source machine learning libraries because:`,qe,J,At="<li>Machine Learning is an extremely fast-moving field in which paradigms, model architectures, and algorithms are changing rapidly, which therefore makes it very difficult to define long-lasting code abstractions.</li> <li>Machine Learning practitioners like to be able to quickly tweak existing code for ideation and research and therefore prefer self-contained code over one that contains many abstractions.</li> <li>Open-source libraries rely on community contributions and therefore must build a library that is easy to contribute to. The more abstract the code, the more dependencies, the harder to read, and the harder to contribute to. Contributors simply stop contributing to very abstract libraries out of fear of breaking vital functionality. If contributing to a library cannot break other fundamental code, not only is it more inviting for potential new contributors, but it is also easier to review and contribute to multiple parts in parallel.</li>",ze,Y,Dt=`At Hugging Face, we call this design the <strong>single-file policy</strong> which means that almost all of the code of a certain class should be written in a single, self-contained file. To read more about the philosophy, you can have a look
at <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">this blog post</a>.`,je,K,St=`In Diffusers, we follow this philosophy for both pipelines and schedulers, but only partly for diffusion models. The reason we don’t follow this design fully for diffusion models is because almost all diffusion pipelines, such
as <a href="https://huggingface.co/docs/diffusers/api/pipelines/ddpm" rel="nofollow">DDPM</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview#stable-diffusion-pipelines" rel="nofollow">Stable Diffusion</a>, <a href="https://huggingface.co/docs/diffusers/api/pipelines/unclip" rel="nofollow">unCLIP (DALL·E 2)</a> and <a href="https://imagen.research.google/" rel="nofollow">Imagen</a> all rely on the same diffusion model, the <a href="https://huggingface.co/docs/diffusers/api/models/unet2d-cond" rel="nofollow">UNet</a>.`,Oe,Q,Et=`Great, now you should have generally understood why 🧨 Diffusers is designed the way it is 🤗.
We try to apply these design principles consistently across the library. Nevertheless, there are some minor exceptions to the philosophy or some unlucky design choices. If you have feedback regarding the design, we would ❤️  to hear it <a href="https://github.com/huggingface/diffusers/issues/new?assignees=&amp;labels=&amp;template=feedback.md&amp;title=" rel="nofollow">directly on GitHub</a>.`,Fe,v,T,ke,V,mt,me,Nt="Design Philosophy in Details",We,X,It=`Now, let’s look a bit into the nitty-gritty details of the design philosophy. Diffusers essentially consists of three major classes: <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines" rel="nofollow">pipelines</a>, <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow">models</a>, and <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow">schedulers</a>.
Let’s walk through more in-detail design decisions for each class.`,Ge,b,C,Pe,Z,gt,ge,Ut="Pipelines",Re,ee,qt='Pipelines are designed to be easy to use (therefore do not follow <a href="#simple-over-easy"><em>Simple over easy</em></a> 100%), are not feature complete, and should loosely be seen as examples of how to use <a href="#models">models</a> and <a href="#schedulers">schedulers</a> for inference.',Be,te,zt="The following design principles are followed:",Je,ie,jt='<li>Pipelines follow the single-file policy. All pipelines can be found in individual directories under src/diffusers/pipelines. One pipeline folder corresponds to one diffusion paper/project/release. Multiple pipeline files can be gathered in one pipeline folder, as it’s done for <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/pipelines/stable_diffusion" rel="nofollow"><code>src/diffusers/pipelines/stable-diffusion</code></a>. If pipelines share similar functionality, one can make use of the <a href="https://github.com/huggingface/diffusers/blob/125d783076e5bd9785beb05367a2d2566843a271/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L251" rel="nofollow">#Copied from mechanism</a>.</li> <li>Pipelines all inherit from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>.</li> <li>Every pipeline consists of different model and scheduler components, that are documented in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code> file</a>, are accessible under the same name as attributes of the pipeline and can be shared between pipelines with <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.components" rel="nofollow"><code>DiffusionPipeline.components</code></a> function.</li> <li>Every pipeline should be loadable via the <a href="https://huggingface.co/docs/diffusers/main/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained" rel="nofollow"><code>DiffusionPipeline.from_pretrained</code></a> function.</li> <li>Pipelines should be used <strong>only</strong> for inference.</li> <li>Pipelines should be very readable, self-explanatory, and easy to tweak.</li> <li>Pipelines should be designed to build on top of each other and be easy to integrate into higher-level APIs.</li> <li>Pipelines are <strong>not</strong> intended to be feature-complete user interfaces. For future complete user interfaces one should rather have a look at <a href="https://github.com/invoke-ai/InvokeAI" rel="nofollow">InvokeAI</a>, <a href="https://github.com/abhishekkrthakur/diffuzers" rel="nofollow">Diffuzers</a>, and <a href="https://github.com/Sanster/lama-cleaner" rel="nofollow">lama-cleaner</a>.</li> <li>Every pipeline should have one and only one way to run it via a <code>__call__</code> method. The naming of the <code>__call__</code> arguments should be shared across all pipelines.</li> <li>Pipelines should be named after the task they are intended to solve.</li> <li>In almost all cases, novel diffusion pipelines shall be implemented in a new pipeline folder/file.</li>',Ye,y,$,Te,oe,vt,ve,Ot="Models",Ke,se,Ft='Models are designed as configurable toolboxes that are natural extensions of <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow">PyTorch’s Module class</a>. They only partly follow the <strong>single-file policy</strong>.',Qe,ne,Wt="The following design principles are followed:",Ve,le,Gt=`<li>Models correspond to <strong>a type of model architecture</strong>. <em>E.g.</em> the <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> class is used for all UNet variations that expect 2D image inputs and are conditioned on some context.</li> <li>All models can be found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/models" rel="nofollow"><code>src/diffusers/models</code></a> and every model architecture shall be defined in its file, e.g. <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unet_2d_condition.py" rel="nofollow"><code>unet_2d_condition.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/transformer_2d.py" rel="nofollow"><code>transformer_2d.py</code></a>, etc…</li> <li>Models <strong>do not</strong> follow the single-file policy and should make use of smaller model building blocks, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention.py" rel="nofollow"><code>attention.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/resnet.py" rel="nofollow"><code>resnet.py</code></a>, <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/embeddings.py" rel="nofollow"><code>embeddings.py</code></a>, etc… <strong>Note</strong>: This is in stark contrast to Transformers’ modeling files and shows that models do not really follow the single-file policy.</li> <li>Models intend to expose complexity, just like PyTorch’s <code>Module</code> class, and give clear error messages.</li> <li>Models all inherit from <code>ModelMixin</code> and <code>ConfigMixin</code>.</li> <li>Models can be optimized for performance when it doesn’t demand major code changes, keeps backward compatibility, and gives significant memory or compute gain.</li> <li>Models should by default have the highest precision and lowest performance setting.</li> <li>To integrate new model checkpoints whose general architecture can be classified as an architecture that already exists in Diffusers, the existing model architecture shall be adapted to make it work with the new checkpoint. One should only create a new file if the model architecture is fundamentally different.</li> <li>Models should be designed to be easily extendable to future changes. This can be achieved by limiting public function arguments, configuration arguments, and “foreseeing” future changes, <em>e.g.</em> it is usually better to add <code>string</code> “…type” arguments that can easily be extended to new future types instead of boolean <code>is_..._type</code> arguments. Only the minimum amount of changes shall be made to existing architectures to make a new model checkpoint work.</li> <li>The model design is a difficult trade-off between keeping code readable and concise and supporting many model checkpoints. For most parts of the modeling code, classes shall be adapted for new model checkpoints, while there are some exceptions where it is preferred to add new classes to make sure the code is kept concise and
readable long-term, such as <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/unet_2d_blocks.py" rel="nofollow">UNet blocks</a> and <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">Attention processors</a>.</li>`,Xe,w,M,Ce,ae,bt,be,Rt="Schedulers",Ze,re,Bt="Schedulers are responsible to guide the denoising process for inference as well as to define a noise schedule for training. They are designed as individual classes with loadable configuration files and strongly follow the <strong>single-file policy</strong>.",et,fe,Jt="The following design principles are followed:",tt,de,Yt='<li>All schedulers are found in <a href="https://github.com/huggingface/diffusers/tree/main/src/diffusers/schedulers" rel="nofollow"><code>src/diffusers/schedulers</code></a>.</li> <li>Schedulers are <strong>not</strong> allowed to import from large utils files and shall be kept very self-contained.</li> <li>One scheduler Python file corresponds to one scheduler algorithm (as might be defined in a paper).</li> <li>If schedulers share similar functionalities, we can make use of the <code>#Copied from</code> mechanism.</li> <li>Schedulers all inherit from <code>SchedulerMixin</code> and <code>ConfigMixin</code>.</li> <li>Schedulers can be easily swapped out with the <a href="https://huggingface.co/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config" rel="nofollow"><code>ConfigMixin.from_config</code></a> method as explained in detail <a href="../using-diffusers/schedulers.md">here</a>.</li> <li>Every scheduler has to have a <code>set_num_inference_steps</code>, and a <code>step</code> function. <code>set_num_inference_steps(...)</code> has to be called before every denoising process, <em>i.e.</em> before <code>step(...)</code> is called.</li> <li>Every scheduler exposes the timesteps to be “looped over” via a <code>timesteps</code> attribute, which is an array of timesteps the model will be called upon.</li> <li>The <code>step(...)</code> function takes a predicted model output and the “current” sample (x_t) and returns the “previous”, slightly more denoised sample (x_t-1).</li> <li>Given the complexity of diffusion schedulers, the <code>step</code> function does not expose all the complexity and can be a bit of a “black box”.</li> <li>In almost all cases, novel schedulers shall be implemented in a new scheduling file.</li>',it;return I=new N({}),j=new N({}),F=new N({}),R=new N({}),V=new N({}),Z=new N({}),oe=new N({}),ae=new N({}),{c(){c=s("meta"),$e=l(),p=s("h1"),x=s("a"),ye=s("span"),L(I.$$.fragment),ht=l(),he=s("span"),he.textContent=wt,Me=l(),U=s("p"),U.innerHTML=xt,Le=l(),q=s("p"),q.textContent=_t,He=l(),z=s("p"),z.innerHTML=kt,Ae=l(),u=s("h2"),_=s("a"),we=s("span"),L(j.$$.fragment),ct=l(),ce=s("span"),ce.textContent=Pt,De=l(),O=s("ul"),O.innerHTML=Tt,Se=l(),m=s("h2"),k=s("a"),xe=s("span"),L(F.$$.fragment),pt=l(),pe=s("span"),pe.textContent=Ct,Ee=l(),W=s("p"),W.innerHTML=$t,Ne=l(),G=s("ul"),G.innerHTML=Mt,Ie=l(),g=s("h2"),P=s("a"),_e=s("span"),L(R.$$.fragment),ut=l(),ue=s("span"),ue.textContent=Lt,Ue=l(),B=s("p"),B.innerHTML=Ht,qe=l(),J=s("ul"),J.innerHTML=At,ze=l(),Y=s("p"),Y.innerHTML=Dt,je=l(),K=s("p"),K.innerHTML=St,Oe=l(),Q=s("p"),Q.innerHTML=Et,Fe=l(),v=s("h2"),T=s("a"),ke=s("span"),L(V.$$.fragment),mt=l(),me=s("span"),me.textContent=Nt,We=l(),X=s("p"),X.innerHTML=It,Ge=l(),b=s("h3"),C=s("a"),Pe=s("span"),L(Z.$$.fragment),gt=l(),ge=s("span"),ge.textContent=Ut,Re=l(),ee=s("p"),ee.innerHTML=qt,Be=l(),te=s("p"),te.textContent=zt,Je=l(),ie=s("ul"),ie.innerHTML=jt,Ye=l(),y=s("h3"),$=s("a"),Te=s("span"),L(oe.$$.fragment),vt=l(),ve=s("span"),ve.textContent=Ot,Ke=l(),se=s("p"),se.innerHTML=Ft,Qe=l(),ne=s("p"),ne.textContent=Wt,Ve=l(),le=s("ul"),le.innerHTML=Gt,Xe=l(),w=s("h3"),M=s("a"),Ce=s("span"),L(ae.$$.fragment),bt=l(),be=s("span"),be.textContent=Rt,Ze=l(),re=s("p"),re.innerHTML=Bt,et=l(),fe=s("p"),fe.textContent=Jt,tt=l(),de=s("ul"),de.innerHTML=Yt,this.h()},l(e){const i=gi("svelte-1phssyn",document.head);c=n(i,"META",{name:!0,content:!0}),i.forEach(t),$e=a(e),p=n(e,"H1",{class:!0});var ot=h(p);x=n(ot,"A",{id:!0,class:!0,href:!0});var Kt=h(x);ye=n(Kt,"SPAN",{});var Qt=h(ye);H(I.$$.fragment,Qt),Qt.forEach(t),Kt.forEach(t),ht=a(ot),he=n(ot,"SPAN",{"data-svelte-h":!0}),d(he)!=="svelte-1c7t9d0"&&(he.textContent=wt),ot.forEach(t),Me=a(e),U=n(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-7afmi5"&&(U.innerHTML=xt),Le=a(e),q=n(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-ymjbvo"&&(q.textContent=_t),He=a(e),z=n(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1qf3v7v"&&(z.innerHTML=kt),Ae=a(e),u=n(e,"H2",{class:!0});var st=h(u);_=n(st,"A",{id:!0,class:!0,href:!0});var Vt=h(_);we=n(Vt,"SPAN",{});var Xt=h(we);H(j.$$.fragment,Xt),Xt.forEach(t),Vt.forEach(t),ct=a(st),ce=n(st,"SPAN",{"data-svelte-h":!0}),d(ce)!=="svelte-vvriir"&&(ce.textContent=Pt),st.forEach(t),De=a(e),O=n(e,"UL",{"data-svelte-h":!0}),d(O)!=="svelte-wzmc8i"&&(O.innerHTML=Tt),Se=a(e),m=n(e,"H2",{class:!0});var nt=h(m);k=n(nt,"A",{id:!0,class:!0,href:!0});var Zt=h(k);xe=n(Zt,"SPAN",{});var ei=h(xe);H(F.$$.fragment,ei),ei.forEach(t),Zt.forEach(t),pt=a(nt),pe=n(nt,"SPAN",{"data-svelte-h":!0}),d(pe)!=="svelte-gdqk8b"&&(pe.textContent=Ct),nt.forEach(t),Ee=a(e),W=n(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-rwqz34"&&(W.innerHTML=$t),Ne=a(e),G=n(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-10zm1ge"&&(G.innerHTML=Mt),Ie=a(e),g=n(e,"H2",{class:!0});var lt=h(g);P=n(lt,"A",{id:!0,class:!0,href:!0});var ti=h(P);_e=n(ti,"SPAN",{});var ii=h(_e);H(R.$$.fragment,ii),ii.forEach(t),ti.forEach(t),ut=a(lt),ue=n(lt,"SPAN",{"data-svelte-h":!0}),d(ue)!=="svelte-wmy43g"&&(ue.textContent=Lt),lt.forEach(t),Ue=a(e),B=n(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1maatxx"&&(B.innerHTML=Ht),qe=a(e),J=n(e,"UL",{"data-svelte-h":!0}),d(J)!=="svelte-8d4xn1"&&(J.innerHTML=At),ze=a(e),Y=n(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-cg0ywv"&&(Y.innerHTML=Dt),je=a(e),K=n(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-s9oxaw"&&(K.innerHTML=St),Oe=a(e),Q=n(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-k3kirj"&&(Q.innerHTML=Et),Fe=a(e),v=n(e,"H2",{class:!0});var at=h(v);T=n(at,"A",{id:!0,class:!0,href:!0});var oi=h(T);ke=n(oi,"SPAN",{});var si=h(ke);H(V.$$.fragment,si),si.forEach(t),oi.forEach(t),mt=a(at),me=n(at,"SPAN",{"data-svelte-h":!0}),d(me)!=="svelte-1ffq0tn"&&(me.textContent=Nt),at.forEach(t),We=a(e),X=n(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-g3jwp9"&&(X.innerHTML=It),Ge=a(e),b=n(e,"H3",{class:!0});var rt=h(b);C=n(rt,"A",{id:!0,class:!0,href:!0});var ni=h(C);Pe=n(ni,"SPAN",{});var li=h(Pe);H(Z.$$.fragment,li),li.forEach(t),ni.forEach(t),gt=a(rt),ge=n(rt,"SPAN",{"data-svelte-h":!0}),d(ge)!=="svelte-l4debw"&&(ge.textContent=Ut),rt.forEach(t),Re=a(e),ee=n(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1ln30jf"&&(ee.innerHTML=qt),Be=a(e),te=n(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1yq4knn"&&(te.textContent=zt),Je=a(e),ie=n(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-ehx8fw"&&(ie.innerHTML=jt),Ye=a(e),y=n(e,"H3",{class:!0});var ft=h(y);$=n(ft,"A",{id:!0,class:!0,href:!0});var ai=h($);Te=n(ai,"SPAN",{});var ri=h(Te);H(oe.$$.fragment,ri),ri.forEach(t),ai.forEach(t),vt=a(ft),ve=n(ft,"SPAN",{"data-svelte-h":!0}),d(ve)!=="svelte-14dxrcz"&&(ve.textContent=Ot),ft.forEach(t),Ke=a(e),se=n(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-bb7xr2"&&(se.innerHTML=Ft),Qe=a(e),ne=n(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1yq4knn"&&(ne.textContent=Wt),Ve=a(e),le=n(e,"UL",{"data-svelte-h":!0}),d(le)!=="svelte-1p55z7f"&&(le.innerHTML=Gt),Xe=a(e),w=n(e,"H3",{class:!0});var dt=h(w);M=n(dt,"A",{id:!0,class:!0,href:!0});var fi=h(M);Ce=n(fi,"SPAN",{});var di=h(Ce);H(ae.$$.fragment,di),di.forEach(t),fi.forEach(t),bt=a(dt),be=n(dt,"SPAN",{"data-svelte-h":!0}),d(be)!=="svelte-1mh2qlv"&&(be.textContent=Rt),dt.forEach(t),Ze=a(e),re=n(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-fs6rzc"&&(re.innerHTML=Bt),et=a(e),fe=n(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-1yq4knn"&&(fe.textContent=Jt),tt=a(e),de=n(e,"UL",{"data-svelte-h":!0}),d(de)!=="svelte-fstk4u"&&(de.innerHTML=Yt),this.h()},h(){r(c,"name","hf:doc:metadata"),r(c,"content",JSON.stringify(bi)),r(x,"id","philosophy"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#philosophy"),r(p,"class","relative group"),r(_,"id","usability-over-performance"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#usability-over-performance"),r(u,"class","relative group"),r(k,"id","simple-over-easy"),r(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(k,"href","#simple-over-easy"),r(m,"class","relative group"),r(P,"id","tweakable-contributorfriendly-over-abstraction"),r(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(P,"href","#tweakable-contributorfriendly-over-abstraction"),r(g,"class","relative group"),r(T,"id","design-philosophy-in-details"),r(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(T,"href","#design-philosophy-in-details"),r(v,"class","relative group"),r(C,"id","pipelines"),r(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(C,"href","#pipelines"),r(b,"class","relative group"),r($,"id","models"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#models"),r(y,"class","relative group"),r(M,"id","schedulers"),r(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(M,"href","#schedulers"),r(w,"class","relative group")},m(e,i){f(document.head,c),o(e,$e,i),o(e,p,i),f(p,x),f(x,ye),A(I,ye,null),f(p,ht),f(p,he),o(e,Me,i),o(e,U,i),o(e,Le,i),o(e,q,i),o(e,He,i),o(e,z,i),o(e,Ae,i),o(e,u,i),f(u,_),f(_,we),A(j,we,null),f(u,ct),f(u,ce),o(e,De,i),o(e,O,i),o(e,Se,i),o(e,m,i),f(m,k),f(k,xe),A(F,xe,null),f(m,pt),f(m,pe),o(e,Ee,i),o(e,W,i),o(e,Ne,i),o(e,G,i),o(e,Ie,i),o(e,g,i),f(g,P),f(P,_e),A(R,_e,null),f(g,ut),f(g,ue),o(e,Ue,i),o(e,B,i),o(e,qe,i),o(e,J,i),o(e,ze,i),o(e,Y,i),o(e,je,i),o(e,K,i),o(e,Oe,i),o(e,Q,i),o(e,Fe,i),o(e,v,i),f(v,T),f(T,ke),A(V,ke,null),f(v,mt),f(v,me),o(e,We,i),o(e,X,i),o(e,Ge,i),o(e,b,i),f(b,C),f(C,Pe),A(Z,Pe,null),f(b,gt),f(b,ge),o(e,Re,i),o(e,ee,i),o(e,Be,i),o(e,te,i),o(e,Je,i),o(e,ie,i),o(e,Ye,i),o(e,y,i),f(y,$),f($,Te),A(oe,Te,null),f(y,vt),f(y,ve),o(e,Ke,i),o(e,se,i),o(e,Qe,i),o(e,ne,i),o(e,Ve,i),o(e,le,i),o(e,Xe,i),o(e,w,i),f(w,M),f(M,Ce),A(ae,Ce,null),f(w,bt),f(w,be),o(e,Ze,i),o(e,re,i),o(e,et,i),o(e,fe,i),o(e,tt,i),o(e,de,i),it=!0},p:ci,i(e){it||(D(I.$$.fragment,e),D(j.$$.fragment,e),D(F.$$.fragment,e),D(R.$$.fragment,e),D(V.$$.fragment,e),D(Z.$$.fragment,e),D(oe.$$.fragment,e),D(ae.$$.fragment,e),it=!0)},o(e){S(I.$$.fragment,e),S(j.$$.fragment,e),S(F.$$.fragment,e),S(R.$$.fragment,e),S(V.$$.fragment,e),S(Z.$$.fragment,e),S(oe.$$.fragment,e),S(ae.$$.fragment,e),it=!1},d(e){e&&(t($e),t(p),t(Me),t(U),t(Le),t(q),t(He),t(z),t(Ae),t(u),t(De),t(O),t(Se),t(m),t(Ee),t(W),t(Ne),t(G),t(Ie),t(g),t(Ue),t(B),t(qe),t(J),t(ze),t(Y),t(je),t(K),t(Oe),t(Q),t(Fe),t(v),t(We),t(X),t(Ge),t(b),t(Re),t(ee),t(Be),t(te),t(Je),t(ie),t(Ye),t(y),t(Ke),t(se),t(Qe),t(ne),t(Ve),t(le),t(Xe),t(w),t(Ze),t(re),t(et),t(fe),t(tt),t(de)),t(c),E(I),E(j),E(F),E(R),E(V),E(Z),E(oe),E(ae)}}}const bi={local:"philosophy",sections:[{local:"usability-over-performance",title:"Usability over Performance"},{local:"simple-over-easy",title:"Simple over easy"},{local:"tweakable-contributorfriendly-over-abstraction",title:"Tweakable, contributor-friendly over abstraction"},{local:"design-philosophy-in-details",sections:[{local:"pipelines",title:"Pipelines"},{local:"models",title:"Models"},{local:"schedulers",title:"Schedulers"}],title:"Design Philosophy in Details"}],title:"Philosophy"};function yi(yt){return pi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ki extends ui{constructor(c){super(),mi(this,c,yi,vi,hi,{})}}export{ki as component};
