import{s as ss,o as ns,n as ze}from"../chunks/scheduler.182ea377.js";import{S as as,i as is,g as n,s as i,p as y,A as os,h as a,f as t,c as o,j as f,q as w,m,k as c,v as u,a as s,r as J,d as T,t as U,u as j}from"../chunks/index.008d68e4.js";import{T as Ye}from"../chunks/Tip.4f096367.js";import{I as z}from"../chunks/IconCopyLink.96bbb92b.js";import{C as F}from"../chunks/CodeBlock.5ed6eb7b.js";function ps(b){let p,M='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){p=n("p"),p.innerHTML=M},l(r){p=a(r,"P",{"data-svelte-h":!0}),m(p)!=="svelte-15lbm2y"&&(p.innerHTML=M)},m(r,h){s(r,p,h)},p:ze,d(r){r&&t(p)}}}function rs(b){let p,M='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){p=n("p"),p.innerHTML=M},l(r){p=a(r,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1yyrc0t"&&(p.innerHTML=M)},m(r,h){s(r,p,h)},p:ze,d(r){r&&t(p)}}}function ms(b){let p,M='When using <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',r,h,v='<a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){p=n("p"),p.innerHTML=M,r=i(),h=n("p"),h.innerHTML=v},l(d){p=a(d,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1697vi3"&&(p.innerHTML=M),r=o(d),h=a(d,"P",{"data-svelte-h":!0}),m(h)!=="svelte-ivc2dm"&&(h.innerHTML=v)},m(d,_){s(d,p,_),s(d,r,_),s(d,h,_)},p:ze,d(d){d&&(t(p),t(r),t(h))}}}function cs(b){let p,M="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){p=n("p"),p.textContent=M},l(r){p=a(r,"P",{"data-svelte-h":!0}),m(p)!=="svelte-1guxtqy"&&(p.textContent=M)},m(r,h){s(r,p,h)},p:ze,d(r){r&&t(p)}}}function us(b){let p,M='In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a> for more information.',r,h,v='<a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){p=n("p"),p.innerHTML=M,r=i(),h=n("p"),h.innerHTML=v},l(d){p=a(d,"P",{"data-svelte-h":!0}),m(p)!=="svelte-bljvwk"&&(p.innerHTML=M),r=o(d),h=a(d,"P",{"data-svelte-h":!0}),m(h)!=="svelte-1etuttz"&&(h.innerHTML=v)},m(d,_){s(d,p,_),s(d,r,_),s(d,h,_)},p:ze,d(d){d&&(t(p),t(r),t(h))}}}function hs(b){let p,M="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){p=n("p"),p.innerHTML=M},l(r){p=a(r,"P",{"data-svelte-h":!0}),m(p)!=="svelte-17vr965"&&(p.innerHTML=M)},m(r,h){s(r,p,h)},p:ze,d(r){r&&t(p)}}}function ds(b){let p,M,r,h,v,d,_,xe,cl="Reduce memory usage",nt,L,ul="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",at,$,it,P,hl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",ot,q,dl="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",pt,C,V,Fe,D,nl,Ae,fl="Sliced VAE",rt,K,Ml='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',mt,O,yl='To use sliced VAE, call <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',ct,ee,ut,te,wl="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",ht,Z,k,Le,le,al,Se,Jl="Tiled VAE",dt,se,Tl='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to reduce memory use further if you have xFormers installed.',ft,ne,Ul='To use tiled VAE processing, call <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Mt,ae,yt,ie,jl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",wt,g,E,Pe,oe,il,Xe,bl="CPU offloading",Jt,pe,vl="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Tt,re,_l='To perform CPU offloading, call <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Ut,me,jt,ce,Cl="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",bt,x,vt,A,_t,B,S,qe,ue,ol,Re,Zl="Model offloading",Ct,X,Zt,he,gl='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',gt,de,Bl="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",Bt,fe,Il=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,It,Me,Wl='Enable model offloading by calling <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Wt,ye,Gt,R,$t,I,N,De,we,pl,Ne,Gl="Channels-last memory format",Vt,Je,$l="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",kt,Te,Vl="For example, to set the pipeline’s UNet to use the channels-last format:",Et,Ue,xt,W,H,Ke,je,rl,He,kl="Tracing",At,be,El="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",St,ve,xl="To trace a UNet:",Xt,_e,Rt,Ce,Al="Replace the <code>unet</code> attribute of the pipeline with the traced model:",Nt,Ze,Ht,G,Q,Oe,ge,ml,Qe,Sl="Memory-efficient attention",Qt,Be,Xl='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',Yt,Y,zt,Ie,Rl="To use Flash Attention, install the following:",Ft,We,Nl='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',Lt,Ge,Hl='Then call <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',Pt,$e,qt,Ve,Ql='The iteration speed when using <code>xformers</code> should match the iteration speed of PyTorch 2.0 as described <a href="torch2.0">here</a>.',Dt;return d=new z({}),$=new Ye({props:{$$slots:{default:[ps]},$$scope:{ctx:b}}}),D=new z({}),ee=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBJTIzcGlwZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDMyKS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>
images = pipe([prompt] * <span class="hljs-number">32</span>).images`}}),le=new z({}),ae=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEElMjNwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
<span class="hljs-comment">#pipe.enable_xformers_memory_efficient_attention()</span>

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`}}),oe=new z({}),me=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),x=new Ye({props:{$$slots:{default:[rs]},$$scope:{ctx:b}}}),A=new Ye({props:{warning:!0,$$slots:{default:[ms]},$$scope:{ctx:b}}}),ue=new z({}),X=new Ye({props:{$$slots:{default:[cs]},$$scope:{ctx:b}}}),ye=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`}}),R=new Ye({props:{warning:!0,$$slots:{default:[us]},$$scope:{ctx:b}}}),we=new z({}),Ue=new F({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`}}),je=new z({}),_e=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    timestep = torch.rand(<span class="hljs-number">1</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16) * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn((<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>), device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.float16)
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`}}),Ze=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLkZsb2F0VGVuc29yJTBBJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTBBJTIzJTIwZGVsJTIwcGlwZS51bmV0JTBBY2xhc3MlMjBUcmFjZWRVTmV0KHRvcmNoLm5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5fY2hhbm5lbHMlMjAlM0QlMjBwaXBlLnVuZXQuY29uZmlnLmluX2NoYW5uZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5kZXZpY2UlMjAlM0QlMjBwaXBlLnVuZXQuZGV2aWNlJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwbGF0ZW50X21vZGVsX2lucHV0JTJDJTIwdCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjB1bmV0X3RyYWNlZChsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBVTmV0MkRDb25kaXRpb25PdXRwdXQoc2FtcGxlJTNEc2FtcGxlKSUwQSUwQSUwQXBpcGUudW5ldCUyMCUzRCUyMFRyYWNlZFVOZXQoKSUwQSUwQXdpdGglMjB0b3JjaC5pbmZlcmVuY2VfbW9kZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyMColMjAxJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.FloatTensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.config.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`}}),ge=new z({}),Y=new Ye({props:{$$slots:{default:[hs]},$$scope:{ctx:b}}}),$e=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`}}),{c(){p=n("meta"),M=i(),r=n("h1"),h=n("a"),v=n("span"),y(d.$$.fragment),_=i(),xe=n("span"),xe.textContent=cl,nt=i(),L=n("p"),L.textContent=ul,at=i(),y($.$$.fragment),it=i(),P=n("p"),P.textContent=hl,ot=i(),q=n("table"),q.innerHTML=dl,pt=i(),C=n("h2"),V=n("a"),Fe=n("span"),y(D.$$.fragment),nl=i(),Ae=n("span"),Ae.textContent=fl,rt=i(),K=n("p"),K.innerHTML=Ml,mt=i(),O=n("p"),O.innerHTML=yl,ct=i(),y(ee.$$.fragment),ut=i(),te=n("p"),te.textContent=wl,ht=i(),Z=n("h2"),k=n("a"),Le=n("span"),y(le.$$.fragment),al=i(),Se=n("span"),Se.textContent=Jl,dt=i(),se=n("p"),se.innerHTML=Tl,ft=i(),ne=n("p"),ne.innerHTML=Ul,Mt=i(),y(ae.$$.fragment),yt=i(),ie=n("p"),ie.textContent=jl,wt=i(),g=n("h2"),E=n("a"),Pe=n("span"),y(oe.$$.fragment),il=i(),Xe=n("span"),Xe.textContent=bl,Jt=i(),pe=n("p"),pe.textContent=vl,Tt=i(),re=n("p"),re.innerHTML=_l,Ut=i(),y(me.$$.fragment),jt=i(),ce=n("p"),ce.innerHTML=Cl,bt=i(),y(x.$$.fragment),vt=i(),y(A.$$.fragment),_t=i(),B=n("h2"),S=n("a"),qe=n("span"),y(ue.$$.fragment),ol=i(),Re=n("span"),Re.textContent=Zl,Ct=i(),y(X.$$.fragment),Zt=i(),he=n("p"),he.innerHTML=gl,gt=i(),de=n("p"),de.innerHTML=Bl,Bt=i(),fe=n("p"),fe.textContent=Il,It=i(),Me=n("p"),Me.innerHTML=Wl,Wt=i(),y(ye.$$.fragment),Gt=i(),y(R.$$.fragment),$t=i(),I=n("h2"),N=n("a"),De=n("span"),y(we.$$.fragment),pl=i(),Ne=n("span"),Ne.textContent=Gl,Vt=i(),Je=n("p"),Je.textContent=$l,kt=i(),Te=n("p"),Te.textContent=Vl,Et=i(),y(Ue.$$.fragment),xt=i(),W=n("h2"),H=n("a"),Ke=n("span"),y(je.$$.fragment),rl=i(),He=n("span"),He.textContent=kl,At=i(),be=n("p"),be.innerHTML=El,St=i(),ve=n("p"),ve.textContent=xl,Xt=i(),y(_e.$$.fragment),Rt=i(),Ce=n("p"),Ce.innerHTML=Al,Nt=i(),y(Ze.$$.fragment),Ht=i(),G=n("h2"),Q=n("a"),Oe=n("span"),y(ge.$$.fragment),ml=i(),Qe=n("span"),Qe.textContent=Sl,Qt=i(),Be=n("p"),Be.innerHTML=Xl,Yt=i(),y(Y.$$.fragment),zt=i(),Ie=n("p"),Ie.textContent=Rl,Ft=i(),We=n("ul"),We.innerHTML=Nl,Lt=i(),Ge=n("p"),Ge.innerHTML=Hl,Pt=i(),y($e.$$.fragment),qt=i(),Ve=n("p"),Ve.innerHTML=Ql,this.h()},l(e){const l=os("svelte-1phssyn",document.head);p=a(l,"META",{name:!0,content:!0}),l.forEach(t),M=o(e),r=a(e,"H1",{class:!0});var ke=f(r);h=a(ke,"A",{id:!0,class:!0,href:!0});var et=f(h);v=a(et,"SPAN",{});var tt=f(v);w(d.$$.fragment,tt),tt.forEach(t),et.forEach(t),_=o(ke),xe=a(ke,"SPAN",{"data-svelte-h":!0}),m(xe)!=="svelte-53j3uh"&&(xe.textContent=cl),ke.forEach(t),nt=o(e),L=a(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-18ag1qn"&&(L.textContent=ul),at=o(e),w($.$$.fragment,e),it=o(e),P=a(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1nfsyhf"&&(P.textContent=hl),ot=o(e),q=a(e,"TABLE",{"data-svelte-h":!0}),m(q)!=="svelte-qiiy0g"&&(q.innerHTML=dl),pt=o(e),C=a(e,"H2",{class:!0});var Ee=f(C);V=a(Ee,"A",{id:!0,class:!0,href:!0});var lt=f(V);Fe=a(lt,"SPAN",{});var st=f(Fe);w(D.$$.fragment,st),st.forEach(t),lt.forEach(t),nl=o(Ee),Ae=a(Ee,"SPAN",{"data-svelte-h":!0}),m(Ae)!=="svelte-1wssjyn"&&(Ae.textContent=fl),Ee.forEach(t),rt=o(e),K=a(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1r555c8"&&(K.innerHTML=Ml),mt=o(e),O=a(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1faejuc"&&(O.innerHTML=yl),ct=o(e),w(ee.$$.fragment,e),ut=o(e),te=a(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-fte8mn"&&(te.textContent=wl),ht=o(e),Z=a(e,"H2",{class:!0});var Kt=f(Z);k=a(Kt,"A",{id:!0,class:!0,href:!0});var Yl=f(k);Le=a(Yl,"SPAN",{});var zl=f(Le);w(le.$$.fragment,zl),zl.forEach(t),Yl.forEach(t),al=o(Kt),Se=a(Kt,"SPAN",{"data-svelte-h":!0}),m(Se)!=="svelte-1n1lykz"&&(Se.textContent=Jl),Kt.forEach(t),dt=o(e),se=a(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-13s6py1"&&(se.innerHTML=Tl),ft=o(e),ne=a(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1hr8tjt"&&(ne.innerHTML=Ul),Mt=o(e),w(ae.$$.fragment,e),yt=o(e),ie=a(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-nyzaca"&&(ie.textContent=jl),wt=o(e),g=a(e,"H2",{class:!0});var Ot=f(g);E=a(Ot,"A",{id:!0,class:!0,href:!0});var Fl=f(E);Pe=a(Fl,"SPAN",{});var Ll=f(Pe);w(oe.$$.fragment,Ll),Ll.forEach(t),Fl.forEach(t),il=o(Ot),Xe=a(Ot,"SPAN",{"data-svelte-h":!0}),m(Xe)!=="svelte-1qjgn7i"&&(Xe.textContent=bl),Ot.forEach(t),Jt=o(e),pe=a(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-435lli"&&(pe.textContent=vl),Tt=o(e),re=a(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-d2g1hu"&&(re.innerHTML=_l),Ut=o(e),w(me.$$.fragment,e),jt=o(e),ce=a(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-153k8wf"&&(ce.innerHTML=Cl),bt=o(e),w(x.$$.fragment,e),vt=o(e),w(A.$$.fragment,e),_t=o(e),B=a(e,"H2",{class:!0});var el=f(B);S=a(el,"A",{id:!0,class:!0,href:!0});var Pl=f(S);qe=a(Pl,"SPAN",{});var ql=f(qe);w(ue.$$.fragment,ql),ql.forEach(t),Pl.forEach(t),ol=o(el),Re=a(el,"SPAN",{"data-svelte-h":!0}),m(Re)!=="svelte-19z4ykt"&&(Re.textContent=Zl),el.forEach(t),Ct=o(e),w(X.$$.fragment,e),Zt=o(e),he=a(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-1w0xgx8"&&(he.innerHTML=gl),gt=o(e),de=a(e,"P",{"data-svelte-h":!0}),m(de)!=="svelte-nislc4"&&(de.innerHTML=Bl),Bt=o(e),fe=a(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-11gjm3"&&(fe.textContent=Il),It=o(e),Me=a(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-il713c"&&(Me.innerHTML=Wl),Wt=o(e),w(ye.$$.fragment,e),Gt=o(e),w(R.$$.fragment,e),$t=o(e),I=a(e,"H2",{class:!0});var tl=f(I);N=a(tl,"A",{id:!0,class:!0,href:!0});var Dl=f(N);De=a(Dl,"SPAN",{});var Kl=f(De);w(we.$$.fragment,Kl),Kl.forEach(t),Dl.forEach(t),pl=o(tl),Ne=a(tl,"SPAN",{"data-svelte-h":!0}),m(Ne)!=="svelte-1kp7b6m"&&(Ne.textContent=Gl),tl.forEach(t),Vt=o(e),Je=a(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-sky5la"&&(Je.textContent=$l),kt=o(e),Te=a(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-mhdc10"&&(Te.textContent=Vl),Et=o(e),w(Ue.$$.fragment,e),xt=o(e),W=a(e,"H2",{class:!0});var ll=f(W);H=a(ll,"A",{id:!0,class:!0,href:!0});var Ol=f(H);Ke=a(Ol,"SPAN",{});var es=f(Ke);w(je.$$.fragment,es),es.forEach(t),Ol.forEach(t),rl=o(ll),He=a(ll,"SPAN",{"data-svelte-h":!0}),m(He)!=="svelte-1svtb99"&&(He.textContent=kl),ll.forEach(t),At=o(e),be=a(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1hj6sqj"&&(be.innerHTML=El),St=o(e),ve=a(e,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-1ca1ko1"&&(ve.textContent=xl),Xt=o(e),w(_e.$$.fragment,e),Rt=o(e),Ce=a(e,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-mpebhd"&&(Ce.innerHTML=Al),Nt=o(e),w(Ze.$$.fragment,e),Ht=o(e),G=a(e,"H2",{class:!0});var sl=f(G);Q=a(sl,"A",{id:!0,class:!0,href:!0});var ts=f(Q);Oe=a(ts,"SPAN",{});var ls=f(Oe);w(ge.$$.fragment,ls),ls.forEach(t),ts.forEach(t),ml=o(sl),Qe=a(sl,"SPAN",{"data-svelte-h":!0}),m(Qe)!=="svelte-1eoj70g"&&(Qe.textContent=Sl),sl.forEach(t),Qt=o(e),Be=a(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1tu2ji2"&&(Be.innerHTML=Xl),Yt=o(e),w(Y.$$.fragment,e),zt=o(e),Ie=a(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-rpfoyf"&&(Ie.textContent=Rl),Ft=o(e),We=a(e,"UL",{"data-svelte-h":!0}),m(We)!=="svelte-1q6gndt"&&(We.innerHTML=Nl),Lt=o(e),Ge=a(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1bsousf"&&(Ge.innerHTML=Hl),Pt=o(e),w($e.$$.fragment,e),qt=o(e),Ve=a(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-1nf2kxh"&&(Ve.innerHTML=Ql),this.h()},h(){c(p,"name","hf:doc:metadata"),c(p,"content",JSON.stringify(fs)),c(h,"id","reduce-memory-usage"),c(h,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(h,"href","#reduce-memory-usage"),c(r,"class","relative group"),c(V,"id","sliced-vae"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#sliced-vae"),c(C,"class","relative group"),c(k,"id","tiled-vae"),c(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(k,"href","#tiled-vae"),c(Z,"class","relative group"),c(E,"id","cpu-offloading"),c(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(E,"href","#cpu-offloading"),c(g,"class","relative group"),c(S,"id","model-offloading"),c(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(S,"href","#model-offloading"),c(B,"class","relative group"),c(N,"id","channelslast-memory-format"),c(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(N,"href","#channelslast-memory-format"),c(I,"class","relative group"),c(H,"id","tracing"),c(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(H,"href","#tracing"),c(W,"class","relative group"),c(Q,"id","memoryefficient-attention"),c(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Q,"href","#memoryefficient-attention"),c(G,"class","relative group")},m(e,l){u(document.head,p),s(e,M,l),s(e,r,l),u(r,h),u(h,v),J(d,v,null),u(r,_),u(r,xe),s(e,nt,l),s(e,L,l),s(e,at,l),J($,e,l),s(e,it,l),s(e,P,l),s(e,ot,l),s(e,q,l),s(e,pt,l),s(e,C,l),u(C,V),u(V,Fe),J(D,Fe,null),u(C,nl),u(C,Ae),s(e,rt,l),s(e,K,l),s(e,mt,l),s(e,O,l),s(e,ct,l),J(ee,e,l),s(e,ut,l),s(e,te,l),s(e,ht,l),s(e,Z,l),u(Z,k),u(k,Le),J(le,Le,null),u(Z,al),u(Z,Se),s(e,dt,l),s(e,se,l),s(e,ft,l),s(e,ne,l),s(e,Mt,l),J(ae,e,l),s(e,yt,l),s(e,ie,l),s(e,wt,l),s(e,g,l),u(g,E),u(E,Pe),J(oe,Pe,null),u(g,il),u(g,Xe),s(e,Jt,l),s(e,pe,l),s(e,Tt,l),s(e,re,l),s(e,Ut,l),J(me,e,l),s(e,jt,l),s(e,ce,l),s(e,bt,l),J(x,e,l),s(e,vt,l),J(A,e,l),s(e,_t,l),s(e,B,l),u(B,S),u(S,qe),J(ue,qe,null),u(B,ol),u(B,Re),s(e,Ct,l),J(X,e,l),s(e,Zt,l),s(e,he,l),s(e,gt,l),s(e,de,l),s(e,Bt,l),s(e,fe,l),s(e,It,l),s(e,Me,l),s(e,Wt,l),J(ye,e,l),s(e,Gt,l),J(R,e,l),s(e,$t,l),s(e,I,l),u(I,N),u(N,De),J(we,De,null),u(I,pl),u(I,Ne),s(e,Vt,l),s(e,Je,l),s(e,kt,l),s(e,Te,l),s(e,Et,l),J(Ue,e,l),s(e,xt,l),s(e,W,l),u(W,H),u(H,Ke),J(je,Ke,null),u(W,rl),u(W,He),s(e,At,l),s(e,be,l),s(e,St,l),s(e,ve,l),s(e,Xt,l),J(_e,e,l),s(e,Rt,l),s(e,Ce,l),s(e,Nt,l),J(Ze,e,l),s(e,Ht,l),s(e,G,l),u(G,Q),u(Q,Oe),J(ge,Oe,null),u(G,ml),u(G,Qe),s(e,Qt,l),s(e,Be,l),s(e,Yt,l),J(Y,e,l),s(e,zt,l),s(e,Ie,l),s(e,Ft,l),s(e,We,l),s(e,Lt,l),s(e,Ge,l),s(e,Pt,l),J($e,e,l),s(e,qt,l),s(e,Ve,l),Dt=!0},p(e,[l]){const ke={};l&2&&(ke.$$scope={dirty:l,ctx:e}),$.$set(ke);const et={};l&2&&(et.$$scope={dirty:l,ctx:e}),x.$set(et);const tt={};l&2&&(tt.$$scope={dirty:l,ctx:e}),A.$set(tt);const Ee={};l&2&&(Ee.$$scope={dirty:l,ctx:e}),X.$set(Ee);const lt={};l&2&&(lt.$$scope={dirty:l,ctx:e}),R.$set(lt);const st={};l&2&&(st.$$scope={dirty:l,ctx:e}),Y.$set(st)},i(e){Dt||(T(d.$$.fragment,e),T($.$$.fragment,e),T(D.$$.fragment,e),T(ee.$$.fragment,e),T(le.$$.fragment,e),T(ae.$$.fragment,e),T(oe.$$.fragment,e),T(me.$$.fragment,e),T(x.$$.fragment,e),T(A.$$.fragment,e),T(ue.$$.fragment,e),T(X.$$.fragment,e),T(ye.$$.fragment,e),T(R.$$.fragment,e),T(we.$$.fragment,e),T(Ue.$$.fragment,e),T(je.$$.fragment,e),T(_e.$$.fragment,e),T(Ze.$$.fragment,e),T(ge.$$.fragment,e),T(Y.$$.fragment,e),T($e.$$.fragment,e),Dt=!0)},o(e){U(d.$$.fragment,e),U($.$$.fragment,e),U(D.$$.fragment,e),U(ee.$$.fragment,e),U(le.$$.fragment,e),U(ae.$$.fragment,e),U(oe.$$.fragment,e),U(me.$$.fragment,e),U(x.$$.fragment,e),U(A.$$.fragment,e),U(ue.$$.fragment,e),U(X.$$.fragment,e),U(ye.$$.fragment,e),U(R.$$.fragment,e),U(we.$$.fragment,e),U(Ue.$$.fragment,e),U(je.$$.fragment,e),U(_e.$$.fragment,e),U(Ze.$$.fragment,e),U(ge.$$.fragment,e),U(Y.$$.fragment,e),U($e.$$.fragment,e),Dt=!1},d(e){e&&(t(M),t(r),t(nt),t(L),t(at),t(it),t(P),t(ot),t(q),t(pt),t(C),t(rt),t(K),t(mt),t(O),t(ct),t(ut),t(te),t(ht),t(Z),t(dt),t(se),t(ft),t(ne),t(Mt),t(yt),t(ie),t(wt),t(g),t(Jt),t(pe),t(Tt),t(re),t(Ut),t(jt),t(ce),t(bt),t(vt),t(_t),t(B),t(Ct),t(Zt),t(he),t(gt),t(de),t(Bt),t(fe),t(It),t(Me),t(Wt),t(Gt),t($t),t(I),t(Vt),t(Je),t(kt),t(Te),t(Et),t(xt),t(W),t(At),t(be),t(St),t(ve),t(Xt),t(Rt),t(Ce),t(Nt),t(Ht),t(G),t(Qt),t(Be),t(Yt),t(zt),t(Ie),t(Ft),t(We),t(Lt),t(Ge),t(Pt),t(qt),t(Ve)),t(p),j(d),j($,e),j(D),j(ee,e),j(le),j(ae,e),j(oe),j(me,e),j(x,e),j(A,e),j(ue),j(X,e),j(ye,e),j(R,e),j(we),j(Ue,e),j(je),j(_e,e),j(Ze,e),j(ge),j(Y,e),j($e,e)}}}const fs={local:"reduce-memory-usage",sections:[{local:"sliced-vae",title:"Sliced VAE"},{local:"tiled-vae",title:"Tiled VAE"},{local:"cpu-offloading",title:"CPU offloading"},{local:"model-offloading",title:"Model offloading"},{local:"channelslast-memory-format",title:"Channels-last memory format"},{local:"tracing",title:"Tracing"},{local:"memoryefficient-attention",title:"Memory-efficient attention"}],title:"Reduce memory usage"};function Ms(b){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class js extends as{constructor(p){super(),is(this,p,Ms,ds,ss,{})}}export{js as component};
