import{s as Vn,o as Yn,n as Qo}from"../chunks/scheduler.182ea377.js";import{S as Kn,i as es,g as n,s as i,p as f,A as ts,h as s,f as t,c as r,j as c,q as h,m as p,k as l,v as o,a as d,r as g,d as _,t as v,u as b}from"../chunks/index.008d68e4.js";import{T as os}from"../chunks/Tip.4f096367.js";import{D as A}from"../chunks/Docstring.7aec8b85.js";import{C as Rn}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as U}from"../chunks/IconCopyLink.96bbb92b.js";import{E as zn}from"../chunks/ExampleCodeBlock.23e54afe.js";function ns(H){let u,k='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){u=n("p"),u.innerHTML=k},l(w){u=s(w,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1wmc0l4"&&(u.innerHTML=k)},m(w,M){d(w,u,M)},p:Qo,d(w){w&&t(u)}}}function ss(H){let u,k="Examples:",w,M,D;return M=new Rn({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMHByb21wdHMlMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjBzb3VuZCUyMG9mJTIwYSUyMGhhbW1lciUyMGhpdHRpbmclMjBhJTIwd29vZGVuJTIwc3VyZmFjZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJMb3clMjBxdWFsaXR5LiUyMiUwQSUwQSUyMyUyMHNldCUyMHRoZSUyMHNlZWQlMjBmb3IlMjBnZW5lcmF0b3IlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjB0aGUlMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1fd2F2ZWZvcm1zX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5hdWRpb3MlMEElMEElMjMlMjBzYXZlJTIwdGhlJTIwYmVzdCUyMGF1ZGlvJTIwc2FtcGxlJTIwKGluZGV4JTIwMCklMjBhcyUyMGElMjAud2F2JTIwZmlsZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIydGVjaG5vLndhdiUyMiUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGRhdGElM0RhdWRpbyU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the prompts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The sound of a hammer hitting a wooden surface.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Low quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set the seed for generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># run the generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    num_waveforms_per_prompt=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).audios

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the best audio sample (index 0) as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio[<span class="hljs-number">0</span>])`}}),{c(){u=n("p"),u.textContent=k,w=i(),f(M.$$.fragment)},l(m){u=s(m,"P",{"data-svelte-h":!0}),p(u)!=="svelte-kvfsh7"&&(u.textContent=k),w=r(m),h(M.$$.fragment,m)},m(m,C){d(m,u,C),d(m,w,C),g(M,m,C),D=!0},p:Qo,i(m){D||(_(M.$$.fragment,m),D=!0)},o(m){v(M.$$.fragment,m),D=!1},d(m){m&&(t(u),t(w)),b(M,m)}}}function as(H){let u,k="Example:",w,M,D;return M=new Rn({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMEdldCUyMHRleHQlMjBlbWJlZGRpbmclMjB2ZWN0b3JzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMjAlM0QlMjBwaXBlLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMEElMjAlMjAlMjAlMjBkb19jbGFzc2lmaWVyX2ZyZWVfZ3VpZGFuY2UlM0RUcnVlJTJDJTBBKSUwQSUwQSUyMyUyMFBhc3MlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHRvJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0LWNvbmRpdGlvbmFsJTIwYXVkaW8lMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RhdHRlbnRpb25fbWFzayUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9wcm9tcHRfZW1iZWRzJTNEZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwYXVkaW9fbGVuZ3RoX2luX3MlM0QxMC4wJTJDJTBBKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMGdlbmVyYXRlZCUyMGF1ZGlvJTIwc2FtcGxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get text embedding vectors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_embeds, attention_mask, generated_prompt_embeds = pipe.encode_prompt(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass text embeddings to pipeline for text-conditional audio generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt_embeds=prompt_embeds,
<span class="hljs-meta">... </span>    attention_mask=attention_mask,
<span class="hljs-meta">... </span>    generated_prompt_embeds=generated_prompt_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save generated audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`}}),{c(){u=n("p"),u.textContent=k,w=i(),f(M.$$.fragment)},l(m){u=s(m,"P",{"data-svelte-h":!0}),p(u)!=="svelte-11lpom8"&&(u.textContent=k),w=r(m),h(M.$$.fragment,m)},m(m,C){d(m,u,C),d(m,w,C),g(M,m,C),D=!0},p:Qo,i(m){D||(_(M.$$.fragment,m),D=!0)},o(m){v(M.$$.fragment,m),D=!1},d(m){m&&(t(u),t(w)),b(M,m)}}}function is(H){let u,k,w,M,D,m,C,Ze,Xo="AudioLDM 2",Tt,de,zo='AudioLDM 2 was proposed in <a href="https://arxiv.org/abs/2308.05734" rel="nofollow">AudioLDM 2: Learning Holistic Audio Generation with Self-supervised Pretraining</a> by Haohe Liu et al. AudioLDM 2 takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional sound effects, human speech and music.',At,le,Ro='Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM 2 is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from text embeddings. Two text encoder models are used to compute the text embeddings from a prompt input: the text-branch of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap" rel="nofollow">CLAP</a> and the encoder of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/flan-t5" rel="nofollow">Flan-T5</a>. These text embeddings are then projected to a shared embedding space by an <a href="https://huggingface.co/docs/diffusers/main/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel" rel="nofollow">AudioLDM2ProjectionModel</a>. A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2" rel="nofollow">GPT2</a> <em>language model (LM)</em> is used to auto-regressively predict eight new embedding vectors, conditional on the projected CLAP and Flan-T5 embeddings. The generated embedding vectors and Flan-T5 text embeddings are used as cross-attention conditioning in the LDM. The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel" rel="nofollow">UNet</a> of AudioLDM 2 is unique in the sense that it takes <strong>two</strong> cross-attention embeddings, as opposed to one cross-attention conditioning, as in most other LDMs.',Ct,ce,Vo="The abstract of the paper is the following:",Lt,pe,Yo='<em>Although audio generation shares commonalities across different types of audio, such as speech, music, and sound effects, designing models for each type requires careful consideration of specific objectives and biases that can significantly differ from those of other types. To bring us closer to a unified perspective of audio generation, this paper proposes a framework that utilizes the same learning method for speech, music, and sound effect generation. Our framework introduces a general representation of audio, called “language of audio” (LOA). Any audio can be translated into LOA based on AudioMAE, a self-supervised pre-trained representation learning model. In the generation process, we translate any modalities into LOA by using a GPT-2 model, and we perform self-supervised audio generation learning with a latent diffusion model conditioned on LOA. The proposed framework naturally brings advantages such as in-context learning abilities and reusable self-supervised pretrained AudioMAE and latent diffusion models. Experiments on the major benchmarks of text-to-audio, text-to-music, and text-to-speech demonstrate state-of-the-art or competitive performance against previous approaches. Our code, pretrained model, and demo are available at <a href="https://audioldm.github.io/audioldm2" rel="nofollow">this https URL</a>.</em>',$t,me,Ko='This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original codebase can be found at <a href="https://github.com/haoheliu/audioldm2" rel="nofollow">haoheliu/audioldm2</a>.',jt,N,F,ht,ue,ho,He,en="Tips",Ut,P,W,gt,fe,go,Fe,tn="Choosing a checkpoint",Nt,he,on="AudioLDM2 comes in three variants. Two of these checkpoints are applicable to the general task of text-to-audio generation. The third checkpoint is trained exclusively on text-to-music generation.",Pt,ge,nn=`All checkpoints share the same model size for the text encoders and VAE. They differ in the size and depth of the UNet.
See table below for details on the three checkpoints:`,Bt,_e,sn='<thead><tr><th>Checkpoint</th> <th>Task</th> <th>UNet Model Size</th> <th>Total Model Size</th> <th>Training Data / h</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/cvssp/audioldm2" rel="nofollow">audioldm2</a></td> <td>Text-to-audio</td> <td>350M</td> <td>1.1B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-large" rel="nofollow">audioldm2-large</a></td> <td>Text-to-audio</td> <td>750M</td> <td>1.5B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-music" rel="nofollow">audioldm2-music</a></td> <td>Text-to-music</td> <td>350M</td> <td>1.1B</td> <td>665k</td></tr></tbody>',Jt,B,O,_t,ve,_o,We,an="Constructing a prompt",Et,be,rn="<li>Descriptive prompt inputs work best: use adjectives to describe the sound (e.g. “high quality” or “clear”) and make the prompt context specific (e.g. “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li> <li>Using a <strong>negative prompt</strong> can significantly improve the quality of the generated waveform, by guiding the generation away from terms that correspond to poor quality audio. Try using a negative prompt of “Low quality.”</li>",It,J,Q,vt,Me,vo,Oe,dn="Controlling inference",qt,we,ln="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",St,E,X,bt,ye,bo,Qe,cn="Evaluating generated waveforms:",Gt,xe,pn="<li>The quality of the generated waveforms can vary significantly based on the seed. Try generating with different seeds until you find a satisfactory generation.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li>",Zt,De,mn='The following example demonstrates how to construct good music generation using the aforementioned tips: <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2Pipeline.__call__.example" rel="nofollow">example</a>.',Ht,z,Ft,I,R,Mt,ke,Mo,Xe,un="AudioLDM2Pipeline",Wt,y,Te,wo,ze,fn="Pipeline for text-to-audio generation using AudioLDM2.",yo,Re,hn=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,xo,$,Ae,Do,Ve,gn="The call function to the pipeline for generation.",ko,V,To,Y,Ce,Ao,Ye,_n=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Co,K,Le,Lo,Ke,vn=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,$o,ee,$e,jo,et,bn=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Uo,j,je,No,tt,Mn="Encodes the prompt into text encoder hidden states.",Po,te,Bo,oe,Ue,Jo,ot,wn="Generates a sequence of hidden-states from the language model, conditioned on the embedding inputs.",Ot,q,ne,wt,Ne,Eo,nt,yn="AudioLDM2ProjectionModel",Qt,L,Pe,Io,st,xn=`A simple linear projection model to map two text embeddings to a shared latent space. It also inserts learned
embedding vectors at the start and end of each text embedding sequence respectively. Each variable appended with
<code>_1</code> refers to that corresponding to the second text encoder. Otherwise, it is from the first.`,qo,at,Be,Xt,S,se,yt,Je,So,it,Dn="AudioLDM2UNet2DConditionModel",zt,T,Ee,Go,rt,kn=`A conditional 2D UNet model that takes a noisy sample, conditional state, and a timestep and returns a sample
shaped output. Compared to the vanilla <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>, this variant optionally includes an additional
self-attention layer in each Transformer block, as well as multiple cross-attention layers. It also allows for up
to two cross-attention embeddings, <code>encoder_hidden_states</code> and <code>encoder_hidden_states_1</code>.`,Zo,dt,Tn=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Ho,ae,Ie,Fo,lt,An='The <a href="/docs/diffusers/v0.25.0/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel">AudioLDM2UNet2DConditionModel</a> forward method.',Rt,G,ie,xt,qe,Wo,ct,Cn="AudioPipelineOutput",Vt,Z,Se,Oo,pt,Ln="Output class for audio pipelines.",Yt;return m=new U({}),ue=new U({}),fe=new U({}),ve=new U({}),Me=new U({}),ye=new U({}),z=new os({props:{$$slots:{default:[ns]},$$scope:{ctx:H}}}),ke=new U({}),Te=new A({props:{name:"class diffusers.AudioLDM2Pipeline",anchor:"diffusers.AudioLDM2Pipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapModel"},{name:"text_encoder_2",val:": T5EncoderModel"},{name:"projection_model",val:": AudioLDM2ProjectionModel"},{name:"language_model",val:": GPT2Model"},{name:"tokenizer",val:": Union"},{name:"tokenizer_2",val:": Union"},{name:"feature_extractor",val:": ClapFeatureExtractor"},{name:"unet",val:": AudioLDM2UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
First frozen text-encoder. AudioLDM2 uses the joint audio-text embedding model
<a href="https://huggingface.co/docs/transformers/model_doc/clap#transformers.CLAPTextModelWithProjection" rel="nofollow">CLAP</a>,
specifically the <a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant. The
text branch is used to encode the text prompt to a prompt embedding. The full audio-text model is used to
rank generated waveforms against the text prompt by computing similarity scores.`,name:"text_encoder"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a>) &#x2014;
Second frozen text-encoder. AudioLDM2 uses the encoder of
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">google/flan-t5-large</a> variant.`,name:"text_encoder_2"},{anchor:"diffusers.AudioLDM2Pipeline.projection_model",description:`<strong>projection_model</strong> (<a href="/docs/diffusers/v0.25.0/en/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel">AudioLDM2ProjectionModel</a>) &#x2014;
A trained model used to linearly project the hidden-states from the first and second text encoder models
and insert learned SOS and EOS token embeddings. The projected hidden-states from the two text encoders are
concatenated to give the input to the language model.`,name:"projection_model"},{anchor:"diffusers.AudioLDM2Pipeline.language_model",description:`<strong>language_model</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/gpt2#transformers.GPT2Model" rel="nofollow">GPT2Model</a>) &#x2014;
An auto-regressive language model used to generate a sequence of hidden-states conditioned on the projected
outputs from the two text encoders.`,name:"language_model"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a>) &#x2014;
Tokenizer to tokenize text for the first frozen text-encoder.`,name:"tokenizer"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/mt5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>) &#x2014;
Tokenizer to tokenize text for the second frozen text-encoder.`,name:"tokenizer_2"},{anchor:"diffusers.AudioLDM2Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to pre-process generated audio waveforms to log-mel spectrograms for automatic scoring.`,name:"feature_extractor"},{anchor:"diffusers.AudioLDM2Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDM2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.25.0/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.25.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.25.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDM2Pipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.36.2/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code> to convert the mel-spectrogram latents to the final audio waveform.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L103"}}),Ae=new A({props:{name:"__call__",anchor:"diffusers.AudioLDM2Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 3.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, then automatic
scoring is performed between the generated outputs and the text prompt. This scoring ranks the
generated waveforms based on their cosine similarity with the text input in the joint text-audio
embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for spectrogram
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Number of new tokens to generate with the GPT2 language model. If not provided, number of tokens will
be taken from the config of the model.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L732",returnDescription:`
<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated audio.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),V=new zn({props:{anchor:"diffusers.AudioLDM2Pipeline.__call__.example",$$slots:{default:[ss]},$$scope:{ctx:H}}}),Ce=new A({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L185"}}),Le=new A({props:{name:"enable_model_cpu_offload",anchor:"diffusers.AudioLDM2Pipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L192"}}),$e=new A({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L177"}}),je=new A({props:{name:"encode_prompt",anchor:"diffusers.AudioLDM2Pipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_waveforms_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
torch device`,name:"device"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>) &#x2014;
number of waveforms that should be generated per prompt`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the audio generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed text embeddings from the Flan T5 model. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, text embeddings will be computed from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-computed negative text embeddings from the Flan T5 model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
The number of new tokens to generate with the GPT2 language model.`,name:"max_new_tokens"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L270",returnDescription:`
<p>Text embeddings from the Flan T5 model.
attention_mask (<code>torch.LongTensor</code>):
Attention mask to be applied to the <code>prompt_embeds</code>.
generated_prompt_embeds (<code>torch.FloatTensor</code>):
Text embeddings generated from the GPT2 langauge model.</p>
`,returnType:`
<p>prompt_embeds (<code>torch.FloatTensor</code>)</p>
`}}),te=new zn({props:{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.example",$$slots:{default:[as]},$$scope:{ctx:H}}}),Ue=new A({props:{name:"generate_language_model",anchor:"diffusers.AudioLDM2Pipeline.generate_language_model",parameters:[{name:"inputs_embeds",val:": Tensor = None"},{name:"max_new_tokens",val:": int = 8"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"inputs_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Number of new tokens to generate.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of additional model-specific kwargs that will be forwarded to the <code>forward</code>
function of the model.`,name:"model_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L229",returnDescription:`
<p>The sequence of generated hidden-states.</p>
`,returnType:`
<p><code>inputs_embeds (</code>torch.FloatTensor<code>of shape</code>(batch_size, sequence_length, hidden_size)\`)</p>
`}}),Ne=new U({}),Pe=new A({props:{name:"class diffusers.AudioLDM2ProjectionModel",anchor:"diffusers.AudioLDM2ProjectionModel",parameters:[{name:"text_encoder_dim",val:""},{name:"text_encoder_1_dim",val:""},{name:"langauge_model_dim",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_dim",description:`<strong>text_encoder_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the first text encoder (CLAP).`,name:"text_encoder_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_1_dim",description:`<strong>text_encoder_1_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the second text encoder (T5 or VITS).`,name:"text_encoder_1_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.langauge_model_dim",description:`<strong>langauge_model_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the language model (GPT2).`,name:"langauge_model_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L82"}}),Be=new A({props:{name:"forward",anchor:"diffusers.AudioLDM2ProjectionModel.forward",parameters:[{name:"hidden_states",val:": Optional = None"},{name:"hidden_states_1",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"attention_mask_1",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L111"}}),Je=new U({}),Ee=new A({props:{name:"class diffusers.AudioLDM2UNet2DConditionModel",anchor:"diffusers.AudioLDM2UNet2DConditionModel",parameters:[{name:"sample_size",val:": Optional = None"},{name:"in_channels",val:": int = 4"},{name:"out_channels",val:": int = 4"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"down_block_types",val:": Tuple = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"mid_block_type",val:": Optional = 'UNetMidBlock2DCrossAttn'"},{name:"up_block_types",val:": Tuple = ('UpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D')"},{name:"only_cross_attention",val:": Union = False"},{name:"block_out_channels",val:": Tuple = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": Union = 2"},{name:"downsample_padding",val:": int = 1"},{name:"mid_block_scale_factor",val:": float = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"norm_num_groups",val:": Optional = 32"},{name:"norm_eps",val:": float = 1e-05"},{name:"cross_attention_dim",val:": Union = 1280"},{name:"transformer_layers_per_block",val:": Union = 1"},{name:"attention_head_dim",val:": Union = 8"},{name:"num_attention_heads",val:": Union = None"},{name:"use_linear_projection",val:": bool = False"},{name:"class_embed_type",val:": Optional = None"},{name:"num_class_embeds",val:": Optional = None"},{name:"upcast_attention",val:": bool = False"},{name:"resnet_time_scale_shift",val:": str = 'default'"},{name:"time_embedding_type",val:": str = 'positional'"},{name:"time_embedding_dim",val:": Optional = None"},{name:"time_embedding_act_fn",val:": Optional = None"},{name:"timestep_post_act",val:": Optional = None"},{name:"time_cond_proj_dim",val:": Optional = None"},{name:"conv_in_kernel",val:": int = 3"},{name:"conv_out_kernel",val:": int = 3"},{name:"projection_class_embeddings_input_dim",val:": Optional = None"},{name:"class_embeddings_concat",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.sample_size",description:`<strong>sample_size</strong> (<code>int</code> or <code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Height and width of input/output sample.`,name:"sample_size"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the input sample.",name:"in_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.out_channels",description:"<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.freq_shift",description:"<strong>freq_shift</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The frequency shift to apply to the time embedding.",name:"freq_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;DownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_type",description:`<strong>mid_block_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;UNetMidBlock2DCrossAttn&quot;</code>) &#x2014;
Block type for middle of UNet, it can only be <code>UNetMidBlock2DCrossAttn</code> for AudioLDM2.`,name:"mid_block_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;)</code>) &#x2014;
The tuple of upsample blocks to use.`,name:"up_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.only_cross_attention",description:`<strong>only_cross_attention</strong> (<code>bool</code> or <code>Tuple[bool]</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether to include self-attention in the basic transformer blocks, see
<code>BasicTransformerBlock</code>.`,name:"only_cross_attention"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.layers_per_block",description:"<strong>layers_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; The number of layers per block.",name:"layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.downsample_padding",description:"<strong>downsample_padding</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The padding to use for the downsampling convolution.",name:"downsample_padding"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_scale_factor",description:"<strong>mid_block_scale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; The scale factor to use for the mid block.",name:"mid_block_scale_factor"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014; The number of groups to use for the normalization.
If <code>None</code>, normalization and activation layers is skipped in post-processing.`,name:"norm_num_groups"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_eps",description:"<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014; The epsilon to use for the normalization.",name:"norm_eps"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1280) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.transformer_layers_per_block",description:`<strong>transformer_layers_per_block</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of transformer blocks of type <code>BasicTransformerBlock</code>. Only relevant for
<code>CrossAttnDownBlock2D</code>, <code>CrossAttnUpBlock2D</code>,
<code>UNetMidBlock2DCrossAttn</code>.`,name:"transformer_layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.attention_head_dim",description:"<strong>attention_head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014; The dimension of the attention heads.",name:"attention_head_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads. If not defined, defaults to <code>attention_head_dim</code>`,name:"num_attention_heads"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.resnet_time_scale_shift",description:`<strong>resnet_time_scale_shift</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; Time scale shift config
for ResNet blocks (see <code>ResnetBlock2D</code>). Choose from <code>default</code> or <code>scale_shift</code>.`,name:"resnet_time_scale_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embed_type",description:`<strong>class_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The type of class embedding to use which is ultimately summed with the time embeddings. Choose from <code>None</code>,
<code>&quot;timestep&quot;</code>, <code>&quot;identity&quot;</code>, <code>&quot;projection&quot;</code>, or <code>&quot;simple_projection&quot;</code>.`,name:"class_embed_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_class_embeds",description:`<strong>num_class_embeds</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Input dimension of the learnable embedding matrix to be projected to <code>time_embed_dim</code>, when performing
class conditioning with <code>class_embed_type</code> equal to <code>None</code>.`,name:"num_class_embeds"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_type",description:`<strong>time_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>positional</code>) &#x2014;
The type of position embedding to use for timesteps. Choose from <code>positional</code> or <code>fourier</code>.`,name:"time_embedding_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_dim",description:`<strong>time_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An optional override for the dimension of the projected time embedding.`,name:"time_embedding_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_act_fn",description:`<strong>time_embedding_act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Optional activation function to use only once on the time embeddings before they are passed to the rest of
the UNet. Choose from <code>silu</code>, <code>mish</code>, <code>gelu</code>, and <code>swish</code>.`,name:"time_embedding_act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.timestep_post_act",description:`<strong>timestep_post_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The second activation function to use in timestep embedding. Choose from <code>silu</code>, <code>mish</code> and <code>gelu</code>.`,name:"timestep_post_act"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_cond_proj_dim",description:`<strong>time_cond_proj_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The dimension of <code>cond_proj</code> layer in the timestep embedding.`,name:"time_cond_proj_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_in_kernel",description:"<strong>conv_in_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_in</code> layer.",name:"conv_in_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_out_kernel",description:"<strong>conv_out_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_out</code> layer.",name:"conv_out_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.projection_class_embeddings_input_dim",description:`<strong>projection_class_embeddings_input_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014; The dimension of the <code>class_labels</code> input when
<code>class_embed_type=&quot;projection&quot;</code>. Required when <code>class_embed_type=&quot;projection&quot;</code>.`,name:"projection_class_embeddings_input_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embeddings_concat",description:`<strong>class_embeddings_concat</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to concatenate the time
embeddings with the class embeddings.`,name:"class_embeddings_concat"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L148"}}),Ie=new A({props:{name:"forward",anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Union"},{name:"encoder_hidden_states",val:": Tensor"},{name:"class_labels",val:": Optional = None"},{name:"timestep_cond",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"encoder_hidden_states_1",val:": Optional = None"},{name:"encoder_attention_mask_1",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The noisy input tensor with the following shape <code>(batch, channel, height, width)</code>.`,name:"sample"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.timestep",description:"<strong>timestep</strong> (<code>torch.FloatTensor</code> or <code>float</code> or <code>int</code>) &#x2014; The number of timesteps to denoise an input.",name:"timestep"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder hidden states with shape <code>(batch, sequence_length, feature_dim)</code>.`,name:"encoder_hidden_states"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length)</code> is applied to <code>encoder_hidden_states</code>. If
<code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput">UNet2DConditionOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttnProcessor</code>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states_1",description:`<strong>encoder_hidden_states_1</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
A second set of encoder hidden states with shape <code>(batch, sequence_length_2, feature_dim_2)</code>. Can be
used to condition the model on a different set of embeddings to <code>encoder_hidden_states</code>.`,name:"encoder_hidden_states_1"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask_1",description:`<strong>encoder_attention_mask_1</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length_2)</code> is applied to <code>encoder_hidden_states_1</code>.
If <code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask_1"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L664",returnDescription:`
<p>If <code>return_dict</code> is True, an <a
  href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> is returned, otherwise
a <code>tuple</code> is returned where the first element is the sample tensor.</p>
`,returnType:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/models/unet2d-cond#diffusers.models.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> or <code>tuple</code></p>
`}}),qe=new U({}),Se=new A({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/pipeline_utils.py#L129"}}),{c(){u=n("meta"),k=i(),w=n("h1"),M=n("a"),D=n("span"),f(m.$$.fragment),C=i(),Ze=n("span"),Ze.textContent=Xo,Tt=i(),de=n("p"),de.innerHTML=zo,At=i(),le=n("p"),le.innerHTML=Ro,Ct=i(),ce=n("p"),ce.textContent=Vo,Lt=i(),pe=n("p"),pe.innerHTML=Yo,$t=i(),me=n("p"),me.innerHTML=Ko,jt=i(),N=n("h2"),F=n("a"),ht=n("span"),f(ue.$$.fragment),ho=i(),He=n("span"),He.textContent=en,Ut=i(),P=n("h3"),W=n("a"),gt=n("span"),f(fe.$$.fragment),go=i(),Fe=n("span"),Fe.textContent=tn,Nt=i(),he=n("p"),he.textContent=on,Pt=i(),ge=n("p"),ge.textContent=nn,Bt=i(),_e=n("table"),_e.innerHTML=sn,Jt=i(),B=n("h3"),O=n("a"),_t=n("span"),f(ve.$$.fragment),_o=i(),We=n("span"),We.textContent=an,Et=i(),be=n("ul"),be.innerHTML=rn,It=i(),J=n("h3"),Q=n("a"),vt=n("span"),f(Me.$$.fragment),vo=i(),Oe=n("span"),Oe.textContent=dn,qt=i(),we=n("ul"),we.innerHTML=ln,St=i(),E=n("h3"),X=n("a"),bt=n("span"),f(ye.$$.fragment),bo=i(),Qe=n("span"),Qe.textContent=cn,Gt=i(),xe=n("ul"),xe.innerHTML=pn,Zt=i(),De=n("p"),De.innerHTML=mn,Ht=i(),f(z.$$.fragment),Ft=i(),I=n("h2"),R=n("a"),Mt=n("span"),f(ke.$$.fragment),Mo=i(),Xe=n("span"),Xe.textContent=un,Wt=i(),y=n("div"),f(Te.$$.fragment),wo=i(),ze=n("p"),ze.textContent=fn,yo=i(),Re=n("p"),Re.innerHTML=hn,xo=i(),$=n("div"),f(Ae.$$.fragment),Do=i(),Ve=n("p"),Ve.textContent=gn,ko=i(),f(V.$$.fragment),To=i(),Y=n("div"),f(Ce.$$.fragment),Ao=i(),Ye=n("p"),Ye.innerHTML=_n,Co=i(),K=n("div"),f(Le.$$.fragment),Lo=i(),Ke=n("p"),Ke.innerHTML=vn,$o=i(),ee=n("div"),f($e.$$.fragment),jo=i(),et=n("p"),et.textContent=bn,Uo=i(),j=n("div"),f(je.$$.fragment),No=i(),tt=n("p"),tt.textContent=Mn,Po=i(),f(te.$$.fragment),Bo=i(),oe=n("div"),f(Ue.$$.fragment),Jo=i(),ot=n("p"),ot.textContent=wn,Ot=i(),q=n("h2"),ne=n("a"),wt=n("span"),f(Ne.$$.fragment),Eo=i(),nt=n("span"),nt.textContent=yn,Qt=i(),L=n("div"),f(Pe.$$.fragment),Io=i(),st=n("p"),st.innerHTML=xn,qo=i(),at=n("div"),f(Be.$$.fragment),Xt=i(),S=n("h2"),se=n("a"),yt=n("span"),f(Je.$$.fragment),So=i(),it=n("span"),it.textContent=Dn,zt=i(),T=n("div"),f(Ee.$$.fragment),Go=i(),rt=n("p"),rt.innerHTML=kn,Zo=i(),dt=n("p"),dt.innerHTML=Tn,Ho=i(),ae=n("div"),f(Ie.$$.fragment),Fo=i(),lt=n("p"),lt.innerHTML=An,Rt=i(),G=n("h2"),ie=n("a"),xt=n("span"),f(qe.$$.fragment),Wo=i(),ct=n("span"),ct.textContent=Cn,Vt=i(),Z=n("div"),f(Se.$$.fragment),Oo=i(),pt=n("p"),pt.textContent=Ln,this.h()},l(e){const a=ts("svelte-1phssyn",document.head);u=s(a,"META",{name:!0,content:!0}),a.forEach(t),k=r(e),w=s(e,"H1",{class:!0});var Ge=c(w);M=s(Ge,"A",{id:!0,class:!0,href:!0});var Dt=c(M);D=s(Dt,"SPAN",{});var kt=c(D);h(m.$$.fragment,kt),kt.forEach(t),Dt.forEach(t),C=r(Ge),Ze=s(Ge,"SPAN",{"data-svelte-h":!0}),p(Ze)!=="svelte-1eqn3og"&&(Ze.textContent=Xo),Ge.forEach(t),Tt=r(e),de=s(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-ta0apn"&&(de.innerHTML=zo),At=r(e),le=s(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-117z0zb"&&(le.innerHTML=Ro),Ct=r(e),ce=s(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-wu27l3"&&(ce.textContent=Vo),Lt=r(e),pe=s(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1ddltfs"&&(pe.innerHTML=Yo),$t=r(e),me=s(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-gffixp"&&(me.innerHTML=Ko),jt=r(e),N=s(e,"H2",{class:!0});var Kt=c(N);F=s(Kt,"A",{id:!0,class:!0,href:!0});var $n=c(F);ht=s($n,"SPAN",{});var jn=c(ht);h(ue.$$.fragment,jn),jn.forEach(t),$n.forEach(t),ho=r(Kt),He=s(Kt,"SPAN",{"data-svelte-h":!0}),p(He)!=="svelte-12o6a2j"&&(He.textContent=en),Kt.forEach(t),Ut=r(e),P=s(e,"H3",{class:!0});var eo=c(P);W=s(eo,"A",{id:!0,class:!0,href:!0});var Un=c(W);gt=s(Un,"SPAN",{});var Nn=c(gt);h(fe.$$.fragment,Nn),Nn.forEach(t),Un.forEach(t),go=r(eo),Fe=s(eo,"SPAN",{"data-svelte-h":!0}),p(Fe)!=="svelte-1ibj3em"&&(Fe.textContent=tn),eo.forEach(t),Nt=r(e),he=s(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1hmv6lf"&&(he.textContent=on),Pt=r(e),ge=s(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1hmqwck"&&(ge.textContent=nn),Bt=r(e),_e=s(e,"TABLE",{"data-svelte-h":!0}),p(_e)!=="svelte-qdkw13"&&(_e.innerHTML=sn),Jt=r(e),B=s(e,"H3",{class:!0});var to=c(B);O=s(to,"A",{id:!0,class:!0,href:!0});var Pn=c(O);_t=s(Pn,"SPAN",{});var Bn=c(_t);h(ve.$$.fragment,Bn),Bn.forEach(t),Pn.forEach(t),_o=r(to),We=s(to,"SPAN",{"data-svelte-h":!0}),p(We)!=="svelte-v7je0d"&&(We.textContent=an),to.forEach(t),Et=r(e),be=s(e,"UL",{"data-svelte-h":!0}),p(be)!=="svelte-1ry6k60"&&(be.innerHTML=rn),It=r(e),J=s(e,"H3",{class:!0});var oo=c(J);Q=s(oo,"A",{id:!0,class:!0,href:!0});var Jn=c(Q);vt=s(Jn,"SPAN",{});var En=c(vt);h(Me.$$.fragment,En),En.forEach(t),Jn.forEach(t),vo=r(oo),Oe=s(oo,"SPAN",{"data-svelte-h":!0}),p(Oe)!=="svelte-13kf8zd"&&(Oe.textContent=dn),oo.forEach(t),qt=r(e),we=s(e,"UL",{"data-svelte-h":!0}),p(we)!=="svelte-jm9a2k"&&(we.innerHTML=ln),St=r(e),E=s(e,"H3",{class:!0});var no=c(E);X=s(no,"A",{id:!0,class:!0,href:!0});var In=c(X);bt=s(In,"SPAN",{});var qn=c(bt);h(ye.$$.fragment,qn),qn.forEach(t),In.forEach(t),bo=r(no),Qe=s(no,"SPAN",{"data-svelte-h":!0}),p(Qe)!=="svelte-19whr5e"&&(Qe.textContent=cn),no.forEach(t),Gt=r(e),xe=s(e,"UL",{"data-svelte-h":!0}),p(xe)!=="svelte-9fhj5v"&&(xe.innerHTML=pn),Zt=r(e),De=s(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-18kt9eu"&&(De.innerHTML=mn),Ht=r(e),h(z.$$.fragment,e),Ft=r(e),I=s(e,"H2",{class:!0});var so=c(I);R=s(so,"A",{id:!0,class:!0,href:!0});var Sn=c(R);Mt=s(Sn,"SPAN",{});var Gn=c(Mt);h(ke.$$.fragment,Gn),Gn.forEach(t),Sn.forEach(t),Mo=r(so),Xe=s(so,"SPAN",{"data-svelte-h":!0}),p(Xe)!=="svelte-1lnhjw0"&&(Xe.textContent=un),so.forEach(t),Wt=r(e),y=s(e,"DIV",{class:!0});var x=c(y);h(Te.$$.fragment,x),wo=r(x),ze=s(x,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-m23e7a"&&(ze.textContent=fn),yo=r(x),Re=s(x,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-s6xyvg"&&(Re.innerHTML=hn),xo=r(x),$=s(x,"DIV",{class:!0});var mt=c($);h(Ae.$$.fragment,mt),Do=r(mt),Ve=s(mt,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-50j04k"&&(Ve.textContent=gn),ko=r(mt),h(V.$$.fragment,mt),mt.forEach(t),To=r(x),Y=s(x,"DIV",{class:!0});var ao=c(Y);h(Ce.$$.fragment,ao),Ao=r(ao),Ye=s(ao,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1s3c06i"&&(Ye.innerHTML=_n),ao.forEach(t),Co=r(x),K=s(x,"DIV",{class:!0});var io=c(K);h(Le.$$.fragment,io),Lo=r(io),Ke=s(io,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-d7vywi"&&(Ke.innerHTML=vn),io.forEach(t),$o=r(x),ee=s(x,"DIV",{class:!0});var ro=c(ee);h($e.$$.fragment,ro),jo=r(ro),et=s(ro,"P",{"data-svelte-h":!0}),p(et)!=="svelte-14bnrb6"&&(et.textContent=bn),ro.forEach(t),Uo=r(x),j=s(x,"DIV",{class:!0});var ut=c(j);h(je.$$.fragment,ut),No=r(ut),tt=s(ut,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-16q0ax1"&&(tt.textContent=Mn),Po=r(ut),h(te.$$.fragment,ut),ut.forEach(t),Bo=r(x),oe=s(x,"DIV",{class:!0});var lo=c(oe);h(Ue.$$.fragment,lo),Jo=r(lo),ot=s(lo,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1whwjf0"&&(ot.textContent=wn),lo.forEach(t),x.forEach(t),Ot=r(e),q=s(e,"H2",{class:!0});var co=c(q);ne=s(co,"A",{id:!0,class:!0,href:!0});var Zn=c(ne);wt=s(Zn,"SPAN",{});var Hn=c(wt);h(Ne.$$.fragment,Hn),Hn.forEach(t),Zn.forEach(t),Eo=r(co),nt=s(co,"SPAN",{"data-svelte-h":!0}),p(nt)!=="svelte-1126fye"&&(nt.textContent=yn),co.forEach(t),Qt=r(e),L=s(e,"DIV",{class:!0});var ft=c(L);h(Pe.$$.fragment,ft),Io=r(ft),st=s(ft,"P",{"data-svelte-h":!0}),p(st)!=="svelte-eyi7ar"&&(st.innerHTML=xn),qo=r(ft),at=s(ft,"DIV",{class:!0});var Fn=c(at);h(Be.$$.fragment,Fn),Fn.forEach(t),ft.forEach(t),Xt=r(e),S=s(e,"H2",{class:!0});var po=c(S);se=s(po,"A",{id:!0,class:!0,href:!0});var Wn=c(se);yt=s(Wn,"SPAN",{});var On=c(yt);h(Je.$$.fragment,On),On.forEach(t),Wn.forEach(t),So=r(po),it=s(po,"SPAN",{"data-svelte-h":!0}),p(it)!=="svelte-7mjnps"&&(it.textContent=Dn),po.forEach(t),zt=r(e),T=s(e,"DIV",{class:!0});var re=c(T);h(Ee.$$.fragment,re),Go=r(re),rt=s(re,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-16qjni5"&&(rt.innerHTML=kn),Zo=r(re),dt=s(re,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-zhna7y"&&(dt.innerHTML=Tn),Ho=r(re),ae=s(re,"DIV",{class:!0});var mo=c(ae);h(Ie.$$.fragment,mo),Fo=r(mo),lt=s(mo,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1kwlh99"&&(lt.innerHTML=An),mo.forEach(t),re.forEach(t),Rt=r(e),G=s(e,"H2",{class:!0});var uo=c(G);ie=s(uo,"A",{id:!0,class:!0,href:!0});var Qn=c(ie);xt=s(Qn,"SPAN",{});var Xn=c(xt);h(qe.$$.fragment,Xn),Xn.forEach(t),Qn.forEach(t),Wo=r(uo),ct=s(uo,"SPAN",{"data-svelte-h":!0}),p(ct)!=="svelte-14yt0be"&&(ct.textContent=Cn),uo.forEach(t),Vt=r(e),Z=s(e,"DIV",{class:!0});var fo=c(Z);h(Se.$$.fragment,fo),Oo=r(fo),pt=s(fo,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-19ryw33"&&(pt.textContent=Ln),fo.forEach(t),this.h()},h(){l(u,"name","hf:doc:metadata"),l(u,"content",JSON.stringify(rs)),l(M,"id","audioldm-2"),l(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(M,"href","#audioldm-2"),l(w,"class","relative group"),l(F,"id","tips"),l(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(F,"href","#tips"),l(N,"class","relative group"),l(W,"id","choosing-a-checkpoint"),l(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(W,"href","#choosing-a-checkpoint"),l(P,"class","relative group"),l(O,"id","constructing-a-prompt"),l(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(O,"href","#constructing-a-prompt"),l(B,"class","relative group"),l(Q,"id","controlling-inference"),l(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(Q,"href","#controlling-inference"),l(J,"class","relative group"),l(X,"id","evaluating-generated-waveforms"),l(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(X,"href","#evaluating-generated-waveforms"),l(E,"class","relative group"),l(R,"id","diffusers.AudioLDM2Pipeline"),l(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(R,"href","#diffusers.AudioLDM2Pipeline"),l(I,"class","relative group"),l($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ne,"id","diffusers.AudioLDM2ProjectionModel"),l(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ne,"href","#diffusers.AudioLDM2ProjectionModel"),l(q,"class","relative group"),l(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(se,"id","diffusers.AudioLDM2UNet2DConditionModel"),l(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(se,"href","#diffusers.AudioLDM2UNet2DConditionModel"),l(S,"class","relative group"),l(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),l(ie,"id","diffusers.AudioPipelineOutput"),l(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),l(ie,"href","#diffusers.AudioPipelineOutput"),l(G,"class","relative group"),l(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){o(document.head,u),d(e,k,a),d(e,w,a),o(w,M),o(M,D),g(m,D,null),o(w,C),o(w,Ze),d(e,Tt,a),d(e,de,a),d(e,At,a),d(e,le,a),d(e,Ct,a),d(e,ce,a),d(e,Lt,a),d(e,pe,a),d(e,$t,a),d(e,me,a),d(e,jt,a),d(e,N,a),o(N,F),o(F,ht),g(ue,ht,null),o(N,ho),o(N,He),d(e,Ut,a),d(e,P,a),o(P,W),o(W,gt),g(fe,gt,null),o(P,go),o(P,Fe),d(e,Nt,a),d(e,he,a),d(e,Pt,a),d(e,ge,a),d(e,Bt,a),d(e,_e,a),d(e,Jt,a),d(e,B,a),o(B,O),o(O,_t),g(ve,_t,null),o(B,_o),o(B,We),d(e,Et,a),d(e,be,a),d(e,It,a),d(e,J,a),o(J,Q),o(Q,vt),g(Me,vt,null),o(J,vo),o(J,Oe),d(e,qt,a),d(e,we,a),d(e,St,a),d(e,E,a),o(E,X),o(X,bt),g(ye,bt,null),o(E,bo),o(E,Qe),d(e,Gt,a),d(e,xe,a),d(e,Zt,a),d(e,De,a),d(e,Ht,a),g(z,e,a),d(e,Ft,a),d(e,I,a),o(I,R),o(R,Mt),g(ke,Mt,null),o(I,Mo),o(I,Xe),d(e,Wt,a),d(e,y,a),g(Te,y,null),o(y,wo),o(y,ze),o(y,yo),o(y,Re),o(y,xo),o(y,$),g(Ae,$,null),o($,Do),o($,Ve),o($,ko),g(V,$,null),o(y,To),o(y,Y),g(Ce,Y,null),o(Y,Ao),o(Y,Ye),o(y,Co),o(y,K),g(Le,K,null),o(K,Lo),o(K,Ke),o(y,$o),o(y,ee),g($e,ee,null),o(ee,jo),o(ee,et),o(y,Uo),o(y,j),g(je,j,null),o(j,No),o(j,tt),o(j,Po),g(te,j,null),o(y,Bo),o(y,oe),g(Ue,oe,null),o(oe,Jo),o(oe,ot),d(e,Ot,a),d(e,q,a),o(q,ne),o(ne,wt),g(Ne,wt,null),o(q,Eo),o(q,nt),d(e,Qt,a),d(e,L,a),g(Pe,L,null),o(L,Io),o(L,st),o(L,qo),o(L,at),g(Be,at,null),d(e,Xt,a),d(e,S,a),o(S,se),o(se,yt),g(Je,yt,null),o(S,So),o(S,it),d(e,zt,a),d(e,T,a),g(Ee,T,null),o(T,Go),o(T,rt),o(T,Zo),o(T,dt),o(T,Ho),o(T,ae),g(Ie,ae,null),o(ae,Fo),o(ae,lt),d(e,Rt,a),d(e,G,a),o(G,ie),o(ie,xt),g(qe,xt,null),o(G,Wo),o(G,ct),d(e,Vt,a),d(e,Z,a),g(Se,Z,null),o(Z,Oo),o(Z,pt),Yt=!0},p(e,[a]){const Ge={};a&2&&(Ge.$$scope={dirty:a,ctx:e}),z.$set(Ge);const Dt={};a&2&&(Dt.$$scope={dirty:a,ctx:e}),V.$set(Dt);const kt={};a&2&&(kt.$$scope={dirty:a,ctx:e}),te.$set(kt)},i(e){Yt||(_(m.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(ve.$$.fragment,e),_(Me.$$.fragment,e),_(ye.$$.fragment,e),_(z.$$.fragment,e),_(ke.$$.fragment,e),_(Te.$$.fragment,e),_(Ae.$$.fragment,e),_(V.$$.fragment,e),_(Ce.$$.fragment,e),_(Le.$$.fragment,e),_($e.$$.fragment,e),_(je.$$.fragment,e),_(te.$$.fragment,e),_(Ue.$$.fragment,e),_(Ne.$$.fragment,e),_(Pe.$$.fragment,e),_(Be.$$.fragment,e),_(Je.$$.fragment,e),_(Ee.$$.fragment,e),_(Ie.$$.fragment,e),_(qe.$$.fragment,e),_(Se.$$.fragment,e),Yt=!0)},o(e){v(m.$$.fragment,e),v(ue.$$.fragment,e),v(fe.$$.fragment,e),v(ve.$$.fragment,e),v(Me.$$.fragment,e),v(ye.$$.fragment,e),v(z.$$.fragment,e),v(ke.$$.fragment,e),v(Te.$$.fragment,e),v(Ae.$$.fragment,e),v(V.$$.fragment,e),v(Ce.$$.fragment,e),v(Le.$$.fragment,e),v($e.$$.fragment,e),v(je.$$.fragment,e),v(te.$$.fragment,e),v(Ue.$$.fragment,e),v(Ne.$$.fragment,e),v(Pe.$$.fragment,e),v(Be.$$.fragment,e),v(Je.$$.fragment,e),v(Ee.$$.fragment,e),v(Ie.$$.fragment,e),v(qe.$$.fragment,e),v(Se.$$.fragment,e),Yt=!1},d(e){e&&(t(k),t(w),t(Tt),t(de),t(At),t(le),t(Ct),t(ce),t(Lt),t(pe),t($t),t(me),t(jt),t(N),t(Ut),t(P),t(Nt),t(he),t(Pt),t(ge),t(Bt),t(_e),t(Jt),t(B),t(Et),t(be),t(It),t(J),t(qt),t(we),t(St),t(E),t(Gt),t(xe),t(Zt),t(De),t(Ht),t(Ft),t(I),t(Wt),t(y),t(Ot),t(q),t(Qt),t(L),t(Xt),t(S),t(zt),t(T),t(Rt),t(G),t(Vt),t(Z)),t(u),b(m),b(ue),b(fe),b(ve),b(Me),b(ye),b(z,e),b(ke),b(Te),b(Ae),b(V),b(Ce),b(Le),b($e),b(je),b(te),b(Ue),b(Ne),b(Pe),b(Be),b(Je),b(Ee),b(Ie),b(qe),b(Se)}}}const rs={local:"audioldm-2",sections:[{local:"tips",sections:[{local:"choosing-a-checkpoint",title:"Choosing a checkpoint"},{local:"constructing-a-prompt",title:"Constructing a prompt"},{local:"controlling-inference",title:"Controlling inference"},{local:"evaluating-generated-waveforms",title:"Evaluating generated waveforms:"}],title:"Tips"},{local:"diffusers.AudioLDM2Pipeline",title:"AudioLDM2Pipeline"},{local:"diffusers.AudioLDM2ProjectionModel",title:"AudioLDM2ProjectionModel"},{local:"diffusers.AudioLDM2UNet2DConditionModel",title:"AudioLDM2UNet2DConditionModel"},{local:"diffusers.AudioPipelineOutput",title:"AudioPipelineOutput"}],title:"AudioLDM 2"};function ds(H){return Yn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends Kn{constructor(u){super(),es(this,u,ds,is,Vn,{})}}export{gs as component};
