import{s as gs,z as hs,o as _s,n as io}from"../chunks/scheduler.182ea377.js";import{S as bs,i as ws,g as o,s as a,p as f,x as ms,A as vs,h as s,f as t,c as l,j as d,q as g,m as u,y as fs,k as c,v as n,a as i,r as _,d as b,t as w,u as v}from"../chunks/index.008d68e4.js";import{D as R}from"../chunks/Docstring.7aec8b85.js";import{C as Qe}from"../chunks/CodeBlock.5ed6eb7b.js";import{I as U}from"../chunks/IconCopyLink.96bbb92b.js";import{E as ro}from"../chunks/ExampleCodeBlock.23e54afe.js";function ys(Q){let h,P="Examples:",y,m,M;return m=new Qe({props:{code:"ZnJvbSUyMGRpZmZ1c2lvbnMlMjBpbXBvcnQlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBXdWVyc3RjaGVuQ29tYmluZWRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyd2FycC1haSUyRld1ZXJzdGNoZW4lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUwQSUyMCUyMCUyMCUyMCUyMmN1ZGElMjIlMEEpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYW4lMjBpbWFnZSUyMG9mJTIwYSUyMHNoaWJhJTIwaW51JTJDJTIwZG9ubmluZyUyMGElMjBzcGFjZXN1aXQlMjBhbmQlMjBoZWxtZXQlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKHByb21wdCUzRHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusions <span class="hljs-keyword">import</span> WuerstchenCombinedPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WuerstchenCombinedPipeline.from_pretrained(<span class="hljs-string">&quot;warp-ai/Wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt)`}}),{c(){h=o("p"),h.textContent=P,y=a(),f(m.$$.fragment)},l(p){h=s(p,"P",{"data-svelte-h":!0}),u(h)!=="svelte-kvfsh7"&&(h.textContent=P),y=l(p),g(m.$$.fragment,p)},m(p,W){i(p,h,W),i(p,y,W),_(m,p,W),M=!0},p:io,i(p){M||(b(m.$$.fragment,p),M=!0)},o(p){w(m.$$.fragment,p),M=!1},d(p){p&&(t(h),t(y)),v(m,p)}}}function Ms(Q){let h,P="Examples:",y,m,M;return m=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMEElMEFwcmlvcl9waXBlJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwaW1hZ2UlMjBvZiUyMGElMjBzaGliYSUyMGludSUyQyUyMGRvbm5pbmclMjBhJTIwc3BhY2VzdWl0JTIwYW5kJTIwaGVsbWV0JTIyJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcGlwZShwcm9tcHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)`}}),{c(){h=o("p"),h.textContent=P,y=a(),f(m.$$.fragment)},l(p){h=s(p,"P",{"data-svelte-h":!0}),u(h)!=="svelte-kvfsh7"&&(h.textContent=P),y=l(p),g(m.$$.fragment,p)},m(p,W){i(p,h,W),i(p,y,W),_(m,p,W),M=!0},p:io,i(p){M||(b(m.$$.fragment,p),M=!0)},o(p){w(m.$$.fragment,p),M=!1},d(p){p&&(t(h),t(y)),v(m,p)}}}function Ts(Q){let h,P="Examples:",y,m,M;return m=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUlMkMlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lJTBBJTBBcHJpb3JfcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFnZW5fcGlwZSUyMCUzRCUyMFd1ZXJzdGNoZW5EZWNvZGVyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbiglMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTBBJTIwJTIwJTIwJTIwJTIyY3VkYSUyMiUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhbiUyMGltYWdlJTIwb2YlMjBhJTIwc2hpYmElMjBpbnUlMkMlMjBkb25uaW5nJTIwYSUyMHNwYWNlc3VpdCUyMGFuZCUyMGhlbG1ldCUyMiUwQXByaW9yX291dHB1dCUyMCUzRCUyMHBpcGUocHJvbXB0KSUwQWltYWdlcyUyMCUzRCUyMGdlbl9waXBlKHByaW9yX291dHB1dC5pbWFnZV9lbWJlZGRpbmdzJTJDJTIwcHJvbXB0JTNEcHJvbXB0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenPriorPipeline, WuerstchenDecoderPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prior_pipe = WuerstchenPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_pipe = WuerstchenDecoderPipeline.from_pretrain(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;an image of a shiba inu, donning a spacesuit and helmet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prior_output = pipe(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>images = gen_pipe(prior_output.image_embeddings, prompt=prompt)`}}),{c(){h=o("p"),h.textContent=P,y=a(),f(m.$$.fragment)},l(p){h=s(p,"P",{"data-svelte-h":!0}),u(h)!=="svelte-kvfsh7"&&(h.textContent=P),y=l(p),g(m.$$.fragment,p)},m(p,W){i(p,h,W),i(p,y,W),_(m,p,W),M=!0},p:io,i(p){M||(b(m.$$.fragment,p),M=!0)},o(p){w(m.$$.fragment,p),M=!1},d(p){p&&(t(h),t(y)),v(m,p)}}}function xs(Q){let h,P,y,m,M,p,W,qe,ao="Würstchen",Gt,He,lo,Bt,ce,co='<a href="https://huggingface.co/papers/2306.00637" rel="nofollow">Wuerstchen: An Efficient Architecture for Large-Scale Text-to-Image Diffusion Models</a> is by Pablo Pernias, Dominic Rampas, Mats L. Richter and Christopher Pal and Marc Aubreville.',At,pe,po="The abstract from the paper is:",Et,de,uo="<em>We introduce Würstchen, a novel architecture for text-to-image synthesis that combines competitive performance with unprecedented cost-effectiveness for large-scale text-to-image diffusion models. A key contribution of our work is to develop a latent diffusion technique in which we learn a detailed but extremely compact semantic image representation used to guide the diffusion process. This highly compressed representation of an image provides much more detailed guidance compared to latent representations of language and this significantly reduces the computational requirements to achieve state-of-the-art results. Our approach also improves the quality of text-conditioned image generation based on our user preference study. The training requirements of our approach consists of 24,602 A100-GPU hours - compared to Stable Diffusion 2.1’s 200,000 GPU hours. Our approach also requires less training data to achieve these results. Furthermore, our compact latent representations allows us to perform inference over twice as fast, slashing the usual costs and carbon footprint of a state-of-the-art (SOTA) diffusion model significantly, without compromising the end performance. In a broader comparison against SOTA models our approach is substantially more efficient and compares favorably in terms of image quality. We believe that this work motivates more emphasis on the prioritization of both performance and computational accessibility.</em>",Zt,G,q,Mt,ue,Cn,Fe,ho="Würstchen Overview",Vt,B,H,Tt,he,Jn,Ye,mo="Würstchen v2 comes to Diffusers",Nt,me,fo="After the initial paper release, we have improved numerous things in the architecture, training and sampling, making Würstchen competitive to current state-of-the-art models in many ways. We are excited to release this new version together with Diffusers. Here is a list of the improvements.",Dt,fe,go="<li>Higher resolution (1024x1024 up to 2048x2048)</li> <li>Faster inference</li> <li>Multi Aspect Resolution Sampling</li> <li>Better quality</li>",St,ge,_o="We are releasing 3 checkpoints for the text-conditional image generation model (Stage C). Those are:",Xt,_e,bo="<li>v2-base</li> <li>v2-aesthetic</li> <li><strong>(default)</strong> v2-interpolated (50% interpolation between v2-base and v2-aesthetic)</li>",Lt,be,wo=`We recommend using v2-interpolated, as it has a nice touch of both photorealism and aesthetics. Use v2-base for finetunings as it does not have a style bias and use v2-aesthetic for very artistic generations.
A comparison can be seen here:`,Rt,we,vo,Qt,A,F,xt,ve,kn,ze,yo="Text-to-Image Generation",qt,ye,Mo="For the sake of usability, Würstchen can be used with a single pipeline. This pipeline can be used as follows:",Ht,Me,Ft,Te,To='For explanation purposes, we can also initialize the two main pipelines of Würstchen individually. Würstchen consists of 3 stages: Stage C, Stage B, Stage A. They all have different jobs and work only together. When generating text-conditional images, Stage C will first generate the latents in a very compressed latent space. This is what happens in the <code>prior_pipeline</code>. Afterwards, the generated latents will be passed to Stage B, which decompresses the latents into a bigger latent space of a VQGAN. These latents can then be decoded by Stage A, which is a VQGAN, into the pixel-space. Stage B &amp; Stage A are both encapsulated in the <code>decoder_pipeline</code>. For more details, take a look at the <a href="https://huggingface.co/papers/2306.00637" rel="nofollow">paper</a>.',Yt,xe,zt,E,Y,Wt,We,Un,Oe,xo="Speed-Up Inference",Ot,Pe,Kt,Z,z,Pt,Ce,jn,Ke,Wo="Limitations",en,Je,Po=`<li>Due to the high compression employed by Würstchen, generations can lack a good amount
of detail. To our human eye, this is especially noticeable in faces, hands etc.</li> <li><strong>Images can only be generated in 128-pixel steps</strong>, e.g. the next higher resolution
after 1024x1024 is 1152x1152</li> <li>The model lacks the ability to render correct text in images</li> <li>The model often does not achieve photorealism</li> <li>Difficult compositional prompts are hard for the model</li>`,tn,ke,Co='The original codebase, as well as experimental ideas, can be found at <a href="https://github.com/dome272/Wuerstchen" rel="nofollow">dome272/Wuerstchen</a>.',nn,V,O,Ct,Ue,$n,et,Jo="WuerstchenCombinedPipeline",on,T,je,In,tt,ko="Combined Pipeline for text-to-image generation using Wuerstchen",Gn,nt,Uo=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Bn,j,$e,An,ot,jo="Function invoked when calling the pipeline for generation.",En,K,Zn,ee,Ie,Vn,st,$o=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Nn,te,Ge,Dn,rt,Io=`Offloads all models (<code>unet</code>, <code>text_encoder</code>, <code>vae</code>, and <code>safety checker</code> state dicts) to CPU using 🤗
Accelerate, significantly reducing memory usage. Models are moved to a <code>torch.device(&#39;meta&#39;)</code> and loaded on a
GPU only when their specific submodule’s <code>forward</code> method is called. Offloading happens on a submodule basis.
Memory savings are higher than using <code>enable_model_cpu_offload</code>, but performance is lower.`,sn,N,ne,Jt,Be,Sn,it,Go="WuerstchenPriorPipeline",rn,x,Ae,Xn,at,Bo="Pipeline for generating image prior for Wuerstchen.",Ln,lt,Ao=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Rn,ct,Eo="The pipeline also inherits the following loading methods:",Qn,pt,Zo='<li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/v0.25.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li>',qn,$,Ee,Hn,dt,Vo="Function invoked when calling the pipeline for generation.",Fn,oe,an,D,se,kt,Ze,Yn,ut,No="WuerstchenPriorPipelineOutput",ln,S,Ve,zn,ht,Do="Output class for WuerstchenPriorPipeline.",cn,X,re,Ut,Ne,On,mt,So="WuerstchenDecoderPipeline",pn,C,De,Kn,ft,Xo="Pipeline for generating images from the Wuerstchen model.",eo,gt,Lo=`This model inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,to,I,Se,no,_t,Ro="Function invoked when calling the pipeline for generation.",oo,ie,dn,L,ae,jt,Xe,so,bt,Qo="Citation",un,Le,hn;return p=new U({}),ue=new U({}),he=new U({}),ve=new U({}),Me=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMucGlwZWxpbmVzLnd1ZXJzdGNoZW4lMjBpbXBvcnQlMjBERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQSUwQWNhcHRpb24lMjAlM0QlMjAlMjJBbnRocm9wb21vcnBoaWMlMjBjYXQlMjBkcmVzc2VkJTIwYXMlMjBhJTIwZmlyZSUyMGZpZ2h0ZXIlMjIlMEFpbWFnZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0QxNTM2JTJDJTBBJTIwJTIwJTIwJTIwcHJpb3JfdGltZXN0ZXBzJTNEREVGQVVMVF9TVEFHRV9DX1RJTUVTVEVQUyUyQyUwQSUyMCUyMCUyMCUyMHByaW9yX2d1aWRhbmNlX3NjYWxlJTNENC4wJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ltYWdlc19wZXJfcHJvbXB0JTNEMiUyQyUwQSkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

pipe = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
images = pipe(
    caption,
    width=<span class="hljs-number">1024</span>,
    height=<span class="hljs-number">1536</span>,
    prior_timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    prior_guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=<span class="hljs-number">2</span>,
).images`}}),xe=new Qe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV3VlcnN0Y2hlbkRlY29kZXJQaXBlbGluZSUyQyUyMFd1ZXJzdGNoZW5QcmlvclBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMud3VlcnN0Y2hlbiUyMGltcG9ydCUyMERFRkFVTFRfU1RBR0VfQ19USU1FU1RFUFMlMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5mbG9hdDE2JTBBbnVtX2ltYWdlc19wZXJfcHJvbXB0JTIwJTNEJTIwMiUwQSUwQXByaW9yX3BpcGVsaW5lJTIwJTNEJTIwV3VlcnN0Y2hlblByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMndhcnAtYWklMkZ3dWVyc3RjaGVuLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUwQSkudG8oZGV2aWNlKSUwQWRlY29kZXJfcGlwZWxpbmUlMjAlM0QlMjBXdWVyc3RjaGVuRGVjb2RlclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJ3YXJwLWFpJTJGd3VlcnN0Y2hlbiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMEEpLnRvKGRldmljZSklMEElMEFjYXB0aW9uJTIwJTNEJTIwJTIyQW50aHJvcG9tb3JwaGljJTIwY2F0JTIwZHJlc3NlZCUyMGFzJTIwYSUyMGZpcmUlMjBmaWdodGVyJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTBBJTBBcHJpb3Jfb3V0cHV0JTIwJTNEJTIwcHJpb3JfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEY2FwdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDE1MzYlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlM0RERUZBVUxUX1NUQUdFX0NfVElNRVNURVBTJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzX3Blcl9wcm9tcHQlMkMlMEEpJTBBZGVjb2Rlcl9vdXRwdXQlMjAlM0QlMjBkZWNvZGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkZGluZ3MlM0Rwcmlvcl9vdXRwdXQuaW1hZ2VfZW1iZWRkaW5ncyUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRGNhcHRpb24lMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUwQSUyMCUyMCUyMCUyMG91dHB1dF90eXBlJTNEJTIycGlsJTIyJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZGVjb2Rlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WuerstchenDecoderPipeline, WuerstchenPriorPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.wuerstchen <span class="hljs-keyword">import</span> DEFAULT_STAGE_C_TIMESTEPS

device = <span class="hljs-string">&quot;cuda&quot;</span>
dtype = torch.float16
num_images_per_prompt = <span class="hljs-number">2</span>

prior_pipeline = WuerstchenPriorPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen-prior&quot;</span>, torch_dtype=dtype
).to(device)
decoder_pipeline = WuerstchenDecoderPipeline.from_pretrained(
    <span class="hljs-string">&quot;warp-ai/wuerstchen&quot;</span>, torch_dtype=dtype
).to(device)

caption = <span class="hljs-string">&quot;Anthropomorphic cat dressed as a fire fighter&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;</span>

prior_output = prior_pipeline(
    prompt=caption,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1536</span>,
    timesteps=DEFAULT_STAGE_C_TIMESTEPS,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">4.0</span>,
    num_images_per_prompt=num_images_per_prompt,
)
decoder_output = decoder_pipeline(
    image_embeddings=prior_output.image_embeddings,
    prompt=caption,
    negative_prompt=negative_prompt,
    guidance_scale=<span class="hljs-number">0.0</span>,
    output_type=<span class="hljs-string">&quot;pil&quot;</span>,
).images[<span class="hljs-number">0</span>]
decoder_output`}}),We=new U({}),Pe=new Qe({props:{code:"cHJpb3JfcGlwZWxpbmUucHJpb3IlMjAlM0QlMjB0b3JjaC5jb21waWxlKHByaW9yX3BpcGVsaW5lLnByaW9yJTJDJTIwbW9kZSUzRCUyMnJlZHVjZS1vdmVyaGVhZCUyMiUyQyUyMGZ1bGxncmFwaCUzRFRydWUpJTBBZGVjb2Rlcl9waXBlbGluZS5kZWNvZGVyJTIwJTNEJTIwdG9yY2guY29tcGlsZShkZWNvZGVyX3BpcGVsaW5lLmRlY29kZXIlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:`prior_pipeline.prior = torch.<span class="hljs-built_in">compile</span>(prior_pipeline.prior, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
decoder_pipeline.decoder = torch.<span class="hljs-built_in">compile</span>(decoder_pipeline.decoder, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`}}),Ce=new U({}),Ue=new U({}),je=new R({props:{name:"class diffusers.WuerstchenCombinedPipeline",anchor:"diffusers.WuerstchenCombinedPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_text_encoder",val:": CLIPTextModel"},{name:"prior_prior",val:": WuerstchenPrior"},{name:"prior_scheduler",val:": DDPMWuerstchenScheduler"}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The decoder tokenizer to be used for text inputs.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The decoder text encoder to be used for text inputs.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The decoder model to be used for decoder image generation pipeline.`,name:"decoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for decoder image generation pipeline.`,name:"scheduler"},{anchor:"diffusers.WuerstchenCombinedPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model to be used for decoder image generation pipeline.`,name:"vqgan"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The prior tokenizer to be used for text inputs.`,name:"prior_tokenizer"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The prior text encoder to be used for text inputs.`,name:"prior_text_encoder"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<code>WuerstchenPrior</code>) &#x2014;
The prior model to be used for prior pipeline.`,name:"prior_prior"},{anchor:"diffusers.WuerstchenCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
The scheduler to be used for prior pipeline.`,name:"prior_scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L43"}}),$e=new R({props:{name:"__call__",anchor:"diffusers.WuerstchenCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_num_inference_steps",val:": int = 60"},{name:"prior_timesteps",val:": Optional = None"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"num_inference_steps",val:": int = 12"},{name:"decoder_timesteps",val:": Optional = None"},{name:"decoder_guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation for the prior and decoder.`,name:"prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings for the prior. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>prior_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>prior_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked
to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>Union[int, Dict[float, int]]</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of prior denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. For more specific timestep spacing, you can pass customized
<code>prior_timesteps</code>`,name:"prior_num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of decoder denoising steps. More denoising steps usually lead to a higher quality image at
the expense of slower inference. For more specific timestep spacing, you can pass customized
<code>timesteps</code>`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_timesteps",description:`<strong>prior_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the prior. If not defined, equal spaced
<code>prior_num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"prior_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_timesteps",description:`<strong>decoder_timesteps</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process for the decoder. If not defined, equal spaced
<code>num_inference_steps</code> timesteps are used. Must be in descending order.`,name:"decoder_timesteps"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.decoder_guidance_scale",description:`<strong>decoder_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"decoder_guidance_scale"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L143",returnDescription:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`}}),K=new ro({props:{anchor:"diffusers.WuerstchenCombinedPipeline.__call__.example",$$slots:{default:[ys]},$$scope:{ctx:Q}}}),Ie=new R({props:{name:"enable_model_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L115"}}),Ge=new R({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.WuerstchenCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_combined.py#L125"}}),Be=new U({}),Ae=new R({props:{name:"class diffusers.WuerstchenPriorPipeline",anchor:"diffusers.WuerstchenPriorPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"prior",val:": WuerstchenPrior"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"latent_mean",val:": float = 42.0"},{name:"latent_std",val:": float = 1.0"},{name:"resolution_multiple",val:": float = 42.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.prior",description:`<strong>prior</strong> (<code>Prior</code>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.WuerstchenPriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenPriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenPriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_mean",description:`<strong>latent_mean</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.0) &#x2014;
Mean value for latent diffusers.`,name:"latent_mean"},{anchor:"diffusers.WuerstchenPriorPipeline.latent_std",description:`<strong>latent_std</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 1.0) &#x2014;
Standard value for latent diffusers.`,name:"latent_std"},{anchor:"diffusers.WuerstchenPriorPipeline.resolution_multiple",description:`<strong>resolution_multiple</strong> (&#x2018;float&#x2019;, <em>optional</em>, defaults to 42.67) &#x2014;
Default resolution for multiple images generated.`,name:"resolution_multiple"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L65"}}),Ee=new R({props:{name:"__call__",anchor:"diffusers.WuerstchenPriorPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"height",val:": int = 1024"},{name:"width",val:": int = 1024"},{name:"num_inference_steps",val:": int = 60"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": float = 8.0"},{name:"negative_prompt",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 60) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 8.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenPriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L280",returnDescription:`
<p><code>~pipelines.WuerstchenPriorPipelineOutput</code> or <code>tuple</code> <code>~pipelines.WuerstchenPriorPipelineOutput</code> if
<code>return_dict</code> is True, otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the
generated image embeddings.</p>
`}}),oe=new ro({props:{anchor:"diffusers.WuerstchenPriorPipeline.__call__.example",$$slots:{default:[Ms]},$$scope:{ctx:Q}}}),Ze=new U({}),Ve=new R({props:{name:"class diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",parameters:[{name:"image_embeddings",val:": Union"}],parametersDescription:[{anchor:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput.image_embeddings",description:`<strong>image_embeddings</strong> (<code>torch.FloatTensor</code> or <code>np.ndarray</code>) &#x2014;
Prior image embeddings for text prompt`,name:"image_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen_prior.py#L51"}}),Ne=new U({}),De=new R({props:{name:"class diffusers.WuerstchenDecoderPipeline",anchor:"diffusers.WuerstchenDecoderPipeline",parameters:[{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder",val:": CLIPTextModel"},{name:"decoder",val:": WuerstchenDiffNeXt"},{name:"scheduler",val:": DDPMWuerstchenScheduler"},{name:"vqgan",val:": PaellaVQModel"},{name:"latent_dim_scale",val:": float = 10.67"}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
The CLIP tokenizer.`,name:"tokenizer"},{anchor:"diffusers.WuerstchenDecoderPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
The CLIP text encoder.`,name:"text_encoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.decoder",description:`<strong>decoder</strong> (<code>WuerstchenDiffNeXt</code>) &#x2014;
The WuerstchenDiffNeXt unet decoder.`,name:"decoder"},{anchor:"diffusers.WuerstchenDecoderPipeline.vqgan",description:`<strong>vqgan</strong> (<code>PaellaVQModel</code>) &#x2014;
The VQGAN model.`,name:"vqgan"},{anchor:"diffusers.WuerstchenDecoderPipeline.scheduler",description:`<strong>scheduler</strong> (<code>DDPMWuerstchenScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.WuerstchenDecoderPipeline.latent_dim_scale",description:`<strong>latent_dim_scale</strong> (float, <code>optional</code>, defaults to 10.67) &#x2014;
Multiplier to determine the VQ latent space size from the image embeddings. If the image embeddings are
height=24 and width=24, the VQ latent shape needs to be height=int(24<em>10.67)=256 and
width=int(24</em>10.67)=256 in order to match the training conditions.`,name:"latent_dim_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L51"}}),Se=new R({props:{name:"__call__",anchor:"diffusers.WuerstchenDecoderPipeline.__call__",parameters:[{name:"image_embeddings",val:": Union"},{name:"prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 12"},{name:"timesteps",val:": Optional = None"},{name:"guidance_scale",val:": float = 0.0"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.image_embedding",description:`<strong>image_embedding</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
Image Embeddings either extracted from an image or generated by a Prior Model.`,name:"image_embedding"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process. If not defined, equal spaced <code>num_inference_steps</code>
timesteps are used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>decoder_guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting
<code>decoder_guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely
linked to the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>decoder_guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.25.0/src/diffusers/pipelines/wuerstchen/pipeline_wuerstchen.py#L208",returnDescription:`
<p><a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code> <a
  href="/docs/diffusers/v0.25.0/en/api/pipelines/consistency_models#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> if <code>return_dict</code> is True,
otherwise a <code>tuple</code>. When returning a tuple, the first element is a list with the generated image
embeddings.</p>
`}}),ie=new ro({props:{anchor:"diffusers.WuerstchenDecoderPipeline.__call__.example",$$slots:{default:[Ts]},$$scope:{ctx:Q}}}),Xe=new U({}),Le=new Qe({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTQwbWlzYyU3QnBlcm5pYXMyMDIzd3VlcnN0Y2hlbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCV3VlcnN0Y2hlbiUzQSUyMEFuJTIwRWZmaWNpZW50JTIwQXJjaGl0ZWN0dXJlJTIwZm9yJTIwTGFyZ2UtU2NhbGUlMjBUZXh0LXRvLUltYWdlJTIwRGlmZnVzaW9uJTIwTW9kZWxzJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCUGFibG8lMjBQZXJuaWFzJTIwYW5kJTIwRG9taW5pYyUyMFJhbXBhcyUyMGFuZCUyME1hdHMlMjBMLiUyMFJpY2h0ZXIlMjBhbmQlMjBDaHJpc3RvcGhlciUyMEouJTIwUGFsJTIwYW5kJTIwTWFyYyUyMEF1YnJldmlsbGUlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5ZWFyJTNEJTdCMjAyMyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVwcmludCUzRCU3QjIzMDYuMDA2MzclN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmNoaXZlUHJlZml4JTNEJTdCYXJYaXYlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmltYXJ5Q2xhc3MlM0QlN0Jjcy5DViU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RA==",highlighted:`      @misc{pernias2023wuerstchen,
            title={Wuerstchen: An Efficient Architecture for Large-<span class="hljs-keyword">Scale </span>Text-to-Image <span class="hljs-keyword">Diffusion </span>Models},
            author={Pablo Pernias <span class="hljs-keyword">and </span>Dominic Rampas <span class="hljs-keyword">and </span>Mats L. Richter <span class="hljs-keyword">and </span>Christopher <span class="hljs-keyword">J. </span>Pal <span class="hljs-keyword">and </span>Marc Aubreville},
            year={<span class="hljs-number">2023</span>},
            eprint={<span class="hljs-number">2306</span>.<span class="hljs-number">00637</span>},
            archivePrefix={arXiv},
            primaryClass={cs.CV}
      }`}}),{c(){h=o("meta"),P=a(),y=o("h1"),m=o("a"),M=o("span"),f(p.$$.fragment),W=a(),qe=o("span"),qe.textContent=ao,Gt=a(),He=o("img"),Bt=a(),ce=o("p"),ce.innerHTML=co,At=a(),pe=o("p"),pe.textContent=po,Et=a(),de=o("p"),de.innerHTML=uo,Zt=a(),G=o("h2"),q=o("a"),Mt=o("span"),f(ue.$$.fragment),Cn=a(),Fe=o("span"),Fe.textContent=ho,Vt=ms(`

Würstchen is a diffusion model, whose text-conditional model works in a highly compressed latent space of images. Why is this important? Compressing data can reduce computational costs for both training and inference by magnitudes. Training on 1024x1024 images is way more expensive than training on 32x32. Usually, other works make use of a relatively small compression, in the range of 4x - 8x spatial compression. Würstchen takes this to an extreme. Through its novel design, we achieve a 42x spatial compression. This was unseen before because common methods fail to faithfully reconstruct detailed images after 16x spatial compression. Würstchen employs a two-stage compression, what we call Stage A and Stage B. Stage A is a VQGAN, and Stage B is a Diffusion Autoencoder (more details can be found in the [paper](https://huggingface.co/papers/2306.00637)). A third model, Stage C, is learned in that highly compressed latent space. This training requires fractions of the compute used for current top-performing models, while also allowing cheaper and faster inference.
`),B=o("h2"),H=o("a"),Tt=o("span"),f(he.$$.fragment),Jn=a(),Ye=o("span"),Ye.textContent=mo,Nt=a(),me=o("p"),me.textContent=fo,Dt=a(),fe=o("ul"),fe.innerHTML=go,St=a(),ge=o("p"),ge.textContent=_o,Xt=a(),_e=o("ul"),_e.innerHTML=bo,Lt=a(),be=o("p"),be.textContent=wo,Rt=a(),we=o("img"),Qt=a(),A=o("h2"),F=o("a"),xt=o("span"),f(ve.$$.fragment),kn=a(),ze=o("span"),ze.textContent=yo,qt=a(),ye=o("p"),ye.textContent=Mo,Ht=a(),f(Me.$$.fragment),Ft=a(),Te=o("p"),Te.innerHTML=To,Yt=a(),f(xe.$$.fragment),zt=a(),E=o("h2"),Y=o("a"),Wt=o("span"),f(We.$$.fragment),Un=a(),Oe=o("span"),Oe.textContent=xo,Ot=ms(`

You can make use of \`torch.compile\` function and gain a speed-up of about 2-3x:

	`),f(Pe.$$.fragment),Kt=a(),Z=o("h2"),z=o("a"),Pt=o("span"),f(Ce.$$.fragment),jn=a(),Ke=o("span"),Ke.textContent=Wo,en=a(),Je=o("ul"),Je.innerHTML=Po,tn=a(),ke=o("p"),ke.innerHTML=Co,nn=a(),V=o("h2"),O=o("a"),Ct=o("span"),f(Ue.$$.fragment),$n=a(),et=o("span"),et.textContent=Jo,on=a(),T=o("div"),f(je.$$.fragment),In=a(),tt=o("p"),tt.textContent=ko,Gn=a(),nt=o("p"),nt.innerHTML=Uo,Bn=a(),j=o("div"),f($e.$$.fragment),An=a(),ot=o("p"),ot.textContent=jo,En=a(),f(K.$$.fragment),Zn=a(),ee=o("div"),f(Ie.$$.fragment),Vn=a(),st=o("p"),st.innerHTML=$o,Nn=a(),te=o("div"),f(Ge.$$.fragment),Dn=a(),rt=o("p"),rt.innerHTML=Io,sn=a(),N=o("h2"),ne=o("a"),Jt=o("span"),f(Be.$$.fragment),Sn=a(),it=o("span"),it.textContent=Go,rn=a(),x=o("div"),f(Ae.$$.fragment),Xn=a(),at=o("p"),at.textContent=Bo,Ln=a(),lt=o("p"),lt.innerHTML=Ao,Rn=a(),ct=o("p"),ct.textContent=Eo,Qn=a(),pt=o("ul"),pt.innerHTML=Zo,qn=a(),$=o("div"),f(Ee.$$.fragment),Hn=a(),dt=o("p"),dt.textContent=Vo,Fn=a(),f(oe.$$.fragment),an=a(),D=o("h2"),se=o("a"),kt=o("span"),f(Ze.$$.fragment),Yn=a(),ut=o("span"),ut.textContent=No,ln=a(),S=o("div"),f(Ve.$$.fragment),zn=a(),ht=o("p"),ht.textContent=Do,cn=a(),X=o("h2"),re=o("a"),Ut=o("span"),f(Ne.$$.fragment),On=a(),mt=o("span"),mt.textContent=So,pn=a(),C=o("div"),f(De.$$.fragment),Kn=a(),ft=o("p"),ft.textContent=Xo,eo=a(),gt=o("p"),gt.innerHTML=Lo,to=a(),I=o("div"),f(Se.$$.fragment),no=a(),_t=o("p"),_t.textContent=Ro,oo=a(),f(ie.$$.fragment),dn=a(),L=o("h2"),ae=o("a"),jt=o("span"),f(Xe.$$.fragment),so=a(),bt=o("span"),bt.textContent=Qo,un=a(),f(Le.$$.fragment),this.h()},l(e){const r=vs("svelte-1phssyn",document.head);h=s(r,"META",{name:!0,content:!0}),r.forEach(t),P=l(e),y=s(e,"H1",{class:!0});var Re=d(y);m=s(Re,"A",{id:!0,class:!0,href:!0});var $t=d(m);M=s($t,"SPAN",{});var It=d(M);g(p.$$.fragment,It),It.forEach(t),$t.forEach(t),W=l(Re),qe=s(Re,"SPAN",{"data-svelte-h":!0}),u(qe)!=="svelte-gfbzmv"&&(qe.textContent=ao),Re.forEach(t),Gt=l(e),He=s(e,"IMG",{src:!0}),Bt=l(e),ce=s(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-hm8v9i"&&(ce.innerHTML=co),At=l(e),pe=s(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-1cwsb16"&&(pe.textContent=po),Et=l(e),de=s(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-10ea9cr"&&(de.innerHTML=uo),Zt=l(e),G=s(e,"H2",{class:!0});var mn=d(G);q=s(mn,"A",{id:!0,class:!0,href:!0});var qo=d(q);Mt=s(qo,"SPAN",{});var Ho=d(Mt);g(ue.$$.fragment,Ho),Ho.forEach(t),qo.forEach(t),Cn=l(mn),Fe=s(mn,"SPAN",{"data-svelte-h":!0}),u(Fe)!=="svelte-rc9yss"&&(Fe.textContent=ho),mn.forEach(t),Vt=fs(e,`

Würstchen is a diffusion model, whose text-conditional model works in a highly compressed latent space of images. Why is this important? Compressing data can reduce computational costs for both training and inference by magnitudes. Training on 1024x1024 images is way more expensive than training on 32x32. Usually, other works make use of a relatively small compression, in the range of 4x - 8x spatial compression. Würstchen takes this to an extreme. Through its novel design, we achieve a 42x spatial compression. This was unseen before because common methods fail to faithfully reconstruct detailed images after 16x spatial compression. Würstchen employs a two-stage compression, what we call Stage A and Stage B. Stage A is a VQGAN, and Stage B is a Diffusion Autoencoder (more details can be found in the [paper](https://huggingface.co/papers/2306.00637)). A third model, Stage C, is learned in that highly compressed latent space. This training requires fractions of the compute used for current top-performing models, while also allowing cheaper and faster inference.
`),B=s(e,"H2",{class:!0});var fn=d(B);H=s(fn,"A",{id:!0,class:!0,href:!0});var Fo=d(H);Tt=s(Fo,"SPAN",{});var Yo=d(Tt);g(he.$$.fragment,Yo),Yo.forEach(t),Fo.forEach(t),Jn=l(fn),Ye=s(fn,"SPAN",{"data-svelte-h":!0}),u(Ye)!=="svelte-ja8yac"&&(Ye.textContent=mo),fn.forEach(t),Nt=l(e),me=s(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-idonvk"&&(me.textContent=fo),Dt=l(e),fe=s(e,"UL",{"data-svelte-h":!0}),u(fe)!=="svelte-hwtnnt"&&(fe.innerHTML=go),St=l(e),ge=s(e,"P",{"data-svelte-h":!0}),u(ge)!=="svelte-bpk4lp"&&(ge.textContent=_o),Xt=l(e),_e=s(e,"UL",{"data-svelte-h":!0}),u(_e)!=="svelte-holqkq"&&(_e.innerHTML=bo),Lt=l(e),be=s(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-izmk3f"&&(be.textContent=wo),Rt=l(e),we=s(e,"IMG",{src:!0,width:!0}),Qt=l(e),A=s(e,"H2",{class:!0});var gn=d(A);F=s(gn,"A",{id:!0,class:!0,href:!0});var zo=d(F);xt=s(zo,"SPAN",{});var Oo=d(xt);g(ve.$$.fragment,Oo),Oo.forEach(t),zo.forEach(t),kn=l(gn),ze=s(gn,"SPAN",{"data-svelte-h":!0}),u(ze)!=="svelte-18cls7s"&&(ze.textContent=yo),gn.forEach(t),qt=l(e),ye=s(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-q6mitm"&&(ye.textContent=Mo),Ht=l(e),g(Me.$$.fragment,e),Ft=l(e),Te=s(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-16aw41o"&&(Te.innerHTML=To),Yt=l(e),g(xe.$$.fragment,e),zt=l(e),E=s(e,"H2",{class:!0});var _n=d(E);Y=s(_n,"A",{id:!0,class:!0,href:!0});var Ko=d(Y);Wt=s(Ko,"SPAN",{});var es=d(Wt);g(We.$$.fragment,es),es.forEach(t),Ko.forEach(t),Un=l(_n),Oe=s(_n,"SPAN",{"data-svelte-h":!0}),u(Oe)!=="svelte-1b4d8bd"&&(Oe.textContent=xo),_n.forEach(t),Ot=fs(e,`

You can make use of \`torch.compile\` function and gain a speed-up of about 2-3x:

	`),g(Pe.$$.fragment,e),Kt=l(e),Z=s(e,"H2",{class:!0});var bn=d(Z);z=s(bn,"A",{id:!0,class:!0,href:!0});var ts=d(z);Pt=s(ts,"SPAN",{});var ns=d(Pt);g(Ce.$$.fragment,ns),ns.forEach(t),ts.forEach(t),jn=l(bn),Ke=s(bn,"SPAN",{"data-svelte-h":!0}),u(Ke)!=="svelte-z4yr6i"&&(Ke.textContent=Wo),bn.forEach(t),en=l(e),Je=s(e,"UL",{"data-svelte-h":!0}),u(Je)!=="svelte-157ejdo"&&(Je.innerHTML=Po),tn=l(e),ke=s(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-1674xah"&&(ke.innerHTML=Co),nn=l(e),V=s(e,"H2",{class:!0});var wn=d(V);O=s(wn,"A",{id:!0,class:!0,href:!0});var os=d(O);Ct=s(os,"SPAN",{});var ss=d(Ct);g(Ue.$$.fragment,ss),ss.forEach(t),os.forEach(t),$n=l(wn),et=s(wn,"SPAN",{"data-svelte-h":!0}),u(et)!=="svelte-1vzf2zu"&&(et.textContent=Jo),wn.forEach(t),on=l(e),T=s(e,"DIV",{class:!0});var J=d(T);g(je.$$.fragment,J),In=l(J),tt=s(J,"P",{"data-svelte-h":!0}),u(tt)!=="svelte-19cx0lp"&&(tt.textContent=ko),Gn=l(J),nt=s(J,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1bjwwin"&&(nt.innerHTML=Uo),Bn=l(J),j=s(J,"DIV",{class:!0});var wt=d(j);g($e.$$.fragment,wt),An=l(wt),ot=s(wt,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-v78lg8"&&(ot.textContent=jo),En=l(wt),g(K.$$.fragment,wt),wt.forEach(t),Zn=l(J),ee=s(J,"DIV",{class:!0});var vn=d(ee);g(Ie.$$.fragment,vn),Vn=l(vn),st=s(vn,"P",{"data-svelte-h":!0}),u(st)!=="svelte-d7vywi"&&(st.innerHTML=$o),vn.forEach(t),Nn=l(J),te=s(J,"DIV",{class:!0});var yn=d(te);g(Ge.$$.fragment,yn),Dn=l(yn),rt=s(yn,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-a2a0wt"&&(rt.innerHTML=Io),yn.forEach(t),J.forEach(t),sn=l(e),N=s(e,"H2",{class:!0});var Mn=d(N);ne=s(Mn,"A",{id:!0,class:!0,href:!0});var rs=d(ne);Jt=s(rs,"SPAN",{});var is=d(Jt);g(Be.$$.fragment,is),is.forEach(t),rs.forEach(t),Sn=l(Mn),it=s(Mn,"SPAN",{"data-svelte-h":!0}),u(it)!=="svelte-ix21y1"&&(it.textContent=Go),Mn.forEach(t),rn=l(e),x=s(e,"DIV",{class:!0});var k=d(x);g(Ae.$$.fragment,k),Xn=l(k),at=s(k,"P",{"data-svelte-h":!0}),u(at)!=="svelte-1atgjon"&&(at.textContent=Bo),Ln=l(k),lt=s(k,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-1bjwwin"&&(lt.innerHTML=Ao),Rn=l(k),ct=s(k,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-14s6m4u"&&(ct.textContent=Eo),Qn=l(k),pt=s(k,"UL",{"data-svelte-h":!0}),u(pt)!=="svelte-1yl0npm"&&(pt.innerHTML=Zo),qn=l(k),$=s(k,"DIV",{class:!0});var vt=d($);g(Ee.$$.fragment,vt),Hn=l(vt),dt=s(vt,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-v78lg8"&&(dt.textContent=Vo),Fn=l(vt),g(oe.$$.fragment,vt),vt.forEach(t),k.forEach(t),an=l(e),D=s(e,"H2",{class:!0});var Tn=d(D);se=s(Tn,"A",{id:!0,class:!0,href:!0});var as=d(se);kt=s(as,"SPAN",{});var ls=d(kt);g(Ze.$$.fragment,ls),ls.forEach(t),as.forEach(t),Yn=l(Tn),ut=s(Tn,"SPAN",{"data-svelte-h":!0}),u(ut)!=="svelte-1hiqj24"&&(ut.textContent=No),Tn.forEach(t),ln=l(e),S=s(e,"DIV",{class:!0});var xn=d(S);g(Ve.$$.fragment,xn),zn=l(xn),ht=s(xn,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-cw9h8a"&&(ht.textContent=Do),xn.forEach(t),cn=l(e),X=s(e,"H2",{class:!0});var Wn=d(X);re=s(Wn,"A",{id:!0,class:!0,href:!0});var cs=d(re);Ut=s(cs,"SPAN",{});var ps=d(Ut);g(Ne.$$.fragment,ps),ps.forEach(t),cs.forEach(t),On=l(Wn),mt=s(Wn,"SPAN",{"data-svelte-h":!0}),u(mt)!=="svelte-17g1lcp"&&(mt.textContent=So),Wn.forEach(t),pn=l(e),C=s(e,"DIV",{class:!0});var le=d(C);g(De.$$.fragment,le),Kn=l(le),ft=s(le,"P",{"data-svelte-h":!0}),u(ft)!=="svelte-iulkbf"&&(ft.textContent=Xo),eo=l(le),gt=s(le,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-1bjwwin"&&(gt.innerHTML=Lo),to=l(le),I=s(le,"DIV",{class:!0});var yt=d(I);g(Se.$$.fragment,yt),no=l(yt),_t=s(yt,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-v78lg8"&&(_t.textContent=Ro),oo=l(yt),g(ie.$$.fragment,yt),yt.forEach(t),le.forEach(t),dn=l(e),L=s(e,"H2",{class:!0});var Pn=d(L);ae=s(Pn,"A",{id:!0,class:!0,href:!0});var ds=d(ae);jt=s(ds,"SPAN",{});var us=d(jt);g(Xe.$$.fragment,us),us.forEach(t),ds.forEach(t),so=l(Pn),bt=s(Pn,"SPAN",{"data-svelte-h":!0}),u(bt)!=="svelte-15mb3gy"&&(bt.textContent=Qo),Pn.forEach(t),un=l(e),g(Le.$$.fragment,e),this.h()},h(){c(h,"name","hf:doc:metadata"),c(h,"content",JSON.stringify(Ws)),c(m,"id","wrstchen"),c(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(m,"href","#wrstchen"),c(y,"class","relative group"),hs(He.src,lo="https://github.com/dome272/Wuerstchen/assets/61938694/0617c863-165a-43ee-9303-2a17299a0cf9")||c(He,"src",lo),c(q,"id","wrstchen-overview"),c(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(q,"href","#wrstchen-overview"),c(G,"class","relative group"),c(H,"id","wrstchen-v2-comes-to-diffusers"),c(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(H,"href","#wrstchen-v2-comes-to-diffusers"),c(B,"class","relative group"),hs(we.src,vo="https://github.com/dome272/Wuerstchen/assets/61938694/2914830f-cbd3-461c-be64-d50734f4b49d")||c(we,"src",vo),c(we,"width","500"),c(F,"id","texttoimage-generation"),c(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(F,"href","#texttoimage-generation"),c(A,"class","relative group"),c(Y,"id","speedup-inference"),c(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Y,"href","#speedup-inference"),c(E,"class","relative group"),c(z,"id","limitations"),c(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(z,"href","#limitations"),c(Z,"class","relative group"),c(O,"id","diffusers.WuerstchenCombinedPipeline"),c(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(O,"href","#diffusers.WuerstchenCombinedPipeline"),c(V,"class","relative group"),c(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"id","diffusers.WuerstchenPriorPipeline"),c(ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ne,"href","#diffusers.WuerstchenPriorPipeline"),c(N,"class","relative group"),c($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(se,"id","diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput"),c(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(se,"href","#diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput"),c(D,"class","relative group"),c(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(re,"id","diffusers.WuerstchenDecoderPipeline"),c(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(re,"href","#diffusers.WuerstchenDecoderPipeline"),c(X,"class","relative group"),c(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ae,"id","citation"),c(ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ae,"href","#citation"),c(L,"class","relative group")},m(e,r){n(document.head,h),i(e,P,r),i(e,y,r),n(y,m),n(m,M),_(p,M,null),n(y,W),n(y,qe),i(e,Gt,r),i(e,He,r),i(e,Bt,r),i(e,ce,r),i(e,At,r),i(e,pe,r),i(e,Et,r),i(e,de,r),i(e,Zt,r),i(e,G,r),n(G,q),n(q,Mt),_(ue,Mt,null),n(G,Cn),n(G,Fe),i(e,Vt,r),i(e,B,r),n(B,H),n(H,Tt),_(he,Tt,null),n(B,Jn),n(B,Ye),i(e,Nt,r),i(e,me,r),i(e,Dt,r),i(e,fe,r),i(e,St,r),i(e,ge,r),i(e,Xt,r),i(e,_e,r),i(e,Lt,r),i(e,be,r),i(e,Rt,r),i(e,we,r),i(e,Qt,r),i(e,A,r),n(A,F),n(F,xt),_(ve,xt,null),n(A,kn),n(A,ze),i(e,qt,r),i(e,ye,r),i(e,Ht,r),_(Me,e,r),i(e,Ft,r),i(e,Te,r),i(e,Yt,r),_(xe,e,r),i(e,zt,r),i(e,E,r),n(E,Y),n(Y,Wt),_(We,Wt,null),n(E,Un),n(E,Oe),i(e,Ot,r),_(Pe,e,r),i(e,Kt,r),i(e,Z,r),n(Z,z),n(z,Pt),_(Ce,Pt,null),n(Z,jn),n(Z,Ke),i(e,en,r),i(e,Je,r),i(e,tn,r),i(e,ke,r),i(e,nn,r),i(e,V,r),n(V,O),n(O,Ct),_(Ue,Ct,null),n(V,$n),n(V,et),i(e,on,r),i(e,T,r),_(je,T,null),n(T,In),n(T,tt),n(T,Gn),n(T,nt),n(T,Bn),n(T,j),_($e,j,null),n(j,An),n(j,ot),n(j,En),_(K,j,null),n(T,Zn),n(T,ee),_(Ie,ee,null),n(ee,Vn),n(ee,st),n(T,Nn),n(T,te),_(Ge,te,null),n(te,Dn),n(te,rt),i(e,sn,r),i(e,N,r),n(N,ne),n(ne,Jt),_(Be,Jt,null),n(N,Sn),n(N,it),i(e,rn,r),i(e,x,r),_(Ae,x,null),n(x,Xn),n(x,at),n(x,Ln),n(x,lt),n(x,Rn),n(x,ct),n(x,Qn),n(x,pt),n(x,qn),n(x,$),_(Ee,$,null),n($,Hn),n($,dt),n($,Fn),_(oe,$,null),i(e,an,r),i(e,D,r),n(D,se),n(se,kt),_(Ze,kt,null),n(D,Yn),n(D,ut),i(e,ln,r),i(e,S,r),_(Ve,S,null),n(S,zn),n(S,ht),i(e,cn,r),i(e,X,r),n(X,re),n(re,Ut),_(Ne,Ut,null),n(X,On),n(X,mt),i(e,pn,r),i(e,C,r),_(De,C,null),n(C,Kn),n(C,ft),n(C,eo),n(C,gt),n(C,to),n(C,I),_(Se,I,null),n(I,no),n(I,_t),n(I,oo),_(ie,I,null),i(e,dn,r),i(e,L,r),n(L,ae),n(ae,jt),_(Xe,jt,null),n(L,so),n(L,bt),i(e,un,r),_(Le,e,r),hn=!0},p(e,[r]){const Re={};r&2&&(Re.$$scope={dirty:r,ctx:e}),K.$set(Re);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),oe.$set($t);const It={};r&2&&(It.$$scope={dirty:r,ctx:e}),ie.$set(It)},i(e){hn||(b(p.$$.fragment,e),b(ue.$$.fragment,e),b(he.$$.fragment,e),b(ve.$$.fragment,e),b(Me.$$.fragment,e),b(xe.$$.fragment,e),b(We.$$.fragment,e),b(Pe.$$.fragment,e),b(Ce.$$.fragment,e),b(Ue.$$.fragment,e),b(je.$$.fragment,e),b($e.$$.fragment,e),b(K.$$.fragment,e),b(Ie.$$.fragment,e),b(Ge.$$.fragment,e),b(Be.$$.fragment,e),b(Ae.$$.fragment,e),b(Ee.$$.fragment,e),b(oe.$$.fragment,e),b(Ze.$$.fragment,e),b(Ve.$$.fragment,e),b(Ne.$$.fragment,e),b(De.$$.fragment,e),b(Se.$$.fragment,e),b(ie.$$.fragment,e),b(Xe.$$.fragment,e),b(Le.$$.fragment,e),hn=!0)},o(e){w(p.$$.fragment,e),w(ue.$$.fragment,e),w(he.$$.fragment,e),w(ve.$$.fragment,e),w(Me.$$.fragment,e),w(xe.$$.fragment,e),w(We.$$.fragment,e),w(Pe.$$.fragment,e),w(Ce.$$.fragment,e),w(Ue.$$.fragment,e),w(je.$$.fragment,e),w($e.$$.fragment,e),w(K.$$.fragment,e),w(Ie.$$.fragment,e),w(Ge.$$.fragment,e),w(Be.$$.fragment,e),w(Ae.$$.fragment,e),w(Ee.$$.fragment,e),w(oe.$$.fragment,e),w(Ze.$$.fragment,e),w(Ve.$$.fragment,e),w(Ne.$$.fragment,e),w(De.$$.fragment,e),w(Se.$$.fragment,e),w(ie.$$.fragment,e),w(Xe.$$.fragment,e),w(Le.$$.fragment,e),hn=!1},d(e){e&&(t(P),t(y),t(Gt),t(He),t(Bt),t(ce),t(At),t(pe),t(Et),t(de),t(Zt),t(G),t(Vt),t(B),t(Nt),t(me),t(Dt),t(fe),t(St),t(ge),t(Xt),t(_e),t(Lt),t(be),t(Rt),t(we),t(Qt),t(A),t(qt),t(ye),t(Ht),t(Ft),t(Te),t(Yt),t(zt),t(E),t(Ot),t(Kt),t(Z),t(en),t(Je),t(tn),t(ke),t(nn),t(V),t(on),t(T),t(sn),t(N),t(rn),t(x),t(an),t(D),t(ln),t(S),t(cn),t(X),t(pn),t(C),t(dn),t(L),t(un)),t(h),v(p),v(ue),v(he),v(ve),v(Me,e),v(xe,e),v(We),v(Pe,e),v(Ce),v(Ue),v(je),v($e),v(K),v(Ie),v(Ge),v(Be),v(Ae),v(Ee),v(oe),v(Ze),v(Ve),v(Ne),v(De),v(Se),v(ie),v(Xe),v(Le,e)}}}const Ws={local:"wrstchen",sections:[{local:"wrstchen-overview",title:"Würstchen Overview"},{local:"wrstchen-v2-comes-to-diffusers",title:"Würstchen v2 comes to Diffusers"},{local:"texttoimage-generation",title:"Text-to-Image Generation"},{local:"speedup-inference",title:"Speed-Up Inference"},{local:"limitations",title:"Limitations"},{local:"diffusers.WuerstchenCombinedPipeline",title:"WuerstchenCombinedPipeline"},{local:"diffusers.WuerstchenPriorPipeline",title:"WuerstchenPriorPipeline"},{local:"diffusers.pipelines.wuerstchen.pipeline_wuerstchen_prior.WuerstchenPriorPipelineOutput",title:"WuerstchenPriorPipelineOutput"},{local:"diffusers.WuerstchenDecoderPipeline",title:"WuerstchenDecoderPipeline"},{local:"citation",title:"Citation"}],title:"Würstchen"};function Ps(Q){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends bs{constructor(h){super(),ws(this,h,Ps,xs,gs,{})}}export{Is as component};
