import{s as ms,n as ps,o as hs}from"../chunks/scheduler.9039eef2.js";import{S as us,i as cs,g as r,s,r as m,A as fs,h as a,f as n,c as o,j as b,u as p,x as d,k as x,l as hl,y as i,a as l,v as h,d as u,t as c,w as f}from"../chunks/index.ded8f90d.js";import{D as w}from"../chunks/Docstring.a2ba2b54.js";import{C as P}from"../chunks/CodeBlock.8580f3e8.js";import{H as M}from"../chunks/Heading.f027f30d.js";function gs(ul){let _,be,ve,xe,R,$e,Z,cl="Text environments provide a learning ground for language agents. It allows a language model to use tools to accomplish a task such as using a Python interpreter to answer math questions or using a search index for trivia questions. Having access to tools allows language models to solve tasks that would be very hard for the models itself but can be trivial for the appropriate tools. A good example is arithmetics of large numbers that become a simple copy-paste task once you have access to a calculator.",we,C,fl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv.png"/>',Me,G,gl="Let’s dive into how text environments work and start with tools!",Te,Q,_e,W,vl="One of the core building blocks of text environments are tools that the model can use to solve tasks. In general tools can be any Python function that takes a string as input and returns string. The <code>TextEnvironment</code> offers two options for tools: either go with predefined tools from <code>transformers.Tool</code> or define your own function or class with <code>__call__</code> method. Let’s have a look at both!",Ce,S,ke,A,yl="Text environments fully support tools of the class <code>transformers.Tool</code>. The advantage of building tools in that framework is that they can easily be shared",Ue,D,je,F,bl="These tools are either loaded from the hub or from a local folder. Using the tool is as simple as calling them with a text query:",Je,Y,He,O,xl="Note that both input and return values are strings to enable easy usage with a language model.",qe,K,Ee,tt,$l="The following is an example of a tool that adds two integers:",ze,et,Le,nt,wl="We looked at basic examples such as a calculator but the principle holds for more complex tools as well such as a web search tool where you input the query and get the search results in return. Now let’s look at how the model can use the tools with the call syntax.",Ie,lt,Ne,st,Ml="In order to have a unified way for the model to call a tool we created a simple syntax that looks as follows:",Ve,ot,Xe,rt,Tl="There are a few special tokens involved so let’s decompose it: First the model can signal that it wants to use a tool by emitting the <code>&lt;request&gt;</code> token. After that we want to know the name of the tool to call which is done by enclosing the tool name with <code>&lt;&gt;</code> brackets. Once we know which tool to call the tool query follows which is in free text form. The <code>&lt;call&gt;</code> tokens signifies the end of the query and stops the model generation. At this point the model output is parsed and the query sent to the tool. The environment appends the tool response to the string followed by the <code>&lt;response&gt;</code> token to show the end the tool output.",Be,at,_l="Let’s look at the concrete example of the calculator and assume its name is <code>Calculator</code> (more on how the name of a tool is inferred later):",Pe,it,Re,dt,Cl="Finally, the episode is ended and generation stops when the model generates <code>&lt;submit&gt;</code> which marks the interaction as completed.",Ze,mt,kl="Now let’s have a look how we can create a new text environment!",Ge,pt,Qe,ht,We,ut,Ul="Let’s decompose the settings:",Se,ct,jl='<thead><tr><th align="left">Argument</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>model</code></td> <td align="left">Language model to interact with the environment and generate requests.</td></tr> <tr><td align="left"><code>tokenizer</code></td> <td align="left">Tokenizer of language model handling tokenization of strings.</td></tr> <tr><td align="left"><code>tools</code></td> <td align="left"><code>list</code> of <code>dict</code> of tools. If former the name of the tool is inferred from class name and otherwise it’s the keys of the dictionary.</td></tr> <tr><td align="left"><code>reward_fn</code></td> <td align="left">A function that takes a string as input and returns. Can have extra arguments that are passed to <code>.run()</code> such as ground truth.</td></tr> <tr><td align="left"><code>prompt</code></td> <td align="left">Prompt to prepend to every task. Usually a few examples to demonstrate to the model how to use the tools in a few-shot fashion.</td></tr> <tr><td align="left"><code>max_turns</code></td> <td align="left">Maximum number of interactions between model and tools before episode ends.</td></tr> <tr><td align="left"><code>max_tool_response</code></td> <td align="left">The tool response is truncated to this number to avoid running out of model context.</td></tr> <tr><td align="left"><code>max_length</code></td> <td align="left">The maximum number of tokens to allow in an episode.</td></tr> <tr><td align="left"><code>generation_kwargs</code></td> <td align="left">Generation settings used by the language model.</td></tr></tbody>',Ae,ft,Jl="You can customize the environment to your needs and add custom tools and settings. Let’s see how you can use the environment to have the model interact with the available tools!",De,gt,Fe,vt,Hl="To run a set of queries through the text environment one can simply use the <code>run</code> method.",Ye,yt,Oe,bt,ql="This will execute the model/tool feedback loop for each query until either no tool is called anymore, the maximum number of turns is reached or to maximum number of tokens in an episode is exceeded. The extra <code>kwargs</code> (e.g. <code>answers=answers</code> above) passed to <code>run</code> will be passed on to the reward function.",Ke,xt,El="There are five objects that are returned by <code>run</code>:",tn,$t,zl="<li><code>queries</code>: a list of the tokenized queries</li> <li><code>responses</code>: all tokens that have been generated withing the environment including model and tool tokens</li> <li><code>masks</code>: mask that indicates which tokens have been generated by the model and which tokens are generated by the tool</li> <li><code>rewards</code>: a list of reward for each query/response</li> <li><code>histories</code>: list of <code>TextHistory</code> objects, which are useful objects containing all the above and also the text equivalents</li>",en,wt,Ll="The masks are crucial for training as we don’t want to optimize tokens that the model has not generated which are tokens produced by the tools.",nn,Mt,Il="Next, we’ll train a PPO step with the generated responses!",ln,Tt,sn,_t,Nl="Training on episodes from the <code>TextEnvironment</code> is straight forward and simply requires forwarding all the returned variables except the <code>TextHistory</code> objects to the <code>step</code> method:",on,Ct,rn,kt,an,Ut,Vl="The <code>TextHistory</code> object stores the interactions between the model and the text environment. It stores tokens and text generated in each turn and their source in each turn (model or system) as well as rewards. Let’s go through the class attributes and methods.",dn,jt,mn,Jt,Xl="The following table summarises the available attributes of the <code>TextEnvironment</code> class:",pn,Ht,Bl='<thead><tr><th align="left">Attribute</th> <th align="left">Description</th></tr></thead> <tbody><tr><td align="left"><code>text</code></td> <td align="left">The full string of the text generated in the text environment with both model and system generated text.</td></tr> <tr><td align="left"><code>text_spans</code></td> <td align="left">A list of tuples with the spans for each model or system generated text segment.</td></tr> <tr><td align="left"><code>system_spans</code></td> <td align="left">A list of boolean values indicating if the segment is model or system generated.</td></tr> <tr><td align="left"><code>tokens</code></td> <td align="left">All tokens generated in text environment with both model and system generated tokens.</td></tr> <tr><td align="left"><code>token_spans</code></td> <td align="left">Similar to <code>text_spans</code> the <code>token_spans</code> indicate the boundaries of model andsystem generated tokens.</td></tr> <tr><td align="left"><code>token_masks</code></td> <td align="left">The token masks can be used to ignore system generated tokens by masking them.</td></tr> <tr><td align="left"><code>completed</code></td> <td align="left">Indicates if the interaction with the environment has completed.</td></tr> <tr><td align="left"><code>truncated</code></td> <td align="left">Indicates if the interaction with the environment has completed because max length was reached.</td></tr></tbody>',hn,qt,Pl="With these attributes you can reconstruct every interaction of the model with the <code>TextEnvironment</code>. The <code>TextHistory</code> also lets you visualize the text history. Let’s have a look!",un,Et,cn,zt,Rl='When the model interacts inside the <code>TextEnvironment</code> it can be useful to visualize and separate which parts of the text outputs were generated by the model and which parts come from the system and tools. For that purpose there are the two methods <a href="/docs/trl/v0.7.4/en/text_environments#trl.TextHistory.show_text">TextHistory.show_text()</a> and <a href="/docs/trl/v0.7.4/en/text_environments#trl.TextHistory.show_tokens">TextHistory.show_tokens()</a>. They print the text and tokens respectively and highlight the various segments using the <a href="https://github.com/Textualize/rich" rel="nofollow"><code>rich</code> libray</a> (make sure to install it before using these methods).',fn,Lt,Zl="You can see that the prompt is highlighted in gray, whereas system segments such as query and tool responses are highlighted in green. All segments generated by the model are highlighted in blue and in addition to the pure text output the reward is displayed as additional text in plum. Here an example of <code>show_text</code>:",gn,k,Gl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_text.png" width="600"/>',vn,It,Ql="Sometimes there can be tricky tokenization related issues that are hidden when showing the decoded text. Thus <code>TextHistory</code> also offers an option to display the same highlighting on the tokens directly with <code>show_tokens</code>:",yn,U,Wl='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/textenv_show_tokens.png" width="800"/>',bn,Nt,Sl="Note that you can turn on the colour legend by passing <code>show_legend=True</code>.",xn,Vt,$n,g,Xt,Nn,te,Al="The TextEnvironment enables interaction of a LLM with an environment using tools.",Vn,j,Bt,Xn,ee,Dl="Compute the reward for a list of histories.",Bn,J,Pt,Pn,ne,Fl="Generate responses for a list of histories.",Rn,H,Rt,Zn,le,Yl="Parse request string. Expected format: <request><tool_name>query<call>",Gn,q,Zt,Qn,se,Ol="Run the environment on a list of queries.",Wn,E,Gt,Sn,oe,Kl="Step the environment forward one turn.",An,z,Qt,Dn,re,ts="Check if the current generation sequence has finished.",Fn,L,Wt,Yn,ae,es="Check if the current generation sequences have finished.",wn,v,St,On,ie,ns="The TextHistory class keeps track of the history of an interaction between the language model and the environment.",Kn,T,At,tl,de,ls="Append a new segment to the history.",el,me,ss=`args:
text (<code>str</code>): The text of the new segment.
tokens (<code>torch.LongTensor</code>): The tokens of the new segment.
system (<code>bool</code>, <em>optional</em>): Whether the new segment is a system or user segment.`,nl,I,Dt,ll,pe,os="Mark the history as completed.",sl,N,Ft,ol,he,rs="Print the colour legend.",rl,V,Yt,al,ue,as="Print the text history.",il,X,Ot,dl,ce,is="Print the history tokens.",ml,B,Kt,pl,fe,ds="Split the tokens into query and response tokens.",Mn,ye,Tn;return R=new M({props:{title:"Text Environments",local:"text-environments",headingTag:"h1"}}),Q=new M({props:{title:"Tools",local:"tools",headingTag:"h2"}}),S=new M({props:{title:"transformers.Tool",local:"transformerstool",headingTag:"h3"}}),D=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGxvYWRfdG9vbCUwQSUwQSUyMyUyMHNpbXBsZSUyMGNhbGN1bGF0b3IlMjB0b29sJTIwdGhhdCUyMHJ1bnMlMjAlMkItJTJGKiUyMG9wZXJhdGlvbnMlMEFjYWxjX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIyeWJlbGthZGElMkZzaW1wbGUtY2FsY3VsYXRvciUyMiklMEElMEElMjMlMjBweXRob24lMjBpbnRlcnByZXRlciUyMHRoYXQlMjBleGVjdXRlcyUyMHByb2dyYW0lMjBhbmQlMjByZXR1cm5zJTIwb3V0cHV0cyUwQXB5X3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybHZ3ZXJyYSUyRnB5dGhvbi1pbnRlcnByZXRlciUyMiklMEElMEElMjMlMjB3aWtpcGVkaWElMjBzZWFyY2glMjBpbmRleCUyMHRoYXQlMjByZXR1cm5zJTIwYmVzdCUyMHNlYXJjaCUyMG1hdGNoJTBBd2lraV90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMnZ3eHl6am4lMkZweXNlcmluaS13aWtpcGVkaWEta2lsdC1kb2MlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> load_tool

<span class="hljs-comment"># simple calculator tool that runs +-/* operations</span>
calc_tool = load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)

<span class="hljs-comment"># python interpreter that executes program and returns outputs</span>
py_tool = load_tool(<span class="hljs-string">&quot;lvwerra/python-interpreter&quot;</span>)

<span class="hljs-comment"># wikipedia search index that returns best search match</span>
wiki_tool = load_tool(<span class="hljs-string">&quot;vwxyzjn/pyserini-wikipedia-kilt-doc&quot;</span>)`,wrap:!1}}),Y=new P({props:{code:"JTIyMC41JTIy",highlighted:`calc_tool(<span class="hljs-string">&quot;1/2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;0.5&quot;</span>`,wrap:!1}}),K=new M({props:{title:"Custom Tools",local:"custom-tools",headingTag:"h3"}}),et=new P({props:{code:"JTBBJTIyMiUyMg==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add</span>(<span class="hljs-params">text</span>):
    int_1, int_2 = text.split(<span class="hljs-string">&quot;+&quot;</span>)
    result = <span class="hljs-built_in">int</span>(int_1) + <span class="hljs-built_in">int</span>(int_2)
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(result)

<span class="hljs-built_in">print</span>(add(<span class="hljs-string">&quot;1+1&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;2&quot;</span>`,wrap:!1}}),lt=new M({props:{title:"Call syntax",local:"call-syntax",headingTag:"h3"}}),ot=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ1RPT0xfTkFNRSUzRVFVRVJZJTNDY2FsbCUzRVRPT0xfUkVTUE9OU0UlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;TOOL_NAME&gt;QUERY&lt;call&gt;TOOL_RESPONSE&lt;response&gt;&quot;</span>',wrap:!1}}),it=new P({props:{code:"JTIyJTNDcmVxdWVzdCUzRSUzQ0NhbGN1bGF0b3IlM0UxJTJGMiUzQ2NhbGwlM0UwLjUlM0NyZXNwb25zZSUzRSUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;request&gt;&lt;Calculator&gt;1/2&lt;call&gt;0.5&lt;response&gt;&quot;</span>',wrap:!1}}),pt=new M({props:{title:"Create a TextEnvironment",local:"create-a-textenvironment",headingTag:"h2"}}),ht=new P({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTVDJTBBV2hhdCUyMGlzJTIwMTMtMyUzRiUwQSUzQ3JlcXVlc3QlM0UlM0NTaW1wbGVDYWxjdWxhdG9yVG9vbCUzRTEzLTMlM0NjYWxsJTNFMTAuMCUzQ3Jlc3BvbnNlJTNFJTBBUmVzdWx0JTNEMTAlM0NzdWJtaXQlM0UlMEElMjIlMjIlMjIlMEElMEFkZWYlMjByZXdhcmRfZm4ocmVzdWx0JTJDJTIwYW5zd2VyKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlNpbXBsaWZpZWQlMjByZXdhcmQlMjBmdW5jdGlvbiUyMHJldHVybmluZyUyMDElMjBpZiUyMHJlc3VsdCUyMG1hdGNoZXMlMjBhbnN3ZXIlMjBhbmQlMjAwJTIwb3RoZXJ3aXNlLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJlc3VsdF9wYXJzZWQlMjAlM0QlMjByZXN1bHQuc3BsaXQoJTIyJTNEJTIyKSU1QjElNUQuc3BsaXQoJTIyJTNDJTIyKSU1QjAlNUQlMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnQocmVzdWx0X3BhcnNlZCUzRCUzRGFuc3dlciklMEElMEF0ZXh0X2VudiUyMCUzRCUyMFRleHRFbnZpcm9uZW1udCglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlMjAlN0IlMjJTaW1wbGVDYWxjdWxhdG9yVG9vbCUyMiUzQSUyMGxvYWRfdG9vbCglMjJ5YmVsa2FkYSUyRnNpbXBsZS1jYWxjdWxhdG9yJTIyKSU3RCUyQyUwQSUyMCUyMCUyMCUyMHJld2FyZF9mbiUzRGV4YWN0X21hdGNoX3Jld2FyZCUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMG1heF90dXJucyUzRDElMEElMjAlMjAlMjAlMjBtYXhfdG9vbF9yZXNwb25zZSUzRDEwMCUwQSUyMCUyMCUyMCUyMGdlbmVyYXRpb25fa3dhcmdzJTNEJTdCJTIyZG9fc2FtcGxlJTIyJTNBJTIwJTIydHJ1ZSUyMiU3RCUwQSk=",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;\\
What is 13-3?
&lt;request&gt;&lt;SimpleCalculatorTool&gt;13-3&lt;call&gt;10.0&lt;response&gt;
Result=10&lt;submit&gt;
&quot;&quot;&quot;</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">reward_fn</span>(<span class="hljs-params">result, answer</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simplified reward function returning 1 if result matches answer and 0 otherwise.&quot;&quot;&quot;</span>
    result_parsed = result.split(<span class="hljs-string">&quot;=&quot;</span>)[<span class="hljs-number">1</span>].split(<span class="hljs-string">&quot;&lt;&quot;</span>)[<span class="hljs-number">0</span>]
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(result_parsed==answer)

text_env = TextEnvironemnt(
    model=model, 
    tokenizer=tokenizer,
    tools= {<span class="hljs-string">&quot;SimpleCalculatorTool&quot;</span>: load_tool(<span class="hljs-string">&quot;ybelkada/simple-calculator&quot;</span>)},
    reward_fn=exact_match_reward,
    prompt=prompt, 
    max_turns=<span class="hljs-number">1</span>
    max_tool_response=<span class="hljs-number">100</span>
    generation_kwargs={<span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-string">&quot;true&quot;</span>}
)`,wrap:!1}}),gt=new M({props:{title:"Run an Episode",local:"run-an-episode",headingTag:"h2"}}),yt=new P({props:{code:"cXVlcmllcyUyMCUzRCUyMCU1QiUyMldoYXQlMjBpcyUyMDElMkYyJTNGJTIyJTVEJTBBYW5zd2VycyUyMCUzRCUyMCU1QiUyMjAuNSUyMiU1RCUwQSUwQXF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjBtYXNrcyUyQyUyMHJld2FyZHMlMkMlMjBoaXN0b3JpZXMlMjAlM0QlMjB0ZXh0X2Vudi5ydW4ocXVlcmllcyUyQyUyMGFuc3dlcnMlM0RhbnN3ZXJzKQ==",highlighted:`queries = [<span class="hljs-string">&quot;What is 1/2?&quot;</span>]
answers = [<span class="hljs-string">&quot;0.5&quot;</span>]

queries, responses, masks, rewards, histories = text_env.run(queries, answers=answers)`,wrap:!1}}),Tt=new M({props:{title:"Train",local:"train",headingTag:"h3"}}),Ct=new P({props:{code:"dHJhaW5fc3RhdHMlMjAlM0QlMjBwcG9fdHJhaW5lci5zdGVwKHF1ZXJpZXMlMkMlMjByZXNwb25zZXMlMkMlMjByZXdhcmRzJTJDJTIwbWFza3Mp",highlighted:"train_stats = ppo_trainer.step(queries, responses, rewards, masks)",wrap:!1}}),kt=new M({props:{title:"TextHistory",local:"texthistory",headingTag:"h2"}}),jt=new M({props:{title:"Attributes",local:"attributes",headingTag:"h3"}}),Et=new M({props:{title:"Visualization",local:"visualization",headingTag:"h3"}}),Vt=new M({props:{title:"API Documentation",local:"trl.TextEnvironment",headingTag:"h2"}}),Xt=new w({props:{name:"class trl.TextEnvironment",anchor:"trl.TextEnvironment",parameters:[{name:"model",val:" = None"},{name:"tokenizer",val:" = None"},{name:"tools",val:" = None"},{name:"reward_fn",val:" = None"},{name:"prompt",val:" = None"},{name:"max_turns",val:" = 4"},{name:"max_tool_reponse",val:" = 100"},{name:"max_length",val:" = None"},{name:"generation_kwargs",val:" = None"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L208"}}),Bt=new w({props:{name:"compute_reward",anchor:"trl.TextEnvironment.compute_reward",parameters:[{name:"histories",val:""},{name:"**reward_kwargs",val:""}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L358"}}),Pt=new w({props:{name:"generate",anchor:"trl.TextEnvironment.generate",parameters:[{name:"histories",val:""}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L367"}}),Rt=new w({props:{name:"parse_tool_call",anchor:"trl.TextEnvironment.parse_tool_call",parameters:[{name:"text",val:""}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L333"}}),Zt=new w({props:{name:"run",anchor:"trl.TextEnvironment.run",parameters:[{name:"queries",val:""},{name:"**rewards_kwargs",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.run.queries",description:"<strong>queries</strong> (list[str]) &#x2014; A list of queries to run the model in the environment on.",name:"queries"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L263"}}),Gt=new w({props:{name:"step",anchor:"trl.TextEnvironment.step",parameters:[{name:"history",val:""}],parametersDescription:[{anchor:"trl.TextEnvironment.step.history",description:"<strong>history</strong> (<code>TextHistory</code>) &#x2014; The history to step forward.",name:"history"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L296"}}),Qt=new w({props:{name:"task_end_check",anchor:"trl.TextEnvironment.task_end_check",parameters:[{name:"history",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L393"}}),Wt=new w({props:{name:"tasks_end_check",anchor:"trl.TextEnvironment.tasks_end_check",parameters:[{name:"histories",val:""},{name:"model_turn",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L382"}}),St=new w({props:{name:"class trl.TextHistory",anchor:"trl.TextHistory",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L59"}}),At=new w({props:{name:"append_segment",anchor:"trl.TextHistory.append_segment",parameters:[{name:"text",val:""},{name:"tokens",val:""},{name:"system",val:" = True"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L88"}}),Dt=new w({props:{name:"complete",anchor:"trl.TextHistory.complete",parameters:[{name:"truncated",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L116"}}),Ft=new w({props:{name:"show_colour_legend",anchor:"trl.TextHistory.show_colour_legend",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L189"}}),Yt=new w({props:{name:"show_text",anchor:"trl.TextHistory.show_text",parameters:[{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L142"}}),Ot=new w({props:{name:"show_tokens",anchor:"trl.TextHistory.show_tokens",parameters:[{name:"tokenizer",val:""},{name:"show_legend",val:" = False"}],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L164"}}),Kt=new w({props:{name:"split_query_response_tokens",anchor:"trl.TextHistory.split_query_response_tokens",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.7.4/trl/environment/base_environment.py#L131"}}),{c(){_=r("meta"),be=s(),ve=r("p"),xe=s(),m(R.$$.fragment),$e=s(),Z=r("p"),Z.textContent=cl,we=s(),C=r("div"),C.innerHTML=fl,Me=s(),G=r("p"),G.textContent=gl,Te=s(),m(Q.$$.fragment),_e=s(),W=r("p"),W.innerHTML=vl,Ce=s(),m(S.$$.fragment),ke=s(),A=r("p"),A.innerHTML=yl,Ue=s(),m(D.$$.fragment),je=s(),F=r("p"),F.textContent=bl,Je=s(),m(Y.$$.fragment),He=s(),O=r("p"),O.textContent=xl,qe=s(),m(K.$$.fragment),Ee=s(),tt=r("p"),tt.textContent=$l,ze=s(),m(et.$$.fragment),Le=s(),nt=r("p"),nt.textContent=wl,Ie=s(),m(lt.$$.fragment),Ne=s(),st=r("p"),st.textContent=Ml,Ve=s(),m(ot.$$.fragment),Xe=s(),rt=r("p"),rt.innerHTML=Tl,Be=s(),at=r("p"),at.innerHTML=_l,Pe=s(),m(it.$$.fragment),Re=s(),dt=r("p"),dt.innerHTML=Cl,Ze=s(),mt=r("p"),mt.textContent=kl,Ge=s(),m(pt.$$.fragment),Qe=s(),m(ht.$$.fragment),We=s(),ut=r("p"),ut.textContent=Ul,Se=s(),ct=r("table"),ct.innerHTML=jl,Ae=s(),ft=r("p"),ft.textContent=Jl,De=s(),m(gt.$$.fragment),Fe=s(),vt=r("p"),vt.innerHTML=Hl,Ye=s(),m(yt.$$.fragment),Oe=s(),bt=r("p"),bt.innerHTML=ql,Ke=s(),xt=r("p"),xt.innerHTML=El,tn=s(),$t=r("ul"),$t.innerHTML=zl,en=s(),wt=r("p"),wt.textContent=Ll,nn=s(),Mt=r("p"),Mt.textContent=Il,ln=s(),m(Tt.$$.fragment),sn=s(),_t=r("p"),_t.innerHTML=Nl,on=s(),m(Ct.$$.fragment),rn=s(),m(kt.$$.fragment),an=s(),Ut=r("p"),Ut.innerHTML=Vl,dn=s(),m(jt.$$.fragment),mn=s(),Jt=r("p"),Jt.innerHTML=Xl,pn=s(),Ht=r("table"),Ht.innerHTML=Bl,hn=s(),qt=r("p"),qt.innerHTML=Pl,un=s(),m(Et.$$.fragment),cn=s(),zt=r("p"),zt.innerHTML=Rl,fn=s(),Lt=r("p"),Lt.innerHTML=Zl,gn=s(),k=r("div"),k.innerHTML=Gl,vn=s(),It=r("p"),It.innerHTML=Ql,yn=s(),U=r("div"),U.innerHTML=Wl,bn=s(),Nt=r("p"),Nt.innerHTML=Sl,xn=s(),m(Vt.$$.fragment),$n=s(),g=r("div"),m(Xt.$$.fragment),Nn=s(),te=r("p"),te.textContent=Al,Vn=s(),j=r("div"),m(Bt.$$.fragment),Xn=s(),ee=r("p"),ee.textContent=Dl,Bn=s(),J=r("div"),m(Pt.$$.fragment),Pn=s(),ne=r("p"),ne.textContent=Fl,Rn=s(),H=r("div"),m(Rt.$$.fragment),Zn=s(),le=r("p"),le.textContent=Yl,Gn=s(),q=r("div"),m(Zt.$$.fragment),Qn=s(),se=r("p"),se.textContent=Ol,Wn=s(),E=r("div"),m(Gt.$$.fragment),Sn=s(),oe=r("p"),oe.textContent=Kl,An=s(),z=r("div"),m(Qt.$$.fragment),Dn=s(),re=r("p"),re.textContent=ts,Fn=s(),L=r("div"),m(Wt.$$.fragment),Yn=s(),ae=r("p"),ae.textContent=es,wn=s(),v=r("div"),m(St.$$.fragment),On=s(),ie=r("p"),ie.textContent=ns,Kn=s(),T=r("div"),m(At.$$.fragment),tl=s(),de=r("p"),de.textContent=ls,el=s(),me=r("p"),me.innerHTML=ss,nl=s(),I=r("div"),m(Dt.$$.fragment),ll=s(),pe=r("p"),pe.textContent=os,sl=s(),N=r("div"),m(Ft.$$.fragment),ol=s(),he=r("p"),he.textContent=rs,rl=s(),V=r("div"),m(Yt.$$.fragment),al=s(),ue=r("p"),ue.textContent=as,il=s(),X=r("div"),m(Ot.$$.fragment),dl=s(),ce=r("p"),ce.textContent=is,ml=s(),B=r("div"),m(Kt.$$.fragment),pl=s(),fe=r("p"),fe.textContent=ds,Mn=s(),ye=r("p"),this.h()},l(t){const e=fs("svelte-u9bgzb",document.head);_=a(e,"META",{name:!0,content:!0}),e.forEach(n),be=o(t),ve=a(t,"P",{}),b(ve).forEach(n),xe=o(t),p(R.$$.fragment,t),$e=o(t),Z=a(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1xyqi3j"&&(Z.textContent=cl),we=o(t),C=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(C)!=="svelte-1trtrmz"&&(C.innerHTML=fl),Me=o(t),G=a(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1fzari6"&&(G.textContent=gl),Te=o(t),p(Q.$$.fragment,t),_e=o(t),W=a(t,"P",{"data-svelte-h":!0}),d(W)!=="svelte-tw2sw7"&&(W.innerHTML=vl),Ce=o(t),p(S.$$.fragment,t),ke=o(t),A=a(t,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ooeso0"&&(A.innerHTML=yl),Ue=o(t),p(D.$$.fragment,t),je=o(t),F=a(t,"P",{"data-svelte-h":!0}),d(F)!=="svelte-n1kfsw"&&(F.textContent=bl),Je=o(t),p(Y.$$.fragment,t),He=o(t),O=a(t,"P",{"data-svelte-h":!0}),d(O)!=="svelte-cvmhd6"&&(O.textContent=xl),qe=o(t),p(K.$$.fragment,t),Ee=o(t),tt=a(t,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-16zvcez"&&(tt.textContent=$l),ze=o(t),p(et.$$.fragment,t),Le=o(t),nt=a(t,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-1180ir7"&&(nt.textContent=wl),Ie=o(t),p(lt.$$.fragment,t),Ne=o(t),st=a(t,"P",{"data-svelte-h":!0}),d(st)!=="svelte-11yatwq"&&(st.textContent=Ml),Ve=o(t),p(ot.$$.fragment,t),Xe=o(t),rt=a(t,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-1jmhsjt"&&(rt.innerHTML=Tl),Be=o(t),at=a(t,"P",{"data-svelte-h":!0}),d(at)!=="svelte-1swzwy8"&&(at.innerHTML=_l),Pe=o(t),p(it.$$.fragment,t),Re=o(t),dt=a(t,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-1v8f0zk"&&(dt.innerHTML=Cl),Ze=o(t),mt=a(t,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-14nr4ad"&&(mt.textContent=kl),Ge=o(t),p(pt.$$.fragment,t),Qe=o(t),p(ht.$$.fragment,t),We=o(t),ut=a(t,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1sl46j2"&&(ut.textContent=Ul),Se=o(t),ct=a(t,"TABLE",{"data-svelte-h":!0}),d(ct)!=="svelte-1ffep7v"&&(ct.innerHTML=jl),Ae=o(t),ft=a(t,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-yvijza"&&(ft.textContent=Jl),De=o(t),p(gt.$$.fragment,t),Fe=o(t),vt=a(t,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-6qt7x3"&&(vt.innerHTML=Hl),Ye=o(t),p(yt.$$.fragment,t),Oe=o(t),bt=a(t,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-uwb7dt"&&(bt.innerHTML=ql),Ke=o(t),xt=a(t,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-a89imt"&&(xt.innerHTML=El),tn=o(t),$t=a(t,"UL",{"data-svelte-h":!0}),d($t)!=="svelte-v1659j"&&($t.innerHTML=zl),en=o(t),wt=a(t,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1fn2ypb"&&(wt.textContent=Ll),nn=o(t),Mt=a(t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-jjlyr5"&&(Mt.textContent=Il),ln=o(t),p(Tt.$$.fragment,t),sn=o(t),_t=a(t,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-1oiocxk"&&(_t.innerHTML=Nl),on=o(t),p(Ct.$$.fragment,t),rn=o(t),p(kt.$$.fragment,t),an=o(t),Ut=a(t,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-11ulv39"&&(Ut.innerHTML=Vl),dn=o(t),p(jt.$$.fragment,t),mn=o(t),Jt=a(t,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-10b1zzx"&&(Jt.innerHTML=Xl),pn=o(t),Ht=a(t,"TABLE",{"data-svelte-h":!0}),d(Ht)!=="svelte-bubgue"&&(Ht.innerHTML=Bl),hn=o(t),qt=a(t,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-idwl5w"&&(qt.innerHTML=Pl),un=o(t),p(Et.$$.fragment,t),cn=o(t),zt=a(t,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-12x43o6"&&(zt.innerHTML=Rl),fn=o(t),Lt=a(t,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-129arh1"&&(Lt.innerHTML=Zl),gn=o(t),k=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(k)!=="svelte-11fs52k"&&(k.innerHTML=Gl),vn=o(t),It=a(t,"P",{"data-svelte-h":!0}),d(It)!=="svelte-r85xss"&&(It.innerHTML=Ql),yn=o(t),U=a(t,"DIV",{style:!0,"data-svelte-h":!0}),d(U)!=="svelte-wolnbf"&&(U.innerHTML=Wl),bn=o(t),Nt=a(t,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-zesxnv"&&(Nt.innerHTML=Sl),xn=o(t),p(Vt.$$.fragment,t),$n=o(t),g=a(t,"DIV",{class:!0});var y=b(g);p(Xt.$$.fragment,y),Nn=o(y),te=a(y,"P",{"data-svelte-h":!0}),d(te)!=="svelte-152alil"&&(te.textContent=Al),Vn=o(y),j=a(y,"DIV",{class:!0});var _n=b(j);p(Bt.$$.fragment,_n),Xn=o(_n),ee=a(_n,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-jbudbm"&&(ee.textContent=Dl),_n.forEach(n),Bn=o(y),J=a(y,"DIV",{class:!0});var Cn=b(J);p(Pt.$$.fragment,Cn),Pn=o(Cn),ne=a(Cn,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-6c4d0o"&&(ne.textContent=Fl),Cn.forEach(n),Rn=o(y),H=a(y,"DIV",{class:!0});var kn=b(H);p(Rt.$$.fragment,kn),Zn=o(kn),le=a(kn,"P",{"data-svelte-h":!0}),d(le)!=="svelte-19cl563"&&(le.textContent=Yl),kn.forEach(n),Gn=o(y),q=a(y,"DIV",{class:!0});var Un=b(q);p(Zt.$$.fragment,Un),Qn=o(Un),se=a(Un,"P",{"data-svelte-h":!0}),d(se)!=="svelte-qo76c0"&&(se.textContent=Ol),Un.forEach(n),Wn=o(y),E=a(y,"DIV",{class:!0});var jn=b(E);p(Gt.$$.fragment,jn),Sn=o(jn),oe=a(jn,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-12fu8ku"&&(oe.textContent=Kl),jn.forEach(n),An=o(y),z=a(y,"DIV",{class:!0});var Jn=b(z);p(Qt.$$.fragment,Jn),Dn=o(Jn),re=a(Jn,"P",{"data-svelte-h":!0}),d(re)!=="svelte-crkk5y"&&(re.textContent=ts),Jn.forEach(n),Fn=o(y),L=a(y,"DIV",{class:!0});var Hn=b(L);p(Wt.$$.fragment,Hn),Yn=o(Hn),ae=a(Hn,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-d45cv9"&&(ae.textContent=es),Hn.forEach(n),y.forEach(n),wn=o(t),v=a(t,"DIV",{class:!0});var $=b(v);p(St.$$.fragment,$),On=o($),ie=a($,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1bq9un6"&&(ie.textContent=ns),Kn=o($),T=a($,"DIV",{class:!0});var ge=b(T);p(At.$$.fragment,ge),tl=o(ge),de=a(ge,"P",{"data-svelte-h":!0}),d(de)!=="svelte-ra5f94"&&(de.textContent=ls),el=o(ge),me=a(ge,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1mpvuud"&&(me.innerHTML=ss),ge.forEach(n),nl=o($),I=a($,"DIV",{class:!0});var qn=b(I);p(Dt.$$.fragment,qn),ll=o(qn),pe=a(qn,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-mmxwjp"&&(pe.textContent=os),qn.forEach(n),sl=o($),N=a($,"DIV",{class:!0});var En=b(N);p(Ft.$$.fragment,En),ol=o(En),he=a(En,"P",{"data-svelte-h":!0}),d(he)!=="svelte-8cca1z"&&(he.textContent=rs),En.forEach(n),rl=o($),V=a($,"DIV",{class:!0});var zn=b(V);p(Yt.$$.fragment,zn),al=o(zn),ue=a(zn,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-emvawv"&&(ue.textContent=as),zn.forEach(n),il=o($),X=a($,"DIV",{class:!0});var Ln=b(X);p(Ot.$$.fragment,Ln),dl=o(Ln),ce=a(Ln,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-13ama2g"&&(ce.textContent=is),Ln.forEach(n),ml=o($),B=a($,"DIV",{class:!0});var In=b(B);p(Kt.$$.fragment,In),pl=o(In),fe=a(In,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-vyrtkr"&&(fe.textContent=ds),In.forEach(n),$.forEach(n),Mn=o(t),ye=a(t,"P",{}),b(ye).forEach(n),this.h()},h(){x(_,"name","hf:doc:metadata"),x(_,"content",vs),hl(C,"text-align","center"),hl(k,"text-align","center"),hl(U,"text-align","center"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){i(document.head,_),l(t,be,e),l(t,ve,e),l(t,xe,e),h(R,t,e),l(t,$e,e),l(t,Z,e),l(t,we,e),l(t,C,e),l(t,Me,e),l(t,G,e),l(t,Te,e),h(Q,t,e),l(t,_e,e),l(t,W,e),l(t,Ce,e),h(S,t,e),l(t,ke,e),l(t,A,e),l(t,Ue,e),h(D,t,e),l(t,je,e),l(t,F,e),l(t,Je,e),h(Y,t,e),l(t,He,e),l(t,O,e),l(t,qe,e),h(K,t,e),l(t,Ee,e),l(t,tt,e),l(t,ze,e),h(et,t,e),l(t,Le,e),l(t,nt,e),l(t,Ie,e),h(lt,t,e),l(t,Ne,e),l(t,st,e),l(t,Ve,e),h(ot,t,e),l(t,Xe,e),l(t,rt,e),l(t,Be,e),l(t,at,e),l(t,Pe,e),h(it,t,e),l(t,Re,e),l(t,dt,e),l(t,Ze,e),l(t,mt,e),l(t,Ge,e),h(pt,t,e),l(t,Qe,e),h(ht,t,e),l(t,We,e),l(t,ut,e),l(t,Se,e),l(t,ct,e),l(t,Ae,e),l(t,ft,e),l(t,De,e),h(gt,t,e),l(t,Fe,e),l(t,vt,e),l(t,Ye,e),h(yt,t,e),l(t,Oe,e),l(t,bt,e),l(t,Ke,e),l(t,xt,e),l(t,tn,e),l(t,$t,e),l(t,en,e),l(t,wt,e),l(t,nn,e),l(t,Mt,e),l(t,ln,e),h(Tt,t,e),l(t,sn,e),l(t,_t,e),l(t,on,e),h(Ct,t,e),l(t,rn,e),h(kt,t,e),l(t,an,e),l(t,Ut,e),l(t,dn,e),h(jt,t,e),l(t,mn,e),l(t,Jt,e),l(t,pn,e),l(t,Ht,e),l(t,hn,e),l(t,qt,e),l(t,un,e),h(Et,t,e),l(t,cn,e),l(t,zt,e),l(t,fn,e),l(t,Lt,e),l(t,gn,e),l(t,k,e),l(t,vn,e),l(t,It,e),l(t,yn,e),l(t,U,e),l(t,bn,e),l(t,Nt,e),l(t,xn,e),h(Vt,t,e),l(t,$n,e),l(t,g,e),h(Xt,g,null),i(g,Nn),i(g,te),i(g,Vn),i(g,j),h(Bt,j,null),i(j,Xn),i(j,ee),i(g,Bn),i(g,J),h(Pt,J,null),i(J,Pn),i(J,ne),i(g,Rn),i(g,H),h(Rt,H,null),i(H,Zn),i(H,le),i(g,Gn),i(g,q),h(Zt,q,null),i(q,Qn),i(q,se),i(g,Wn),i(g,E),h(Gt,E,null),i(E,Sn),i(E,oe),i(g,An),i(g,z),h(Qt,z,null),i(z,Dn),i(z,re),i(g,Fn),i(g,L),h(Wt,L,null),i(L,Yn),i(L,ae),l(t,wn,e),l(t,v,e),h(St,v,null),i(v,On),i(v,ie),i(v,Kn),i(v,T),h(At,T,null),i(T,tl),i(T,de),i(T,el),i(T,me),i(v,nl),i(v,I),h(Dt,I,null),i(I,ll),i(I,pe),i(v,sl),i(v,N),h(Ft,N,null),i(N,ol),i(N,he),i(v,rl),i(v,V),h(Yt,V,null),i(V,al),i(V,ue),i(v,il),i(v,X),h(Ot,X,null),i(X,dl),i(X,ce),i(v,ml),i(v,B),h(Kt,B,null),i(B,pl),i(B,fe),l(t,Mn,e),l(t,ye,e),Tn=!0},p:ps,i(t){Tn||(u(R.$$.fragment,t),u(Q.$$.fragment,t),u(S.$$.fragment,t),u(D.$$.fragment,t),u(Y.$$.fragment,t),u(K.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(ot.$$.fragment,t),u(it.$$.fragment,t),u(pt.$$.fragment,t),u(ht.$$.fragment,t),u(gt.$$.fragment,t),u(yt.$$.fragment,t),u(Tt.$$.fragment,t),u(Ct.$$.fragment,t),u(kt.$$.fragment,t),u(jt.$$.fragment,t),u(Et.$$.fragment,t),u(Vt.$$.fragment,t),u(Xt.$$.fragment,t),u(Bt.$$.fragment,t),u(Pt.$$.fragment,t),u(Rt.$$.fragment,t),u(Zt.$$.fragment,t),u(Gt.$$.fragment,t),u(Qt.$$.fragment,t),u(Wt.$$.fragment,t),u(St.$$.fragment,t),u(At.$$.fragment,t),u(Dt.$$.fragment,t),u(Ft.$$.fragment,t),u(Yt.$$.fragment,t),u(Ot.$$.fragment,t),u(Kt.$$.fragment,t),Tn=!0)},o(t){c(R.$$.fragment,t),c(Q.$$.fragment,t),c(S.$$.fragment,t),c(D.$$.fragment,t),c(Y.$$.fragment,t),c(K.$$.fragment,t),c(et.$$.fragment,t),c(lt.$$.fragment,t),c(ot.$$.fragment,t),c(it.$$.fragment,t),c(pt.$$.fragment,t),c(ht.$$.fragment,t),c(gt.$$.fragment,t),c(yt.$$.fragment,t),c(Tt.$$.fragment,t),c(Ct.$$.fragment,t),c(kt.$$.fragment,t),c(jt.$$.fragment,t),c(Et.$$.fragment,t),c(Vt.$$.fragment,t),c(Xt.$$.fragment,t),c(Bt.$$.fragment,t),c(Pt.$$.fragment,t),c(Rt.$$.fragment,t),c(Zt.$$.fragment,t),c(Gt.$$.fragment,t),c(Qt.$$.fragment,t),c(Wt.$$.fragment,t),c(St.$$.fragment,t),c(At.$$.fragment,t),c(Dt.$$.fragment,t),c(Ft.$$.fragment,t),c(Yt.$$.fragment,t),c(Ot.$$.fragment,t),c(Kt.$$.fragment,t),Tn=!1},d(t){t&&(n(be),n(ve),n(xe),n($e),n(Z),n(we),n(C),n(Me),n(G),n(Te),n(_e),n(W),n(Ce),n(ke),n(A),n(Ue),n(je),n(F),n(Je),n(He),n(O),n(qe),n(Ee),n(tt),n(ze),n(Le),n(nt),n(Ie),n(Ne),n(st),n(Ve),n(Xe),n(rt),n(Be),n(at),n(Pe),n(Re),n(dt),n(Ze),n(mt),n(Ge),n(Qe),n(We),n(ut),n(Se),n(ct),n(Ae),n(ft),n(De),n(Fe),n(vt),n(Ye),n(Oe),n(bt),n(Ke),n(xt),n(tn),n($t),n(en),n(wt),n(nn),n(Mt),n(ln),n(sn),n(_t),n(on),n(rn),n(an),n(Ut),n(dn),n(mn),n(Jt),n(pn),n(Ht),n(hn),n(qt),n(un),n(cn),n(zt),n(fn),n(Lt),n(gn),n(k),n(vn),n(It),n(yn),n(U),n(bn),n(Nt),n(xn),n($n),n(g),n(wn),n(v),n(Mn),n(ye)),n(_),f(R,t),f(Q,t),f(S,t),f(D,t),f(Y,t),f(K,t),f(et,t),f(lt,t),f(ot,t),f(it,t),f(pt,t),f(ht,t),f(gt,t),f(yt,t),f(Tt,t),f(Ct,t),f(kt,t),f(jt,t),f(Et,t),f(Vt,t),f(Xt),f(Bt),f(Pt),f(Rt),f(Zt),f(Gt),f(Qt),f(Wt),f(St),f(At),f(Dt),f(Ft),f(Yt),f(Ot),f(Kt)}}}const vs='{"title":"Text Environments","local":"text-environments","sections":[{"title":"Tools","local":"tools","sections":[{"title":"transformers.Tool","local":"transformerstool","sections":[],"depth":3},{"title":"Custom Tools","local":"custom-tools","sections":[],"depth":3},{"title":"Call syntax","local":"call-syntax","sections":[],"depth":3}],"depth":2},{"title":"Create a TextEnvironment","local":"create-a-textenvironment","sections":[],"depth":2},{"title":"Run an Episode","local":"run-an-episode","sections":[{"title":"Train","local":"train","sections":[],"depth":3}],"depth":2},{"title":"TextHistory","local":"texthistory","sections":[{"title":"Attributes","local":"attributes","sections":[],"depth":3},{"title":"Visualization","local":"visualization","sections":[],"depth":3}],"depth":2},{"title":"API Documentation","local":"trl.TextEnvironment","sections":[],"depth":2}],"depth":1}';function ys(ul){return hs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ts extends us{constructor(_){super(),cs(this,_,ys,gs,ms,{})}}export{Ts as component};
