import{s as Do,o as Ro,n as ae}from"../chunks/scheduler.182ea377.js";import{S as Qo,i as Xo,g as l,s as a,r as g,A as zo,h as d,f as i,c as o,j as M,u,x as y,k as I,y as t,a as p,v as f,d as _,t as h,w as b}from"../chunks/index.abf12888.js";import{T as No}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.81ce6c10.js";import{C as xe}from"../chunks/CodeBlock.57fe6e13.js";import{E as Te}from"../chunks/ExampleCodeBlock.6db7157e.js";import{H as N,E as Fo}from"../chunks/EditOnGithub.9b8e78e4.js";function Yo(T){let s,w='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){s=l("p"),s.innerHTML=w},l(m){s=d(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1nfky5i"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:ae,d(m){m&&i(s)}}}function So(T){let s,w='Make sure to check out the schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=l("p"),s.innerHTML=w},l(m){s=d(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1rr33yw"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:ae,d(m){m&&i(s)}}}function Ho(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2VfZW1iJTJDJTIwbmVnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpLnRvX3R1cGxlKCklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2UlNUIwJTVELnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, negative_image_emb = pipe_prior(prompt).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Ao(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQW91dCUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RvdXQuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzdGFycnlfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior.interpolate(images_texts, weights)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=out.image_embeds,
<span class="hljs-meta">... </span>    negative_image_embeds=out.negative_image_embeds,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Oo(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQXplcm9faW1hZ2VfZW1iJTIwJTNEJTIwb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lWMjJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>zero_image_emb = out.negative_image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ei(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbGlvbiUyMGluJTIwZ2FsYXhpZXMlMkMlMjBzcGlyYWxzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwc21va2UlMkMlMjBpcmlkZXNjZW50JTJDJTIwaW50cmljYXRlJTIwZGV0YWlsJTJDJTIwb2N0YW5lJTIwcmVuZGVyJTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ni(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycmVkJTIwY2F0JTJDJTIwNGslMjBwaG90byUyMiUwQWltZyUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBaW1hZ2VfZW1iJTJDJTIwbmFnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltZyUyQyUyMHN0cmVuZ3RoJTNEMC4yKS50b190dXBsZSgpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTIyJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorEmb2EmbPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, nagative_image_emb = pipe_prior(prompt, image=img, strength=<span class="hljs-number">0.2</span>).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder, torch_dtype=torch.float16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ti(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yRW1iMkVtYlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMFBJTCUwQSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBaW1nMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRnN0YXJyeV9uaWdodC5qcGVnJTIyJTBBKSUwQSUwQWltYWdlc190ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjIlMkMlMjBpbWcxJTJDJTIwaW1nMiU1RCUwQXdlaWdodHMlMjAlM0QlMjAlNUIwLjMlMkMlMjAwLjMlMkMlMjAwLjQlNUQlMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ai(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function oi(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXItaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3klMkZjYXQucG5nJTIyJTBBKSUwQSUwQW1hc2slMjAlM0QlMjBucC56ZXJvcygoNzY4JTJDJTIwNzY4KSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMEElMjMlMjBMZXQncyUyMG1hc2slMjBvdXQlMjBhbiUyMGFyZWElMjBhYm92ZSUyMHRoZSUyMGNhdCdzJTIwaGVhZCUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=l("p"),s.textContent=w,m=a(),g(c.$$.fragment)},l(n){s=d(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=o(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:ae,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ii(T){let s,w,m,c,k,n,v,Ha='Kandinsky 2.2 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',ct,Ce,Aa="The description from it’s GitHub page is:",pt,Ve,Oa="<em>Kandinsky 2.2 brings substantial improvements upon its predecessor, Kandinsky 2.1, by introducing a new, more powerful image encoder - CLIP-ViT-G and the ControlNet support. The switch to CLIP-ViT-G as the image encoder significantly increases the model’s capability to generate more aesthetic pictures and better understand text, thus enhancing the model’s overall performance. The addition of the ControlNet mechanism allows the model to effectively control the process of generating images. This leads to more accurate and visually appealing outputs and opens new possibilities for text-guided image manipulation.</em>",mt,Je,eo='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',gt,de,ut,ce,ft,je,_t,C,Ue,Et,_n,no="Pipeline for generating image prior for Kandinsky",Nt,hn,to=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Dt,D,$e,Rt,bn,ao="Function invoked when calling the pipeline for generation.",Qt,pe,Xt,R,Ze,zt,yn,oo="Function invoked when using the prior pipeline for interpolation.",Ft,me,ht,We,bt,U,Ke,Yt,kn,io="Pipeline for text-to-image generation using Kandinsky",St,vn,so=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ht,Q,Ge,At,wn,ro="Function invoked when calling the pipeline for generation.",Ot,ge,yt,qe,kt,V,Le,ea,Mn,lo="Combined Pipeline for text-to-image generation using Kandinsky",na,In,co=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ta,X,Be,aa,Pn,po="Function invoked when calling the pipeline for generation.",oa,ue,ia,fe,Ee,sa,Tn,mo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,vt,Ne,wt,$,De,ra,xn,go="Pipeline for text-to-image generation using Kandinsky",la,Cn,uo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,da,z,Re,ca,Vn,fo="Function invoked when calling the pipeline for generation.",pa,Jn,_o="Examples:",Mt,Qe,It,J,Xe,ma,jn,ho="Pipeline for generating image prior for Kandinsky",ga,Un,bo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ua,F,ze,fa,$n,yo="Function invoked when calling the pipeline for generation.",_a,_e,ha,Y,Fe,ba,Zn,ko="Function invoked when using the prior pipeline for interpolation.",ya,he,Pt,Ye,Tt,Z,Se,ka,Wn,vo="Pipeline for image-to-image generation using Kandinsky",va,Kn,wo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,wa,S,He,Ma,Gn,Mo="Function invoked when calling the pipeline for generation.",Ia,qn,Io="Examples:",xt,Ae,Ct,x,Oe,Pa,Ln,Po="Combined Pipeline for image-to-image generation using Kandinsky",Ta,Bn,To=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,xa,H,en,Ca,En,xo="Function invoked when calling the pipeline for generation.",Va,be,Ja,ye,nn,ja,Nn,Co=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Ua,ke,tn,$a,Dn,Vo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Vt,an,Jt,W,on,Za,Rn,Jo="Pipeline for image-to-image generation using Kandinsky",Wa,Qn,jo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ka,A,sn,Ga,Xn,Uo="Function invoked when calling the pipeline for generation.",qa,zn,$o="Examples:",jt,rn,Ut,K,ln,La,Fn,Zo="Pipeline for text-guided image inpainting using Kandinsky2.1",Ba,Yn,Wo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ea,O,dn,Na,Sn,Ko="Function invoked when calling the pipeline for generation.",Da,Hn,Go="Examples:",$t,cn,Zt,j,pn,Ra,An,qo="Combined Pipeline for inpainting generation using Kandinsky",Qa,On,Lo=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Xa,ee,mn,za,et,Bo="Function invoked when calling the pipeline for generation.",Fa,ve,Ya,we,gn,Sa,nt,Eo=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Wt,un,Kt,dt,Gt;return k=new N({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h1"}}),de=new No({props:{$$slots:{default:[Yo]},$$scope:{ctx:T}}}),ce=new No({props:{$$slots:{default:[So]},$$scope:{ctx:T}}}),je=new N({props:{title:"KandinskyV22PriorPipeline",local:"diffusers.KandinskyV22PriorPipeline",headingTag:"h2"}}),Ue=new P({props:{name:"class diffusers.KandinskyV22PriorPipeline",anchor:"diffusers.KandinskyV22PriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L84"}}),$e=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L370",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.example",$$slots:{default:[Ho]},$$scope:{ctx:T}}}),Ze=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.Tensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L131",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),me=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.example",$$slots:{default:[Ao]},$$scope:{ctx:T}}}),We=new N({props:{title:"KandinskyV22Pipeline",local:"diffusers.KandinskyV22Pipeline",headingTag:"h2"}}),Ke=new P({props:{name:"class diffusers.KandinskyV22Pipeline",anchor:"diffusers.KandinskyV22Pipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Pipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L64"}}),Ge=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Pipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L122",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Te({props:{anchor:"diffusers.KandinskyV22Pipeline.__call__.example",$$slots:{default:[Oo]},$$scope:{ctx:T}}}),qe=new N({props:{title:"KandinskyV22CombinedPipeline",local:"diffusers.KandinskyV22CombinedPipeline",headingTag:"h2"}}),Le=new P({props:{name:"class diffusers.KandinskyV22CombinedPipeline",anchor:"diffusers.KandinskyV22CombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22CombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L107"}}),Be=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22CombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the prior pipeline.
The function is called with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your prior pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the decoder pipeline.
The function is called with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors
as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L202",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ue=new Te({props:{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.example",$$slots:{default:[ei]},$$scope:{ctx:T}}}),Ee=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22CombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L182"}}),Ne=new N({props:{title:"KandinskyV22ControlnetPipeline",local:"diffusers.KandinskyV22ControlnetPipeline",headingTag:"h2"}}),De=new P({props:{name:"class diffusers.KandinskyV22ControlnetPipeline",anchor:"diffusers.KandinskyV22ControlnetPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L106"}}),Re=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": Tensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.Tensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L151",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Qe=new N({props:{title:"KandinskyV22PriorEmb2EmbPipeline",local:"diffusers.KandinskyV22PriorEmb2EmbPipeline",headingTag:"h2"}}),Xe=new P({props:{name:"class diffusers.KandinskyV22PriorEmb2EmbPipeline",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L102"}}),ze=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"strength",val:": float = 0.3"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>emb</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added.`,name:"strength"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.emb",description:`<strong>emb</strong> (<code>torch.Tensor</code>) &#x2014;
The image embedding.`,name:"emb"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.example",$$slots:{default:[ni]},$$scope:{ctx:T}}}),Fe=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.Tensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L155",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),he=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.example",$$slots:{default:[ti]},$$scope:{ctx:T}}}),Ye=new N({props:{title:"KandinskyV22Img2ImgPipeline",local:"diffusers.KandinskyV22Img2ImgPipeline",headingTag:"h2"}}),Se=new P({props:{name:"class diffusers.KandinskyV22Img2ImgPipeline",anchor:"diffusers.KandinskyV22Img2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L92"}}),He=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L190",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Ae=new N({props:{title:"KandinskyV22Img2ImgCombinedPipeline",local:"diffusers.KandinskyV22Img2ImgCombinedPipeline",headingTag:"h2"}}),Oe=new P({props:{name:"class diffusers.KandinskyV22Img2ImgCombinedPipeline",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L335"}}),en=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L440",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),be=new Te({props:{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.example",$$slots:{default:[ai]},$$scope:{ctx:T}}}),nn=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L410"}}),tn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L420"}}),an=new N({props:{title:"KandinskyV22ControlnetImg2ImgPipeline",local:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",headingTag:"h2"}}),on=new P({props:{name:"class diffusers.KandinskyV22ControlnetImg2ImgPipeline",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L120"}}),sn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": Tensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.Tensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L206",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),rn=new N({props:{title:"KandinskyV22InpaintPipeline",local:"diffusers.KandinskyV22InpaintPipeline",headingTag:"h2"}}),ln=new P({props:{name:"class diffusers.KandinskyV22InpaintPipeline",anchor:"diffusers.KandinskyV22InpaintPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L235"}}),dn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.Tensor</code> or <code>List[torch.Tensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L294",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),cn=new N({props:{title:"KandinskyV22InpaintCombinedPipeline",local:"diffusers.KandinskyV22InpaintCombinedPipeline",headingTag:"h2"}}),pn=new P({props:{name:"class diffusers.KandinskyV22InpaintCombinedPipeline",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/main/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/main/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonical unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L584"}}),mn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L679",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_unclip#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ve=new Te({props:{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.example",$$slots:{default:[oi]},$$scope:{ctx:T}}}),gn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L659"}}),un=new Fo({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/kandinsky_v22.md"}}),{c(){s=l("meta"),w=a(),m=l("p"),c=a(),g(k.$$.fragment),n=a(),v=l("p"),v.innerHTML=Ha,ct=a(),Ce=l("p"),Ce.textContent=Aa,pt=a(),Ve=l("p"),Ve.innerHTML=Oa,mt=a(),Je=l("p"),Je.innerHTML=eo,gt=a(),g(de.$$.fragment),ut=a(),g(ce.$$.fragment),ft=a(),g(je.$$.fragment),_t=a(),C=l("div"),g(Ue.$$.fragment),Et=a(),_n=l("p"),_n.textContent=no,Nt=a(),hn=l("p"),hn.innerHTML=to,Dt=a(),D=l("div"),g($e.$$.fragment),Rt=a(),bn=l("p"),bn.textContent=ao,Qt=a(),g(pe.$$.fragment),Xt=a(),R=l("div"),g(Ze.$$.fragment),zt=a(),yn=l("p"),yn.textContent=oo,Ft=a(),g(me.$$.fragment),ht=a(),g(We.$$.fragment),bt=a(),U=l("div"),g(Ke.$$.fragment),Yt=a(),kn=l("p"),kn.textContent=io,St=a(),vn=l("p"),vn.innerHTML=so,Ht=a(),Q=l("div"),g(Ge.$$.fragment),At=a(),wn=l("p"),wn.textContent=ro,Ot=a(),g(ge.$$.fragment),yt=a(),g(qe.$$.fragment),kt=a(),V=l("div"),g(Le.$$.fragment),ea=a(),Mn=l("p"),Mn.textContent=lo,na=a(),In=l("p"),In.innerHTML=co,ta=a(),X=l("div"),g(Be.$$.fragment),aa=a(),Pn=l("p"),Pn.textContent=po,oa=a(),g(ue.$$.fragment),ia=a(),fe=l("div"),g(Ee.$$.fragment),sa=a(),Tn=l("p"),Tn.innerHTML=mo,vt=a(),g(Ne.$$.fragment),wt=a(),$=l("div"),g(De.$$.fragment),ra=a(),xn=l("p"),xn.textContent=go,la=a(),Cn=l("p"),Cn.innerHTML=uo,da=a(),z=l("div"),g(Re.$$.fragment),ca=a(),Vn=l("p"),Vn.textContent=fo,pa=a(),Jn=l("p"),Jn.textContent=_o,Mt=a(),g(Qe.$$.fragment),It=a(),J=l("div"),g(Xe.$$.fragment),ma=a(),jn=l("p"),jn.textContent=ho,ga=a(),Un=l("p"),Un.innerHTML=bo,ua=a(),F=l("div"),g(ze.$$.fragment),fa=a(),$n=l("p"),$n.textContent=yo,_a=a(),g(_e.$$.fragment),ha=a(),Y=l("div"),g(Fe.$$.fragment),ba=a(),Zn=l("p"),Zn.textContent=ko,ya=a(),g(he.$$.fragment),Pt=a(),g(Ye.$$.fragment),Tt=a(),Z=l("div"),g(Se.$$.fragment),ka=a(),Wn=l("p"),Wn.textContent=vo,va=a(),Kn=l("p"),Kn.innerHTML=wo,wa=a(),S=l("div"),g(He.$$.fragment),Ma=a(),Gn=l("p"),Gn.textContent=Mo,Ia=a(),qn=l("p"),qn.textContent=Io,xt=a(),g(Ae.$$.fragment),Ct=a(),x=l("div"),g(Oe.$$.fragment),Pa=a(),Ln=l("p"),Ln.textContent=Po,Ta=a(),Bn=l("p"),Bn.innerHTML=To,xa=a(),H=l("div"),g(en.$$.fragment),Ca=a(),En=l("p"),En.textContent=xo,Va=a(),g(be.$$.fragment),Ja=a(),ye=l("div"),g(nn.$$.fragment),ja=a(),Nn=l("p"),Nn.innerHTML=Co,Ua=a(),ke=l("div"),g(tn.$$.fragment),$a=a(),Dn=l("p"),Dn.innerHTML=Vo,Vt=a(),g(an.$$.fragment),Jt=a(),W=l("div"),g(on.$$.fragment),Za=a(),Rn=l("p"),Rn.textContent=Jo,Wa=a(),Qn=l("p"),Qn.innerHTML=jo,Ka=a(),A=l("div"),g(sn.$$.fragment),Ga=a(),Xn=l("p"),Xn.textContent=Uo,qa=a(),zn=l("p"),zn.textContent=$o,jt=a(),g(rn.$$.fragment),Ut=a(),K=l("div"),g(ln.$$.fragment),La=a(),Fn=l("p"),Fn.textContent=Zo,Ba=a(),Yn=l("p"),Yn.innerHTML=Wo,Ea=a(),O=l("div"),g(dn.$$.fragment),Na=a(),Sn=l("p"),Sn.textContent=Ko,Da=a(),Hn=l("p"),Hn.textContent=Go,$t=a(),g(cn.$$.fragment),Zt=a(),j=l("div"),g(pn.$$.fragment),Ra=a(),An=l("p"),An.textContent=qo,Qa=a(),On=l("p"),On.innerHTML=Lo,Xa=a(),ee=l("div"),g(mn.$$.fragment),za=a(),et=l("p"),et.textContent=Bo,Fa=a(),g(ve.$$.fragment),Ya=a(),we=l("div"),g(gn.$$.fragment),Sa=a(),nt=l("p"),nt.innerHTML=Eo,Wt=a(),g(un.$$.fragment),Kt=a(),dt=l("p"),this.h()},l(e){const r=zo("svelte-u9bgzb",document.head);s=d(r,"META",{name:!0,content:!0}),r.forEach(i),w=o(e),m=d(e,"P",{}),M(m).forEach(i),c=o(e),u(k.$$.fragment,e),n=o(e),v=d(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1a9feuc"&&(v.innerHTML=Ha),ct=o(e),Ce=d(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1og8lwg"&&(Ce.textContent=Aa),pt=o(e),Ve=d(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-xseaz5"&&(Ve.innerHTML=Oa),mt=o(e),Je=d(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-14rg3yz"&&(Je.innerHTML=eo),gt=o(e),u(de.$$.fragment,e),ut=o(e),u(ce.$$.fragment,e),ft=o(e),u(je.$$.fragment,e),_t=o(e),C=d(e,"DIV",{class:!0});var G=M(C);u(Ue.$$.fragment,G),Et=o(G),_n=d(G,"P",{"data-svelte-h":!0}),y(_n)!=="svelte-gfz7tn"&&(_n.textContent=no),Nt=o(G),hn=d(G,"P",{"data-svelte-h":!0}),y(hn)!=="svelte-wu1jmh"&&(hn.innerHTML=to),Dt=o(G),D=d(G,"DIV",{class:!0});var oe=M(D);u($e.$$.fragment,oe),Rt=o(oe),bn=d(oe,"P",{"data-svelte-h":!0}),y(bn)!=="svelte-v78lg8"&&(bn.textContent=ao),Qt=o(oe),u(pe.$$.fragment,oe),oe.forEach(i),Xt=o(G),R=d(G,"DIV",{class:!0});var ie=M(R);u(Ze.$$.fragment,ie),zt=o(ie),yn=d(ie,"P",{"data-svelte-h":!0}),y(yn)!=="svelte-1k7d7q8"&&(yn.textContent=oo),Ft=o(ie),u(me.$$.fragment,ie),ie.forEach(i),G.forEach(i),ht=o(e),u(We.$$.fragment,e),bt=o(e),U=d(e,"DIV",{class:!0});var B=M(U);u(Ke.$$.fragment,B),Yt=o(B),kn=d(B,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-jhhofy"&&(kn.textContent=io),St=o(B),vn=d(B,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-wu1jmh"&&(vn.innerHTML=so),Ht=o(B),Q=d(B,"DIV",{class:!0});var se=M(Q);u(Ge.$$.fragment,se),At=o(se),wn=d(se,"P",{"data-svelte-h":!0}),y(wn)!=="svelte-v78lg8"&&(wn.textContent=ro),Ot=o(se),u(ge.$$.fragment,se),se.forEach(i),B.forEach(i),yt=o(e),u(qe.$$.fragment,e),kt=o(e),V=d(e,"DIV",{class:!0});var q=M(V);u(Le.$$.fragment,q),ea=o(q),Mn=d(q,"P",{"data-svelte-h":!0}),y(Mn)!=="svelte-1spbql3"&&(Mn.textContent=lo),na=o(q),In=d(q,"P",{"data-svelte-h":!0}),y(In)!=="svelte-wu1jmh"&&(In.innerHTML=co),ta=o(q),X=d(q,"DIV",{class:!0});var re=M(X);u(Be.$$.fragment,re),aa=o(re),Pn=d(re,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-v78lg8"&&(Pn.textContent=po),oa=o(re),u(ue.$$.fragment,re),re.forEach(i),ia=o(q),fe=d(q,"DIV",{class:!0});var fn=M(fe);u(Ee.$$.fragment,fn),sa=o(fn),Tn=d(fn,"P",{"data-svelte-h":!0}),y(Tn)!=="svelte-1ff7ilh"&&(Tn.innerHTML=mo),fn.forEach(i),q.forEach(i),vt=o(e),u(Ne.$$.fragment,e),wt=o(e),$=d(e,"DIV",{class:!0});var E=M($);u(De.$$.fragment,E),ra=o(E),xn=d(E,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-jhhofy"&&(xn.textContent=go),la=o(E),Cn=d(E,"P",{"data-svelte-h":!0}),y(Cn)!=="svelte-wu1jmh"&&(Cn.innerHTML=uo),da=o(E),z=d(E,"DIV",{class:!0});var le=M(z);u(Re.$$.fragment,le),ca=o(le),Vn=d(le,"P",{"data-svelte-h":!0}),y(Vn)!=="svelte-v78lg8"&&(Vn.textContent=fo),pa=o(le),Jn=d(le,"P",{"data-svelte-h":!0}),y(Jn)!=="svelte-kvfsh7"&&(Jn.textContent=_o),le.forEach(i),E.forEach(i),Mt=o(e),u(Qe.$$.fragment,e),It=o(e),J=d(e,"DIV",{class:!0});var ne=M(J);u(Xe.$$.fragment,ne),ma=o(ne),jn=d(ne,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-gfz7tn"&&(jn.textContent=ho),ga=o(ne),Un=d(ne,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-wu1jmh"&&(Un.innerHTML=bo),ua=o(ne),F=d(ne,"DIV",{class:!0});var tt=M(F);u(ze.$$.fragment,tt),fa=o(tt),$n=d(tt,"P",{"data-svelte-h":!0}),y($n)!=="svelte-v78lg8"&&($n.textContent=yo),_a=o(tt),u(_e.$$.fragment,tt),tt.forEach(i),ha=o(ne),Y=d(ne,"DIV",{class:!0});var at=M(Y);u(Fe.$$.fragment,at),ba=o(at),Zn=d(at,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-1k7d7q8"&&(Zn.textContent=ko),ya=o(at),u(he.$$.fragment,at),at.forEach(i),ne.forEach(i),Pt=o(e),u(Ye.$$.fragment,e),Tt=o(e),Z=d(e,"DIV",{class:!0});var Me=M(Z);u(Se.$$.fragment,Me),ka=o(Me),Wn=d(Me,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-1nm2rj2"&&(Wn.textContent=vo),va=o(Me),Kn=d(Me,"P",{"data-svelte-h":!0}),y(Kn)!=="svelte-wu1jmh"&&(Kn.innerHTML=wo),wa=o(Me),S=d(Me,"DIV",{class:!0});var ot=M(S);u(He.$$.fragment,ot),Ma=o(ot),Gn=d(ot,"P",{"data-svelte-h":!0}),y(Gn)!=="svelte-v78lg8"&&(Gn.textContent=Mo),Ia=o(ot),qn=d(ot,"P",{"data-svelte-h":!0}),y(qn)!=="svelte-kvfsh7"&&(qn.textContent=Io),ot.forEach(i),Me.forEach(i),xt=o(e),u(Ae.$$.fragment,e),Ct=o(e),x=d(e,"DIV",{class:!0});var L=M(x);u(Oe.$$.fragment,L),Pa=o(L),Ln=d(L,"P",{"data-svelte-h":!0}),y(Ln)!=="svelte-1ql3mrb"&&(Ln.textContent=Po),Ta=o(L),Bn=d(L,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-wu1jmh"&&(Bn.innerHTML=To),xa=o(L),H=d(L,"DIV",{class:!0});var it=M(H);u(en.$$.fragment,it),Ca=o(it),En=d(it,"P",{"data-svelte-h":!0}),y(En)!=="svelte-v78lg8"&&(En.textContent=xo),Va=o(it),u(be.$$.fragment,it),it.forEach(i),Ja=o(L),ye=d(L,"DIV",{class:!0});var qt=M(ye);u(nn.$$.fragment,qt),ja=o(qt),Nn=d(qt,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-d7vywi"&&(Nn.innerHTML=Co),qt.forEach(i),Ua=o(L),ke=d(L,"DIV",{class:!0});var Lt=M(ke);u(tn.$$.fragment,Lt),$a=o(Lt),Dn=d(Lt,"P",{"data-svelte-h":!0}),y(Dn)!=="svelte-1ff7ilh"&&(Dn.innerHTML=Vo),Lt.forEach(i),L.forEach(i),Vt=o(e),u(an.$$.fragment,e),Jt=o(e),W=d(e,"DIV",{class:!0});var Ie=M(W);u(on.$$.fragment,Ie),Za=o(Ie),Rn=d(Ie,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-1nm2rj2"&&(Rn.textContent=Jo),Wa=o(Ie),Qn=d(Ie,"P",{"data-svelte-h":!0}),y(Qn)!=="svelte-wu1jmh"&&(Qn.innerHTML=jo),Ka=o(Ie),A=d(Ie,"DIV",{class:!0});var st=M(A);u(sn.$$.fragment,st),Ga=o(st),Xn=d(st,"P",{"data-svelte-h":!0}),y(Xn)!=="svelte-v78lg8"&&(Xn.textContent=Uo),qa=o(st),zn=d(st,"P",{"data-svelte-h":!0}),y(zn)!=="svelte-kvfsh7"&&(zn.textContent=$o),st.forEach(i),Ie.forEach(i),jt=o(e),u(rn.$$.fragment,e),Ut=o(e),K=d(e,"DIV",{class:!0});var Pe=M(K);u(ln.$$.fragment,Pe),La=o(Pe),Fn=d(Pe,"P",{"data-svelte-h":!0}),y(Fn)!=="svelte-2p9m8a"&&(Fn.textContent=Zo),Ba=o(Pe),Yn=d(Pe,"P",{"data-svelte-h":!0}),y(Yn)!=="svelte-wu1jmh"&&(Yn.innerHTML=Wo),Ea=o(Pe),O=d(Pe,"DIV",{class:!0});var rt=M(O);u(dn.$$.fragment,rt),Na=o(rt),Sn=d(rt,"P",{"data-svelte-h":!0}),y(Sn)!=="svelte-v78lg8"&&(Sn.textContent=Ko),Da=o(rt),Hn=d(rt,"P",{"data-svelte-h":!0}),y(Hn)!=="svelte-kvfsh7"&&(Hn.textContent=Go),rt.forEach(i),Pe.forEach(i),$t=o(e),u(cn.$$.fragment,e),Zt=o(e),j=d(e,"DIV",{class:!0});var te=M(j);u(pn.$$.fragment,te),Ra=o(te),An=d(te,"P",{"data-svelte-h":!0}),y(An)!=="svelte-ydcvxp"&&(An.textContent=qo),Qa=o(te),On=d(te,"P",{"data-svelte-h":!0}),y(On)!=="svelte-wu1jmh"&&(On.innerHTML=Lo),Xa=o(te),ee=d(te,"DIV",{class:!0});var lt=M(ee);u(mn.$$.fragment,lt),za=o(lt),et=d(lt,"P",{"data-svelte-h":!0}),y(et)!=="svelte-v78lg8"&&(et.textContent=Bo),Fa=o(lt),u(ve.$$.fragment,lt),lt.forEach(i),Ya=o(te),we=d(te,"DIV",{class:!0});var Bt=M(we);u(gn.$$.fragment,Bt),Sa=o(Bt),nt=d(Bt,"P",{"data-svelte-h":!0}),y(nt)!=="svelte-1ff7ilh"&&(nt.innerHTML=Eo),Bt.forEach(i),te.forEach(i),Wt=o(e),u(un.$$.fragment,e),Kt=o(e),dt=d(e,"P",{}),M(dt).forEach(i),this.h()},h(){I(s,"name","hf:doc:metadata"),I(s,"content",si),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){t(document.head,s),p(e,w,r),p(e,m,r),p(e,c,r),f(k,e,r),p(e,n,r),p(e,v,r),p(e,ct,r),p(e,Ce,r),p(e,pt,r),p(e,Ve,r),p(e,mt,r),p(e,Je,r),p(e,gt,r),f(de,e,r),p(e,ut,r),f(ce,e,r),p(e,ft,r),f(je,e,r),p(e,_t,r),p(e,C,r),f(Ue,C,null),t(C,Et),t(C,_n),t(C,Nt),t(C,hn),t(C,Dt),t(C,D),f($e,D,null),t(D,Rt),t(D,bn),t(D,Qt),f(pe,D,null),t(C,Xt),t(C,R),f(Ze,R,null),t(R,zt),t(R,yn),t(R,Ft),f(me,R,null),p(e,ht,r),f(We,e,r),p(e,bt,r),p(e,U,r),f(Ke,U,null),t(U,Yt),t(U,kn),t(U,St),t(U,vn),t(U,Ht),t(U,Q),f(Ge,Q,null),t(Q,At),t(Q,wn),t(Q,Ot),f(ge,Q,null),p(e,yt,r),f(qe,e,r),p(e,kt,r),p(e,V,r),f(Le,V,null),t(V,ea),t(V,Mn),t(V,na),t(V,In),t(V,ta),t(V,X),f(Be,X,null),t(X,aa),t(X,Pn),t(X,oa),f(ue,X,null),t(V,ia),t(V,fe),f(Ee,fe,null),t(fe,sa),t(fe,Tn),p(e,vt,r),f(Ne,e,r),p(e,wt,r),p(e,$,r),f(De,$,null),t($,ra),t($,xn),t($,la),t($,Cn),t($,da),t($,z),f(Re,z,null),t(z,ca),t(z,Vn),t(z,pa),t(z,Jn),p(e,Mt,r),f(Qe,e,r),p(e,It,r),p(e,J,r),f(Xe,J,null),t(J,ma),t(J,jn),t(J,ga),t(J,Un),t(J,ua),t(J,F),f(ze,F,null),t(F,fa),t(F,$n),t(F,_a),f(_e,F,null),t(J,ha),t(J,Y),f(Fe,Y,null),t(Y,ba),t(Y,Zn),t(Y,ya),f(he,Y,null),p(e,Pt,r),f(Ye,e,r),p(e,Tt,r),p(e,Z,r),f(Se,Z,null),t(Z,ka),t(Z,Wn),t(Z,va),t(Z,Kn),t(Z,wa),t(Z,S),f(He,S,null),t(S,Ma),t(S,Gn),t(S,Ia),t(S,qn),p(e,xt,r),f(Ae,e,r),p(e,Ct,r),p(e,x,r),f(Oe,x,null),t(x,Pa),t(x,Ln),t(x,Ta),t(x,Bn),t(x,xa),t(x,H),f(en,H,null),t(H,Ca),t(H,En),t(H,Va),f(be,H,null),t(x,Ja),t(x,ye),f(nn,ye,null),t(ye,ja),t(ye,Nn),t(x,Ua),t(x,ke),f(tn,ke,null),t(ke,$a),t(ke,Dn),p(e,Vt,r),f(an,e,r),p(e,Jt,r),p(e,W,r),f(on,W,null),t(W,Za),t(W,Rn),t(W,Wa),t(W,Qn),t(W,Ka),t(W,A),f(sn,A,null),t(A,Ga),t(A,Xn),t(A,qa),t(A,zn),p(e,jt,r),f(rn,e,r),p(e,Ut,r),p(e,K,r),f(ln,K,null),t(K,La),t(K,Fn),t(K,Ba),t(K,Yn),t(K,Ea),t(K,O),f(dn,O,null),t(O,Na),t(O,Sn),t(O,Da),t(O,Hn),p(e,$t,r),f(cn,e,r),p(e,Zt,r),p(e,j,r),f(pn,j,null),t(j,Ra),t(j,An),t(j,Qa),t(j,On),t(j,Xa),t(j,ee),f(mn,ee,null),t(ee,za),t(ee,et),t(ee,Fa),f(ve,ee,null),t(j,Ya),t(j,we),f(gn,we,null),t(we,Sa),t(we,nt),p(e,Wt,r),f(un,e,r),p(e,Kt,r),p(e,dt,r),Gt=!0},p(e,[r]){const G={};r&2&&(G.$$scope={dirty:r,ctx:e}),de.$set(G);const oe={};r&2&&(oe.$$scope={dirty:r,ctx:e}),ce.$set(oe);const ie={};r&2&&(ie.$$scope={dirty:r,ctx:e}),pe.$set(ie);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),me.$set(B);const se={};r&2&&(se.$$scope={dirty:r,ctx:e}),ge.$set(se);const q={};r&2&&(q.$$scope={dirty:r,ctx:e}),ue.$set(q);const re={};r&2&&(re.$$scope={dirty:r,ctx:e}),_e.$set(re);const fn={};r&2&&(fn.$$scope={dirty:r,ctx:e}),he.$set(fn);const E={};r&2&&(E.$$scope={dirty:r,ctx:e}),be.$set(E);const le={};r&2&&(le.$$scope={dirty:r,ctx:e}),ve.$set(le)},i(e){Gt||(_(k.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(je.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(pe.$$.fragment,e),_(Ze.$$.fragment,e),_(me.$$.fragment,e),_(We.$$.fragment,e),_(Ke.$$.fragment,e),_(Ge.$$.fragment,e),_(ge.$$.fragment,e),_(qe.$$.fragment,e),_(Le.$$.fragment,e),_(Be.$$.fragment,e),_(ue.$$.fragment,e),_(Ee.$$.fragment,e),_(Ne.$$.fragment,e),_(De.$$.fragment,e),_(Re.$$.fragment,e),_(Qe.$$.fragment,e),_(Xe.$$.fragment,e),_(ze.$$.fragment,e),_(_e.$$.fragment,e),_(Fe.$$.fragment,e),_(he.$$.fragment,e),_(Ye.$$.fragment,e),_(Se.$$.fragment,e),_(He.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(en.$$.fragment,e),_(be.$$.fragment,e),_(nn.$$.fragment,e),_(tn.$$.fragment,e),_(an.$$.fragment,e),_(on.$$.fragment,e),_(sn.$$.fragment,e),_(rn.$$.fragment,e),_(ln.$$.fragment,e),_(dn.$$.fragment,e),_(cn.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(ve.$$.fragment,e),_(gn.$$.fragment,e),_(un.$$.fragment,e),Gt=!0)},o(e){h(k.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(je.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(pe.$$.fragment,e),h(Ze.$$.fragment,e),h(me.$$.fragment,e),h(We.$$.fragment,e),h(Ke.$$.fragment,e),h(Ge.$$.fragment,e),h(ge.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(ue.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(De.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(ze.$$.fragment,e),h(_e.$$.fragment,e),h(Fe.$$.fragment,e),h(he.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(He.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(en.$$.fragment,e),h(be.$$.fragment,e),h(nn.$$.fragment,e),h(tn.$$.fragment,e),h(an.$$.fragment,e),h(on.$$.fragment,e),h(sn.$$.fragment,e),h(rn.$$.fragment,e),h(ln.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(pn.$$.fragment,e),h(mn.$$.fragment,e),h(ve.$$.fragment,e),h(gn.$$.fragment,e),h(un.$$.fragment,e),Gt=!1},d(e){e&&(i(w),i(m),i(c),i(n),i(v),i(ct),i(Ce),i(pt),i(Ve),i(mt),i(Je),i(gt),i(ut),i(ft),i(_t),i(C),i(ht),i(bt),i(U),i(yt),i(kt),i(V),i(vt),i(wt),i($),i(Mt),i(It),i(J),i(Pt),i(Tt),i(Z),i(xt),i(Ct),i(x),i(Vt),i(Jt),i(W),i(jt),i(Ut),i(K),i($t),i(Zt),i(j),i(Wt),i(Kt),i(dt)),i(s),b(k,e),b(de,e),b(ce,e),b(je,e),b(Ue),b($e),b(pe),b(Ze),b(me),b(We,e),b(Ke),b(Ge),b(ge),b(qe,e),b(Le),b(Be),b(ue),b(Ee),b(Ne,e),b(De),b(Re),b(Qe,e),b(Xe),b(ze),b(_e),b(Fe),b(he),b(Ye,e),b(Se),b(He),b(Ae,e),b(Oe),b(en),b(be),b(nn),b(tn),b(an,e),b(on),b(sn),b(rn,e),b(ln),b(dn),b(cn,e),b(pn),b(mn),b(ve),b(gn),b(un,e)}}}const si='{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[{"title":"KandinskyV22PriorPipeline","local":"diffusers.KandinskyV22PriorPipeline","sections":[],"depth":2},{"title":"KandinskyV22Pipeline","local":"diffusers.KandinskyV22Pipeline","sections":[],"depth":2},{"title":"KandinskyV22CombinedPipeline","local":"diffusers.KandinskyV22CombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetPipeline","local":"diffusers.KandinskyV22ControlnetPipeline","sections":[],"depth":2},{"title":"KandinskyV22PriorEmb2EmbPipeline","local":"diffusers.KandinskyV22PriorEmb2EmbPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgPipeline","local":"diffusers.KandinskyV22Img2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgCombinedPipeline","local":"diffusers.KandinskyV22Img2ImgCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetImg2ImgPipeline","local":"diffusers.KandinskyV22ControlnetImg2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintPipeline","local":"diffusers.KandinskyV22InpaintPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintCombinedPipeline","local":"diffusers.KandinskyV22InpaintCombinedPipeline","sections":[],"depth":2}],"depth":1}';function ri(T){return Ro(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fi extends Qo{constructor(s){super(),Xo(this,s,ri,ii,Do,{})}}export{fi as component};
