import{s as Ut,n as It,o as $t}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as Bt,g as p,s as a,r as i,A as Wt,h as m,f as l,c as n,j as bt,u as o,x as d,k as ft,y as kt,a as e,v as c,d as r,t as h,w as M}from"../chunks/index.c9bcf812.js";import{C as Q}from"../chunks/CodeBlock.94efc595.js";import{H as _}from"../chunks/Heading.3c6e5b17.js";function Nt(rt){let J,R,V,X,j,A,w,ht='<strong>MnasNet</strong> is a type of convolutional neural network optimized for mobile devices that is discovered through mobile neural architecture search, which explicitly incorporates model latency into the main objective so that the search can identify a model that achieves a good trade-off between accuracy and latency. The main building block is an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual block</a> (from <a href="https://paperswithcode.com/method/mobilenetv2" rel="nofollow">MobileNetV2</a>).',F,g,z,y,Mt="To load a pretrained model:",H,T,S,u,dt="To load and preprocess the image:",L,b,D,f,Jt="To get the model predictions:",P,U,q,I,jt="To get the top-5 predictions class names:",K,$,O,Z,wt="Replace the model name with the variant you want to use, e.g. <code>mnasnet_100</code>. You can find the IDs in the model summaries at the top of this page.",tt,B,gt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,W,lt,k,yt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",et,N,at,G,Tt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,C,pt,x,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,v,it,E,ot,Y,ct;return j=new _({props:{title:"MnasNet",local:"mnasnet",headingTag:"h1"}}),g=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21uYXNuZXRfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW1vZGVsLmV2YWwoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),W=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW5hc25ldF8xMDAnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRE5VTV9GSU5FVFVORV9DTEFTU0VTKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mnasnet_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),C=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),v=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new Q({props:{code:"JTQwbWlzYyU3QnRhbjIwMTltbmFzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JNbmFzTmV0JTNBJTIwUGxhdGZvcm0tQXdhcmUlMjBOZXVyYWwlMjBBcmNoaXRlY3R1cmUlMjBTZWFyY2glMjBmb3IlMjBNb2JpbGUlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JNaW5neGluZyUyMFRhbiUyMGFuZCUyMEJvJTIwQ2hlbiUyMGFuZCUyMFJ1b21pbmclMjBQYW5nJTIwYW5kJTIwVmlqYXklMjBWYXN1ZGV2YW4lMjBhbmQlMjBNYXJrJTIwU2FuZGxlciUyMGFuZCUyMEFuZHJldyUyMEhvd2FyZCUyMGFuZCUyMFF1b2MlMjBWLiUyMExlJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxODA3LjExNjI2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{tan2019mnasnet,
      title={MnasNet: Platform-Aware Neural Architecture Search for Mobile}, 
      author={Mingxing Tan <span class="hljs-keyword">and </span><span class="hljs-keyword">Bo </span>Chen <span class="hljs-keyword">and </span>Ruoming Pang <span class="hljs-keyword">and </span>Vijay Vasudevan <span class="hljs-keyword">and </span>Mark Sandler <span class="hljs-keyword">and </span><span class="hljs-keyword">Andrew </span>Howard <span class="hljs-keyword">and </span>Quoc V. Le},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1807</span>.<span class="hljs-number">11626</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){J=p("meta"),R=a(),V=p("p"),X=a(),i(j.$$.fragment),A=a(),w=p("p"),w.innerHTML=ht,F=a(),i(g.$$.fragment),z=a(),y=p("p"),y.textContent=Mt,H=a(),i(T.$$.fragment),S=a(),u=p("p"),u.textContent=dt,L=a(),i(b.$$.fragment),D=a(),f=p("p"),f.textContent=Jt,P=a(),i(U.$$.fragment),q=a(),I=p("p"),I.textContent=jt,K=a(),i($.$$.fragment),O=a(),Z=p("p"),Z.innerHTML=wt,tt=a(),B=p("p"),B.innerHTML=gt,st=a(),i(W.$$.fragment),lt=a(),k=p("p"),k.textContent=yt,et=a(),i(N.$$.fragment),at=a(),G=p("p"),G.innerHTML=Tt,nt=a(),i(C.$$.fragment),pt=a(),x=p("p"),x.innerHTML=ut,mt=a(),i(v.$$.fragment),it=a(),i(E.$$.fragment),ot=a(),Y=p("p"),this.h()},l(t){const s=Wt("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(l),R=n(t),V=m(t,"P",{}),bt(V).forEach(l),X=n(t),o(j.$$.fragment,t),A=n(t),w=m(t,"P",{"data-svelte-h":!0}),d(w)!=="svelte-1b8hcw9"&&(w.innerHTML=ht),F=n(t),o(g.$$.fragment,t),z=n(t),y=m(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-18ywhxh"&&(y.textContent=Mt),H=n(t),o(T.$$.fragment,t),S=n(t),u=m(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1c2ipa8"&&(u.textContent=dt),L=n(t),o(b.$$.fragment,t),D=n(t),f=m(t,"P",{"data-svelte-h":!0}),d(f)!=="svelte-1n9qsq1"&&(f.textContent=Jt),P=n(t),o(U.$$.fragment,t),q=n(t),I=m(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19cnvx1"&&(I.textContent=jt),K=n(t),o($.$$.fragment,t),O=n(t),Z=m(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1jw4zc0"&&(Z.innerHTML=wt),tt=n(t),B=m(t,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1wmi3ea"&&(B.innerHTML=gt),st=n(t),o(W.$$.fragment,t),lt=n(t),k=m(t,"P",{"data-svelte-h":!0}),d(k)!=="svelte-9sr7nh"&&(k.textContent=yt),et=n(t),o(N.$$.fragment,t),at=n(t),G=m(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-1kguc51"&&(G.innerHTML=Tt),nt=n(t),o(C.$$.fragment,t),pt=n(t),x=m(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1n0coha"&&(x.innerHTML=ut),mt=n(t),o(v.$$.fragment,t),it=n(t),o(E.$$.fragment,t),ot=n(t),Y=m(t,"P",{}),bt(Y).forEach(l),this.h()},h(){ft(J,"name","hf:doc:metadata"),ft(J,"content",Gt)},m(t,s){kt(document.head,J),e(t,R,s),e(t,V,s),e(t,X,s),c(j,t,s),e(t,A,s),e(t,w,s),e(t,F,s),c(g,t,s),e(t,z,s),e(t,y,s),e(t,H,s),c(T,t,s),e(t,S,s),e(t,u,s),e(t,L,s),c(b,t,s),e(t,D,s),e(t,f,s),e(t,P,s),c(U,t,s),e(t,q,s),e(t,I,s),e(t,K,s),c($,t,s),e(t,O,s),e(t,Z,s),e(t,tt,s),e(t,B,s),e(t,st,s),c(W,t,s),e(t,lt,s),e(t,k,s),e(t,et,s),c(N,t,s),e(t,at,s),e(t,G,s),e(t,nt,s),c(C,t,s),e(t,pt,s),e(t,x,s),e(t,mt,s),c(v,t,s),e(t,it,s),c(E,t,s),e(t,ot,s),e(t,Y,s),ct=!0},p:It,i(t){ct||(r(j.$$.fragment,t),r(g.$$.fragment,t),r(T.$$.fragment,t),r(b.$$.fragment,t),r(U.$$.fragment,t),r($.$$.fragment,t),r(W.$$.fragment,t),r(N.$$.fragment,t),r(C.$$.fragment,t),r(v.$$.fragment,t),r(E.$$.fragment,t),ct=!0)},o(t){h(j.$$.fragment,t),h(g.$$.fragment,t),h(T.$$.fragment,t),h(b.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(W.$$.fragment,t),h(N.$$.fragment,t),h(C.$$.fragment,t),h(v.$$.fragment,t),h(E.$$.fragment,t),ct=!1},d(t){t&&(l(R),l(V),l(X),l(A),l(w),l(F),l(z),l(y),l(H),l(S),l(u),l(L),l(D),l(f),l(P),l(q),l(I),l(K),l(O),l(Z),l(tt),l(B),l(st),l(lt),l(k),l(et),l(at),l(G),l(nt),l(pt),l(x),l(mt),l(it),l(ot),l(Y)),l(J),M(j,t),M(g,t),M(T,t),M(b,t),M(U,t),M($,t),M(W,t),M(N,t),M(C,t),M(v,t),M(E,t)}}}const Gt='{"title":"MnasNet","local":"mnasnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Ct(rt){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vt extends Zt{constructor(J){super(),Bt(this,J,Ct,Nt,Ut,{})}}export{Vt as component};
