import{s as nl,n as Ml,o as pl}from"../chunks/scheduler.7da89386.js";import{S as yl,i as cl,g as o,s as e,r as p,A as il,h as w,f as a,c as n,j as tl,u as y,x as W,k as el,y as rl,a as t,v as c,d as i,t as r,w as J}from"../chunks/index.20910acc.js";import{C as X}from"../chunks/CodeBlock.cde23137.js";import{H as q,E as Jl}from"../chunks/EditOnGithub.ba36cbd0.js";function ol(L){let M,z,B,Y,m,g,j,P="Evaluate can be easily intergrated into your Keras and Tensorflow workflow. We’ll demonstrate two ways of incorporating Evaluate into model training, using the Fashion MNIST example dataset. We’ll train a standard classifier to predict two classes from this dataset, and show how to use a metric as a callback during training or afterwards for evaluation.",E,U,x,h,R,T,O="Suppose we want to keep track of model metrics while a model is training. We can use a Callback in order to calculate this metric during training, after an epoch ends.",Q,d,ll="We’ll define a callback here that will take a metric name and our training data, and have it calculate a metric after the epoch ends.",S,u,N,b,sl="We can pass this class to the <code>callbacks</code> keyword-argument to use it during training:",A,C,v,I,H,f,al="We can also use the same metric after model training! Here, we show how to check accuracy of the model after training on the test set:",$,_,F,k,V,Z,K,G,D;return m=new q({props:{title:"Working with Keras and Tensorflow",local:"working-with-keras-and-tensorflow",headingTag:"h1"}}),U=new X({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> tensorflow <span class="hljs-keyword">import</span> keras
<span class="hljs-keyword">from</span> tensorflow.keras <span class="hljs-keyword">import</span> layers
<span class="hljs-keyword">import</span> evaluate

<span class="hljs-comment"># We pull example code from Keras.io&#x27;s guide on classifying with MNIST</span>
<span class="hljs-comment"># Located here: https://keras.io/examples/vision/mnist_convnet/</span>

<span class="hljs-comment"># Model / data parameters</span>
input_shape = (<span class="hljs-number">28</span>, <span class="hljs-number">28</span>, <span class="hljs-number">1</span>)

<span class="hljs-comment"># Load the data and split it between train and test sets</span>
(x_train, y_train), (x_test, y_test) = keras.datasets.fashion_mnist.load_data()


<span class="hljs-comment"># Only select tshirts/tops and trousers, classes 0 and 1</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tshirts_tops_and_trouser</span>(<span class="hljs-params">x_vals, y_vals</span>):
    mask = np.where((y_vals == <span class="hljs-number">0</span>) | (y_vals == <span class="hljs-number">1</span>))
    <span class="hljs-keyword">return</span> x_vals[mask], y_vals[mask]

x_train, y_train = get_tshirts_tops_and_trouser(x_train, y_train)
x_test, y_test = get_tshirts_tops_and_trouser(x_test, y_test)


<span class="hljs-comment"># Scale images to the [0, 1] range</span>
x_train = x_train.astype(<span class="hljs-string">&quot;float32&quot;</span>) / <span class="hljs-number">255</span>
x_test = x_test.astype(<span class="hljs-string">&quot;float32&quot;</span>) / <span class="hljs-number">255</span>

x_train = np.expand_dims(x_train, -<span class="hljs-number">1</span>)
x_test = np.expand_dims(x_test, -<span class="hljs-number">1</span>)


model = keras.Sequential(
    [
        keras.Input(shape=input_shape),
        layers.Conv2D(<span class="hljs-number">32</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Conv2D(<span class="hljs-number">64</span>, kernel_size=(<span class="hljs-number">3</span>, <span class="hljs-number">3</span>), activation=<span class="hljs-string">&quot;relu&quot;</span>),
        layers.MaxPooling2D(pool_size=(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)),
        layers.Flatten(),
        layers.Dropout(<span class="hljs-number">0.5</span>),
        layers.Dense(<span class="hljs-number">1</span>, activation=<span class="hljs-string">&quot;sigmoid&quot;</span>),
    ]
)`,wrap:!1}}),h=new q({props:{title:"Callbacks",local:"callbacks",headingTag:"h2"}}),u=new X({props:{code:"Y2xhc3MlMjBNZXRyaWNzQ2FsbGJhY2soa2VyYXMuY2FsbGJhY2tzLkNhbGxiYWNrKSUzQSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtZXRyaWNfbmFtZSUyQyUyMHhfZGF0YSUyQyUyMHlfZGF0YSklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKE1ldHJpY3NDYWxsYmFjayUyQyUyMHNlbGYpLl9faW5pdF9fKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnhfZGF0YSUyMCUzRCUyMHhfZGF0YSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYueV9kYXRhJTIwJTNEJTIweV9kYXRhJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tZXRyaWNfbmFtZSUyMCUzRCUyMG1ldHJpY19uYW1lJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKG1ldHJpY19uYW1lKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMG9uX2Vwb2NoX2VuZChzZWxmJTJDJTIwZXBvY2glMkMlMjBsb2dzJTNEZGljdCgpKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG0lMjAlM0QlMjBzZWxmLm1vZGVsJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRW5zdXJlJTIwd2UlMjBnZXQlMjBsYWJlbHMlMjBvZiUyMCUyMjElMjIlMjBvciUyMCUyMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbmluZ19wcmVkcyUyMCUzRCUyMG5wLnJvdW5kKG0ucHJlZGljdChzZWxmLnhfZGF0YSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5pbmdfbGFiZWxzJTIwJTNEJTIwc2VsZi55X2RhdGElMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb21wdXRlJTIwc2NvcmUlMjBhbmQlMjBzYXZlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2NvcmUlMjAlM0QlMjBzZWxmLm1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTIwJTNEJTIwdHJhaW5pbmdfcHJlZHMlMkMlMjByZWZlcmVuY2VzJTIwJTNEJTIwdHJhaW5pbmdfbGFiZWxzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ3MudXBkYXRlKHNjb3JlKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MetricsCallback</span>(keras.callbacks.Callback):

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, metric_name, x_data, y_data</span>) -&gt; <span class="hljs-literal">None</span>:
        <span class="hljs-built_in">super</span>(MetricsCallback, self).__init__()

        self.x_data = x_data
        self.y_data = y_data
        self.metric_name = metric_name
        self.metric = evaluate.load(metric_name)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_epoch_end</span>(<span class="hljs-params">self, epoch, logs=<span class="hljs-built_in">dict</span>(<span class="hljs-params"></span>)</span>):
        m = self.model 
        <span class="hljs-comment"># Ensure we get labels of &quot;1&quot; or &quot;0&quot;</span>
        training_preds = np.<span class="hljs-built_in">round</span>(m.predict(self.x_data))
        training_labels = self.y_data

        <span class="hljs-comment"># Compute score and save</span>
        score = self.metric.compute(predictions = training_preds, references = training_labels)
        
        logs.update(score)`,wrap:!1}}),C=new X({props:{code:"YmF0Y2hfc2l6ZSUyMCUzRCUyMDEyOCUwQWVwb2NocyUyMCUzRCUyMDIlMEElMEFtb2RlbC5jb21waWxlKGxvc3MlM0QlMjJiaW5hcnlfY3Jvc3NlbnRyb3B5JTIyJTJDJTIwb3B0aW1pemVyJTNEJTIyYWRhbSUyMiklMEElMEFtb2RlbF9oaXN0b3J5JTIwJTNEJTIwbW9kZWwuZml0KHhfdHJhaW4lMkMlMjB5X3RyYWluJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBlcG9jaHMlM0RlcG9jaHMlMkMlMjB2YWxpZGF0aW9uX3NwbGl0JTNEMC4xJTJDJTIwJTBBY2FsbGJhY2tzJTIwJTNEJTIwJTVCTWV0cmljc0NhbGxiYWNrKHhfZGF0YSUyMCUzRCUyMHhfdHJhaW4lMkMlMjB5X2RhdGElMjAlM0QlMjB5X3RyYWluJTJDJTIwbWV0cmljX25hbWUlMjAlM0QlMjAlMjJhY2N1cmFjeSUyMiklNUQp",highlighted:`batch_size = <span class="hljs-number">128</span>
epochs = <span class="hljs-number">2</span>

model.<span class="hljs-built_in">compile</span>(loss=<span class="hljs-string">&quot;binary_crossentropy&quot;</span>, optimizer=<span class="hljs-string">&quot;adam&quot;</span>)

model_history = model.fit(x_train, y_train, batch_size=batch_size, epochs=epochs, validation_split=<span class="hljs-number">0.1</span>, 
callbacks = [MetricsCallback(x_data = x_train, y_data = y_train, metric_name = <span class="hljs-string">&quot;accuracy&quot;</span>)])`,wrap:!1}}),I=new q({props:{title:"Using an Evaluate Metric for… Evaluation!",local:"using-an-evaluate-metric-for-evaluation",headingTag:"h2"}}),_=new X({props:{code:"YWNjJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJhY2N1cmFjeSUyMiklMEElMjMlMjBSb3VuZCUyMHRoZSUyMHByZWRpY3Rpb25zJTIwdG8lMjB0dXJuJTIwdGhlbSUyMGludG8lMjAlMjIwJTIyJTIwb3IlMjAlMjIxJTIyJTIwbGFiZWxzJTBBdGVzdF9wcmVkcyUyMCUzRCUyMG5wLnJvdW5kKG1vZGVsLnByZWRpY3QoeF90ZXN0KSklMEF0ZXN0X2xhYmVscyUyMCUzRCUyMHlfdGVzdA==",highlighted:`acc = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-comment"># Round the predictions to turn them into &quot;0&quot; or &quot;1&quot; labels</span>
test_preds = np.<span class="hljs-built_in">round</span>(model.predict(x_test))
test_labels = y_test`,wrap:!1}}),k=new X({props:{code:"cHJpbnQoJTIyVGVzdCUyMGFjY3VyYWN5JTIwaXMlMjAlM0ElMjAlMjIlMkMlMjBhY2MuY29tcHV0ZShwcmVkaWN0aW9ucyUyMCUzRCUyMHRlc3RfcHJlZHMlMkMlMjByZWZlcmVuY2VzJTIwJTNEJTIwdGVzdF9sYWJlbHMpKSUwQSUyMyUyMFRlc3QlMjBhY2N1cmFjeSUyMGlzJTIwJTNBJTIwMC45ODU1",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Test accuracy is : &quot;</span>, acc.compute(predictions = test_preds, references = test_labels))
<span class="hljs-comment"># Test accuracy is : 0.9855</span>`,wrap:!1}}),Z=new Jl({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/keras_integrations.md"}}),{c(){M=o("meta"),z=e(),B=o("p"),Y=e(),p(m.$$.fragment),g=e(),j=o("p"),j.textContent=P,E=e(),p(U.$$.fragment),x=e(),p(h.$$.fragment),R=e(),T=o("p"),T.textContent=O,Q=e(),d=o("p"),d.textContent=ll,S=e(),p(u.$$.fragment),N=e(),b=o("p"),b.innerHTML=sl,A=e(),p(C.$$.fragment),v=e(),p(I.$$.fragment),H=e(),f=o("p"),f.textContent=al,$=e(),p(_.$$.fragment),F=e(),p(k.$$.fragment),V=e(),p(Z.$$.fragment),K=e(),G=o("p"),this.h()},l(l){const s=il("svelte-u9bgzb",document.head);M=w(s,"META",{name:!0,content:!0}),s.forEach(a),z=n(l),B=w(l,"P",{}),tl(B).forEach(a),Y=n(l),y(m.$$.fragment,l),g=n(l),j=w(l,"P",{"data-svelte-h":!0}),W(j)!=="svelte-dqtpg8"&&(j.textContent=P),E=n(l),y(U.$$.fragment,l),x=n(l),y(h.$$.fragment,l),R=n(l),T=w(l,"P",{"data-svelte-h":!0}),W(T)!=="svelte-1vmwzbw"&&(T.textContent=O),Q=n(l),d=w(l,"P",{"data-svelte-h":!0}),W(d)!=="svelte-1125oxi"&&(d.textContent=ll),S=n(l),y(u.$$.fragment,l),N=n(l),b=w(l,"P",{"data-svelte-h":!0}),W(b)!=="svelte-1ba9645"&&(b.innerHTML=sl),A=n(l),y(C.$$.fragment,l),v=n(l),y(I.$$.fragment,l),H=n(l),f=w(l,"P",{"data-svelte-h":!0}),W(f)!=="svelte-18qazw3"&&(f.textContent=al),$=n(l),y(_.$$.fragment,l),F=n(l),y(k.$$.fragment,l),V=n(l),y(Z.$$.fragment,l),K=n(l),G=w(l,"P",{}),tl(G).forEach(a),this.h()},h(){el(M,"name","hf:doc:metadata"),el(M,"content",wl)},m(l,s){rl(document.head,M),t(l,z,s),t(l,B,s),t(l,Y,s),c(m,l,s),t(l,g,s),t(l,j,s),t(l,E,s),c(U,l,s),t(l,x,s),c(h,l,s),t(l,R,s),t(l,T,s),t(l,Q,s),t(l,d,s),t(l,S,s),c(u,l,s),t(l,N,s),t(l,b,s),t(l,A,s),c(C,l,s),t(l,v,s),c(I,l,s),t(l,H,s),t(l,f,s),t(l,$,s),c(_,l,s),t(l,F,s),c(k,l,s),t(l,V,s),c(Z,l,s),t(l,K,s),t(l,G,s),D=!0},p:Ml,i(l){D||(i(m.$$.fragment,l),i(U.$$.fragment,l),i(h.$$.fragment,l),i(u.$$.fragment,l),i(C.$$.fragment,l),i(I.$$.fragment,l),i(_.$$.fragment,l),i(k.$$.fragment,l),i(Z.$$.fragment,l),D=!0)},o(l){r(m.$$.fragment,l),r(U.$$.fragment,l),r(h.$$.fragment,l),r(u.$$.fragment,l),r(C.$$.fragment,l),r(I.$$.fragment,l),r(_.$$.fragment,l),r(k.$$.fragment,l),r(Z.$$.fragment,l),D=!1},d(l){l&&(a(z),a(B),a(Y),a(g),a(j),a(E),a(x),a(R),a(T),a(Q),a(d),a(S),a(N),a(b),a(A),a(v),a(H),a(f),a($),a(F),a(V),a(K),a(G)),a(M),J(m,l),J(U,l),J(h,l),J(u,l),J(C,l),J(I,l),J(_,l),J(k,l),J(Z,l)}}}const wl='{"title":"Working with Keras and Tensorflow","local":"working-with-keras-and-tensorflow","sections":[{"title":"Callbacks","local":"callbacks","sections":[],"depth":2},{"title":"Using an Evaluate Metric for… Evaluation!","local":"using-an-evaluate-metric-for-evaluation","sections":[],"depth":2}],"depth":1}';function ml(L){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends yl{constructor(M){super(),cl(this,M,ml,ol,nl,{})}}export{dl as component};
