import{s as pa,o as ca,n as jt}from"../chunks/scheduler.6062bdaf.js";import{S as da,i as ua,g as o,s as l,r as w,A as wa,h as n,f as t,c as i,j as u,u as y,x as c,k as h,y as p,a as s,v as f,d as b,t as g,w as M}from"../chunks/index.4bca734e.js";import{T as Ut}from"../chunks/Tip.b9ac1f03.js";import{I as ye}from"../chunks/IconCopyLink.68a13644.js";import{C as Ze}from"../chunks/CodeBlock.f213e6a5.js";function ya(W){let r,v=`To see a running example of a webhook server, check out the <a href="https://huggingface.co/spaces/spaces-ci-bot/webhook" rel="nofollow">Spaces CI Bot</a>
one. It is a Space that launches ephemeral environments when a PR is opened on a Space.`;return{c(){r=o("p"),r.innerHTML=v},l(d){r=n(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-18sko4t"&&(r.innerHTML=v)},m(d,m){s(d,r,m)},p:jt,d(d){d&&t(r)}}}function fa(W){let r,v=`This is an <a href="../package_reference/environment_variables#hfhubdisableexperimentalwarning">experimental feature</a>. This
means that we are still working on improving the API. Breaking changes might be introduced in the future without prior
notice. Make sure to pin the version of <code>huggingface_hub</code> in your requirements.`;return{c(){r=o("p"),r.innerHTML=v},l(d){r=n(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-fuzk6g"&&(r.innerHTML=v)},m(d,m){s(d,r,m)},p:jt,d(d){d&&t(r)}}}function ba(W){let r,v=`By default, the server is started at the end of your script. If you are running it in a notebook, you can start the
server manually by calling <code>decorated_function.run()</code>. Since a unique server is used, you only have to start the server
once even if you have multiple endpoints.`;return{c(){r=o("p"),r.innerHTML=v},l(d){r=n(d,"P",{"data-svelte-h":!0}),c(r)!=="svelte-1jc349n"&&(r.innerHTML=v)},m(d,m){s(d,r,m)},p:jt,d(d){d&&t(r)}}}function ga(W){let r,v,d,m,Te,V,gt,fe,It="Webhooks Server",Ge,F,Wt=`Webhooks are a foundation for MLOps-related features. They allow you to listen for new changes on specific repos or to
all repos belonging to particular users/organizations you’re interested in following. This guide will explain how to
leverage <code>huggingface_hub</code> to create a server listening to webhooks and deploy it to a Space. It assumes you are
familiar with the concept of webhooks on the Huggingface Hub. To learn more about webhooks themselves, you can read
this <a href="https://huggingface.co/docs/hub/webhooks" rel="nofollow">guide</a> first.`,Se,E,_t=`The base class that we will use in this guide is <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. It is a class for easily configuring a server that
can receive webhooks from the Huggingface Hub. The server is based on a <a href="https://gradio.app/" rel="nofollow">Gradio</a> app. It has a UI
to display instructions for you or your users and an API to listen to webhooks.`,Be,_,He,C,xe,k,$,Je,R,Mt,be,Ct="Create an endpoint",Ye,N,$t=`Implementing a webhook endpoint is as simple as decorating a function. Let’s see a first example to explain the main
concepts:`,Ve,Q,Fe,X,Zt="Save this snippet in a file called <code>&#39;app.py&#39;</code> and run it with <code>&#39;python app.py&#39;</code>. You should see a message like this:",Ee,L,Re,z,Gt="Good job! You just launched a webhook server! Let’s break down what happened exactly:",Ne,P,St=`<li>By decorating a function with <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.webhook_endpoint">webhook_endpoint()</a>, a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object has been created in the background.
As you can see, this server is a Gradio app running on <a href="http://127.0.0.1:7860" rel="nofollow">http://127.0.0.1:7860</a>. If you open this URL in your browser, you
will see a landing page with instructions about the registered webhooks.</li> <li>A Gradio app is a FastAPI server under the hood. A new POST route <code>/webhooks/trigger_training</code> has been added to it.
This is the route that will listen to webhooks and run the <code>trigger_training</code> function when triggered. FastAPI will
automatically parse the payload and pass it to the function as a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhookPayload">WebhookPayload</a> object. This is a <code>pydantic</code> object
that contains all the information about the event that triggered the webhook.</li> <li>The Gradio app also opened a tunnel to receive requests from the internet. This is the interesting part: you can
configure a Webhook on <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a> pointing to your local machine. This is useful for
debugging your webhook server and quickly iterating before deploying it to a Space.</li> <li>Finally, the logs also tell you that your server is currently not secured by a secret. This is not problematic for
local debugging but is to keep in mind for later.</li>`,Qe,Z,Xe,T,G,Ue,A,mt,ge,Bt="Configure a Webhook",Le,q,Ht=`Now that you have a webhook server running, you want to configure a Webhook to start receiving messages.
Go to <a href="https://huggingface.co/settings/webhooks" rel="nofollow">https://huggingface.co/settings/webhooks</a>, click on “Add a new webhook” and configure your Webhook. Set the target
repositories you want to watch and the Webhook URL, here <code>https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training</code>.`,ze,S,xt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/configure_webhook.png"/>',Pe,O,Yt=`And that’s it! You can now trigger that webhook by updating the target repository (e.g. push a commit). Check the
Activity tab of your Webhook to see the events that have been triggered. Now that you have a working setup, you can
test it and quickly iterate. If you modify your code and restart the server, your public URL might change. Make sure
to update the webhook configuration on the Hub if needed.`,Ae,J,B,je,K,vt,Me,Vt="Deploy to a Space",qe,D,Ft=`Now that you have a working webhook server, the goal is to deploy it to a Space. Go to <a href="https://huggingface.co/new-space" rel="nofollow">https://huggingface.co/new-space</a>
to create a Space. Give it a name, select the Gradio SDK and click on “Create Space”. Upload your code to the Space
in a file called <code>app.py</code>. Your Space will start automatically! For more details about Spaces, please refer to this
<a href="https://huggingface.co/docs/hub/spaces-overview" rel="nofollow">guide</a>.`,Oe,ee,Et=`Your webhook server is now running on a public Space. If most cases, you will want to secure it with a secret. Go to
your Space settings &gt; Section “Repository secrets” &gt; “Add a secret”. Set the <code>WEBHOOK_SECRET</code> environment variable to
the value of your choice. Go back to the <a href="https://huggingface.co/settings/webhooks" rel="nofollow">Webhooks settings</a> and set the
secret in the webhook configuration. Now, only requests with the correct secret will be accepted by your server.`,Ke,te,Rt=`And this is it! Your Space is now ready to receive webhooks from the Hub. Please keep in mind that if you run the Space
on a free ‘cpu-basic’ hardware, it will be shut down after 48 hours of inactivity. If you need a permanent Space, you
should consider setting to an <a href="https://huggingface.co/docs/hub/spaces-gpus#hardware-specs" rel="nofollow">upgraded hardware</a>.`,De,U,H,Ie,ae,kt,me,Nt="Advanced usage",et,se,Qt=`The guide above explained the quickest way to setup a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>. In this section, we will see how to customize
it further.`,tt,j,x,We,oe,Tt,ve,Xt="Multiple endpoints",at,ne,Lt=`You can register multiple endpoints on the same server. For example, you might want to have one endpoint to trigger
a training job and another one to trigger a model evaluation. You can do this by adding multiple <code>@webhook_endpoint</code>
decorators:`,st,le,ot,ie,zt="Which will create two endpoints:",nt,re,lt,I,Y,_e,he,Jt,ke,Pt="Custom server",it,pe,At=`To get more flexibility, you can also create a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object directly. This is useful if you want to
customize the landing page of your server. You can do this by passing a <a href="https://gradio.app/docs/#blocks" rel="nofollow">Gradio UI</a>
that will overwrite the default one. For example, you can add instructions for your users or add a form to manually
trigger the webhooks. When creating a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a>, you can register new webhooks using the
<code>add_webhook()</code> decorator.`,rt,ce,qt="Here is a complete example:",ht,de,pt,ue,Ot=`<li>We define a custom UI using Gradio blocks. This UI will be displayed on the landing page of the server.</li> <li>We create a <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/webhooks_server#huggingface_hub.WebhooksServer">WebhooksServer()</a> object with a custom UI and a secret. The secret is optional and can be set with
the <code>WEBHOOK_SECRET</code> environment variable.</li> <li>We register a webhook with an explicit name. This will create an endpoint at <code>/webhooks/say_hello</code>.</li> <li>We register a webhook with an implicit name. This will create an endpoint at <code>/webhooks/goodbye</code>.</li> <li>We start the server. This is optional as your server will automatically be started at the end of the script.</li>`,ct;return V=new ye({}),_=new Ut({props:{$$slots:{default:[ya]},$$scope:{ctx:W}}}),C=new Ut({props:{warning:!0,$$slots:{default:[fa]},$$scope:{ctx:W}}}),R=new ye({}),Q=new Ze({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...`}}),L=new Ze({props:{code:"V2ViaG9vayUyMHNlY3JldCUyMGlzJTIwbm90JTIwZGVmaW5lZC4lMjBUaGlzJTIwbWVhbnMlMjB5b3VyJTIwd2ViaG9vayUyMGVuZHBvaW50cyUyMHdpbGwlMjBiZSUyMG9wZW4lMjB0byUyMGV2ZXJ5b25lLiUwQVRvJTIwYWRkJTIwYSUyMHNlY3JldCUyQyUyMHNldCUyMCU2MFdFQkhPT0tfU0VDUkVUJTYwJTIwYXMlMjBlbnZpcm9ubWVudCUyMHZhcmlhYmxlJTIwb3IlMjBwYXNzJTIwaXQlMjBhdCUyMGluaXRpYWxpemF0aW9uJTNBJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTYwYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIod2ViaG9va19zZWNyZXQlM0QnbXlfc2VjcmV0JyUyQyUyMC4uLiklNjAlMEFGb3IlMjBtb3JlJTIwZGV0YWlscyUyMGFib3V0JTIwd2ViaG9vayUyMHNlY3JldHMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZ3ZWJob29rcyUyM3dlYmhvb2stc2VjcmV0LiUwQVJ1bm5pbmclMjBvbiUyMGxvY2FsJTIwVVJMJTNBJTIwJTIwaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTc4NjAlMEFSdW5uaW5nJTIwb24lMjBwdWJsaWMlMjBVUkwlM0ElMjBodHRwcyUzQSUyRiUyRjFmYWRiMGY1MmQ4YmY4MjVmYy5ncmFkaW8ubGl2ZSUwQSUwQVRoaXMlMjBzaGFyZSUyMGxpbmslMjBleHBpcmVzJTIwaW4lMjA3MiUyMGhvdXJzLiUyMEZvciUyMGZyZWUlMjBwZXJtYW5lbnQlMjBob3N0aW5nJTIwYW5kJTIwR1BVJTIwdXBncmFkZXMlMjAoTkVXISklMkMlMjBjaGVjayUyMG91dCUyMFNwYWNlcyUzQSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMEElMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEFHbyUyMHRvJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnNldHRpbmdzJTJGd2ViaG9va3MlMjB0byUyMHNldHVwJTIweW91ciUyMHdlYmhvb2tzLg==",highlighted:`Webhook secret is not defined. This means your webhook endpoints will be open to everyone.
To add a secret, set \`WEBHOOK_SECRET\` as environment variable or pass it at initialization: 
        \`app = WebhooksServer(webhook_secret=&#x27;my_secret&#x27;, ...)\`
For more details about webhook secrets, please refer to https://huggingface.co/docs/hub/webhooks#webhook-secret.
Running on local URL:  http://127.0.0.1:7860
Running on public URL: https://1fadb0f52d8bf825fc.gradio.live

This share link expires in 72 hours. For free permanent hosting and GPU upgrades (NEW!), check out Spaces: https://huggingface.co/spaces

Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
Go to https://huggingface.co/settings/webhooks to setup your webhooks.`}}),Z=new Ut({props:{warning:!0,$$slots:{default:[ba]},$$scope:{ctx:W}}}),A=new ye({}),K=new ye({}),ae=new ye({}),oe=new ye({}),le=new Ze({props:{code:"JTIzJTIwYXBwLnB5JTBBZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdlYmhvb2tfZW5kcG9pbnQlMkMlMjBXZWJob29rUGF5bG9hZCUwQSUwQSU0MHdlYmhvb2tfZW5kcG9pbnQlMEFhc3luYyUyMGRlZiUyMHRyaWdnZXJfdHJhaW5pbmcocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwaWYlMjBwYXlsb2FkLnJlcG8udHlwZSUyMCUzRCUzRCUyMCUyMmRhdGFzZXQlMjIlMjBhbmQlMjBwYXlsb2FkLmV2ZW50LmFjdGlvbiUyMCUzRCUzRCUyMCUyMnVwZGF0ZSUyMiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFRyaWdnZXIlMjBhJTIwdHJhaW5pbmclMjBqb2IlMjBpZiUyMGElMjBkYXRhc2V0JTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTBBJTQwd2ViaG9va19lbmRwb2ludCUwQWFzeW5jJTIwZGVmJTIwdHJpZ2dlcl9ldmFsdWF0aW9uKHBheWxvYWQlM0ElMjBXZWJob29rUGF5bG9hZCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwcGF5bG9hZC5yZXBvLnR5cGUlMjAlM0QlM0QlMjAlMjJtb2RlbCUyMiUyMGFuZCUyMHBheWxvYWQuZXZlbnQuYWN0aW9uJTIwJTNEJTNEJTIwJTIydXBkYXRlJTIyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJpZ2dlciUyMGFuJTIwZXZhbHVhdGlvbiUyMGpvYiUyMGlmJTIwYSUyMG1vZGVsJTIwaXMlMjB1cGRhdGVkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-comment"># app.py</span>
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> webhook_endpoint, WebhookPayload

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_training</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;dataset&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger a training job if a dataset is updated</span>
        ...

<span class="hljs-meta">@webhook_endpoint</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">trigger_evaluation</span>(<span class="hljs-params">payload: WebhookPayload</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">if</span> payload.repo.<span class="hljs-built_in">type</span> == <span class="hljs-string">&quot;model&quot;</span> <span class="hljs-keyword">and</span> payload.event.action == <span class="hljs-string">&quot;update&quot;</span>:
        <span class="hljs-comment"># Trigger an evaluation job if a model is updated</span>
        ...`}}),re=new Ze({props:{code:"KC4uLiklMEFXZWJob29rcyUyMGFyZSUyMGNvcnJlY3RseSUyMHNldHVwJTIwYW5kJTIwcmVhZHklMjB0byUyMHVzZSUzQSUwQSUyMCUyMC0lMjBQT1NUJTIwaHR0cHMlM0ElMkYlMkYxZmFkYjBmNTJkOGJmODI1ZmMuZ3JhZGlvLmxpdmUlMkZ3ZWJob29rcyUyRnRyaWdnZXJfdHJhaW5pbmclMEElMjAlMjAtJTIwUE9TVCUyMGh0dHBzJTNBJTJGJTJGMWZhZGIwZjUyZDhiZjgyNWZjLmdyYWRpby5saXZlJTJGd2ViaG9va3MlMkZ0cmlnZ2VyX2V2YWx1YXRpb24=",highlighted:`(...)
Webhooks are correctly setup and ready to use:
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_training
  - POST https://1fadb0f52d8bf825fc.gradio.live/webhooks/trigger_evaluation`}}),he=new ye({}),de=new Ze({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBmYXN0YXBpJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBXZWJob29rc1NlcnZlciUyQyUyMFdlYmhvb2tQYXlsb2FkJTBBJTBBJTIzJTIwMS4lMjBEZWZpbmUlMjAlMjBVSSUwQXdpdGglMjBnci5CbG9ja3MoKSUyMGFzJTIwdWklM0ElMEElMjAlMjAlMjAlMjAuLi4lMEElMEElMjMlMjAyLiUyMENyZWF0ZSUyMFdlYmhvb2tzU2VydmVyJTIwd2l0aCUyMGN1c3RvbSUyMFVJJTIwYW5kJTIwc2VjcmV0JTBBYXBwJTIwJTNEJTIwV2ViaG9va3NTZXJ2ZXIodWklM0R1aSUyQyUyMHdlYmhvb2tfc2VjcmV0JTNEJTIybXlfc2VjcmV0X2tleSUyMiklMEElMEElMjMlMjAzLiUyMFJlZ2lzdGVyJTIwd2ViaG9vayUyMHdpdGglMjBleHBsaWNpdCUyMG5hbWUlMEElNDBhcHAuYWRkX3dlYmhvb2soJTIyJTJGc2F5X2hlbGxvJTIyKSUwQWFzeW5jJTIwZGVmJTIwaGVsbG8ocGF5bG9hZCUzQSUyMFdlYmhvb2tQYXlsb2FkKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMm1lc3NhZ2UlMjIlM0ElMjAlMjJoZWxsbyUyMiU3RCUwQSUwQSUyMyUyMDQuJTIwUmVnaXN0ZXIlMjB3ZWJob29rJTIwd2l0aCUyMGltcGxpY2l0JTIwbmFtZSUwQSU0MGFwcC5hZGRfd2ViaG9vayUwQWFzeW5jJTIwZGVmJTIwZ29vZGJ5ZShwYXlsb2FkJTNBJTIwV2ViaG9va1BheWxvYWQpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybWVzc2FnZSUyMiUzQSUyMCUyMmdvb2RieWUlMjIlN0QlMEElMEElMjMlMjA1LiUyMFN0YXJ0JTIwc2VydmVyJTIwKG9wdGlvbmFsKSUwQWFwcC5ydW4oKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> fastapi <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> WebhooksServer, WebhookPayload

<span class="hljs-comment"># 1. Define  UI</span>
<span class="hljs-keyword">with</span> gr.Blocks() <span class="hljs-keyword">as</span> ui:
    ...

<span class="hljs-comment"># 2. Create WebhooksServer with custom UI and secret</span>
app = WebhooksServer(ui=ui, webhook_secret=<span class="hljs-string">&quot;my_secret_key&quot;</span>)

<span class="hljs-comment"># 3. Register webhook with explicit name</span>
<span class="hljs-meta">@app.add_webhook(<span class="hljs-params"><span class="hljs-string">&quot;/say_hello&quot;</span></span>)</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">hello</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;hello&quot;</span>}

<span class="hljs-comment"># 4. Register webhook with implicit name</span>
<span class="hljs-meta">@app.add_webhook</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">goodbye</span>(<span class="hljs-params">payload: WebhookPayload</span>):
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;message&quot;</span>: <span class="hljs-string">&quot;goodbye&quot;</span>}

<span class="hljs-comment"># 5. Start server (optional)</span>
app.run()`}}),{c(){r=o("meta"),v=l(),d=o("h1"),m=o("a"),Te=o("span"),w(V.$$.fragment),gt=l(),fe=o("span"),fe.textContent=It,Ge=l(),F=o("p"),F.innerHTML=Wt,Se=l(),E=o("p"),E.innerHTML=_t,Be=l(),w(_.$$.fragment),He=l(),w(C.$$.fragment),xe=l(),k=o("h2"),$=o("a"),Je=o("span"),w(R.$$.fragment),Mt=l(),be=o("span"),be.textContent=Ct,Ye=l(),N=o("p"),N.textContent=$t,Ve=l(),w(Q.$$.fragment),Fe=l(),X=o("p"),X.innerHTML=Zt,Ee=l(),w(L.$$.fragment),Re=l(),z=o("p"),z.textContent=Gt,Ne=l(),P=o("ol"),P.innerHTML=St,Qe=l(),w(Z.$$.fragment),Xe=l(),T=o("h2"),G=o("a"),Ue=o("span"),w(A.$$.fragment),mt=l(),ge=o("span"),ge.textContent=Bt,Le=l(),q=o("p"),q.innerHTML=Ht,ze=l(),S=o("div"),S.innerHTML=xt,Pe=l(),O=o("p"),O.textContent=Yt,Ae=l(),J=o("h2"),B=o("a"),je=o("span"),w(K.$$.fragment),vt=l(),Me=o("span"),Me.textContent=Vt,qe=l(),D=o("p"),D.innerHTML=Ft,Oe=l(),ee=o("p"),ee.innerHTML=Et,Ke=l(),te=o("p"),te.innerHTML=Rt,De=l(),U=o("h2"),H=o("a"),Ie=o("span"),w(ae.$$.fragment),kt=l(),me=o("span"),me.textContent=Nt,et=l(),se=o("p"),se.innerHTML=Qt,tt=l(),j=o("h3"),x=o("a"),We=o("span"),w(oe.$$.fragment),Tt=l(),ve=o("span"),ve.textContent=Xt,at=l(),ne=o("p"),ne.innerHTML=Lt,st=l(),w(le.$$.fragment),ot=l(),ie=o("p"),ie.textContent=zt,nt=l(),w(re.$$.fragment),lt=l(),I=o("h3"),Y=o("a"),_e=o("span"),w(he.$$.fragment),Jt=l(),ke=o("span"),ke.textContent=Pt,it=l(),pe=o("p"),pe.innerHTML=At,rt=l(),ce=o("p"),ce.textContent=qt,ht=l(),w(de.$$.fragment),pt=l(),ue=o("ol"),ue.innerHTML=Ot,this.h()},l(e){const a=wa("svelte-1phssyn",document.head);r=n(a,"META",{name:!0,content:!0}),a.forEach(t),v=i(e),d=n(e,"H1",{class:!0});var we=u(d);m=n(we,"A",{id:!0,class:!0,href:!0});var Ce=u(m);Te=n(Ce,"SPAN",{});var $e=u(Te);y(V.$$.fragment,$e),$e.forEach(t),Ce.forEach(t),gt=i(we),fe=n(we,"SPAN",{"data-svelte-h":!0}),c(fe)!=="svelte-485osi"&&(fe.textContent=It),we.forEach(t),Ge=i(e),F=n(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1si55wx"&&(F.innerHTML=Wt),Se=i(e),E=n(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-1mr6xkj"&&(E.innerHTML=_t),Be=i(e),y(_.$$.fragment,e),He=i(e),y(C.$$.fragment,e),xe=i(e),k=n(e,"H2",{class:!0});var dt=u(k);$=n(dt,"A",{id:!0,class:!0,href:!0});var Kt=u($);Je=n(Kt,"SPAN",{});var Dt=u(Je);y(R.$$.fragment,Dt),Dt.forEach(t),Kt.forEach(t),Mt=i(dt),be=n(dt,"SPAN",{"data-svelte-h":!0}),c(be)!=="svelte-1f5whfl"&&(be.textContent=Ct),dt.forEach(t),Ye=i(e),N=n(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-1dl6tkz"&&(N.textContent=$t),Ve=i(e),y(Q.$$.fragment,e),Fe=i(e),X=n(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-nkdywa"&&(X.innerHTML=Zt),Ee=i(e),y(L.$$.fragment,e),Re=i(e),z=n(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-bjh0uv"&&(z.textContent=Gt),Ne=i(e),P=n(e,"OL",{"data-svelte-h":!0}),c(P)!=="svelte-he60yn"&&(P.innerHTML=St),Qe=i(e),y(Z.$$.fragment,e),Xe=i(e),T=n(e,"H2",{class:!0});var ut=u(T);G=n(ut,"A",{id:!0,class:!0,href:!0});var ea=u(G);Ue=n(ea,"SPAN",{});var ta=u(Ue);y(A.$$.fragment,ta),ta.forEach(t),ea.forEach(t),mt=i(ut),ge=n(ut,"SPAN",{"data-svelte-h":!0}),c(ge)!=="svelte-adojzt"&&(ge.textContent=Bt),ut.forEach(t),Le=i(e),q=n(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1x65hd6"&&(q.innerHTML=Ht),ze=i(e),S=n(e,"DIV",{class:!0,"data-svelte-h":!0}),c(S)!=="svelte-krvowi"&&(S.innerHTML=xt),Pe=i(e),O=n(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-1sr65c9"&&(O.textContent=Yt),Ae=i(e),J=n(e,"H2",{class:!0});var wt=u(J);B=n(wt,"A",{id:!0,class:!0,href:!0});var aa=u(B);je=n(aa,"SPAN",{});var sa=u(je);y(K.$$.fragment,sa),sa.forEach(t),aa.forEach(t),vt=i(wt),Me=n(wt,"SPAN",{"data-svelte-h":!0}),c(Me)!=="svelte-e77b12"&&(Me.textContent=Vt),wt.forEach(t),qe=i(e),D=n(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-apq0kg"&&(D.innerHTML=Ft),Oe=i(e),ee=n(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1h3f73"&&(ee.innerHTML=Et),Ke=i(e),te=n(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-1cxtt3c"&&(te.innerHTML=Rt),De=i(e),U=n(e,"H2",{class:!0});var yt=u(U);H=n(yt,"A",{id:!0,class:!0,href:!0});var oa=u(H);Ie=n(oa,"SPAN",{});var na=u(Ie);y(ae.$$.fragment,na),na.forEach(t),oa.forEach(t),kt=i(yt),me=n(yt,"SPAN",{"data-svelte-h":!0}),c(me)!=="svelte-psuwy"&&(me.textContent=Nt),yt.forEach(t),et=i(e),se=n(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1m04po0"&&(se.innerHTML=Qt),tt=i(e),j=n(e,"H3",{class:!0});var ft=u(j);x=n(ft,"A",{id:!0,class:!0,href:!0});var la=u(x);We=n(la,"SPAN",{});var ia=u(We);y(oe.$$.fragment,ia),ia.forEach(t),la.forEach(t),Tt=i(ft),ve=n(ft,"SPAN",{"data-svelte-h":!0}),c(ve)!=="svelte-1ii46if"&&(ve.textContent=Xt),ft.forEach(t),at=i(e),ne=n(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-gotrx0"&&(ne.innerHTML=Lt),st=i(e),y(le.$$.fragment,e),ot=i(e),ie=n(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-o8x9sv"&&(ie.textContent=zt),nt=i(e),y(re.$$.fragment,e),lt=i(e),I=n(e,"H3",{class:!0});var bt=u(I);Y=n(bt,"A",{id:!0,class:!0,href:!0});var ra=u(Y);_e=n(ra,"SPAN",{});var ha=u(_e);y(he.$$.fragment,ha),ha.forEach(t),ra.forEach(t),Jt=i(bt),ke=n(bt,"SPAN",{"data-svelte-h":!0}),c(ke)!=="svelte-1shjvid"&&(ke.textContent=Pt),bt.forEach(t),it=i(e),pe=n(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-grjoog"&&(pe.innerHTML=At),rt=i(e),ce=n(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1plkp10"&&(ce.textContent=qt),ht=i(e),y(de.$$.fragment,e),pt=i(e),ue=n(e,"OL",{"data-svelte-h":!0}),c(ue)!=="svelte-1pnifeu"&&(ue.innerHTML=Ot),this.h()},h(){h(r,"name","hf:doc:metadata"),h(r,"content",JSON.stringify(Ma)),h(m,"id","webhooks-server"),h(m,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(m,"href","#webhooks-server"),h(d,"class","relative group"),h($,"id","create-an-endpoint"),h($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h($,"href","#create-an-endpoint"),h(k,"class","relative group"),h(G,"id","configure-a-webhook"),h(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(G,"href","#configure-a-webhook"),h(T,"class","relative group"),h(S,"class","flex justify-center"),h(B,"id","deploy-to-a-space"),h(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(B,"href","#deploy-to-a-space"),h(J,"class","relative group"),h(H,"id","advanced-usage"),h(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(H,"href","#advanced-usage"),h(U,"class","relative group"),h(x,"id","multiple-endpoints"),h(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(x,"href","#multiple-endpoints"),h(j,"class","relative group"),h(Y,"id","custom-server"),h(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(Y,"href","#custom-server"),h(I,"class","relative group")},m(e,a){p(document.head,r),s(e,v,a),s(e,d,a),p(d,m),p(m,Te),f(V,Te,null),p(d,gt),p(d,fe),s(e,Ge,a),s(e,F,a),s(e,Se,a),s(e,E,a),s(e,Be,a),f(_,e,a),s(e,He,a),f(C,e,a),s(e,xe,a),s(e,k,a),p(k,$),p($,Je),f(R,Je,null),p(k,Mt),p(k,be),s(e,Ye,a),s(e,N,a),s(e,Ve,a),f(Q,e,a),s(e,Fe,a),s(e,X,a),s(e,Ee,a),f(L,e,a),s(e,Re,a),s(e,z,a),s(e,Ne,a),s(e,P,a),s(e,Qe,a),f(Z,e,a),s(e,Xe,a),s(e,T,a),p(T,G),p(G,Ue),f(A,Ue,null),p(T,mt),p(T,ge),s(e,Le,a),s(e,q,a),s(e,ze,a),s(e,S,a),s(e,Pe,a),s(e,O,a),s(e,Ae,a),s(e,J,a),p(J,B),p(B,je),f(K,je,null),p(J,vt),p(J,Me),s(e,qe,a),s(e,D,a),s(e,Oe,a),s(e,ee,a),s(e,Ke,a),s(e,te,a),s(e,De,a),s(e,U,a),p(U,H),p(H,Ie),f(ae,Ie,null),p(U,kt),p(U,me),s(e,et,a),s(e,se,a),s(e,tt,a),s(e,j,a),p(j,x),p(x,We),f(oe,We,null),p(j,Tt),p(j,ve),s(e,at,a),s(e,ne,a),s(e,st,a),f(le,e,a),s(e,ot,a),s(e,ie,a),s(e,nt,a),f(re,e,a),s(e,lt,a),s(e,I,a),p(I,Y),p(Y,_e),f(he,_e,null),p(I,Jt),p(I,ke),s(e,it,a),s(e,pe,a),s(e,rt,a),s(e,ce,a),s(e,ht,a),f(de,e,a),s(e,pt,a),s(e,ue,a),ct=!0},p(e,[a]){const we={};a&2&&(we.$$scope={dirty:a,ctx:e}),_.$set(we);const Ce={};a&2&&(Ce.$$scope={dirty:a,ctx:e}),C.$set(Ce);const $e={};a&2&&($e.$$scope={dirty:a,ctx:e}),Z.$set($e)},i(e){ct||(b(V.$$.fragment,e),b(_.$$.fragment,e),b(C.$$.fragment,e),b(R.$$.fragment,e),b(Q.$$.fragment,e),b(L.$$.fragment,e),b(Z.$$.fragment,e),b(A.$$.fragment,e),b(K.$$.fragment,e),b(ae.$$.fragment,e),b(oe.$$.fragment,e),b(le.$$.fragment,e),b(re.$$.fragment,e),b(he.$$.fragment,e),b(de.$$.fragment,e),ct=!0)},o(e){g(V.$$.fragment,e),g(_.$$.fragment,e),g(C.$$.fragment,e),g(R.$$.fragment,e),g(Q.$$.fragment,e),g(L.$$.fragment,e),g(Z.$$.fragment,e),g(A.$$.fragment,e),g(K.$$.fragment,e),g(ae.$$.fragment,e),g(oe.$$.fragment,e),g(le.$$.fragment,e),g(re.$$.fragment,e),g(he.$$.fragment,e),g(de.$$.fragment,e),ct=!1},d(e){e&&(t(v),t(d),t(Ge),t(F),t(Se),t(E),t(Be),t(He),t(xe),t(k),t(Ye),t(N),t(Ve),t(Fe),t(X),t(Ee),t(Re),t(z),t(Ne),t(P),t(Qe),t(Xe),t(T),t(Le),t(q),t(ze),t(S),t(Pe),t(O),t(Ae),t(J),t(qe),t(D),t(Oe),t(ee),t(Ke),t(te),t(De),t(U),t(et),t(se),t(tt),t(j),t(at),t(ne),t(st),t(ot),t(ie),t(nt),t(lt),t(I),t(it),t(pe),t(rt),t(ce),t(ht),t(pt),t(ue)),t(r),M(V),M(_,e),M(C,e),M(R),M(Q,e),M(L,e),M(Z,e),M(A),M(K),M(ae),M(oe),M(le,e),M(re,e),M(he),M(de,e)}}}const Ma={local:"webhooks-server",sections:[{local:"create-an-endpoint",title:"Create an endpoint"},{local:"configure-a-webhook",title:"Configure a Webhook"},{local:"deploy-to-a-space",title:"Deploy to a Space"},{local:"advanced-usage",sections:[{local:"multiple-endpoints",title:"Multiple endpoints"},{local:"custom-server",title:"Custom server"}],title:"Advanced usage"}],title:"Webhooks Server"};function ma(W){return ca(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ja extends da{constructor(r){super(),ua(this,r,ma,ga,pa,{})}}export{ja as component};
