import{s as bl,f as dl,n as Tl,o as fl}from"../chunks/scheduler.37c15a92.js";import{S as Il,i as gl,g as p,s as a,r as Z,A as Cl,h as i,f as e,c as n,j as al,u as B,x as M,k as o,y as kl,a as t,v as x,d as W,t as A,w as Q}from"../chunks/index.2bf4358c.js";import{C as Ul}from"../chunks/CodeBlock.4f5fc1ad.js";import{D as Gl}from"../chunks/DocNotebookDropdown.d9dfeb24.js";import{H as nl}from"../chunks/Heading.8ada512a.js";function Zl(ol){let m,$,v,E,y,R,u,_,w,pl="現在我們可以構建和共享一個基本接口, 讓我們來探索一些更高級的特性, 如狀態和解釋。",q,h,Y,J,il="Gradio 支持 <em>會話狀態</em>, 其中數據在頁面加載中的多個提交中持續存在。會話狀態對於構建演示很有用, 例如, 你希望在用戶與模型交互時保留數據的聊天機器人。請注意, 會話狀態不會在模型的不同用戶之間共享數據。",N,j,rl="要將數據存儲在會話狀態中, 你需要做三件事:",z,d,cl="<li>向函數中傳遞一個 <em>額外的參數</em> , 該參數表示接口的狀態。</li> <li>在函數結束時, 將狀態的更新值作為 <em>額外的返回值</em> 返回。</li> <li>在創建<code>接口</code>時添加 ‘state’ 輸入和 ‘state’ 輸出組件。</li>",X,U,Ml="請參閱下面的聊天機器人示例:",V,b,F,r,ml,H,T,yl="請注意輸出組件的狀態如何在提交之間保持不變。注意: 可以給 state 參數傳入一個默認值, 作為 state 的初始值。",D,f,L,I,ul="大多數機器學習模型都是黑盒子, 函數的內部邏輯對終端用戶是隱藏的。為了提高透明度, 我們通過簡單地將 Interface 類中的解釋關鍵字設置為默認值, 使向模型添加解釋變得非常容易。這允許你的用戶理解輸入的哪些部分負責輸出。看看下面這個簡單的接口, 它顯示了一個還包括解釋的圖像分類器:",K,g,P,C,wl="通過提交一個輸入, 然後單擊輸出組件下的Interpret來測試解釋功能。",O,c,hl,ll,k,Jl='除了Gradio提供的默認解釋方法之外, 你還可以為 <code>interpretation</code> 參數指定 <code>shap</code>, 並設置 <code>num_shap</code> 參數。這使用基於 Shapley 的解釋, 你可以在 <a href="https://christophm.github.io/interpretable-ml-book/shap.html" rel="nofollow">here</a> 閱讀更多信息。最後, 還可以將自己的解釋函數傳入 <code>interpretation</code> 參數。在Gradio的入門頁面 <a href="https://gradio.app/getting_started/" rel="nofollow">here</a> 中可以看到一個例子。',sl,G,jl="這結束了我們對Gradio的<code>Interface</code>類的深入研究。正如我們所看到的, 這個類使用幾行Python代碼創建機器學習演示變得簡單。然而, 有時你會想通過改變佈局或鏈接多個預測函數來定製你的demo。如果我們能以某種方式將 <code>接口</code> 分成可定製的 “塊”, 那不是很好嗎? 幸運的是, 有! 這是最後一部分的主題。",el,S,tl;return y=new nl({props:{title:"高級接口功能",local:"高級接口功能",headingTag:"h1"}}),u=new Gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/chapter9/section6.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/chapter9/section6.ipynb"}]}}),h=new nl({props:{title:"使用狀態保存數據",local:"使用狀態保存數據",headingTag:"h3"}}),b=new Ul({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYXQobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeSUyMCUzRCUyMGhpc3RvcnklMjBvciUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZS5zdGFydHN3aXRoKCUyMkhvdyUyMG1hbnklMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20ucmFuZGludCgxJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJIb3clMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20uY2hvaWNlKCU1QiUyMkdyZWF0JTIyJTJDJTIwJTIyR29vZCUyMiUyQyUyMCUyMk9rYXklMjIlMkMlMjAlMjJCYWQlMjIlNUQpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJXaGVyZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJhbmRvbS5jaG9pY2UoJTVCJTIySGVyZSUyMiUyQyUyMCUyMlRoZXJlJTIyJTJDJTIwJTIyU29tZXdoZXJlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMCUyMkklMjBkb24ndCUyMGtub3clMjIlMEElMjAlMjAlMjAlMjBoaXN0b3J5LmFwcGVuZCgobWVzc2FnZSUyQyUyMHJlc3BvbnNlKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaXN0b3J5JTJDJTIwaGlzdG9yeSUwQSUwQSUwQWlmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGNoYXQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJ0ZXh0JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJjaGF0Ym90JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19zY3JlZW5zaG90JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19mbGFnZ2luZyUzRCUyMm5ldmVyJTIyJTJDJTBBKSUwQWlmYWNlLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history</span>):
    history = history <span class="hljs-keyword">or</span> []
    <span class="hljs-keyword">if</span> message.startswith(<span class="hljs-string">&quot;How many&quot;</span>):
        response = random.randint(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>)
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;How&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Great&quot;</span>, <span class="hljs-string">&quot;Good&quot;</span>, <span class="hljs-string">&quot;Okay&quot;</span>, <span class="hljs-string">&quot;Bad&quot;</span>])
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;Where&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Here&quot;</span>, <span class="hljs-string">&quot;There&quot;</span>, <span class="hljs-string">&quot;Somewhere&quot;</span>])
    <span class="hljs-keyword">else</span>:
        response = <span class="hljs-string">&quot;I don&#x27;t know&quot;</span>
    history.append((message, response))
    <span class="hljs-keyword">return</span> history, history


iface = gr.Interface(
    chat,
    [<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    [<span class="hljs-string">&quot;chatbot&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    allow_screenshot=<span class="hljs-literal">False</span>,
    allow_flagging=<span class="hljs-string">&quot;never&quot;</span>,
)
iface.launch()`,wrap:!1}}),f=new nl({props:{title:"通過解釋來理解預測",local:"通過解釋來理解預測",headingTag:"h3"}}),g=new Ul({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBsb2FkJTIwdGhlJTIwbW9kZWwlMEElMEElMjMlMjBEb3dubG9hZCUyMGh1bWFuLXJlYWRhYmxlJTIwbGFiZWxzJTIwZm9yJTIwSW1hZ2VOZXQuJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZnaXQuaW8lMkZKSmtZTiUyMiklMEFsYWJlbHMlMjAlM0QlMjByZXNwb25zZS50ZXh0LnNwbGl0KCUyMiU1Q24lMjIpJTBBJTBBJTBBZGVmJTIwY2xhc3NpZnlfaW1hZ2UoaW5wKSUzQSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMGlucC5yZXNoYXBlKCgtMSUyQyUyMDIyNCUyQyUyMDIyNCUyQyUyMDMpKSUwQSUyMCUyMCUyMCUyMGlucCUyMCUzRCUyMHRmLmtlcmFzLmFwcGxpY2F0aW9ucy5tb2JpbGVuZXRfdjIucHJlcHJvY2Vzc19pbnB1dChpbnApJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbiUyMCUzRCUyMGluY2VwdGlvbl9uZXQucHJlZGljdChpbnApLmZsYXR0ZW4oKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QmxhYmVscyU1QmklNUQlM0ElMjBmbG9hdChwcmVkaWN0aW9uJTVCaSU1RCklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMDAwKSU3RCUwQSUwQSUwQWltYWdlJTIwJTNEJTIwZ3IuSW1hZ2Uoc2hhcGUlM0QoMjI0JTJDJTIwMjI0KSklMEFsYWJlbCUyMCUzRCUyMGdyLkxhYmVsKG51bV90b3BfY2xhc3NlcyUzRDMpJTBBJTBBdGl0bGUlMjAlM0QlMjAlMjJHcmFkaW8lMjBJbWFnZSUyMENsYXNzaWZpY3Rpb24lMjAlMkIlMjBJbnRlcnByZXRhdGlvbiUyMEV4YW1wbGUlMjIlMEFnci5JbnRlcmZhY2UoJTBBJTIwJTIwJTIwJTIwZm4lM0RjbGFzc2lmeV9pbWFnZSUyQyUyMGlucHV0cyUzRGltYWdlJTJDJTIwb3V0cHV0cyUzRGxhYmVsJTJDJTIwaW50ZXJwcmV0YXRpb24lM0QlMjJkZWZhdWx0JTIyJTJDJTIwdGl0bGUlM0R0aXRsZSUwQSkubGF1bmNoKCk=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># load the model</span>

<span class="hljs-comment"># Download human-readable labels for ImageNet.</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch()`,wrap:!1}}),{c(){m=p("meta"),$=a(),v=p("p"),E=a(),Z(y.$$.fragment),R=a(),Z(u.$$.fragment),_=a(),w=p("p"),w.textContent=pl,q=a(),Z(h.$$.fragment),Y=a(),J=p("p"),J.innerHTML=il,N=a(),j=p("p"),j.textContent=rl,z=a(),d=p("ol"),d.innerHTML=cl,X=a(),U=p("p"),U.textContent=Ml,V=a(),Z(b.$$.fragment),F=a(),r=p("iframe"),H=a(),T=p("p"),T.textContent=yl,D=a(),Z(f.$$.fragment),L=a(),I=p("p"),I.textContent=ul,K=a(),Z(g.$$.fragment),P=a(),C=p("p"),C.textContent=wl,O=a(),c=p("iframe"),ll=a(),k=p("p"),k.innerHTML=Jl,sl=a(),G=p("p"),G.innerHTML=jl,el=a(),S=p("p"),this.h()},l(l){const s=Cl("svelte-u9bgzb",document.head);m=i(s,"META",{name:!0,content:!0}),s.forEach(e),$=n(l),v=i(l,"P",{}),al(v).forEach(e),E=n(l),B(y.$$.fragment,l),R=n(l),B(u.$$.fragment,l),_=n(l),w=i(l,"P",{"data-svelte-h":!0}),M(w)!=="svelte-x51h71"&&(w.textContent=pl),q=n(l),B(h.$$.fragment,l),Y=n(l),J=i(l,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1cc60o"&&(J.innerHTML=il),N=n(l),j=i(l,"P",{"data-svelte-h":!0}),M(j)!=="svelte-zuau5n"&&(j.textContent=rl),z=n(l),d=i(l,"OL",{"data-svelte-h":!0}),M(d)!=="svelte-67hbs5"&&(d.innerHTML=cl),X=n(l),U=i(l,"P",{"data-svelte-h":!0}),M(U)!=="svelte-f104y5"&&(U.textContent=Ml),V=n(l),B(b.$$.fragment,l),F=n(l),r=i(l,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),al(r).forEach(e),H=n(l),T=i(l,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1qf57y9"&&(T.textContent=yl),D=n(l),B(f.$$.fragment,l),L=n(l),I=i(l,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1psqlkg"&&(I.textContent=ul),K=n(l),B(g.$$.fragment,l),P=n(l),C=i(l,"P",{"data-svelte-h":!0}),M(C)!=="svelte-3q3puo"&&(C.textContent=wl),O=n(l),c=i(l,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),al(c).forEach(e),ll=n(l),k=i(l,"P",{"data-svelte-h":!0}),M(k)!=="svelte-9mllfu"&&(k.innerHTML=Jl),sl=n(l),G=i(l,"P",{"data-svelte-h":!0}),M(G)!=="svelte-16becp1"&&(G.innerHTML=jl),el=n(l),S=i(l,"P",{}),al(S).forEach(e),this.h()},h(){o(m,"name","hf:doc:metadata"),o(m,"content",Bl),dl(r.src,ml="https://course-demos-Chatbot-Demo.hf.space")||o(r,"src",ml),o(r,"frameborder","0"),o(r,"height","350"),o(r,"title","Gradio app"),o(r,"class","container p-0 flex-grow space-iframe"),o(r,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(r,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),dl(c.src,hl="https://course-demos-gradio-image-interpretation.hf.space")||o(c,"src",hl),o(c,"frameborder","0"),o(c,"height","570"),o(c,"title","Gradio app"),o(c,"class","container p-0 flex-grow space-iframe"),o(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),o(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(l,s){kl(document.head,m),t(l,$,s),t(l,v,s),t(l,E,s),x(y,l,s),t(l,R,s),x(u,l,s),t(l,_,s),t(l,w,s),t(l,q,s),x(h,l,s),t(l,Y,s),t(l,J,s),t(l,N,s),t(l,j,s),t(l,z,s),t(l,d,s),t(l,X,s),t(l,U,s),t(l,V,s),x(b,l,s),t(l,F,s),t(l,r,s),t(l,H,s),t(l,T,s),t(l,D,s),x(f,l,s),t(l,L,s),t(l,I,s),t(l,K,s),x(g,l,s),t(l,P,s),t(l,C,s),t(l,O,s),t(l,c,s),t(l,ll,s),t(l,k,s),t(l,sl,s),t(l,G,s),t(l,el,s),t(l,S,s),tl=!0},p:Tl,i(l){tl||(W(y.$$.fragment,l),W(u.$$.fragment,l),W(h.$$.fragment,l),W(b.$$.fragment,l),W(f.$$.fragment,l),W(g.$$.fragment,l),tl=!0)},o(l){A(y.$$.fragment,l),A(u.$$.fragment,l),A(h.$$.fragment,l),A(b.$$.fragment,l),A(f.$$.fragment,l),A(g.$$.fragment,l),tl=!1},d(l){l&&(e($),e(v),e(E),e(R),e(_),e(w),e(q),e(Y),e(J),e(N),e(j),e(z),e(d),e(X),e(U),e(V),e(F),e(r),e(H),e(T),e(D),e(L),e(I),e(K),e(P),e(C),e(O),e(c),e(ll),e(k),e(sl),e(G),e(el),e(S)),e(m),Q(y,l),Q(u,l),Q(h,l),Q(b,l),Q(f,l),Q(g,l)}}}const Bl='{"title":"高級接口功能","local":"高級接口功能","sections":[{"title":"使用狀態保存數據","local":"使用狀態保存數據","sections":[],"depth":3},{"title":"通過解釋來理解預測","local":"通過解釋來理解預測","sections":[],"depth":3}],"depth":1}';function xl(ol){return fl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends Il{constructor(m){super(),gl(this,m,xl,Zl,bl,{})}}export{$l as component};
