import{s as $n,o as kn,n as In}from"../chunks/scheduler.9bc65507.js";import{S as xn,i as Zn,g as p,s as l,r,A as vn,h as i,f as s,c as n,j as Cn,u as c,x as o,k as Ht,y as Vn,a,v as h,d as m,t as u,w as M}from"../chunks/index.707bf1b6.js";import{T as Gn}from"../chunks/Tip.c2ecdbf4.js";import{C as d}from"../chunks/CodeBlock.54a9f38d.js";import{D as _n}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as b}from"../chunks/Heading.342b1fa6.js";function Bn(At){let j,v="To follow this guide you will need a GPU. If you’re working in a notebook, run the following line to check if a GPU is available:",U,w,J,T,C="or alternatively for AMD GPUs:",$,g,V;return w=new d({props:{code:"IW52aWRpYS1zbWk=",highlighted:"!nvidia-smi",wrap:!1}}),g=new d({props:{code:"IXJvY20tc21p",highlighted:"!rocm-smi",wrap:!1}}),{c(){j=p("p"),j.textContent=v,U=l(),r(w.$$.fragment),J=l(),T=p("p"),T.textContent=C,$=l(),r(g.$$.fragment)},l(y){j=i(y,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1qyctb1"&&(j.textContent=v),U=n(y),c(w.$$.fragment,y),J=n(y),T=i(y,"P",{"data-svelte-h":!0}),o(T)!=="svelte-p2429"&&(T.textContent=C),$=n(y),c(g.$$.fragment,y)},m(y,f){a(y,j,f),a(y,U,f),h(w,y,f),a(y,J,f),a(y,T,f),a(y,$,f),h(g,y,f),V=!0},p:In,i(y){V||(m(w.$$.fragment,y),m(g.$$.fragment,y),V=!0)},o(y){u(w.$$.fragment,y),u(g.$$.fragment,y),V=!1},d(y){y&&(s(j),s(U),s(J),s(T),s($)),M(w,y),M(g,y)}}}function Wn(At){let j,v,U,w,J,T,C,$,g,V=`Text-to-speech (TTS) is the task of creating natural-sounding speech from text, where the speech can be generated in multiple
languages and for multiple speakers. Several text-to-speech models are currently available in 🤗 Transformers, such as
<a href="../model_doc/bark">Bark</a>, <a href="../model_doc/mms">MMS</a>, <a href="../model_doc/vits">VITS</a> and <a href="../model_doc/speecht5">SpeechT5</a>.`,y,f,cl=`You can easily generate audio using the <code>&quot;text-to-audio&quot;</code> pipeline (or its alias - <code>&quot;text-to-speech&quot;</code>). Some models, like Bark,
can also be conditioned to generate non-verbal communications such as laughing, sighing and crying, or even add music.
Here’s an example of how you would use the <code>&quot;text-to-speech&quot;</code> pipeline with Bark:`,Et,G,St,_,hl="Here’s a code snippet you can use to listen to the resulting audio in a notebook:",Pt,B,Lt,W,ml=`For more examples on what Bark and other pretrained TTS models can do, refer to our
<a href="https://huggingface.co/learn/audio-course/chapter6/pre-trained_models" rel="nofollow">Audio course</a>.`,Dt,R,ul=`If you are looking to fine-tune a TTS model, you can currently fine-tune SpeechT5 only. SpeechT5 is pre-trained on a combination of
speech-to-text and text-to-speech data, allowing it to learn a unified space of hidden representations shared by both text
and speech. This means that the same pre-trained model can be fine-tuned for different tasks. Furthermore, SpeechT5
supports multiple speakers through x-vector speaker embeddings.`,Kt,X,Ml="The remainder of this guide illustrates how to:",Ot,Y,dl='<li>Fine-tune <a href="../model_doc/speecht5">SpeechT5</a> that was originally trained on English speech on the Dutch (<code>nl</code>) language subset of the <a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> dataset.</li> <li>Use your refined model for inference in one of two ways: using a pipeline or directly.</li>',es,z,yl="Before you begin, make sure you have all the necessary libraries installed:",ts,Q,ss,N,jl="Install 🤗Transformers from source as not all the SpeechT5 features have been merged into an official release yet:",as,F,ls,k,ns,q,gl="We encourage you to log in to your Hugging Face account to upload and share your model with the community. When prompted, enter your token to log in:",ps,H,is,A,os,E,fl=`<a href="https://huggingface.co/datasets/facebook/voxpopuli" rel="nofollow">VoxPopuli</a> is a large-scale multilingual speech corpus consisting of
data sourced from 2009-2020 European Parliament event recordings. It contains labelled audio-transcription data for 15
European languages. In this guide, we are using the Dutch language subset, feel free to pick another subset.`,rs,S,wl=`Note that VoxPopuli or any other automated speech recognition (ASR) dataset may not be the most suitable
option for training TTS models. The features that make it beneficial for ASR, such as excessive background noise, are
typically undesirable in TTS. However, finding top-quality, multilingual, and multi-speaker TTS datasets can be quite
challenging.`,cs,P,Jl="Let’s load the data:",hs,L,ms,D,Tl=`20968 examples should be sufficient for fine-tuning. SpeechT5 expects audio data to have a sampling rate of 16 kHz, so
make sure the examples in the dataset meet this requirement:`,us,K,Ms,O,ds,ee,bl="Let’s begin by defining the model checkpoint to use and loading the appropriate processor:",ys,te,js,se,gs,ae,Ul="Start by cleaning up the text data. You’ll need the tokenizer part of the processor to process the text:",fs,le,ws,ne,Cl=`The dataset examples contain <code>raw_text</code> and <code>normalized_text</code> features. When deciding which feature to use as the text input,
consider that the SpeechT5 tokenizer doesn’t have any tokens for numbers. In <code>normalized_text</code> the numbers are written
out as text. Thus, it is a better fit, and we recommend using    <code>normalized_text</code> as input text.`,Js,pe,$l=`Because SpeechT5 was trained on the English language, it may not recognize certain characters in the Dutch dataset. If
left as is, these characters will be converted to <code>&lt;unk&gt;</code> tokens. However, in Dutch, certain characters like <code>à</code> are
used to stress syllables. In order to preserve the meaning of the text, we can replace this character with a regular <code>a</code>.`,Ts,ie,kl=`To identify unsupported tokens, extract all unique characters in the dataset using the <code>SpeechT5Tokenizer</code> which
works with characters as tokens. To do this, write the <code>extract_all_chars</code> mapping function that concatenates
the transcriptions from all examples into one string and converts it to a set of characters.
Make sure to set <code>batched=True</code> and <code>batch_size=-1</code> in <code>dataset.map()</code> so that all transcriptions are available at once for
the mapping function.`,bs,oe,Us,re,Il=`Now you have two sets of characters: one with the vocabulary from the dataset and one with the vocabulary from the tokenizer.
To identify any unsupported characters in the dataset, you can take the difference between these two sets. The resulting
set will contain the characters that are in the dataset but not in the tokenizer.`,Cs,ce,$s,he,xl=`To handle the unsupported characters identified in the previous step, define a function that maps these characters to
valid tokens. Note that spaces are already replaced by <code>▁</code> in the tokenizer and don’t need to be handled separately.`,ks,me,Is,ue,Zl="Now that you have dealt with special characters in the text, it’s time to shift focus to the audio data.",xs,Me,Zs,de,vl=`The VoxPopuli dataset includes speech from multiple speakers, but how many speakers are represented in the dataset? To
determine this, we can count the number of unique speakers and the number of examples each speaker contributes to the dataset.
With a total of 20,968 examples in the dataset, this information will give us a better understanding of the distribution of
speakers and examples in the data.`,vs,ye,Vs,je,Vl="By plotting a histogram you can get a sense of how much data there is for each speaker.",Gs,ge,_s,I,Gl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_speakers_histogram.png" alt="Speakers histogram"/>',Bs,fe,_l=`The histogram reveals that approximately one-third of the speakers in the dataset have fewer than 100 examples, while
around ten speakers have more than 500 examples. To improve training efficiency and balance the dataset, we can limit
the data to speakers with between 100 and 400 examples.`,Ws,we,Rs,Je,Bl="Let’s check how many speakers remain:",Xs,Te,Ys,be,Wl="Let’s see how many examples are left:",zs,Ue,Qs,Ce,Rl="You are left with just under 10,000 examples from approximately 40 unique speakers, which should be sufficient.",Ns,$e,Xl=`Note that some speakers with few examples may actually have more audio available if the examples are long. However,
determining the total amount of audio for each speaker requires scanning through the entire dataset, which is a
time-consuming process that involves loading and decoding each audio file. As such, we have chosen to skip this step here.`,Fs,ke,qs,Ie,Yl=`To enable the TTS model to differentiate between multiple speakers, you’ll need to create a speaker embedding for each example.
The speaker embedding is an additional input into the model that captures a particular speaker’s voice characteristics.
To generate these speaker embeddings, use the pre-trained <a href="https://huggingface.co/speechbrain/spkrec-xvect-voxceleb" rel="nofollow">spkrec-xvect-voxceleb</a>
model from SpeechBrain.`,Hs,xe,zl=`Create a function <code>create_speaker_embedding()</code> that takes an input audio waveform and outputs a 512-element vector
containing the corresponding speaker embedding.`,As,Ze,Es,ve,Ql=`It’s important to note that the <code>speechbrain/spkrec-xvect-voxceleb</code> model was trained on English speech from the VoxCeleb
dataset, whereas the training examples in this guide are in Dutch. While we believe that this model will still generate
reasonable speaker embeddings for our Dutch dataset, this assumption may not hold true in all cases.`,Ss,Ve,Nl=`For optimal results, we recommend training an X-vector model on the target speech first. This will ensure that the model
is better able to capture the unique voice characteristics present in the Dutch language.`,Ps,Ge,Ls,_e,Fl=`Finally, let’s process the data into the format the model expects. Create a <code>prepare_dataset</code> function that takes in a
single example and uses the <code>SpeechT5Processor</code> object to tokenize the input text and load the target audio into a log-mel spectrogram.
It should also add the speaker embeddings as an additional input.`,Ds,Be,Ks,We,ql="Verify the processing is correct by looking at a single example:",Os,Re,ea,Xe,Hl="Speaker embeddings should be a 512-element vector:",ta,Ye,sa,ze,Al="The labels should be a log-mel spectrogram with 80 mel bins.",aa,Qe,la,x,El='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_1.png" alt="Log-mel spectrogram with 80 mel bins"/>',na,Ne,Sl=`Side note: If you find this spectrogram confusing, it may be due to your familiarity with the convention of placing low frequencies
at the bottom and high frequencies at the top of a plot. However, when plotting spectrograms as an image using the matplotlib library,
the y-axis is flipped and the spectrograms appear upside down.`,pa,Fe,Pl="Now apply the processing function to the entire dataset. This will take between 5 and 10 minutes.",ia,qe,oa,He,Ll=`You’ll see a warning saying that some examples in the dataset are longer than the maximum input length the model can handle (600 tokens).
Remove those examples from the dataset. Here we go even further and to allow for larger batch sizes we remove anything over 200 tokens.`,ra,Ae,ca,Ee,Dl="Next, create a basic train/test split:",ha,Se,ma,Pe,ua,Le,Kl=`In order to combine multiple examples into a batch, you need to define a custom data collator. This collator will pad shorter sequences with padding
tokens, ensuring that all examples have the same length. For the spectrogram labels, the padded portions are replaced with the special value <code>-100</code>. This special value
instructs the model to ignore that part of the spectrogram when calculating the spectrogram loss.`,Ma,De,da,Ke,Ol=`In SpeechT5, the input to the decoder part of the model is reduced by a factor 2. In other words, it throws away every
other timestep from the target sequence. The decoder then predicts a sequence that is twice as long. Since the original
target sequence length may be odd, the data collator makes sure to round the maximum length of the batch down to be a
multiple of 2.`,ya,Oe,ja,et,ga,tt,en="Load the pre-trained model from the same checkpoint as you used for loading the processor:",fa,st,wa,at,tn="The <code>use_cache=True</code> option is incompatible with gradient checkpointing. Disable it for training.",Ja,lt,Ta,nt,sn=`Define the training arguments. Here we are not computing any evaluation metrics during the training process. Instead, we’ll
only look at the loss:`,ba,pt,Ua,it,an="Instantiate the <code>Trainer</code> object  and pass the model, dataset, and data collator to it.",Ca,ot,$a,rt,ln=`And with that, you’re ready to start training! Training will take several hours. Depending on your GPU,
it is possible that you will encounter a CUDA “out-of-memory” error when you start training. In this case, you can reduce
the <code>per_device_train_batch_size</code> incrementally by factors of 2 and increase <code>gradient_accumulation_steps</code> by 2x to compensate.`,ka,ct,Ia,ht,nn="To be able to use your checkpoint with a pipeline, make sure to save the processor with the checkpoint:",xa,mt,Za,ut,pn="Push the final model to the 🤗 Hub:",va,Mt,Va,dt,Ga,yt,_a,jt,on=`Great, now that you’ve fine-tuned a model, you can use it for inference!
First, let’s see how you can use it with a corresponding pipeline. Let’s create a <code>&quot;text-to-speech&quot;</code> pipeline with your
checkpoint:`,Ba,gt,Wa,ft,rn="Pick a piece of text in Dutch you’d like narrated, e.g.:",Ra,wt,Xa,Jt,cn="To use SpeechT5 with the pipeline, you’ll need a speaker embedding. Let’s get it from an example in the test dataset:",Ya,Tt,za,bt,hn="Now you can pass the text and speaker embeddings to the pipeline, and it will take care of the rest:",Qa,Ut,Na,Ct,mn="You can then listen to the result:",Fa,$t,qa,kt,Ha,It,un="You can achieve the same inference results without using the pipeline, however, more steps will be required.",Aa,xt,Mn="Load the model from the 🤗 Hub:",Ea,Zt,Sa,vt,dn="Pick an example from the test dataset obtain a speaker embedding.",Pa,Vt,La,Gt,yn="Define the input text and tokenize it.",Da,_t,Ka,Bt,jn="Create a spectrogram with your model:",Oa,Wt,el,Rt,gn="Visualize the spectrogram, if you’d like to:",tl,Xt,sl,Z,fn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/tts_logmelspectrogram_2.png" alt="Generated log-mel spectrogram"/>',al,Yt,wn="Finally, use the vocoder to turn the spectrogram into sound.",ll,zt,nl,Qt,Jn=`In our experience, obtaining satisfactory results from this model can be challenging. The quality of the speaker
embeddings appears to be a significant factor. Since SpeechT5 was pre-trained with English x-vectors, it performs best
when using English speaker embeddings. If the synthesized speech sounds poor, try using a different speaker embedding.`,pl,Nt,Tn=`Increasing the training duration is also likely to enhance the quality of the results. Even so, the speech clearly is Dutch instead of English, and it does
capture the voice characteristics of the speaker (compare to the original audio in the example).
Another thing to experiment with is the model’s configuration. For example, try using <code>config.reduction_factor = 1</code> to
see if this improves the results.`,il,Ft,bn=`Finally, it is essential to consider ethical considerations. Although TTS technology has numerous useful applications, it
may also be used for malicious purposes, such as impersonating someone’s voice without their knowledge or consent. Please
use TTS judiciously and responsibly.`,ol,qt,rl;return J=new b({props:{title:"Text to speech",local:"text-to-speech",headingTag:"h1"}}),C=new _n({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/text-to-speech.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/text-to-speech.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/text-to-speech.ipynb"}]}}),G=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJzdW5vJTJGYmFyay1zbWFsbCUyMiklMEF0ZXh0JTIwJTNEJTIwJTIyJTVCY2xlYXJzJTIwdGhyb2F0JTVEJTIwVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjAuLi4lMjBhbmQlMjBJJTIwanVzdCUyMHRvb2slMjBhJTIwbG9uZyUyMHBhdXNlLiUyMiUwQW91dHB1dCUyMCUzRCUyMHBpcGUodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;suno/bark-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;[clears throat] This is a test ... and I just took a long pause.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text)`,wrap:!1}}),B=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJTIyYXVkaW8lMjIlNUQlMkMlMjByYXRlJTNEb3V0cHV0JTVCJTIyc2FtcGxpbmdfcmF0ZSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&quot;audio&quot;</span>], rate=output[<span class="hljs-string">&quot;sampling_rate&quot;</span>])`,wrap:!1}}),Q=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGFzZXRzJTIwc291bmRmaWxlJTIwc3BlZWNoYnJhaW4lMjBhY2NlbGVyYXRl",highlighted:"pip install datasets soundfile speechbrain accelerate",wrap:!1}}),F=new d({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzLmdpdA==",highlighted:"pip install git+https://github.com/huggingface/transformers.git",wrap:!1}}),k=new Gn({props:{$$slots:{default:[Bn]},$$scope:{ctx:At}}}),H=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),A=new b({props:{title:"Load the dataset",local:"load-the-dataset",headingTag:"h2"}}),L=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTJDJTIwQXVkaW8lMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmZhY2Vib29rJTJGdm94cG9wdWxpJTIyJTJDJTIwJTIybmwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;facebook/voxpopuli&quot;</span>, <span class="hljs-string">&quot;nl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">20968</span>`,wrap:!1}}),K=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuY2FzdF9jb2x1bW4oJTIyYXVkaW8lMjIlMkMlMjBBdWRpbyhzYW1wbGluZ19yYXRlJTNEMTYwMDApKQ==",highlighted:'dataset = dataset.cast_column(<span class="hljs-string">&quot;audio&quot;</span>, Audio(sampling_rate=<span class="hljs-number">16000</span>))',wrap:!1}}),O=new b({props:{title:"Preprocess the data",local:"preprocess-the-data",headingTag:"h2"}}),te=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1UHJvY2Vzc29yJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1pY3Jvc29mdCUyRnNwZWVjaHQ1X3R0cyUyMiUwQXByb2Nlc3NvciUyMCUzRCUyMFNwZWVjaFQ1UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5Processor

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;microsoft/speecht5_tts&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = SpeechT5Processor.from_pretrained(checkpoint)`,wrap:!1}}),se=new b({props:{title:"Text cleanup for SpeechT5 tokenization",local:"text-cleanup-for-speecht5-tokenization",headingTag:"h3"}}),le=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplcg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = processor.tokenizer',wrap:!1}}),oe=new d({props:{code:"ZGVmJTIwZXh0cmFjdF9hbGxfY2hhcnMoYmF0Y2gpJTNBJTBBJTIwJTIwJTIwJTIwYWxsX3RleHQlMjAlM0QlMjAlMjIlMjAlMjIuam9pbihiYXRjaCU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCklMEElMjAlMjAlMjAlMjB2b2NhYiUyMCUzRCUyMGxpc3Qoc2V0KGFsbF90ZXh0KSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJ2b2NhYiUyMiUzQSUyMCU1QnZvY2FiJTVEJTJDJTIwJTIyYWxsX3RleHQlMjIlM0ElMjAlNUJhbGxfdGV4dCU1RCU3RCUwQSUwQSUwQXZvY2FicyUyMCUzRCUyMGRhdGFzZXQubWFwKCUwQSUyMCUyMCUyMCUyMGV4dHJhY3RfYWxsX2NoYXJzJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hlZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNELTElMkMlMEElMjAlMjAlMjAlMjBrZWVwX2luX21lbW9yeSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZW1vdmVfY29sdW1ucyUzRGRhdGFzZXQuY29sdW1uX25hbWVzJTJDJTBBKSUwQSUwQWRhdGFzZXRfdm9jYWIlMjAlM0QlMjBzZXQodm9jYWJzJTVCJTIydm9jYWIlMjIlNUQlNUIwJTVEKSUwQXRva2VuaXplcl92b2NhYiUyMCUzRCUyMCU3QmslMjBmb3IlMjBrJTJDJTIwXyUyMGluJTIwdG9rZW5pemVyLmdldF92b2NhYigpLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_all_chars</span>(<span class="hljs-params">batch</span>):
<span class="hljs-meta">... </span>    all_text = <span class="hljs-string">&quot; &quot;</span>.join(batch[<span class="hljs-string">&quot;normalized_text&quot;</span>])
<span class="hljs-meta">... </span>    vocab = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_text))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;vocab&quot;</span>: [vocab], <span class="hljs-string">&quot;all_text&quot;</span>: [all_text]}


<span class="hljs-meta">&gt;&gt;&gt; </span>vocabs = dataset.<span class="hljs-built_in">map</span>(
<span class="hljs-meta">... </span>    extract_all_chars,
<span class="hljs-meta">... </span>    batched=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=-<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    keep_in_memory=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    remove_columns=dataset.column_names,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab = <span class="hljs-built_in">set</span>(vocabs[<span class="hljs-string">&quot;vocab&quot;</span>][<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_vocab = {k <span class="hljs-keyword">for</span> k, _ <span class="hljs-keyword">in</span> tokenizer.get_vocab().items()}`,wrap:!1}}),ce=new d({props:{code:"ZGF0YXNldF92b2NhYiUyMC0lMjB0b2tlbml6ZXJfdm9jYWI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset_vocab - tokenizer_vocab
{<span class="hljs-string">&#x27; &#x27;</span>, <span class="hljs-string">&#x27;à&#x27;</span>, <span class="hljs-string">&#x27;ç&#x27;</span>, <span class="hljs-string">&#x27;è&#x27;</span>, <span class="hljs-string">&#x27;ë&#x27;</span>, <span class="hljs-string">&#x27;í&#x27;</span>, <span class="hljs-string">&#x27;ï&#x27;</span>, <span class="hljs-string">&#x27;ö&#x27;</span>, <span class="hljs-string">&#x27;ü&#x27;</span>}`,wrap:!1}}),me=new d({props:{code:"cmVwbGFjZW1lbnRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBMCUyMiUyQyUyMCUyMmElMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBNyUyMiUyQyUyMCUyMmMlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBOCUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBQiUyMiUyQyUyMCUyMmUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRCUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVBRiUyMiUyQyUyMCUyMmklMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCNiUyMiUyQyUyMCUyMm8lMjIpJTJDJTBBJTIwJTIwJTIwJTIwKCUyMiVDMyVCQyUyMiUyQyUyMCUyMnUlMjIpJTJDJTBBJTVEJTBBJTBBJTBBZGVmJTIwY2xlYW51cF90ZXh0KGlucHV0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBzcmMlMkMlMjBkc3QlMjBpbiUyMHJlcGxhY2VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RCUyMCUzRCUyMGlucHV0cyU1QiUyMm5vcm1hbGl6ZWRfdGV4dCUyMiU1RC5yZXBsYWNlKHNyYyUyQyUyMGRzdCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAoY2xlYW51cF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>replacements = [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;à&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ç&quot;</span>, <span class="hljs-string">&quot;c&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;è&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ë&quot;</span>, <span class="hljs-string">&quot;e&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;í&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ï&quot;</span>, <span class="hljs-string">&quot;i&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ö&quot;</span>, <span class="hljs-string">&quot;o&quot;</span>),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;ü&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>),
<span class="hljs-meta">... </span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup_text</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> src, dst <span class="hljs-keyword">in</span> replacements:
<span class="hljs-meta">... </span>        inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>] = inputs[<span class="hljs-string">&quot;normalized_text&quot;</span>].replace(src, dst)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(cleanup_text)`,wrap:!1}}),Me=new b({props:{title:"Speakers",local:"speakers",headingTag:"h3"}}),ye=new d({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEFzcGVha2VyX2NvdW50cyUyMCUzRCUyMGRlZmF1bHRkaWN0KGludCklMEElMEFmb3IlMjBzcGVha2VyX2lkJTIwaW4lMjBkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCUzQSUwQSUyMCUyMCUyMCUyMHNwZWFrZXJfY291bnRzJTVCc3BlYWtlcl9pZCU1RCUyMCUyQiUzRCUyMDE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_counts = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> speaker_id <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]:
<span class="hljs-meta">... </span>    speaker_counts[speaker_id] += <span class="hljs-number">1</span>`,wrap:!1}}),ge=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5oaXN0KHNwZWFrZXJfY291bnRzLnZhbHVlcygpJTJDJTIwYmlucyUzRDIwKSUwQXBsdC55bGFiZWwoJTIyU3BlYWtlcnMlMjIpJTBBcGx0LnhsYWJlbCglMjJFeGFtcGxlcyUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.hist(speaker_counts.values(), bins=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.ylabel(<span class="hljs-string">&quot;Speakers&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.xlabel(<span class="hljs-string">&quot;Examples&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),we=new d({props:{code:"ZGVmJTIwc2VsZWN0X3NwZWFrZXIoc3BlYWtlcl9pZCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjAxMDAlMjAlM0MlM0QlMjBzcGVha2VyX2NvdW50cyU1QnNwZWFrZXJfaWQlNUQlMjAlM0MlM0QlMjA0MDAlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5maWx0ZXIoc2VsZWN0X3NwZWFrZXIlMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyc3BlYWtlcl9pZCUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">select_speaker</span>(<span class="hljs-params">speaker_id</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-number">100</span> &lt;= speaker_counts[speaker_id] &lt;= <span class="hljs-number">400</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(select_speaker, input_columns=[<span class="hljs-string">&quot;speaker_id&quot;</span>])`,wrap:!1}}),Te=new d({props:{code:"bGVuKHNldChkYXRhc2V0JTVCJTIyc3BlYWtlcl9pZCUyMiU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(<span class="hljs-built_in">set</span>(dataset[<span class="hljs-string">&quot;speaker_id&quot;</span>]))
<span class="hljs-number">42</span>`,wrap:!1}}),Ue=new d({props:{code:"bGVuKGRhdGFzZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">9973</span>`,wrap:!1}}),ke=new b({props:{title:"Speaker embeddings",local:"speaker-embeddings",headingTag:"h3"}}),Ze=new d({props:{code:"aW1wb3J0JTIwb3MlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBzcGVlY2hicmFpbi5wcmV0cmFpbmVkJTIwaW1wb3J0JTIwRW5jb2RlckNsYXNzaWZpZXIlMEElMEFzcGtfbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnNwZWVjaGJyYWluJTJGc3BrcmVjLXh2ZWN0LXZveGNlbGViJTIyJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEFzcGVha2VyX21vZGVsJTIwJTNEJTIwRW5jb2RlckNsYXNzaWZpZXIuZnJvbV9ocGFyYW1zKCUwQSUyMCUyMCUyMCUyMHNvdXJjZSUzRHNwa19tb2RlbF9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwcnVuX29wdHMlM0QlN0IlMjJkZXZpY2UlMjIlM0ElMjBkZXZpY2UlN0QlMkMlMEElMjAlMjAlMjAlMjBzYXZlZGlyJTNEb3MucGF0aC5qb2luKCUyMiUyRnRtcCUyMiUyQyUyMHNwa19tb2RlbF9uYW1lKSUyQyUwQSklMEElMEElMEFkZWYlMjBjcmVhdGVfc3BlYWtlcl9lbWJlZGRpbmcod2F2ZWZvcm0pJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwZWFrZXJfZW1iZWRkaW5ncyUyMCUzRCUyMHNwZWFrZXJfbW9kZWwuZW5jb2RlX2JhdGNoKHRvcmNoLnRlbnNvcih3YXZlZm9ybSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5ub3JtYWxpemUoc3BlYWtlcl9lbWJlZGRpbmdzJTJDJTIwZGltJTNEMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGVha2VyX2VtYmVkZGluZ3MlMjAlM0QlMjBzcGVha2VyX2VtYmVkZGluZ3Muc3F1ZWV6ZSgpLmNwdSgpLm51bXB5KCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzcGVha2VyX2VtYmVkZGluZ3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> speechbrain.pretrained <span class="hljs-keyword">import</span> EncoderClassifier

<span class="hljs-meta">&gt;&gt;&gt; </span>spk_model_name = <span class="hljs-string">&quot;speechbrain/spkrec-xvect-voxceleb&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_model = EncoderClassifier.from_hparams(
<span class="hljs-meta">... </span>    source=spk_model_name,
<span class="hljs-meta">... </span>    run_opts={<span class="hljs-string">&quot;device&quot;</span>: device},
<span class="hljs-meta">... </span>    savedir=os.path.join(<span class="hljs-string">&quot;/tmp&quot;</span>, spk_model_name),
<span class="hljs-meta">... </span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_speaker_embedding</span>(<span class="hljs-params">waveform</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_model.encode_batch(torch.tensor(waveform))
<span class="hljs-meta">... </span>        speaker_embeddings = torch.nn.functional.normalize(speaker_embeddings, dim=<span class="hljs-number">2</span>)
<span class="hljs-meta">... </span>        speaker_embeddings = speaker_embeddings.squeeze().cpu().numpy()
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> speaker_embeddings`,wrap:!1}}),Ge=new b({props:{title:"Processing the dataset",local:"processing-the-dataset",headingTag:"h3"}}),Be=new d({props:{code:"ZGVmJTIwcHJlcGFyZV9kYXRhc2V0KGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwYXVkaW8lMjAlM0QlMjBleGFtcGxlJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRleHQlM0RleGFtcGxlJTVCJTIybm9ybWFsaXplZF90ZXh0JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXVkaW9fdGFyZ2V0JTNEYXVkaW8lNUIlMjJhcnJheSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RhdWRpbyU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm5fYXR0ZW50aW9uX21hc2slM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBzdHJpcCUyMG9mZiUyMHRoZSUyMGJhdGNoJTIwZGltZW5zaW9uJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGV4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQlNUIwJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwdXNlJTIwU3BlZWNoQnJhaW4lMjB0byUyMG9idGFpbiUyMHgtdmVjdG9yJTBBJTIwJTIwJTIwJTIwZXhhbXBsZSU1QiUyMnNwZWFrZXJfZW1iZWRkaW5ncyUyMiU1RCUyMCUzRCUyMGNyZWF0ZV9zcGVha2VyX2VtYmVkZGluZyhhdWRpbyU1QiUyMmFycmF5JTIyJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prepare_dataset</span>(<span class="hljs-params">example</span>):
<span class="hljs-meta">... </span>    audio = example[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">... </span>    example = processor(
<span class="hljs-meta">... </span>        text=example[<span class="hljs-string">&quot;normalized_text&quot;</span>],
<span class="hljs-meta">... </span>        audio_target=audio[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>        sampling_rate=audio[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>        return_attention_mask=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    <span class="hljs-comment"># strip off the batch dimension</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;labels&quot;</span>] = example[<span class="hljs-string">&quot;labels&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>    <span class="hljs-comment"># use SpeechBrain to obtain x-vector</span>
<span class="hljs-meta">... </span>    example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = create_speaker_embedding(audio[<span class="hljs-string">&quot;array&quot;</span>])

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> example`,wrap:!1}}),Re=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlMjAlM0QlMjBwcmVwYXJlX2RhdGFzZXQoZGF0YXNldCU1QjAlNUQpJTBBbGlzdChwcm9jZXNzZWRfZXhhbXBsZS5rZXlzKCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example = prepare_dataset(dataset[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(processed_example.keys())
[<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>, <span class="hljs-string">&#x27;stop_labels&#x27;</span>, <span class="hljs-string">&#x27;speaker_embeddings&#x27;</span>]`,wrap:!1}}),Ye=new d({props:{code:"cHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQuc2hhcGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>].shape
(<span class="hljs-number">512</span>,)`,wrap:!1}}),Qe=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5maWd1cmUoKSUwQXBsdC5pbXNob3cocHJvY2Vzc2VkX2V4YW1wbGUlNUIlMjJsYWJlbHMlMjIlNUQuVCklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(processed_example[<span class="hljs-string">&quot;labels&quot;</span>].T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),qe=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKHByZXBhcmVfZGF0YXNldCUyQyUyMHJlbW92ZV9jb2x1bW5zJTNEZGF0YXNldC5jb2x1bW5fbmFtZXMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(prepare_dataset, remove_columns=dataset.column_names)',wrap:!1}}),Ae=new d({props:{code:"ZGVmJTIwaXNfbm90X3Rvb19sb25nKGlucHV0X2lkcyklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9sZW5ndGglMjAlM0QlMjBsZW4oaW5wdXRfaWRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0X2xlbmd0aCUyMCUzQyUyMDIwMCUwQSUwQSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LmZpbHRlcihpc19ub3RfdG9vX2xvbmclMkMlMjBpbnB1dF9jb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQWxlbihkYXRhc2V0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">is_not_too_long</span>(<span class="hljs-params">input_ids</span>):
<span class="hljs-meta">... </span>    input_length = <span class="hljs-built_in">len</span>(input_ids)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> input_length &lt; <span class="hljs-number">200</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">filter</span>(is_not_too_long, input_columns=[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(dataset)
<span class="hljs-number">8259</span>`,wrap:!1}}),Se=new d({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQudHJhaW5fdGVzdF9zcGxpdCh0ZXN0X3NpemUlM0QwLjEp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.train_test_split(test_size=<span class="hljs-number">0.1</span>)',wrap:!1}}),Pe=new b({props:{title:"Data collator",local:"data-collator",headingTag:"h3"}}),De=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Union</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TTSDataCollatorWithPadding</span>:
<span class="hljs-meta">... </span>    processor: <span class="hljs-type">Any</span>

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, features: <span class="hljs-type">List</span>[<span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Union</span>[<span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>], torch.Tensor]]]</span>) -&gt; <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
<span class="hljs-meta">... </span>        input_ids = [{<span class="hljs-string">&quot;input_ids&quot;</span>: feature[<span class="hljs-string">&quot;input_ids&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        label_features = [{<span class="hljs-string">&quot;input_values&quot;</span>: feature[<span class="hljs-string">&quot;labels&quot;</span>]} <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]
<span class="hljs-meta">... </span>        speaker_features = [feature[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> features]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># collate the inputs and targets into a batch</span>
<span class="hljs-meta">... </span>        batch = processor.pad(input_ids=input_ids, labels=label_features, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># replace padding with -100 to ignore loss correctly</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>].masked_fill(batch.decoder_attention_mask.unsqueeze(-<span class="hljs-number">1</span>).ne(<span class="hljs-number">1</span>), -<span class="hljs-number">100</span>)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># not used during fine-tuning</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">del</span> batch[<span class="hljs-string">&quot;decoder_attention_mask&quot;</span>]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># round down target lengths to multiple of reduction factor</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> model.config.reduction_factor &gt; <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>            target_lengths = torch.tensor([<span class="hljs-built_in">len</span>(feature[<span class="hljs-string">&quot;input_values&quot;</span>]) <span class="hljs-keyword">for</span> feature <span class="hljs-keyword">in</span> label_features])
<span class="hljs-meta">... </span>            target_lengths = target_lengths.new(
<span class="hljs-meta">... </span>                [length - length % model.config.reduction_factor <span class="hljs-keyword">for</span> length <span class="hljs-keyword">in</span> target_lengths]
<span class="hljs-meta">... </span>            )
<span class="hljs-meta">... </span>            max_length = <span class="hljs-built_in">max</span>(target_lengths)
<span class="hljs-meta">... </span>            batch[<span class="hljs-string">&quot;labels&quot;</span>] = batch[<span class="hljs-string">&quot;labels&quot;</span>][:, :max_length]

<span class="hljs-meta">... </span>        <span class="hljs-comment"># also add in the speaker embeddings</span>
<span class="hljs-meta">... </span>        batch[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>] = torch.tensor(speaker_features)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> batch`,wrap:!1}}),Oe=new d({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMFRUU0RhdGFDb2xsYXRvcldpdGhQYWRkaW5nKHByb2Nlc3NvciUzRHByb2Nlc3Nvcik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = TTSDataCollatorWithPadding(processor=processor)',wrap:!1}}),et=new b({props:{title:"Train the model",local:"train-the-model",headingTag:"h2"}}),st=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwZWVjaFQ1Rm9yVGV4dFRvU3BlZWNoJTBBJTBBbW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SpeechT5ForTextToSpeech

<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(checkpoint)`,wrap:!1}}),lt=new d({props:{code:"bW9kZWwuY29uZmlnLnVzZV9jYWNoZSUyMCUzRCUyMEZhbHNl",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.use_cache = <span class="hljs-literal">False</span>',wrap:!1}}),pt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmluZ0FyZ3VtZW50cyUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBTZXEyU2VxVHJhaW5pbmdBcmd1bWVudHMoJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIlMkMlMjAlMjAlMjMlMjBjaGFuZ2UlMjB0byUyMGElMjByZXBvJTIwbmFtZSUyMG9mJTIweW91ciUyMGNob2ljZSUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q4JTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDFlLTUlMkMlMEElMjAlMjAlMjAlMjB3YXJtdXBfc3RlcHMlM0Q1MDAlMkMlMEElMjAlMjAlMjAlMjBtYXhfc3RlcHMlM0Q0MDAwJTJDJTBBJTIwJTIwJTIwJTIwZ3JhZGllbnRfY2hlY2twb2ludGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0QxMDAwJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9zdGVwcyUzRDEwMDAlMkMlMEElMjAlMjAlMjAlMjBsb2dnaW5nX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjByZXBvcnRfdG8lM0QlNUIlMjJ0ZW5zb3Jib2FyZCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZ3JlYXRlcl9pc19iZXR0ZXIlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX25hbWVzJTNEJTVCJTIybGFiZWxzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = Seq2SeqTrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;speecht5_finetuned_voxpopuli_nl&quot;</span>,  <span class="hljs-comment"># change to a repo name of your choice</span>
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    gradient_accumulation_steps=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">1e-5</span>,
<span class="hljs-meta">... </span>    warmup_steps=<span class="hljs-number">500</span>,
<span class="hljs-meta">... </span>    max_steps=<span class="hljs-number">4000</span>,
<span class="hljs-meta">... </span>    gradient_checkpointing=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    fp16=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    eval_steps=<span class="hljs-number">1000</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">25</span>,
<span class="hljs-meta">... </span>    report_to=[<span class="hljs-string">&quot;tensorboard&quot;</span>],
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    greater_is_better=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ot=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlcTJTZXFUcmFpbmVyJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNlcTJTZXFUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEcHJvY2Vzc29yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Seq2SeqTrainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Seq2SeqTrainer(
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    train_dataset=dataset[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=dataset[<span class="hljs-string">&quot;test&quot;</span>],
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),ct=new d({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),mt=new d({props:{code:"cHJvY2Vzc29yLnNhdmVfcHJldHJhaW5lZCglMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>processor.save_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),Mt=new d({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),dt=new b({props:{title:"Inference",local:"inference",headingTag:"h2"}}),yt=new b({props:{title:"Inference with a pipeline",local:"inference-with-a-pipeline",headingTag:"h3"}}),gt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtdG8tc3BlZWNoJTIyJTJDJTIwbW9kZWwlM0QlMjJZT1VSX0FDQ09VTlRfTkFNRSUyRnNwZWVjaHQ1X2ZpbmV0dW5lZF92b3hwb3B1bGlfbmwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;text-to-speech&quot;</span>, model=<span class="hljs-string">&quot;YOUR_ACCOUNT_NAME/speecht5_finetuned_voxpopuli_nl&quot;</span>)`,wrap:!1}}),wt=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMg==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>',wrap:!1}}),Tt=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),Ut=new d({props:{code:"Zm9yd2FyZF9wYXJhbXMlMjAlM0QlMjAlN0IlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlM0ElMjBzcGVha2VyX2VtYmVkZGluZ3MlN0QlMEFvdXRwdXQlMjAlM0QlMjBwaXBlKHRleHQlMkMlMjBmb3J3YXJkX3BhcmFtcyUzRGZvcndhcmRfcGFyYW1zKSUwQW91dHB1dA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>forward_params = {<span class="hljs-string">&quot;speaker_embeddings&quot;</span>: speaker_embeddings}
<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(text, forward_params=forward_params)
<span class="hljs-meta">&gt;&gt;&gt; </span>output
{<span class="hljs-string">&#x27;audio&#x27;</span>: array([-<span class="hljs-number">6.82714235e-05</span>, -<span class="hljs-number">4.26525949e-04</span>,  <span class="hljs-number">1.06134125e-04</span>, ...,
        -<span class="hljs-number">1.22392643e-03</span>, -<span class="hljs-number">7.76011671e-04</span>,  <span class="hljs-number">3.29112721e-04</span>], dtype=float32),
 <span class="hljs-string">&#x27;sampling_rate&#x27;</span>: <span class="hljs-number">16000</span>}`,wrap:!1}}),$t=new d({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBQXVkaW8ob3V0cHV0JTVCJ2F1ZGlvJyU1RCUyQyUyMHJhdGUlM0RvdXRwdXQlNUInc2FtcGxpbmdfcmF0ZSclNUQpJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio
<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(output[<span class="hljs-string">&#x27;audio&#x27;</span>], rate=output[<span class="hljs-string">&#x27;sampling_rate&#x27;</span>]) `,wrap:!1}}),kt=new b({props:{title:"Run inference manually",local:"run-inference-manually",headingTag:"h3"}}),Zt=new d({props:{code:"bW9kZWwlMjAlM0QlMjBTcGVlY2hUNUZvclRleHRUb1NwZWVjaC5mcm9tX3ByZXRyYWluZWQoJTIyWU9VUl9BQ0NPVU5UJTJGc3BlZWNodDVfZmluZXR1bmVkX3ZveHBvcHVsaV9ubCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = SpeechT5ForTextToSpeech.from_pretrained(<span class="hljs-string">&quot;YOUR_ACCOUNT/speecht5_finetuned_voxpopuli_nl&quot;</span>)',wrap:!1}}),Vt=new d({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCMzA0JTVEJTBBc3BlYWtlcl9lbWJlZGRpbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKGV4YW1wbGUlNUIlMjJzcGVha2VyX2VtYmVkZGluZ3MlMjIlNUQpLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-number">304</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>speaker_embeddings = torch.tensor(example[<span class="hljs-string">&quot;speaker_embeddings&quot;</span>]).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),_t=new d({props:{code:"dGV4dCUyMCUzRCUyMCUyMmhhbGxvJTIwYWxsZW1hYWwlMkMlMjBpayUyMHByYWF0JTIwbmVkZXJsYW5kcy4lMjBncm9ldGplcyUyMGFhbiUyMGllZGVyZWVuISUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hallo allemaal, ik praat nederlands. groetjes aan iedereen!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Wt=new d({props:{code:"c3BlY3Ryb2dyYW0lMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZV9zcGVlY2goaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwc3BlYWtlcl9lbWJlZGRpbmdzKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>spectrogram = model.generate_speech(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], speaker_embeddings)',wrap:!1}}),Xt=new d({props:{code:"cGx0LmZpZ3VyZSgpJTBBcGx0Lmltc2hvdyhzcGVjdHJvZ3JhbS5UKSUwQXBsdC5zaG93KCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>plt.figure()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(spectrogram.T)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),zt=new d({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMHNwZWVjaCUyMCUzRCUyMHZvY29kZXIoc3BlY3Ryb2dyYW0pJTBBJTBBZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBQXVkaW8oc3BlZWNoLm51bXB5KCklMkMlMjByYXRlJTNEMTYwMDAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    speech = vocoder(spectrogram)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

<span class="hljs-meta">&gt;&gt;&gt; </span>Audio(speech.numpy(), rate=<span class="hljs-number">16000</span>)`,wrap:!1}}),{c(){j=p("meta"),v=l(),U=p("p"),w=l(),r(J.$$.fragment),T=l(),r(C.$$.fragment),$=l(),g=p("p"),g.innerHTML=V,y=l(),f=p("p"),f.innerHTML=cl,Et=l(),r(G.$$.fragment),St=l(),_=p("p"),_.textContent=hl,Pt=l(),r(B.$$.fragment),Lt=l(),W=p("p"),W.innerHTML=ml,Dt=l(),R=p("p"),R.textContent=ul,Kt=l(),X=p("p"),X.textContent=Ml,Ot=l(),Y=p("ol"),Y.innerHTML=dl,es=l(),z=p("p"),z.textContent=yl,ts=l(),r(Q.$$.fragment),ss=l(),N=p("p"),N.textContent=jl,as=l(),r(F.$$.fragment),ls=l(),r(k.$$.fragment),ns=l(),q=p("p"),q.textContent=gl,ps=l(),r(H.$$.fragment),is=l(),r(A.$$.fragment),os=l(),E=p("p"),E.innerHTML=fl,rs=l(),S=p("p"),S.textContent=wl,cs=l(),P=p("p"),P.textContent=Jl,hs=l(),r(L.$$.fragment),ms=l(),D=p("p"),D.textContent=Tl,us=l(),r(K.$$.fragment),Ms=l(),r(O.$$.fragment),ds=l(),ee=p("p"),ee.textContent=bl,ys=l(),r(te.$$.fragment),js=l(),r(se.$$.fragment),gs=l(),ae=p("p"),ae.textContent=Ul,fs=l(),r(le.$$.fragment),ws=l(),ne=p("p"),ne.innerHTML=Cl,Js=l(),pe=p("p"),pe.innerHTML=$l,Ts=l(),ie=p("p"),ie.innerHTML=kl,bs=l(),r(oe.$$.fragment),Us=l(),re=p("p"),re.textContent=Il,Cs=l(),r(ce.$$.fragment),$s=l(),he=p("p"),he.innerHTML=xl,ks=l(),r(me.$$.fragment),Is=l(),ue=p("p"),ue.textContent=Zl,xs=l(),r(Me.$$.fragment),Zs=l(),de=p("p"),de.textContent=vl,vs=l(),r(ye.$$.fragment),Vs=l(),je=p("p"),je.textContent=Vl,Gs=l(),r(ge.$$.fragment),_s=l(),I=p("div"),I.innerHTML=Gl,Bs=l(),fe=p("p"),fe.textContent=_l,Ws=l(),r(we.$$.fragment),Rs=l(),Je=p("p"),Je.textContent=Bl,Xs=l(),r(Te.$$.fragment),Ys=l(),be=p("p"),be.textContent=Wl,zs=l(),r(Ue.$$.fragment),Qs=l(),Ce=p("p"),Ce.textContent=Rl,Ns=l(),$e=p("p"),$e.textContent=Xl,Fs=l(),r(ke.$$.fragment),qs=l(),Ie=p("p"),Ie.innerHTML=Yl,Hs=l(),xe=p("p"),xe.innerHTML=zl,As=l(),r(Ze.$$.fragment),Es=l(),ve=p("p"),ve.innerHTML=Ql,Ss=l(),Ve=p("p"),Ve.textContent=Nl,Ps=l(),r(Ge.$$.fragment),Ls=l(),_e=p("p"),_e.innerHTML=Fl,Ds=l(),r(Be.$$.fragment),Ks=l(),We=p("p"),We.textContent=ql,Os=l(),r(Re.$$.fragment),ea=l(),Xe=p("p"),Xe.textContent=Hl,ta=l(),r(Ye.$$.fragment),sa=l(),ze=p("p"),ze.textContent=Al,aa=l(),r(Qe.$$.fragment),la=l(),x=p("div"),x.innerHTML=El,na=l(),Ne=p("p"),Ne.textContent=Sl,pa=l(),Fe=p("p"),Fe.textContent=Pl,ia=l(),r(qe.$$.fragment),oa=l(),He=p("p"),He.textContent=Ll,ra=l(),r(Ae.$$.fragment),ca=l(),Ee=p("p"),Ee.textContent=Dl,ha=l(),r(Se.$$.fragment),ma=l(),r(Pe.$$.fragment),ua=l(),Le=p("p"),Le.innerHTML=Kl,Ma=l(),r(De.$$.fragment),da=l(),Ke=p("p"),Ke.textContent=Ol,ya=l(),r(Oe.$$.fragment),ja=l(),r(et.$$.fragment),ga=l(),tt=p("p"),tt.textContent=en,fa=l(),r(st.$$.fragment),wa=l(),at=p("p"),at.innerHTML=tn,Ja=l(),r(lt.$$.fragment),Ta=l(),nt=p("p"),nt.textContent=sn,ba=l(),r(pt.$$.fragment),Ua=l(),it=p("p"),it.innerHTML=an,Ca=l(),r(ot.$$.fragment),$a=l(),rt=p("p"),rt.innerHTML=ln,ka=l(),r(ct.$$.fragment),Ia=l(),ht=p("p"),ht.textContent=nn,xa=l(),r(mt.$$.fragment),Za=l(),ut=p("p"),ut.textContent=pn,va=l(),r(Mt.$$.fragment),Va=l(),r(dt.$$.fragment),Ga=l(),r(yt.$$.fragment),_a=l(),jt=p("p"),jt.innerHTML=on,Ba=l(),r(gt.$$.fragment),Wa=l(),ft=p("p"),ft.textContent=rn,Ra=l(),r(wt.$$.fragment),Xa=l(),Jt=p("p"),Jt.textContent=cn,Ya=l(),r(Tt.$$.fragment),za=l(),bt=p("p"),bt.textContent=hn,Qa=l(),r(Ut.$$.fragment),Na=l(),Ct=p("p"),Ct.textContent=mn,Fa=l(),r($t.$$.fragment),qa=l(),r(kt.$$.fragment),Ha=l(),It=p("p"),It.textContent=un,Aa=l(),xt=p("p"),xt.textContent=Mn,Ea=l(),r(Zt.$$.fragment),Sa=l(),vt=p("p"),vt.textContent=dn,Pa=l(),r(Vt.$$.fragment),La=l(),Gt=p("p"),Gt.textContent=yn,Da=l(),r(_t.$$.fragment),Ka=l(),Bt=p("p"),Bt.textContent=jn,Oa=l(),r(Wt.$$.fragment),el=l(),Rt=p("p"),Rt.textContent=gn,tl=l(),r(Xt.$$.fragment),sl=l(),Z=p("div"),Z.innerHTML=fn,al=l(),Yt=p("p"),Yt.textContent=wn,ll=l(),r(zt.$$.fragment),nl=l(),Qt=p("p"),Qt.textContent=Jn,pl=l(),Nt=p("p"),Nt.innerHTML=Tn,il=l(),Ft=p("p"),Ft.textContent=bn,ol=l(),qt=p("p"),this.h()},l(e){const t=vn("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(s),v=n(e),U=i(e,"P",{}),Cn(U).forEach(s),w=n(e),c(J.$$.fragment,e),T=n(e),c(C.$$.fragment,e),$=n(e),g=i(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-l8vv5f"&&(g.innerHTML=V),y=n(e),f=i(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-onhyd5"&&(f.innerHTML=cl),Et=n(e),c(G.$$.fragment,e),St=n(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-8r9uzp"&&(_.textContent=hl),Pt=n(e),c(B.$$.fragment,e),Lt=n(e),W=i(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-jff0e4"&&(W.innerHTML=ml),Dt=n(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-c5wqzo"&&(R.textContent=ul),Kt=n(e),X=i(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-13pgbx8"&&(X.textContent=Ml),Ot=n(e),Y=i(e,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-16nfhgc"&&(Y.innerHTML=dl),es=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1c9nexd"&&(z.textContent=yl),ts=n(e),c(Q.$$.fragment,e),ss=n(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1pk9b4n"&&(N.textContent=jl),as=n(e),c(F.$$.fragment,e),ls=n(e),c(k.$$.fragment,e),ns=n(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-yib87s"&&(q.textContent=gl),ps=n(e),c(H.$$.fragment,e),is=n(e),c(A.$$.fragment,e),os=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1lfskuv"&&(E.innerHTML=fl),rs=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1smm6mj"&&(S.textContent=wl),cs=n(e),P=i(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1soaqfm"&&(P.textContent=Jl),hs=n(e),c(L.$$.fragment,e),ms=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1xdebij"&&(D.textContent=Tl),us=n(e),c(K.$$.fragment,e),Ms=n(e),c(O.$$.fragment,e),ds=n(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-1cfkf3a"&&(ee.textContent=bl),ys=n(e),c(te.$$.fragment,e),js=n(e),c(se.$$.fragment,e),gs=n(e),ae=i(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-1bseo5y"&&(ae.textContent=Ul),fs=n(e),c(le.$$.fragment,e),ws=n(e),ne=i(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-alux34"&&(ne.innerHTML=Cl),Js=n(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1qiuc1m"&&(pe.innerHTML=$l),Ts=n(e),ie=i(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-l4aof2"&&(ie.innerHTML=kl),bs=n(e),c(oe.$$.fragment,e),Us=n(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-fefaym"&&(re.textContent=Il),Cs=n(e),c(ce.$$.fragment,e),$s=n(e),he=i(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-1m7sgt2"&&(he.innerHTML=xl),ks=n(e),c(me.$$.fragment,e),Is=n(e),ue=i(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-k1jzc5"&&(ue.textContent=Zl),xs=n(e),c(Me.$$.fragment,e),Zs=n(e),de=i(e,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1edo483"&&(de.textContent=vl),vs=n(e),c(ye.$$.fragment,e),Vs=n(e),je=i(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1hah56a"&&(je.textContent=Vl),Gs=n(e),c(ge.$$.fragment,e),_s=n(e),I=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-1uufiik"&&(I.innerHTML=Gl),Bs=n(e),fe=i(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1ujf40"&&(fe.textContent=_l),Ws=n(e),c(we.$$.fragment,e),Rs=n(e),Je=i(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-g2dd32"&&(Je.textContent=Bl),Xs=n(e),c(Te.$$.fragment,e),Ys=n(e),be=i(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-hbes5t"&&(be.textContent=Wl),zs=n(e),c(Ue.$$.fragment,e),Qs=n(e),Ce=i(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-oizlk1"&&(Ce.textContent=Rl),Ns=n(e),$e=i(e,"P",{"data-svelte-h":!0}),o($e)!=="svelte-1n0u7fp"&&($e.textContent=Xl),Fs=n(e),c(ke.$$.fragment,e),qs=n(e),Ie=i(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1xdfpy2"&&(Ie.innerHTML=Yl),Hs=n(e),xe=i(e,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-7nncma"&&(xe.innerHTML=zl),As=n(e),c(Ze.$$.fragment,e),Es=n(e),ve=i(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-1mtxkxr"&&(ve.innerHTML=Ql),Ss=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-1az2ed"&&(Ve.textContent=Nl),Ps=n(e),c(Ge.$$.fragment,e),Ls=n(e),_e=i(e,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-1tlidee"&&(_e.innerHTML=Fl),Ds=n(e),c(Be.$$.fragment,e),Ks=n(e),We=i(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-17mzfft"&&(We.textContent=ql),Os=n(e),c(Re.$$.fragment,e),ea=n(e),Xe=i(e,"P",{"data-svelte-h":!0}),o(Xe)!=="svelte-1mqg4ck"&&(Xe.textContent=Hl),ta=n(e),c(Ye.$$.fragment,e),sa=n(e),ze=i(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-f7g58h"&&(ze.textContent=Al),aa=n(e),c(Qe.$$.fragment,e),la=n(e),x=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-j4o1b8"&&(x.innerHTML=El),na=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1t9vz0y"&&(Ne.textContent=Sl),pa=n(e),Fe=i(e,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-1r5jy40"&&(Fe.textContent=Pl),ia=n(e),c(qe.$$.fragment,e),oa=n(e),He=i(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-wvyh3r"&&(He.textContent=Ll),ra=n(e),c(Ae.$$.fragment,e),ca=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),o(Ee)!=="svelte-12gx63x"&&(Ee.textContent=Dl),ha=n(e),c(Se.$$.fragment,e),ma=n(e),c(Pe.$$.fragment,e),ua=n(e),Le=i(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-1qadcxm"&&(Le.innerHTML=Kl),Ma=n(e),c(De.$$.fragment,e),da=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-u623yc"&&(Ke.textContent=Ol),ya=n(e),c(Oe.$$.fragment,e),ja=n(e),c(et.$$.fragment,e),ga=n(e),tt=i(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-1kkriue"&&(tt.textContent=en),fa=n(e),c(st.$$.fragment,e),wa=n(e),at=i(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-15xsopr"&&(at.innerHTML=tn),Ja=n(e),c(lt.$$.fragment,e),Ta=n(e),nt=i(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-11l73nm"&&(nt.textContent=sn),ba=n(e),c(pt.$$.fragment,e),Ua=n(e),it=i(e,"P",{"data-svelte-h":!0}),o(it)!=="svelte-1yq1u47"&&(it.innerHTML=an),Ca=n(e),c(ot.$$.fragment,e),$a=n(e),rt=i(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-1qh8b8v"&&(rt.innerHTML=ln),ka=n(e),c(ct.$$.fragment,e),Ia=n(e),ht=i(e,"P",{"data-svelte-h":!0}),o(ht)!=="svelte-pldkg9"&&(ht.textContent=nn),xa=n(e),c(mt.$$.fragment,e),Za=n(e),ut=i(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-hefgo2"&&(ut.textContent=pn),va=n(e),c(Mt.$$.fragment,e),Va=n(e),c(dt.$$.fragment,e),Ga=n(e),c(yt.$$.fragment,e),_a=n(e),jt=i(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1jgqgi3"&&(jt.innerHTML=on),Ba=n(e),c(gt.$$.fragment,e),Wa=n(e),ft=i(e,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-1jnrzsv"&&(ft.textContent=rn),Ra=n(e),c(wt.$$.fragment,e),Xa=n(e),Jt=i(e,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-1kvctpa"&&(Jt.textContent=cn),Ya=n(e),c(Tt.$$.fragment,e),za=n(e),bt=i(e,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-n7ysoq"&&(bt.textContent=hn),Qa=n(e),c(Ut.$$.fragment,e),Na=n(e),Ct=i(e,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-1rln9cy"&&(Ct.textContent=mn),Fa=n(e),c($t.$$.fragment,e),qa=n(e),c(kt.$$.fragment,e),Ha=n(e),It=i(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1r1hsi3"&&(It.textContent=un),Aa=n(e),xt=i(e,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-1ydpy0n"&&(xt.textContent=Mn),Ea=n(e),c(Zt.$$.fragment,e),Sa=n(e),vt=i(e,"P",{"data-svelte-h":!0}),o(vt)!=="svelte-fmd5zf"&&(vt.textContent=dn),Pa=n(e),c(Vt.$$.fragment,e),La=n(e),Gt=i(e,"P",{"data-svelte-h":!0}),o(Gt)!=="svelte-1611eam"&&(Gt.textContent=yn),Da=n(e),c(_t.$$.fragment,e),Ka=n(e),Bt=i(e,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-eurn6"&&(Bt.textContent=jn),Oa=n(e),c(Wt.$$.fragment,e),el=n(e),Rt=i(e,"P",{"data-svelte-h":!0}),o(Rt)!=="svelte-iofzmb"&&(Rt.textContent=gn),tl=n(e),c(Xt.$$.fragment,e),sl=n(e),Z=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-16b2dt6"&&(Z.innerHTML=fn),al=n(e),Yt=i(e,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-chmo02"&&(Yt.textContent=wn),ll=n(e),c(zt.$$.fragment,e),nl=n(e),Qt=i(e,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-1fdujzv"&&(Qt.textContent=Jn),pl=n(e),Nt=i(e,"P",{"data-svelte-h":!0}),o(Nt)!=="svelte-6lmfh0"&&(Nt.innerHTML=Tn),il=n(e),Ft=i(e,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-1mo0fd"&&(Ft.textContent=bn),ol=n(e),qt=i(e,"P",{}),Cn(qt).forEach(s),this.h()},h(){Ht(j,"name","hf:doc:metadata"),Ht(j,"content",Rn),Ht(I,"class","flex justify-center"),Ht(x,"class","flex justify-center"),Ht(Z,"class","flex justify-center")},m(e,t){Vn(document.head,j),a(e,v,t),a(e,U,t),a(e,w,t),h(J,e,t),a(e,T,t),h(C,e,t),a(e,$,t),a(e,g,t),a(e,y,t),a(e,f,t),a(e,Et,t),h(G,e,t),a(e,St,t),a(e,_,t),a(e,Pt,t),h(B,e,t),a(e,Lt,t),a(e,W,t),a(e,Dt,t),a(e,R,t),a(e,Kt,t),a(e,X,t),a(e,Ot,t),a(e,Y,t),a(e,es,t),a(e,z,t),a(e,ts,t),h(Q,e,t),a(e,ss,t),a(e,N,t),a(e,as,t),h(F,e,t),a(e,ls,t),h(k,e,t),a(e,ns,t),a(e,q,t),a(e,ps,t),h(H,e,t),a(e,is,t),h(A,e,t),a(e,os,t),a(e,E,t),a(e,rs,t),a(e,S,t),a(e,cs,t),a(e,P,t),a(e,hs,t),h(L,e,t),a(e,ms,t),a(e,D,t),a(e,us,t),h(K,e,t),a(e,Ms,t),h(O,e,t),a(e,ds,t),a(e,ee,t),a(e,ys,t),h(te,e,t),a(e,js,t),h(se,e,t),a(e,gs,t),a(e,ae,t),a(e,fs,t),h(le,e,t),a(e,ws,t),a(e,ne,t),a(e,Js,t),a(e,pe,t),a(e,Ts,t),a(e,ie,t),a(e,bs,t),h(oe,e,t),a(e,Us,t),a(e,re,t),a(e,Cs,t),h(ce,e,t),a(e,$s,t),a(e,he,t),a(e,ks,t),h(me,e,t),a(e,Is,t),a(e,ue,t),a(e,xs,t),h(Me,e,t),a(e,Zs,t),a(e,de,t),a(e,vs,t),h(ye,e,t),a(e,Vs,t),a(e,je,t),a(e,Gs,t),h(ge,e,t),a(e,_s,t),a(e,I,t),a(e,Bs,t),a(e,fe,t),a(e,Ws,t),h(we,e,t),a(e,Rs,t),a(e,Je,t),a(e,Xs,t),h(Te,e,t),a(e,Ys,t),a(e,be,t),a(e,zs,t),h(Ue,e,t),a(e,Qs,t),a(e,Ce,t),a(e,Ns,t),a(e,$e,t),a(e,Fs,t),h(ke,e,t),a(e,qs,t),a(e,Ie,t),a(e,Hs,t),a(e,xe,t),a(e,As,t),h(Ze,e,t),a(e,Es,t),a(e,ve,t),a(e,Ss,t),a(e,Ve,t),a(e,Ps,t),h(Ge,e,t),a(e,Ls,t),a(e,_e,t),a(e,Ds,t),h(Be,e,t),a(e,Ks,t),a(e,We,t),a(e,Os,t),h(Re,e,t),a(e,ea,t),a(e,Xe,t),a(e,ta,t),h(Ye,e,t),a(e,sa,t),a(e,ze,t),a(e,aa,t),h(Qe,e,t),a(e,la,t),a(e,x,t),a(e,na,t),a(e,Ne,t),a(e,pa,t),a(e,Fe,t),a(e,ia,t),h(qe,e,t),a(e,oa,t),a(e,He,t),a(e,ra,t),h(Ae,e,t),a(e,ca,t),a(e,Ee,t),a(e,ha,t),h(Se,e,t),a(e,ma,t),h(Pe,e,t),a(e,ua,t),a(e,Le,t),a(e,Ma,t),h(De,e,t),a(e,da,t),a(e,Ke,t),a(e,ya,t),h(Oe,e,t),a(e,ja,t),h(et,e,t),a(e,ga,t),a(e,tt,t),a(e,fa,t),h(st,e,t),a(e,wa,t),a(e,at,t),a(e,Ja,t),h(lt,e,t),a(e,Ta,t),a(e,nt,t),a(e,ba,t),h(pt,e,t),a(e,Ua,t),a(e,it,t),a(e,Ca,t),h(ot,e,t),a(e,$a,t),a(e,rt,t),a(e,ka,t),h(ct,e,t),a(e,Ia,t),a(e,ht,t),a(e,xa,t),h(mt,e,t),a(e,Za,t),a(e,ut,t),a(e,va,t),h(Mt,e,t),a(e,Va,t),h(dt,e,t),a(e,Ga,t),h(yt,e,t),a(e,_a,t),a(e,jt,t),a(e,Ba,t),h(gt,e,t),a(e,Wa,t),a(e,ft,t),a(e,Ra,t),h(wt,e,t),a(e,Xa,t),a(e,Jt,t),a(e,Ya,t),h(Tt,e,t),a(e,za,t),a(e,bt,t),a(e,Qa,t),h(Ut,e,t),a(e,Na,t),a(e,Ct,t),a(e,Fa,t),h($t,e,t),a(e,qa,t),h(kt,e,t),a(e,Ha,t),a(e,It,t),a(e,Aa,t),a(e,xt,t),a(e,Ea,t),h(Zt,e,t),a(e,Sa,t),a(e,vt,t),a(e,Pa,t),h(Vt,e,t),a(e,La,t),a(e,Gt,t),a(e,Da,t),h(_t,e,t),a(e,Ka,t),a(e,Bt,t),a(e,Oa,t),h(Wt,e,t),a(e,el,t),a(e,Rt,t),a(e,tl,t),h(Xt,e,t),a(e,sl,t),a(e,Z,t),a(e,al,t),a(e,Yt,t),a(e,ll,t),h(zt,e,t),a(e,nl,t),a(e,Qt,t),a(e,pl,t),a(e,Nt,t),a(e,il,t),a(e,Ft,t),a(e,ol,t),a(e,qt,t),rl=!0},p(e,[t]){const Un={};t&2&&(Un.$$scope={dirty:t,ctx:e}),k.$set(Un)},i(e){rl||(m(J.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(B.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(k.$$.fragment,e),m(H.$$.fragment,e),m(A.$$.fragment,e),m(L.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),m(te.$$.fragment,e),m(se.$$.fragment,e),m(le.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(ge.$$.fragment,e),m(we.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(ke.$$.fragment,e),m(Ze.$$.fragment,e),m(Ge.$$.fragment,e),m(Be.$$.fragment,e),m(Re.$$.fragment,e),m(Ye.$$.fragment,e),m(Qe.$$.fragment,e),m(qe.$$.fragment,e),m(Ae.$$.fragment,e),m(Se.$$.fragment,e),m(Pe.$$.fragment,e),m(De.$$.fragment,e),m(Oe.$$.fragment,e),m(et.$$.fragment,e),m(st.$$.fragment,e),m(lt.$$.fragment,e),m(pt.$$.fragment,e),m(ot.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(Mt.$$.fragment,e),m(dt.$$.fragment,e),m(yt.$$.fragment,e),m(gt.$$.fragment,e),m(wt.$$.fragment,e),m(Tt.$$.fragment,e),m(Ut.$$.fragment,e),m($t.$$.fragment,e),m(kt.$$.fragment,e),m(Zt.$$.fragment,e),m(Vt.$$.fragment,e),m(_t.$$.fragment,e),m(Wt.$$.fragment,e),m(Xt.$$.fragment,e),m(zt.$$.fragment,e),rl=!0)},o(e){u(J.$$.fragment,e),u(C.$$.fragment,e),u(G.$$.fragment,e),u(B.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(k.$$.fragment,e),u(H.$$.fragment,e),u(A.$$.fragment,e),u(L.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(ge.$$.fragment,e),u(we.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Ze.$$.fragment,e),u(Ge.$$.fragment,e),u(Be.$$.fragment,e),u(Re.$$.fragment,e),u(Ye.$$.fragment,e),u(Qe.$$.fragment,e),u(qe.$$.fragment,e),u(Ae.$$.fragment,e),u(Se.$$.fragment,e),u(Pe.$$.fragment,e),u(De.$$.fragment,e),u(Oe.$$.fragment,e),u(et.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(pt.$$.fragment,e),u(ot.$$.fragment,e),u(ct.$$.fragment,e),u(mt.$$.fragment,e),u(Mt.$$.fragment,e),u(dt.$$.fragment,e),u(yt.$$.fragment,e),u(gt.$$.fragment,e),u(wt.$$.fragment,e),u(Tt.$$.fragment,e),u(Ut.$$.fragment,e),u($t.$$.fragment,e),u(kt.$$.fragment,e),u(Zt.$$.fragment,e),u(Vt.$$.fragment,e),u(_t.$$.fragment,e),u(Wt.$$.fragment,e),u(Xt.$$.fragment,e),u(zt.$$.fragment,e),rl=!1},d(e){e&&(s(v),s(U),s(w),s(T),s($),s(g),s(y),s(f),s(Et),s(St),s(_),s(Pt),s(Lt),s(W),s(Dt),s(R),s(Kt),s(X),s(Ot),s(Y),s(es),s(z),s(ts),s(ss),s(N),s(as),s(ls),s(ns),s(q),s(ps),s(is),s(os),s(E),s(rs),s(S),s(cs),s(P),s(hs),s(ms),s(D),s(us),s(Ms),s(ds),s(ee),s(ys),s(js),s(gs),s(ae),s(fs),s(ws),s(ne),s(Js),s(pe),s(Ts),s(ie),s(bs),s(Us),s(re),s(Cs),s($s),s(he),s(ks),s(Is),s(ue),s(xs),s(Zs),s(de),s(vs),s(Vs),s(je),s(Gs),s(_s),s(I),s(Bs),s(fe),s(Ws),s(Rs),s(Je),s(Xs),s(Ys),s(be),s(zs),s(Qs),s(Ce),s(Ns),s($e),s(Fs),s(qs),s(Ie),s(Hs),s(xe),s(As),s(Es),s(ve),s(Ss),s(Ve),s(Ps),s(Ls),s(_e),s(Ds),s(Ks),s(We),s(Os),s(ea),s(Xe),s(ta),s(sa),s(ze),s(aa),s(la),s(x),s(na),s(Ne),s(pa),s(Fe),s(ia),s(oa),s(He),s(ra),s(ca),s(Ee),s(ha),s(ma),s(ua),s(Le),s(Ma),s(da),s(Ke),s(ya),s(ja),s(ga),s(tt),s(fa),s(wa),s(at),s(Ja),s(Ta),s(nt),s(ba),s(Ua),s(it),s(Ca),s($a),s(rt),s(ka),s(Ia),s(ht),s(xa),s(Za),s(ut),s(va),s(Va),s(Ga),s(_a),s(jt),s(Ba),s(Wa),s(ft),s(Ra),s(Xa),s(Jt),s(Ya),s(za),s(bt),s(Qa),s(Na),s(Ct),s(Fa),s(qa),s(Ha),s(It),s(Aa),s(xt),s(Ea),s(Sa),s(vt),s(Pa),s(La),s(Gt),s(Da),s(Ka),s(Bt),s(Oa),s(el),s(Rt),s(tl),s(sl),s(Z),s(al),s(Yt),s(ll),s(nl),s(Qt),s(pl),s(Nt),s(il),s(Ft),s(ol),s(qt)),s(j),M(J,e),M(C,e),M(G,e),M(B,e),M(Q,e),M(F,e),M(k,e),M(H,e),M(A,e),M(L,e),M(K,e),M(O,e),M(te,e),M(se,e),M(le,e),M(oe,e),M(ce,e),M(me,e),M(Me,e),M(ye,e),M(ge,e),M(we,e),M(Te,e),M(Ue,e),M(ke,e),M(Ze,e),M(Ge,e),M(Be,e),M(Re,e),M(Ye,e),M(Qe,e),M(qe,e),M(Ae,e),M(Se,e),M(Pe,e),M(De,e),M(Oe,e),M(et,e),M(st,e),M(lt,e),M(pt,e),M(ot,e),M(ct,e),M(mt,e),M(Mt,e),M(dt,e),M(yt,e),M(gt,e),M(wt,e),M(Tt,e),M(Ut,e),M($t,e),M(kt,e),M(Zt,e),M(Vt,e),M(_t,e),M(Wt,e),M(Xt,e),M(zt,e)}}}const Rn='{"title":"Text to speech","local":"text-to-speech","sections":[{"title":"Load the dataset","local":"load-the-dataset","sections":[],"depth":2},{"title":"Preprocess the data","local":"preprocess-the-data","sections":[{"title":"Text cleanup for SpeechT5 tokenization","local":"text-cleanup-for-speecht5-tokenization","sections":[],"depth":3},{"title":"Speakers","local":"speakers","sections":[],"depth":3},{"title":"Speaker embeddings","local":"speaker-embeddings","sections":[],"depth":3},{"title":"Processing the dataset","local":"processing-the-dataset","sections":[],"depth":3},{"title":"Data collator","local":"data-collator","sections":[],"depth":3}],"depth":2},{"title":"Train the model","local":"train-the-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[{"title":"Inference with a pipeline","local":"inference-with-a-pipeline","sections":[],"depth":3},{"title":"Run inference manually","local":"run-inference-manually","sections":[],"depth":3}],"depth":2}],"depth":1}';function Xn(At){return kn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hn extends xn{constructor(j){super(),Zn(this,j,Xn,Wn,$n,{})}}export{Hn as component};
