import{s as $e,f as Je,o as Ae,n as _e}from"../chunks/scheduler.37c15a92.js";import{S as Ie,i as ke,g as i,s as l,r as M,A as Ee,h as o,f as n,c as a,j as be,u as y,x as r,k as st,y as Le,a as s,v as w,d as C,t as v,w as x,m as Ze,n as Be}from"../chunks/index.2bf4358c.js";import{T as Pe}from"../chunks/Tip.363c041f.js";import{C as Ue}from"../chunks/CodeBlock.4e987730.js";import{H as Xt}from"../chunks/Heading.8ada512a.js";import{E as Se}from"../chunks/index.f9c0018f.js";function He(at){let p,c,d="We’ll cover how actions are represented (using JSON or code), the importance of the stop and parse approach, and introduce different types of agents.";return{c(){p=Ze(`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),c=i("p"),c.textContent=d},l(u){p=Be(u,`In this section, we explore the concrete steps an AI agent takes to interact with its environment. 
`),c=o(u,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1st7yzx"&&(c.textContent=d)},m(u,h){s(u,p,h),s(u,c,h)},p:_e,d(u){u&&(n(p),n(c))}}}function Ge(at){let p,c,d,u,h,it,m,ot,T,Qt="Actions are the concrete steps an <strong>AI agent takes to interact with its environment</strong>.",rt,j,zt="Whether it’s browsing the web for information or controlling a physical device, each action is a deliberate operation executed by the agent.",pt,b,Yt="For example, an agent assisting with customer service might retrieve customer data, offer support articles, or transfer issues to a human representative.",ct,U,ut,$,Ot="There are multiple types of Agents that take actions differently:",ht,J,Dt="<thead><tr><th>Type of Agent</th> <th>Description</th></tr></thead> <tbody><tr><td>JSON Agent</td> <td>The Action to take is specified in JSON format.</td></tr> <tr><td>Code Agent</td> <td>The Agent writes a code block that is interpreted externally.</td></tr> <tr><td>Function-calling Agent</td> <td>It is a subcategory of the JSON Agent which has been fine-tuned to generate a new message for each action.</td></tr></tbody>",dt,A,Kt="Actions themselves can serve many purposes:",mt,_,te="<thead><tr><th>Type of Action</th> <th>Description</th></tr></thead> <tbody><tr><td>Information Gathering</td> <td>Performing web searches, querying databases, or retrieving documents.</td></tr> <tr><td>Tool Usage</td> <td>Making API calls, running calculations, and executing code.</td></tr> <tr><td>Environment Interaction</td> <td>Manipulating digital interfaces or controlling physical devices.</td></tr> <tr><td>Communication</td> <td>Engaging with users via chat or collaborating with other agents.</td></tr></tbody>",ft,I,ee="The LLM only handles text and uses it to describe the action it wants to take and the parameters to supply to the tool. For an agent to work properly, the LLM must STOP generating new tokens after emitting all the tokens to define a complete Action. This passes control from the LLM back to the agent and ensures the result is parseable - whether the intended format is JSON, code, or function-calling.",gt,k,Mt,E,ne="One key method for implementing actions is the <strong>stop and parse approach</strong>. This method ensures that the agent’s output is structured and predictable:",yt,L,se="<li><strong>Generation in a Structured Format</strong>:</li>",wt,Z,le="The agent outputs its intended action in a clear, predetermined format (JSON or code).",Ct,f,ae="<li><strong>Halting Further Generation</strong>:</li>",vt,B,ie="Once the text defining the action has been emitted, <strong>the LLM stops generating additional tokens</strong>. This prevents extra or erroneous output.",xt,g,oe="<li><strong>Parsing the Output</strong>:</li>",Tt,P,re="An external parser reads the formatted action, determines which Tool to call, and extracts the required parameters.",jt,S,pe="For example, an agent needing to check the weather might output:",bt,H,Ut,G,ce="The framework can then easily parse the name of the function to call and the arguments to apply.",$t,F,ue="This clear, machine-readable format minimizes errors and enables external tools to accurately process the agent’s command.",Jt,W,he=`Note: Function-calling agents operate similarly by structuring each action so that a designated function is invoked with the correct arguments.
We’ll dive deeper into those types of Agents in a future Unit.`,At,q,_t,N,de=`An alternative approach is using <em>Code Agents</em>.
The idea is: <strong>instead of outputting a simple JSON object</strong>, a Code Agent generates an <strong>executable code block—typically in a high-level language like Python</strong>.`,It,R,me,kt,V,fe="This approach offers several advantages:",Et,X,ge="<li><strong>Expressiveness:</strong> Code can naturally represent complex logic, including loops, conditionals, and nested functions, providing greater flexibility than JSON.</li> <li><strong>Modularity and Reusability:</strong> Generated code can include functions and modules that are reusable across different actions or tasks.</li> <li><strong>Enhanced Debuggability:</strong> With a well-defined programming syntax, code errors are often easier to detect and correct.</li> <li><strong>Direct Integration:</strong> Code Agents can integrate directly with external libraries and APIs, enabling more complex operations such as data processing or real-time decision making.</li>",Lt,Q,Me="For example, a Code Agent tasked with fetching the weather might generate the following Python snippet:",Zt,z,Bt,Y,ye="In this example, the Code Agent:",Pt,O,we="<li>Retrieves weather data <strong>via an API call</strong>,</li> <li>Processes the response,</li> <li>And uses the print() function to output a final answer.</li>",St,D,Ce="This method <strong>also follows the stop and parse approach</strong> by clearly delimiting the code block and signaling when execution is complete (here, by printing the final_answer).",Ht,Gt,Ft,K,ve="We learned that Actions bridge an agent’s internal reasoning and its real-world interactions by executing clear, structured tasks—whether through JSON, code, or function calls.",Wt,tt,xe="This deliberate execution ensures that each action is precise and ready for external processing via the stop and parse approach. In the next section, we will explore Observations to see how agents capture and integrate feedback from their environment.",qt,et,Te="After this, we will <strong>finally be ready to build our first Agent!</strong>",Nt,nt,Rt,lt,Vt;return h=new Xt({props:{title:"Actions:  Enabling the Agent to Engage with Its Environment",local:"actions-enabling-the-agent-to-engage-with-its-environment",headingTag:"h1"}}),m=new Pe({props:{$$slots:{default:[He]},$$scope:{ctx:at}}}),U=new Xt({props:{title:"Types of Agent Actions",local:"types-of-agent-actions",headingTag:"h2"}}),k=new Xt({props:{title:"The Stop and Parse Approach",local:"the-stop-and-parse-approach",headingTag:"h2"}}),H=new Ue({props:{code:"VGhvdWdodCUzQSUyMEklMjBuZWVkJTIwdG8lMjBjaGVjayUyMHRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwZm9yJTIwTmV3JTIwWW9yay4lMEFBY3Rpb24lMjAlM0ElMEElN0IlMEElMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjAlMjJnZXRfd2VhdGhlciUyMiUyQyUwQSUyMCUyMCUyMmFjdGlvbl9pbnB1dCUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyTmV3JTIwWW9yayUyMiU3RCUwQSU3RA==",highlighted:`Thought<span class="hljs-punctuation">:</span> I need to check the current weather for New York.
Action <span class="hljs-punctuation">:</span>
<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;action&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_weather&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;action_input&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;New York&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),q=new Xt({props:{title:"Code Agents",local:"code-agents",headingTag:"h2"}}),z=new Ue({props:{code:"JTIzJTIwQ29kZSUyMEFnZW50JTIwRXhhbXBsZSUzQSUyMFJldHJpZXZlJTIwV2VhdGhlciUyMEluZm9ybWF0aW9uJTBBZGVmJTIwZ2V0X3dlYXRoZXIoY2l0eSklM0ElMEElMjAlMjAlMjAlMjBpbXBvcnQlMjByZXF1ZXN0cyUwQSUyMCUyMCUyMCUyMGFwaV91cmwlMjAlM0QlMjBmJTIyaHR0cHMlM0ElMkYlMkZhcGkud2VhdGhlci5jb20lMkZ2MSUyRmxvY2F0aW9uJTJGJTdCY2l0eSU3RCUzRmFwaUtleSUzRFlPVVJfQVBJX0tFWSUyMiUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KGFwaV91cmwpJTBBJTIwJTIwJTIwJTIwaWYlMjByZXNwb25zZS5zdGF0dXNfY29kZSUyMCUzRCUzRCUyMDIwMCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjByZXNwb25zZS5qc29uKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBkYXRhLmdldCglMjJ3ZWF0aGVyJTIyJTJDJTIwJTIyTm8lMjB3ZWF0aGVyJTIwaW5mb3JtYXRpb24lMjBhdmFpbGFibGUlMjIpJTBBJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCUyMkVycm9yJTNBJTIwVW5hYmxlJTIwdG8lMjBmZXRjaCUyMHdlYXRoZXIlMjBkYXRhLiUyMiUwQSUwQSUyMyUyMEV4ZWN1dGUlMjB0aGUlMjBmdW5jdGlvbiUyMGFuZCUyMHByZXBhcmUlMjB0aGUlMjBmaW5hbCUyMGFuc3dlciUwQXJlc3VsdCUyMCUzRCUyMGdldF93ZWF0aGVyKCUyMk5ldyUyMFlvcmslMjIpJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwZiUyMlRoZSUyMGN1cnJlbnQlMjB3ZWF0aGVyJTIwaW4lMjBOZXclMjBZb3JrJTIwaXMlM0ElMjAlN0JyZXN1bHQlN0QlMjIlMEFwcmludChmaW5hbF9hbnN3ZXIp",highlighted:`<span class="hljs-comment"># Code Agent Example: Retrieve Weather Information</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_weather</span>(<span class="hljs-params">city</span>):
    <span class="hljs-keyword">import</span> requests
    api_url = <span class="hljs-string">f&quot;https://api.weather.com/v1/location/<span class="hljs-subst">{city}</span>?apiKey=YOUR_API_KEY&quot;</span>
    response = requests.get(api_url)
    <span class="hljs-keyword">if</span> response.status_code == <span class="hljs-number">200</span>:
        data = response.json()
        <span class="hljs-keyword">return</span> data.get(<span class="hljs-string">&quot;weather&quot;</span>, <span class="hljs-string">&quot;No weather information available&quot;</span>)
    <span class="hljs-keyword">else</span>:
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Error: Unable to fetch weather data.&quot;</span>

<span class="hljs-comment"># Execute the function and prepare the final answer</span>
result = get_weather(<span class="hljs-string">&quot;New York&quot;</span>)
final_answer = <span class="hljs-string">f&quot;The current weather in New York is: <span class="hljs-subst">{result}</span>&quot;</span>
<span class="hljs-built_in">print</span>(final_answer)`,wrap:!1}}),nt=new Se({props:{source:"https://github.com/huggingface/agents-course/blob/main/units/en/unit1/actions.mdx"}}),{c(){p=i("meta"),c=l(),d=i("p"),u=l(),M(h.$$.fragment),it=l(),M(m.$$.fragment),ot=l(),T=i("p"),T.innerHTML=Qt,rt=l(),j=i("p"),j.textContent=zt,pt=l(),b=i("p"),b.textContent=Yt,ct=l(),M(U.$$.fragment),ut=l(),$=i("p"),$.textContent=Ot,ht=l(),J=i("table"),J.innerHTML=Dt,dt=l(),A=i("p"),A.textContent=Kt,mt=l(),_=i("table"),_.innerHTML=te,ft=l(),I=i("p"),I.textContent=ee,gt=l(),M(k.$$.fragment),Mt=l(),E=i("p"),E.innerHTML=ne,yt=l(),L=i("ol"),L.innerHTML=se,wt=l(),Z=i("p"),Z.textContent=le,Ct=l(),f=i("ol"),f.innerHTML=ae,vt=l(),B=i("p"),B.innerHTML=ie,xt=l(),g=i("ol"),g.innerHTML=oe,Tt=l(),P=i("p"),P.textContent=re,jt=l(),S=i("p"),S.textContent=pe,bt=l(),M(H.$$.fragment),Ut=l(),G=i("p"),G.textContent=ce,$t=l(),F=i("p"),F.textContent=ue,Jt=l(),W=i("p"),W.textContent=he,At=l(),M(q.$$.fragment),_t=l(),N=i("p"),N.innerHTML=de,It=l(),R=i("img"),kt=l(),V=i("p"),V.textContent=fe,Et=l(),X=i("ul"),X.innerHTML=ge,Lt=l(),Q=i("p"),Q.textContent=Me,Zt=l(),M(z.$$.fragment),Bt=l(),Y=i("p"),Y.textContent=ye,Pt=l(),O=i("ul"),O.innerHTML=we,St=l(),D=i("p"),D.innerHTML=Ce,Ht=l(),Gt=i("hr"),Ft=l(),K=i("p"),K.textContent=ve,Wt=l(),tt=i("p"),tt.textContent=xe,qt=l(),et=i("p"),et.innerHTML=Te,Nt=l(),M(nt.$$.fragment),Rt=l(),lt=i("p"),this.h()},l(t){const e=Ee("svelte-u9bgzb",document.head);p=o(e,"META",{name:!0,content:!0}),e.forEach(n),c=a(t),d=o(t,"P",{}),be(d).forEach(n),u=a(t),y(h.$$.fragment,t),it=a(t),y(m.$$.fragment,t),ot=a(t),T=o(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1d9hktj"&&(T.innerHTML=Qt),rt=a(t),j=o(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1tl5mip"&&(j.textContent=zt),pt=a(t),b=o(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1ubetp8"&&(b.textContent=Yt),ct=a(t),y(U.$$.fragment,t),ut=a(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-1wlcwgd"&&($.textContent=Ot),ht=a(t),J=o(t,"TABLE",{"data-svelte-h":!0}),r(J)!=="svelte-3ls1cj"&&(J.innerHTML=Dt),dt=a(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1xp7kgk"&&(A.textContent=Kt),mt=a(t),_=o(t,"TABLE",{"data-svelte-h":!0}),r(_)!=="svelte-4604oy"&&(_.innerHTML=te),ft=a(t),I=o(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-172oujm"&&(I.textContent=ee),gt=a(t),y(k.$$.fragment,t),Mt=a(t),E=o(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-a9as0m"&&(E.innerHTML=ne),yt=a(t),L=o(t,"OL",{"data-svelte-h":!0}),r(L)!=="svelte-1nmidra"&&(L.innerHTML=se),wt=a(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-l3tk2o"&&(Z.textContent=le),Ct=a(t),f=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-j1mwkc"&&(f.innerHTML=ae),vt=a(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1hxxesc"&&(B.innerHTML=ie),xt=a(t),g=o(t,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-w7r926"&&(g.innerHTML=oe),Tt=a(t),P=o(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-191aaii"&&(P.textContent=re),jt=a(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1exbnez"&&(S.textContent=pe),bt=a(t),y(H.$$.fragment,t),Ut=a(t),G=o(t,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1j4o5aq"&&(G.textContent=ce),$t=a(t),F=o(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1so9m39"&&(F.textContent=ue),Jt=a(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1k8g2zy"&&(W.textContent=he),At=a(t),y(q.$$.fragment,t),_t=a(t),N=o(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19f0lzf"&&(N.innerHTML=de),It=a(t),R=o(t,"IMG",{src:!0,alt:!0}),kt=a(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-rsd8hl"&&(V.textContent=fe),Et=a(t),X=o(t,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-1t80mrq"&&(X.innerHTML=ge),Lt=a(t),Q=o(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-qjq0mw"&&(Q.textContent=Me),Zt=a(t),y(z.$$.fragment,t),Bt=a(t),Y=o(t,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-pfpi4"&&(Y.textContent=ye),Pt=a(t),O=o(t,"UL",{"data-svelte-h":!0}),r(O)!=="svelte-b7upo8"&&(O.innerHTML=we),St=a(t),D=o(t,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1v0y8k3"&&(D.innerHTML=Ce),Ht=a(t),Gt=o(t,"HR",{}),Ft=a(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-b7m3f6"&&(K.textContent=ve),Wt=a(t),tt=o(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-h8bvqv"&&(tt.textContent=xe),qt=a(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-14ocnmz"&&(et.innerHTML=Te),Nt=a(t),y(nt.$$.fragment,t),Rt=a(t),lt=o(t,"P",{}),be(lt).forEach(n),this.h()},h(){st(p,"name","hf:doc:metadata"),st(p,"content",Fe),st(f,"start","2"),st(g,"start","3"),Je(R.src,me="https://huggingface.co/datasets/agents-course/course-images/resolve/main/en/unit1/code-vs-json-actions.png")||st(R,"src",me),st(R,"alt","Code Agents")},m(t,e){Le(document.head,p),s(t,c,e),s(t,d,e),s(t,u,e),w(h,t,e),s(t,it,e),w(m,t,e),s(t,ot,e),s(t,T,e),s(t,rt,e),s(t,j,e),s(t,pt,e),s(t,b,e),s(t,ct,e),w(U,t,e),s(t,ut,e),s(t,$,e),s(t,ht,e),s(t,J,e),s(t,dt,e),s(t,A,e),s(t,mt,e),s(t,_,e),s(t,ft,e),s(t,I,e),s(t,gt,e),w(k,t,e),s(t,Mt,e),s(t,E,e),s(t,yt,e),s(t,L,e),s(t,wt,e),s(t,Z,e),s(t,Ct,e),s(t,f,e),s(t,vt,e),s(t,B,e),s(t,xt,e),s(t,g,e),s(t,Tt,e),s(t,P,e),s(t,jt,e),s(t,S,e),s(t,bt,e),w(H,t,e),s(t,Ut,e),s(t,G,e),s(t,$t,e),s(t,F,e),s(t,Jt,e),s(t,W,e),s(t,At,e),w(q,t,e),s(t,_t,e),s(t,N,e),s(t,It,e),s(t,R,e),s(t,kt,e),s(t,V,e),s(t,Et,e),s(t,X,e),s(t,Lt,e),s(t,Q,e),s(t,Zt,e),w(z,t,e),s(t,Bt,e),s(t,Y,e),s(t,Pt,e),s(t,O,e),s(t,St,e),s(t,D,e),s(t,Ht,e),s(t,Gt,e),s(t,Ft,e),s(t,K,e),s(t,Wt,e),s(t,tt,e),s(t,qt,e),s(t,et,e),s(t,Nt,e),w(nt,t,e),s(t,Rt,e),s(t,lt,e),Vt=!0},p(t,[e]){const je={};e&2&&(je.$$scope={dirty:e,ctx:t}),m.$set(je)},i(t){Vt||(C(h.$$.fragment,t),C(m.$$.fragment,t),C(U.$$.fragment,t),C(k.$$.fragment,t),C(H.$$.fragment,t),C(q.$$.fragment,t),C(z.$$.fragment,t),C(nt.$$.fragment,t),Vt=!0)},o(t){v(h.$$.fragment,t),v(m.$$.fragment,t),v(U.$$.fragment,t),v(k.$$.fragment,t),v(H.$$.fragment,t),v(q.$$.fragment,t),v(z.$$.fragment,t),v(nt.$$.fragment,t),Vt=!1},d(t){t&&(n(c),n(d),n(u),n(it),n(ot),n(T),n(rt),n(j),n(pt),n(b),n(ct),n(ut),n($),n(ht),n(J),n(dt),n(A),n(mt),n(_),n(ft),n(I),n(gt),n(Mt),n(E),n(yt),n(L),n(wt),n(Z),n(Ct),n(f),n(vt),n(B),n(xt),n(g),n(Tt),n(P),n(jt),n(S),n(bt),n(Ut),n(G),n($t),n(F),n(Jt),n(W),n(At),n(_t),n(N),n(It),n(R),n(kt),n(V),n(Et),n(X),n(Lt),n(Q),n(Zt),n(Bt),n(Y),n(Pt),n(O),n(St),n(D),n(Ht),n(Gt),n(Ft),n(K),n(Wt),n(tt),n(qt),n(et),n(Nt),n(Rt),n(lt)),n(p),x(h,t),x(m,t),x(U,t),x(k,t),x(H,t),x(q,t),x(z,t),x(nt,t)}}}const Fe='{"title":"Actions:  Enabling the Agent to Engage with Its Environment","local":"actions-enabling-the-agent-to-engage-with-its-environment","sections":[{"title":"Types of Agent Actions","local":"types-of-agent-actions","sections":[],"depth":2},{"title":"The Stop and Parse Approach","local":"the-stop-and-parse-approach","sections":[],"depth":2},{"title":"Code Agents","local":"code-agents","sections":[],"depth":2}],"depth":1}';function We(at){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ze extends Ie{constructor(p){super(),ke(this,p,We,Ge,$e,{})}}export{ze as component};
