import{s as zo,f as Lo,o as Yo,n as fs}from"../chunks/scheduler.d627b047.js";import{S as Po,i as Do,g as o,s as l,r as p,A as Oo,h as i,f as a,c as s,j as R,u as d,x as r,k as I,l as Vo,y,a as n,v as c,d as m,t as u,w as h}from"../chunks/index.73c51727.js";import{T as Qo}from"../chunks/Tip.a82942ec.js";import{D as Ja}from"../chunks/Docstring.c464211f.js";import{C as g}from"../chunks/CodeBlock.5f78c87f.js";import{E as Ko}from"../chunks/ExampleCodeBlock.d5ae35f8.js";import{H as M,E as ti}from"../chunks/index.bb4866f7.js";function ei(x){let f,J="Some base models, like those from Qwen, have a predefined chat template in the model’s tokenizer. In these cases it is not necessary to apply <code>setup_chat_format()</code>, as the tokenizer already handles the formatting. However, it is necessary to align the EOS token with the chat template to ensure the model’s responses terminate correctly. In these cases, specify <code>eos_token</code> in <code>SFTConfig</code>; for example, for <code>Qwen/Qwen2.5-1.5B</code> one should set <code>eos_token=&quot;&lt;|im_end|&gt;&quot;</code>.";return{c(){f=o("p"),f.innerHTML=J},l(T){f=i(T,"P",{"data-svelte-h":!0}),r(f)!=="svelte-y0vf1h"&&(f.innerHTML=J)},m(T,b){n(T,f,b)},p:fs,d(T){T&&a(f)}}}function ai(x){let f,J="If the chat template contains special tokens like <code>&lt;|im_start|&gt;</code> (ChatML) or <code>&lt;|eot_id|&gt;</code> (Llama), the embedding layer and LM head must be included in the trainable parameters via the <code>modules_to_save</code> argument. Without this, the fine-tuned model will produce unbounded or nonsense generations. If the chat template doesn’t contain special tokens (e.g. Alpaca), then the <code>modules_to_save</code> argument can be ignored or set to <code>None</code>.";return{c(){f=o("p"),f.innerHTML=J},l(T){f=i(T,"P",{"data-svelte-h":!0}),r(f)!=="svelte-10b052h"&&(f.innerHTML=J)},m(T,b){n(T,f,b)},p:fs,d(T){T&&a(f)}}}function ni(x){let f,J="Example:",T,b,U;return b=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnJvbmVuZWxkYW4lMkZUaW55U3RvcmllcyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lNUIlM0ExJTI1JTVEJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKG1vZGVsJTNEJTIyUXdlbiUyRlF3ZW4yLTAuNUItSW5zdHJ1Y3QlMjIlMkMlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;roneneldan/TinyStories&quot;</span>, split=<span class="hljs-string">&quot;train[:1%]&quot;</span>)

trainer = SFTTrainer(model=<span class="hljs-string">&quot;Qwen/Qwen2-0.5B-Instruct&quot;</span>, train_dataset=dataset)
trainer.train()`,wrap:!1}}),{c(){f=o("p"),f.textContent=J,T=l(),p(b.$$.fragment)},l(_){f=i(_,"P",{"data-svelte-h":!0}),r(f)!=="svelte-11lpom8"&&(f.textContent=J),T=s(_),d(b.$$.fragment,_)},m(_,C){n(_,f,C),n(_,T,C),c(b,_,C),U=!0},p:fs,i(_){U||(m(b.$$.fragment,_),U=!0)},o(_){u(b.$$.fragment,_),U=!1},d(_){_&&(a(f),a(T)),h(b,_)}}}function li(x){let f,J,T,b,U,_,C,gs='<a href="https://huggingface.co/models?other=sft,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-SFT-blue"/></a> <a href="https://github.com/huggingface/smol-course/tree/main/1_instruction_tuning" rel="nofollow"><img src="https://img.shields.io/badge/smol_course-Chapter_1-yellow"/></a>',va,X,Ms='Supervised fine-tuning (SFT) is the most common step in post-training foundation models, and also one of the most effective. In TRL, we provide a simple API to train models with SFT in a few lines of code; for a complete training script, check out <a href="https://github.com/huggingface/trl/tree/main/trl/scripts/sft.py" rel="nofollow"><code>trl/scripts/sft.py</code></a>. Experimental support for Vision Language Models is also included in <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.',Ua,H,Ia,V,ys=`If you have a dataset hosted on the 🤗 Hub, you can easily fine-tune your SFT model using <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> from TRL. Let us assume your dataset is <code>imdb</code>, the text you want to predict is inside the <code>text</code> field of the dataset, and you want to fine-tune the <code>facebook/opt-350m</code> model.
The following code-snippet takes care of all the data pre-processing and training for you:`,Ca,Q,Fa,z,Ts="Make sure to pass the correct value for <code>max_length</code> as the default value will be set to <code>min(tokenizer.model_max_length, 1024)</code>.",$a,L,_s="You can also construct a model outside of the trainer and pass it as follows:",ka,Y,xa,P,ws='The above snippets will use the default training arguments from the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> class. If you want to modify the defaults pass in your modification to the <code>SFTConfig</code> constructor and pass them to the trainer via the <code>args</code> argument.',Na,D,Aa,O,Za,K,bs='To train on completions only, simply use a <a href="#prompt-completion">prompt-completion</a> dataset. In this mode, loss is computed solely on the completion part.',qa,tt,js='If you’d like to compute loss on both the prompt <strong>and</strong> the completion while still using a prompt-completion dataset, set <code>completion_only_loss=False</code> in the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. This is equivalent to <a href="#from-prompt-completion-to-language-modeling-dataset">converting the dataset to a language modeling</a> format.',Ba,et,Ga,at,Js=`Adding special tokens to a language model is crucial for training chat models. These tokens are added between the different roles in a conversation, such as the user, assistant, and system and help the model recognize the structure and flow of a conversation. This setup is essential for enabling the model to generate coherent and contextually appropriate responses in a chat environment.
The <code>setup_chat_format()</code> function in <code>trl</code> easily sets up a model and tokenizer for conversational AI tasks. This function:`,Ea,nt,vs='<li>Adds special tokens to the tokenizer, e.g. <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code>, to indicate the start and end of a conversation.</li> <li>Resizes the model’s embedding layer to accommodate the new tokens.</li> <li>Sets the <code>chat_template</code> of the tokenizer, which is used to format the input data into a chat-like format. The default is <code>chatml</code> from OpenAI.</li> <li><em>optionally</em> you can pass <code>resize_to_multiple_of</code> to resize the embedding layer to a multiple of the <code>resize_to_multiple_of</code> argument, e.g. 64. If you want to see more formats being supported in the future, please open a GitHub issue on <a href="https://github.com/huggingface/trl" rel="nofollow">trl</a></li>',Sa,lt,Wa,N,Ra,st,Us="With our model and tokenizer set up, we can now fine-tune our model on a conversational dataset. Below is an example of how a dataset can be formatted for fine-tuning.",Xa,ot,Ha,it,Is='The <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports popular dataset formats. This allows you to pass the dataset to the trainer without any pre-processing directly. The following formats are supported:',Va,rt,Cs="<li>conversational format</li>",Qa,pt,za,dt,Fs="<li>instruction format</li>",La,ct,Ya,mt,$s='If your dataset uses one of the above formats, you can directly pass it to the trainer without pre-processing. The <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> will then format the dataset for you using the defined format from the model’s tokenizer with the <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#templates-for-chat-models" rel="nofollow">apply_chat_template</a> method.',Pa,ut,Da,ht,ks="If the dataset is not in one of those format you can either preprocess the dataset to match the formatting or pass a formatting function to the SFTTrainer to do it for you. Let’s have a look.",Oa,ft,Ka,gt,xs=`For instruction fine-tuning, it is quite common to have two columns inside the dataset: one for the prompt &amp; the other for the response.
This allows people to format examples like <a href="https://github.com/tatsu-lab/stanford_alpaca" rel="nofollow">Stanford-Alpaca</a> did as follows:`,tn,Mt,en,yt,Ns="Let us assume your dataset has two fields, <code>question</code> and <code>answer</code>. Therefore you can just run:",an,Tt,nn,_t,As='To properly format your input make sure to process all the examples by looping over them and returning a list of processed text. Check out a full example of how to use SFTTrainer on alpaca dataset <a href="https://github.com/huggingface/trl/pull/444#issue-1760952763" rel="nofollow">here</a>',ln,wt,sn,bt,Zs='<a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> supports <em>example packing</em>, where multiple short examples are packed in the same input sequence to increase training efficiency. To enable the usage of this dataset class, simply pass <code>packing=True</code> to the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a> constructor.',on,jt,rn,Jt,qs=`Note that if you use a packed dataset and if you pass <code>max_steps</code> in the training arguments you will probably train your models for more than few epochs, depending on the way you have configured the packed dataset and the training protocol. Double check that you know and understand what you are doing.
If you don’t want to pack your <code>eval_dataset</code>, you can pass <code>eval_packing=False</code> to the <code>SFTConfig</code> init method.`,pn,vt,dn,Ut,Bs="If your dataset has several fields that you want to combine, for example if the dataset has <code>question</code> and <code>answer</code> fields and you want to combine them, you can pass a formatting function to the trainer that will take care of that. For example:",cn,It,mn,Ct,un,Ft,Gs='You can directly pass the kwargs of the <code>from_pretrained()</code> method to the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. For example, if you want to load a model in a different precision, analogous to',hn,$t,fn,kt,Es="Note that all keyword arguments of <code>from_pretrained()</code> are supported.",gn,xt,Mn,Nt,Ss="We also support tight integration with 🤗 PEFT library so that any user can conveniently train adapters and share them on the Hub instead of training the entire model.",yn,At,Tn,A,_n,Zt,Ws="You can also continue training your <code>PeftModel</code>. For that, first load a <code>PeftModel</code> outside <code>SFTTrainer</code> and pass it directly to the trainer without the <code>peft_config</code> argument being passed.",wn,qt,bn,Bt,Rs="For that, you need to first load your 8 bit model outside the Trainer and pass a <code>PeftConfig</code> to the trainer. For example:",jn,Gt,Jn,Et,vn,St,Xs=`You can benefit from Flash Attention 1 & 2 using SFTTrainer out of the box with minimal changes of code.
First, to make sure you have all the latest features from transformers, install transformers from source`,Un,Wt,In,Rt,Hs=`Note that Flash Attention only works on GPU now and under half-precision regime (when using adapters, base model loaded in half-precision)
Note also both features are perfectly compatible with other tools such as quantization.`,Cn,Xt,Fn,Ht,Vs="For Flash Attention 1 you can use the <code>BetterTransformer</code> API and force-dispatch the API to use Flash Attention kernel. First, install the latest optimum package:",$n,Vt,kn,Qt,Qs="Once you have loaded your model, wrap the <code>trainer.train()</code> call under the <code>with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</code> context manager:",xn,zt,Nn,Lt,zs="Note that you cannot train your model using Flash Attention 1 on an arbitrary dataset as <code>torch.scaled_dot_product_attention</code> does not support training with padding tokens if you use Flash Attention kernels. Therefore you can only use that feature with <code>packing=True</code>. If your dataset contains padding tokens, consider switching to Flash Attention 2 integration.",An,Yt,Ls="Below are some numbers you can get in terms of speedup and memory efficiency, using Flash Attention 1, on a single NVIDIA-T4 16GB.",Zn,Pt,Ys="<thead><tr><th>use_flash_attn_1</th> <th>model_name</th> <th>max_seq_len</th> <th>batch_size</th> <th>time per training step</th></tr></thead> <tbody><tr><td>✓</td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td>~59.1s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>8</td> <td><strong>OOM</strong></td></tr> <tr><td>✓</td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~30.3s</td></tr> <tr><td></td> <td>facebook/opt-350m</td> <td>2048</td> <td>4</td> <td>~148.9s</td></tr></tbody>",qn,Dt,Bn,Ot,Ps="To use Flash Attention 2, first install the latest <code>flash-attn</code> package:",Gn,Kt,En,te,Ds="And add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when calling <code>from_pretrained</code>:",Sn,ee,Wn,ae,Os=`If you don’t use quantization, make sure your model is loaded in half-precision and dispatch your model on a supported GPU device.
After loading your model, you can either train it as it is, or attach adapters and train adapters on it in case your model is quantized.`,Rn,ne,Ks="In contrast to Flash Attention 1, the integration makes it possible to train your model on an arbitrary dataset that also includes padding tokens.",Xn,le,Hn,se,to="We included a utility function to create your model.",Vn,F,oe,ns,ha,eo="Configuration class for the models.",ls,fa,ao=`Using <a href="https://huggingface.co/docs/transformers/v4.51.3/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Qn,ie,zn,re,Ln,pe,no='NEFTune is a technique to boost the performance of chat models and was introduced by the paper <a href="https://huggingface.co/papers/2310.05914" rel="nofollow">“NEFTune: Noisy Embeddings Improve Instruction Finetuning”</a> from Jain et al. it consists of adding noise to the embedding vectors during training. According to the abstract of the paper:',Yn,de,lo="<p>Standard finetuning of LLaMA-2-7B using Alpaca achieves 29.79% on AlpacaEval, which rises to 64.69% using noisy embeddings. NEFTune also improves over strong baselines on modern instruction datasets. Models trained with Evol-Instruct see a 10% improvement, with ShareGPT an 8% improvement, and with OpenPlatypus an 8% improvement. Even powerful models further refined with RLHF such as LLaMA-2-Chat benefit from additional training with NEFTune.</p>",Pn,Z,so='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/neft-screenshot.png"/>',Dn,ce,oo="To use it in <code>SFTTrainer</code> simply pass <code>neftune_noise_alpha</code> when creating your <code>SFTConfig</code> instance. Note that to avoid any surprising behaviour, NEFTune is disabled after training to retrieve back the original behaviour of the embedding layer.",On,me,Kn,ue,io='We have tested NEFTune by training <code>mistralai/Mistral-7B-v0.1</code> on the <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">OpenAssistant dataset</a> and validated that using NEFTune led to a performance boost of ~25% on MT Bench.',tl,q,ro='<img src="https://huggingface.co/datasets/trl-lib/documentation-images/resolve/main/trl-neftune-mistral-7b.png"/>',el,he,po='Note however, that the amount of performance gain is <em>dataset dependent</em> and in particular, applying NEFTune on synthetic datasets like <a href="https://huggingface.co/datasets/stingning/ultrachat" rel="nofollow">UltraChat</a> typically produces smaller gains.',al,fe,nl,ge,co='You can further accelerate QLoRA / LoRA (2x faster, 60% less memory) using the <a href="https://github.com/unslothai/unsloth" rel="nofollow"><code>unsloth</code></a> library that is fully compatible with <code>SFTTrainer</code>. Currently <code>unsloth</code> supports only Llama (Yi, TinyLlama, Qwen, Deepseek etc) and Mistral architectures. Some benchmarks on 1x A100 listed below:',ll,Me,mo="<thead><tr><th>1 A100 40GB</th> <th>Dataset</th> <th>🤗</th> <th>🤗 + Flash Attention 2</th> <th>🦥 Unsloth</th> <th>🦥 VRAM saved</th></tr></thead> <tbody><tr><td>Code Llama 34b</td> <td>Slim Orca</td> <td>1x</td> <td>1.01x</td> <td><strong>1.94x</strong></td> <td>-22.7%</td></tr> <tr><td>Llama-2 7b</td> <td>Slim Orca</td> <td>1x</td> <td>0.96x</td> <td><strong>1.87x</strong></td> <td>-39.3%</td></tr> <tr><td>Mistral 7b</td> <td>Slim Orca</td> <td>1x</td> <td>1.17x</td> <td><strong>1.88x</strong></td> <td>-65.9%</td></tr> <tr><td>Tiny Llama 1.1b</td> <td>Alpaca</td> <td>1x</td> <td>1.55x</td> <td><strong>2.74x</strong></td> <td>-57.8%</td></tr></tbody>",sl,ye,uo='First install <code>unsloth</code> according to the <a href="https://github.com/unslothai/unsloth" rel="nofollow">official documentation</a>. Once installed, you can incorporate unsloth into your workflow in a very simple manner; instead of loading <code>AutoModelForCausalLM</code>, you just need to load a <code>FastLanguageModel</code> as follows:',ol,Te,il,_e,ho='The saved model is fully compatible with Hugging Face’s transformers library. Learn more about unsloth in their <a href="https://github.com/unslothai/unsloth" rel="nofollow">official repository</a>.',rl,we,pl,be,fo='<a href="https://github.com/linkedin/Liger-Kernel" rel="nofollow">Liger Kernel</a> is a collection of Triton kernels designed specifically for LLM training. It can effectively increase multi-GPU training throughput by 20% and reduces memory usage by 60%. That way, we can <strong>4x</strong> our context length, as described in the benchmark below. They have implemented Hugging Face Compatible <code>RMSNorm</code>, <code>RoPE</code>, <code>SwiGLU</code>, <code>CrossEntropy</code>, <code>FusedLinearCrossEntropy</code>, and more to come. The kernel works out of the box with <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">Flash Attention</a>, <a href="https://pytorch.org/tutorials/intermediate/FSDP_tutorial.html" rel="nofollow">PyTorch FSDP</a>, and <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">Microsoft DeepSpeed</a>.',dl,je,go="With great memory reduction, you can potentially turn off cpu_offloading or gradient checkpointing to further boost the performance.",cl,Je,Mo='<thead><tr><th>Speed Up</th> <th>Memory Reduction</th></tr></thead> <tbody><tr><td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-tps.png" alt="Speed up"/></td> <td><img src="https://raw.githubusercontent.com/linkedin/Liger-Kernel/main/docs/images/e2e-memory.png" alt="Memory"/></td></tr></tbody>',ml,ve,yo='<li>To use Liger-Kernel in <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, first install by</li>',ul,Ue,hl,B,To='<li>Once installed, set <code>use_liger_kernel</code> in <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. No other changes are needed!</li>',fl,Ie,gl,Ce,_o='To learn more about Liger-Kernel, visit their <a href="https://github.com/linkedin/Liger-Kernel/" rel="nofollow">official repository</a>.',Ml,Fe,yl,$e,wo="Pay attention to the following best practices when training a model with that trainer:",Tl,ke,bo='<li><a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> always truncates by default the sequences to the <code>max_length</code> argument of the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>. If none is passed, the trainer will retrieve that value from the tokenizer. Some tokenizers do not provide a default value, so there is a check to retrieve the minimum between 1024 and that value. Make sure to check it before training.</li> <li>For training adapters in 8bit, you might need to tweak the arguments of the <code>prepare_model_for_kbit_training</code> method from PEFT, hence we advise users to use <code>prepare_in_int8_kwargs</code> field, or create the <code>PeftModel</code> outside the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> and pass it.</li> <li>For a more memory-efficient training using adapters, you can load the base model in 8bit, for that simply add <code>load_in_8bit</code> argument when creating the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>, or create a base model in 8bit outside the trainer and pass it.</li> <li>If you create a model outside the trainer, make sure to not pass to the trainer any additional keyword arguments that are relative to <code>from_pretrained()</code> method.</li>',_l,xe,wl,Ne,jo='Trainer (and thus SFTTrainer) supports multi-GPU training. If you run your script with <code>python script.py</code> it will default to using DP as the strategy, which may be <a href="https://github.com/huggingface/trl/issues/1303" rel="nofollow">slower than expected</a>. To use DDP (which is generally recommended, see <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many?select-gpu=Accelerate#data-parallelism" rel="nofollow">here</a> for more info) you must launch the script with <code>python -m torch.distributed.launch script.py</code> or <code>accelerate launch script.py</code>. For DDP to work you must also check the following:',bl,Ae,Jo='<li>If you’re using gradient_checkpointing, add the following to the TrainingArguments: <code>gradient_checkpointing_kwargs={&#39;use_reentrant&#39;:False}</code> (more info <a href="https://github.com/huggingface/transformers/issues/26969" rel="nofollow">here</a></li> <li>Ensure that the model is placed on the correct device:</li>',jl,Ze,Jl,qe,vl,Be,vo="You may experience some issues with GPTQ Quantization after completing training. Lowering <code>gradient_accumulation_steps</code> to <code>4</code> will resolve most issues during the quantization process to GPTQ format.",Ul,Ge,Il,Ee,Uo='<code>SFTTrainer</code> does not inherently support vision-language data. However, we provide a guide on how to tweak the trainer to support vision-language data. Specifically, you need to use a custom data collator that is compatible with vision-language data. This guide outlines the steps to make these adjustments. For a concrete example, refer to the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a> which demonstrates how to fine-tune the LLaVA 1.5 model on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset.',Cl,Se,Fl,We,Io="The data format is flexible, provided it is compatible with the custom collator that we will define later. A common approach is to use conversational data. Given that the data includes both text and images, the format needs to be adjusted accordingly. Below is an example of a conversational data format involving both text and images:",$l,Re,kl,Xe,Co="To illustrate how this data format will be processed using the LLaVA model, you can use the following code:",xl,He,Nl,Ve,Fo="The output will be formatted as follows:",Al,Qe,Zl,$,$o,ql,ze,Bl,Le,ko="Unlike the default behavior of <code>SFTTrainer</code>, processing multi-modal data is done on the fly during the data collation process. To do this, you need to define a custom collator that processes both the text and images. This collator must take a list of examples as input (see the previous section for an example of the data format) and return a batch of processed data. Below is an example of such a collator:",Gl,Ye,El,Pe,xo="We can verify that the collator works as expected by running the following code:",Sl,De,Wl,Oe,Rl,Ke,No="Now that we have prepared the data and defined the collator, we can proceed with training the model. To ensure that the data is not processed as text-only, we need to set a couple of arguments in the <code>SFTConfig</code>, specifically <code>remove_unused_columns</code> and <code>skip_prepare_dataset</code> to <code>True</code> to avoid the default processing of the dataset. Below is an example of how to set up the <code>SFTTrainer</code>.",Xl,ta,Hl,ea,Ao='A full example of training LLaVa 1.5 on the <a href="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft" rel="nofollow">HuggingFaceH4/llava-instruct-mix-vsft</a> dataset can be found in the script <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/sft_vlm.py" rel="nofollow"><code>examples/scripts/sft_vlm.py</code></a>.',Vl,aa,Zo='<li><a href="https://wandb.ai/huggingface/trl/runs/2b2c5l7s" rel="nofollow">Experiment tracking</a></li> <li><a href="https://huggingface.co/HuggingFaceH4/sft-llava-1.5-7b-hf" rel="nofollow">Trained model</a></li>',Ql,na,zl,w,la,ss,ga,qo="Trainer for Supervised Fine-Tuning (SFT) method.",os,Ma,Bo='This class is a wrapper around the <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/trainer#transformers.Trainer" rel="nofollow">transformers.Trainer</a> class and inherits all of its attributes and methods.',is,G,rs,E,sa,ps,ya,Go="Compute training loss and additionally compute token accuracies",ds,S,oa,cs,Ta,Eo="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Ll,ia,Yl,v,ra,ms,_a,So='Configuration class for the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a>.',us,wa,Wo=`Only the parameters specific to SFT training are listed here. For details on other parameters, refer to the
<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> documentation.`,hs,ba,Ro=`Using <a href="https://huggingface.co/docs/transformers/v4.51.3/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,Pl,pa,Dl,da,Xo="In the SFTTrainer we smartly support <code>datasets.IterableDataset</code> in addition to other style datasets. This is useful if you are using large corpora that you do not want to save all to disk. The data will be tokenized and processed on the fly, even when packing is enabled.",Ol,ca,Ho="Additionally, in the SFTTrainer, we support pre-tokenized datasets if they are <code>datasets.Dataset</code> or <code>datasets.IterableDataset</code>. In other words, if such a dataset has a column of <code>input_ids</code>, no further processing (tokenization or packing) will be done, and the dataset will be used as-is. This can be useful if you have pretokenized your dataset outside of this script and want to re-use it directly.",Kl,ma,ts,ja,es;return U=new M({props:{title:"Supervised Fine-tuning Trainer",local:"supervised-fine-tuning-trainer",headingTag:"h1"}}),H=new M({props:{title:"Quickstart",local:"quickstart",headingTag:"h2"}}),Q=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMiUyRnRtcCUyMiUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    max_length=<span class="hljs-number">512</span>,
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),Y=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKG91dHB1dF9kaXIlM0QlMjIlMkZ0bXAlMjIpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),D=new M({props:{title:"Advanced usage",local:"advanced-usage",headingTag:"h2"}}),O=new M({props:{title:"Train on completions only",local:"train-on-completions-only",headingTag:"h3"}}),et=new M({props:{title:"Add Special Tokens for Chat Format",local:"add-special-tokens-for-chat-format",headingTag:"h3"}}),lt=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBzZXR1cF9jaGF0X2Zvcm1hdCUwQSUwQSUyMyUyMExvYWQlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEElMEElMjMlMjBTZXQlMjB1cCUyMHRoZSUyMGNoYXQlMjBmb3JtYXQlMjB3aXRoJTIwZGVmYXVsdCUyMCdjaGF0bWwnJTIwZm9ybWF0JTBBbW9kZWwlMkMlMjB0b2tlbml6ZXIlMjAlM0QlMjBzZXR1cF9jaGF0X2Zvcm1hdChtb2RlbCUyQyUyMHRva2VuaXplcik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> setup_chat_format

<span class="hljs-comment"># Load model and tokenizer</span>
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

<span class="hljs-comment"># Set up the chat format with default &#x27;chatml&#x27; format</span>
model, tokenizer = setup_chat_format(model, tokenizer)`,wrap:!1}}),N=new Qo({props:{warning:!0,$$slots:{default:[ei]},$$scope:{ctx:x}}}),ot=new M({props:{title:"Dataset format support",local:"dataset-format-support",headingTag:"h3"}}),pt=new g({props:{code:"JTdCJTIybWVzc2FnZXMlMjIlM0ElMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGhlbHBmdWwlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0J3MlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YlMjIlN0QlMkMlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMi4uLiUyMiU3RCU1RCU3RCUwQSU3QiUyMm1lc3NhZ2VzJTIyJTNBJTIwJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBoZWxwZnVsJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwd3JvdGUlMjAnUm9tZW8lMjBhbmQlMjBKdWxpZXQnJTNGJTIyJTdEJTJDJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIuLi4lMjIlN0QlNUQlN0QlMEElN0IlMjJtZXNzYWdlcyUyMiUzQSUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwaGVscGZ1bCUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMGZhciUyMGlzJTIwdGhlJTIwTW9vbiUyMGZyb20lMjBFYXJ0aCUzRiUyMiU3RCUyQyUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyLi4uJTIyJTdEJTVEJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What&#x27;s the capital of France?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Who wrote &#x27;Romeo and Juliet&#x27;?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;system&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;You are helpful&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;How far is the Moon from Earth?&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;...&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ct=new g({props:{code:"JTdCJTIycHJvbXB0JTIyJTNBJTIwJTIyJTNDcHJvbXB0JTIwdGV4dCUzRSUyMiUyQyUyMCUyMmNvbXBsZXRpb24lMjIlM0ElMjAlMjIlM0NpZGVhbCUyMGdlbmVyYXRlZCUyMHRleHQlM0UlMjIlN0QlMEElN0IlMjJwcm9tcHQlMjIlM0ElMjAlMjIlM0Nwcm9tcHQlMjB0ZXh0JTNFJTIyJTJDJTIwJTIyY29tcGxldGlvbiUyMiUzQSUyMCUyMiUzQ2lkZWFsJTIwZ2VuZXJhdGVkJTIwdGV4dCUzRSUyMiU3RCUwQSU3QiUyMnByb21wdCUyMiUzQSUyMCUyMiUzQ3Byb21wdCUyMHRleHQlM0UlMjIlMkMlMjAlMjJjb21wbGV0aW9uJTIyJTNBJTIwJTIyJTNDaWRlYWwlMjBnZW5lcmF0ZWQlMjB0ZXh0JTNFJTIyJTdE",highlighted:`<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;prompt&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;prompt text&gt;&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;completion&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;ideal generated text&gt;&quot;</span><span class="hljs-punctuation">}</span>`,wrap:!1}}),ut=new g({props:{code:"JTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

...

<span class="hljs-comment"># load jsonl dataset</span>
dataset = load_dataset(<span class="hljs-string">&quot;json&quot;</span>, data_files=<span class="hljs-string">&quot;path/to/dataset.jsonl&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-comment"># load dataset from the HuggingFace Hub</span>
dataset = load_dataset(<span class="hljs-string">&quot;philschmid/dolly-15k-oai-style&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

...

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    args=training_args,
    train_dataset=dataset,
)`,wrap:!1}}),ft=new M({props:{title:"Format your input prompts",local:"format-your-input-prompts",headingTag:"h3"}}),Mt=new g({props:{code:"QmVsb3clMjBpcyUyMGFuJTIwaW5zdHJ1Y3Rpb24lMjAuLi4lMEElMEElMjMlMjMlMjMlMjBJbnN0cnVjdGlvbiUwQSU3QnByb21wdCU3RCUwQSUwQSUyMyUyMyUyMyUyMFJlc3BvbnNlJTNBJTBBJTdCY29tcGxldGlvbiU3RA==",highlighted:`Below is an instruction ...

<span class="hljs-comment">### Instruction</span>
{prompt}

<span class="hljs-comment">### Response:</span>
{completion}`,wrap:!1}}),Tt=new g({props:{code:"JTBBJTBB",highlighted:`...
<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_prompts_func</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>


trainer = SFTTrainer(
    model,
    args=training_args,
    train_dataset=dataset,
    formatting_func=formatting_prompt_func,
)

trainer.train()`,wrap:!1}}),wt=new M({props:{title:"Packing dataset",local:"packing-dataset",headingTag:"h3"}}),jt=new g({props:{code:"JTBB",highlighted:`...
training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args
)

trainer.train()`,wrap:!1}}),vt=new M({props:{title:"Customize your prompts using packed dataset",local:"customize-your-prompts-using-packed-dataset",headingTag:"h4"}}),It=new g({props:{code:"ZGVmJTIwZm9ybWF0dGluZ19mdW5jKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwdGV4dCUyMCUzRCUyMGYlMjIlMjMlMjMlMjMlMjBRdWVzdGlvbiUzQSUyMCU3QmV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTdEJTVDbiUyMCUyMyUyMyUyMyUyMEFuc3dlciUzQSUyMCU3QmV4YW1wbGUlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRleHQlMEElMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwU0ZUQ29uZmlnKHBhY2tpbmclM0RUcnVlKSUwQXRyYWluZXIlMjAlM0QlMjBTRlRUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwZm9ybWF0dGluZ19mdW5jJTNEZm9ybWF0dGluZ19mdW5jJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">formatting_func</span>(<span class="hljs-params">example</span>):
    text = <span class="hljs-string">f&quot;### Question: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;question&#x27;</span>]}</span>\\n ### Answer: <span class="hljs-subst">{example[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">return</span> text

training_args = SFTConfig(packing=<span class="hljs-literal">True</span>)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
    formatting_func=formatting_func
)

trainer.train()`,wrap:!1}}),Ct=new M({props:{title:"Control over the pretrained model",local:"control-over-the-pretrained-model",headingTag:"h3"}}),$t=new g({props:{code:"JTBBJTBB",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, torch_dtype=torch.bfloat16)

...

training_args = SFTConfig(
    model_init_kwargs={
        <span class="hljs-string">&quot;torch_dtype&quot;</span>: <span class="hljs-string">&quot;bfloat16&quot;</span>,
    },
    output_dir=<span class="hljs-string">&quot;/tmp&quot;</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)

trainer.train()`,wrap:!1}}),xt=new M({props:{title:"Training adapters",local:"training-adapters",headingTag:"h3"}}),At=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMExvcmFDb25maWclMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnRybC1saWIlMkZDYXB5YmFyYSUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBtb2R1bGVzX3RvX3NhdmUlM0QlNUIlMjJsbV9oZWFkJTIyJTJDJTIwJTIyZW1iZWRfdG9rZW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFNGVFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwJTIyUXdlbiUyRlF3ZW4yLjUtMC41QiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyhvdXRwdXRfZGlyJTNEJTIyUXdlbjIuNS0wLjVCLVNGVCUyMiklMkMlMEElMjAlMjAlMjAlMjBwZWZ0X2NvbmZpZyUzRHBlZnRfY29uZmlnJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/Capybara&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;lm_head&quot;</span>, <span class="hljs-string">&quot;embed_token&quot;</span>],
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

trainer = SFTTrainer(
    <span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B&quot;</span>,
    train_dataset=dataset,
    args=SFTConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-SFT&quot;</span>),
    peft_config=peft_config
)

trainer.train()`,wrap:!1}}),A=new Qo({props:{warning:!0,$$slots:{default:[ai]},$$scope:{ctx:x}}}),qt=new M({props:{title:"Training adapters with base 8 bit models",local:"training-adapters-with-base-8-bit-models",headingTag:"h3"}}),Gt=new g({props:{code:"JTBBJTBBJTBB",highlighted:`...

peft_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;EleutherAI/gpt-neo-125m&quot;</span>,
    load_in_8bit=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
)

trainer = SFTTrainer(
    model,
    train_dataset=dataset,
    args=SFTConfig(),
    peft_config=peft_config,
)

trainer.train()`,wrap:!1}}),Et=new M({props:{title:"Using Flash Attention and Flash Attention 2",local:"using-flash-attention-and-flash-attention-2",headingTag:"h2"}}),Wt=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZ2l0JTJCaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZ0cmFuc2Zvcm1lcnMuZ2l0",highlighted:"pip install -U git+https://github.com/huggingface/transformers.git",wrap:!1}}),Xt=new M({props:{title:"Using Flash-Attention 1",local:"using-flash-attention-1",headingTag:"h3"}}),Vt=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwb3B0aW11bQ==",highlighted:"pip install -U optimum",wrap:!1}}),zt=new g({props:{code:"",highlighted:`...

<span class="hljs-addition">+ with torch.backends.cuda.sdp_kernel(enable_flash=True, enable_math=False, enable_mem_efficient=False):</span>
    trainer.train()`,wrap:!1}}),Dt=new M({props:{title:"Using Flash Attention-2",local:"using-flash-attention-2",headingTag:"h3"}}),Kt=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0bg==",highlighted:"pip install -U flash-attn",wrap:!1}}),ee=new g({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(
    model_id,
    load_in_4bit=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
)`,wrap:!1}}),le=new M({props:{title:"Using model creation utility",local:"trl.ModelConfig",headingTag:"h3"}}),oe=new Ja({props:{name:"class trl.ModelConfig",anchor:"trl.ModelConfig",parameters:[{name:"model_name_or_path",val:": typing.Optional[str] = None"},{name:"model_revision",val:": str = 'main'"},{name:"torch_dtype",val:": typing.Optional[str] = None"},{name:"trust_remote_code",val:": bool = False"},{name:"attn_implementation",val:": typing.Optional[str] = None"},{name:"use_peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"lora_target_modules",val:": typing.Optional[list[str]] = None"},{name:"lora_modules_to_save",val:": typing.Optional[list[str]] = None"},{name:"lora_task_type",val:": str = 'CAUSAL_LM'"},{name:"use_rslora",val:": bool = False"},{name:"use_dora",val:": bool = False"},{name:"load_in_8bit",val:": bool = False"},{name:"load_in_4bit",val:": bool = False"},{name:"bnb_4bit_quant_type",val:": str = 'nf4'"},{name:"use_bnb_nested_quant",val:": bool = False"}],parametersDescription:[{anchor:"trl.ModelConfig.model_name_or_path",description:`<strong>model_name_or_path</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model checkpoint for weights initialization.`,name:"model_name_or_path"},{anchor:"trl.ModelConfig.model_revision",description:`<strong>model_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
Specific model version to use. It can be a branch name, a tag name, or a commit id.`,name:"model_revision"},{anchor:"trl.ModelConfig.torch_dtype",description:`<strong>torch_dtype</strong> (<code>Literal[&quot;auto&quot;, &quot;bfloat16&quot;, &quot;float16&quot;, &quot;float32&quot;]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Override the default <code>torch.dtype</code> and load the model under this dtype. Possible values are</p>
<ul>
<li><code>&quot;bfloat16&quot;</code>: <code>torch.bfloat16</code></li>
<li><code>&quot;float16&quot;</code>: <code>torch.float16</code></li>
<li><code>&quot;float32&quot;</code>: <code>torch.float32</code></li>
<li><code>&quot;auto&quot;</code>: Automatically derive the dtype from the model&#x2019;s weights.</li>
</ul>`,name:"torch_dtype"},{anchor:"trl.ModelConfig.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to allow for custom models defined on the Hub in their own modeling files. This option should only
be set to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code
present on the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"trl.ModelConfig.attn_implementation",description:`<strong>attn_implementation</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Which attention implementation to use. You can run <code>--attn_implementation=flash_attention_2</code>, in which case
you must install this manually by running <code>pip install flash-attn --no-build-isolation</code>.`,name:"attn_implementation"},{anchor:"trl.ModelConfig.use_peft",description:`<strong>use_peft</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use PEFT for training.`,name:"use_peft"},{anchor:"trl.ModelConfig.lora_r",description:`<strong>lora_r</strong> (<code>int</code>, <em>optional</em>, defaults to <code>16</code>) &#x2014;
LoRA R value.`,name:"lora_r"},{anchor:"trl.ModelConfig.lora_alpha",description:`<strong>lora_alpha</strong> (<code>int</code>, <em>optional</em>, defaults to <code>32</code>) &#x2014;
LoRA alpha.`,name:"lora_alpha"},{anchor:"trl.ModelConfig.lora_dropout",description:`<strong>lora_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.05</code>) &#x2014;
LoRA dropout.`,name:"lora_dropout"},{anchor:"trl.ModelConfig.lora_target_modules",description:`<strong>lora_target_modules</strong> (<code>Union[str, list[str]]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
LoRA target modules.`,name:"lora_target_modules"},{anchor:"trl.ModelConfig.lora_modules_to_save",description:`<strong>lora_modules_to_save</strong> (<code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Model layers to unfreeze &amp; train.`,name:"lora_modules_to_save"},{anchor:"trl.ModelConfig.lora_task_type",description:`<strong>lora_task_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;CAUSAL_LM&quot;</code>) &#x2014;
Task type to pass for LoRA (use <code>&quot;SEQ_CLS&quot;</code> for reward modeling).`,name:"lora_task_type"},{anchor:"trl.ModelConfig.use_rslora",description:`<strong>use_rslora</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use Rank-Stabilized LoRA, which sets the adapter scaling factor to <code>lora_alpha/&#x221A;r</code>, instead of
the original default value of <code>lora_alpha/r</code>.`,name:"use_rslora"},{anchor:"trl.ModelConfig.use_dora",description:`<strong>use_dora</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Enable <a href="https://huggingface.co/papers/2402.09353" rel="nofollow">Weight-Decomposed Low-Rank Adaptation (DoRA)</a>. This
technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is
handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can
improve the performance of LoRA, especially at low ranks. Right now, DoRA only supports linear and Conv2D
layers. DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for
inference.`,name:"use_dora"},{anchor:"trl.ModelConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 8 bit precision for the base model. Works only with LoRA.`,name:"load_in_8bit"},{anchor:"trl.ModelConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use 4 bit precision for the base model. Works only with LoRA.`,name:"load_in_4bit"},{anchor:"trl.ModelConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;nf4&quot;</code>) &#x2014;
Quantization type (<code>&quot;fp4&quot;</code> or <code>&quot;nf4&quot;</code>).`,name:"bnb_4bit_quant_type"},{anchor:"trl.ModelConfig.use_bnb_nested_quant",description:`<strong>use_bnb_nested_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use nested quantization.`,name:"use_bnb_nested_quant"}],source:"https://github.com/huggingface/trl/blob/v0.17.0/trl/trainer/model_config.py#L19"}}),ie=new g({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyME1vZGVsQ29uZmlnJTJDJTIwU0ZUVHJhaW5lciUyQyUyMGdldF9rYml0X2RldmljZV9tYXAlMkMlMjBnZXRfcGVmdF9jb25maWclMkMlMjBnZXRfcXVhbnRpemF0aW9uX2NvbmZpZyUwQW1vZGVsX2FyZ3MlMjAlM0QlMjBNb2RlbENvbmZpZyglMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lX29yX3BhdGglM0QlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRE5vbmUlMkMlMjAlMjMlMjBvciUyMCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKSUwQXRvcmNoX2R0eXBlJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2FyZ3MudG9yY2hfZHR5cGUlMEElMjAlMjAlMjAlMjBpZiUyMG1vZGVsX2FyZ3MudG9yY2hfZHR5cGUlMjBpbiUyMCU1QiUyMmF1dG8lMjIlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwZWxzZSUyMGdldGF0dHIodG9yY2glMkMlMjBtb2RlbF9hcmdzLnRvcmNoX2R0eXBlKSUwQSklMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwZ2V0X3F1YW50aXphdGlvbl9jb25maWcobW9kZWxfYXJncyklMEFtb2RlbF9rd2FyZ3MlMjAlM0QlMjBkaWN0KCUwQSUyMCUyMCUyMCUyMHJldmlzaW9uJTNEbW9kZWxfYXJncy5tb2RlbF9yZXZpc2lvbiUyQyUwQSUyMCUyMCUyMCUyMHRydXN0X3JlbW90ZV9jb2RlJTNEbW9kZWxfYXJncy50cnVzdF9yZW1vdGVfY29kZSUyQyUwQSUyMCUyMCUyMCUyMGF0dG5faW1wbGVtZW50YXRpb24lM0Rtb2RlbF9hcmdzLmF0dG5faW1wbGVtZW50YXRpb24lMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoX2R0eXBlJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2NhY2hlJTNERmFsc2UlMjBpZiUyMHRyYWluaW5nX2FyZ3MuZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMGVsc2UlMjBUcnVlJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGdldF9rYml0X2RldmljZV9tYXAoKSUyMGlmJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUyMGlzJTIwbm90JTIwTm9uZSUyMGVsc2UlMjBOb25lJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfYXJncy5tb2RlbF9uYW1lX29yX3BhdGglMkMlMjAqKm1vZGVsX2t3YXJncyklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2FyZ3MubW9kZWxfbmFtZV9vcl9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwcGVmdF9jb25maWclM0RnZXRfcGVmdF9jb25maWcobW9kZWxfYXJncyklMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> ModelConfig, SFTTrainer, get_kbit_device_map, get_peft_config, get_quantization_config
model_args = ModelConfig(
    model_name_or_path=<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>
    attn_implementation=<span class="hljs-literal">None</span>, <span class="hljs-comment"># or &quot;flash_attention_2&quot;</span>
)
torch_dtype = (
    model_args.torch_dtype
    <span class="hljs-keyword">if</span> model_args.torch_dtype <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;auto&quot;</span>, <span class="hljs-literal">None</span>]
    <span class="hljs-keyword">else</span> <span class="hljs-built_in">getattr</span>(torch, model_args.torch_dtype)
)
quantization_config = get_quantization_config(model_args)
model_kwargs = <span class="hljs-built_in">dict</span>(
    revision=model_args.model_revision,
    trust_remote_code=model_args.trust_remote_code,
    attn_implementation=model_args.attn_implementation,
    torch_dtype=torch_dtype,
    use_cache=<span class="hljs-literal">False</span> <span class="hljs-keyword">if</span> training_args.gradient_checkpointing <span class="hljs-keyword">else</span> <span class="hljs-literal">True</span>,
    device_map=get_kbit_device_map() <span class="hljs-keyword">if</span> quantization_config <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>,
    quantization_config=quantization_config,
)
model = AutoModelForCausalLM.from_pretrained(model_args.model_name_or_path, **model_kwargs)
trainer = SFTTrainer(
    ...,
    model=model_args.model_name_or_path,
    peft_config=get_peft_config(model_args),
)`,wrap:!1}}),re=new M({props:{title:"Enhance the model’s performances using NEFTune",local:"enhance-the-models-performances-using-neftune",headingTag:"h3"}}),me=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVENvbmZpZyUyQyUyMFNGVFRyYWluZXIlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnN0YW5mb3JkbmxwJTJGaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIpJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjAlMjAlMjBuZWZ0dW5lX25vaXNlX2FscGhhJTNENSUyQyUwQSklMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRGRhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer

dataset = load_dataset(<span class="hljs-string">&quot;stanfordnlp/imdb&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)

training_args = SFTConfig(
    neftune_noise_alpha=<span class="hljs-number">5</span>,
)
trainer = SFTTrainer(
    <span class="hljs-string">&quot;facebook/opt-350m&quot;</span>,
    train_dataset=dataset,
    args=training_args,
)
trainer.train()`,wrap:!1}}),fe=new M({props:{title:"Accelerate fine-tuning 2x using unsloth",local:"accelerate-fine-tuning-2x-using-unsloth",headingTag:"h3"}}),Te=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTConfig, SFTTrainer
<span class="hljs-keyword">from</span> unsloth <span class="hljs-keyword">import</span> FastLanguageModel

max_length = <span class="hljs-number">2048</span> <span class="hljs-comment"># Supports automatic RoPE Scaling, so choose any number</span>

<span class="hljs-comment"># Load model</span>
model, tokenizer = FastLanguageModel.from_pretrained(
    model_name=<span class="hljs-string">&quot;unsloth/mistral-7b&quot;</span>,
    max_seq_length=max_length,
    dtype=<span class="hljs-literal">None</span>,  <span class="hljs-comment"># None for auto detection. Float16 for Tesla T4, V100, Bfloat16 for Ampere+</span>
    load_in_4bit=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Use 4bit quantization to reduce memory usage. Can be False</span>
    <span class="hljs-comment"># token = &quot;hf_...&quot;, # use one if using gated models like meta-llama/Llama-2-7b-hf</span>
)

<span class="hljs-comment"># Do model patching and add fast LoRA weights</span>
model = FastLanguageModel.get_peft_model(
    model,
    r=<span class="hljs-number">16</span>,
    target_modules=[
        <span class="hljs-string">&quot;q_proj&quot;</span>,
        <span class="hljs-string">&quot;k_proj&quot;</span>,
        <span class="hljs-string">&quot;v_proj&quot;</span>,
        <span class="hljs-string">&quot;o_proj&quot;</span>,
        <span class="hljs-string">&quot;gate_proj&quot;</span>,
        <span class="hljs-string">&quot;up_proj&quot;</span>,
        <span class="hljs-string">&quot;down_proj&quot;</span>,
    ],
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0</span>,  <span class="hljs-comment"># Dropout = 0 is currently optimized</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,  <span class="hljs-comment"># Bias = &quot;none&quot; is currently optimized</span>
    use_gradient_checkpointing=<span class="hljs-literal">True</span>,
    random_state=<span class="hljs-number">3407</span>,
)

training_args = SFTConfig(output_dir=<span class="hljs-string">&quot;./output&quot;</span>, max_length=max_length)

trainer = SFTTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
)
trainer.train()`,wrap:!1}}),we=new M({props:{title:"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training",local:"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training",headingTag:"h2"}}),Ue=new g({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpZ2VyLWtlcm5lbA==",highlighted:"pip install liger-kernel",wrap:!1}}),Ie=new g({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFNGVENvbmZpZyglMEElMjAlMjB1c2VfbGlnZXJfa2VybmVsJTNEVHJ1ZSUwQSk=",highlighted:`training_args = SFTConfig(
  use_liger_kernel=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Fe=new M({props:{title:"Best practices",local:"best-practices",headingTag:"h2"}}),xe=new M({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h2"}}),Ze=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBQYXJ0aWFsU3RhdGUlMEFkZXZpY2Vfc3RyaW5nJTIwJTNEJTIwUGFydGlhbFN0YXRlKCkucHJvY2Vzc19pbmRleCUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0InJyUzQWRldmljZV9zdHJpbmclN0QlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
device_string = PartialState().process_index
model = AutoModelForCausalLM.from_pretrained(
     ...
    device_map={<span class="hljs-string">&#x27;&#x27;</span>:device_string}
)`,wrap:!1}}),qe=new M({props:{title:"GPTQ Conversion",local:"gptq-conversion",headingTag:"h2"}}),Ge=new M({props:{title:"Extending SFTTrainer for Vision Language Models",local:"extending-sfttrainer-for-vision-language-models",headingTag:"h2"}}),Se=new M({props:{title:"Preparing the Data",local:"preparing-the-data",headingTag:"h3"}}),Re=new g({props:{code:"aW1hZ2VzJTIwJTNEJTIwJTVCJTIyb2JhbWEucG5nJTIyJTVEJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIydGV4dCUyMiUyQyUyMCUyMnRleHQlMjIlM0ElMjAlMjJXaG8lMjBpcyUyMHRoaXMlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkJhcmFjayUyME9iYW1hJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjIlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMkhlJTIwaXMlMjB0aGUlMjA0NHRoJTIwUHJlc2lkZW50JTIwb2YlMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMuJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTVE",highlighted:`images = [<span class="hljs-string">&quot;obama.png&quot;</span>]
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Who is this?&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Barack Obama&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is he famous for?&quot;</span>}
        ]
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;He is the 44th President of the United States.&quot;</span>}
        ]
    }
]`,wrap:!1}}),He=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLTEuNS03Yi1oZiUyMiklMEFwcmludChwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMHRva2VuaXplJTNERmFsc2UpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-built_in">print</span>(processor.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>))`,wrap:!1}}),Qe=new g({props:{code:"V2hvJTIwaXMlMjB0aGlzJTNGJTIwQVNTSVNUQU5UJTNBJTIwQmFyYWNrJTIwT2JhbWElMjBVU0VSJTNBJTIwV2hhdCUyMGlzJTIwaGUlMjBmYW1vdXMlMjBmb3IlM0YlMjBBU1NJU1RBTlQlM0ElMjBIZSUyMGlzJTIwdGhlJTIwNDR0aCUyMFByZXNpZGVudCUyMG9mJTIwdGhlJTIwVW5pdGVkJTIwU3RhdGVzLiUyMA==",highlighted:"Who is this? ASSISTANT: Barack Obama USER: What is he famous for? ASSISTANT: He is the 44th President of the United States. ",wrap:!1}}),ze=new M({props:{title:"A custom collator for processing multi-modal data",local:"a-custom-collator-for-processing-multi-modal-data",headingTag:"h3"}}),Ye=new g({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjB0ZXh0cyUyMGFuZCUyMGltYWdlcyUyQyUyMGFuZCUyMGFwcGx5JTIwdGhlJTIwY2hhdCUyMHRlbXBsYXRlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShleGFtcGxlJTVCJTIybWVzc2FnZXMlMjIlNUQlMkMlMjB0b2tlbml6ZSUzREZhbHNlKSUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTIwJTNEJTIwJTVCZXhhbXBsZSU1QiUyMmltYWdlcyUyMiU1RCU1QjAlNUQlMjBmb3IlMjBleGFtcGxlJTIwaW4lMjBleGFtcGxlcyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRva2VuaXplJTIwdGhlJTIwdGV4dHMlMjBhbmQlMjBwcm9jZXNzJTIwdGhlJTIwaW1hZ2VzJTBBJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjBwcm9jZXNzb3IodGV4dHMlMkMlMjBpbWFnZXMlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVGhlJTIwbGFiZWxzJTIwYXJlJTIwdGhlJTIwaW5wdXRfaWRzJTJDJTIwYW5kJTIwd2UlMjBtYXNrJTIwdGhlJTIwcGFkZGluZyUyMHRva2VucyUyMGluJTIwdGhlJTIwbG9zcyUyMGNvbXB1dGF0aW9uJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwYmF0Y2glNUIlMjJpbnB1dF9pZHMlMjIlNUQuY2xvbmUoKSUwQSUyMCUyMCUyMCUyMGxhYmVscyU1QmxhYmVscyUyMCUzRCUzRCUyMHByb2Nlc3Nvci50b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEJTIwJTNEJTIwbGFiZWxzJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYmF0Y2g=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
    <span class="hljs-comment"># Get the texts and images, and apply the chat template</span>
    texts = [processor.apply_chat_template(example[<span class="hljs-string">&quot;messages&quot;</span>], tokenize=<span class="hljs-literal">False</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
    images = [example[<span class="hljs-string">&quot;images&quot;</span>][<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]

    <span class="hljs-comment"># Tokenize the texts and process the images</span>
    batch = processor(texts, images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># The labels are the input_ids, and we mask the padding tokens in the loss computation</span>
    labels = batch[<span class="hljs-string">&quot;input_ids&quot;</span>].clone()
    labels[labels == processor.tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    batch[<span class="hljs-string">&quot;labels&quot;</span>] = labels

    <span class="hljs-keyword">return</span> batch`,wrap:!1}}),De=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJIdWdnaW5nRmFjZUg0JTJGbGxhdmEtaW5zdHJ1Y3QtbWl4LXZzZnQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWV4YW1wbGVzJTIwJTNEJTIwJTVCZGF0YXNldCU1QjAlNUQlMkMlMjBkYXRhc2V0JTVCMSU1RCU1RCUyMCUyMCUyMyUyMEp1c3QlMjB0d28lMjBleGFtcGxlcyUyMGZvciUyMHRoZSUyMHNha2UlMjBvZiUyMHRoZSUyMGV4YW1wbGUlMEFjb2xsYXRlZF9kYXRhJTIwJTNEJTIwY29sbGF0ZV9mbihleGFtcGxlcyklMEFwcmludChjb2xsYXRlZF9kYXRhLmtleXMoKSklMjAlMjAlMjMlMjBkaWN0X2tleXMoJTVCJ2lucHV0X2lkcyclMkMlMjAnYXR0ZW50aW9uX21hc2snJTJDJTIwJ3BpeGVsX3ZhbHVlcyclMkMlMjAnbGFiZWxzJyU1RCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset = load_dataset(<span class="hljs-string">&quot;HuggingFaceH4/llava-instruct-mix-vsft&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
examples = [dataset[<span class="hljs-number">0</span>], dataset[<span class="hljs-number">1</span>]]  <span class="hljs-comment"># Just two examples for the sake of the example</span>
collated_data = collate_fn(examples)
<span class="hljs-built_in">print</span>(collated_data.keys())  <span class="hljs-comment"># dict_keys([&#x27;input_ids&#x27;, &#x27;attention_mask&#x27;, &#x27;pixel_values&#x27;, &#x27;labels&#x27;])</span>`,wrap:!1}}),Oe=new M({props:{title:"Training the vision-language model",local:"training-the-vision-language-model",headingTag:"h3"}}),ta=new g({props:{code:"dHJhaW5pbmdfYXJncy5yZW1vdmVfdW51c2VkX2NvbHVtbnMlMjAlM0QlMjBGYWxzZSUwQXRyYWluaW5nX2FyZ3MuZGF0YXNldF9rd2FyZ3MlMjAlM0QlMjAlN0IlMjJza2lwX3ByZXBhcmVfZGF0YXNldCUyMiUzQSUyMFRydWUlN0QlMEElMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEY29sbGF0ZV9mbiUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMEEp",highlighted:`training_args.remove_unused_columns = <span class="hljs-literal">False</span>
training_args.dataset_kwargs = {<span class="hljs-string">&quot;skip_prepare_dataset&quot;</span>: <span class="hljs-literal">True</span>}

trainer = SFTTrainer(
    model=model,
    args=training_args,
    data_collator=collate_fn,
    train_dataset=train_dataset,
    processing_class=processor.tokenizer,
)`,wrap:!1}}),na=new M({props:{title:"SFTTrainer",local:"trl.SFTTrainer",headingTag:"h2"}}),la=new Ja({props:{name:"class trl.SFTTrainer",anchor:"trl.SFTTrainer",parameters:[{name:"model",val:": typing.Union[str, torch.nn.modules.module.Module, transformers.modeling_utils.PreTrainedModel]"},{name:"args",val:": typing.Union[trl.trainer.sft_config.SFTConfig, transformers.training_args.TrainingArguments, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"train_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, datasets.iterable_dataset.IterableDataset, NoneType] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"compute_loss_func",val:": typing.Optional[typing.Callable] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalPrediction], dict]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"optimizer_cls_and_kwargs",val:": typing.Optional[tuple[type[torch.optim.optimizer.Optimizer], dict[str, typing.Any]]] = None"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[ForwardRef('PeftConfig')] = None"},{name:"formatting_func",val:": typing.Union[typing.Callable[[dict], str], typing.Callable[[dict], list[str]], NoneType] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.model",description:`<strong>model</strong> (<code>Union[str, PreTrainedModel]</code>) &#x2014;
Model to be trained. Can be either:</p>
<ul>
<li>A string, being the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co, or
a path to a <em>directory</em> containing model weights saved using
<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a>, e.g., <code>&apos;./my_model_directory/&apos;</code>. The model is
loaded using <a href="https://huggingface.co/docs/transformers/v4.51.3/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a> with the keywork arguments
in <code>args.model_init_kwargs</code>.</li>
<li>A <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/model#transformers.PreTrainedModel" rel="nofollow">PreTrainedModel</a> object. Only causal language models are supported.</li>
</ul>`,name:"model"},{anchor:"trl.SFTTrainer.args",description:`<strong>args</strong> (<a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTConfig">SFTConfig</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Configuration for this trainer. If <code>None</code>, a default configuration is used.`,name:"args"},{anchor:"trl.SFTTrainer.data_collator",description:`<strong>data_collator</strong> (<code>DataCollator</code>, <em>optional</em>) &#x2014;
Function to use to form a batch from a list of elements of the processed <code>train_dataset</code> or <code>eval_dataset</code>.
Will default to <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/data_collator#transformers.default_data_collator" rel="nofollow">default_data_collator</a> if no <code>processing_class</code> is provided, an instance
of <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/data_collator#transformers.DataCollatorWithPadding" rel="nofollow">DataCollatorWithPadding</a> otherwise if the processing_class is a feature extractor or
tokenizer.`,name:"data_collator"},{anchor:"trl.SFTTrainer.train_dataset",description:`<strong>train_dataset</strong> (<a href="https://huggingface.co/docs/datasets/v3.5.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a> or <a href="https://huggingface.co/docs/datasets/v3.5.0/en/package_reference/main_classes#datasets.IterableDataset" rel="nofollow">IterableDataset</a>) &#x2014;
Dataset to use for training. SFT supports both <a href="#language-modeling">language modeling</a> type and
<a href="#prompt-completion">prompt-completion</a> type. The format of the samples can be either:</p>
<ul>
<li><a href="dataset_formats#standard">Standard</a>: Each sample contains plain text.</li>
<li><a href="dataset_formats#conversational">Conversational</a>: Each sample contains structured messages (e.g., role
and content).</li>
</ul>
<p>The trainer also supports processed datasets (tokenized) as long as they contain an <code>input_ids</code> field.`,name:"train_dataset"},{anchor:"trl.SFTTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<a href="https://huggingface.co/docs/datasets/v3.5.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, <a href="https://huggingface.co/docs/datasets/v3.5.0/en/package_reference/main_classes#datasets.IterableDataset" rel="nofollow">IterableDataset</a> or <code>dict[str, Union[Dataset, IterableDataset]]</code>) &#x2014;
Dataset to use for evaluation. It must meet the same requirements as <code>train_dataset</code>.`,name:"eval_dataset"},{anchor:"trl.SFTTrainer.processing_class",description:`<strong>processing_class</strong> (<a href="https://huggingface.co/docs/transformers/v4.51.3/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase" rel="nofollow">PreTrainedTokenizerBase</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Processing class used to process the data. If <code>None</code>, the processing class is loaded from the model&#x2019;s name
with <a href="https://huggingface.co/docs/transformers/v4.51.3/en/model_doc/auto#transformers.AutoTokenizer.from_pretrained" rel="nofollow">from_pretrained</a>.`,name:"processing_class"},{anchor:"trl.SFTTrainer.callbacks",description:`<strong>callbacks</strong> (list of <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/callback#transformers.TrainerCallback" rel="nofollow">TrainerCallback</a>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
List of callbacks to customize the training loop. Will add those to the list of default callbacks
detailed in <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">here</a>.</p>
<p>If you want to remove one of the default callbacks used, use the <a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/trainer#transformers.Trainer.remove_callback" rel="nofollow">remove_callback</a>
method.`,name:"callbacks"},{anchor:"trl.SFTTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>, <em>optional</em>, defaults to <code>(None, None)</code>) &#x2014;
A tuple containing the optimizer and the scheduler to use. Will default to an instance of <code>AdamW</code> on your
model and a scheduler given by <code>get_linear_schedule_with_warmup</code> controlled by <code>args</code>.`,name:"optimizers"},{anchor:"trl.SFTTrainer.optimizer_cls_and_kwargs",description:`<strong>optimizer_cls_and_kwargs</strong> (<code>Tuple[Type[torch.optim.Optimizer], Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A tuple containing the optimizer class and keyword arguments to use.
Overrides <code>optim</code> and <code>optim_args</code> in <code>args</code>. Incompatible with the <code>optimizers</code> argument.</p>
<p>Unlike <code>optimizers</code>, this argument avoids the need to place model parameters on the correct devices before initializing the Trainer.`,name:"optimizer_cls_and_kwargs"},{anchor:"trl.SFTTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
A function that preprocess the logits right before caching them at each evaluation step. Must take two
tensors, the logits and the labels, and return the logits once processed as desired. The modifications made
by this function will be reflected in the predictions received by <code>compute_metrics</code>.</p>
<p>Note that the labels (second parameter) will be <code>None</code> if the dataset does not have them.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.SFTTrainer.peft_config",description:`<strong>peft_config</strong> (<code>~peft.PeftConfig</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
PEFT configuration used to wrap the model. If <code>None</code>, the model is not wrapped.`,name:"peft_config"},{anchor:"trl.SFTTrainer.formatting_func",description:`<strong>formatting_func</strong> (<code>Optional[Callable]</code>) &#x2014;
Formatting function applied to the dataset before tokenization.`,name:"formatting_func"}],source:"https://github.com/huggingface/trl/blob/v0.17.0/trl/trainer/sft_trainer.py#L141"}}),G=new Ko({props:{anchor:"trl.SFTTrainer.example",$$slots:{default:[ni]},$$scope:{ctx:x}}}),sa=new Ja({props:{name:"compute_loss",anchor:"trl.SFTTrainer.compute_loss",parameters:[{name:"model",val:""},{name:"inputs",val:""},{name:"return_outputs",val:" = False"},{name:"num_items_in_batch",val:" = None"}],source:"https://github.com/huggingface/trl/blob/v0.17.0/trl/trainer/sft_trainer.py#L649"}}),oa=new Ja({props:{name:"create_model_card",anchor:"trl.SFTTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.SFTTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the model.`,name:"model_name"},{anchor:"trl.SFTTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.SFTTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.17.0/trl/trainer/sft_trainer.py#L713"}}),ia=new M({props:{title:"SFTConfig",local:"trl.SFTConfig",headingTag:"h2"}}),ra=new Ja({props:{name:"class trl.SFTConfig",anchor:"trl.SFTConfig",parameters:[{name:"output_dir",val:": typing.Optional[str] = None"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 2e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, list[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[list[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[list[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": list = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, list[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_text_field",val:": str = 'text'"},{name:"dataset_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"eos_token",val:": typing.Optional[str] = None"},{name:"pad_token",val:": typing.Optional[str] = None"},{name:"max_length",val:": typing.Optional[int] = 1024"},{name:"packing",val:": bool = False"},{name:"padding_free",val:": bool = False"},{name:"eval_packing",val:": typing.Optional[bool] = None"},{name:"completion_only_loss",val:": typing.Optional[bool] = None"},{name:"dataset_batch_size",val:": typing.Optional[int] = None"},{name:"num_of_sequences",val:": typing.Optional[int] = None"},{name:"chars_per_token",val:": typing.Optional[float] = None"},{name:"max_seq_length",val:": typing.Optional[int] = None"},{name:"use_liger",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/trl/blob/v0.17.0/trl/trainer/sft_config.py#L22",parameterGroups:[{title:"Parameters that control the model",parametersDescription:[{anchor:"trl.SFTConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments for <a href="https://huggingface.co/docs/transformers/v4.51.3/en/model_doc/auto#transformers.AutoModelForCausalLM.from_pretrained" rel="nofollow">from_pretrained</a>, used when the <code>model</code>
argument of the <a href="/docs/trl/v0.17.0/en/sft_trainer#trl.SFTTrainer">SFTTrainer</a> is provided as a string.`,name:"model_init_kwargs"}]},{title:"Parameters that control the data preprocessing",parametersDescription:[{anchor:"trl.SFTConfig.dataset_text_field",description:`<strong>dataset_text_field</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text&quot;</code>) &#x2014;
Name of the column that contains text data in the dataset.`,name:"dataset_text_field"},{anchor:"trl.SFTConfig.dataset_kwargs",description:`<strong>dataset_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Dictionary of optional keyword arguments for the dataset preparation. The only supported key is
<code>skip_prepare_dataset</code>.`,name:"dataset_kwargs"},{anchor:"trl.SFTConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.SFTConfig.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Token used to indicate the end of a turn or sequence. If <code>None</code>, it defaults to <code>processing_class.eos_token</code>.`,name:"eos_token"},{anchor:"trl.SFTConfig.pad_token",description:`<strong>pad_token</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Token used for padding. If <code>None</code>, it defaults to <code>processing_class.pad_token</code>, or if that is also <code>None</code>,
it falls back to <code>processing_class.eos_token</code>.`,name:"pad_token"},{anchor:"trl.SFTConfig.max_length",description:`<strong>max_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Maximum length of the tokenized sequence. Sequences longer than <code>max_length</code> are truncated from the right.
If <code>None</code>, no truncation is applied. When packing is enabled, this value sets the sequence length.`,name:"max_length"},{anchor:"trl.SFTConfig.packing",description:`<strong>packing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to pack multiple sequences into a fixed-length format. Uses <code>max_length</code> to define sequence length.`,name:"packing"},{anchor:"trl.SFTConfig.padding_free",description:`<strong>padding_free</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to perform forward passes without padding by flattening all sequences in the batch into a single
continuous sequence. This reduces memory usage by eliminating padding overhead. Currently, this is only
supported with the <code>flash_attention_2</code> attention implementation, which can efficiently handle the flattened
batch structure.`,name:"padding_free"},{anchor:"trl.SFTConfig.eval_packing",description:`<strong>eval_packing</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to pack the eval dataset. If <code>None</code>, uses the same value as <code>packing</code>.`,name:"eval_packing"}]},{title:"Parameters that control the training",parametersDescription:[{anchor:"trl.SFTConfig.learning_rate",description:`<strong>learning_rate</strong> (<code>float</code>, <em>optional</em>, defaults to <code>2e-5</code>) &#x2014;
Initial learning rate for <code>AdamW</code> optimizer. The default value replaces that of
<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a>.`,name:"learning_rate"},{anchor:"trl.SFTConfig.completion_only_loss",description:`<strong>completion_only_loss</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to compute loss only on the completion part of the sequence. If set to <code>True</code>, loss is computed
only on the completion, which is supported only for <a href="#prompt-completion">prompt-completion</a> datasets. If
<code>False</code>, loss is computed on the entire sequence. If <code>None</code> (default), the behavior depends on the dataset:
loss is computed on the completion for <a href="#prompt-completion">prompt-completion</a> datasets, and on
the full sequence for <a href="#language-modeling">language modeling</a> datasets.`,name:"completion_only_loss"}]}]}}),pa=new M({props:{title:"Datasets",local:"datasets",headingTag:"h2"}}),ma=new ti({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/sft_trainer.md"}}),{c(){f=o("meta"),J=l(),T=o("p"),b=l(),p(U.$$.fragment),_=l(),C=o("p"),C.innerHTML=gs,va=l(),X=o("p"),X.innerHTML=Ms,Ua=l(),p(H.$$.fragment),Ia=l(),V=o("p"),V.innerHTML=ys,Ca=l(),p(Q.$$.fragment),Fa=l(),z=o("p"),z.innerHTML=Ts,$a=l(),L=o("p"),L.textContent=_s,ka=l(),p(Y.$$.fragment),xa=l(),P=o("p"),P.innerHTML=ws,Na=l(),p(D.$$.fragment),Aa=l(),p(O.$$.fragment),Za=l(),K=o("p"),K.innerHTML=bs,qa=l(),tt=o("p"),tt.innerHTML=js,Ba=l(),p(et.$$.fragment),Ga=l(),at=o("p"),at.innerHTML=Js,Ea=l(),nt=o("ul"),nt.innerHTML=vs,Sa=l(),p(lt.$$.fragment),Wa=l(),p(N.$$.fragment),Ra=l(),st=o("p"),st.textContent=Us,Xa=l(),p(ot.$$.fragment),Ha=l(),it=o("p"),it.innerHTML=Is,Va=l(),rt=o("ul"),rt.innerHTML=Cs,Qa=l(),p(pt.$$.fragment),za=l(),dt=o("ul"),dt.innerHTML=Fs,La=l(),p(ct.$$.fragment),Ya=l(),mt=o("p"),mt.innerHTML=$s,Pa=l(),p(ut.$$.fragment),Da=l(),ht=o("p"),ht.textContent=ks,Oa=l(),p(ft.$$.fragment),Ka=l(),gt=o("p"),gt.innerHTML=xs,tn=l(),p(Mt.$$.fragment),en=l(),yt=o("p"),yt.innerHTML=Ns,an=l(),p(Tt.$$.fragment),nn=l(),_t=o("p"),_t.innerHTML=As,ln=l(),p(wt.$$.fragment),sn=l(),bt=o("p"),bt.innerHTML=Zs,on=l(),p(jt.$$.fragment),rn=l(),Jt=o("p"),Jt.innerHTML=qs,pn=l(),p(vt.$$.fragment),dn=l(),Ut=o("p"),Ut.innerHTML=Bs,cn=l(),p(It.$$.fragment),mn=l(),p(Ct.$$.fragment),un=l(),Ft=o("p"),Ft.innerHTML=Gs,hn=l(),p($t.$$.fragment),fn=l(),kt=o("p"),kt.innerHTML=Es,gn=l(),p(xt.$$.fragment),Mn=l(),Nt=o("p"),Nt.textContent=Ss,yn=l(),p(At.$$.fragment),Tn=l(),p(A.$$.fragment),_n=l(),Zt=o("p"),Zt.innerHTML=Ws,wn=l(),p(qt.$$.fragment),bn=l(),Bt=o("p"),Bt.innerHTML=Rs,jn=l(),p(Gt.$$.fragment),Jn=l(),p(Et.$$.fragment),vn=l(),St=o("p"),St.textContent=Xs,Un=l(),p(Wt.$$.fragment),In=l(),Rt=o("p"),Rt.textContent=Hs,Cn=l(),p(Xt.$$.fragment),Fn=l(),Ht=o("p"),Ht.innerHTML=Vs,$n=l(),p(Vt.$$.fragment),kn=l(),Qt=o("p"),Qt.innerHTML=Qs,xn=l(),p(zt.$$.fragment),Nn=l(),Lt=o("p"),Lt.innerHTML=zs,An=l(),Yt=o("p"),Yt.textContent=Ls,Zn=l(),Pt=o("table"),Pt.innerHTML=Ys,qn=l(),p(Dt.$$.fragment),Bn=l(),Ot=o("p"),Ot.innerHTML=Ps,Gn=l(),p(Kt.$$.fragment),En=l(),te=o("p"),te.innerHTML=Ds,Sn=l(),p(ee.$$.fragment),Wn=l(),ae=o("p"),ae.textContent=Os,Rn=l(),ne=o("p"),ne.textContent=Ks,Xn=l(),p(le.$$.fragment),Hn=l(),se=o("p"),se.textContent=to,Vn=l(),F=o("div"),p(oe.$$.fragment),ns=l(),ha=o("p"),ha.textContent=eo,ls=l(),fa=o("p"),fa.innerHTML=ao,Qn=l(),p(ie.$$.fragment),zn=l(),p(re.$$.fragment),Ln=l(),pe=o("p"),pe.innerHTML=no,Yn=l(),de=o("blockquote"),de.innerHTML=lo,Pn=l(),Z=o("div"),Z.innerHTML=so,Dn=l(),ce=o("p"),ce.innerHTML=oo,On=l(),p(me.$$.fragment),Kn=l(),ue=o("p"),ue.innerHTML=io,tl=l(),q=o("div"),q.innerHTML=ro,el=l(),he=o("p"),he.innerHTML=po,al=l(),p(fe.$$.fragment),nl=l(),ge=o("p"),ge.innerHTML=co,ll=l(),Me=o("table"),Me.innerHTML=mo,sl=l(),ye=o("p"),ye.innerHTML=uo,ol=l(),p(Te.$$.fragment),il=l(),_e=o("p"),_e.innerHTML=ho,rl=l(),p(we.$$.fragment),pl=l(),be=o("p"),be.innerHTML=fo,dl=l(),je=o("p"),je.textContent=go,cl=l(),Je=o("table"),Je.innerHTML=Mo,ml=l(),ve=o("ol"),ve.innerHTML=yo,ul=l(),p(Ue.$$.fragment),hl=l(),B=o("ol"),B.innerHTML=To,fl=l(),p(Ie.$$.fragment),gl=l(),Ce=o("p"),Ce.innerHTML=_o,Ml=l(),p(Fe.$$.fragment),yl=l(),$e=o("p"),$e.textContent=wo,Tl=l(),ke=o("ul"),ke.innerHTML=bo,_l=l(),p(xe.$$.fragment),wl=l(),Ne=o("p"),Ne.innerHTML=jo,bl=l(),Ae=o("ul"),Ae.innerHTML=Jo,jl=l(),p(Ze.$$.fragment),Jl=l(),p(qe.$$.fragment),vl=l(),Be=o("p"),Be.innerHTML=vo,Ul=l(),p(Ge.$$.fragment),Il=l(),Ee=o("p"),Ee.innerHTML=Uo,Cl=l(),p(Se.$$.fragment),Fl=l(),We=o("p"),We.textContent=Io,$l=l(),p(Re.$$.fragment),kl=l(),Xe=o("p"),Xe.textContent=Co,xl=l(),p(He.$$.fragment),Nl=l(),Ve=o("p"),Ve.textContent=Fo,Al=l(),p(Qe.$$.fragment),Zl=l(),$=o("iframe"),ql=l(),p(ze.$$.fragment),Bl=l(),Le=o("p"),Le.innerHTML=ko,Gl=l(),p(Ye.$$.fragment),El=l(),Pe=o("p"),Pe.textContent=xo,Sl=l(),p(De.$$.fragment),Wl=l(),p(Oe.$$.fragment),Rl=l(),Ke=o("p"),Ke.innerHTML=No,Xl=l(),p(ta.$$.fragment),Hl=l(),ea=o("p"),ea.innerHTML=Ao,Vl=l(),aa=o("ul"),aa.innerHTML=Zo,Ql=l(),p(na.$$.fragment),zl=l(),w=o("div"),p(la.$$.fragment),ss=l(),ga=o("p"),ga.textContent=qo,os=l(),Ma=o("p"),Ma.innerHTML=Bo,is=l(),p(G.$$.fragment),rs=l(),E=o("div"),p(sa.$$.fragment),ps=l(),ya=o("p"),ya.textContent=Go,ds=l(),S=o("div"),p(oa.$$.fragment),cs=l(),Ta=o("p"),Ta.innerHTML=Eo,Ll=l(),p(ia.$$.fragment),Yl=l(),v=o("div"),p(ra.$$.fragment),ms=l(),_a=o("p"),_a.innerHTML=So,us=l(),wa=o("p"),wa.innerHTML=Wo,hs=l(),ba=o("p"),ba.innerHTML=Ro,Pl=l(),p(pa.$$.fragment),Dl=l(),da=o("p"),da.innerHTML=Xo,Ol=l(),ca=o("p"),ca.innerHTML=Ho,Kl=l(),p(ma.$$.fragment),ts=l(),ja=o("p"),this.h()},l(t){const e=Oo("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(a),J=s(t),T=i(t,"P",{}),R(T).forEach(a),b=s(t),d(U.$$.fragment,t),_=s(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-3qdiva"&&(C.innerHTML=gs),va=s(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-7wn2yx"&&(X.innerHTML=Ms),Ua=s(t),d(H.$$.fragment,t),Ia=s(t),V=i(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1xtmjd7"&&(V.innerHTML=ys),Ca=s(t),d(Q.$$.fragment,t),Fa=s(t),z=i(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1ixmgvo"&&(z.innerHTML=Ts),$a=s(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-ulikv8"&&(L.textContent=_s),ka=s(t),d(Y.$$.fragment,t),xa=s(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-yh0ppk"&&(P.innerHTML=ws),Na=s(t),d(D.$$.fragment,t),Aa=s(t),d(O.$$.fragment,t),Za=s(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-badgis"&&(K.innerHTML=bs),qa=s(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-hdbaeb"&&(tt.innerHTML=js),Ba=s(t),d(et.$$.fragment,t),Ga=s(t),at=i(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1ccg0zx"&&(at.innerHTML=Js),Ea=s(t),nt=i(t,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-ebt5re"&&(nt.innerHTML=vs),Sa=s(t),d(lt.$$.fragment,t),Wa=s(t),d(N.$$.fragment,t),Ra=s(t),st=i(t,"P",{"data-svelte-h":!0}),r(st)!=="svelte-1hmfl2q"&&(st.textContent=Us),Xa=s(t),d(ot.$$.fragment,t),Ha=s(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-10zqcb6"&&(it.innerHTML=Is),Va=s(t),rt=i(t,"UL",{"data-svelte-h":!0}),r(rt)!=="svelte-5iwuvk"&&(rt.innerHTML=Cs),Qa=s(t),d(pt.$$.fragment,t),za=s(t),dt=i(t,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-23l1e6"&&(dt.innerHTML=Fs),La=s(t),d(ct.$$.fragment,t),Ya=s(t),mt=i(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-hicu2m"&&(mt.innerHTML=$s),Pa=s(t),d(ut.$$.fragment,t),Da=s(t),ht=i(t,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-145h0zs"&&(ht.textContent=ks),Oa=s(t),d(ft.$$.fragment,t),Ka=s(t),gt=i(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-cqsf2h"&&(gt.innerHTML=xs),tn=s(t),d(Mt.$$.fragment,t),en=s(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-l25vq0"&&(yt.innerHTML=Ns),an=s(t),d(Tt.$$.fragment,t),nn=s(t),_t=i(t,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-j2xlt3"&&(_t.innerHTML=As),ln=s(t),d(wt.$$.fragment,t),sn=s(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-2n8v6m"&&(bt.innerHTML=Zs),on=s(t),d(jt.$$.fragment,t),rn=s(t),Jt=i(t,"P",{"data-svelte-h":!0}),r(Jt)!=="svelte-t5o0mn"&&(Jt.innerHTML=qs),pn=s(t),d(vt.$$.fragment,t),dn=s(t),Ut=i(t,"P",{"data-svelte-h":!0}),r(Ut)!=="svelte-iejqw3"&&(Ut.innerHTML=Bs),cn=s(t),d(It.$$.fragment,t),mn=s(t),d(Ct.$$.fragment,t),un=s(t),Ft=i(t,"P",{"data-svelte-h":!0}),r(Ft)!=="svelte-1tykk53"&&(Ft.innerHTML=Gs),hn=s(t),d($t.$$.fragment,t),fn=s(t),kt=i(t,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-1su7aih"&&(kt.innerHTML=Es),gn=s(t),d(xt.$$.fragment,t),Mn=s(t),Nt=i(t,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1x3lqim"&&(Nt.textContent=Ss),yn=s(t),d(At.$$.fragment,t),Tn=s(t),d(A.$$.fragment,t),_n=s(t),Zt=i(t,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-pwdaav"&&(Zt.innerHTML=Ws),wn=s(t),d(qt.$$.fragment,t),bn=s(t),Bt=i(t,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-11pydf"&&(Bt.innerHTML=Rs),jn=s(t),d(Gt.$$.fragment,t),Jn=s(t),d(Et.$$.fragment,t),vn=s(t),St=i(t,"P",{"data-svelte-h":!0}),r(St)!=="svelte-fyvvsj"&&(St.textContent=Xs),Un=s(t),d(Wt.$$.fragment,t),In=s(t),Rt=i(t,"P",{"data-svelte-h":!0}),r(Rt)!=="svelte-yypgof"&&(Rt.textContent=Hs),Cn=s(t),d(Xt.$$.fragment,t),Fn=s(t),Ht=i(t,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-yugu96"&&(Ht.innerHTML=Vs),$n=s(t),d(Vt.$$.fragment,t),kn=s(t),Qt=i(t,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-1qms4cl"&&(Qt.innerHTML=Qs),xn=s(t),d(zt.$$.fragment,t),Nn=s(t),Lt=i(t,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-qe5zfz"&&(Lt.innerHTML=zs),An=s(t),Yt=i(t,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-69u1rz"&&(Yt.textContent=Ls),Zn=s(t),Pt=i(t,"TABLE",{"data-svelte-h":!0}),r(Pt)!=="svelte-1xan75p"&&(Pt.innerHTML=Ys),qn=s(t),d(Dt.$$.fragment,t),Bn=s(t),Ot=i(t,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1rqlm78"&&(Ot.innerHTML=Ps),Gn=s(t),d(Kt.$$.fragment,t),En=s(t),te=i(t,"P",{"data-svelte-h":!0}),r(te)!=="svelte-14s96xo"&&(te.innerHTML=Ds),Sn=s(t),d(ee.$$.fragment,t),Wn=s(t),ae=i(t,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-vfpk19"&&(ae.textContent=Os),Rn=s(t),ne=i(t,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-162zeem"&&(ne.textContent=Ks),Xn=s(t),d(le.$$.fragment,t),Hn=s(t),se=i(t,"P",{"data-svelte-h":!0}),r(se)!=="svelte-u9yx96"&&(se.textContent=to),Vn=s(t),F=i(t,"DIV",{class:!0});var k=R(F);d(oe.$$.fragment,k),ns=s(k),ha=i(k,"P",{"data-svelte-h":!0}),r(ha)!=="svelte-21rjm6"&&(ha.textContent=eo),ls=s(k),fa=i(k,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-1itwmqz"&&(fa.innerHTML=ao),k.forEach(a),Qn=s(t),d(ie.$$.fragment,t),zn=s(t),d(re.$$.fragment,t),Ln=s(t),pe=i(t,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-8q8jbt"&&(pe.innerHTML=no),Yn=s(t),de=i(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(de)!=="svelte-1ejl1pl"&&(de.innerHTML=lo),Pn=s(t),Z=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1oygymd"&&(Z.innerHTML=so),Dn=s(t),ce=i(t,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-15c39pv"&&(ce.innerHTML=oo),On=s(t),d(me.$$.fragment,t),Kn=s(t),ue=i(t,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-sqj12"&&(ue.innerHTML=io),tl=s(t),q=i(t,"DIV",{style:!0,"data-svelte-h":!0}),r(q)!=="svelte-1wn6sb4"&&(q.innerHTML=ro),el=s(t),he=i(t,"P",{"data-svelte-h":!0}),r(he)!=="svelte-rwofnh"&&(he.innerHTML=po),al=s(t),d(fe.$$.fragment,t),nl=s(t),ge=i(t,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1q1m1nw"&&(ge.innerHTML=co),ll=s(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),r(Me)!=="svelte-lj2wpp"&&(Me.innerHTML=mo),sl=s(t),ye=i(t,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1p74c9x"&&(ye.innerHTML=uo),ol=s(t),d(Te.$$.fragment,t),il=s(t),_e=i(t,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1o18rwj"&&(_e.innerHTML=ho),rl=s(t),d(we.$$.fragment,t),pl=s(t),be=i(t,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1tpy3c1"&&(be.innerHTML=fo),dl=s(t),je=i(t,"P",{"data-svelte-h":!0}),r(je)!=="svelte-wsouej"&&(je.textContent=go),cl=s(t),Je=i(t,"TABLE",{"data-svelte-h":!0}),r(Je)!=="svelte-1jpb79"&&(Je.innerHTML=Mo),ml=s(t),ve=i(t,"OL",{"data-svelte-h":!0}),r(ve)!=="svelte-i7h8xn"&&(ve.innerHTML=yo),ul=s(t),d(Ue.$$.fragment,t),hl=s(t),B=i(t,"OL",{start:!0,"data-svelte-h":!0}),r(B)!=="svelte-16fnzm8"&&(B.innerHTML=To),fl=s(t),d(Ie.$$.fragment,t),gl=s(t),Ce=i(t,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1h5mxii"&&(Ce.innerHTML=_o),Ml=s(t),d(Fe.$$.fragment,t),yl=s(t),$e=i(t,"P",{"data-svelte-h":!0}),r($e)!=="svelte-g801h1"&&($e.textContent=wo),Tl=s(t),ke=i(t,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-1wp3m6h"&&(ke.innerHTML=bo),_l=s(t),d(xe.$$.fragment,t),wl=s(t),Ne=i(t,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-s3xf41"&&(Ne.innerHTML=jo),bl=s(t),Ae=i(t,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-19jsxq"&&(Ae.innerHTML=Jo),jl=s(t),d(Ze.$$.fragment,t),Jl=s(t),d(qe.$$.fragment,t),vl=s(t),Be=i(t,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-xofzi2"&&(Be.innerHTML=vo),Ul=s(t),d(Ge.$$.fragment,t),Il=s(t),Ee=i(t,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-gz974t"&&(Ee.innerHTML=Uo),Cl=s(t),d(Se.$$.fragment,t),Fl=s(t),We=i(t,"P",{"data-svelte-h":!0}),r(We)!=="svelte-58v4pe"&&(We.textContent=Io),$l=s(t),d(Re.$$.fragment,t),kl=s(t),Xe=i(t,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1i9g14v"&&(Xe.textContent=Co),xl=s(t),d(He.$$.fragment,t),Nl=s(t),Ve=i(t,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-aegjvb"&&(Ve.textContent=Fo),Al=s(t),d(Qe.$$.fragment,t),Zl=s(t),$=i(t,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0}),R($).forEach(a),ql=s(t),d(ze.$$.fragment,t),Bl=s(t),Le=i(t,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1y2dzof"&&(Le.innerHTML=ko),Gl=s(t),d(Ye.$$.fragment,t),El=s(t),Pe=i(t,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-ezw63w"&&(Pe.textContent=xo),Sl=s(t),d(De.$$.fragment,t),Wl=s(t),d(Oe.$$.fragment,t),Rl=s(t),Ke=i(t,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-yvalkp"&&(Ke.innerHTML=No),Xl=s(t),d(ta.$$.fragment,t),Hl=s(t),ea=i(t,"P",{"data-svelte-h":!0}),r(ea)!=="svelte-bk6pmc"&&(ea.innerHTML=Ao),Vl=s(t),aa=i(t,"UL",{"data-svelte-h":!0}),r(aa)!=="svelte-ata0nu"&&(aa.innerHTML=Zo),Ql=s(t),d(na.$$.fragment,t),zl=s(t),w=i(t,"DIV",{class:!0});var j=R(w);d(la.$$.fragment,j),ss=s(j),ga=i(j,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-1pvil1z"&&(ga.textContent=qo),os=s(j),Ma=i(j,"P",{"data-svelte-h":!0}),r(Ma)!=="svelte-1h1r7qo"&&(Ma.innerHTML=Bo),is=s(j),d(G.$$.fragment,j),rs=s(j),E=i(j,"DIV",{class:!0});var ua=R(E);d(sa.$$.fragment,ua),ps=s(ua),ya=i(ua,"P",{"data-svelte-h":!0}),r(ya)!=="svelte-wli0e"&&(ya.textContent=Go),ua.forEach(a),ds=s(j),S=i(j,"DIV",{class:!0});var as=R(S);d(oa.$$.fragment,as),cs=s(as),Ta=i(as,"P",{"data-svelte-h":!0}),r(Ta)!=="svelte-1mh859w"&&(Ta.innerHTML=Eo),as.forEach(a),j.forEach(a),Ll=s(t),d(ia.$$.fragment,t),Yl=s(t),v=i(t,"DIV",{class:!0});var W=R(v);d(ra.$$.fragment,W),ms=s(W),_a=i(W,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-10skw1o"&&(_a.innerHTML=So),us=s(W),wa=i(W,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-lgs4dn"&&(wa.innerHTML=Wo),hs=s(W),ba=i(W,"P",{"data-svelte-h":!0}),r(ba)!=="svelte-1itwmqz"&&(ba.innerHTML=Ro),W.forEach(a),Pl=s(t),d(pa.$$.fragment,t),Dl=s(t),da=i(t,"P",{"data-svelte-h":!0}),r(da)!=="svelte-16l6c3u"&&(da.innerHTML=Xo),Ol=s(t),ca=i(t,"P",{"data-svelte-h":!0}),r(ca)!=="svelte-k5kqyl"&&(ca.innerHTML=Ho),Kl=s(t),d(ma.$$.fragment,t),ts=s(t),ja=i(t,"P",{}),R(ja).forEach(a),this.h()},h(){I(f,"name","hf:doc:metadata"),I(f,"content",si),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Vo(Z,"text-align","center"),Vo(q,"text-align","center"),I(B,"start","2"),Lo($.src,$o="https://huggingface.co/datasets/HuggingFaceH4/llava-instruct-mix-vsft/embed/viewer/default/train")||I($,"src",$o),I($,"frameborder","0"),I($,"width","100%"),I($,"height","560px"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,e){y(document.head,f),n(t,J,e),n(t,T,e),n(t,b,e),c(U,t,e),n(t,_,e),n(t,C,e),n(t,va,e),n(t,X,e),n(t,Ua,e),c(H,t,e),n(t,Ia,e),n(t,V,e),n(t,Ca,e),c(Q,t,e),n(t,Fa,e),n(t,z,e),n(t,$a,e),n(t,L,e),n(t,ka,e),c(Y,t,e),n(t,xa,e),n(t,P,e),n(t,Na,e),c(D,t,e),n(t,Aa,e),c(O,t,e),n(t,Za,e),n(t,K,e),n(t,qa,e),n(t,tt,e),n(t,Ba,e),c(et,t,e),n(t,Ga,e),n(t,at,e),n(t,Ea,e),n(t,nt,e),n(t,Sa,e),c(lt,t,e),n(t,Wa,e),c(N,t,e),n(t,Ra,e),n(t,st,e),n(t,Xa,e),c(ot,t,e),n(t,Ha,e),n(t,it,e),n(t,Va,e),n(t,rt,e),n(t,Qa,e),c(pt,t,e),n(t,za,e),n(t,dt,e),n(t,La,e),c(ct,t,e),n(t,Ya,e),n(t,mt,e),n(t,Pa,e),c(ut,t,e),n(t,Da,e),n(t,ht,e),n(t,Oa,e),c(ft,t,e),n(t,Ka,e),n(t,gt,e),n(t,tn,e),c(Mt,t,e),n(t,en,e),n(t,yt,e),n(t,an,e),c(Tt,t,e),n(t,nn,e),n(t,_t,e),n(t,ln,e),c(wt,t,e),n(t,sn,e),n(t,bt,e),n(t,on,e),c(jt,t,e),n(t,rn,e),n(t,Jt,e),n(t,pn,e),c(vt,t,e),n(t,dn,e),n(t,Ut,e),n(t,cn,e),c(It,t,e),n(t,mn,e),c(Ct,t,e),n(t,un,e),n(t,Ft,e),n(t,hn,e),c($t,t,e),n(t,fn,e),n(t,kt,e),n(t,gn,e),c(xt,t,e),n(t,Mn,e),n(t,Nt,e),n(t,yn,e),c(At,t,e),n(t,Tn,e),c(A,t,e),n(t,_n,e),n(t,Zt,e),n(t,wn,e),c(qt,t,e),n(t,bn,e),n(t,Bt,e),n(t,jn,e),c(Gt,t,e),n(t,Jn,e),c(Et,t,e),n(t,vn,e),n(t,St,e),n(t,Un,e),c(Wt,t,e),n(t,In,e),n(t,Rt,e),n(t,Cn,e),c(Xt,t,e),n(t,Fn,e),n(t,Ht,e),n(t,$n,e),c(Vt,t,e),n(t,kn,e),n(t,Qt,e),n(t,xn,e),c(zt,t,e),n(t,Nn,e),n(t,Lt,e),n(t,An,e),n(t,Yt,e),n(t,Zn,e),n(t,Pt,e),n(t,qn,e),c(Dt,t,e),n(t,Bn,e),n(t,Ot,e),n(t,Gn,e),c(Kt,t,e),n(t,En,e),n(t,te,e),n(t,Sn,e),c(ee,t,e),n(t,Wn,e),n(t,ae,e),n(t,Rn,e),n(t,ne,e),n(t,Xn,e),c(le,t,e),n(t,Hn,e),n(t,se,e),n(t,Vn,e),n(t,F,e),c(oe,F,null),y(F,ns),y(F,ha),y(F,ls),y(F,fa),n(t,Qn,e),c(ie,t,e),n(t,zn,e),c(re,t,e),n(t,Ln,e),n(t,pe,e),n(t,Yn,e),n(t,de,e),n(t,Pn,e),n(t,Z,e),n(t,Dn,e),n(t,ce,e),n(t,On,e),c(me,t,e),n(t,Kn,e),n(t,ue,e),n(t,tl,e),n(t,q,e),n(t,el,e),n(t,he,e),n(t,al,e),c(fe,t,e),n(t,nl,e),n(t,ge,e),n(t,ll,e),n(t,Me,e),n(t,sl,e),n(t,ye,e),n(t,ol,e),c(Te,t,e),n(t,il,e),n(t,_e,e),n(t,rl,e),c(we,t,e),n(t,pl,e),n(t,be,e),n(t,dl,e),n(t,je,e),n(t,cl,e),n(t,Je,e),n(t,ml,e),n(t,ve,e),n(t,ul,e),c(Ue,t,e),n(t,hl,e),n(t,B,e),n(t,fl,e),c(Ie,t,e),n(t,gl,e),n(t,Ce,e),n(t,Ml,e),c(Fe,t,e),n(t,yl,e),n(t,$e,e),n(t,Tl,e),n(t,ke,e),n(t,_l,e),c(xe,t,e),n(t,wl,e),n(t,Ne,e),n(t,bl,e),n(t,Ae,e),n(t,jl,e),c(Ze,t,e),n(t,Jl,e),c(qe,t,e),n(t,vl,e),n(t,Be,e),n(t,Ul,e),c(Ge,t,e),n(t,Il,e),n(t,Ee,e),n(t,Cl,e),c(Se,t,e),n(t,Fl,e),n(t,We,e),n(t,$l,e),c(Re,t,e),n(t,kl,e),n(t,Xe,e),n(t,xl,e),c(He,t,e),n(t,Nl,e),n(t,Ve,e),n(t,Al,e),c(Qe,t,e),n(t,Zl,e),n(t,$,e),n(t,ql,e),c(ze,t,e),n(t,Bl,e),n(t,Le,e),n(t,Gl,e),c(Ye,t,e),n(t,El,e),n(t,Pe,e),n(t,Sl,e),c(De,t,e),n(t,Wl,e),c(Oe,t,e),n(t,Rl,e),n(t,Ke,e),n(t,Xl,e),c(ta,t,e),n(t,Hl,e),n(t,ea,e),n(t,Vl,e),n(t,aa,e),n(t,Ql,e),c(na,t,e),n(t,zl,e),n(t,w,e),c(la,w,null),y(w,ss),y(w,ga),y(w,os),y(w,Ma),y(w,is),c(G,w,null),y(w,rs),y(w,E),c(sa,E,null),y(E,ps),y(E,ya),y(w,ds),y(w,S),c(oa,S,null),y(S,cs),y(S,Ta),n(t,Ll,e),c(ia,t,e),n(t,Yl,e),n(t,v,e),c(ra,v,null),y(v,ms),y(v,_a),y(v,us),y(v,wa),y(v,hs),y(v,ba),n(t,Pl,e),c(pa,t,e),n(t,Dl,e),n(t,da,e),n(t,Ol,e),n(t,ca,e),n(t,Kl,e),c(ma,t,e),n(t,ts,e),n(t,ja,e),es=!0},p(t,[e]){const k={};e&2&&(k.$$scope={dirty:e,ctx:t}),N.$set(k);const j={};e&2&&(j.$$scope={dirty:e,ctx:t}),A.$set(j);const ua={};e&2&&(ua.$$scope={dirty:e,ctx:t}),G.$set(ua)},i(t){es||(m(U.$$.fragment,t),m(H.$$.fragment,t),m(Q.$$.fragment,t),m(Y.$$.fragment,t),m(D.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(lt.$$.fragment,t),m(N.$$.fragment,t),m(ot.$$.fragment,t),m(pt.$$.fragment,t),m(ct.$$.fragment,t),m(ut.$$.fragment,t),m(ft.$$.fragment,t),m(Mt.$$.fragment,t),m(Tt.$$.fragment,t),m(wt.$$.fragment,t),m(jt.$$.fragment,t),m(vt.$$.fragment,t),m(It.$$.fragment,t),m(Ct.$$.fragment,t),m($t.$$.fragment,t),m(xt.$$.fragment,t),m(At.$$.fragment,t),m(A.$$.fragment,t),m(qt.$$.fragment,t),m(Gt.$$.fragment,t),m(Et.$$.fragment,t),m(Wt.$$.fragment,t),m(Xt.$$.fragment,t),m(Vt.$$.fragment,t),m(zt.$$.fragment,t),m(Dt.$$.fragment,t),m(Kt.$$.fragment,t),m(ee.$$.fragment,t),m(le.$$.fragment,t),m(oe.$$.fragment,t),m(ie.$$.fragment,t),m(re.$$.fragment,t),m(me.$$.fragment,t),m(fe.$$.fragment,t),m(Te.$$.fragment,t),m(we.$$.fragment,t),m(Ue.$$.fragment,t),m(Ie.$$.fragment,t),m(Fe.$$.fragment,t),m(xe.$$.fragment,t),m(Ze.$$.fragment,t),m(qe.$$.fragment,t),m(Ge.$$.fragment,t),m(Se.$$.fragment,t),m(Re.$$.fragment,t),m(He.$$.fragment,t),m(Qe.$$.fragment,t),m(ze.$$.fragment,t),m(Ye.$$.fragment,t),m(De.$$.fragment,t),m(Oe.$$.fragment,t),m(ta.$$.fragment,t),m(na.$$.fragment,t),m(la.$$.fragment,t),m(G.$$.fragment,t),m(sa.$$.fragment,t),m(oa.$$.fragment,t),m(ia.$$.fragment,t),m(ra.$$.fragment,t),m(pa.$$.fragment,t),m(ma.$$.fragment,t),es=!0)},o(t){u(U.$$.fragment,t),u(H.$$.fragment,t),u(Q.$$.fragment,t),u(Y.$$.fragment,t),u(D.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(lt.$$.fragment,t),u(N.$$.fragment,t),u(ot.$$.fragment,t),u(pt.$$.fragment,t),u(ct.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(Mt.$$.fragment,t),u(Tt.$$.fragment,t),u(wt.$$.fragment,t),u(jt.$$.fragment,t),u(vt.$$.fragment,t),u(It.$$.fragment,t),u(Ct.$$.fragment,t),u($t.$$.fragment,t),u(xt.$$.fragment,t),u(At.$$.fragment,t),u(A.$$.fragment,t),u(qt.$$.fragment,t),u(Gt.$$.fragment,t),u(Et.$$.fragment,t),u(Wt.$$.fragment,t),u(Xt.$$.fragment,t),u(Vt.$$.fragment,t),u(zt.$$.fragment,t),u(Dt.$$.fragment,t),u(Kt.$$.fragment,t),u(ee.$$.fragment,t),u(le.$$.fragment,t),u(oe.$$.fragment,t),u(ie.$$.fragment,t),u(re.$$.fragment,t),u(me.$$.fragment,t),u(fe.$$.fragment,t),u(Te.$$.fragment,t),u(we.$$.fragment,t),u(Ue.$$.fragment,t),u(Ie.$$.fragment,t),u(Fe.$$.fragment,t),u(xe.$$.fragment,t),u(Ze.$$.fragment,t),u(qe.$$.fragment,t),u(Ge.$$.fragment,t),u(Se.$$.fragment,t),u(Re.$$.fragment,t),u(He.$$.fragment,t),u(Qe.$$.fragment,t),u(ze.$$.fragment,t),u(Ye.$$.fragment,t),u(De.$$.fragment,t),u(Oe.$$.fragment,t),u(ta.$$.fragment,t),u(na.$$.fragment,t),u(la.$$.fragment,t),u(G.$$.fragment,t),u(sa.$$.fragment,t),u(oa.$$.fragment,t),u(ia.$$.fragment,t),u(ra.$$.fragment,t),u(pa.$$.fragment,t),u(ma.$$.fragment,t),es=!1},d(t){t&&(a(J),a(T),a(b),a(_),a(C),a(va),a(X),a(Ua),a(Ia),a(V),a(Ca),a(Fa),a(z),a($a),a(L),a(ka),a(xa),a(P),a(Na),a(Aa),a(Za),a(K),a(qa),a(tt),a(Ba),a(Ga),a(at),a(Ea),a(nt),a(Sa),a(Wa),a(Ra),a(st),a(Xa),a(Ha),a(it),a(Va),a(rt),a(Qa),a(za),a(dt),a(La),a(Ya),a(mt),a(Pa),a(Da),a(ht),a(Oa),a(Ka),a(gt),a(tn),a(en),a(yt),a(an),a(nn),a(_t),a(ln),a(sn),a(bt),a(on),a(rn),a(Jt),a(pn),a(dn),a(Ut),a(cn),a(mn),a(un),a(Ft),a(hn),a(fn),a(kt),a(gn),a(Mn),a(Nt),a(yn),a(Tn),a(_n),a(Zt),a(wn),a(bn),a(Bt),a(jn),a(Jn),a(vn),a(St),a(Un),a(In),a(Rt),a(Cn),a(Fn),a(Ht),a($n),a(kn),a(Qt),a(xn),a(Nn),a(Lt),a(An),a(Yt),a(Zn),a(Pt),a(qn),a(Bn),a(Ot),a(Gn),a(En),a(te),a(Sn),a(Wn),a(ae),a(Rn),a(ne),a(Xn),a(Hn),a(se),a(Vn),a(F),a(Qn),a(zn),a(Ln),a(pe),a(Yn),a(de),a(Pn),a(Z),a(Dn),a(ce),a(On),a(Kn),a(ue),a(tl),a(q),a(el),a(he),a(al),a(nl),a(ge),a(ll),a(Me),a(sl),a(ye),a(ol),a(il),a(_e),a(rl),a(pl),a(be),a(dl),a(je),a(cl),a(Je),a(ml),a(ve),a(ul),a(hl),a(B),a(fl),a(gl),a(Ce),a(Ml),a(yl),a($e),a(Tl),a(ke),a(_l),a(wl),a(Ne),a(bl),a(Ae),a(jl),a(Jl),a(vl),a(Be),a(Ul),a(Il),a(Ee),a(Cl),a(Fl),a(We),a($l),a(kl),a(Xe),a(xl),a(Nl),a(Ve),a(Al),a(Zl),a($),a(ql),a(Bl),a(Le),a(Gl),a(El),a(Pe),a(Sl),a(Wl),a(Rl),a(Ke),a(Xl),a(Hl),a(ea),a(Vl),a(aa),a(Ql),a(zl),a(w),a(Ll),a(Yl),a(v),a(Pl),a(Dl),a(da),a(Ol),a(ca),a(Kl),a(ts),a(ja)),a(f),h(U,t),h(H,t),h(Q,t),h(Y,t),h(D,t),h(O,t),h(et,t),h(lt,t),h(N,t),h(ot,t),h(pt,t),h(ct,t),h(ut,t),h(ft,t),h(Mt,t),h(Tt,t),h(wt,t),h(jt,t),h(vt,t),h(It,t),h(Ct,t),h($t,t),h(xt,t),h(At,t),h(A,t),h(qt,t),h(Gt,t),h(Et,t),h(Wt,t),h(Xt,t),h(Vt,t),h(zt,t),h(Dt,t),h(Kt,t),h(ee,t),h(le,t),h(oe),h(ie,t),h(re,t),h(me,t),h(fe,t),h(Te,t),h(we,t),h(Ue,t),h(Ie,t),h(Fe,t),h(xe,t),h(Ze,t),h(qe,t),h(Ge,t),h(Se,t),h(Re,t),h(He,t),h(Qe,t),h(ze,t),h(Ye,t),h(De,t),h(Oe,t),h(ta,t),h(na,t),h(la),h(G),h(sa),h(oa),h(ia,t),h(ra),h(pa,t),h(ma,t)}}}const si='{"title":"Supervised Fine-tuning Trainer","local":"supervised-fine-tuning-trainer","sections":[{"title":"Quickstart","local":"quickstart","sections":[],"depth":2},{"title":"Advanced usage","local":"advanced-usage","sections":[{"title":"Train on completions only","local":"train-on-completions-only","sections":[],"depth":3},{"title":"Add Special Tokens for Chat Format","local":"add-special-tokens-for-chat-format","sections":[],"depth":3},{"title":"Dataset format support","local":"dataset-format-support","sections":[],"depth":3},{"title":"Format your input prompts","local":"format-your-input-prompts","sections":[],"depth":3},{"title":"Packing dataset","local":"packing-dataset","sections":[{"title":"Customize your prompts using packed dataset","local":"customize-your-prompts-using-packed-dataset","sections":[],"depth":4}],"depth":3},{"title":"Control over the pretrained model","local":"control-over-the-pretrained-model","sections":[],"depth":3},{"title":"Training adapters","local":"training-adapters","sections":[],"depth":3},{"title":"Training adapters with base 8 bit models","local":"training-adapters-with-base-8-bit-models","sections":[],"depth":3}],"depth":2},{"title":"Using Flash Attention and Flash Attention 2","local":"using-flash-attention-and-flash-attention-2","sections":[{"title":"Using Flash-Attention 1","local":"using-flash-attention-1","sections":[],"depth":3},{"title":"Using Flash Attention-2","local":"using-flash-attention-2","sections":[],"depth":3},{"title":"Using model creation utility","local":"trl.ModelConfig","sections":[],"depth":3},{"title":"Enhance the model’s performances using NEFTune","local":"enhance-the-models-performances-using-neftune","sections":[],"depth":3},{"title":"Accelerate fine-tuning 2x using unsloth","local":"accelerate-fine-tuning-2x-using-unsloth","sections":[],"depth":3}],"depth":2},{"title":"Liger-Kernel: Increase 20% throughput and reduces 60% memory for multi-GPU training","local":"liger-kernel-increase-20-throughput-and-reduces-60-memory-for-multi-gpu-training","sections":[],"depth":2},{"title":"Best practices","local":"best-practices","sections":[],"depth":2},{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[],"depth":2},{"title":"GPTQ Conversion","local":"gptq-conversion","sections":[],"depth":2},{"title":"Extending SFTTrainer for Vision Language Models","local":"extending-sfttrainer-for-vision-language-models","sections":[{"title":"Preparing the Data","local":"preparing-the-data","sections":[],"depth":3},{"title":"A custom collator for processing multi-modal data","local":"a-custom-collator-for-processing-multi-modal-data","sections":[],"depth":3},{"title":"Training the vision-language model","local":"training-the-vision-language-model","sections":[],"depth":3}],"depth":2},{"title":"SFTTrainer","local":"trl.SFTTrainer","sections":[],"depth":2},{"title":"SFTConfig","local":"trl.SFTConfig","sections":[],"depth":2},{"title":"Datasets","local":"datasets","sections":[],"depth":2}],"depth":1}';function oi(x){return Yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hi extends Po{constructor(f){super(),Do(this,f,oi,li,zo,{})}}export{hi as component};
