import{s as wo,o as yo,n as B}from"../chunks/scheduler.182ea377.js";import{S as xo,i as Io,g as i,s as o,r as g,A as Mo,h as l,f as r,c as a,j as $,u as h,x as f,k as T,y as t,a as y,v as _,d as b,t as v,w}from"../chunks/index.abf12888.js";import{T as At}from"../chunks/Tip.230e2334.js";import{D as J}from"../chunks/Docstring.93f6f462.js";import{C as ot}from"../chunks/CodeBlock.57fe6e13.js";import{E as st}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as Yt}from"../chunks/Heading.16916d63.js";function $o(j){let s,I='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!';return{c(){s=i("p"),s.innerHTML=I},l(d){s=l(d,"P",{"data-svelte-h":!0}),f(s)!=="svelte-1j961ct"&&(s.innerHTML=I)},m(d,p){y(d,s,p)},p:B,d(d){d&&r(s)}}}function To(j){let s,I="Examples:",d,p,x;return p=new ot({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkX29yX3BhdGglMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkX29yX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMHBpcGUudG8oZGV2aWNlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uJTJGbWFpbiUyRmFzc2V0cyUyRnN0YWJsZS1zYW1wbGVzJTJGaW1nMmltZyUyRnNrZXRjaC1tb3VudGFpbnMtaW5wdXQuanBnJTIyJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNzY4JTJDJTIwNTEyKSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmFudGFzeSUyMGxhbmRzY2FwZSUyQyUyMHRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTIyJTBBJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMjBzdHJlbmd0aCUzRDAuNzUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDcuNSkuaW1hZ2VzJTBBaW1hZ2VzJTVCMCU1RC5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id_or_path = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionImg2ImgPipeline.from_pretrained(model_id_or_path, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipe(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-kvfsh7"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function jo(j){let s,I=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){s=i("p"),s.innerHTML=I},l(d){s=l(d,"P",{"data-svelte-h":!0}),f(s)!=="svelte-ackzsn"&&(s.innerHTML=I)},m(d,p){y(d,s,p)},p:B,d(d){d&&r(s)}}}function Jo(j){let s,I="Examples:",d,p,x;return p=new ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-kvfsh7"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function So(j){let s,I=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=i("p"),s.textContent=I},l(d){s=l(d,"P",{"data-svelte-h":!0}),f(s)!=="svelte-17p1lpg"&&(s.textContent=I)},m(d,p){y(d,s,p)},p:B,d(d){d&&r(s)}}}function ko(j){let s,I="Examples:",d,p,x;return p=new ot({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-kvfsh7"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function Do(j){let s,I="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",d,p,x;return p=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-1gc783q"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function Po(j){let s,I="locally:",d,p,x;return p=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-4c75kq"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function Uo(j){let s,I="Examples:",d,p,x;return p=new ot({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seSUyMiklMEElMEElMjMlMjBFbmFibGUlMjBmbG9hdDE2JTIwYW5kJTIwbW92ZSUyMHRvJTIwR1BVJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-kvfsh7"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function Co(j){let s,I="This API is 🧪 experimental.";return{c(){s=i("p"),s.textContent=I},l(d){s=l(d,"P",{"data-svelte-h":!0}),f(s)!=="svelte-89q1io"&&(s.textContent=I)},m(d,p){y(d,s,p)},p:B,d(d){d&&r(s)}}}function Zo(j){let s,I="This API is 🧪 experimental.";return{c(){s=i("p"),s.textContent=I},l(d){s=l(d,"P",{"data-svelte-h":!0}),f(s)!=="svelte-89q1io"&&(s.textContent=I)},m(d,p){y(d,s,p)},p:B,d(d){d&&r(s)}}}function Wo(j){let s,I="Examples:",d,p,x;return p=new ot({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax.numpy <span class="hljs-keyword">as</span> jnp
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionImg2ImgPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_key</span>(<span class="hljs-params">seed=<span class="hljs-number">0</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> jax.random.PRNGKey(seed)


<span class="hljs-meta">&gt;&gt;&gt; </span>rng = create_key(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>response = requests.get(url)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>init_img = init_img.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>prompts = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionImg2ImgPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>,
<span class="hljs-meta">... </span>    revision=<span class="hljs-string">&quot;flax&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>rng = jax.random.split(rng, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids, processed_image = pipeline.prepare_inputs(
<span class="hljs-meta">... </span>    prompt=[prompts] * num_samples, image=[init_img] * num_samples
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>p_params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_image = shard(processed_image)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipeline(
<span class="hljs-meta">... </span>    prompt_ids=prompt_ids,
<span class="hljs-meta">... </span>    image=processed_image,
<span class="hljs-meta">... </span>    params=p_params,
<span class="hljs-meta">... </span>    prng_seed=rng,
<span class="hljs-meta">... </span>    strength=<span class="hljs-number">0.75</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    jit=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>output_images = pipeline.numpy_to_pil(np.asarray(output.reshape((num_samples,) + output.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){s=i("p"),s.textContent=I,d=o(),g(p.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),f(s)!=="svelte-kvfsh7"&&(s.textContent=I),d=a(n),h(p.$$.fragment,n)},m(n,M){y(n,s,M),y(n,d,M),_(p,n,M),x=!0},p:B,i(n){x||(b(p.$$.fragment,n),x=!0)},o(n){v(p.$$.fragment,n),x=!1},d(n){n&&(r(s),r(d)),w(p,n)}}}function Bo(j){let s,I,d,p,x,n,M,Ps="The Stable Diffusion model can also be applied to image-to-image generation by passing a text prompt and an initial image to condition the generation of new images.",Ht,we,Us='The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> uses the diffusion-denoising mechanism proposed in <a href="https://huggingface.co/papers/2108.01073" rel="nofollow">SDEdit: Guided Image Synthesis and Editing with Stochastic Differential Equations</a> by Chenlin Meng, Yutong He, Yang Song, Jiaming Song, Jiajun Wu, Jun-Yan Zhu, Stefano Ermon.',qt,ye,Cs="The abstract from the paper is:",Qt,xe,Zs="<em>Guided image synthesis enables everyday users to create and edit photo-realistic images with minimum effort. The key challenge is balancing faithfulness to the user input (e.g., hand-drawn colored strokes) and realism of the synthesized image. Existing GAN-based methods attempt to achieve such balance using either conditional GANs or GAN inversions, which are challenging and often require additional training data or loss functions for individual applications. To address these issues, we introduce a new image synthesis and editing method, Stochastic Differential Editing (SDEdit), based on a diffusion model generative prior, which synthesizes realistic images by iteratively denoising through a stochastic differential equation (SDE). Given an input image with user guide of any type, SDEdit first adds noise to the input, then subsequently denoises the resulting image through the SDE prior to increase its realism. SDEdit does not require task-specific training or inversions and can naturally achieve the balance between realism and faithfulness. SDEdit significantly outperforms state-of-the-art GAN-based methods by up to 98.09% on realism and 91.72% on overall satisfaction scores, according to a human perception study, on multiple tasks, including stroke-based image synthesis and editing as well as image compositing.</em>",Ot,H,Kt,Ie,en,m,Me,_n,at,Ws="Pipeline for text-guided image-to-image generation using Stable Diffusion.",bn,it,Bs=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,vn,lt,Gs="The pipeline also inherits the following loading methods:",wn,rt,Fs='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',yn,N,$e,xn,dt,Ls="The call function to the pipeline for generation.",In,q,Mn,C,Te,$n,pt,Ns=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Tn,Q,jn,O,Jn,K,je,Sn,ct,Es=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,kn,Z,Je,Dn,mt,Vs=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Pn,ee,Un,te,Cn,ne,Se,Zn,ft,Xs='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',Wn,S,ke,Bn,ut,zs=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Gn,gt,Rs="Example:",Fn,se,Ln,ht,As=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Nn,oe,En,E,De,Vn,_t,Ys=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Xn,ae,zn,k,Pe,Rn,bt,Hs=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,An,vt,qs="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Yn,wt,Qs='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Hn,yt,Os=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,qn,xt,Ks=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Qn,ie,Ue,On,It,eo="Save the LoRA parameters corresponding to the UNet and text encoder.",Kn,le,Ce,es,Mt,to="Disables the FreeU mechanism if enabled.",ts,re,Ze,ns,$t,no=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,ss,de,We,os,Tt,so=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,as,W,Be,is,jt,oo='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',ls,Jt,ao="The suffixes after the scaling factors represent the stages where they are being applied.",rs,St,io=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,ds,pe,Ge,ps,kt,lo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,cs,ce,Fe,ms,Dt,ro=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,fs,me,Le,us,Pt,po="Encodes the prompt into text encoder hidden states.",gs,V,Ne,hs,Ut,co=`Enables fused QKV projections. For self-attention modules, all projection matrices (i.e., query,
key, value) are fused. For cross-attention modules, key and value projection matrices are fused.`,_s,fe,bs,ue,Ee,vs,Ct,mo='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',ws,X,Ve,ys,Zt,fo="Disable QKV projection fusion if enabled.",xs,ge,tn,Xe,nn,R,ze,Is,Wt,uo="Output class for Stable Diffusion pipelines.",sn,Re,on,U,Ae,Ms,Bt,go="Flax-based pipeline for text-guided image-to-image generation using Stable Diffusion.",$s,Gt,ho=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ts,z,Ye,js,Ft,_o="The call function to the pipeline for generation.",Js,he,an,He,ln,G,qe,Ss,Lt,bo="Output class for Flax-based Stable Diffusion pipelines.",ks,_e,Qe,Ds,Nt,vo="“Returns a new object replacing the specified fields with new values.",rn,Rt,dn;return x=new Yt({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h1"}}),H=new At({props:{$$slots:{default:[$o]},$$scope:{ctx:j}}}),Ie=new Yt({props:{title:"StableDiffusionImg2ImgPipeline",local:"diffusers.StableDiffusionImg2ImgPipeline",headingTag:"h2"}}),Me=new J({props:{name:"class diffusers.StableDiffusionImg2ImgPipeline",anchor:"diffusers.StableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L158"}}),$e=new J({props:{name:"__call__",anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": Optional = 50"},{name:"timesteps",val:": List = None"},{name:"guidance_scale",val:": Optional = 7.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": Optional = 0.0"},{name:"generator",val:": Union = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"ip_adapter_image_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"clip_skip",val:": int = None"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be used as the starting point. For both
numpy array and pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list
or tensors, the expected shape should be <code>(B, C, H, W)</code> or <code>(C, H, W)</code>. If it is a numpy array or a
list of arrays, the expected shape should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code> It can also accept image
latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L916",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),q=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[To]},$$scope:{ctx:j}}}),Te=new J({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2042"}}),Q=new At({props:{warning:!0,$$slots:{default:[jo]},$$scope:{ctx:j}}}),O=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_attention_slicing.example",$$slots:{default:[Jo]},$$scope:{ctx:j}}}),je=new J({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2082"}}),Je=new J({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1981"}}),ee=new At({props:{warning:!0,$$slots:{default:[So]},$$scope:{ctx:j}}}),te=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[ko]},$$scope:{ctx:j}}}),Se=new J({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2016"}}),ke=new J({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),se=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example",$$slots:{default:[Do]},$$scope:{ctx:j}}}),oe=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_textual_inversion.example-2",$$slots:{default:[Po]},$$scope:{ctx:j}}}),De=new J({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L148"}}),ae=new st({props:{anchor:"diffusers.StableDiffusionImg2ImgPipeline.from_single_file.example",$$slots:{default:[Uo]},$$scope:{ctx:j}}}),Pe=new J({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L80"}}),Ue=new J({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L703"}}),Ce=new J({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L795"}}),Ze=new J({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L300"}}),We=new J({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionImg2ImgPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L317"}}),Be=new J({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L772"}}),Ge=new J({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L292"}}),Fe=new J({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionImg2ImgPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L308"}}),Le=new J({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"},{name:"clip_skip",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L358"}}),Ne=new J({props:{name:"fuse_qkv_projections",anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.fuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L800"}}),fe=new At({props:{warning:!0,$$slots:{default:[Co]},$$scope:{ctx:j}}}),Ee=new J({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:""},{name:"embedding_dim",val:" = 512"},{name:"dtype",val:" = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.timesteps",description:`<strong>timesteps</strong> (<code>torch.Tensor</code>) &#x2014;
generate embedding vectors at these timesteps`,name:"timesteps"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
dimension of the embeddings to generate
dtype &#x2014;
data type of the generated embeddings`,name:"embedding_dim"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L861",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(timesteps), embedding_dim)</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),Ve=new J({props:{name:"unfuse_qkv_projections",anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections",parameters:[{name:"unet",val:": bool = True"},{name:"vae",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections.unet",description:"<strong>unet</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the UNet.",name:"unet"},{anchor:"diffusers.StableDiffusionImg2ImgPipeline.unfuse_qkv_projections.vae",description:"<strong>vae</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014; To apply fusion on the VAE.",name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_img2img.py#L832"}}),ge=new At({props:{warning:!0,$$slots:{default:[Zo]},$$scope:{ctx:j}}}),Xe=new Yt({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ze=new J({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),Re=new Yt({props:{title:"FlaxStableDiffusionImg2ImgPipeline",local:"diffusers.FlaxStableDiffusionImg2ImgPipeline",headingTag:"h2"}}),Ae=new J({props:{name:"class diffusers.FlaxStableDiffusionImg2ImgPipeline",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": Union"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.FlaxCLIPTextModel" rel="nofollow">FlaxCLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L105"}}),Ye=new J({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"prompt_ids",val:": Array"},{name:"image",val:": Array"},{name:"params",val:": Union"},{name:"prng_seed",val:": Array"},{name:"strength",val:": float = 0.8"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"guidance_scale",val:": Union = 7.5"},{name:"noise",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prompt_ids",description:`<strong>prompt_ids</strong> (<code>jnp.ndarray</code>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt_ids"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>jnp.ndarray</code>) &#x2014;
Array representing an image batch to be used as the starting point.`,name:"image"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.params",description:`<strong>params</strong> (<code>Dict</code> or <code>FrozenDict</code>) &#x2014;
Dictionary containing the model parameters/weights.`,name:"params"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.prng_seed",description:`<strong>prng_seed</strong> (<code>jax.Array</code> or <code>jax.Array</code>) &#x2014;
Array containing random number generator key.`,name:"prng_seed"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Indicates extent to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code> is used as a
starting point and more noise is added the higher the <code>strength</code>. The number of denoising steps depends
on the amount of noise initially added. When <code>strength</code> is 1, added noise is maximum and the denoising
process runs for the full number of iterations specified in <code>num_inference_steps</code>. A value of 1
essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference. This parameter is modulated by <code>strength</code>.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.noise",description:`<strong>noise</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. The array is generated by
sampling using the supplied random <code>generator</code>.`,name:"noise"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"},{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion_img2img.py#L337",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),he=new st({props:{anchor:"diffusers.FlaxStableDiffusionImg2ImgPipeline.__call__.example",$$slots:{default:[Wo]},$$scope:{ctx:j}}}),He=new Yt({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),qe=new J({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": List"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Qe=new J({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L111"}}),{c(){s=i("meta"),I=o(),d=i("p"),p=o(),g(x.$$.fragment),n=o(),M=i("p"),M.textContent=Ps,Ht=o(),we=i("p"),we.innerHTML=Us,qt=o(),ye=i("p"),ye.textContent=Cs,Qt=o(),xe=i("p"),xe.innerHTML=Zs,Ot=o(),g(H.$$.fragment),Kt=o(),g(Ie.$$.fragment),en=o(),m=i("div"),g(Me.$$.fragment),_n=o(),at=i("p"),at.textContent=Ws,bn=o(),it=i("p"),it.innerHTML=Bs,vn=o(),lt=i("p"),lt.textContent=Gs,wn=o(),rt=i("ul"),rt.innerHTML=Fs,yn=o(),N=i("div"),g($e.$$.fragment),xn=o(),dt=i("p"),dt.textContent=Ls,In=o(),g(q.$$.fragment),Mn=o(),C=i("div"),g(Te.$$.fragment),$n=o(),pt=i("p"),pt.textContent=Ns,Tn=o(),g(Q.$$.fragment),jn=o(),g(O.$$.fragment),Jn=o(),K=i("div"),g(je.$$.fragment),Sn=o(),ct=i("p"),ct.innerHTML=Es,kn=o(),Z=i("div"),g(Je.$$.fragment),Dn=o(),mt=i("p"),mt.innerHTML=Vs,Pn=o(),g(ee.$$.fragment),Un=o(),g(te.$$.fragment),Cn=o(),ne=i("div"),g(Se.$$.fragment),Zn=o(),ft=i("p"),ft.innerHTML=Xs,Wn=o(),S=i("div"),g(ke.$$.fragment),Bn=o(),ut=i("p"),ut.innerHTML=zs,Gn=o(),gt=i("p"),gt.textContent=Rs,Fn=o(),g(se.$$.fragment),Ln=o(),ht=i("p"),ht.innerHTML=As,Nn=o(),g(oe.$$.fragment),En=o(),E=i("div"),g(De.$$.fragment),Vn=o(),_t=i("p"),_t.innerHTML=Ys,Xn=o(),g(ae.$$.fragment),zn=o(),k=i("div"),g(Pe.$$.fragment),Rn=o(),bt=i("p"),bt.innerHTML=Hs,An=o(),vt=i("p"),vt.innerHTML=qs,Yn=o(),wt=i("p"),wt.innerHTML=Qs,Hn=o(),yt=i("p"),yt.innerHTML=Os,qn=o(),xt=i("p"),xt.innerHTML=Ks,Qn=o(),ie=i("div"),g(Ue.$$.fragment),On=o(),It=i("p"),It.textContent=eo,Kn=o(),le=i("div"),g(Ce.$$.fragment),es=o(),Mt=i("p"),Mt.textContent=to,ts=o(),re=i("div"),g(Ze.$$.fragment),ns=o(),$t=i("p"),$t.innerHTML=no,ss=o(),de=i("div"),g(We.$$.fragment),os=o(),Tt=i("p"),Tt.innerHTML=so,as=o(),W=i("div"),g(Be.$$.fragment),is=o(),jt=i("p"),jt.innerHTML=oo,ls=o(),Jt=i("p"),Jt.textContent=ao,rs=o(),St=i("p"),St.innerHTML=io,ds=o(),pe=i("div"),g(Ge.$$.fragment),ps=o(),kt=i("p"),kt.textContent=lo,cs=o(),ce=i("div"),g(Fe.$$.fragment),ms=o(),Dt=i("p"),Dt.textContent=ro,fs=o(),me=i("div"),g(Le.$$.fragment),us=o(),Pt=i("p"),Pt.textContent=po,gs=o(),V=i("div"),g(Ne.$$.fragment),hs=o(),Ut=i("p"),Ut.textContent=co,_s=o(),g(fe.$$.fragment),bs=o(),ue=i("div"),g(Ee.$$.fragment),vs=o(),Ct=i("p"),Ct.innerHTML=mo,ws=o(),X=i("div"),g(Ve.$$.fragment),ys=o(),Zt=i("p"),Zt.textContent=fo,xs=o(),g(ge.$$.fragment),tn=o(),g(Xe.$$.fragment),nn=o(),R=i("div"),g(ze.$$.fragment),Is=o(),Wt=i("p"),Wt.textContent=uo,sn=o(),g(Re.$$.fragment),on=o(),U=i("div"),g(Ae.$$.fragment),Ms=o(),Bt=i("p"),Bt.textContent=go,$s=o(),Gt=i("p"),Gt.innerHTML=ho,Ts=o(),z=i("div"),g(Ye.$$.fragment),js=o(),Ft=i("p"),Ft.textContent=_o,Js=o(),g(he.$$.fragment),an=o(),g(He.$$.fragment),ln=o(),G=i("div"),g(qe.$$.fragment),Ss=o(),Lt=i("p"),Lt.textContent=bo,ks=o(),_e=i("div"),g(Qe.$$.fragment),Ds=o(),Nt=i("p"),Nt.textContent=vo,rn=o(),Rt=i("p"),this.h()},l(e){const c=Mo("svelte-u9bgzb",document.head);s=l(c,"META",{name:!0,content:!0}),c.forEach(r),I=a(e),d=l(e,"P",{}),$(d).forEach(r),p=a(e),h(x.$$.fragment,e),n=a(e),M=l(e,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1wz97a4"&&(M.textContent=Ps),Ht=a(e),we=l(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-1ju27vr"&&(we.innerHTML=Us),qt=a(e),ye=l(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1cwsb16"&&(ye.textContent=Cs),Qt=a(e),xe=l(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1nbpwa2"&&(xe.innerHTML=Zs),Ot=a(e),h(H.$$.fragment,e),Kt=a(e),h(Ie.$$.fragment,e),en=a(e),m=l(e,"DIV",{class:!0});var u=$(m);h(Me.$$.fragment,u),_n=a(u),at=l(u,"P",{"data-svelte-h":!0}),f(at)!=="svelte-1n95u1g"&&(at.textContent=Ws),bn=a(u),it=l(u,"P",{"data-svelte-h":!0}),f(it)!=="svelte-496sm0"&&(it.innerHTML=Bs),vn=a(u),lt=l(u,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-14s6m4u"&&(lt.textContent=Gs),wn=a(u),rt=l(u,"UL",{"data-svelte-h":!0}),f(rt)!=="svelte-1ak2zof"&&(rt.innerHTML=Fs),yn=a(u),N=l(u,"DIV",{class:!0});var A=$(N);h($e.$$.fragment,A),xn=a(A),dt=l(A,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-50j04k"&&(dt.textContent=Ls),In=a(A),h(q.$$.fragment,A),A.forEach(r),Mn=a(u),C=l(u,"DIV",{class:!0});var F=$(C);h(Te.$$.fragment,F),$n=a(F),pt=l(F,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-10jaql7"&&(pt.textContent=Ns),Tn=a(F),h(Q.$$.fragment,F),jn=a(F),h(O.$$.fragment,F),F.forEach(r),Jn=a(u),K=l(u,"DIV",{class:!0});var Oe=$(K);h(je.$$.fragment,Oe),Sn=a(Oe),ct=l(Oe,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-1lh0nh5"&&(ct.innerHTML=Es),Oe.forEach(r),kn=a(u),Z=l(u,"DIV",{class:!0});var L=$(Z);h(Je.$$.fragment,L),Dn=a(L),mt=l(L,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-e03q3e"&&(mt.innerHTML=Vs),Pn=a(L),h(ee.$$.fragment,L),Un=a(L),h(te.$$.fragment,L),L.forEach(r),Cn=a(u),ne=l(u,"DIV",{class:!0});var Ke=$(ne);h(Se.$$.fragment,Ke),Zn=a(Ke),ft=l(Ke,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-1vfte1e"&&(ft.innerHTML=Xs),Ke.forEach(r),Wn=a(u),S=l(u,"DIV",{class:!0});var D=$(S);h(ke.$$.fragment,D),Bn=a(D),ut=l(D,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-1lv88wo"&&(ut.innerHTML=zs),Gn=a(D),gt=l(D,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-11lpom8"&&(gt.textContent=Rs),Fn=a(D),h(se.$$.fragment,D),Ln=a(D),ht=l(D,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-15d7mv5"&&(ht.innerHTML=As),Nn=a(D),h(oe.$$.fragment,D),D.forEach(r),En=a(u),E=l(u,"DIV",{class:!0});var Y=$(E);h(De.$$.fragment,Y),Vn=a(Y),_t=l(Y,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-pmqrln"&&(_t.innerHTML=Ys),Xn=a(Y),h(ae.$$.fragment,Y),Y.forEach(r),zn=a(u),k=l(u,"DIV",{class:!0});var P=$(k);h(Pe.$$.fragment,P),Rn=a(P),bt=l(P,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-vs7s0z"&&(bt.innerHTML=Hs),An=a(P),vt=l(P,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-15b960v"&&(vt.innerHTML=qs),Yn=a(P),wt=l(P,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-12uyc98"&&(wt.innerHTML=Qs),Hn=a(P),yt=l(P,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-1q3yzk7"&&(yt.innerHTML=Os),qn=a(P),xt=l(P,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-10xxjud"&&(xt.innerHTML=Ks),P.forEach(r),Qn=a(u),ie=l(u,"DIV",{class:!0});var et=$(ie);h(Ue.$$.fragment,et),On=a(et),It=l(et,"P",{"data-svelte-h":!0}),f(It)!=="svelte-1ufq5ot"&&(It.textContent=eo),et.forEach(r),Kn=a(u),le=l(u,"DIV",{class:!0});var tt=$(le);h(Ce.$$.fragment,tt),es=a(tt),Mt=l(tt,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-psupw6"&&(Mt.textContent=to),tt.forEach(r),ts=a(u),re=l(u,"DIV",{class:!0});var nt=$(re);h(Ze.$$.fragment,nt),ns=a(nt),$t=l(nt,"P",{"data-svelte-h":!0}),f($t)!=="svelte-1s3c06i"&&($t.innerHTML=no),nt.forEach(r),ss=a(u),de=l(u,"DIV",{class:!0});var pn=$(de);h(We.$$.fragment,pn),os=a(pn),Tt=l(pn,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-pkn4ui"&&(Tt.innerHTML=so),pn.forEach(r),as=a(u),W=l(u,"DIV",{class:!0});var be=$(W);h(Be.$$.fragment,be),is=a(be),jt=l(be,"P",{"data-svelte-h":!0}),f(jt)!=="svelte-1f3tmq1"&&(jt.innerHTML=oo),ls=a(be),Jt=l(be,"P",{"data-svelte-h":!0}),f(Jt)!=="svelte-xjijlp"&&(Jt.textContent=ao),rs=a(be),St=l(be,"P",{"data-svelte-h":!0}),f(St)!=="svelte-hy0nzs"&&(St.innerHTML=io),be.forEach(r),ds=a(u),pe=l(u,"DIV",{class:!0});var cn=$(pe);h(Ge.$$.fragment,cn),ps=a(cn),kt=l(cn,"P",{"data-svelte-h":!0}),f(kt)!=="svelte-14bnrb6"&&(kt.textContent=lo),cn.forEach(r),cs=a(u),ce=l(u,"DIV",{class:!0});var mn=$(ce);h(Fe.$$.fragment,mn),ms=a(mn),Dt=l(mn,"P",{"data-svelte-h":!0}),f(Dt)!=="svelte-1xwrf7t"&&(Dt.textContent=ro),mn.forEach(r),fs=a(u),me=l(u,"DIV",{class:!0});var fn=$(me);h(Le.$$.fragment,fn),us=a(fn),Pt=l(fn,"P",{"data-svelte-h":!0}),f(Pt)!=="svelte-16q0ax1"&&(Pt.textContent=po),fn.forEach(r),gs=a(u),V=l(u,"DIV",{class:!0});var Et=$(V);h(Ne.$$.fragment,Et),hs=a(Et),Ut=l(Et,"P",{"data-svelte-h":!0}),f(Ut)!=="svelte-le0q9u"&&(Ut.textContent=co),_s=a(Et),h(fe.$$.fragment,Et),Et.forEach(r),bs=a(u),ue=l(u,"DIV",{class:!0});var un=$(ue);h(Ee.$$.fragment,un),vs=a(un),Ct=l(un,"P",{"data-svelte-h":!0}),f(Ct)!=="svelte-vo59ec"&&(Ct.innerHTML=mo),un.forEach(r),ws=a(u),X=l(u,"DIV",{class:!0});var Vt=$(X);h(Ve.$$.fragment,Vt),ys=a(Vt),Zt=l(Vt,"P",{"data-svelte-h":!0}),f(Zt)!=="svelte-fohozp"&&(Zt.textContent=fo),xs=a(Vt),h(ge.$$.fragment,Vt),Vt.forEach(r),u.forEach(r),tn=a(e),h(Xe.$$.fragment,e),nn=a(e),R=l(e,"DIV",{class:!0});var gn=$(R);h(ze.$$.fragment,gn),Is=a(gn),Wt=l(gn,"P",{"data-svelte-h":!0}),f(Wt)!=="svelte-1qpjiuf"&&(Wt.textContent=uo),gn.forEach(r),sn=a(e),h(Re.$$.fragment,e),on=a(e),U=l(e,"DIV",{class:!0});var ve=$(U);h(Ae.$$.fragment,ve),Ms=a(ve),Bt=l(ve,"P",{"data-svelte-h":!0}),f(Bt)!=="svelte-at7ys7"&&(Bt.textContent=go),$s=a(ve),Gt=l(ve,"P",{"data-svelte-h":!0}),f(Gt)!=="svelte-knddhk"&&(Gt.innerHTML=ho),Ts=a(ve),z=l(ve,"DIV",{class:!0});var Xt=$(z);h(Ye.$$.fragment,Xt),js=a(Xt),Ft=l(Xt,"P",{"data-svelte-h":!0}),f(Ft)!=="svelte-50j04k"&&(Ft.textContent=_o),Js=a(Xt),h(he.$$.fragment,Xt),Xt.forEach(r),ve.forEach(r),an=a(e),h(He.$$.fragment,e),ln=a(e),G=l(e,"DIV",{class:!0});var zt=$(G);h(qe.$$.fragment,zt),Ss=a(zt),Lt=l(zt,"P",{"data-svelte-h":!0}),f(Lt)!=="svelte-wzv2jc"&&(Lt.textContent=bo),ks=a(zt),_e=l(zt,"DIV",{class:!0});var hn=$(_e);h(Qe.$$.fragment,hn),Ds=a(hn),Nt=l(hn,"P",{"data-svelte-h":!0}),f(Nt)!=="svelte-5ihtpa"&&(Nt.textContent=vo),hn.forEach(r),zt.forEach(r),rn=a(e),Rt=l(e,"P",{}),$(Rt).forEach(r),this.h()},h(){T(s,"name","hf:doc:metadata"),T(s,"content",Go),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,s),y(e,I,c),y(e,d,c),y(e,p,c),_(x,e,c),y(e,n,c),y(e,M,c),y(e,Ht,c),y(e,we,c),y(e,qt,c),y(e,ye,c),y(e,Qt,c),y(e,xe,c),y(e,Ot,c),_(H,e,c),y(e,Kt,c),_(Ie,e,c),y(e,en,c),y(e,m,c),_(Me,m,null),t(m,_n),t(m,at),t(m,bn),t(m,it),t(m,vn),t(m,lt),t(m,wn),t(m,rt),t(m,yn),t(m,N),_($e,N,null),t(N,xn),t(N,dt),t(N,In),_(q,N,null),t(m,Mn),t(m,C),_(Te,C,null),t(C,$n),t(C,pt),t(C,Tn),_(Q,C,null),t(C,jn),_(O,C,null),t(m,Jn),t(m,K),_(je,K,null),t(K,Sn),t(K,ct),t(m,kn),t(m,Z),_(Je,Z,null),t(Z,Dn),t(Z,mt),t(Z,Pn),_(ee,Z,null),t(Z,Un),_(te,Z,null),t(m,Cn),t(m,ne),_(Se,ne,null),t(ne,Zn),t(ne,ft),t(m,Wn),t(m,S),_(ke,S,null),t(S,Bn),t(S,ut),t(S,Gn),t(S,gt),t(S,Fn),_(se,S,null),t(S,Ln),t(S,ht),t(S,Nn),_(oe,S,null),t(m,En),t(m,E),_(De,E,null),t(E,Vn),t(E,_t),t(E,Xn),_(ae,E,null),t(m,zn),t(m,k),_(Pe,k,null),t(k,Rn),t(k,bt),t(k,An),t(k,vt),t(k,Yn),t(k,wt),t(k,Hn),t(k,yt),t(k,qn),t(k,xt),t(m,Qn),t(m,ie),_(Ue,ie,null),t(ie,On),t(ie,It),t(m,Kn),t(m,le),_(Ce,le,null),t(le,es),t(le,Mt),t(m,ts),t(m,re),_(Ze,re,null),t(re,ns),t(re,$t),t(m,ss),t(m,de),_(We,de,null),t(de,os),t(de,Tt),t(m,as),t(m,W),_(Be,W,null),t(W,is),t(W,jt),t(W,ls),t(W,Jt),t(W,rs),t(W,St),t(m,ds),t(m,pe),_(Ge,pe,null),t(pe,ps),t(pe,kt),t(m,cs),t(m,ce),_(Fe,ce,null),t(ce,ms),t(ce,Dt),t(m,fs),t(m,me),_(Le,me,null),t(me,us),t(me,Pt),t(m,gs),t(m,V),_(Ne,V,null),t(V,hs),t(V,Ut),t(V,_s),_(fe,V,null),t(m,bs),t(m,ue),_(Ee,ue,null),t(ue,vs),t(ue,Ct),t(m,ws),t(m,X),_(Ve,X,null),t(X,ys),t(X,Zt),t(X,xs),_(ge,X,null),y(e,tn,c),_(Xe,e,c),y(e,nn,c),y(e,R,c),_(ze,R,null),t(R,Is),t(R,Wt),y(e,sn,c),_(Re,e,c),y(e,on,c),y(e,U,c),_(Ae,U,null),t(U,Ms),t(U,Bt),t(U,$s),t(U,Gt),t(U,Ts),t(U,z),_(Ye,z,null),t(z,js),t(z,Ft),t(z,Js),_(he,z,null),y(e,an,c),_(He,e,c),y(e,ln,c),y(e,G,c),_(qe,G,null),t(G,Ss),t(G,Lt),t(G,ks),t(G,_e),_(Qe,_e,null),t(_e,Ds),t(_e,Nt),y(e,rn,c),y(e,Rt,c),dn=!0},p(e,[c]){const u={};c&2&&(u.$$scope={dirty:c,ctx:e}),H.$set(u);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),q.$set(A);const F={};c&2&&(F.$$scope={dirty:c,ctx:e}),Q.$set(F);const Oe={};c&2&&(Oe.$$scope={dirty:c,ctx:e}),O.$set(Oe);const L={};c&2&&(L.$$scope={dirty:c,ctx:e}),ee.$set(L);const Ke={};c&2&&(Ke.$$scope={dirty:c,ctx:e}),te.$set(Ke);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),se.$set(D);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:e}),oe.$set(Y);const P={};c&2&&(P.$$scope={dirty:c,ctx:e}),ae.$set(P);const et={};c&2&&(et.$$scope={dirty:c,ctx:e}),fe.$set(et);const tt={};c&2&&(tt.$$scope={dirty:c,ctx:e}),ge.$set(tt);const nt={};c&2&&(nt.$$scope={dirty:c,ctx:e}),he.$set(nt)},i(e){dn||(b(x.$$.fragment,e),b(H.$$.fragment,e),b(Ie.$$.fragment,e),b(Me.$$.fragment,e),b($e.$$.fragment,e),b(q.$$.fragment,e),b(Te.$$.fragment,e),b(Q.$$.fragment,e),b(O.$$.fragment,e),b(je.$$.fragment,e),b(Je.$$.fragment,e),b(ee.$$.fragment,e),b(te.$$.fragment,e),b(Se.$$.fragment,e),b(ke.$$.fragment,e),b(se.$$.fragment,e),b(oe.$$.fragment,e),b(De.$$.fragment,e),b(ae.$$.fragment,e),b(Pe.$$.fragment,e),b(Ue.$$.fragment,e),b(Ce.$$.fragment,e),b(Ze.$$.fragment,e),b(We.$$.fragment,e),b(Be.$$.fragment,e),b(Ge.$$.fragment,e),b(Fe.$$.fragment,e),b(Le.$$.fragment,e),b(Ne.$$.fragment,e),b(fe.$$.fragment,e),b(Ee.$$.fragment,e),b(Ve.$$.fragment,e),b(ge.$$.fragment,e),b(Xe.$$.fragment,e),b(ze.$$.fragment,e),b(Re.$$.fragment,e),b(Ae.$$.fragment,e),b(Ye.$$.fragment,e),b(he.$$.fragment,e),b(He.$$.fragment,e),b(qe.$$.fragment,e),b(Qe.$$.fragment,e),dn=!0)},o(e){v(x.$$.fragment,e),v(H.$$.fragment,e),v(Ie.$$.fragment,e),v(Me.$$.fragment,e),v($e.$$.fragment,e),v(q.$$.fragment,e),v(Te.$$.fragment,e),v(Q.$$.fragment,e),v(O.$$.fragment,e),v(je.$$.fragment,e),v(Je.$$.fragment,e),v(ee.$$.fragment,e),v(te.$$.fragment,e),v(Se.$$.fragment,e),v(ke.$$.fragment,e),v(se.$$.fragment,e),v(oe.$$.fragment,e),v(De.$$.fragment,e),v(ae.$$.fragment,e),v(Pe.$$.fragment,e),v(Ue.$$.fragment,e),v(Ce.$$.fragment,e),v(Ze.$$.fragment,e),v(We.$$.fragment,e),v(Be.$$.fragment,e),v(Ge.$$.fragment,e),v(Fe.$$.fragment,e),v(Le.$$.fragment,e),v(Ne.$$.fragment,e),v(fe.$$.fragment,e),v(Ee.$$.fragment,e),v(Ve.$$.fragment,e),v(ge.$$.fragment,e),v(Xe.$$.fragment,e),v(ze.$$.fragment,e),v(Re.$$.fragment,e),v(Ae.$$.fragment,e),v(Ye.$$.fragment,e),v(he.$$.fragment,e),v(He.$$.fragment,e),v(qe.$$.fragment,e),v(Qe.$$.fragment,e),dn=!1},d(e){e&&(r(I),r(d),r(p),r(n),r(M),r(Ht),r(we),r(qt),r(ye),r(Qt),r(xe),r(Ot),r(Kt),r(en),r(m),r(tn),r(nn),r(R),r(sn),r(on),r(U),r(an),r(ln),r(G),r(rn),r(Rt)),r(s),w(x,e),w(H,e),w(Ie,e),w(Me),w($e),w(q),w(Te),w(Q),w(O),w(je),w(Je),w(ee),w(te),w(Se),w(ke),w(se),w(oe),w(De),w(ae),w(Pe),w(Ue),w(Ce),w(Ze),w(We),w(Be),w(Ge),w(Fe),w(Le),w(Ne),w(fe),w(Ee),w(Ve),w(ge),w(Xe,e),w(ze),w(Re,e),w(Ae),w(Ye),w(he),w(He,e),w(qe),w(Qe)}}}const Go='{"title":"Image-to-image","local":"image-to-image","sections":[{"title":"StableDiffusionImg2ImgPipeline","local":"diffusers.StableDiffusionImg2ImgPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionImg2ImgPipeline","local":"diffusers.FlaxStableDiffusionImg2ImgPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Fo(j){return yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ao extends xo{constructor(s){super(),Io(this,s,Fo,Bo,wo,{})}}export{Ao as component};
