import{s as Ft,o as Et,n as yt}from"../chunks/scheduler.8c3d61f6.js";import{S as Pt,i as Yt,g as l,s,r as c,A as Qt,h as r,f as n,c as a,j as x,u as m,x as M,k as V,y as p,a as o,v as g,d as h,t as u,w as f}from"../chunks/index.da70eac4.js";import{T as St}from"../chunks/Tip.1d9b8c37.js";import{D as ue}from"../chunks/Docstring.6b390b9a.js";import{C as fe}from"../chunks/CodeBlock.00a903b3.js";import{E as $t}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Ze,E as At}from"../chunks/EditOnGithub.1e64e623.js";function qt(k){let d,U='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading.md#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){d=l("p"),d.innerHTML=U},l(T){d=r(T,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1wdzd23"&&(d.innerHTML=U)},m(T,_){o(T,d,_)},p:yt,d(T){T&&n(d)}}}function Dt(k){let d,U="Examples:",T,_,y;return _=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3MDQlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){d=l("p"),d.textContent=U,T=s(),c(_.$$.fragment)},l(i){d=r(i,"P",{"data-svelte-h":!0}),M(d)!=="svelte-kvfsh7"&&(d.textContent=U),T=a(i),m(_.$$.fragment,i)},m(i,b){o(i,d,b),o(i,T,b),g(_,i,b),y=!0},p:yt,i(i){y||(h(_.$$.fragment,i),y=!0)},o(i){u(_.$$.fragment,i),y=!1},d(i){i&&(n(d),n(T)),f(_,i)}}}function Ot(k){let d,U="Examples:",T,_,y;return _=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZhLXItci1vLXclMkZ0aW55LW1lbWUtZGF0YXNldC1jYXB0aW9uZWQlMkZyZXNvbHZlJTJGbWFpbiUyRmltYWdlcyUyRjgucG5nJTIyJTBBKSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjB5b3VuZyUyMGdpcmwlMjBzdGFuZHMlMjBjYWxtbHklMjBpbiUyMHRoZSUyMGZvcmVncm91bmQlMkMlMjBsb29raW5nJTIwZGlyZWN0bHklMjBhdCUyMHRoZSUyMGNhbWVyYSUyQyUyMGFzJTIwYSUyMGhvdXNlJTIwZmlyZSUyMHJhZ2VzJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kLiUyMEZsYW1lcyUyMGVuZ3VsZiUyMHRoZSUyMHN0cnVjdHVyZSUyQyUyMHdpdGglMjBzbW9rZSUyMGJpbGxvd2luZyUyMGludG8lMjB0aGUlMjBhaXIuJTIwRmlyZWZpZ2h0ZXJzJTIwaW4lMjBwcm90ZWN0aXZlJTIwZ2VhciUyMHJ1c2glMjB0byUyMHRoZSUyMHNjZW5lJTJDJTIwYSUyMGZpcmUlMjB0cnVjayUyMGxhYmVsZWQlMjAnMzgnJTIwdmlzaWJsZSUyMGJlaGluZCUyMHRoZW0uJTIwVGhlJTIwZ2lybCdzJTIwbmV1dHJhbCUyMGV4cHJlc3Npb24lMjBjb250cmFzdHMlMjBzaGFycGx5JTIwd2l0aCUyMHRoZSUyMGNoYW9zJTIwb2YlMjB0aGUlMjBmaXJlJTJDJTIwY3JlYXRpbmclMjBhJTIwcG9pZ25hbnQlMjBhbmQlMjBlbW90aW9uYWxseSUyMGNoYXJnZWQlMjBzY2VuZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJ3b3JzdCUyMHF1YWxpdHklMkMlMjBpbmNvbnNpc3RlbnQlMjBtb3Rpb24lMkMlMjBibHVycnklMkMlMjBqaXR0ZXJ5JTJDJTIwZGlzdG9ydGVkJTIyJTBBJTBBdmlkZW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDcwNCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0QxNjElMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXQubXA0JTIyJTJDJTIwZnBzJTNEMjQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = LTXImageToVideoPipeline.from_pretrained(<span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/a-r-r-o-w/tiny-meme-dataset-captioned/resolve/main/images/8.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A young girl stands calmly in the foreground, looking directly at the camera, as a house fire rages in the background. Flames engulf the structure, with smoke billowing into the air. Firefighters in protective gear rush to the scene, a fire truck labeled &#x27;38&#x27; visible behind them. The girl&#x27;s neutral expression contrasts sharply with the chaos of the fire, creating a poignant and emotionally charged scene.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>video = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">704</span>,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">480</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">161</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),{c(){d=l("p"),d.textContent=U,T=s(),c(_.$$.fragment)},l(i){d=r(i,"P",{"data-svelte-h":!0}),M(d)!=="svelte-kvfsh7"&&(d.textContent=U),T=a(i),m(_.$$.fragment,i)},m(i,b){o(i,d,b),o(i,T,b),g(_,i,b),y=!0},p:yt,i(i){y||(h(_.$$.fragment,i),y=!0)},o(i){u(_.$$.fragment,i),y=!1},d(i){i&&(n(d),n(T)),f(_,i)}}}function Kt(k){let d,U,T,_,y,i,b,bt='<a href="https://huggingface.co/Lightricks/LTX-Video" rel="nofollow">LTX Video</a> is the first DiT-based video generation model capable of generating high-quality videos in real-time. It produces 24 FPS videos at a 768x512 resolution faster than they can be watched. Trained on a large-scale dataset of diverse videos, the model generates high-resolution videos with realistic and varied content. We provide a model for both text-to-video as well as image + text-to-video usecases.',Xe,B,Ge,N,wt="Available models:",xe,H,Jt='<thead><tr><th align="center">Model name</th> <th align="center">Recommended dtype</th></tr></thead> <tbody><tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.safetensors" rel="nofollow"><code>LTX Video 0.9.0</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr> <tr><td align="center"><a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow"><code>LTX Video 0.9.1</code></a></td> <td align="center"><code>torch.bfloat16</code></td></tr></tbody>',Ve,z,Ut="Note: The recommended dtype is for the transformer component. The VAE and text encoders can be either <code>torch.float32</code>, <code>torch.bfloat16</code> or <code>torch.float16</code> but the recommended dtype is <code>torch.bfloat16</code> as used in the original repository.",ke,$,Be,F,vt="Loading the original LTX Video checkpoints is also possible with <code>~ModelMixin.from_single_file</code>. We recommend using <code>from_single_file</code> for the Lightricks series of models, as they plan to release multiple models in the future in the single file format.",Le,E,We,P,jt="Alternatively, the pipeline can be used to load the weights with <code>~FromSingleFileMixin.from_single_file</code>.",Ce,Y,Re,Q,Zt='Loading <a href="https://huggingface.co/city96/LTX-Video-gguf" rel="nofollow">LTX GGUF checkpoints</a> are also supported:',Ne,S,He,A,It='Make sure to read the <a href="../../quantization/gguf">documentation on GGUF</a> to learn more about our GGUF support.',ze,q,Xt='Loading and running inference with <a href="https://huggingface.co/Lightricks/LTX-Video/blob/main/ltx-video-2b-v0.9.1.safetensors" rel="nofollow">LTX Video 0.9.1</a> weights.',$e,D,Fe,O,Gt='Refer to <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/cogvideox#memory-optimization" rel="nofollow">this section</a> to learn more about optimizing memory consumption.',Ee,K,Pe,ee,xt="Quantization helps reduce the memory requirements of very large models by storing model weights in a lower precision data type. However, quantization may have varying impact on video quality depending on the video model.",Ye,te,Vt='Refer to the <a href="../../quantization/overview">Quantization</a> overview to learn more about supported quantization backends and selecting a quantization backend that supports your use case. The example below demonstrates how to load a quantized <a href="/docs/diffusers/main/en/api/pipelines/ltx_video#diffusers.LTXPipeline">LTXPipeline</a> for inference with bitsandbytes.',Qe,ne,Se,oe,Ae,w,se,at,Me,kt="Pipeline for text-to-video generation.",it,_e,Bt='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',lt,j,ae,rt,Te,Lt="Function invoked when calling the pipeline for generation.",dt,L,pt,W,ie,ct,ye,Wt="Encodes the prompt into text encoder hidden states.",qe,le,De,J,re,mt,be,Ct="Pipeline for image-to-video generation.",gt,we,Rt='Reference: <a href="https://github.com/Lightricks/LTX-Video" rel="nofollow">https://github.com/Lightricks/LTX-Video</a>',ht,Z,de,ut,Je,Nt="Function invoked when calling the pipeline for generation.",ft,C,Mt,R,pe,_t,Ue,Ht="Encodes the prompt into text encoder hidden states.",Oe,ce,Ke,X,me,Tt,ve,zt="Output class for LTX pipelines.",et,ge,tt,Ie,nt;return y=new Ze({props:{title:"LTX Video",local:"ltx-video",headingTag:"h1"}}),B=new St({props:{$$slots:{default:[qt]},$$scope:{ctx:k}}}),$=new Ze({props:{title:"Loading Single Files",local:"loading-single-files",headingTag:"h2"}}),E=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTExUWFZpZGVvJTJDJTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMkMlMjBMVFhWaWRlb1RyYW5zZm9ybWVyM0RNb2RlbCUwQSUwQSUyMyUyMCU2MHNpbmdsZV9maWxlX3VybCU2MCUyMGNvdWxkJTIwYWxzbyUyMGJlJTIwaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS4xLnNhZmV0ZW5zb3JzJTBBc2luZ2xlX2ZpbGVfdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMkZsdHgtdmlkZW8tMmItdjAuOS5zYWZldGVuc29ycyUyMiUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwTFRYVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjBzaW5nbGVfZmlsZV91cmwlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXZhZSUyMCUzRCUyMEF1dG9lbmNvZGVyS0xMVFhWaWRlby5mcm9tX3NpbmdsZV9maWxlKHNpbmdsZV9maWxlX3VybCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcGlwZSUyMCUzRCUyMExUWEltYWdlVG9WaWRlb1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTIyJTJDJTIwdHJhbnNmb3JtZXIlM0R0cmFuc2Zvcm1lciUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwLi4uJTIwaW5mZXJlbmNlJTIwY29kZSUyMC4uLg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLLTXVideo, LTXImageToVideoPipeline, LTXVideoTransformer3DModel

<span class="hljs-comment"># \`single_file_url\` could also be https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.1.safetensors</span>
single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
transformer = LTXVideoTransformer3DModel.from_single_file(
  single_file_url, torch_dtype=torch.bfloat16
)
vae = AutoencoderKLLTXVideo.from_single_file(single_file_url, torch_dtype=torch.bfloat16)
pipe = LTXImageToVideoPipeline.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, transformer=transformer, vae=vae, torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># ... inference code ...</span>`,wrap:!1}}),Y=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYSW1hZ2VUb1ZpZGVvUGlwZWxpbmUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVDVFbmNvZGVyTW9kZWwlMkMlMjBUNVRva2VuaXplciUwQSUwQXNpbmdsZV9maWxlX3VybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZMaWdodHJpY2tzJTJGTFRYLVZpZGVvJTJGbHR4LXZpZGVvLTJiLXYwLjkuc2FmZXRlbnNvcnMlMjIlMEF0ZXh0X2VuY29kZXIlMjAlM0QlMjBUNUVuY29kZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMkxpZ2h0cmlja3MlMkZMVFgtVmlkZW8lMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQXBpcGUlMjAlM0QlMjBMVFhJbWFnZVRvVmlkZW9QaXBlbGluZS5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMHNpbmdsZV9maWxlX3VybCUyQyUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXImageToVideoPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5EncoderModel, T5Tokenizer

single_file_url = <span class="hljs-string">&quot;https://huggingface.co/Lightricks/LTX-Video/ltx-video-2b-v0.9.safetensors&quot;</span>
text_encoder = T5EncoderModel.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
tokenizer = T5Tokenizer.from_pretrained(
  <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>, torch_dtype=torch.bfloat16
)
pipe = LTXImageToVideoPipeline.from_single_file(
  single_file_url, text_encoder=text_encoder, tokenizer=tokenizer, torch_dtype=torch.bfloat16
)`,wrap:!1}}),S=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExUWFBpcGVsaW5lJTJDJTIwTFRYVmlkZW9UcmFuc2Zvcm1lcjNETW9kZWwlMkMlMjBHR1VGUXVhbnRpemF0aW9uQ29uZmlnJTBBJTBBY2twdF9wYXRoJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZjaXR5OTYlMkZMVFgtVmlkZW8tZ2d1ZiUyRmJsb2IlMkZtYWluJTJGbHR4LXZpZGVvLTJiLXYwLjktUTNfS19TLmdndWYlMjIlMEEpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBMVFhWaWRlb1RyYW5zZm9ybWVyM0RNb2RlbC5mcm9tX3NpbmdsZV9maWxlKCUwQSUyMCUyMCUyMCUyMGNrcHRfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RHR1VGUXVhbnRpemF0aW9uQ29uZmlnKGNvbXB1dGVfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBMVFhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTGlnaHRyaWNrcyUyRkxUWC1WaWRlbyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwd29tYW4lMjB3aXRoJTIwbG9uZyUyMGJyb3duJTIwaGFpciUyMGFuZCUyMGxpZ2h0JTIwc2tpbiUyMHNtaWxlcyUyMGF0JTIwYW5vdGhlciUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBibG9uZGUlMjBoYWlyLiUyMFRoZSUyMHdvbWFuJTIwd2l0aCUyMGJyb3duJTIwaGFpciUyMHdlYXJzJTIwYSUyMGJsYWNrJTIwamFja2V0JTIwYW5kJTIwaGFzJTIwYSUyMHNtYWxsJTJDJTIwYmFyZWx5JTIwbm90aWNlYWJsZSUyMG1vbGUlMjBvbiUyMGhlciUyMHJpZ2h0JTIwY2hlZWsuJTIwVGhlJTIwY2FtZXJhJTIwYW5nbGUlMjBpcyUyMGElMjBjbG9zZS11cCUyQyUyMGZvY3VzZWQlMjBvbiUyMHRoZSUyMHdvbWFuJTIwd2l0aCUyMGJyb3duJTIwaGFpcidzJTIwZmFjZS4lMjBUaGUlMjBsaWdodGluZyUyMGlzJTIwd2FybSUyMGFuZCUyMG5hdHVyYWwlMkMlMjBsaWtlbHklMjBmcm9tJTIwdGhlJTIwc2V0dGluZyUyMHN1biUyQyUyMGNhc3RpbmclMjBhJTIwc29mdCUyMGdsb3clMjBvbiUyMHRoZSUyMHNjZW5lLiUyMFRoZSUyMHNjZW5lJTIwYXBwZWFycyUyMHRvJTIwYmUlMjByZWFsLWxpZmUlMjBmb290YWdlJTIyJTBBbmVnYXRpdmVfcHJvbXB0JTIwJTNEJTIwJTIyd29yc3QlMjBxdWFsaXR5JTJDJTIwaW5jb25zaXN0ZW50JTIwbW90aW9uJTJDJTIwYmx1cnJ5JTJDJTIwaml0dGVyeSUyQyUyMGRpc3RvcnRlZCUyMiUwQSUwQXZpZGVvJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDcwNCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDQ4MCUyQyUwQSUyMCUyMCUyMCUyMG51bV9mcmFtZXMlM0QxNjElMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fdmlkZW8odmlkZW8lMkMlMjAlMjJvdXRwdXRfZ2d1Zl9sdHgubXA0JTIyJTJDJTIwZnBzJTNEMjQp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline, LTXVideoTransformer3DModel, GGUFQuantizationConfig

ckpt_path = (
    <span class="hljs-string">&quot;https://huggingface.co/city96/LTX-Video-gguf/blob/main/ltx-video-2b-v0.9-Q3_K_S.gguf&quot;</span>
)
transformer = LTXVideoTransformer3DModel.from_single_file(
    ckpt_path,
    quantization_config=GGUFQuantizationConfig(compute_dtype=torch.bfloat16),
    torch_dtype=torch.bfloat16,
)
pipe = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">704</span>,
    height=<span class="hljs-number">480</span>,
    num_frames=<span class="hljs-number">161</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output_gguf_ltx.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),D=new fe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTFRYUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwZXhwb3J0X3RvX3ZpZGVvJTBBJTBBcGlwZSUyMCUzRCUyMExUWFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJhLXItci1vLXclMkZMVFgtVmlkZW8tMC45LjEtZGlmZnVzZXJzJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMHdvbWFuJTIwd2l0aCUyMGxvbmclMjBicm93biUyMGhhaXIlMjBhbmQlMjBsaWdodCUyMHNraW4lMjBzbWlsZXMlMjBhdCUyMGFub3RoZXIlMjB3b21hbiUyMHdpdGglMjBsb25nJTIwYmxvbmRlJTIwaGFpci4lMjBUaGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIlMjB3ZWFycyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMGhhcyUyMGElMjBzbWFsbCUyQyUyMGJhcmVseSUyMG5vdGljZWFibGUlMjBtb2xlJTIwb24lMjBoZXIlMjByaWdodCUyMGNoZWVrLiUyMFRoZSUyMGNhbWVyYSUyMGFuZ2xlJTIwaXMlMjBhJTIwY2xvc2UtdXAlMkMlMjBmb2N1c2VkJTIwb24lMjB0aGUlMjB3b21hbiUyMHdpdGglMjBicm93biUyMGhhaXIncyUyMGZhY2UuJTIwVGhlJTIwbGlnaHRpbmclMjBpcyUyMHdhcm0lMjBhbmQlMjBuYXR1cmFsJTJDJTIwbGlrZWx5JTIwZnJvbSUyMHRoZSUyMHNldHRpbmclMjBzdW4lMkMlMjBjYXN0aW5nJTIwYSUyMHNvZnQlMjBnbG93JTIwb24lMjB0aGUlMjBzY2VuZS4lMjBUaGUlMjBzY2VuZSUyMGFwcGVhcnMlMjB0byUyMGJlJTIwcmVhbC1saWZlJTIwZm9vdGFnZSUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMndvcnN0JTIwcXVhbGl0eSUyQyUyMGluY29uc2lzdGVudCUyMG1vdGlvbiUyQyUyMGJsdXJyeSUyQyUyMGppdHRlcnklMkMlMjBkaXN0b3J0ZWQlMjIlMEElMEF2aWRlbyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMTYxJTJDJTBBJTIwJTIwJTIwJTIwZGVjb2RlX3RpbWVzdGVwJTNEMC4wMyUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9ub2lzZV9zY2FsZSUzRDAuMDI1JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX3ZpZGVvKHZpZGVvJTJDJTIwJTIyb3V0cHV0Lm1wNCUyMiUyQyUyMGZwcyUzRDI0KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

pipe = LTXPipeline.from_pretrained(<span class="hljs-string">&quot;a-r-r-o-w/LTX-Video-0.9.1-diffusers&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A woman with long brown hair and light skin smiles at another woman with long blonde hair. The woman with brown hair wears a black jacket and has a small, barely noticeable mole on her right cheek. The camera angle is a close-up, focused on the woman with brown hair&#x27;s face. The lighting is warm and natural, likely from the setting sun, casting a soft glow on the scene. The scene appears to be real-life footage&quot;</span>
negative_prompt = <span class="hljs-string">&quot;worst quality, inconsistent motion, blurry, jittery, distorted&quot;</span>

video = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    width=<span class="hljs-number">768</span>,
    height=<span class="hljs-number">512</span>,
    num_frames=<span class="hljs-number">161</span>,
    decode_timestep=<span class="hljs-number">0.03</span>,
    decode_noise_scale=<span class="hljs-number">0.025</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),K=new Ze({props:{title:"Quantization",local:"quantization",headingTag:"h2"}}),ne=new fe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig, LTXVideoTransformer3DModel, LTXPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> BitsAndBytesConfig, T5EncoderModel

quant_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
text_encoder_8bit = T5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

quant_config = DiffusersBitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
transformer_8bit = LTXVideoTransformer3DModel.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config,
    torch_dtype=torch.float16,
)

pipeline = LTXPipeline.from_pretrained(
    <span class="hljs-string">&quot;Lightricks/LTX-Video&quot;</span>,
    text_encoder=text_encoder_8bit,
    transformer=transformer_8bit,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
)

prompt = <span class="hljs-string">&quot;A detailed wooden toy ship with intricately carved masts and sails is seen gliding smoothly over a plush, blue carpet that mimics the waves of the sea. The ship&#x27;s hull is painted a rich brown, with tiny windows. The carpet, soft and textured, provides a perfect backdrop, resembling an oceanic expanse. Surrounding the ship are various other toys and children&#x27;s items, hinting at a playful environment. The scene captures the innocence and imagination of childhood, with the toy ship&#x27;s journey symbolizing endless adventures in a whimsical, indoor setting.&quot;</span>
video = pipeline(prompt=prompt, num_frames=<span class="hljs-number">161</span>, num_inference_steps=<span class="hljs-number">50</span>).frames[<span class="hljs-number">0</span>]
export_to_video(video, <span class="hljs-string">&quot;ship.mp4&quot;</span>, fps=<span class="hljs-number">24</span>)`,wrap:!1}}),oe=new Ze({props:{title:"LTXPipeline",local:"diffusers.LTXPipeline",headingTag:"h2"}}),se=new ue({props:{name:"class diffusers.LTXPipeline",anchor:"diffusers.LTXPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L143"}}),ae=new ue({props:{name:"__call__",anchor:"diffusers.LTXPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),L=new $t({props:{anchor:"diffusers.LTXPipeline.__call__.example",$$slots:{default:[Dt]},$$scope:{ctx:k}}}),ie=new ue({props:{name:"encode_prompt",anchor:"diffusers.LTXPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx.py#L256"}}),le=new Ze({props:{title:"LTXImageToVideoPipeline",local:"diffusers.LTXImageToVideoPipeline",headingTag:"h2"}}),re=new ue({props:{name:"class diffusers.LTXImageToVideoPipeline",anchor:"diffusers.LTXImageToVideoPipeline",parameters:[{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKLLTXVideo"},{name:"text_encoder",val:": T5EncoderModel"},{name:"tokenizer",val:": T5TokenizerFast"},{name:"transformer",val:": LTXVideoTransformer3DModel"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/ltx_video_transformer3d#diffusers.LTXVideoTransformer3DModel">LTXVideoTransformer3DModel</a>) &#x2014;
Conditional Transformer architecture to denoise the encoded video latents.`,name:"transformer"},{anchor:"diffusers.LTXImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.LTXImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl_ltx_video#diffusers.AutoencoderKLLTXVideo">AutoencoderKLLTXVideo</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.LTXImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">google/t5-v1_1-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.LTXImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5TokenizerFast</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5TokenizerFast" rel="nofollow">T5TokenizerFast</a>.`,name:"tokenizer"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L162"}}),de=new ue({props:{name:"__call__",anchor:"diffusers.LTXImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": int = 512"},{name:"width",val:": int = 704"},{name:"num_frames",val:": int = 161"},{name:"frame_rate",val:": int = 25"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"guidance_scale",val:": float = 3"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"decode_timestep",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"decode_noise_scale",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 128"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>512</code>) &#x2014;
The height in pixels of the generated image. This is set to 480 by default for the best results.`,name:"height"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>704</code>) &#x2014;
The width in pixels of the generated image. This is set to 848 by default for the best results.`,name:"width"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>161</code>) &#x2014;
The number of video frames to generate`,name:"num_frames"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>3 </code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of videos to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.prompt_attention_mask",description:`<strong>prompt_attention_mask</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for text embeddings.`,name:"prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. For PixArt-Sigma this negative prompt should be &quot;&quot;. If not
provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated attention mask for negative text embeddings.`,name:"negative_prompt_attention_mask"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_timestep",description:`<strong>decode_timestep</strong> (<code>float</code>, defaults to <code>0.0</code>) &#x2014;
The timestep at which generated video is decoded.`,name:"decode_timestep"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.decode_noise_scale",description:`<strong>decode_noise_scale</strong> (<code>float</code>, defaults to <code>None</code>) &#x2014;
The interpolation factor between random noise and denoised latents at the decode timestep.`,name:"decode_noise_scale"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.ltx.LTXPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.LTXImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code> defaults to <code>128 </code>) &#x2014;
Maximum sequence length to use with the <code>prompt</code>.`,name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L559",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.ltx.LTXPipelineOutput</code> is returned, otherwise a <code>tuple</code> is
returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.ltx.LTXPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new $t({props:{anchor:"diffusers.LTXImageToVideoPipeline.__call__.example",$$slots:{default:[Ot]},$$scope:{ctx:k}}}),pe=new ue({props:{name:"encode_prompt",anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 128"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.LTXImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_ltx_image2video.py#L279"}}),ce=new Ze({props:{title:"LTXPipelineOutput",local:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",headingTag:"h2"}}),me=new ue({props:{name:"class diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/ltx/pipeline_output.py#L8"}}),ge=new At({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/ltx_video.md"}}),{c(){d=l("meta"),U=s(),T=l("p"),_=s(),c(y.$$.fragment),i=s(),b=l("p"),b.innerHTML=bt,Xe=s(),c(B.$$.fragment),Ge=s(),N=l("p"),N.textContent=wt,xe=s(),H=l("table"),H.innerHTML=Jt,Ve=s(),z=l("p"),z.innerHTML=Ut,ke=s(),c($.$$.fragment),Be=s(),F=l("p"),F.innerHTML=vt,Le=s(),c(E.$$.fragment),We=s(),P=l("p"),P.innerHTML=jt,Ce=s(),c(Y.$$.fragment),Re=s(),Q=l("p"),Q.innerHTML=Zt,Ne=s(),c(S.$$.fragment),He=s(),A=l("p"),A.innerHTML=It,ze=s(),q=l("p"),q.innerHTML=Xt,$e=s(),c(D.$$.fragment),Fe=s(),O=l("p"),O.innerHTML=Gt,Ee=s(),c(K.$$.fragment),Pe=s(),ee=l("p"),ee.textContent=xt,Ye=s(),te=l("p"),te.innerHTML=Vt,Qe=s(),c(ne.$$.fragment),Se=s(),c(oe.$$.fragment),Ae=s(),w=l("div"),c(se.$$.fragment),at=s(),Me=l("p"),Me.textContent=kt,it=s(),_e=l("p"),_e.innerHTML=Bt,lt=s(),j=l("div"),c(ae.$$.fragment),rt=s(),Te=l("p"),Te.textContent=Lt,dt=s(),c(L.$$.fragment),pt=s(),W=l("div"),c(ie.$$.fragment),ct=s(),ye=l("p"),ye.textContent=Wt,qe=s(),c(le.$$.fragment),De=s(),J=l("div"),c(re.$$.fragment),mt=s(),be=l("p"),be.textContent=Ct,gt=s(),we=l("p"),we.innerHTML=Rt,ht=s(),Z=l("div"),c(de.$$.fragment),ut=s(),Je=l("p"),Je.textContent=Nt,ft=s(),c(C.$$.fragment),Mt=s(),R=l("div"),c(pe.$$.fragment),_t=s(),Ue=l("p"),Ue.textContent=Ht,Oe=s(),c(ce.$$.fragment),Ke=s(),X=l("div"),c(me.$$.fragment),Tt=s(),ve=l("p"),ve.textContent=zt,et=s(),c(ge.$$.fragment),tt=s(),Ie=l("p"),this.h()},l(e){const t=Qt("svelte-u9bgzb",document.head);d=r(t,"META",{name:!0,content:!0}),t.forEach(n),U=a(e),T=r(e,"P",{}),x(T).forEach(n),_=a(e),m(y.$$.fragment,e),i=a(e),b=r(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1t4cyrb"&&(b.innerHTML=bt),Xe=a(e),m(B.$$.fragment,e),Ge=a(e),N=r(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1bob28v"&&(N.textContent=wt),xe=a(e),H=r(e,"TABLE",{"data-svelte-h":!0}),M(H)!=="svelte-z7ye80"&&(H.innerHTML=Jt),Ve=a(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-xu6cps"&&(z.innerHTML=Ut),ke=a(e),m($.$$.fragment,e),Be=a(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-lk4l6j"&&(F.innerHTML=vt),Le=a(e),m(E.$$.fragment,e),We=a(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-rvy320"&&(P.innerHTML=jt),Ce=a(e),m(Y.$$.fragment,e),Re=a(e),Q=r(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1r1x4fd"&&(Q.innerHTML=Zt),Ne=a(e),m(S.$$.fragment,e),He=a(e),A=r(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-7vi8uq"&&(A.innerHTML=It),ze=a(e),q=r(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-1d7qawf"&&(q.innerHTML=Xt),$e=a(e),m(D.$$.fragment,e),Fe=a(e),O=r(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-obf3nv"&&(O.innerHTML=Gt),Ee=a(e),m(K.$$.fragment,e),Pe=a(e),ee=r(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1ou2pxc"&&(ee.textContent=xt),Ye=a(e),te=r(e,"P",{"data-svelte-h":!0}),M(te)!=="svelte-1dokfz4"&&(te.innerHTML=Vt),Qe=a(e),m(ne.$$.fragment,e),Se=a(e),m(oe.$$.fragment,e),Ae=a(e),w=r(e,"DIV",{class:!0});var v=x(w);m(se.$$.fragment,v),at=a(v),Me=r(v,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-19ipoo4"&&(Me.textContent=kt),it=a(v),_e=r(v,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-1sr6eg8"&&(_e.innerHTML=Bt),lt=a(v),j=r(v,"DIV",{class:!0});var G=x(j);m(ae.$$.fragment,G),rt=a(G),Te=r(G,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-v78lg8"&&(Te.textContent=Lt),dt=a(G),m(L.$$.fragment,G),G.forEach(n),pt=a(v),W=r(v,"DIV",{class:!0});var he=x(W);m(ie.$$.fragment,he),ct=a(he),ye=r(he,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-16q0ax1"&&(ye.textContent=Wt),he.forEach(n),v.forEach(n),qe=a(e),m(le.$$.fragment,e),De=a(e),J=r(e,"DIV",{class:!0});var I=x(J);m(re.$$.fragment,I),mt=a(I),be=r(I,"P",{"data-svelte-h":!0}),M(be)!=="svelte-10tczlw"&&(be.textContent=Ct),gt=a(I),we=r(I,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1sr6eg8"&&(we.innerHTML=Rt),ht=a(I),Z=r(I,"DIV",{class:!0});var je=x(Z);m(de.$$.fragment,je),ut=a(je),Je=r(je,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-v78lg8"&&(Je.textContent=Nt),ft=a(je),m(C.$$.fragment,je),je.forEach(n),Mt=a(I),R=r(I,"DIV",{class:!0});var ot=x(R);m(pe.$$.fragment,ot),_t=a(ot),Ue=r(ot,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-16q0ax1"&&(Ue.textContent=Ht),ot.forEach(n),I.forEach(n),Oe=a(e),m(ce.$$.fragment,e),Ke=a(e),X=r(e,"DIV",{class:!0});var st=x(X);m(me.$$.fragment,st),Tt=a(st),ve=r(st,"P",{"data-svelte-h":!0}),M(ve)!=="svelte-ia4jjd"&&(ve.textContent=zt),st.forEach(n),et=a(e),m(ge.$$.fragment,e),tt=a(e),Ie=r(e,"P",{}),x(Ie).forEach(n),this.h()},h(){V(d,"name","hf:doc:metadata"),V(d,"content",en),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,d),o(e,U,t),o(e,T,t),o(e,_,t),g(y,e,t),o(e,i,t),o(e,b,t),o(e,Xe,t),g(B,e,t),o(e,Ge,t),o(e,N,t),o(e,xe,t),o(e,H,t),o(e,Ve,t),o(e,z,t),o(e,ke,t),g($,e,t),o(e,Be,t),o(e,F,t),o(e,Le,t),g(E,e,t),o(e,We,t),o(e,P,t),o(e,Ce,t),g(Y,e,t),o(e,Re,t),o(e,Q,t),o(e,Ne,t),g(S,e,t),o(e,He,t),o(e,A,t),o(e,ze,t),o(e,q,t),o(e,$e,t),g(D,e,t),o(e,Fe,t),o(e,O,t),o(e,Ee,t),g(K,e,t),o(e,Pe,t),o(e,ee,t),o(e,Ye,t),o(e,te,t),o(e,Qe,t),g(ne,e,t),o(e,Se,t),g(oe,e,t),o(e,Ae,t),o(e,w,t),g(se,w,null),p(w,at),p(w,Me),p(w,it),p(w,_e),p(w,lt),p(w,j),g(ae,j,null),p(j,rt),p(j,Te),p(j,dt),g(L,j,null),p(w,pt),p(w,W),g(ie,W,null),p(W,ct),p(W,ye),o(e,qe,t),g(le,e,t),o(e,De,t),o(e,J,t),g(re,J,null),p(J,mt),p(J,be),p(J,gt),p(J,we),p(J,ht),p(J,Z),g(de,Z,null),p(Z,ut),p(Z,Je),p(Z,ft),g(C,Z,null),p(J,Mt),p(J,R),g(pe,R,null),p(R,_t),p(R,Ue),o(e,Oe,t),g(ce,e,t),o(e,Ke,t),o(e,X,t),g(me,X,null),p(X,Tt),p(X,ve),o(e,et,t),g(ge,e,t),o(e,tt,t),o(e,Ie,t),nt=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),B.$set(v);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),L.$set(G);const he={};t&2&&(he.$$scope={dirty:t,ctx:e}),C.$set(he)},i(e){nt||(h(y.$$.fragment,e),h(B.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(L.$$.fragment,e),h(ie.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(de.$$.fragment,e),h(C.$$.fragment,e),h(pe.$$.fragment,e),h(ce.$$.fragment,e),h(me.$$.fragment,e),h(ge.$$.fragment,e),nt=!0)},o(e){u(y.$$.fragment,e),u(B.$$.fragment,e),u($.$$.fragment,e),u(E.$$.fragment,e),u(Y.$$.fragment,e),u(S.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(L.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(C.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(ge.$$.fragment,e),nt=!1},d(e){e&&(n(U),n(T),n(_),n(i),n(b),n(Xe),n(Ge),n(N),n(xe),n(H),n(Ve),n(z),n(ke),n(Be),n(F),n(Le),n(We),n(P),n(Ce),n(Re),n(Q),n(Ne),n(He),n(A),n(ze),n(q),n($e),n(Fe),n(O),n(Ee),n(Pe),n(ee),n(Ye),n(te),n(Qe),n(Se),n(Ae),n(w),n(qe),n(De),n(J),n(Oe),n(Ke),n(X),n(et),n(tt),n(Ie)),n(d),f(y,e),f(B,e),f($,e),f(E,e),f(Y,e),f(S,e),f(D,e),f(K,e),f(ne,e),f(oe,e),f(se),f(ae),f(L),f(ie),f(le,e),f(re),f(de),f(C),f(pe),f(ce,e),f(me),f(ge,e)}}}const en='{"title":"LTX Video","local":"ltx-video","sections":[{"title":"Loading Single Files","local":"loading-single-files","sections":[],"depth":2},{"title":"Quantization","local":"quantization","sections":[],"depth":2},{"title":"LTXPipeline","local":"diffusers.LTXPipeline","sections":[],"depth":2},{"title":"LTXImageToVideoPipeline","local":"diffusers.LTXImageToVideoPipeline","sections":[],"depth":2},{"title":"LTXPipelineOutput","local":"diffusers.pipelines.ltx.pipeline_output.LTXPipelineOutput","sections":[],"depth":2}],"depth":1}';function tn(k){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pn extends Pt{constructor(d){super(),Yt(this,d,tn,Kt,Ft,{})}}export{pn as component};
