import{s as Oe,n as Ke,o as et}from"../chunks/scheduler.d627b047.js";import{S as tt,i as lt,g as c,s as a,r as i,A as st,h as y,f as l,c as n,j as De,u as r,x as u,k as Pe,y as at,a as s,v as p,d as o,t as m,w as d}from"../chunks/index.73c51727.js";import{C as M}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as J,E as nt}from"../chunks/EditOnGithub.859b9ebc.js";function it(Ve){let f,K,P,ee,h,te,b,_e="TRL is designed with modularity in mind so that users to be able to efficiently customize the training loop for their needs. Below are some examples on how you can apply and test different techniques.  Note: Although these examples use the DPOTrainer, the customization applies to most (if not all) trainers.",le,w,se,T,ze="The trainers in TRL use 🤗 Accelerate to enable distributed training across multiple GPUs or nodes. To do so, first create an 🤗 Accelerate config file by running",ae,U,ne,g,Qe="and answering the questions according to your multi-gpu / multi-node setup. You can then launch distributed training by running:",ie,Z,re,j,Ne='We also provide config files in the <a href="https://github.com/huggingface/trl/tree/main/examples/accelerate_configs" rel="nofollow">examples folder</a> that can be used as templates. To use these templates, simply pass the path to the config file when launching a job, e.g.:',pe,R,oe,W,ve='Refer to the <a href="https://github.com/huggingface/trl/tree/main/examples" rel="nofollow">examples page</a> for more details.',me,C,de,X,Ee="All of the trainers in TRL can be run on multiple GPUs together with DeepSpeed ZeRO-{1,2,3} for efficient sharding of the optimizer states, gradients, and model weights. To do so, run:",ce,G,ye,B,Fe='Note that for ZeRO-3, a small tweak is needed to initialize your reward model on the correct device via the <code>zero3_init_context_manager()</code> context manager. In particular, this is needed to avoid DeepSpeed hanging after a fixed number of training steps. Here is a snippet of what is involved from the <a href="https://github.com/huggingface/trl/blob/main/examples/scripts/ppo.py" rel="nofollow"><code>sentiment_tuning</code></a> example:',ue,$,Me,I,Ye='Consult the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/usage_guides/deepspeed" rel="nofollow">documentation</a> for more information about the DeepSpeed plugin.',fe,k,Je,V,xe="By default, the <code>DPOTrainer</code> creates a <code>torch.optim.AdamW</code> optimizer. You can create and define a different optimizer and pass it to <code>DPOTrainer</code> as follows:",he,_,be,z,we,Q,He="You can also play with your training by adding learning rate schedulers.",Te,N,Ue,v,ge,E,Ae="Another tool you can use for more memory efficient fine-tuning is to share layers between the reference model and the model you want to train.",Ze,F,je,Y,Re,x,Se="Since <code>trl</code> supports all keyword arguments when loading a model from <code>transformers</code> using <code>from_pretrained</code>, you can also leverage <code>load_in_8bit</code> from <code>transformers</code> for more memory efficient fine-tuning.",We,H,Le='Read more about 8-bit model loading in <code>transformers</code> <a href="https://huggingface.co/docs/transformers/en/peft#load-in-8bit-or-4bit" rel="nofollow">here</a>.',Ce,A,Xe,S,Ge,L,qe="When training large models, you should better handle the CUDA cache by iteratively clearing it. To do so, simply pass <code>optimize_cuda_cache=True</code> to <code>DPOConfig</code>:",Be,q,$e,D,Ie,O,ke;return h=new J({props:{title:"Training customization",local:"training-customization",headingTag:"h1"}}),w=new J({props:{title:"Train on multiple GPUs / nodes",local:"train-on-multiple-gpus--nodes",headingTag:"h2"}}),U=new M({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Z=new M({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHlvdXJfc2NyaXB0LnB5",highlighted:"accelerate launch your_script.py",wrap:!1}}),R=new M({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRm11bHRpX2dwdS55YW1sJTIwLS1udW1fcHJvY2Vzc2VzJTIwJTdCTlVNX0dQVVMlN0QlMjBwYXRoX3RvX3NjcmlwdC5weSUyMC0tYWxsX2FyZ3VtZW50c19vZl90aGVfc2NyaXB0",highlighted:"accelerate launch --config_file=examples/accelerate_configs/multi_gpu.yaml --num_processes {NUM_GPUS} path_to_script.py --all_arguments_of_the_script",wrap:!1}}),C=new J({props:{title:"Distributed training with DeepSpeed",local:"distributed-training-with-deepspeed",headingTag:"h3"}}),G=new M({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlM0RleGFtcGxlcyUyRmFjY2VsZXJhdGVfY29uZmlncyUyRmRlZXBzcGVlZF96ZXJvJTdCMSUyQzIlMkMzJTdELnlhbWwlMjAtLW51bV9wcm9jZXNzZXMlMjAlN0JOVU1fR1BVUyU3RCUyMHBhdGhfdG9feW91cl9zY3JpcHQucHklMjAtLWFsbF9hcmd1bWVudHNfb2ZfdGhlX3NjcmlwdA==",highlighted:"accelerate launch --config_file=examples/accelerate_configs/deepspeed_zero{1,2,3}.yaml --num_processes {NUM_GPUS} path_to_your_script.py --all_arguments_of_the_script",wrap:!1}}),$=new M({props:{code:"ZHNfcGx1Z2luJTIwJTNEJTIwcHBvX3RyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZGVlcHNwZWVkX3BsdWdpbiUwQWlmJTIwZHNfcGx1Z2luJTIwaXMlMjBub3QlMjBOb25lJTIwYW5kJTIwZHNfcGx1Z2luLmlzX3plcm8zX2luaXRfZW5hYmxlZCgpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGRzX3BsdWdpbi56ZXJvM19pbml0X2NvbnRleHRfbWFuYWdlcihlbmFibGUlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZW50aW1lbnRfcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnNlbnRpbWVudC1hbmFseXNpcyUyMiUyQyUyMG1vZGVsJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwc2VudGltZW50X3BpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIlMkMlMjBtb2RlbCUzRCUyMmx2d2VycmElMkZkaXN0aWxiZXJ0LWltZGIlMjIlMkMlMjBkZXZpY2UlM0RkZXZpY2Up",highlighted:`ds_plugin = ppo_trainer.accelerator.state.deepspeed_plugin
<span class="hljs-keyword">if</span> ds_plugin <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> ds_plugin.is_zero3_init_enabled():
    <span class="hljs-keyword">with</span> ds_plugin.zero3_init_context_manager(enable=<span class="hljs-literal">False</span>):
        sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)
<span class="hljs-keyword">else</span>:
    sentiment_pipe = pipeline(<span class="hljs-string">&quot;sentiment-analysis&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>, device=device)`,wrap:!1}}),k=new J({props:{title:"Use different optimizers and schedulers",local:"use-different-optimizers-and-schedulers",headingTag:"h2"}}),_=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG9wdGltJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLjUtMC41Qi1EUE8lMjIpJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uU0dEKG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEdHJhaW5pbmdfYXJncy5sZWFybmluZ19yYXRlKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBOb25lKSUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> optim
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

optimizer = optim.SGD(model.parameters(), lr=training_args.learning_rate)

trainer = DPOTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
    optimizers=(optimizer, <span class="hljs-literal">None</span>),
)
trainer.train()`,wrap:!1}}),z=new J({props:{title:"Add a learning rate scheduler",local:"add-a-learning-rate-scheduler",headingTag:"h3"}}),N=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG9wdGltJTBBZnJvbSUyMHRybCUyMGltcG9ydCUyMERQT0NvbmZpZyUyQyUyMERQT1RyYWluZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ0cmwtbGliJTJGdWx0cmFmZWVkYmFja19iaW5hcml6ZWQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBEUE9Db25maWcob3V0cHV0X2RpciUzRCUyMlF3ZW4yLjUtMC41Qi1EUE8lMjIpJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwb3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0R0cmFpbmluZ19hcmdzLmxlYXJuaW5nX3JhdGUpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwb3B0aW0ubHJfc2NoZWR1bGVyLlN0ZXBMUihvcHRpbWl6ZXIlMkMlMjBzdGVwX3NpemUlM0QzMCUyQyUyMGdhbW1hJTNEMC4xKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIpJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> optim
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

optimizer = optim.AdamW(model.parameters(), lr=training_args.learning_rate)
lr_scheduler = optim.lr_scheduler.StepLR(optimizer, step_size=<span class="hljs-number">30</span>, gamma=<span class="hljs-number">0.1</span>)

trainer = DPOTrainer(
    model=model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
    optimizers=(optimizer, lr_scheduler),
)
trainer.train()`,wrap:!1}}),v=new J({props:{title:"Memory efficient fine-tuning by sharing layers",local:"memory-efficient-fine-tuning-by-sharing-layers",headingTag:"h2"}}),F=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBjcmVhdGVfcmVmZXJlbmNlX21vZGVsJTJDJTIwRFBPQ29uZmlnJTJDJTIwRFBPVHJhaW5lciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIpJTBBcmVmX21vZGVsJTIwJTNEJTIwY3JlYXRlX3JlZmVyZW5jZV9tb2RlbChtb2RlbCUyQyUyMG51bV9zaGFyZWRfbGF5ZXJzJTNENiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnVsdHJhZmVlZGJhY2tfYmluYXJpemVkJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiU1QiUzQTElMjUlNUQlMjIpJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyhvdXRwdXRfZGlyJTNEJTIyUXdlbjIuNS0wLjVCLURQTyUyMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwRFBPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwcmVmX21vZGVsJTNEcmVmX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> create_reference_model, DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
ref_model = create_reference_model(model, num_shared_layers=<span class="hljs-number">6</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train[:1%]&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

trainer = DPOTrainer(
    model=model,
    ref_model=ref_model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),Y=new J({props:{title:"Pass 8-bit reference models",local:"pass-8-bit-reference-models",headingTag:"h2"}}),A=new M({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQWZyb20lMjB0cmwlMjBpbXBvcnQlMjBEUE9Db25maWclMkMlMjBEUE9UcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyUXdlbiUyRlF3ZW4yLjUtMC41Qi1JbnN0cnVjdCUyMiklMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fOGJpdCUzRFRydWUpJTBBcmVmX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuMi41LTAuNUItSW5zdHJ1Y3QlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEJTIwcXVhbnRpemF0aW9uX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJRd2VuJTJGUXdlbjIuNS0wLjVCLUluc3RydWN0JTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIydHJsLWxpYiUyRnVsdHJhZmVlZGJhY2tfYmluYXJpemVkJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEF0cmFpbmluZ19hcmdzJTIwJTNEJTIwRFBPQ29uZmlnKG91dHB1dF9kaXIlM0QlMjJRd2VuMi41LTAuNUItRFBPJTIyKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBEUE9UcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByZWZfbW9kZWwlM0RyZWZfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0RkYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBKSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> DPOConfig, DPOTrainer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
quantization_config = BitsAndBytesConfig(load_in_8bit=<span class="hljs-literal">True</span>)
ref_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>, quantization_config= quantization_config)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen2.5-0.5B-Instruct&quot;</span>)
dataset = load_dataset(<span class="hljs-string">&quot;trl-lib/ultrafeedback_binarized&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
training_args = DPOConfig(output_dir=<span class="hljs-string">&quot;Qwen2.5-0.5B-DPO&quot;</span>)

trainer = DPOTrainer(
    model=model,
    ref_model=ref_model,
    args=training_args,
    train_dataset=dataset,
    tokenizer=tokenizer,
)
trainer.train()`,wrap:!1}}),S=new J({props:{title:"Use the CUDA cache optimizer",local:"use-the-cuda-cache-optimizer",headingTag:"h2"}}),q=new M({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMERQT0NvbmZpZyguLi4lMkMlMjBvcHRpbWl6ZV9jdWRhX2NhY2hlJTNEVHJ1ZSk=",highlighted:'training_args = DPOConfig(..., optimize_cuda_cache=<span class="hljs-literal">True</span>)',wrap:!1}}),D=new nt({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/customization.mdx"}}),{c(){f=c("meta"),K=a(),P=c("p"),ee=a(),i(h.$$.fragment),te=a(),b=c("p"),b.textContent=_e,le=a(),i(w.$$.fragment),se=a(),T=c("p"),T.textContent=ze,ae=a(),i(U.$$.fragment),ne=a(),g=c("p"),g.textContent=Qe,ie=a(),i(Z.$$.fragment),re=a(),j=c("p"),j.innerHTML=Ne,pe=a(),i(R.$$.fragment),oe=a(),W=c("p"),W.innerHTML=ve,me=a(),i(C.$$.fragment),de=a(),X=c("p"),X.textContent=Ee,ce=a(),i(G.$$.fragment),ye=a(),B=c("p"),B.innerHTML=Fe,ue=a(),i($.$$.fragment),Me=a(),I=c("p"),I.innerHTML=Ye,fe=a(),i(k.$$.fragment),Je=a(),V=c("p"),V.innerHTML=xe,he=a(),i(_.$$.fragment),be=a(),i(z.$$.fragment),we=a(),Q=c("p"),Q.textContent=He,Te=a(),i(N.$$.fragment),Ue=a(),i(v.$$.fragment),ge=a(),E=c("p"),E.textContent=Ae,Ze=a(),i(F.$$.fragment),je=a(),i(Y.$$.fragment),Re=a(),x=c("p"),x.innerHTML=Se,We=a(),H=c("p"),H.innerHTML=Le,Ce=a(),i(A.$$.fragment),Xe=a(),i(S.$$.fragment),Ge=a(),L=c("p"),L.innerHTML=qe,Be=a(),i(q.$$.fragment),$e=a(),i(D.$$.fragment),Ie=a(),O=c("p"),this.h()},l(e){const t=st("svelte-u9bgzb",document.head);f=y(t,"META",{name:!0,content:!0}),t.forEach(l),K=n(e),P=y(e,"P",{}),De(P).forEach(l),ee=n(e),r(h.$$.fragment,e),te=n(e),b=y(e,"P",{"data-svelte-h":!0}),u(b)!=="svelte-13e1rz9"&&(b.textContent=_e),le=n(e),r(w.$$.fragment,e),se=n(e),T=y(e,"P",{"data-svelte-h":!0}),u(T)!=="svelte-ctt0hb"&&(T.textContent=ze),ae=n(e),r(U.$$.fragment,e),ne=n(e),g=y(e,"P",{"data-svelte-h":!0}),u(g)!=="svelte-1ln7prb"&&(g.textContent=Qe),ie=n(e),r(Z.$$.fragment,e),re=n(e),j=y(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-15pg0q3"&&(j.innerHTML=Ne),pe=n(e),r(R.$$.fragment,e),oe=n(e),W=y(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-la5c3h"&&(W.innerHTML=ve),me=n(e),r(C.$$.fragment,e),de=n(e),X=y(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-190jsut"&&(X.textContent=Ee),ce=n(e),r(G.$$.fragment,e),ye=n(e),B=y(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-e8r4tv"&&(B.innerHTML=Fe),ue=n(e),r($.$$.fragment,e),Me=n(e),I=y(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-hhlpqt"&&(I.innerHTML=Ye),fe=n(e),r(k.$$.fragment,e),Je=n(e),V=y(e,"P",{"data-svelte-h":!0}),u(V)!=="svelte-mc250"&&(V.innerHTML=xe),he=n(e),r(_.$$.fragment,e),be=n(e),r(z.$$.fragment,e),we=n(e),Q=y(e,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-gsqx31"&&(Q.textContent=He),Te=n(e),r(N.$$.fragment,e),Ue=n(e),r(v.$$.fragment,e),ge=n(e),E=y(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-hswwhh"&&(E.textContent=Ae),Ze=n(e),r(F.$$.fragment,e),je=n(e),r(Y.$$.fragment,e),Re=n(e),x=y(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-orby5n"&&(x.innerHTML=Se),We=n(e),H=y(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-11ft3oj"&&(H.innerHTML=Le),Ce=n(e),r(A.$$.fragment,e),Xe=n(e),r(S.$$.fragment,e),Ge=n(e),L=y(e,"P",{"data-svelte-h":!0}),u(L)!=="svelte-xeg2g6"&&(L.innerHTML=qe),Be=n(e),r(q.$$.fragment,e),$e=n(e),r(D.$$.fragment,e),Ie=n(e),O=y(e,"P",{}),De(O).forEach(l),this.h()},h(){Pe(f,"name","hf:doc:metadata"),Pe(f,"content",rt)},m(e,t){at(document.head,f),s(e,K,t),s(e,P,t),s(e,ee,t),p(h,e,t),s(e,te,t),s(e,b,t),s(e,le,t),p(w,e,t),s(e,se,t),s(e,T,t),s(e,ae,t),p(U,e,t),s(e,ne,t),s(e,g,t),s(e,ie,t),p(Z,e,t),s(e,re,t),s(e,j,t),s(e,pe,t),p(R,e,t),s(e,oe,t),s(e,W,t),s(e,me,t),p(C,e,t),s(e,de,t),s(e,X,t),s(e,ce,t),p(G,e,t),s(e,ye,t),s(e,B,t),s(e,ue,t),p($,e,t),s(e,Me,t),s(e,I,t),s(e,fe,t),p(k,e,t),s(e,Je,t),s(e,V,t),s(e,he,t),p(_,e,t),s(e,be,t),p(z,e,t),s(e,we,t),s(e,Q,t),s(e,Te,t),p(N,e,t),s(e,Ue,t),p(v,e,t),s(e,ge,t),s(e,E,t),s(e,Ze,t),p(F,e,t),s(e,je,t),p(Y,e,t),s(e,Re,t),s(e,x,t),s(e,We,t),s(e,H,t),s(e,Ce,t),p(A,e,t),s(e,Xe,t),p(S,e,t),s(e,Ge,t),s(e,L,t),s(e,Be,t),p(q,e,t),s(e,$e,t),p(D,e,t),s(e,Ie,t),s(e,O,t),ke=!0},p:Ke,i(e){ke||(o(h.$$.fragment,e),o(w.$$.fragment,e),o(U.$$.fragment,e),o(Z.$$.fragment,e),o(R.$$.fragment,e),o(C.$$.fragment,e),o(G.$$.fragment,e),o($.$$.fragment,e),o(k.$$.fragment,e),o(_.$$.fragment,e),o(z.$$.fragment,e),o(N.$$.fragment,e),o(v.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(A.$$.fragment,e),o(S.$$.fragment,e),o(q.$$.fragment,e),o(D.$$.fragment,e),ke=!0)},o(e){m(h.$$.fragment,e),m(w.$$.fragment,e),m(U.$$.fragment,e),m(Z.$$.fragment,e),m(R.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(k.$$.fragment,e),m(_.$$.fragment,e),m(z.$$.fragment,e),m(N.$$.fragment,e),m(v.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(A.$$.fragment,e),m(S.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),ke=!1},d(e){e&&(l(K),l(P),l(ee),l(te),l(b),l(le),l(se),l(T),l(ae),l(ne),l(g),l(ie),l(re),l(j),l(pe),l(oe),l(W),l(me),l(de),l(X),l(ce),l(ye),l(B),l(ue),l(Me),l(I),l(fe),l(Je),l(V),l(he),l(be),l(we),l(Q),l(Te),l(Ue),l(ge),l(E),l(Ze),l(je),l(Re),l(x),l(We),l(H),l(Ce),l(Xe),l(Ge),l(L),l(Be),l($e),l(Ie),l(O)),l(f),d(h,e),d(w,e),d(U,e),d(Z,e),d(R,e),d(C,e),d(G,e),d($,e),d(k,e),d(_,e),d(z,e),d(N,e),d(v,e),d(F,e),d(Y,e),d(A,e),d(S,e),d(q,e),d(D,e)}}}const rt='{"title":"Training customization","local":"training-customization","sections":[{"title":"Train on multiple GPUs / nodes","local":"train-on-multiple-gpus--nodes","sections":[{"title":"Distributed training with DeepSpeed","local":"distributed-training-with-deepspeed","sections":[],"depth":3}],"depth":2},{"title":"Use different optimizers and schedulers","local":"use-different-optimizers-and-schedulers","sections":[{"title":"Add a learning rate scheduler","local":"add-a-learning-rate-scheduler","sections":[],"depth":3}],"depth":2},{"title":"Memory efficient fine-tuning by sharing layers","local":"memory-efficient-fine-tuning-by-sharing-layers","sections":[],"depth":2},{"title":"Pass 8-bit reference models","local":"pass-8-bit-reference-models","sections":[],"depth":2},{"title":"Use the CUDA cache optimizer","local":"use-the-cuda-cache-optimizer","sections":[],"depth":2}],"depth":1}';function pt(Ve){return et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class yt extends tt{constructor(f){super(),lt(this,f,pt,it,Oe,{})}}export{yt as component};
