import{s as Pt,o as Et,n as Ft}from"../chunks/scheduler.25b97de1.js";import{S as qt,i as Lt,g as l,s as n,r as d,A as Dt,h as i,f as o,c as s,j as S,u,x as c,k as x,y as r,a,v as h,d as g,t as f,w as y}from"../chunks/index.d9030fc9.js";import{T as Yt}from"../chunks/Tip.baa67368.js";import{D as ce}from"../chunks/Docstring.ffac8efa.js";import{C as et}from"../chunks/CodeBlock.e6cd0d95.js";import{E as At}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as Ge,E as Kt}from"../chunks/EditOnGithub.91d95064.js";function Ot(pe){let p,C="Examples:",w,_,G;return _=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyR2x1ZUNvbmZpZyUyQyUyMFN1cGVyR2x1ZU1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFN1cGVyR2x1ZSUyMHN1cGVyZ2x1ZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBTdXBlckdsdWVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBzdXBlcmdsdWUlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyR2x1ZU1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperGlueConfig, SuperGlueModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperGlue superglue style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperGlueConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superglue style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperGlueModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){p=l("p"),p.textContent=C,w=n(),d(_.$$.fragment)},l(M){p=i(M,"P",{"data-svelte-h":!0}),c(p)!=="svelte-kvfsh7"&&(p.textContent=C),w=s(M),u(_.$$.fragment,M)},m(M,I){a(M,p,I),a(M,w,I),h(_,M,I),G=!0},p:Ft,i(M){G||(g(_.$$.fragment,M),G=!0)},o(M){f(_.$$.fragment,M),G=!1},d(M){M&&(o(p),o(w)),y(_,M)}}}function eo(pe){let p,C=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){p=l("p"),p.innerHTML=C},l(w){p=i(w,"P",{"data-svelte-h":!0}),c(p)!=="svelte-fincs2"&&(p.innerHTML=C)},m(w,_){a(w,p,_)},p:Ft,d(w){w&&o(p)}}}function to(pe){let p,C,w,_,G,M,I,ve,W,Tt='The SuperGlue model was proposed in <a href="https://arxiv.org/abs/1911.11763" rel="nofollow">SuperGlue: Learning Feature Matching with Graph Neural Networks</a> by Paul-Edouard Sarlin, Daniel DeTone, Tomasz Malisiewicz and Andrew Rabinovich.',Ce,N,bt=`This model consists of matching two sets of interest points detected in an image. Paired with the
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">SuperPoint model</a>, it can be used to match two images and
estimate the pose between them. This model is useful for tasks such as image matching, homography estimation, etc.`,je,R,_t="The abstract from the paper is the following:",Se,X,Jt=`<em>This paper introduces SuperGlue, a neural network that matches two sets of local features by jointly finding correspondences
and rejecting non-matchable points. Assignments are estimated by solving a differentiable optimal transport problem, whose costs
are predicted by a graph neural network. We introduce a flexible context aggregation mechanism based on attention, enabling
SuperGlue to reason about the underlying 3D scene and feature assignments jointly. Compared to traditional, hand-designed heuristics,
our technique learns priors over geometric transformations and regularities of the 3D world through end-to-end training from image
pairs. SuperGlue outperforms other learned approaches and achieves state-of-the-art results on the task of pose estimation in
challenging real-world indoor and outdoor environments. The proposed method performs matching in real-time on a modern GPU and
can be readily integrated into modern SfM or SLAM systems. The code and trained weights are publicly available at this <a href="https://github.com/magicleap/SuperGluePretrainedNetwork" rel="nofollow">URL</a>.</em>`,xe,V,ke,H,Ut=`Here is a quick example of using the model. Since this model is an image matching model, it requires pairs of images to be matched.
The raw outputs contain the list of keypoints detected by the keypoint detector as well as the list of matches with their corresponding
matching scores.`,$e,Q,ze,F,Gt="You can use the <code>post_process_keypoint_matching</code> method from the <code>SuperGlueImageProcessor</code> to get the keypoints and matches in a more readable format:",Be,P,Ze,E,It="From the outputs, you can visualize the matches between the two images using the following code:",We,q,Ne,L,vt='<img src="https://cdn-uploads.huggingface.co/production/uploads/632885ba1558dac67c440aa8/01ZYaLB1NL5XdA8u7yCo4.png" alt="image/png"/>',Re,D,Ct=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperGluePretrainedNetwork" rel="nofollow">here</a>.`,Xe,Y,Ve,J,A,tt,me,jt=`This is the configuration class to store the configuration of a <code>SuperGlueModel</code>. It is used to instantiate a
SuperGlue model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperGlue
<a href="https://huggingface.co/magic-leap-community/superglue_indoor" rel="nofollow">magic-leap-community/superglue_indoor</a> architecture.`,ot,de,St=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,nt,k,He,K,Qe,b,O,st,ue,xt="Constructs a SuperGlue image processor.",at,$,ee,rt,he,kt=`Converts the raw output of <code>KeypointMatchingOutput</code> into lists of keypoints, scores and descriptors
with coordinates absolute to the original image sizes.`,lt,z,te,it,ge,$t="Preprocess an image or batch of images.",ct,B,oe,pt,fe,zt="Resize an image.",Fe,ne,Bt="<li>preprocess</li>",Pe,se,Ee,m,ae,mt,ye,Zt=`SuperGlue model taking images as inputs and outputting the matching of them.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,dt,Me,Wt="SuperGlue feature matching middle-end",ut,we,Nt=`Given two sets of keypoints and locations, we determine the
correspondences by:`,ht,Te,Rt="<li>Keypoint Encoding (normalization + visual feature and location fusion)</li> <li>Graph Neural Network with multiple self and cross-attention layers</li> <li>Final projection layer</li> <li>Optimal Transport Layer (a differentiable Hungarian matching algorithm)</li> <li>Thresholding matrix based on mutual exclusivity and a match_threshold</li>",gt,be,Xt="The correspondence ids use -1 to indicate non-matching points.",ft,_e,Vt=`Paul-Edouard Sarlin, Daniel DeTone, Tomasz Malisiewicz, and Andrew
Rabinovich. SuperGlue: Learning Feature Matching with Graph Neural
Networks. In CVPR, 2020. <a href="https://arxiv.org/abs/1911.11763" rel="nofollow">https://arxiv.org/abs/1911.11763</a>`,yt,j,re,Mt,Je,Ht='The <a href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueForKeypointMatching">SuperGlueForKeypointMatching</a> forward method, overrides the <code>__call__</code> special method.',wt,Z,qe,le,Qt="<li>forward</li> <li>post_process_keypoint_matching</li>",Le,ie,De,Ie,Ye;return G=new Ge({props:{title:"SuperGlue",local:"superglue",headingTag:"h1"}}),I=new Ge({props:{title:"Overview",local:"overview",headingTag:"h2"}}),V=new Ge({props:{title:"How to use",local:"how-to-use",headingTag:"h2"}}),Q=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2UxJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGbWFnaWNsZWFwJTJGU3VwZXJHbHVlUHJldHJhaW5lZE5ldHdvcmslMkZyZWZzJTJGaGVhZHMlMkZtYXN0ZXIlMkZhc3NldHMlMkZwaG90b3RvdXJpc21fc2FtcGxlX2ltYWdlcyUyRnVuaXRlZF9zdGF0ZXNfY2FwaXRvbF85ODE2OTg4OF8zMzQ3NzEwODUyLmpwZyUyMiUwQWltYWdlMSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybF9pbWFnZTElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlMiUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGcmF3LmdpdGh1YnVzZXJjb250ZW50LmNvbSUyRm1hZ2ljbGVhcCUyRlN1cGVyR2x1ZVByZXRyYWluZWROZXR3b3JrJTJGcmVmcyUyRmhlYWRzJTJGbWFzdGVyJTJGYXNzZXRzJTJGcGhvdG90b3VyaXNtX3NhbXBsZV9pbWFnZXMlMkZ1bml0ZWRfc3RhdGVzX2NhcGl0b2xfMjY3NTcwMjdfNjcxNzA4NDA2MS5qcGclMjIlMEFpbWFnZV8yJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZTElMkMlMjBpbWFnZTIlNUQlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJnbHVlX291dGRvb3IlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJnbHVlX291dGRvb3IlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image1 = <span class="hljs-string">&quot;https://raw.githubusercontent.com/magicleap/SuperGluePretrainedNetwork/refs/heads/master/assets/phototourism_sample_images/united_states_capitol_98169888_3347710852.jpg&quot;</span>
image1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image1, stream=<span class="hljs-literal">True</span>).raw)
url_image2 = <span class="hljs-string">&quot;https://raw.githubusercontent.com/magicleap/SuperGluePretrainedNetwork/refs/heads/master/assets/phototourism_sample_images/united_states_capitol_26757027_6717084061.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image2, stream=<span class="hljs-literal">True</span>).raw)

images = [image1, image2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superglue_outdoor&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)`,wrap:!1}}),P=new et({props:{code:"aW1hZ2Vfc2l6ZXMlMjAlM0QlMjAlNUIlNUIoaW1hZ2UuaGVpZ2h0JTJDJTIwaW1hZ2Uud2lkdGgpJTIwZm9yJTIwaW1hZ2UlMjBpbiUyMGltYWdlcyU1RCU1RCUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IucG9zdF9wcm9jZXNzX2tleXBvaW50X21hdGNoaW5nKG91dHB1dHMlMkMlMjBpbWFnZV9zaXplcyUyQyUyMHRocmVzaG9sZCUzRDAuMiklMEFmb3IlMjBpJTJDJTIwb3V0cHV0JTIwaW4lMjBlbnVtZXJhdGUob3V0cHV0cyklM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJGb3IlMjB0aGUlMjBpbWFnZSUyMHBhaXIlMjIlMkMlMjBpKSUwQSUyMCUyMCUyMCUyMGZvciUyMGtleXBvaW50MCUyQyUyMGtleXBvaW50MSUyQyUyMG1hdGNoaW5nX3Njb3JlJTIwaW4lMjB6aXAoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTVCJTIya2V5cG9pbnRzMCUyMiU1RCUyQyUyMG91dHB1dCU1QiUyMmtleXBvaW50czElMjIlNUQlMkMlMjBvdXRwdXQlNUIlMjJtYXRjaGluZ19zY29yZXMlMjIlNUQlMEElMjAlMjAlMjAlMjApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMktleXBvaW50JTIwYXQlMjBjb29yZGluYXRlJTIwJTdCa2V5cG9pbnQwLm51bXB5KCklN0QlMjBpbiUyMHRoZSUyMGZpcnN0JTIwaW1hZ2UlMjBtYXRjaGVzJTIwd2l0aCUyMGtleXBvaW50JTIwYXQlMjBjb29yZGluYXRlJTIwJTdCa2V5cG9pbnQxLm51bXB5KCklN0QlMjBpbiUyMHRoZSUyMHNlY29uZCUyMGltYWdlJTIwd2l0aCUyMGElMjBzY29yZSUyMG9mJTIwJTdCbWF0Y2hpbmdfc2NvcmUlN0QuJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQQ==",highlighted:`image_sizes = [[(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]]
outputs = processor.post_process_keypoint_matching(outputs, image_sizes, threshold=<span class="hljs-number">0.2</span>)
<span class="hljs-keyword">for</span> i, output <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(outputs):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;For the image pair&quot;</span>, i)
    <span class="hljs-keyword">for</span> keypoint0, keypoint1, matching_score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
            output[<span class="hljs-string">&quot;keypoints0&quot;</span>], output[<span class="hljs-string">&quot;keypoints1&quot;</span>], output[<span class="hljs-string">&quot;matching_scores&quot;</span>]
    ):
        <span class="hljs-built_in">print</span>(
            <span class="hljs-string">f&quot;Keypoint at coordinate <span class="hljs-subst">{keypoint0.numpy()}</span> in the first image matches with keypoint at coordinate <span class="hljs-subst">{keypoint1.numpy()}</span> in the second image with a score of <span class="hljs-subst">{matching_score}</span>.&quot;</span>
        )
`,wrap:!1}}),q=new et({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># Create side by side image</span>
merged_image = np.zeros((<span class="hljs-built_in">max</span>(image1.height, image2.height), image1.width + image2.width, <span class="hljs-number">3</span>))
merged_image[: image1.height, : image1.width] = np.array(image1) / <span class="hljs-number">255.0</span>
merged_image[: image2.height, image1.width :] = np.array(image2) / <span class="hljs-number">255.0</span>
plt.imshow(merged_image)
plt.axis(<span class="hljs-string">&quot;off&quot;</span>)

<span class="hljs-comment"># Retrieve the keypoints and matches</span>
output = outputs[<span class="hljs-number">0</span>]
keypoints0 = output[<span class="hljs-string">&quot;keypoints0&quot;</span>]
keypoints1 = output[<span class="hljs-string">&quot;keypoints1&quot;</span>]
matching_scores = output[<span class="hljs-string">&quot;matching_scores&quot;</span>]
keypoints0_x, keypoints0_y = keypoints0[:, <span class="hljs-number">0</span>].numpy(), keypoints0[:, <span class="hljs-number">1</span>].numpy()
keypoints1_x, keypoints1_y = keypoints1[:, <span class="hljs-number">0</span>].numpy(), keypoints1[:, <span class="hljs-number">1</span>].numpy()

<span class="hljs-comment"># Plot the matches</span>
<span class="hljs-keyword">for</span> keypoint0_x, keypoint0_y, keypoint1_x, keypoint1_y, matching_score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(
        keypoints0_x, keypoints0_y, keypoints1_x, keypoints1_y, matching_scores
):
    plt.plot(
        [keypoint0_x, keypoint1_x + image1.width],
        [keypoint0_y, keypoint1_y],
        color=plt.get_cmap(<span class="hljs-string">&quot;RdYlGn&quot;</span>)(matching_score.item()),
        alpha=<span class="hljs-number">0.9</span>,
        linewidth=<span class="hljs-number">0.5</span>,
    )
    plt.scatter(keypoint0_x, keypoint0_y, c=<span class="hljs-string">&quot;black&quot;</span>, s=<span class="hljs-number">2</span>)
    plt.scatter(keypoint1_x + image1.width, keypoint1_y, c=<span class="hljs-string">&quot;black&quot;</span>, s=<span class="hljs-number">2</span>)

<span class="hljs-comment"># Save the plot</span>
plt.savefig(<span class="hljs-string">&quot;matched_image.png&quot;</span>, dpi=<span class="hljs-number">300</span>, bbox_inches=<span class="hljs-string">&#x27;tight&#x27;</span>)
plt.close()`,wrap:!1}}),Y=new Ge({props:{title:"SuperGlueConfig",local:"transformers.SuperGlueConfig",headingTag:"h2"}}),A=new ce({props:{name:"class transformers.SuperGlueConfig",anchor:"transformers.SuperGlueConfig",parameters:[{name:"keypoint_detector_config",val:": SuperPointConfig = None"},{name:"hidden_size",val:": int = 256"},{name:"keypoint_encoder_sizes",val:": typing.List[int] = None"},{name:"gnn_layers_types",val:": typing.List[str] = None"},{name:"num_attention_heads",val:": int = 4"},{name:"sinkhorn_iterations",val:": int = 100"},{name:"matching_threshold",val:": float = 0.0"},{name:"initializer_range",val:": float = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueConfig.keypoint_detector_config",description:`<strong>keypoint_detector_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SuperPointConfig</code>) &#x2014;
The config object or dictionary of the keypoint detector.`,name:"keypoint_detector_config"},{anchor:"transformers.SuperGlueConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The dimension of the descriptors.`,name:"hidden_size"},{anchor:"transformers.SuperGlueConfig.keypoint_encoder_sizes",description:`<strong>keypoint_encoder_sizes</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[32, 64, 128, 256]</code>) &#x2014;
The sizes of the keypoint encoder layers.`,name:"keypoint_encoder_sizes"},{anchor:"transformers.SuperGlueConfig.gnn_layers_types",description:`<strong>gnn_layers_types</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;, &apos;self&apos;, &apos;cross&apos;]</code>) &#x2014;
The types of the GNN layers. Must be either &#x2018;self&#x2019; or &#x2018;cross&#x2019;.`,name:"gnn_layers_types"},{anchor:"transformers.SuperGlueConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of heads in the GNN layers.`,name:"num_attention_heads"},{anchor:"transformers.SuperGlueConfig.sinkhorn_iterations",description:`<strong>sinkhorn_iterations</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of Sinkhorn iterations.`,name:"sinkhorn_iterations"},{anchor:"transformers.SuperGlueConfig.matching_threshold",description:`<strong>matching_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The matching threshold.`,name:"matching_threshold"},{anchor:"transformers.SuperGlueConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/configuration_superglue.py#L27"}}),k=new At({props:{anchor:"transformers.SuperGlueConfig.example",$$slots:{default:[Ot]},$$scope:{ctx:pe}}}),K=new Ge({props:{title:"SuperGlueImageProcessor",local:"transformers.SuperGlueImageProcessor",headingTag:"h2"}}),O=new ce({props:{name:"class transformers.SuperGlueImageProcessor",anchor:"transformers.SuperGlueImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_grayscale",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overriden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperGlueImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overriden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overriden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.SuperGlueImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overriden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperGlueImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overriden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.SuperGlueImageProcessor.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to grayscale. Can be overriden by <code>do_grayscale</code> in the <code>preprocess</code> method.`,name:"do_grayscale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L134"}}),ee=new ce({props:{name:"post_process_keypoint_matching",anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching",parameters:[{name:"outputs",val:": KeypointMatchingOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]]"},{name:"threshold",val:": float = 0.0"}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.outputs",description:`<strong>outputs</strong> (<code>KeypointMatchingOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[Tuple[int, int]]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2, 2)</code> or list of tuples of tuples (<code>Tuple[int, int]</code>) containing the
target size <code>(height, width)</code> of each image in the batch. This must be the original image size (before
any processing).`,name:"target_sizes"},{anchor:"transformers.SuperGlueImageProcessor.post_process_keypoint_matching.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Threshold to filter out the matches with low scores.`,name:"threshold"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L338",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints in the first and second image
of the pair, the matching scores and the matching indices.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),te=new ce({props:{name:"preprocess",anchor:"transformers.SuperGlueImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_grayscale",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image pairs to preprocess. Expects either a list of 2 images or a list of list of 2 images list with
pixel values ranging from 0 to 255. If passing in images with pixel values between 0 and 1, set
<code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of <code>PILImageResampling</code>, filters. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_grayscale</code>) &#x2014;
Whether to convert the image to grayscale.`,name:"do_grayscale"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperGlueImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L220"}}),oe=new ce({props:{name:"resize",anchor:"transformers.SuperGlueImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperGlueImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperGlueImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperGlueImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperGlueImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/image_processing_superglue.py#L181"}}),se=new Ge({props:{title:"SuperGlueForKeypointMatching",local:"transformers.SuperGlueForKeypointMatching",headingTag:"h2"}}),ae=new ce({props:{name:"class transformers.SuperGlueForKeypointMatching",anchor:"transformers.SuperGlueForKeypointMatching",parameters:[{name:"config",val:": SuperGlueConfig"}],parametersDescription:[{anchor:"transformers.SuperGlueForKeypointMatching.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueConfig">SuperGlueConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/modeling_superglue.py#L598"}}),re=new ce({props:{name:"forward",anchor:"transformers.SuperGlueForKeypointMatching.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SuperGlueForKeypointMatching.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/superglue#transformers.SuperGlueImageProcessor">SuperGlueImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/imagegpt#transformers.ImageGPTFeatureExtractor.__call__">SuperGlueImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors. See <code>attentions</code> under returned tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.Examples",description:"<strong>Examples</strong> &#x2014;",name:"Examples"},{anchor:"transformers.SuperGlueForKeypointMatching.forward.```python",description:`<strong>\`\`\`python</strong> &#x2014;</p>
<blockquote>
<blockquote>
<blockquote>
<p>from transformers import AutoImageProcessor, AutoModel
import torch
from PIL import Image
import requests</p>
</blockquote>
</blockquote>
</blockquote>`,name:"```python"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superglue/modeling_superglue.py#L779"}}),Z=new Yt({props:{$$slots:{default:[eo]},$$scope:{ctx:pe}}}),ie=new Kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superglue.md"}}),{c(){p=l("meta"),C=n(),w=l("p"),_=n(),d(G.$$.fragment),M=n(),d(I.$$.fragment),ve=n(),W=l("p"),W.innerHTML=Tt,Ce=n(),N=l("p"),N.innerHTML=bt,je=n(),R=l("p"),R.textContent=_t,Se=n(),X=l("p"),X.innerHTML=Jt,xe=n(),d(V.$$.fragment),ke=n(),H=l("p"),H.textContent=Ut,$e=n(),d(Q.$$.fragment),ze=n(),F=l("p"),F.innerHTML=Gt,Be=n(),d(P.$$.fragment),Ze=n(),E=l("p"),E.textContent=It,We=n(),d(q.$$.fragment),Ne=n(),L=l("p"),L.innerHTML=vt,Re=n(),D=l("p"),D.innerHTML=Ct,Xe=n(),d(Y.$$.fragment),Ve=n(),J=l("div"),d(A.$$.fragment),tt=n(),me=l("p"),me.innerHTML=jt,ot=n(),de=l("p"),de.innerHTML=St,nt=n(),d(k.$$.fragment),He=n(),d(K.$$.fragment),Qe=n(),b=l("div"),d(O.$$.fragment),st=n(),ue=l("p"),ue.textContent=xt,at=n(),$=l("div"),d(ee.$$.fragment),rt=n(),he=l("p"),he.innerHTML=kt,lt=n(),z=l("div"),d(te.$$.fragment),it=n(),ge=l("p"),ge.textContent=$t,ct=n(),B=l("div"),d(oe.$$.fragment),pt=n(),fe=l("p"),fe.textContent=zt,Fe=n(),ne=l("ul"),ne.innerHTML=Bt,Pe=n(),d(se.$$.fragment),Ee=n(),m=l("div"),d(ae.$$.fragment),mt=n(),ye=l("p"),ye.innerHTML=Zt,dt=n(),Me=l("p"),Me.textContent=Wt,ut=n(),we=l("p"),we.textContent=Nt,ht=n(),Te=l("ol"),Te.innerHTML=Rt,gt=n(),be=l("p"),be.textContent=Xt,ft=n(),_e=l("p"),_e.innerHTML=Vt,yt=n(),j=l("div"),d(re.$$.fragment),Mt=n(),Je=l("p"),Je.innerHTML=Ht,wt=n(),d(Z.$$.fragment),qe=n(),le=l("ul"),le.innerHTML=Qt,Le=n(),d(ie.$$.fragment),De=n(),Ie=l("p"),this.h()},l(e){const t=Dt("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(o),C=s(e),w=i(e,"P",{}),S(w).forEach(o),_=s(e),u(G.$$.fragment,e),M=s(e),u(I.$$.fragment,e),ve=s(e),W=i(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-jnhrty"&&(W.innerHTML=Tt),Ce=s(e),N=i(e,"P",{"data-svelte-h":!0}),c(N)!=="svelte-11zlwci"&&(N.innerHTML=bt),je=s(e),R=i(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-vfdo9a"&&(R.textContent=_t),Se=s(e),X=i(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-1hznpl7"&&(X.innerHTML=Jt),xe=s(e),u(V.$$.fragment,e),ke=s(e),H=i(e,"P",{"data-svelte-h":!0}),c(H)!=="svelte-88y6pj"&&(H.textContent=Ut),$e=s(e),u(Q.$$.fragment,e),ze=s(e),F=i(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-o9bw9u"&&(F.innerHTML=Gt),Be=s(e),u(P.$$.fragment,e),Ze=s(e),E=i(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-v9owge"&&(E.textContent=It),We=s(e),u(q.$$.fragment,e),Ne=s(e),L=i(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-1pvnv97"&&(L.innerHTML=vt),Re=s(e),D=i(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1plbgli"&&(D.innerHTML=Ct),Xe=s(e),u(Y.$$.fragment,e),Ve=s(e),J=i(e,"DIV",{class:!0});var v=S(J);u(A.$$.fragment,v),tt=s(v),me=i(v,"P",{"data-svelte-h":!0}),c(me)!=="svelte-mrmg6g"&&(me.innerHTML=jt),ot=s(v),de=i(v,"P",{"data-svelte-h":!0}),c(de)!=="svelte-o55m63"&&(de.innerHTML=St),nt=s(v),u(k.$$.fragment,v),v.forEach(o),He=s(e),u(K.$$.fragment,e),Qe=s(e),b=i(e,"DIV",{class:!0});var U=S(b);u(O.$$.fragment,U),st=s(U),ue=i(U,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-2i9uog"&&(ue.textContent=xt),at=s(U),$=i(U,"DIV",{class:!0});var Ae=S($);u(ee.$$.fragment,Ae),rt=s(Ae),he=i(Ae,"P",{"data-svelte-h":!0}),c(he)!=="svelte-y19agd"&&(he.innerHTML=kt),Ae.forEach(o),lt=s(U),z=i(U,"DIV",{class:!0});var Ke=S(z);u(te.$$.fragment,Ke),it=s(Ke),ge=i(Ke,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1x3yxsa"&&(ge.textContent=$t),Ke.forEach(o),ct=s(U),B=i(U,"DIV",{class:!0});var Oe=S(B);u(oe.$$.fragment,Oe),pt=s(Oe),fe=i(Oe,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1eb2h1k"&&(fe.textContent=zt),Oe.forEach(o),U.forEach(o),Fe=s(e),ne=i(e,"UL",{"data-svelte-h":!0}),c(ne)!=="svelte-j0c82d"&&(ne.innerHTML=Bt),Pe=s(e),u(se.$$.fragment,e),Ee=s(e),m=i(e,"DIV",{class:!0});var T=S(m);u(ae.$$.fragment,T),mt=s(T),ye=i(T,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1aw6tuh"&&(ye.innerHTML=Zt),dt=s(T),Me=i(T,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1dk3ngg"&&(Me.textContent=Wt),ut=s(T),we=i(T,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1brn206"&&(we.textContent=Nt),ht=s(T),Te=i(T,"OL",{"data-svelte-h":!0}),c(Te)!=="svelte-1pikpqu"&&(Te.innerHTML=Rt),gt=s(T),be=i(T,"P",{"data-svelte-h":!0}),c(be)!=="svelte-z466vq"&&(be.textContent=Xt),ft=s(T),_e=i(T,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-1wx5o62"&&(_e.innerHTML=Vt),yt=s(T),j=i(T,"DIV",{class:!0});var Ue=S(j);u(re.$$.fragment,Ue),Mt=s(Ue),Je=i(Ue,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-18va01n"&&(Je.innerHTML=Ht),wt=s(Ue),u(Z.$$.fragment,Ue),Ue.forEach(o),T.forEach(o),qe=s(e),le=i(e,"UL",{"data-svelte-h":!0}),c(le)!=="svelte-mdsibh"&&(le.innerHTML=Qt),Le=s(e),u(ie.$$.fragment,e),De=s(e),Ie=i(e,"P",{}),S(Ie).forEach(o),this.h()},h(){x(p,"name","hf:doc:metadata"),x(p,"content",oo),x(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(b,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,p),a(e,C,t),a(e,w,t),a(e,_,t),h(G,e,t),a(e,M,t),h(I,e,t),a(e,ve,t),a(e,W,t),a(e,Ce,t),a(e,N,t),a(e,je,t),a(e,R,t),a(e,Se,t),a(e,X,t),a(e,xe,t),h(V,e,t),a(e,ke,t),a(e,H,t),a(e,$e,t),h(Q,e,t),a(e,ze,t),a(e,F,t),a(e,Be,t),h(P,e,t),a(e,Ze,t),a(e,E,t),a(e,We,t),h(q,e,t),a(e,Ne,t),a(e,L,t),a(e,Re,t),a(e,D,t),a(e,Xe,t),h(Y,e,t),a(e,Ve,t),a(e,J,t),h(A,J,null),r(J,tt),r(J,me),r(J,ot),r(J,de),r(J,nt),h(k,J,null),a(e,He,t),h(K,e,t),a(e,Qe,t),a(e,b,t),h(O,b,null),r(b,st),r(b,ue),r(b,at),r(b,$),h(ee,$,null),r($,rt),r($,he),r(b,lt),r(b,z),h(te,z,null),r(z,it),r(z,ge),r(b,ct),r(b,B),h(oe,B,null),r(B,pt),r(B,fe),a(e,Fe,t),a(e,ne,t),a(e,Pe,t),h(se,e,t),a(e,Ee,t),a(e,m,t),h(ae,m,null),r(m,mt),r(m,ye),r(m,dt),r(m,Me),r(m,ut),r(m,we),r(m,ht),r(m,Te),r(m,gt),r(m,be),r(m,ft),r(m,_e),r(m,yt),r(m,j),h(re,j,null),r(j,Mt),r(j,Je),r(j,wt),h(Z,j,null),a(e,qe,t),a(e,le,t),a(e,Le,t),h(ie,e,t),a(e,De,t),a(e,Ie,t),Ye=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),k.$set(v);const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),Z.$set(U)},i(e){Ye||(g(G.$$.fragment,e),g(I.$$.fragment,e),g(V.$$.fragment,e),g(Q.$$.fragment,e),g(P.$$.fragment,e),g(q.$$.fragment,e),g(Y.$$.fragment,e),g(A.$$.fragment,e),g(k.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(ee.$$.fragment,e),g(te.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(ae.$$.fragment,e),g(re.$$.fragment,e),g(Z.$$.fragment,e),g(ie.$$.fragment,e),Ye=!0)},o(e){f(G.$$.fragment,e),f(I.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(P.$$.fragment,e),f(q.$$.fragment,e),f(Y.$$.fragment,e),f(A.$$.fragment,e),f(k.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),f(te.$$.fragment,e),f(oe.$$.fragment,e),f(se.$$.fragment,e),f(ae.$$.fragment,e),f(re.$$.fragment,e),f(Z.$$.fragment,e),f(ie.$$.fragment,e),Ye=!1},d(e){e&&(o(C),o(w),o(_),o(M),o(ve),o(W),o(Ce),o(N),o(je),o(R),o(Se),o(X),o(xe),o(ke),o(H),o($e),o(ze),o(F),o(Be),o(Ze),o(E),o(We),o(Ne),o(L),o(Re),o(D),o(Xe),o(Ve),o(J),o(He),o(Qe),o(b),o(Fe),o(ne),o(Pe),o(Ee),o(m),o(qe),o(le),o(Le),o(De),o(Ie)),o(p),y(G,e),y(I,e),y(V,e),y(Q,e),y(P,e),y(q,e),y(Y,e),y(A),y(k),y(K,e),y(O),y(ee),y(te),y(oe),y(se,e),y(ae),y(re),y(Z),y(ie,e)}}}const oo='{"title":"SuperGlue","local":"superglue","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"How to use","local":"how-to-use","sections":[],"depth":2},{"title":"SuperGlueConfig","local":"transformers.SuperGlueConfig","sections":[],"depth":2},{"title":"SuperGlueImageProcessor","local":"transformers.SuperGlueImageProcessor","sections":[],"depth":2},{"title":"SuperGlueForKeypointMatching","local":"transformers.SuperGlueForKeypointMatching","sections":[],"depth":2}],"depth":1}';function no(pe){return Et(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mo extends qt{constructor(p){super(),Lt(this,p,no,to,Pt,{})}}export{mo as component};
